C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=SMDIRS,SSI=0
C
                     SUBROUTINE SMDIRS
C                    *****************
C
C      ---------------------------------------------------
     *( NDIRS,VDIRS,B,DMAT,XMAT,NODES,
     *  TRAV,DIRIND,DIRVAL,
     *  NPOINS,NELEMS,NDMATS,NBDIRS,NCOEMA,
     *  NDIELE,NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR,
     *  WCT )  
C     ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DU SECOND MEMBRE                           *
C                    PRISE EN COMPTE DES CONDITIONS DE DIRICHLET       *
C                                                                      *
C      On utilise la procedure suivante:                               *
C                                                                      *
C      On veut resoudre  M X = B                                       *
C      On initialise un vecteur DIRVAL de longueur NPOINS              *
C      On stocke la valeur impose de dirichlet dans DIRVAL             *
C      On effectue M . DIRVAL (contribution des noeuds dirichlet)      *
C      On met a jour le second membre B - M . DIRVAL                   *
C      On modifie le second membre pour mettre la valeur Dirichlet     *
C      On modifie la matrice M pour chaque noeud de dirichlet:         *
C                on met les coefficients de ligne et colonne a 0       *
C                on met 1 sur la diagonale                             *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NDIRS   !  TR  ! D  ! NUMERO DES POINTS DE DIRICHLET           !
C   !   VDIRS   !  TR  ! D  ! VALEUR DE DIRICHLET                      !
C   !   B       !  TR  ! R  ! SECOND MEMBRE  (Partie explicite         !
C   !   DMAT    !  TR  ! R  ! DIAGONALE DE LA MATRICE M                !
C   !   XMAT    !  TR  ! R  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   NODES   !  TE  ! D  ! NUMERO DES NOEUDS ( LOCALE --> GLOBALE ) !
C   !   DIRIND  !  TR  ! M  ! INDICATEUR DE DIRICHLET (Tab Travail )   !
C   !   DIRVAL  !  TR  ! M  ! VALEUR DE DIRICHLET (Tab travail)        !
C   !   WCT     !  TR  ! M  ! TABLEAUX DE TRAVAIL (NELEMS*NDMATS)    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDMATS,NBDIRS,NCOEMA,NDIELE
      INTEGER NBPRIO,NBCOPR,NELEPR
      INTEGER NODEPR(NELEPR,NDMATS+1),NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NODES(NELEMS,NDMATS)    
      INTEGER NDIRS(NBDIRS)
C
      DOUBLE PRECISION B(NPOINS),DMAT(NPOINS),XMAT(NELEMS,NCOEMA)
      DOUBLE PRECISION VDIRS(NBDIRS)
      DOUBLE PRECISION DIRVAL(NPOINS),DIRIND(NPOINS),TRAV(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
C
      DOUBLE PRECISION VIND1,VIND2,VIND3,VIND4,VIND5
      DOUBLE PRECISION VIND6,VIND7,VIND8,VIND9,VIND10  
C
C..Variables locales
      DOUBLE PRECISION C,ZERO,ZUN
      INTEGER I,INODE
      LOGICAL LVERIF
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .TRUE.
      ZERO   = 0.D0
      ZUN    = 1.D0
C
      CALL OV ( 'X=C     ',DIRIND,DIRIND,DIRIND,ZUN,NPOINS )
      CALL OV ( 'X=C     ',DIRVAL,DIRVAL,DIRVAL,ZERO,NPOINS )
      CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,ZERO,NPOINS )
C
C     2- MODIFICATION DU SECOND MEMBRE 
C     ====================================
C         2.1- Changement des vecteurs DIRIND et DIRVAL
C         ---------------------------------------------
C
          DO 200 I=1,NBDIRS
              INODE = NDIRS(I)
              DIRIND(INODE) = 0.D0
              DIRVAL(INODE) = VDIRS(I)
  200     CONTINUE  
C
C         2.2- Modification du second membre pour noeud autre que
C         dirichlet
C         ----------------------------------
          CALL OMV ( 'X=MY    ',TRAV,DMAT,XMAT,DIRVAL,C,NODES,WCT,
     &               NPOINS,NDMATS,NCOEMA,NDIELE,NELEMS,
     &               NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR) 
          CALL OV ( 'X=Y-Z   ',B,B,TRAV,ZERO,NPOINS )
C
C         2.3- Modification du second membre pour les noeuds dirichlets
C         -------------------------------------------------------------
C         On fait B = valeur au noeud (ici DIRVAL ou VDIRS)
          DO 230 I=1,NBDIRS
              B(NDIRS(I)) = VDIRS(I)
  230     CONTINUE
C
C     3- MODIFICATION DE LA MATRICE 
C     =============================
C         3.1- Modification de la diagonale 
C         -------------------------------------
C         
          DO 310 I=1,NBDIRS
              DMAT(NDIRS(I)) = 1.D0
  310     CONTINUE
C 
C         3.2- Modification des termes extras diagonaux
C         -------------------------------------
C         
C         3.2.1- CAS des triangles
C         ------------------------
          IF ( NDIELE .EQ. 2) THEN
C 
              DO 321 I=1,NELEMS
C
                  VIND1 = DIRIND(NODES(I,1))
                  VIND2 = DIRIND(NODES(I,2))
                  VIND3 = DIRIND(NODES(I,3))
                  VIND4 = DIRIND(NODES(I,4))
                  VIND5 = DIRIND(NODES(I,5))
                  VIND6 = DIRIND(NODES(I,6))
C
                  XMAT(I,1) = XMAT(I,1) * VIND1 * VIND4
                  XMAT(I,2) = XMAT(I,2) * VIND1 * VIND6
                  XMAT(I,3) = XMAT(I,3) * VIND2 * VIND4
                  XMAT(I,4) = XMAT(I,4) * VIND2 * VIND5
                  XMAT(I,5) = XMAT(I,5) * VIND3 * VIND5
                  XMAT(I,6) = XMAT(I,6) * VIND3 * VIND6
                  XMAT(I,7) = XMAT(I,7) * VIND4 * VIND5
                  XMAT(I,8) = XMAT(I,8) * VIND4 * VIND6
                  XMAT(I,9) = XMAT(I,9) * VIND5 * VIND6
C
  321         CONTINUE
C 
C         3.2.2- CAS des tetraedre (ndiele=3)
C         -----------------------------------
          ELSE
C 
              DO 322 I=1,NELEMS
C
                  VIND1 = DIRIND(NODES(I,1))
                  VIND2 = DIRIND(NODES(I,2))
                  VIND3 = DIRIND(NODES(I,3))
                  VIND4 = DIRIND(NODES(I,4))
                  VIND5 = DIRIND(NODES(I,5))
                  VIND6 = DIRIND(NODES(I,6))
                  VIND7 = DIRIND(NODES(I,7))
                  VIND8 = DIRIND(NODES(I,8))
                  VIND9 = DIRIND(NODES(I,9))
                  VIND10 = DIRIND(NODES(I,10))
C
                  XMAT(I,1) = XMAT(I,1) * VIND1 * VIND5
                  XMAT(I,2) = XMAT(I,2) * VIND1 * VIND7
                  XMAT(I,3) = XMAT(I,3) * VIND1 * VIND8
                  XMAT(I,4) = XMAT(I,4) * VIND2 * VIND5
                  XMAT(I,5) = XMAT(I,5) * VIND2 * VIND6
                  XMAT(I,6) = XMAT(I,6) * VIND2 * VIND9
                  XMAT(I,7) = XMAT(I,7) * VIND3 * VIND6
                  XMAT(I,8) = XMAT(I,8) * VIND3 * VIND7
                  XMAT(I,9) = XMAT(I,9) * VIND3 * VIND10
                  XMAT(I,10) = XMAT(I,10) * VIND4 * VIND8
                  XMAT(I,11) = XMAT(I,11) * VIND4 * VIND9
                  XMAT(I,12) = XMAT(I,12) * VIND4 * VIND10
                  XMAT(I,13) = XMAT(I,13) * VIND5 * VIND6
                  XMAT(I,14) = XMAT(I,14) * VIND5 * VIND7
                  XMAT(I,15) = XMAT(I,15) * VIND5 * VIND8
                  XMAT(I,16) = XMAT(I,16) * VIND5 * VIND9
                  XMAT(I,17) = XMAT(I,17) * VIND6 * VIND7
                  XMAT(I,18) = XMAT(I,18) * VIND6 * VIND8
                  XMAT(I,19) = XMAT(I,19) * VIND6 * VIND9
                  XMAT(I,20) = XMAT(I,20) * VIND6 * VIND10
                  XMAT(I,21) = XMAT(I,21) * VIND7 * VIND8
                  XMAT(I,22) = XMAT(I,22) * VIND7 * VIND10
                  XMAT(I,23) = XMAT(I,23) * VIND8 * VIND9
                  XMAT(I,24) = XMAT(I,24) * VIND8 * VIND10
                  XMAT(I,25) = XMAT(I,25) * VIND9 * VIND10
C
  322         CONTINUE
C
C         Fin du cas 3D
          ENDIF                   
C                               
      RETURN
      END
