C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE GAUSEI
C                       *****************
C
C     ----------------------------------------------------------------
     * (NELRAY,NUMBS,FDFRAY,SUFRAY,EMISSI,EPROPR,NFFIRA,NGFFIR,RADIOS,
     *  TABRAY)
C     ----------------------------------------------------------------
C
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C        Resolution du systeme de rayonnement pour la bande numbs
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NUMBS    !  E ! D  ! NUMERO DE LA BANDE SPECTRALE                 !
C !  NELRAY   !  E ! D  ! NOMBRE D'ELEMENTS (maillage rayt)            !
C !  FDFRAY   ! TR ! R  ! FACTEURS DE FORME RAYONNEMENT                !
C !  SUFRAY   ! TR ! D  ! SURFACE DES ELEMENTS (maillage rayt)         !
C !  EMISSI   ! TR ! D  ! EMISSIVITE (maillage rayt)                   !
C !  EPROPR   ! TR ! D  ! EMISSION PROPRE (maillage rayt)              !
C !  RADIOS   ! TR ! R  ! RADIOSITE (maillage rayt)                    !
C !  NFFIRA   !  E ! D  ! Nombre de facette de type flux impose        !
C !  NGFFIR   ! TE ! D  ! Numerotation globale des faces a flux impose !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) :
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON 
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NELRAY,NUMBS,NFFIRA
      INTEGER NGFFIR(NFFIRA)
      DOUBLE PRECISION FDFRAY(NELRAY*(NELRAY+1)/2)
      DOUBLE PRECISION SUFRAY(NELRAY),EPROPR(NELRAY,NBANDE)
      DOUBLE PRECISION RADIOS(NELRAY,NBANDE),EMISSI(NELRAY,2,NBANDE)
      DOUBLE PRECISION TABRAY(NELRAY,9)
C
C.. Variables internes
      INTEGER N,NGFAC
C
C***********************************************************************
C
      IF (NBLBLR.GT.1) WRITE(NFECRA,1000) NUMBS
C
C     1- TRANSFORMATION DE epsilon en 1-epsilon pour la bande numbs
C     ===========================================================
C
      DO 11 N=1,NFFIRA
         NGFAC = NGFFIR(N)
         EMISSI(NGFAC,2,NUMBS) = 1.
   11 CONTINUE
C
      CALL RRAYRC(FDFRAY,SUFRAY,NELRAY,EMISSI,RADIOS,EPROPR,NUMBS,
     *            TABRAY(1,1),TABRAY(1,2),TABRAY(1,3),TABRAY(1,4),
     *            TABRAY(1,5),TABRAY(1,6),TABRAY(1,7),TABRAY(1,8))
C     
C--------
C FORMATS
C--------
C
 1000 FORMAT(/' *** GAUSEI :  Traitement de la bande spectrale : ',I2)
 1001 FORMAT(' *** GAUSEI :   Iteration      Erreur relative   ',
     &              '      Erreur absolue')
 1100 FORMAT(18X,I4,9X,E12.7,11X,E12.7)
 3020 FORMAT(I4,3X,I4,3X,E15.7,E15.7)
C----
C FIN
C----
C
      END
