C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=DPTSEG,SSI=0
                        SUBROUTINE DPTSEG
C                       *****************
C
C      ------------------------------------------
     * (XP1,YP1,XA,YA,XB,YB,DIST,XMIN,YMIN,ICODE)
C      ------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            RECHERCHE DU POINT D'UN SEGMENT QUI REALISE LA DISTANCE   *
C            MINIMALE ENTRE UN POINT DONNE ET LE SEGMENT               *
C            (DIMENSION 2)                                             *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  XP1,YP1  !  R ! D  ! COORDONNEES DU POINT CONSIDERE               !
C !  XA,YA    !  R ! D  ! COORDONNEES DU 1ER SOMMET DU SEGMENT         !
C !  XB,YB    !  R ! D  ! COORDONNEES DU 2EME SOMMET DU SEGMENT        !
C !  DIST     !  R ! R  ! DISTANCE DE P1 AU SEGMENT                    !
C ! XMIN,YMIN !  R ! R  ! POINT DU SEGMENT QUI REALISE CETTE DIST MIN  !
C !  ICODE    !  E ! R  ! CODE D'ERREUR EN CAS D'ECHEC DE LA RECHERCHE !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : CORFS2
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
C
C***********************************************************************
C
      INTEGER ICODE
C
      DOUBLE PRECISION XA,YA,XB,YB,XAB,YAB
      DOUBLE PRECISION ABN,XE1,YE1,XE2,YE2
      DOUBLE PRECISION XP1,YP1,XH,XANEW,YANEW,XBNEW,YBNEW,XP
      DOUBLE PRECISION XX,DIST,XMIN,YMIN
C
C
C***********************************************************************
C
      XAB = XB - XA
      YAB = YB - YA
C
      ABN = SQRT ( XAB*XAB + YAB*YAB )
C
      XE1 = XAB / ABN
      YE1 = YAB / ABN
C
      XE2 = -YE1
      YE2 =  XE1
C
      XP = (XP1-XA)*XE1 + (YP1-YA)*YE1
C
      XH = (XP1-XA)*XE2 + (YP1-YA)*YE2
C
      XANEW = 0.D0
      YANEW = 0.D0
      XBNEW = ABN
      YBNEW = 0.D0
C
      IF (XP.GE.XANEW .AND. XP.LE.XBNEW) THEN
         XX = XP
         DIST = ABS (XH)
C
      ELSEIF (XP.GT.XBNEW) THEN
         XX = XBNEW
         DIST = SQRT ( XH*XH + (XP-XBNEW)*(XP-XBNEW) ) 
C
      ELSEIF (XP.LT.XANEW) THEN        
         XX = XANEW
         DIST = SQRT ( XH*XH + (XP-XANEW)*(XP-XANEW) ) 
C
      ELSE
         ICODE = 1
         RETURN
      ENDIF
C
      XMIN = XA + XX*XE1 
      YMIN = YA + XX*YE1 
C
C
C----
C FIN
C----
      END
