/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>
# include "f2c_syrthes.h"
# include "tree.h"
# include "abs.h"
# include "interfaces.h"

#define  nquartier 72
int tabint[nquartier];

const double Pi=3.141592653589793;

int ss_sega[2][2] = { {0,2},
	             {2,1} };
int nsp,ordrei,ordrej;
double taille_boite,taille_seg;
double wi[24],xli[24],wj[24],xlj[24];


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | cfdf2d                                                               |
  |         Gestion du calcul des facteurs de forme en axisymetrique     |
  |======================================================================| */

proc(void cfdf2a,void CFDF2A) 
             (int *ndim,int *nelray,int *npoinr,int *nodray,
              double *cooray,double *sufray,double *fdf,
              int *nplasy,double *plasym,
	      int *iaxi,int *ndecoup_max,
	      int *nrfray,double *pvinter,int *numgu, int*ngumax, int *nblblr)

{
    int i,n2;
    int faces_cachees ;
    int *nod2,nel2,npoin2;
    double *coo2,*xnf2,xmult;
    double *cooa1,*xnfa1;
    int iaxir;
    int *grconv, *grconv2;
    int imult;

    dimension_2d(*ndim,*nelray,*npoinr,nodray,cooray,
		 &taille_boite,&taille_seg);

    imult = 0;
    xmult = 1.;
    if(taille_seg < 0.01 || taille_seg > 10)
      {
        imult = 1;
	if (taille_seg < 0.01) xmult = 0.1/taille_seg;
	if (taille_seg > 10  ) xmult =   1/taille_seg;
        if(*nblblr >= 10) printf("Facteur multiplicatif interne xmult= %f \n",xmult);
	for (i=0;i< *npoinr* *ndim ;i++) *(cooray+i) *=  xmult ;
        taille_boite *= xmult;
        taille_seg   *= xmult;
        for(i=0;i<3**ngumax;i++) *(pvinter+i)*=xmult;
	for(i=0;i<*nplasy;i++) plasym[i*4+2]*=xmult;
      }



    grconv = (int *)malloc( *nelray * sizeof(int) );
    if (grconv==NULL) 
      {printf(" ERREUR cfdf2a : probleme d'allocation memoire\n");
       exit(0);}
    orie2d(nodray,*nelray,*npoinr,nrfray,cooray,pvinter,*numgu,*ndim,*nblblr,
	   grconv);
     
    gauss();


    surface_anneau (*iaxi,*nelray,*npoinr,nodray,cooray,sufray);

    if  (*nplasy == 0) nsp=1; else nsp=2; 

    cooa1=(double*)malloc( *npoinr * 2 * sizeof(double));
    if (cooa1==NULL) 
      {printf(" ERREUR cfdf2a : probleme d'allocation memoire\n");
       exit(0);}
    alter_axi1(*iaxi,*npoinr,cooray,cooa1);

    xnfa1=(double*)malloc(*nelray * 2 * sizeof(double));
    if (xnfa1==NULL) 
      {printf(" ERREUR cfdf2a : probleme d'allocation memoire\n");
       exit(0);}
    cnor_2d(*ndim,*nelray,*npoinr,nodray,cooa1,xnfa1);

    if (*nplasy != 0) 
      {
	n2=1;
	if (*nplasy==1){n2=2;}
	else if (*nplasy==2){n2=4;}
        /* n2=(int)(pow(2,*nplasy)+0.1); */
	nod2=(int*)malloc(n2 * *nelray * 2 * sizeof(int));
	coo2=(double*)malloc(n2 * *npoinr * 2 * sizeof(double));
	xnf2=(double*)malloc(n2 * *nelray * 2 * sizeof(double));
	grconv2=(int*)malloc(n2 * *nelray * sizeof(int));
	if (n2==0 || nod2==NULL || coo2==NULL || xnf2==NULL || grconv2==NULL ) 
	  {printf(" ERREUR cfdf2a : probleme d'allocation memoire\n");
	   exit(0);}
        dupliq2d_sym(*nplasy,plasym,
		     *npoinr,*nelray,nodray,cooa1,xnfa1,
		     &nel2,&npoin2,nod2,coo2,xnf2,grconv,grconv2);    
        
      }



    if (*nplasy == 0) 
      {
	faces_cachees=1;iaxir=2;
	if (faces_cachees)
	  facforme_2a_fc(*ndim,*npoinr,*nelray,*nelray,nodray,cooa1,xnfa1,fdf,sufray,
			 iaxir,*nplasy,*ndecoup_max,grconv,*nblblr);
	else
	  facforme_2a_vis(*ndim,*npoinr,*nelray,*nelray,nodray,cooa1,xnfa1,fdf,sufray,
			  iaxir,*nplasy,*ndecoup_max,grconv,*nblblr);
      }
    else
      {
	/* ca parait douteux : je prefere commenter pour l'instant 21/01/97 cp 
	facecache_2a(*ndim,npoin2,nel2,*nelray,nod2,cooa1,xnfa1,&faces_cachees,
		     *nplasy,*nblblr) ;*/
	faces_cachees=1;iaxir=2;
	if (faces_cachees)
	  facforme_2a_fc(*ndim,npoin2,nel2,*nelray,nod2,coo2,xnf2,fdf,sufray,
			 iaxir,*nplasy,*ndecoup_max,grconv2,*nblblr);
	else
	  facforme_2a_vis(*ndim,npoin2,nel2,*nelray,nod2,coo2,xnf2,fdf,sufray,
			  iaxir,*nplasy,*ndecoup_max,grconv2,*nblblr);

      }    
    
    free(grconv);
    if (*nplasy != 0) {free(coo2); free(nod2); free(xnf2);free(grconv2); }

    free(cooa1); free(xnfa1);


    if(imult)
      {
	for (i=0;i< *npoinr* *ndim ;i++) *(cooray+i) /=  xmult ;
        xmult *= xmult;
	for (i=0;i< *nelray ;i++) *(sufray+i) /=  xmult;
	for (i=0 ; i<*nelray*(*nelray+1)/2 ; i++ ) *(fdf+i) /=  xmult;
      }
    
}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | facforme_2a_vis                                                      |
  |           calcul des facteurs de forme en axisymetrique              |
  |           pas de faces cachees                                       |
  |======================================================================| */

void facforme_2a_vis(int ndim, int npoin,int nel2,int nel,
                     int *nod,double *coord,double *xnf,double *fdf,double *sufray,
                     int iaxi,int nplasy,int ndecoup_max,int *grconv,int nblblr)
{
    int i,j,k,npoin2,ns,ideb,n;
    int noeud[6];
    int nbfcoplanaire;
    double xi[4],yi[4],fforme,l1,l2,d,x1m,y1m,x2m,y2m;
    double xn1,yn1;
    double titi1, titi2;
    int ncomplique;
    int idec,jdec;
    double xi_ini[4],yi_ini[4];
    double dist12,dist03;
    double total_fac,pourcent,pourcent_ecrit;
    int ndecmax;


    /* Initialisations 
       --------------- */
    npoin2 = npoin*2;
    nbfcoplanaire = 0 ;
    ncomplique = 0;

    ndecmax = (int)(pow(2,ndecoup_max) +0.1);

    for (i=0 ; i<nel*(nel+1)/2 ; i++ ) *(fdf+i) = 0.; 

	    
    titi1 =0;
    titi2 =0;
    ideb = -nel;
    total_fac=nsp*nel;
    pourcent_ecrit=0.2;

    for (ns=0 ; ns < nsp ; ns++ ) 
      {
	ideb += nel;

	for (i=0 ; i<nel ; i++ )  	
	  {
            pourcent=(ns+1)*i/total_fac;
            if (pourcent>pourcent_ecrit)
	      {
		printf("              %5.2f %% du calcul effectue\n",pourcent_ecrit*100);
		pourcent_ecrit += 0.2;
	      }
	    xn1 = xnf[i];
	    yn1 = xnf[i+ nel2];
	    noeud[0] = nod[i];
	    noeud[1] = nod[i+ nel2];

	    for  (j=ideb+i ; j<ideb+nel ; j++ )  
	      {
		fforme = coplanaire_2a(iaxi,xn1,yn1,xnf[j],xnf[j+nel2]);
		if (fforme>-0.1)
		  {
		    nbfcoplanaire += 1;
		  }
		if (fforme<-1.)  
		  {
		    noeud[2] = nod[j];
		    noeud[3] = nod[j+ nel2];
		    
		    for (k=0;k<4;k++)
		      { 
			xi_ini[k] = coord[noeud[k]-1];
			yi_ini[k] = coord[noeud[k]-1+ npoin];
		      }
		    
		    fforme=0.;
		    for (idec=0;idec<ndecmax;idec++)
		      {
			for(jdec=0;jdec<ndecmax;jdec++)
			  {
			    xi[0] = xi_ini[0]+(xi_ini[1]-xi_ini[0])/ndecmax*idec;
			    xi[1] = xi_ini[0]+(xi_ini[1]-xi_ini[0])/ndecmax*(idec+1);
			    yi[0] = yi_ini[0]+(yi_ini[1]-yi_ini[0])/ndecmax*idec;
			    yi[1] = yi_ini[0]+(yi_ini[1]-yi_ini[0])/ndecmax*(idec+1);
			    
			    xi[2] = xi_ini[2]+(xi_ini[3]-xi_ini[2])/ndecmax*jdec;
			    xi[3] = xi_ini[2]+(xi_ini[3]-xi_ini[2])/ndecmax*(jdec+1);
			    yi[2] = yi_ini[2]+(yi_ini[3]-yi_ini[2])/ndecmax*jdec;
			    yi[3] = yi_ini[2]+(yi_ini[3]-yi_ini[2])/ndecmax*(jdec+1);
			    
			    if (i==j)
			      {
				l1=sqrt((xi[0]-xi[1])*(xi[0]-xi[1])+(yi[0]-yi[1])*(yi[0]-yi[1]));
				if (iaxi==1)
				  d=0.5*(yi[0]+yi[1]);
				else
				  d=0.5*(xi[0]+xi[1]);
				if (l1/d<0.3) 
				  {ordrei=3; ordrej=4;}
				else
				  {ordrei=10;ordrej=12;}
			      }
			    else
			      {
				x1m=0.5*(xi[0]+xi[1]);y1m=0.5*(yi[0]+yi[1]);
				x2m=0.5*(xi[2]+xi[3]);y2m=0.5*(yi[2]+yi[3]);
				d=sqrt((x2m-x1m)*(x2m-x1m)+(y2m-y1m)*(y2m-y1m));
				l1=sqrt((xi[0]-xi[1])*(xi[0]-xi[1])+(yi[0]-yi[1])*(yi[0]-yi[1]));
				l2=sqrt((xi[2]-xi[3])*(xi[2]-xi[3])+(yi[2]-yi[3])*(yi[2]-yi[3]));
				if (l1/d<0.3) ordrei=3; else ordrei=10;
				if (l2/d<0.3) ordrej=3; else ordrej=10;	
				
				dist12=(xi[2]-xi[1])*(xi[2]-xi[1])+(yi[2]-yi[1])*(yi[2]-yi[1]) ;
				dist03=(xi[3]-xi[0])*(xi[3]-xi[0])+(yi[3]-yi[0])*(yi[3]-yi[0]) ;
				if (dist12 < 1e-10 || dist03 < 1e-10 )  { ordrei = 24 ; ordrej = 24;} 
			      }
			    
			    
			    gauss();
			    
			    for (n=0;n<nquartier;n++) tabint[n]=1;
			    
			    axi_integ_vis(yi,xi,&fforme);
			    
			    if(fforme < 0.) 
			      {
				if (nblblr >= 11)
				  printf(" fforme negatif ns%d i %d j %d  fdf= %f\n",ns,i+1,j+1,1e6*fforme);
			      }
			    else
			      fdf[i*nel-(i+1)*i/2+j%nel] += fforme; 
			    /* printf(" facteur de forme i+1 j+1 %d %d %f \n",i+1,j+1,fforme*1e6); */
			  }
		      }
		    
		    
		  }
		
	      }
	    
	  }
	
      }
    
  }


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | facforme_2a_vis                                                      |
  |           calcul des facteurs de forme en axisymetrique              |
  |           faces cachees                                              |
  |======================================================================| */

void facforme_2a_fc(int ndim, int npoin,int nel2,int nel,
                     int *nod,double *coord,double *xnf,double *fdf,double *sufray,
                     int iaxi,int nplasy,int ndecoup_max,int *grconv,int nblblr )
{
    int i,j,k,npoin2,ns,ideb,n,icode;
    int noeud[6],idec,jdec;
    int nbfcoplanaire;
    double xi[4],yi[4],fforme;
    double xn1,yn1;
    double l1,l2,d,x1m,y1m,x2m,y2m;
    double titi1, titi2;
    double total_fac,pourcent,pourcent_ecrit;
    double xi_ini[4],yi_ini[4];
    double dist12,dist03;
    int ndecmax;

    int iaxir ;

    npoin2 = npoin*2;
    nbfcoplanaire = 0 ;
    
    ndecmax = (int)(pow(2,ndecoup_max) +0.1);

    for (i=0 ; i<nel*(nel+1)/2 ; i++ ) *(fdf+i) = 0.; 

	    
    titi1 =0;
    titi2 =0;
    ideb = -nel;
    total_fac=nsp*nel;
    pourcent_ecrit=0.1;

    for (ns=0 ; ns < nsp ; ns++ ) 
      {
	ideb += nel;

	for (i=0 ; i<nel ; i++ ) 
	
	  {
            if(nblblr >=11) printf(" *** FACFORME_2A : ns=%d   facette i=%d \n",ns+1,i+1);
            pourcent=(ns+1)*i/total_fac;
            if (pourcent>pourcent_ecrit)
	      {
		printf("              %5.2f %% du calcul effectue\n",pourcent_ecrit*100);
		pourcent_ecrit += 0.1;
	      }
	    xn1 = xnf[i];
	    yn1 = xnf[i+ nel2];
	    noeud[0] = nod[i];
	    noeud[1] = nod[i+ nel2];

	    for  (j=ideb+i ; j<ideb+nel ; j++ )   
	      {
		if (grconv[i]!=grconv[j]) continue;

		fforme = coplanaire_2a(iaxi,xn1,yn1,xnf[j],xnf[j+nel2]);
		if (fforme>-0.1)
		  {
		    nbfcoplanaire += 1;
		  }
		if (fforme<-1.)  
		  {
		    noeud[2] = nod[j];
		    noeud[3] = nod[j+ nel2];
		    
		    for (k=0;k<4;k++)
		      { 
			xi_ini[k] = coord[noeud[k]-1];
			yi_ini[k] = coord[noeud[k]-1+ npoin];
		      }

		    decouphor_2a(iaxi,xi_ini,yi_ini,xn1,yn1,xnf[j],xnf[j+nel2]);
		    fforme=0.;
		    for (idec=0;idec<ndecmax;idec++)
                      {
                    for(jdec=0;jdec<ndecmax;jdec++)
		      {
			xi[0] = xi_ini[0]+(xi_ini[1]-xi_ini[0])/ndecmax*idec;
			xi[1] = xi_ini[0]+(xi_ini[1]-xi_ini[0])/ndecmax*(idec+1);
			yi[0] = yi_ini[0]+(yi_ini[1]-yi_ini[0])/ndecmax*idec;
			yi[1] = yi_ini[0]+(yi_ini[1]-yi_ini[0])/ndecmax*(idec+1);

			xi[2] = xi_ini[2]+(xi_ini[3]-xi_ini[2])/ndecmax*jdec;
			xi[3] = xi_ini[2]+(xi_ini[3]-xi_ini[2])/ndecmax*(jdec+1);
			yi[2] = yi_ini[2]+(yi_ini[3]-yi_ini[2])/ndecmax*jdec;
			yi[3] = yi_ini[2]+(yi_ini[3]-yi_ini[2])/ndecmax*(jdec+1);
			

			for (n=0;n<nquartier;n++) tabint[n]=1;
		    
			x1m=0.5*(xi[0]+xi[1]);y1m=0.5*(yi[0]+yi[1]);
			x2m=0.5*(xi[2]+xi[3]);y2m=0.5*(yi[2]+yi[3]);

			iaxir=2 ;
			derriere_2a (iaxir,i,j,xn1,yn1,xnf[j],xnf[j+ nel2],x1m,y1m,x2m,y2m,&icode); 
			
			if (icode!=0)
			  {
			    if (i==j)
			      {
				l1=sqrt((xi[0]-xi[1])*(xi[0]-xi[1])+(yi[0]-yi[1])*(yi[0]-yi[1]));
				if (iaxi==1)
				  d=0.5*(yi[0]+yi[1]);
				else
				  d=0.5*(xi[0]+xi[1]);
				if (l1/d<0.3) 
				  {ordrei=3; ordrej=4;}
				else
				  {ordrei=10;ordrej=12;}
			      }
			    else
			      {
				d=sqrt((x2m-x1m)*(x2m-x1m)+(y2m-y1m)*(y2m-y1m));
				l1=sqrt((xi[0]-xi[1])*(xi[0]-xi[1])+(yi[0]-yi[1])*(yi[0]-yi[1]));
				l2=sqrt((xi[2]-xi[3])*(xi[2]-xi[3])+(yi[2]-yi[3])*(yi[2]-yi[3]));
				if (l1/d<0.3) ordrei=3; else ordrei=10;
				if (l2/d<0.3) ordrej=3; else ordrej=10;

				dist12=(xi[2]-xi[1])*(xi[2]-xi[1])+(yi[2]-yi[1])*(yi[2]-yi[1]) ;
				dist03=(xi[3]-xi[0])*(xi[3]-xi[0])+(yi[3]-yi[0])*(yi[3]-yi[0]) ;
				if (dist12 < 1e-10 || dist03 < 1e-10 )  { ordrei = 24 ; ordrej = 24;} 
			      }
		    
			    gauss();
		    
			    segfdfaxi (iaxi,i,j,xi,yi,nel2,npoin,nod,coord,&fforme);
		    
			    if(fforme < 0.) 
			      {
				if (nblblr >= 11)
				  printf(" fforme negatif ns%d i %d j %d  fdf= %f\n",ns,i+1,j+1,1e6*fforme);
			      }
			    else
			      fdf[i*nel-(i+1)*i/2+j%nel] += fforme; 
			    /* printf("i+1,j+1 %d  %d fdf %f\n",i+1,j+1,fforme*1.e6); */
			  }
		      }
                  }

		  }
	      }  /* for  (j=ideb+i ; j<ideb+nel ; j++ ) */
      
	  } /*  for (i=0 ; i<nel ; i++ )  */

      } /*  for (ns=0 ; ns<2^nplasy ; ns++ )  */

}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | segfdfaxi                                                            |
  |        organisation du calcul du facteur de forme entre 2 segments   |
  |        (axisymetrique)                                               |
  |======================================================================| */

void segfdfaxi (int iaxi,int ii,int jj,double x[],double y[],
		int nel2,int npoin,int *nod, double *coord,double *fforme)
 
{
  double xi,yi,xj,yj,xc,yc,xd,yd,xk,yk,xx,c0,cpi,s1,s2,s3,s4;
  double ymin,ymax,xn0,yn0,xnpi,ynpi;
  int i,iq1,iq2,n,ns,n1,n2;
  double xmax,xk_min,yk_min,yk_max;
  double ytop_ab,ybot_ab,ytop_cd,ybot_cd;

  yi=0.5*(y[0]+y[1]); yj=0.5*(y[2]+y[3]); 
  xi=0.5*(x[0]+x[1]); xj=0.5*(x[2]+x[3]); 


  ytop_ab = max(y[0],y[1]); ybot_ab = min(y[0],y[1]);
  ytop_cd = max(y[2],y[3]); ybot_cd = min(y[2],y[3]);
  ymin=min(ybot_ab,ybot_cd)+1e-5; ymax=max(ytop_ab,ytop_cd)-1e-5;
  xmax = max(xi,xj);

  xn0=-abs(yj-yi); xnpi= abs(yj-yi); 
  if (yi<yj) {yn0=xj-xi;} else {yn0=xi-xj;}
  if (yn0<0.) {ynpi=-xi-xj;} else {ynpi=xi+xj;}

  /* peut etre a revoir CP !!*/
  if (abs(yj-yi)<1.e-5) 
    {xn0=0;yn0=1.;xnpi=0;ynpi=1; }
 
  xx=sqrt(xn0*xn0+yn0*yn0); xn0 /=xx; yn0 /=xx;
  xx=sqrt(xnpi*xnpi+ynpi*ynpi); xnpi /=xx; ynpi /=xx;
  c0=-xn0*xi-yn0*yi;   cpi=-xnpi*xi-ynpi*yi;
  
  for (i=0;i<nel2;i++)
    {

      /* printf(" test pour facette oculte  i= %d \n",i); */
      if (i==ii || i==jj) continue;

      n1 = nod[i];
      n2 = nod[i+ nel2];
      xc = coord[n1-1]; yc = coord[n1-1+ npoin];
      xd = coord[n2-1]; yd = coord[n2-1+ npoin];
      xk=0.5*(xc+xd); yk=0.5*(yc+yd); 

      xk_min = min(xc,xd);

      yk_min = min(yc,yd); yk_max=max(yc,yd);
      
      if (yk_min > ymax || yk_max < ymin || xk_min >= xmax )
	{
	  /* printf(" on sort sur ce test yk=%f ymax=%f ymin=%f xkmin=%f  xmax=%f\n",yk_min,yk_max,ymin,xk_min,xmax); */
	   continue;
	 }

      s1=xn0*xc+yn0*yc+c0; s2=-xnpi*xc+ynpi*yc+cpi; 
      s3=xn0*xd+yn0*yd+c0; s4=-xnpi*xd+ynpi*yd+cpi;
      if (s1*s3>0 && s2*s4>0 && s1*s2>0 && abs(yj-yi) < 1.e-5)
	{
	  /* printf(" on sort sur ce test s1=%f s2=%f s3=%f s4=%f \n",s1,s2,s3,s4); */
	  continue;
	}

      if (abs(yi-yj) >  1e-5)
	quel_angle(ii,jj,xi,yi,xj,yj,xc,yc,xd-xc,yd-yc,&iq1,&iq2);
      else
	quel_angle_hide(ii,jj,xi,yi,xj,yj,xc,yc,xd-xc,yd-yc);
	
    }


  ns=0; 
  for (n=0;n<nquartier;n++) ns += tabint[n];


  if (ns==0) 
    *fforme=0;
  else
    axi_integ_fc(x,y,fforme);


}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | facecache_2d                                                         |
  |          Algorithme de detection rapide de faces cachees             |
  |======================================================================| */
void facecache_2a(int ndim, int npoin,int nel2,int nel,
		  int *nod,double *coord,double *xnf,
		  int *faces_cachees,int nplasy)

{
  int i,j,k,ns;
  int noeud[4];
  int nbfcoplanaire,code_decoupe,nbfca;
  int ideb,npoin2;
  double xi[4],yi[4],*pland,dsign[4];
  double xn1,yn1,x,y,fforme;


  pland = (double*)malloc( nel2 * sizeof(double));
  if (pland==NULL) 
    {printf(" ERREUR facecache_2a : probleme d'allocation memoire\n");
     exit(0);}

  nbfca = 0 ;
  nbfcoplanaire = 0 ;
  npoin2 = 2*npoin ;

  for (i=0 ; i<nel2 ; i++)
    {
      xn1 = xnf[i];
      yn1 = xnf[i+ nel2];
      x  = coord[nod[i]-1];
      y  = coord[nod[i]-1+npoin];
      pland[i]=-x*xn1-y*yn1;
    }


  ideb = -nel;
  for (ns=0 ; ns < nsp ; ns++ ) 
    {
      ideb += nel;
      for (i=0 ; i<nel ; i++ )  
	{
	  xn1 = xnf[i];
	  yn1 = xnf[i+ nel2];
	  noeud[0] = nod[i];
	  noeud[1] = nod[i+ nel2];

 	  for  (j=ideb+i ; j<ideb+nel ; j++ )   
	    {
	      fforme = coplanaire_2d(xn1,yn1,xnf[j],xnf[j+nel2]);
	      if (fforme<-1.)  
		{
		  noeud[2] = nod[j];
		  noeud[3] = nod[j+ nel2];
		    
		  for (k=0;k<4;k++)
		    { 
		      xi[k] = coord[noeud[k]-1];
		      yi[k] = coord[noeud[k]-1+ npoin];
		    }

		  derriere_2d(nel2,i,j,xnf,pland,xi,yi,dsign,&code_decoupe) ;  
		  if ( code_decoupe != 0 ) nbfca += 1 ;
		}
	    }
	}

    }
  if (nbfca != 0 ) 
    {
      *faces_cachees = 1 ;
      printf( " FACECACHE_2A : Le maillage comporte des faces cachees (nbre=%d) \n",nbfca ) ;
    }
  else
    {
      *faces_cachees = 0 ;
      printf( " FACECACHE_2A : Le maillage ne comporte a priori pas de faces cachees \n" ) ;
    }

}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | coplanaire_2a                                                        |
  |           retourne 0 si les faces sont coplanaires, -1000 sinon      |
  |           (pour de l'axisymetrique)                                  |
  |======================================================================| */

double coplanaire_2a (int iaxi,double xn1,double yn1,double xn2,double yn2)
{
    double dnx,dny,epscop,eps0;
    
    epscop = 1.E-3;
    eps0 = 1.E-8;
    dnx = xn1 - xn2;
    dny = yn1 - yn2;

    if (iaxi==2 && abs(xn1)<eps0 && abs(xn2)<eps0 && abs(dny)<epscop)
      return(0);
    else if (iaxi==1 && abs(yn1)<eps0 && abs(yn2)<eps0 && abs(dnx)<epscop)
      return(0);
    else
      return(-1000);

}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | axi_integ_vis                                                        |
  |           calcul du facteur de forme en axi                          |
  |           (pas de face cachee algo CP-IR)                            |
  |======================================================================| */

void axi_integ_vis (double x[4],double y[4],double *fij)
{
  double c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14,c15;
  double h,dzi,dzj,dxi,dxj,xi2,xj2,h2,F,t1,t2,li,lj,xi,xj;
  int i,j;

  t1=0; t2=Pi;


  dzi=y[1]-y[0];  dxi=x[1]-x[0];  
  dzj=y[3]-y[2];  dxj=x[3]-x[2];


  F=0;
  for (i=0;i<ordrei;i++)
    for (j=0;j<ordrej;j++)
      {
	li=0.5*xli[i]+0.5; lj=0.5*xlj[j]+0.5;
	xi=x[0]+li*dxi;      xj=x[2]+lj*dxj;
	h=y[2]-y[0]+lj*dzj-li*dzi;
	xi2=xi*xi; xj2=xj*xj; h2=h*h;
	
	c1=xi2*xj2*dzi*dzj;
	c2=-xi*xj*((xi2+xj2)*dzi*dzj-h*(xj*dxj*dzi-xi*dxi*dzj));
	c3=xi*xj*(xi*dzi+h*dxi)*(xj*dzj-h*dxj);
	c4=xi2+xj2+h2;
	c5=-2*xi*xj;
	c6=c4/c5;
	c7=c2-2*c1*c6;
	c8=c3-c1*c6*c6;
	c9=c7*c6-c8;
	c10=2*(c7-c6*c8);
	c11=sqrt(c6*c6-1);
	c12=(c6-1)/c11;
	
	c13=c1/(c5*c5);
	c14=1./(c5*c5*c11*c11);
	c15=c10/c11;
	


	
	if (c12>0)
	  F += wi[i]*wj[j] *(c13*(t2-t1)-c14*c15*Pi*0.5);
	else
	  F += wi[i]*wj[j] *(c13*(t2-t1)+c14*c15*Pi*0.5);
      }
  
  *fij=F;
}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | axi_integ_vis                                                        |
  |           calcul du facteur de forme en axi                          |
  |           (faces cachees algo CP-IR)                                 |
  |======================================================================| */

void axi_integ_fc (double x[4],double y[4],double *fij)
{
  double c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14,c15;
  double h,dzi,dzj,dxi,dxj,xi2,xj2,h2,F,t1,t2,li,lj,xi,xj,pisnq;
  int i,j,ic,nc,couple[nquartier][2],n;


  dzi=y[1]-y[0];  dxi=x[1]-x[0];  
  dzj=y[3]-y[2];  dxj=x[3]-x[2];

  pisnq=Pi/(nquartier-1);
  ic=tabint[0];
  couple[0][0]=0;
  if (ic==1) nc=0; else nc=-1;

  for (i=1;i<nquartier;i++)
    if (tabint[i] != ic)
      { 
	if (ic==1) 
	  {couple[nc][1]=i-1; ic=0;} 
	else 
	  {nc +=1; couple[nc][0]=i; ic=1;} 
      }

  if (tabint[nquartier-1]==1) couple[nc][1]=nquartier-1;

  F=0;
  for (n=0;n<=nc;n++)
    {
      t1=pisnq*couple[n][0];
      t2=pisnq*couple[n][1];

      for (i=0;i<ordrei;i++)
	for (j=0;j<ordrej;j++)
	  {
	    li=0.5*xli[i]+0.5; lj=0.5*xlj[j]+0.5;
	    xi=x[0]+li*dxi;      xj=x[2]+lj*dxj;
	    h=y[2]-y[0]+lj*dzj-li*dzi;
	    xi2=xi*xi; xj2=xj*xj; h2=h*h;
	    
	    c1=xi2*xj2*dzi*dzj;
	    c2=-xi*xj*((xi2+xj2)*dzi*dzj-h*(xj*dxj*dzi-xi*dxi*dzj));
	    c3=xi*xj*(xi*dzi+h*dxi)*(xj*dzj-h*dxj);
	    c4=xi2+xj2+h2;
	    c5=-2*xi*xj;
	    c6=c4/c5;
	    c7=c2-2*c1*c6;
	    c8=c3-c1*c6*c6;
	    c9=c7*c6-c8;
	    c10=2*(c7-c6*c8);
	    c11=sqrt(c6*c6-1);
	    c12=(c6-1)/c11;
	    
	    c13=c1/(c5*c5);
	    c14=1./(c5*c5*c11*c11);
	    c15=c10/c11;
	

	    F += wi[i]*wj[j] *(
			       c13*(t2-t1)+
			       c14*(c9*( sin(t2)/(c6+cos(t2))-sin(t1)/(c6+cos(t1)) )
				    -c15*(atan(c12*tan(0.5*t2))-atan(c12*tan(0.5*t1)) )
				    )
			       );

	  }
    }
  
  *fij=F;
}
  
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | gauss                                                                |
  |           calcul du facteur de forme en axi                          |
  |           (pas de face cachee)                                       |
  |======================================================================| */

void gauss()
{

  if (ordrei==3) 
    {
      xli[0] =  0.;
      xli[1] =  0.774596669241483;
      xli[2] = -0.774596669241483;
       wi[0] =  0.888888888888889;
       wi[1] = wi[2] =  0.555555555555556; 
    }
  else if (ordrei==4)
    {
      xli[0] = 0.339981043584856;
      xli[1] =-0.339981043584856;
      xli[2] = 0.861136311594053;
      xli[3] =-0.861136311594053;
       wi[0] = wi[1] = 0.652145154862546;
       wi[2] = wi[3] = 0.347854845137454;
    }
  else if (ordrei==5)
    {
      xli[0] = 0.;
      xli[1] = 0.538469310105683;
      xli[2] =-0.538469310105683;
      xli[3] = 0.906179845938664;
      xli[4] =-0.906179845938664;
       wi[0] = 0.568888888888889;
       wi[1] = wi[2] = 0.478628670499366;
       wi[3] = wi[4] = 0.236926885056189; 
    }
  else if (ordrei==10)
    {
      xli[0] = 0.148874338981631;
      xli[1] =-0.148874338981631;
      xli[2] = 0.433395394129247;
      xli[3] =-0.433395394129247;
      xli[4] = 0.679409568299024;
      xli[5] =-0.679409568299024;
      xli[6] = 0.865063366688985;
      xli[7] =-0.865063366688985;
      xli[8] = 0.973906528517172;
      xli[9] =-0.973906528517172;
       wi[0] = wi[1] = 0.295524224714753;
       wi[2] = wi[3] = 0.269266719309996;
       wi[4] = wi[5] = 0.219086362515982;
       wi[6] = wi[7] = 0.149451349150581;
       wi[8] = wi[9] = 0.066671344308688;
    }
  else if (ordrei==12)
    {
      xli[0] = 0.1252334085;
      xli[1] =-0.1252334085;
      xli[2] = 0.3678314989;
      xli[3] =-0.3678314989;
      xli[4] = 0.5873179542;
      xli[5] =-0.5873179542;
      xli[6] = 0.7699026741;
      xli[7] =-0.7699026741;
      xli[8] = 0.9041172563;
      xli[9] =-0.9041172563;
     xli[10] = 0.9815606342;
     xli[11] =-0.9815606342;
       wi[0] = wi[1] = 0.2491470458;
       wi[2] = wi[3] = 0.2334925365;
       wi[4] = wi[5] = 0.2031674267;
       wi[6] = wi[7] = 0.1600783285;
       wi[8] = wi[9] = 0.1069393259;
      wi[10] =wi[11] = 0.0471753363;
    }
  else if (ordrei==24)
    {
      xli[0] = 0.0640568928;
      xli[1] =-0.0640568928;
      xli[2] = 0.1911188674;
      xli[3] =-0.1911188674;
      xli[4] = 0.3150426796;
      xli[5] =-0.3150426796;
      xli[6] = 0.4337935076;
      xli[7] =-0.4337935076;
      xli[8] = 0.5454214713;
      xli[9] =-0.5454214713;
     xli[10] = 0.6480936519;
     xli[11] =-0.6480936519;
     xli[12] = 0.7401241915;
     xli[13] =-0.7401241915;
     xli[14] = 0.8200019859;
     xli[15] =-0.8200019859;
     xli[16] = 0.8864155270;
     xli[17] =-0.8864155270;
     xli[18] = 0.9382745520;
     xli[19] =-0.9382745520;
     xli[20] = 0.9747285559;
     xli[21] =-0.9747285559;
     xli[22] = 0.9951872199;
     xli[23] =-0.9951872199;
       wi[0] = wi[1] =0.1279381953;
       wi[2] = wi[3] = 0.1258374563;
       wi[4] = wi[5] = 0.1216704729;
       wi[6] = wi[7] = 0.1155056680;
       wi[8] = wi[9] = 0.1074442701;
      wi[10] = wi[11] = 0.0976186521;
      wi[12] = wi[13] = 0.0861901615;
      wi[14] = wi[15] = 0.0733464814;
      wi[16] = wi[17] = 0.0592985849;
      wi[18] = wi[19] = 0.0442774388;
      wi[20] = wi[21] = 0.0285313886;
      wi[22] = wi[23] = 0.0123412297;
    }


  if (ordrej==3) 
    {
      xlj[0] = 0.;
      xlj[1] = 0.774596669241483;
      xlj[2] =-0.774596669241483;
       wj[0] = 0.888888888888889;
       wj[1] = wj[2] = 0.555555555555556; 
    }
  else if (ordrej==4)
    {
      xlj[0] = 0.339981043584856;
      xlj[1] =-0.339981043584856;
      xlj[2] = 0.861136311594053;
      xlj[3] =-0.861136311594053;
       wj[0] = wj[1] = 0.652145154862546;
       wj[2] = wj[3] = 0.347854845137454;
    }
  else if (ordrej==5)
    {
      xlj[0] = 0.;
      xlj[1] = 0.538469310105683;
      xlj[2] =-0.538469310105683;
      xlj[3] = 0.906179845938664;
      xlj[4] =-0.906179845938664;
       wj[0] = 0.568888888888889;
       wj[1] = wj[2] = 0.478628670499366;
       wj[3] = wj[4] = 0.236926885056189; 
    }
  else if (ordrej==10)
    {
      xlj[0] = 0.148874338981631;
      xlj[1] =-0.148874338981631;
      xlj[2] = 0.433395394129247;
      xlj[3] =-0.433395394129247;
      xlj[4] = 0.679409568299024;
      xlj[5] =-0.679409568299024;
      xlj[6] = 0.865063366688985;
      xlj[7] =-0.865063366688985;
      xlj[8] = 0.973906528517172;
      xlj[9] =-0.973906528517172;
       wj[0] = wj[1] = 0.295524224714753;
       wj[2] = wj[3] = 0.269266719309996;
       wj[4] = wj[5] = 0.219086362515982;
       wj[6] = wj[7] = 0.149451349150581;
       wj[8] = wj[9] = 0.066671344308688;
    }
  else if (ordrej==12)
    {
      xlj[0] = 0.1252334085;
      xlj[1] =-0.1252334085;
      xlj[2] = 0.3678314989;
      xlj[3] =-0.3678314989;
      xlj[4] = 0.5873179542;
      xlj[5] =-0.5873179542;
      xlj[6] = 0.7699026741;
      xlj[7] =-0.7699026741;
      xlj[8] = 0.9041172563;
      xlj[9] =-0.9041172563;
     xlj[10] = 0.9815606342;
     xlj[11] =-0.9815606342;
       wj[0] = wj[1] = 0.2491470458;
       wj[2] = wj[3] = 0.2334925365;
       wj[4] = wj[5] = 0.2031674267;
       wj[6] = wj[7] = 0.1600783285;
       wj[8] = wj[9] = 0.1069393259;
      wj[10] =wj[11] = 0.0471753363;
    }
  else if (ordrej==24)
    {
      xlj[0] = 0.0640568928;
      xlj[1] =-0.0640568928;
      xlj[2] = 0.1911188674;
      xlj[3] =-0.1911188674;
      xlj[4] = 0.3150426796;
      xlj[5] =-0.3150426796;
      xlj[6] = 0.4337935076;
      xlj[7] =-0.4337935076;
      xlj[8] = 0.5454214713;
      xlj[9] =-0.5454214713;
     xlj[10] = 0.6480936519;
     xlj[11] =-0.6480936519;
     xlj[12] = 0.7401241915;
     xlj[13] =-0.7401241915;
     xlj[14] = 0.8200019859;
     xlj[15] =-0.8200019859;
     xlj[16] = 0.8864155270;
     xlj[17] =-0.8864155270;
     xlj[18] = 0.9382745520;
     xlj[19] =-0.9382745520;
     xlj[20] = 0.9747285559;
     xlj[21] =-0.9747285559;
     xlj[22] = 0.9951872199;
     xlj[23] =-0.9951872199;
       wj[0] = wj[1] = 0.1279381953;
       wj[2] = wj[3] = 0.1258374563;
       wj[4] = wj[5] = 0.1216704729;
       wj[6] = wj[7] = 0.1155056680;
       wj[8] = wj[9] = 0.1074442701;
      wj[10] = wj[11] = 0.0976186521;
      wj[12] = wj[13] = 0.0861901615;
      wj[14] = wj[15] = 0.0733464814;
      wj[16] = wj[17] = 0.0592985849;
      wj[18] = wj[19] = 0.0442774388;
      wj[20] = wj[21] = 0.0285313886;
      wj[22] = wj[23] = 0.0123412297;
    }

}
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | surface_seg                                                          |
  |           calcul de la longueur des segments                         |
  |======================================================================| */

void surface_anneau (int iaxi,int nel,int npoin,
		     int *nod,double *coord,double *sufray)

{
    int i,noeud[2];
    double xab,yab;
    double xa,ya,xb,yb;
    

    if (iaxi==1)
      for (i=0 ; i<nel ; i++ )   
	{
	  noeud[0] = nod[i];
	  noeud[1] = nod[i+ nel];
	  
	  xa = coord[noeud[0]-1];
	  ya = coord[noeud[0]-1+ npoin];
	  xb = coord[noeud[1]-1];
	  yb = coord[noeud[1]-1+ npoin];
	  
	  xab = xb-xa;
	  yab = yb-ya;
	  sufray[i]=Pi*abs(yb+ya)*sqrt(xab*xab + yab*yab); 
	}
    else
      for (i=0 ; i<nel ; i++ )   
	{
	  noeud[0] = nod[i];
	  noeud[1] = nod[i+ nel];
	  
	  xa = coord[noeud[0]-1];
	  ya = coord[noeud[0]-1+ npoin];
	  xb = coord[noeud[1]-1];
	  yb = coord[noeud[1]-1+ npoin];
	  
	  xab = xb-xa;
	  yab = yb-ya;
	  sufray[i]=Pi*abs(xb+xa)*sqrt(xab*xab + yab*yab); 
	}

}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | quel_angle                                                           |
  |     detremination de l'angle d'integration                           |
  |======================================================================| */
void quel_angle(int ii,int jj,double xi, double  zi, double xj, double zj,
		double u0, double v0, double u1, double v1,
		int *iq1,int *iq2)
{

  double a,b,c,d,teta;
  double b1,b2,c1,c2,d1,d2,r1,r2,alpha,beta,gama,deltap;
  double rac1,rac2,delta,dteta,ct;
  double teta1,aa,bb,sqd;
  int    n,i,voir0,voirPi,ideb;
  double rac;
  double ratioz;

  a=-(zj-zi)*(zj-zi);


  b1=xi*xi+xj*xj; b2=-2*xi*xj;
  c1=-2*(xi*xi*zj+xj*xj*zi); c2=2*xi*xj*(zi+zj);
  d1=xi*xi*zj*zj+zi*zi*xj*xj; d2=-2*xi*xj*zi*zj;


  r1=(u1*v0-v1*u0)*(u1*v0-v1*u0);
  r2=u1*v1*u0-u1*u1*v0;
  
  alpha=v1*v1*(c2*c2-4*b2*d2);
  beta=4*a*(-b2*r1+c2*r2)+v1*v1*(2*c1*c2-4*(b1*d2+b2*d1))-4*u1*u1*a*d2;
  gama=4*a*(-b1*r1+c1*r2)+v1*v1*(c1*c1-4*b1*d1)-4*(u1*u1*a*d1);

  deltap=beta*beta-4*alpha*gama;
  teta1=0;
  if (deltap<0 && alpha<0)
      {/*printf("Aucune racine : pas d'intersection\n");*/ teta1=-1;}
  
    
  if (teta1>-0.1)
    {
      /* en 0 : ct=1 */
      if (ii==jj)
	{
	  voir0=1;
	}
      else if (abs(-v1*(xj-xi)+u1*(zj-zi))<1.e-5)
	{
	  voir0=1;
	}
      else
	{
	  ct = 1;
	  b=b1+b2;
	  c=c1+c2;
	  d=d1+d2;
	  delta=alpha + beta + gama;
	  voir0=1;
	  if (delta>=0)
	    {
	      aa = a*u1*u1+b*v1*v1;
	      bb=2*a*u0*u1+2*b*v1*v0+c*v1;
	      if (delta==0)
		rac1=rac2=-0.5*bb/aa;
	      else
		{
		  sqd=sqrt(delta);
		  rac1=0.5*(-bb-sqd)/aa;
		  rac2=0.5*(-bb+sqd)/aa;
		}

	      rac= -1e6;
	      if (rac1>=0 && rac1<=1) rac = rac1 ;
	      else if ( rac2>=0 && rac2<=1) rac = rac2 ;

	      if ( rac>=0 && rac<=1)
		{
		  ratioz = (abs(v0+rac*v1)-zi)/(zj-zi);
		  if (0 <= ratioz && ratioz <= 1.) {voir0=0;tabint[0] = 0 ;}
		}
	    }
	}

      /* en Pi : ct=-1 */
      ct = -1;
      b=b1-b2;
      c=c1-c2;
      d=d1-d2;
      delta=alpha - beta + gama;
      voirPi=1;
      if (delta>=0)
	{
	  aa = a*u1*u1+b*v1*v1;
	  bb=2*a*u0*u1+2*b*v1*v0+c*v1;
	  if (delta==0)
	    rac1=rac2=-0.5*bb/aa;
	  else
	    {
	      sqd=sqrt(delta);
	      rac1=0.5*(-bb-sqd)/aa;
	      rac2=0.5*(-bb+sqd)/aa;
	    }

	  rac = -1e6;
	  if (rac1>=0 && rac1<=1) rac = rac1 ;
	  else if ( rac2>=0 && rac2<=1) rac = rac2 ;

	  if ( rac>=0 && rac<=1)
	    {
	      ratioz = (abs(v0+rac*v1)-zi)/(zj-zi);
	      if (0 < ratioz && ratioz < 1.) {voirPi=0;tabint[nquartier-1] = 0;}
	    }
	}

      /* printf("voir0=%d voirPi=%d\n",voir0,voirPi);  */

      if (voir0==0 && voirPi==0) 
	{
	  /* printf("les facettes ne se voient jamais\n");*/
	  for(n=0;n<nquartier;n++)tabint[n]=0;
	}
      else
	{
	  dteta=Pi/(nquartier-1);
	  if (ii==jj || abs(-v1*(xj-xi)+u1*(zj-zi))<1.e-5) {ideb=1;teta=dteta;}
	  else {ideb=0;teta=0;}

	  for(i=ideb;i<nquartier;i++)
	    {
	      if (tabint[i]==1)
		{
		  ct=cos(teta);
		  b=b1+b2*ct;
		  c=c1+c2*ct;
		  d=d1+d2*ct;
		  
		  delta=alpha*ct*ct + beta*ct + gama;
		  
		  if (delta>=0)
		    {
		      aa = a*u1*u1+b*v1*v1;
		      bb=2*a*u0*u1+2*b*v1*v0+c*v1;
		      if (delta==0)
			rac1=rac2=-0.5*bb/aa;
		      else
			{
			  sqd=sqrt(delta);
			  rac1=0.5*(-bb-sqd)/aa;
			  rac2=0.5*(-bb+sqd)/aa;
			}
		      
		      rac = -1e6;
		      if (rac1>=0 && rac1<=1) rac = rac1 ;
		      else if ( rac2>=0 && rac2<=1) rac = rac2 ;

		      /*   printf(" i=%d   rac1=%f rac2=%f \n",i,rac1,rac2); */

		      if ( rac>=0 && rac<=1)
			{
			  ratioz = (abs(v0+rac*v1)-zi)/(zj-zi);
			  if (0 < ratioz && ratioz < 1.) tabint[i] = 0 ;

			}

		    }
		}
	      teta+=dteta;
	    }
	}
      
    }

}
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | tab_integ                                                            |
  |      mise a jour des indicateurs d'integration                       |
  |======================================================================| */
void tab_integ(int iq1,int iq2)
{
  int i;
  
  for(i=iq1;i<=iq2;i++) tabint[i]=0;
}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | derriere                                                             |
  |         Detection des segments en arriere et retour d'un code de     |
  |         Classement   (axisymetrique)                                 |
  |======================================================================| */

void derriere_2a (int iaxi,int i,int j,double xni0,double yni0,double xnj0,double ynj0,
		  double xi,double yi,double xj,double yj,
		  int *icode)

{
  int n;
  double xnipi,ynipi,xnjpi,ynjpi,xij0,yij0,xijpi,yijpi;
  double psi0,psj0,psipi,psjpi,xij,yij,zij,xnj,ynj,znj,psi,psj;
  double pisnq,t,epsi;

  epsi=1.e-6;
  if (i==j)
    {
      if (iaxi==2 && xni0>0) {*icode=0;   /*printf("    --> face concave\n");*/ }
      else if (iaxi==1 && yni0>0) {*icode=0;   /*printf("    --> face concave\n");*/ }
      else *icode=1;
    }
  else
    {
      pisnq=Pi/(nquartier-1);

      xnipi=-xni0; ynipi=yni0; xnjpi=-xnj0; ynjpi=ynj0; 
      xij0=xj-xi; yij0=yj-yi;  xijpi=-xj-xi; yijpi=yj-yi;
      
       psi0=xij0*xni0+yij0*yni0;        psj0=-(xij0*xnj0+yij0*ynj0);  
       psipi=xijpi*xni0+yijpi*yni0;   psjpi=-(xijpi*xnjpi+yijpi*ynjpi);
      
      if ((psi0<-epsi || psj0<-epsi) && (psipi<-epsi || psjpi<-epsi)) 
	{*icode=0; /*printf("    --> ne se voient jamais\n");*/}
      else if (psi0>0 && psipi>0 && psj0>0 && psjpi>0) 
	{*icode=1;/*printf("    --> se voient potentiellement toujours\n");*/}
      else
	{
	  *icode=2;
	  for (n=0;n<nquartier;n++) 
	    {
	      t=pisnq*n;
	      xij=xj*cos(t)-xi; yij=xj*sin(t);zij=yj-yi;
	      xnj=xnj0*cos(t); ynj=xnj0*sin(t);  znj=ynj0;
	      psi= xij*xni0+zij*yni0;  psj=-(xij*xnj+yij*ynj+zij*znj);
	      if (psi<0 || psj<0) tabint[n]=0;
	    }
	}
    }
} 


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | quel_angle_ide                                                       |
  |     detremination de l'angle d'integration (hauteur identique)       |
  |======================================================================| */
void quel_angle_hide (int ii,int jj,double xi, double  zi, double xj, double zj,
		     double u0, double v0, double u1, double v1)

{
  double teta;
  double alpha,beta,gama,u;
  double rac1,rac2,delta,dteta,ct;
  double aa,bb,sqd;
  int    n,i,voir0,voirPi,ind,tet[2],ideb;
  int    test;

  test = 0;
  if ( v1 > 0 ) {if (zi < v0 ||  v0+v1 < zi)    return ; else  test = 1;}
  else { if (zi < v0+v1 ||  v0 < zi)    return ; test = 1; }

  if (test == 1)
    {
      u = u0 + (zi-v0)/v1*u1;

      /* en 0 : ct=1 */
      if (ii==jj)
	{
	  voir0=1;
	}
      else if (abs(-v1*(xj-xi)+u1*(zj-zi))<1.e-5)
	{
	  voir0=1;
	}
      else
	{

	  voir0=1;
	  rac1 = (u-xi)/(xj-xi);
	  rac2 = -(u+xi)/(xj-xi);
	  if (rac1>=0 && rac1<=1  || rac2>=0 && rac2<=1) 
	    {voir0=0; tabint[0]=0;}	  
	}

      /* en Pi : ct=-1 */
      voirPi=1;
      rac1 = - (u-xi)/(xj+xi);
      rac2 =   (u+xi)/(xj+xi);
      if (rac1>=0 && rac1<=1  || rac2>=0 && rac2<=1) 
	{voirPi=0; tabint[nquartier-1]=0;}


      /* printf("voir0=%d voirPi=%d\n",voir0,voirPi);  */

      if (voir0==0 && voirPi==0) 
	{
	  /* printf("les facettes ne se voient jamais\n");*/
	  tet[0]=tet[1]=0;  for(n=0;n<nquartier;n++)tabint[n]=0;
	}
      else
	{
	  tet[0]=0; tet[1]=nquartier-1; ind=0;
	  dteta=Pi/(nquartier-1);
	  if (ii==jj || abs(-v1*(xj-xi)+u1*(zj-zi))<1.e-5) {ideb=1;teta=dteta;}
	  else {ideb=0;teta=0;}

	  for(i=ideb;i<nquartier;i++)
	    {
	      if (tabint[i]==1)
		{
		  ct=cos(teta);		  
		  delta=4*((xi*xi*(xj*ct-xi)*(xj*ct-xi))-((xj*xj+xi*xi)-2*xj*xi*ct)*(xi*xi-u*u));

		  if (delta>=0)
		    {
		      if (delta==0)
			rac1=rac2=-0.5*(xi*(xj*ct-xi))/((xj*xj+xi*xi)-2*xj*xi*ct);
		      else
			{
			  sqd=sqrt(delta);
			  rac1=0.5*(-2*(xi*(xj*ct-xi))-sqd)/((xj*xj+xi*xi)-2*xj*xi*ct);
			  rac2=0.5*(-2*(xi*(xj*ct-xi))+sqd)/((xj*xj+xi*xi)-2*xj*xi*ct);
			}
		      if (rac1>=0 && rac1<=1  || rac2>=0 && rac2<=1)
			{ 
                          tabint[i]=0; 
			  if (voir0==1)
			    {
			      if (voirPi==0) {tet[1]=i;for(n=i;n<nquartier;n++)tabint[n]=0;break;}
			      else if (voirPi==1 && ind==0) {tet[0]=i;ind=1;}
			    }
			}
		      else
			{
			  if (voir0==0) {tet[0]=i;break;}
			  else if (voir0==1 && voirPi==1 && ind==1) {tet[1]=i;break;}
			}
		    }
		  /* if (delta<0) printf("teta=%12.4e , delta < 0 \n",teta); 
		     else
		     printf("teta=%12.4e delta=%12.4e rac1=%12.4e rac2=%12.4e \n",teta,delta,rac1,rac2); 
		  */
		}
	      teta+=dteta;
	    }
	}
    }

}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | decouphor_2a                                                         |
  |         Decoupage de segments  optimisation qualite                  |
  |                                                                      |
  |======================================================================| */
void decouphor_2a(int iaxi,double *xi_ini,double *yi_ini,double xn_i,
		  double yn_i,double xn_j,double yn_j)

{
  
  double epsih=1.e-5,epsd=1e-4,eps=1e-6;
  double denom,numer,alfa,s0,s1,s2,s3;
  double pland_i,pland_j ;
  double iaxir ;


  pland_i = -xi_ini[0]*xn_i-yi_ini[0]*yn_i;
  pland_j = -xi_ini[2]*xn_j-yi_ini[2]*yn_j;

  s0 = xi_ini[0]*xn_j+yi_ini[0]*yn_j+pland_j ;
  s1 = xi_ini[1]*xn_j+yi_ini[1]*yn_j+pland_j ;
  s2 = xi_ini[2]*xn_i+yi_ini[2]*yn_i+pland_i ;
  s3 = xi_ini[3]*xn_i+yi_ini[3]*yn_i+pland_i ;

  iaxir =2;
  
  /* detection facettes (wilkinson) */
  if (iaxir==1) 
    {
      printf(" sans objet - decision cp \n");
    }
  else
    {
      if (abs(xn_i) < epsih && s2*s3 < 0) 
	{
	  if ( s2 > 0 ) 
	    {
	      denom = xn_i*(xi_ini[3]-xi_ini[2]) + yn_i *(yi_ini[3]-yi_ini[2]);
	      
	      if ( abs(denom) > eps )
		{
		  numer =  xn_i*xi_ini[2]+ yn_i*yi_ini[2]+ pland_i ;
		  alfa  = - numer/denom - epsd ;
		      
		  xi_ini[3]= xi_ini[2]+ alfa*(xi_ini[3]-xi_ini[2]);
		  yi_ini[3]= yi_ini[2]+ alfa*(yi_ini[3]-yi_ini[2]);
		}
	    }
	  else
	    {
	      denom = xn_i*(xi_ini[3]-xi_ini[2]) + yn_i *(yi_ini[3]-yi_ini[2]);
	      
	      if ( abs(denom) > eps )
		{
		      numer =  xn_i*xi_ini[2]+ yn_i*yi_ini[2]+ pland_i ;
		      alfa  = - numer/denom + epsd ;
		      
		      xi_ini[2]= xi_ini[2]+ alfa*(xi_ini[3]-xi_ini[2]);
		      yi_ini[2]= yi_ini[2]+ alfa*(yi_ini[3]-yi_ini[2]);
		    }
	    }
	    }
      
      else if  (abs(xn_j) < epsih && s0*s1 < 0) 
	{
	  if ( s0 > 0 ) 
	    {
	      /* deuxieme segment (wilkinson) */
	      denom = xn_j*(xi_ini[1]-xi_ini[0]) + yn_j *(yi_ini[1]-yi_ini[0]);
	      
	      if ( abs(denom) > eps )
		{
		  numer =  xn_j*xi_ini[0]+ yn_j*yi_ini[0]+ pland_j ;
		  alfa  = - numer/denom - epsd ;
		  
		  xi_ini[1]= xi_ini[0]+ alfa*(xi_ini[1]-xi_ini[0]);
		  yi_ini[1]= yi_ini[0]+ alfa*(yi_ini[1]-yi_ini[0]);
		}
	    }
	  else
		{
		  denom = xn_j*(xi_ini[1]-xi_ini[0]) + yn_j *(yi_ini[1]-yi_ini[0]);
		  
		  if ( abs(denom) > eps )
		    {
		      numer =  xn_j*xi_ini[0]+ yn_j*yi_ini[0]+ pland_j ;
		      alfa  = - numer/denom + epsd ;
		      
		      xi_ini[0]= xi_ini[0]+ alfa*(xi_ini[1]-xi_ini[0]);
		      yi_ini[0]= yi_ini[0]+ alfa*(yi_ini[1]-yi_ini[0]);
		    }
		}
	  
	}
      
      else
	{
	  if (s2*s3 < 0 && xn_i >=0 )
	    { 
	      /* i (transformation wilkinson) j */
	      if ( s2 > 0 ) 
		{
		  denom = xn_i*(xi_ini[3]-xi_ini[2]) + yn_i *(yi_ini[3]-yi_ini[2]);
		  
		  if ( abs(denom) > eps )
		    {
		      numer =  xn_i*xi_ini[2]+ yn_i*yi_ini[2]+ pland_i ;
		      alfa  = - numer/denom - epsd ;
		      
		      xi_ini[3]= xi_ini[2]+ alfa*(xi_ini[3]-xi_ini[2]);
		      yi_ini[3]= yi_ini[2]+ alfa*(yi_ini[3]-yi_ini[2]);
		    }
		}
	      else
		{
		  denom = xn_i*(xi_ini[3]-xi_ini[2]) + yn_i *(yi_ini[3]-yi_ini[2]);
		  
		  if ( abs(denom) > eps )
		    {
		      numer =  xn_i*xi_ini[2]+ yn_i*yi_ini[2]+ pland_i ;
		      alfa  = - numer/denom + epsd ;
		      
		      xi_ini[2]= xi_ini[2]+ alfa*(xi_ini[3]-xi_ini[2]);
		      yi_ini[2]= yi_ini[2]+ alfa*(yi_ini[3]-yi_ini[2]);
		    }
		}
	    }
	  
	  else if (s0*s1 < 0 && xn_j >=0 )
	    {
	      if ( s0 > 0 ) 
		{
		  denom = xn_j*(xi_ini[1]-xi_ini[0]) + yn_j *(yi_ini[1]-yi_ini[0]);

		  if ( abs(denom) > eps )
		    {
		      numer =  xn_j*xi_ini[0]+ yn_j*yi_ini[0]+ pland_j ;
		      alfa  = - numer/denom - epsd ;
		      
		      xi_ini[1]= xi_ini[0]+ alfa*(xi_ini[1]-xi_ini[0]);
		      yi_ini[1]= yi_ini[0]+ alfa*(yi_ini[1]-yi_ini[0]);
		    }
		}
	      else
		{
		  denom = xn_j*(xi_ini[1]-xi_ini[0]) + yn_j *(yi_ini[1]-yi_ini[0]);
		  
		  if ( abs(denom) > eps )
		    {
		      numer =  xn_j*xi_ini[0]+ yn_j*yi_ini[0]+ pland_j ;
		      alfa  = - numer/denom + epsd ;
		      
		      xi_ini[0]= xi_ini[0]+ alfa*(xi_ini[1]-xi_ini[0]);
		      yi_ini[0]= yi_ini[0]+ alfa*(yi_ini[1]-yi_ini[0]);
		    }
		}

	    }
	}
    }
  
}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | alter_axi1                                                           |
  |         alteration des coordonnees                                   |
  |                                                                      |
  |======================================================================| */
void alter_axi1(int iaxi, int npoinr, double *cooini , double *cooalt)

{

  int i;
  double ymini ;
  
  ymini = 10000.;
 
  
  if (iaxi==1)
    {
      for (i=0;i<npoinr;i++)
	{
	  cooalt[i] = cooini[i+npoinr];
	  cooalt[i+npoinr] =  -cooini[i] ;
	}
    }
  else
    {
      for (i=0;i<npoinr;i++)
	{
	  cooalt[i] = cooini[i];
	  cooalt[i+npoinr] =  cooini[i+npoinr] ;
	}
    }
  
    /* Test pour savoir si on est positif (et eventuellement decaller) en y */
  for (i=0;i<npoinr;i++)
    {
      if (ymini >=  cooalt[i+npoinr]) 
	ymini =  cooalt[i+npoinr];
    }
    
  if (ymini <= 0.) 
    /* on decalle de ymini */
    {
      for  (i=0;i<npoinr;i++)
	{
	  cooalt[i+npoinr] =  cooalt[i+npoinr]+abs(ymini);
	}
    }


  
}
