/*
 * This file is part of the syndication library
 *
 * Copyright (C) 2006 Frank Osterfeld <osterfeld@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef SYNDICATION_MAPPER_ENCLOSUREATOMIMPL_H
#define SYNDICATION_MAPPER_ENCLOSUREATOMIMPL_H

#include <enclosure.h>
#include <atom/link.h>

namespace Syndication
{

class EnclosureAtomImpl;
typedef QSharedPointer<EnclosureAtomImpl> EnclosureAtomImplPtr;

/**
 *
 * @internal
 * @author Frank Osterfeld
 */
class EnclosureAtomImpl : public Syndication::Enclosure
{
public:

    explicit EnclosureAtomImpl(const Syndication::Atom::Link &link);

    bool isNull() const Q_DECL_OVERRIDE;

    QString url() const Q_DECL_OVERRIDE;

    QString title() const Q_DECL_OVERRIDE;

    QString type() const Q_DECL_OVERRIDE;

    uint length() const Q_DECL_OVERRIDE;

    uint duration() const Q_DECL_OVERRIDE;

private:
    Syndication::Atom::Link m_link;
};

} // namespace Syndication

#endif // SYNDICATION_MAPPER_ENCLOSUREATOMIMPL_H
