// Code generated by protoc-gen-gogo.
// source: bep.proto
// DO NOT EDIT!

/*
	Package protocol is a generated protocol buffer package.

	It is generated from these files:
		bep.proto

	It has these top-level messages:
		Hello
		Header
		ClusterConfig
		Folder
		Device
		Index
		IndexUpdate
		FileInfo
		BlockInfo
		Vector
		Counter
		Request
		Response
		DownloadProgress
		FileDownloadProgressUpdate
		Ping
		Close
*/
package protocol

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.GoGoProtoPackageIsVersion1

type MessageType int32

const (
	messageTypeClusterConfig    MessageType = 0
	messageTypeIndex            MessageType = 1
	messageTypeIndexUpdate      MessageType = 2
	messageTypeRequest          MessageType = 3
	messageTypeResponse         MessageType = 4
	messageTypeDownloadProgress MessageType = 5
	messageTypePing             MessageType = 6
	messageTypeClose            MessageType = 7
)

var MessageType_name = map[int32]string{
	0: "CLUSTER_CONFIG",
	1: "INDEX",
	2: "INDEX_UPDATE",
	3: "REQUEST",
	4: "RESPONSE",
	5: "DOWNLOAD_PROGRESS",
	6: "PING",
	7: "CLOSE",
}
var MessageType_value = map[string]int32{
	"CLUSTER_CONFIG":    0,
	"INDEX":             1,
	"INDEX_UPDATE":      2,
	"REQUEST":           3,
	"RESPONSE":          4,
	"DOWNLOAD_PROGRESS": 5,
	"PING":              6,
	"CLOSE":             7,
}

func (x MessageType) String() string {
	return proto.EnumName(MessageType_name, int32(x))
}
func (MessageType) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{0} }

type MessageCompression int32

const (
	MessageCompressionNone MessageCompression = 0
	MessageCompressionLZ4  MessageCompression = 1
)

var MessageCompression_name = map[int32]string{
	0: "NONE",
	1: "LZ4",
}
var MessageCompression_value = map[string]int32{
	"NONE": 0,
	"LZ4":  1,
}

func (x MessageCompression) String() string {
	return proto.EnumName(MessageCompression_name, int32(x))
}
func (MessageCompression) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{1} }

type Compression int32

const (
	CompressMetadata Compression = 0
	CompressNever    Compression = 1
	CompressAlways   Compression = 2
)

var Compression_name = map[int32]string{
	0: "METADATA",
	1: "NEVER",
	2: "ALWAYS",
}
var Compression_value = map[string]int32{
	"METADATA": 0,
	"NEVER":    1,
	"ALWAYS":   2,
}

func (x Compression) String() string {
	return proto.EnumName(Compression_name, int32(x))
}
func (Compression) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{2} }

type FileInfoType int32

const (
	FileInfoTypeFile             FileInfoType = 0
	FileInfoTypeDirectory        FileInfoType = 1
	FileInfoTypeSymlinkFile      FileInfoType = 2
	FileInfoTypeSymlinkDirectory FileInfoType = 3
	FileInfoTypeSymlinkUnknown   FileInfoType = 4
)

var FileInfoType_name = map[int32]string{
	0: "FILE",
	1: "DIRECTORY",
	2: "SYMLINK_FILE",
	3: "SYMLINK_DIRECTORY",
	4: "SYMLINK_UNKNOWN",
}
var FileInfoType_value = map[string]int32{
	"FILE":              0,
	"DIRECTORY":         1,
	"SYMLINK_FILE":      2,
	"SYMLINK_DIRECTORY": 3,
	"SYMLINK_UNKNOWN":   4,
}

func (x FileInfoType) String() string {
	return proto.EnumName(FileInfoType_name, int32(x))
}
func (FileInfoType) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{3} }

type ErrorCode int32

const (
	ErrorCodeNoError     ErrorCode = 0
	ErrorCodeGeneric     ErrorCode = 1
	ErrorCodeNoSuchFile  ErrorCode = 2
	ErrorCodeInvalidFile ErrorCode = 3
)

var ErrorCode_name = map[int32]string{
	0: "NO_ERROR",
	1: "GENERIC",
	2: "NO_SUCH_FILE",
	3: "INVALID_FILE",
}
var ErrorCode_value = map[string]int32{
	"NO_ERROR":     0,
	"GENERIC":      1,
	"NO_SUCH_FILE": 2,
	"INVALID_FILE": 3,
}

func (x ErrorCode) String() string {
	return proto.EnumName(ErrorCode_name, int32(x))
}
func (ErrorCode) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{4} }

type FileDownloadProgressUpdateType int32

const (
	UpdateTypeAppend FileDownloadProgressUpdateType = 0
	UpdateTypeForget FileDownloadProgressUpdateType = 1
)

var FileDownloadProgressUpdateType_name = map[int32]string{
	0: "APPEND",
	1: "FORGET",
}
var FileDownloadProgressUpdateType_value = map[string]int32{
	"APPEND": 0,
	"FORGET": 1,
}

func (x FileDownloadProgressUpdateType) String() string {
	return proto.EnumName(FileDownloadProgressUpdateType_name, int32(x))
}
func (FileDownloadProgressUpdateType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorBep, []int{5}
}

type Hello struct {
	DeviceName    string `protobuf:"bytes,1,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	ClientName    string `protobuf:"bytes,2,opt,name=client_name,json=clientName,proto3" json:"client_name,omitempty"`
	ClientVersion string `protobuf:"bytes,3,opt,name=client_version,json=clientVersion,proto3" json:"client_version,omitempty"`
}

func (m *Hello) Reset()                    { *m = Hello{} }
func (m *Hello) String() string            { return proto.CompactTextString(m) }
func (*Hello) ProtoMessage()               {}
func (*Hello) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{0} }

type Header struct {
	Type        MessageType        `protobuf:"varint,1,opt,name=type,proto3,enum=protocol.MessageType" json:"type,omitempty"`
	Compression MessageCompression `protobuf:"varint,2,opt,name=compression,proto3,enum=protocol.MessageCompression" json:"compression,omitempty"`
}

func (m *Header) Reset()                    { *m = Header{} }
func (m *Header) String() string            { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()               {}
func (*Header) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{1} }

type ClusterConfig struct {
	Folders []Folder `protobuf:"bytes,1,rep,name=folders" json:"folders"`
}

func (m *ClusterConfig) Reset()                    { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()               {}
func (*ClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{2} }

type Folder struct {
	ID                 string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Label              string   `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	ReadOnly           bool     `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	IgnorePermissions  bool     `protobuf:"varint,4,opt,name=ignore_permissions,json=ignorePermissions,proto3" json:"ignore_permissions,omitempty"`
	IgnoreDelete       bool     `protobuf:"varint,5,opt,name=ignore_delete,json=ignoreDelete,proto3" json:"ignore_delete,omitempty"`
	DisableTempIndexes bool     `protobuf:"varint,6,opt,name=disable_temp_indexes,json=disableTempIndexes,proto3" json:"disable_temp_indexes,omitempty"`
	Devices            []Device `protobuf:"bytes,16,rep,name=devices" json:"devices"`
}

func (m *Folder) Reset()                    { *m = Folder{} }
func (m *Folder) String() string            { return proto.CompactTextString(m) }
func (*Folder) ProtoMessage()               {}
func (*Folder) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{3} }

type Device struct {
	ID          DeviceID    `protobuf:"bytes,1,opt,name=id,proto3,customtype=DeviceID" json:"id"`
	Name        string      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Addresses   []string    `protobuf:"bytes,3,rep,name=addresses" json:"addresses,omitempty"`
	Compression Compression `protobuf:"varint,4,opt,name=compression,proto3,enum=protocol.Compression" json:"compression,omitempty"`
	CertName    string      `protobuf:"bytes,5,opt,name=cert_name,json=certName,proto3" json:"cert_name,omitempty"`
	MaxSequence int64       `protobuf:"varint,6,opt,name=max_sequence,json=maxSequence,proto3" json:"max_sequence,omitempty"`
	Introducer  bool        `protobuf:"varint,7,opt,name=introducer,proto3" json:"introducer,omitempty"`
	IndexID     IndexID     `protobuf:"varint,8,opt,name=index_id,json=indexId,proto3,customtype=IndexID" json:"index_id"`
}

func (m *Device) Reset()                    { *m = Device{} }
func (m *Device) String() string            { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()               {}
func (*Device) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{4} }

type Index struct {
	Folder string     `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	Files  []FileInfo `protobuf:"bytes,2,rep,name=files" json:"files"`
}

func (m *Index) Reset()                    { *m = Index{} }
func (m *Index) String() string            { return proto.CompactTextString(m) }
func (*Index) ProtoMessage()               {}
func (*Index) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{5} }

type IndexUpdate struct {
	Folder string     `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	Files  []FileInfo `protobuf:"bytes,2,rep,name=files" json:"files"`
}

func (m *IndexUpdate) Reset()                    { *m = IndexUpdate{} }
func (m *IndexUpdate) String() string            { return proto.CompactTextString(m) }
func (*IndexUpdate) ProtoMessage()               {}
func (*IndexUpdate) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{6} }

type FileInfo struct {
	Name          string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type          FileInfoType `protobuf:"varint,2,opt,name=type,proto3,enum=protocol.FileInfoType" json:"type,omitempty"`
	Size          int64        `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	Permissions   uint32       `protobuf:"varint,4,opt,name=permissions,proto3" json:"permissions,omitempty"`
	ModifiedS     int64        `protobuf:"varint,5,opt,name=modified_s,json=modifiedS,proto3" json:"modified_s,omitempty"`
	ModifiedNs    int32        `protobuf:"varint,11,opt,name=modified_ns,json=modifiedNs,proto3" json:"modified_ns,omitempty"`
	Deleted       bool         `protobuf:"varint,6,opt,name=deleted,proto3" json:"deleted,omitempty"`
	Invalid       bool         `protobuf:"varint,7,opt,name=invalid,proto3" json:"invalid,omitempty"`
	NoPermissions bool         `protobuf:"varint,8,opt,name=no_permissions,json=noPermissions,proto3" json:"no_permissions,omitempty"`
	Version       Vector       `protobuf:"bytes,9,opt,name=version" json:"version"`
	Sequence      int64        `protobuf:"varint,10,opt,name=sequence,proto3" json:"sequence,omitempty"`
	Blocks        []BlockInfo  `protobuf:"bytes,16,rep,name=Blocks,json=blocks" json:"Blocks"`
}

func (m *FileInfo) Reset()                    { *m = FileInfo{} }
func (*FileInfo) ProtoMessage()               {}
func (*FileInfo) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{7} }

type BlockInfo struct {
	Offset int64  `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
	Size   int32  `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	Hash   []byte `protobuf:"bytes,3,opt,name=hash,proto3" json:"hash,omitempty"`
}

func (m *BlockInfo) Reset()                    { *m = BlockInfo{} }
func (*BlockInfo) ProtoMessage()               {}
func (*BlockInfo) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{8} }

type Vector struct {
	Counters []Counter `protobuf:"bytes,1,rep,name=counters" json:"counters"`
}

func (m *Vector) Reset()                    { *m = Vector{} }
func (m *Vector) String() string            { return proto.CompactTextString(m) }
func (*Vector) ProtoMessage()               {}
func (*Vector) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{9} }

type Counter struct {
	ID    ShortID `protobuf:"varint,1,opt,name=id,proto3,customtype=ShortID" json:"id"`
	Value uint64  `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Counter) Reset()                    { *m = Counter{} }
func (m *Counter) String() string            { return proto.CompactTextString(m) }
func (*Counter) ProtoMessage()               {}
func (*Counter) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{10} }

type Request struct {
	ID            int32  `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Folder        string `protobuf:"bytes,2,opt,name=folder,proto3" json:"folder,omitempty"`
	Name          string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Offset        int64  `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	Size          int32  `protobuf:"varint,5,opt,name=size,proto3" json:"size,omitempty"`
	Hash          []byte `protobuf:"bytes,6,opt,name=hash,proto3" json:"hash,omitempty"`
	FromTemporary bool   `protobuf:"varint,7,opt,name=from_temporary,json=fromTemporary,proto3" json:"from_temporary,omitempty"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (m *Request) String() string            { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{11} }

type Response struct {
	ID   int32     `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Data []byte    `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	Code ErrorCode `protobuf:"varint,3,opt,name=code,proto3,enum=protocol.ErrorCode" json:"code,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{12} }

type DownloadProgress struct {
	Folder  string                       `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	Updates []FileDownloadProgressUpdate `protobuf:"bytes,2,rep,name=updates" json:"updates"`
}

func (m *DownloadProgress) Reset()                    { *m = DownloadProgress{} }
func (m *DownloadProgress) String() string            { return proto.CompactTextString(m) }
func (*DownloadProgress) ProtoMessage()               {}
func (*DownloadProgress) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{13} }

type FileDownloadProgressUpdate struct {
	UpdateType   FileDownloadProgressUpdateType `protobuf:"varint,1,opt,name=update_type,json=updateType,proto3,enum=protocol.FileDownloadProgressUpdateType" json:"update_type,omitempty"`
	Name         string                         `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Version      Vector                         `protobuf:"bytes,3,opt,name=version" json:"version"`
	BlockIndexes []int32                        `protobuf:"varint,4,rep,name=block_indexes,json=blockIndexes" json:"block_indexes,omitempty"`
}

func (m *FileDownloadProgressUpdate) Reset()                    { *m = FileDownloadProgressUpdate{} }
func (m *FileDownloadProgressUpdate) String() string            { return proto.CompactTextString(m) }
func (*FileDownloadProgressUpdate) ProtoMessage()               {}
func (*FileDownloadProgressUpdate) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{14} }

type Ping struct {
}

func (m *Ping) Reset()                    { *m = Ping{} }
func (m *Ping) String() string            { return proto.CompactTextString(m) }
func (*Ping) ProtoMessage()               {}
func (*Ping) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{15} }

type Close struct {
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (m *Close) Reset()                    { *m = Close{} }
func (m *Close) String() string            { return proto.CompactTextString(m) }
func (*Close) ProtoMessage()               {}
func (*Close) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{16} }

func init() {
	proto.RegisterType((*Hello)(nil), "protocol.Hello")
	proto.RegisterType((*Header)(nil), "protocol.Header")
	proto.RegisterType((*ClusterConfig)(nil), "protocol.ClusterConfig")
	proto.RegisterType((*Folder)(nil), "protocol.Folder")
	proto.RegisterType((*Device)(nil), "protocol.Device")
	proto.RegisterType((*Index)(nil), "protocol.Index")
	proto.RegisterType((*IndexUpdate)(nil), "protocol.IndexUpdate")
	proto.RegisterType((*FileInfo)(nil), "protocol.FileInfo")
	proto.RegisterType((*BlockInfo)(nil), "protocol.BlockInfo")
	proto.RegisterType((*Vector)(nil), "protocol.Vector")
	proto.RegisterType((*Counter)(nil), "protocol.Counter")
	proto.RegisterType((*Request)(nil), "protocol.Request")
	proto.RegisterType((*Response)(nil), "protocol.Response")
	proto.RegisterType((*DownloadProgress)(nil), "protocol.DownloadProgress")
	proto.RegisterType((*FileDownloadProgressUpdate)(nil), "protocol.FileDownloadProgressUpdate")
	proto.RegisterType((*Ping)(nil), "protocol.Ping")
	proto.RegisterType((*Close)(nil), "protocol.Close")
	proto.RegisterEnum("protocol.MessageType", MessageType_name, MessageType_value)
	proto.RegisterEnum("protocol.MessageCompression", MessageCompression_name, MessageCompression_value)
	proto.RegisterEnum("protocol.Compression", Compression_name, Compression_value)
	proto.RegisterEnum("protocol.FileInfoType", FileInfoType_name, FileInfoType_value)
	proto.RegisterEnum("protocol.ErrorCode", ErrorCode_name, ErrorCode_value)
	proto.RegisterEnum("protocol.FileDownloadProgressUpdateType", FileDownloadProgressUpdateType_name, FileDownloadProgressUpdateType_value)
}
func (m *Hello) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Hello) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DeviceName) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.DeviceName)))
		i += copy(data[i:], m.DeviceName)
	}
	if len(m.ClientName) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.ClientName)))
		i += copy(data[i:], m.ClientName)
	}
	if len(m.ClientVersion) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintBep(data, i, uint64(len(m.ClientVersion)))
		i += copy(data[i:], m.ClientVersion)
	}
	return i, nil
}

func (m *Header) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Header) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.Type))
	}
	if m.Compression != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintBep(data, i, uint64(m.Compression))
	}
	return i, nil
}

func (m *ClusterConfig) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ClusterConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Folders) > 0 {
		for _, msg := range m.Folders {
			data[i] = 0xa
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Folder) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Folder) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	if len(m.Label) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Label)))
		i += copy(data[i:], m.Label)
	}
	if m.ReadOnly {
		data[i] = 0x18
		i++
		if m.ReadOnly {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.IgnorePermissions {
		data[i] = 0x20
		i++
		if m.IgnorePermissions {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.IgnoreDelete {
		data[i] = 0x28
		i++
		if m.IgnoreDelete {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.DisableTempIndexes {
		data[i] = 0x30
		i++
		if m.DisableTempIndexes {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.Devices) > 0 {
		for _, msg := range m.Devices {
			data[i] = 0x82
			i++
			data[i] = 0x1
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Device) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Device) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintBep(data, i, uint64(m.ID.ProtoSize()))
	n1, err := m.ID.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if len(m.Name) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			data[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.Compression != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintBep(data, i, uint64(m.Compression))
	}
	if len(m.CertName) > 0 {
		data[i] = 0x2a
		i++
		i = encodeVarintBep(data, i, uint64(len(m.CertName)))
		i += copy(data[i:], m.CertName)
	}
	if m.MaxSequence != 0 {
		data[i] = 0x30
		i++
		i = encodeVarintBep(data, i, uint64(m.MaxSequence))
	}
	if m.Introducer {
		data[i] = 0x38
		i++
		if m.Introducer {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.IndexID != 0 {
		data[i] = 0x40
		i++
		i = encodeVarintBep(data, i, uint64(m.IndexID))
	}
	return i, nil
}

func (m *Index) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Index) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Folder) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Folder)))
		i += copy(data[i:], m.Folder)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			data[i] = 0x12
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *IndexUpdate) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IndexUpdate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Folder) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Folder)))
		i += copy(data[i:], m.Folder)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			data[i] = 0x12
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *FileInfo) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FileInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if m.Type != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintBep(data, i, uint64(m.Type))
	}
	if m.Size != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintBep(data, i, uint64(m.Size))
	}
	if m.Permissions != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintBep(data, i, uint64(m.Permissions))
	}
	if m.ModifiedS != 0 {
		data[i] = 0x28
		i++
		i = encodeVarintBep(data, i, uint64(m.ModifiedS))
	}
	if m.Deleted {
		data[i] = 0x30
		i++
		if m.Deleted {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Invalid {
		data[i] = 0x38
		i++
		if m.Invalid {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.NoPermissions {
		data[i] = 0x40
		i++
		if m.NoPermissions {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	data[i] = 0x4a
	i++
	i = encodeVarintBep(data, i, uint64(m.Version.ProtoSize()))
	n2, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.Sequence != 0 {
		data[i] = 0x50
		i++
		i = encodeVarintBep(data, i, uint64(m.Sequence))
	}
	if m.ModifiedNs != 0 {
		data[i] = 0x58
		i++
		i = encodeVarintBep(data, i, uint64(m.ModifiedNs))
	}
	if len(m.Blocks) > 0 {
		for _, msg := range m.Blocks {
			data[i] = 0x82
			i++
			data[i] = 0x1
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BlockInfo) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *BlockInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Offset != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.Offset))
	}
	if m.Size != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintBep(data, i, uint64(m.Size))
	}
	if len(m.Hash) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Hash)))
		i += copy(data[i:], m.Hash)
	}
	return i, nil
}

func (m *Vector) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Vector) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Counters) > 0 {
		for _, msg := range m.Counters {
			data[i] = 0xa
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Counter) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Counter) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.ID))
	}
	if m.Value != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintBep(data, i, uint64(m.Value))
	}
	return i, nil
}

func (m *Request) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Request) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.ID))
	}
	if len(m.Folder) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Folder)))
		i += copy(data[i:], m.Folder)
	}
	if len(m.Name) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if m.Offset != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintBep(data, i, uint64(m.Offset))
	}
	if m.Size != 0 {
		data[i] = 0x28
		i++
		i = encodeVarintBep(data, i, uint64(m.Size))
	}
	if len(m.Hash) > 0 {
		data[i] = 0x32
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Hash)))
		i += copy(data[i:], m.Hash)
	}
	if m.FromTemporary {
		data[i] = 0x38
		i++
		if m.FromTemporary {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Response) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Response) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.ID))
	}
	if len(m.Data) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if m.Code != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintBep(data, i, uint64(m.Code))
	}
	return i, nil
}

func (m *DownloadProgress) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *DownloadProgress) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Folder) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Folder)))
		i += copy(data[i:], m.Folder)
	}
	if len(m.Updates) > 0 {
		for _, msg := range m.Updates {
			data[i] = 0x12
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *FileDownloadProgressUpdate) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FileDownloadProgressUpdate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.UpdateType != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.UpdateType))
	}
	if len(m.Name) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	data[i] = 0x1a
	i++
	i = encodeVarintBep(data, i, uint64(m.Version.ProtoSize()))
	n3, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if len(m.BlockIndexes) > 0 {
		for _, num := range m.BlockIndexes {
			data[i] = 0x20
			i++
			i = encodeVarintBep(data, i, uint64(num))
		}
	}
	return i, nil
}

func (m *Ping) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Ping) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *Close) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Close) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Reason) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Reason)))
		i += copy(data[i:], m.Reason)
	}
	return i, nil
}

func encodeFixed64Bep(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Bep(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintBep(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func (m *Hello) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.DeviceName)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.ClientName)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.ClientVersion)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	return n
}

func (m *Header) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovBep(uint64(m.Type))
	}
	if m.Compression != 0 {
		n += 1 + sovBep(uint64(m.Compression))
	}
	return n
}

func (m *ClusterConfig) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Folders) > 0 {
		for _, e := range m.Folders {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *Folder) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.ReadOnly {
		n += 2
	}
	if m.IgnorePermissions {
		n += 2
	}
	if m.IgnoreDelete {
		n += 2
	}
	if m.DisableTempIndexes {
		n += 2
	}
	if len(m.Devices) > 0 {
		for _, e := range m.Devices {
			l = e.ProtoSize()
			n += 2 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *Device) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ID.ProtoSize()
	n += 1 + l + sovBep(uint64(l))
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			l = len(s)
			n += 1 + l + sovBep(uint64(l))
		}
	}
	if m.Compression != 0 {
		n += 1 + sovBep(uint64(m.Compression))
	}
	l = len(m.CertName)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.MaxSequence != 0 {
		n += 1 + sovBep(uint64(m.MaxSequence))
	}
	if m.Introducer {
		n += 2
	}
	if m.IndexID != 0 {
		n += 1 + sovBep(uint64(m.IndexID))
	}
	return n
}

func (m *Index) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Folder)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *IndexUpdate) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Folder)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *FileInfo) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovBep(uint64(m.Type))
	}
	if m.Size != 0 {
		n += 1 + sovBep(uint64(m.Size))
	}
	if m.Permissions != 0 {
		n += 1 + sovBep(uint64(m.Permissions))
	}
	if m.ModifiedS != 0 {
		n += 1 + sovBep(uint64(m.ModifiedS))
	}
	if m.Deleted {
		n += 2
	}
	if m.Invalid {
		n += 2
	}
	if m.NoPermissions {
		n += 2
	}
	l = m.Version.ProtoSize()
	n += 1 + l + sovBep(uint64(l))
	if m.Sequence != 0 {
		n += 1 + sovBep(uint64(m.Sequence))
	}
	if m.ModifiedNs != 0 {
		n += 1 + sovBep(uint64(m.ModifiedNs))
	}
	if len(m.Blocks) > 0 {
		for _, e := range m.Blocks {
			l = e.ProtoSize()
			n += 2 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *BlockInfo) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Offset != 0 {
		n += 1 + sovBep(uint64(m.Offset))
	}
	if m.Size != 0 {
		n += 1 + sovBep(uint64(m.Size))
	}
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	return n
}

func (m *Vector) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Counters) > 0 {
		for _, e := range m.Counters {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *Counter) ProtoSize() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovBep(uint64(m.ID))
	}
	if m.Value != 0 {
		n += 1 + sovBep(uint64(m.Value))
	}
	return n
}

func (m *Request) ProtoSize() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovBep(uint64(m.ID))
	}
	l = len(m.Folder)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.Offset != 0 {
		n += 1 + sovBep(uint64(m.Offset))
	}
	if m.Size != 0 {
		n += 1 + sovBep(uint64(m.Size))
	}
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.FromTemporary {
		n += 2
	}
	return n
}

func (m *Response) ProtoSize() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovBep(uint64(m.ID))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.Code != 0 {
		n += 1 + sovBep(uint64(m.Code))
	}
	return n
}

func (m *DownloadProgress) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Folder)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if len(m.Updates) > 0 {
		for _, e := range m.Updates {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *FileDownloadProgressUpdate) ProtoSize() (n int) {
	var l int
	_ = l
	if m.UpdateType != 0 {
		n += 1 + sovBep(uint64(m.UpdateType))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = m.Version.ProtoSize()
	n += 1 + l + sovBep(uint64(l))
	if len(m.BlockIndexes) > 0 {
		for _, e := range m.BlockIndexes {
			n += 1 + sovBep(uint64(e))
		}
	}
	return n
}

func (m *Ping) ProtoSize() (n int) {
	var l int
	_ = l
	return n
}

func (m *Close) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	return n
}

func sovBep(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBep(x uint64) (n int) {
	return sovBep(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Hello) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Hello: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Hello: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeviceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeviceName = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientName = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientVersion = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Header) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Type |= (MessageType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compression", wireType)
			}
			m.Compression = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Compression |= (MessageCompression(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folders = append(m.Folders, Folder{})
			if err := m.Folders[len(m.Folders)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Folder) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Folder: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Folder: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReadOnly = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IgnorePermissions", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IgnorePermissions = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IgnoreDelete", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IgnoreDelete = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableTempIndexes", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableTempIndexes = bool(v != 0)
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Devices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Devices = append(m.Devices, Device{})
			if err := m.Devices[len(m.Devices)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Device) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Device: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Device: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ID.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compression", wireType)
			}
			m.Compression = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Compression |= (Compression(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertName = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSequence", wireType)
			}
			m.MaxSequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.MaxSequence |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Introducer", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Introducer = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexID", wireType)
			}
			m.IndexID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.IndexID |= (IndexID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Index) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Index: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Index: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folder", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folder = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, FileInfo{})
			if err := m.Files[len(m.Files)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IndexUpdate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folder", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folder = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, FileInfo{})
			if err := m.Files[len(m.Files)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Type |= (FileInfoType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size", wireType)
			}
			m.Size = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Size |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			m.Permissions = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Permissions |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModifiedS", wireType)
			}
			m.ModifiedS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ModifiedS |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Deleted = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Invalid", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Invalid = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoPermissions", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoPermissions = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Sequence |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModifiedNs", wireType)
			}
			m.ModifiedNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ModifiedNs |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blocks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Blocks = append(m.Blocks, BlockInfo{})
			if err := m.Blocks[len(m.Blocks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BlockInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BlockInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BlockInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Offset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size", wireType)
			}
			m.Size = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Size |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], data[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Vector) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Vector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Vector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Counters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Counters = append(m.Counters, Counter{})
			if err := m.Counters[len(m.Counters)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Counter) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Counter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Counter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (ShortID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Value |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Request) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folder", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folder = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Offset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size", wireType)
			}
			m.Size = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Size |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], data[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromTemporary", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FromTemporary = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], data[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Code |= (ErrorCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DownloadProgress) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DownloadProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DownloadProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folder", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folder = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Updates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Updates = append(m.Updates, FileDownloadProgressUpdate{})
			if err := m.Updates[len(m.Updates)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileDownloadProgressUpdate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileDownloadProgressUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileDownloadProgressUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateType", wireType)
			}
			m.UpdateType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.UpdateType |= (FileDownloadProgressUpdateType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockIndexes", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BlockIndexes = append(m.BlockIndexes, v)
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Ping) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Close) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Close: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Close: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBep(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBep
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBep
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBep
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBep
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBep
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBep(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBep = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBep   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorBep = []byte{
	// 1598 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x57, 0xcd, 0x6e, 0xdb, 0xc6,
	0x16, 0xb6, 0x24, 0xea, 0x6f, 0x24, 0x3b, 0xf2, 0xc4, 0x71, 0x74, 0x19, 0xc7, 0xf6, 0x65, 0x92,
	0x7b, 0x7d, 0x85, 0x1b, 0xe7, 0xde, 0xa4, 0x6d, 0x80, 0x02, 0x2d, 0x20, 0x4b, 0xb4, 0x23, 0x44,
	0xa6, 0x14, 0x4a, 0x72, 0x9a, 0x2e, 0x2a, 0x48, 0xe2, 0x48, 0x26, 0x42, 0x71, 0x54, 0x52, 0x4a,
	0xe2, 0x3e, 0x42, 0xfb, 0x02, 0xdd, 0x14, 0x08, 0xba, 0xeb, 0xb6, 0xe8, 0x43, 0x64, 0x19, 0x64,
	0xd9, 0x45, 0xd0, 0xa6, 0x9b, 0xbe, 0x40, 0xf7, 0x3d, 0x3c, 0x43, 0x52, 0x94, 0x7f, 0x8a, 0x2c,
	0xba, 0x30, 0x34, 0x73, 0xce, 0x37, 0xe7, 0xcc, 0xf9, 0xce, 0xcf, 0xd0, 0x24, 0xdb, 0x67, 0x93,
	0xdd, 0x89, 0xc3, 0xa7, 0x9c, 0x66, 0xf0, 0x67, 0xc0, 0x2d, 0xf9, 0xf6, 0xc8, 0x9c, 0x1e, 0xcf,
	0xfa, 0xbb, 0x03, 0x3e, 0xbe, 0x33, 0xe2, 0x23, 0x7e, 0x07, 0x35, 0xfd, 0xd9, 0x10, 0x77, 0xb8,
	0xc1, 0x95, 0x38, 0xa8, 0x4c, 0x48, 0xf2, 0x01, 0xb3, 0x2c, 0x4e, 0xb7, 0x48, 0xce, 0x60, 0xcf,
	0xcc, 0x01, 0xeb, 0xda, 0xbd, 0x31, 0x2b, 0xc6, 0xb6, 0x63, 0x3b, 0x59, 0x9d, 0x08, 0x91, 0x06,
	0x12, 0x0f, 0x30, 0xb0, 0x4c, 0x66, 0x4f, 0x05, 0x20, 0x2e, 0x00, 0x42, 0x84, 0x80, 0x5b, 0x64,
	0xc5, 0x07, 0x3c, 0x63, 0x8e, 0x6b, 0x72, 0xbb, 0x98, 0x40, 0xcc, 0xb2, 0x90, 0x1e, 0x09, 0xa1,
	0xe2, 0x92, 0xd4, 0x03, 0xd6, 0x33, 0x98, 0x43, 0xff, 0x43, 0xa4, 0xe9, 0xc9, 0x44, 0xf8, 0x5a,
	0xb9, 0x7b, 0x65, 0x37, 0x88, 0x61, 0xf7, 0x90, 0xb9, 0x6e, 0x6f, 0xc4, 0xda, 0xa0, 0xd4, 0x11,
	0x42, 0x3f, 0x05, 0xe7, 0x7c, 0x3c, 0x71, 0x40, 0xe1, 0x19, 0x8e, 0xe3, 0x89, 0x8d, 0x33, 0x27,
	0x2a, 0x73, 0x8c, 0x1e, 0x3d, 0xa0, 0x94, 0xc9, 0x72, 0xc5, 0x9a, 0xb9, 0x53, 0xe6, 0x54, 0xb8,
	0x3d, 0x34, 0x47, 0xf4, 0x7f, 0x24, 0x3d, 0xe4, 0x16, 0xdc, 0xc2, 0x05, 0xf7, 0x89, 0x9d, 0xdc,
	0xdd, 0xc2, 0xdc, 0xd8, 0x3e, 0x2a, 0xf6, 0xa4, 0x57, 0x6f, 0xb7, 0x96, 0xf4, 0x00, 0xa6, 0x7c,
	0x13, 0x27, 0x29, 0xa1, 0xa1, 0xeb, 0x24, 0x6e, 0x1a, 0x82, 0xa2, 0xbd, 0xd4, 0xbb, 0xb7, 0x5b,
	0xf1, 0x5a, 0x55, 0x07, 0x09, 0x5d, 0x23, 0x49, 0xab, 0xd7, 0x67, 0x96, 0x4f, 0x8e, 0xd8, 0xd0,
	0x6b, 0x24, 0xeb, 0x40, 0xc0, 0x5d, 0x6e, 0x5b, 0x27, 0x48, 0x49, 0x46, 0xcf, 0x78, 0x82, 0x06,
	0xec, 0xe9, 0x6d, 0x42, 0xcd, 0x91, 0xcd, 0x1d, 0xd6, 0x9d, 0x30, 0x67, 0x6c, 0xe2, 0x6d, 0xdd,
	0xa2, 0x84, 0xa8, 0x55, 0xa1, 0x69, 0xce, 0x15, 0xf4, 0x06, 0x59, 0xf6, 0xe1, 0x06, 0xb3, 0xd8,
	0x94, 0x15, 0x93, 0x88, 0xcc, 0x0b, 0x61, 0x15, 0x65, 0x10, 0xdb, 0x9a, 0x61, 0xba, 0xbd, 0xbe,
	0xc5, 0xba, 0x53, 0x36, 0x9e, 0x74, 0x4d, 0xdb, 0x60, 0x2f, 0x98, 0x5b, 0x4c, 0x21, 0x96, 0xfa,
	0xba, 0x36, 0xa8, 0x6a, 0x42, 0xe3, 0xb1, 0x21, 0x32, 0xed, 0x16, 0x0b, 0xa7, 0xd9, 0xa8, 0xa2,
	0x22, 0x60, 0xc3, 0x87, 0x29, 0x3f, 0x02, 0x1b, 0x42, 0x43, 0xff, 0x15, 0xb2, 0x91, 0xdf, 0x5b,
	0xf7, 0x50, 0x3f, 0xbf, 0xdd, 0xca, 0x08, 0x5d, 0xad, 0x1a, 0x61, 0x87, 0x12, 0x29, 0x52, 0x39,
	0xb8, 0xa6, 0x1b, 0x24, 0xdb, 0x33, 0x0c, 0x2f, 0x4b, 0xe0, 0x3a, 0x01, 0xae, 0xb3, 0xfa, 0x5c,
	0x40, 0xef, 0x2f, 0x66, 0x5d, 0x3a, 0x5d, 0x27, 0x17, 0xa5, 0xdb, 0xa3, 0x7c, 0xc0, 0x1c, 0xbf,
	0x52, 0x93, 0xe8, 0x2f, 0xe3, 0x09, 0xb0, 0x4e, 0xff, 0x49, 0xf2, 0xe3, 0xde, 0x8b, 0xae, 0xcb,
	0xbe, 0x9c, 0x31, 0x7b, 0xc0, 0x90, 0x96, 0x84, 0x9e, 0x03, 0x59, 0xcb, 0x17, 0xd1, 0x4d, 0x42,
	0x4c, 0x7b, 0xea, 0x70, 0x63, 0x06, 0xa7, 0x8a, 0x69, 0xe4, 0x2d, 0x22, 0xa1, 0x1f, 0x92, 0x0c,
	0x92, 0xda, 0x85, 0xc0, 0x33, 0xa0, 0x95, 0xf6, 0x64, 0x3f, 0xf0, 0x34, 0x52, 0x8a, 0x71, 0x07,
	0x4b, 0x3d, 0x8d, 0xd8, 0x9a, 0xa1, 0x34, 0x48, 0x12, 0x65, 0x50, 0x40, 0x29, 0x51, 0x56, 0x7e,
	0x9f, 0xf9, 0x3b, 0xba, 0x4b, 0x92, 0x43, 0xd3, 0x02, 0x2a, 0xe2, 0x98, 0x05, 0x1a, 0xa9, 0x49,
	0x10, 0xd7, 0xec, 0x21, 0xf7, 0xf3, 0x20, 0x60, 0x4a, 0x87, 0xe4, 0xd0, 0x60, 0x67, 0x62, 0xf4,
	0x20, 0xf1, 0x7f, 0x97, 0xd9, 0xef, 0x13, 0x24, 0x13, 0x68, 0xc2, 0xb4, 0xc5, 0x22, 0x69, 0x2b,
	0xf9, 0x9d, 0x2b, 0xfa, 0x70, 0xfd, 0xac, 0xbd, 0x48, 0xeb, 0xc2, 0x79, 0xd7, 0xfc, 0x8a, 0x61,
	0xe5, 0x27, 0x74, 0x5c, 0xd3, 0x6d, 0x92, 0x3b, 0x5d, 0xee, 0xcb, 0x7a, 0x54, 0x44, 0xaf, 0x13,
	0x32, 0xe6, 0x86, 0x39, 0x34, 0x99, 0xd1, 0x75, 0x31, 0x85, 0x09, 0x3d, 0x1b, 0x48, 0x5a, 0xb4,
	0xe8, 0x15, 0xac, 0x57, 0xec, 0x86, 0x5f, 0xd5, 0xc1, 0xd6, 0xd3, 0x98, 0xf6, 0xb3, 0x9e, 0x05,
	0x99, 0x11, 0x79, 0x0b, 0xb6, 0xde, 0x7c, 0xb2, 0xf9, 0x42, 0x9b, 0x65, 0x10, 0xb0, 0x6c, 0xf3,
	0x68, 0x8b, 0x41, 0x2f, 0x04, 0xf3, 0x2b, 0x0b, 0xfa, 0x85, 0x5e, 0x38, 0x62, 0x83, 0x29, 0x0f,
	0x27, 0x83, 0x0f, 0xa3, 0x32, 0xc9, 0x84, 0xc5, 0x44, 0xf0, 0xa6, 0xe1, 0xde, 0x9b, 0x9a, 0x61,
	0x1c, 0xe0, 0x31, 0x07, 0xea, 0xa4, 0x1e, 0x86, 0xa6, 0xb9, 0xf4, 0xff, 0x24, 0xb5, 0x67, 0xf1,
	0xc1, 0xd3, 0xa0, 0xf3, 0x2e, 0xcf, 0xbd, 0xa1, 0x3c, 0x92, 0x9d, 0x54, 0x1f, 0x81, 0x1f, 0x4b,
	0xdf, 0xbe, 0xdc, 0x5a, 0x52, 0x1e, 0x91, 0x6c, 0x08, 0xf0, 0x32, 0xcf, 0x87, 0x43, 0x97, 0x4d,
	0x31, 0x4d, 0x09, 0xdd, 0xdf, 0x85, 0xe4, 0xc7, 0xd1, 0xaf, 0x20, 0x1f, 0x64, 0xc7, 0x3d, 0xf7,
	0x18, 0x13, 0x92, 0xd7, 0x71, 0xed, 0x9b, 0xfc, 0x84, 0xa4, 0x44, 0x84, 0xf4, 0x1e, 0xc9, 0x0c,
	0xf8, 0xcc, 0x9e, 0xce, 0xe7, 0xe3, 0x6a, 0xb4, 0xed, 0x50, 0xe3, 0xdf, 0x2a, 0x04, 0x2a, 0xfb,
	0x24, 0xed, 0xab, 0x80, 0xeb, 0x60, 0x26, 0x48, 0x7b, 0x57, 0x82, 0xd6, 0x68, 0x1d, 0x73, 0x67,
	0xba, 0x30, 0x12, 0x60, 0x60, 0x42, 0x6e, 0x66, 0xe2, 0x7e, 0x92, 0x2e, 0x36, 0xca, 0x4f, 0x31,
	0x92, 0xd6, 0x3d, 0x02, 0xdd, 0x69, 0x64, 0xd4, 0x26, 0x17, 0x46, 0xed, 0xbc, 0xd4, 0xe3, 0x0b,
	0xa5, 0x1e, 0x54, 0x6b, 0x22, 0x52, 0xad, 0x73, 0x72, 0xa4, 0x73, 0xc9, 0x49, 0x9e, 0x43, 0x4e,
	0x6a, 0x4e, 0x8e, 0x57, 0x38, 0x43, 0x87, 0x8f, 0x71, 0x98, 0x72, 0xa7, 0xe7, 0x9c, 0xf8, 0x95,
	0xb5, 0xec, 0x49, 0xdb, 0x81, 0x50, 0xe9, 0x92, 0x8c, 0xce, 0xdc, 0x09, 0xd4, 0x10, 0xbb, 0xf0,
	0xda, 0x60, 0x1e, 0x3a, 0xb5, 0x87, 0x97, 0x06, 0xf3, 0xde, 0x9a, 0xfe, 0x9b, 0x48, 0x03, 0x6e,
	0x88, 0x2b, 0xaf, 0x44, 0xf3, 0xaf, 0x3a, 0x0e, 0x87, 0xf7, 0xca, 0x80, 0x4e, 0xf2, 0x00, 0xf0,
	0x56, 0x17, 0xaa, 0xfc, 0xb9, 0x6d, 0xf1, 0x9e, 0xd1, 0x74, 0xf8, 0xc8, 0x1b, 0x76, 0x17, 0xb6,
	0x7c, 0x95, 0xa4, 0x67, 0x38, 0x14, 0x82, 0xa6, 0xbf, 0xb9, 0xd8, 0xa4, 0xa7, 0x0d, 0x89, 0x09,
	0x12, 0x54, 0xb6, 0x7f, 0x54, 0x79, 0x13, 0x23, 0xf2, 0xc5, 0x68, 0x5a, 0x23, 0x39, 0x81, 0xec,
	0x46, 0xde, 0xf1, 0x9d, 0xf7, 0x71, 0x84, 0xf3, 0x81, 0xcc, 0xc2, 0xf5, 0xb9, 0x8f, 0x43, 0xa4,
	0x13, 0x13, 0xef, 0xd7, 0x89, 0xf0, 0x3c, 0x62, 0x8f, 0x84, 0x4f, 0x9e, 0x04, 0xb1, 0x27, 0xf5,
	0x7c, 0x5f, 0x34, 0x0a, 0xca, 0x94, 0x14, 0x91, 0x9a, 0xa6, 0x3d, 0x52, 0xb6, 0x48, 0xb2, 0x62,
	0x71, 0x4c, 0x56, 0x0a, 0xde, 0x63, 0x17, 0xdc, 0xf8, 0x1c, 0x8a, 0x5d, 0xe9, 0x4d, 0x9c, 0xe4,
	0x22, 0x9f, 0x22, 0x70, 0x9f, 0x95, 0x4a, 0xbd, 0xd3, 0x6a, 0xab, 0x7a, 0xb7, 0xd2, 0xd0, 0xf6,
	0x6b, 0x07, 0x85, 0x25, 0x79, 0xe3, 0xeb, 0xef, 0xb6, 0x8b, 0xe3, 0x39, 0x68, 0xf1, 0x2b, 0x03,
	0x5c, 0xd4, 0xb4, 0xaa, 0xfa, 0x59, 0x21, 0x26, 0xaf, 0x01, 0xb0, 0x10, 0x01, 0x8a, 0x87, 0xe0,
	0xbf, 0x24, 0x8f, 0x80, 0x6e, 0xa7, 0x59, 0x2d, 0xb7, 0xd5, 0x42, 0x5c, 0x96, 0x01, 0xb7, 0x7e,
	0x1a, 0xe7, 0xf3, 0x7d, 0x03, 0xfa, 0x42, 0x7d, 0xd4, 0x51, 0x5b, 0xed, 0x42, 0x42, 0x5e, 0x07,
	0x20, 0x8d, 0x00, 0x83, 0x8e, 0xb9, 0x05, 0x65, 0xa8, 0xb6, 0x9a, 0x0d, 0xad, 0xa5, 0x16, 0x24,
	0xf9, 0x2a, 0xa0, 0x2e, 0x2f, 0xa0, 0xfc, 0x0a, 0xfd, 0x88, 0xac, 0x56, 0x1b, 0x8f, 0xb5, 0x7a,
	0xa3, 0x5c, 0xed, 0x36, 0xf5, 0xc6, 0x01, 0x9c, 0x69, 0x15, 0x92, 0xf2, 0x16, 0xe0, 0xaf, 0x45,
	0xf0, 0x67, 0x0a, 0xee, 0x3a, 0xb0, 0x57, 0xd3, 0x0e, 0x0a, 0x29, 0xf9, 0x32, 0x40, 0x2f, 0x45,
	0xa0, 0x1e, 0xa9, 0x5e, 0xc4, 0x95, 0x7a, 0x03, 0x5c, 0xa7, 0xcf, 0x44, 0x8c, 0x64, 0x97, 0xbe,
	0x20, 0xf4, 0xec, 0xc7, 0x1a, 0xbd, 0x49, 0x24, 0xad, 0xa1, 0xa9, 0x40, 0x28, 0xc6, 0x7f, 0x16,
	0xa1, 0x71, 0x9b, 0x51, 0x85, 0x24, 0xea, 0x9f, 0x7f, 0x00, 0x64, 0xfe, 0x03, 0x40, 0x57, 0xce,
	0x82, 0x40, 0x59, 0xe2, 0x24, 0x17, 0x35, 0xac, 0x90, 0xcc, 0xa1, 0xda, 0x2e, 0x03, 0xb9, 0x65,
	0x30, 0x8e, 0x57, 0x0a, 0xd4, 0x87, 0x6c, 0xda, 0xc3, 0x06, 0xdc, 0x20, 0x49, 0x4d, 0x3d, 0x52,
	0x75, 0x30, 0xbc, 0x0a, 0x80, 0xe5, 0x00, 0xa0, 0x31, 0xa8, 0x2b, 0xf8, 0x16, 0x48, 0x95, 0xeb,
	0x8f, 0xcb, 0x4f, 0x5a, 0x90, 0x1c, 0x0a, 0xea, 0x95, 0x40, 0x5d, 0xb6, 0x9e, 0xf7, 0x4e, 0xdc,
	0xd2, 0x1f, 0x31, 0x92, 0x8f, 0x3e, 0x7b, 0x70, 0x40, 0xda, 0xaf, 0xd5, 0xd5, 0xc0, 0x5d, 0x54,
	0xe7, 0xad, 0xe9, 0x0e, 0xc9, 0x56, 0x6b, 0xba, 0x5a, 0x69, 0x37, 0xf4, 0x27, 0x41, 0x2c, 0x51,
	0x50, 0xd5, 0x74, 0xb0, 0xb8, 0xbd, 0x8f, 0xc3, 0x7c, 0xeb, 0xc9, 0x61, 0xbd, 0xa6, 0x3d, 0xec,
	0xa2, 0xc5, 0xb8, 0x7c, 0x0d, 0xc0, 0x57, 0xa3, 0xe0, 0xd6, 0xc9, 0xd8, 0x32, 0xed, 0xa7, 0x68,
	0xf8, 0x3e, 0x59, 0x0d, 0xe0, 0x73, 0x07, 0x09, 0x79, 0x1b, 0xce, 0x6c, 0x9c, 0x73, 0x66, 0xee,
	0xe7, 0x1e, 0xb9, 0x14, 0x1c, 0xec, 0x68, 0x0f, 0x35, 0x28, 0x0b, 0xa8, 0x9c, 0x4d, 0x38, 0x26,
	0x9f, 0x73, 0xac, 0x63, 0x3f, 0xb5, 0xa1, 0x28, 0x4a, 0x3f, 0xc4, 0x48, 0x36, 0x9c, 0x50, 0x1e,
	0xcf, 0x5a, 0xa3, 0xab, 0xea, 0x7a, 0x43, 0x0f, 0x02, 0x0f, 0x95, 0x1a, 0xc7, 0x25, 0x7c, 0x78,
	0xa5, 0x0f, 0x54, 0x4d, 0xd5, 0x6b, 0x95, 0xa0, 0x1f, 0x42, 0xc8, 0x01, 0xb3, 0x99, 0x63, 0x0e,
	0xe0, 0x5f, 0x82, 0x3c, 0x98, 0x69, 0x75, 0x2a, 0x0f, 0x82, 0x88, 0xb1, 0x80, 0x23, 0xa6, 0x5a,
	0xb3, 0xc1, 0x31, 0x46, 0x5b, 0xf2, 0x5a, 0xe7, 0xa8, 0x5c, 0xaf, 0x55, 0x05, 0x34, 0x21, 0x17,
	0x01, 0xba, 0x16, 0x42, 0x6b, 0xe2, 0xd9, 0xf7, 0xb0, 0x25, 0x83, 0x6c, 0xfe, 0xf5, 0x2c, 0x82,
	0x2f, 0x92, 0x54, 0xb9, 0xd9, 0x54, 0xb5, 0x6a, 0x70, 0xfb, 0xb9, 0xae, 0x3c, 0x99, 0x30, 0xdb,
	0xf0, 0x10, 0xfb, 0x0d, 0xfd, 0x40, 0x6d, 0x07, 0x97, 0x9f, 0x23, 0xf6, 0xb9, 0x33, 0x62, 0xd3,
	0xbd, 0x8d, 0x57, 0xbf, 0x6e, 0x2e, 0xbd, 0x86, 0xbf, 0x57, 0xef, 0x36, 0x63, 0xaf, 0xe1, 0xef,
	0x97, 0x77, 0x9b, 0x4b, 0xbf, 0xc3, 0xef, 0xcb, 0xdf, 0x36, 0x63, 0xfd, 0x14, 0xce, 0xae, 0x7b,
	0x7f, 0x06, 0x00, 0x00, 0xff, 0xff, 0x96, 0x0b, 0xf7, 0x15, 0xb6, 0x0d, 0x00, 0x00,
}
