// Code generated by protoc-gen-gogo.
// source: bep.proto
// DO NOT EDIT!

/*
	Package protocol is a generated protocol buffer package.

	It is generated from these files:
		bep.proto

	It has these top-level messages:
		Hello
		Header
		ClusterConfig
		Folder
		Device
		Index
		IndexUpdate
		FileInfo
		BlockInfo
		Vector
		Counter
		Request
		Response
		DownloadProgress
		FileDownloadProgressUpdate
		Ping
		Close
*/
package protocol

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.GoGoProtoPackageIsVersion1

type MessageType int32

const (
	messageTypeClusterConfig    MessageType = 0
	messageTypeIndex            MessageType = 1
	messageTypeIndexUpdate      MessageType = 2
	messageTypeRequest          MessageType = 3
	messageTypeResponse         MessageType = 4
	messageTypeDownloadProgress MessageType = 5
	messageTypePing             MessageType = 6
	messageTypeClose            MessageType = 7
)

var MessageType_name = map[int32]string{
	0: "CLUSTER_CONFIG",
	1: "INDEX",
	2: "INDEX_UPDATE",
	3: "REQUEST",
	4: "RESPONSE",
	5: "DOWNLOAD_PROGRESS",
	6: "PING",
	7: "CLOSE",
}
var MessageType_value = map[string]int32{
	"CLUSTER_CONFIG":    0,
	"INDEX":             1,
	"INDEX_UPDATE":      2,
	"REQUEST":           3,
	"RESPONSE":          4,
	"DOWNLOAD_PROGRESS": 5,
	"PING":              6,
	"CLOSE":             7,
}

func (x MessageType) String() string {
	return proto.EnumName(MessageType_name, int32(x))
}
func (MessageType) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{0} }

type MessageCompression int32

const (
	MessageCompressionNone MessageCompression = 0
	MessageCompressionLZ4  MessageCompression = 1
)

var MessageCompression_name = map[int32]string{
	0: "NONE",
	1: "LZ4",
}
var MessageCompression_value = map[string]int32{
	"NONE": 0,
	"LZ4":  1,
}

func (x MessageCompression) String() string {
	return proto.EnumName(MessageCompression_name, int32(x))
}
func (MessageCompression) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{1} }

type Compression int32

const (
	CompressMetadata Compression = 0
	CompressNever    Compression = 1
	CompressAlways   Compression = 2
)

var Compression_name = map[int32]string{
	0: "METADATA",
	1: "NEVER",
	2: "ALWAYS",
}
var Compression_value = map[string]int32{
	"METADATA": 0,
	"NEVER":    1,
	"ALWAYS":   2,
}

func (x Compression) String() string {
	return proto.EnumName(Compression_name, int32(x))
}
func (Compression) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{2} }

type FileInfoType int32

const (
	FileInfoTypeFile             FileInfoType = 0
	FileInfoTypeDirectory        FileInfoType = 1
	FileInfoTypeSymlinkFile      FileInfoType = 2
	FileInfoTypeSymlinkDirectory FileInfoType = 3
	FileInfoTypeSymlinkUnknown   FileInfoType = 4
)

var FileInfoType_name = map[int32]string{
	0: "FILE",
	1: "DIRECTORY",
	2: "SYMLINK_FILE",
	3: "SYMLINK_DIRECTORY",
	4: "SYMLINK_UNKNOWN",
}
var FileInfoType_value = map[string]int32{
	"FILE":              0,
	"DIRECTORY":         1,
	"SYMLINK_FILE":      2,
	"SYMLINK_DIRECTORY": 3,
	"SYMLINK_UNKNOWN":   4,
}

func (x FileInfoType) String() string {
	return proto.EnumName(FileInfoType_name, int32(x))
}
func (FileInfoType) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{3} }

type ErrorCode int32

const (
	ErrorCodeNoError     ErrorCode = 0
	ErrorCodeGeneric     ErrorCode = 1
	ErrorCodeNoSuchFile  ErrorCode = 2
	ErrorCodeInvalidFile ErrorCode = 3
)

var ErrorCode_name = map[int32]string{
	0: "NO_ERROR",
	1: "GENERIC",
	2: "NO_SUCH_FILE",
	3: "INVALID_FILE",
}
var ErrorCode_value = map[string]int32{
	"NO_ERROR":     0,
	"GENERIC":      1,
	"NO_SUCH_FILE": 2,
	"INVALID_FILE": 3,
}

func (x ErrorCode) String() string {
	return proto.EnumName(ErrorCode_name, int32(x))
}
func (ErrorCode) EnumDescriptor() ([]byte, []int) { return fileDescriptorBep, []int{4} }

type FileDownloadProgressUpdateType int32

const (
	UpdateTypeAppend FileDownloadProgressUpdateType = 0
	UpdateTypeForget FileDownloadProgressUpdateType = 1
)

var FileDownloadProgressUpdateType_name = map[int32]string{
	0: "APPEND",
	1: "FORGET",
}
var FileDownloadProgressUpdateType_value = map[string]int32{
	"APPEND": 0,
	"FORGET": 1,
}

func (x FileDownloadProgressUpdateType) String() string {
	return proto.EnumName(FileDownloadProgressUpdateType_name, int32(x))
}
func (FileDownloadProgressUpdateType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorBep, []int{5}
}

type Hello struct {
	DeviceName    string `protobuf:"bytes,1,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	ClientName    string `protobuf:"bytes,2,opt,name=client_name,json=clientName,proto3" json:"client_name,omitempty"`
	ClientVersion string `protobuf:"bytes,3,opt,name=client_version,json=clientVersion,proto3" json:"client_version,omitempty"`
}

func (m *Hello) Reset()                    { *m = Hello{} }
func (m *Hello) String() string            { return proto.CompactTextString(m) }
func (*Hello) ProtoMessage()               {}
func (*Hello) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{0} }

type Header struct {
	Type        MessageType        `protobuf:"varint,1,opt,name=type,proto3,enum=protocol.MessageType" json:"type,omitempty"`
	Compression MessageCompression `protobuf:"varint,2,opt,name=compression,proto3,enum=protocol.MessageCompression" json:"compression,omitempty"`
}

func (m *Header) Reset()                    { *m = Header{} }
func (m *Header) String() string            { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()               {}
func (*Header) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{1} }

type ClusterConfig struct {
	Folders []Folder `protobuf:"bytes,1,rep,name=folders" json:"folders"`
}

func (m *ClusterConfig) Reset()                    { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()               {}
func (*ClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{2} }

type Folder struct {
	ID                 string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Label              string   `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	ReadOnly           bool     `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	IgnorePermissions  bool     `protobuf:"varint,4,opt,name=ignore_permissions,json=ignorePermissions,proto3" json:"ignore_permissions,omitempty"`
	IgnoreDelete       bool     `protobuf:"varint,5,opt,name=ignore_delete,json=ignoreDelete,proto3" json:"ignore_delete,omitempty"`
	DisableTempIndexes bool     `protobuf:"varint,6,opt,name=disable_temp_indexes,json=disableTempIndexes,proto3" json:"disable_temp_indexes,omitempty"`
	Devices            []Device `protobuf:"bytes,16,rep,name=devices" json:"devices"`
}

func (m *Folder) Reset()                    { *m = Folder{} }
func (m *Folder) String() string            { return proto.CompactTextString(m) }
func (*Folder) ProtoMessage()               {}
func (*Folder) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{3} }

type Device struct {
	ID              []byte      `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name            string      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Addresses       []string    `protobuf:"bytes,3,rep,name=addresses" json:"addresses,omitempty"`
	Compression     Compression `protobuf:"varint,4,opt,name=compression,proto3,enum=protocol.Compression" json:"compression,omitempty"`
	CertName        string      `protobuf:"bytes,5,opt,name=cert_name,json=certName,proto3" json:"cert_name,omitempty"`
	MaxLocalVersion int64       `protobuf:"varint,6,opt,name=max_local_version,json=maxLocalVersion,proto3" json:"max_local_version,omitempty"`
	Introducer      bool        `protobuf:"varint,7,opt,name=introducer,proto3" json:"introducer,omitempty"`
}

func (m *Device) Reset()                    { *m = Device{} }
func (m *Device) String() string            { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()               {}
func (*Device) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{4} }

type Index struct {
	Folder string     `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	Files  []FileInfo `protobuf:"bytes,2,rep,name=files" json:"files"`
}

func (m *Index) Reset()                    { *m = Index{} }
func (m *Index) String() string            { return proto.CompactTextString(m) }
func (*Index) ProtoMessage()               {}
func (*Index) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{5} }

type IndexUpdate struct {
	Folder string     `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	Files  []FileInfo `protobuf:"bytes,2,rep,name=files" json:"files"`
}

func (m *IndexUpdate) Reset()                    { *m = IndexUpdate{} }
func (m *IndexUpdate) String() string            { return proto.CompactTextString(m) }
func (*IndexUpdate) ProtoMessage()               {}
func (*IndexUpdate) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{6} }

type FileInfo struct {
	Name          string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type          FileInfoType `protobuf:"varint,2,opt,name=type,proto3,enum=protocol.FileInfoType" json:"type,omitempty"`
	Size          int64        `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	Permissions   uint32       `protobuf:"varint,4,opt,name=permissions,proto3" json:"permissions,omitempty"`
	Modified      int64        `protobuf:"varint,5,opt,name=modified,proto3" json:"modified,omitempty"`
	Deleted       bool         `protobuf:"varint,6,opt,name=deleted,proto3" json:"deleted,omitempty"`
	Invalid       bool         `protobuf:"varint,7,opt,name=invalid,proto3" json:"invalid,omitempty"`
	NoPermissions bool         `protobuf:"varint,8,opt,name=no_permissions,json=noPermissions,proto3" json:"no_permissions,omitempty"`
	Version       Vector       `protobuf:"bytes,9,opt,name=version" json:"version"`
	LocalVersion  int64        `protobuf:"varint,10,opt,name=local_version,json=localVersion,proto3" json:"local_version,omitempty"`
	Blocks        []BlockInfo  `protobuf:"bytes,16,rep,name=Blocks,json=blocks" json:"Blocks"`
}

func (m *FileInfo) Reset()                    { *m = FileInfo{} }
func (*FileInfo) ProtoMessage()               {}
func (*FileInfo) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{7} }

type BlockInfo struct {
	Offset int64  `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
	Size   int32  `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	Hash   []byte `protobuf:"bytes,3,opt,name=hash,proto3" json:"hash,omitempty"`
}

func (m *BlockInfo) Reset()                    { *m = BlockInfo{} }
func (*BlockInfo) ProtoMessage()               {}
func (*BlockInfo) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{8} }

type Vector struct {
	Counters []Counter `protobuf:"bytes,1,rep,name=counters" json:"counters"`
}

func (m *Vector) Reset()                    { *m = Vector{} }
func (m *Vector) String() string            { return proto.CompactTextString(m) }
func (*Vector) ProtoMessage()               {}
func (*Vector) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{9} }

type Counter struct {
	ID    ShortID `protobuf:"varint,1,opt,name=id,proto3,customtype=ShortID" json:"id"`
	Value uint64  `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Counter) Reset()                    { *m = Counter{} }
func (m *Counter) String() string            { return proto.CompactTextString(m) }
func (*Counter) ProtoMessage()               {}
func (*Counter) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{10} }

type Request struct {
	ID            int32  `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Folder        string `protobuf:"bytes,2,opt,name=folder,proto3" json:"folder,omitempty"`
	Name          string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Offset        int64  `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	Size          int32  `protobuf:"varint,5,opt,name=size,proto3" json:"size,omitempty"`
	Hash          []byte `protobuf:"bytes,6,opt,name=hash,proto3" json:"hash,omitempty"`
	FromTemporary bool   `protobuf:"varint,7,opt,name=from_temporary,json=fromTemporary,proto3" json:"from_temporary,omitempty"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (m *Request) String() string            { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{11} }

type Response struct {
	ID   int32     `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Data []byte    `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	Code ErrorCode `protobuf:"varint,3,opt,name=code,proto3,enum=protocol.ErrorCode" json:"code,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{12} }

type DownloadProgress struct {
	Folder  string                       `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	Updates []FileDownloadProgressUpdate `protobuf:"bytes,2,rep,name=updates" json:"updates"`
}

func (m *DownloadProgress) Reset()                    { *m = DownloadProgress{} }
func (m *DownloadProgress) String() string            { return proto.CompactTextString(m) }
func (*DownloadProgress) ProtoMessage()               {}
func (*DownloadProgress) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{13} }

type FileDownloadProgressUpdate struct {
	UpdateType   FileDownloadProgressUpdateType `protobuf:"varint,1,opt,name=update_type,json=updateType,proto3,enum=protocol.FileDownloadProgressUpdateType" json:"update_type,omitempty"`
	Name         string                         `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Version      Vector                         `protobuf:"bytes,3,opt,name=version" json:"version"`
	BlockIndexes []int32                        `protobuf:"varint,4,rep,name=block_indexes,json=blockIndexes" json:"block_indexes,omitempty"`
}

func (m *FileDownloadProgressUpdate) Reset()                    { *m = FileDownloadProgressUpdate{} }
func (m *FileDownloadProgressUpdate) String() string            { return proto.CompactTextString(m) }
func (*FileDownloadProgressUpdate) ProtoMessage()               {}
func (*FileDownloadProgressUpdate) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{14} }

type Ping struct {
}

func (m *Ping) Reset()                    { *m = Ping{} }
func (m *Ping) String() string            { return proto.CompactTextString(m) }
func (*Ping) ProtoMessage()               {}
func (*Ping) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{15} }

type Close struct {
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (m *Close) Reset()                    { *m = Close{} }
func (m *Close) String() string            { return proto.CompactTextString(m) }
func (*Close) ProtoMessage()               {}
func (*Close) Descriptor() ([]byte, []int) { return fileDescriptorBep, []int{16} }

func init() {
	proto.RegisterType((*Hello)(nil), "protocol.Hello")
	proto.RegisterType((*Header)(nil), "protocol.Header")
	proto.RegisterType((*ClusterConfig)(nil), "protocol.ClusterConfig")
	proto.RegisterType((*Folder)(nil), "protocol.Folder")
	proto.RegisterType((*Device)(nil), "protocol.Device")
	proto.RegisterType((*Index)(nil), "protocol.Index")
	proto.RegisterType((*IndexUpdate)(nil), "protocol.IndexUpdate")
	proto.RegisterType((*FileInfo)(nil), "protocol.FileInfo")
	proto.RegisterType((*BlockInfo)(nil), "protocol.BlockInfo")
	proto.RegisterType((*Vector)(nil), "protocol.Vector")
	proto.RegisterType((*Counter)(nil), "protocol.Counter")
	proto.RegisterType((*Request)(nil), "protocol.Request")
	proto.RegisterType((*Response)(nil), "protocol.Response")
	proto.RegisterType((*DownloadProgress)(nil), "protocol.DownloadProgress")
	proto.RegisterType((*FileDownloadProgressUpdate)(nil), "protocol.FileDownloadProgressUpdate")
	proto.RegisterType((*Ping)(nil), "protocol.Ping")
	proto.RegisterType((*Close)(nil), "protocol.Close")
	proto.RegisterEnum("protocol.MessageType", MessageType_name, MessageType_value)
	proto.RegisterEnum("protocol.MessageCompression", MessageCompression_name, MessageCompression_value)
	proto.RegisterEnum("protocol.Compression", Compression_name, Compression_value)
	proto.RegisterEnum("protocol.FileInfoType", FileInfoType_name, FileInfoType_value)
	proto.RegisterEnum("protocol.ErrorCode", ErrorCode_name, ErrorCode_value)
	proto.RegisterEnum("protocol.FileDownloadProgressUpdateType", FileDownloadProgressUpdateType_name, FileDownloadProgressUpdateType_value)
}
func (m *Hello) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Hello) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DeviceName) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.DeviceName)))
		i += copy(data[i:], m.DeviceName)
	}
	if len(m.ClientName) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.ClientName)))
		i += copy(data[i:], m.ClientName)
	}
	if len(m.ClientVersion) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintBep(data, i, uint64(len(m.ClientVersion)))
		i += copy(data[i:], m.ClientVersion)
	}
	return i, nil
}

func (m *Header) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Header) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.Type))
	}
	if m.Compression != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintBep(data, i, uint64(m.Compression))
	}
	return i, nil
}

func (m *ClusterConfig) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ClusterConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Folders) > 0 {
		for _, msg := range m.Folders {
			data[i] = 0xa
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Folder) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Folder) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	if len(m.Label) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Label)))
		i += copy(data[i:], m.Label)
	}
	if m.ReadOnly {
		data[i] = 0x18
		i++
		if m.ReadOnly {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.IgnorePermissions {
		data[i] = 0x20
		i++
		if m.IgnorePermissions {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.IgnoreDelete {
		data[i] = 0x28
		i++
		if m.IgnoreDelete {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.DisableTempIndexes {
		data[i] = 0x30
		i++
		if m.DisableTempIndexes {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.Devices) > 0 {
		for _, msg := range m.Devices {
			data[i] = 0x82
			i++
			data[i] = 0x1
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Device) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Device) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	if len(m.Name) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			data[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.Compression != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintBep(data, i, uint64(m.Compression))
	}
	if len(m.CertName) > 0 {
		data[i] = 0x2a
		i++
		i = encodeVarintBep(data, i, uint64(len(m.CertName)))
		i += copy(data[i:], m.CertName)
	}
	if m.MaxLocalVersion != 0 {
		data[i] = 0x30
		i++
		i = encodeVarintBep(data, i, uint64(m.MaxLocalVersion))
	}
	if m.Introducer {
		data[i] = 0x38
		i++
		if m.Introducer {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Index) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Index) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Folder) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Folder)))
		i += copy(data[i:], m.Folder)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			data[i] = 0x12
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *IndexUpdate) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IndexUpdate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Folder) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Folder)))
		i += copy(data[i:], m.Folder)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			data[i] = 0x12
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *FileInfo) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FileInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if m.Type != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintBep(data, i, uint64(m.Type))
	}
	if m.Size != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintBep(data, i, uint64(m.Size))
	}
	if m.Permissions != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintBep(data, i, uint64(m.Permissions))
	}
	if m.Modified != 0 {
		data[i] = 0x28
		i++
		i = encodeVarintBep(data, i, uint64(m.Modified))
	}
	if m.Deleted {
		data[i] = 0x30
		i++
		if m.Deleted {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Invalid {
		data[i] = 0x38
		i++
		if m.Invalid {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.NoPermissions {
		data[i] = 0x40
		i++
		if m.NoPermissions {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	data[i] = 0x4a
	i++
	i = encodeVarintBep(data, i, uint64(m.Version.ProtoSize()))
	n1, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.LocalVersion != 0 {
		data[i] = 0x50
		i++
		i = encodeVarintBep(data, i, uint64(m.LocalVersion))
	}
	if len(m.Blocks) > 0 {
		for _, msg := range m.Blocks {
			data[i] = 0x82
			i++
			data[i] = 0x1
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BlockInfo) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *BlockInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Offset != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.Offset))
	}
	if m.Size != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintBep(data, i, uint64(m.Size))
	}
	if len(m.Hash) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Hash)))
		i += copy(data[i:], m.Hash)
	}
	return i, nil
}

func (m *Vector) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Vector) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Counters) > 0 {
		for _, msg := range m.Counters {
			data[i] = 0xa
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Counter) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Counter) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.ID))
	}
	if m.Value != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintBep(data, i, uint64(m.Value))
	}
	return i, nil
}

func (m *Request) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Request) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.ID))
	}
	if len(m.Folder) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Folder)))
		i += copy(data[i:], m.Folder)
	}
	if len(m.Name) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if m.Offset != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintBep(data, i, uint64(m.Offset))
	}
	if m.Size != 0 {
		data[i] = 0x28
		i++
		i = encodeVarintBep(data, i, uint64(m.Size))
	}
	if len(m.Hash) > 0 {
		data[i] = 0x32
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Hash)))
		i += copy(data[i:], m.Hash)
	}
	if m.FromTemporary {
		data[i] = 0x38
		i++
		if m.FromTemporary {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Response) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Response) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.ID))
	}
	if len(m.Data) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if m.Code != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintBep(data, i, uint64(m.Code))
	}
	return i, nil
}

func (m *DownloadProgress) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *DownloadProgress) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Folder) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Folder)))
		i += copy(data[i:], m.Folder)
	}
	if len(m.Updates) > 0 {
		for _, msg := range m.Updates {
			data[i] = 0x12
			i++
			i = encodeVarintBep(data, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *FileDownloadProgressUpdate) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FileDownloadProgressUpdate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.UpdateType != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintBep(data, i, uint64(m.UpdateType))
	}
	if len(m.Name) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	data[i] = 0x1a
	i++
	i = encodeVarintBep(data, i, uint64(m.Version.ProtoSize()))
	n2, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.BlockIndexes) > 0 {
		for _, num := range m.BlockIndexes {
			data[i] = 0x20
			i++
			i = encodeVarintBep(data, i, uint64(num))
		}
	}
	return i, nil
}

func (m *Ping) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Ping) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *Close) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Close) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Reason) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintBep(data, i, uint64(len(m.Reason)))
		i += copy(data[i:], m.Reason)
	}
	return i, nil
}

func encodeFixed64Bep(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Bep(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintBep(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func (m *Hello) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.DeviceName)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.ClientName)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.ClientVersion)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	return n
}

func (m *Header) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovBep(uint64(m.Type))
	}
	if m.Compression != 0 {
		n += 1 + sovBep(uint64(m.Compression))
	}
	return n
}

func (m *ClusterConfig) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Folders) > 0 {
		for _, e := range m.Folders {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *Folder) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.ReadOnly {
		n += 2
	}
	if m.IgnorePermissions {
		n += 2
	}
	if m.IgnoreDelete {
		n += 2
	}
	if m.DisableTempIndexes {
		n += 2
	}
	if len(m.Devices) > 0 {
		for _, e := range m.Devices {
			l = e.ProtoSize()
			n += 2 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *Device) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			l = len(s)
			n += 1 + l + sovBep(uint64(l))
		}
	}
	if m.Compression != 0 {
		n += 1 + sovBep(uint64(m.Compression))
	}
	l = len(m.CertName)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.MaxLocalVersion != 0 {
		n += 1 + sovBep(uint64(m.MaxLocalVersion))
	}
	if m.Introducer {
		n += 2
	}
	return n
}

func (m *Index) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Folder)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *IndexUpdate) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Folder)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *FileInfo) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovBep(uint64(m.Type))
	}
	if m.Size != 0 {
		n += 1 + sovBep(uint64(m.Size))
	}
	if m.Permissions != 0 {
		n += 1 + sovBep(uint64(m.Permissions))
	}
	if m.Modified != 0 {
		n += 1 + sovBep(uint64(m.Modified))
	}
	if m.Deleted {
		n += 2
	}
	if m.Invalid {
		n += 2
	}
	if m.NoPermissions {
		n += 2
	}
	l = m.Version.ProtoSize()
	n += 1 + l + sovBep(uint64(l))
	if m.LocalVersion != 0 {
		n += 1 + sovBep(uint64(m.LocalVersion))
	}
	if len(m.Blocks) > 0 {
		for _, e := range m.Blocks {
			l = e.ProtoSize()
			n += 2 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *BlockInfo) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Offset != 0 {
		n += 1 + sovBep(uint64(m.Offset))
	}
	if m.Size != 0 {
		n += 1 + sovBep(uint64(m.Size))
	}
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	return n
}

func (m *Vector) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Counters) > 0 {
		for _, e := range m.Counters {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *Counter) ProtoSize() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovBep(uint64(m.ID))
	}
	if m.Value != 0 {
		n += 1 + sovBep(uint64(m.Value))
	}
	return n
}

func (m *Request) ProtoSize() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovBep(uint64(m.ID))
	}
	l = len(m.Folder)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.Offset != 0 {
		n += 1 + sovBep(uint64(m.Offset))
	}
	if m.Size != 0 {
		n += 1 + sovBep(uint64(m.Size))
	}
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.FromTemporary {
		n += 2
	}
	return n
}

func (m *Response) ProtoSize() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovBep(uint64(m.ID))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if m.Code != 0 {
		n += 1 + sovBep(uint64(m.Code))
	}
	return n
}

func (m *DownloadProgress) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Folder)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	if len(m.Updates) > 0 {
		for _, e := range m.Updates {
			l = e.ProtoSize()
			n += 1 + l + sovBep(uint64(l))
		}
	}
	return n
}

func (m *FileDownloadProgressUpdate) ProtoSize() (n int) {
	var l int
	_ = l
	if m.UpdateType != 0 {
		n += 1 + sovBep(uint64(m.UpdateType))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	l = m.Version.ProtoSize()
	n += 1 + l + sovBep(uint64(l))
	if len(m.BlockIndexes) > 0 {
		for _, e := range m.BlockIndexes {
			n += 1 + sovBep(uint64(e))
		}
	}
	return n
}

func (m *Ping) ProtoSize() (n int) {
	var l int
	_ = l
	return n
}

func (m *Close) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovBep(uint64(l))
	}
	return n
}

func sovBep(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBep(x uint64) (n int) {
	return sovBep(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Hello) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Hello: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Hello: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeviceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeviceName = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientName = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientVersion = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Header) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Type |= (MessageType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compression", wireType)
			}
			m.Compression = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Compression |= (MessageCompression(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folders = append(m.Folders, Folder{})
			if err := m.Folders[len(m.Folders)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Folder) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Folder: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Folder: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReadOnly = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IgnorePermissions", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IgnorePermissions = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IgnoreDelete", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IgnoreDelete = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableTempIndexes", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableTempIndexes = bool(v != 0)
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Devices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Devices = append(m.Devices, Device{})
			if err := m.Devices[len(m.Devices)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Device) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Device: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Device: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = append(m.ID[:0], data[iNdEx:postIndex]...)
			if m.ID == nil {
				m.ID = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compression", wireType)
			}
			m.Compression = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Compression |= (Compression(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertName = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxLocalVersion", wireType)
			}
			m.MaxLocalVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.MaxLocalVersion |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Introducer", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Introducer = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Index) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Index: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Index: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folder", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folder = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, FileInfo{})
			if err := m.Files[len(m.Files)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IndexUpdate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folder", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folder = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, FileInfo{})
			if err := m.Files[len(m.Files)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Type |= (FileInfoType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size", wireType)
			}
			m.Size = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Size |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			m.Permissions = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Permissions |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modified", wireType)
			}
			m.Modified = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Modified |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Deleted = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Invalid", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Invalid = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoPermissions", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoPermissions = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalVersion", wireType)
			}
			m.LocalVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.LocalVersion |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blocks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Blocks = append(m.Blocks, BlockInfo{})
			if err := m.Blocks[len(m.Blocks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BlockInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BlockInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BlockInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Offset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size", wireType)
			}
			m.Size = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Size |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], data[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Vector) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Vector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Vector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Counters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Counters = append(m.Counters, Counter{})
			if err := m.Counters[len(m.Counters)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Counter) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Counter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Counter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (ShortID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Value |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Request) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folder", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folder = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Offset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size", wireType)
			}
			m.Size = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Size |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], data[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromTemporary", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FromTemporary = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], data[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Code |= (ErrorCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DownloadProgress) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DownloadProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DownloadProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Folder", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Folder = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Updates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Updates = append(m.Updates, FileDownloadProgressUpdate{})
			if err := m.Updates[len(m.Updates)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileDownloadProgressUpdate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileDownloadProgressUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileDownloadProgressUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateType", wireType)
			}
			m.UpdateType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.UpdateType |= (FileDownloadProgressUpdateType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockIndexes", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BlockIndexes = append(m.BlockIndexes, v)
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Ping) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Close) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBep
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Close: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Close: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBep
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBep
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBep(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBep
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBep(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBep
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBep
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBep
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBep
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBep
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBep(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBep = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBep   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorBep = []byte{
	// 1543 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x56, 0x41, 0x6f, 0x1a, 0xc7,
	0x17, 0x37, 0xb0, 0x2c, 0x30, 0xc6, 0x0e, 0x9e, 0x38, 0x0e, 0xff, 0x8d, 0xff, 0xb6, 0xbb, 0x49,
	0x54, 0x17, 0x35, 0x4e, 0x9b, 0x54, 0x8d, 0x54, 0xa9, 0x95, 0x30, 0xac, 0x1d, 0x14, 0xbc, 0x90,
	0x05, 0x9c, 0xa6, 0x87, 0xa2, 0x85, 0x1d, 0xf0, 0x2a, 0xcb, 0x0e, 0xdd, 0x5d, 0x92, 0xb8, 0x5f,
	0xa0, 0x52, 0xfb, 0x05, 0x7a, 0xa9, 0x94, 0x6b, 0xef, 0xfd, 0x10, 0x39, 0x46, 0x39, 0xf6, 0x10,
	0xb5, 0xe9, 0xa5, 0x1f, 0xa0, 0xbd, 0xf7, 0xcd, 0xcc, 0x2e, 0x2c, 0xc6, 0xae, 0x72, 0xe8, 0x01,
	0x31, 0xf3, 0xde, 0x6f, 0xde, 0xcc, 0xfc, 0xde, 0xef, 0xbd, 0x59, 0x94, 0xeb, 0x91, 0xf1, 0xde,
	0xd8, 0xa3, 0x01, 0xc5, 0x59, 0xfe, 0xd7, 0xa7, 0x8e, 0x72, 0x6b, 0x68, 0x07, 0x27, 0x93, 0xde,
	0x5e, 0x9f, 0x8e, 0x6e, 0x0f, 0xe9, 0x90, 0xde, 0xe6, 0x9e, 0xde, 0x64, 0xc0, 0x67, 0x7c, 0xc2,
	0x47, 0x62, 0xa1, 0x3a, 0x46, 0xe9, 0xfb, 0xc4, 0x71, 0x28, 0xde, 0x46, 0xcb, 0x16, 0x79, 0x6a,
	0xf7, 0x49, 0xd7, 0x35, 0x47, 0xa4, 0x98, 0xd8, 0x49, 0xec, 0xe6, 0x0c, 0x24, 0x4c, 0x3a, 0x58,
	0x18, 0xa0, 0xef, 0xd8, 0xc4, 0x0d, 0x04, 0x20, 0x29, 0x00, 0xc2, 0xc4, 0x01, 0x37, 0xd1, 0x6a,
	0x08, 0x78, 0x4a, 0x3c, 0xdf, 0xa6, 0x6e, 0x31, 0xc5, 0x31, 0x2b, 0xc2, 0x7a, 0x2c, 0x8c, 0xaa,
	0x8f, 0xe4, 0xfb, 0xc4, 0xb4, 0x88, 0x87, 0x3f, 0x40, 0x52, 0x70, 0x3a, 0x16, 0x7b, 0xad, 0xde,
	0xb9, 0xb2, 0x17, 0xdd, 0x61, 0xef, 0x88, 0xf8, 0xbe, 0x39, 0x24, 0x6d, 0x70, 0x1a, 0x1c, 0x82,
	0xbf, 0x80, 0xcd, 0xe9, 0x68, 0xec, 0x81, 0x83, 0x05, 0x4e, 0xf2, 0x15, 0x9b, 0x0b, 0x2b, 0x2a,
	0x33, 0x8c, 0x11, 0x5f, 0xa0, 0x96, 0xd1, 0x4a, 0xc5, 0x99, 0xf8, 0x01, 0xf1, 0x2a, 0xd4, 0x1d,
	0xd8, 0x43, 0xfc, 0x11, 0xca, 0x0c, 0xa8, 0x03, 0xa7, 0xf0, 0x61, 0xfb, 0xd4, 0xee, 0xf2, 0x9d,
	0xc2, 0x2c, 0xd8, 0x01, 0x77, 0xec, 0x4b, 0x2f, 0xdf, 0x6c, 0x2f, 0x19, 0x11, 0x4c, 0xfd, 0x21,
	0x89, 0x64, 0xe1, 0xc1, 0x1b, 0x28, 0x69, 0x5b, 0x82, 0xa2, 0x7d, 0xf9, 0xed, 0x9b, 0xed, 0x64,
	0xad, 0x6a, 0x80, 0x05, 0xaf, 0xa3, 0xb4, 0x63, 0xf6, 0x88, 0x13, 0x92, 0x23, 0x26, 0xf8, 0x1a,
	0xca, 0x79, 0x70, 0xe1, 0x2e, 0x75, 0x9d, 0x53, 0x4e, 0x49, 0xd6, 0xc8, 0x32, 0x43, 0x03, 0xe6,
	0xf8, 0x16, 0xc2, 0xf6, 0xd0, 0xa5, 0x1e, 0xe9, 0x8e, 0x89, 0x37, 0xb2, 0xf9, 0x69, 0xfd, 0xa2,
	0xc4, 0x51, 0x6b, 0xc2, 0xd3, 0x9c, 0x39, 0xf0, 0x75, 0xb4, 0x12, 0xc2, 0x2d, 0xe2, 0x90, 0x80,
	0x14, 0xd3, 0x1c, 0x99, 0x17, 0xc6, 0x2a, 0xb7, 0xc1, 0xdd, 0xd6, 0x2d, 0xdb, 0x37, 0x7b, 0x0e,
	0xe9, 0x06, 0x64, 0x34, 0xee, 0xda, 0xae, 0x45, 0x9e, 0x13, 0xbf, 0x28, 0x73, 0x2c, 0x0e, 0x7d,
	0x6d, 0x70, 0xd5, 0x84, 0x87, 0xb1, 0x21, 0x32, 0xed, 0x17, 0x0b, 0x67, 0xd9, 0xa8, 0x72, 0x47,
	0xc4, 0x46, 0x08, 0x53, 0xff, 0x4a, 0x20, 0x59, 0x78, 0x62, 0x6c, 0xe4, 0xe7, 0xd8, 0xc0, 0x48,
	0x8a, 0x29, 0x85, 0x8f, 0xf1, 0x26, 0xca, 0x99, 0x96, 0xc5, 0xb2, 0x02, 0x5b, 0xa5, 0x60, 0xab,
	0x9c, 0x31, 0x33, 0xe0, 0x7b, 0xf3, 0x59, 0x96, 0xce, 0xea, 0xe2, 0xa2, 0xf4, 0x32, 0x8a, 0xfb,
	0xc4, 0x0b, 0x95, 0x99, 0xe6, 0xfb, 0x65, 0x99, 0x81, 0xeb, 0xb2, 0x84, 0xd6, 0x46, 0xe6, 0xf3,
	0xae, 0x43, 0xfb, 0xa6, 0x33, 0x95, 0x26, 0xe3, 0x22, 0x65, 0x5c, 0x02, 0x47, 0x9d, 0xd9, 0x43,
	0x71, 0xe2, 0x2d, 0x84, 0x6c, 0x37, 0xf0, 0xa8, 0x35, 0x81, 0xe5, 0xc5, 0x0c, 0x27, 0x2c, 0x66,
	0x51, 0x1b, 0x28, 0xcd, 0x39, 0x83, 0x4b, 0xcb, 0x42, 0x18, 0x61, 0xa5, 0x84, 0x33, 0xbc, 0x87,
	0xd2, 0x03, 0xdb, 0x81, 0xcb, 0x25, 0x39, 0x8f, 0x38, 0xa6, 0x2a, 0x30, 0xd7, 0xdc, 0x01, 0x0d,
	0x99, 0x14, 0x30, 0xb5, 0x83, 0x96, 0x79, 0xc0, 0xce, 0xd8, 0x32, 0x03, 0xf2, 0x9f, 0x85, 0xfd,
	0x2e, 0x85, 0xb2, 0x91, 0x67, 0x9a, 0x88, 0x44, 0x2c, 0x11, 0xa5, 0xb0, 0xf6, 0x44, 0x25, 0x6d,
	0x2c, 0xc6, 0x8b, 0x15, 0x1f, 0xac, 0xf7, 0xed, 0x6f, 0x09, 0xd7, 0x6e, 0xca, 0xe0, 0x63, 0xbc,
	0x83, 0x96, 0xcf, 0x0a, 0x76, 0xc5, 0x88, 0x9b, 0xb0, 0x82, 0xb2, 0x23, 0x6a, 0xd9, 0x03, 0x9b,
	0x58, 0x3c, 0x25, 0x29, 0x63, 0x3a, 0xc7, 0x45, 0xa6, 0x37, 0xa6, 0x55, 0x2b, 0x14, 0x65, 0x34,
	0x65, 0x1e, 0xdb, 0x7d, 0x6a, 0x3a, 0xa0, 0x28, 0xc1, 0x7e, 0x34, 0x65, 0xed, 0xc5, 0xa5, 0x73,
	0x55, 0x92, 0xe5, 0x80, 0x15, 0x97, 0xc6, 0x2b, 0x04, 0xa4, 0x1c, 0xe5, 0x38, 0x07, 0xfe, 0x39,
	0x29, 0x1f, 0x93, 0x7e, 0x40, 0xa7, 0x85, 0x1d, 0xc2, 0x58, 0x4d, 0xcd, 0x6b, 0x03, 0xf1, 0xd3,
	0xe6, 0x9d, 0xb8, 0x30, 0x3e, 0x46, 0xf2, 0x3e, 0x18, 0x9e, 0x44, 0x05, 0x72, 0x79, 0x16, 0x95,
	0xdb, 0x63, 0x29, 0x90, 0x7b, 0x1c, 0xf8, 0x99, 0xf4, 0xe3, 0x8b, 0xed, 0x25, 0xf5, 0x21, 0xca,
	0x4d, 0x01, 0x2c, 0xbd, 0x74, 0x30, 0xf0, 0x49, 0xc0, 0x73, 0x91, 0x32, 0xc2, 0xd9, 0x94, 0x61,
	0x96, 0x8d, 0x74, 0xc8, 0x30, 0xd8, 0x4e, 0x4c, 0xff, 0x84, 0xb3, 0x9e, 0x37, 0xf8, 0x38, 0x0c,
	0xf9, 0x39, 0x92, 0xc5, 0x4d, 0xf0, 0x5d, 0x94, 0xed, 0xd3, 0x89, 0x1b, 0xcc, 0xda, 0xd8, 0x5a,
	0xbc, 0x5a, 0xb8, 0x27, 0x3c, 0xd5, 0x14, 0xa8, 0x1e, 0xa0, 0x4c, 0xe8, 0x02, 0x4e, 0xa3, 0xd2,
	0x95, 0xf6, 0xaf, 0x30, 0xd8, 0xaf, 0x6f, 0xb6, 0x33, 0xad, 0x13, 0xea, 0x05, 0xb5, 0xea, 0x7c,
	0x5f, 0x83, 0x1c, 0x4c, 0xc4, 0xf9, 0x24, 0x43, 0x4c, 0xd4, 0x5f, 0x12, 0x28, 0x63, 0x90, 0x6f,
	0x26, 0xc4, 0x0f, 0x62, 0x3d, 0x20, 0x3d, 0xd7, 0x03, 0x66, 0x7a, 0x4e, 0xce, 0xe9, 0x39, 0x92,
	0x64, 0x2a, 0x26, 0xc9, 0x19, 0x39, 0xd2, 0xb9, 0xe4, 0xa4, 0xcf, 0x21, 0x47, 0x9e, 0x91, 0xc3,
	0x04, 0x32, 0xf0, 0xe8, 0x88, 0xf7, 0x3c, 0xea, 0x99, 0xde, 0x69, 0xa8, 0xa0, 0x15, 0x66, 0x6d,
	0x47, 0x46, 0xb5, 0x8b, 0xb2, 0x06, 0xf1, 0xc7, 0xa0, 0x15, 0x72, 0xe1, 0xb1, 0x21, 0x3c, 0x94,
	0xa3, 0xc9, 0x0f, 0x0d, 0xe1, 0xd9, 0x18, 0xbf, 0x8f, 0xa4, 0x3e, 0xb5, 0xc4, 0x91, 0x57, 0xe3,
	0xf9, 0xd7, 0x3c, 0x8f, 0xc2, 0xb3, 0x62, 0x41, 0xb9, 0x30, 0x00, 0x3c, 0xa9, 0x85, 0x2a, 0x7d,
	0xe6, 0x3a, 0xd4, 0xb4, 0x9a, 0x1e, 0x1d, 0xb2, 0x1e, 0x75, 0x61, 0x5d, 0x57, 0x51, 0x66, 0xc2,
	0x2b, 0x3f, 0xaa, 0xec, 0x1b, 0xf3, 0x95, 0x78, 0x36, 0x90, 0x68, 0x13, 0x91, 0x82, 0xc3, 0xa5,
	0xea, 0xeb, 0x04, 0x52, 0x2e, 0x46, 0xe3, 0x1a, 0x5a, 0x16, 0xc8, 0x6e, 0xec, 0xb9, 0xdd, 0x7d,
	0x97, 0x8d, 0x78, 0x13, 0x40, 0x93, 0xe9, 0xf8, 0xdc, 0x9e, 0x1e, 0xab, 0xb8, 0xd4, 0x3b, 0x57,
	0x1c, 0xaf, 0x91, 0xe9, 0xcb, 0x24, 0xc1, 0xdd, 0xd3, 0x46, 0xbe, 0x27, 0x0a, 0x85, 0xdb, 0x54,
	0x19, 0x49, 0x4d, 0xdb, 0x1d, 0xaa, 0xdb, 0x28, 0x5d, 0x71, 0x28, 0x4f, 0x96, 0x0c, 0xcf, 0xa6,
	0x0f, 0xdb, 0x84, 0x1c, 0x8a, 0x59, 0xe9, 0x75, 0x12, 0x2d, 0xc7, 0xbe, 0x18, 0xe0, 0x3c, 0xab,
	0x95, 0x7a, 0xa7, 0xd5, 0xd6, 0x8c, 0x6e, 0xa5, 0xa1, 0x1f, 0xd4, 0x0e, 0x0b, 0x4b, 0xca, 0xe6,
	0xf7, 0x3f, 0xed, 0x14, 0x47, 0x33, 0xd0, 0xfc, 0xc7, 0x00, 0x6c, 0x51, 0xd3, 0xab, 0xda, 0x97,
	0x85, 0x84, 0xb2, 0x0e, 0xc0, 0x42, 0x0c, 0x28, 0xba, 0xfd, 0x87, 0x28, 0xcf, 0x01, 0xdd, 0x4e,
	0xb3, 0x5a, 0x6e, 0x6b, 0x85, 0xa4, 0xa2, 0x00, 0x6e, 0xe3, 0x2c, 0x2e, 0xe4, 0xfb, 0x3a, 0xd4,
	0x85, 0xf6, 0xb0, 0xa3, 0xb5, 0xda, 0x85, 0x94, 0xb2, 0x01, 0x40, 0x1c, 0x03, 0x46, 0x15, 0x73,
	0x13, 0x64, 0xa8, 0xb5, 0x9a, 0x0d, 0xbd, 0xa5, 0x15, 0x24, 0xe5, 0x2a, 0xa0, 0x2e, 0xcf, 0xa1,
	0x42, 0x85, 0x7e, 0x8a, 0xd6, 0xaa, 0x8d, 0x47, 0x7a, 0xbd, 0x51, 0xae, 0x76, 0x9b, 0x46, 0xe3,
	0x10, 0xd6, 0xb4, 0x0a, 0x69, 0x65, 0x1b, 0xf0, 0xd7, 0x62, 0xf8, 0x05, 0xc1, 0xfd, 0x1f, 0xd8,
	0xab, 0xe9, 0x87, 0x05, 0x59, 0xb9, 0x0c, 0xd0, 0x4b, 0x31, 0x28, 0x23, 0x95, 0xdd, 0xb8, 0x52,
	0x6f, 0xc0, 0xd6, 0x99, 0x85, 0x1b, 0x73, 0xb2, 0x4b, 0x5f, 0x23, 0xbc, 0xf8, 0x4d, 0x85, 0x6f,
	0x20, 0x49, 0x6f, 0xe8, 0x1a, 0x10, 0xca, 0xef, 0xbf, 0x88, 0xd0, 0xa9, 0x4b, 0xb0, 0x8a, 0x52,
	0xf5, 0xaf, 0x3e, 0x01, 0x32, 0xff, 0x07, 0xa0, 0x2b, 0x8b, 0x20, 0x70, 0x96, 0x28, 0x5a, 0x8e,
	0x07, 0x56, 0x51, 0xf6, 0x48, 0x6b, 0x97, 0x81, 0xdc, 0x32, 0x04, 0xe7, 0x47, 0x8a, 0xdc, 0x47,
	0x24, 0x30, 0x79, 0x01, 0x6e, 0xa2, 0xb4, 0xae, 0x1d, 0x6b, 0x06, 0x04, 0x5e, 0x03, 0xc0, 0x4a,
	0x04, 0xd0, 0x09, 0xe8, 0x0a, 0x5e, 0x6e, 0xb9, 0x5c, 0x7f, 0x54, 0x7e, 0xdc, 0x82, 0xe4, 0x60,
	0x70, 0xaf, 0x46, 0xee, 0xb2, 0xf3, 0xcc, 0x3c, 0xf5, 0x4b, 0x7f, 0x27, 0x50, 0x3e, 0xfe, 0xb6,
	0xc1, 0x02, 0xe9, 0xa0, 0x56, 0xd7, 0xa2, 0xed, 0xe2, 0x3e, 0x36, 0xc6, 0xbb, 0x28, 0x57, 0xad,
	0x19, 0x5a, 0xa5, 0xdd, 0x30, 0x1e, 0x47, 0x77, 0x89, 0x83, 0xaa, 0xb6, 0xc7, 0xc5, 0xcd, 0xbe,
	0xe1, 0xf2, 0xad, 0xc7, 0x47, 0xf5, 0x9a, 0xfe, 0xa0, 0xcb, 0x23, 0x26, 0x95, 0x6b, 0x00, 0xbe,
	0x1a, 0x07, 0xb7, 0x4e, 0x47, 0x8e, 0xed, 0x3e, 0xe1, 0x81, 0xef, 0xa1, 0xb5, 0x08, 0x3e, 0xdb,
	0x20, 0xa5, 0xec, 0xc0, 0x9a, 0xcd, 0x73, 0xd6, 0xcc, 0xf6, 0xb9, 0x8b, 0x2e, 0x45, 0x0b, 0x3b,
	0xfa, 0x03, 0x1d, 0x64, 0x01, 0xca, 0xd9, 0x82, 0x65, 0xca, 0x39, 0xcb, 0x3a, 0xee, 0x13, 0x17,
	0x44, 0x51, 0xfa, 0x39, 0x81, 0x72, 0xd3, 0x0e, 0xc5, 0x78, 0xd6, 0x1b, 0x5d, 0xcd, 0x30, 0x1a,
	0x46, 0x74, 0xf1, 0xa9, 0x53, 0xa7, 0x7c, 0x88, 0xdf, 0x43, 0x99, 0x43, 0x4d, 0xd7, 0x8c, 0x5a,
	0x25, 0xaa, 0x87, 0x29, 0xe4, 0x90, 0xb8, 0xc4, 0xb3, 0xfb, 0xf0, 0xe5, 0x9e, 0x87, 0x30, 0xad,
	0x4e, 0xe5, 0x7e, 0x74, 0x63, 0x2e, 0xe0, 0x58, 0xa8, 0xd6, 0xa4, 0x7f, 0xc2, 0x6f, 0x5b, 0x62,
	0xa5, 0x73, 0x5c, 0xae, 0xd7, 0xaa, 0x02, 0x9a, 0x52, 0x8a, 0x00, 0x5d, 0x9f, 0x42, 0x6b, 0xe2,
	0x79, 0x67, 0xd8, 0x92, 0x85, 0xb6, 0xfe, 0xbd, 0x17, 0xc1, 0x67, 0x87, 0x5c, 0x6e, 0x36, 0x35,
	0xbd, 0x1a, 0x9d, 0x7e, 0xe6, 0x2b, 0x8f, 0xc7, 0xc4, 0xb5, 0x18, 0xe2, 0xa0, 0x61, 0x1c, 0x6a,
	0xed, 0xe8, 0xf0, 0x33, 0xc4, 0x01, 0xf5, 0x86, 0x24, 0xd8, 0xdf, 0x7c, 0xf9, 0xfb, 0xd6, 0xd2,
	0x2b, 0xf8, 0xbd, 0x7c, 0xbb, 0x95, 0x78, 0x05, 0xbf, 0xdf, 0xde, 0x6e, 0x2d, 0xfd, 0x09, 0xff,
	0x2f, 0xfe, 0xd8, 0x4a, 0xf4, 0x64, 0xde, 0xbb, 0xee, 0xfe, 0x13, 0x00, 0x00, 0xff, 0xff, 0x88,
	0x06, 0x3b, 0x0f, 0x5d, 0x0d, 0x00, 0x00,
}
