// ************************************************************
// This file is automatically generated by genxdr. Do not edit.
// ************************************************************

package protocol

import (
	"github.com/calmh/xdr"
)

/*

HelloMessage Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\              Device Name (length + padded data)               \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\              Client Name (length + padded data)               \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\             Client Version (length + padded data)             \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct HelloMessage {
	string DeviceName<64>;
	string ClientName<64>;
	string ClientVersion<64>;
}

*/

func (o HelloMessage) XDRSize() int {
	return 4 + len(o.DeviceName) + xdr.Padding(len(o.DeviceName)) +
		4 + len(o.ClientName) + xdr.Padding(len(o.ClientName)) +
		4 + len(o.ClientVersion) + xdr.Padding(len(o.ClientVersion))
}

func (o HelloMessage) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o HelloMessage) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o HelloMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.DeviceName); l > 64 {
		return xdr.ElementSizeExceeded("DeviceName", l, 64)
	}
	m.MarshalString(o.DeviceName)
	if l := len(o.ClientName); l > 64 {
		return xdr.ElementSizeExceeded("ClientName", l, 64)
	}
	m.MarshalString(o.ClientName)
	if l := len(o.ClientVersion); l > 64 {
		return xdr.ElementSizeExceeded("ClientVersion", l, 64)
	}
	m.MarshalString(o.ClientVersion)
	return m.Error
}

func (o *HelloMessage) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *HelloMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.DeviceName = u.UnmarshalStringMax(64)
	o.ClientName = u.UnmarshalStringMax(64)
	o.ClientVersion = u.UnmarshalStringMax(64)
	return u.Error
}

/*

IndexMessage Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                 Folder (length + padded data)                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                        Number of Files                        |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\               Zero or more FileInfo Structures                \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Flags                             |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Options                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                Zero or more Option Structures                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct IndexMessage {
	string Folder<256>;
	FileInfo Files<1000000>;
	unsigned int Flags;
	Option Options<64>;
}

*/

func (o IndexMessage) XDRSize() int {
	return 4 + len(o.Folder) + xdr.Padding(len(o.Folder)) +
		4 + xdr.SizeOfSlice(o.Files) + 4 +
		4 + xdr.SizeOfSlice(o.Options)
}

func (o IndexMessage) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o IndexMessage) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o IndexMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.Folder); l > 256 {
		return xdr.ElementSizeExceeded("Folder", l, 256)
	}
	m.MarshalString(o.Folder)
	if l := len(o.Files); l > 1000000 {
		return xdr.ElementSizeExceeded("Files", l, 1000000)
	}
	m.MarshalUint32(uint32(len(o.Files)))
	for i := range o.Files {
		if err := o.Files[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	m.MarshalUint32(o.Flags)
	if l := len(o.Options); l > 64 {
		return xdr.ElementSizeExceeded("Options", l, 64)
	}
	m.MarshalUint32(uint32(len(o.Options)))
	for i := range o.Options {
		if err := o.Options[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	return m.Error
}

func (o *IndexMessage) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *IndexMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.Folder = u.UnmarshalStringMax(256)
	_FilesSize := int(u.UnmarshalUint32())
	if _FilesSize < 0 {
		return xdr.ElementSizeExceeded("Files", _FilesSize, 1000000)
	} else if _FilesSize == 0 {
		o.Files = nil
	} else {
		if _FilesSize > 1000000 {
			return xdr.ElementSizeExceeded("Files", _FilesSize, 1000000)
		}
		if _FilesSize <= len(o.Files) {
			o.Files = o.Files[:_FilesSize]
		} else {
			o.Files = make([]FileInfo, _FilesSize)
		}
		for i := range o.Files {
			(&o.Files[i]).UnmarshalXDRFrom(u)
		}
	}
	o.Flags = u.UnmarshalUint32()
	_OptionsSize := int(u.UnmarshalUint32())
	if _OptionsSize < 0 {
		return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
	} else if _OptionsSize == 0 {
		o.Options = nil
	} else {
		if _OptionsSize > 64 {
			return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
		}
		if _OptionsSize <= len(o.Options) {
			o.Options = o.Options[:_OptionsSize]
		} else {
			o.Options = make([]Option, _OptionsSize)
		}
		for i := range o.Options {
			(&o.Options[i]).UnmarshalXDRFrom(u)
		}
	}
	return u.Error
}

/*

FileInfo Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                  Name (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Flags                             |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                                                               |
+                      Modified (64 bits)                       +
|                                                               |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                       Vector Structure                        \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                                                               |
+                    Local Version (64 bits)                    +
|                                                               |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Blocks                        |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\               Zero or more BlockInfo Structures               \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct FileInfo {
	string Name<8192>;
	unsigned int Flags;
	hyper Modified;
	Vector Version;
	hyper LocalVersion;
	BlockInfo Blocks<10000000>;
}

*/

func (o FileInfo) XDRSize() int {
	return 4 + len(o.Name) + xdr.Padding(len(o.Name)) + 4 + 8 +
		o.Version.XDRSize() + 8 +
		4 + xdr.SizeOfSlice(o.Blocks)
}

func (o FileInfo) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o FileInfo) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o FileInfo) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.Name); l > 8192 {
		return xdr.ElementSizeExceeded("Name", l, 8192)
	}
	m.MarshalString(o.Name)
	m.MarshalUint32(o.Flags)
	m.MarshalUint64(uint64(o.Modified))
	if err := o.Version.MarshalXDRInto(m); err != nil {
		return err
	}
	m.MarshalUint64(uint64(o.LocalVersion))
	if l := len(o.Blocks); l > 10000000 {
		return xdr.ElementSizeExceeded("Blocks", l, 10000000)
	}
	m.MarshalUint32(uint32(len(o.Blocks)))
	for i := range o.Blocks {
		if err := o.Blocks[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	return m.Error
}

func (o *FileInfo) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *FileInfo) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.Name = u.UnmarshalStringMax(8192)
	o.Flags = u.UnmarshalUint32()
	o.Modified = int64(u.UnmarshalUint64())
	(&o.Version).UnmarshalXDRFrom(u)
	o.LocalVersion = int64(u.UnmarshalUint64())
	_BlocksSize := int(u.UnmarshalUint32())
	if _BlocksSize < 0 {
		return xdr.ElementSizeExceeded("Blocks", _BlocksSize, 10000000)
	} else if _BlocksSize == 0 {
		o.Blocks = nil
	} else {
		if _BlocksSize > 10000000 {
			return xdr.ElementSizeExceeded("Blocks", _BlocksSize, 10000000)
		}
		if _BlocksSize <= len(o.Blocks) {
			o.Blocks = o.Blocks[:_BlocksSize]
		} else {
			o.Blocks = make([]BlockInfo, _BlocksSize)
		}
		for i := range o.Blocks {
			(&o.Blocks[i]).UnmarshalXDRFrom(u)
		}
	}
	return u.Error
}

/*

BlockInfo Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Size                              |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                  Hash (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct BlockInfo {
	int Size;
	opaque Hash<64>;
}

*/

func (o BlockInfo) XDRSize() int {
	return 4 +
		4 + len(o.Hash) + xdr.Padding(len(o.Hash))
}

func (o BlockInfo) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o BlockInfo) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o BlockInfo) MarshalXDRInto(m *xdr.Marshaller) error {
	m.MarshalUint32(uint32(o.Size))
	if l := len(o.Hash); l > 64 {
		return xdr.ElementSizeExceeded("Hash", l, 64)
	}
	m.MarshalBytes(o.Hash)
	return m.Error
}

func (o *BlockInfo) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *BlockInfo) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.Size = int32(u.UnmarshalUint32())
	o.Hash = u.UnmarshalBytesMax(64)
	return u.Error
}

/*

RequestMessage Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                 Folder (length + padded data)                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                  Name (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                                                               |
+                       Offset (64 bits)                        +
|                                                               |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Size                              |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                  Hash (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Flags                             |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Options                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                Zero or more Option Structures                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct RequestMessage {
	string Folder<256>;
	string Name<8192>;
	hyper Offset;
	int Size;
	opaque Hash<64>;
	unsigned int Flags;
	Option Options<64>;
}

*/

func (o RequestMessage) XDRSize() int {
	return 4 + len(o.Folder) + xdr.Padding(len(o.Folder)) +
		4 + len(o.Name) + xdr.Padding(len(o.Name)) + 8 + 4 +
		4 + len(o.Hash) + xdr.Padding(len(o.Hash)) + 4 +
		4 + xdr.SizeOfSlice(o.Options)
}

func (o RequestMessage) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o RequestMessage) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o RequestMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.Folder); l > 256 {
		return xdr.ElementSizeExceeded("Folder", l, 256)
	}
	m.MarshalString(o.Folder)
	if l := len(o.Name); l > 8192 {
		return xdr.ElementSizeExceeded("Name", l, 8192)
	}
	m.MarshalString(o.Name)
	m.MarshalUint64(uint64(o.Offset))
	m.MarshalUint32(uint32(o.Size))
	if l := len(o.Hash); l > 64 {
		return xdr.ElementSizeExceeded("Hash", l, 64)
	}
	m.MarshalBytes(o.Hash)
	m.MarshalUint32(o.Flags)
	if l := len(o.Options); l > 64 {
		return xdr.ElementSizeExceeded("Options", l, 64)
	}
	m.MarshalUint32(uint32(len(o.Options)))
	for i := range o.Options {
		if err := o.Options[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	return m.Error
}

func (o *RequestMessage) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *RequestMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.Folder = u.UnmarshalStringMax(256)
	o.Name = u.UnmarshalStringMax(8192)
	o.Offset = int64(u.UnmarshalUint64())
	o.Size = int32(u.UnmarshalUint32())
	o.Hash = u.UnmarshalBytesMax(64)
	o.Flags = u.UnmarshalUint32()
	_OptionsSize := int(u.UnmarshalUint32())
	if _OptionsSize < 0 {
		return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
	} else if _OptionsSize == 0 {
		o.Options = nil
	} else {
		if _OptionsSize > 64 {
			return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
		}
		if _OptionsSize <= len(o.Options) {
			o.Options = o.Options[:_OptionsSize]
		} else {
			o.Options = make([]Option, _OptionsSize)
		}
		for i := range o.Options {
			(&o.Options[i]).UnmarshalXDRFrom(u)
		}
	}
	return u.Error
}

/*

ResponseMessage Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                  Data (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Code                              |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct ResponseMessage {
	opaque Data<>;
	int Code;
}

*/

func (o ResponseMessage) XDRSize() int {
	return 4 + len(o.Data) + xdr.Padding(len(o.Data)) + 4
}

func (o ResponseMessage) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o ResponseMessage) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o ResponseMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	m.MarshalBytes(o.Data)
	m.MarshalUint32(uint32(o.Code))
	return m.Error
}

func (o *ResponseMessage) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *ResponseMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.Data = u.UnmarshalBytes()
	o.Code = int32(u.UnmarshalUint32())
	return u.Error
}

/*

ClusterConfigMessage Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Folders                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                Zero or more Folder Structures                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Options                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                Zero or more Option Structures                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct ClusterConfigMessage {
	Folder Folders<1000000>;
	Option Options<64>;
}

*/

func (o ClusterConfigMessage) XDRSize() int {
	return 4 + xdr.SizeOfSlice(o.Folders) +
		4 + xdr.SizeOfSlice(o.Options)
}

func (o ClusterConfigMessage) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o ClusterConfigMessage) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o ClusterConfigMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.Folders); l > 1000000 {
		return xdr.ElementSizeExceeded("Folders", l, 1000000)
	}
	m.MarshalUint32(uint32(len(o.Folders)))
	for i := range o.Folders {
		if err := o.Folders[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	if l := len(o.Options); l > 64 {
		return xdr.ElementSizeExceeded("Options", l, 64)
	}
	m.MarshalUint32(uint32(len(o.Options)))
	for i := range o.Options {
		if err := o.Options[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	return m.Error
}

func (o *ClusterConfigMessage) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *ClusterConfigMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	_FoldersSize := int(u.UnmarshalUint32())
	if _FoldersSize < 0 {
		return xdr.ElementSizeExceeded("Folders", _FoldersSize, 1000000)
	} else if _FoldersSize == 0 {
		o.Folders = nil
	} else {
		if _FoldersSize > 1000000 {
			return xdr.ElementSizeExceeded("Folders", _FoldersSize, 1000000)
		}
		if _FoldersSize <= len(o.Folders) {
			o.Folders = o.Folders[:_FoldersSize]
		} else {
			o.Folders = make([]Folder, _FoldersSize)
		}
		for i := range o.Folders {
			(&o.Folders[i]).UnmarshalXDRFrom(u)
		}
	}
	_OptionsSize := int(u.UnmarshalUint32())
	if _OptionsSize < 0 {
		return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
	} else if _OptionsSize == 0 {
		o.Options = nil
	} else {
		if _OptionsSize > 64 {
			return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
		}
		if _OptionsSize <= len(o.Options) {
			o.Options = o.Options[:_OptionsSize]
		} else {
			o.Options = make([]Option, _OptionsSize)
		}
		for i := range o.Options {
			(&o.Options[i]).UnmarshalXDRFrom(u)
		}
	}
	return u.Error
}

/*

DownloadProgressMessage Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                 Folder (length + padded data)                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Updates                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\      Zero or more FileDownloadProgressUpdate Structures       \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Flags                             |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Options                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                Zero or more Option Structures                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct DownloadProgressMessage {
	string Folder<64>;
	FileDownloadProgressUpdate Updates<1000000>;
	unsigned int Flags;
	Option Options<64>;
}

*/

func (o DownloadProgressMessage) XDRSize() int {
	return 4 + len(o.Folder) + xdr.Padding(len(o.Folder)) +
		4 + xdr.SizeOfSlice(o.Updates) + 4 +
		4 + xdr.SizeOfSlice(o.Options)
}

func (o DownloadProgressMessage) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o DownloadProgressMessage) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o DownloadProgressMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.Folder); l > 64 {
		return xdr.ElementSizeExceeded("Folder", l, 64)
	}
	m.MarshalString(o.Folder)
	if l := len(o.Updates); l > 1000000 {
		return xdr.ElementSizeExceeded("Updates", l, 1000000)
	}
	m.MarshalUint32(uint32(len(o.Updates)))
	for i := range o.Updates {
		if err := o.Updates[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	m.MarshalUint32(o.Flags)
	if l := len(o.Options); l > 64 {
		return xdr.ElementSizeExceeded("Options", l, 64)
	}
	m.MarshalUint32(uint32(len(o.Options)))
	for i := range o.Options {
		if err := o.Options[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	return m.Error
}

func (o *DownloadProgressMessage) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *DownloadProgressMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.Folder = u.UnmarshalStringMax(64)
	_UpdatesSize := int(u.UnmarshalUint32())
	if _UpdatesSize < 0 {
		return xdr.ElementSizeExceeded("Updates", _UpdatesSize, 1000000)
	} else if _UpdatesSize == 0 {
		o.Updates = nil
	} else {
		if _UpdatesSize > 1000000 {
			return xdr.ElementSizeExceeded("Updates", _UpdatesSize, 1000000)
		}
		if _UpdatesSize <= len(o.Updates) {
			o.Updates = o.Updates[:_UpdatesSize]
		} else {
			o.Updates = make([]FileDownloadProgressUpdate, _UpdatesSize)
		}
		for i := range o.Updates {
			(&o.Updates[i]).UnmarshalXDRFrom(u)
		}
	}
	o.Flags = u.UnmarshalUint32()
	_OptionsSize := int(u.UnmarshalUint32())
	if _OptionsSize < 0 {
		return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
	} else if _OptionsSize == 0 {
		o.Options = nil
	} else {
		if _OptionsSize > 64 {
			return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
		}
		if _OptionsSize <= len(o.Options) {
			o.Options = o.Options[:_OptionsSize]
		} else {
			o.Options = make([]Option, _OptionsSize)
		}
		for i := range o.Options {
			(&o.Options[i]).UnmarshalXDRFrom(u)
		}
	}
	return u.Error
}

/*

Folder Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                   ID (length + padded data)                   \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                 Label (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Devices                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                Zero or more Device Structures                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Flags                             |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Options                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                Zero or more Option Structures                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct Folder {
	string ID<256>;
	string Label<256>;
	Device Devices<1000000>;
	unsigned int Flags;
	Option Options<64>;
}

*/

func (o Folder) XDRSize() int {
	return 4 + len(o.ID) + xdr.Padding(len(o.ID)) +
		4 + len(o.Label) + xdr.Padding(len(o.Label)) +
		4 + xdr.SizeOfSlice(o.Devices) + 4 +
		4 + xdr.SizeOfSlice(o.Options)
}

func (o Folder) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o Folder) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o Folder) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.ID); l > 256 {
		return xdr.ElementSizeExceeded("ID", l, 256)
	}
	m.MarshalString(o.ID)
	if l := len(o.Label); l > 256 {
		return xdr.ElementSizeExceeded("Label", l, 256)
	}
	m.MarshalString(o.Label)
	if l := len(o.Devices); l > 1000000 {
		return xdr.ElementSizeExceeded("Devices", l, 1000000)
	}
	m.MarshalUint32(uint32(len(o.Devices)))
	for i := range o.Devices {
		if err := o.Devices[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	m.MarshalUint32(o.Flags)
	if l := len(o.Options); l > 64 {
		return xdr.ElementSizeExceeded("Options", l, 64)
	}
	m.MarshalUint32(uint32(len(o.Options)))
	for i := range o.Options {
		if err := o.Options[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	return m.Error
}

func (o *Folder) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *Folder) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.ID = u.UnmarshalStringMax(256)
	o.Label = u.UnmarshalStringMax(256)
	_DevicesSize := int(u.UnmarshalUint32())
	if _DevicesSize < 0 {
		return xdr.ElementSizeExceeded("Devices", _DevicesSize, 1000000)
	} else if _DevicesSize == 0 {
		o.Devices = nil
	} else {
		if _DevicesSize > 1000000 {
			return xdr.ElementSizeExceeded("Devices", _DevicesSize, 1000000)
		}
		if _DevicesSize <= len(o.Devices) {
			o.Devices = o.Devices[:_DevicesSize]
		} else {
			o.Devices = make([]Device, _DevicesSize)
		}
		for i := range o.Devices {
			(&o.Devices[i]).UnmarshalXDRFrom(u)
		}
	}
	o.Flags = u.UnmarshalUint32()
	_OptionsSize := int(u.UnmarshalUint32())
	if _OptionsSize < 0 {
		return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
	} else if _OptionsSize == 0 {
		o.Options = nil
	} else {
		if _OptionsSize > 64 {
			return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
		}
		if _OptionsSize <= len(o.Options) {
			o.Options = o.Options[:_OptionsSize]
		} else {
			o.Options = make([]Option, _OptionsSize)
		}
		for i := range o.Options {
			(&o.Options[i]).UnmarshalXDRFrom(u)
		}
	}
	return u.Error
}

/*

Device Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                   ID (length + padded data)                   \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                  Name (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                      Number of Addresses                      |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
/                                                               /
\               Addresses (length + padded data)                \
/                                                               /
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                          Compression                          |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\               Cert Name (length + padded data)                \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                                                               |
+                  Max Local Version (64 bits)                  +
|                                                               |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Flags                             |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                       Number of Options                       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                Zero or more Option Structures                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct Device {
	opaque ID<32>;
	string Name<64>;
	string Addresses<64>;
	unsigned int Compression;
	string CertName<64>;
	hyper MaxLocalVersion;
	unsigned int Flags;
	Option Options<64>;
}

*/

func (o Device) XDRSize() int {
	return 4 + len(o.ID) + xdr.Padding(len(o.ID)) +
		4 + len(o.Name) + xdr.Padding(len(o.Name)) +
		4 + xdr.SizeOfSlice(o.Addresses) + 4 +
		4 + len(o.CertName) + xdr.Padding(len(o.CertName)) + 8 + 4 +
		4 + xdr.SizeOfSlice(o.Options)
}

func (o Device) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o Device) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o Device) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.ID); l > 32 {
		return xdr.ElementSizeExceeded("ID", l, 32)
	}
	m.MarshalBytes(o.ID)
	if l := len(o.Name); l > 64 {
		return xdr.ElementSizeExceeded("Name", l, 64)
	}
	m.MarshalString(o.Name)
	if l := len(o.Addresses); l > 64 {
		return xdr.ElementSizeExceeded("Addresses", l, 64)
	}
	m.MarshalUint32(uint32(len(o.Addresses)))
	for i := range o.Addresses {
		m.MarshalString(o.Addresses[i])
	}
	m.MarshalUint32(o.Compression)
	if l := len(o.CertName); l > 64 {
		return xdr.ElementSizeExceeded("CertName", l, 64)
	}
	m.MarshalString(o.CertName)
	m.MarshalUint64(uint64(o.MaxLocalVersion))
	m.MarshalUint32(o.Flags)
	if l := len(o.Options); l > 64 {
		return xdr.ElementSizeExceeded("Options", l, 64)
	}
	m.MarshalUint32(uint32(len(o.Options)))
	for i := range o.Options {
		if err := o.Options[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	return m.Error
}

func (o *Device) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *Device) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.ID = u.UnmarshalBytesMax(32)
	o.Name = u.UnmarshalStringMax(64)
	_AddressesSize := int(u.UnmarshalUint32())
	if _AddressesSize < 0 {
		return xdr.ElementSizeExceeded("Addresses", _AddressesSize, 64)
	} else if _AddressesSize == 0 {
		o.Addresses = nil
	} else {
		if _AddressesSize > 64 {
			return xdr.ElementSizeExceeded("Addresses", _AddressesSize, 64)
		}
		if _AddressesSize <= len(o.Addresses) {
			for i := _AddressesSize; i < len(o.Addresses); i++ {
				o.Addresses[i] = ""
			}
			o.Addresses = o.Addresses[:_AddressesSize]
		} else {
			o.Addresses = make([]string, _AddressesSize)
		}
		for i := range o.Addresses {
			o.Addresses[i] = u.UnmarshalStringMax(2083)
		}
	}
	o.Compression = u.UnmarshalUint32()
	o.CertName = u.UnmarshalStringMax(64)
	o.MaxLocalVersion = int64(u.UnmarshalUint64())
	o.Flags = u.UnmarshalUint32()
	_OptionsSize := int(u.UnmarshalUint32())
	if _OptionsSize < 0 {
		return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
	} else if _OptionsSize == 0 {
		o.Options = nil
	} else {
		if _OptionsSize > 64 {
			return xdr.ElementSizeExceeded("Options", _OptionsSize, 64)
		}
		if _OptionsSize <= len(o.Options) {
			o.Options = o.Options[:_OptionsSize]
		} else {
			o.Options = make([]Option, _OptionsSize)
		}
		for i := range o.Options {
			(&o.Options[i]).UnmarshalXDRFrom(u)
		}
	}
	return u.Error
}

/*

FileDownloadProgressUpdate Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                          Update Type                          |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                  Name (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                       Vector Structure                        \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                    Number of Block Indexes                    |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
|                    Block Indexes (n items)                    |
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct FileDownloadProgressUpdate {
	unsigned int UpdateType;
	string Name<8192>;
	Vector Version;
	int BlockIndexes<1000000>;
}

*/

func (o FileDownloadProgressUpdate) XDRSize() int {
	return 4 +
		4 + len(o.Name) + xdr.Padding(len(o.Name)) +
		o.Version.XDRSize() +
		4 + len(o.BlockIndexes)*4
}

func (o FileDownloadProgressUpdate) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o FileDownloadProgressUpdate) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o FileDownloadProgressUpdate) MarshalXDRInto(m *xdr.Marshaller) error {
	m.MarshalUint32(o.UpdateType)
	if l := len(o.Name); l > 8192 {
		return xdr.ElementSizeExceeded("Name", l, 8192)
	}
	m.MarshalString(o.Name)
	if err := o.Version.MarshalXDRInto(m); err != nil {
		return err
	}
	if l := len(o.BlockIndexes); l > 1000000 {
		return xdr.ElementSizeExceeded("BlockIndexes", l, 1000000)
	}
	m.MarshalUint32(uint32(len(o.BlockIndexes)))
	for i := range o.BlockIndexes {
		m.MarshalUint32(uint32(o.BlockIndexes[i]))
	}
	return m.Error
}

func (o *FileDownloadProgressUpdate) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *FileDownloadProgressUpdate) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.UpdateType = u.UnmarshalUint32()
	o.Name = u.UnmarshalStringMax(8192)
	(&o.Version).UnmarshalXDRFrom(u)
	_BlockIndexesSize := int(u.UnmarshalUint32())
	if _BlockIndexesSize < 0 {
		return xdr.ElementSizeExceeded("BlockIndexes", _BlockIndexesSize, 1000000)
	} else if _BlockIndexesSize == 0 {
		o.BlockIndexes = nil
	} else {
		if _BlockIndexesSize > 1000000 {
			return xdr.ElementSizeExceeded("BlockIndexes", _BlockIndexesSize, 1000000)
		}
		if _BlockIndexesSize <= len(o.BlockIndexes) {
			o.BlockIndexes = o.BlockIndexes[:_BlockIndexesSize]
		} else {
			o.BlockIndexes = make([]int32, _BlockIndexesSize)
		}
		for i := range o.BlockIndexes {
			o.BlockIndexes[i] = int32(u.UnmarshalUint32())
		}
	}
	return u.Error
}

/*

Option Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                  Key (length + padded data)                   \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                 Value (length + padded data)                  \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct Option {
	string Key<64>;
	string Value<1024>;
}

*/

func (o Option) XDRSize() int {
	return 4 + len(o.Key) + xdr.Padding(len(o.Key)) +
		4 + len(o.Value) + xdr.Padding(len(o.Value))
}

func (o Option) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o Option) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o Option) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.Key); l > 64 {
		return xdr.ElementSizeExceeded("Key", l, 64)
	}
	m.MarshalString(o.Key)
	if l := len(o.Value); l > 1024 {
		return xdr.ElementSizeExceeded("Value", l, 1024)
	}
	m.MarshalString(o.Value)
	return m.Error
}

func (o *Option) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *Option) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.Key = u.UnmarshalStringMax(64)
	o.Value = u.UnmarshalStringMax(1024)
	return u.Error
}

/*

CloseMessage Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                 Reason (length + padded data)                 \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             Code                              |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct CloseMessage {
	string Reason<1024>;
	int Code;
}

*/

func (o CloseMessage) XDRSize() int {
	return 4 + len(o.Reason) + xdr.Padding(len(o.Reason)) + 4
}

func (o CloseMessage) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o CloseMessage) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o CloseMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.Reason); l > 1024 {
		return xdr.ElementSizeExceeded("Reason", l, 1024)
	}
	m.MarshalString(o.Reason)
	m.MarshalUint32(uint32(o.Code))
	return m.Error
}

func (o *CloseMessage) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *CloseMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.Reason = u.UnmarshalStringMax(1024)
	o.Code = int32(u.UnmarshalUint32())
	return u.Error
}

/*

EmptyMessage Structure:
(contains no fields)


struct EmptyMessage {
}

*/

func (o EmptyMessage) XDRSize() int {
	return 0
}
func (o EmptyMessage) MarshalXDR() ([]byte, error) {
	return nil, nil
}

func (o EmptyMessage) MustMarshalXDR() []byte {
	return nil
}

func (o EmptyMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	return nil
}

func (o *EmptyMessage) UnmarshalXDR(bs []byte) error {
	return nil
}

func (o *EmptyMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	return nil
}
