/* smd-applet.c generated by valac 0.16.0, the Vala compiler
 * generated from smd-applet.vala, do not modify */

/* Released under the terms of GPLv3 or at your option any later version.*/
/* No warranties.*/
/* Copyright Enrico Tassi <gares@fettunta.org>*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <libnotify/notify.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include "smd-config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_NETWORK_MANAGER (network_manager_get_type ())
#define NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NETWORK_MANAGER, NetworkManager))
#define IS_NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NETWORK_MANAGER))
#define NETWORK_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NETWORK_MANAGER, NetworkManagerIface))

typedef struct _NetworkManager NetworkManager;
typedef struct _NetworkManagerIface NetworkManagerIface;

#define TYPE_NETWORK_MANAGER_PROXY (network_manager_proxy_get_type ())
typedef GDBusProxy NetworkManagerProxy;
typedef GDBusProxyClass NetworkManagerProxyClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
typedef struct _EventPrivate EventPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _event_unref0(var) ((var == NULL) ? NULL : (var = (event_unref (var), NULL)))
typedef struct _ParamSpecEvent ParamSpecEvent;

#define TYPE_SMD_APPLET (smd_applet_get_type ())
#define SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SMD_APPLET, smdApplet))
#define SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SMD_APPLET, smdAppletClass))
#define IS_SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SMD_APPLET))
#define IS_SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SMD_APPLET))
#define SMD_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SMD_APPLET, smdAppletClass))

typedef struct _smdApplet smdApplet;
typedef struct _smdAppletClass smdAppletClass;
typedef struct _smdAppletPrivate smdAppletPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _smd_applet_unref0(var) ((var == NULL) ? NULL : (var = (smd_applet_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecsmdApplet ParamSpecsmdApplet;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

typedef enum  {
	EXIT_ABORT
} Exit;
#define EXIT exit_quark ()
struct _NetworkManagerIface {
	GTypeInterface parent_iface;
	guint (*get_state) (NetworkManager* self);
};

struct _Event {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EventPrivate * priv;
	gchar* message;
	gchar* message_icon;
	gboolean enter_network_error_mode;
	gboolean enter_error_mode;
	gboolean transient_error_message;
	gchar* context;
	gchar* cause;
	gchar* permissions;
	gchar* mail_name;
	gchar* mail_body;
	GeeArrayList* commands;
};

struct _EventClass {
	GTypeClass parent_class;
	void (*finalize) (Event *self);
};

struct _ParamSpecEvent {
	GParamSpec parent_instance;
};

struct _smdApplet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	smdAppletPrivate * priv;
};

struct _smdAppletClass {
	GTypeClass parent_class;
	void (*finalize) (smdApplet *self);
};

struct _smdAppletPrivate {
	GtkBuilder* builder;
	GtkMenu* menuL;
	GtkMenu* menuR;
	GtkStatusIcon* si;
	GtkWindow* win;
	GtkWindow* err_win;
	GtkWindow* log_win;
	GtkAboutDialog* about_win;
	GtkCheckMenuItem* miPause;
	GtkComboBoxText* cblogs;
	GeeArrayList* lognames;
	GConfClient* gconf;
	GThread* thread;
	gboolean thread_die;
	GPid pid;
	GMutex events_lock;
	GeeArrayList* events;
	gboolean error_mode;
	gboolean network_error_mode;
	gboolean config_wait_mode;
	GHashTable* command_hash;
	NetworkManager* net_manager;
	NotifyNotification* notification;
	gboolean notification_server_has_persistence;
};

struct _ParamSpecsmdApplet {
	GParamSpec parent_instance;
};


extern gboolean verbose;
gboolean verbose = FALSE;
static gpointer event_parent_class = NULL;
extern gchar* SMD_LOGS_DIR;
gchar* SMD_LOGS_DIR = NULL;
extern gchar* SMD_LOOP_CFG;
gchar* SMD_LOOP_CFG = NULL;
extern gchar* SMD_PP_DEF_CFG;
gchar* SMD_PP_DEF_CFG = NULL;
extern gchar* XDG_AUTORUN_FILE;
gchar* XDG_AUTORUN_FILE = NULL;
static gpointer smd_applet_parent_class = NULL;
extern gchar* smd_applet_smd_loop_cmd;
gchar* smd_applet_smd_loop_cmd = NULL;
extern gchar* smd_applet_smd_applet_ui;
gchar* smd_applet_smd_applet_ui = NULL;
extern gchar* smd_applet_smd_push_cmd;
gchar* smd_applet_smd_push_cmd = NULL;
extern gchar* smd_applet_smd_applet_desktop;
gchar* smd_applet_smd_applet_desktop = NULL;

GQuark exit_quark (void);
void debug (const gchar* message);
GType network_manager_get_type (void) G_GNUC_CONST;
GType network_manager_proxy_get_type (void) G_GNUC_CONST;
guint network_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
guint network_manager_get_state (NetworkManager* self);
static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters);
static guint network_manager_dbus_proxy_get_state (NetworkManager* self);
static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface);
static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_network_manager_get_state (NetworkManager* self);
static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data);
static void _network_manager_unregister_object (gpointer user_data);
#define NM_SERVICE "org.freedesktop.NetworkManager"
#define NM_PATH "/org/freedesktop/NetworkManager"
gboolean is_nm_connected (guint code);
gpointer event_ref (gpointer instance);
void event_unref (gpointer instance);
GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_event (GValue* value, gpointer v_object);
void value_take_event (GValue* value, gpointer v_object);
gpointer value_get_event (const GValue* value);
GType event_get_type (void) G_GNUC_CONST;
enum  {
	EVENT_DUMMY_PROPERTY
};
Event* event_error (const gchar* account, const gchar* host, const gchar* context, const gchar* cause, const gchar* permissions, const gchar* mail_name, const gchar* mail_body, GeeArrayList* commands);
Event* event_new (void);
Event* event_construct (GType object_type);
Event* event_generic_error (const gchar* cause);
Event* event_network_error (void);
Event* event_stats (const gchar* account, const gchar* host, gint new_mails, gint del_mails);
gboolean event_is_error_event (Event* self);
static void event_finalize (Event* obj);
#define SMD_LOOP "/bin/smd-loop"
#define SMD_PUSH "/bin/smd-push"
#define SMD_APPLET_UI "/share/syncmaildir-applet/smd-applet.ui"
#define SMD_APPLET_DESKTOP "/share/applications/smd-applet.desktop"
#define GNOME_AUTOSTART_DISABLED "X-GNOME-Autostart-enabled=false"
gpointer smd_applet_ref (gpointer instance);
void smd_applet_unref (gpointer instance);
GParamSpec* param_spec_smd_applet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_smd_applet (GValue* value, gpointer v_object);
void value_take_smd_applet (GValue* value, gpointer v_object);
gpointer value_get_smd_applet (const GValue* value);
GType smd_applet_get_type (void) G_GNUC_CONST;
#define SMD_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SMD_APPLET, smdAppletPrivate))
enum  {
	SMD_APPLET_DUMMY_PROPERTY
};
#define SMD_APPLET_key_icon "/apps/smd-applet/icon_only_on_errors"
#define SMD_APPLET_key_newmail "/apps/smd-applet/notify_new_mail"
smdApplet* smd_applet_new (gboolean hide_status_icon, GError** error);
smdApplet* smd_applet_construct (GType object_type, gboolean hide_status_icon, GError** error);
static void ___lambda2_ (smdApplet* self, guint s);
static void ____lambda2__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self);
static void __lambda3_ (smdApplet* self, GtkComboBox* cb);
static void ___lambda3__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void smd_applet_close_logs_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_logs_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean smd_applet_close_logs_event (smdApplet* self, GdkEventAny* e);
static gboolean _smd_applet_close_logs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void smd_applet_close_prefs_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_prefs_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda5_ (smdApplet* self, GtkToggleButton* b);
static void ___lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda6_ (smdApplet* self, GtkToggleButton* b);
static void ___lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda7_ (smdApplet* self, GtkToggleButton* b);
static void ___lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void smd_applet_close_err_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda8_ (smdApplet* self, GtkButton* b);
static gboolean smd_applet_is_smd_loop_configured (smdApplet* self);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda9_ (smdApplet* self, GtkButton* b);
static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda10_ (smdApplet* self, GtkMenuItem* b);
static void ___lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda11_ (smdApplet* self, GtkCheckMenuItem* b);
static void smd_applet_pause (smdApplet* self);
static void smd_applet_unpause (smdApplet* self);
static void ___lambda11__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda12_ (smdApplet* self, gint id);
static void ___lambda12__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void __lambda13_ (smdApplet* self, GtkMenuItem* b);
static void ___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda14_ (smdApplet* self, GtkMenuItem* b);
static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda15_ (smdApplet* self, GtkMenuItem* b);
static void smd_applet_update_loglist (smdApplet* self);
static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda16_ (smdApplet* self, guint button, guint time);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void ___lambda16__gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void __lambda17_ (smdApplet* self, GtkStatusIcon* s);
static void ___lambda17__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void* smd_applet_smdThread (smdApplet* self);
static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error);
static void smd_applet_start_smdThread (smdApplet* self, gboolean force);
static gpointer _smd_applet_smdThread_gthread_func (gpointer self);
static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const gchar* args, const gchar* account, const gchar* host, GError** error);
static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const gchar* s);
static void ___lambda4_ (smdApplet* self);
static void ____lambda4__gspawn_child_setup_func (gpointer self);
static gboolean smd_applet_eat_event (smdApplet* self);
static void ______lambda18_ (smdApplet* self, NotifyNotification* not, const gchar* action);
static void _______lambda18__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void ______lambda19_ (smdApplet* self, GtkButton* b);
static void _______lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void smd_applet_reset_to_regular_run (smdApplet* self, gboolean force);
static gboolean smd_applet_close_err_event (smdApplet* self, GdkEventAny* e);
static void smd_applet_close_prefs (smdApplet* self);
static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEventAny* e);
static gboolean smd_applet_is_smd_stack_configured (smdApplet* self);
static void smd_applet_close_logs (smdApplet* self);
static void smd_applet_my_gtk_main_quit_button (smdApplet* self, GtkButton* b);
static gboolean smd_applet_my_gtk_main_quit_event (smdApplet* self, GdkEventAny* b);
void smd_applet_run (smdApplet* self, GError** error);
static gboolean _smd_applet_eat_event_gsource_func (gpointer self);
static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
void smd_applet_configure (smdApplet* self);
static void _smd_applet_my_gtk_main_quit_button_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void smd_applet_finalize (smdApplet* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusMethodInfo * const _network_manager_dbus_method_info[] = {NULL};
static const GDBusArgInfo _network_manager_dbus_arg_info_state_changed_state = {-1, "state", "u"};
static const GDBusArgInfo * const _network_manager_dbus_arg_info_state_changed[] = {&_network_manager_dbus_arg_info_state_changed_state, NULL};
static const GDBusSignalInfo _network_manager_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_network_manager_dbus_arg_info_state_changed)};
static const GDBusSignalInfo * const _network_manager_dbus_signal_info[] = {&_network_manager_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo _network_manager_dbus_property_info_state = {-1, "State", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _network_manager_dbus_property_info[] = {&_network_manager_dbus_property_info_state, NULL};
static const GDBusInterfaceInfo _network_manager_dbus_interface_info = {-1, "org.freedesktop.NetworkManager", (GDBusMethodInfo **) (&_network_manager_dbus_method_info), (GDBusSignalInfo **) (&_network_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_network_manager_dbus_property_info)};
static const GDBusInterfaceVTable _network_manager_dbus_interface_vtable = {network_manager_dbus_interface_method_call, network_manager_dbus_interface_get_property, network_manager_dbus_interface_set_property};

GQuark exit_quark (void) {
	return g_quark_from_static_string ("exit-quark");
}


void debug (const gchar* message) {
	gboolean _tmp0_;
	g_return_if_fail (message != NULL);
	_tmp0_ = verbose;
	if (_tmp0_) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = stderr;
		_tmp2_ = message;
		fprintf (_tmp1_, "DEBUG: %s\n", _tmp2_);
	}
}


guint network_manager_get_state (NetworkManager* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return NETWORK_MANAGER_GET_INTERFACE (self)->get_state (self);
}


static void network_manager_base_init (NetworkManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("state_changed", TYPE_NETWORK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	}
}


GType network_manager_get_type (void) {
	static volatile gsize network_manager_type_id__volatile = 0;
	if (g_once_init_enter (&network_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetworkManagerIface), (GBaseInitFunc) network_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType network_manager_type_id;
		network_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetworkManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (network_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) network_manager_proxy_get_type);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.NetworkManager");
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) network_manager_register_object);
		g_once_init_leave (&network_manager_type_id__volatile, network_manager_type_id);
	}
	return network_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (NetworkManagerProxy, network_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_NETWORK_MANAGER, network_manager_proxy_network_manager_interface_init) )
static void network_manager_proxy_class_init (NetworkManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = network_manager_proxy_g_signal;
}


static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint state = 0U;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	state = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "state-changed", state);
}


static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StateChanged") == 0) {
		_dbus_handle_network_manager_state_changed ((NetworkManager*) proxy, parameters);
	}
}


static void network_manager_proxy_init (NetworkManagerProxy* self) {
}


static guint network_manager_dbus_proxy_get_state (NetworkManager* self) {
	GVariant *_inner_reply;
	guint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "State");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.NetworkManager"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("State"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0U;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface) {
	iface->get_state = network_manager_dbus_proxy_get_state;
}


static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_network_manager_get_state (NetworkManager* self) {
	guint result;
	GVariant* _reply;
	result = network_manager_get_state (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "State") == 0) {
		return _dbus_network_manager_get_state (object);
	}
	return NULL;
}


static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (state));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.NetworkManager", "StateChanged", _arguments, NULL);
}


guint network_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_network_manager_dbus_interface_info), &_network_manager_dbus_interface_vtable, data, _network_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_network_manager_state_changed, data);
	return result;
}


static void _network_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_network_manager_state_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gboolean is_nm_connected (guint code) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp3_;
	_tmp1_ = code;
	if (_tmp1_ == ((guint) 3)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_;
		_tmp2_ = code;
		_tmp0_ = _tmp2_ == ((guint) 70);
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Event* event_error (const gchar* account, const gchar* host, const gchar* context, const gchar* cause, const gchar* permissions, const gchar* mail_name, const gchar* mail_body, GeeArrayList* commands) {
	Event* result = NULL;
	Event* _tmp0_;
	Event* e;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (cause != NULL, NULL);
	g_return_val_if_fail (commands != NULL, NULL);
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strdup ("An error occurred, click on the icon for more details");
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("error");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->enter_error_mode = TRUE;
	_tmp3_ = cause;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (e->cause);
	e->cause = _tmp4_;
	_tmp5_ = context;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (e->context);
	e->context = _tmp6_;
	_tmp7_ = permissions;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (e->permissions);
	e->permissions = _tmp8_;
	_tmp9_ = mail_name;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (e->mail_name);
	e->mail_name = _tmp10_;
	_tmp11_ = mail_body;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (e->mail_body);
	e->mail_body = _tmp12_;
	_tmp13_ = commands;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (e->commands);
	e->commands = _tmp14_;
	result = e;
	return result;
}


Event* event_generic_error (const gchar* cause) {
	Event* result = NULL;
	Event* _tmp0_;
	Event* e;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (cause != NULL, NULL);
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = cause;
	_tmp2_ = g_strconcat ("A failure occurred: ", _tmp1_, NULL);
	_g_free0 (e->message);
	e->message = _tmp2_;
	_tmp3_ = g_strdup ("dialog-warning");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp3_;
	e->transient_error_message = TRUE;
	result = e;
	return result;
}


Event* event_network_error (void) {
	Event* result = NULL;
	Event* _tmp0_;
	Event* e;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strdup ("A persistent network failure occurred");
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("dialog-warning");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->enter_network_error_mode = TRUE;
	result = e;
	return result;
}


Event* event_stats (const gchar* account, const gchar* host, gint new_mails, gint del_mails) {
	Event* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* preamble;
	Event* _tmp2_;
	Event* e;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gboolean _tmp6_;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = g_strdup_printf ("Synchronize with %s:\n", _tmp0_);
	preamble = _tmp1_;
	_tmp2_ = event_new ();
	e = _tmp2_;
	_tmp4_ = new_mails;
	if (_tmp4_ > 0) {
		gint _tmp5_;
		_tmp5_ = del_mails;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		Event* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp7_ = e;
		_tmp8_ = preamble;
		_tmp9_ = new_mails;
		_tmp10_ = del_mails;
		_tmp11_ = g_strdup_printf ("%s%d new messages\n%d deleted messages", _tmp8_, _tmp9_, _tmp10_);
		_g_free0 (_tmp7_->message);
		_tmp7_->message = _tmp11_;
	} else {
		gint _tmp12_;
		_tmp12_ = new_mails;
		if (_tmp12_ > 0) {
			Event* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gchar* _tmp16_ = NULL;
			_tmp13_ = e;
			_tmp14_ = preamble;
			_tmp15_ = new_mails;
			_tmp16_ = g_strdup_printf ("%s%d new messages", _tmp14_, _tmp15_);
			_g_free0 (_tmp13_->message);
			_tmp13_->message = _tmp16_;
		} else {
			Event* _tmp17_;
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_ = NULL;
			_tmp17_ = e;
			_tmp18_ = preamble;
			_tmp19_ = del_mails;
			_tmp20_ = g_strdup_printf ("%s%d deleted messages", _tmp18_, _tmp19_);
			_g_free0 (_tmp17_->message);
			_tmp17_->message = _tmp20_;
		}
	}
	result = e;
	_g_free0 (preamble);
	return result;
}


gboolean event_is_error_event (Event* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->enter_error_mode;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = self->enter_network_error_mode;
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_;
		_tmp5_ = self->transient_error_message;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	result = _tmp6_;
	return result;
}


Event* event_construct (GType object_type) {
	Event* self = NULL;
	self = (Event*) g_type_create_instance (object_type);
	return self;
}


Event* event_new (void) {
	return event_construct (TYPE_EVENT);
}


static void value_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		event_unref (value->data[0].v_pointer);
	}
}


static void value_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Event* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Event** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT), NULL);
	return value->data[0].v_pointer;
}


void value_set_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


void value_take_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


static void event_class_init (EventClass * klass) {
	event_parent_class = g_type_class_peek_parent (klass);
	EVENT_CLASS (klass)->finalize = event_finalize;
}


static void event_instance_init (Event * self) {
	gchar* _tmp0_;
	self->message = NULL;
	_tmp0_ = g_strdup ("gtk-about");
	self->message_icon = _tmp0_;
	self->enter_network_error_mode = FALSE;
	self->enter_error_mode = FALSE;
	self->transient_error_message = FALSE;
	self->context = NULL;
	self->cause = NULL;
	self->permissions = NULL;
	self->mail_name = NULL;
	self->mail_body = NULL;
	self->commands = NULL;
	self->ref_count = 1;
}


static void event_finalize (Event* obj) {
	Event * self;
	self = EVENT (obj);
	_g_free0 (self->message);
	_g_free0 (self->message_icon);
	_g_free0 (self->context);
	_g_free0 (self->cause);
	_g_free0 (self->permissions);
	_g_free0 (self->mail_name);
	_g_free0 (self->mail_body);
	_g_object_unref0 (self->commands);
}


GType event_get_type (void) {
	static volatile gsize event_type_id__volatile = 0;
	if (g_once_init_enter (&event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_event_init, value_event_free_value, value_event_copy_value, value_event_peek_pointer, "p", value_event_collect_value, "p", value_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Event), 0, (GInstanceInitFunc) event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType event_type_id;
		event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Event", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&event_type_id__volatile, event_type_id);
	}
	return event_type_id__volatile;
}


gpointer event_ref (gpointer instance) {
	Event* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void event_unref (gpointer instance) {
	Event* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void ___lambda2_ (smdApplet* self, guint s) {
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = s;
	_tmp1_ = is_nm_connected (_tmp0_);
	if (_tmp1_) {
		GtkCheckMenuItem* _tmp2_;
		_tmp2_ = self->priv->miPause;
		gtk_check_menu_item_set_active (_tmp2_, FALSE);
	} else {
		GtkCheckMenuItem* _tmp3_;
		_tmp3_ = self->priv->miPause;
		gtk_check_menu_item_set_active (_tmp3_, TRUE);
	}
}


static void ____lambda2__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self) {
	___lambda2_ (self, state);
}


static void __lambda3_ (smdApplet* self, GtkComboBox* cb) {
	GtkComboBoxText* _tmp0_;
	gint _tmp1_ = 0;
	gint selected;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (cb != NULL);
	_tmp0_ = self->priv->cblogs;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	selected = _tmp1_;
	_tmp2_ = selected;
	if (_tmp2_ >= 0) {
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gpointer _tmp5_ = NULL;
		gchar* file;
		gchar* content = NULL;
		_tmp3_ = self->priv->lognames;
		_tmp4_ = selected;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
		file = (gchar*) _tmp5_;
		{
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp6_ = SMD_LOGS_DIR;
			_tmp7_ = file;
			_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
			_tmp9_ = _tmp8_;
			_tmp11_ = g_file_get_contents (_tmp9_, &_tmp10_, NULL, &_inner_error_);
			_g_free0 (content);
			content = _tmp10_;
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp9_);
			_tmp13_ = _tmp12_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch2_g_file_error;
				}
				_g_free0 (content);
				_g_free0 (file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (_tmp13_) {
				GtkBuilder* _tmp14_;
				GObject* _tmp15_ = NULL;
				GtkTextView* _tmp16_;
				GtkTextView* tv;
				GtkTextView* _tmp17_;
				GtkTextBuffer* _tmp18_ = NULL;
				GtkTextBuffer* _tmp19_;
				GtkTextBuffer* b;
				GtkTextBuffer* _tmp20_;
				const gchar* _tmp21_;
				GtkTextIter end_iter = {0};
				GtkTextBuffer* _tmp22_;
				GtkTextIter _tmp23_ = {0};
				GtkTextBuffer* _tmp24_;
				GtkTextIter _tmp25_;
				GtkTextMark* _tmp26_ = NULL;
				GtkTextMark* _tmp27_;
				GtkTextMark* end_mark;
				GtkTextView* _tmp28_;
				GtkTextMark* _tmp29_;
				_tmp14_ = self->priv->builder;
				_tmp15_ = gtk_builder_get_object (_tmp14_, "tvLog");
				_tmp16_ = _g_object_ref0 (GTK_IS_TEXT_VIEW (_tmp15_) ? ((GtkTextView*) _tmp15_) : NULL);
				tv = _tmp16_;
				_tmp17_ = tv;
				_tmp18_ = gtk_text_view_get_buffer (_tmp17_);
				_tmp19_ = _g_object_ref0 (_tmp18_);
				b = _tmp19_;
				_tmp20_ = b;
				_tmp21_ = content;
				gtk_text_buffer_set_text (_tmp20_, _tmp21_, -1);
				_tmp22_ = b;
				gtk_text_buffer_get_end_iter (_tmp22_, &_tmp23_);
				end_iter = _tmp23_;
				_tmp24_ = b;
				_tmp25_ = end_iter;
				_tmp26_ = gtk_text_buffer_create_mark (_tmp24_, "end", &_tmp25_, FALSE);
				_tmp27_ = _g_object_ref0 (_tmp26_);
				end_mark = _tmp27_;
				_tmp28_ = tv;
				_tmp29_ = end_mark;
				gtk_text_view_scroll_to_mark (_tmp28_, _tmp29_, 0.0, TRUE, 0.0, 0.0);
				_g_object_unref0 (end_mark);
				_g_object_unref0 (b);
				_g_object_unref0 (tv);
			} else {
				FILE* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp30_ = stderr;
				_tmp31_ = SMD_LOGS_DIR;
				_tmp32_ = file;
				_tmp33_ = g_strconcat (_tmp31_, _tmp32_, NULL);
				_tmp34_ = _tmp33_;
				fprintf (_tmp30_, "Unable to read %s\n", _tmp34_);
				_g_free0 (_tmp34_);
			}
		}
		goto __finally2;
		__catch2_g_file_error:
		{
			GError* e = NULL;
			FILE* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			GError* _tmp40_;
			const gchar* _tmp41_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp35_ = stderr;
			_tmp36_ = SMD_LOGS_DIR;
			_tmp37_ = file;
			_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = e;
			_tmp41_ = _tmp40_->message;
			fprintf (_tmp35_, "Unable to read %s: %s\n", _tmp39_, _tmp41_);
			_g_free0 (_tmp39_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			_g_free0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (content);
		_g_free0 (file);
	}
}


static void ___lambda3__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	__lambda3_ (self, _sender);
}


static void _smd_applet_close_logs_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_logs_action (self, _sender);
}


static gboolean _smd_applet_close_logs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_logs_event (self, event);
	return result;
}


static void _smd_applet_close_prefs_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_prefs_action (self, _sender);
}


static void __lambda5_ (smdApplet* self, GtkToggleButton* b) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		GConfClient* _tmp0_;
		GtkToggleButton* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		GConfClient* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		GtkStatusIcon* _tmp7_;
		_tmp0_ = self->priv->gconf;
		_tmp1_ = b;
		_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
		_tmp3_ = _tmp2_;
		gconf_client_set_bool (_tmp0_, SMD_APPLET_key_icon, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp4_ = self->priv->gconf;
		_tmp5_ = gconf_client_get_bool (_tmp4_, SMD_APPLET_key_icon, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp7_ = self->priv->si;
		gtk_status_icon_set_visible (_tmp7_, !_tmp6_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		fprintf (_tmp8_, "%s\n", _tmp10_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda5_ (self, _sender);
}


static void __lambda6_ (smdApplet* self, GtkToggleButton* b) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		GConfClient* _tmp0_;
		GtkToggleButton* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp0_ = self->priv->gconf;
		_tmp1_ = b;
		_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
		_tmp3_ = _tmp2_;
		gconf_client_set_bool (_tmp0_, SMD_APPLET_key_newmail, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda6_ (self, _sender);
}


static void __lambda7_ (smdApplet* self, GtkToggleButton* b) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = b;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gchar* content = NULL;
		{
			const gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp3_ = smd_applet_smd_applet_desktop;
			g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error_);
			_g_free0 (content);
			content = _tmp4_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch8_g_file_error;
				}
				_g_free0 (content);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp5_ = XDG_AUTORUN_FILE;
			_tmp6_ = content;
			g_file_set_contents (_tmp5_, _tmp6_, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch8_g_file_error;
				}
				_g_free0 (content);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally8;
		__catch8_g_file_error:
		{
			GError* e = NULL;
			FILE* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = stderr;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			fprintf (_tmp7_, "%s\n", _tmp9_);
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (content);
	} else {
		const gchar* _tmp10_;
		_tmp10_ = XDG_AUTORUN_FILE;
		g_remove (_tmp10_);
	}
}


static void ___lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda7_ (self, _sender);
}


static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_err_action (self, _sender);
}


static void __lambda8_ (smdApplet* self, GtkButton* b) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* cmd;
		const gchar* _tmp6_;
		_tmp0_ = smd_applet_is_smd_loop_configured (self);
		if (!_tmp0_) {
			const gchar* _tmp1_;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp1_ = smd_applet_smd_loop_cmd;
			_tmp2_ = g_strdup_printf ("%s -t", _tmp1_);
			_tmp3_ = _tmp2_;
			g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error_);
			_g_free0 (_tmp3_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch9_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = SMD_LOOP_CFG;
		_tmp5_ = g_strdup_printf ("gnome-open %s", _tmp4_);
		cmd = _tmp5_;
		_tmp6_ = cmd;
		g_spawn_command_line_async (_tmp6_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch9_g_spawn_error;
			}
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		smd_applet_is_smd_loop_configured (self);
		_g_free0 (cmd);
	}
	goto __finally9;
	__catch9_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda8_ (self, _sender);
}


static void __lambda9_ (smdApplet* self, GtkButton* b) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* cmd;
		const gchar* _tmp6_;
		_tmp0_ = smd_applet_is_smd_pushpull_configured (self);
		if (!_tmp0_) {
			const gchar* _tmp1_;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp1_ = smd_applet_smd_push_cmd;
			_tmp2_ = g_strdup_printf ("%s -t", _tmp1_);
			_tmp3_ = _tmp2_;
			g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error_);
			_g_free0 (_tmp3_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch10_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = SMD_PP_DEF_CFG;
		_tmp5_ = g_strdup_printf ("gnome-open %s", _tmp4_);
		cmd = _tmp5_;
		_tmp6_ = cmd;
		g_spawn_command_line_async (_tmp6_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch10_g_spawn_error;
			}
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		smd_applet_is_smd_pushpull_configured (self);
		_g_free0 (cmd);
	}
	goto __finally10;
	__catch10_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda9_ (self, _sender);
}


static void __lambda10_ (smdApplet* self, GtkMenuItem* b) {
	GPid _tmp0_;
	g_return_if_fail (b != NULL);
	self->priv->thread_die = TRUE;
	_tmp0_ = self->priv->pid;
	if (((gint) _tmp0_) != 0) {
		GPid _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GPid _tmp4_;
		_tmp1_ = self->priv->pid;
		_tmp2_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) _tmp1_));
		_tmp3_ = _tmp2_;
		debug (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp4_)), SIGTERM);
	}
	gtk_main_quit ();
}


static void ___lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda10_ (self, _sender);
}


static void __lambda11_ (smdApplet* self, GtkCheckMenuItem* b) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->miPause;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		smd_applet_pause (self);
	} else {
		smd_applet_unpause (self);
	}
}


static void ___lambda11__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda11_ (self, _sender);
}


static void __lambda12_ (smdApplet* self, gint id) {
	GtkAboutDialog* _tmp0_;
	_tmp0_ = self->priv->about_win;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void ___lambda12__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda12_ (self, response_id);
}


static void __lambda13_ (smdApplet* self, GtkMenuItem* b) {
	GtkAboutDialog* _tmp0_;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->about_win;
	gtk_dialog_run ((GtkDialog*) _tmp0_);
}


static void ___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda13_ (self, _sender);
}


static void __lambda14_ (smdApplet* self, GtkMenuItem* b) {
	GtkWindow* _tmp0_;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->win;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda14_ (self, _sender);
}


static void __lambda15_ (smdApplet* self, GtkMenuItem* b) {
	GtkWindow* _tmp0_;
	g_return_if_fail (b != NULL);
	smd_applet_update_loglist (self);
	_tmp0_ = self->priv->log_win;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda15_ (self, _sender);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void __lambda16_ (smdApplet* self, guint button, guint time) {
	GtkMenu* _tmp0_;
	GtkStatusIcon* _tmp1_;
	guint32 _tmp2_ = 0U;
	_tmp0_ = self->priv->menuR;
	_tmp1_ = self->priv->si;
	_tmp2_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp0_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp1_, (guint) 0, _tmp2_);
}


static void ___lambda16__gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	__lambda16_ (self, button, activate_time);
}


static void __lambda17_ (smdApplet* self, GtkStatusIcon* s) {
	gboolean _tmp0_;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->error_mode;
	if (_tmp0_) {
		GtkWindow* _tmp1_;
		_tmp1_ = self->priv->err_win;
		gtk_window_reshow_with_initial_size (_tmp1_);
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->config_wait_mode;
		if (_tmp2_) {
			GtkWindow* _tmp3_;
			_tmp3_ = self->priv->win;
			gtk_widget_show ((GtkWidget*) _tmp3_);
		} else {
			GtkMenu* _tmp4_;
			GtkStatusIcon* _tmp5_;
			guint32 _tmp6_ = 0U;
			_tmp4_ = self->priv->menuL;
			_tmp5_ = self->priv->si;
			_tmp6_ = gtk_get_current_event_time ();
			gtk_menu_popup (_tmp4_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp5_, (guint) 0, _tmp6_);
		}
	}
}


static void ___lambda17__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	__lambda17_ (self, _sender);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


smdApplet* smd_applet_construct (GType object_type, gboolean hide_status_icon, GError** error) {
	smdApplet* self = NULL;
	GtkBuilder* _tmp0_;
	GeeArrayList* _tmp7_;
	GConfClient* _tmp8_ = NULL;
	GConfClient* _tmp9_;
	GtkBuilder* _tmp16_;
	GObject* _tmp17_ = NULL;
	GtkWindow* _tmp18_;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkWindow* _tmp21_;
	GtkBuilder* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkAboutDialog* _tmp24_;
	GtkAboutDialog* _tmp25_;
	GtkBuilder* _tmp26_;
	GObject* _tmp27_ = NULL;
	GtkWindow* _tmp28_;
	GtkBuilder* _tmp29_;
	GObject* _tmp30_ = NULL;
	GtkVBox* _tmp31_;
	GtkVBox* logs_vb;
	GtkComboBoxText* _tmp32_;
	GtkComboBoxText* _tmp33_;
	GeeArrayList* _tmp34_;
	GtkComboBoxText* _tmp35_;
	GtkComboBoxText* _tmp36_;
	GtkComboBoxText* _tmp37_;
	GtkComboBoxText* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkButton* _tmp41_;
	GtkButton* close_log;
	GtkWindow* _tmp42_;
	GtkBuilder* _tmp43_;
	GObject* _tmp44_ = NULL;
	GtkButton* _tmp45_;
	GtkButton* close;
	GtkBuilder* _tmp46_;
	GObject* _tmp47_ = NULL;
	GtkCheckButton* _tmp48_;
	GtkCheckButton* bicon;
	GtkBuilder* _tmp55_;
	GObject* _tmp56_ = NULL;
	GtkCheckButton* _tmp57_;
	GtkCheckButton* bnotify;
	GtkBuilder* _tmp64_;
	GObject* _tmp65_ = NULL;
	GtkCheckButton* _tmp66_;
	GtkCheckButton* bautostart;
	GtkBuilder* _tmp75_;
	GObject* _tmp76_ = NULL;
	GtkButton* _tmp77_;
	GtkButton* bc;
	GtkBuilder* _tmp78_;
	GObject* _tmp79_ = NULL;
	GtkButton* _tmp80_;
	GtkButton* bel;
	GtkBuilder* _tmp81_;
	GObject* _tmp82_ = NULL;
	GtkButton* _tmp83_;
	GtkButton* bepp;
	GtkBuilder* _tmp84_;
	GObject* _tmp85_ = NULL;
	GtkMenu* _tmp86_;
	GtkBuilder* _tmp87_;
	GObject* _tmp88_ = NULL;
	GtkMenu* _tmp89_;
	GtkBuilder* _tmp90_;
	GObject* _tmp91_ = NULL;
	GtkMenuItem* _tmp92_;
	GtkMenuItem* quit;
	GtkBuilder* _tmp93_;
	GObject* _tmp94_ = NULL;
	GtkCheckMenuItem* _tmp95_;
	GtkCheckMenuItem* _tmp96_;
	GtkBuilder* _tmp97_;
	GObject* _tmp98_ = NULL;
	GtkMenuItem* _tmp99_;
	GtkMenuItem* about;
	GtkAboutDialog* _tmp100_;
	GtkAboutDialog* _tmp101_;
	GtkBuilder* _tmp102_;
	GObject* _tmp103_ = NULL;
	GtkMenuItem* _tmp104_;
	GtkMenuItem* prefs;
	GtkBuilder* _tmp105_;
	GObject* _tmp106_ = NULL;
	GtkMenuItem* _tmp107_;
	GtkMenuItem* logs;
	GtkStatusIcon* _tmp108_;
	GtkStatusIcon* _tmp109_;
	gboolean _tmp110_;
	GtkStatusIcon* _tmp111_;
	GtkStatusIcon* _tmp112_;
	GtkStatusIcon* _tmp113_;
	GList* _tmp114_ = NULL;
	GList* l;
	gint _tmp115_ = 0;
	GHashFunc _tmp116_;
	GEqualFunc _tmp117_;
	GHashTable* _tmp118_;
	GError * _inner_error_ = NULL;
	self = (smdApplet*) g_type_create_instance (object_type);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp0_;
	{
		GtkBuilder* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->builder;
		_tmp2_ = smd_applet_smd_applet_ui;
		gtk_builder_add_from_file (_tmp1_, _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		_tmp6_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to load the ui file");
		_inner_error_ = _tmp6_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = gee_array_list_new (TYPE_EVENT, (GBoxedCopyFunc) event_ref, event_unref, NULL);
	_g_object_unref0 (self->priv->events);
	self->priv->events = _tmp7_;
	_tmp8_ = gconf_client_get_default ();
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->gconf);
	self->priv->gconf = _tmp9_;
	{
		NetworkManager* _tmp10_ = NULL;
		NetworkManager* _tmp11_;
		NetworkManager* _tmp12_;
		_tmp10_ = g_initable_new (TYPE_NETWORK_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", NM_SERVICE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", NM_PATH, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
		_tmp11_ = (NetworkManager*) _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_g_object_unref0 (self->priv->net_manager);
		self->priv->net_manager = _tmp11_;
		_tmp12_ = self->priv->net_manager;
		g_signal_connect (_tmp12_, "state-changed", (GCallback) ____lambda2__network_manager_state_changed, self);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = stderr;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "%s\n", _tmp15_);
		_g_object_unref0 (self->priv->net_manager);
		self->priv->net_manager = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = self->priv->builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "wPrefs");
	_tmp18_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp17_) ? ((GtkWindow*) _tmp17_) : NULL);
	_g_object_unref0 (self->priv->win);
	self->priv->win = _tmp18_;
	_tmp19_ = self->priv->builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "wError");
	_tmp21_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp20_) ? ((GtkWindow*) _tmp20_) : NULL);
	_g_object_unref0 (self->priv->err_win);
	self->priv->err_win = _tmp21_;
	_tmp22_ = self->priv->builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "wAbout");
	_tmp24_ = _g_object_ref0 (GTK_IS_ABOUT_DIALOG (_tmp23_) ? ((GtkAboutDialog*) _tmp23_) : NULL);
	_g_object_unref0 (self->priv->about_win);
	self->priv->about_win = _tmp24_;
	_tmp25_ = self->priv->about_win;
	gtk_about_dialog_set_copyright (_tmp25_, "Copyright " SMD_CONF_COPYRIGHT);
	_tmp26_ = self->priv->builder;
	_tmp27_ = gtk_builder_get_object (_tmp26_, "wLog");
	_tmp28_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp27_) ? ((GtkWindow*) _tmp27_) : NULL);
	_g_object_unref0 (self->priv->log_win);
	self->priv->log_win = _tmp28_;
	_tmp29_ = self->priv->builder;
	_tmp30_ = gtk_builder_get_object (_tmp29_, "vbLog");
	_tmp31_ = _g_object_ref0 (GTK_IS_VBOX (_tmp30_) ? ((GtkVBox*) _tmp30_) : NULL);
	logs_vb = _tmp31_;
	_tmp32_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	_tmp33_ = g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->cblogs);
	self->priv->cblogs = _tmp33_;
	_tmp34_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->lognames);
	self->priv->lognames = _tmp34_;
	_tmp35_ = self->priv->cblogs;
	gtk_box_pack_start ((GtkBox*) logs_vb, (GtkWidget*) _tmp35_, FALSE, TRUE, (guint) 0);
	_tmp36_ = self->priv->cblogs;
	gtk_box_reorder_child ((GtkBox*) logs_vb, (GtkWidget*) _tmp36_, 0);
	_tmp37_ = self->priv->cblogs;
	gtk_widget_show ((GtkWidget*) _tmp37_);
	_tmp38_ = self->priv->cblogs;
	g_signal_connect ((GtkComboBox*) _tmp38_, "changed", (GCallback) ___lambda3__gtk_combo_box_changed, self);
	_tmp39_ = self->priv->builder;
	_tmp40_ = gtk_builder_get_object (_tmp39_, "bLogClose");
	_tmp41_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp40_) ? ((GtkButton*) _tmp40_) : NULL);
	close_log = _tmp41_;
	g_signal_connect (close_log, "clicked", (GCallback) _smd_applet_close_logs_action_gtk_button_clicked, self);
	_tmp42_ = self->priv->log_win;
	g_signal_connect ((GtkWidget*) _tmp42_, "delete-event", (GCallback) _smd_applet_close_logs_event_gtk_widget_delete_event, self);
	_tmp43_ = self->priv->builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "bClosePrefs");
	_tmp45_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp44_) ? ((GtkButton*) _tmp44_) : NULL);
	close = _tmp45_;
	g_signal_connect (close, "clicked", (GCallback) _smd_applet_close_prefs_action_gtk_button_clicked, self);
	_tmp46_ = self->priv->builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "cbIcon");
	_tmp48_ = _g_object_ref0 (GTK_IS_CHECK_BUTTON (_tmp47_) ? ((GtkCheckButton*) _tmp47_) : NULL);
	bicon = _tmp48_;
	{
		GConfClient* _tmp49_;
		gboolean _tmp50_ = FALSE;
		gboolean _tmp51_;
		_tmp49_ = self->priv->gconf;
		_tmp50_ = gconf_client_get_bool (_tmp49_, SMD_APPLET_key_icon, &_inner_error_);
		_tmp51_ = _tmp50_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		gtk_toggle_button_set_active ((GtkToggleButton*) bicon, _tmp51_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp52_;
		GError* _tmp53_;
		const gchar* _tmp54_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp52_ = stderr;
		_tmp53_ = e;
		_tmp54_ = _tmp53_->message;
		fprintf (_tmp52_, "%s\n", _tmp54_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect ((GtkToggleButton*) bicon, "toggled", (GCallback) ___lambda5__gtk_toggle_button_toggled, self);
	_tmp55_ = self->priv->builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "cbNotify");
	_tmp57_ = _g_object_ref0 (GTK_IS_CHECK_BUTTON (_tmp56_) ? ((GtkCheckButton*) _tmp56_) : NULL);
	bnotify = _tmp57_;
	{
		GConfClient* _tmp58_;
		gboolean _tmp59_ = FALSE;
		gboolean _tmp60_;
		_tmp58_ = self->priv->gconf;
		_tmp59_ = gconf_client_get_bool (_tmp58_, SMD_APPLET_key_newmail, &_inner_error_);
		_tmp60_ = _tmp59_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		gtk_toggle_button_set_active ((GtkToggleButton*) bnotify, _tmp60_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp61_;
		GError* _tmp62_;
		const gchar* _tmp63_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp61_ = stderr;
		_tmp62_ = e;
		_tmp63_ = _tmp62_->message;
		fprintf (_tmp61_, "%s\n", _tmp63_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect ((GtkToggleButton*) bnotify, "toggled", (GCallback) ___lambda6__gtk_toggle_button_toggled, self);
	_tmp64_ = self->priv->builder;
	_tmp65_ = gtk_builder_get_object (_tmp64_, "cbAutostart");
	_tmp66_ = _g_object_ref0 (GTK_IS_CHECK_BUTTON (_tmp65_) ? ((GtkCheckButton*) _tmp65_) : NULL);
	bautostart = _tmp66_;
	{
		gchar* content = NULL;
		const gchar* _tmp67_;
		gchar* _tmp68_ = NULL;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_;
		_tmp67_ = XDG_AUTORUN_FILE;
		_tmp69_ = g_file_get_contents (_tmp67_, &_tmp68_, NULL, &_inner_error_);
		_g_free0 (content);
		content = _tmp68_;
		_tmp70_ = _tmp69_;
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch7_g_file_error;
			}
			_g_free0 (content);
			_g_object_unref0 (bautostart);
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		if (_tmp70_) {
			gboolean _tmp71_ = FALSE;
			_tmp71_ = g_regex_match_simple (GNOME_AUTOSTART_DISABLED, content, 0, 0);
			if (_tmp71_) {
				gtk_toggle_button_set_active ((GtkToggleButton*) bautostart, FALSE);
			} else {
				gtk_toggle_button_set_active ((GtkToggleButton*) bautostart, TRUE);
			}
		} else {
			gtk_toggle_button_set_active ((GtkToggleButton*) bautostart, FALSE);
		}
		_g_free0 (content);
	}
	goto __finally7;
	__catch7_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp72_;
		GError* _tmp73_;
		const gchar* _tmp74_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp72_ = stderr;
		_tmp73_ = e;
		_tmp74_ = _tmp73_->message;
		fprintf (_tmp72_, "%s\n", _tmp74_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (bautostart);
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (bautostart);
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect ((GtkToggleButton*) bautostart, "toggled", (GCallback) ___lambda7__gtk_toggle_button_toggled, self);
	_tmp75_ = self->priv->builder;
	_tmp76_ = gtk_builder_get_object (_tmp75_, "bClose");
	_tmp77_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp76_) ? ((GtkButton*) _tmp76_) : NULL);
	bc = _tmp77_;
	g_signal_connect (bc, "clicked", (GCallback) _smd_applet_close_err_action_gtk_button_clicked, self);
	_tmp78_ = self->priv->builder;
	_tmp79_ = gtk_builder_get_object (_tmp78_, "bEditLoopCfg");
	_tmp80_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp79_) ? ((GtkButton*) _tmp79_) : NULL);
	bel = _tmp80_;
	g_signal_connect (bel, "clicked", (GCallback) ___lambda8__gtk_button_clicked, self);
	_tmp81_ = self->priv->builder;
	_tmp82_ = gtk_builder_get_object (_tmp81_, "bEditPushPullCfg");
	_tmp83_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp82_) ? ((GtkButton*) _tmp82_) : NULL);
	bepp = _tmp83_;
	g_signal_connect (bepp, "clicked", (GCallback) ___lambda9__gtk_button_clicked, self);
	_tmp84_ = self->priv->builder;
	_tmp85_ = gtk_builder_get_object (_tmp84_, "mLeft");
	_tmp86_ = _g_object_ref0 (GTK_IS_MENU (_tmp85_) ? ((GtkMenu*) _tmp85_) : NULL);
	_g_object_unref0 (self->priv->menuL);
	self->priv->menuL = _tmp86_;
	_tmp87_ = self->priv->builder;
	_tmp88_ = gtk_builder_get_object (_tmp87_, "mRight");
	_tmp89_ = _g_object_ref0 (GTK_IS_MENU (_tmp88_) ? ((GtkMenu*) _tmp88_) : NULL);
	_g_object_unref0 (self->priv->menuR);
	self->priv->menuR = _tmp89_;
	_tmp90_ = self->priv->builder;
	_tmp91_ = gtk_builder_get_object (_tmp90_, "miQuit");
	_tmp92_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp91_) ? ((GtkMenuItem*) _tmp91_) : NULL);
	quit = _tmp92_;
	g_signal_connect (quit, "activate", (GCallback) ___lambda10__gtk_menu_item_activate, self);
	_tmp93_ = self->priv->builder;
	_tmp94_ = gtk_builder_get_object (_tmp93_, "miPause");
	_tmp95_ = _g_object_ref0 (GTK_IS_CHECK_MENU_ITEM (_tmp94_) ? ((GtkCheckMenuItem*) _tmp94_) : NULL);
	_g_object_unref0 (self->priv->miPause);
	self->priv->miPause = _tmp95_;
	_tmp96_ = self->priv->miPause;
	g_signal_connect (_tmp96_, "toggled", (GCallback) ___lambda11__gtk_check_menu_item_toggled, self);
	_tmp97_ = self->priv->builder;
	_tmp98_ = gtk_builder_get_object (_tmp97_, "miAbout");
	_tmp99_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp98_) ? ((GtkMenuItem*) _tmp98_) : NULL);
	about = _tmp99_;
	_tmp100_ = self->priv->about_win;
	g_signal_connect ((GtkDialog*) _tmp100_, "response", (GCallback) ___lambda12__gtk_dialog_response, self);
	g_signal_connect (about, "activate", (GCallback) ___lambda13__gtk_menu_item_activate, self);
	_tmp101_ = self->priv->about_win;
	gtk_about_dialog_set_comments (_tmp101_, "GNOME applet for syncmaildir version " SMD_CONF_VERSION);
	_tmp102_ = self->priv->builder;
	_tmp103_ = gtk_builder_get_object (_tmp102_, "miPrefs");
	_tmp104_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp103_) ? ((GtkMenuItem*) _tmp103_) : NULL);
	prefs = _tmp104_;
	g_signal_connect (prefs, "activate", (GCallback) ___lambda14__gtk_menu_item_activate, self);
	_tmp105_ = self->priv->builder;
	_tmp106_ = gtk_builder_get_object (_tmp105_, "miLog");
	_tmp107_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp106_) ? ((GtkMenuItem*) _tmp106_) : NULL);
	logs = _tmp107_;
	g_signal_connect (logs, "activate", (GCallback) ___lambda15__gtk_menu_item_activate, self);
	_tmp108_ = gtk_status_icon_new_from_icon_name ("mail-send-receive");
	_g_object_unref0 (self->priv->si);
	self->priv->si = _tmp108_;
	_tmp109_ = self->priv->si;
	_tmp110_ = hide_status_icon;
	gtk_status_icon_set_visible (_tmp109_, !_tmp110_);
	_tmp111_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp111_, "smd-applet is running");
	_tmp112_ = self->priv->si;
	g_signal_connect (_tmp112_, "popup-menu", (GCallback) ___lambda16__gtk_status_icon_popup_menu, self);
	_tmp113_ = self->priv->si;
	g_signal_connect (_tmp113_, "activate", (GCallback) ___lambda17__gtk_status_icon_activate, self);
	_tmp114_ = notify_get_server_caps ();
	l = _tmp114_;
	_tmp115_ = g_list_index (l, "persistence");
	self->priv->notification_server_has_persistence = 0 <= _tmp115_;
	_tmp116_ = g_direct_hash;
	_tmp117_ = g_str_equal;
	_tmp118_ = g_hash_table_new_full (_tmp116_, _tmp117_, _g_object_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->command_hash);
	self->priv->command_hash = _tmp118_;
	_g_object_unref0 (logs);
	_g_object_unref0 (prefs);
	_g_object_unref0 (about);
	_g_object_unref0 (quit);
	_g_object_unref0 (bepp);
	_g_object_unref0 (bel);
	_g_object_unref0 (bc);
	_g_object_unref0 (bautostart);
	_g_object_unref0 (bnotify);
	_g_object_unref0 (bicon);
	_g_object_unref0 (close);
	_g_object_unref0 (close_log);
	_g_object_unref0 (logs_vb);
	return self;
}


smdApplet* smd_applet_new (gboolean hide_status_icon, GError** error) {
	return smd_applet_construct (TYPE_SMD_APPLET, hide_status_icon, error);
}


static void* smd_applet_smdThread (smdApplet* self) {
	void* result = NULL;
	gboolean rc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rc = TRUE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		gboolean _tmp3_;
		_tmp1_ = rc;
		if (_tmp1_) {
			gboolean _tmp2_;
			_tmp2_ = self->priv->thread_die;
			_tmp0_ = !_tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
		debug ("(re)starting smd-loop");
		{
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_;
			_tmp4_ = smd_applet_run_smd_loop (self, &_inner_error_);
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == EXIT) {
					goto __catch11_exit;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			rc = _tmp5_;
		}
		goto __finally11;
		__catch11_exit:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			rc = FALSE;
			_g_error_free0 (e);
		}
		__finally11:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = NULL;
	return result;
}


static gpointer _smd_applet_smdThread_gthread_func (gpointer self) {
	gpointer result;
	result = smd_applet_smdThread (self);
	return result;
}


static void smd_applet_start_smdThread (smdApplet* self, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp2_ = force;
	if (!_tmp2_) {
		NetworkManager* _tmp3_;
		_tmp3_ = self->priv->net_manager;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		NetworkManager* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = self->priv->net_manager;
		_tmp6_ = network_manager_get_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = is_nm_connected (_tmp7_);
		_tmp0_ = !_tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		GtkCheckMenuItem* _tmp10_;
		_tmp10_ = self->priv->miPause;
		gtk_check_menu_item_set_active (_tmp10_, TRUE);
	} else {
		GThread* _tmp11_;
		_tmp11_ = g_thread_new (NULL, _smd_applet_smdThread_gthread_func, self);
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp11_;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const gchar* args, const gchar* account, const gchar* host, GError** error) {
	gboolean result = FALSE;
	GRegex* _tmp0_;
	GRegex* context;
	GRegex* _tmp1_;
	GRegex* cause;
	GRegex* _tmp2_;
	GRegex* human;
	GRegex* _tmp3_;
	GRegex* actions;
	GMatchInfo* i_ctx;
	GMatchInfo* i_cause;
	GMatchInfo* i_human;
	GMatchInfo* i_act;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GRegex* _tmp10_;
	const gchar* _tmp11_;
	GMatchInfo* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GRegex* _tmp16_;
	const gchar* _tmp17_;
	GMatchInfo* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GRegex* _tmp22_;
	const gchar* _tmp23_;
	GMatchInfo* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean has_actions;
	gboolean _tmp26_ = FALSE;
	GMatchInfo* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp34_;
	GMatchInfo* _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	gboolean _tmp44_;
	gchar* permissions;
	gchar* mail_name;
	gchar* mail_body;
	GeeArrayList* _tmp56_;
	GeeArrayList* commands;
	gboolean _tmp57_;
	GeeArrayList* _tmp130_;
	GeeArrayList* _tmp131_;
	gint _tmp132_;
	gint _tmp133_;
	const gchar* _tmp134_;
	const gchar* _tmp135_;
	GMatchInfo* _tmp136_;
	gchar* _tmp137_ = NULL;
	gchar* _tmp138_;
	GMatchInfo* _tmp139_;
	gchar* _tmp140_ = NULL;
	gchar* _tmp141_;
	const gchar* _tmp142_;
	const gchar* _tmp143_;
	const gchar* _tmp144_;
	GeeArrayList* _tmp145_;
	Event* _tmp146_ = NULL;
	Event* _tmp147_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	g_return_val_if_fail (account != NULL, FALSE);
	g_return_val_if_fail (host != NULL, FALSE);
	_tmp0_ = g_regex_new ("context\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	context = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp1_ = g_regex_new ("probable-cause\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	cause = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp2_ = g_regex_new ("human-intervention\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	human = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp3_ = g_regex_new ("suggested-actions\\((.*)\\) *$", 0, 0, &_inner_error_);
	actions = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	i_ctx = NULL;
	i_cause = NULL;
	i_human = NULL;
	i_act = NULL;
	_tmp4_ = context;
	_tmp5_ = args;
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
	_g_match_info_free0 (i_ctx);
	i_ctx = _tmp6_;
	if (!_tmp7_) {
		FILE* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = stderr;
		_tmp9_ = args;
		fprintf (_tmp8_, "smd-loop error with no context: %s\n", _tmp9_);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp10_ = cause;
	_tmp11_ = args;
	_tmp13_ = g_regex_match (_tmp10_, _tmp11_, 0, &_tmp12_);
	_g_match_info_free0 (i_cause);
	i_cause = _tmp12_;
	if (!_tmp13_) {
		FILE* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = stderr;
		_tmp15_ = args;
		fprintf (_tmp14_, "smd-loop error with no cause: %s\n", _tmp15_);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp16_ = human;
	_tmp17_ = args;
	_tmp19_ = g_regex_match (_tmp16_, _tmp17_, 0, &_tmp18_);
	_g_match_info_free0 (i_human);
	i_human = _tmp18_;
	if (!_tmp19_) {
		FILE* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = stderr;
		_tmp21_ = args;
		fprintf (_tmp20_, "smd-loop error with no human: %s\n", _tmp21_);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp22_ = actions;
	_tmp23_ = args;
	_tmp25_ = g_regex_match (_tmp22_, _tmp23_, 0, &_tmp24_);
	_g_match_info_free0 (i_act);
	i_act = _tmp24_;
	has_actions = _tmp25_;
	_tmp27_ = i_human;
	_tmp28_ = g_match_info_fetch (_tmp27_, 1);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strcmp0 (_tmp29_, "necessary") != 0;
	_g_free0 (_tmp29_);
	if (_tmp30_) {
		GMatchInfo* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		_tmp31_ = i_cause;
		_tmp32_ = g_match_info_fetch (_tmp31_, 1);
		_tmp33_ = _tmp32_;
		_tmp26_ = g_strcmp0 (_tmp33_, "network") == 0;
		_g_free0 (_tmp33_);
	} else {
		_tmp26_ = FALSE;
	}
	_tmp34_ = _tmp26_;
	if (_tmp34_) {
		GeeArrayList* _tmp35_;
		GeeArrayList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		Event* _tmp39_ = NULL;
		Event* _tmp40_;
		g_mutex_lock (&self->priv->events_lock);
		_tmp35_ = self->priv->events;
		_tmp36_ = self->priv->events;
		_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = event_network_error ();
		_tmp40_ = _tmp39_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp35_, _tmp38_, _tmp40_);
		_event_unref0 (_tmp40_);
		g_mutex_unlock (&self->priv->events_lock);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp41_ = i_human;
	_tmp42_ = g_match_info_fetch (_tmp41_, 1);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strcmp0 (_tmp43_, "necessary") != 0;
	_g_free0 (_tmp43_);
	if (_tmp44_) {
		FILE* _tmp45_;
		const gchar* _tmp46_;
		GeeArrayList* _tmp47_;
		GeeArrayList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		GMatchInfo* _tmp51_;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_;
		Event* _tmp54_ = NULL;
		Event* _tmp55_;
		_tmp45_ = stderr;
		_tmp46_ = args;
		fprintf (_tmp45_, "smd-loop giving an avoidable error: %s\n", _tmp46_);
		g_mutex_lock (&self->priv->events_lock);
		_tmp47_ = self->priv->events;
		_tmp48_ = self->priv->events;
		_tmp49_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = i_cause;
		_tmp52_ = g_match_info_fetch (_tmp51_, 1);
		_tmp53_ = _tmp52_;
		_tmp54_ = event_generic_error (_tmp53_);
		_tmp55_ = _tmp54_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp47_, _tmp50_, _tmp55_);
		_event_unref0 (_tmp55_);
		_g_free0 (_tmp53_);
		g_mutex_unlock (&self->priv->events_lock);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	permissions = NULL;
	mail_name = NULL;
	mail_body = NULL;
	_tmp56_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	commands = _tmp56_;
	_tmp57_ = has_actions;
	if (_tmp57_) {
		GMatchInfo* _tmp58_;
		gchar* _tmp59_ = NULL;
		gchar* acts;
		GRegex* _tmp60_;
		GRegex* r_perm;
		GRegex* _tmp61_;
		GRegex* r_mail;
		GRegex* _tmp62_;
		GRegex* r_cmd;
		gint from;
		_tmp58_ = i_act;
		_tmp59_ = g_match_info_fetch (_tmp58_, 1);
		acts = _tmp59_;
		_tmp60_ = g_regex_new ("display-permissions\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_perm = _tmp60_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp61_ = g_regex_new ("display-mail\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_mail = _tmp61_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp62_ = g_regex_new ("run\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_cmd = _tmp62_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		from = 0;
		{
			gboolean _tmp63_;
			_tmp63_ = TRUE;
			while (TRUE) {
				gboolean _tmp64_;
				gboolean _tmp65_ = FALSE;
				const gchar* _tmp66_;
				gboolean _tmp70_;
				GMatchInfo* i_cmd;
				GRegex* _tmp71_;
				const gchar* _tmp72_;
				GMatchInfo* _tmp73_ = NULL;
				gboolean _tmp74_ = FALSE;
				const gchar* _tmp127_;
				gint _tmp128_;
				gchar* _tmp129_ = NULL;
				_tmp64_ = _tmp63_;
				if (!_tmp64_) {
				}
				_tmp63_ = FALSE;
				_tmp66_ = acts;
				if (_tmp66_ != NULL) {
					const gchar* _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					_tmp67_ = acts;
					_tmp68_ = strlen (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp65_ = _tmp69_ > 0;
				} else {
					_tmp65_ = FALSE;
				}
				_tmp70_ = _tmp65_;
				if (!_tmp70_) {
					break;
				}
				i_cmd = NULL;
				_tmp71_ = r_perm;
				_tmp72_ = acts;
				_tmp74_ = g_regex_match (_tmp71_, _tmp72_, 0, &_tmp73_);
				_g_match_info_free0 (i_cmd);
				i_cmd = _tmp73_;
				if (_tmp74_) {
					GMatchInfo* _tmp75_;
					gint _tmp76_ = 0;
					GMatchInfo* _tmp77_;
					gchar* _tmp78_ = NULL;
					gchar* file;
					gchar* output;
					gchar* err;
					_tmp75_ = i_cmd;
					g_match_info_fetch_pos (_tmp75_, 0, NULL, &_tmp76_);
					from = _tmp76_;
					_tmp77_ = i_cmd;
					_tmp78_ = g_match_info_fetch (_tmp77_, 1);
					file = _tmp78_;
					output = NULL;
					err = NULL;
					{
						const gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						gchar* _tmp82_ = NULL;
						gchar* _tmp83_ = NULL;
						const gchar* _tmp84_;
						const gchar* _tmp85_;
						gchar* _tmp86_;
						_tmp79_ = file;
						_tmp80_ = g_strconcat ("ls -ld ", _tmp79_, NULL);
						_tmp81_ = _tmp80_;
						g_spawn_command_line_sync (_tmp81_, &_tmp82_, &_tmp83_, NULL, &_inner_error_);
						_g_free0 (output);
						output = _tmp82_;
						_g_free0 (err);
						err = _tmp83_;
						_g_free0 (_tmp81_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_SPAWN_ERROR) {
								goto __catch12_g_spawn_error;
							}
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_tmp84_ = output;
						_tmp85_ = err;
						_tmp86_ = g_strconcat (_tmp84_, _tmp85_, NULL);
						_g_free0 (permissions);
						permissions = _tmp86_;
					}
					goto __finally12;
					__catch12_g_spawn_error:
					{
						GError* e = NULL;
						FILE* _tmp87_;
						GError* _tmp88_;
						const gchar* _tmp89_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp87_ = stderr;
						_tmp88_ = e;
						_tmp89_ = _tmp88_->message;
						fprintf (_tmp87_, "Spawning ls: %s\n", _tmp89_);
						_g_error_free0 (e);
					}
					__finally12:
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							return FALSE;
						} else {
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					_g_free0 (err);
					_g_free0 (output);
					_g_free0 (file);
				} else {
					GRegex* _tmp90_;
					const gchar* _tmp91_;
					GMatchInfo* _tmp92_ = NULL;
					gboolean _tmp93_ = FALSE;
					_tmp90_ = r_mail;
					_tmp91_ = acts;
					_tmp93_ = g_regex_match (_tmp90_, _tmp91_, 0, &_tmp92_);
					_g_match_info_free0 (i_cmd);
					i_cmd = _tmp92_;
					if (_tmp93_) {
						GMatchInfo* _tmp94_;
						gint _tmp95_ = 0;
						GMatchInfo* _tmp96_;
						gchar* _tmp97_ = NULL;
						gchar* file;
						gchar* _tmp98_;
						gchar* output;
						gchar* err;
						_tmp94_ = i_cmd;
						g_match_info_fetch_pos (_tmp94_, 0, NULL, &_tmp95_);
						from = _tmp95_;
						_tmp96_ = i_cmd;
						_tmp97_ = g_match_info_fetch (_tmp96_, 1);
						file = _tmp97_;
						_tmp98_ = g_strdup ("");
						output = _tmp98_;
						err = NULL;
						{
							const gchar* _tmp99_;
							gchar* _tmp100_;
							const gchar* _tmp101_;
							gchar* _tmp102_;
							gchar* _tmp103_;
							gchar* _tmp104_ = NULL;
							gchar* _tmp105_ = NULL;
							const gchar* _tmp106_;
							const gchar* _tmp107_;
							gchar* _tmp108_;
							_tmp99_ = file;
							_tmp100_ = g_strdup (_tmp99_);
							_g_free0 (mail_name);
							mail_name = _tmp100_;
							_tmp101_ = file;
							_tmp102_ = g_strconcat ("cat ", _tmp101_, NULL);
							_tmp103_ = _tmp102_;
							g_spawn_command_line_sync (_tmp103_, &_tmp104_, &_tmp105_, NULL, &_inner_error_);
							_g_free0 (output);
							output = _tmp104_;
							_g_free0 (err);
							err = _tmp105_;
							_g_free0 (_tmp103_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_SPAWN_ERROR) {
									goto __catch13_g_spawn_error;
								}
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_free0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_free0 (i_act);
								_g_match_info_free0 (i_human);
								_g_match_info_free0 (i_cause);
								_g_match_info_free0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
							_tmp106_ = output;
							_tmp107_ = err;
							_tmp108_ = g_strconcat (_tmp106_, _tmp107_, NULL);
							_g_free0 (mail_body);
							mail_body = _tmp108_;
						}
						goto __finally13;
						__catch13_g_spawn_error:
						{
							GError* e = NULL;
							FILE* _tmp109_;
							GError* _tmp110_;
							const gchar* _tmp111_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp109_ = stderr;
							_tmp110_ = e;
							_tmp111_ = _tmp110_->message;
							fprintf (_tmp109_, "Spawning ls: %s\n", _tmp111_);
							_g_error_free0 (e);
						}
						__finally13:
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_REGEX_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_free0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_free0 (i_act);
								_g_match_info_free0 (i_human);
								_g_match_info_free0 (i_cause);
								_g_match_info_free0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								return FALSE;
							} else {
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_free0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_free0 (i_act);
								_g_match_info_free0 (i_human);
								_g_match_info_free0 (i_cause);
								_g_match_info_free0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_g_free0 (err);
						_g_free0 (output);
						_g_free0 (file);
					} else {
						GRegex* _tmp112_;
						const gchar* _tmp113_;
						GMatchInfo* _tmp114_ = NULL;
						gboolean _tmp115_ = FALSE;
						_tmp112_ = r_cmd;
						_tmp113_ = acts;
						_tmp115_ = g_regex_match (_tmp112_, _tmp113_, 0, &_tmp114_);
						_g_match_info_free0 (i_cmd);
						i_cmd = _tmp114_;
						if (_tmp115_) {
							GMatchInfo* _tmp116_;
							gchar* _tmp117_ = NULL;
							gchar* command;
							GMatchInfo* _tmp118_;
							gint _tmp119_ = 0;
							GeeArrayList* _tmp120_;
							GeeArrayList* _tmp121_;
							gint _tmp122_;
							gint _tmp123_;
							const gchar* _tmp124_;
							_tmp116_ = i_cmd;
							_tmp117_ = g_match_info_fetch (_tmp116_, 1);
							command = _tmp117_;
							_tmp118_ = i_cmd;
							g_match_info_fetch_pos (_tmp118_, 0, NULL, &_tmp119_);
							from = _tmp119_;
							_tmp120_ = commands;
							_tmp121_ = commands;
							_tmp122_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp121_);
							_tmp123_ = _tmp122_;
							_tmp124_ = command;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp120_, _tmp123_, _tmp124_);
							_g_free0 (command);
						} else {
							FILE* _tmp125_;
							const gchar* _tmp126_;
							_tmp125_ = stderr;
							_tmp126_ = acts;
							fprintf (_tmp125_, "Unrecognized action: %s\n", _tmp126_);
							_g_match_info_free0 (i_cmd);
							break;
						}
					}
				}
				_tmp127_ = acts;
				_tmp128_ = from;
				_tmp129_ = string_substring (_tmp127_, (glong) _tmp128_, (glong) (-1));
				_g_free0 (acts);
				acts = _tmp129_;
				_g_match_info_free0 (i_cmd);
			}
		}
		_g_regex_unref0 (r_cmd);
		_g_regex_unref0 (r_mail);
		_g_regex_unref0 (r_perm);
		_g_free0 (acts);
	}
	g_mutex_lock (&self->priv->events_lock);
	_tmp130_ = self->priv->events;
	_tmp131_ = self->priv->events;
	_tmp132_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = account;
	_tmp135_ = host;
	_tmp136_ = i_ctx;
	_tmp137_ = g_match_info_fetch (_tmp136_, 1);
	_tmp138_ = _tmp137_;
	_tmp139_ = i_cause;
	_tmp140_ = g_match_info_fetch (_tmp139_, 1);
	_tmp141_ = _tmp140_;
	_tmp142_ = permissions;
	_tmp143_ = mail_name;
	_tmp144_ = mail_body;
	_tmp145_ = commands;
	_tmp146_ = event_error (_tmp134_, _tmp135_, _tmp138_, _tmp141_, _tmp142_, _tmp143_, _tmp144_, _tmp145_);
	_tmp147_ = _tmp146_;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp130_, _tmp133_, _tmp147_);
	_event_unref0 (_tmp147_);
	_g_free0 (_tmp141_);
	_g_free0 (_tmp138_);
	g_mutex_unlock (&self->priv->events_lock);
	result = FALSE;
	_g_object_unref0 (commands);
	_g_free0 (mail_body);
	_g_free0 (mail_name);
	_g_free0 (permissions);
	_g_match_info_free0 (i_act);
	_g_match_info_free0 (i_human);
	_g_match_info_free0 (i_cause);
	_g_match_info_free0 (i_ctx);
	_g_regex_unref0 (actions);
	_g_regex_unref0 (human);
	_g_regex_unref0 (cause);
	_g_regex_unref0 (context);
	return result;
}


static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const gchar* s) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	{
		GMatchInfo* info;
		GRegex* _tmp0_;
		GRegex* r_tags;
		GRegex* _tmp1_;
		GRegex* r_skip;
		GRegex* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		GMatchInfo* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		GMatchInfo* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* account;
		GMatchInfo* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* host;
		GMatchInfo* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* tags;
		GMatchInfo* i_args;
		GRegex* _tmp18_;
		GRegex* r_stats;
		GRegex* _tmp19_;
		GRegex* r_error;
		GRegex* _tmp20_;
		const gchar* _tmp21_;
		GMatchInfo* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		info = NULL;
		_tmp0_ = g_regex_new ("^([^:]+): smd-(client|server|loop|push|pull|pushpull)@([^:]+): TAGS:(." \
"*)$", 0, 0, &_inner_error_);
		r_tags = _tmp0_;
		if (_inner_error_ != NULL) {
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp1_ = g_regex_new ("^([^:]+): smd-(client|server)@([^:]+): ERROR", 0, 0, &_inner_error_);
		r_skip = _tmp1_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp2_ = r_skip;
		_tmp3_ = s;
		_tmp4_ = g_regex_match (_tmp2_, _tmp3_, 0, NULL);
		if (_tmp4_) {
			result = TRUE;
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			return result;
		}
		_tmp5_ = r_tags;
		_tmp6_ = s;
		_tmp8_ = g_regex_match (_tmp5_, _tmp6_, 0, &_tmp7_);
		_g_match_info_free0 (info);
		info = _tmp7_;
		if (!_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp9_ = s;
			_tmp10_ = g_strdup_printf ("unhandled smd-loop message: %s", _tmp9_);
			_tmp11_ = _tmp10_;
			debug (_tmp11_);
			_g_free0 (_tmp11_);
			result = TRUE;
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			return result;
		}
		_tmp12_ = info;
		_tmp13_ = g_match_info_fetch (_tmp12_, 1);
		account = _tmp13_;
		_tmp14_ = info;
		_tmp15_ = g_match_info_fetch (_tmp14_, 3);
		host = _tmp15_;
		_tmp16_ = info;
		_tmp17_ = g_match_info_fetch (_tmp16_, 4);
		tags = _tmp17_;
		i_args = NULL;
		_tmp18_ = g_regex_new (" stats::(.*)$", 0, 0, &_inner_error_);
		r_stats = _tmp18_;
		if (_inner_error_ != NULL) {
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp19_ = g_regex_new (" error::(.*)$", 0, 0, &_inner_error_);
		r_error = _tmp19_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp20_ = r_stats;
		_tmp21_ = tags;
		_tmp23_ = g_regex_match (_tmp20_, _tmp21_, 0, &_tmp22_);
		_g_match_info_free0 (i_args);
		i_args = _tmp22_;
		if (_tmp23_) {
			GRegex* _tmp24_;
			GRegex* r_neW;
			GRegex* _tmp25_;
			GRegex* r_del;
			GMatchInfo* i_new;
			GMatchInfo* i_del;
			GMatchInfo* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* args;
			GRegex* _tmp28_;
			const gchar* _tmp29_;
			GMatchInfo* _tmp30_ = NULL;
			gboolean _tmp31_ = FALSE;
			gboolean has_new;
			GRegex* _tmp32_;
			const gchar* _tmp33_;
			GMatchInfo* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			gboolean has_del;
			gint new_mails;
			gboolean _tmp36_;
			gint del_mails;
			gboolean _tmp41_;
			gboolean _tmp46_ = FALSE;
			const gchar* _tmp47_;
			gboolean _tmp52_;
			_tmp24_ = g_regex_new ("new-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
			r_neW = _tmp24_;
			if (_inner_error_ != NULL) {
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch14_g_regex_error;
				}
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp25_ = g_regex_new ("del-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
			r_del = _tmp25_;
			if (_inner_error_ != NULL) {
				_g_regex_unref0 (r_neW);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch14_g_regex_error;
				}
				_g_regex_unref0 (r_neW);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			i_new = NULL;
			i_del = NULL;
			_tmp26_ = i_args;
			_tmp27_ = g_match_info_fetch (_tmp26_, 1);
			args = _tmp27_;
			_tmp28_ = r_neW;
			_tmp29_ = args;
			_tmp31_ = g_regex_match (_tmp28_, _tmp29_, 0, &_tmp30_);
			_g_match_info_free0 (i_new);
			i_new = _tmp30_;
			has_new = _tmp31_;
			_tmp32_ = r_del;
			_tmp33_ = args;
			_tmp35_ = g_regex_match (_tmp32_, _tmp33_, 0, &_tmp34_);
			_g_match_info_free0 (i_del);
			i_del = _tmp34_;
			has_del = _tmp35_;
			new_mails = 0;
			_tmp36_ = has_new;
			if (_tmp36_) {
				GMatchInfo* _tmp37_;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_;
				gint _tmp40_ = 0;
				_tmp37_ = i_new;
				_tmp38_ = g_match_info_fetch (_tmp37_, 1);
				_tmp39_ = _tmp38_;
				_tmp40_ = atoi (_tmp39_);
				new_mails = _tmp40_;
				_g_free0 (_tmp39_);
			}
			del_mails = 0;
			_tmp41_ = has_del;
			if (_tmp41_) {
				GMatchInfo* _tmp42_;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_;
				gint _tmp45_ = 0;
				_tmp42_ = i_del;
				_tmp43_ = g_match_info_fetch (_tmp42_, 1);
				_tmp44_ = _tmp43_;
				_tmp45_ = atoi (_tmp44_);
				del_mails = _tmp45_;
				_g_free0 (_tmp44_);
			}
			_tmp47_ = host;
			if (g_strcmp0 (_tmp47_, "localhost") == 0) {
				gboolean _tmp48_ = FALSE;
				gint _tmp49_;
				gboolean _tmp51_;
				_tmp49_ = new_mails;
				if (_tmp49_ > 0) {
					_tmp48_ = TRUE;
				} else {
					gint _tmp50_;
					_tmp50_ = del_mails;
					_tmp48_ = _tmp50_ > 0;
				}
				_tmp51_ = _tmp48_;
				_tmp46_ = _tmp51_;
			} else {
				_tmp46_ = FALSE;
			}
			_tmp52_ = _tmp46_;
			if (_tmp52_) {
				GeeArrayList* _tmp53_;
				GeeArrayList* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				Event* _tmp61_ = NULL;
				Event* _tmp62_;
				g_mutex_lock (&self->priv->events_lock);
				_tmp53_ = self->priv->events;
				_tmp54_ = self->priv->events;
				_tmp55_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = account;
				_tmp58_ = host;
				_tmp59_ = new_mails;
				_tmp60_ = del_mails;
				_tmp61_ = event_stats (_tmp57_, _tmp58_, _tmp59_, _tmp60_);
				_tmp62_ = _tmp61_;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp53_, _tmp56_, _tmp62_);
				_event_unref0 (_tmp62_);
				g_mutex_unlock (&self->priv->events_lock);
			} else {
			}
			result = TRUE;
			_g_free0 (args);
			_g_match_info_free0 (i_del);
			_g_match_info_free0 (i_new);
			_g_regex_unref0 (r_del);
			_g_regex_unref0 (r_neW);
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			return result;
		} else {
			GRegex* _tmp63_;
			const gchar* _tmp64_;
			GMatchInfo* _tmp65_ = NULL;
			gboolean _tmp66_ = FALSE;
			_tmp63_ = r_error;
			_tmp64_ = tags;
			_tmp66_ = g_regex_match (_tmp63_, _tmp64_, 0, &_tmp65_);
			_g_match_info_free0 (i_args);
			i_args = _tmp65_;
			if (_tmp66_) {
				GMatchInfo* _tmp67_;
				gchar* _tmp68_ = NULL;
				gchar* args;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				const gchar* _tmp71_;
				gboolean _tmp72_ = FALSE;
				gboolean _tmp73_;
				_tmp67_ = i_args;
				_tmp68_ = g_match_info_fetch (_tmp67_, 1);
				args = _tmp68_;
				_tmp69_ = args;
				_tmp70_ = account;
				_tmp71_ = host;
				_tmp72_ = smd_applet_eval_smd_loop_error_message (self, _tmp69_, _tmp70_, _tmp71_, &_inner_error_);
				_tmp73_ = _tmp72_;
				if (_inner_error_ != NULL) {
					_g_free0 (args);
					_g_regex_unref0 (r_error);
					_g_regex_unref0 (r_stats);
					_g_match_info_free0 (i_args);
					_g_free0 (tags);
					_g_free0 (host);
					_g_free0 (account);
					_g_regex_unref0 (r_skip);
					_g_regex_unref0 (r_tags);
					_g_match_info_free0 (info);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch14_g_regex_error;
					}
					_g_free0 (args);
					_g_regex_unref0 (r_error);
					_g_regex_unref0 (r_stats);
					_g_match_info_free0 (i_args);
					_g_free0 (tags);
					_g_free0 (host);
					_g_free0 (account);
					_g_regex_unref0 (r_skip);
					_g_regex_unref0 (r_tags);
					_g_match_info_free0 (info);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				result = _tmp73_;
				_g_free0 (args);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				return result;
			} else {
				FILE* _tmp74_;
				const gchar* _tmp75_;
				_tmp74_ = stderr;
				_tmp75_ = s;
				fprintf (_tmp74_, "unhandled smd-loop message: %s\n", _tmp75_);
				result = TRUE;
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				return result;
			}
		}
		_g_regex_unref0 (r_error);
		_g_regex_unref0 (r_stats);
		_g_match_info_free0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
		FILE* _tmp76_;
		GError* _tmp77_;
		const gchar* _tmp78_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp76_ = stderr;
		_tmp77_ = e;
		_tmp78_ = _tmp77_->message;
		fprintf (_tmp76_, "%s\n", _tmp78_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void ___lambda4_ (smdApplet* self) {
	setpgid ((pid_t) 0, (pid_t) 0);
}


static void ____lambda4__gspawn_child_setup_func (gpointer self) {
	___lambda4_ (self);
}


static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** cmd;
	gint cmd_length1;
	gint _cmd_size_;
	gint child_in = 0;
	gint child_out = 0;
	gint child_err = 0;
	gchar* _tmp4_ = NULL;
	gchar* buff;
	gint buff_length1;
	gint _buff_size_;
	GSpawnFlags flags;
	gboolean rc = FALSE;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = smd_applet_smd_loop_cmd;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("-v");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	cmd = _tmp3_;
	cmd_length1 = 2;
	_cmd_size_ = cmd_length1;
	_tmp4_ = g_new0 (gchar, 10240);
	buff = _tmp4_;
	buff_length1 = 10240;
	_buff_size_ = buff_length1;
	flags = 0;
	_tmp5_ = smd_applet_smd_loop_cmd;
	_tmp6_ = g_strdup_printf ("spawning %s\n", _tmp5_);
	_tmp7_ = _tmp6_;
	debug (_tmp7_);
	_g_free0 (_tmp7_);
	{
		gchar** _tmp8_;
		gint _tmp8__length1;
		GSpawnFlags _tmp9_;
		GPid _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp8_ = cmd;
		_tmp8__length1 = cmd_length1;
		_tmp9_ = flags;
		_tmp14_ = g_spawn_async_with_pipes (NULL, _tmp8_, NULL, _tmp9_, ____lambda4__gspawn_child_setup_func, self, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_inner_error_);
		self->priv->pid = _tmp10_;
		child_in = _tmp11_;
		child_out = _tmp12_;
		child_err = _tmp13_;
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		rc = _tmp15_;
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		FILE* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GError* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stderr;
		_tmp17_ = smd_applet_smd_loop_cmd;
		_tmp18_ = g_strconcat ("Unable to execute ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, ": ", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
		_tmp27_ = _tmp26_;
		fprintf (_tmp16_, "%s", _tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_tmp28_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		_inner_error_ = _tmp28_;
		_g_error_free0 (e);
		goto __finally15;
	}
	__finally15:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (rc) {
		gint _tmp29_;
		FILE* _tmp30_ = NULL;
		FILE* input;
		gchar* s;
		gboolean goon;
		const gchar* _tmp50_;
		GPid _tmp60_;
		GPid _tmp61_;
		_tmp29_ = child_out;
		_tmp30_ = fdopen (_tmp29_, "r");
		input = _tmp30_;
		s = NULL;
		goon = TRUE;
		while (TRUE) {
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_;
			gboolean _tmp39_;
			gboolean _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_;
			const gchar* _tmp45_;
			gboolean _tmp46_ = FALSE;
			gboolean _tmp47_;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_;
			_tmp33_ = goon;
			if (_tmp33_) {
				FILE* _tmp34_;
				gchar* _tmp35_;
				gint _tmp35__length1;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp34_ = input;
				_tmp35_ = buff;
				_tmp35__length1 = buff_length1;
				_tmp36_ = fgets (_tmp35_, _tmp35__length1, _tmp34_);
				_tmp37_ = g_strdup (_tmp36_);
				_g_free0 (s);
				s = _tmp37_;
				_tmp38_ = s;
				_tmp32_ = _tmp38_ != NULL;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp39_ = _tmp32_;
			if (_tmp39_) {
				gboolean _tmp40_;
				_tmp40_ = self->priv->thread_die;
				_tmp31_ = !_tmp40_;
			} else {
				_tmp31_ = FALSE;
			}
			_tmp41_ = _tmp31_;
			if (!_tmp41_) {
				break;
			}
			_tmp42_ = s;
			_tmp43_ = g_strdup_printf ("smd-loop outputs: %s", _tmp42_);
			_tmp44_ = _tmp43_;
			debug (_tmp44_);
			_g_free0 (_tmp44_);
			_tmp45_ = s;
			_tmp46_ = smd_applet_eval_smd_loop_message (self, _tmp45_);
			goon = _tmp46_;
			_tmp47_ = goon;
			_tmp48_ = g_strdup_printf ("eval_smd_loop_message returned %d", (gint) _tmp47_);
			_tmp49_ = _tmp48_;
			debug (_tmp49_);
			_g_free0 (_tmp49_);
		}
		_tmp50_ = s;
		if (_tmp50_ != NULL) {
			FILE* _tmp51_;
			gchar* _tmp52_;
			gint _tmp52__length1;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_;
			const gchar* _tmp55_;
			_tmp51_ = input;
			_tmp52_ = buff;
			_tmp52__length1 = buff_length1;
			_tmp53_ = fgets (_tmp52_, _tmp52__length1, _tmp51_);
			_tmp54_ = g_strdup (_tmp53_);
			_g_free0 (s);
			s = _tmp54_;
			_tmp55_ = s;
			if (_tmp55_ != NULL) {
				FILE* _tmp56_;
				FILE* _tmp57_;
				GPid _tmp58_;
				const gchar* _tmp59_;
				_tmp56_ = stderr;
				fprintf (_tmp56_, "smd-loop gave error tag but not died\n");
				_tmp57_ = stderr;
				_tmp58_ = self->priv->pid;
				_tmp59_ = s;
				fprintf (_tmp57_, "smd-loop has pid %d and prints %s\n", (gint) _tmp58_, _tmp59_);
			}
		}
		_tmp60_ = self->priv->pid;
		g_spawn_close_pid (_tmp60_);
		_tmp61_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp61_)), SIGTERM);
		result = goon;
		_g_free0 (s);
		_fclose0 (input);
		buff = (g_free (buff), NULL);
		cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		FILE* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		GError* _tmp68_;
		_tmp62_ = stderr;
		_tmp63_ = smd_applet_smd_loop_cmd;
		_tmp64_ = g_strconcat ("Unable to execute ", _tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strconcat (_tmp65_, "\n", NULL);
		_tmp67_ = _tmp66_;
		fprintf (_tmp62_, "%s", _tmp67_);
		_g_free0 (_tmp67_);
		_g_free0 (_tmp65_);
		_tmp68_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		_inner_error_ = _tmp68_;
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	buff = (g_free (buff), NULL);
	cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
}


static void ______lambda18_ (smdApplet* self, NotifyNotification* not, const gchar* action) {
	GtkWindow* _tmp0_;
	g_return_if_fail (not != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->err_win;
	gtk_window_reshow_with_initial_size (_tmp0_);
}


static void _______lambda18__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	______lambda18_ (self, notification, action);
}


static void ______lambda19_ (smdApplet* self, GtkButton* b) {
	gint cmd_status = 0;
	gchar* output = NULL;
	gchar* _error_ = NULL;
	GHashTable* _tmp0_;
	GtkButton* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->command_hash;
	_tmp1_ = b;
	_tmp2_ = g_hash_table_lookup (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp3_ = g_strdup_printf ("executing: %s\n", (const gchar*) _tmp2_);
	_tmp4_ = _tmp3_;
	debug (_tmp4_);
	_g_free0 (_tmp4_);
	{
		GHashTable* _tmp5_;
		GtkButton* _tmp6_;
		gconstpointer _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp14_;
		_tmp5_ = self->priv->command_hash;
		_tmp6_ = b;
		_tmp7_ = g_hash_table_lookup (_tmp5_, (GtkWidget*) _tmp6_);
		g_spawn_command_line_sync ((const gchar*) _tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_inner_error_);
		_g_free0 (output);
		output = _tmp8_;
		_g_free0 (_error_);
		_error_ = _tmp9_;
		cmd_status = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch20_g_spawn_error;
			}
			_g_free0 (_error_);
			_g_free0 (output);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = WIFEXITED (cmd_status);
		if (_tmp12_) {
			gint _tmp13_ = 0;
			_tmp13_ = WEXITSTATUS (cmd_status);
			_tmp11_ = 0 == _tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp14_ = _tmp11_;
		if (_tmp14_) {
			GtkButton* _tmp15_;
			_tmp15_ = b;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
		} else {
			GtkWindow* _tmp16_;
			GtkMessageDialog* _tmp17_;
			GtkMessageDialog* _tmp18_;
			GtkMessageDialog* w;
			GtkMessageDialog* _tmp19_;
			GtkMessageDialog* _tmp20_;
			_tmp16_ = self->priv->err_win;
			_tmp17_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp16_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "An error occurred:\n%s\n%s", output, _error_);
			_tmp18_ = g_object_ref_sink (_tmp17_);
			w = _tmp18_;
			_tmp19_ = w;
			gtk_dialog_run ((GtkDialog*) _tmp19_);
			_tmp20_ = w;
			gtk_widget_destroy ((GtkWidget*) _tmp20_);
			_g_object_unref0 (w);
		}
	}
	goto __finally20;
	__catch20_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = stderr;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		fprintf (_tmp21_, "Spawning: %s\n", _tmp23_);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_free0 (_error_);
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (_error_);
	_g_free0 (output);
}


static void _______lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda19_ (self, _sender);
}


static gboolean smd_applet_eat_event (smdApplet* self) {
	gboolean result = FALSE;
	Event* e;
	gboolean _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp9_ = FALSE;
	Event* _tmp10_;
	gboolean _tmp13_;
	gboolean _tmp63_ = FALSE;
	Event* _tmp64_;
	gboolean _tmp67_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	e = NULL;
	_tmp0_ = self->priv->error_mode;
	if (_tmp0_) {
		result = TRUE;
		_event_unref0 (e);
		return result;
	}
	g_mutex_lock (&self->priv->events_lock);
	_tmp1_ = self->priv->events;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_;
		gpointer _tmp5_ = NULL;
		GeeArrayList* _tmp6_;
		gpointer _tmp7_ = NULL;
		Event* _tmp8_;
		_tmp4_ = self->priv->events;
		_tmp5_ = gee_abstract_list_first ((GeeAbstractList*) _tmp4_);
		_event_unref0 (e);
		e = (Event*) _tmp5_;
		_tmp6_ = self->priv->events;
		_tmp7_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp6_, 0);
		_tmp8_ = (Event*) _tmp7_;
		_event_unref0 (_tmp8_);
	}
	g_mutex_unlock (&self->priv->events_lock);
	_tmp10_ = e;
	if (_tmp10_ != NULL) {
		Event* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp9_ = _tmp12_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp13_ = _tmp9_;
	if (_tmp13_) {
		gboolean notify_on_newail;
		gboolean _tmp20_ = FALSE;
		Event* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp24_;
		notify_on_newail = FALSE;
		{
			GConfClient* _tmp14_;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_;
			_tmp14_ = self->priv->gconf;
			_tmp15_ = gconf_client_get_bool (_tmp14_, SMD_APPLET_key_newmail, &_inner_error_);
			_tmp16_ = _tmp15_;
			if (_inner_error_ != NULL) {
				goto __catch16_g_error;
			}
			notify_on_newail = _tmp16_;
		}
		goto __finally16;
		__catch16_g_error:
		{
			GError* e = NULL;
			FILE* _tmp17_;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = stderr;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			fprintf (_tmp17_, "%s\n", _tmp19_);
			_g_error_free0 (e);
		}
		__finally16:
		if (_inner_error_ != NULL) {
			_event_unref0 (e);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp21_ = e;
		_tmp22_ = _tmp21_->enter_network_error_mode;
		if (_tmp22_) {
			gboolean _tmp23_;
			_tmp23_ = self->priv->network_error_mode;
			_tmp20_ = _tmp23_;
		} else {
			_tmp20_ = FALSE;
		}
		_tmp24_ = _tmp20_;
		if (_tmp24_) {
		} else {
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			Event* _tmp27_;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp30_;
			gboolean _tmp37_;
			_tmp27_ = e;
			_tmp28_ = event_is_error_event (_tmp27_);
			if (!_tmp28_) {
				gboolean _tmp29_;
				_tmp29_ = notify_on_newail;
				_tmp26_ = _tmp29_;
			} else {
				_tmp26_ = FALSE;
			}
			_tmp30_ = _tmp26_;
			if (_tmp30_) {
				_tmp25_ = TRUE;
			} else {
				gboolean _tmp31_ = FALSE;
				Event* _tmp32_;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp36_;
				_tmp32_ = e;
				_tmp33_ = event_is_error_event (_tmp32_);
				if (_tmp33_) {
					Event* _tmp34_;
					gboolean _tmp35_;
					_tmp34_ = e;
					_tmp35_ = _tmp34_->enter_network_error_mode;
					_tmp31_ = _tmp35_;
				} else {
					_tmp31_ = FALSE;
				}
				_tmp36_ = _tmp31_;
				_tmp25_ = _tmp36_;
			}
			_tmp37_ = _tmp25_;
			if (_tmp37_) {
				Event* _tmp38_;
				const gchar* _tmp39_;
				Event* _tmp40_;
				const gchar* _tmp41_;
				NotifyNotification* _tmp42_;
				NotifyNotification* _tmp43_;
				GVariant* _tmp44_;
				GVariant* _tmp45_;
				_tmp38_ = e;
				_tmp39_ = _tmp38_->message;
				_tmp40_ = e;
				_tmp41_ = _tmp40_->message_icon;
				_tmp42_ = notify_notification_new ("Syncmaildir", _tmp39_, _tmp41_);
				_g_object_unref0 (self->priv->notification);
				self->priv->notification = _tmp42_;
				_tmp43_ = self->priv->notification;
				_tmp44_ = g_variant_new_boolean (TRUE);
				_tmp45_ = g_variant_ref_sink (_tmp44_);
				notify_notification_set_hint (_tmp43_, "transient", _tmp45_);
				_g_variant_unref0 (_tmp45_);
				{
					NotifyNotification* _tmp46_;
					_tmp46_ = self->priv->notification;
					notify_notification_show (_tmp46_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch17_g_error;
					}
				}
				goto __finally17;
				__catch17_g_error:
				{
					GError* e = NULL;
					FILE* _tmp47_;
					GError* _tmp48_;
					const gchar* _tmp49_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp47_ = stderr;
					_tmp48_ = e;
					_tmp49_ = _tmp48_->message;
					fprintf (_tmp47_, "%s\n", _tmp49_);
					_g_error_free0 (e);
				}
				__finally17:
				if (_inner_error_ != NULL) {
					_event_unref0 (e);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			} else {
				Event* _tmp50_;
				gboolean _tmp51_ = FALSE;
				_tmp50_ = e;
				_tmp51_ = event_is_error_event (_tmp50_);
				if (_tmp51_) {
					Event* _tmp52_;
					const gchar* _tmp53_;
					Event* _tmp54_;
					const gchar* _tmp55_;
					NotifyNotification* _tmp56_;
					NotifyNotification* _tmp57_;
					NotifyNotification* _tmp58_;
					_tmp52_ = e;
					_tmp53_ = _tmp52_->message;
					_tmp54_ = e;
					_tmp55_ = _tmp54_->message_icon;
					_tmp56_ = notify_notification_new ("Syncmaildir", _tmp53_, _tmp55_);
					_g_object_unref0 (self->priv->notification);
					self->priv->notification = _tmp56_;
					_tmp57_ = self->priv->notification;
					notify_notification_set_timeout (_tmp57_, 0);
					_tmp58_ = self->priv->notification;
					notify_notification_add_action (_tmp58_, "clicked", "Handle error", _______lambda18__notify_action_callback, smd_applet_ref (self), smd_applet_unref);
					{
						NotifyNotification* _tmp59_;
						_tmp59_ = self->priv->notification;
						notify_notification_show (_tmp59_, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch18_g_error;
						}
					}
					goto __finally18;
					__catch18_g_error:
					{
						GError* e = NULL;
						FILE* _tmp60_;
						GError* _tmp61_;
						const gchar* _tmp62_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp60_ = stderr;
						_tmp61_ = e;
						_tmp62_ = _tmp61_->message;
						fprintf (_tmp60_, "%s\n", _tmp62_);
						_g_error_free0 (e);
					}
					__finally18:
					if (_inner_error_ != NULL) {
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
			}
		}
	}
	_tmp64_ = e;
	if (_tmp64_ != NULL) {
		Event* _tmp65_;
		gboolean _tmp66_;
		_tmp65_ = e;
		_tmp66_ = _tmp65_->enter_error_mode;
		_tmp63_ = _tmp66_;
	} else {
		_tmp63_ = FALSE;
	}
	_tmp67_ = _tmp63_;
	if (_tmp67_) {
		GtkStatusIcon* _tmp68_;
		GtkStatusIcon* _tmp69_;
		gboolean _tmp70_;
		GtkBuilder* _tmp72_;
		GObject* _tmp73_ = NULL;
		GtkLabel* _tmp74_;
		GtkLabel* l_ctx;
		GtkBuilder* _tmp75_;
		GObject* _tmp76_ = NULL;
		GtkLabel* _tmp77_;
		GtkLabel* l_cause;
		GtkLabel* _tmp78_;
		Event* _tmp79_;
		const gchar* _tmp80_;
		GtkLabel* _tmp81_;
		Event* _tmp82_;
		const gchar* _tmp83_;
		GHashTable* _tmp84_;
		GtkBuilder* _tmp85_;
		GObject* _tmp86_ = NULL;
		GtkVBox* _tmp87_;
		GtkVBox* vb;
		GtkVBox* _tmp88_;
		GList* _tmp89_ = NULL;
		Event* _tmp93_;
		const gchar* _tmp94_;
		Event* _tmp101_;
		const gchar* _tmp102_;
		Event* _tmp130_;
		GeeArrayList* _tmp131_;
		GtkBuilder* _tmp180_;
		GObject* _tmp181_ = NULL;
		GtkWidget* _tmp182_;
		GtkWidget* x;
		GtkWidget* _tmp183_;
		Event* _tmp184_;
		const gchar* _tmp185_;
		GtkBuilder* _tmp186_;
		GObject* _tmp187_ = NULL;
		GtkWidget* _tmp188_;
		GtkWidget* _tmp189_;
		Event* _tmp190_;
		const gchar* _tmp191_;
		GtkBuilder* _tmp192_;
		GObject* _tmp193_ = NULL;
		GtkWidget* _tmp194_;
		GtkWidget* _tmp195_;
		Event* _tmp196_;
		GeeArrayList* _tmp197_;
		gint _tmp198_;
		gint _tmp199_;
		_tmp68_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp68_, "error");
		_tmp69_ = self->priv->si;
		gtk_status_icon_set_tooltip_text (_tmp69_, "smd-applet encountered an error");
		self->priv->error_mode = TRUE;
		_tmp70_ = self->priv->notification_server_has_persistence;
		if (!_tmp70_) {
			GtkStatusIcon* _tmp71_;
			_tmp71_ = self->priv->si;
			gtk_status_icon_set_visible (_tmp71_, TRUE);
		}
		_tmp72_ = self->priv->builder;
		_tmp73_ = gtk_builder_get_object (_tmp72_, "lContext");
		_tmp74_ = _g_object_ref0 (GTK_IS_LABEL (_tmp73_) ? ((GtkLabel*) _tmp73_) : NULL);
		l_ctx = _tmp74_;
		_tmp75_ = self->priv->builder;
		_tmp76_ = gtk_builder_get_object (_tmp75_, "lCause");
		_tmp77_ = _g_object_ref0 (GTK_IS_LABEL (_tmp76_) ? ((GtkLabel*) _tmp76_) : NULL);
		l_cause = _tmp77_;
		_tmp78_ = l_ctx;
		_tmp79_ = e;
		_tmp80_ = _tmp79_->context;
		gtk_label_set_text (_tmp78_, _tmp80_);
		_tmp81_ = l_cause;
		_tmp82_ = e;
		_tmp83_ = _tmp82_->cause;
		gtk_label_set_text (_tmp81_, _tmp83_);
		_tmp84_ = self->priv->command_hash;
		g_hash_table_remove_all (_tmp84_);
		_tmp85_ = self->priv->builder;
		_tmp86_ = gtk_builder_get_object (_tmp85_, "vbRun");
		_tmp87_ = _g_object_ref0 (GTK_IS_VBOX (_tmp86_) ? ((GtkVBox*) _tmp86_) : NULL);
		vb = _tmp87_;
		_tmp88_ = vb;
		_tmp89_ = gtk_container_get_children ((GtkContainer*) _tmp88_);
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp89_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp90_;
				GtkWidget* w = NULL;
				_tmp90_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp90_;
				{
					GtkVBox* _tmp91_;
					GtkWidget* _tmp92_;
					_tmp91_ = vb;
					_tmp92_ = w;
					gtk_container_remove ((GtkContainer*) _tmp91_, _tmp92_);
					_g_object_unref0 (w);
				}
			}
			_g_list_free0 (w_collection);
		}
		_tmp93_ = e;
		_tmp94_ = _tmp93_->permissions;
		if (_tmp94_ != NULL) {
			GtkBuilder* _tmp95_;
			GObject* _tmp96_ = NULL;
			GtkLabel* _tmp97_;
			GtkLabel* l;
			GtkLabel* _tmp98_;
			Event* _tmp99_;
			const gchar* _tmp100_;
			_tmp95_ = self->priv->builder;
			_tmp96_ = gtk_builder_get_object (_tmp95_, "lPermissions");
			_tmp97_ = _g_object_ref0 (GTK_IS_LABEL (_tmp96_) ? ((GtkLabel*) _tmp96_) : NULL);
			l = _tmp97_;
			_tmp98_ = l;
			_tmp99_ = e;
			_tmp100_ = _tmp99_->permissions;
			gtk_label_set_text (_tmp98_, _tmp100_);
			_g_object_unref0 (l);
		}
		_tmp101_ = e;
		_tmp102_ = _tmp101_->mail_name;
		if (_tmp102_ != NULL) {
			GtkBuilder* _tmp103_;
			GObject* _tmp104_ = NULL;
			GtkEntry* _tmp105_;
			GtkEntry* fn;
			GtkEntry* _tmp106_;
			Event* _tmp107_;
			const gchar* _tmp108_;
			GtkBuilder* _tmp109_;
			GObject* _tmp110_ = NULL;
			GtkTextView* _tmp111_;
			GtkTextView* l;
			GtkTextView* _tmp112_;
			GtkTextBuffer* _tmp113_ = NULL;
			GtkTextBuffer* _tmp114_;
			GtkTextBuffer* b;
			GtkTextBuffer* _tmp115_;
			Event* _tmp116_;
			const gchar* _tmp117_;
			GtkTextIter it = {0};
			GtkTextIter subj = {0};
			GtkTextBuffer* _tmp118_;
			GtkTextIter _tmp119_ = {0};
			GtkTextIter _tmp120_ = {0};
			gboolean _tmp121_ = FALSE;
			_tmp103_ = self->priv->builder;
			_tmp104_ = gtk_builder_get_object (_tmp103_, "eMailName");
			_tmp105_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp104_) ? ((GtkEntry*) _tmp104_) : NULL);
			fn = _tmp105_;
			_tmp106_ = fn;
			_tmp107_ = e;
			_tmp108_ = _tmp107_->mail_name;
			gtk_entry_set_text (_tmp106_, _tmp108_);
			_tmp109_ = self->priv->builder;
			_tmp110_ = gtk_builder_get_object (_tmp109_, "tvMail");
			_tmp111_ = _g_object_ref0 (GTK_IS_TEXT_VIEW (_tmp110_) ? ((GtkTextView*) _tmp110_) : NULL);
			l = _tmp111_;
			_tmp112_ = l;
			_tmp113_ = gtk_text_view_get_buffer (_tmp112_);
			_tmp114_ = _g_object_ref0 (_tmp113_);
			b = _tmp114_;
			_tmp115_ = b;
			_tmp116_ = e;
			_tmp117_ = _tmp116_->mail_body;
			gtk_text_buffer_set_text (_tmp115_, _tmp117_, -1);
			_tmp118_ = b;
			gtk_text_buffer_get_start_iter (_tmp118_, &_tmp119_);
			it = _tmp119_;
			_tmp121_ = gtk_text_iter_forward_search (&it, "Subject:", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp120_, NULL, NULL);
			subj = _tmp120_;
			if (_tmp121_) {
				GtkTextBuffer* _tmp122_;
				GtkTextMark* _tmp123_ = NULL;
				GtkTextMark* _tmp124_;
				GtkTextMark* insert;
				GtkTextBuffer* _tmp125_;
				GtkTextIter _tmp126_;
				GtkTextIter _tmp127_;
				GtkTextView* _tmp128_;
				GtkTextMark* _tmp129_;
				_tmp122_ = b;
				_tmp123_ = gtk_text_buffer_get_insert (_tmp122_);
				_tmp124_ = _g_object_ref0 (_tmp123_);
				insert = _tmp124_;
				_tmp125_ = b;
				_tmp126_ = subj;
				_tmp127_ = subj;
				gtk_text_buffer_select_range (_tmp125_, &_tmp126_, &_tmp127_);
				_tmp128_ = l;
				_tmp129_ = insert;
				gtk_text_view_scroll_to_mark (_tmp128_, _tmp129_, 0.0, TRUE, 0.0, 0.0);
				_g_object_unref0 (insert);
			}
			_g_object_unref0 (b);
			_g_object_unref0 (l);
			_g_object_unref0 (fn);
		}
		_tmp130_ = e;
		_tmp131_ = _tmp130_->commands;
		if (_tmp131_ != NULL) {
			{
				Event* _tmp132_;
				GeeArrayList* _tmp133_;
				GeeArrayList* _tmp134_;
				GeeArrayList* _command_list;
				GeeArrayList* _tmp135_;
				gint _tmp136_;
				gint _tmp137_;
				gint _command_size;
				gint _command_index;
				_tmp132_ = e;
				_tmp133_ = _tmp132_->commands;
				_tmp134_ = _g_object_ref0 (_tmp133_);
				_command_list = _tmp134_;
				_tmp135_ = _command_list;
				_tmp136_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp135_);
				_tmp137_ = _tmp136_;
				_command_size = _tmp137_;
				_command_index = -1;
				while (TRUE) {
					gint _tmp138_;
					gint _tmp139_;
					gint _tmp140_;
					GeeArrayList* _tmp141_;
					gint _tmp142_;
					gpointer _tmp143_ = NULL;
					gchar* command;
					GtkHBox* _tmp144_;
					GtkHBox* _tmp145_;
					GtkHBox* hb;
					gchar* nice_command = NULL;
					const gchar* _tmp161_;
					GtkLabel* _tmp162_;
					GtkLabel* _tmp163_;
					GtkLabel* lbl;
					GtkLabel* _tmp164_;
					GtkButton* _tmp165_;
					GtkButton* _tmp166_;
					GtkButton* but;
					GHashTable* _tmp167_;
					GtkButton* _tmp168_;
					GtkWidget* _tmp169_;
					const gchar* _tmp170_;
					gchar* _tmp171_;
					GtkButton* _tmp172_;
					GtkHBox* _tmp173_;
					GtkLabel* _tmp174_;
					GtkHBox* _tmp175_;
					GtkButton* _tmp176_;
					GtkVBox* _tmp177_;
					GtkHBox* _tmp178_;
					GtkHBox* _tmp179_;
					_tmp138_ = _command_index;
					_command_index = _tmp138_ + 1;
					_tmp139_ = _command_index;
					_tmp140_ = _command_size;
					if (!(_tmp139_ < _tmp140_)) {
						break;
					}
					_tmp141_ = _command_list;
					_tmp142_ = _command_index;
					_tmp143_ = gee_abstract_list_get ((GeeAbstractList*) _tmp141_, _tmp142_);
					command = (gchar*) _tmp143_;
					_tmp144_ = (GtkHBox*) gtk_hbox_new (FALSE, 10);
					_tmp145_ = g_object_ref_sink (_tmp144_);
					hb = _tmp145_;
					{
						GMatchInfo* i_mailto = NULL;
						GRegex* _tmp146_;
						GRegex* mailto_rex;
						GRegex* _tmp147_;
						const gchar* _tmp148_;
						GMatchInfo* _tmp149_ = NULL;
						gboolean _tmp150_ = FALSE;
						_tmp146_ = g_regex_new ("^gnome-open..mailto:", 0, 0, &_inner_error_);
						mailto_rex = _tmp146_;
						if (_inner_error_ != NULL) {
							_g_match_info_free0 (i_mailto);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch19_g_regex_error;
							}
							_g_match_info_free0 (i_mailto);
							_g_free0 (nice_command);
							_g_object_unref0 (hb);
							_g_free0 (command);
							_g_object_unref0 (_command_list);
							_g_object_unref0 (vb);
							_g_object_unref0 (l_cause);
							_g_object_unref0 (l_ctx);
							_event_unref0 (e);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_tmp147_ = mailto_rex;
						_tmp148_ = command;
						_tmp150_ = g_regex_match (_tmp147_, _tmp148_, 0, &_tmp149_);
						_g_match_info_free0 (i_mailto);
						i_mailto = _tmp149_;
						if (_tmp150_) {
							const gchar* _tmp151_;
							gchar* _tmp152_ = NULL;
							gchar* _tmp153_;
							gchar* _tmp154_ = NULL;
							gchar* _tmp155_;
							gchar* _tmp156_;
							_tmp151_ = command;
							_tmp152_ = g_uri_unescape_string (_tmp151_, NULL);
							_tmp153_ = _tmp152_;
							_tmp154_ = string_substring (_tmp153_, (glong) 12, (glong) 70);
							_tmp155_ = _tmp154_;
							_tmp156_ = g_strconcat (_tmp155_, "...", NULL);
							_g_free0 (nice_command);
							nice_command = _tmp156_;
							_g_free0 (_tmp155_);
							_g_free0 (_tmp153_);
						} else {
							const gchar* _tmp157_;
							gchar* _tmp158_;
							_tmp157_ = command;
							_tmp158_ = g_strdup (_tmp157_);
							_g_free0 (nice_command);
							nice_command = _tmp158_;
						}
						_g_regex_unref0 (mailto_rex);
						_g_match_info_free0 (i_mailto);
					}
					goto __finally19;
					__catch19_g_regex_error:
					{
						GError* e = NULL;
						const gchar* _tmp159_;
						gchar* _tmp160_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp159_ = command;
						_tmp160_ = g_strdup (_tmp159_);
						_g_free0 (nice_command);
						nice_command = _tmp160_;
						_g_error_free0 (e);
					}
					__finally19:
					if (_inner_error_ != NULL) {
						_g_free0 (nice_command);
						_g_object_unref0 (hb);
						_g_free0 (command);
						_g_object_unref0 (_command_list);
						_g_object_unref0 (vb);
						_g_object_unref0 (l_cause);
						_g_object_unref0 (l_ctx);
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_tmp161_ = nice_command;
					_tmp162_ = (GtkLabel*) gtk_label_new (_tmp161_);
					_tmp163_ = g_object_ref_sink (_tmp162_);
					lbl = _tmp163_;
					_tmp164_ = lbl;
					gtk_misc_set_alignment ((GtkMisc*) _tmp164_, 0.0f, 0.5f);
					_tmp165_ = (GtkButton*) gtk_button_new_from_stock ("gtk-execute");
					_tmp166_ = g_object_ref_sink (_tmp165_);
					but = _tmp166_;
					_tmp167_ = self->priv->command_hash;
					_tmp168_ = but;
					_tmp169_ = _g_object_ref0 ((GtkWidget*) _tmp168_);
					_tmp170_ = command;
					_tmp171_ = g_strdup (_tmp170_);
					g_hash_table_insert (_tmp167_, _tmp169_, _tmp171_);
					_tmp172_ = but;
					g_signal_connect (_tmp172_, "clicked", (GCallback) _______lambda19__gtk_button_clicked, self);
					_tmp173_ = hb;
					_tmp174_ = lbl;
					gtk_box_pack_end ((GtkBox*) _tmp173_, (GtkWidget*) _tmp174_, TRUE, TRUE, (guint) 0);
					_tmp175_ = hb;
					_tmp176_ = but;
					gtk_box_pack_end ((GtkBox*) _tmp175_, (GtkWidget*) _tmp176_, FALSE, FALSE, (guint) 0);
					_tmp177_ = vb;
					_tmp178_ = hb;
					gtk_box_pack_end ((GtkBox*) _tmp177_, (GtkWidget*) _tmp178_, TRUE, TRUE, (guint) 0);
					_tmp179_ = hb;
					gtk_widget_show_all ((GtkWidget*) _tmp179_);
					_g_object_unref0 (but);
					_g_object_unref0 (lbl);
					_g_free0 (nice_command);
					_g_object_unref0 (hb);
					_g_free0 (command);
				}
				_g_object_unref0 (_command_list);
			}
		}
		_tmp180_ = self->priv->builder;
		_tmp181_ = gtk_builder_get_object (_tmp180_, "fDisplayPermissions");
		_tmp182_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp181_) ? ((GtkWidget*) _tmp181_) : NULL);
		x = _tmp182_;
		_tmp183_ = x;
		_tmp184_ = e;
		_tmp185_ = _tmp184_->permissions;
		gtk_widget_set_visible (_tmp183_, _tmp185_ != NULL);
		_tmp186_ = self->priv->builder;
		_tmp187_ = gtk_builder_get_object (_tmp186_, "fDisplayMail");
		_tmp188_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp187_) ? ((GtkWidget*) _tmp187_) : NULL);
		_g_object_unref0 (x);
		x = _tmp188_;
		_tmp189_ = x;
		_tmp190_ = e;
		_tmp191_ = _tmp190_->mail_name;
		gtk_widget_set_visible (_tmp189_, _tmp191_ != NULL);
		_tmp192_ = self->priv->builder;
		_tmp193_ = gtk_builder_get_object (_tmp192_, "fRun");
		_tmp194_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp193_) ? ((GtkWidget*) _tmp193_) : NULL);
		_g_object_unref0 (x);
		x = _tmp194_;
		_tmp195_ = x;
		_tmp196_ = e;
		_tmp197_ = _tmp196_->commands;
		_tmp198_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp197_);
		_tmp199_ = _tmp198_;
		gtk_widget_set_visible (_tmp195_, _tmp199_ > 0);
		_g_object_unref0 (x);
		_g_object_unref0 (vb);
		_g_object_unref0 (l_cause);
		_g_object_unref0 (l_ctx);
	} else {
		gboolean _tmp200_ = FALSE;
		Event* _tmp201_;
		gboolean _tmp204_;
		_tmp201_ = e;
		if (_tmp201_ != NULL) {
			Event* _tmp202_;
			gboolean _tmp203_;
			_tmp202_ = e;
			_tmp203_ = _tmp202_->enter_network_error_mode;
			_tmp200_ = _tmp203_;
		} else {
			_tmp200_ = FALSE;
		}
		_tmp204_ = _tmp200_;
		if (_tmp204_) {
			GtkStatusIcon* _tmp205_;
			GtkStatusIcon* _tmp206_;
			self->priv->network_error_mode = TRUE;
			_tmp205_ = self->priv->si;
			gtk_status_icon_set_from_icon_name (_tmp205_, "dialog-warning");
			_tmp206_ = self->priv->si;
			gtk_status_icon_set_tooltip_text (_tmp206_, "Network error");
		} else {
			Event* _tmp207_;
			_tmp207_ = e;
			if (_tmp207_ != NULL) {
				GtkStatusIcon* _tmp208_;
				GtkStatusIcon* _tmp209_;
				self->priv->network_error_mode = FALSE;
				_tmp208_ = self->priv->si;
				gtk_status_icon_set_from_icon_name (_tmp208_, "mail-send-receive");
				_tmp209_ = self->priv->si;
				gtk_status_icon_set_tooltip_text (_tmp209_, "smd-applet is running");
			}
		}
	}
	result = TRUE;
	_event_unref0 (e);
	return result;
}


static void smd_applet_close_err_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_reset_to_regular_run (self, FALSE);
}


static gboolean smd_applet_close_err_event (smdApplet* self, GdkEventAny* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_reset_to_regular_run (self, FALSE);
	result = TRUE;
	return result;
}


static void smd_applet_reset_to_regular_run (smdApplet* self, gboolean force) {
	GtkWindow* _tmp0_;
	GtkStatusIcon* _tmp1_;
	GtkStatusIcon* _tmp2_;
	GThread* _tmp10_;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->err_win;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->error_mode = FALSE;
	_tmp1_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp1_, "smd-applet is running");
	_tmp2_ = self->priv->si;
	gtk_status_icon_set_from_icon_name (_tmp2_, "mail-send-receive");
	{
		GConfClient* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		GtkStatusIcon* _tmp6_;
		_tmp3_ = self->priv->gconf;
		_tmp4_ = gconf_client_get_bool (_tmp3_, SMD_APPLET_key_icon, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_tmp6_ = self->priv->si;
		gtk_status_icon_set_visible (_tmp6_, !_tmp5_);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	debug ("joining smdThread");
	_tmp10_ = self->priv->thread;
	g_thread_join (_tmp10_);
	self->priv->thread_die = FALSE;
	debug ("starting smdThread");
	_tmp11_ = force;
	smd_applet_start_smdThread (self, _tmp11_);
}


static void smd_applet_close_prefs_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_close_prefs (self);
}


static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEventAny* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_close_prefs (self);
	result = TRUE;
	return result;
}


static void smd_applet_close_prefs (smdApplet* self) {
	GtkWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->win;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp2_ = smd_applet_is_smd_stack_configured (self);
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->config_wait_mode;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		GtkStatusIcon* _tmp12_;
		self->priv->config_wait_mode = FALSE;
		{
			GConfClient* _tmp5_;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			GtkStatusIcon* _tmp8_;
			_tmp5_ = self->priv->gconf;
			_tmp6_ = gconf_client_get_bool (_tmp5_, SMD_APPLET_key_icon, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				goto __catch22_g_error;
			}
			_tmp8_ = self->priv->si;
			gtk_status_icon_set_visible (_tmp8_, !_tmp7_);
		}
		goto __finally22;
		__catch22_g_error:
		{
			GError* e = NULL;
			FILE* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = stderr;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			fprintf (_tmp9_, "Unable to read gconf key %s: %s\n", SMD_APPLET_key_icon, _tmp11_);
			_g_error_free0 (e);
		}
		__finally22:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp12_, "mail-send-receive");
		debug ("starting smdThread since smd stack is configured");
		smd_applet_start_smdThread (self, FALSE);
	}
}


static void smd_applet_close_logs (smdApplet* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->log_win;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void smd_applet_close_logs_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_close_logs (self);
}


static gboolean smd_applet_close_logs_event (smdApplet* self, GdkEventAny* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_close_logs (self);
	result = TRUE;
	return result;
}


static void smd_applet_my_gtk_main_quit_button (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	gtk_main_quit ();
}


static gboolean smd_applet_my_gtk_main_quit_event (smdApplet* self, GdkEventAny* b) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	gtk_main_quit ();
	result = FALSE;
	return result;
}


static void smd_applet_pause (smdApplet* self) {
	GPid _tmp0_;
	GtkStatusIcon* _tmp5_;
	GtkStatusIcon* _tmp6_;
	g_return_if_fail (self != NULL);
	debug ("enter pause mode");
	_tmp0_ = self->priv->pid;
	if (((gint) _tmp0_) != 0) {
		GPid _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GPid _tmp4_;
		_tmp1_ = self->priv->pid;
		_tmp2_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) _tmp1_));
		_tmp3_ = _tmp2_;
		debug (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp4_)), SIGTERM);
	}
	self->priv->thread_die = TRUE;
	_tmp5_ = self->priv->si;
	gtk_status_icon_set_from_stock (_tmp5_, "gtk-media-pause");
	_tmp6_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp6_, "smd-applet is paused");
}


static void smd_applet_unpause (smdApplet* self) {
	g_return_if_fail (self != NULL);
	debug ("exit pause mode");
	smd_applet_reset_to_regular_run (self, TRUE);
}


static gboolean smd_applet_is_smd_loop_configured (smdApplet* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean rc;
	GtkBuilder* _tmp2_;
	GObject* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* l;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = SMD_LOOP_CFG;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	rc = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "lErrLoop");
	_tmp4_ = _g_object_ref0 (GTK_IS_LABEL (_tmp3_) ? ((GtkLabel*) _tmp3_) : NULL);
	l = _tmp4_;
	_tmp5_ = rc;
	if (!_tmp5_) {
		GtkLabel* _tmp6_;
		_tmp6_ = l;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	} else {
		GtkLabel* _tmp7_;
		_tmp7_ = l;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean rc;
	GtkBuilder* _tmp2_;
	GObject* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* l;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = SMD_PP_DEF_CFG;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	rc = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "lErrPushPull");
	_tmp4_ = _g_object_ref0 (GTK_IS_LABEL (_tmp3_) ? ((GtkLabel*) _tmp3_) : NULL);
	l = _tmp4_;
	_tmp5_ = rc;
	if (!_tmp5_) {
		GtkLabel* _tmp6_;
		_tmp6_ = l;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	} else {
		GtkLabel* _tmp7_;
		_tmp7_ = l;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_stack_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean a;
	gboolean _tmp1_ = FALSE;
	gboolean b;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = smd_applet_is_smd_loop_configured (self);
	a = _tmp0_;
	_tmp1_ = smd_applet_is_smd_pushpull_configured (self);
	b = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = b;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	result = _tmp5_;
	return result;
}


static void smd_applet_update_loglist (smdApplet* self) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkTextView* _tmp2_;
	GtkTextView* tv;
	GtkTextView* _tmp3_;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* b;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "tvLog");
	_tmp2_ = _g_object_ref0 (GTK_IS_TEXT_VIEW (_tmp1_) ? ((GtkTextView*) _tmp1_) : NULL);
	tv = _tmp2_;
	_tmp3_ = tv;
	_tmp4_ = gtk_text_view_get_buffer (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	b = _tmp5_;
	{
		const gchar* _tmp6_;
		GDir* _tmp7_ = NULL;
		GDir* d;
		gchar* file = NULL;
		GtkComboBoxText* _tmp8_;
		GtkTreeModel* _tmp9_ = NULL;
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp6_ = SMD_LOGS_DIR;
		_tmp7_ = g_dir_open (_tmp6_, (guint) 0, &_inner_error_);
		d = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch23_g_file_error;
			}
			_g_object_unref0 (b);
			_g_object_unref0 (tv);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->cblogs;
		_tmp9_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp8_);
		gtk_list_store_clear (GTK_LIST_STORE (_tmp9_));
		_tmp10_ = self->priv->lognames;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
		while (TRUE) {
			GDir* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			GeeArrayList* _tmp15_;
			const gchar* _tmp16_;
			GtkComboBoxText* _tmp17_;
			const gchar* _tmp18_;
			_tmp11_ = d;
			_tmp12_ = g_dir_read_name (_tmp11_);
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (file);
			file = _tmp13_;
			_tmp14_ = file;
			if (!(_tmp14_ != NULL)) {
				break;
			}
			_tmp15_ = self->priv->lognames;
			_tmp16_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
			_tmp17_ = self->priv->cblogs;
			_tmp18_ = file;
			gtk_combo_box_text_append_text (_tmp17_, _tmp18_);
		}
		_tmp19_ = self->priv->lognames;
		_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_ == 0) {
			GtkTextBuffer* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			_tmp22_ = b;
			_tmp23_ = SMD_LOGS_DIR;
			_tmp24_ = g_strdup_printf ("No logs in %s", _tmp23_);
			_tmp25_ = _tmp24_;
			gtk_text_buffer_set_text (_tmp22_, _tmp25_, -1);
			_g_free0 (_tmp25_);
		} else {
			GtkComboBoxText* _tmp26_;
			GtkComboBoxText* _tmp27_;
			_tmp26_ = self->priv->cblogs;
			gtk_combo_box_set_title ((GtkComboBox*) _tmp26_, "Choose log file");
			_tmp27_ = self->priv->cblogs;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp27_, 0);
		}
		_g_free0 (file);
		_g_dir_close0 (d);
	}
	goto __finally23;
	__catch23_g_file_error:
	{
		GError* e = NULL;
		GtkTextBuffer* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = b;
		_tmp29_ = SMD_LOGS_DIR;
		_tmp30_ = g_strdup_printf ("Unable to list directory %s", _tmp29_);
		_tmp31_ = _tmp30_;
		gtk_text_buffer_set_text (_tmp28_, _tmp31_, -1);
		_g_free0 (_tmp31_);
		_g_error_free0 (e);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (b);
		_g_object_unref0 (tv);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (b);
	_g_object_unref0 (tv);
}


static gboolean _smd_applet_eat_event_gsource_func (gpointer self) {
	gboolean result;
	result = smd_applet_eat_event (self);
	return result;
}


static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_prefs_event (self, event);
	return result;
}


static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_err_event (self, event);
	return result;
}


void smd_applet_run (smdApplet* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	gboolean _tmp3_;
	GThread* _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _smd_applet_eat_event_gsource_func, smd_applet_ref (self), smd_applet_unref);
	_tmp0_ = smd_applet_is_smd_stack_configured (self);
	if (_tmp0_) {
		smd_applet_start_smdThread (self, FALSE);
	} else {
		self->priv->config_wait_mode = TRUE;
	}
	_tmp1_ = self->priv->win;
	g_signal_connect ((GtkWidget*) _tmp1_, "delete-event", (GCallback) _smd_applet_close_prefs_event_gtk_widget_delete_event, self);
	_tmp2_ = self->priv->err_win;
	g_signal_connect ((GtkWidget*) _tmp2_, "delete-event", (GCallback) _smd_applet_close_err_event_gtk_widget_delete_event, self);
	_tmp3_ = self->priv->config_wait_mode;
	if (_tmp3_) {
		GtkStatusIcon* _tmp4_;
		GtkStatusIcon* _tmp6_;
		GtkStatusIcon* _tmp7_;
		NotifyNotification* _tmp9_;
		NotifyNotification* _tmp10_;
		GVariant* _tmp11_;
		GVariant* _tmp12_;
		_tmp4_ = self->priv->si;
		gtk_status_icon_set_visible (_tmp4_, FALSE);
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = gtk_events_pending ();
			if (!_tmp5_) {
				break;
			}
			gtk_main_iteration ();
		}
		sleep ((guint) 5);
		_tmp6_ = self->priv->si;
		gtk_status_icon_set_visible (_tmp6_, TRUE);
		_tmp7_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp7_, "error");
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = gtk_events_pending ();
			if (!_tmp8_) {
				break;
			}
			gtk_main_iteration ();
		}
		_tmp9_ = notify_notification_new ("Syncmaildir", "Syncmaildir is not configured properly, " "click on the icon to configure it.", "dialog-warning");
		_g_object_unref0 (self->priv->notification);
		self->priv->notification = _tmp9_;
		_tmp10_ = self->priv->notification;
		_tmp11_ = g_variant_new_boolean (TRUE);
		_tmp12_ = g_variant_ref_sink (_tmp11_);
		notify_notification_set_hint (_tmp10_, "transient", _tmp12_);
		_g_variant_unref0 (_tmp12_);
		{
			NotifyNotification* _tmp13_;
			_tmp13_ = self->priv->notification;
			notify_notification_show (_tmp13_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch24_g_error;
			}
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* e = NULL;
			FILE* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = stderr;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			fprintf (_tmp14_, "%s\n", _tmp16_);
			_g_error_free0 (e);
		}
		__finally24:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		{
			GConfClient* _tmp17_;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
			GtkStatusIcon* _tmp20_;
			_tmp17_ = self->priv->gconf;
			_tmp18_ = gconf_client_get_bool (_tmp17_, SMD_APPLET_key_icon, &_inner_error_);
			_tmp19_ = _tmp18_;
			if (_inner_error_ != NULL) {
				goto __catch25_g_error;
			}
			_tmp20_ = self->priv->si;
			gtk_status_icon_set_visible (_tmp20_, !_tmp19_);
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError* e = NULL;
			FILE* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = stderr;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			fprintf (_tmp21_, "%s\n", _tmp23_);
			_g_error_free0 (e);
		}
		__finally25:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	gtk_main ();
	_tmp24_ = self->priv->thread;
	if (_tmp24_ != NULL) {
		GThread* _tmp25_;
		_tmp25_ = self->priv->thread;
		g_thread_join (_tmp25_);
	}
}


static void _smd_applet_my_gtk_main_quit_button_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_my_gtk_main_quit_button (self, _sender);
}


static gboolean _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = smd_applet_my_gtk_main_quit_event (self, event);
	return result;
}


void smd_applet_configure (smdApplet* self) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	GtkButton* close;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	guint _tmp5_ = 0U;
	GtkWindow* _tmp6_;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "bClosePrefs");
	_tmp2_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp1_) ? ((GtkButton*) _tmp1_) : NULL);
	close = _tmp2_;
	g_signal_connect (close, "clicked", (GCallback) _smd_applet_my_gtk_main_quit_button_gtk_button_clicked, self);
	_tmp3_ = self->priv->win;
	g_signal_connect ((GtkWidget*) _tmp3_, "delete-event", (GCallback) _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event, self);
	_tmp4_ = self->priv->win;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	gtk_main ();
	g_signal_parse_name ("clicked", GTK_TYPE_BUTTON, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (close, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _smd_applet_my_gtk_main_quit_button_gtk_button_clicked, self);
	_tmp6_ = self->priv->win;
	g_signal_parse_name ("delete-event", GTK_TYPE_WIDGET, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event, self);
	_g_object_unref0 (close);
}


static void value_smd_applet_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_smd_applet_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		smd_applet_unref (value->data[0].v_pointer);
	}
}


static void value_smd_applet_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = smd_applet_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_smd_applet_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_smd_applet_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		smdApplet* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = smd_applet_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_smd_applet_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	smdApplet** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = smd_applet_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_smd_applet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecsmdApplet* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SMD_APPLET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_smd_applet (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET), NULL);
	return value->data[0].v_pointer;
}


void value_set_smd_applet (GValue* value, gpointer v_object) {
	smdApplet* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SMD_APPLET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		smd_applet_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		smd_applet_unref (old);
	}
}


void value_take_smd_applet (GValue* value, gpointer v_object) {
	smdApplet* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SMD_APPLET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		smd_applet_unref (old);
	}
}


static void smd_applet_class_init (smdAppletClass * klass) {
	smd_applet_parent_class = g_type_class_peek_parent (klass);
	SMD_APPLET_CLASS (klass)->finalize = smd_applet_finalize;
	g_type_class_add_private (klass, sizeof (smdAppletPrivate));
}


static void smd_applet_instance_init (smdApplet * self) {
	GMutex _tmp0_ = {0};
	self->priv = SMD_APPLET_GET_PRIVATE (self);
	self->priv->builder = NULL;
	self->priv->menuL = NULL;
	self->priv->menuR = NULL;
	self->priv->si = NULL;
	self->priv->win = NULL;
	self->priv->err_win = NULL;
	self->priv->log_win = NULL;
	self->priv->about_win = NULL;
	self->priv->miPause = NULL;
	self->priv->cblogs = NULL;
	self->priv->lognames = NULL;
	self->priv->gconf = NULL;
	self->priv->thread = NULL;
	self->priv->thread_die = FALSE;
	g_mutex_init (&_tmp0_);
	self->priv->events_lock = _tmp0_;
	self->priv->events = NULL;
	self->priv->error_mode = FALSE;
	self->priv->network_error_mode = FALSE;
	self->priv->command_hash = NULL;
	self->priv->net_manager = NULL;
	self->priv->notification = NULL;
	self->priv->notification_server_has_persistence = FALSE;
	self->ref_count = 1;
}


static void smd_applet_finalize (smdApplet* obj) {
	smdApplet * self;
	self = SMD_APPLET (obj);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->menuL);
	_g_object_unref0 (self->priv->menuR);
	_g_object_unref0 (self->priv->si);
	_g_object_unref0 (self->priv->win);
	_g_object_unref0 (self->priv->err_win);
	_g_object_unref0 (self->priv->log_win);
	_g_object_unref0 (self->priv->about_win);
	_g_object_unref0 (self->priv->miPause);
	_g_object_unref0 (self->priv->cblogs);
	_g_object_unref0 (self->priv->lognames);
	_g_object_unref0 (self->priv->gconf);
	_g_thread_unref0 (self->priv->thread);
	g_mutex_clear (&self->priv->events_lock);
	_g_object_unref0 (self->priv->events);
	_g_hash_table_unref0 (self->priv->command_hash);
	_g_object_unref0 (self->priv->net_manager);
	_g_object_unref0 (self->priv->notification);
}


GType smd_applet_get_type (void) {
	static volatile gsize smd_applet_type_id__volatile = 0;
	if (g_once_init_enter (&smd_applet_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_smd_applet_init, value_smd_applet_free_value, value_smd_applet_copy_value, value_smd_applet_peek_pointer, "p", value_smd_applet_collect_value, "p", value_smd_applet_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (smdAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) smd_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (smdApplet), 0, (GInstanceInitFunc) smd_applet_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType smd_applet_type_id;
		smd_applet_type_id = g_type_register_fundamental (g_type_fundamental_next (), "smdApplet", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&smd_applet_type_id__volatile, smd_applet_type_id);
	}
	return smd_applet_type_id__volatile;
}


gpointer smd_applet_ref (gpointer instance) {
	smdApplet* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void smd_applet_unref (gpointer instance) {
	smdApplet* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SMD_APPLET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar* _tmp0_;
	gchar* PREFIX;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gchar* homedir;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gchar* conf_home;
	const gchar* _tmp38_;
	const gchar* _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gboolean config_only;
	GOptionEntry _tmp46_ = {0};
	GOptionEntry _tmp47_ = {0};
	GOptionEntry _tmp48_ = {0};
	GOptionEntry _tmp49_ = {0};
	GOptionEntry* _tmp50_ = NULL;
	GOptionEntry* oe;
	gint oe_length1;
	gint _oe_size_;
	GOptionContext* _tmp51_;
	GOptionContext* oc;
	GOptionContext* _tmp52_;
	GOptionEntry* _tmp53_;
	gint _tmp53__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup (SMD_CONF_PREFIX);
	PREFIX = _tmp0_;
	_tmp1_ = PREFIX;
	_tmp2_ = g_strconcat (_tmp1_, SMD_APPLET_UI, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	_tmp5_ = !_tmp4_;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		FILE* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		FILE* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		FILE* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		FILE* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		FILE* _tmp18_;
		const gchar* _tmp19_;
		_tmp6_ = stderr;
		_tmp7_ = PREFIX;
		fprintf (_tmp6_, "error: file not found: %s + %s\n", _tmp7_, SMD_APPLET_UI);
		_tmp8_ = g_strdup ("./smd-loop");
		_g_free0 (smd_applet_smd_loop_cmd);
		smd_applet_smd_loop_cmd = _tmp8_;
		_tmp9_ = stderr;
		_tmp10_ = smd_applet_smd_loop_cmd;
		fprintf (_tmp9_, "smd-applet not installed, " "assuming smd-loop is: %s\n", _tmp10_);
		_tmp11_ = g_strdup ("./smd-applet.ui");
		_g_free0 (smd_applet_smd_applet_ui);
		smd_applet_smd_applet_ui = _tmp11_;
		_tmp12_ = stderr;
		_tmp13_ = smd_applet_smd_applet_ui;
		fprintf (_tmp12_, "smd-applet not installed, " "assuming smd-applet.ui is: %s\n", _tmp13_);
		_tmp14_ = g_strdup ("./smd-push");
		_g_free0 (smd_applet_smd_push_cmd);
		smd_applet_smd_push_cmd = _tmp14_;
		_tmp15_ = stderr;
		_tmp16_ = smd_applet_smd_push_cmd;
		fprintf (_tmp15_, "smd-applet not installed, " "assuming smd-push is: %s\n", _tmp16_);
		_tmp17_ = g_strdup ("./smd-applet.desktop");
		_g_free0 (smd_applet_smd_applet_desktop);
		smd_applet_smd_applet_desktop = _tmp17_;
		_tmp18_ = stderr;
		_tmp19_ = smd_applet_smd_applet_desktop;
		fprintf (_tmp18_, "smd-applet not installed, " "assuming smd-applet.desktop is: %s\n", _tmp19_);
	} else {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp20_ = PREFIX;
		_tmp21_ = g_strconcat (_tmp20_, SMD_LOOP, NULL);
		_g_free0 (smd_applet_smd_loop_cmd);
		smd_applet_smd_loop_cmd = _tmp21_;
		_tmp22_ = PREFIX;
		_tmp23_ = g_strconcat (_tmp22_, SMD_PUSH, NULL);
		_g_free0 (smd_applet_smd_push_cmd);
		smd_applet_smd_push_cmd = _tmp23_;
		_tmp24_ = PREFIX;
		_tmp25_ = g_strconcat (_tmp24_, SMD_APPLET_UI, NULL);
		_g_free0 (smd_applet_smd_applet_ui);
		smd_applet_smd_applet_ui = _tmp25_;
		_tmp26_ = PREFIX;
		_tmp27_ = g_strconcat (_tmp26_, SMD_APPLET_DESKTOP, NULL);
		_g_free0 (smd_applet_smd_applet_desktop);
		smd_applet_smd_applet_desktop = _tmp27_;
	}
	_tmp28_ = g_get_home_dir ();
	_tmp29_ = g_strdup (_tmp28_);
	homedir = _tmp29_;
	_tmp30_ = homedir;
	_tmp31_ = g_strconcat (_tmp30_, "/.smd/log/", NULL);
	_g_free0 (SMD_LOGS_DIR);
	SMD_LOGS_DIR = _tmp31_;
	_tmp32_ = homedir;
	_tmp33_ = g_strconcat (_tmp32_, "/.smd/loop", NULL);
	_g_free0 (SMD_LOOP_CFG);
	SMD_LOOP_CFG = _tmp33_;
	_tmp34_ = homedir;
	_tmp35_ = g_strconcat (_tmp34_, "/.smd/config.default", NULL);
	_g_free0 (SMD_PP_DEF_CFG);
	SMD_PP_DEF_CFG = _tmp35_;
	_tmp36_ = g_getenv ("XDG_CONFIG_HOME");
	_tmp37_ = g_strdup (_tmp36_);
	conf_home = _tmp37_;
	_tmp38_ = conf_home;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp39_ = conf_home;
		_tmp40_ = g_strconcat (_tmp39_, "/autostart/smd-applet.desktop", NULL);
		_g_free0 (XDG_AUTORUN_FILE);
		XDG_AUTORUN_FILE = _tmp40_;
	} else {
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp41_ = homedir;
		_tmp42_ = g_strconcat (_tmp41_, "/.config/autostart/smd-applet.desktop", NULL);
		_g_free0 (XDG_AUTORUN_FILE);
		XDG_AUTORUN_FILE = _tmp42_;
	}
	_tmp43_ = XDG_AUTORUN_FILE;
	_tmp44_ = g_path_get_dirname (_tmp43_);
	_tmp45_ = _tmp44_;
	g_mkdir_with_parents (_tmp45_, 0700);
	_g_free0 (_tmp45_);
	gtk_init (&args_length1, &args);
	notify_init ("smd-applet");
	config_only = FALSE;
	memset (&_tmp46_, 0, sizeof (GOptionEntry));
	_tmp46_.long_name = "configure";
	_tmp46_.short_name = 'c';
	_tmp46_.flags = 0;
	_tmp46_.arg = G_OPTION_ARG_NONE;
	_tmp46_.arg_data = &config_only;
	_tmp46_.description = "show config window, don't really run the applet";
	_tmp46_.arg_description = NULL;
	memset (&_tmp47_, 0, sizeof (GOptionEntry));
	_tmp47_.long_name = "verbose";
	_tmp47_.short_name = 'v';
	_tmp47_.flags = 0;
	_tmp47_.arg = G_OPTION_ARG_NONE;
	_tmp47_.arg_data = &verbose;
	_tmp47_.description = "verbose output, for debugging only";
	_tmp47_.arg_description = NULL;
	memset (&_tmp48_, 0, sizeof (GOptionEntry));
	_tmp48_.long_name = "smd-loop";
	_tmp48_.short_name = 'l';
	_tmp48_.flags = 0;
	_tmp48_.arg = G_OPTION_ARG_STRING;
	_tmp48_.arg_data = &smd_applet_smd_loop_cmd;
	_tmp48_.description = "override smd-loop command name, debugging only";
	_tmp48_.arg_description = "program";
	memset (&_tmp49_, 0, sizeof (GOptionEntry));
	_tmp49_.long_name = NULL;
	_tmp50_ = g_new0 (GOptionEntry, 4);
	_tmp50_[0] = _tmp46_;
	_tmp50_[1] = _tmp47_;
	_tmp50_[2] = _tmp48_;
	_tmp50_[3] = _tmp49_;
	oe = _tmp50_;
	oe_length1 = 4;
	_oe_size_ = oe_length1;
	_tmp51_ = g_option_context_new (" - syncmaildir applet");
	oc = _tmp51_;
	_tmp52_ = oc;
	_tmp53_ = oe;
	_tmp53__length1 = oe_length1;
	g_option_context_add_main_entries (_tmp52_, _tmp53_, NULL);
	{
		GOptionContext* _tmp54_;
		_tmp54_ = oc;
		g_option_context_parse (_tmp54_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch26_g_option_error;
			}
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (conf_home);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally26;
	__catch26_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp55_;
		GError* _tmp56_;
		const gchar* _tmp57_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp55_ = stderr;
		_tmp56_ = e;
		_tmp57_ = _tmp56_->message;
		fprintf (_tmp55_, "%s\n", _tmp57_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		return result;
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		gboolean _tmp58_;
		smdApplet* _tmp59_;
		smdApplet* smd_applet;
		gboolean _tmp60_;
		_tmp58_ = config_only;
		_tmp59_ = smd_applet_new (_tmp58_, &_inner_error_);
		smd_applet = _tmp59_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				goto __catch27_exit;
			}
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (conf_home);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp60_ = config_only;
		if (_tmp60_) {
			smdApplet* _tmp61_;
			_tmp61_ = smd_applet;
			smd_applet_configure (_tmp61_);
		} else {
			smdApplet* _tmp62_;
			_tmp62_ = smd_applet;
			smd_applet_run (_tmp62_, &_inner_error_);
			if (_inner_error_ != NULL) {
				_smd_applet_unref0 (smd_applet);
				if (_inner_error_->domain == EXIT) {
					goto __catch27_exit;
				}
				_smd_applet_unref0 (smd_applet);
				_g_option_context_free0 (oc);
				oe = (g_free (oe), NULL);
				_g_free0 (conf_home);
				_g_free0 (homedir);
				_g_free0 (PREFIX);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		_smd_applet_unref0 (smd_applet);
	}
	goto __finally27;
	__catch27_exit:
	{
		GError* e = NULL;
		FILE* _tmp63_;
		GError* _tmp64_;
		const gchar* _tmp65_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp63_ = stderr;
		_tmp64_ = e;
		_tmp65_ = _tmp64_->message;
		fprintf (_tmp63_, "abort: %s\n", _tmp65_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		return result;
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (oc);
	oe = (g_free (oe), NULL);
	_g_free0 (conf_home);
	_g_free0 (homedir);
	_g_free0 (PREFIX);
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



