/* smd-applet.c generated by valac 0.10.3, the Vala compiler
 * generated from smd-applet.vala, do not modify */

/* Released under the terms of GPLv3 or at your option any later version.*/
/* No warranties.*/
/* Copyright 2008-2010 Enrico Tassi <gares@fettunta.org>*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <libnotify/notify.h>
#include <sys/wait.h>
#include <smd-config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_NETWORK_MANAGER (network_manager_get_type ())
#define NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NETWORK_MANAGER, NetworkManager))
#define IS_NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NETWORK_MANAGER))
#define NETWORK_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NETWORK_MANAGER, NetworkManagerIface))

typedef struct _NetworkManager NetworkManager;
typedef struct _NetworkManagerIface NetworkManagerIface;

#define TYPE_NETWORK_MANAGER_PROXY (network_manager_proxy_get_type ())
typedef GDBusProxy NetworkManagerProxy;
typedef GDBusProxyClass NetworkManagerProxyClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
typedef struct _EventPrivate EventPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _event_unref0(var) ((var == NULL) ? NULL : (var = (event_unref (var), NULL)))
typedef struct _ParamSpecEvent ParamSpecEvent;

#define TYPE_SMD_APPLET (smd_applet_get_type ())
#define SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SMD_APPLET, smdApplet))
#define SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SMD_APPLET, smdAppletClass))
#define IS_SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SMD_APPLET))
#define IS_SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SMD_APPLET))
#define SMD_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SMD_APPLET, smdAppletClass))

typedef struct _smdApplet smdApplet;
typedef struct _smdAppletClass smdAppletClass;
typedef struct _smdAppletPrivate smdAppletPrivate;
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _smd_applet_unref0(var) ((var == NULL) ? NULL : (var = (smd_applet_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecsmdApplet ParamSpecsmdApplet;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

typedef enum  {
	EXIT_ABORT
} Exit;
#define EXIT exit_quark ()
struct _NetworkManagerIface {
	GTypeInterface parent_iface;
	guint (*get_state) (NetworkManager* self);
};

struct _Event {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EventPrivate * priv;
	char* message;
	char* message_icon;
	gboolean enter_network_error_mode;
	gboolean enter_error_mode;
	gboolean transient_error_message;
	char* context;
	char* cause;
	char* permissions;
	char* mail_name;
	char* mail_body;
	GeeArrayList* commands;
};

struct _EventClass {
	GTypeClass parent_class;
	void (*finalize) (Event *self);
};

struct _ParamSpecEvent {
	GParamSpec parent_instance;
};

struct _smdApplet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	smdAppletPrivate * priv;
};

struct _smdAppletClass {
	GTypeClass parent_class;
	void (*finalize) (smdApplet *self);
};

struct _smdAppletPrivate {
	GtkBuilder* builder;
	GtkMenu* menuL;
	GtkMenu* menuR;
	GtkStatusIcon* si;
	GtkWindow* win;
	GtkWindow* err_win;
	GtkWindow* log_win;
	GtkAboutDialog* about_win;
	GtkCheckMenuItem* miPause;
	GtkComboBox* cblogs;
	GeeArrayList* lognames;
	GConfClient* gconf;
	GThread* thread;
	gboolean thread_die;
	GPid pid;
	GMutex* events_lock;
	GeeArrayList* events;
	gboolean error_mode;
	gboolean network_error_mode;
	gboolean config_wait_mode;
	GHashTable* command_hash;
	NetworkManager* net_manager;
};

struct _ParamSpecsmdApplet {
	GParamSpec parent_instance;
};


extern gboolean verbose;
gboolean verbose = FALSE;
static gpointer event_parent_class = NULL;
extern char* SMD_LOGS_DIR;
char* SMD_LOGS_DIR = NULL;
extern char* SMD_LOOP_CFG;
char* SMD_LOOP_CFG = NULL;
extern char* SMD_PP_DEF_CFG;
char* SMD_PP_DEF_CFG = NULL;
extern char* smd_applet_smd_loop_cmd;
char* smd_applet_smd_loop_cmd = NULL;
extern char* smd_applet_smd_applet_ui;
char* smd_applet_smd_applet_ui = NULL;
extern char* smd_applet_smd_push_cmd;
char* smd_applet_smd_push_cmd = NULL;
static gpointer smd_applet_parent_class = NULL;

GQuark exit_quark (void);
void debug (const char* message);
GType network_manager_get_type (void) G_GNUC_CONST;
GType network_manager_proxy_get_type (void) G_GNUC_CONST;
guint network_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
guint network_manager_get_state (NetworkManager* self);
static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters);
static guint network_manager_dbus_proxy_get_state (NetworkManager* self);
static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface);
static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_network_manager_get_state (NetworkManager* self);
static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data);
static void _network_manager_unregister_object (gpointer user_data);
#define NM_CONNECTED ((guint) 3)
#define NM_SERVICE "org.freedesktop.NetworkManager"
#define NM_PATH "/org/freedesktop/NetworkManager"
gpointer event_ref (gpointer instance);
void event_unref (gpointer instance);
GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_event (GValue* value, gpointer v_object);
void value_take_event (GValue* value, gpointer v_object);
gpointer value_get_event (const GValue* value);
GType event_get_type (void) G_GNUC_CONST;
enum  {
	EVENT_DUMMY_PROPERTY
};
Event* event_error (const char* account, const char* host, const char* context, const char* cause, const char* permissions, const char* mail_name, const char* mail_body, GeeArrayList* commands);
Event* event_new (void);
Event* event_construct (GType object_type);
Event* event_generic_error (const char* cause);
Event* event_network_error (void);
Event* event_stats (const char* account, const char* host, gint new_mails, gint del_mails);
gboolean event_is_error_event (Event* self);
static void event_finalize (Event* obj);
#define SMD_LOOP "/bin/smd-loop"
#define SMD_PUSH "/bin/smd-push"
#define SMD_APPLET_UI "/share/syncmaildir-applet/smd-applet.ui"
gpointer smd_applet_ref (gpointer instance);
void smd_applet_unref (gpointer instance);
GParamSpec* param_spec_smd_applet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_smd_applet (GValue* value, gpointer v_object);
void value_take_smd_applet (GValue* value, gpointer v_object);
gpointer value_get_smd_applet (const GValue* value);
GType smd_applet_get_type (void) G_GNUC_CONST;
#define SMD_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SMD_APPLET, smdAppletPrivate))
enum  {
	SMD_APPLET_DUMMY_PROPERTY
};
#define SMD_APPLET_key_icon "/apps/smd-applet/icon_only_on_errors"
#define SMD_APPLET_key_newmail "/apps/smd-applet/notify_new_mail"
smdApplet* smd_applet_new (gboolean hide_status_icon, GError** error);
smdApplet* smd_applet_construct (GType object_type, gboolean hide_status_icon, GError** error);
static void _lambda0_ (guint s, smdApplet* self);
static void __lambda0__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self);
static void _lambda1_ (GtkComboBox* cb, smdApplet* self);
static void __lambda1__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void smd_applet_close_logs_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_logs_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean smd_applet_close_logs_event (smdApplet* self, GdkEvent* e);
static gboolean _smd_applet_close_logs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void smd_applet_close_prefs_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_prefs_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda3_ (GtkToggleButton* b, smdApplet* self);
static void __lambda3__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda4_ (GtkToggleButton* b, smdApplet* self);
static void __lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void smd_applet_close_err_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda5_ (GtkButton* b, smdApplet* self);
static gboolean smd_applet_is_smd_loop_configured (smdApplet* self);
static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda6_ (GtkButton* b, smdApplet* self);
static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self);
static void __lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda7_ (GtkMenuItem* b, smdApplet* self);
static void __lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda8_ (GtkCheckMenuItem* b, smdApplet* self);
static void smd_applet_pause (smdApplet* self);
static void smd_applet_unpause (smdApplet* self);
static void __lambda8__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void _lambda9_ (gint id, smdApplet* self);
static void __lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _lambda10_ (GtkMenuItem* b, smdApplet* self);
static void __lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda11_ (GtkMenuItem* b, smdApplet* self);
static void __lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda12_ (GtkMenuItem* b, smdApplet* self);
static void smd_applet_update_loglist (smdApplet* self);
static void __lambda12__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda13_ (guint button, guint time, smdApplet* self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void __lambda13__gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void _lambda14_ (GtkStatusIcon* s, smdApplet* self);
static void __lambda14__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void* smd_applet_smdThread (smdApplet* self);
static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error);
static void smd_applet_start_smdThread (smdApplet* self);
static void* _smd_applet_smdThread_gthread_func (gpointer self);
static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const char* args, const char* account, const char* host, GError** error);
static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const char* s);
static void _lambda2_ (smdApplet* self);
static void __lambda2__gspawn_child_setup_func (gpointer self);
static gboolean smd_applet_eat_event (smdApplet* self);
static void _lambda15_ (GtkButton* b, smdApplet* self);
static void __lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void smd_applet_reset_to_regular_run (smdApplet* self);
static gboolean smd_applet_close_err_event (smdApplet* self, GdkEvent* e);
static void smd_applet_close_prefs (smdApplet* self);
static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEvent* e);
static gboolean smd_applet_is_smd_stack_configured (smdApplet* self);
static void smd_applet_close_logs (smdApplet* self);
static void smd_applet_my_gtk_main_quit_button (smdApplet* self, GtkButton* b);
static gboolean smd_applet_my_gtk_main_quit_event (smdApplet* self, GdkEvent* b);
void smd_applet_run (smdApplet* self, GError** error);
static gboolean _smd_applet_eat_event_gsource_func (gpointer self);
static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
void smd_applet_configure (smdApplet* self);
static void _smd_applet_my_gtk_main_quit_button_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void smd_applet_finalize (smdApplet* obj);
gint _vala_main (char** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GDBusMethodInfo * const _network_manager_dbus_method_info[] = {NULL};
static const GDBusArgInfo _network_manager_dbus_arg_info_state_changed_state = {-1, "state", "u"};
static const GDBusArgInfo * const _network_manager_dbus_arg_info_state_changed[] = {&_network_manager_dbus_arg_info_state_changed_state, NULL};
static const GDBusSignalInfo _network_manager_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_network_manager_dbus_arg_info_state_changed)};
static const GDBusSignalInfo * const _network_manager_dbus_signal_info[] = {&_network_manager_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo _network_manager_dbus_property_info_state = {-1, "State", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _network_manager_dbus_property_info[] = {&_network_manager_dbus_property_info_state, NULL};
static const GDBusInterfaceInfo _network_manager_dbus_interface_info = {-1, "org.freedesktop.NetworkManager", (GDBusMethodInfo **) (&_network_manager_dbus_method_info), (GDBusSignalInfo **) (&_network_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_network_manager_dbus_property_info)};
static const GDBusInterfaceVTable _network_manager_dbus_interface_vtable = {network_manager_dbus_interface_method_call, network_manager_dbus_interface_get_property, network_manager_dbus_interface_set_property};


GQuark exit_quark (void) {
	return g_quark_from_static_string ("exit-quark");
}


void debug (const char* message) {
	g_return_if_fail (message != NULL);
	if (verbose) {
		fprintf (stderr, "DEBUG: %s\n", message);
	}
}


guint network_manager_get_state (NetworkManager* self) {
	return NETWORK_MANAGER_GET_INTERFACE (self)->get_state (self);
}


static void network_manager_base_init (NetworkManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("state_changed", TYPE_NETWORK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	}
}


GType network_manager_get_type (void) {
	static volatile gsize network_manager_type_id__volatile = 0;
	if (g_once_init_enter (&network_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetworkManagerIface), (GBaseInitFunc) network_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType network_manager_type_id;
		network_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetworkManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (network_manager_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&network_manager_type_id__volatile, network_manager_type_id);
	}
	return network_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (NetworkManagerProxy, network_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_NETWORK_MANAGER, network_manager_proxy_network_manager_interface_init) );
static void network_manager_proxy_class_init (NetworkManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = network_manager_proxy_g_signal;
}


static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters) {
	guint state = 0U;
	GVariant* _tmp0_;
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	state = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "state-changed", state);
}


static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StateChanged") == 0) {
		_dbus_handle_network_manager_state_changed (proxy, parameters);
	}
}


static void network_manager_proxy_init (NetworkManagerProxy* self) {
}


static guint network_manager_dbus_proxy_get_state (NetworkManager* self) {
	GVariant *_arguments, *_reply, *_inner_reply;
	GVariantBuilder _arguments_builder;
	GVariantIter _reply_iter;
	guint _result;
	GVariant* _tmp1_;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.NetworkManager"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("State"));
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return 0U;
	}
	_inner_reply = g_variant_get_child_value (_reply, 0);
	g_variant_iter_init (&_reply_iter, _inner_reply);
	_tmp1_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp1_);
	g_variant_unref (_tmp1_);
	g_variant_unref (_reply);
	return _result;
}


static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface) {
	iface->get_state = network_manager_dbus_proxy_get_state;
}


static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
}


static GVariant* _dbus_network_manager_get_state (NetworkManager* self) {
	guint result;
	GVariant* _reply;
	result = network_manager_get_state (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "State") == 0) {
		return _dbus_network_manager_get_state (object);
	}
	return NULL;
}


static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (state));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.NetworkManager", "StateChanged", _arguments, NULL);
}


guint network_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, &_network_manager_dbus_interface_info, &_network_manager_dbus_interface_vtable, data, _network_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_network_manager_state_changed, data);
	return result;
}


static void _network_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Event* event_error (const char* account, const char* host, const char* context, const char* cause, const char* permissions, const char* mail_name, const char* mail_body, GeeArrayList* commands) {
	Event* result = NULL;
	Event* e;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	GeeArrayList* _tmp7_;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (cause != NULL, NULL);
	g_return_val_if_fail (commands != NULL, NULL);
	e = event_new ();
	e->message = (_tmp0_ = g_strdup ("An error occurred, click on the icon for more details"), _g_free0 (e->message), _tmp0_);
	e->message_icon = (_tmp1_ = g_strdup ("error"), _g_free0 (e->message_icon), _tmp1_);
	e->enter_error_mode = TRUE;
	e->cause = (_tmp2_ = g_strdup (cause), _g_free0 (e->cause), _tmp2_);
	e->context = (_tmp3_ = g_strdup (context), _g_free0 (e->context), _tmp3_);
	e->permissions = (_tmp4_ = g_strdup (permissions), _g_free0 (e->permissions), _tmp4_);
	e->mail_name = (_tmp5_ = g_strdup (mail_name), _g_free0 (e->mail_name), _tmp5_);
	e->mail_body = (_tmp6_ = g_strdup (mail_body), _g_free0 (e->mail_body), _tmp6_);
	e->commands = (_tmp7_ = _g_object_ref0 (commands), _g_object_unref0 (e->commands), _tmp7_);
	result = e;
	return result;
}


Event* event_generic_error (const char* cause) {
	Event* result = NULL;
	Event* e;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (cause != NULL, NULL);
	e = event_new ();
	e->message = (_tmp0_ = g_strconcat ("A failure occurred: ", cause, NULL), _g_free0 (e->message), _tmp0_);
	e->message_icon = (_tmp1_ = g_strdup ("dialog-warning"), _g_free0 (e->message_icon), _tmp1_);
	e->transient_error_message = TRUE;
	result = e;
	return result;
}


Event* event_network_error (void) {
	Event* result = NULL;
	Event* e;
	char* _tmp0_;
	char* _tmp1_;
	e = event_new ();
	e->message = (_tmp0_ = g_strdup ("A persistent network failure occurred"), _g_free0 (e->message), _tmp0_);
	e->message_icon = (_tmp1_ = g_strdup ("dialog-warning"), _g_free0 (e->message_icon), _tmp1_);
	e->enter_network_error_mode = TRUE;
	result = e;
	return result;
}


Event* event_stats (const char* account, const char* host, gint new_mails, gint del_mails) {
	Event* result = NULL;
	char* preamble;
	Event* e;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	preamble = g_strdup_printf ("Synchronize with %s:\n", account);
	e = event_new ();
	if (new_mails > 0) {
		_tmp0_ = del_mails > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		e->message = (_tmp1_ = g_strdup_printf ("%s%d new messages\n%d deleted messages", preamble, new_mails, del_mails), _g_free0 (e->message), _tmp1_);
	} else {
		if (new_mails > 0) {
			char* _tmp2_;
			e->message = (_tmp2_ = g_strdup_printf ("%s%d new messages", preamble, new_mails), _g_free0 (e->message), _tmp2_);
		} else {
			char* _tmp3_;
			e->message = (_tmp3_ = g_strdup_printf ("%s%d deleted messages", preamble, del_mails), _g_free0 (e->message), _tmp3_);
		}
	}
	result = e;
	_g_free0 (preamble);
	return result;
}


gboolean event_is_error_event (Event* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->enter_error_mode) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->enter_network_error_mode;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->transient_error_message;
	}
	result = _tmp0_;
	return result;
}


Event* event_construct (GType object_type) {
	Event* self = (Event*) g_type_create_instance (object_type);
	return self;
}


Event* event_new (void) {
	return event_construct (TYPE_EVENT);
}


static void value_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		event_unref (value->data[0].v_pointer);
	}
}


static void value_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Event* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Event** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT), NULL);
	return value->data[0].v_pointer;
}


void value_set_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


void value_take_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


static void event_class_init (EventClass * klass) {
	event_parent_class = g_type_class_peek_parent (klass);
	EVENT_CLASS (klass)->finalize = event_finalize;
}


static void event_instance_init (Event * self) {
	self->message = NULL;
	self->message_icon = g_strdup ("gtk-about");
	self->enter_network_error_mode = FALSE;
	self->enter_error_mode = FALSE;
	self->transient_error_message = FALSE;
	self->context = NULL;
	self->cause = NULL;
	self->permissions = NULL;
	self->mail_name = NULL;
	self->mail_body = NULL;
	self->commands = NULL;
	self->ref_count = 1;
}


static void event_finalize (Event* obj) {
	Event * self;
	self = EVENT (obj);
	_g_free0 (self->message);
	_g_free0 (self->message_icon);
	_g_free0 (self->context);
	_g_free0 (self->cause);
	_g_free0 (self->permissions);
	_g_free0 (self->mail_name);
	_g_free0 (self->mail_body);
	_g_object_unref0 (self->commands);
}


GType event_get_type (void) {
	static volatile gsize event_type_id__volatile = 0;
	if (g_once_init_enter (&event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_event_init, value_event_free_value, value_event_copy_value, value_event_peek_pointer, "p", value_event_collect_value, "p", value_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Event), 0, (GInstanceInitFunc) event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType event_type_id;
		event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Event", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&event_type_id__volatile, event_type_id);
	}
	return event_type_id__volatile;
}


gpointer event_ref (gpointer instance) {
	Event* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void event_unref (gpointer instance) {
	Event* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _lambda0_ (guint s, smdApplet* self) {
	if (s == NM_CONNECTED) {
		gtk_check_menu_item_set_active (self->priv->miPause, FALSE);
	} else {
		gtk_check_menu_item_set_active (self->priv->miPause, TRUE);
	}
}


static void __lambda0__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self) {
	_lambda0_ (state, self);
}


static void _lambda1_ (GtkComboBox* cb, smdApplet* self) {
	gint selected;
	GError * _inner_error_ = NULL;
	g_return_if_fail (cb != NULL);
	selected = gtk_combo_box_get_active (self->priv->cblogs);
	if (selected >= 0) {
		char* file;
		char* content;
		file = (char*) gee_abstract_list_get ((GeeAbstractList*) self->priv->lognames, selected);
		content = NULL;
		{
			char* _tmp0_;
			char* _tmp1_ = NULL;
			gboolean _tmp2_;
			char* _tmp3_;
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp5_ = (_tmp4_ = (_tmp2_ = g_file_get_contents (_tmp0_ = g_strconcat (SMD_LOGS_DIR, file, NULL), &_tmp1_, NULL, &_inner_error_), content = (_tmp3_ = _tmp1_, _g_free0 (content), _tmp3_), _tmp2_), _g_free0 (_tmp0_), _tmp4_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch2_g_file_error;
				}
				_g_free0 (content);
				_g_free0 (file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (_tmp5_) {
				GObject* _tmp6_;
				GtkTextView* tv;
				GtkTextBuffer* b;
				GtkTextIter end_iter = {0};
				GtkTextMark* end_mark;
				tv = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (self->priv->builder, "tvLog"), GTK_IS_TEXT_VIEW (_tmp6_) ? ((GtkTextView*) _tmp6_) : NULL));
				b = _g_object_ref0 (gtk_text_view_get_buffer (tv));
				gtk_text_buffer_set_text (b, content, -1);
				gtk_text_buffer_get_end_iter (b, &end_iter);
				end_mark = _g_object_ref0 (gtk_text_buffer_create_mark (b, "end", &end_iter, FALSE));
				gtk_text_view_scroll_to_mark (tv, end_mark, 0.0, TRUE, 0.0, 0.0);
				_g_object_unref0 (end_mark);
				_g_object_unref0 (b);
				_g_object_unref0 (tv);
			} else {
				char* _tmp7_;
				fprintf (stderr, "Unable to read %s\n", _tmp7_ = g_strconcat (SMD_LOGS_DIR, file, NULL));
				_g_free0 (_tmp7_);
			}
		}
		goto __finally2;
		__catch2_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp8_;
				fprintf (stderr, "Unable to read %s: %s\n", _tmp8_ = g_strconcat (SMD_LOGS_DIR, file, NULL), e->message);
				_g_free0 (_tmp8_);
				_g_error_free0 (e);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			_g_free0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (content);
		_g_free0 (file);
	}
}


static void __lambda1__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _smd_applet_close_logs_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_logs_action (self, _sender);
}


static gboolean _smd_applet_close_logs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_logs_event (self, event);
	return result;
}


static void _smd_applet_close_prefs_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_prefs_action (self, _sender);
}


static void _lambda3_ (GtkToggleButton* b, smdApplet* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		gboolean _tmp0_;
		gconf_client_set_bool (self->priv->gconf, SMD_APPLET_key_icon, gtk_toggle_button_get_active (b), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp0_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		gtk_status_icon_set_visible (self->priv->si, !_tmp0_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda3__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _lambda4_ (GtkToggleButton* b, smdApplet* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		gconf_client_set_bool (self->priv->gconf, SMD_APPLET_key_newmail, gtk_toggle_button_get_active (b), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_err_action (self, _sender);
}


static void _lambda5_ (GtkButton* b, smdApplet* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		char* cmd;
		if (!smd_applet_is_smd_loop_configured (self)) {
			char* _tmp0_;
			g_spawn_command_line_sync (_tmp0_ = g_strdup_printf ("%s -t", smd_applet_smd_loop_cmd), NULL, NULL, NULL, &_inner_error_);
			_g_free0 (_tmp0_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch7_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		cmd = g_strdup_printf ("gnome-open %s", SMD_LOOP_CFG);
		g_spawn_command_line_async (cmd, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch7_g_spawn_error;
			}
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		smd_applet_is_smd_loop_configured (self);
		_g_free0 (cmd);
	}
	goto __finally7;
	__catch7_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static void _lambda6_ (GtkButton* b, smdApplet* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		char* cmd;
		if (!smd_applet_is_smd_pushpull_configured (self)) {
			char* _tmp0_;
			g_spawn_command_line_sync (_tmp0_ = g_strdup_printf ("%s -t", smd_applet_smd_push_cmd), NULL, NULL, NULL, &_inner_error_);
			_g_free0 (_tmp0_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch8_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		cmd = g_strdup_printf ("gnome-open %s", SMD_PP_DEF_CFG);
		g_spawn_command_line_async (cmd, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch8_g_spawn_error;
			}
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		smd_applet_is_smd_pushpull_configured (self);
		_g_free0 (cmd);
	}
	goto __finally8;
	__catch8_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static void _lambda7_ (GtkMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	self->priv->thread_die = TRUE;
	if (((gint) self->priv->pid) != 0) {
		char* _tmp0_;
		debug (_tmp0_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) self->priv->pid)));
		_g_free0 (_tmp0_);
		kill ((pid_t) (-((gint) self->priv->pid)), SIGTERM);
	}
	gtk_main_quit ();
}


static void __lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static void _lambda8_ (GtkCheckMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	if (gtk_check_menu_item_get_active (self->priv->miPause)) {
		smd_applet_pause (self);
	} else {
		smd_applet_unpause (self);
	}
}


static void __lambda8__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda8_ (_sender, self);
}


static void _lambda9_ (gint id, smdApplet* self) {
	gtk_widget_hide ((GtkWidget*) self->priv->about_win);
}


static void __lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda9_ (response_id, self);
}


static void _lambda10_ (GtkMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	gtk_dialog_run ((GtkDialog*) self->priv->about_win);
}


static void __lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda10_ (_sender, self);
}


static void _lambda11_ (GtkMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	gtk_widget_show ((GtkWidget*) self->priv->win);
}


static void __lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda11_ (_sender, self);
}


static void _lambda12_ (GtkMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	smd_applet_update_loglist (self);
	gtk_widget_show ((GtkWidget*) self->priv->log_win);
}


static void __lambda12__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda12_ (_sender, self);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void _lambda13_ (guint button, guint time, smdApplet* self) {
	gtk_menu_popup (self->priv->menuR, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, self->priv->si, (guint) 0, gtk_get_current_event_time ());
}


static void __lambda13__gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	_lambda13_ (button, activate_time, self);
}


static void _lambda14_ (GtkStatusIcon* s, smdApplet* self) {
	g_return_if_fail (s != NULL);
	if (self->priv->error_mode) {
		gtk_window_reshow_with_initial_size (self->priv->err_win);
	} else {
		if (self->priv->config_wait_mode) {
			gtk_widget_show ((GtkWidget*) self->priv->win);
		} else {
			gtk_menu_popup (self->priv->menuL, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, self->priv->si, (guint) 0, gtk_get_current_event_time ());
		}
	}
}


static void __lambda14__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	_lambda14_ (_sender, self);
}


smdApplet* smd_applet_construct (GType object_type, gboolean hide_status_icon, GError** error) {
	smdApplet* self = (smdApplet*) g_type_create_instance (object_type);
	GtkBuilder* _tmp0_;
	GeeArrayList* _tmp1_;
	GMutex* _tmp2_;
	GConfClient* _tmp3_;
	GObject* _tmp7_;
	GtkWindow* _tmp8_;
	GObject* _tmp9_;
	GtkWindow* _tmp10_;
	GObject* _tmp11_;
	GtkAboutDialog* _tmp12_;
	GObject* _tmp13_;
	GtkWindow* _tmp14_;
	GObject* _tmp15_;
	GtkVBox* logs_vb;
	GtkComboBox* _tmp16_;
	GeeArrayList* _tmp17_;
	GObject* _tmp18_;
	GtkButton* close_log;
	GObject* _tmp19_;
	GtkButton* close;
	GObject* _tmp20_;
	GtkCheckButton* bicon;
	GObject* _tmp22_;
	GtkCheckButton* bnotify;
	GObject* _tmp24_;
	GtkButton* bc;
	GObject* _tmp25_;
	GtkButton* bel;
	GObject* _tmp26_;
	GtkButton* bepp;
	GObject* _tmp27_;
	GtkMenu* _tmp28_;
	GObject* _tmp29_;
	GtkMenu* _tmp30_;
	GObject* _tmp31_;
	GtkMenuItem* quit;
	GObject* _tmp32_;
	GtkCheckMenuItem* _tmp33_;
	GObject* _tmp34_;
	GtkMenuItem* about;
	GObject* _tmp35_;
	GtkMenuItem* prefs;
	GObject* _tmp36_;
	GtkMenuItem* logs;
	GtkStatusIcon* _tmp37_;
	GHashTable* _tmp38_;
	GError * _inner_error_ = NULL;
	self->priv->builder = (_tmp0_ = gtk_builder_new (), _g_object_unref0 (self->priv->builder), _tmp0_);
	{
		gtk_builder_add_from_file (self->priv->builder, smd_applet_smd_applet_ui, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			_inner_error_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to load the ui file");
			{
				_g_error_free0 (e);
				goto __finally0;
			}
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->events = (_tmp1_ = gee_array_list_new (TYPE_EVENT, (GBoxedCopyFunc) event_ref, event_unref, NULL), _g_object_unref0 (self->priv->events), _tmp1_);
	self->priv->events_lock = (_tmp2_ = g_mutex_new (), _g_mutex_free0 (self->priv->events_lock), _tmp2_);
	self->priv->gconf = (_tmp3_ = _g_object_ref0 (gconf_client_get_default ()), _g_object_unref0 (self->priv->gconf), _tmp3_);
	{
		NetworkManager* _tmp4_;
		NetworkManager* _tmp5_;
		_tmp4_ = (NetworkManager*) g_initable_new (TYPE_NETWORK_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", NM_SERVICE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", NM_PATH, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		self->priv->net_manager = (_tmp5_ = _tmp4_, _g_object_unref0 (self->priv->net_manager), _tmp5_);
		g_signal_connect (self->priv->net_manager, "state-changed", (GCallback) __lambda0__network_manager_state_changed, self);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			NetworkManager* _tmp6_;
			fprintf (stderr, "%s\n", e->message);
			self->priv->net_manager = (_tmp6_ = NULL, _g_object_unref0 (self->priv->net_manager), _tmp6_);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->win = (_tmp8_ = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (self->priv->builder, "wPrefs"), GTK_IS_WINDOW (_tmp7_) ? ((GtkWindow*) _tmp7_) : NULL)), _g_object_unref0 (self->priv->win), _tmp8_);
	self->priv->err_win = (_tmp10_ = _g_object_ref0 ((_tmp9_ = gtk_builder_get_object (self->priv->builder, "wError"), GTK_IS_WINDOW (_tmp9_) ? ((GtkWindow*) _tmp9_) : NULL)), _g_object_unref0 (self->priv->err_win), _tmp10_);
	self->priv->about_win = (_tmp12_ = _g_object_ref0 ((_tmp11_ = gtk_builder_get_object (self->priv->builder, "wAbout"), GTK_IS_ABOUT_DIALOG (_tmp11_) ? ((GtkAboutDialog*) _tmp11_) : NULL)), _g_object_unref0 (self->priv->about_win), _tmp12_);
	self->priv->log_win = (_tmp14_ = _g_object_ref0 ((_tmp13_ = gtk_builder_get_object (self->priv->builder, "wLog"), GTK_IS_WINDOW (_tmp13_) ? ((GtkWindow*) _tmp13_) : NULL)), _g_object_unref0 (self->priv->log_win), _tmp14_);
	logs_vb = _g_object_ref0 ((_tmp15_ = gtk_builder_get_object (self->priv->builder, "vbLog"), GTK_IS_VBOX (_tmp15_) ? ((GtkVBox*) _tmp15_) : NULL));
	self->priv->cblogs = (_tmp16_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->priv->cblogs), _tmp16_);
	self->priv->lognames = (_tmp17_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (self->priv->lognames), _tmp17_);
	gtk_box_pack_start ((GtkBox*) logs_vb, (GtkWidget*) self->priv->cblogs, FALSE, TRUE, (guint) 0);
	gtk_box_reorder_child ((GtkBox*) logs_vb, (GtkWidget*) self->priv->cblogs, 0);
	gtk_widget_show ((GtkWidget*) self->priv->cblogs);
	g_signal_connect (self->priv->cblogs, "changed", (GCallback) __lambda1__gtk_combo_box_changed, self);
	close_log = _g_object_ref0 ((_tmp18_ = gtk_builder_get_object (self->priv->builder, "bLogClose"), GTK_IS_BUTTON (_tmp18_) ? ((GtkButton*) _tmp18_) : NULL));
	g_signal_connect (close_log, "clicked", (GCallback) _smd_applet_close_logs_action_gtk_button_clicked, self);
	g_signal_connect ((GtkWidget*) self->priv->log_win, "delete-event", (GCallback) _smd_applet_close_logs_event_gtk_widget_delete_event, self);
	close = _g_object_ref0 ((_tmp19_ = gtk_builder_get_object (self->priv->builder, "bClosePrefs"), GTK_IS_BUTTON (_tmp19_) ? ((GtkButton*) _tmp19_) : NULL));
	g_signal_connect (close, "clicked", (GCallback) _smd_applet_close_prefs_action_gtk_button_clicked, self);
	bicon = _g_object_ref0 ((_tmp20_ = gtk_builder_get_object (self->priv->builder, "cbIcon"), GTK_IS_CHECK_BUTTON (_tmp20_) ? ((GtkCheckButton*) _tmp20_) : NULL));
	{
		gboolean _tmp21_;
		_tmp21_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		gtk_toggle_button_set_active ((GtkToggleButton*) bicon, _tmp21_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect ((GtkToggleButton*) bicon, "toggled", (GCallback) __lambda3__gtk_toggle_button_toggled, self);
	bnotify = _g_object_ref0 ((_tmp22_ = gtk_builder_get_object (self->priv->builder, "cbNotify"), GTK_IS_CHECK_BUTTON (_tmp22_) ? ((GtkCheckButton*) _tmp22_) : NULL));
	{
		gboolean _tmp23_;
		_tmp23_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_newmail, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		gtk_toggle_button_set_active ((GtkToggleButton*) bnotify, _tmp23_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect ((GtkToggleButton*) bnotify, "toggled", (GCallback) __lambda4__gtk_toggle_button_toggled, self);
	bc = _g_object_ref0 ((_tmp24_ = gtk_builder_get_object (self->priv->builder, "bClose"), GTK_IS_BUTTON (_tmp24_) ? ((GtkButton*) _tmp24_) : NULL));
	g_signal_connect (bc, "clicked", (GCallback) _smd_applet_close_err_action_gtk_button_clicked, self);
	bel = _g_object_ref0 ((_tmp25_ = gtk_builder_get_object (self->priv->builder, "bEditLoopCfg"), GTK_IS_BUTTON (_tmp25_) ? ((GtkButton*) _tmp25_) : NULL));
	g_signal_connect (bel, "clicked", (GCallback) __lambda5__gtk_button_clicked, self);
	bepp = _g_object_ref0 ((_tmp26_ = gtk_builder_get_object (self->priv->builder, "bEditPushPullCfg"), GTK_IS_BUTTON (_tmp26_) ? ((GtkButton*) _tmp26_) : NULL));
	g_signal_connect (bepp, "clicked", (GCallback) __lambda6__gtk_button_clicked, self);
	self->priv->menuL = (_tmp28_ = _g_object_ref0 ((_tmp27_ = gtk_builder_get_object (self->priv->builder, "mLeft"), GTK_IS_MENU (_tmp27_) ? ((GtkMenu*) _tmp27_) : NULL)), _g_object_unref0 (self->priv->menuL), _tmp28_);
	self->priv->menuR = (_tmp30_ = _g_object_ref0 ((_tmp29_ = gtk_builder_get_object (self->priv->builder, "mRight"), GTK_IS_MENU (_tmp29_) ? ((GtkMenu*) _tmp29_) : NULL)), _g_object_unref0 (self->priv->menuR), _tmp30_);
	quit = _g_object_ref0 ((_tmp31_ = gtk_builder_get_object (self->priv->builder, "miQuit"), GTK_IS_MENU_ITEM (_tmp31_) ? ((GtkMenuItem*) _tmp31_) : NULL));
	g_signal_connect (quit, "activate", (GCallback) __lambda7__gtk_menu_item_activate, self);
	self->priv->miPause = (_tmp33_ = _g_object_ref0 ((_tmp32_ = gtk_builder_get_object (self->priv->builder, "miPause"), GTK_IS_CHECK_MENU_ITEM (_tmp32_) ? ((GtkCheckMenuItem*) _tmp32_) : NULL)), _g_object_unref0 (self->priv->miPause), _tmp33_);
	g_signal_connect (self->priv->miPause, "toggled", (GCallback) __lambda8__gtk_check_menu_item_toggled, self);
	about = _g_object_ref0 ((_tmp34_ = gtk_builder_get_object (self->priv->builder, "miAbout"), GTK_IS_MENU_ITEM (_tmp34_) ? ((GtkMenuItem*) _tmp34_) : NULL));
	g_signal_connect ((GtkDialog*) self->priv->about_win, "response", (GCallback) __lambda9__gtk_dialog_response, self);
	g_signal_connect (about, "activate", (GCallback) __lambda10__gtk_menu_item_activate, self);
	gtk_about_dialog_set_comments (self->priv->about_win, "GNOME applet for syncmaildir version " SMD_CONF_VERSION);
	prefs = _g_object_ref0 ((_tmp35_ = gtk_builder_get_object (self->priv->builder, "miPrefs"), GTK_IS_MENU_ITEM (_tmp35_) ? ((GtkMenuItem*) _tmp35_) : NULL));
	g_signal_connect (prefs, "activate", (GCallback) __lambda11__gtk_menu_item_activate, self);
	logs = _g_object_ref0 ((_tmp36_ = gtk_builder_get_object (self->priv->builder, "miLog"), GTK_IS_MENU_ITEM (_tmp36_) ? ((GtkMenuItem*) _tmp36_) : NULL));
	g_signal_connect (logs, "activate", (GCallback) __lambda12__gtk_menu_item_activate, self);
	self->priv->si = (_tmp37_ = gtk_status_icon_new_from_icon_name ("mail-send-receive"), _g_object_unref0 (self->priv->si), _tmp37_);
	gtk_status_icon_set_visible (self->priv->si, !hide_status_icon);
	gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet is running");
	g_signal_connect (self->priv->si, "popup-menu", (GCallback) __lambda13__gtk_status_icon_popup_menu, self);
	g_signal_connect (self->priv->si, "activate", (GCallback) __lambda14__gtk_status_icon_activate, self);
	self->priv->command_hash = (_tmp38_ = g_hash_table_new_full (g_direct_hash, g_str_equal, g_object_unref, g_free), _g_hash_table_unref0 (self->priv->command_hash), _tmp38_);
	_g_object_unref0 (logs);
	_g_object_unref0 (prefs);
	_g_object_unref0 (about);
	_g_object_unref0 (quit);
	_g_object_unref0 (bepp);
	_g_object_unref0 (bel);
	_g_object_unref0 (bc);
	_g_object_unref0 (bnotify);
	_g_object_unref0 (bicon);
	_g_object_unref0 (close);
	_g_object_unref0 (close_log);
	_g_object_unref0 (logs_vb);
	return self;
}


smdApplet* smd_applet_new (gboolean hide_status_icon, GError** error) {
	return smd_applet_construct (TYPE_SMD_APPLET, hide_status_icon, error);
}


static void* smd_applet_smdThread (smdApplet* self) {
	void* result = NULL;
	gboolean rc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rc = TRUE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (rc) {
			_tmp0_ = !self->priv->thread_die;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		debug ("(re)starting smd-loop");
		{
			gboolean _tmp1_;
			_tmp1_ = smd_applet_run_smd_loop (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == EXIT) {
					goto __catch9_exit;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			rc = _tmp1_;
		}
		goto __finally9;
		__catch9_exit:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				rc = FALSE;
				_g_error_free0 (e);
			}
		}
		__finally9:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = NULL;
	return result;
}


static void* _smd_applet_smdThread_gthread_func (gpointer self) {
	void* result;
	result = smd_applet_smdThread (self);
	return result;
}


static void smd_applet_start_smdThread (smdApplet* self) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->net_manager != NULL) {
		_tmp0_ = network_manager_get_state (self->priv->net_manager) != NM_CONNECTED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_check_menu_item_set_active (self->priv->miPause, TRUE);
	} else {
		{
			GThread* _tmp1_;
			_tmp1_ = g_thread_create (_smd_applet_smdThread_gthread_func, self, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_THREAD_ERROR) {
					goto __catch10_g_thread_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			self->priv->thread = _tmp1_;
		}
		goto __finally10;
		__catch10_g_thread_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, "Unable to start a thread\n");
				gtk_main_quit ();
				_g_error_free0 (e);
			}
		}
		__finally10:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const char* args, const char* account, const char* host, GError** error) {
	gboolean result = FALSE;
	GRegex* context;
	GRegex* cause;
	GRegex* human;
	GRegex* actions;
	GMatchInfo* i_ctx;
	GMatchInfo* i_cause;
	GMatchInfo* i_human;
	GMatchInfo* i_act;
	GMatchInfo* _tmp0_ = NULL;
	gboolean _tmp1_;
	GMatchInfo* _tmp2_;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	GMatchInfo* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	GMatchInfo* _tmp8_;
	GMatchInfo* _tmp9_ = NULL;
	gboolean _tmp10_;
	GMatchInfo* _tmp11_;
	gboolean has_actions;
	gboolean _tmp12_ = FALSE;
	char* _tmp13_;
	gboolean _tmp14_;
	char* _tmp17_;
	gboolean _tmp18_;
	char* permissions;
	char* mail_name;
	char* mail_body;
	GeeArrayList* commands;
	char* _tmp46_;
	char* _tmp47_;
	Event* _tmp48_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	g_return_val_if_fail (account != NULL, FALSE);
	g_return_val_if_fail (host != NULL, FALSE);
	context = g_regex_new ("context\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	cause = g_regex_new ("probable-cause\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	human = g_regex_new ("human-intervention\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	actions = g_regex_new ("suggested-actions\\((.*)\\) *$", 0, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	i_ctx = NULL;
	i_cause = NULL;
	i_human = NULL;
	i_act = NULL;
	if (!(_tmp1_ = g_regex_match (context, args, 0, &_tmp0_), i_ctx = (_tmp2_ = _tmp0_, _g_match_info_free0 (i_ctx), _tmp2_), _tmp1_)) {
		fprintf (stderr, "smd-loop error with no context: %s\n", args);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	if (!(_tmp4_ = g_regex_match (cause, args, 0, &_tmp3_), i_cause = (_tmp5_ = _tmp3_, _g_match_info_free0 (i_cause), _tmp5_), _tmp4_)) {
		fprintf (stderr, "smd-loop error with no cause: %s\n", args);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	if (!(_tmp7_ = g_regex_match (human, args, 0, &_tmp6_), i_human = (_tmp8_ = _tmp6_, _g_match_info_free0 (i_human), _tmp8_), _tmp7_)) {
		fprintf (stderr, "smd-loop error with no human: %s\n", args);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	has_actions = (_tmp10_ = g_regex_match (actions, args, 0, &_tmp9_), i_act = (_tmp11_ = _tmp9_, _g_match_info_free0 (i_act), _tmp11_), _tmp10_);
	if ((_tmp14_ = _vala_strcmp0 (_tmp13_ = g_match_info_fetch (i_human, 1), "necessary") != 0, _g_free0 (_tmp13_), _tmp14_)) {
		char* _tmp15_;
		_tmp12_ = _vala_strcmp0 (_tmp15_ = g_match_info_fetch (i_cause, 1), "network") == 0;
		_g_free0 (_tmp15_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		Event* _tmp16_;
		g_mutex_lock (self->priv->events_lock);
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->events, gee_collection_get_size ((GeeCollection*) self->priv->events), _tmp16_ = event_network_error ());
		_event_unref0 (_tmp16_);
		g_mutex_unlock (self->priv->events_lock);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	if ((_tmp18_ = _vala_strcmp0 (_tmp17_ = g_match_info_fetch (i_human, 1), "necessary") != 0, _g_free0 (_tmp17_), _tmp18_)) {
		char* _tmp19_;
		Event* _tmp20_;
		fprintf (stderr, "smd-loop giving an avoidable error: %s\n", args);
		g_mutex_lock (self->priv->events_lock);
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->events, gee_collection_get_size ((GeeCollection*) self->priv->events), _tmp20_ = event_generic_error (_tmp19_ = g_match_info_fetch (i_cause, 1)));
		_event_unref0 (_tmp20_);
		_g_free0 (_tmp19_);
		g_mutex_unlock (self->priv->events_lock);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	permissions = NULL;
	mail_name = NULL;
	mail_body = NULL;
	commands = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	if (has_actions) {
		char* acts;
		GRegex* r_perm;
		GRegex* r_mail;
		GRegex* r_cmd;
		gint from;
		acts = g_match_info_fetch (i_act, 1);
		r_perm = g_regex_new ("display-permissions\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		r_mail = g_regex_new ("display-mail\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		r_cmd = g_regex_new ("run\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		from = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gboolean _tmp22_ = FALSE;
				GMatchInfo* i_cmd;
				GMatchInfo* _tmp23_ = NULL;
				gboolean _tmp24_;
				GMatchInfo* _tmp25_;
				char* _tmp45_;
				if (!_tmp21_) {
				}
				_tmp21_ = FALSE;
				if (acts != NULL) {
					_tmp22_ = string_get_length (acts) > 0;
				} else {
					_tmp22_ = FALSE;
				}
				if (!_tmp22_) {
					break;
				}
				i_cmd = NULL;
				if ((_tmp24_ = g_regex_match (r_perm, acts, 0, &_tmp23_), i_cmd = (_tmp25_ = _tmp23_, _g_match_info_free0 (i_cmd), _tmp25_), _tmp24_)) {
					char* file;
					char* output;
					char* err;
					g_match_info_fetch_pos (i_cmd, 0, NULL, &from);
					file = g_match_info_fetch (i_cmd, 1);
					output = NULL;
					err = NULL;
					{
						char* _tmp26_;
						char* _tmp27_ = NULL;
						char* _tmp28_;
						char* _tmp29_ = NULL;
						char* _tmp30_;
						char* _tmp31_;
						(g_spawn_command_line_sync (_tmp26_ = g_strconcat ("ls -ld ", file, NULL), &_tmp27_, &_tmp29_, NULL, &_inner_error_), output = (_tmp28_ = _tmp27_, _g_free0 (output), _tmp28_));
						err = (_tmp30_ = _tmp29_, _g_free0 (err), _tmp30_);
						_g_free0 (_tmp26_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_SPAWN_ERROR) {
								goto __catch11_g_spawn_error;
							}
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						permissions = (_tmp31_ = g_strconcat (output, err, NULL), _g_free0 (permissions), _tmp31_);
					}
					goto __finally11;
					__catch11_g_spawn_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						{
							fprintf (stderr, "Spawning ls: %s\n", e->message);
							_g_error_free0 (e);
						}
					}
					__finally11:
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							return FALSE;
						} else {
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					_g_free0 (err);
					_g_free0 (output);
					_g_free0 (file);
				} else {
					GMatchInfo* _tmp32_ = NULL;
					gboolean _tmp33_;
					GMatchInfo* _tmp34_;
					if ((_tmp33_ = g_regex_match (r_mail, acts, 0, &_tmp32_), i_cmd = (_tmp34_ = _tmp32_, _g_match_info_free0 (i_cmd), _tmp34_), _tmp33_)) {
						char* file;
						char* output;
						char* err;
						g_match_info_fetch_pos (i_cmd, 0, NULL, &from);
						file = g_match_info_fetch (i_cmd, 1);
						output = g_strdup ("");
						err = NULL;
						{
							char* _tmp35_;
							char* _tmp36_;
							char* _tmp37_ = NULL;
							char* _tmp38_;
							char* _tmp39_ = NULL;
							char* _tmp40_;
							char* _tmp41_;
							mail_name = (_tmp35_ = g_strdup (file), _g_free0 (mail_name), _tmp35_);
							(g_spawn_command_line_sync (_tmp36_ = g_strconcat ("cat ", file, NULL), &_tmp37_, &_tmp39_, NULL, &_inner_error_), output = (_tmp38_ = _tmp37_, _g_free0 (output), _tmp38_));
							err = (_tmp40_ = _tmp39_, _g_free0 (err), _tmp40_);
							_g_free0 (_tmp36_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_SPAWN_ERROR) {
									goto __catch12_g_spawn_error;
								}
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_free0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_free0 (i_act);
								_g_match_info_free0 (i_human);
								_g_match_info_free0 (i_cause);
								_g_match_info_free0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
							mail_body = (_tmp41_ = g_strconcat (output, err, NULL), _g_free0 (mail_body), _tmp41_);
						}
						goto __finally12;
						__catch12_g_spawn_error:
						{
							GError * e;
							e = _inner_error_;
							_inner_error_ = NULL;
							{
								fprintf (stderr, "Spawning ls: %s\n", e->message);
								_g_error_free0 (e);
							}
						}
						__finally12:
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_REGEX_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_free0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_free0 (i_act);
								_g_match_info_free0 (i_human);
								_g_match_info_free0 (i_cause);
								_g_match_info_free0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								return FALSE;
							} else {
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_free0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_free0 (i_act);
								_g_match_info_free0 (i_human);
								_g_match_info_free0 (i_cause);
								_g_match_info_free0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_g_free0 (err);
						_g_free0 (output);
						_g_free0 (file);
					} else {
						GMatchInfo* _tmp42_ = NULL;
						gboolean _tmp43_;
						GMatchInfo* _tmp44_;
						if ((_tmp43_ = g_regex_match (r_cmd, acts, 0, &_tmp42_), i_cmd = (_tmp44_ = _tmp42_, _g_match_info_free0 (i_cmd), _tmp44_), _tmp43_)) {
							char* command;
							command = g_match_info_fetch (i_cmd, 1);
							g_match_info_fetch_pos (i_cmd, 0, NULL, &from);
							gee_abstract_list_insert ((GeeAbstractList*) commands, gee_collection_get_size ((GeeCollection*) commands), command);
							_g_free0 (command);
						} else {
							fprintf (stderr, "Unrecognized action: %s\n", acts);
							_g_match_info_free0 (i_cmd);
							break;
						}
					}
				}
				acts = (_tmp45_ = string_substring (acts, (glong) from, -1), _g_free0 (acts), _tmp45_);
				_g_match_info_free0 (i_cmd);
			}
		}
		_g_regex_unref0 (r_cmd);
		_g_regex_unref0 (r_mail);
		_g_regex_unref0 (r_perm);
		_g_free0 (acts);
	}
	g_mutex_lock (self->priv->events_lock);
	gee_abstract_list_insert ((GeeAbstractList*) self->priv->events, gee_collection_get_size ((GeeCollection*) self->priv->events), _tmp48_ = event_error (account, host, _tmp46_ = g_match_info_fetch (i_ctx, 1), _tmp47_ = g_match_info_fetch (i_cause, 1), permissions, mail_name, mail_body, commands));
	_event_unref0 (_tmp48_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp46_);
	g_mutex_unlock (self->priv->events_lock);
	result = FALSE;
	_g_object_unref0 (commands);
	_g_free0 (mail_body);
	_g_free0 (mail_name);
	_g_free0 (permissions);
	_g_match_info_free0 (i_act);
	_g_match_info_free0 (i_human);
	_g_match_info_free0 (i_cause);
	_g_match_info_free0 (i_ctx);
	_g_regex_unref0 (actions);
	_g_regex_unref0 (human);
	_g_regex_unref0 (cause);
	_g_regex_unref0 (context);
	return result;
}


static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const char* s) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	{
		GMatchInfo* info;
		GRegex* r_tags;
		GRegex* r_skip;
		GMatchInfo* _tmp0_ = NULL;
		gboolean _tmp1_;
		GMatchInfo* _tmp2_;
		char* account;
		char* host;
		char* tags;
		GMatchInfo* i_args;
		GRegex* r_stats;
		GRegex* r_error;
		GMatchInfo* _tmp4_ = NULL;
		gboolean _tmp5_;
		GMatchInfo* _tmp6_;
		info = NULL;
		r_tags = g_regex_new ("^([^:]+): smd-(client|server|loop|push|pull|pushpull)@([^:]+): TAGS:(." \
"*)$", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		r_skip = g_regex_new ("^([^:]+): smd-(client|server)@([^:]+): ERROR", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (g_regex_match (r_skip, s, 0, NULL)) {
			result = TRUE;
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			return result;
		}
		if (!(_tmp1_ = g_regex_match (r_tags, s, 0, &_tmp0_), info = (_tmp2_ = _tmp0_, _g_match_info_free0 (info), _tmp2_), _tmp1_)) {
			char* _tmp3_;
			debug (_tmp3_ = g_strdup_printf ("unhandled smd-loop message: %s", s));
			_g_free0 (_tmp3_);
			result = TRUE;
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			return result;
		}
		account = g_match_info_fetch (info, 1);
		host = g_match_info_fetch (info, 3);
		tags = g_match_info_fetch (info, 4);
		i_args = NULL;
		r_stats = g_regex_new (" stats::(.*)$", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		r_error = g_regex_new (" error::(.*)$", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if ((_tmp5_ = g_regex_match (r_stats, tags, 0, &_tmp4_), i_args = (_tmp6_ = _tmp4_, _g_match_info_free0 (i_args), _tmp6_), _tmp5_)) {
			GRegex* r_neW;
			GRegex* r_del;
			GMatchInfo* i_new;
			GMatchInfo* i_del;
			char* args;
			GMatchInfo* _tmp7_ = NULL;
			gboolean _tmp8_;
			GMatchInfo* _tmp9_;
			gboolean has_new;
			GMatchInfo* _tmp10_ = NULL;
			gboolean _tmp11_;
			GMatchInfo* _tmp12_;
			gboolean has_del;
			gint new_mails;
			gint del_mails;
			gboolean _tmp15_ = FALSE;
			r_neW = g_regex_new ("new-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch13_g_regex_error;
				}
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			r_del = g_regex_new ("del-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_regex_unref0 (r_neW);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch13_g_regex_error;
				}
				_g_regex_unref0 (r_neW);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			i_new = NULL;
			i_del = NULL;
			args = g_match_info_fetch (i_args, 1);
			has_new = (_tmp8_ = g_regex_match (r_neW, args, 0, &_tmp7_), i_new = (_tmp9_ = _tmp7_, _g_match_info_free0 (i_new), _tmp9_), _tmp8_);
			has_del = (_tmp11_ = g_regex_match (r_del, args, 0, &_tmp10_), i_del = (_tmp12_ = _tmp10_, _g_match_info_free0 (i_del), _tmp12_), _tmp11_);
			new_mails = 0;
			if (has_new) {
				char* _tmp13_;
				new_mails = atoi (_tmp13_ = g_match_info_fetch (i_new, 1));
				_g_free0 (_tmp13_);
			}
			del_mails = 0;
			if (has_del) {
				char* _tmp14_;
				del_mails = atoi (_tmp14_ = g_match_info_fetch (i_del, 1));
				_g_free0 (_tmp14_);
			}
			if (_vala_strcmp0 (host, "localhost") == 0) {
				gboolean _tmp16_ = FALSE;
				if (new_mails > 0) {
					_tmp16_ = TRUE;
				} else {
					_tmp16_ = del_mails > 0;
				}
				_tmp15_ = _tmp16_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				Event* _tmp17_;
				g_mutex_lock (self->priv->events_lock);
				gee_abstract_list_insert ((GeeAbstractList*) self->priv->events, gee_collection_get_size ((GeeCollection*) self->priv->events), _tmp17_ = event_stats (account, host, new_mails, del_mails));
				_event_unref0 (_tmp17_);
				g_mutex_unlock (self->priv->events_lock);
			} else {
			}
			result = TRUE;
			_g_free0 (args);
			_g_match_info_free0 (i_del);
			_g_match_info_free0 (i_new);
			_g_regex_unref0 (r_del);
			_g_regex_unref0 (r_neW);
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			return result;
		} else {
			GMatchInfo* _tmp18_ = NULL;
			gboolean _tmp19_;
			GMatchInfo* _tmp20_;
			if ((_tmp19_ = g_regex_match (r_error, tags, 0, &_tmp18_), i_args = (_tmp20_ = _tmp18_, _g_match_info_free0 (i_args), _tmp20_), _tmp19_)) {
				char* args;
				gboolean _tmp21_;
				args = g_match_info_fetch (i_args, 1);
				_tmp21_ = smd_applet_eval_smd_loop_error_message (self, args, account, host, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (args);
					_g_regex_unref0 (r_error);
					_g_regex_unref0 (r_stats);
					_g_match_info_free0 (i_args);
					_g_free0 (tags);
					_g_free0 (host);
					_g_free0 (account);
					_g_regex_unref0 (r_skip);
					_g_regex_unref0 (r_tags);
					_g_match_info_free0 (info);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch13_g_regex_error;
					}
					_g_free0 (args);
					_g_regex_unref0 (r_error);
					_g_regex_unref0 (r_stats);
					_g_match_info_free0 (i_args);
					_g_free0 (tags);
					_g_free0 (host);
					_g_free0 (account);
					_g_regex_unref0 (r_skip);
					_g_regex_unref0 (r_tags);
					_g_match_info_free0 (info);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				result = _tmp21_;
				_g_free0 (args);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				return result;
			} else {
				fprintf (stderr, "unhandled smd-loop message: %s\n", s);
				result = TRUE;
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				return result;
			}
		}
		_g_regex_unref0 (r_error);
		_g_regex_unref0 (r_stats);
		_g_match_info_free0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void _lambda2_ (smdApplet* self) {
	setpgid ((pid_t) 0, (pid_t) 0);
}


static void __lambda2__gspawn_child_setup_func (gpointer self) {
	_lambda2_ (self);
}


static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error) {
	gboolean result = FALSE;
	gint cmd_length1;
	gint _cmd_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** cmd;
	gint child_in = 0;
	gint child_out = 0;
	gint child_err = 0;
	gint buff_length1;
	gint _buff_size_;
	gchar* _tmp2_;
	gchar* buff;
	GSpawnFlags flags;
	gboolean rc = FALSE;
	char* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	cmd = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup (smd_applet_smd_loop_cmd), _tmp0_[1] = g_strdup ("-v"), _tmp0_), cmd_length1 = 2, _cmd_size_ = cmd_length1, _tmp1_);
	buff = (_tmp2_ = g_new0 (gchar, 10240), buff_length1 = 10240, _buff_size_ = buff_length1, _tmp2_);
	flags = 0;
	debug (_tmp3_ = g_strdup_printf ("spawning %s\n", smd_applet_smd_loop_cmd));
	_g_free0 (_tmp3_);
	{
		gboolean _tmp4_;
		_tmp4_ = g_spawn_async_with_pipes (NULL, cmd, NULL, flags, __lambda2__gspawn_child_setup_func, self, &self->priv->pid, &child_in, &child_out, &child_err, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		rc = _tmp4_;
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			fprintf (stderr, "%s", _tmp8_ = g_strconcat (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat ("Unable to execute ", smd_applet_smd_loop_cmd, NULL), ": ", NULL), e->message, NULL), "\n", NULL));
			_g_free0 (_tmp8_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp5_);
			_inner_error_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
			{
				_g_error_free0 (e);
				buff = (g_free (buff), NULL);
				cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
				goto __finally14;
			}
			_g_error_free0 (e);
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (rc) {
		FILE* input;
		char* s;
		gboolean goon;
		input = fdopen (child_out, "r");
		s = NULL;
		goon = TRUE;
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			char* _tmp12_;
			char* _tmp13_;
			if (goon) {
				char* _tmp11_;
				_tmp10_ = (s = (_tmp11_ = g_strdup (fgets (buff, buff_length1, input)), _g_free0 (s), _tmp11_)) != NULL;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				_tmp9_ = !self->priv->thread_die;
			} else {
				_tmp9_ = FALSE;
			}
			if (!_tmp9_) {
				break;
			}
			debug (_tmp12_ = g_strdup_printf ("smd-loop outputs: %s", s));
			_g_free0 (_tmp12_);
			goon = smd_applet_eval_smd_loop_message (self, s);
			debug (_tmp13_ = g_strdup_printf ("eval_smd_loop_message returned %d", (gint) goon));
			_g_free0 (_tmp13_);
		}
		if (s != NULL) {
			char* _tmp14_;
			if ((s = (_tmp14_ = g_strdup (fgets (buff, buff_length1, input)), _g_free0 (s), _tmp14_)) != NULL) {
				fprintf (stderr, "smd-loop gave error tag but not died\n");
				fprintf (stderr, "smd-loop has pid %d and prints %s\n", (gint) self->priv->pid, s);
			}
		}
		g_spawn_close_pid (self->priv->pid);
		kill ((pid_t) (-((gint) self->priv->pid)), SIGTERM);
		result = goon;
		_g_free0 (s);
		_fclose0 (input);
		buff = (g_free (buff), NULL);
		cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		char* _tmp15_;
		char* _tmp16_;
		fprintf (stderr, "%s", _tmp16_ = g_strconcat (_tmp15_ = g_strconcat ("Unable to execute ", smd_applet_smd_loop_cmd, NULL), "\n", NULL));
		_g_free0 (_tmp16_);
		_g_free0 (_tmp15_);
		_inner_error_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		{
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				buff = (g_free (buff), NULL);
				cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
				return FALSE;
			} else {
				buff = (g_free (buff), NULL);
				cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	buff = (g_free (buff), NULL);
	cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
}


static void _lambda15_ (GtkButton* b, smdApplet* self) {
	gint cmd_status = 0;
	char* output;
	char* _error_;
	char* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	output = NULL;
	_error_ = NULL;
	debug (_tmp0_ = g_strdup_printf ("executing: %s\n", (const char*) g_hash_table_lookup (self->priv->command_hash, (GtkWidget*) b)));
	_g_free0 (_tmp0_);
	{
		char* _tmp1_ = NULL;
		char* _tmp2_;
		char* _tmp3_ = NULL;
		char* _tmp4_;
		gboolean _tmp5_ = FALSE;
		(g_spawn_command_line_sync ((const char*) g_hash_table_lookup (self->priv->command_hash, (GtkWidget*) b), &_tmp1_, &_tmp3_, &cmd_status, &_inner_error_), output = (_tmp2_ = _tmp1_, _g_free0 (output), _tmp2_));
		_error_ = (_tmp4_ = _tmp3_, _g_free0 (_error_), _tmp4_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch18_g_spawn_error;
			}
			_g_free0 (_error_);
			_g_free0 (output);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (WIFEXITED (cmd_status)) {
			_tmp5_ = 0 == WEXITSTATUS (cmd_status);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gtk_widget_set_sensitive ((GtkWidget*) b, FALSE);
		} else {
			GtkMessageDialog* w;
			w = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->err_win, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "An error occurred:\n%s\n%s", output, _error_));
			gtk_dialog_run ((GtkDialog*) w);
			gtk_object_destroy ((GtkObject*) w);
			_g_object_unref0 (w);
		}
	}
	goto __finally18;
	__catch18_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Spawning: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally18:
	if (_inner_error_ != NULL) {
		_g_free0 (_error_);
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (_error_);
	_g_free0 (output);
}


static void __lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda15_ (_sender, self);
}


static gboolean smd_applet_eat_event (smdApplet* self) {
	gboolean result = FALSE;
	Event* e;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	e = NULL;
	if (self->priv->error_mode) {
		result = TRUE;
		_event_unref0 (e);
		return result;
	}
	g_mutex_lock (self->priv->events_lock);
	if (gee_collection_get_size ((GeeCollection*) self->priv->events) > 0) {
		Event* _tmp0_;
		Event* _tmp1_;
		e = (_tmp0_ = (Event*) gee_abstract_list_first ((GeeAbstractList*) self->priv->events), _event_unref0 (e), _tmp0_);
		_tmp1_ = (Event*) gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->events, 0);
		_event_unref0 (_tmp1_);
	}
	g_mutex_unlock (self->priv->events_lock);
	if (e != NULL) {
		_tmp2_ = e->message != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean notify_on_newail;
		gboolean _tmp4_ = FALSE;
		notify_on_newail = FALSE;
		{
			gboolean _tmp3_;
			_tmp3_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_newmail, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch15_g_error;
			}
			notify_on_newail = _tmp3_;
		}
		goto __finally15;
		__catch15_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, "%s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally15:
		if (_inner_error_ != NULL) {
			_event_unref0 (e);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (e->enter_network_error_mode) {
			_tmp4_ = self->priv->network_error_mode;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
		} else {
			gboolean _tmp5_ = FALSE;
			if (event_is_error_event (e)) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = notify_on_newail;
			}
			if (_tmp5_) {
				NotifyNotification* not;
				not = notify_notification_new ("Syncmaildir", e->message, e->message_icon, NULL);
				notify_notification_attach_to_status_icon (not, self->priv->si);
				{
					notify_notification_show (not, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch16_g_error;
					}
				}
				goto __finally16;
				__catch16_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						fprintf (stderr, "%s\n", e->message);
						_g_error_free0 (e);
					}
				}
				__finally16:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (not);
					_event_unref0 (e);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (not);
			}
		}
	}
	if (e != NULL) {
		_tmp6_ = e->enter_error_mode;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GObject* _tmp7_;
		GtkLabel* l_ctx;
		GObject* _tmp8_;
		GtkLabel* l_cause;
		GObject* _tmp9_;
		GtkVBox* vb;
		GObject* _tmp21_;
		GtkWidget* x;
		GObject* _tmp22_;
		GtkWidget* _tmp23_;
		GObject* _tmp24_;
		GtkWidget* _tmp25_;
		gtk_status_icon_set_from_icon_name (self->priv->si, "error");
		gtk_status_icon_set_blinking (self->priv->si, TRUE);
		gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet encountered an error");
		self->priv->error_mode = TRUE;
		l_ctx = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (self->priv->builder, "lContext"), GTK_IS_LABEL (_tmp7_) ? ((GtkLabel*) _tmp7_) : NULL));
		l_cause = _g_object_ref0 ((_tmp8_ = gtk_builder_get_object (self->priv->builder, "lCause"), GTK_IS_LABEL (_tmp8_) ? ((GtkLabel*) _tmp8_) : NULL));
		gtk_label_set_text (l_ctx, e->context);
		gtk_label_set_text (l_cause, e->cause);
		g_hash_table_remove_all (self->priv->command_hash);
		vb = _g_object_ref0 ((_tmp9_ = gtk_builder_get_object (self->priv->builder, "vbRun"), GTK_IS_VBOX (_tmp9_) ? ((GtkVBox*) _tmp9_) : NULL));
		{
			GList* w_collection;
			GList* w_it;
			w_collection = gtk_container_get_children ((GtkContainer*) vb);
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* w;
				w = _g_object_ref0 ((GtkWidget*) w_it->data);
				{
					gtk_container_remove ((GtkContainer*) vb, w);
					_g_object_unref0 (w);
				}
			}
			_g_list_free0 (w_collection);
		}
		if (e->permissions != NULL) {
			GObject* _tmp10_;
			GtkLabel* l;
			l = _g_object_ref0 ((_tmp10_ = gtk_builder_get_object (self->priv->builder, "lPermissions"), GTK_IS_LABEL (_tmp10_) ? ((GtkLabel*) _tmp10_) : NULL));
			gtk_label_set_text (l, e->permissions);
			_g_object_unref0 (l);
		}
		if (e->mail_name != NULL) {
			GObject* _tmp11_;
			GtkEntry* fn;
			GObject* _tmp12_;
			GtkTextView* l;
			GtkTextBuffer* b;
			GtkTextIter it = {0};
			GtkTextIter subj = {0};
			fn = _g_object_ref0 ((_tmp11_ = gtk_builder_get_object (self->priv->builder, "eMailName"), GTK_IS_ENTRY (_tmp11_) ? ((GtkEntry*) _tmp11_) : NULL));
			gtk_entry_set_text (fn, e->mail_name);
			l = _g_object_ref0 ((_tmp12_ = gtk_builder_get_object (self->priv->builder, "tvMail"), GTK_IS_TEXT_VIEW (_tmp12_) ? ((GtkTextView*) _tmp12_) : NULL));
			b = _g_object_ref0 (gtk_text_view_get_buffer (l));
			gtk_text_buffer_set_text (b, e->mail_body, -1);
			gtk_text_buffer_get_start_iter (b, &it);
			if (gtk_text_iter_forward_search (&it, "Subject:", GTK_TEXT_SEARCH_TEXT_ONLY, &subj, NULL, NULL)) {
				GtkTextMark* insert;
				insert = _g_object_ref0 (gtk_text_buffer_get_insert (b));
				gtk_text_buffer_select_range (b, &subj, &subj);
				gtk_text_view_scroll_to_mark (l, insert, 0.0, TRUE, 0.0, 0.0);
				_g_object_unref0 (insert);
			}
			_g_object_unref0 (b);
			_g_object_unref0 (l);
			_g_object_unref0 (fn);
		}
		if (e->commands != NULL) {
			{
				GeeIterator* _command_it;
				_command_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) e->commands);
				while (TRUE) {
					char* command;
					GtkHBox* hb;
					char* nice_command;
					GtkLabel* lbl;
					GtkButton* but;
					if (!gee_iterator_next (_command_it)) {
						break;
					}
					command = (char*) gee_iterator_get (_command_it);
					hb = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 10));
					nice_command = NULL;
					{
						GMatchInfo* i_mailto;
						GRegex* mailto_rex;
						GMatchInfo* _tmp13_ = NULL;
						gboolean _tmp14_;
						GMatchInfo* _tmp15_;
						i_mailto = NULL;
						mailto_rex = g_regex_new ("^gnome-open..mailto:", 0, 0, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_match_info_free0 (i_mailto);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch17_g_regex_error;
							}
							_g_match_info_free0 (i_mailto);
							_g_free0 (nice_command);
							_g_object_unref0 (hb);
							_g_free0 (command);
							_g_object_unref0 (_command_it);
							_g_object_unref0 (vb);
							_g_object_unref0 (l_cause);
							_g_object_unref0 (l_ctx);
							_event_unref0 (e);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						if ((_tmp14_ = g_regex_match (mailto_rex, command, 0, &_tmp13_), i_mailto = (_tmp15_ = _tmp13_, _g_match_info_free0 (i_mailto), _tmp15_), _tmp14_)) {
							char* _tmp16_;
							char* _tmp17_;
							char* _tmp18_;
							nice_command = (_tmp18_ = g_strconcat (_tmp17_ = string_substring (_tmp16_ = g_uri_unescape_string (command, NULL), (glong) 12, (glong) 70), "...", NULL), _g_free0 (nice_command), _tmp18_);
							_g_free0 (_tmp17_);
							_g_free0 (_tmp16_);
						} else {
							char* _tmp19_;
							nice_command = (_tmp19_ = g_strdup (command), _g_free0 (nice_command), _tmp19_);
						}
						_g_regex_unref0 (mailto_rex);
						_g_match_info_free0 (i_mailto);
					}
					goto __finally17;
					__catch17_g_regex_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						{
							char* _tmp20_;
							nice_command = (_tmp20_ = g_strdup (command), _g_free0 (nice_command), _tmp20_);
							_g_error_free0 (e);
						}
					}
					__finally17:
					if (_inner_error_ != NULL) {
						_g_free0 (nice_command);
						_g_object_unref0 (hb);
						_g_free0 (command);
						_g_object_unref0 (_command_it);
						_g_object_unref0 (vb);
						_g_object_unref0 (l_cause);
						_g_object_unref0 (l_ctx);
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					lbl = g_object_ref_sink ((GtkLabel*) gtk_label_new (nice_command));
					gtk_misc_set_alignment ((GtkMisc*) lbl, 0.0f, 0.5f);
					but = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock ("gtk-execute"));
					g_hash_table_insert (self->priv->command_hash, _g_object_ref0 ((GtkWidget*) but), g_strdup (command));
					g_signal_connect (but, "clicked", (GCallback) __lambda15__gtk_button_clicked, self);
					gtk_box_pack_end ((GtkBox*) hb, (GtkWidget*) lbl, TRUE, TRUE, (guint) 0);
					gtk_box_pack_end ((GtkBox*) hb, (GtkWidget*) but, FALSE, FALSE, (guint) 0);
					gtk_box_pack_end ((GtkBox*) vb, (GtkWidget*) hb, TRUE, TRUE, (guint) 0);
					gtk_widget_show_all ((GtkWidget*) hb);
					_g_object_unref0 (but);
					_g_object_unref0 (lbl);
					_g_free0 (nice_command);
					_g_object_unref0 (hb);
					_g_free0 (command);
				}
				_g_object_unref0 (_command_it);
			}
		}
		x = _g_object_ref0 ((_tmp21_ = gtk_builder_get_object (self->priv->builder, "fDisplayPermissions"), GTK_IS_WIDGET (_tmp21_) ? ((GtkWidget*) _tmp21_) : NULL));
		gtk_widget_set_visible (x, e->permissions != NULL);
		x = (_tmp23_ = _g_object_ref0 ((_tmp22_ = gtk_builder_get_object (self->priv->builder, "fDisplayMail"), GTK_IS_WIDGET (_tmp22_) ? ((GtkWidget*) _tmp22_) : NULL)), _g_object_unref0 (x), _tmp23_);
		gtk_widget_set_visible (x, e->mail_name != NULL);
		x = (_tmp25_ = _g_object_ref0 ((_tmp24_ = gtk_builder_get_object (self->priv->builder, "fRun"), GTK_IS_WIDGET (_tmp24_) ? ((GtkWidget*) _tmp24_) : NULL)), _g_object_unref0 (x), _tmp25_);
		gtk_widget_set_visible (x, gee_collection_get_size ((GeeCollection*) e->commands) > 0);
		_g_object_unref0 (x);
		_g_object_unref0 (vb);
		_g_object_unref0 (l_cause);
		_g_object_unref0 (l_ctx);
	} else {
		gboolean _tmp26_ = FALSE;
		if (e != NULL) {
			_tmp26_ = e->enter_network_error_mode;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			self->priv->network_error_mode = TRUE;
			gtk_status_icon_set_from_icon_name (self->priv->si, "dialog-warning");
			gtk_status_icon_set_tooltip_text (self->priv->si, "Network error");
		} else {
			if (e != NULL) {
				self->priv->network_error_mode = FALSE;
				gtk_status_icon_set_from_icon_name (self->priv->si, "mail-send-receive");
				gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet is running");
			}
		}
	}
	result = TRUE;
	_event_unref0 (e);
	return result;
}


static void smd_applet_close_err_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_reset_to_regular_run (self);
}


static gboolean smd_applet_close_err_event (smdApplet* self, GdkEvent* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_reset_to_regular_run (self);
	result = TRUE;
	return result;
}


static void smd_applet_reset_to_regular_run (smdApplet* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->err_win);
	self->priv->error_mode = FALSE;
	gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet is running");
	gtk_status_icon_set_from_icon_name (self->priv->si, "mail-send-receive");
	gtk_status_icon_set_blinking (self->priv->si, FALSE);
	debug ("joining smdThread");
	g_thread_join (self->priv->thread);
	self->priv->thread_die = FALSE;
	debug ("starting smdThread");
	smd_applet_start_smdThread (self);
}


static void smd_applet_close_prefs_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_close_prefs (self);
}


static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEvent* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_close_prefs (self);
	result = TRUE;
	return result;
}


static void smd_applet_close_prefs (smdApplet* self) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->win);
	if (smd_applet_is_smd_stack_configured (self)) {
		_tmp0_ = self->priv->config_wait_mode;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->config_wait_mode = FALSE;
		{
			gboolean _tmp1_;
			_tmp1_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch19_g_error;
			}
			gtk_status_icon_set_visible (self->priv->si, !_tmp1_);
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, "Unable to read gconf key %s: %s\n", SMD_APPLET_key_icon, e->message);
				_g_error_free0 (e);
			}
		}
		__finally19:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		gtk_status_icon_set_from_icon_name (self->priv->si, "mail-send-receive");
		debug ("starting smdThread since smd stack is configured");
		smd_applet_start_smdThread (self);
	}
}


static void smd_applet_close_logs (smdApplet* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->log_win);
}


static void smd_applet_close_logs_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_close_logs (self);
}


static gboolean smd_applet_close_logs_event (smdApplet* self, GdkEvent* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_close_logs (self);
	result = TRUE;
	return result;
}


static void smd_applet_my_gtk_main_quit_button (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	gtk_main_quit ();
}


static gboolean smd_applet_my_gtk_main_quit_event (smdApplet* self, GdkEvent* b) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	gtk_main_quit ();
	result = FALSE;
	return result;
}


static void smd_applet_pause (smdApplet* self) {
	g_return_if_fail (self != NULL);
	debug ("enter pause mode");
	if (((gint) self->priv->pid) != 0) {
		char* _tmp0_;
		debug (_tmp0_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) self->priv->pid)));
		_g_free0 (_tmp0_);
		kill ((pid_t) (-((gint) self->priv->pid)), SIGTERM);
	}
	self->priv->thread_die = TRUE;
	gtk_status_icon_set_from_stock (self->priv->si, "gtk-media-pause");
	gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet is paused");
}


static void smd_applet_unpause (smdApplet* self) {
	g_return_if_fail (self != NULL);
	debug ("exit pause mode");
	smd_applet_reset_to_regular_run (self);
}


static gboolean smd_applet_is_smd_loop_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean rc;
	GObject* _tmp0_;
	GtkLabel* l;
	g_return_val_if_fail (self != NULL, FALSE);
	rc = g_file_test (SMD_LOOP_CFG, G_FILE_TEST_EXISTS);
	l = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (self->priv->builder, "lErrLoop"), GTK_IS_LABEL (_tmp0_) ? ((GtkLabel*) _tmp0_) : NULL));
	if (!rc) {
		gtk_widget_show ((GtkWidget*) l);
	} else {
		gtk_widget_hide ((GtkWidget*) l);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean rc;
	GObject* _tmp0_;
	GtkLabel* l;
	g_return_val_if_fail (self != NULL, FALSE);
	rc = g_file_test (SMD_PP_DEF_CFG, G_FILE_TEST_EXISTS);
	l = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (self->priv->builder, "lErrPushPull"), GTK_IS_LABEL (_tmp0_) ? ((GtkLabel*) _tmp0_) : NULL));
	if (!rc) {
		gtk_widget_show ((GtkWidget*) l);
	} else {
		gtk_widget_hide ((GtkWidget*) l);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_stack_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean a;
	gboolean b;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	a = smd_applet_is_smd_loop_configured (self);
	b = smd_applet_is_smd_pushpull_configured (self);
	if (a) {
		_tmp0_ = b;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void smd_applet_update_loglist (smdApplet* self) {
	GObject* _tmp0_;
	GtkTextView* tv;
	GtkTextBuffer* b;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tv = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (self->priv->builder, "tvLog"), GTK_IS_TEXT_VIEW (_tmp0_) ? ((GtkTextView*) _tmp0_) : NULL));
	b = _g_object_ref0 (gtk_text_view_get_buffer (tv));
	{
		GDir* d;
		char* file;
		d = g_dir_open (SMD_LOGS_DIR, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch20_g_file_error;
			}
			_g_object_unref0 (b);
			_g_object_unref0 (tv);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		file = NULL;
		gtk_list_store_clear (GTK_LIST_STORE (gtk_combo_box_get_model (self->priv->cblogs)));
		gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->lognames);
		while (TRUE) {
			char* _tmp1_;
			if (!((file = (_tmp1_ = g_strdup (g_dir_read_name (d)), _g_free0 (file), _tmp1_)) != NULL)) {
				break;
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->lognames, file);
			gtk_combo_box_append_text (self->priv->cblogs, file);
		}
		if (gee_collection_get_size ((GeeCollection*) self->priv->lognames) == 0) {
			char* _tmp2_;
			gtk_text_buffer_set_text (b, _tmp2_ = g_strdup_printf ("No logs in %s", SMD_LOGS_DIR), -1);
			_g_free0 (_tmp2_);
		} else {
			gtk_combo_box_set_title (self->priv->cblogs, "Choose log file");
			gtk_combo_box_set_active (self->priv->cblogs, 0);
		}
		_g_free0 (file);
		_g_dir_close0 (d);
	}
	goto __finally20;
	__catch20_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp3_;
			gtk_text_buffer_set_text (b, _tmp3_ = g_strdup_printf ("Unable to list directory %s", SMD_LOGS_DIR), -1);
			_g_free0 (_tmp3_);
			_g_error_free0 (e);
		}
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (b);
		_g_object_unref0 (tv);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (b);
	_g_object_unref0 (tv);
}


static gboolean _smd_applet_eat_event_gsource_func (gpointer self) {
	gboolean result;
	result = smd_applet_eat_event (self);
	return result;
}


static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_prefs_event (self, event);
	return result;
}


static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_err_event (self, event);
	return result;
}


void smd_applet_run (smdApplet* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _smd_applet_eat_event_gsource_func, smd_applet_ref (self), smd_applet_unref);
	if (smd_applet_is_smd_stack_configured (self)) {
		smd_applet_start_smdThread (self);
	} else {
		self->priv->config_wait_mode = TRUE;
	}
	g_signal_connect ((GtkWidget*) self->priv->win, "delete-event", (GCallback) _smd_applet_close_prefs_event_gtk_widget_delete_event, self);
	g_signal_connect ((GtkWidget*) self->priv->err_win, "delete-event", (GCallback) _smd_applet_close_err_event_gtk_widget_delete_event, self);
	if (self->priv->config_wait_mode) {
		NotifyNotification* not;
		gtk_status_icon_set_visible (self->priv->si, FALSE);
		while (TRUE) {
			if (!gtk_events_pending ()) {
				break;
			}
			gtk_main_iteration ();
		}
		sleep ((guint) 5);
		gtk_status_icon_set_visible (self->priv->si, TRUE);
		gtk_status_icon_set_from_icon_name (self->priv->si, "error");
		while (TRUE) {
			if (!gtk_events_pending ()) {
				break;
			}
			gtk_main_iteration ();
		}
		not = notify_notification_new ("Syncmaildir", "Syncmaildir is not configured properly, " "click on the icon to configure it.", "dialog-warning", NULL);
		notify_notification_attach_to_status_icon (not, self->priv->si);
		{
			notify_notification_show (not, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch21_g_error;
			}
		}
		goto __finally21;
		__catch21_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, "%s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally21:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (not);
				return;
			} else {
				_g_object_unref0 (not);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (not);
	} else {
		{
			gboolean _tmp0_;
			_tmp0_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch22_g_error;
			}
			gtk_status_icon_set_visible (self->priv->si, !_tmp0_);
		}
		goto __finally22;
		__catch22_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, "%s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally22:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	gtk_main ();
	if (self->priv->thread != NULL) {
		g_thread_join (self->priv->thread);
	}
}


static void _smd_applet_my_gtk_main_quit_button_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_my_gtk_main_quit_button (self, _sender);
}


static gboolean _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = smd_applet_my_gtk_main_quit_event (self, event);
	return result;
}


void smd_applet_configure (smdApplet* self) {
	GObject* _tmp0_;
	GtkButton* close;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	close = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (self->priv->builder, "bClosePrefs"), GTK_IS_BUTTON (_tmp0_) ? ((GtkButton*) _tmp0_) : NULL));
	g_signal_connect (close, "clicked", (GCallback) _smd_applet_my_gtk_main_quit_button_gtk_button_clicked, self);
	g_signal_connect ((GtkWidget*) self->priv->win, "delete-event", (GCallback) _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event, self);
	gtk_widget_show ((GtkWidget*) self->priv->win);
	gtk_main ();
	g_signal_parse_name ("clicked", GTK_TYPE_BUTTON, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (close, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _smd_applet_my_gtk_main_quit_button_gtk_button_clicked, self);
	g_signal_parse_name ("delete-event", GTK_TYPE_WIDGET, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->win, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event, self);
	_g_object_unref0 (close);
}


static void value_smd_applet_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_smd_applet_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		smd_applet_unref (value->data[0].v_pointer);
	}
}


static void value_smd_applet_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = smd_applet_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_smd_applet_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_smd_applet_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		smdApplet* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = smd_applet_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_smd_applet_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	smdApplet** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = smd_applet_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_smd_applet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecsmdApplet* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SMD_APPLET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_smd_applet (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET), NULL);
	return value->data[0].v_pointer;
}


void value_set_smd_applet (GValue* value, gpointer v_object) {
	smdApplet* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SMD_APPLET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		smd_applet_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		smd_applet_unref (old);
	}
}


void value_take_smd_applet (GValue* value, gpointer v_object) {
	smdApplet* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SMD_APPLET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		smd_applet_unref (old);
	}
}


static void smd_applet_class_init (smdAppletClass * klass) {
	smd_applet_parent_class = g_type_class_peek_parent (klass);
	SMD_APPLET_CLASS (klass)->finalize = smd_applet_finalize;
	g_type_class_add_private (klass, sizeof (smdAppletPrivate));
}


static void smd_applet_instance_init (smdApplet * self) {
	self->priv = SMD_APPLET_GET_PRIVATE (self);
	self->priv->builder = NULL;
	self->priv->menuL = NULL;
	self->priv->menuR = NULL;
	self->priv->si = NULL;
	self->priv->win = NULL;
	self->priv->err_win = NULL;
	self->priv->log_win = NULL;
	self->priv->about_win = NULL;
	self->priv->miPause = NULL;
	self->priv->cblogs = NULL;
	self->priv->lognames = NULL;
	self->priv->gconf = NULL;
	self->priv->thread = NULL;
	self->priv->thread_die = FALSE;
	self->priv->events_lock = NULL;
	self->priv->events = NULL;
	self->priv->error_mode = FALSE;
	self->priv->network_error_mode = FALSE;
	self->priv->command_hash = NULL;
	self->priv->net_manager = NULL;
	self->ref_count = 1;
}


static void smd_applet_finalize (smdApplet* obj) {
	smdApplet * self;
	self = SMD_APPLET (obj);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->menuL);
	_g_object_unref0 (self->priv->menuR);
	_g_object_unref0 (self->priv->si);
	_g_object_unref0 (self->priv->win);
	_g_object_unref0 (self->priv->err_win);
	_g_object_unref0 (self->priv->log_win);
	_g_object_unref0 (self->priv->about_win);
	_g_object_unref0 (self->priv->miPause);
	_g_object_unref0 (self->priv->cblogs);
	_g_object_unref0 (self->priv->lognames);
	_g_object_unref0 (self->priv->gconf);
	_g_mutex_free0 (self->priv->events_lock);
	_g_object_unref0 (self->priv->events);
	_g_hash_table_unref0 (self->priv->command_hash);
	_g_object_unref0 (self->priv->net_manager);
}


GType smd_applet_get_type (void) {
	static volatile gsize smd_applet_type_id__volatile = 0;
	if (g_once_init_enter (&smd_applet_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_smd_applet_init, value_smd_applet_free_value, value_smd_applet_copy_value, value_smd_applet_peek_pointer, "p", value_smd_applet_collect_value, "p", value_smd_applet_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (smdAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) smd_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (smdApplet), 0, (GInstanceInitFunc) smd_applet_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType smd_applet_type_id;
		smd_applet_type_id = g_type_register_fundamental (g_type_fundamental_next (), "smdApplet", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&smd_applet_type_id__volatile, smd_applet_type_id);
	}
	return smd_applet_type_id__volatile;
}


gpointer smd_applet_ref (gpointer instance) {
	smdApplet* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void smd_applet_unref (gpointer instance) {
	smdApplet* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SMD_APPLET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	char* PREFIX;
	char* _tmp0_;
	gboolean _tmp1_;
	char* homedir;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	gboolean config_only;
	gint oe_length1;
	gint _oe_size_;
	GOptionEntry* _tmp16_;
	GOptionEntry _tmp11_ = {0};
	GOptionEntry _tmp12_ = {0};
	GOptionEntry _tmp13_ = {0};
	GOptionEntry _tmp14_ = {0};
	GOptionEntry* _tmp15_ = NULL;
	GOptionEntry* oe;
	GOptionContext* oc;
	GError * _inner_error_ = NULL;
	PREFIX = g_strdup (SMD_CONF_PREFIX);
	if ((_tmp1_ = !g_file_test (_tmp0_ = g_strconcat (PREFIX, SMD_APPLET_UI, NULL), G_FILE_TEST_EXISTS), _g_free0 (_tmp0_), _tmp1_)) {
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
		fprintf (stderr, "error: file not found: %s + %s\n", PREFIX, SMD_APPLET_UI);
		smd_applet_smd_loop_cmd = (_tmp2_ = g_strdup ("./smd-loop"), _g_free0 (smd_applet_smd_loop_cmd), _tmp2_);
		fprintf (stderr, "smd-applet not installed, " "assuming smd-loop is: %s\n", smd_applet_smd_loop_cmd);
		smd_applet_smd_applet_ui = (_tmp3_ = g_strdup ("./smd-applet.ui"), _g_free0 (smd_applet_smd_applet_ui), _tmp3_);
		fprintf (stderr, "smd-applet not installed, " "assuming smd-applet.ui is: %s\n", smd_applet_smd_applet_ui);
		smd_applet_smd_push_cmd = (_tmp4_ = g_strdup ("./smd-push"), _g_free0 (smd_applet_smd_push_cmd), _tmp4_);
		fprintf (stderr, "smd-applet not installed, " "assuming smd-push is: %s\n", smd_applet_smd_push_cmd);
	} else {
		char* _tmp5_;
		char* _tmp6_;
		char* _tmp7_;
		smd_applet_smd_loop_cmd = (_tmp5_ = g_strconcat (PREFIX, SMD_LOOP, NULL), _g_free0 (smd_applet_smd_loop_cmd), _tmp5_);
		smd_applet_smd_push_cmd = (_tmp6_ = g_strconcat (PREFIX, SMD_PUSH, NULL), _g_free0 (smd_applet_smd_push_cmd), _tmp6_);
		smd_applet_smd_applet_ui = (_tmp7_ = g_strconcat (PREFIX, SMD_APPLET_UI, NULL), _g_free0 (smd_applet_smd_applet_ui), _tmp7_);
	}
	homedir = g_strdup (g_get_home_dir ());
	SMD_LOGS_DIR = (_tmp8_ = g_strconcat (homedir, "/.smd/log/", NULL), _g_free0 (SMD_LOGS_DIR), _tmp8_);
	SMD_LOOP_CFG = (_tmp9_ = g_strconcat (homedir, "/.smd/loop", NULL), _g_free0 (SMD_LOOP_CFG), _tmp9_);
	SMD_PP_DEF_CFG = (_tmp10_ = g_strconcat (homedir, "/.smd/config.default", NULL), _g_free0 (SMD_PP_DEF_CFG), _tmp10_);
	gtk_init (&args_length1, &args);
	notify_init ("smd-applet");
	config_only = FALSE;
	oe = (_tmp16_ = (_tmp15_ = g_new0 (GOptionEntry, 4), _tmp15_[0] = (memset (&_tmp11_, 0, sizeof (GOptionEntry)), _tmp11_.long_name = "configure", _tmp11_.short_name = 'c', _tmp11_.flags = (gint) G_OPTION_FLAG_NO_ARG, _tmp11_.arg = G_OPTION_ARG_NONE, _tmp11_.arg_data = &config_only, _tmp11_.description = "show config window, don't really run the applet", _tmp11_.arg_description = NULL, _tmp11_), _tmp15_[1] = (memset (&_tmp12_, 0, sizeof (GOptionEntry)), _tmp12_.long_name = "verbose", _tmp12_.short_name = 'v', _tmp12_.flags = (gint) G_OPTION_FLAG_NO_ARG, _tmp12_.arg = G_OPTION_ARG_NONE, _tmp12_.arg_data = &verbose, _tmp12_.description = "verbose output, for debugging only", _tmp12_.arg_description = NULL, _tmp12_), _tmp15_[2] = (memset (&_tmp13_, 0, sizeof (GOptionEntry)), _tmp13_.long_name = "smd-loop", _tmp13_.short_name = 'l', _tmp13_.flags = 0, _tmp13_.arg = G_OPTION_ARG_STRING, _tmp13_.arg_data = &smd_applet_smd_loop_cmd, _tmp13_.description = "override smd-loop command name, debugging only", _tmp13_.arg_description = "program", _tmp13_), _tmp15_[3] = (memset (&_tmp14_, 0, sizeof (GOptionEntry)), _tmp14_.long_name = NULL, _tmp14_), _tmp15_), oe_length1 = 4, _oe_size_ = oe_length1, _tmp16_);
	oc = g_option_context_new (" - syncmaildir applet");
	g_option_context_add_main_entries (oc, oe, NULL);
	{
		g_option_context_parse (oc, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch23_g_option_error;
			}
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally23;
	__catch23_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			result = 1;
			_g_error_free0 (e);
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			return result;
		}
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		smdApplet* smd_applet;
		smd_applet = smd_applet_new (config_only, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				goto __catch24_exit;
			}
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		if (config_only) {
			smd_applet_configure (smd_applet);
		} else {
			smd_applet_run (smd_applet, &_inner_error_);
			if (_inner_error_ != NULL) {
				_smd_applet_unref0 (smd_applet);
				if (_inner_error_->domain == EXIT) {
					goto __catch24_exit;
				}
				_smd_applet_unref0 (smd_applet);
				_g_option_context_free0 (oc);
				oe = (g_free (oe), NULL);
				_g_free0 (homedir);
				_g_free0 (PREFIX);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		_smd_applet_unref0 (smd_applet);
	}
	goto __finally24;
	__catch24_exit:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "abort: %s\n", e->message);
			result = 1;
			_g_error_free0 (e);
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			return result;
		}
	}
	__finally24:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (oc);
	oe = (g_free (oe), NULL);
	_g_free0 (homedir);
	_g_free0 (PREFIX);
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




