/* pastebin-plugin.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from pastebin-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libnotify/notify.h>


#define SYNAPSE_TYPE_PASTEBIN_PLUGIN (synapse_pastebin_plugin_get_type ())
#define SYNAPSE_PASTEBIN_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_PASTEBIN_PLUGIN, SynapsePastebinPlugin))
#define SYNAPSE_PASTEBIN_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_PASTEBIN_PLUGIN, SynapsePastebinPluginClass))
#define SYNAPSE_IS_PASTEBIN_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_PASTEBIN_PLUGIN))
#define SYNAPSE_IS_PASTEBIN_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_PASTEBIN_PLUGIN))
#define SYNAPSE_PASTEBIN_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_PASTEBIN_PLUGIN, SynapsePastebinPluginClass))

typedef struct _SynapsePastebinPlugin SynapsePastebinPlugin;
typedef struct _SynapsePastebinPluginClass SynapsePastebinPluginClass;
typedef struct _SynapsePastebinPluginPrivate SynapsePastebinPluginPrivate;

#define SYNAPSE_PASTEBIN_PLUGIN_TYPE_PASTEBIN_ACTION (synapse_pastebin_plugin_pastebin_action_get_type ())
#define SYNAPSE_PASTEBIN_PLUGIN_PASTEBIN_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_PASTEBIN_PLUGIN_TYPE_PASTEBIN_ACTION, SynapsePastebinPluginPastebinAction))
#define SYNAPSE_PASTEBIN_PLUGIN_PASTEBIN_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_PASTEBIN_PLUGIN_TYPE_PASTEBIN_ACTION, SynapsePastebinPluginPastebinActionClass))
#define SYNAPSE_PASTEBIN_PLUGIN_IS_PASTEBIN_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_PASTEBIN_PLUGIN_TYPE_PASTEBIN_ACTION))
#define SYNAPSE_PASTEBIN_PLUGIN_IS_PASTEBIN_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_PASTEBIN_PLUGIN_TYPE_PASTEBIN_ACTION))
#define SYNAPSE_PASTEBIN_PLUGIN_PASTEBIN_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_PASTEBIN_PLUGIN_TYPE_PASTEBIN_ACTION, SynapsePastebinPluginPastebinActionClass))

typedef struct _SynapsePastebinPluginPastebinAction SynapsePastebinPluginPastebinAction;
typedef struct _SynapsePastebinPluginPastebinActionClass SynapsePastebinPluginPastebinActionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_TYPE_LOCATE_PLUGIN (synapse_locate_plugin_get_type ())
#define SYNAPSE_LOCATE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin))
#define SYNAPSE_LOCATE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginClass))
#define SYNAPSE_IS_LOCATE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN))
#define SYNAPSE_IS_LOCATE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_LOCATE_PLUGIN))
#define SYNAPSE_LOCATE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginClass))

typedef struct _SynapseLocatePlugin SynapseLocatePlugin;
typedef struct _SynapseLocatePluginClass SynapseLocatePluginClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapsePastebinPluginPastebinActionPrivate SynapsePastebinPluginPastebinActionPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapsePastebinPluginPastebinActionPastebinFileData SynapsePastebinPluginPastebinActionPastebinFileData;
typedef struct _SynapsePastebinPluginPastebinActionPastebinTextData SynapsePastebinPluginPastebinActionPastebinTextData;

struct _SynapsePastebinPlugin {
	GObject parent_instance;
	SynapsePastebinPluginPrivate * priv;
};

struct _SynapsePastebinPluginClass {
	GObjectClass parent_class;
};

struct _SynapsePastebinPluginPrivate {
	gboolean _enabled;
	SynapsePastebinPluginPastebinAction* action;
};

struct _SynapsePastebinPluginPastebinAction {
	SynapseBaseAction parent_instance;
	SynapsePastebinPluginPastebinActionPrivate * priv;
};

struct _SynapsePastebinPluginPastebinActionClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapsePastebinPluginPastebinActionPastebinFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapsePastebinPluginPastebinAction* self;
	gchar* path;
	gchar* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	GPid pid;
	gint read_fd;
	GPid _tmp4_;
	gint _tmp5_;
	GUnixInputStream* _tmp6_;
	GUnixInputStream* read_stream;
	GDataInputStream* _tmp7_;
	GDataInputStream* pastebinit_output;
	gchar* line;
	gchar* _tmp8_;
	gchar* complete_output;
	gboolean _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GRegex* _tmp14_;
	GRegex* url;
	gboolean _tmp15_;
	GError* _tmp16_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapsePastebinPluginPastebinActionPastebinTextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapsePastebinPluginPastebinAction* self;
	gchar* content;
	gchar* result;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	GPid pid;
	gint read_fd;
	gint write_fd;
	GPid _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GUnixInputStream* _tmp5_;
	GUnixInputStream* read_stream;
	GDataInputStream* _tmp6_;
	GDataInputStream* pastebinit_output;
	GUnixOutputStream* _tmp7_;
	GUnixOutputStream* write_stream;
	guint8* _tmp8_;
	gint _tmp9_;
	gchar* line;
	gchar* _tmp10_;
	gchar* complete_output;
	gboolean _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GRegex* _tmp16_;
	GRegex* url;
	gboolean _tmp17_;
	GError* _tmp18_;
	GError * err;
	GError * _inner_error_;
};


static gpointer synapse_pastebin_plugin_parent_class = NULL;
static gpointer synapse_pastebin_plugin_pastebin_action_parent_class = NULL;
static SynapseActivatableIface* synapse_pastebin_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface* synapse_pastebin_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_pastebin_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_pastebin_plugin_pastebin_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_PASTEBIN_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_PASTEBIN_PLUGIN, SynapsePastebinPluginPrivate))
enum  {
	SYNAPSE_PASTEBIN_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_PASTEBIN_PLUGIN_ENABLED
};
static void synapse_pastebin_plugin_real_activate (SynapseActivatable* base);
static void synapse_pastebin_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_pastebin_plugin_register_plugin (void);
GType synapse_locate_plugin_get_type (void) G_GNUC_CONST;
static void _synapse_pastebin_plugin_register_plugin_synapse_plugin_register_func (void);
static SynapseResultSet* synapse_pastebin_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* q, SynapseMatch* match);
SynapsePastebinPlugin* synapse_pastebin_plugin_new (void);
SynapsePastebinPlugin* synapse_pastebin_plugin_construct (GType object_type);
static GObject * synapse_pastebin_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static SynapsePastebinPluginPastebinAction* synapse_pastebin_plugin_pastebin_action_new (void);
static SynapsePastebinPluginPastebinAction* synapse_pastebin_plugin_pastebin_action_construct (GType object_type);
enum  {
	SYNAPSE_PASTEBIN_PLUGIN_PASTEBIN_ACTION_DUMMY_PROPERTY
};
static void synapse_pastebin_plugin_pastebin_action_pastebin_file_data_free (gpointer _data);
static void synapse_pastebin_plugin_pastebin_action_pastebin_file (SynapsePastebinPluginPastebinAction* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* synapse_pastebin_plugin_pastebin_action_pastebin_file_finish (SynapsePastebinPluginPastebinAction* self, GAsyncResult* _res_);
static gboolean synapse_pastebin_plugin_pastebin_action_pastebin_file_co (SynapsePastebinPluginPastebinActionPastebinFileData* data);
static void synapse_pastebin_plugin_pastebin_action_pastebin_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_pastebin_plugin_pastebin_action_pastebin_text_data_free (gpointer _data);
static void synapse_pastebin_plugin_pastebin_action_pastebin_text (SynapsePastebinPluginPastebinAction* self, const gchar* content, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* synapse_pastebin_plugin_pastebin_action_pastebin_text_finish (SynapsePastebinPluginPastebinAction* self, GAsyncResult* _res_);
static gboolean synapse_pastebin_plugin_pastebin_action_pastebin_text_co (SynapsePastebinPluginPastebinActionPastebinTextData* data);
static void synapse_pastebin_plugin_pastebin_action_pastebin_text_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_pastebin_plugin_pastebin_action_process_pastebin_result (SynapsePastebinPluginPastebinAction* self, const gchar* url);
static void synapse_pastebin_plugin_pastebin_action_real_do_execute (SynapseBaseAction* base, SynapseMatch* match);
static void _lambda9_ (GObject* obj, GAsyncResult* res, SynapsePastebinPluginPastebinAction* self);
static void __lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _lambda10_ (GObject* obj, GAsyncResult* res, SynapsePastebinPluginPastebinAction* self);
static void __lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean synapse_pastebin_plugin_pastebin_action_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match);
static void synapse_pastebin_plugin_finalize (GObject* obj);
static void _vala_synapse_pastebin_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_pastebin_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void synapse_pastebin_plugin_real_activate (SynapseActivatable* base) {
	SynapsePastebinPlugin * self;
	self = (SynapsePastebinPlugin*) base;
}


static void synapse_pastebin_plugin_real_deactivate (SynapseActivatable* base) {
	SynapsePastebinPlugin * self;
	self = (SynapsePastebinPlugin*) base;
}


static void _synapse_pastebin_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_pastebin_plugin_register_plugin ();
}


static void synapse_pastebin_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Pastebin");
	_tmp3_ = _ ("Upload files to pastebin.");
	_tmp4_ = g_find_program_in_path ("pastebinit");
	_tmp5_ = _tmp4_;
	_tmp6_ = _ ("Unable to find \"pastebinit\" program");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_LOCATE_PLUGIN, _tmp2_, _tmp3_, "document-send", _synapse_pastebin_plugin_register_plugin_synapse_plugin_register_func, _tmp5_ != NULL, _tmp6_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static SynapseResultSet* synapse_pastebin_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* q, SynapseMatch* match) {
	SynapsePastebinPlugin * self;
	SynapseResultSet* result = NULL;
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean query_empty;
	SynapseResultSet* _tmp3_ = NULL;
	SynapseResultSet* results;
	self = (SynapsePastebinPlugin*) base;
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = synapse_base_action_valid_for_match ((SynapseBaseAction*) self->priv->action, match);
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = string_strip ((*q).query_string);
	_tmp2_ = _tmp1_;
	_g_free0 ((*q).query_string);
	(*q).query_string = _tmp2_;
	query_empty = g_strcmp0 ((*q).query_string, "") == 0;
	_tmp3_ = synapse_result_set_new ();
	results = _tmp3_;
	if (query_empty) {
		gint _tmp4_;
		_tmp4_ = synapse_base_action_get_default_relevancy ((SynapseBaseAction*) self->priv->action);
		synapse_result_set_add (results, (SynapseMatch*) self->priv->action, _tmp4_);
	} else {
		GeeList* _tmp5_ = NULL;
		GeeList* matchers;
		_tmp5_ = synapse_query_get_matchers_for_query ((*q).query_string, 0, G_REGEX_CASELESS);
		matchers = _tmp5_;
		{
			GeeList* _tmp6_;
			GeeList* _matcher_list;
			gint _tmp7_;
			gint _matcher_size;
			gint _matcher_index;
			_tmp6_ = _g_object_ref0 (matchers);
			_matcher_list = _tmp6_;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _matcher_list);
			_matcher_size = _tmp7_;
			_matcher_index = -1;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				GeeMapEntry* matcher;
				gconstpointer _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp11_;
				_matcher_index = _matcher_index + 1;
				if (!(_matcher_index < _matcher_size)) {
					break;
				}
				_tmp8_ = gee_list_get (_matcher_list, _matcher_index);
				matcher = (GeeMapEntry*) _tmp8_;
				_tmp9_ = gee_map_entry_get_key (matcher);
				_tmp10_ = synapse_match_get_title ((SynapseMatch*) self->priv->action);
				_tmp11_ = g_regex_match ((GRegex*) _tmp9_, _tmp10_, 0, NULL);
				if (_tmp11_) {
					gconstpointer _tmp12_ = NULL;
					_tmp12_ = gee_map_entry_get_value (matcher);
					synapse_result_set_add (results, (SynapseMatch*) self->priv->action, GPOINTER_TO_INT (_tmp12_));
					_g_object_unref0 (matcher);
					break;
				}
				_g_object_unref0 (matcher);
			}
			_g_object_unref0 (_matcher_list);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


SynapsePastebinPlugin* synapse_pastebin_plugin_construct (GType object_type) {
	SynapsePastebinPlugin * self = NULL;
	self = (SynapsePastebinPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapsePastebinPlugin* synapse_pastebin_plugin_new (void) {
	return synapse_pastebin_plugin_construct (SYNAPSE_TYPE_PASTEBIN_PLUGIN);
}


static gboolean synapse_pastebin_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapsePastebinPlugin* self;
	self = (SynapsePastebinPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_pastebin_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapsePastebinPlugin* self;
	self = (SynapsePastebinPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_pastebin_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapsePastebinPlugin * self;
	SynapsePastebinPluginPastebinAction* _tmp0_ = NULL;
	SynapsePastebinPluginPastebinAction* _tmp1_;
	parent_class = G_OBJECT_CLASS (synapse_pastebin_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_PASTEBIN_PLUGIN (obj);
	_tmp0_ = synapse_pastebin_plugin_pastebin_action_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->action);
	self->priv->action = _tmp1_;
	return obj;
}


static SynapsePastebinPluginPastebinAction* synapse_pastebin_plugin_pastebin_action_construct (GType object_type) {
	SynapsePastebinPluginPastebinAction * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Pastebin");
	_tmp1_ = _ ("Pastebin selection");
	self = (SynapsePastebinPluginPastebinAction*) g_object_new (object_type, "title", _tmp0_, "description", _tmp1_, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "icon-name", "document-send", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
	return self;
}


static SynapsePastebinPluginPastebinAction* synapse_pastebin_plugin_pastebin_action_new (void) {
	return synapse_pastebin_plugin_pastebin_action_construct (SYNAPSE_PASTEBIN_PLUGIN_TYPE_PASTEBIN_ACTION);
}


static void synapse_pastebin_plugin_pastebin_action_pastebin_file_data_free (gpointer _data) {
	SynapsePastebinPluginPastebinActionPastebinFileData* data;
	data = _data;
	_g_free0 (data->path);
	_g_free0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapsePastebinPluginPastebinActionPastebinFileData, data);
}


static void synapse_pastebin_plugin_pastebin_action_pastebin_file (SynapsePastebinPluginPastebinAction* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapsePastebinPluginPastebinActionPastebinFileData* _data_;
	_data_ = g_slice_new0 (SynapsePastebinPluginPastebinActionPastebinFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_pastebin_plugin_pastebin_action_pastebin_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_pastebin_plugin_pastebin_action_pastebin_file_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->path = g_strdup (path);
	synapse_pastebin_plugin_pastebin_action_pastebin_file_co (_data_);
}


static gchar* synapse_pastebin_plugin_pastebin_action_pastebin_file_finish (SynapsePastebinPluginPastebinAction* self, GAsyncResult* _res_) {
	gchar* result;
	SynapsePastebinPluginPastebinActionPastebinFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_pastebin_plugin_pastebin_action_pastebin_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapsePastebinPluginPastebinActionPastebinFileData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_pastebin_plugin_pastebin_action_pastebin_file_co (data);
}


static gboolean synapse_pastebin_plugin_pastebin_action_pastebin_file_co (SynapsePastebinPluginPastebinActionPastebinFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = g_strdup ("pastebinit");
	data->_tmp1_ = g_strdup ("-i");
	data->_tmp2_ = g_strdup (data->path);
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_new0 (gchar*, 3 + 1);
	data->_tmp3_[0] = data->_tmp0_;
	data->_tmp3_[1] = data->_tmp1_;
	data->_tmp3_[2] = data->_tmp2_;
	data->argv = data->_tmp3_;
	data->argv_length1 = 3;
	data->_argv_size_ = 3;
	g_spawn_async_with_pipes (NULL, data->argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &data->_tmp4_, NULL, &data->_tmp5_, NULL, &data->_inner_error_);
	data->pid = data->_tmp4_;
	data->read_fd = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		goto __catch31_g_error;
	}
	data->_tmp6_ = NULL;
	data->_tmp6_ = (GUnixInputStream*) g_unix_input_stream_new (data->read_fd, TRUE);
	data->read_stream = data->_tmp6_;
	data->_tmp7_ = NULL;
	data->_tmp7_ = g_data_input_stream_new ((GInputStream*) data->read_stream);
	data->pastebinit_output = data->_tmp7_;
	data->line = NULL;
	data->_tmp8_ = g_strdup ("");
	data->complete_output = data->_tmp8_;
	{
		data->_tmp9_ = TRUE;
		while (TRUE) {
			if (!data->_tmp9_) {
				if (!(data->line != NULL)) {
					break;
				}
			}
			data->_tmp9_ = FALSE;
			data->_state_ = 1;
			g_data_input_stream_read_line_async (data->pastebinit_output, G_PRIORITY_DEFAULT_IDLE, NULL, synapse_pastebin_plugin_pastebin_action_pastebin_file_ready, data);
			return FALSE;
			_state_1:
			data->_tmp10_ = NULL;
			data->_tmp10_ = g_data_input_stream_read_line_finish (data->pastebinit_output, data->_res_, NULL, &data->_inner_error_);
			data->_tmp11_ = data->_tmp10_;
			if (data->_inner_error_ != NULL) {
				_g_free0 (data->complete_output);
				_g_free0 (data->line);
				_g_object_unref0 (data->pastebinit_output);
				_g_object_unref0 (data->read_stream);
				goto __catch31_g_error;
			}
			data->_tmp12_ = data->_tmp11_;
			_g_free0 (data->line);
			data->line = data->_tmp12_;
			if (data->line != NULL) {
				data->_tmp13_ = g_strconcat (data->complete_output, data->line, NULL);
				_g_free0 (data->complete_output);
				data->complete_output = data->_tmp13_;
			}
		}
	}
	data->_tmp14_ = NULL;
	data->_tmp14_ = g_regex_new ("^http(s)?://.*$", 0, 0, &data->_inner_error_);
	data->url = data->_tmp14_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->complete_output);
		_g_free0 (data->line);
		_g_object_unref0 (data->pastebinit_output);
		_g_object_unref0 (data->read_stream);
		goto __catch31_g_error;
	}
	data->_tmp15_ = g_regex_match (data->url, data->complete_output, 0, NULL);
	if (data->_tmp15_) {
		data->result = data->complete_output;
		_g_regex_unref0 (data->url);
		_g_free0 (data->line);
		_g_object_unref0 (data->pastebinit_output);
		_g_object_unref0 (data->read_stream);
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_tmp16_ = NULL;
		data->_tmp16_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_DATA, data->complete_output);
		data->_inner_error_ = data->_tmp16_;
		_g_regex_unref0 (data->url);
		_g_free0 (data->complete_output);
		_g_free0 (data->line);
		_g_object_unref0 (data->pastebinit_output);
		_g_object_unref0 (data->read_stream);
		goto __catch31_g_error;
	}
	_g_regex_unref0 (data->url);
	_g_free0 (data->complete_output);
	_g_free0 (data->line);
	_g_object_unref0 (data->pastebinit_output);
	_g_object_unref0 (data->read_stream);
	goto __finally31;
	__catch31_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		synapse_utils_logger_warning ((GObject*) data->self, "%s", data->err->message, NULL);
		_g_error_free0 (data->err);
	}
	__finally31:
	if (data->_inner_error_ != NULL) {
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->result = NULL;
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_pastebin_plugin_pastebin_action_pastebin_text_data_free (gpointer _data) {
	SynapsePastebinPluginPastebinActionPastebinTextData* data;
	data = _data;
	_g_free0 (data->content);
	_g_free0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapsePastebinPluginPastebinActionPastebinTextData, data);
}


static void synapse_pastebin_plugin_pastebin_action_pastebin_text (SynapsePastebinPluginPastebinAction* self, const gchar* content, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapsePastebinPluginPastebinActionPastebinTextData* _data_;
	_data_ = g_slice_new0 (SynapsePastebinPluginPastebinActionPastebinTextData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_pastebin_plugin_pastebin_action_pastebin_text);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_pastebin_plugin_pastebin_action_pastebin_text_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->content = g_strdup (content);
	synapse_pastebin_plugin_pastebin_action_pastebin_text_co (_data_);
}


static gchar* synapse_pastebin_plugin_pastebin_action_pastebin_text_finish (SynapsePastebinPluginPastebinAction* self, GAsyncResult* _res_) {
	gchar* result;
	SynapsePastebinPluginPastebinActionPastebinTextData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = -1;
	_tmp0_ = strlen (self);
	res_length1 = (gint) _tmp0_;
	_tmp1_ = res;
	*result_length1 = res_length1;
	result = _tmp1_;
	return result;
}


static void synapse_pastebin_plugin_pastebin_action_pastebin_text_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapsePastebinPluginPastebinActionPastebinTextData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_pastebin_plugin_pastebin_action_pastebin_text_co (data);
}


static gboolean synapse_pastebin_plugin_pastebin_action_pastebin_text_co (SynapsePastebinPluginPastebinActionPastebinTextData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = g_strdup ("pastebinit");
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_new0 (gchar*, 1 + 1);
	data->_tmp1_[0] = data->_tmp0_;
	data->argv = data->_tmp1_;
	data->argv_length1 = 1;
	data->_argv_size_ = 1;
	g_spawn_async_with_pipes (NULL, data->argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &data->_tmp2_, &data->_tmp3_, &data->_tmp4_, NULL, &data->_inner_error_);
	data->pid = data->_tmp2_;
	data->write_fd = data->_tmp3_;
	data->read_fd = data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		goto __catch32_g_error;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = (GUnixInputStream*) g_unix_input_stream_new (data->read_fd, TRUE);
	data->read_stream = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_data_input_stream_new ((GInputStream*) data->read_stream);
	data->pastebinit_output = data->_tmp6_;
	data->_tmp7_ = NULL;
	data->_tmp7_ = (GUnixOutputStream*) g_unix_output_stream_new (data->write_fd, TRUE);
	data->write_stream = data->_tmp7_;
	data->_tmp8_ = NULL;
	data->_tmp8_ = string_get_data (data->content, &data->_tmp9_);
	data->_state_ = 1;
	g_output_stream_write_async ((GOutputStream*) data->write_stream, data->_tmp8_, (gsize) data->_tmp9_, G_PRIORITY_DEFAULT, NULL, synapse_pastebin_plugin_pastebin_action_pastebin_text_ready, data);
	return FALSE;
	_state_1:
	g_output_stream_write_finish ((GOutputStream*) data->write_stream, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->write_stream);
		_g_object_unref0 (data->pastebinit_output);
		_g_object_unref0 (data->read_stream);
		goto __catch32_g_error;
	}
	data->_state_ = 2;
	g_output_stream_close_async ((GOutputStream*) data->write_stream, G_PRIORITY_DEFAULT, NULL, synapse_pastebin_plugin_pastebin_action_pastebin_text_ready, data);
	return FALSE;
	_state_2:
	g_output_stream_close_finish ((GOutputStream*) data->write_stream, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->write_stream);
		_g_object_unref0 (data->pastebinit_output);
		_g_object_unref0 (data->read_stream);
		goto __catch32_g_error;
	}
	data->line = NULL;
	data->_tmp10_ = g_strdup ("");
	data->complete_output = data->_tmp10_;
	{
		data->_tmp11_ = TRUE;
		while (TRUE) {
			if (!data->_tmp11_) {
				if (!(data->line != NULL)) {
					break;
				}
			}
			data->_tmp11_ = FALSE;
			data->_state_ = 3;
			g_data_input_stream_read_line_async (data->pastebinit_output, G_PRIORITY_DEFAULT_IDLE, NULL, synapse_pastebin_plugin_pastebin_action_pastebin_text_ready, data);
			return FALSE;
			_state_3:
			data->_tmp12_ = NULL;
			data->_tmp12_ = g_data_input_stream_read_line_finish (data->pastebinit_output, data->_res_, NULL, &data->_inner_error_);
			data->_tmp13_ = data->_tmp12_;
			if (data->_inner_error_ != NULL) {
				_g_free0 (data->complete_output);
				_g_free0 (data->line);
				_g_object_unref0 (data->write_stream);
				_g_object_unref0 (data->pastebinit_output);
				_g_object_unref0 (data->read_stream);
				goto __catch32_g_error;
			}
			data->_tmp14_ = data->_tmp13_;
			_g_free0 (data->line);
			data->line = data->_tmp14_;
			if (data->line != NULL) {
				data->_tmp15_ = g_strconcat (data->complete_output, data->line, NULL);
				_g_free0 (data->complete_output);
				data->complete_output = data->_tmp15_;
			}
		}
	}
	data->_tmp16_ = NULL;
	data->_tmp16_ = g_regex_new ("^http(s)?://.*$", 0, 0, &data->_inner_error_);
	data->url = data->_tmp16_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->complete_output);
		_g_free0 (data->line);
		_g_object_unref0 (data->write_stream);
		_g_object_unref0 (data->pastebinit_output);
		_g_object_unref0 (data->read_stream);
		goto __catch32_g_error;
	}
	data->_tmp17_ = g_regex_match (data->url, data->complete_output, 0, NULL);
	if (data->_tmp17_) {
		data->result = data->complete_output;
		_g_regex_unref0 (data->url);
		_g_free0 (data->line);
		_g_object_unref0 (data->write_stream);
		_g_object_unref0 (data->pastebinit_output);
		_g_object_unref0 (data->read_stream);
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_tmp18_ = NULL;
		data->_tmp18_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_DATA, data->complete_output);
		data->_inner_error_ = data->_tmp18_;
		_g_regex_unref0 (data->url);
		_g_free0 (data->complete_output);
		_g_free0 (data->line);
		_g_object_unref0 (data->write_stream);
		_g_object_unref0 (data->pastebinit_output);
		_g_object_unref0 (data->read_stream);
		goto __catch32_g_error;
	}
	_g_regex_unref0 (data->url);
	_g_free0 (data->complete_output);
	_g_free0 (data->line);
	_g_object_unref0 (data->write_stream);
	_g_object_unref0 (data->pastebinit_output);
	_g_object_unref0 (data->read_stream);
	goto __finally32;
	__catch32_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		synapse_utils_logger_warning ((GObject*) data->self, "%s", data->err->message, NULL);
		_g_error_free0 (data->err);
	}
	__finally32:
	if (data->_inner_error_ != NULL) {
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->result = NULL;
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_pastebin_plugin_pastebin_action_process_pastebin_result (SynapsePastebinPluginPastebinAction* self, const gchar* url) {
	gchar* msg = NULL;
	const gchar* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_;
	GObject* _tmp11_;
	NotifyNotification* notification;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (url != NULL) {
		GtkClipboard* _tmp0_ = NULL;
		GtkClipboard* _tmp1_;
		GtkClipboard* cb;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = gtk_clipboard_get (GDK_NONE);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		cb = _tmp1_;
		gtk_clipboard_set_text (cb, url, -1);
		_tmp2_ = _ ("The selection was successfully uploaded and its URL was copied to clip" \
"board.");
		_tmp3_ = g_strdup (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (msg);
		msg = _tmp4_;
		_g_object_unref0 (cb);
	} else {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = _ ("An error occurred during upload, please check the log for more informa" \
"tion.");
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (msg);
		msg = _tmp7_;
	}
	_tmp8_ = _ ("Synapse - Pastebin");
	_tmp9_ = g_object_new (NOTIFY_TYPE_NOTIFICATION, "summary", _tmp8_, "body", msg, "icon-name", "synapse", NULL, NULL);
	notification = (_tmp11_ = (_tmp10_ = _tmp9_, G_IS_INITIALLY_UNOWNED (_tmp10_) ? g_object_ref_sink (_tmp10_) : _tmp10_), NOTIFY_IS_NOTIFICATION (_tmp11_) ? ((NotifyNotification*) _tmp11_) : NULL);
	notify_notification_set_timeout (notification, 10);
	notify_notification_show (notification, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (notification);
		goto __catch33_g_error;
	}
	_g_object_unref0 (notification);
	goto __finally33;
	__catch33_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
		_g_error_free0 (err);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		_g_free0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (msg);
}


static void _lambda9_ (GObject* obj, GAsyncResult* res, SynapsePastebinPluginPastebinAction* self) {
	gchar* _tmp0_ = NULL;
	gchar* url;
	g_return_if_fail (res != NULL);
	_tmp0_ = synapse_pastebin_plugin_pastebin_action_pastebin_file_finish (self, res);
	url = _tmp0_;
	synapse_pastebin_plugin_pastebin_action_process_pastebin_result (self, url);
	_g_free0 (url);
}


static void __lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda9_ (source_object, res, self);
	g_object_unref (self);
}


static void _lambda10_ (GObject* obj, GAsyncResult* res, SynapsePastebinPluginPastebinAction* self) {
	gchar* _tmp0_ = NULL;
	gchar* url;
	g_return_if_fail (res != NULL);
	_tmp0_ = synapse_pastebin_plugin_pastebin_action_pastebin_text_finish (self, res);
	url = _tmp0_;
	synapse_pastebin_plugin_pastebin_action_process_pastebin_result (self, url);
	_g_free0 (url);
}


static void __lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda10_ (source_object, res, self);
	g_object_unref (self);
}


static void synapse_pastebin_plugin_pastebin_action_real_do_execute (SynapseBaseAction* base, SynapseMatch* match) {
	SynapsePastebinPluginPastebinAction * self;
	gboolean _tmp0_ = FALSE;
	SynapseMatchType _tmp1_;
	self = (SynapsePastebinPluginPastebinAction*) base;
	_tmp1_ = synapse_match_get_match_type (match);
	if (_tmp1_ == SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		_tmp0_ = SYNAPSE_IS_URI_MATCH (match);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SynapseMatch* _tmp2_;
		SynapseUriMatch* _tmp3_;
		SynapseUriMatch* uri_match;
		const gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* f;
		gchar* _tmp6_ = NULL;
		gchar* path;
		_tmp3_ = _g_object_ref0 ((_tmp2_ = match, SYNAPSE_IS_URI_MATCH (_tmp2_) ? ((SynapseUriMatch*) _tmp2_) : NULL));
		uri_match = _tmp3_;
		_tmp4_ = synapse_uri_match_get_uri (uri_match);
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		f = _tmp5_;
		_tmp6_ = g_file_get_path (f);
		path = _tmp6_;
		if (path == NULL) {
			const gchar* _tmp7_ = NULL;
			_tmp7_ = synapse_uri_match_get_uri (uri_match);
			synapse_utils_logger_warning ((GObject*) self, "Unable to get path for %s", _tmp7_, NULL);
			_g_free0 (path);
			_g_object_unref0 (f);
			_g_object_unref0 (uri_match);
			return;
		}
		synapse_pastebin_plugin_pastebin_action_pastebin_file (self, path, __lambda9__gasync_ready_callback, g_object_ref (self));
		_g_free0 (path);
		_g_object_unref0 (f);
		_g_object_unref0 (uri_match);
	} else {
		SynapseMatchType _tmp8_;
		_tmp8_ = synapse_match_get_match_type (match);
		if (_tmp8_ == SYNAPSE_MATCH_TYPE_TEXT) {
			SynapseMatch* _tmp9_;
			SynapseTextMatch* _tmp10_;
			SynapseTextMatch* text_match;
			gchar* _tmp11_ = NULL;
			gchar* _tmp17_;
			gchar* content;
			_tmp10_ = _g_object_ref0 ((_tmp9_ = match, SYNAPSE_IS_TEXT_MATCH (_tmp9_) ? ((SynapseTextMatch*) _tmp9_) : NULL));
			text_match = _tmp10_;
			if (text_match != NULL) {
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp12_ = synapse_text_match_get_text (text_match);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				_tmp11_ = _tmp13_;
			} else {
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = synapse_match_get_title (match);
				_tmp15_ = g_strdup (_tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp11_);
				_tmp11_ = _tmp16_;
			}
			_tmp17_ = g_strdup (_tmp11_);
			content = _tmp17_;
			synapse_pastebin_plugin_pastebin_action_pastebin_text (self, content, __lambda10__gasync_ready_callback, g_object_ref (self));
			_g_free0 (content);
			_g_free0 (_tmp11_);
			_g_object_unref0 (text_match);
		}
	}
}


static gboolean synapse_pastebin_plugin_pastebin_action_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapsePastebinPluginPastebinAction * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	self = (SynapsePastebinPluginPastebinAction*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	switch (_tmp0_) {
		case SYNAPSE_MATCH_TYPE_TEXT:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
		{
			SynapseMatch* _tmp1_;
			SynapseUriMatch* _tmp2_;
			SynapseUriMatch* um;
			const gchar* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GFile* f;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gboolean _tmp7_;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_;
			_tmp2_ = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_URI_MATCH (_tmp1_) ? ((SynapseUriMatch*) _tmp1_) : NULL));
			um = _tmp2_;
			_tmp3_ = synapse_uri_match_get_uri (um);
			_tmp4_ = g_file_new_for_uri (_tmp3_);
			f = _tmp4_;
			_tmp5_ = g_file_get_path (f);
			_tmp6_ = _tmp5_;
			if ((_tmp7_ = _tmp6_ == NULL, _g_free0 (_tmp6_), _tmp7_)) {
				result = FALSE;
				_g_object_unref0 (f);
				_g_object_unref0 (um);
				return result;
			}
			_tmp8_ = synapse_uri_match_get_mime_type (um);
			_tmp9_ = g_content_type_is_a (_tmp8_, "text/*");
			result = _tmp9_;
			_g_object_unref0 (f);
			_g_object_unref0 (um);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void synapse_pastebin_plugin_pastebin_action_class_init (SynapsePastebinPluginPastebinActionClass * klass) {
	synapse_pastebin_plugin_pastebin_action_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_pastebin_plugin_pastebin_action_real_do_execute;
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_pastebin_plugin_pastebin_action_real_valid_for_match;
}


static void synapse_pastebin_plugin_pastebin_action_instance_init (SynapsePastebinPluginPastebinAction * self) {
}


static GType synapse_pastebin_plugin_pastebin_action_get_type (void) {
	static volatile gsize synapse_pastebin_plugin_pastebin_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_pastebin_plugin_pastebin_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapsePastebinPluginPastebinActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_pastebin_plugin_pastebin_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapsePastebinPluginPastebinAction), 0, (GInstanceInitFunc) synapse_pastebin_plugin_pastebin_action_instance_init, NULL };
		GType synapse_pastebin_plugin_pastebin_action_type_id;
		synapse_pastebin_plugin_pastebin_action_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapsePastebinPluginPastebinAction", &g_define_type_info, 0);
		g_once_init_leave (&synapse_pastebin_plugin_pastebin_action_type_id__volatile, synapse_pastebin_plugin_pastebin_action_type_id);
	}
	return synapse_pastebin_plugin_pastebin_action_type_id__volatile;
}


static void synapse_pastebin_plugin_class_init (SynapsePastebinPluginClass * klass) {
	synapse_pastebin_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapsePastebinPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_pastebin_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_pastebin_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_pastebin_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_pastebin_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_PASTEBIN_PLUGIN_ENABLED, "enabled");
	synapse_pastebin_plugin_register_plugin ();
}


static void synapse_pastebin_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_pastebin_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_pastebin_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_pastebin_plugin_real_deactivate;
	iface->get_enabled = synapse_pastebin_plugin_real_get_enabled;
	iface->set_enabled = synapse_pastebin_plugin_real_set_enabled;
}


static void synapse_pastebin_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface) {
	synapse_pastebin_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_for_match = (SynapseResultSet* (*)(SynapseActionProvider* ,SynapseQuery* ,SynapseMatch*)) synapse_pastebin_plugin_real_find_for_match;
}


static void synapse_pastebin_plugin_instance_init (SynapsePastebinPlugin * self) {
	self->priv = SYNAPSE_PASTEBIN_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_pastebin_plugin_finalize (GObject* obj) {
	SynapsePastebinPlugin * self;
	self = SYNAPSE_PASTEBIN_PLUGIN (obj);
	_g_object_unref0 (self->priv->action);
	G_OBJECT_CLASS (synapse_pastebin_plugin_parent_class)->finalize (obj);
}


GType synapse_pastebin_plugin_get_type (void) {
	static volatile gsize synapse_pastebin_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_pastebin_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapsePastebinPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_pastebin_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapsePastebinPlugin), 0, (GInstanceInitFunc) synapse_pastebin_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_pastebin_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_pastebin_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_pastebin_plugin_type_id;
		synapse_pastebin_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapsePastebinPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_pastebin_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_pastebin_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		g_once_init_leave (&synapse_pastebin_plugin_type_id__volatile, synapse_pastebin_plugin_type_id);
	}
	return synapse_pastebin_plugin_type_id__volatile;
}


static void _vala_synapse_pastebin_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapsePastebinPlugin * self;
	self = SYNAPSE_PASTEBIN_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_PASTEBIN_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_pastebin_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapsePastebinPlugin * self;
	self = SYNAPSE_PASTEBIN_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_PASTEBIN_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



