/* launchpad-plugin.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from launchpad-plugin.vala, do not modify */

/*
 * Copyright (C) 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define SYNAPSE_TYPE_LAUNCHPAD_PLUGIN (synapse_launchpad_plugin_get_type ())
#define SYNAPSE_LAUNCHPAD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, SynapseLaunchpadPlugin))
#define SYNAPSE_LAUNCHPAD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, SynapseLaunchpadPluginClass))
#define SYNAPSE_IS_LAUNCHPAD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN))
#define SYNAPSE_IS_LAUNCHPAD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN))
#define SYNAPSE_LAUNCHPAD_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, SynapseLaunchpadPluginClass))

typedef struct _SynapseLaunchpadPlugin SynapseLaunchpadPlugin;
typedef struct _SynapseLaunchpadPluginClass SynapseLaunchpadPluginClass;
typedef struct _SynapseLaunchpadPluginPrivate SynapseLaunchpadPluginPrivate;

#define SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT (synapse_launchpad_plugin_launchpad_auth_object_get_type ())
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT, SynapseLaunchpadPluginLaunchpadAuthObject))
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT, SynapseLaunchpadPluginLaunchpadAuthObjectClass))
#define SYNAPSE_LAUNCHPAD_PLUGIN_IS_LAUNCHPAD_AUTH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT))
#define SYNAPSE_LAUNCHPAD_PLUGIN_IS_LAUNCHPAD_AUTH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT))
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT, SynapseLaunchpadPluginLaunchpadAuthObjectClass))

typedef struct _SynapseLaunchpadPluginLaunchpadAuthObject SynapseLaunchpadPluginLaunchpadAuthObject;
typedef struct _SynapseLaunchpadPluginLaunchpadAuthObjectClass SynapseLaunchpadPluginLaunchpadAuthObjectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT (synapse_launchpad_plugin_launchpad_object_get_type ())
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, SynapseLaunchpadPluginLaunchpadObject))
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, SynapseLaunchpadPluginLaunchpadObjectClass))
#define SYNAPSE_LAUNCHPAD_PLUGIN_IS_LAUNCHPAD_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT))
#define SYNAPSE_LAUNCHPAD_PLUGIN_IS_LAUNCHPAD_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT))
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, SynapseLaunchpadPluginLaunchpadObjectClass))

typedef struct _SynapseLaunchpadPluginLaunchpadObject SynapseLaunchpadPluginLaunchpadObject;
typedef struct _SynapseLaunchpadPluginLaunchpadObjectClass SynapseLaunchpadPluginLaunchpadObjectClass;
typedef struct _SynapseLaunchpadPluginSearchData SynapseLaunchpadPluginSearchData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseLaunchpadPluginLaunchpadAuthObjectPrivate SynapseLaunchpadPluginLaunchpadAuthObjectPrivate;
typedef struct _SynapseLaunchpadPluginLaunchpadObjectPrivate SynapseLaunchpadPluginLaunchpadObjectPrivate;

struct _SynapseLaunchpadPlugin {
	GObject parent_instance;
	SynapseLaunchpadPluginPrivate * priv;
};

struct _SynapseLaunchpadPluginClass {
	GObjectClass parent_class;
};

struct _SynapseLaunchpadPluginPrivate {
	gboolean _enabled;
	SynapseLaunchpadPluginLaunchpadAuthObject* auth_object;
	GRegex* bug_regex;
	GRegex* branch_regex;
};

struct _SynapseLaunchpadPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseLaunchpadPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	gchar* uri;
	gchar* title;
	gchar* description;
	SynapseResultSet* _tmp0_;
	SynapseResultSet* _result_;
	gchar* _tmp1_;
	gchar* stripped;
	GMatchInfo* mi;
	GMatchInfo* _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp4_;
	gchar* branch;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** groups;
	gint groups_length1;
	gint _groups_size_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	SynapseLaunchpadPluginLaunchpadObject* _tmp28_;
	SynapseLaunchpadPluginLaunchpadObject* _tmp29_;
	GMatchInfo* _tmp30_;
	gboolean _tmp31_;
	gchar* _tmp32_;
	gchar* bug_num;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	SynapseLaunchpadPluginLaunchpadObject* _tmp39_;
	SynapseLaunchpadPluginLaunchpadObject* _tmp40_;
	GError * _inner_error_;
};

struct _SynapseLaunchpadPluginLaunchpadAuthObject {
	GObject parent_instance;
	SynapseLaunchpadPluginLaunchpadAuthObjectPrivate * priv;
};

struct _SynapseLaunchpadPluginLaunchpadAuthObjectClass {
	GObjectClass parent_class;
};

struct _SynapseLaunchpadPluginLaunchpadObject {
	GObject parent_instance;
	SynapseLaunchpadPluginLaunchpadObjectPrivate * priv;
};

struct _SynapseLaunchpadPluginLaunchpadObjectClass {
	GObjectClass parent_class;
};

struct _SynapseLaunchpadPluginLaunchpadObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gchar* _uri;
	SynapseQueryFlags _file_type;
	gchar* _mime_type;
};


static gpointer synapse_launchpad_plugin_parent_class = NULL;
static gpointer synapse_launchpad_plugin_launchpad_auth_object_parent_class = NULL;
static gpointer synapse_launchpad_plugin_launchpad_object_parent_class = NULL;
static SynapseMatchIface* synapse_launchpad_plugin_launchpad_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface* synapse_launchpad_plugin_launchpad_object_synapse_uri_match_parent_iface = NULL;
static SynapseActivatableIface* synapse_launchpad_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_launchpad_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_launchpad_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_launchpad_plugin_launchpad_auth_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_LAUNCHPAD_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, SynapseLaunchpadPluginPrivate))
enum  {
	SYNAPSE_LAUNCHPAD_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_LAUNCHPAD_PLUGIN_ENABLED
};
static void synapse_launchpad_plugin_real_activate (SynapseActivatable* base);
static void synapse_launchpad_plugin_real_deactivate (SynapseActivatable* base);
GtkWidget* synapse_launchpad_plugin_create_config_widget (SynapseLaunchpadPlugin* self);
static void synapse_launchpad_plugin_register_plugin (void);
static void _synapse_launchpad_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_launchpad_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* q);
static void synapse_launchpad_plugin_real_search_data_free (gpointer _data);
static void synapse_launchpad_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean synapse_launchpad_plugin_real_search_co (SynapseLaunchpadPluginSearchData* data);
static SynapseLaunchpadPluginLaunchpadObject* synapse_launchpad_plugin_launchpad_object_new (const gchar* title, const gchar* desc, const gchar* uri);
static SynapseLaunchpadPluginLaunchpadObject* synapse_launchpad_plugin_launchpad_object_construct (GType object_type, const gchar* title, const gchar* desc, const gchar* uri);
static GType synapse_launchpad_plugin_launchpad_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
SynapseResultSet* synapse_launchpad_plugin_find_for_match (SynapseLaunchpadPlugin* self, SynapseQuery* query, SynapseMatch* match);
SynapseLaunchpadPlugin* synapse_launchpad_plugin_new (void);
SynapseLaunchpadPlugin* synapse_launchpad_plugin_construct (GType object_type);
static GObject * synapse_launchpad_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT_DUMMY_PROPERTY
};
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT_CONSUMER_KEY "Synapse.LaunchpadPlugin"
static SynapseLaunchpadPluginLaunchpadAuthObject* synapse_launchpad_plugin_launchpad_auth_object_new (void);
static SynapseLaunchpadPluginLaunchpadAuthObject* synapse_launchpad_plugin_launchpad_auth_object_construct (GType object_type);
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, SynapseLaunchpadPluginLaunchpadObjectPrivate))
enum  {
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_TITLE,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DESCRIPTION,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_ICON_NAME,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MATCH_TYPE,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_URI,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_FILE_TYPE,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MIME_TYPE
};
static void synapse_launchpad_plugin_launchpad_object_finalize (GObject* obj);
static void _vala_synapse_launchpad_plugin_launchpad_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_launchpad_plugin_launchpad_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_launchpad_plugin_finalize (GObject* obj);
static void _vala_synapse_launchpad_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_launchpad_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void synapse_launchpad_plugin_real_activate (SynapseActivatable* base) {
	SynapseLaunchpadPlugin * self;
	self = (SynapseLaunchpadPlugin*) base;
}


static void synapse_launchpad_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseLaunchpadPlugin * self;
	SynapseLaunchpadPluginLaunchpadAuthObject* _tmp0_;
	self = (SynapseLaunchpadPlugin*) base;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->auth_object);
	self->priv->auth_object = _tmp0_;
}


GtkWidget* synapse_launchpad_plugin_create_config_widget (SynapseLaunchpadPlugin* self) {
	GtkWidget* result = NULL;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* box;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* authorize_button;
	GtkSpinner* _tmp3_ = NULL;
	GtkSpinner* spinner;
	const gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* label;
	const gchar* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkButton* proceed_button;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	box = g_object_ref_sink (_tmp0_);
	gtk_widget_show ((GtkWidget*) box);
	_tmp1_ = _ ("Authorize with Launchpad");
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_tmp1_);
	authorize_button = g_object_ref_sink (_tmp2_);
	gtk_widget_show ((GtkWidget*) authorize_button);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) authorize_button, TRUE, FALSE, (guint) 0);
	_tmp3_ = (GtkSpinner*) gtk_spinner_new ();
	spinner = g_object_ref_sink (_tmp3_);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) spinner, TRUE, TRUE, (guint) 0);
	_tmp4_ = _ ("Please press the Finish button once you login to Launchpad with your w" \
"eb browser");
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	label = g_object_ref_sink (_tmp5_);
	gtk_label_set_width_chars (label, 40);
	gtk_label_set_line_wrap (label, TRUE);
	_tmp6_ = _ ("Finish authorization");
	_tmp7_ = (GtkButton*) gtk_button_new_with_label (_tmp6_);
	proceed_button = g_object_ref_sink (_tmp7_);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) proceed_button, TRUE, FALSE, (guint) 0);
	result = (GtkWidget*) box;
	_g_object_unref0 (proceed_button);
	_g_object_unref0 (label);
	_g_object_unref0 (spinner);
	_g_object_unref0 (authorize_button);
	return result;
}


static void _synapse_launchpad_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_launchpad_plugin_register_plugin ();
}


static void synapse_launchpad_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Find bugs and branches on Launchpad.");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, "Launchpad", _tmp2_, "applications-internet", _synapse_launchpad_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}


static gboolean synapse_launchpad_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* q) {
	SynapseLaunchpadPlugin * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (SynapseLaunchpadPlugin*) base;
	if (((*q).query_type & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = ((*q).query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
	}
	result = _tmp0_;
	return result;
}


static void synapse_launchpad_plugin_real_search_data_free (gpointer _data) {
	SynapseLaunchpadPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseLaunchpadPluginSearchData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_launchpad_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseLaunchpadPlugin * self;
	SynapseLaunchpadPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseLaunchpadPlugin*) base;
	_data_ = g_slice_new0 (SynapseLaunchpadPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_launchpad_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_launchpad_plugin_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	synapse_launchpad_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_launchpad_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseLaunchpadPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean synapse_launchpad_plugin_real_search_co (SynapseLaunchpadPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->uri = NULL;
	data->title = NULL;
	data->description = NULL;
	data->_tmp0_ = NULL;
	data->_tmp0_ = synapse_result_set_new ();
	data->_result_ = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = string_strip (data->q.query_string);
	data->stripped = data->_tmp1_;
	if (g_strcmp0 (data->stripped, "") == 0) {
		data->result = NULL;
		_g_free0 (data->stripped);
		_g_object_unref0 (data->_result_);
		_g_free0 (data->description);
		_g_free0 (data->title);
		_g_free0 (data->uri);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp2_ = NULL;
	data->_tmp3_ = g_regex_match (data->self->priv->branch_regex, data->stripped, 0, &data->_tmp2_);
	_g_match_info_free0 (data->mi);
	data->mi = data->_tmp2_;
	if (data->_tmp3_) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_match_info_fetch (data->mi, 1);
		data->branch = data->_tmp4_;
		data->_tmp6_ = NULL;
		data->_tmp6_ = data->_tmp5_ = g_strsplit (data->branch, "/", 0);
		data->groups = data->_tmp6_;
		data->groups_length1 = _vala_array_length (data->_tmp5_);
		data->_groups_size_ = _vala_array_length (data->_tmp5_);
		if (data->groups_length1 == 1) {
			data->_tmp7_ = g_strconcat ("https://code.launchpad.net/", data->branch, NULL);
			_g_free0 (data->uri);
			data->uri = data->_tmp7_;
			data->_tmp8_ = NULL;
			data->_tmp8_ = _ ("Launchpad: Bazaar branches for %s");
			data->_tmp9_ = NULL;
			data->_tmp9_ = g_strdup_printf (data->_tmp8_, data->branch);
			data->_tmp10_ = data->_tmp9_;
			_g_free0 (data->title);
			data->title = data->_tmp10_;
			data->_tmp11_ = g_strdup (data->uri);
			data->_tmp12_ = data->_tmp11_;
			_g_free0 (data->description);
			data->description = data->_tmp12_;
		} else {
			if (data->groups_length1 == 2) {
				data->_tmp14_ = g_str_has_prefix (data->branch, "~");
				data->_tmp13_ = !data->_tmp14_;
			} else {
				data->_tmp13_ = FALSE;
			}
			if (data->_tmp13_) {
				data->_tmp15_ = g_strconcat ("https://code.launchpad.net/", data->branch, NULL);
				_g_free0 (data->uri);
				data->uri = data->_tmp15_;
				data->_tmp16_ = NULL;
				data->_tmp16_ = _ ("Launchpad: Series %s for Project %s");
				data->_tmp17_ = NULL;
				data->_tmp17_ = g_strdup_printf (data->_tmp16_, data->groups[1], data->groups[0]);
				data->_tmp18_ = data->_tmp17_;
				_g_free0 (data->title);
				data->title = data->_tmp18_;
				data->_tmp19_ = g_strdup (data->uri);
				data->_tmp20_ = data->_tmp19_;
				_g_free0 (data->description);
				data->description = data->_tmp20_;
			} else {
				data->_tmp21_ = g_str_has_prefix (data->branch, "~");
				if (data->_tmp21_) {
					data->_tmp22_ = g_strconcat ("https://code.launchpad.net/", data->branch, NULL);
					_g_free0 (data->uri);
					data->uri = data->_tmp22_;
					data->_tmp23_ = NULL;
					data->_tmp23_ = _ ("Launchpad: Bazaar branch %s");
					data->_tmp24_ = NULL;
					data->_tmp24_ = g_strdup_printf (data->_tmp23_, data->branch);
					data->_tmp25_ = data->_tmp24_;
					_g_free0 (data->title);
					data->title = data->_tmp25_;
					data->_tmp26_ = g_strdup (data->uri);
					data->_tmp27_ = data->_tmp26_;
					_g_free0 (data->description);
					data->description = data->_tmp27_;
				}
			}
		}
		if (data->uri != NULL) {
			data->_tmp28_ = NULL;
			data->_tmp28_ = synapse_launchpad_plugin_launchpad_object_new (data->title, data->description, data->uri);
			data->_tmp29_ = data->_tmp28_;
			synapse_result_set_add (data->_result_, (SynapseMatch*) data->_tmp29_, (gint) SYNAPSE_MATCH_SCORE_EXCELLENT);
			_g_object_unref0 (data->_tmp29_);
		}
		data->groups = (_vala_array_free (data->groups, data->groups_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->branch);
	} else {
		data->_tmp30_ = NULL;
		data->_tmp31_ = g_regex_match (data->self->priv->bug_regex, data->stripped, 0, &data->_tmp30_);
		_g_match_info_free0 (data->mi);
		data->mi = data->_tmp30_;
		if (data->_tmp31_) {
			data->_tmp32_ = NULL;
			data->_tmp32_ = g_match_info_fetch (data->mi, 1);
			data->bug_num = data->_tmp32_;
			data->_tmp33_ = g_strconcat ("https://bugs.launchpad.net/bugs/", data->bug_num, NULL);
			_g_free0 (data->uri);
			data->uri = data->_tmp33_;
			data->_tmp34_ = NULL;
			data->_tmp34_ = _ ("Launchpad: Bug #%s");
			data->_tmp35_ = NULL;
			data->_tmp35_ = g_strdup_printf (data->_tmp34_, data->bug_num);
			data->_tmp36_ = data->_tmp35_;
			_g_free0 (data->title);
			data->title = data->_tmp36_;
			data->_tmp37_ = g_strdup (data->uri);
			data->_tmp38_ = data->_tmp37_;
			_g_free0 (data->description);
			data->description = data->_tmp38_;
			data->_tmp39_ = NULL;
			data->_tmp39_ = synapse_launchpad_plugin_launchpad_object_new (data->title, data->description, data->uri);
			data->_tmp40_ = data->_tmp39_;
			synapse_result_set_add (data->_result_, (SynapseMatch*) data->_tmp40_, (gint) SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE);
			_g_object_unref0 (data->_tmp40_);
			_g_free0 (data->bug_num);
		}
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_match_info_free0 (data->mi);
			_g_free0 (data->stripped);
			_g_object_unref0 (data->_result_);
			_g_free0 (data->description);
			_g_free0 (data->title);
			_g_free0 (data->uri);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_match_info_free0 (data->mi);
			_g_free0 (data->stripped);
			_g_object_unref0 (data->_result_);
			_g_free0 (data->description);
			_g_free0 (data->title);
			_g_free0 (data->uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_result_;
	_g_match_info_free0 (data->mi);
	_g_free0 (data->stripped);
	_g_free0 (data->description);
	_g_free0 (data->title);
	_g_free0 (data->uri);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_match_info_free0 (data->mi);
	_g_free0 (data->stripped);
	_g_object_unref0 (data->_result_);
	_g_free0 (data->description);
	_g_free0 (data->title);
	_g_free0 (data->uri);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


SynapseResultSet* synapse_launchpad_plugin_find_for_match (SynapseLaunchpadPlugin* self, SynapseQuery* query, SynapseMatch* match) {
	SynapseResultSet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (match != NULL, NULL);
	result = NULL;
	return result;
}


SynapseLaunchpadPlugin* synapse_launchpad_plugin_construct (GType object_type) {
	SynapseLaunchpadPlugin * self = NULL;
	self = (SynapseLaunchpadPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseLaunchpadPlugin* synapse_launchpad_plugin_new (void) {
	return synapse_launchpad_plugin_construct (SYNAPSE_TYPE_LAUNCHPAD_PLUGIN);
}


static gboolean synapse_launchpad_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseLaunchpadPlugin* self;
	self = (SynapseLaunchpadPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_launchpad_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseLaunchpadPlugin* self;
	self = (SynapseLaunchpadPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_launchpad_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseLaunchpadPlugin * self;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GRegex* _tmp2_;
	GRegex* _tmp3_ = NULL;
	GRegex* _tmp4_;
	GRegex* _tmp5_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_launchpad_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_LAUNCHPAD_PLUGIN (obj);
	_tmp0_ = g_regex_new ("(?:bug|lp|#):?\\s*#?\\s*(\\d+)$", G_REGEX_OPTIMIZE | G_REGEX_CASELESS, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch24_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp2_ = _tmp1_;
	_g_regex_unref0 (self->priv->bug_regex);
	self->priv->bug_regex = _tmp2_;
	_tmp3_ = g_regex_new ("lp:(~?[a-z]+[+-/_a-z0-9]*)", G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch24_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp5_ = _tmp4_;
	_g_regex_unref0 (self->priv->branch_regex);
	self->priv->branch_regex = _tmp5_;
	goto __finally24;
	__catch24_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		synapse_utils_logger_warning ((GObject*) self, "Unable to construct regex: %s", err->message, NULL);
		_g_error_free0 (err);
	}
	__finally24:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static SynapseLaunchpadPluginLaunchpadAuthObject* synapse_launchpad_plugin_launchpad_auth_object_construct (GType object_type) {
	SynapseLaunchpadPluginLaunchpadAuthObject * self = NULL;
	self = (SynapseLaunchpadPluginLaunchpadAuthObject*) g_object_new (object_type, NULL);
	return self;
}


static SynapseLaunchpadPluginLaunchpadAuthObject* synapse_launchpad_plugin_launchpad_auth_object_new (void) {
	return synapse_launchpad_plugin_launchpad_auth_object_construct (SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT);
}


static void synapse_launchpad_plugin_launchpad_auth_object_class_init (SynapseLaunchpadPluginLaunchpadAuthObjectClass * klass) {
	synapse_launchpad_plugin_launchpad_auth_object_parent_class = g_type_class_peek_parent (klass);
}


static void synapse_launchpad_plugin_launchpad_auth_object_instance_init (SynapseLaunchpadPluginLaunchpadAuthObject * self) {
}


static GType synapse_launchpad_plugin_launchpad_auth_object_get_type (void) {
	static volatile gsize synapse_launchpad_plugin_launchpad_auth_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_launchpad_plugin_launchpad_auth_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLaunchpadPluginLaunchpadAuthObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_launchpad_plugin_launchpad_auth_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLaunchpadPluginLaunchpadAuthObject), 0, (GInstanceInitFunc) synapse_launchpad_plugin_launchpad_auth_object_instance_init, NULL };
		GType synapse_launchpad_plugin_launchpad_auth_object_type_id;
		synapse_launchpad_plugin_launchpad_auth_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLaunchpadPluginLaunchpadAuthObject", &g_define_type_info, 0);
		g_once_init_leave (&synapse_launchpad_plugin_launchpad_auth_object_type_id__volatile, synapse_launchpad_plugin_launchpad_auth_object_type_id);
	}
	return synapse_launchpad_plugin_launchpad_auth_object_type_id__volatile;
}


static SynapseLaunchpadPluginLaunchpadObject* synapse_launchpad_plugin_launchpad_object_construct (GType object_type, const gchar* title, const gchar* desc, const gchar* uri) {
	SynapseLaunchpadPluginLaunchpadObject * self = NULL;
	GIcon* _tmp0_ = NULL;
	GIcon* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_content_type_get_icon ("text/html");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_icon_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) g_object_new (object_type, "title", title, "description", desc, "icon-name", _tmp3_, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, "uri", uri, "mime-type", "text/html", "file-type", SYNAPSE_QUERY_FLAGS_INTERNET, NULL);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	return self;
}


static SynapseLaunchpadPluginLaunchpadObject* synapse_launchpad_plugin_launchpad_object_new (const gchar* title, const gchar* desc, const gchar* uri) {
	return synapse_launchpad_plugin_launchpad_object_construct (SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, title, desc, uri);
}


static const gchar* synapse_launchpad_plugin_launchpad_object_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_launchpad_plugin_launchpad_object_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_launchpad_plugin_launchpad_object_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_launchpad_plugin_launchpad_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_launchpad_plugin_launchpad_object_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp1_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_launchpad_plugin_launchpad_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static const gchar* synapse_launchpad_plugin_launchpad_object_real_get_uri (SynapseUriMatch* base) {
	const gchar* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_uri;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_uri (SynapseUriMatch* base, const gchar* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


static SynapseQueryFlags synapse_launchpad_plugin_launchpad_object_real_get_file_type (SynapseUriMatch* base) {
	SynapseQueryFlags result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_file_type;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_file_type (SynapseUriMatch* base, SynapseQueryFlags value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_file_type = value;
	g_object_notify ((GObject *) self, "file-type");
}


static const gchar* synapse_launchpad_plugin_launchpad_object_real_get_mime_type (SynapseUriMatch* base) {
	const gchar* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_mime_type;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_mime_type (SynapseUriMatch* base, const gchar* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


static void synapse_launchpad_plugin_launchpad_object_class_init (SynapseLaunchpadPluginLaunchpadObjectClass * klass) {
	synapse_launchpad_plugin_launchpad_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseLaunchpadPluginLaunchpadObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_launchpad_plugin_launchpad_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_launchpad_plugin_launchpad_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_launchpad_plugin_launchpad_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MIME_TYPE, "mime-type");
}


static void synapse_launchpad_plugin_launchpad_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_launchpad_plugin_launchpad_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_launchpad_plugin_launchpad_object_real_get_title;
	iface->set_title = synapse_launchpad_plugin_launchpad_object_real_set_title;
	iface->get_description = synapse_launchpad_plugin_launchpad_object_real_get_description;
	iface->set_description = synapse_launchpad_plugin_launchpad_object_real_set_description;
	iface->get_icon_name = synapse_launchpad_plugin_launchpad_object_real_get_icon_name;
	iface->set_icon_name = synapse_launchpad_plugin_launchpad_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_launchpad_plugin_launchpad_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_launchpad_plugin_launchpad_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_launchpad_plugin_launchpad_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_launchpad_plugin_launchpad_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_launchpad_plugin_launchpad_object_real_get_match_type;
	iface->set_match_type = synapse_launchpad_plugin_launchpad_object_real_set_match_type;
}


static void synapse_launchpad_plugin_launchpad_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface) {
	synapse_launchpad_plugin_launchpad_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_launchpad_plugin_launchpad_object_real_get_uri;
	iface->set_uri = synapse_launchpad_plugin_launchpad_object_real_set_uri;
	iface->get_file_type = synapse_launchpad_plugin_launchpad_object_real_get_file_type;
	iface->set_file_type = synapse_launchpad_plugin_launchpad_object_real_set_file_type;
	iface->get_mime_type = synapse_launchpad_plugin_launchpad_object_real_get_mime_type;
	iface->set_mime_type = synapse_launchpad_plugin_launchpad_object_real_set_mime_type;
}


static void synapse_launchpad_plugin_launchpad_object_instance_init (SynapseLaunchpadPluginLaunchpadObject * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
}


static void synapse_launchpad_plugin_launchpad_object_finalize (GObject* obj) {
	SynapseLaunchpadPluginLaunchpadObject * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	G_OBJECT_CLASS (synapse_launchpad_plugin_launchpad_object_parent_class)->finalize (obj);
}


static GType synapse_launchpad_plugin_launchpad_object_get_type (void) {
	static volatile gsize synapse_launchpad_plugin_launchpad_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_launchpad_plugin_launchpad_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLaunchpadPluginLaunchpadObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_launchpad_plugin_launchpad_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLaunchpadPluginLaunchpadObject), 0, (GInstanceInitFunc) synapse_launchpad_plugin_launchpad_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_launchpad_plugin_launchpad_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_launchpad_plugin_launchpad_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_launchpad_plugin_launchpad_object_type_id;
		synapse_launchpad_plugin_launchpad_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLaunchpadPluginLaunchpadObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_launchpad_plugin_launchpad_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_launchpad_plugin_launchpad_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		g_once_init_leave (&synapse_launchpad_plugin_launchpad_object_type_id__volatile, synapse_launchpad_plugin_launchpad_object_type_id);
	}
	return synapse_launchpad_plugin_launchpad_object_type_id__volatile;
}


static void _vala_synapse_launchpad_plugin_launchpad_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseLaunchpadPluginLaunchpadObject * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_URI:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_FILE_TYPE:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MIME_TYPE:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_launchpad_plugin_launchpad_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseLaunchpadPluginLaunchpadObject * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_URI:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_FILE_TYPE:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MIME_TYPE:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_launchpad_plugin_class_init (SynapseLaunchpadPluginClass * klass) {
	synapse_launchpad_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseLaunchpadPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_launchpad_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_launchpad_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_launchpad_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_launchpad_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_ENABLED, "enabled");
	synapse_launchpad_plugin_register_plugin ();
}


static void synapse_launchpad_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_launchpad_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_launchpad_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_launchpad_plugin_real_deactivate;
	iface->get_enabled = synapse_launchpad_plugin_real_get_enabled;
	iface->set_enabled = synapse_launchpad_plugin_real_set_enabled;
}


static void synapse_launchpad_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_launchpad_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*)(SynapseItemProvider* ,SynapseQuery*)) synapse_launchpad_plugin_real_handles_query;
	iface->search = (SynapseResultSet* (*)(SynapseItemProvider* ,SynapseQuery* ,GError**)) synapse_launchpad_plugin_real_search;
	iface->search_finish = synapse_launchpad_plugin_real_search_finish;
}


static void synapse_launchpad_plugin_instance_init (SynapseLaunchpadPlugin * self) {
	self->priv = SYNAPSE_LAUNCHPAD_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_launchpad_plugin_finalize (GObject* obj) {
	SynapseLaunchpadPlugin * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN (obj);
	_g_object_unref0 (self->priv->auth_object);
	_g_regex_unref0 (self->priv->bug_regex);
	_g_regex_unref0 (self->priv->branch_regex);
	G_OBJECT_CLASS (synapse_launchpad_plugin_parent_class)->finalize (obj);
}


GType synapse_launchpad_plugin_get_type (void) {
	static volatile gsize synapse_launchpad_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_launchpad_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLaunchpadPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_launchpad_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLaunchpadPlugin), 0, (GInstanceInitFunc) synapse_launchpad_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_launchpad_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_launchpad_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_launchpad_plugin_type_id;
		synapse_launchpad_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLaunchpadPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_launchpad_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_launchpad_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_launchpad_plugin_type_id__volatile, synapse_launchpad_plugin_type_id);
	}
	return synapse_launchpad_plugin_type_id__volatile;
}


static void _vala_synapse_launchpad_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseLaunchpadPlugin * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_LAUNCHPAD_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_launchpad_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseLaunchpadPlugin * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_LAUNCHPAD_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



