/* imgur-plugin.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from imgur-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rest/rest-proxy.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <json-glib/json-glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libnotify/notify.h>


#define SYNAPSE_TYPE_IMG_UR_PLUGIN (synapse_img_ur_plugin_get_type ())
#define SYNAPSE_IMG_UR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_IMG_UR_PLUGIN, SynapseImgUrPlugin))
#define SYNAPSE_IMG_UR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_IMG_UR_PLUGIN, SynapseImgUrPluginClass))
#define SYNAPSE_IS_IMG_UR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_IMG_UR_PLUGIN))
#define SYNAPSE_IS_IMG_UR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_IMG_UR_PLUGIN))
#define SYNAPSE_IMG_UR_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_IMG_UR_PLUGIN, SynapseImgUrPluginClass))

typedef struct _SynapseImgUrPlugin SynapseImgUrPlugin;
typedef struct _SynapseImgUrPluginClass SynapseImgUrPluginClass;
typedef struct _SynapseImgUrPluginPrivate SynapseImgUrPluginPrivate;

#define SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION (synapse_img_ur_plugin_img_ur_action_get_type ())
#define SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION, SynapseImgUrPluginImgUrAction))
#define SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION, SynapseImgUrPluginImgUrActionClass))
#define SYNAPSE_IMG_UR_PLUGIN_IS_IMG_UR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION))
#define SYNAPSE_IMG_UR_PLUGIN_IS_IMG_UR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION))
#define SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION, SynapseImgUrPluginImgUrActionClass))

typedef struct _SynapseImgUrPluginImgUrAction SynapseImgUrPluginImgUrAction;
typedef struct _SynapseImgUrPluginImgUrActionClass SynapseImgUrPluginImgUrActionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_TYPE_LOCATE_PLUGIN (synapse_locate_plugin_get_type ())
#define SYNAPSE_LOCATE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin))
#define SYNAPSE_LOCATE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginClass))
#define SYNAPSE_IS_LOCATE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN))
#define SYNAPSE_IS_LOCATE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_LOCATE_PLUGIN))
#define SYNAPSE_LOCATE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginClass))

typedef struct _SynapseLocatePlugin SynapseLocatePlugin;
typedef struct _SynapseLocatePluginClass SynapseLocatePluginClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseImgUrPluginImgUrActionPrivate SynapseImgUrPluginImgUrActionPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _SynapseImgUrPluginImgUrActionUploadFileData SynapseImgUrPluginImgUrActionUploadFileData;

typedef enum  {
	SYNAPSE_UPLOAD_ERROR_LIMIT_REACHED,
	SYNAPSE_UPLOAD_ERROR_UNKNOWN_ERROR
} SynapseUploadError;
#define SYNAPSE_UPLOAD_ERROR synapse_upload_error_quark ()
struct _SynapseImgUrPlugin {
	GObject parent_instance;
	SynapseImgUrPluginPrivate * priv;
};

struct _SynapseImgUrPluginClass {
	GObjectClass parent_class;
};

struct _SynapseImgUrPluginPrivate {
	gboolean _enabled;
	SynapseImgUrPluginImgUrAction* action;
};

struct _SynapseImgUrPluginImgUrAction {
	SynapseBaseAction parent_instance;
	SynapseImgUrPluginImgUrActionPrivate * priv;
};

struct _SynapseImgUrPluginImgUrActionClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseImgUrPluginImgUrActionPrivate {
	RestProxy* proxy;
};

struct _Block7Data {
	int _ref_count_;
	SynapseImgUrPluginImgUrAction * self;
	GError* err;
	gpointer _async_data_;
};

struct _SynapseImgUrPluginImgUrActionUploadFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseImgUrPluginImgUrAction* self;
	gchar* uri;
	gchar* result;
	Block7Data* _data7_;
	GFile* _tmp0_;
	GFile* f;
	GFileInputStream* _tmp1_;
	GFileInputStream* input;
	gint chunk_size;
	guint8* _tmp2_;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp3_;
	gchar* encode_buffer;
	gint encode_buffer_length1;
	gint _encode_buffer_size_;
	gsize read_bytes;
	gint state;
	gint save;
	GString* _tmp4_;
	GString* encoded;
	gssize _tmp5_;
	gssize _tmp6_;
	gsize _tmp7_;
	gsize enc_len;
	gssize _tmp8_;
	gssize _tmp9_;
	gsize _tmp10_;
	gsize enc_close;
	RestProxyCall* _tmp11_;
	RestProxyCall* call;
	GError* _tmp12_;
	const gchar* _tmp13_;
	const gchar* limit_remaining;
	const gchar* _tmp14_;
	const gchar* reset_time;
	guint _tmp15_;
	gboolean _tmp16_;
	gint _tmp17_;
	gint remaining;
	glong _tmp18_;
	glong reset;
	gboolean _tmp19_;
	GTimeVal cur_time;
	glong delta;
	glong _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError* _tmp30_;
	JsonParser* _tmp31_;
	JsonParser* parser;
	const gchar* _tmp32_;
	gint64 _tmp33_;
	JsonNode* _tmp34_;
	JsonObject* _tmp35_;
	JsonObject* node_obj;
	JsonObject* _tmp36_;
	JsonObject* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	GError* _tmp40_;
	GError * _inner_error_;
};


static gpointer synapse_img_ur_plugin_parent_class = NULL;
static gpointer synapse_img_ur_plugin_img_ur_action_parent_class = NULL;
static SynapseActivatableIface* synapse_img_ur_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface* synapse_img_ur_plugin_synapse_action_provider_parent_iface = NULL;

GQuark synapse_upload_error_quark (void);
GType synapse_img_ur_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_img_ur_plugin_img_ur_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_IMG_UR_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_IMG_UR_PLUGIN, SynapseImgUrPluginPrivate))
enum  {
	SYNAPSE_IMG_UR_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_IMG_UR_PLUGIN_ENABLED
};
static void synapse_img_ur_plugin_real_activate (SynapseActivatable* base);
static SynapseImgUrPluginImgUrAction* synapse_img_ur_plugin_img_ur_action_new (void);
static SynapseImgUrPluginImgUrAction* synapse_img_ur_plugin_img_ur_action_construct (GType object_type);
static void synapse_img_ur_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_img_ur_plugin_register_plugin (void);
GType synapse_locate_plugin_get_type (void) G_GNUC_CONST;
static void _synapse_img_ur_plugin_register_plugin_synapse_plugin_register_func (void);
static SynapseResultSet* synapse_img_ur_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* q, SynapseMatch* match);
SynapseImgUrPlugin* synapse_img_ur_plugin_new (void);
SynapseImgUrPlugin* synapse_img_ur_plugin_construct (GType object_type);
static GObject * synapse_img_ur_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION, SynapseImgUrPluginImgUrActionPrivate))
enum  {
	SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_DUMMY_PROPERTY
};
static void synapse_img_ur_plugin_img_ur_action_upload_file_data_free (gpointer _data);
static void synapse_img_ur_plugin_img_ur_action_upload_file (SynapseImgUrPluginImgUrAction* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* synapse_img_ur_plugin_img_ur_action_upload_file_finish (SynapseImgUrPluginImgUrAction* self, GAsyncResult* _res_, GError** error);
static gboolean synapse_img_ur_plugin_img_ur_action_upload_file_co (SynapseImgUrPluginImgUrActionUploadFileData* data);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void synapse_img_ur_plugin_img_ur_action_upload_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _lambda13_ (RestProxyCall* call_obj, GError* _error_, GObject* obj, Block7Data* _data7_);
static void __lambda13__rest_proxy_call_async_callback (RestProxyCall* call, GError* _error_, GObject* weak_object, gpointer self);
static void synapse_img_ur_plugin_img_ur_action_process_result (SynapseImgUrPluginImgUrAction* self, const gchar* url);
static void synapse_img_ur_plugin_img_ur_action_real_do_execute (SynapseBaseAction* base, SynapseMatch* match);
static void _lambda14_ (GObject* obj, GAsyncResult* res, SynapseImgUrPluginImgUrAction* self);
static void __lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean synapse_img_ur_plugin_img_ur_action_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match);
static GObject * synapse_img_ur_plugin_img_ur_action_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void synapse_img_ur_plugin_img_ur_action_finalize (GObject* obj);
static void synapse_img_ur_plugin_finalize (GObject* obj);
static void _vala_synapse_img_ur_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_img_ur_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark synapse_upload_error_quark (void) {
	return g_quark_from_static_string ("synapse_upload_error-quark");
}


static void synapse_img_ur_plugin_real_activate (SynapseActivatable* base) {
	SynapseImgUrPlugin * self;
	SynapseImgUrPluginImgUrAction* _tmp0_ = NULL;
	SynapseImgUrPluginImgUrAction* _tmp1_;
	self = (SynapseImgUrPlugin*) base;
	_tmp0_ = synapse_img_ur_plugin_img_ur_action_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->action);
	self->priv->action = _tmp1_;
}


static void synapse_img_ur_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseImgUrPlugin * self;
	SynapseImgUrPluginImgUrAction* _tmp0_;
	self = (SynapseImgUrPlugin*) base;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->action);
	self->priv->action = _tmp0_;
}


static void _synapse_img_ur_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_img_ur_plugin_register_plugin ();
}


static void synapse_img_ur_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Imgur");
	_tmp3_ = _ ("Share images using imgur.");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_LOCATE_PLUGIN, _tmp2_, _tmp3_, "document-send", _synapse_img_ur_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static SynapseResultSet* synapse_img_ur_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* q, SynapseMatch* match) {
	SynapseImgUrPlugin * self;
	SynapseResultSet* result = NULL;
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean query_empty;
	SynapseResultSet* _tmp3_ = NULL;
	SynapseResultSet* results;
	self = (SynapseImgUrPlugin*) base;
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = synapse_base_action_valid_for_match ((SynapseBaseAction*) self->priv->action, match);
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = string_strip ((*q).query_string);
	_tmp2_ = _tmp1_;
	_g_free0 ((*q).query_string);
	(*q).query_string = _tmp2_;
	query_empty = g_strcmp0 ((*q).query_string, "") == 0;
	_tmp3_ = synapse_result_set_new ();
	results = _tmp3_;
	if (query_empty) {
		gint _tmp4_;
		_tmp4_ = synapse_base_action_get_default_relevancy ((SynapseBaseAction*) self->priv->action);
		synapse_result_set_add (results, (SynapseMatch*) self->priv->action, _tmp4_);
	} else {
		GeeList* _tmp5_ = NULL;
		GeeList* matchers;
		_tmp5_ = synapse_query_get_matchers_for_query ((*q).query_string, 0, G_REGEX_CASELESS);
		matchers = _tmp5_;
		{
			GeeList* _tmp6_;
			GeeList* _matcher_list;
			gint _tmp7_;
			gint _matcher_size;
			gint _matcher_index;
			_tmp6_ = _g_object_ref0 (matchers);
			_matcher_list = _tmp6_;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _matcher_list);
			_matcher_size = _tmp7_;
			_matcher_index = -1;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				GeeMapEntry* matcher;
				gconstpointer _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp11_;
				_matcher_index = _matcher_index + 1;
				if (!(_matcher_index < _matcher_size)) {
					break;
				}
				_tmp8_ = gee_list_get (_matcher_list, _matcher_index);
				matcher = (GeeMapEntry*) _tmp8_;
				_tmp9_ = gee_map_entry_get_key (matcher);
				_tmp10_ = synapse_match_get_title ((SynapseMatch*) self->priv->action);
				_tmp11_ = g_regex_match ((GRegex*) _tmp9_, _tmp10_, 0, NULL);
				if (_tmp11_) {
					gconstpointer _tmp12_ = NULL;
					_tmp12_ = gee_map_entry_get_value (matcher);
					synapse_result_set_add (results, (SynapseMatch*) self->priv->action, GPOINTER_TO_INT (_tmp12_));
					_g_object_unref0 (matcher);
					break;
				}
				_g_object_unref0 (matcher);
			}
			_g_object_unref0 (_matcher_list);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


SynapseImgUrPlugin* synapse_img_ur_plugin_construct (GType object_type) {
	SynapseImgUrPlugin * self = NULL;
	self = (SynapseImgUrPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseImgUrPlugin* synapse_img_ur_plugin_new (void) {
	return synapse_img_ur_plugin_construct (SYNAPSE_TYPE_IMG_UR_PLUGIN);
}


static gboolean synapse_img_ur_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseImgUrPlugin* self;
	self = (SynapseImgUrPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_img_ur_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseImgUrPlugin* self;
	self = (SynapseImgUrPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_img_ur_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseImgUrPlugin * self;
	parent_class = G_OBJECT_CLASS (synapse_img_ur_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_IMG_UR_PLUGIN (obj);
	return obj;
}


static SynapseImgUrPluginImgUrAction* synapse_img_ur_plugin_img_ur_action_construct (GType object_type) {
	SynapseImgUrPluginImgUrAction * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Upload to imgur");
	_tmp1_ = _ ("Upload selection to imgur image sharer");
	self = (SynapseImgUrPluginImgUrAction*) g_object_new (object_type, "title", _tmp0_, "description", _tmp1_, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "icon-name", "document-send", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, NULL);
	return self;
}


static SynapseImgUrPluginImgUrAction* synapse_img_ur_plugin_img_ur_action_new (void) {
	return synapse_img_ur_plugin_img_ur_action_construct (SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION);
}


static void synapse_img_ur_plugin_img_ur_action_upload_file_data_free (gpointer _data) {
	SynapseImgUrPluginImgUrActionUploadFileData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_free0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseImgUrPluginImgUrActionUploadFileData, data);
}


static void synapse_img_ur_plugin_img_ur_action_upload_file (SynapseImgUrPluginImgUrAction* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseImgUrPluginImgUrActionUploadFileData* _data_;
	_data_ = g_slice_new0 (SynapseImgUrPluginImgUrActionUploadFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_img_ur_plugin_img_ur_action_upload_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_img_ur_plugin_img_ur_action_upload_file_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	synapse_img_ur_plugin_img_ur_action_upload_file_co (_data_);
}


static gchar* synapse_img_ur_plugin_img_ur_action_upload_file_finish (SynapseImgUrPluginImgUrAction* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	SynapseImgUrPluginImgUrActionUploadFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_error_free0 (_data7_->err);
		g_slice_free (Block7Data, _data7_);
	}
}


static void synapse_img_ur_plugin_img_ur_action_upload_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseImgUrPluginImgUrActionUploadFileData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_img_ur_plugin_img_ur_action_upload_file_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _lambda13_ (RestProxyCall* call_obj, GError* _error_, GObject* obj, Block7Data* _data7_) {
	SynapseImgUrPluginImgUrAction * self;
	GError* _tmp0_;
	GError* _tmp1_;
	self = _data7_->self;
	g_return_if_fail (call_obj != NULL);
	_tmp0_ = _g_error_copy0 (_error_);
	_tmp1_ = _tmp0_;
	_g_error_free0 (_data7_->err);
	_data7_->err = _tmp1_;
	synapse_img_ur_plugin_img_ur_action_upload_file_co (_data7_->_async_data_);
}


static void __lambda13__rest_proxy_call_async_callback (RestProxyCall* call, GError* _error_, GObject* weak_object, gpointer self) {
	_lambda13_ (call, _error_, weak_object, self);
}


static gboolean synapse_img_ur_plugin_img_ur_action_upload_file_co (SynapseImgUrPluginImgUrActionUploadFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data7_ = g_slice_new0 (Block7Data);
	data->_data7_->_ref_count_ = 1;
	data->_data7_->self = g_object_ref (data->self);
	data->_data7_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_new_for_uri (data->uri);
	data->f = data->_tmp0_;
	data->_state_ = 1;
	g_file_read_async (data->f, G_PRIORITY_DEFAULT, NULL, synapse_img_ur_plugin_img_ur_action_upload_file_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_read_finish (data->f, data->_res_, &data->_inner_error_);
	data->input = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->f);
		block7_data_unref (data->_data7_);
		data->_data7_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->chunk_size = 128 * 1024;
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_new0 (guint8, data->chunk_size);
	data->buffer = data->_tmp2_;
	data->buffer_length1 = data->chunk_size;
	data->_buffer_size_ = data->chunk_size;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_new0 (gchar, (((data->chunk_size / 3) + 1) * 4) + 4);
	data->encode_buffer = data->_tmp3_;
	data->encode_buffer_length1 = (((data->chunk_size / 3) + 1) * 4) + 4;
	data->_encode_buffer_size_ = (((data->chunk_size / 3) + 1) * 4) + 4;
	data->state = 0;
	data->save = 0;
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_string_new ("");
	data->encoded = data->_tmp4_;
	data->_state_ = 2;
	g_input_stream_read_async ((GInputStream*) data->input, data->buffer, (gsize) data->buffer_length1, G_PRIORITY_DEFAULT, NULL, synapse_img_ur_plugin_img_ur_action_upload_file_ready, data);
	return FALSE;
	_state_2:
	data->_tmp5_ = g_input_stream_read_finish ((GInputStream*) data->input, data->_res_, &data->_inner_error_);
	data->_tmp6_ = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_string_free0 (data->encoded);
		data->encode_buffer = (g_free (data->encode_buffer), NULL);
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->input);
		_g_object_unref0 (data->f);
		block7_data_unref (data->_data7_);
		data->_data7_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->read_bytes = (gsize) data->_tmp6_;
	while (TRUE) {
		if (!(data->read_bytes != 0)) {
			break;
		}
		data->buffer_length1 = (gint) data->read_bytes;
		data->_tmp7_ = g_base64_encode_step ((guchar*) data->buffer, data->buffer_length1, FALSE, data->encode_buffer, &data->state, &data->save);
		data->enc_len = data->_tmp7_;
		g_string_append_len (data->encoded, (const gchar*) data->encode_buffer, (gssize) data->enc_len);
		data->_state_ = 3;
		g_input_stream_read_async ((GInputStream*) data->input, data->buffer, (gsize) data->buffer_length1, G_PRIORITY_DEFAULT, NULL, synapse_img_ur_plugin_img_ur_action_upload_file_ready, data);
		return FALSE;
		_state_3:
		data->_tmp8_ = g_input_stream_read_finish ((GInputStream*) data->input, data->_res_, &data->_inner_error_);
		data->_tmp9_ = data->_tmp8_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_string_free0 (data->encoded);
			data->encode_buffer = (g_free (data->encode_buffer), NULL);
			data->buffer = (g_free (data->buffer), NULL);
			_g_object_unref0 (data->input);
			_g_object_unref0 (data->f);
			block7_data_unref (data->_data7_);
			data->_data7_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->read_bytes = (gsize) data->_tmp9_;
	}
	data->_tmp10_ = g_base64_encode_close (FALSE, data->encode_buffer, &data->state, &data->save);
	data->enc_close = data->_tmp10_;
	g_string_append_len (data->encoded, (const gchar*) data->encode_buffer, (gssize) data->enc_close);
	data->_tmp11_ = NULL;
	data->_tmp11_ = rest_proxy_new_call (data->self->priv->proxy);
	data->call = data->_tmp11_;
	rest_proxy_call_set_method (data->call, "POST");
	rest_proxy_call_set_function (data->call, "upload.json");
	rest_proxy_call_add_param (data->call, "key", "ae208d46a27310d4758e462a05c7f12e");
	rest_proxy_call_add_param (data->call, "image", data->encoded->str);
	data->_data7_->err = NULL;
	rest_proxy_call_async (data->call, __lambda13__rest_proxy_call_async_callback, (GObject*) data->self, data->_data7_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->call);
		_g_string_free0 (data->encoded);
		data->encode_buffer = (g_free (data->encode_buffer), NULL);
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->input);
		_g_object_unref0 (data->f);
		block7_data_unref (data->_data7_);
		data->_data7_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 4;
	return FALSE;
	_state_4:
	;
	if (data->_data7_->err != NULL) {
		data->_tmp12_ = _g_error_copy0 (data->_data7_->err);
		data->_inner_error_ = data->_tmp12_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->call);
		_g_string_free0 (data->encoded);
		data->encode_buffer = (g_free (data->encode_buffer), NULL);
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->input);
		_g_object_unref0 (data->f);
		block7_data_unref (data->_data7_);
		data->_data7_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp13_ = NULL;
	data->_tmp13_ = rest_proxy_call_lookup_response_header (data->call, "X-RateLimit-Remaining");
	data->limit_remaining = data->_tmp13_;
	data->_tmp14_ = NULL;
	data->_tmp14_ = rest_proxy_call_lookup_response_header (data->call, "X-RateLimit-Reset");
	data->reset_time = data->_tmp14_;
	data->_tmp15_ = rest_proxy_call_get_status_code (data->call);
	if (data->_tmp15_ != 200) {
		if (data->limit_remaining != NULL) {
			data->_tmp16_ = data->reset_time != NULL;
		} else {
			data->_tmp16_ = FALSE;
		}
		if (data->_tmp16_) {
			data->_tmp17_ = atoi (data->limit_remaining);
			data->remaining = data->_tmp17_;
			data->_tmp18_ = strtol (data->reset_time, NULL, 0);
			data->reset = data->_tmp18_;
			if (data->remaining < 10) {
				data->_tmp19_ = data->reset > 0;
			} else {
				data->_tmp19_ = FALSE;
			}
			if (data->_tmp19_) {
				g_get_current_time (&data->cur_time);
				data->delta = (data->reset - data->cur_time.tv_sec) / 60;
				data->_tmp20_ = MAX ((glong) 1, data->delta);
				data->delta = data->_tmp20_;
				data->_tmp21_ = NULL;
				data->_tmp21_ = g_strdup_printf ("%li", data->delta);
				data->_tmp22_ = data->_tmp21_;
				data->_tmp23_ = NULL;
				data->_tmp23_ = g_strconcat ("Upload limit reached, reset in ", data->_tmp22_, " minutes", NULL);
				data->_tmp24_ = data->_tmp23_;
				data->_tmp25_ = NULL;
				data->_tmp25_ = g_error_new_literal (SYNAPSE_UPLOAD_ERROR, SYNAPSE_UPLOAD_ERROR_LIMIT_REACHED, data->_tmp24_);
				data->_inner_error_ = (data->_tmp26_ = data->_tmp25_, _g_free0 (data->_tmp24_), _g_free0 (data->_tmp22_), data->_tmp26_);
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->call);
				_g_string_free0 (data->encoded);
				data->encode_buffer = (g_free (data->encode_buffer), NULL);
				data->buffer = (g_free (data->buffer), NULL);
				_g_object_unref0 (data->input);
				_g_object_unref0 (data->f);
				block7_data_unref (data->_data7_);
				data->_data7_ = NULL;
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				data->_tmp27_ = NULL;
				data->_tmp27_ = rest_proxy_call_get_status_message (data->call);
				data->_tmp28_ = NULL;
				data->_tmp28_ = g_error_new_literal (SYNAPSE_UPLOAD_ERROR, SYNAPSE_UPLOAD_ERROR_UNKNOWN_ERROR, data->_tmp27_);
				data->_inner_error_ = data->_tmp28_;
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->call);
				_g_string_free0 (data->encoded);
				data->encode_buffer = (g_free (data->encode_buffer), NULL);
				data->buffer = (g_free (data->buffer), NULL);
				_g_object_unref0 (data->input);
				_g_object_unref0 (data->f);
				block7_data_unref (data->_data7_);
				data->_data7_ = NULL;
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->_tmp29_ = NULL;
			data->_tmp29_ = rest_proxy_call_get_status_message (data->call);
			data->_tmp30_ = NULL;
			data->_tmp30_ = g_error_new_literal (SYNAPSE_UPLOAD_ERROR, SYNAPSE_UPLOAD_ERROR_UNKNOWN_ERROR, data->_tmp29_);
			data->_inner_error_ = data->_tmp30_;
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->call);
			_g_string_free0 (data->encoded);
			data->encode_buffer = (g_free (data->encode_buffer), NULL);
			data->buffer = (g_free (data->buffer), NULL);
			_g_object_unref0 (data->input);
			_g_object_unref0 (data->f);
			block7_data_unref (data->_data7_);
			data->_data7_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_tmp31_ = NULL;
	data->_tmp31_ = json_parser_new ();
	data->parser = data->_tmp31_;
	data->_tmp32_ = NULL;
	data->_tmp32_ = rest_proxy_call_get_payload (data->call);
	data->_tmp33_ = rest_proxy_call_get_payload_length (data->call);
	json_parser_load_from_data (data->parser, data->_tmp32_, (gssize) data->_tmp33_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->parser);
		_g_object_unref0 (data->call);
		_g_string_free0 (data->encoded);
		data->encode_buffer = (g_free (data->encode_buffer), NULL);
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->input);
		_g_object_unref0 (data->f);
		block7_data_unref (data->_data7_);
		data->_data7_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp34_ = NULL;
	data->_tmp34_ = json_parser_get_root (data->parser);
	data->_tmp35_ = NULL;
	data->_tmp35_ = json_node_get_object (data->_tmp34_);
	data->node_obj = data->_tmp35_;
	if (data->node_obj != NULL) {
		data->_tmp36_ = NULL;
		data->_tmp36_ = json_object_get_object_member (data->node_obj, "upload");
		data->node_obj = data->_tmp36_;
		if (data->node_obj != NULL) {
			data->_tmp37_ = NULL;
			data->_tmp37_ = json_object_get_object_member (data->node_obj, "links");
			data->node_obj = data->_tmp37_;
			if (data->node_obj != NULL) {
				data->_tmp38_ = NULL;
				data->_tmp38_ = json_object_get_string_member (data->node_obj, "imgur_page");
				data->_tmp39_ = g_strdup (data->_tmp38_);
				data->result = data->_tmp39_;
				_g_object_unref0 (data->parser);
				_g_object_unref0 (data->call);
				_g_string_free0 (data->encoded);
				data->encode_buffer = (g_free (data->encode_buffer), NULL);
				data->buffer = (g_free (data->buffer), NULL);
				_g_object_unref0 (data->input);
				_g_object_unref0 (data->f);
				block7_data_unref (data->_data7_);
				data->_data7_ = NULL;
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	data->_tmp40_ = NULL;
	data->_tmp40_ = g_error_new_literal (SYNAPSE_UPLOAD_ERROR, SYNAPSE_UPLOAD_ERROR_UNKNOWN_ERROR, "Unable to parse result");
	data->_inner_error_ = data->_tmp40_;
	g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
	g_error_free (data->_inner_error_);
	_g_object_unref0 (data->parser);
	_g_object_unref0 (data->call);
	_g_string_free0 (data->encoded);
	data->encode_buffer = (g_free (data->encode_buffer), NULL);
	data->buffer = (g_free (data->buffer), NULL);
	_g_object_unref0 (data->input);
	_g_object_unref0 (data->f);
	block7_data_unref (data->_data7_);
	data->_data7_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->parser);
	_g_object_unref0 (data->call);
	_g_string_free0 (data->encoded);
	data->encode_buffer = (g_free (data->encode_buffer), NULL);
	data->buffer = (g_free (data->buffer), NULL);
	_g_object_unref0 (data->input);
	_g_object_unref0 (data->f);
	block7_data_unref (data->_data7_);
	data->_data7_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_img_ur_plugin_img_ur_action_process_result (SynapseImgUrPluginImgUrAction* self, const gchar* url) {
	gchar* msg = NULL;
	const gchar* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_;
	GObject* _tmp11_;
	NotifyNotification* notification;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (url != NULL) {
		GtkClipboard* _tmp0_ = NULL;
		GtkClipboard* _tmp1_;
		GtkClipboard* cb;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = gtk_clipboard_get (GDK_NONE);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		cb = _tmp1_;
		gtk_clipboard_set_text (cb, url, -1);
		_tmp2_ = _ ("The selection was successfully uploaded and its URL was copied to clip" \
"board.");
		_tmp3_ = g_strdup (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (msg);
		msg = _tmp4_;
		_g_object_unref0 (cb);
	} else {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = _ ("An error occurred during upload, please check the log for more informa" \
"tion.");
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (msg);
		msg = _tmp7_;
	}
	_tmp8_ = _ ("Synapse - Imgur");
	_tmp9_ = g_object_new (NOTIFY_TYPE_NOTIFICATION, "summary", _tmp8_, "body", msg, "icon-name", "synapse", NULL, NULL);
	notification = (_tmp11_ = (_tmp10_ = _tmp9_, G_IS_INITIALLY_UNOWNED (_tmp10_) ? g_object_ref_sink (_tmp10_) : _tmp10_), NOTIFY_IS_NOTIFICATION (_tmp11_) ? ((NotifyNotification*) _tmp11_) : NULL);
	notify_notification_set_timeout (notification, 10);
	notify_notification_show (notification, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (notification);
		goto __catch52_g_error;
	}
	_g_object_unref0 (notification);
	goto __finally52;
	__catch52_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
		_g_error_free0 (err);
	}
	__finally52:
	if (_inner_error_ != NULL) {
		_g_free0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (msg);
}


static void _lambda14_ (GObject* obj, GAsyncResult* res, SynapseImgUrPluginImgUrAction* self) {
	gchar* url;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	url = NULL;
	_tmp0_ = synapse_img_ur_plugin_img_ur_action_upload_file_finish (self, res, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch53_g_error;
	}
	_tmp2_ = _tmp1_;
	_g_free0 (url);
	url = _tmp2_;
	synapse_utils_logger_log ((GObject*) self, "%s", url, NULL);
	goto __finally53;
	__catch53_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
		_g_error_free0 (err);
	}
	__finally53:
	if (_inner_error_ != NULL) {
		_g_free0 (url);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	synapse_img_ur_plugin_img_ur_action_process_result (self, url);
	_g_free0 (url);
}


static void __lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda14_ (source_object, res, self);
	g_object_unref (self);
}


static void synapse_img_ur_plugin_img_ur_action_real_do_execute (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseImgUrPluginImgUrAction * self;
	gboolean _tmp0_ = FALSE;
	SynapseMatchType _tmp1_;
	self = (SynapseImgUrPluginImgUrAction*) base;
	_tmp1_ = synapse_match_get_match_type (match);
	if (_tmp1_ == SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		_tmp0_ = SYNAPSE_IS_URI_MATCH (match);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SynapseMatch* _tmp2_;
		SynapseUriMatch* _tmp3_;
		SynapseUriMatch* uri_match;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = _g_object_ref0 ((_tmp2_ = match, SYNAPSE_IS_URI_MATCH (_tmp2_) ? ((SynapseUriMatch*) _tmp2_) : NULL));
		uri_match = _tmp3_;
		_tmp4_ = synapse_uri_match_get_uri (uri_match);
		synapse_img_ur_plugin_img_ur_action_upload_file (self, _tmp4_, __lambda14__gasync_ready_callback, g_object_ref (self));
		_g_object_unref0 (uri_match);
	}
}


static gboolean synapse_img_ur_plugin_img_ur_action_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseImgUrPluginImgUrAction * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	self = (SynapseImgUrPluginImgUrAction*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	switch (_tmp0_) {
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
		{
			SynapseMatch* _tmp1_;
			SynapseUriMatch* _tmp2_;
			SynapseUriMatch* um;
			const gchar* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GFile* f;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gboolean _tmp7_;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_;
			_tmp2_ = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_URI_MATCH (_tmp1_) ? ((SynapseUriMatch*) _tmp1_) : NULL));
			um = _tmp2_;
			_tmp3_ = synapse_uri_match_get_uri (um);
			_tmp4_ = g_file_new_for_uri (_tmp3_);
			f = _tmp4_;
			_tmp5_ = g_file_get_path (f);
			_tmp6_ = _tmp5_;
			if ((_tmp7_ = _tmp6_ == NULL, _g_free0 (_tmp6_), _tmp7_)) {
				result = FALSE;
				_g_object_unref0 (f);
				_g_object_unref0 (um);
				return result;
			}
			_tmp8_ = synapse_uri_match_get_mime_type (um);
			_tmp9_ = g_content_type_is_a (_tmp8_, "image/*");
			result = _tmp9_;
			_g_object_unref0 (f);
			_g_object_unref0 (um);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static GObject * synapse_img_ur_plugin_img_ur_action_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseImgUrPluginImgUrAction * self;
	RestProxy* _tmp0_ = NULL;
	RestProxy* _tmp1_;
	parent_class = G_OBJECT_CLASS (synapse_img_ur_plugin_img_ur_action_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION (obj);
	_tmp0_ = rest_proxy_new ("http://api.imgur.com/2/", FALSE);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp1_;
	return obj;
}


static void synapse_img_ur_plugin_img_ur_action_class_init (SynapseImgUrPluginImgUrActionClass * klass) {
	synapse_img_ur_plugin_img_ur_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseImgUrPluginImgUrActionPrivate));
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_img_ur_plugin_img_ur_action_real_do_execute;
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_img_ur_plugin_img_ur_action_real_valid_for_match;
	G_OBJECT_CLASS (klass)->constructor = synapse_img_ur_plugin_img_ur_action_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_img_ur_plugin_img_ur_action_finalize;
}


static void synapse_img_ur_plugin_img_ur_action_instance_init (SynapseImgUrPluginImgUrAction * self) {
	self->priv = SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_GET_PRIVATE (self);
}


static void synapse_img_ur_plugin_img_ur_action_finalize (GObject* obj) {
	SynapseImgUrPluginImgUrAction * self;
	self = SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION (obj);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (synapse_img_ur_plugin_img_ur_action_parent_class)->finalize (obj);
}


static GType synapse_img_ur_plugin_img_ur_action_get_type (void) {
	static volatile gsize synapse_img_ur_plugin_img_ur_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_img_ur_plugin_img_ur_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseImgUrPluginImgUrActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_img_ur_plugin_img_ur_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseImgUrPluginImgUrAction), 0, (GInstanceInitFunc) synapse_img_ur_plugin_img_ur_action_instance_init, NULL };
		GType synapse_img_ur_plugin_img_ur_action_type_id;
		synapse_img_ur_plugin_img_ur_action_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseImgUrPluginImgUrAction", &g_define_type_info, 0);
		g_once_init_leave (&synapse_img_ur_plugin_img_ur_action_type_id__volatile, synapse_img_ur_plugin_img_ur_action_type_id);
	}
	return synapse_img_ur_plugin_img_ur_action_type_id__volatile;
}


static void synapse_img_ur_plugin_class_init (SynapseImgUrPluginClass * klass) {
	synapse_img_ur_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseImgUrPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_img_ur_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_img_ur_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_img_ur_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_img_ur_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_IMG_UR_PLUGIN_ENABLED, "enabled");
	synapse_img_ur_plugin_register_plugin ();
}


static void synapse_img_ur_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_img_ur_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_img_ur_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_img_ur_plugin_real_deactivate;
	iface->get_enabled = synapse_img_ur_plugin_real_get_enabled;
	iface->set_enabled = synapse_img_ur_plugin_real_set_enabled;
}


static void synapse_img_ur_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface) {
	synapse_img_ur_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_for_match = (SynapseResultSet* (*)(SynapseActionProvider* ,SynapseQuery* ,SynapseMatch*)) synapse_img_ur_plugin_real_find_for_match;
}


static void synapse_img_ur_plugin_instance_init (SynapseImgUrPlugin * self) {
	self->priv = SYNAPSE_IMG_UR_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_img_ur_plugin_finalize (GObject* obj) {
	SynapseImgUrPlugin * self;
	self = SYNAPSE_IMG_UR_PLUGIN (obj);
	_g_object_unref0 (self->priv->action);
	G_OBJECT_CLASS (synapse_img_ur_plugin_parent_class)->finalize (obj);
}


GType synapse_img_ur_plugin_get_type (void) {
	static volatile gsize synapse_img_ur_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_img_ur_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseImgUrPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_img_ur_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseImgUrPlugin), 0, (GInstanceInitFunc) synapse_img_ur_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_img_ur_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_img_ur_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_img_ur_plugin_type_id;
		synapse_img_ur_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseImgUrPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_img_ur_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_img_ur_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		g_once_init_leave (&synapse_img_ur_plugin_type_id__volatile, synapse_img_ur_plugin_type_id);
	}
	return synapse_img_ur_plugin_type_id__volatile;
}


static void _vala_synapse_img_ur_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseImgUrPlugin * self;
	self = SYNAPSE_IMG_UR_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_IMG_UR_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_img_ur_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseImgUrPlugin * self;
	self = SYNAPSE_IMG_UR_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_IMG_UR_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



