/* hybrid-search-plugin.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from hybrid-search-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */
/* 
 * This plugin keeps a cache of file names for directories that are commonly
 * used. 
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN (synapse_hybrid_search_plugin_get_type ())
#define SYNAPSE_HYBRID_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPlugin))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPluginClass))
#define SYNAPSE_IS_HYBRID_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN))
#define SYNAPSE_IS_HYBRID_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPluginClass))

typedef struct _SynapseHybridSearchPlugin SynapseHybridSearchPlugin;
typedef struct _SynapseHybridSearchPluginClass SynapseHybridSearchPluginClass;
typedef struct _SynapseHybridSearchPluginPrivate SynapseHybridSearchPluginPrivate;

#define SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO (synapse_hybrid_search_plugin_directory_info_get_type ())
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfo))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfoClass))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfoClass))

typedef struct _SynapseHybridSearchPluginDirectoryInfo SynapseHybridSearchPluginDirectoryInfo;
typedef struct _SynapseHybridSearchPluginDirectoryInfoClass SynapseHybridSearchPluginDirectoryInfoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bookmark_file_free0(var) ((var == NULL) ? NULL : (var = (g_bookmark_file_free (var), NULL)))
typedef struct _SynapseHybridSearchPluginDirectoryInfoPrivate SynapseHybridSearchPluginDirectoryInfoPrivate;
typedef struct _SynapseHybridSearchPluginAnalyzeRecentDocumentsData SynapseHybridSearchPluginAnalyzeRecentDocumentsData;
typedef struct _SynapseHybridSearchPluginProcessUrisData SynapseHybridSearchPluginProcessUrisData;

#define SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT (synapse_hybrid_search_plugin_match_object_get_type ())
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, SynapseHybridSearchPluginMatchObject))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, SynapseHybridSearchPluginMatchObjectClass))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, SynapseHybridSearchPluginMatchObjectClass))

typedef struct _SynapseHybridSearchPluginMatchObject SynapseHybridSearchPluginMatchObject;
typedef struct _SynapseHybridSearchPluginMatchObjectClass SynapseHybridSearchPluginMatchObjectClass;
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
#define _synapse_hybrid_search_plugin_directory_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_hybrid_search_plugin_directory_info_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _SynapseHybridSearchPluginUpdateDirectoryContentsData SynapseHybridSearchPluginUpdateDirectoryContentsData;
typedef struct _SynapseHybridSearchPluginProcessDirectoriesData SynapseHybridSearchPluginProcessDirectoriesData;
typedef struct _SynapseHybridSearchPluginGetExtraResultsData SynapseHybridSearchPluginGetExtraResultsData;
typedef struct _Block3Data Block3Data;
typedef struct _SynapseHybridSearchPluginSearchData SynapseHybridSearchPluginSearchData;
typedef struct _SynapseHybridSearchPluginMatchObjectPrivate SynapseHybridSearchPluginMatchObjectPrivate;
typedef struct _SynapseHybridSearchPluginParamSpecDirectoryInfo SynapseHybridSearchPluginParamSpecDirectoryInfo;

struct _SynapseHybridSearchPlugin {
	GObject parent_instance;
	SynapseHybridSearchPluginPrivate * priv;
};

struct _SynapseHybridSearchPluginClass {
	GObjectClass parent_class;
};

struct _SynapseHybridSearchPluginPrivate {
	SynapseDataSink* _data_sink;
	gboolean _enabled;
	gboolean connected_to_zg;
	gboolean initialization_done;
	GeeMap* directory_hits;
	gint hit_level;
	gint current_level_uris;
	GeeMap* directory_contents;
	gchar* current_query;
};

struct _SynapseHybridSearchPluginDirectoryInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseHybridSearchPluginDirectoryInfoPrivate * priv;
	gchar* path;
	GTimeVal last_update;
	GeeMap* files;
};

struct _SynapseHybridSearchPluginDirectoryInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseHybridSearchPluginDirectoryInfo *self);
};

struct _SynapseHybridSearchPluginAnalyzeRecentDocumentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* recent;
	gchar* contents;
	gsize len;
	gboolean load_ok;
	gchar* _tmp5_;
	gsize _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GError * load_error;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gsize _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GBookmarkFile* _tmp18_;
	GBookmarkFile* bf;
	gint _tmp19_;
	gchar** _tmp20_;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	GeeHashMap* _tmp21_;
	GeeMap* dir_hits;
	gchar** uri_collection;
	int uri_collection_length1;
	int uri_it;
	const gchar* uri;
	GFile* _tmp22_;
	GFile* f;
	GFile* _tmp23_;
	GFile* parent;
	gchar* _tmp24_;
	gchar* parent_path;
	gpointer _tmp25_;
	GeeArrayList* _tmp26_;
	GeeList* sorted_dirs;
	GeeSet* _tmp27_;
	GeeSet* _tmp28_;
	GeeArrayList* _tmp29_;
	GeeList* directories;
	gint i;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gpointer _tmp34_;
	GeeMapEntry* _tmp35_;
	gconstpointer _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* dir_path;
	gboolean _tmp39_;
	GFile* _tmp40_;
	GFile* dir_f;
	gboolean _tmp41_;
	gboolean exists;
	gboolean _tmp42_;
	gint z;
	GeeSet* _tmp43_;
	GeeSet* _tmp44_;
	GeeIterator* _tmp45_;
	GeeIterator* _tmp46_;
	GeeIterator* _x_it;
	gboolean _tmp47_;
	gpointer _tmp48_;
	GeeMapEntry* x;
	gconstpointer _tmp49_;
	gint _tmp50_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginProcessUrisData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	GeeCollection* uris;
	GeeHashSet* _tmp0_;
	GeeSet* dirs;
	GeeIterator* _tmp1_;
	GeeIterator* _uri_it;
	gboolean _tmp2_;
	gpointer _tmp3_;
	gchar* uri;
	GFile* _tmp4_;
	GFile* f;
	gboolean _tmp5_;
	GFileInfo* _tmp6_;
	GFileInfo* fi;
	GFileType _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* parent_path;
	GError * err;
	gint _tmp12_;
	gint _tmp13_;
	gint q_len;
	GeeIterator* _tmp14_;
	GeeIterator* _dir_it;
	gboolean _tmp15_;
	gpointer _tmp16_;
	gchar* dir;
	gboolean _tmp17_;
	gpointer _tmp18_;
	gint hit_count;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginUpdateDirectoryContentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	GFile* directory;
	SynapseHybridSearchPluginDirectoryInfo* di;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFileEnumerator* _tmp2_;
	GFileEnumerator* enumerator;
	GList* _tmp3_;
	GList* files;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginProcessDirectoriesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	GeeCollection* directories;
	GeeIterator* _tmp0_;
	GeeIterator* _dir_path_it;
	gboolean _tmp1_;
	gpointer _tmp2_;
	gchar* dir_path;
	GFile* _tmp3_;
	GFile* directory;
	SynapseHybridSearchPluginDirectoryInfo* di;
	gboolean _tmp4_;
	GTimeVal cur_time;
	gpointer _tmp5_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp6_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp7_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp8_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginGetExtraResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	SynapseQuery q;
	SynapseResultSet* original_rs;
	GeeCollection* dirs;
	SynapseResultSet* result;
	guint num_results;
	gboolean enough_results;
	SynapseResultSet* _tmp0_;
	SynapseResultSet* results;
	GRegexCompileFlags flags;
	GeeList* _tmp1_;
	GeeList* matchers;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeSet* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* directories;
	GeeIterator* _tmp7_;
	GeeIterator* _directory_it;
	gboolean _tmp8_;
	gpointer _tmp9_;
	gchar* directory;
	gpointer _tmp10_;
	SynapseHybridSearchPluginDirectoryInfo* di;
	GFile* _tmp11_;
	GFile* dir;
	GFileInfo* _tmp12_;
	GFileInfo* dir_info;
	GTimeVal t;
	GTimeVal _tmp13_;
	GError * err;
	SynapseRelevancyService* _tmp14_;
	SynapseRelevancyService* rel_srv;
	GeeSet* _tmp15_;
	GeeSet* _tmp16_;
	GeeIterator* _tmp17_;
	GeeIterator* _tmp18_;
	GeeIterator* _entry_it;
	gboolean _tmp19_;
	gpointer _tmp20_;
	GeeMapEntry* entry;
	GeeList* _tmp21_;
	GeeList* _matcher_list;
	gint _tmp22_;
	gint _matcher_size;
	gint _matcher_index;
	gpointer _tmp23_;
	GeeMapEntry* matcher;
	gconstpointer _tmp24_;
	SynapseUtilsFileInfo* _tmp25_;
	SynapseUtilsFileInfo* fi;
	gconstpointer _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gboolean exists;
	gboolean _tmp33_;
	gconstpointer _tmp34_;
	gint base_relevancy;
	gfloat _tmp35_;
	gfloat pop;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	SynapseHybridSearchPlugin * self;
	guint query_id;
	SynapseResultSet* original_rs;
	GeeSet* uris;
	gulong sig_id;
	gpointer _async_data_;
};

struct _SynapseHybridSearchPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block3Data* _data3_;
	SynapseQueryFlags our_results;
	SynapseQueryFlags common_flags;
	gboolean _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint last_level_uris;
	GeeHashSet* _tmp6_;
	gulong _tmp7_;
	gulong _tmp8_;
	gulong canc_sig_id;
	gboolean _tmp9_;
	GObject* _tmp10_;
	GObject* _tmp11_;
	gboolean _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	gint _tmp15_;
	GeeList* _tmp16_;
	GeeList* directories;
	SynapseResultSet* _tmp17_;
	SynapseResultSet* _result_;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginMatchObject {
	GObject parent_instance;
	SynapseHybridSearchPluginMatchObjectPrivate * priv;
};

struct _SynapseHybridSearchPluginMatchObjectClass {
	GObjectClass parent_class;
};

struct _SynapseHybridSearchPluginMatchObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gchar* _uri;
	SynapseQueryFlags _file_type;
	gchar* _mime_type;
};

struct _SynapseHybridSearchPluginParamSpecDirectoryInfo {
	GParamSpec parent_instance;
};


static gpointer synapse_hybrid_search_plugin_parent_class = NULL;
static gpointer synapse_hybrid_search_plugin_match_object_parent_class = NULL;
static SynapseMatchIface* synapse_hybrid_search_plugin_match_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface* synapse_hybrid_search_plugin_match_object_synapse_uri_match_parent_iface = NULL;
static gpointer synapse_hybrid_search_plugin_directory_info_parent_class = NULL;
static SynapseActivatableIface* synapse_hybrid_search_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_hybrid_search_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_hybrid_search_plugin_get_type (void) G_GNUC_CONST;
static gpointer synapse_hybrid_search_plugin_directory_info_ref (gpointer instance);
static void synapse_hybrid_search_plugin_directory_info_unref (gpointer instance);
static GParamSpec* synapse_hybrid_search_plugin_param_spec_directory_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void synapse_hybrid_search_plugin_value_set_directory_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void synapse_hybrid_search_plugin_value_take_directory_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer synapse_hybrid_search_plugin_value_get_directory_info (const GValue* value) G_GNUC_UNUSED;
static GType synapse_hybrid_search_plugin_directory_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPluginPrivate))
enum  {
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED
};
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME ".recently-used.xbel"
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MAX_RECENT_DIRS 10
static void synapse_hybrid_search_plugin_real_activate (SynapseActivatable* base);
static void synapse_hybrid_search_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_hybrid_search_plugin_register_plugin (void);
static void _synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_hybrid_search_plugin_real_constructed (GObject* base);
SynapseDataSink* synapse_hybrid_search_plugin_get_data_sink (SynapseHybridSearchPlugin* self);
static void synapse_hybrid_search_plugin_zg_plugin_search_done (SynapseHybridSearchPlugin* self, SynapseResultSet* rs, guint query_id);
static void _synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_item_provider_search_done (SynapseItemProvider* _sender, SynapseResultSet* rs, guint query_id, gpointer self);
static void synapse_hybrid_search_plugin_analyze_recent_documents_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_analyze_recent_documents (SynapseHybridSearchPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_analyze_recent_documents_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_);
static gboolean synapse_hybrid_search_plugin_analyze_recent_documents_co (SynapseHybridSearchPluginAnalyzeRecentDocumentsData* data);
static void synapse_hybrid_search_plugin_analyze_recent_documents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gint _lambda5_ (gconstpointer a, gconstpointer b, SynapseHybridSearchPlugin* self);
static gint __lambda5__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void synapse_hybrid_search_plugin_process_directories (SynapseHybridSearchPlugin* self, GeeCollection* directories, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_process_directories_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_);
static void synapse_hybrid_search_plugin_process_uris_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_process_uris (SynapseHybridSearchPlugin* self, GeeCollection* uris, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_process_uris_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_);
static gboolean synapse_hybrid_search_plugin_process_uris_co (SynapseHybridSearchPluginProcessUrisData* data);
static void synapse_hybrid_search_plugin_process_uris_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GeeList* synapse_hybrid_search_plugin_get_most_likely_dirs (SynapseHybridSearchPlugin* self);
static gint _lambda6_ (gconstpointer a, gconstpointer b, SynapseHybridSearchPlugin* self);
static gint __lambda6__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void synapse_hybrid_search_plugin_process_directory_contents (SynapseHybridSearchPlugin* self, SynapseHybridSearchPluginDirectoryInfo* di, GFile* directory, GList* files);
static GType synapse_hybrid_search_plugin_match_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void synapse_hybrid_search_plugin_update_directory_contents_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_update_directory_contents (SynapseHybridSearchPlugin* self, GFile* directory, SynapseHybridSearchPluginDirectoryInfo* di, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_update_directory_contents_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_, GError** error);
static gboolean synapse_hybrid_search_plugin_update_directory_contents_co (SynapseHybridSearchPluginUpdateDirectoryContentsData* data);
static void synapse_hybrid_search_plugin_update_directory_contents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_hybrid_search_plugin_process_directories_data_free (gpointer _data);
static gboolean synapse_hybrid_search_plugin_process_directories_co (SynapseHybridSearchPluginProcessDirectoriesData* data);
static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_new (const gchar* path);
static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_construct (GType object_type, const gchar* path);
static void synapse_hybrid_search_plugin_process_directories_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_get_extra_results_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_get_extra_results (SynapseHybridSearchPlugin* self, SynapseQuery* q, SynapseResultSet* original_rs, GeeCollection* dirs, GAsyncReadyCallback _callback_, gpointer _user_data_);
static SynapseResultSet* synapse_hybrid_search_plugin_get_extra_results_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_, GError** error);
static gboolean synapse_hybrid_search_plugin_get_extra_results_co (SynapseHybridSearchPluginGetExtraResultsData* data);
static void synapse_hybrid_search_plugin_get_extra_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_real_search_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean synapse_hybrid_search_plugin_real_search_co (SynapseHybridSearchPluginSearchData* data);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda7_ (SynapseResultSet* rs, guint q_id, Block3Data* _data3_);
static void __lambda7__synapse_hybrid_search_plugin_zeitgeist_search_complete (SynapseHybridSearchPlugin* _sender, SynapseResultSet* rs, guint query_id, gpointer self);
static void _lambda8_ (Block3Data* _data3_);
static gboolean _synapse_hybrid_search_plugin_real_search_co_gsource_func (gpointer self);
static void __lambda8__gcallback (GCancellable* instance, gpointer self);
static void synapse_hybrid_search_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_new (void);
SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_construct (GType object_type);
static void synapse_hybrid_search_plugin_set_data_sink (SynapseHybridSearchPlugin* self, SynapseDataSink* value);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * synapse_hybrid_search_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, SynapseHybridSearchPluginMatchObjectPrivate))
enum  {
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_TITLE,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DESCRIPTION,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_ICON_NAME,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MATCH_TYPE,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_URI,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_FILE_TYPE,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MIME_TYPE
};
static SynapseHybridSearchPluginMatchObject* synapse_hybrid_search_plugin_match_object_new (const gchar* thumbnail_path, const gchar* icon);
static SynapseHybridSearchPluginMatchObject* synapse_hybrid_search_plugin_match_object_construct (GType object_type, const gchar* thumbnail_path, const gchar* icon);
static void synapse_hybrid_search_plugin_match_object_finalize (GObject* obj);
static void _vala_synapse_hybrid_search_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_hybrid_search_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_DUMMY_PROPERTY
};
static void synapse_hybrid_search_plugin_directory_info_finalize (SynapseHybridSearchPluginDirectoryInfo* obj);
static void synapse_hybrid_search_plugin_finalize (GObject* obj);
static void _vala_synapse_hybrid_search_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_hybrid_search_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void synapse_hybrid_search_plugin_real_activate (SynapseActivatable* base) {
	SynapseHybridSearchPlugin * self;
	self = (SynapseHybridSearchPlugin*) base;
}


static void synapse_hybrid_search_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseHybridSearchPlugin * self;
	self = (SynapseHybridSearchPlugin*) base;
}


static void _synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_hybrid_search_plugin_register_plugin ();
}


static void synapse_hybrid_search_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Improve results returned by the Zeitgeist plugin by looking " "for similar files on the filesystem.");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, "Hybrid Search", _tmp2_, "search", _synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}


static void _synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_item_provider_search_done (SynapseItemProvider* _sender, SynapseResultSet* rs, guint query_id, gpointer self) {
	synapse_hybrid_search_plugin_zg_plugin_search_done (self, rs, query_id);
}


static void synapse_hybrid_search_plugin_real_constructed (GObject* base) {
	SynapseHybridSearchPlugin * self;
	SynapseItemProvider* zg_plugin = NULL;
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_;
	self = (SynapseHybridSearchPlugin*) base;
	_tmp0_ = synapse_data_sink_get_plugin (self->priv->_data_sink, "SynapseZeitgeistPlugin");
	zg_plugin = (_tmp1_ = _tmp0_, SYNAPSE_IS_ITEM_PROVIDER (_tmp1_) ? ((SynapseItemProvider*) _tmp1_) : NULL);
	if (zg_plugin == NULL) {
		return;
	}
	g_signal_connect_object (zg_plugin, "search-done", (GCallback) _synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_item_provider_search_done, self, 0);
	self->priv->connected_to_zg = TRUE;
}


static void synapse_hybrid_search_plugin_analyze_recent_documents_data_free (gpointer _data) {
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SynapseHybridSearchPluginAnalyzeRecentDocumentsData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_hybrid_search_plugin_analyze_recent_documents (SynapseHybridSearchPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginAnalyzeRecentDocumentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_analyze_recent_documents);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_analyze_recent_documents_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_hybrid_search_plugin_analyze_recent_documents_co (_data_);
}


static void synapse_hybrid_search_plugin_analyze_recent_documents_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_) {
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_analyze_recent_documents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_analyze_recent_documents_co (data);
}


static gint _lambda5_ (gconstpointer a, gconstpointer b, SynapseHybridSearchPlugin* self) {
	gint result = 0;
	GeeMapEntry* e1;
	GeeMapEntry* e2;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	e1 = GEE_MAP_ENTRY (a);
	e2 = GEE_MAP_ENTRY (b);
	_tmp0_ = gee_map_entry_get_value (e2);
	_tmp1_ = gee_map_entry_get_value (e1);
	result = GPOINTER_TO_INT (_tmp0_) - GPOINTER_TO_INT (_tmp1_);
	return result;
}


static gint __lambda5__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = _lambda5_ (a, b, self);
	return result;
}


static gboolean synapse_hybrid_search_plugin_analyze_recent_documents_co (SynapseHybridSearchPluginAnalyzeRecentDocumentsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_get_home_dir ();
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_build_filename (data->_tmp0_, SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME, NULL, NULL);
	data->_tmp2_ = data->_tmp1_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_file_new_for_path (data->_tmp2_);
	data->recent = (data->_tmp4_ = data->_tmp3_, _g_free0 (data->_tmp2_), data->_tmp4_);
	data->_tmp5_ = NULL;
	data->_state_ = 1;
	g_file_load_contents_async (data->recent, NULL, synapse_hybrid_search_plugin_analyze_recent_documents_ready, data);
	return FALSE;
	_state_1:
	data->_tmp7_ = g_file_load_contents_finish (data->recent, data->_res_, &data->_tmp5_, &data->_tmp6_, NULL, &data->_inner_error_);
	_g_free0 (data->contents);
	data->contents = data->_tmp5_;
	data->len = data->_tmp6_;
	data->_tmp8_ = data->_tmp7_;
	if (data->_inner_error_ != NULL) {
		goto __catch20_g_error;
	}
	data->load_ok = data->_tmp8_;
	goto __finally20;
	__catch20_g_error:
	{
		data->load_error = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->load_ok = FALSE;
		_g_error_free0 (data->load_error);
	}
	__finally20:
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->contents);
		goto __catch19_g_error;
	}
	if (!data->load_ok) {
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_get_user_data_dir ();
		data->_tmp10_ = NULL;
		data->_tmp10_ = g_build_filename (data->_tmp9_, SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME, NULL, NULL);
		data->_tmp11_ = data->_tmp10_;
		data->_tmp12_ = NULL;
		data->_tmp12_ = g_file_new_for_path (data->_tmp11_);
		data->_tmp13_ = data->_tmp12_;
		_g_object_unref0 (data->recent);
		data->recent = data->_tmp13_;
		_g_free0 (data->_tmp11_);
		data->_tmp14_ = NULL;
		data->_state_ = 2;
		g_file_load_contents_async (data->recent, NULL, synapse_hybrid_search_plugin_analyze_recent_documents_ready, data);
		return FALSE;
		_state_2:
		data->_tmp16_ = g_file_load_contents_finish (data->recent, data->_res_, &data->_tmp14_, &data->_tmp15_, NULL, &data->_inner_error_);
		_g_free0 (data->contents);
		data->contents = data->_tmp14_;
		data->len = data->_tmp15_;
		data->_tmp17_ = data->_tmp16_;
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->contents);
			goto __catch19_g_error;
		}
		data->load_ok = data->_tmp17_;
	}
	if (data->load_ok) {
		data->_tmp18_ = NULL;
		data->_tmp18_ = g_bookmark_file_new ();
		data->bf = data->_tmp18_;
		g_bookmark_file_load_from_data (data->bf, data->contents, data->len, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			_g_bookmark_file_free0 (data->bf);
			_g_free0 (data->contents);
			goto __catch19_g_error;
		}
		data->_tmp20_ = NULL;
		data->_tmp20_ = g_bookmark_file_get_uris (data->bf, &data->_tmp19_);
		data->uris = data->_tmp20_;
		data->uris_length1 = data->_tmp19_;
		data->_uris_size_ = data->_tmp19_;
		data->_tmp21_ = NULL;
		data->_tmp21_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		data->dir_hits = (GeeMap*) data->_tmp21_;
		{
			data->uri_collection = data->uris;
			data->uri_collection_length1 = data->uris_length1;
			for (data->uri_it = 0; data->uri_it < data->uris_length1; data->uri_it = data->uri_it + 1) {
				data->uri = data->uri_collection[data->uri_it];
				{
					data->_tmp22_ = NULL;
					data->_tmp22_ = g_file_new_for_uri (data->uri);
					data->f = data->_tmp22_;
					data->_tmp23_ = NULL;
					data->_tmp23_ = g_file_get_parent (data->f);
					data->parent = data->_tmp23_;
					if (data->parent == NULL) {
						_g_object_unref0 (data->parent);
						_g_object_unref0 (data->f);
						continue;
					}
					data->_tmp24_ = NULL;
					data->_tmp24_ = g_file_get_path (data->parent);
					data->parent_path = data->_tmp24_;
					if (data->parent_path == NULL) {
						_g_free0 (data->parent_path);
						_g_object_unref0 (data->parent);
						_g_object_unref0 (data->f);
						continue;
					}
					data->_tmp25_ = NULL;
					data->_tmp25_ = gee_map_get (data->dir_hits, data->parent_path);
					gee_map_set (data->dir_hits, data->parent_path, GINT_TO_POINTER (GPOINTER_TO_INT (data->_tmp25_) + 1));
					_g_free0 (data->parent_path);
					_g_object_unref0 (data->parent);
					_g_object_unref0 (data->f);
				}
			}
		}
		data->_tmp26_ = NULL;
		data->_tmp26_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		data->sorted_dirs = (GeeList*) data->_tmp26_;
		data->_tmp27_ = NULL;
		data->_tmp27_ = gee_map_get_entries (data->dir_hits);
		data->_tmp28_ = data->_tmp27_;
		gee_collection_add_all ((GeeCollection*) data->sorted_dirs, (GeeCollection*) data->_tmp28_);
		_g_object_unref0 (data->_tmp28_);
		gee_list_sort (data->sorted_dirs, __lambda5__gcompare_data_func, g_object_ref (data->self), g_object_unref);
		data->_tmp29_ = NULL;
		data->_tmp29_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		data->directories = (GeeList*) data->_tmp29_;
		{
			data->i = 0;
			{
				data->_tmp30_ = TRUE;
				while (TRUE) {
					if (!data->_tmp30_) {
						data->i++;
					}
					data->_tmp30_ = FALSE;
					data->_tmp32_ = gee_collection_get_size ((GeeCollection*) data->sorted_dirs);
					if (data->i < data->_tmp32_) {
						data->_tmp33_ = gee_collection_get_size ((GeeCollection*) data->directories);
						data->_tmp31_ = data->_tmp33_ < SYNAPSE_HYBRID_SEARCH_PLUGIN_MAX_RECENT_DIRS;
					} else {
						data->_tmp31_ = FALSE;
					}
					if (!data->_tmp31_) {
						break;
					}
					data->_tmp34_ = NULL;
					data->_tmp34_ = gee_list_get (data->sorted_dirs, data->i);
					data->_tmp35_ = (GeeMapEntry*) data->_tmp34_;
					data->_tmp36_ = NULL;
					data->_tmp36_ = gee_map_entry_get_key (data->_tmp35_);
					data->_tmp37_ = g_strdup ((const gchar*) data->_tmp36_);
					data->dir_path = (data->_tmp38_ = data->_tmp37_, _g_object_unref0 (data->_tmp35_), data->_tmp38_);
					data->_tmp39_ = g_str_has_prefix (data->dir_path, "/tmp");
					if (data->_tmp39_) {
						_g_free0 (data->dir_path);
						continue;
					}
					data->_tmp40_ = NULL;
					data->_tmp40_ = g_file_new_for_path (data->dir_path);
					data->dir_f = data->_tmp40_;
					data->_tmp41_ = g_file_is_native (data->dir_f);
					if (data->_tmp41_) {
						data->_state_ = 3;
						synapse_utils_query_exists_async (data->dir_f, synapse_hybrid_search_plugin_analyze_recent_documents_ready, data);
						return FALSE;
						_state_3:
						data->_tmp42_ = synapse_utils_query_exists_finish (data->_res_);
						data->exists = data->_tmp42_;
						if (data->exists) {
							gee_collection_add ((GeeCollection*) data->directories, data->dir_path);
						}
					}
					_g_object_unref0 (data->dir_f);
					_g_free0 (data->dir_path);
				}
			}
		}
		data->_state_ = 4;
		synapse_hybrid_search_plugin_process_directories (data->self, (GeeCollection*) data->directories, synapse_hybrid_search_plugin_analyze_recent_documents_ready, data);
		return FALSE;
		_state_4:
		synapse_hybrid_search_plugin_process_directories_finish (data->self, data->_res_);
		data->z = 0;
		{
			data->_tmp43_ = NULL;
			data->_tmp43_ = gee_map_get_entries (data->self->priv->directory_contents);
			data->_tmp44_ = data->_tmp43_;
			data->_tmp45_ = NULL;
			data->_tmp45_ = gee_iterable_iterator ((GeeIterable*) data->_tmp44_);
			data->_x_it = (data->_tmp46_ = data->_tmp45_, _g_object_unref0 (data->_tmp44_), data->_tmp46_);
			while (TRUE) {
				data->_tmp47_ = gee_iterator_next (data->_x_it);
				if (!data->_tmp47_) {
					break;
				}
				data->_tmp48_ = NULL;
				data->_tmp48_ = gee_iterator_get (data->_x_it);
				data->x = (GeeMapEntry*) data->_tmp48_;
				data->_tmp49_ = NULL;
				data->_tmp49_ = gee_map_entry_get_value (data->x);
				data->_tmp50_ = gee_map_get_size (((SynapseHybridSearchPluginDirectoryInfo*) data->_tmp49_)->files);
				data->z = data->z + data->_tmp50_;
				_g_object_unref0 (data->x);
			}
			_g_object_unref0 (data->_x_it);
		}
		synapse_utils_logger_log ((GObject*) data->self, "keeps in cache now %d file names", data->z, NULL);
		_g_object_unref0 (data->directories);
		_g_object_unref0 (data->sorted_dirs);
		_g_object_unref0 (data->dir_hits);
		data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
		_g_bookmark_file_free0 (data->bf);
	}
	_g_free0 (data->contents);
	goto __finally19;
	__catch19_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("hybrid-search-plugin.vala:216: Unable to parse ~/%s", SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME);
		_g_error_free0 (data->err);
	}
	__finally19:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->recent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->self->priv->initialization_done = TRUE;
	_g_object_unref0 (data->recent);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_hybrid_search_plugin_zg_plugin_search_done (SynapseHybridSearchPlugin* self, SynapseResultSet* rs, guint query_id) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "zeitgeist-search-complete", rs, query_id);
}


static void synapse_hybrid_search_plugin_process_uris_data_free (gpointer _data) {
	SynapseHybridSearchPluginProcessUrisData* data;
	data = _data;
	_g_object_unref0 (data->uris);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseHybridSearchPluginProcessUrisData, data);
}


static void synapse_hybrid_search_plugin_process_uris (SynapseHybridSearchPlugin* self, GeeCollection* uris, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginProcessUrisData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginProcessUrisData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_process_uris);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_process_uris_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uris = _g_object_ref0 (uris);
	synapse_hybrid_search_plugin_process_uris_co (_data_);
}


static void synapse_hybrid_search_plugin_process_uris_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_) {
	SynapseHybridSearchPluginProcessUrisData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_process_uris_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginProcessUrisData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_process_uris_co (data);
}


static gboolean synapse_hybrid_search_plugin_process_uris_co (SynapseHybridSearchPluginProcessUrisData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	data->dirs = (GeeSet*) data->_tmp0_;
	{
		data->_tmp1_ = NULL;
		data->_tmp1_ = gee_iterable_iterator ((GeeIterable*) data->uris);
		data->_uri_it = data->_tmp1_;
		while (TRUE) {
			data->_tmp2_ = gee_iterator_next (data->_uri_it);
			if (!data->_tmp2_) {
				break;
			}
			data->_tmp3_ = NULL;
			data->_tmp3_ = gee_iterator_get (data->_uri_it);
			data->uri = (gchar*) data->_tmp3_;
			data->_tmp4_ = NULL;
			data->_tmp4_ = g_file_new_for_uri (data->uri);
			data->f = data->_tmp4_;
			data->_tmp5_ = g_file_is_native (data->f);
			if (data->_tmp5_) {
				data->_state_ = 1;
				g_file_query_info_async (data->f, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_hybrid_search_plugin_process_uris_ready, data);
				return FALSE;
				_state_1:
				data->_tmp6_ = NULL;
				data->_tmp6_ = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
				data->fi = data->_tmp6_;
				if (data->_inner_error_ != NULL) {
					goto __catch21_g_error;
				}
				data->_tmp7_ = g_file_info_get_file_type (data->fi);
				if (data->_tmp7_ == G_FILE_TYPE_REGULAR) {
					data->_tmp8_ = NULL;
					data->_tmp8_ = g_file_get_parent (data->f);
					data->_tmp9_ = data->_tmp8_;
					data->_tmp10_ = NULL;
					data->_tmp10_ = g_file_get_path (data->_tmp9_);
					data->parent_path = (data->_tmp11_ = data->_tmp10_, _g_object_unref0 (data->_tmp9_), data->_tmp11_);
					if (data->parent_path != NULL) {
						gee_collection_add ((GeeCollection*) data->dirs, data->parent_path);
					}
					_g_free0 (data->parent_path);
				}
				_g_object_unref0 (data->fi);
			}
			goto __finally21;
			__catch21_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				_g_error_free0 (data->err);
				_g_object_unref0 (data->f);
				_g_free0 (data->uri);
				continue;
			}
			__finally21:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->f);
				_g_free0 (data->uri);
				_g_object_unref0 (data->_uri_it);
				_g_object_unref0 (data->dirs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			_g_object_unref0 (data->f);
			_g_free0 (data->uri);
		}
		_g_object_unref0 (data->_uri_it);
	}
	if (data->self->priv->current_query == NULL) {
		data->_tmp12_ = 1;
	} else {
		data->_tmp13_ = strlen (data->self->priv->current_query);
		data->_tmp12_ = (gint) data->_tmp13_;
	}
	data->q_len = data->_tmp12_;
	{
		data->_tmp14_ = NULL;
		data->_tmp14_ = gee_iterable_iterator ((GeeIterable*) data->dirs);
		data->_dir_it = data->_tmp14_;
		while (TRUE) {
			data->_tmp15_ = gee_iterator_next (data->_dir_it);
			if (!data->_tmp15_) {
				break;
			}
			data->_tmp16_ = NULL;
			data->_tmp16_ = gee_iterator_get (data->_dir_it);
			data->dir = (gchar*) data->_tmp16_;
			data->_tmp17_ = gee_map_contains (data->self->priv->directory_hits, data->dir);
			if (data->_tmp17_) {
				data->_tmp18_ = NULL;
				data->_tmp18_ = gee_map_get (data->self->priv->directory_hits, data->dir);
				data->hit_count = GPOINTER_TO_INT (data->_tmp18_);
				gee_map_set (data->self->priv->directory_hits, data->dir, GINT_TO_POINTER (data->hit_count + data->q_len));
			} else {
				gee_map_set (data->self->priv->directory_hits, data->dir, GINT_TO_POINTER (data->q_len));
			}
			_g_free0 (data->dir);
		}
		_g_object_unref0 (data->_dir_it);
	}
	_g_object_unref0 (data->dirs);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gint _lambda6_ (gconstpointer a, gconstpointer b, SynapseHybridSearchPlugin* self) {
	gint result = 0;
	GeeMapEntry* e1;
	GeeMapEntry* e2;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	e1 = GEE_MAP_ENTRY (a);
	e2 = GEE_MAP_ENTRY (b);
	_tmp0_ = gee_map_entry_get_value (e2);
	_tmp1_ = gee_map_entry_get_value (e1);
	result = GPOINTER_TO_INT (_tmp0_) - GPOINTER_TO_INT (_tmp1_);
	return result;
}


static gint __lambda6__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = _lambda6_ (a, b, self);
	return result;
}


static GeeList* synapse_hybrid_search_plugin_get_most_likely_dirs (SynapseHybridSearchPlugin* self) {
	GeeList* result = NULL;
	gint MAX_ITEMS;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _result_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	MAX_ITEMS = 2;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_result_ = _tmp0_;
	_tmp1_ = gee_map_get_size (self->priv->directory_hits);
	if (_tmp1_ <= MAX_ITEMS) {
		{
			GeeSet* _tmp2_ = NULL;
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_ = NULL;
			GeeIterator* _tmp5_;
			GeeIterator* _dir_it;
			_tmp2_ = gee_map_get_keys (self->priv->directory_hits);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_dir_it = (_tmp5_ = _tmp4_, _g_object_unref0 (_tmp3_), _tmp5_);
			while (TRUE) {
				gboolean _tmp6_;
				gpointer _tmp7_ = NULL;
				gchar* dir;
				_tmp6_ = gee_iterator_next (_dir_it);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = gee_iterator_get (_dir_it);
				dir = (gchar*) _tmp7_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _result_, dir);
				_g_free0 (dir);
			}
			_g_object_unref0 (_dir_it);
		}
	} else {
		GeeArrayList* _tmp8_ = NULL;
		GeeArrayList* sort_array;
		gint min_hit;
		gint count;
		_tmp8_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		sort_array = _tmp8_;
		min_hit = G_MAXINT;
		{
			GeeSet* _tmp9_ = NULL;
			GeeSet* _tmp10_;
			GeeIterator* _tmp11_ = NULL;
			GeeIterator* _tmp12_;
			GeeIterator* _entry_it;
			_tmp9_ = gee_map_get_entries (self->priv->directory_hits);
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
			_entry_it = (_tmp12_ = _tmp11_, _g_object_unref0 (_tmp10_), _tmp12_);
			while (TRUE) {
				gboolean _tmp13_;
				gpointer _tmp14_ = NULL;
				GeeMapEntry* entry;
				gconstpointer _tmp15_ = NULL;
				_tmp13_ = gee_iterator_next (_entry_it);
				if (!_tmp13_) {
					break;
				}
				_tmp14_ = gee_iterator_get (_entry_it);
				entry = (GeeMapEntry*) _tmp14_;
				_tmp15_ = gee_map_entry_get_value (entry);
				if (GPOINTER_TO_INT (_tmp15_) < min_hit) {
					gconstpointer _tmp16_ = NULL;
					_tmp16_ = gee_map_entry_get_value (entry);
					min_hit = GPOINTER_TO_INT (_tmp16_);
				}
				_g_object_unref0 (entry);
			}
			_g_object_unref0 (_entry_it);
		}
		{
			GeeSet* _tmp17_ = NULL;
			GeeSet* _tmp18_;
			GeeIterator* _tmp19_ = NULL;
			GeeIterator* _tmp20_;
			GeeIterator* _entry_it;
			_tmp17_ = gee_map_get_entries (self->priv->directory_hits);
			_tmp18_ = _tmp17_;
			_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
			_entry_it = (_tmp20_ = _tmp19_, _g_object_unref0 (_tmp18_), _tmp20_);
			while (TRUE) {
				gboolean _tmp21_;
				gpointer _tmp22_ = NULL;
				GeeMapEntry* entry;
				gconstpointer _tmp23_ = NULL;
				_tmp21_ = gee_iterator_next (_entry_it);
				if (!_tmp21_) {
					break;
				}
				_tmp22_ = gee_iterator_get (_entry_it);
				entry = (GeeMapEntry*) _tmp22_;
				_tmp23_ = gee_map_entry_get_value (entry);
				if (GPOINTER_TO_INT (_tmp23_) > min_hit) {
					gee_abstract_collection_add ((GeeAbstractCollection*) sort_array, entry);
				}
				_g_object_unref0 (entry);
			}
			_g_object_unref0 (_entry_it);
		}
		gee_list_sort ((GeeList*) sort_array, __lambda6__gcompare_data_func, g_object_ref (self), g_object_unref);
		count = 0;
		{
			GeeArrayList* _tmp24_;
			GeeArrayList* _entry_list;
			gint _tmp25_;
			gint _entry_size;
			gint _entry_index;
			_tmp24_ = _g_object_ref0 (sort_array);
			_entry_list = _tmp24_;
			_tmp25_ = gee_collection_get_size ((GeeCollection*) _entry_list);
			_entry_size = _tmp25_;
			_entry_index = -1;
			while (TRUE) {
				gpointer _tmp26_ = NULL;
				GeeMapEntry* entry;
				gconstpointer _tmp27_ = NULL;
				gint _tmp28_;
				_entry_index = _entry_index + 1;
				if (!(_entry_index < _entry_size)) {
					break;
				}
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _entry_list, _entry_index);
				entry = (GeeMapEntry*) _tmp26_;
				_tmp27_ = gee_map_entry_get_key (entry);
				gee_abstract_collection_add ((GeeAbstractCollection*) _result_, (const gchar*) _tmp27_);
				_tmp28_ = count;
				count = _tmp28_ + 1;
				if (_tmp28_ >= (MAX_ITEMS - 1)) {
					_g_object_unref0 (entry);
					break;
				}
				_g_object_unref0 (entry);
			}
			_g_object_unref0 (_entry_list);
		}
		_g_object_unref0 (sort_array);
	}
	result = (GeeList*) _result_;
	return result;
}


static void synapse_hybrid_search_plugin_process_directory_contents (SynapseHybridSearchPlugin* self, SynapseHybridSearchPluginDirectoryInfo* di, GFile* directory, GList* files) {
	GTimeVal _tmp0_ = {0};
	GTimeVal _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (di != NULL);
	g_return_if_fail (directory != NULL);
	g_get_current_time (&_tmp0_);
	_tmp1_ = _tmp0_;
	di->last_update = _tmp1_;
	{
		GList* f_collection;
		GList* f_it;
		f_collection = files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFileInfo* _tmp2_;
			GFileInfo* f;
			_tmp2_ = _g_object_ref0 ((GFileInfo*) f_it->data);
			f = _tmp2_;
			{
				const gchar* _tmp3_ = NULL;
				const gchar* name;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_;
				GFile* _tmp11_ = NULL;
				GFile* child;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				SynapseUtilsFileInfo* _tmp14_ = NULL;
				SynapseUtilsFileInfo* _tmp15_;
				SynapseUtilsFileInfo* file_info;
				_tmp3_ = g_file_info_get_name (f);
				name = _tmp3_;
				_tmp7_ = g_str_has_suffix (name, ".o");
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_;
					_tmp8_ = g_str_has_suffix (name, ".lo");
					_tmp6_ = _tmp8_;
				}
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp9_;
					_tmp9_ = g_str_has_suffix (name, ".mo");
					_tmp5_ = _tmp9_;
				}
				if (_tmp5_) {
					_tmp4_ = TRUE;
				} else {
					gboolean _tmp10_;
					_tmp10_ = g_str_has_suffix (name, ".gmo");
					_tmp4_ = _tmp10_;
				}
				if (_tmp4_) {
					_g_object_unref0 (f);
					continue;
				}
				_tmp11_ = g_file_get_child (directory, name);
				child = _tmp11_;
				_tmp12_ = g_file_get_uri (child);
				_tmp13_ = _tmp12_;
				_tmp14_ = synapse_utils_file_info_new (_tmp13_, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT);
				file_info = (_tmp15_ = _tmp14_, _g_free0 (_tmp13_), _tmp15_);
				gee_map_set (di->files, file_info->uri, file_info);
				_synapse_utils_file_info_unref0 (file_info);
				_g_object_unref0 (child);
				_g_object_unref0 (f);
			}
		}
	}
}


static void synapse_hybrid_search_plugin_update_directory_contents_data_free (gpointer _data) {
	SynapseHybridSearchPluginUpdateDirectoryContentsData* data;
	data = _data;
	_g_object_unref0 (data->directory);
	_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseHybridSearchPluginUpdateDirectoryContentsData, data);
}


static gpointer _synapse_hybrid_search_plugin_directory_info_ref0 (gpointer self) {
	return self ? synapse_hybrid_search_plugin_directory_info_ref (self) : NULL;
}


static void synapse_hybrid_search_plugin_update_directory_contents (SynapseHybridSearchPlugin* self, GFile* directory, SynapseHybridSearchPluginDirectoryInfo* di, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginUpdateDirectoryContentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_update_directory_contents);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_update_directory_contents_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->directory = _g_object_ref0 (directory);
	_data_->di = _synapse_hybrid_search_plugin_directory_info_ref0 (di);
	synapse_hybrid_search_plugin_update_directory_contents_co (_data_);
}


static void synapse_hybrid_search_plugin_update_directory_contents_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_, GError** error) {
	SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_update_directory_contents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginUpdateDirectoryContentsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_update_directory_contents_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean synapse_hybrid_search_plugin_update_directory_contents_co (SynapseHybridSearchPluginUpdateDirectoryContentsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_get_path (data->directory);
	data->_tmp1_ = data->_tmp0_;
	synapse_utils_logger_debug ((GObject*) data->self, "Scanning %s", data->_tmp1_, NULL);
	_g_free0 (data->_tmp1_);
	data->_state_ = 1;
	g_file_enumerate_children_async (data->directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, 0, NULL, synapse_hybrid_search_plugin_update_directory_contents_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_file_enumerate_children_finish (data->directory, data->_res_, &data->_inner_error_);
	data->enumerator = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 2;
	g_file_enumerator_next_files_async (data->enumerator, 1024, 0, NULL, synapse_hybrid_search_plugin_update_directory_contents_ready, data);
	return FALSE;
	_state_2:
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
	data->files = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->enumerator);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	gee_map_clear (data->di->files);
	synapse_hybrid_search_plugin_process_directory_contents (data->self, data->di, data->directory, data->files);
	__g_list_free__g_object_unref0_0 (data->files);
	_g_object_unref0 (data->enumerator);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_hybrid_search_plugin_process_directories_data_free (gpointer _data) {
	SynapseHybridSearchPluginProcessDirectoriesData* data;
	data = _data;
	_g_object_unref0 (data->directories);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseHybridSearchPluginProcessDirectoriesData, data);
}


static void synapse_hybrid_search_plugin_process_directories (SynapseHybridSearchPlugin* self, GeeCollection* directories, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginProcessDirectoriesData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginProcessDirectoriesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_process_directories);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_process_directories_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->directories = _g_object_ref0 (directories);
	synapse_hybrid_search_plugin_process_directories_co (_data_);
}


static void synapse_hybrid_search_plugin_process_directories_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_) {
	SynapseHybridSearchPluginProcessDirectoriesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_process_directories_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginProcessDirectoriesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_process_directories_co (data);
}


static gboolean synapse_hybrid_search_plugin_process_directories_co (SynapseHybridSearchPluginProcessDirectoriesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = NULL;
		data->_tmp0_ = gee_iterable_iterator ((GeeIterable*) data->directories);
		data->_dir_path_it = data->_tmp0_;
		while (TRUE) {
			data->_tmp1_ = gee_iterator_next (data->_dir_path_it);
			if (!data->_tmp1_) {
				break;
			}
			data->_tmp2_ = NULL;
			data->_tmp2_ = gee_iterator_get (data->_dir_path_it);
			data->dir_path = (gchar*) data->_tmp2_;
			data->_tmp3_ = NULL;
			data->_tmp3_ = g_file_new_for_path (data->dir_path);
			data->directory = data->_tmp3_;
			data->_tmp4_ = gee_map_contains (data->self->priv->directory_contents, data->dir_path);
			if (data->_tmp4_) {
				g_get_current_time (&data->cur_time);
				data->_tmp5_ = NULL;
				data->_tmp5_ = gee_map_get (data->self->priv->directory_contents, data->dir_path);
				data->_tmp6_ = (SynapseHybridSearchPluginDirectoryInfo*) data->_tmp5_;
				_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
				data->di = data->_tmp6_;
				if ((data->cur_time.tv_sec - data->di->last_update.tv_sec) <= (5 * 60)) {
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_object_unref0 (data->directory);
					_g_free0 (data->dir_path);
					continue;
				}
			} else {
				data->_tmp7_ = NULL;
				data->_tmp7_ = synapse_hybrid_search_plugin_directory_info_new (data->dir_path);
				data->_tmp8_ = data->_tmp7_;
				_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
				data->di = data->_tmp8_;
				gee_map_set (data->self->priv->directory_contents, data->dir_path, data->di);
			}
			data->_state_ = 1;
			synapse_hybrid_search_plugin_update_directory_contents (data->self, data->directory, data->di, synapse_hybrid_search_plugin_process_directories_ready, data);
			return FALSE;
			_state_1:
			synapse_hybrid_search_plugin_update_directory_contents_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
				goto __catch22_g_error;
			}
			_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
			goto __finally22;
			__catch22_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				_g_error_free0 (data->err);
			}
			__finally22:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->directory);
				_g_free0 (data->dir_path);
				_g_object_unref0 (data->_dir_path_it);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			_g_object_unref0 (data->directory);
			_g_free0 (data->dir_path);
		}
		_g_object_unref0 (data->_dir_path_it);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_hybrid_search_plugin_get_extra_results_data_free (gpointer _data) {
	SynapseHybridSearchPluginGetExtraResultsData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->original_rs);
	_g_object_unref0 (data->dirs);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseHybridSearchPluginGetExtraResultsData, data);
}


static void synapse_hybrid_search_plugin_get_extra_results (SynapseHybridSearchPlugin* self, SynapseQuery* q, SynapseResultSet* original_rs, GeeCollection* dirs, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginGetExtraResultsData* _data_;
	SynapseQuery _tmp0_ = {0};
	_data_ = g_slice_new0 (SynapseHybridSearchPluginGetExtraResultsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_get_extra_results);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_get_extra_results_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	_data_->original_rs = _g_object_ref0 (original_rs);
	_data_->dirs = _g_object_ref0 (dirs);
	synapse_hybrid_search_plugin_get_extra_results_co (_data_);
}


static SynapseResultSet* synapse_hybrid_search_plugin_get_extra_results_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseHybridSearchPluginGetExtraResultsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_hybrid_search_plugin_get_extra_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginGetExtraResultsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_get_extra_results_co (data);
}


static gpointer _synapse_utils_file_info_ref0 (gpointer self) {
	return self ? synapse_utils_file_info_ref (self) : NULL;
}


static gboolean synapse_hybrid_search_plugin_get_extra_results_co (SynapseHybridSearchPluginGetExtraResultsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->num_results = (guint) 0;
	data->enough_results = FALSE;
	data->_tmp0_ = NULL;
	data->_tmp0_ = synapse_result_set_new ();
	data->results = data->_tmp0_;
	data->flags = G_REGEX_OPTIMIZE | G_REGEX_CASELESS;
	data->_tmp1_ = NULL;
	data->_tmp1_ = synapse_query_get_matchers_for_query (data->q.query_string, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, data->flags);
	data->matchers = data->_tmp1_;
	data->_tmp2_ = _g_object_ref0 (data->dirs);
	data->_tmp3_ = data->_tmp2_;
	if (data->_tmp3_ == NULL) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = gee_map_get_keys (data->self->priv->directory_contents);
		data->_tmp5_ = (GeeCollection*) data->_tmp4_;
		_g_object_unref0 (data->_tmp3_);
		data->_tmp3_ = data->_tmp5_;
	}
	data->_tmp6_ = _g_object_ref0 (data->_tmp3_);
	data->directories = data->_tmp6_;
	{
		data->_tmp7_ = NULL;
		data->_tmp7_ = gee_iterable_iterator ((GeeIterable*) data->directories);
		data->_directory_it = data->_tmp7_;
		while (TRUE) {
			data->_tmp8_ = gee_iterator_next (data->_directory_it);
			if (!data->_tmp8_) {
				break;
			}
			data->_tmp9_ = NULL;
			data->_tmp9_ = gee_iterator_get (data->_directory_it);
			data->directory = (gchar*) data->_tmp9_;
			data->_tmp10_ = NULL;
			data->_tmp10_ = gee_map_get (data->self->priv->directory_contents, data->directory);
			data->di = (SynapseHybridSearchPluginDirectoryInfo*) data->_tmp10_;
			data->_tmp11_ = NULL;
			data->_tmp11_ = g_file_new_for_path (data->directory);
			data->dir = data->_tmp11_;
			data->_state_ = 1;
			g_file_query_info_async (data->dir, "time::*", 0, 0, NULL, synapse_hybrid_search_plugin_get_extra_results_ready, data);
			return FALSE;
			_state_1:
			data->_tmp12_ = NULL;
			data->_tmp12_ = g_file_query_info_finish (data->dir, data->_res_, &data->_inner_error_);
			data->dir_info = data->_tmp12_;
			if (data->_inner_error_ != NULL) {
				goto __catch23_g_error;
			}
			g_get_current_time (&data->t);
			memset (&data->_tmp13_, 0, sizeof (GTimeVal));
			g_file_info_get_modification_time (data->dir_info, &data->_tmp13_);
			data->t = data->_tmp13_;
			if (data->t.tv_sec > data->di->last_update.tv_sec) {
				data->_state_ = 2;
				synapse_hybrid_search_plugin_update_directory_contents (data->self, data->dir, data->di, synapse_hybrid_search_plugin_get_extra_results_ready, data);
				return FALSE;
				_state_2:
				synapse_hybrid_search_plugin_update_directory_contents_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->dir_info);
					goto __catch23_g_error;
				}
			}
			_g_object_unref0 (data->dir_info);
			goto __finally23;
			__catch23_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				g_warning ("hybrid-search-plugin.vala:416: %s", data->err->message);
				_g_error_free0 (data->err);
			}
			__finally23:
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->dir);
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_free0 (data->directory);
					_g_object_unref0 (data->_directory_it);
					_g_object_unref0 (data->directories);
					_g_object_unref0 (data->_tmp3_);
					_g_object_unref0 (data->matchers);
					_g_object_unref0 (data->results);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (data->dir);
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_free0 (data->directory);
					_g_object_unref0 (data->_directory_it);
					_g_object_unref0 (data->directories);
					_g_object_unref0 (data->_tmp3_);
					_g_object_unref0 (data->matchers);
					_g_object_unref0 (data->results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			data->_tmp14_ = NULL;
			data->_tmp14_ = synapse_relevancy_service_get_default ();
			data->rel_srv = data->_tmp14_;
			{
				data->_tmp15_ = NULL;
				data->_tmp15_ = gee_map_get_entries (data->di->files);
				data->_tmp16_ = data->_tmp15_;
				data->_tmp17_ = NULL;
				data->_tmp17_ = gee_iterable_iterator ((GeeIterable*) data->_tmp16_);
				data->_entry_it = (data->_tmp18_ = data->_tmp17_, _g_object_unref0 (data->_tmp16_), data->_tmp18_);
				while (TRUE) {
					data->_tmp19_ = gee_iterator_next (data->_entry_it);
					if (!data->_tmp19_) {
						break;
					}
					data->_tmp20_ = NULL;
					data->_tmp20_ = gee_iterator_get (data->_entry_it);
					data->entry = (GeeMapEntry*) data->_tmp20_;
					{
						data->_tmp21_ = _g_object_ref0 (data->matchers);
						data->_matcher_list = data->_tmp21_;
						data->_tmp22_ = gee_collection_get_size ((GeeCollection*) data->_matcher_list);
						data->_matcher_size = data->_tmp22_;
						data->_matcher_index = -1;
						while (TRUE) {
							data->_matcher_index = data->_matcher_index + 1;
							if (!(data->_matcher_index < data->_matcher_size)) {
								break;
							}
							data->_tmp23_ = NULL;
							data->_tmp23_ = gee_list_get (data->_matcher_list, data->_matcher_index);
							data->matcher = (GeeMapEntry*) data->_tmp23_;
							data->_tmp24_ = NULL;
							data->_tmp24_ = gee_map_entry_get_value (data->entry);
							data->_tmp25_ = _synapse_utils_file_info_ref0 ((SynapseUtilsFileInfo*) data->_tmp24_);
							data->fi = data->_tmp25_;
							data->_tmp26_ = NULL;
							data->_tmp26_ = gee_map_entry_get_key (data->matcher);
							data->_tmp27_ = g_regex_match ((GRegex*) data->_tmp26_, data->fi->parse_name, 0, NULL);
							if (data->_tmp27_) {
								if (data->original_rs == NULL) {
									data->_tmp28_ = TRUE;
								} else {
									data->_tmp29_ = synapse_result_set_contains_uri (data->original_rs, data->fi->uri);
									data->_tmp28_ = !data->_tmp29_;
								}
								if (data->_tmp28_) {
									data->_tmp30_ = synapse_utils_file_info_is_initialized (data->fi);
									if (!data->_tmp30_) {
										data->_state_ = 3;
										synapse_utils_file_info_initialize (data->fi, synapse_hybrid_search_plugin_get_extra_results_ready, data);
										return FALSE;
										_state_3:
										synapse_utils_file_info_initialize_finish (data->fi, data->_res_);
									} else {
										if (data->fi->match_obj != NULL) {
											data->_tmp31_ = (data->q.query_type & data->fi->file_type) == data->fi->file_type;
										} else {
											data->_tmp31_ = FALSE;
										}
										if (data->_tmp31_) {
											data->_state_ = 4;
											synapse_utils_file_info_exists (data->fi, synapse_hybrid_search_plugin_get_extra_results_ready, data);
											return FALSE;
											_state_4:
											data->_tmp32_ = synapse_utils_file_info_exists_finish (data->fi, data->_res_);
											data->exists = data->_tmp32_;
											if (!data->exists) {
												_synapse_utils_file_info_unref0 (data->fi);
												_g_object_unref0 (data->matcher);
												break;
											}
										}
									}
									if (data->fi->match_obj != NULL) {
										data->_tmp33_ = (data->q.query_type & data->fi->file_type) == data->fi->file_type;
									} else {
										data->_tmp33_ = FALSE;
									}
									if (data->_tmp33_) {
										data->_tmp34_ = NULL;
										data->_tmp34_ = gee_map_entry_get_value (data->matcher);
										data->base_relevancy = GPOINTER_TO_INT (data->_tmp34_) - SYNAPSE_MATCH_SCORE_URI_PENALTY;
										data->_tmp35_ = synapse_relevancy_service_get_uri_popularity (data->rel_srv, data->fi->uri);
										data->pop = data->_tmp35_;
										data->_tmp36_ = synapse_relevancy_service_compute_relevancy (data->base_relevancy, data->pop);
										synapse_result_set_add (data->results, (SynapseMatch*) data->fi->match_obj, data->_tmp36_);
										data->num_results++;
									}
								}
								_synapse_utils_file_info_unref0 (data->fi);
								_g_object_unref0 (data->matcher);
								break;
							}
							_synapse_utils_file_info_unref0 (data->fi);
							_g_object_unref0 (data->matcher);
						}
						_g_object_unref0 (data->_matcher_list);
					}
					if (data->num_results >= data->q.max_results) {
						data->enough_results = TRUE;
						_g_object_unref0 (data->entry);
						break;
					}
					_g_object_unref0 (data->entry);
				}
				_g_object_unref0 (data->_entry_it);
			}
			synapse_query_check_cancellable (&data->q, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->rel_srv);
					_g_object_unref0 (data->dir);
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_free0 (data->directory);
					_g_object_unref0 (data->_directory_it);
					_g_object_unref0 (data->directories);
					_g_object_unref0 (data->_tmp3_);
					_g_object_unref0 (data->matchers);
					_g_object_unref0 (data->results);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (data->rel_srv);
					_g_object_unref0 (data->dir);
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_free0 (data->directory);
					_g_object_unref0 (data->_directory_it);
					_g_object_unref0 (data->directories);
					_g_object_unref0 (data->_tmp3_);
					_g_object_unref0 (data->matchers);
					_g_object_unref0 (data->results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			if (data->enough_results) {
				_g_object_unref0 (data->rel_srv);
				_g_object_unref0 (data->dir);
				_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
				_g_free0 (data->directory);
				break;
			}
			_g_object_unref0 (data->rel_srv);
			_g_object_unref0 (data->dir);
			_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
			_g_free0 (data->directory);
		}
		_g_object_unref0 (data->_directory_it);
	}
	data->_tmp37_ = gee_collection_get_size (data->directories);
	if (data->_tmp37_ == 0) {
		synapse_query_check_cancellable (&data->q, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->directories);
				_g_object_unref0 (data->_tmp3_);
				_g_object_unref0 (data->matchers);
				_g_object_unref0 (data->results);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (data->directories);
				_g_object_unref0 (data->_tmp3_);
				_g_object_unref0 (data->matchers);
				_g_object_unref0 (data->results);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	if (data->original_rs == NULL) {
		data->_tmp38_ = 0;
	} else {
		data->_tmp39_ = synapse_result_set_get_size (data->original_rs);
		data->_tmp38_ = data->_tmp39_;
	}
	data->_tmp40_ = synapse_result_set_get_size (data->results);
	synapse_utils_logger_debug ((GObject*) data->self, "found %d extra uris (ZG returned %d)", data->_tmp40_, data->_tmp38_, NULL);
	data->result = data->results;
	_g_object_unref0 (data->directories);
	_g_object_unref0 (data->_tmp3_);
	_g_object_unref0 (data->matchers);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->directories);
	_g_object_unref0 (data->_tmp3_);
	_g_object_unref0 (data->matchers);
	_g_object_unref0 (data->results);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_hybrid_search_plugin_real_search_data_free (gpointer _data) {
	SynapseHybridSearchPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseHybridSearchPluginSearchData, data);
}


static void synapse_hybrid_search_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPlugin * self;
	SynapseHybridSearchPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseHybridSearchPlugin*) base;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	synapse_hybrid_search_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_hybrid_search_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseHybridSearchPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->uris);
		_g_object_unref0 (_data3_->original_rs);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda7_ (SynapseResultSet* rs, guint q_id, Block3Data* _data3_) {
	SynapseHybridSearchPlugin * self;
	SynapseResultSet* _tmp6_;
	SynapseResultSet* _tmp7_;
	self = _data3_->self;
	if (q_id != _data3_->query_id) {
		return;
	}
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _match_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) rs);
		_match_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			GeeMapEntry* match;
			gconstpointer _tmp3_ = NULL;
			SynapseMatch* _tmp4_;
			SynapseUriMatch* uri_match;
			const gchar* _tmp5_ = NULL;
			_tmp1_ = gee_iterator_next (_match_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_match_it);
			match = (GeeMapEntry*) _tmp2_;
			_tmp3_ = gee_map_entry_get_key (match);
			uri_match = (_tmp4_ = (SynapseMatch*) _tmp3_, SYNAPSE_IS_URI_MATCH (_tmp4_) ? ((SynapseUriMatch*) _tmp4_) : NULL);
			if (uri_match == NULL) {
				_g_object_unref0 (match);
				continue;
			}
			_tmp5_ = synapse_uri_match_get_uri (uri_match);
			gee_collection_add ((GeeCollection*) _data3_->uris, _tmp5_);
			_g_object_unref0 (match);
		}
		_g_object_unref0 (_match_it);
	}
	_tmp6_ = _g_object_ref0 (rs);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_data3_->original_rs);
	_data3_->original_rs = _tmp7_;
	synapse_hybrid_search_plugin_real_search_co (_data3_->_async_data_);
}


static void __lambda7__synapse_hybrid_search_plugin_zeitgeist_search_complete (SynapseHybridSearchPlugin* _sender, SynapseResultSet* rs, guint query_id, gpointer self) {
	_lambda7_ (rs, query_id, self);
}


static gboolean _synapse_hybrid_search_plugin_real_search_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_hybrid_search_plugin_real_search_co (self);
	return result;
}


static void _lambda8_ (Block3Data* _data3_) {
	SynapseHybridSearchPlugin * self;
	self = _data3_->self;
	g_signal_handler_block (self, _data3_->sig_id);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_hybrid_search_plugin_real_search_co_gsource_func, _data3_->_async_data_, NULL);
}


static void __lambda8__gcallback (GCancellable* instance, gpointer self) {
	_lambda8_ (self);
}


static void synapse_hybrid_search_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_real_search_co (data);
}


static gboolean synapse_hybrid_search_plugin_real_search_co (SynapseHybridSearchPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data3_ = g_slice_new0 (Block3Data);
	data->_data3_->_ref_count_ = 1;
	data->_data3_->self = g_object_ref (data->self);
	data->_data3_->_async_data_ = data;
	data->our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
	data->common_flags = data->q.query_type & data->our_results;
	if (data->common_flags == 0) {
		data->_tmp0_ = TRUE;
	} else {
		data->_tmp1_ = strlen (data->q.query_string);
		data->_tmp0_ = data->_tmp1_ <= 1;
	}
	if (data->_tmp0_) {
		data->result = NULL;
		block3_data_unref (data->_data3_);
		data->_data3_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->self->priv->current_query != NULL) {
		data->_tmp3_ = g_str_has_prefix (data->q.query_string, data->self->priv->current_query);
		data->_tmp2_ = !data->_tmp3_;
	} else {
		data->_tmp2_ = FALSE;
	}
	if (data->_tmp2_) {
		data->self->priv->hit_level = 0;
		data->self->priv->current_level_uris = 0;
		gee_map_clear (data->self->priv->directory_hits);
	}
	data->_data3_->query_id = data->q.query_id;
	data->_tmp4_ = g_strdup (data->q.query_string);
	data->_tmp5_ = data->_tmp4_;
	_g_free0 (data->self->priv->current_query);
	data->self->priv->current_query = data->_tmp5_;
	data->last_level_uris = data->self->priv->current_level_uris;
	data->_data3_->original_rs = NULL;
	data->_tmp6_ = NULL;
	data->_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	data->_data3_->uris = (GeeSet*) data->_tmp6_;
	data->_tmp7_ = g_signal_connect_data (data->self, "zeitgeist-search-complete", (GCallback) __lambda7__synapse_hybrid_search_plugin_zeitgeist_search_complete, block3_data_ref (data->_data3_), (GClosureNotify) block3_data_unref, 0);
	data->_data3_->sig_id = data->_tmp7_;
	data->_tmp8_ = g_cancellable_connect (data->q.cancellable, __lambda8__gcallback, block3_data_ref (data->_data3_), block3_data_unref);
	data->canc_sig_id = data->_tmp8_;
	if (data->self->priv->connected_to_zg) {
		data->_tmp10_ = NULL;
		data->_tmp10_ = synapse_data_sink_get_plugin (data->self->priv->_data_sink, "SynapseZeitgeistPlugin");
		data->_tmp12_ = synapse_activatable_get_enabled ((SynapseActivatable*) (data->_tmp11_ = data->_tmp10_, SYNAPSE_IS_ITEM_PROVIDER (data->_tmp11_) ? ((SynapseItemProvider*) data->_tmp11_) : NULL));
		data->_tmp9_ = data->_tmp12_;
	} else {
		data->_tmp9_ = FALSE;
	}
	if (data->_tmp9_) {
		data->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	g_signal_handler_disconnect (data->self, data->_data3_->sig_id);
	g_cancellable_disconnect (data->q.cancellable, data->canc_sig_id);
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block3_data_unref (data->_data3_);
			data->_data3_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			block3_data_unref (data->_data3_);
			data->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	while (TRUE) {
		if (!(!data->self->priv->initialization_done)) {
			break;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _synapse_hybrid_search_plugin_real_search_co_gsource_func, data, NULL);
		data->_state_ = 2;
		return FALSE;
		_state_2:
		;
	}
	data->_tmp13_ = gee_collection_get_size ((GeeCollection*) data->_data3_->uris);
	data->self->priv->current_level_uris = data->_tmp13_;
	if (data->self->priv->current_level_uris > 0) {
		data->_state_ = 3;
		synapse_hybrid_search_plugin_process_uris (data->self, (GeeCollection*) data->_data3_->uris, synapse_hybrid_search_plugin_search_ready, data);
		return FALSE;
		_state_3:
		synapse_hybrid_search_plugin_process_uris_finish (data->self, data->_res_);
		synapse_query_check_cancellable (&data->q, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				block3_data_unref (data->_data3_);
				data->_data3_ = NULL;
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				block3_data_unref (data->_data3_);
				data->_data3_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	data->self->priv->hit_level++;
	if (data->self->priv->hit_level > 1) {
		data->_tmp15_ = strlen (data->q.query_string);
		data->_tmp14_ = data->_tmp15_ >= 3;
	} else {
		data->_tmp14_ = FALSE;
	}
	if (data->_tmp14_) {
		if ((data->self->priv->current_level_uris * 3) > (2 * data->last_level_uris)) {
			data->_tmp16_ = NULL;
			data->_tmp16_ = synapse_hybrid_search_plugin_get_most_likely_dirs (data->self);
			data->directories = data->_tmp16_;
			data->_state_ = 4;
			synapse_hybrid_search_plugin_process_directories (data->self, (GeeCollection*) data->directories, synapse_hybrid_search_plugin_search_ready, data);
			return FALSE;
			_state_4:
			synapse_hybrid_search_plugin_process_directories_finish (data->self, data->_res_);
			synapse_query_check_cancellable (&data->q, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->directories);
					block3_data_unref (data->_data3_);
					data->_data3_ = NULL;
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (data->directories);
					block3_data_unref (data->_data3_);
					data->_data3_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (data->directories);
		}
	}
	data->_state_ = 5;
	synapse_hybrid_search_plugin_get_extra_results (data->self, &data->q, data->_data3_->original_rs, NULL, synapse_hybrid_search_plugin_search_ready, data);
	return FALSE;
	_state_5:
	data->_tmp17_ = NULL;
	data->_tmp17_ = synapse_hybrid_search_plugin_get_extra_results_finish (data->self, data->_res_, &data->_inner_error_);
	data->_result_ = data->_tmp17_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block3_data_unref (data->_data3_);
			data->_data3_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			block3_data_unref (data->_data3_);
			data->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_result_;
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->_result_);
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_construct (GType object_type) {
	SynapseHybridSearchPlugin * self = NULL;
	self = (SynapseHybridSearchPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_new (void) {
	return synapse_hybrid_search_plugin_construct (SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN);
}


SynapseDataSink* synapse_hybrid_search_plugin_get_data_sink (SynapseHybridSearchPlugin* self) {
	SynapseDataSink* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_data_sink;
	return result;
}


static void synapse_hybrid_search_plugin_set_data_sink (SynapseHybridSearchPlugin* self, SynapseDataSink* value) {
	g_return_if_fail (self != NULL);
	self->priv->_data_sink = value;
	g_object_notify ((GObject *) self, "data-sink");
}


static gboolean synapse_hybrid_search_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseHybridSearchPlugin* self;
	self = (SynapseHybridSearchPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_hybrid_search_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseHybridSearchPlugin* self;
	self = (SynapseHybridSearchPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static GObject * synapse_hybrid_search_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseHybridSearchPlugin * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeMap* _tmp1_;
	GeeHashMap* _tmp2_ = NULL;
	GeeMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (synapse_hybrid_search_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = (GeeMap*) _tmp0_;
	_g_object_unref0 (self->priv->directory_hits);
	self->priv->directory_hits = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SYNAPSE_UTILS_TYPE_FILE_INFO, (GBoxedCopyFunc) synapse_utils_file_info_ref, synapse_utils_file_info_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = (GeeMap*) _tmp2_;
	_g_object_unref0 (self->priv->directory_contents);
	self->priv->directory_contents = _tmp3_;
	synapse_hybrid_search_plugin_analyze_recent_documents (self, NULL, NULL);
	return obj;
}


static SynapseHybridSearchPluginMatchObject* synapse_hybrid_search_plugin_match_object_construct (GType object_type, const gchar* thumbnail_path, const gchar* icon) {
	SynapseHybridSearchPluginMatchObject * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = g_strdup (icon);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup ("");
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = g_strdup (thumbnail_path);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup ("");
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp7_;
	}
	self = (SynapseHybridSearchPluginMatchObject*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp1_, "thumbnail-path", _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp1_);
	return self;
}


static SynapseHybridSearchPluginMatchObject* synapse_hybrid_search_plugin_match_object_new (const gchar* thumbnail_path, const gchar* icon) {
	return synapse_hybrid_search_plugin_match_object_construct (SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, thumbnail_path, icon);
}


static const gchar* synapse_hybrid_search_plugin_match_object_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseHybridSearchPluginMatchObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_hybrid_search_plugin_match_object_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseHybridSearchPluginMatchObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_hybrid_search_plugin_match_object_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseHybridSearchPluginMatchObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_hybrid_search_plugin_match_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_hybrid_search_plugin_match_object_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseHybridSearchPluginMatchObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp1_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_hybrid_search_plugin_match_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static const gchar* synapse_hybrid_search_plugin_match_object_real_get_uri (SynapseUriMatch* base) {
	const gchar* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_uri;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_uri (SynapseUriMatch* base, const gchar* value) {
	SynapseHybridSearchPluginMatchObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


static SynapseQueryFlags synapse_hybrid_search_plugin_match_object_real_get_file_type (SynapseUriMatch* base) {
	SynapseQueryFlags result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_file_type;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_file_type (SynapseUriMatch* base, SynapseQueryFlags value) {
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_file_type = value;
	g_object_notify ((GObject *) self, "file-type");
}


static const gchar* synapse_hybrid_search_plugin_match_object_real_get_mime_type (SynapseUriMatch* base) {
	const gchar* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_mime_type;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_mime_type (SynapseUriMatch* base, const gchar* value) {
	SynapseHybridSearchPluginMatchObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


static void synapse_hybrid_search_plugin_match_object_class_init (SynapseHybridSearchPluginMatchObjectClass * klass) {
	synapse_hybrid_search_plugin_match_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseHybridSearchPluginMatchObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_hybrid_search_plugin_match_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_hybrid_search_plugin_match_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_hybrid_search_plugin_match_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MIME_TYPE, "mime-type");
}


static void synapse_hybrid_search_plugin_match_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_hybrid_search_plugin_match_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_hybrid_search_plugin_match_object_real_get_title;
	iface->set_title = synapse_hybrid_search_plugin_match_object_real_set_title;
	iface->get_description = synapse_hybrid_search_plugin_match_object_real_get_description;
	iface->set_description = synapse_hybrid_search_plugin_match_object_real_set_description;
	iface->get_icon_name = synapse_hybrid_search_plugin_match_object_real_get_icon_name;
	iface->set_icon_name = synapse_hybrid_search_plugin_match_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_hybrid_search_plugin_match_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_hybrid_search_plugin_match_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_hybrid_search_plugin_match_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_hybrid_search_plugin_match_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_hybrid_search_plugin_match_object_real_get_match_type;
	iface->set_match_type = synapse_hybrid_search_plugin_match_object_real_set_match_type;
}


static void synapse_hybrid_search_plugin_match_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface) {
	synapse_hybrid_search_plugin_match_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_hybrid_search_plugin_match_object_real_get_uri;
	iface->set_uri = synapse_hybrid_search_plugin_match_object_real_set_uri;
	iface->get_file_type = synapse_hybrid_search_plugin_match_object_real_get_file_type;
	iface->set_file_type = synapse_hybrid_search_plugin_match_object_real_set_file_type;
	iface->get_mime_type = synapse_hybrid_search_plugin_match_object_real_get_mime_type;
	iface->set_mime_type = synapse_hybrid_search_plugin_match_object_real_set_mime_type;
}


static void synapse_hybrid_search_plugin_match_object_instance_init (SynapseHybridSearchPluginMatchObject * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
}


static void synapse_hybrid_search_plugin_match_object_finalize (GObject* obj) {
	SynapseHybridSearchPluginMatchObject * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	G_OBJECT_CLASS (synapse_hybrid_search_plugin_match_object_parent_class)->finalize (obj);
}


static GType synapse_hybrid_search_plugin_match_object_get_type (void) {
	static volatile gsize synapse_hybrid_search_plugin_match_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_hybrid_search_plugin_match_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseHybridSearchPluginMatchObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_hybrid_search_plugin_match_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseHybridSearchPluginMatchObject), 0, (GInstanceInitFunc) synapse_hybrid_search_plugin_match_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_match_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_match_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_hybrid_search_plugin_match_object_type_id;
		synapse_hybrid_search_plugin_match_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseHybridSearchPluginMatchObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_hybrid_search_plugin_match_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_hybrid_search_plugin_match_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		g_once_init_leave (&synapse_hybrid_search_plugin_match_object_type_id__volatile, synapse_hybrid_search_plugin_match_object_type_id);
	}
	return synapse_hybrid_search_plugin_match_object_type_id__volatile;
}


static void _vala_synapse_hybrid_search_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseHybridSearchPluginMatchObject * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_URI:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_hybrid_search_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseHybridSearchPluginMatchObject * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_URI:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_construct (GType object_type, const gchar* path) {
	SynapseHybridSearchPluginDirectoryInfo* self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeMap* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (path != NULL, NULL);
	self = (SynapseHybridSearchPluginDirectoryInfo*) g_type_create_instance (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, NULL, NULL, SYNAPSE_UTILS_TYPE_FILE_INFO, (GBoxedCopyFunc) synapse_utils_file_info_ref, synapse_utils_file_info_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = (GeeMap*) _tmp0_;
	_g_object_unref0 (self->files);
	self->files = _tmp1_;
	_tmp2_ = g_strdup (path);
	_tmp3_ = _tmp2_;
	_g_free0 (self->path);
	self->path = _tmp3_;
	return self;
}


static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_new (const gchar* path) {
	return synapse_hybrid_search_plugin_directory_info_construct (SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, path);
}


static void synapse_hybrid_search_plugin_value_directory_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void synapse_hybrid_search_plugin_value_directory_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		synapse_hybrid_search_plugin_directory_info_unref (value->data[0].v_pointer);
	}
}


static void synapse_hybrid_search_plugin_value_directory_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_hybrid_search_plugin_directory_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer synapse_hybrid_search_plugin_value_directory_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* synapse_hybrid_search_plugin_value_directory_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SynapseHybridSearchPluginDirectoryInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_hybrid_search_plugin_directory_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* synapse_hybrid_search_plugin_value_directory_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SynapseHybridSearchPluginDirectoryInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_hybrid_search_plugin_directory_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* synapse_hybrid_search_plugin_param_spec_directory_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SynapseHybridSearchPluginParamSpecDirectoryInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer synapse_hybrid_search_plugin_value_get_directory_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
	return value->data[0].v_pointer;
}


static void synapse_hybrid_search_plugin_value_set_directory_info (GValue* value, gpointer v_object) {
	SynapseHybridSearchPluginDirectoryInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_hybrid_search_plugin_directory_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_hybrid_search_plugin_directory_info_unref (old);
	}
}


static void synapse_hybrid_search_plugin_value_take_directory_info (GValue* value, gpointer v_object) {
	SynapseHybridSearchPluginDirectoryInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_hybrid_search_plugin_directory_info_unref (old);
	}
}


static void synapse_hybrid_search_plugin_directory_info_class_init (SynapseHybridSearchPluginDirectoryInfoClass * klass) {
	synapse_hybrid_search_plugin_directory_info_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_CLASS (klass)->finalize = synapse_hybrid_search_plugin_directory_info_finalize;
}


static void synapse_hybrid_search_plugin_directory_info_instance_init (SynapseHybridSearchPluginDirectoryInfo * self) {
	self->ref_count = 1;
}


static void synapse_hybrid_search_plugin_directory_info_finalize (SynapseHybridSearchPluginDirectoryInfo* obj) {
	SynapseHybridSearchPluginDirectoryInfo * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO (obj);
	_g_free0 (self->path);
	_g_object_unref0 (self->files);
}


static GType synapse_hybrid_search_plugin_directory_info_get_type (void) {
	static volatile gsize synapse_hybrid_search_plugin_directory_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_hybrid_search_plugin_directory_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_hybrid_search_plugin_value_directory_info_init, synapse_hybrid_search_plugin_value_directory_info_free_value, synapse_hybrid_search_plugin_value_directory_info_copy_value, synapse_hybrid_search_plugin_value_directory_info_peek_pointer, "p", synapse_hybrid_search_plugin_value_directory_info_collect_value, "p", synapse_hybrid_search_plugin_value_directory_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseHybridSearchPluginDirectoryInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_hybrid_search_plugin_directory_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseHybridSearchPluginDirectoryInfo), 0, (GInstanceInitFunc) synapse_hybrid_search_plugin_directory_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_hybrid_search_plugin_directory_info_type_id;
		synapse_hybrid_search_plugin_directory_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseHybridSearchPluginDirectoryInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&synapse_hybrid_search_plugin_directory_info_type_id__volatile, synapse_hybrid_search_plugin_directory_info_type_id);
	}
	return synapse_hybrid_search_plugin_directory_info_type_id__volatile;
}


static gpointer synapse_hybrid_search_plugin_directory_info_ref (gpointer instance) {
	SynapseHybridSearchPluginDirectoryInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void synapse_hybrid_search_plugin_directory_info_unref (gpointer instance) {
	SynapseHybridSearchPluginDirectoryInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void synapse_hybrid_search_plugin_class_init (SynapseHybridSearchPluginClass * klass) {
	synapse_hybrid_search_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseHybridSearchPluginPrivate));
	G_OBJECT_CLASS (klass)->constructed = synapse_hybrid_search_plugin_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_hybrid_search_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_hybrid_search_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_hybrid_search_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_hybrid_search_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK, g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED, "enabled");
	g_signal_new ("zeitgeist_search_complete", SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
	synapse_hybrid_search_plugin_register_plugin ();
}


static void synapse_hybrid_search_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_hybrid_search_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_hybrid_search_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_hybrid_search_plugin_real_deactivate;
	iface->get_enabled = synapse_hybrid_search_plugin_real_get_enabled;
	iface->set_enabled = synapse_hybrid_search_plugin_real_set_enabled;
}


static void synapse_hybrid_search_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_hybrid_search_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (SynapseResultSet* (*)(SynapseItemProvider* ,SynapseQuery* ,GError**)) synapse_hybrid_search_plugin_real_search;
	iface->search_finish = synapse_hybrid_search_plugin_real_search_finish;
}


static void synapse_hybrid_search_plugin_instance_init (SynapseHybridSearchPlugin * self) {
	self->priv = SYNAPSE_HYBRID_SEARCH_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->connected_to_zg = FALSE;
	self->priv->initialization_done = FALSE;
	self->priv->hit_level = 0;
	self->priv->current_level_uris = 0;
	self->priv->current_query = NULL;
}


static void synapse_hybrid_search_plugin_finalize (GObject* obj) {
	SynapseHybridSearchPlugin * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN (obj);
	_g_object_unref0 (self->priv->directory_hits);
	_g_object_unref0 (self->priv->directory_contents);
	_g_free0 (self->priv->current_query);
	G_OBJECT_CLASS (synapse_hybrid_search_plugin_parent_class)->finalize (obj);
}


GType synapse_hybrid_search_plugin_get_type (void) {
	static volatile gsize synapse_hybrid_search_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_hybrid_search_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseHybridSearchPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_hybrid_search_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseHybridSearchPlugin), 0, (GInstanceInitFunc) synapse_hybrid_search_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_hybrid_search_plugin_type_id;
		synapse_hybrid_search_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseHybridSearchPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_hybrid_search_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_hybrid_search_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_hybrid_search_plugin_type_id__volatile, synapse_hybrid_search_plugin_type_id);
	}
	return synapse_hybrid_search_plugin_type_id__volatile;
}


static void _vala_synapse_hybrid_search_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseHybridSearchPlugin * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK:
		g_value_set_object (value, synapse_hybrid_search_plugin_get_data_sink (self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_hybrid_search_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseHybridSearchPlugin * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK:
		synapse_hybrid_search_plugin_set_data_sink (self, g_value_get_object (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



