/* devhelp-search.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from devhelp-search.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>


#define SYNAPSE_TYPE_DEVHELP_PLUGIN (synapse_devhelp_plugin_get_type ())
#define SYNAPSE_DEVHELP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin))
#define SYNAPSE_DEVHELP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPluginClass))
#define SYNAPSE_IS_DEVHELP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DEVHELP_PLUGIN))
#define SYNAPSE_IS_DEVHELP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DEVHELP_PLUGIN))
#define SYNAPSE_DEVHELP_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPluginClass))

typedef struct _SynapseDevhelpPlugin SynapseDevhelpPlugin;
typedef struct _SynapseDevhelpPluginClass SynapseDevhelpPluginClass;
typedef struct _SynapseDevhelpPluginPrivate SynapseDevhelpPluginPrivate;

#define SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH (synapse_devhelp_plugin_search_get_type ())
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch))
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearchClass))
#define SYNAPSE_DEVHELP_PLUGIN_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH))
#define SYNAPSE_DEVHELP_PLUGIN_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH))
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearchClass))

typedef struct _SynapseDevhelpPluginSearch SynapseDevhelpPluginSearch;
typedef struct _SynapseDevhelpPluginSearchClass SynapseDevhelpPluginSearchClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDevhelpPluginSearchPrivate SynapseDevhelpPluginSearchPrivate;

struct _SynapseDevhelpPlugin {
	GObject parent_instance;
	SynapseDevhelpPluginPrivate * priv;
};

struct _SynapseDevhelpPluginClass {
	GObjectClass parent_class;
};

struct _SynapseDevhelpPluginPrivate {
	gboolean _enabled;
	SynapseDevhelpPluginSearch* action;
	gboolean has_devhelp;
	GRegex* symbol_re;
};

struct _SynapseDevhelpPluginSearch {
	GObject parent_instance;
	SynapseDevhelpPluginSearchPrivate * priv;
};

struct _SynapseDevhelpPluginSearchClass {
	GObjectClass parent_class;
};

struct _SynapseDevhelpPluginSearchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
};


static gpointer synapse_devhelp_plugin_parent_class = NULL;
static gpointer synapse_devhelp_plugin_search_parent_class = NULL;
static SynapseMatchIface* synapse_devhelp_plugin_search_synapse_match_parent_iface = NULL;
static SynapseActivatableIface* synapse_devhelp_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface* synapse_devhelp_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_devhelp_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_devhelp_plugin_search_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_DEVHELP_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPluginPrivate))
enum  {
	SYNAPSE_DEVHELP_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_ENABLED
};
static void synapse_devhelp_plugin_real_activate (SynapseActivatable* base);
static void synapse_devhelp_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_devhelp_plugin_register_plugin (void);
static void _synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_devhelp_plugin_real_handles_unknown (SynapseActionProvider* base);
static SynapseResultSet* synapse_devhelp_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* query, SynapseMatch* match);
static gint synapse_devhelp_plugin_search_get_default_relevancy (SynapseDevhelpPluginSearch* self);
SynapseDevhelpPlugin* synapse_devhelp_plugin_new (void);
SynapseDevhelpPlugin* synapse_devhelp_plugin_construct (GType object_type);
static GObject * synapse_devhelp_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static SynapseDevhelpPluginSearch* synapse_devhelp_plugin_search_new (void);
static SynapseDevhelpPluginSearch* synapse_devhelp_plugin_search_construct (GType object_type);
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearchPrivate))
enum  {
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_DUMMY_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_TITLE,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_DESCRIPTION,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_ICON_NAME,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_HAS_THUMBNAIL,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_THUMBNAIL_PATH,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_MATCH_TYPE,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY
};
static void synapse_devhelp_plugin_search_real_execute (SynapseMatch* base, SynapseMatch* match);
static void synapse_devhelp_plugin_search_set_default_relevancy (SynapseDevhelpPluginSearch* self, gint value);
static void synapse_devhelp_plugin_search_finalize (GObject* obj);
static void _vala_synapse_devhelp_plugin_search_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_devhelp_plugin_search_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_devhelp_plugin_finalize (GObject* obj);
static void _vala_synapse_devhelp_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_devhelp_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void synapse_devhelp_plugin_real_activate (SynapseActivatable* base) {
	SynapseDevhelpPlugin * self;
	self = (SynapseDevhelpPlugin*) base;
}


static void synapse_devhelp_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseDevhelpPlugin * self;
	self = (SynapseDevhelpPlugin*) base;
}


static void _synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_devhelp_plugin_register_plugin ();
}


static void synapse_devhelp_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Search documentation using Devhelp.");
	_tmp3_ = g_find_program_in_path ("devhelp");
	_tmp4_ = _tmp3_;
	_tmp5_ = _ ("Devhelp is not installed");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DEVHELP_PLUGIN, "Devhelp", _tmp2_, "devhelp", _synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func, _tmp4_ != NULL, _tmp5_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
}


static gboolean synapse_devhelp_plugin_real_handles_unknown (SynapseActionProvider* base) {
	SynapseDevhelpPlugin * self;
	gboolean result = FALSE;
	self = (SynapseDevhelpPlugin*) base;
	result = self->priv->has_devhelp;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static SynapseResultSet* synapse_devhelp_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* query, SynapseMatch* match) {
	SynapseDevhelpPlugin * self;
	SynapseResultSet* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean query_empty;
	SynapseResultSet* _tmp3_ = NULL;
	SynapseResultSet* results;
	self = (SynapseDevhelpPlugin*) base;
	g_return_val_if_fail (match != NULL, NULL);
	if (!self->priv->has_devhelp) {
		_tmp1_ = TRUE;
	} else {
		SynapseMatchType _tmp2_;
		_tmp2_ = synapse_match_get_match_type (match);
		_tmp1_ = _tmp2_ != SYNAPSE_MATCH_TYPE_UNKNOWN;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !(((*query).query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	query_empty = g_strcmp0 ((*query).query_string, "") == 0;
	_tmp3_ = synapse_result_set_new ();
	results = _tmp3_;
	if (query_empty) {
		gint _tmp4_;
		gint relevancy;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp4_ = synapse_devhelp_plugin_search_get_default_relevancy (self->priv->action);
		relevancy = _tmp4_;
		_tmp5_ = synapse_match_get_title (match);
		_tmp6_ = g_regex_match (self->priv->symbol_re, _tmp5_, 0, NULL);
		if (_tmp6_) {
			relevancy = relevancy + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
		}
		synapse_result_set_add (results, (SynapseMatch*) self->priv->action, relevancy);
	} else {
		GeeList* _tmp7_ = NULL;
		GeeList* matchers;
		_tmp7_ = synapse_query_get_matchers_for_query ((*query).query_string, 0, G_REGEX_CASELESS);
		matchers = _tmp7_;
		{
			GeeList* _tmp8_;
			GeeList* _matcher_list;
			gint _tmp9_;
			gint _matcher_size;
			gint _matcher_index;
			_tmp8_ = _g_object_ref0 (matchers);
			_matcher_list = _tmp8_;
			_tmp9_ = gee_collection_get_size ((GeeCollection*) _matcher_list);
			_matcher_size = _tmp9_;
			_matcher_index = -1;
			while (TRUE) {
				gpointer _tmp10_ = NULL;
				GeeMapEntry* matcher;
				gconstpointer _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_;
				_matcher_index = _matcher_index + 1;
				if (!(_matcher_index < _matcher_size)) {
					break;
				}
				_tmp10_ = gee_list_get (_matcher_list, _matcher_index);
				matcher = (GeeMapEntry*) _tmp10_;
				_tmp11_ = gee_map_entry_get_key (matcher);
				_tmp12_ = synapse_match_get_title ((SynapseMatch*) self->priv->action);
				_tmp13_ = g_regex_match ((GRegex*) _tmp11_, _tmp12_, 0, NULL);
				if (_tmp13_) {
					gconstpointer _tmp14_ = NULL;
					_tmp14_ = gee_map_entry_get_value (matcher);
					synapse_result_set_add (results, (SynapseMatch*) self->priv->action, GPOINTER_TO_INT (_tmp14_));
					_g_object_unref0 (matcher);
					break;
				}
				_g_object_unref0 (matcher);
			}
			_g_object_unref0 (_matcher_list);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


SynapseDevhelpPlugin* synapse_devhelp_plugin_construct (GType object_type) {
	SynapseDevhelpPlugin * self = NULL;
	self = (SynapseDevhelpPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseDevhelpPlugin* synapse_devhelp_plugin_new (void) {
	return synapse_devhelp_plugin_construct (SYNAPSE_TYPE_DEVHELP_PLUGIN);
}


static gboolean synapse_devhelp_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseDevhelpPlugin* self;
	self = (SynapseDevhelpPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_devhelp_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseDevhelpPlugin* self;
	self = (SynapseDevhelpPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_devhelp_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDevhelpPlugin * self;
	SynapseDevhelpPluginSearch* _tmp0_ = NULL;
	SynapseDevhelpPluginSearch* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GRegex* _tmp4_ = NULL;
	GRegex* _tmp5_;
	GRegex* _tmp6_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_devhelp_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_DEVHELP_PLUGIN (obj);
	_tmp0_ = synapse_devhelp_plugin_search_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->action);
	self->priv->action = _tmp1_;
	_tmp2_ = g_find_program_in_path ("devhelp");
	_tmp3_ = _tmp2_;
	self->priv->has_devhelp = _tmp3_ != NULL;
	_g_free0 (_tmp3_);
	_tmp4_ = g_regex_new ("^([a-z]+_)|([A-Z]+[a-z]+[A-Z])", G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	_tmp6_ = _tmp5_;
	_g_regex_unref0 (self->priv->symbol_re);
	self->priv->symbol_re = _tmp6_;
	goto __finally12;
	__catch12_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("devhelp-search.vala:107: %s", err->message);
		_g_error_free0 (err);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void synapse_devhelp_plugin_search_real_execute (SynapseMatch* base, SynapseMatch* match) {
	SynapseDevhelpPluginSearch * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GAppInfo* _tmp3_ = NULL;
	GAppInfo* _tmp4_;
	GAppInfo* _tmp5_;
	GAppInfo* ai;
	GdkAppLaunchContext* _tmp6_ = NULL;
	GdkAppLaunchContext* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (SynapseDevhelpPluginSearch*) base;
	_tmp0_ = synapse_match_get_title (match);
	_tmp1_ = g_strdup_printf ("devhelp -s \"%s\"", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_app_info_create_from_commandline (_tmp2_, "devhelp", 0, &_inner_error_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	ai = (_tmp5_ = _tmp4_, _g_free0 (_tmp2_), _tmp5_);
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tmp6_ = gdk_app_launch_context_new ();
	_tmp7_ = _tmp6_;
	g_app_info_launch (ai, NULL, (GAppLaunchContext*) _tmp7_, &_inner_error_);
	_g_object_unref0 (_tmp7_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ai);
		goto __catch13_g_error;
	}
	_g_object_unref0 (ai);
	goto __finally13;
	__catch13_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("devhelp-search.vala:61: %s", err->message);
		_g_error_free0 (err);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static SynapseDevhelpPluginSearch* synapse_devhelp_plugin_search_construct (GType object_type) {
	SynapseDevhelpPluginSearch * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Search in Devhelp");
	_tmp1_ = _ ("Search documentation for this symbol");
	self = (SynapseDevhelpPluginSearch*) g_object_new (object_type, "title", _tmp0_, "description", _tmp1_, "has-thumbnail", FALSE, "icon-name", "devhelp", NULL);
	return self;
}


static SynapseDevhelpPluginSearch* synapse_devhelp_plugin_search_new (void) {
	return synapse_devhelp_plugin_search_construct (SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH);
}


static const gchar* synapse_devhelp_plugin_search_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseDevhelpPluginSearch* self;
	self = (SynapseDevhelpPluginSearch*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_devhelp_plugin_search_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseDevhelpPluginSearch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDevhelpPluginSearch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_devhelp_plugin_search_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseDevhelpPluginSearch* self;
	self = (SynapseDevhelpPluginSearch*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_devhelp_plugin_search_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseDevhelpPluginSearch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDevhelpPluginSearch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_devhelp_plugin_search_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseDevhelpPluginSearch* self;
	self = (SynapseDevhelpPluginSearch*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_devhelp_plugin_search_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseDevhelpPluginSearch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDevhelpPluginSearch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_devhelp_plugin_search_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseDevhelpPluginSearch* self;
	self = (SynapseDevhelpPluginSearch*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_devhelp_plugin_search_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseDevhelpPluginSearch* self;
	self = (SynapseDevhelpPluginSearch*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_devhelp_plugin_search_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseDevhelpPluginSearch* self;
	self = (SynapseDevhelpPluginSearch*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_devhelp_plugin_search_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseDevhelpPluginSearch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDevhelpPluginSearch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp1_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_devhelp_plugin_search_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseDevhelpPluginSearch* self;
	self = (SynapseDevhelpPluginSearch*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_devhelp_plugin_search_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseDevhelpPluginSearch* self;
	self = (SynapseDevhelpPluginSearch*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static gint synapse_devhelp_plugin_search_get_default_relevancy (SynapseDevhelpPluginSearch* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}


static void synapse_devhelp_plugin_search_set_default_relevancy (SynapseDevhelpPluginSearch* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_default_relevancy = value;
	g_object_notify ((GObject *) self, "default-relevancy");
}


static void synapse_devhelp_plugin_search_class_init (SynapseDevhelpPluginSearchClass * klass) {
	synapse_devhelp_plugin_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDevhelpPluginSearchPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_devhelp_plugin_search_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_devhelp_plugin_search_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_devhelp_plugin_search_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_MATCH_TYPE, "match-type");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY, g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_devhelp_plugin_search_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_devhelp_plugin_search_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->execute = (void (*)(SynapseMatch* ,SynapseMatch*)) synapse_devhelp_plugin_search_real_execute;
	iface->get_title = synapse_devhelp_plugin_search_real_get_title;
	iface->set_title = synapse_devhelp_plugin_search_real_set_title;
	iface->get_description = synapse_devhelp_plugin_search_real_get_description;
	iface->set_description = synapse_devhelp_plugin_search_real_set_description;
	iface->get_icon_name = synapse_devhelp_plugin_search_real_get_icon_name;
	iface->set_icon_name = synapse_devhelp_plugin_search_real_set_icon_name;
	iface->get_has_thumbnail = synapse_devhelp_plugin_search_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_devhelp_plugin_search_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_devhelp_plugin_search_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_devhelp_plugin_search_real_set_thumbnail_path;
	iface->get_match_type = synapse_devhelp_plugin_search_real_get_match_type;
	iface->set_match_type = synapse_devhelp_plugin_search_real_set_match_type;
}


static void synapse_devhelp_plugin_search_instance_init (SynapseDevhelpPluginSearch * self) {
	self->priv = SYNAPSE_DEVHELP_PLUGIN_SEARCH_GET_PRIVATE (self);
	self->priv->_default_relevancy = 0;
}


static void synapse_devhelp_plugin_search_finalize (GObject* obj) {
	SynapseDevhelpPluginSearch * self;
	self = SYNAPSE_DEVHELP_PLUGIN_SEARCH (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_devhelp_plugin_search_parent_class)->finalize (obj);
}


static GType synapse_devhelp_plugin_search_get_type (void) {
	static volatile gsize synapse_devhelp_plugin_search_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_devhelp_plugin_search_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDevhelpPluginSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_devhelp_plugin_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDevhelpPluginSearch), 0, (GInstanceInitFunc) synapse_devhelp_plugin_search_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_devhelp_plugin_search_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_devhelp_plugin_search_type_id;
		synapse_devhelp_plugin_search_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDevhelpPluginSearch", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_devhelp_plugin_search_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_once_init_leave (&synapse_devhelp_plugin_search_type_id__volatile, synapse_devhelp_plugin_search_type_id);
	}
	return synapse_devhelp_plugin_search_type_id__volatile;
}


static void _vala_synapse_devhelp_plugin_search_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDevhelpPluginSearch * self;
	self = SYNAPSE_DEVHELP_PLUGIN_SEARCH (object);
	switch (property_id) {
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY:
		g_value_set_int (value, synapse_devhelp_plugin_search_get_default_relevancy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_devhelp_plugin_search_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDevhelpPluginSearch * self;
	self = SYNAPSE_DEVHELP_PLUGIN_SEARCH (object);
	switch (property_id) {
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY:
		synapse_devhelp_plugin_search_set_default_relevancy (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_devhelp_plugin_class_init (SynapseDevhelpPluginClass * klass) {
	synapse_devhelp_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDevhelpPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_devhelp_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_devhelp_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_devhelp_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_devhelp_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_ENABLED, "enabled");
	synapse_devhelp_plugin_register_plugin ();
}


static void synapse_devhelp_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_devhelp_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_devhelp_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_devhelp_plugin_real_deactivate;
	iface->get_enabled = synapse_devhelp_plugin_real_get_enabled;
	iface->set_enabled = synapse_devhelp_plugin_real_set_enabled;
}


static void synapse_devhelp_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface) {
	synapse_devhelp_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_unknown = (gboolean (*)(SynapseActionProvider*)) synapse_devhelp_plugin_real_handles_unknown;
	iface->find_for_match = (SynapseResultSet* (*)(SynapseActionProvider* ,SynapseQuery* ,SynapseMatch*)) synapse_devhelp_plugin_real_find_for_match;
}


static void synapse_devhelp_plugin_instance_init (SynapseDevhelpPlugin * self) {
	self->priv = SYNAPSE_DEVHELP_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_devhelp_plugin_finalize (GObject* obj) {
	SynapseDevhelpPlugin * self;
	self = SYNAPSE_DEVHELP_PLUGIN (obj);
	_g_object_unref0 (self->priv->action);
	_g_regex_unref0 (self->priv->symbol_re);
	G_OBJECT_CLASS (synapse_devhelp_plugin_parent_class)->finalize (obj);
}


GType synapse_devhelp_plugin_get_type (void) {
	static volatile gsize synapse_devhelp_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_devhelp_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDevhelpPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_devhelp_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDevhelpPlugin), 0, (GInstanceInitFunc) synapse_devhelp_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_devhelp_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_devhelp_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_devhelp_plugin_type_id;
		synapse_devhelp_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDevhelpPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_devhelp_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_devhelp_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		g_once_init_leave (&synapse_devhelp_plugin_type_id__volatile, synapse_devhelp_plugin_type_id);
	}
	return synapse_devhelp_plugin_type_id__volatile;
}


static void _vala_synapse_devhelp_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDevhelpPlugin * self;
	self = SYNAPSE_DEVHELP_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_DEVHELP_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_devhelp_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDevhelpPlugin * self;
	self = SYNAPSE_DEVHELP_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_DEVHELP_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



