/* desktop-file-plugin.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from desktop-file-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>


#define SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN (synapse_desktop_file_plugin_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))

typedef struct _SynapseDesktopFilePlugin SynapseDesktopFilePlugin;
typedef struct _SynapseDesktopFilePluginClass SynapseDesktopFilePluginClass;
typedef struct _SynapseDesktopFilePluginPrivate SynapseDesktopFilePluginPrivate;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH (synapse_desktop_file_plugin_desktop_file_match_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))

typedef struct _SynapseDesktopFilePluginDesktopFileMatch SynapseDesktopFilePluginDesktopFileMatch;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchClass SynapseDesktopFilePluginDesktopFileMatchClass;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION (synapse_desktop_file_plugin_open_with_action_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))

typedef struct _SynapseDesktopFilePluginOpenWithAction SynapseDesktopFilePluginOpenWithAction;
typedef struct _SynapseDesktopFilePluginOpenWithActionClass SynapseDesktopFilePluginOpenWithActionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseDesktopFilePluginLoadAllDesktopFilesData SynapseDesktopFilePluginLoadAllDesktopFilesData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _SynapseDesktopFilePluginSearchData SynapseDesktopFilePluginSearchData;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchPrivate SynapseDesktopFilePluginDesktopFileMatchPrivate;
typedef struct _SynapseDesktopFilePluginOpenWithActionPrivate SynapseDesktopFilePluginOpenWithActionPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseDesktopFilePlugin {
	GObject parent_instance;
	SynapseDesktopFilePluginPrivate * priv;
};

struct _SynapseDesktopFilePluginClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginPrivate {
	gboolean _enabled;
	GeeList* desktop_files;
	gboolean loading_in_progress;
	GeeMap* mimetype_map;
};

struct _SynapseDesktopFilePluginLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseDesktopFileService* _tmp0_;
	SynapseDesktopFileService* dfs;
	GeeList* _tmp1_;
	GeeList* _dfi_list;
	gint _tmp2_;
	gint _dfi_size;
	gint _dfi_index;
	gpointer _tmp3_;
	SynapseDesktopFileInfo* dfi;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp4_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp5_;
};

struct _Block1Data {
	int _ref_count_;
	SynapseDesktopFilePlugin * self;
	gpointer _async_data_;
};

struct _SynapseDesktopFilePluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block1Data* _data1_;
	gulong _tmp0_;
	gulong signal_id;
	SynapseResultSet* _tmp1_;
	SynapseResultSet* _result_;
	gint _tmp2_;
	SynapseMatcherFlags flags;
	GError * _inner_error_;
};

struct _SynapseDesktopFilePluginDesktopFileMatch {
	GObject parent_instance;
	SynapseDesktopFilePluginDesktopFileMatchPrivate * priv;
};

struct _SynapseDesktopFilePluginDesktopFileMatchClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginDesktopFileMatchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* title_folded;
	gchar* _title_unaccented;
	gchar* _desktop_id;
	gchar* _exec;
};

struct _SynapseDesktopFilePluginOpenWithAction {
	GObject parent_instance;
	SynapseDesktopFilePluginOpenWithActionPrivate * priv;
};

struct _SynapseDesktopFilePluginOpenWithActionClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginOpenWithActionPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	SynapseDesktopFileInfo* _desktop_info;
};


static gpointer synapse_desktop_file_plugin_parent_class = NULL;
static gpointer synapse_desktop_file_plugin_desktop_file_match_parent_class = NULL;
static SynapseMatchIface* synapse_desktop_file_plugin_desktop_file_match_synapse_match_parent_iface = NULL;
static SynapseApplicationMatchIface* synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_parent_iface = NULL;
static gpointer synapse_desktop_file_plugin_open_with_action_parent_class = NULL;
static SynapseMatchIface* synapse_desktop_file_plugin_open_with_action_synapse_match_parent_iface = NULL;
static SynapseActivatableIface* synapse_desktop_file_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_desktop_file_plugin_synapse_item_provider_parent_iface = NULL;
static SynapseActionProviderIface* synapse_desktop_file_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_desktop_file_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_desktop_file_plugin_desktop_file_match_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType synapse_desktop_file_plugin_open_with_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_DESKTOP_FILE_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginPrivate))
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED
};
static void synapse_desktop_file_plugin_real_activate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_register_plugin (void);
static void _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self, GAsyncResult* _res_);
static gboolean synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* data);
static gboolean _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new_for_info (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct_for_info (GType object_type, SynapseDesktopFileInfo* info);
static gint synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self, SynapseDesktopFilePluginDesktopFileMatch* dfm, gint base_relevancy);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self);
static void synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self, SynapseQuery* q, SynapseResultSet* results, SynapseMatcherFlags flags);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self);
static gboolean synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* q);
static void synapse_desktop_file_plugin_real_search_data_free (gpointer _data);
static void synapse_desktop_file_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* data);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (Block1Data* _data1_);
static void __lambda0__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender, gpointer self);
static gboolean _synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self);
static SynapseResultSet* synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* query, SynapseMatch* match);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_construct (GType object_type, SynapseDesktopFileInfo* info);
SynapseDesktopFilePlugin* synapse_desktop_file_plugin_new (void);
SynapseDesktopFilePlugin* synapse_desktop_file_plugin_construct (GType object_type);
static GObject * synapse_desktop_file_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda1_ (SynapseDesktopFilePlugin* self);
static void __lambda1__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender, gpointer self);
static void _lambda2_ (SynapseDesktopFilePlugin* self);
static void __lambda2__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender, gpointer self);
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchPrivate))
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DUMMY_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC
};
static void synapse_desktop_file_plugin_desktop_file_match_init_from_info (SynapseDesktopFilePluginDesktopFileMatch* self, SynapseDesktopFileInfo* info);
static void synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self, const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self, const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self, const gchar* value);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new (void);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type);
static void synapse_desktop_file_plugin_desktop_file_match_finalize (GObject* obj);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionPrivate))
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DUMMY_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO
};
static void synapse_desktop_file_plugin_open_with_action_init_with_info (SynapseDesktopFilePluginOpenWithAction* self, SynapseDesktopFileInfo* info);
static void synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self, SynapseDesktopFileInfo* value);
static void synapse_desktop_file_plugin_open_with_action_real_execute (SynapseMatch* base, SynapseMatch* match);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_plugin_open_with_action_finalize (GObject* obj);
static void _vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_desktop_file_plugin_finalize (GObject* obj);
static void _vala_synapse_desktop_file_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void synapse_desktop_file_plugin_real_activate (SynapseActivatable* base) {
	SynapseDesktopFilePlugin * self;
	self = (SynapseDesktopFilePlugin*) base;
}


static void synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseDesktopFilePlugin * self;
	self = (SynapseDesktopFilePlugin*) base;
}


static void _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_desktop_file_plugin_register_plugin ();
}


static void synapse_desktop_file_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Search for and run applications on your computer.");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, "Application Search", _tmp2_, "system-run", _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}


static void synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data) {
	SynapseDesktopFilePluginLoadAllDesktopFilesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SynapseDesktopFilePluginLoadAllDesktopFilesData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFilePluginLoadAllDesktopFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_plugin_load_all_desktop_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_plugin_load_all_desktop_files_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_desktop_file_plugin_load_all_desktop_files_co (_data_);
}


static void synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self, GAsyncResult* _res_) {
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_desktop_file_plugin_load_all_desktop_files_co (self);
	return result;
}


static gboolean synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->self->priv->loading_in_progress = TRUE;
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func, data, NULL);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	data->_tmp0_ = NULL;
	data->_tmp0_ = synapse_desktop_file_service_get_default ();
	data->dfs = data->_tmp0_;
	{
		data->_tmp1_ = NULL;
		data->_tmp1_ = synapse_desktop_file_service_get_desktop_files (data->dfs);
		data->_dfi_list = data->_tmp1_;
		data->_tmp2_ = gee_collection_get_size ((GeeCollection*) data->_dfi_list);
		data->_dfi_size = data->_tmp2_;
		data->_dfi_index = -1;
		while (TRUE) {
			data->_dfi_index = data->_dfi_index + 1;
			if (!(data->_dfi_index < data->_dfi_size)) {
				break;
			}
			data->_tmp3_ = NULL;
			data->_tmp3_ = gee_list_get (data->_dfi_list, data->_dfi_index);
			data->dfi = (SynapseDesktopFileInfo*) data->_tmp3_;
			data->_tmp4_ = NULL;
			data->_tmp4_ = synapse_desktop_file_plugin_desktop_file_match_new_for_info (data->dfi);
			data->_tmp5_ = data->_tmp4_;
			gee_collection_add ((GeeCollection*) data->self->priv->desktop_files, data->_tmp5_);
			_g_object_unref0 (data->_tmp5_);
			_g_object_unref0 (data->dfi);
		}
		_g_object_unref0 (data->_dfi_list);
	}
	data->self->priv->loading_in_progress = FALSE;
	g_signal_emit_by_name (data->self, "load-complete");
	_g_object_unref0 (data->dfs);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gint synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self, SynapseDesktopFilePluginDesktopFileMatch* dfm, gint base_relevancy) {
	gint result = 0;
	SynapseRelevancyService* _tmp0_ = NULL;
	SynapseRelevancyService* rs;
	const gchar* _tmp1_ = NULL;
	gfloat _tmp2_;
	gfloat popularity;
	gint _tmp3_;
	gint r;
	const gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (dfm != NULL, 0);
	_tmp0_ = synapse_relevancy_service_get_default ();
	rs = _tmp0_;
	_tmp1_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
	_tmp2_ = synapse_relevancy_service_get_application_popularity (rs, _tmp1_);
	popularity = _tmp2_;
	_tmp3_ = synapse_relevancy_service_compute_relevancy (base_relevancy, popularity);
	r = _tmp3_;
	_tmp4_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
	synapse_utils_logger_debug ((GObject*) self, "relevancy for %s: %d", _tmp4_, r, NULL);
	result = r;
	_g_object_unref0 (rs);
	return result;
}


static void synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self, SynapseQuery* q, SynapseResultSet* results, SynapseMatcherFlags flags) {
	GeeList* _tmp0_ = NULL;
	GeeList* matchers;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = synapse_query_get_matchers_for_query ((*q).query_string_folded, flags, G_REGEX_OPTIMIZE);
	matchers = _tmp0_;
	{
		GeeList* _tmp1_;
		GeeList* _dfm_list;
		gint _tmp2_;
		gint _dfm_size;
		gint _dfm_index;
		_tmp1_ = _g_object_ref0 (self->priv->desktop_files);
		_dfm_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _dfm_list);
		_dfm_size = _tmp2_;
		_dfm_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* dfm;
			const gchar* _tmp4_ = NULL;
			const gchar* folded_title;
			const gchar* _tmp5_ = NULL;
			const gchar* unaccented_title;
			gboolean matched;
			gboolean _tmp18_ = FALSE;
			_dfm_index = _dfm_index + 1;
			if (!(_dfm_index < _dfm_size)) {
				break;
			}
			_tmp3_ = gee_list_get (_dfm_list, _dfm_index);
			dfm = (SynapseDesktopFilePluginDesktopFileMatch*) _tmp3_;
			_tmp4_ = synapse_desktop_file_plugin_desktop_file_match_get_title_folded (dfm);
			folded_title = _tmp4_;
			_tmp5_ = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (dfm);
			unaccented_title = _tmp5_;
			matched = FALSE;
			{
				GeeList* _tmp6_;
				GeeList* _matcher_list;
				gint _tmp7_;
				gint _matcher_size;
				gint _matcher_index;
				_tmp6_ = _g_object_ref0 (matchers);
				_matcher_list = _tmp6_;
				_tmp7_ = gee_collection_get_size ((GeeCollection*) _matcher_list);
				_matcher_size = _tmp7_;
				_matcher_index = -1;
				while (TRUE) {
					gpointer _tmp8_ = NULL;
					GeeMapEntry* matcher;
					gconstpointer _tmp9_ = NULL;
					gboolean _tmp10_;
					_matcher_index = _matcher_index + 1;
					if (!(_matcher_index < _matcher_size)) {
						break;
					}
					_tmp8_ = gee_list_get (_matcher_list, _matcher_index);
					matcher = (GeeMapEntry*) _tmp8_;
					_tmp9_ = gee_map_entry_get_key (matcher);
					_tmp10_ = g_regex_match ((GRegex*) _tmp9_, folded_title, 0, NULL);
					if (_tmp10_) {
						gconstpointer _tmp11_ = NULL;
						gint _tmp12_;
						_tmp11_ = gee_map_entry_get_value (matcher);
						_tmp12_ = synapse_desktop_file_plugin_compute_relevancy (self, dfm, GPOINTER_TO_INT (_tmp11_));
						synapse_result_set_add (results, (SynapseMatch*) dfm, _tmp12_);
						matched = TRUE;
						_g_object_unref0 (matcher);
						break;
					} else {
						gboolean _tmp13_ = FALSE;
						if (unaccented_title != NULL) {
							gconstpointer _tmp14_ = NULL;
							gboolean _tmp15_;
							_tmp14_ = gee_map_entry_get_key (matcher);
							_tmp15_ = g_regex_match ((GRegex*) _tmp14_, unaccented_title, 0, NULL);
							_tmp13_ = _tmp15_;
						} else {
							_tmp13_ = FALSE;
						}
						if (_tmp13_) {
							gconstpointer _tmp16_ = NULL;
							gint _tmp17_;
							_tmp16_ = gee_map_entry_get_value (matcher);
							_tmp17_ = synapse_desktop_file_plugin_compute_relevancy (self, dfm, GPOINTER_TO_INT (_tmp16_) - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
							synapse_result_set_add (results, (SynapseMatch*) dfm, _tmp17_);
							matched = TRUE;
							_g_object_unref0 (matcher);
							break;
						}
					}
					_g_object_unref0 (matcher);
				}
				_g_object_unref0 (_matcher_list);
			}
			if (!matched) {
				const gchar* _tmp19_ = NULL;
				gboolean _tmp20_;
				_tmp19_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (dfm);
				_tmp20_ = g_str_has_prefix (_tmp19_, (*q).query_string);
				_tmp18_ = _tmp20_;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				SynapseMatchScore _tmp21_ = 0;
				const gchar* _tmp22_ = NULL;
				gint _tmp23_;
				_tmp22_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (dfm);
				if (g_strcmp0 (_tmp22_, (*q).query_string) == 0) {
					_tmp21_ = SYNAPSE_MATCH_SCORE_VERY_GOOD;
				} else {
					_tmp21_ = SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
				}
				_tmp23_ = synapse_desktop_file_plugin_compute_relevancy (self, dfm, (gint) _tmp21_);
				synapse_result_set_add (results, (SynapseMatch*) dfm, _tmp23_);
			}
			_g_object_unref0 (dfm);
		}
		_g_object_unref0 (_dfm_list);
	}
	_g_object_unref0 (matchers);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* q) {
	SynapseDesktopFilePlugin * self;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	self = (SynapseDesktopFilePlugin*) base;
	if (!(((*q).query_type & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = string_strip ((*q).query_string);
	_tmp1_ = _tmp0_;
	if ((_tmp2_ = g_strcmp0 (_tmp1_, "") == 0, _g_free0 (_tmp1_), _tmp2_)) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void synapse_desktop_file_plugin_real_search_data_free (gpointer _data) {
	SynapseDesktopFilePluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseDesktopFilePluginSearchData, data);
}


static void synapse_desktop_file_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFilePlugin * self;
	SynapseDesktopFilePluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseDesktopFilePlugin*) base;
	_data_ = g_slice_new0 (SynapseDesktopFilePluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_plugin_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	synapse_desktop_file_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_desktop_file_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseDesktopFilePluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (Block1Data* _data1_) {
	SynapseDesktopFilePlugin * self;
	self = _data1_->self;
	synapse_desktop_file_plugin_real_search_co (_data1_->_async_data_);
}


static void __lambda0__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender, gpointer self) {
	_lambda0_ (self);
}


static gboolean _synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_desktop_file_plugin_real_search_co (self);
	return result;
}


static gboolean synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->_async_data_ = data;
	if (data->self->priv->loading_in_progress) {
		data->_tmp0_ = g_signal_connect_data (data->self, "load-complete", (GCallback) __lambda0__synapse_desktop_file_plugin_load_complete, block1_data_ref (data->_data1_), (GClosureNotify) block1_data_unref, 0);
		data->signal_id = data->_tmp0_;
		data->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect (data->self, data->signal_id);
	} else {
		g_idle_add_full (G_PRIORITY_HIGH_IDLE, _synapse_desktop_file_plugin_real_search_co_gsource_func, data, NULL);
		data->_state_ = 2;
		return FALSE;
		_state_2:
		;
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = synapse_result_set_new ();
	data->_result_ = data->_tmp1_;
	data->_tmp2_ = strlen (data->q.query_string);
	if (data->_tmp2_ == 1) {
		data->flags = (SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) | SYNAPSE_MATCHER_FLAGS_NO_FUZZY;
		synapse_desktop_file_plugin_full_search (data->self, &data->q, data->_result_, data->flags);
	} else {
		synapse_desktop_file_plugin_full_search (data->self, &data->q, data->_result_, 0);
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->_result_);
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->_result_);
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_result_;
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->_result_);
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static SynapseResultSet* synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* query, SynapseMatch* match) {
	SynapseDesktopFilePlugin * self;
	SynapseResultSet* result = NULL;
	SynapseMatchType _tmp0_;
	SynapseMatch* _tmp1_;
	SynapseUriMatch* _tmp2_;
	SynapseUriMatch* uri_match;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GeeList* ow_list;
	SynapseResultSet* _tmp19_ = NULL;
	SynapseResultSet* rs;
	self = (SynapseDesktopFilePlugin*) base;
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = synapse_match_get_match_type (match);
	if (_tmp0_ != SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		result = NULL;
		return result;
	}
	_tmp2_ = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_URI_MATCH (_tmp1_) ? ((SynapseUriMatch*) _tmp1_) : NULL));
	uri_match = _tmp2_;
	g_return_val_if_fail (uri_match != NULL, NULL);
	_tmp3_ = synapse_uri_match_get_mime_type (uri_match);
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (uri_match);
		return result;
	}
	_tmp4_ = synapse_uri_match_get_mime_type (uri_match);
	_tmp5_ = gee_map_get (self->priv->mimetype_map, _tmp4_);
	ow_list = (GeeList*) _tmp5_;
	if (ow_list == NULL) {
		GeeLinkedList* _tmp6_ = NULL;
		GeeList* _tmp7_;
		const gchar* _tmp8_ = NULL;
		SynapseDesktopFileService* _tmp9_ = NULL;
		SynapseDesktopFileService* dfs;
		const gchar* _tmp10_ = NULL;
		GeeList* _tmp11_ = NULL;
		GeeList* list_for_mimetype;
		gint _tmp12_;
		_tmp6_ = gee_linked_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		_tmp7_ = (GeeList*) _tmp6_;
		_g_object_unref0 (ow_list);
		ow_list = _tmp7_;
		_tmp8_ = synapse_uri_match_get_mime_type (uri_match);
		gee_map_set (self->priv->mimetype_map, _tmp8_, ow_list);
		_tmp9_ = synapse_desktop_file_service_get_default ();
		dfs = _tmp9_;
		_tmp10_ = synapse_uri_match_get_mime_type (uri_match);
		_tmp11_ = synapse_desktop_file_service_get_desktop_files_for_type (dfs, _tmp10_);
		list_for_mimetype = _tmp11_;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) list_for_mimetype);
		if (_tmp12_ > 1) {
			{
				GeeList* _tmp13_;
				GeeList* _entry_list;
				gint _tmp14_;
				gint _entry_size;
				gint _entry_index;
				_tmp13_ = _g_object_ref0 (list_for_mimetype);
				_entry_list = _tmp13_;
				_tmp14_ = gee_collection_get_size ((GeeCollection*) _entry_list);
				_entry_size = _tmp14_;
				_entry_index = -1;
				while (TRUE) {
					gpointer _tmp15_ = NULL;
					SynapseDesktopFileInfo* entry;
					SynapseDesktopFilePluginOpenWithAction* _tmp16_ = NULL;
					SynapseDesktopFilePluginOpenWithAction* _tmp17_;
					_entry_index = _entry_index + 1;
					if (!(_entry_index < _entry_size)) {
						break;
					}
					_tmp15_ = gee_list_get (_entry_list, _entry_index);
					entry = (SynapseDesktopFileInfo*) _tmp15_;
					_tmp16_ = synapse_desktop_file_plugin_open_with_action_new (entry);
					_tmp17_ = _tmp16_;
					gee_collection_add ((GeeCollection*) ow_list, _tmp17_);
					_g_object_unref0 (_tmp17_);
					_g_object_unref0 (entry);
				}
				_g_object_unref0 (_entry_list);
			}
		} else {
			result = NULL;
			_g_object_unref0 (list_for_mimetype);
			_g_object_unref0 (dfs);
			_g_object_unref0 (ow_list);
			_g_object_unref0 (uri_match);
			return result;
		}
		_g_object_unref0 (list_for_mimetype);
		_g_object_unref0 (dfs);
	} else {
		gint _tmp18_;
		_tmp18_ = gee_collection_get_size ((GeeCollection*) ow_list);
		if (_tmp18_ == 0) {
			result = NULL;
			_g_object_unref0 (ow_list);
			_g_object_unref0 (uri_match);
			return result;
		}
	}
	_tmp19_ = synapse_result_set_new ();
	rs = _tmp19_;
	if (g_strcmp0 ((*query).query_string, "") == 0) {
		{
			GeeList* _tmp20_;
			GeeList* _action_list;
			gint _tmp21_;
			gint _action_size;
			gint _action_index;
			_tmp20_ = _g_object_ref0 (ow_list);
			_action_list = _tmp20_;
			_tmp21_ = gee_collection_get_size ((GeeCollection*) _action_list);
			_action_size = _tmp21_;
			_action_index = -1;
			while (TRUE) {
				gpointer _tmp22_ = NULL;
				SynapseDesktopFilePluginOpenWithAction* action;
				_action_index = _action_index + 1;
				if (!(_action_index < _action_size)) {
					break;
				}
				_tmp22_ = gee_list_get (_action_list, _action_index);
				action = (SynapseDesktopFilePluginOpenWithAction*) _tmp22_;
				synapse_result_set_add (rs, (SynapseMatch*) action, (gint) SYNAPSE_MATCH_SCORE_POOR);
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_list);
		}
	} else {
		GeeList* _tmp23_ = NULL;
		GeeList* matchers;
		_tmp23_ = synapse_query_get_matchers_for_query ((*query).query_string, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
		matchers = _tmp23_;
		{
			GeeList* _tmp24_;
			GeeList* _action_list;
			gint _tmp25_;
			gint _action_size;
			gint _action_index;
			_tmp24_ = _g_object_ref0 (ow_list);
			_action_list = _tmp24_;
			_tmp25_ = gee_collection_get_size ((GeeCollection*) _action_list);
			_action_size = _tmp25_;
			_action_index = -1;
			while (TRUE) {
				gpointer _tmp26_ = NULL;
				SynapseDesktopFilePluginOpenWithAction* action;
				_action_index = _action_index + 1;
				if (!(_action_index < _action_size)) {
					break;
				}
				_tmp26_ = gee_list_get (_action_list, _action_index);
				action = (SynapseDesktopFilePluginOpenWithAction*) _tmp26_;
				{
					GeeList* _tmp27_;
					GeeList* _matcher_list;
					gint _tmp28_;
					gint _matcher_size;
					gint _matcher_index;
					_tmp27_ = _g_object_ref0 (matchers);
					_matcher_list = _tmp27_;
					_tmp28_ = gee_collection_get_size ((GeeCollection*) _matcher_list);
					_matcher_size = _tmp28_;
					_matcher_index = -1;
					while (TRUE) {
						gpointer _tmp29_ = NULL;
						GeeMapEntry* matcher;
						gconstpointer _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
						gboolean _tmp32_;
						_matcher_index = _matcher_index + 1;
						if (!(_matcher_index < _matcher_size)) {
							break;
						}
						_tmp29_ = gee_list_get (_matcher_list, _matcher_index);
						matcher = (GeeMapEntry*) _tmp29_;
						_tmp30_ = gee_map_entry_get_key (matcher);
						_tmp31_ = synapse_match_get_title ((SynapseMatch*) action);
						_tmp32_ = g_regex_match ((GRegex*) _tmp30_, _tmp31_, 0, NULL);
						if (_tmp32_) {
							gconstpointer _tmp33_ = NULL;
							_tmp33_ = gee_map_entry_get_value (matcher);
							synapse_result_set_add (rs, (SynapseMatch*) action, GPOINTER_TO_INT (_tmp33_));
							_g_object_unref0 (matcher);
							break;
						}
						_g_object_unref0 (matcher);
					}
					_g_object_unref0 (_matcher_list);
				}
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_list);
		}
		_g_object_unref0 (matchers);
	}
	result = rs;
	_g_object_unref0 (ow_list);
	_g_object_unref0 (uri_match);
	return result;
}


SynapseDesktopFilePlugin* synapse_desktop_file_plugin_construct (GType object_type) {
	SynapseDesktopFilePlugin * self = NULL;
	self = (SynapseDesktopFilePlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseDesktopFilePlugin* synapse_desktop_file_plugin_new (void) {
	return synapse_desktop_file_plugin_construct (SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN);
}


static gboolean synapse_desktop_file_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseDesktopFilePlugin* self;
	self = (SynapseDesktopFilePlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_desktop_file_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseDesktopFilePlugin* self;
	self = (SynapseDesktopFilePlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static void _lambda1_ (SynapseDesktopFilePlugin* self) {
	self->priv->loading_in_progress = TRUE;
}


static void __lambda1__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender, gpointer self) {
	_lambda1_ (self);
}


static void _lambda2_ (SynapseDesktopFilePlugin* self) {
	gee_map_clear (self->priv->mimetype_map);
	gee_collection_clear ((GeeCollection*) self->priv->desktop_files);
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
}


static void __lambda2__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender, gpointer self) {
	_lambda2_ (self);
}


static GObject * synapse_desktop_file_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePlugin * self;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* _tmp1_;
	GeeHashMap* _tmp2_ = NULL;
	GeeMap* _tmp3_;
	SynapseDesktopFileService* _tmp4_ = NULL;
	SynapseDesktopFileService* dfs;
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_DESKTOP_FILE_PLUGIN (obj);
	_tmp0_ = gee_array_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp1_ = (GeeList*) _tmp0_;
	_g_object_unref0 (self->priv->desktop_files);
	self->priv->desktop_files = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = (GeeMap*) _tmp2_;
	_g_object_unref0 (self->priv->mimetype_map);
	self->priv->mimetype_map = _tmp3_;
	_tmp4_ = synapse_desktop_file_service_get_default ();
	dfs = _tmp4_;
	g_signal_connect_object (dfs, "reload-started", (GCallback) __lambda1__synapse_desktop_file_service_reload_started, self, 0);
	g_signal_connect_object (dfs, "reload-done", (GCallback) __lambda2__synapse_desktop_file_service_reload_done, self, 0);
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
	_g_object_unref0 (dfs);
	return obj;
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->title_folded == NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = synapse_match_get_title ((SynapseMatch*) self);
		_tmp1_ = g_utf8_casefold (_tmp0_, (gssize) (-1));
		_tmp2_ = _tmp1_;
		_g_free0 (self->priv->title_folded);
		self->priv->title_folded = _tmp2_;
	}
	result = self->priv->title_folded;
	return result;
}


static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct_for_info (GType object_type, SynapseDesktopFileInfo* info) {
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = synapse_desktop_file_info_get_filename (info);
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, "filename", _tmp0_, "match-type", SYNAPSE_MATCH_TYPE_APPLICATION, NULL);
	synapse_desktop_file_plugin_desktop_file_match_init_from_info (self, info);
	return self;
}


static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new_for_info (SynapseDesktopFileInfo* info) {
	return synapse_desktop_file_plugin_desktop_file_match_construct_for_info (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, info);
}


static void synapse_desktop_file_plugin_desktop_file_match_init_from_info (SynapseDesktopFilePluginDesktopFileMatch* self, SynapseDesktopFileInfo* info) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = synapse_desktop_file_info_get_name (info);
	synapse_match_set_title ((SynapseMatch*) self, _tmp0_);
	_tmp1_ = synapse_desktop_file_info_get_comment (info);
	synapse_match_set_description ((SynapseMatch*) self, _tmp1_);
	_tmp2_ = synapse_desktop_file_info_get_icon_name (info);
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp2_);
	_tmp3_ = synapse_desktop_file_info_get_exec (info);
	synapse_desktop_file_plugin_desktop_file_match_set_exec (self, _tmp3_);
	_tmp4_ = synapse_desktop_file_info_get_needs_terminal (info);
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp4_);
	_tmp5_ = synapse_desktop_file_info_get_name_folded (info);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (self->priv->title_folded);
	self->priv->title_folded = _tmp7_;
	_tmp8_ = synapse_utils_remove_accents (self->priv->title_folded);
	_tmp9_ = _tmp8_;
	synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) self);
	_tmp11_ = g_path_get_basename (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("application://", _tmp12_, NULL);
	synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp12_);
}


static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type) {
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, NULL);
	return self;
}


static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new (void) {
	return synapse_desktop_file_plugin_desktop_file_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH);
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_desktop_file_plugin_desktop_file_match_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp1_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_desktop_file_plugin_desktop_file_match_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static GAppInfo* synapse_desktop_file_plugin_desktop_file_match_real_get_app_info (SynapseApplicationMatch* base) {
	GAppInfo* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_app_info;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_app_info (SynapseApplicationMatch* base, GAppInfo* value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	GAppInfo* _tmp0_;
	GAppInfo* _tmp1_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_app_info);
	self->priv->_app_info = _tmp1_;
	g_object_notify ((GObject *) self, "app-info");
}


static gboolean synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal (SynapseApplicationMatch* base) {
	gboolean result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_needs_terminal;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_needs_terminal (SynapseApplicationMatch* base, gboolean value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	self->priv->_needs_terminal = value;
	g_object_notify ((GObject *) self, "needs-terminal");
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_real_get_filename (SynapseApplicationMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_filename;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_real_set_filename (SynapseApplicationMatch* base, const gchar* value) {
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	g_object_notify ((GObject *) self, "filename");
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title_unaccented;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_title_unaccented);
	self->priv->_title_unaccented = _tmp1_;
	g_object_notify ((GObject *) self, "title-unaccented");
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_desktop_id;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_desktop_id);
	self->priv->_desktop_id = _tmp1_;
	g_object_notify ((GObject *) self, "desktop-id");
}


static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_exec;
	return result;
}


static void synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_exec);
	self->priv->_exec = _tmp1_;
	g_object_notify ((GObject *) self, "exec");
}


static void synapse_desktop_file_plugin_desktop_file_match_class_init (SynapseDesktopFilePluginDesktopFileMatchClass * klass) {
	synapse_desktop_file_plugin_desktop_file_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDesktopFilePluginDesktopFileMatchPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_desktop_file_match_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_desktop_file_match_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_desktop_file_match_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO, "app-info");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL, "needs-terminal");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME, "filename");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED, g_param_spec_string ("title-unaccented", "title-unaccented", "title-unaccented", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID, g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC, g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_desktop_file_plugin_desktop_file_match_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_desktop_file_plugin_desktop_file_match_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_desktop_file_plugin_desktop_file_match_real_get_title;
	iface->set_title = synapse_desktop_file_plugin_desktop_file_match_real_set_title;
	iface->get_description = synapse_desktop_file_plugin_desktop_file_match_real_get_description;
	iface->set_description = synapse_desktop_file_plugin_desktop_file_match_real_set_description;
	iface->get_icon_name = synapse_desktop_file_plugin_desktop_file_match_real_get_icon_name;
	iface->set_icon_name = synapse_desktop_file_plugin_desktop_file_match_real_set_icon_name;
	iface->get_has_thumbnail = synapse_desktop_file_plugin_desktop_file_match_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_desktop_file_plugin_desktop_file_match_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_desktop_file_plugin_desktop_file_match_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_desktop_file_plugin_desktop_file_match_real_set_thumbnail_path;
	iface->get_match_type = synapse_desktop_file_plugin_desktop_file_match_real_get_match_type;
	iface->set_match_type = synapse_desktop_file_plugin_desktop_file_match_real_set_match_type;
}


static void synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface) {
	synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_app_info = synapse_desktop_file_plugin_desktop_file_match_real_get_app_info;
	iface->set_app_info = synapse_desktop_file_plugin_desktop_file_match_real_set_app_info;
	iface->get_needs_terminal = synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal;
	iface->set_needs_terminal = synapse_desktop_file_plugin_desktop_file_match_real_set_needs_terminal;
	iface->get_filename = synapse_desktop_file_plugin_desktop_file_match_real_get_filename;
	iface->set_filename = synapse_desktop_file_plugin_desktop_file_match_real_set_filename;
}


static void synapse_desktop_file_plugin_desktop_file_match_instance_init (SynapseDesktopFilePluginDesktopFileMatch * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
	self->priv->_app_info = NULL;
	self->priv->_needs_terminal = FALSE;
	self->priv->title_folded = NULL;
	self->priv->_title_unaccented = NULL;
	self->priv->_desktop_id = NULL;
}


static void synapse_desktop_file_plugin_desktop_file_match_finalize (GObject* obj) {
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->title_folded);
	_g_free0 (self->priv->_title_unaccented);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_exec);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_desktop_file_match_parent_class)->finalize (obj);
}


static GType synapse_desktop_file_plugin_desktop_file_match_get_type (void) {
	static volatile gsize synapse_desktop_file_plugin_desktop_file_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_desktop_file_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginDesktopFileMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_desktop_file_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginDesktopFileMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_desktop_file_match_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_desktop_file_match_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_desktop_file_plugin_desktop_file_match_type_id;
		synapse_desktop_file_plugin_desktop_file_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePluginDesktopFileMatch", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_desktop_file_plugin_desktop_file_match_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_desktop_file_plugin_desktop_file_match_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
		g_once_init_leave (&synapse_desktop_file_plugin_desktop_file_match_type_id__volatile, synapse_desktop_file_plugin_desktop_file_match_type_id);
	}
	return synapse_desktop_file_plugin_desktop_file_match_type_id__volatile;
}


static void _vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO:
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL:
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME:
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_exec (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO:
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL:
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME:
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED:
		synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID:
		synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC:
		synapse_desktop_file_plugin_desktop_file_match_set_exec (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_construct (GType object_type, SynapseDesktopFileInfo* info) {
	SynapseDesktopFilePluginOpenWithAction * self = NULL;
	g_return_val_if_fail (info != NULL, NULL);
	self = (SynapseDesktopFilePluginOpenWithAction*) g_object_new (object_type, NULL);
	synapse_desktop_file_plugin_open_with_action_init_with_info (self, info);
	return self;
}


static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info) {
	return synapse_desktop_file_plugin_open_with_action_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, info);
}


static void synapse_desktop_file_plugin_open_with_action_init_with_info (SynapseDesktopFilePluginOpenWithAction* self, SynapseDesktopFileInfo* info) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = _ ("Open with %s");
	_tmp1_ = synapse_desktop_file_info_get_name (info);
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	synapse_match_set_title ((SynapseMatch*) self, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = synapse_desktop_file_info_get_icon_name (info);
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp4_);
	_tmp5_ = _ ("Opens current selection using %s");
	_tmp6_ = synapse_desktop_file_info_get_name (info);
	_tmp7_ = g_strdup_printf (_tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	synapse_match_set_description ((SynapseMatch*) self, _tmp8_);
	_g_free0 (_tmp8_);
	synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, info);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void synapse_desktop_file_plugin_open_with_action_real_execute (SynapseMatch* base, SynapseMatch* match) {
	SynapseDesktopFilePluginOpenWithAction * self;
	SynapseMatch* _tmp0_;
	SynapseUriMatch* _tmp1_;
	SynapseUriMatch* uri_match;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* f;
	const gchar* _tmp4_ = NULL;
	GDesktopAppInfo* _tmp5_ = NULL;
	GDesktopAppInfo* app_info;
	GList* files;
	GFile* _tmp6_;
	GdkAppLaunchContext* _tmp7_ = NULL;
	GdkAppLaunchContext* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp1_ = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL));
	uri_match = _tmp1_;
	g_return_if_fail (uri_match != NULL);
	_tmp2_ = synapse_uri_match_get_uri (uri_match);
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	f = _tmp3_;
	_tmp4_ = synapse_desktop_file_info_get_filename (self->priv->_desktop_info);
	_tmp5_ = g_desktop_app_info_new_from_filename (_tmp4_);
	app_info = _tmp5_;
	files = NULL;
	_tmp6_ = _g_object_ref0 (f);
	files = g_list_prepend (files, _tmp6_);
	_tmp7_ = gdk_app_launch_context_new ();
	_tmp8_ = _tmp7_;
	g_app_info_launch ((GAppInfo*) app_info, files, (GAppLaunchContext*) _tmp8_, &_inner_error_);
	_g_object_unref0 (_tmp8_);
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (files);
		_g_object_unref0 (app_info);
		goto __catch11_g_error;
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (app_info);
	goto __finally11;
	__catch11_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("desktop-file-plugin.vala:284: %s", err->message);
		_g_error_free0 (err);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		_g_object_unref0 (uri_match);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
}


static const gchar* synapse_desktop_file_plugin_open_with_action_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_desktop_file_plugin_open_with_action_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseDesktopFilePluginOpenWithAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_desktop_file_plugin_open_with_action_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_desktop_file_plugin_open_with_action_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseDesktopFilePluginOpenWithAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_desktop_file_plugin_open_with_action_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_desktop_file_plugin_open_with_action_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseDesktopFilePluginOpenWithAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_desktop_file_plugin_open_with_action_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_desktop_file_plugin_open_with_action_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_desktop_file_plugin_open_with_action_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_desktop_file_plugin_open_with_action_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseDesktopFilePluginOpenWithAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp1_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_desktop_file_plugin_open_with_action_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_desktop_file_plugin_open_with_action_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self) {
	SynapseDesktopFileInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_desktop_info;
	return result;
}


static void synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self, SynapseDesktopFileInfo* value) {
	SynapseDesktopFileInfo* _tmp0_;
	SynapseDesktopFileInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_desktop_info);
	self->priv->_desktop_info = _tmp1_;
	g_object_notify ((GObject *) self, "desktop-info");
}


static void synapse_desktop_file_plugin_open_with_action_class_init (SynapseDesktopFilePluginOpenWithActionClass * klass) {
	synapse_desktop_file_plugin_open_with_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDesktopFilePluginOpenWithActionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_open_with_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_open_with_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_open_with_action_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE, "match-type");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO, g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void synapse_desktop_file_plugin_open_with_action_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_desktop_file_plugin_open_with_action_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->execute = (void (*)(SynapseMatch* ,SynapseMatch*)) synapse_desktop_file_plugin_open_with_action_real_execute;
	iface->get_title = synapse_desktop_file_plugin_open_with_action_real_get_title;
	iface->set_title = synapse_desktop_file_plugin_open_with_action_real_set_title;
	iface->get_description = synapse_desktop_file_plugin_open_with_action_real_get_description;
	iface->set_description = synapse_desktop_file_plugin_open_with_action_real_set_description;
	iface->get_icon_name = synapse_desktop_file_plugin_open_with_action_real_get_icon_name;
	iface->set_icon_name = synapse_desktop_file_plugin_open_with_action_real_set_icon_name;
	iface->get_has_thumbnail = synapse_desktop_file_plugin_open_with_action_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_desktop_file_plugin_open_with_action_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_desktop_file_plugin_open_with_action_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_desktop_file_plugin_open_with_action_real_set_thumbnail_path;
	iface->get_match_type = synapse_desktop_file_plugin_open_with_action_real_get_match_type;
	iface->set_match_type = synapse_desktop_file_plugin_open_with_action_real_set_match_type;
}


static void synapse_desktop_file_plugin_open_with_action_instance_init (SynapseDesktopFilePluginOpenWithAction * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
}


static void synapse_desktop_file_plugin_open_with_action_finalize (GObject* obj) {
	SynapseDesktopFilePluginOpenWithAction * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_object_unref0 (self->priv->_desktop_info);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_open_with_action_parent_class)->finalize (obj);
}


static GType synapse_desktop_file_plugin_open_with_action_get_type (void) {
	static volatile gsize synapse_desktop_file_plugin_open_with_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_open_with_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginOpenWithActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_open_with_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginOpenWithAction), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_open_with_action_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_open_with_action_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_desktop_file_plugin_open_with_action_type_id;
		synapse_desktop_file_plugin_open_with_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePluginOpenWithAction", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_desktop_file_plugin_open_with_action_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_once_init_leave (&synapse_desktop_file_plugin_open_with_action_type_id__volatile, synapse_desktop_file_plugin_open_with_action_type_id);
	}
	return synapse_desktop_file_plugin_open_with_action_type_id__volatile;
}


static void _vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDesktopFilePluginOpenWithAction * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO:
		g_value_set_object (value, synapse_desktop_file_plugin_open_with_action_get_desktop_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDesktopFilePluginOpenWithAction * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO:
		synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_desktop_file_plugin_class_init (SynapseDesktopFilePluginClass * klass) {
	synapse_desktop_file_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDesktopFilePluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED, "enabled");
	g_signal_new ("load_complete", SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	synapse_desktop_file_plugin_register_plugin ();
}


static void synapse_desktop_file_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_desktop_file_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_desktop_file_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_desktop_file_plugin_real_deactivate;
	iface->get_enabled = synapse_desktop_file_plugin_real_get_enabled;
	iface->set_enabled = synapse_desktop_file_plugin_real_set_enabled;
}


static void synapse_desktop_file_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_desktop_file_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*)(SynapseItemProvider* ,SynapseQuery*)) synapse_desktop_file_plugin_real_handles_query;
	iface->search = (SynapseResultSet* (*)(SynapseItemProvider* ,SynapseQuery* ,GError**)) synapse_desktop_file_plugin_real_search;
	iface->search_finish = synapse_desktop_file_plugin_real_search_finish;
}


static void synapse_desktop_file_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface) {
	synapse_desktop_file_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_for_match = (SynapseResultSet* (*)(SynapseActionProvider* ,SynapseQuery* ,SynapseMatch*)) synapse_desktop_file_plugin_real_find_for_match;
}


static void synapse_desktop_file_plugin_instance_init (SynapseDesktopFilePlugin * self) {
	self->priv = SYNAPSE_DESKTOP_FILE_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->loading_in_progress = FALSE;
}


static void synapse_desktop_file_plugin_finalize (GObject* obj) {
	SynapseDesktopFilePlugin * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN (obj);
	_g_object_unref0 (self->priv->desktop_files);
	_g_object_unref0 (self->priv->mimetype_map);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class)->finalize (obj);
}


GType synapse_desktop_file_plugin_get_type (void) {
	static volatile gsize synapse_desktop_file_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePlugin), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_desktop_file_plugin_type_id;
		synapse_desktop_file_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		g_once_init_leave (&synapse_desktop_file_plugin_type_id__volatile, synapse_desktop_file_plugin_type_id);
	}
	return synapse_desktop_file_plugin_type_id__volatile;
}


static void _vala_synapse_desktop_file_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDesktopFilePlugin * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_desktop_file_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDesktopFilePlugin * self;
	self = SYNAPSE_DESKTOP_FILE_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



