/* utils.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdarg.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseUtilsQueryExistsAsyncData SynapseUtilsQueryExistsAsyncData;

#define SYNAPSE_UTILS_TYPE_LOGGER (synapse_utils_logger_get_type ())
#define SYNAPSE_UTILS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLogger))
#define SYNAPSE_UTILS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))
#define SYNAPSE_UTILS_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))

typedef struct _SynapseUtilsLogger SynapseUtilsLogger;
typedef struct _SynapseUtilsLoggerClass SynapseUtilsLoggerClass;
typedef struct _SynapseUtilsLoggerPrivate SynapseUtilsLoggerPrivate;
typedef struct _SynapseUtilsParamSpecLogger SynapseUtilsParamSpecLogger;

#define SYNAPSE_UTILS_TYPE_FILE_INFO (synapse_utils_file_info_get_type ())
#define SYNAPSE_UTILS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo))
#define SYNAPSE_UTILS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))
#define SYNAPSE_UTILS_IS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_IS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))

typedef struct _SynapseUtilsFileInfo SynapseUtilsFileInfo;
typedef struct _SynapseUtilsFileInfoClass SynapseUtilsFileInfoClass;
typedef struct _SynapseUtilsFileInfoPrivate SynapseUtilsFileInfoPrivate;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
typedef struct _SynapseUtilsFileInfoInitializeData SynapseUtilsFileInfoInitializeData;
typedef struct _SynapseUtilsFileInfoExistsData SynapseUtilsFileInfoExistsData;
typedef struct _SynapseUtilsParamSpecFileInfo SynapseUtilsParamSpecFileInfo;

struct _SynapseUtilsQueryExistsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* f;
	gboolean result;
	gboolean exists;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseUtilsLogger {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsLoggerPrivate * priv;
};

struct _SynapseUtilsLoggerClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsLogger *self);
};

struct _SynapseUtilsParamSpecLogger {
	GParamSpec parent_instance;
};

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 1,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 3,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 5,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 6,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 7,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 15,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFF | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH
} SynapseMatchType;

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseUtilsFileInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsFileInfoPrivate * priv;
	gchar* uri;
	gchar* parse_name;
	SynapseQueryFlags file_type;
	SynapseUriMatch* match_obj;
};

struct _SynapseUtilsFileInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsFileInfo *self);
};

struct _SynapseUtilsFileInfoPrivate {
	gboolean initialized;
	GType match_obj_type;
};

struct _SynapseUtilsFileInfoInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseUtilsFileInfo* self;
	GFile* _tmp0_;
	GFile* f;
	GFileInfo* _tmp1_;
	GFileInfo* fi;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GFileType _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	GIcon* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GObject* _tmp14_;
	GObject* _tmp15_;
	SynapseUriMatch* _tmp16_;
	const gchar* _tmp17_;
	const gchar* mime_type;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseUtilsFileInfoExistsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseUtilsFileInfo* self;
	gboolean result;
	GFile* _tmp0_;
	GFile* f;
	gboolean _tmp1_;
	gboolean _result_;
};

struct _SynapseUtilsParamSpecFileInfo {
	GParamSpec parent_instance;
};


static gpointer synapse_utils_logger_parent_class = NULL;
static gboolean synapse_utils_logger_initialized;
static gboolean synapse_utils_logger_initialized = FALSE;
static gboolean synapse_utils_logger_show_debug;
static gboolean synapse_utils_logger_show_debug = FALSE;
static gpointer synapse_utils_file_info_parent_class = NULL;
static gchar* synapse_utils_file_info_interesting_attributes;
static gchar* synapse_utils_file_info_interesting_attributes = NULL;

gchar* synapse_utils_remove_accents (const gchar* input);
gchar* synapse_utils_remove_last_unichar (const gchar* input, glong offset);
static void synapse_utils_query_exists_async_data_free (gpointer _data);
void synapse_utils_query_exists_async (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static gboolean synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* data);
static void synapse_utils_query_exists_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* synapse_utils_extract_type_name (GType obj_type);
gpointer synapse_utils_logger_ref (gpointer instance);
void synapse_utils_logger_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_logger (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void synapse_utils_value_set_logger (GValue* value, gpointer v_object);
void synapse_utils_value_take_logger (GValue* value, gpointer v_object);
gpointer synapse_utils_value_get_logger (const GValue* value);
GType synapse_utils_logger_get_type (void) G_GNUC_CONST;
enum  {
	SYNAPSE_UTILS_LOGGER_DUMMY_PROPERTY
};
#define SYNAPSE_UTILS_LOGGER_RED "\x1b[31m"
#define SYNAPSE_UTILS_LOGGER_GREEN "\x1b[32m"
#define SYNAPSE_UTILS_LOGGER_YELLOW "\x1b[33m"
#define SYNAPSE_UTILS_LOGGER_BLUE "\x1b[34m"
#define SYNAPSE_UTILS_LOGGER_MAGENTA "\x1b[35m"
#define SYNAPSE_UTILS_LOGGER_CYAN "\x1b[36m"
#define SYNAPSE_UTILS_LOGGER_RESET "\x1b[0m"
static void synapse_utils_logger_log_internal (GObject* obj, GLogLevelFlags level, const gchar* format, va_list args);
void synapse_utils_logger_handler (const gchar* domain, GLogLevelFlags level, const gchar* msg);
static void _synapse_utils_logger_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
void synapse_utils_logger_log (GObject* obj, const gchar* format, ...);
void synapse_utils_logger_debug (GObject* obj, const gchar* format, ...);
void synapse_utils_logger_warning (GObject* obj, const gchar* format, ...);
void synapse_utils_logger_error (GObject* obj, const gchar* format, ...);
SynapseUtilsLogger* synapse_utils_logger_new (void);
SynapseUtilsLogger* synapse_utils_logger_construct (GType object_type);
static void synapse_utils_logger_finalize (SynapseUtilsLogger* obj);
gpointer synapse_utils_file_info_ref (gpointer instance);
void synapse_utils_file_info_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_file_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void synapse_utils_value_set_file_info (GValue* value, gpointer v_object);
void synapse_utils_value_take_file_info (GValue* value, gpointer v_object);
gpointer synapse_utils_value_get_file_info (const GValue* value);
GType synapse_utils_file_info_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
#define SYNAPSE_UTILS_FILE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoPrivate))
enum  {
	SYNAPSE_UTILS_FILE_INFO_DUMMY_PROPERTY
};
SynapseUtilsFileInfo* synapse_utils_file_info_new (const gchar* uri, GType obj_type);
SynapseUtilsFileInfo* synapse_utils_file_info_construct (GType object_type, const gchar* uri, GType obj_type);
gboolean synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self);
static void synapse_utils_file_info_initialize_data_free (gpointer _data);
void synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_);
static gboolean synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* data);
static void synapse_utils_file_info_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void synapse_uri_match_set_file_type (SynapseUriMatch* self, SynapseQueryFlags value);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self, const gchar* value);
static void synapse_utils_file_info_exists_data_free (gpointer _data);
void synapse_utils_file_info_exists (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_);
static gboolean synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* data);
static void synapse_utils_file_info_exists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_utils_file_info_finalize (SynapseUtilsFileInfo* obj);


gchar* synapse_utils_remove_accents (const gchar* input) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	const gchar* charset = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	g_get_charset (&_tmp0_);
	charset = _tmp0_;
	_tmp1_ = strlen (input);
	_tmp2_ = g_convert (input, (gssize) _tmp1_, "US-ASCII//TRANSLIT", charset, NULL, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_CONVERT_ERROR) {
			goto __catch23_g_convert_error;
		}
		_g_free0 (_result_);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp3_;
	_g_free0 (_result_);
	_result_ = _tmp4_;
	if (g_strcmp0 (input, _result_) == 0) {
		result = NULL;
		_g_free0 (_result_);
		return result;
	}
	goto __finally23;
	__catch23_g_convert_error:
	{
		GError * err;
		gchar* _tmp5_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = NULL;
		_g_free0 (_result_);
		_result_ = _tmp5_;
		_g_error_free0 (err);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_free0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _result_;
	return result;
}


gchar* synapse_utils_remove_last_unichar (const gchar* input, glong offset) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	glong len;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = g_utf8_strlen (input, (gssize) (-1));
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	len = (string_length - offset) - 1;
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = g_utf8_offset_to_pointer (input, offset);
	start = _tmp1_;
	_tmp2_ = g_utf8_offset_to_pointer (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static void synapse_utils_query_exists_async_data_free (gpointer _data) {
	SynapseUtilsQueryExistsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->f);
	g_slice_free (SynapseUtilsQueryExistsAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void synapse_utils_query_exists_async (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = g_slice_new0 (SynapseUtilsQueryExistsAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, synapse_utils_query_exists_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_utils_query_exists_async_data_free);
	_data_->f = _g_object_ref0 (f);
	synapse_utils_query_exists_async_co (_data_);
}


gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_) {
	gboolean result;
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void synapse_utils_query_exists_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseUtilsQueryExistsAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_utils_query_exists_async_co (data);
}


static gboolean synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	g_file_query_info_async (data->f, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_utils_query_exists_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	_g_object_unref0 (data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		goto __catch24_g_error;
	}
	data->exists = TRUE;
	goto __finally24;
	__catch24_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->exists = FALSE;
		_g_error_free0 (data->err);
	}
	__finally24:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->result = data->exists;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = strnlen ((gchar*) self, (gsize) (offset + len));
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


gchar* synapse_utils_extract_type_name (GType obj_type) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* obj_class;
	gboolean _tmp2_;
	_tmp0_ = g_type_name (obj_type);
	_tmp1_ = g_strdup (_tmp0_);
	obj_class = _tmp1_;
	_tmp2_ = g_str_has_prefix (obj_class, "Synapse");
	if (_tmp2_) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = string_substring (obj_class, (glong) 7, (glong) (-1));
		result = _tmp3_;
		_g_free0 (obj_class);
		return result;
	}
	result = obj_class;
	return result;
}


static void _synapse_utils_logger_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	synapse_utils_logger_handler (log_domain, log_levels, message);
}


static void synapse_utils_logger_log_internal (GObject* obj, GLogLevelFlags level, const gchar* format, va_list args) {
	GType _tmp1_ = 0UL;
	GType obj_type;
	gchar* _tmp3_ = NULL;
	gchar* obj_class;
	gchar* _tmp4_ = NULL;
	gchar* pretty_obj;
	gchar* _tmp5_;
	g_return_if_fail (format != NULL);
	if (!synapse_utils_logger_initialized) {
		GLogLevelFlags levels;
		const gchar* _tmp0_ = NULL;
		levels = (((G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_INFO) | G_LOG_LEVEL_WARNING) | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR;
		g_log_set_handler ("Synapse", levels, _synapse_utils_logger_handler_glog_func, NULL);
		_tmp0_ = g_getenv ("SYNAPSE_DEBUG");
		synapse_utils_logger_show_debug = _tmp0_ != NULL;
		synapse_utils_logger_initialized = TRUE;
	}
	if (obj != NULL) {
		GType _tmp2_;
		_tmp2_ = G_TYPE_FROM_INSTANCE (obj);
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = SYNAPSE_UTILS_TYPE_LOGGER;
	}
	obj_type = _tmp1_;
	_tmp3_ = synapse_utils_extract_type_name (obj_type);
	obj_class = _tmp3_;
	_tmp4_ = g_strdup_printf ("%s[%s]%s ", SYNAPSE_UTILS_LOGGER_MAGENTA, obj_class, SYNAPSE_UTILS_LOGGER_RESET);
	pretty_obj = _tmp4_;
	_tmp5_ = g_strconcat (pretty_obj, format, NULL);
	g_logv ("Synapse", level, _tmp5_, args);
	_g_free0 (_tmp5_);
	_g_free0 (pretty_obj);
	_g_free0 (obj_class);
}


void synapse_utils_logger_log (GObject* obj, const gchar* format, ...) {
	va_list args;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_INFO, format, args);
	va_end (args);
}


void synapse_utils_logger_debug (GObject* obj, const gchar* format, ...) {
	va_list args;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_DEBUG, format, args);
	va_end (args);
}


void synapse_utils_logger_warning (GObject* obj, const gchar* format, ...) {
	va_list args;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_WARNING, format, args);
	va_end (args);
}


void synapse_utils_logger_error (GObject* obj, const gchar* format, ...) {
	va_list args;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_ERROR, format, args);
	va_end (args);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void synapse_utils_logger_handler (const gchar* domain, GLogLevelFlags level, const gchar* msg) {
	gchar* header = NULL;
	GTimeVal _tmp0_ = {0};
	GTimeVal _tmp1_ = {0};
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* cur_time;
	g_return_if_fail (msg != NULL);
	g_get_current_time (&_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_time_val_to_iso8601 (&_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (_tmp3_, (glong) 11, (glong) 15);
	cur_time = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
	if (level == G_LOG_LEVEL_DEBUG) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		if (!synapse_utils_logger_show_debug) {
			_g_free0 (cur_time);
			_g_free0 (header);
			return;
		}
		_tmp6_ = string_to_string (SYNAPSE_UTILS_LOGGER_GREEN);
		_tmp7_ = string_to_string (cur_time);
		_tmp8_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
		_tmp9_ = g_strconcat (_tmp6_, "[", _tmp7_, " Debug]", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_g_free0 (header);
		header = _tmp10_;
	} else {
		if (level == G_LOG_LEVEL_INFO) {
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp11_ = string_to_string (SYNAPSE_UTILS_LOGGER_BLUE);
			_tmp12_ = string_to_string (cur_time);
			_tmp13_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
			_tmp14_ = g_strconcat (_tmp11_, "[", _tmp12_, " Info]", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_g_free0 (header);
			header = _tmp15_;
		} else {
			if (level == G_LOG_LEVEL_WARNING) {
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				_tmp16_ = string_to_string (SYNAPSE_UTILS_LOGGER_RED);
				_tmp17_ = string_to_string (cur_time);
				_tmp18_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
				_tmp19_ = g_strconcat (_tmp16_, "[", _tmp17_, " Warning]", _tmp18_, NULL);
				_tmp20_ = _tmp19_;
				_g_free0 (header);
				header = _tmp20_;
			} else {
				gboolean _tmp21_ = FALSE;
				if (level == G_LOG_LEVEL_CRITICAL) {
					_tmp21_ = TRUE;
				} else {
					_tmp21_ = level == G_LOG_LEVEL_ERROR;
				}
				if (_tmp21_) {
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_;
					_tmp22_ = string_to_string (SYNAPSE_UTILS_LOGGER_RED);
					_tmp23_ = string_to_string (cur_time);
					_tmp24_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
					_tmp25_ = g_strconcat (_tmp22_, "[", _tmp23_, " Critical]", _tmp24_, NULL);
					_tmp26_ = _tmp25_;
					_g_free0 (header);
					header = _tmp26_;
				} else {
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					_tmp27_ = string_to_string (SYNAPSE_UTILS_LOGGER_YELLOW);
					_tmp28_ = string_to_string (cur_time);
					_tmp29_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
					_tmp30_ = g_strconcat (_tmp27_, "[", _tmp28_, "]", _tmp29_, NULL);
					_tmp31_ = _tmp30_;
					_g_free0 (header);
					header = _tmp31_;
				}
			}
		}
	}
	fprintf (stdout, "%s %s\n", header, msg);
	_g_free0 (cur_time);
	_g_free0 (header);
}


SynapseUtilsLogger* synapse_utils_logger_construct (GType object_type) {
	SynapseUtilsLogger* self = NULL;
	self = (SynapseUtilsLogger*) g_type_create_instance (object_type);
	return self;
}


SynapseUtilsLogger* synapse_utils_logger_new (void) {
	return synapse_utils_logger_construct (SYNAPSE_UTILS_TYPE_LOGGER);
}


static void synapse_utils_value_logger_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void synapse_utils_value_logger_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		synapse_utils_logger_unref (value->data[0].v_pointer);
	}
}


static void synapse_utils_value_logger_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_utils_logger_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer synapse_utils_value_logger_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* synapse_utils_value_logger_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SynapseUtilsLogger* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_utils_logger_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* synapse_utils_value_logger_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SynapseUtilsLogger** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_utils_logger_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* synapse_utils_param_spec_logger (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SynapseUtilsParamSpecLogger* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer synapse_utils_value_get_logger (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
	return value->data[0].v_pointer;
}


void synapse_utils_value_set_logger (GValue* value, gpointer v_object) {
	SynapseUtilsLogger* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_utils_logger_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_logger_unref (old);
	}
}


void synapse_utils_value_take_logger (GValue* value, gpointer v_object) {
	SynapseUtilsLogger* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_logger_unref (old);
	}
}


static void synapse_utils_logger_class_init (SynapseUtilsLoggerClass * klass) {
	synapse_utils_logger_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_UTILS_LOGGER_CLASS (klass)->finalize = synapse_utils_logger_finalize;
}


static void synapse_utils_logger_instance_init (SynapseUtilsLogger * self) {
	self->ref_count = 1;
}


static void synapse_utils_logger_finalize (SynapseUtilsLogger* obj) {
	SynapseUtilsLogger * self;
	self = SYNAPSE_UTILS_LOGGER (obj);
}


GType synapse_utils_logger_get_type (void) {
	static volatile gsize synapse_utils_logger_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_logger_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_logger_init, synapse_utils_value_logger_free_value, synapse_utils_value_logger_copy_value, synapse_utils_value_logger_peek_pointer, "p", synapse_utils_value_logger_collect_value, "p", synapse_utils_value_logger_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsLogger), 0, (GInstanceInitFunc) synapse_utils_logger_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_utils_logger_type_id;
		synapse_utils_logger_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsLogger", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&synapse_utils_logger_type_id__volatile, synapse_utils_logger_type_id);
	}
	return synapse_utils_logger_type_id__volatile;
}


gpointer synapse_utils_logger_ref (gpointer instance) {
	SynapseUtilsLogger* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void synapse_utils_logger_unref (gpointer instance) {
	SynapseUtilsLogger* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_UTILS_LOGGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


SynapseUtilsFileInfo* synapse_utils_file_info_construct (GType object_type, const gchar* uri, GType obj_type) {
	SynapseUtilsFileInfo* self = NULL;
	gboolean _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SynapseUriMatch* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* f;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (SynapseUtilsFileInfo*) g_type_create_instance (object_type);
	_tmp0_ = g_type_is_a (obj_type, SYNAPSE_TYPE_URI_MATCH);
	g_assert (_tmp0_);
	_tmp1_ = g_strdup (uri);
	_tmp2_ = _tmp1_;
	_g_free0 (self->uri);
	self->uri = _tmp2_;
	_tmp3_ = NULL;
	_g_object_unref0 (self->match_obj);
	self->match_obj = _tmp3_;
	self->priv->match_obj_type = obj_type;
	self->priv->initialized = FALSE;
	self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
	_tmp4_ = g_file_new_for_uri (uri);
	f = _tmp4_;
	_tmp5_ = g_file_get_parse_name (f);
	_tmp6_ = _tmp5_;
	_g_free0 (self->parse_name);
	self->parse_name = _tmp6_;
	_g_object_unref0 (f);
	return self;
}


SynapseUtilsFileInfo* synapse_utils_file_info_new (const gchar* uri, GType obj_type) {
	return synapse_utils_file_info_construct (SYNAPSE_UTILS_TYPE_FILE_INFO, uri, obj_type);
}


gboolean synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->initialized;
	return result;
}


static void synapse_utils_file_info_initialize_data_free (gpointer _data) {
	SynapseUtilsFileInfoInitializeData* data;
	data = _data;
	_synapse_utils_file_info_unref0 (data->self);
	g_slice_free (SynapseUtilsFileInfoInitializeData, data);
}


static gpointer _synapse_utils_file_info_ref0 (gpointer self) {
	return self ? synapse_utils_file_info_ref (self) : NULL;
}


void synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = g_slice_new0 (SynapseUtilsFileInfoInitializeData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, synapse_utils_file_info_initialize);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_utils_file_info_initialize_data_free);
	_data_->self = _synapse_utils_file_info_ref0 (self);
	synapse_utils_file_info_initialize_co (_data_);
}


void synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_) {
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_utils_file_info_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseUtilsFileInfoInitializeData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_utils_file_info_initialize_co (data);
}


static gboolean synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->self->priv->initialized = TRUE;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_new_for_uri (data->self->uri);
	data->f = data->_tmp0_;
	data->_state_ = 1;
	g_file_query_info_async (data->f, synapse_utils_file_info_interesting_attributes, 0, 0, NULL, synapse_utils_file_info_initialize_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
	data->fi = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		goto __catch25_g_error;
	}
	data->_tmp4_ = g_file_info_get_file_type (data->fi);
	if (data->_tmp4_ == G_FILE_TYPE_REGULAR) {
		data->_tmp5_ = g_file_info_get_is_hidden (data->fi);
		data->_tmp3_ = !data->_tmp5_;
	} else {
		data->_tmp3_ = FALSE;
	}
	if (data->_tmp3_) {
		data->_tmp6_ = g_file_info_get_is_backup (data->fi);
		data->_tmp2_ = !data->_tmp6_;
	} else {
		data->_tmp2_ = FALSE;
	}
	if (data->_tmp2_) {
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_file_info_get_attribute_byte_string (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
		data->_tmp8_ = NULL;
		data->_tmp8_ = g_file_info_get_icon (data->fi);
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_icon_to_string (data->_tmp8_);
		data->_tmp10_ = data->_tmp9_;
		data->_tmp11_ = NULL;
		data->_tmp11_ = g_file_info_get_display_name (data->fi);
		data->_tmp12_ = NULL;
		data->_tmp12_ = g_file_get_parse_name (data->f);
		data->_tmp13_ = data->_tmp12_;
		data->_tmp14_ = NULL;
		data->_tmp14_ = g_object_new (data->self->priv->match_obj_type, "thumbnail-path", data->_tmp7_, "icon-name", data->_tmp10_, "uri", data->self->uri, "title", data->_tmp11_, "description", data->_tmp13_, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, NULL, NULL);
		data->_tmp16_ = SYNAPSE_URI_MATCH ((data->_tmp15_ = data->_tmp14_, G_IS_INITIALLY_UNOWNED (data->_tmp15_) ? g_object_ref_sink (data->_tmp15_) : data->_tmp15_));
		_g_object_unref0 (data->self->match_obj);
		data->self->match_obj = data->_tmp16_;
		_g_free0 (data->_tmp13_);
		_g_free0 (data->_tmp10_);
		data->_tmp17_ = NULL;
		data->_tmp17_ = g_file_info_get_attribute_string (data->fi, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
		data->mime_type = data->_tmp17_;
		data->_tmp18_ = g_content_type_is_unknown (data->mime_type);
		if (data->_tmp18_) {
			data->self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
		} else {
			data->_tmp19_ = g_content_type_is_a (data->mime_type, "audio/*");
			if (data->_tmp19_) {
				data->self->file_type = SYNAPSE_QUERY_FLAGS_AUDIO;
			} else {
				data->_tmp20_ = g_content_type_is_a (data->mime_type, "video/*");
				if (data->_tmp20_) {
					data->self->file_type = SYNAPSE_QUERY_FLAGS_VIDEO;
				} else {
					data->_tmp21_ = g_content_type_is_a (data->mime_type, "image/*");
					if (data->_tmp21_) {
						data->self->file_type = SYNAPSE_QUERY_FLAGS_IMAGES;
					} else {
						data->_tmp22_ = g_content_type_is_a (data->mime_type, "text/*");
						if (data->_tmp22_) {
							data->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
						} else {
							data->_tmp23_ = g_content_type_is_a (data->mime_type, "application/*");
							if (data->_tmp23_) {
								data->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
							}
						}
					}
				}
			}
		}
		synapse_uri_match_set_file_type (data->self->match_obj, data->self->file_type);
		synapse_uri_match_set_mime_type (data->self->match_obj, data->mime_type);
	}
	_g_object_unref0 (data->fi);
	goto __finally25;
	__catch25_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("utils.vala:277: %s", data->err->message);
		_g_error_free0 (data->err);
	}
	__finally25:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->f);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_utils_file_info_exists_data_free (gpointer _data) {
	SynapseUtilsFileInfoExistsData* data;
	data = _data;
	_synapse_utils_file_info_unref0 (data->self);
	g_slice_free (SynapseUtilsFileInfoExistsData, data);
}


void synapse_utils_file_info_exists (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = g_slice_new0 (SynapseUtilsFileInfoExistsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, synapse_utils_file_info_exists);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_utils_file_info_exists_data_free);
	_data_->self = _synapse_utils_file_info_ref0 (self);
	synapse_utils_file_info_exists_co (_data_);
}


gboolean synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_) {
	gboolean result;
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void synapse_utils_file_info_exists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseUtilsFileInfoExistsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_utils_file_info_exists_co (data);
}


static gboolean synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_new_for_uri (data->self->uri);
	data->f = data->_tmp0_;
	data->_state_ = 1;
	synapse_utils_query_exists_async (data->f, synapse_utils_file_info_exists_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = synapse_utils_query_exists_finish (data->_res_);
	data->_result_ = data->_tmp1_;
	data->result = data->_result_;
	_g_object_unref0 (data->f);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->f);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_utils_value_file_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void synapse_utils_value_file_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		synapse_utils_file_info_unref (value->data[0].v_pointer);
	}
}


static void synapse_utils_value_file_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_utils_file_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer synapse_utils_value_file_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* synapse_utils_value_file_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SynapseUtilsFileInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_utils_file_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* synapse_utils_value_file_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SynapseUtilsFileInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_utils_file_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* synapse_utils_param_spec_file_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SynapseUtilsParamSpecFileInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer synapse_utils_value_get_file_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
	return value->data[0].v_pointer;
}


void synapse_utils_value_set_file_info (GValue* value, gpointer v_object) {
	SynapseUtilsFileInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_utils_file_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_file_info_unref (old);
	}
}


void synapse_utils_value_take_file_info (GValue* value, gpointer v_object) {
	SynapseUtilsFileInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_file_info_unref (old);
	}
}


static void synapse_utils_file_info_class_init (SynapseUtilsFileInfoClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	synapse_utils_file_info_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_UTILS_FILE_INFO_CLASS (klass)->finalize = synapse_utils_file_info_finalize;
	g_type_class_add_private (klass, sizeof (SynapseUtilsFileInfoPrivate));
	_tmp0_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_free0 (synapse_utils_file_info_interesting_attributes);
	synapse_utils_file_info_interesting_attributes = _tmp1_;
}


static void synapse_utils_file_info_instance_init (SynapseUtilsFileInfo * self) {
	self->priv = SYNAPSE_UTILS_FILE_INFO_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void synapse_utils_file_info_finalize (SynapseUtilsFileInfo* obj) {
	SynapseUtilsFileInfo * self;
	self = SYNAPSE_UTILS_FILE_INFO (obj);
	_g_free0 (self->uri);
	_g_free0 (self->parse_name);
	_g_object_unref0 (self->match_obj);
}


GType synapse_utils_file_info_get_type (void) {
	static volatile gsize synapse_utils_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_file_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_file_info_init, synapse_utils_value_file_info_free_value, synapse_utils_value_file_info_copy_value, synapse_utils_value_file_info_peek_pointer, "p", synapse_utils_value_file_info_collect_value, "p", synapse_utils_value_file_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsFileInfo), 0, (GInstanceInitFunc) synapse_utils_file_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_utils_file_info_type_id;
		synapse_utils_file_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsFileInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&synapse_utils_file_info_type_id__volatile, synapse_utils_file_info_type_id);
	}
	return synapse_utils_file_info_type_id__volatile;
}


gpointer synapse_utils_file_info_ref (gpointer instance) {
	SynapseUtilsFileInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void synapse_utils_file_info_unref (gpointer instance) {
	SynapseUtilsFileInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_UTILS_FILE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



