/* relevancy-backend-zg.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from relevancy-backend-zg.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <zeitgeist.h>
#include <gee.h>
#include <gio/gdesktopappinfo.h>


#define SYNAPSE_TYPE_RELEVANCY_BACKEND (synapse_relevancy_backend_get_type ())
#define SYNAPSE_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackend))
#define SYNAPSE_IS_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND))
#define SYNAPSE_RELEVANCY_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackendIface))

typedef struct _SynapseRelevancyBackend SynapseRelevancyBackend;
typedef struct _SynapseRelevancyBackendIface SynapseRelevancyBackendIface;

#define SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND (synapse_zeitgeist_relevancy_backend_get_type ())
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackend))
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendClass))
#define SYNAPSE_IS_ZEITGEIST_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND))
#define SYNAPSE_IS_ZEITGEIST_RELEVANCY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND))
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendClass))

typedef struct _SynapseZeitgeistRelevancyBackend SynapseZeitgeistRelevancyBackend;
typedef struct _SynapseZeitgeistRelevancyBackendClass SynapseZeitgeistRelevancyBackendClass;
typedef struct _SynapseZeitgeistRelevancyBackendPrivate SynapseZeitgeistRelevancyBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
typedef struct _SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData;
typedef struct _SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SynapseRelevancyBackendIface {
	GTypeInterface parent_iface;
	gfloat (*get_application_popularity) (SynapseRelevancyBackend* self, const gchar* desktop_id);
	gfloat (*get_uri_popularity) (SynapseRelevancyBackend* self, const gchar* uri);
	void (*application_launched) (SynapseRelevancyBackend* self, GAppInfo* app_info);
};

struct _SynapseZeitgeistRelevancyBackend {
	GObject parent_instance;
	SynapseZeitgeistRelevancyBackendPrivate * priv;
};

struct _SynapseZeitgeistRelevancyBackendClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistRelevancyBackendPrivate {
	ZeitgeistLog* zg_log;
	GeeMap* application_popularity;
	GeeMap* uri_popularity;
};

struct _SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	gint64 _tmp0_;
	gint64 end;
	gint64 start;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* tr;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistEvent* event;
	ZeitgeistSubject* _tmp3_;
	ZeitgeistSubject* subject;
	GPtrArray* _tmp4_;
	GPtrArray* ptr_arr;
	ZeitgeistResultSet* rs;
	GPtrArray* _tmp5_;
	ZeitgeistResultSet* _tmp6_;
	ZeitgeistResultSet* _tmp7_;
	ZeitgeistResultSet* _tmp8_;
	guint _tmp9_;
	guint size;
	guint index;
	ZeitgeistResultSet* _tmp10_;
	ZeitgeistResultSet* _e_it;
	ZeitgeistEvent* e;
	ZeitgeistEvent* _tmp11_;
	ZeitgeistEvent* _tmp12_;
	ZeitgeistEvent* _tmp13_;
	gint _tmp14_;
	ZeitgeistSubject* _tmp15_;
	ZeitgeistSubject* _tmp16_;
	ZeitgeistSubject* s;
	gfloat power;
	gfloat _tmp17_;
	gfloat relevancy;
	const gchar* _tmp18_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	gint64 _tmp0_;
	gint64 end;
	gint64 start;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* tr;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistEvent* event;
	ZeitgeistSubject* _tmp3_;
	ZeitgeistSubject* subject;
	GPtrArray* _tmp4_;
	GPtrArray* ptr_arr;
	ZeitgeistResultSet* rs;
	GeeHashMap* _tmp5_;
	GeeMap* popularity_map;
	guint size;
	guint index;
	gfloat power;
	gfloat relevancy;
	GPtrArray* _tmp6_;
	ZeitgeistResultSet* _tmp7_;
	ZeitgeistResultSet* _tmp8_;
	ZeitgeistResultSet* _tmp9_;
	guint _tmp10_;
	ZeitgeistResultSet* _tmp11_;
	ZeitgeistResultSet* _e1_it;
	ZeitgeistEvent* e1;
	ZeitgeistEvent* _tmp12_;
	ZeitgeistEvent* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	gint _tmp15_;
	ZeitgeistSubject* _tmp16_;
	ZeitgeistSubject* _tmp17_;
	ZeitgeistSubject* s1;
	gfloat _tmp18_;
	const gchar* _tmp19_;
	GPtrArray* _tmp20_;
	GPtrArray* _tmp21_;
	GPtrArray* _tmp22_;
	ZeitgeistResultSet* _tmp23_;
	ZeitgeistResultSet* _tmp24_;
	ZeitgeistResultSet* _tmp25_;
	guint _tmp26_;
	ZeitgeistResultSet* _tmp27_;
	ZeitgeistResultSet* _e2_it;
	ZeitgeistEvent* e2;
	ZeitgeistEvent* _tmp28_;
	ZeitgeistEvent* _tmp29_;
	ZeitgeistEvent* _tmp30_;
	gint _tmp31_;
	ZeitgeistSubject* _tmp32_;
	ZeitgeistSubject* _tmp33_;
	ZeitgeistSubject* s2;
	gfloat _tmp34_;
	const gchar* _tmp35_;
	GError * err;
	GeeMap* _tmp36_;
	GeeMap* _tmp37_;
	GError * _inner_error_;
};


static gpointer synapse_zeitgeist_relevancy_backend_parent_class = NULL;
static SynapseRelevancyBackendIface* synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_parent_iface = NULL;

GType synapse_relevancy_backend_get_type (void) G_GNUC_CONST;
GType synapse_zeitgeist_relevancy_backend_get_type (void) G_GNUC_CONST;
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendPrivate))
enum  {
	SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_DUMMY_PROPERTY
};
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER 65535.0f
static gboolean synapse_zeitgeist_relevancy_backend_refresh_popularity (SynapseZeitgeistRelevancyBackend* self);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies (SynapseZeitgeistRelevancyBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_finish (SynapseZeitgeistRelevancyBackend* self, GAsyncResult* _res_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies (SynapseZeitgeistRelevancyBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_finish (SynapseZeitgeistRelevancyBackend* self, GAsyncResult* _res_);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free (gpointer _data);
static gboolean synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* data);
static gboolean _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free (gpointer _data);
static gboolean synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* data);
static gboolean _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gfloat synapse_zeitgeist_relevancy_backend_real_get_application_popularity (SynapseRelevancyBackend* base, const gchar* desktop_id);
static gfloat synapse_zeitgeist_relevancy_backend_real_get_uri_popularity (SynapseRelevancyBackend* base, const gchar* uri);
static void synapse_zeitgeist_relevancy_backend_reload_relevancies (SynapseZeitgeistRelevancyBackend* self);
static gboolean _lambda2_ (SynapseZeitgeistRelevancyBackend* self);
static gboolean __lambda2__gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_real_application_launched (SynapseRelevancyBackend* base, GAppInfo* app_info);
static void synapse_zeitgeist_relevancy_backend_push_app_launch (SynapseZeitgeistRelevancyBackend* self, const gchar* app_uri, const gchar* display_name);
SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_new (void);
SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_construct (GType object_type);
static GObject * synapse_zeitgeist_relevancy_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_finalize (GObject* obj);


static gboolean synapse_zeitgeist_relevancy_backend_refresh_popularity (SynapseZeitgeistRelevancyBackend* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	synapse_zeitgeist_relevancy_backend_load_application_relevancies (self, NULL, NULL);
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies (self, NULL, NULL);
	result = TRUE;
	return result;
}


static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free (gpointer _data) {
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_zeitgeist_relevancy_backend_load_application_relevancies (SynapseZeitgeistRelevancyBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_relevancy_backend_load_application_relevancies);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (_data_);
}


static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_finish (SynapseZeitgeistRelevancyBackend* self, GAsyncResult* _res_) {
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (self);
	return result;
}


static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (data);
}


static gboolean synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_LOW, _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func, data, NULL);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	data->_tmp0_ = zeitgeist_timestamp_for_now ();
	data->end = data->_tmp0_;
	data->start = data->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
	data->_tmp1_ = NULL;
	data->_tmp1_ = zeitgeist_time_range_new (data->start, data->end);
	data->tr = g_object_ref_sink (data->_tmp1_);
	data->_tmp2_ = NULL;
	data->_tmp2_ = zeitgeist_event_new ();
	data->event = g_object_ref_sink (data->_tmp2_);
	zeitgeist_event_set_interpretation (data->event, "!" ZEITGEIST_ZG_LEAVE_EVENT);
	data->_tmp3_ = NULL;
	data->_tmp3_ = zeitgeist_subject_new ();
	data->subject = g_object_ref_sink (data->_tmp3_);
	zeitgeist_subject_set_interpretation (data->subject, ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_subject_set_uri (data->subject, "application://*");
	zeitgeist_event_add_subject (data->event, data->subject);
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_ptr_array_new ();
	data->ptr_arr = data->_tmp4_;
	g_ptr_array_add (data->ptr_arr, data->event);
	data->_tmp5_ = data->ptr_arr;
	data->ptr_arr = NULL;
	data->_state_ = 2;
	zeitgeist_log_find_events (data->self->priv->zg_log, data->tr, data->_tmp5_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready, data);
	return FALSE;
	_state_2:
	data->_tmp6_ = NULL;
	data->_tmp6_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_);
	data->_tmp7_ = data->_tmp6_;
	if (data->_inner_error_ != NULL) {
		goto __catch26_g_error;
	}
	data->_tmp8_ = data->_tmp7_;
	_g_object_unref0 (data->rs);
	data->rs = data->_tmp8_;
	gee_map_clear (data->self->priv->application_popularity);
	data->_tmp9_ = zeitgeist_result_set_size (data->rs);
	data->size = data->_tmp9_;
	data->index = (guint) 0;
	{
		data->_tmp10_ = NULL;
		data->_tmp10_ = _vala_zeitgeist_result_set_iterator (data->rs);
		data->_e_it = data->_tmp10_;
		while (TRUE) {
			data->_tmp11_ = NULL;
			data->_tmp11_ = _vala_zeitgeist_result_set_next_value (data->_e_it);
			data->_tmp12_ = _g_object_ref0 (data->_tmp11_);
			data->_tmp13_ = data->_tmp12_;
			_g_object_unref0 (data->e);
			data->e = data->_tmp13_;
			if (!(data->e != NULL)) {
				break;
			}
			data->_tmp14_ = zeitgeist_event_num_subjects (data->e);
			if (data->_tmp14_ <= 0) {
				continue;
			}
			data->_tmp15_ = NULL;
			data->_tmp15_ = zeitgeist_event_get_subject (data->e, 0);
			data->_tmp16_ = _g_object_ref0 (data->_tmp15_);
			data->s = data->_tmp16_;
			data->power = (data->index / (data->size * 2)) + 0.5f;
			data->_tmp17_ = powf ((gfloat) (data->index + 1), data->power);
			data->relevancy = 1.0f / data->_tmp17_;
			data->_tmp18_ = NULL;
			data->_tmp18_ = zeitgeist_subject_get_uri (data->s);
			gee_map_set (data->self->priv->application_popularity, data->_tmp18_, GINT_TO_POINTER ((gint) (data->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
			data->index++;
			_g_object_unref0 (data->s);
		}
		_g_object_unref0 (data->e);
		_g_object_unref0 (data->_e_it);
	}
	goto __finally26;
	__catch26_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("relevancy-backend-zg.vala:98: %s", data->err->message);
		_g_error_free0 (data->err);
		_g_object_unref0 (data->rs);
		_g_ptr_array_free0 (data->ptr_arr);
		_g_object_unref0 (data->subject);
		_g_object_unref0 (data->event);
		_g_object_unref0 (data->tr);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally26:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->rs);
		_g_ptr_array_free0 (data->ptr_arr);
		_g_object_unref0 (data->subject);
		_g_object_unref0 (data->event);
		_g_object_unref0 (data->tr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->rs);
	_g_ptr_array_free0 (data->ptr_arr);
	_g_object_unref0 (data->subject);
	_g_object_unref0 (data->event);
	_g_object_unref0 (data->tr);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free (gpointer _data) {
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData, data);
}


static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies (SynapseZeitgeistRelevancyBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_relevancy_backend_load_uri_relevancies);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (_data_);
}


static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_finish (SynapseZeitgeistRelevancyBackend* self, GAsyncResult* _res_) {
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (self);
	return result;
}


static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (data);
}


static gboolean synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_LOW, _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func, data, NULL);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	data->_tmp0_ = zeitgeist_timestamp_for_now ();
	data->end = data->_tmp0_;
	data->start = data->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
	data->_tmp1_ = NULL;
	data->_tmp1_ = zeitgeist_time_range_new (data->start, data->end);
	data->tr = g_object_ref_sink (data->_tmp1_);
	data->_tmp2_ = NULL;
	data->_tmp2_ = zeitgeist_event_new ();
	data->event = g_object_ref_sink (data->_tmp2_);
	zeitgeist_event_set_interpretation (data->event, "!" ZEITGEIST_ZG_LEAVE_EVENT);
	data->_tmp3_ = NULL;
	data->_tmp3_ = zeitgeist_subject_new ();
	data->subject = g_object_ref_sink (data->_tmp3_);
	zeitgeist_subject_set_interpretation (data->subject, "!" ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_subject_set_uri (data->subject, "file://*");
	zeitgeist_event_add_subject (data->event, data->subject);
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_ptr_array_new ();
	data->ptr_arr = data->_tmp4_;
	g_ptr_array_add (data->ptr_arr, data->event);
	data->_tmp5_ = NULL;
	data->_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	data->popularity_map = (GeeMap*) data->_tmp5_;
	data->_tmp6_ = data->ptr_arr;
	data->ptr_arr = NULL;
	data->_state_ = 2;
	zeitgeist_log_find_events (data->self->priv->zg_log, data->tr, data->_tmp6_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready, data);
	return FALSE;
	_state_2:
	data->_tmp7_ = NULL;
	data->_tmp7_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_);
	data->_tmp8_ = data->_tmp7_;
	if (data->_inner_error_ != NULL) {
		goto __catch27_g_error;
	}
	data->_tmp9_ = data->_tmp8_;
	_g_object_unref0 (data->rs);
	data->rs = data->_tmp9_;
	data->_tmp10_ = zeitgeist_result_set_size (data->rs);
	data->size = data->_tmp10_;
	data->index = (guint) 0;
	{
		data->_tmp11_ = NULL;
		data->_tmp11_ = _vala_zeitgeist_result_set_iterator (data->rs);
		data->_e1_it = data->_tmp11_;
		while (TRUE) {
			data->_tmp12_ = NULL;
			data->_tmp12_ = _vala_zeitgeist_result_set_next_value (data->_e1_it);
			data->_tmp13_ = _g_object_ref0 (data->_tmp12_);
			data->_tmp14_ = data->_tmp13_;
			_g_object_unref0 (data->e1);
			data->e1 = data->_tmp14_;
			if (!(data->e1 != NULL)) {
				break;
			}
			data->_tmp15_ = zeitgeist_event_num_subjects (data->e1);
			if (data->_tmp15_ <= 0) {
				continue;
			}
			data->_tmp16_ = NULL;
			data->_tmp16_ = zeitgeist_event_get_subject (data->e1, 0);
			data->_tmp17_ = _g_object_ref0 (data->_tmp16_);
			data->s1 = data->_tmp17_;
			data->power = (data->index / (data->size * 2)) + 0.5f;
			data->_tmp18_ = powf ((gfloat) (data->index + 1), data->power);
			data->relevancy = 1.0f / data->_tmp18_;
			data->_tmp19_ = NULL;
			data->_tmp19_ = zeitgeist_subject_get_uri (data->s1);
			gee_map_set (data->popularity_map, data->_tmp19_, GINT_TO_POINTER ((gint) (data->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
			data->index++;
			_g_object_unref0 (data->s1);
		}
		_g_object_unref0 (data->e1);
		_g_object_unref0 (data->_e1_it);
	}
	zeitgeist_subject_set_interpretation (data->subject, ZEITGEIST_NFO_WEBSITE);
	zeitgeist_subject_set_uri (data->subject, "");
	data->_tmp20_ = NULL;
	data->_tmp20_ = g_ptr_array_new ();
	data->_tmp21_ = data->_tmp20_;
	_g_ptr_array_free0 (data->ptr_arr);
	data->ptr_arr = data->_tmp21_;
	g_ptr_array_add (data->ptr_arr, data->event);
	data->_tmp22_ = data->ptr_arr;
	data->ptr_arr = NULL;
	data->_state_ = 3;
	zeitgeist_log_find_events (data->self->priv->zg_log, data->tr, data->_tmp22_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 128, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready, data);
	return FALSE;
	_state_3:
	data->_tmp23_ = NULL;
	data->_tmp23_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_);
	data->_tmp24_ = data->_tmp23_;
	if (data->_inner_error_ != NULL) {
		goto __catch27_g_error;
	}
	data->_tmp25_ = data->_tmp24_;
	_g_object_unref0 (data->rs);
	data->rs = data->_tmp25_;
	data->_tmp26_ = zeitgeist_result_set_size (data->rs);
	data->size = data->_tmp26_;
	data->index = (guint) 0;
	{
		data->_tmp27_ = NULL;
		data->_tmp27_ = _vala_zeitgeist_result_set_iterator (data->rs);
		data->_e2_it = data->_tmp27_;
		while (TRUE) {
			data->_tmp28_ = NULL;
			data->_tmp28_ = _vala_zeitgeist_result_set_next_value (data->_e2_it);
			data->_tmp29_ = _g_object_ref0 (data->_tmp28_);
			data->_tmp30_ = data->_tmp29_;
			_g_object_unref0 (data->e2);
			data->e2 = data->_tmp30_;
			if (!(data->e2 != NULL)) {
				break;
			}
			data->_tmp31_ = zeitgeist_event_num_subjects (data->e2);
			if (data->_tmp31_ <= 0) {
				continue;
			}
			data->_tmp32_ = NULL;
			data->_tmp32_ = zeitgeist_event_get_subject (data->e2, 0);
			data->_tmp33_ = _g_object_ref0 (data->_tmp32_);
			data->s2 = data->_tmp33_;
			data->power = (data->index / (data->size * 2)) + 0.5f;
			data->_tmp34_ = powf ((gfloat) (data->index + 1), data->power);
			data->relevancy = 1.0f / data->_tmp34_;
			data->_tmp35_ = NULL;
			data->_tmp35_ = zeitgeist_subject_get_uri (data->s2);
			gee_map_set (data->popularity_map, data->_tmp35_, GINT_TO_POINTER ((gint) (data->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
			data->index++;
			_g_object_unref0 (data->s2);
		}
		_g_object_unref0 (data->e2);
		_g_object_unref0 (data->_e2_it);
	}
	goto __finally27;
	__catch27_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("relevancy-backend-zg.vala:184: %s", data->err->message);
		_g_error_free0 (data->err);
	}
	__finally27:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->popularity_map);
		_g_object_unref0 (data->rs);
		_g_ptr_array_free0 (data->ptr_arr);
		_g_object_unref0 (data->subject);
		_g_object_unref0 (data->event);
		_g_object_unref0 (data->tr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp36_ = _g_object_ref0 (data->popularity_map);
	data->_tmp37_ = data->_tmp36_;
	_g_object_unref0 (data->self->priv->uri_popularity);
	data->self->priv->uri_popularity = data->_tmp37_;
	_g_object_unref0 (data->popularity_map);
	_g_object_unref0 (data->rs);
	_g_ptr_array_free0 (data->ptr_arr);
	_g_object_unref0 (data->subject);
	_g_object_unref0 (data->event);
	_g_object_unref0 (data->tr);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gfloat synapse_zeitgeist_relevancy_backend_real_get_application_popularity (SynapseRelevancyBackend* base, const gchar* desktop_id) {
	SynapseZeitgeistRelevancyBackend * self;
	gfloat result = 0.0F;
	gboolean _tmp0_;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_val_if_fail (desktop_id != NULL, 0.0F);
	_tmp0_ = gee_map_contains (self->priv->application_popularity, desktop_id);
	if (_tmp0_) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_map_get (self->priv->application_popularity, desktop_id);
		result = GPOINTER_TO_INT (_tmp1_) / SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER;
		return result;
	}
	result = 0.0f;
	return result;
}


static gfloat synapse_zeitgeist_relevancy_backend_real_get_uri_popularity (SynapseRelevancyBackend* base, const gchar* uri) {
	SynapseZeitgeistRelevancyBackend * self;
	gfloat result = 0.0F;
	gboolean _tmp0_;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_val_if_fail (uri != NULL, 0.0F);
	_tmp0_ = gee_map_contains (self->priv->uri_popularity, uri);
	if (_tmp0_) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_map_get (self->priv->uri_popularity, uri);
		result = GPOINTER_TO_INT (_tmp1_) / SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER;
		return result;
	}
	result = 0.0f;
	return result;
}


static gboolean _lambda2_ (SynapseZeitgeistRelevancyBackend* self) {
	gboolean result = FALSE;
	synapse_zeitgeist_relevancy_backend_load_application_relevancies (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static void synapse_zeitgeist_relevancy_backend_reload_relevancies (SynapseZeitgeistRelevancyBackend* self) {
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_LOW, __lambda2__gsource_func, g_object_ref (self), g_object_unref);
}


static void synapse_zeitgeist_relevancy_backend_real_application_launched (SynapseRelevancyBackend* base, GAppInfo* app_info) {
	SynapseZeitgeistRelevancyBackend * self;
	GType _tmp0_;
	GType zg_gio_module;
	gchar* app_uri;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp10_ = NULL;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_if_fail (app_info != NULL);
	_tmp0_ = g_type_from_name ("GAppLaunchHandlerZeitgeist");
	zg_gio_module = _tmp0_;
	if (zg_gio_module != 0) {
		synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
		return;
	}
	app_uri = NULL;
	_tmp1_ = g_app_info_get_id (app_info);
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = g_app_info_get_id (app_info);
		_tmp3_ = g_strconcat ("application://", _tmp2_, NULL);
		_g_free0 (app_uri);
		app_uri = _tmp3_;
	} else {
		if (G_IS_DESKTOP_APP_INFO (app_info)) {
			GAppInfo* _tmp4_;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* filename;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp5_ = g_desktop_app_info_get_filename ((_tmp4_ = app_info, G_IS_DESKTOP_APP_INFO (_tmp4_) ? ((GDesktopAppInfo*) _tmp4_) : NULL));
			_tmp6_ = g_strdup (_tmp5_);
			filename = _tmp6_;
			if (filename == NULL) {
				_g_free0 (filename);
				_g_free0 (app_uri);
				return;
			}
			_tmp7_ = g_path_get_basename (filename);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat ("application://", _tmp8_, NULL);
			_g_free0 (app_uri);
			app_uri = _tmp9_;
			_g_free0 (_tmp8_);
			_g_free0 (filename);
		}
	}
	_tmp10_ = g_app_info_get_display_name (app_info);
	synapse_zeitgeist_relevancy_backend_push_app_launch (self, app_uri, _tmp10_);
	synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
	_g_free0 (app_uri);
}


static void synapse_zeitgeist_relevancy_backend_push_app_launch (SynapseZeitgeistRelevancyBackend* self, const gchar* app_uri, const gchar* display_name) {
	ZeitgeistEvent* _tmp0_ = NULL;
	ZeitgeistEvent* event;
	ZeitgeistSubject* _tmp1_ = NULL;
	ZeitgeistSubject* subject;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_uri != NULL);
	_tmp0_ = zeitgeist_event_new ();
	event = g_object_ref_sink (_tmp0_);
	_tmp1_ = zeitgeist_subject_new ();
	subject = g_object_ref_sink (_tmp1_);
	zeitgeist_event_set_actor (event, "application://synapse.desktop");
	zeitgeist_event_set_interpretation (event, ZEITGEIST_ZG_ACCESS_EVENT);
	zeitgeist_event_set_manifestation (event, ZEITGEIST_ZG_USER_ACTIVITY);
	zeitgeist_event_add_subject (event, subject);
	zeitgeist_subject_set_uri (subject, app_uri);
	zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_subject_set_manifestation (subject, ZEITGEIST_NFO_SOFTWARE_ITEM);
	zeitgeist_subject_set_mimetype (subject, "application/x-desktop");
	zeitgeist_subject_set_text (subject, display_name);
	zeitgeist_log_insert_events_no_reply (self->priv->zg_log, event, NULL, NULL);
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
}


SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_construct (GType object_type) {
	SynapseZeitgeistRelevancyBackend * self = NULL;
	self = (SynapseZeitgeistRelevancyBackend*) g_object_new (object_type, NULL);
	return self;
}


SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_new (void) {
	return synapse_zeitgeist_relevancy_backend_construct (SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND);
}


static gboolean _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_refresh_popularity (self);
	return result;
}


static GObject * synapse_zeitgeist_relevancy_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistRelevancyBackend * self;
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistLog* _tmp1_;
	GeeHashMap* _tmp2_ = NULL;
	GeeMap* _tmp3_;
	GeeHashMap* _tmp4_ = NULL;
	GeeMap* _tmp5_;
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_relevancy_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND (obj);
	_tmp0_ = zeitgeist_log_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->zg_log);
	self->priv->zg_log = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = (GeeMap*) _tmp2_;
	_g_object_unref0 (self->priv->application_popularity);
	self->priv->application_popularity = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp5_ = (GeeMap*) _tmp4_;
	_g_object_unref0 (self->priv->uri_popularity);
	self->priv->uri_popularity = _tmp5_;
	synapse_zeitgeist_relevancy_backend_refresh_popularity (self);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (60 * 30), _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func, g_object_ref (self), g_object_unref);
	return obj;
}


static void synapse_zeitgeist_relevancy_backend_class_init (SynapseZeitgeistRelevancyBackendClass * klass) {
	synapse_zeitgeist_relevancy_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseZeitgeistRelevancyBackendPrivate));
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_relevancy_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_relevancy_backend_finalize;
}


static void synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_interface_init (SynapseRelevancyBackendIface * iface) {
	synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_application_popularity = (gfloat (*)(SynapseRelevancyBackend* ,const gchar*)) synapse_zeitgeist_relevancy_backend_real_get_application_popularity;
	iface->get_uri_popularity = (gfloat (*)(SynapseRelevancyBackend* ,const gchar*)) synapse_zeitgeist_relevancy_backend_real_get_uri_popularity;
	iface->application_launched = (void (*)(SynapseRelevancyBackend* ,GAppInfo*)) synapse_zeitgeist_relevancy_backend_real_application_launched;
}


static void synapse_zeitgeist_relevancy_backend_instance_init (SynapseZeitgeistRelevancyBackend * self) {
	self->priv = SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_GET_PRIVATE (self);
}


static void synapse_zeitgeist_relevancy_backend_finalize (GObject* obj) {
	SynapseZeitgeistRelevancyBackend * self;
	self = SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND (obj);
	_g_object_unref0 (self->priv->zg_log);
	_g_object_unref0 (self->priv->application_popularity);
	_g_object_unref0 (self->priv->uri_popularity);
	G_OBJECT_CLASS (synapse_zeitgeist_relevancy_backend_parent_class)->finalize (obj);
}


GType synapse_zeitgeist_relevancy_backend_get_type (void) {
	static volatile gsize synapse_zeitgeist_relevancy_backend_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_relevancy_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistRelevancyBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_relevancy_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistRelevancyBackend), 0, (GInstanceInitFunc) synapse_zeitgeist_relevancy_backend_instance_init, NULL };
		static const GInterfaceInfo synapse_relevancy_backend_info = { (GInterfaceInitFunc) synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_zeitgeist_relevancy_backend_type_id;
		synapse_zeitgeist_relevancy_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistRelevancyBackend", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_zeitgeist_relevancy_backend_type_id, SYNAPSE_TYPE_RELEVANCY_BACKEND, &synapse_relevancy_backend_info);
		g_once_init_leave (&synapse_zeitgeist_relevancy_backend_type_id__volatile, synapse_zeitgeist_relevancy_backend_type_id);
	}
	return synapse_zeitgeist_relevancy_backend_type_id__volatile;
}



