/* zeitgeist-plugin.c generated by valac 0.11.7.1-263a8, the Vala compiler
 * generated from zeitgeist-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <zeitgeist.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define SYNAPSE_TYPE_ZEITGEIST_PLUGIN (synapse_zeitgeist_plugin_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin))
#define SYNAPSE_ZEITGEIST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPluginClass))
#define SYNAPSE_IS_ZEITGEIST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN))
#define SYNAPSE_IS_ZEITGEIST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEITGEIST_PLUGIN))
#define SYNAPSE_ZEITGEIST_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPluginClass))

typedef struct _SynapseZeitgeistPlugin SynapseZeitgeistPlugin;
typedef struct _SynapseZeitgeistPluginClass SynapseZeitgeistPluginClass;
typedef struct _SynapseZeitgeistPluginPrivate SynapseZeitgeistPluginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT (synapse_zeitgeist_plugin_match_object_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, SynapseZeitgeistPluginMatchObject))
#define SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, SynapseZeitgeistPluginMatchObjectClass))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, SynapseZeitgeistPluginMatchObjectClass))

typedef struct _SynapseZeitgeistPluginMatchObject SynapseZeitgeistPluginMatchObject;
typedef struct _SynapseZeitgeistPluginMatchObjectClass SynapseZeitgeistPluginMatchObjectClass;
typedef struct _SynapseZeitgeistPluginProcessResultsData SynapseZeitgeistPluginProcessResultsData;
typedef struct _SynapseZeitgeistPluginProcessRecentResultsData SynapseZeitgeistPluginProcessRecentResultsData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _SynapseZeitgeistPluginSearchData SynapseZeitgeistPluginSearchData;
typedef struct _SynapseZeitgeistPluginMatchObjectPrivate SynapseZeitgeistPluginMatchObjectPrivate;

struct _SynapseZeitgeistPlugin {
	GObject parent_instance;
	SynapseZeitgeistPluginPrivate * priv;
};

struct _SynapseZeitgeistPluginClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistPluginPrivate {
	gboolean _enabled;
	ZeitgeistIndex* zg_index;
	ZeitgeistLog* zg_log;
	gchar* interesting_attributes;
};

struct _SynapseZeitgeistPluginProcessResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistPlugin* self;
	gchar* query;
	ZeitgeistResultSet* events;
	GCancellable* cancellable;
	SynapseResultSet* real_results;
	gboolean local_only;
	GeeHashSet* _tmp0_;
	GeeSet* uris;
	GeeList* _tmp1_;
	GeeList* matchers;
	SynapseResultSet* _tmp2_;
	SynapseResultSet* results;
	glong minimum;
	glong maximum;
	ZeitgeistResultSet* _tmp3_;
	ZeitgeistResultSet* _event_it;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp4_;
	gint _tmp5_;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* subject;
	const gchar* _tmp8_;
	const gchar* uri;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gint relevancy_penalty;
	gchar* thumbnail_path;
	gchar* icon;
	GFile* _tmp11_;
	GFile* f;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GFileInfo* _tmp16_;
	GFileInfo* fi;
	GIcon* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	GError * err;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* note_filename;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* note_path;
	GFile* _tmp31_;
	GFile* note_f;
	gboolean _tmp32_;
	gboolean exists;
	gboolean _tmp33_;
	GIcon* _tmp34_;
	GIcon* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* mimetype;
	gboolean _tmp38_;
	GIcon* _tmp39_;
	GIcon* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	SynapseZeitgeistPluginMatchObject* _tmp43_;
	SynapseZeitgeistPluginMatchObject* match_obj;
	gboolean match_found;
	GeeList* _tmp44_;
	GeeList* _matcher_list;
	gint _tmp45_;
	gint _matcher_size;
	gint _matcher_index;
	gpointer _tmp46_;
	GeeMapEntry* matcher;
	gchar* adjusted_title;
	gboolean _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gconstpointer _tmp54_;
	gboolean _tmp55_;
	gconstpointer _tmp56_;
	gint _tmp57_;
	gint relevancy;
	GeeSet* _tmp58_;
	GeeSet* _tmp59_;
	GeeIterator* _tmp60_;
	GeeIterator* _tmp61_;
	GeeIterator* _entry_it;
	gboolean _tmp62_;
	gpointer _tmp63_;
	GeeMapEntry* entry;
	gconstpointer _tmp64_;
	SynapseMatch* _tmp65_;
	SynapseZeitgeistPluginMatchObject* _tmp66_;
	SynapseZeitgeistPluginMatchObject* mo;
	gboolean _tmp67_;
	gboolean _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	gboolean _tmp71_;
	const gchar* _tmp72_;
	gint _tmp73_;
	glong len;
	gfloat mult;
	gconstpointer _tmp74_;
	gint adjusted_relevancy;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	gconstpointer _tmp77_;
	GError * _inner_error_;
};

struct _SynapseZeitgeistPluginProcessRecentResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistPlugin* self;
	ZeitgeistResultSet* events;
	GCancellable* cancellable;
	SynapseResultSet* results;
	gboolean local_only;
	GeeHashSet* _tmp0_;
	GeeSet* uris;
	guint _tmp1_;
	guint events_size;
	guint event_index;
	ZeitgeistResultSet* _tmp2_;
	ZeitgeistResultSet* _event_it;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp3_;
	gint _tmp4_;
	ZeitgeistSubject* _tmp5_;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistSubject* subject;
	const gchar* _tmp7_;
	const gchar* uri;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean is_application;
	gint relevancy_penalty;
	gchar* thumbnail_path;
	gchar* icon;
	GFile* _tmp10_;
	GFile* f;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GFileInfo* _tmp15_;
	GFileInfo* fi;
	GIcon* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	GError * err;
	gboolean _tmp22_;
	gboolean _tmp23_;
	SynapseDesktopFileService* _tmp24_;
	SynapseDesktopFileService* dfs;
	gchar* _tmp25_;
	gchar* _tmp26_;
	SynapseDesktopFileInfo* _tmp27_;
	SynapseDesktopFileInfo* _tmp28_;
	gboolean _tmp29_;
	const gchar* _tmp30_;
	const gchar* mimetype;
	gboolean _tmp31_;
	GIcon* _tmp32_;
	GIcon* _tmp33_;
	gchar* _tmp34_;
	SynapseZeitgeistPluginMatchObject* _tmp35_;
	SynapseZeitgeistPluginMatchObject* match_obj;
	gint relevancy;
	GError * _inner_error_;
};

struct _SynapseZeitgeistPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	gchar* _tmp0_;
	gchar* search_query;
	gboolean empty_query;
	GTimer* _tmp1_;
	GTimer* timer;
	GPtrArray* _tmp2_;
	GPtrArray* templates;
	GPtrArray* _tmp3_;
	GPtrArray* event_templates;
	gint _tmp4_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gconstpointer _tmp7_;
	SynapseResultSet* _tmp8_;
	SynapseResultSet* _result_;
	ZeitgeistResultSet* rs;
	gboolean only_local;
	gint64 _tmp9_;
	gint64 start_ts;
	ZeitgeistTimeRange* _tmp10_;
	ZeitgeistTimeRange* _tmp11_;
	GPtrArray* _tmp12_;
	ZeitgeistResultSet* _tmp13_;
	ZeitgeistResultSet* _tmp14_;
	ZeitgeistResultSet* _tmp15_;
	gboolean _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gchar** words;
	gint words_length1;
	gint _words_size_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	ZeitgeistTimeRange* _tmp22_;
	ZeitgeistTimeRange* _tmp23_;
	GPtrArray* _tmp24_;
	ZeitgeistResultSet* _tmp25_;
	ZeitgeistResultSet* _tmp26_;
	ZeitgeistResultSet* _tmp27_;
	gboolean _tmp28_;
	GError * err;
	gboolean _tmp29_;
	gdouble _tmp30_;
	GError * _inner_error_;
};

struct _SynapseZeitgeistPluginMatchObject {
	GObject parent_instance;
	SynapseZeitgeistPluginMatchObjectPrivate * priv;
};

struct _SynapseZeitgeistPluginMatchObjectClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistPluginMatchObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _uri;
	SynapseQueryFlags _file_type;
	gchar* _mime_type;
	gchar* _extended_info;
};


static gpointer synapse_zeitgeist_plugin_parent_class = NULL;
static gpointer synapse_zeitgeist_plugin_match_object_parent_class = NULL;
static SynapseMatchIface* synapse_zeitgeist_plugin_match_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface* synapse_zeitgeist_plugin_match_object_synapse_uri_match_parent_iface = NULL;
static SynapseApplicationMatchIface* synapse_zeitgeist_plugin_match_object_synapse_application_match_parent_iface = NULL;
static SynapseExtendedInfoIface* synapse_zeitgeist_plugin_match_object_synapse_extended_info_parent_iface = NULL;
static SynapseActivatableIface* synapse_zeitgeist_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_zeitgeist_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_zeitgeist_plugin_get_type (void) G_GNUC_CONST;
#define SYNAPSE_ZEITGEIST_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPluginPrivate))
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_ENABLED
};
#define SYNAPSE_ZEITGEIST_PLUGIN_UNIQUE_NAME "org.gnome.zeitgeist.Engine"
static void synapse_zeitgeist_plugin_real_activate (SynapseActivatable* base);
static void synapse_zeitgeist_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_zeitgeist_plugin_register_plugin (void);
static void _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func (void);
static gint synapse_zeitgeist_plugin_compute_relevancy (SynapseZeitgeistPlugin* self, const gchar* uri, gint base_relevancy);
static void synapse_zeitgeist_plugin_update_min_max (const gchar* uri, glong* minimum, glong* maximum);
static void synapse_zeitgeist_plugin_process_results_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_process_results (SynapseZeitgeistPlugin* self, const gchar* query, ZeitgeistResultSet* events, GCancellable* cancellable, SynapseResultSet* real_results, gboolean local_only, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_plugin_process_results_finish (SynapseZeitgeistPlugin* self, GAsyncResult* _res_);
static gboolean synapse_zeitgeist_plugin_process_results_co (SynapseZeitgeistPluginProcessResultsData* data);
static void synapse_zeitgeist_plugin_process_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static SynapseZeitgeistPluginMatchObject* synapse_zeitgeist_plugin_match_object_new (ZeitgeistEvent* event, const gchar* thumbnail_path, const gchar* icon, gboolean is_application);
static SynapseZeitgeistPluginMatchObject* synapse_zeitgeist_plugin_match_object_construct (GType object_type, ZeitgeistEvent* event, const gchar* thumbnail_path, const gchar* icon, gboolean is_application);
static GType synapse_zeitgeist_plugin_match_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void synapse_zeitgeist_plugin_process_recent_results_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_process_recent_results (SynapseZeitgeistPlugin* self, ZeitgeistResultSet* events, GCancellable* cancellable, SynapseResultSet* results, gboolean local_only, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_plugin_process_recent_results_finish (SynapseZeitgeistPlugin* self, GAsyncResult* _res_);
static gboolean synapse_zeitgeist_plugin_process_recent_results_co (SynapseZeitgeistPluginProcessRecentResultsData* data);
static void synapse_zeitgeist_plugin_process_recent_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_zeitgeist_plugin_match_object_init_extended_info_from_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event);
static GPtrArray* synapse_zeitgeist_plugin_create_templates (SynapseZeitgeistPlugin* self, SynapseQueryFlags flags);
static void _g_object_unref0_ (gpointer var);
static gboolean synapse_zeitgeist_plugin_real_handles_empty_query (SynapseItemProvider* base);
static void synapse_zeitgeist_plugin_real_search_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean synapse_zeitgeist_plugin_real_search_co (SynapseZeitgeistPluginSearchData* data);
static void synapse_zeitgeist_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_new (void);
SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_construct (GType object_type);
static GObject * synapse_zeitgeist_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, SynapseZeitgeistPluginMatchObjectPrivate))
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_TITLE,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DESCRIPTION,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_ICON_NAME,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MATCH_TYPE,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_APP_INFO,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_NEEDS_TERMINAL,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILENAME,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_URI,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILE_TYPE,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MIME_TYPE,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_EXTENDED_INFO
};
static void synapse_zeitgeist_plugin_match_object_init_from_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event);
static void synapse_zeitgeist_plugin_match_object_init_from_app_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event);
static void synapse_zeitgeist_plugin_match_object_finalize (GObject* obj);
static void _vala_synapse_zeitgeist_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_zeitgeist_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_zeitgeist_plugin_finalize (GObject* obj);
static void _vala_synapse_zeitgeist_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_zeitgeist_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void synapse_zeitgeist_plugin_real_activate (SynapseActivatable* base) {
	SynapseZeitgeistPlugin * self;
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistIndex* _tmp1_ = NULL;
	self = (SynapseZeitgeistPlugin*) base;
	_tmp0_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->zg_log);
	self->priv->zg_log = _tmp0_;
	_tmp1_ = zeitgeist_index_new ();
	_g_object_unref0 (self->priv->zg_index);
	self->priv->zg_index = _tmp1_;
}


static void synapse_zeitgeist_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseZeitgeistPlugin * self;
	self = (SynapseZeitgeistPlugin*) base;
}


static void _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_zeitgeist_plugin_register_plugin ();
}


static void synapse_zeitgeist_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	SynapseDBusService* _tmp3_ = NULL;
	SynapseDBusService* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Search various items logged by Zeitgeist.");
	_tmp3_ = synapse_dbus_service_get_default ();
	_tmp4_ = _tmp3_;
	_tmp5_ = synapse_dbus_service_name_is_activatable (_tmp4_, SYNAPSE_ZEITGEIST_PLUGIN_UNIQUE_NAME);
	_tmp6_ = _ ("Zeitgeist is not installed");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, "Zeitgeist", _tmp2_, "zeitgeist", _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func, _tmp5_, _tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
}


static gint synapse_zeitgeist_plugin_compute_relevancy (SynapseZeitgeistPlugin* self, const gchar* uri, gint base_relevancy) {
	gint result = 0;
	SynapseRelevancyService* _tmp0_ = NULL;
	SynapseRelevancyService* rs;
	gfloat _tmp1_;
	gfloat pop;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_tmp0_ = synapse_relevancy_service_get_default ();
	rs = _tmp0_;
	_tmp1_ = synapse_relevancy_service_get_uri_popularity (rs, uri);
	pop = _tmp1_;
	_tmp2_ = synapse_relevancy_service_compute_relevancy (base_relevancy, pop);
	result = _tmp2_;
	_g_object_unref0 (rs);
	return result;
}


static void synapse_zeitgeist_plugin_update_min_max (const gchar* uri, glong* minimum, glong* maximum) {
	gint _tmp0_;
	glong len;
	g_return_if_fail (uri != NULL);
	_tmp0_ = strlen (uri);
	len = (glong) _tmp0_;
	if (len > (*maximum)) {
		*maximum = len;
	}
	if (len < (*minimum)) {
		*minimum = len;
	}
}


static void synapse_zeitgeist_plugin_process_results_data_free (gpointer _data) {
	SynapseZeitgeistPluginProcessResultsData* data;
	data = _data;
	_g_free0 (data->query);
	_g_object_unref0 (data->events);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->real_results);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseZeitgeistPluginProcessResultsData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_zeitgeist_plugin_process_results (SynapseZeitgeistPlugin* self, const gchar* query, ZeitgeistResultSet* events, GCancellable* cancellable, SynapseResultSet* real_results, gboolean local_only, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistPluginProcessResultsData* _data_;
	_data_ = g_slice_new0 (SynapseZeitgeistPluginProcessResultsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_plugin_process_results);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_plugin_process_results_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->query = g_strdup (query);
	_data_->events = _g_object_ref0 (events);
	_data_->cancellable = _g_object_ref0 (cancellable);
	_data_->real_results = _g_object_ref0 (real_results);
	_data_->local_only = local_only;
	synapse_zeitgeist_plugin_process_results_co (_data_);
}


static void synapse_zeitgeist_plugin_process_results_finish (SynapseZeitgeistPlugin* self, GAsyncResult* _res_) {
	SynapseZeitgeistPluginProcessResultsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_zeitgeist_plugin_process_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistPluginProcessResultsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_zeitgeist_plugin_process_results_co (data);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gboolean synapse_zeitgeist_plugin_process_results_co (SynapseZeitgeistPluginProcessResultsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	data->uris = (GeeSet*) data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = synapse_query_get_matchers_for_query (data->query, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
	data->matchers = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = synapse_result_set_new ();
	data->results = data->_tmp2_;
	data->minimum = G_MAXLONG;
	data->maximum = (glong) 0;
	{
		data->_tmp3_ = NULL;
		data->_tmp3_ = _vala_zeitgeist_result_set_iterator (data->events);
		data->_event_it = data->_tmp3_;
		while (TRUE) {
			data->_tmp4_ = NULL;
			data->_tmp4_ = _vala_zeitgeist_result_set_next_value (data->_event_it);
			data->event = data->_tmp4_;
			if (!(data->event != NULL)) {
				break;
			}
			data->_tmp5_ = zeitgeist_event_num_subjects (data->event);
			if (data->_tmp5_ <= 0) {
				continue;
			}
			data->_tmp6_ = NULL;
			data->_tmp6_ = zeitgeist_event_get_subject (data->event, 0);
			data->_tmp7_ = _g_object_ref0 (data->_tmp6_);
			data->subject = data->_tmp7_;
			data->_tmp8_ = NULL;
			data->_tmp8_ = zeitgeist_subject_get_uri (data->subject);
			data->uri = data->_tmp8_;
			if (data->uri == NULL) {
				data->_tmp9_ = TRUE;
			} else {
				data->_tmp9_ = g_strcmp0 (data->uri, "") == 0;
			}
			if (data->_tmp9_) {
				_g_object_unref0 (data->subject);
				continue;
			}
			data->_tmp10_ = gee_collection_contains ((GeeCollection*) data->uris, data->uri);
			if (!data->_tmp10_) {
				data->relevancy_penalty = (gint) SYNAPSE_MATCH_SCORE_URI_PENALTY;
				data->thumbnail_path = NULL;
				data->icon = NULL;
				gee_collection_add ((GeeCollection*) data->uris, data->uri);
				data->_tmp11_ = NULL;
				data->_tmp11_ = g_file_new_for_uri (data->uri);
				data->f = data->_tmp11_;
				data->_tmp12_ = NULL;
				data->_tmp12_ = g_file_get_uri_scheme (data->f);
				data->_tmp13_ = data->_tmp12_;
				data->_tmp14_ = g_strcmp0 (data->_tmp13_, "data") == 0;
				_g_free0 (data->_tmp13_);
				if (data->_tmp14_) {
					_g_object_unref0 (data->f);
					_g_free0 (data->icon);
					_g_free0 (data->thumbnail_path);
					_g_object_unref0 (data->subject);
					continue;
				}
				data->_tmp15_ = g_file_is_native (data->f);
				if (data->_tmp15_) {
					data->_state_ = 1;
					g_file_query_info_async (data->f, data->self->priv->interesting_attributes, 0, 0, data->cancellable, synapse_zeitgeist_plugin_process_results_ready, data);
					return FALSE;
					_state_1:
					data->_tmp16_ = NULL;
					data->_tmp16_ = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
					data->fi = data->_tmp16_;
					if (data->_inner_error_ != NULL) {
						goto __catch50_g_error;
					}
					data->_tmp17_ = NULL;
					data->_tmp17_ = g_file_info_get_icon (data->fi);
					data->_tmp18_ = NULL;
					data->_tmp18_ = g_icon_to_string (data->_tmp17_);
					_g_free0 (data->icon);
					data->icon = data->_tmp18_;
					data->_tmp19_ = g_file_info_has_attribute (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
					if (data->_tmp19_) {
						data->_tmp20_ = NULL;
						data->_tmp20_ = g_file_info_get_attribute_byte_string (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
						data->_tmp21_ = g_strdup (data->_tmp20_);
						_g_free0 (data->thumbnail_path);
						data->thumbnail_path = data->_tmp21_;
					}
					data->_tmp22_ = g_file_info_get_is_hidden (data->fi);
					if (data->_tmp22_) {
						data->relevancy_penalty = data->relevancy_penalty + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM);
					}
					_g_object_unref0 (data->fi);
					goto __finally50;
					__catch50_g_error:
					{
						data->err = data->_inner_error_;
						data->_inner_error_ = NULL;
						data->_tmp23_ = g_cancellable_is_cancelled (data->cancellable);
						if (data->_tmp23_) {
							_g_error_free0 (data->err);
							_g_object_unref0 (data->f);
							_g_free0 (data->icon);
							_g_free0 (data->thumbnail_path);
							_g_object_unref0 (data->subject);
							_g_object_unref0 (data->_event_it);
							_g_object_unref0 (data->results);
							_g_object_unref0 (data->matchers);
							_g_object_unref0 (data->uris);
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						} else {
							_g_error_free0 (data->err);
							_g_object_unref0 (data->f);
							_g_free0 (data->icon);
							_g_free0 (data->thumbnail_path);
							_g_object_unref0 (data->subject);
							continue;
						}
						_g_error_free0 (data->err);
					}
					__finally50:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->f);
						_g_free0 (data->icon);
						_g_free0 (data->thumbnail_path);
						_g_object_unref0 (data->subject);
						_g_object_unref0 (data->_event_it);
						_g_object_unref0 (data->results);
						_g_object_unref0 (data->matchers);
						_g_object_unref0 (data->uris);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				} else {
					data->_tmp24_ = g_str_has_prefix (data->uri, "note://tomboy/");
					if (data->_tmp24_) {
						data->_tmp25_ = NULL;
						data->_tmp25_ = string_substring (data->uri, (glong) 14, (glong) (-1));
						data->_tmp26_ = data->_tmp25_;
						data->_tmp27_ = g_strconcat (data->_tmp26_, ".note", NULL);
						data->_tmp28_ = data->_tmp27_;
						_g_free0 (data->_tmp26_);
						data->note_filename = data->_tmp28_;
						data->_tmp29_ = NULL;
						data->_tmp29_ = g_get_user_data_dir ();
						data->_tmp30_ = NULL;
						data->_tmp30_ = g_build_filename (data->_tmp29_, "tomboy", data->note_filename, NULL);
						data->note_path = data->_tmp30_;
						data->_tmp31_ = NULL;
						data->_tmp31_ = g_file_new_for_path (data->note_path);
						data->note_f = data->_tmp31_;
						data->_state_ = 2;
						synapse_utils_query_exists_async (data->note_f, synapse_zeitgeist_plugin_process_results_ready, data);
						return FALSE;
						_state_2:
						data->_tmp32_ = synapse_utils_query_exists_finish (data->_res_);
						data->exists = data->_tmp32_;
						data->_tmp33_ = g_cancellable_is_cancelled (data->cancellable);
						if (data->_tmp33_) {
							_g_object_unref0 (data->note_f);
							_g_free0 (data->note_path);
							_g_free0 (data->note_filename);
							_g_object_unref0 (data->f);
							_g_free0 (data->icon);
							_g_free0 (data->thumbnail_path);
							_g_object_unref0 (data->subject);
							_g_object_unref0 (data->_event_it);
							_g_object_unref0 (data->results);
							_g_object_unref0 (data->matchers);
							_g_object_unref0 (data->uris);
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						} else {
							if (!data->exists) {
								_g_object_unref0 (data->note_f);
								_g_free0 (data->note_path);
								_g_free0 (data->note_filename);
								_g_object_unref0 (data->f);
								_g_free0 (data->icon);
								_g_free0 (data->thumbnail_path);
								_g_object_unref0 (data->subject);
								continue;
							}
						}
						data->_tmp34_ = NULL;
						data->_tmp34_ = g_content_type_get_icon ("application/x-note");
						data->_tmp35_ = data->_tmp34_;
						data->_tmp36_ = NULL;
						data->_tmp36_ = g_icon_to_string (data->_tmp35_);
						_g_free0 (data->icon);
						data->icon = data->_tmp36_;
						_g_object_unref0 (data->_tmp35_);
						_g_object_unref0 (data->note_f);
						_g_free0 (data->note_path);
						_g_free0 (data->note_filename);
					} else {
						if (data->local_only) {
							_g_object_unref0 (data->f);
							_g_free0 (data->icon);
							_g_free0 (data->thumbnail_path);
							_g_object_unref0 (data->subject);
							continue;
						} else {
							data->relevancy_penalty = data->relevancy_penalty + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
							data->_tmp37_ = NULL;
							data->_tmp37_ = zeitgeist_subject_get_mimetype (data->subject);
							data->mimetype = data->_tmp37_;
							if (data->mimetype != NULL) {
								data->_tmp38_ = g_strcmp0 (data->mimetype, "") != 0;
							} else {
								data->_tmp38_ = FALSE;
							}
							if (data->_tmp38_) {
								data->_tmp39_ = NULL;
								data->_tmp39_ = g_content_type_get_icon (data->mimetype);
								data->_tmp40_ = data->_tmp39_;
								data->_tmp41_ = NULL;
								data->_tmp41_ = g_icon_to_string (data->_tmp40_);
								_g_free0 (data->icon);
								data->icon = data->_tmp41_;
								_g_object_unref0 (data->_tmp40_);
							}
							data->_tmp42_ = g_str_has_prefix (data->uri, "http");
							if (data->_tmp42_) {
								synapse_zeitgeist_plugin_update_min_max (data->uri, &data->minimum, &data->maximum);
							}
						}
					}
				}
				data->_tmp43_ = NULL;
				data->_tmp43_ = synapse_zeitgeist_plugin_match_object_new (data->event, data->thumbnail_path, data->icon, FALSE);
				data->match_obj = data->_tmp43_;
				data->match_found = FALSE;
				{
					data->_tmp44_ = _g_object_ref0 (data->matchers);
					data->_matcher_list = data->_tmp44_;
					data->_tmp45_ = gee_collection_get_size ((GeeCollection*) data->_matcher_list);
					data->_matcher_size = data->_tmp45_;
					data->_matcher_index = -1;
					while (TRUE) {
						data->_matcher_index = data->_matcher_index + 1;
						if (!(data->_matcher_index < data->_matcher_size)) {
							break;
						}
						data->_tmp46_ = NULL;
						data->_tmp46_ = gee_list_get (data->_matcher_list, data->_matcher_index);
						data->matcher = (GeeMapEntry*) data->_tmp46_;
						data->adjusted_title = NULL;
						data->_tmp47_ = g_str_has_prefix (data->uri, "http");
						if (data->_tmp47_) {
							data->_tmp48_ = NULL;
							data->_tmp48_ = synapse_match_get_title ((SynapseMatch*) data->match_obj);
							data->_tmp49_ = NULL;
							data->_tmp49_ = g_strdup_printf ("%s (%s)", data->_tmp48_, data->uri);
							_g_free0 (data->adjusted_title);
							data->adjusted_title = data->_tmp49_;
						}
						data->_tmp50_ = g_strdup (data->adjusted_title);
						data->_tmp51_ = data->_tmp50_;
						if (data->_tmp51_ == NULL) {
							data->_tmp52_ = NULL;
							data->_tmp52_ = synapse_match_get_title ((SynapseMatch*) data->match_obj);
							data->_tmp53_ = g_strdup (data->_tmp52_);
							_g_free0 (data->_tmp51_);
							data->_tmp51_ = data->_tmp53_;
						}
						data->_tmp54_ = NULL;
						data->_tmp54_ = gee_map_entry_get_key (data->matcher);
						data->_tmp55_ = g_regex_match ((GRegex*) data->_tmp54_, data->_tmp51_, 0, NULL);
						if (data->_tmp55_) {
							data->_tmp56_ = NULL;
							data->_tmp56_ = gee_map_entry_get_value (data->matcher);
							data->_tmp57_ = synapse_zeitgeist_plugin_compute_relevancy (data->self, data->uri, GPOINTER_TO_INT (data->_tmp56_) - data->relevancy_penalty);
							data->relevancy = data->_tmp57_;
							synapse_result_set_add (data->results, (SynapseMatch*) data->match_obj, data->relevancy);
							data->match_found = TRUE;
							_g_free0 (data->_tmp51_);
							_g_free0 (data->adjusted_title);
							_g_object_unref0 (data->matcher);
							break;
						}
						_g_free0 (data->_tmp51_);
						_g_free0 (data->adjusted_title);
						_g_object_unref0 (data->matcher);
					}
					_g_object_unref0 (data->_matcher_list);
				}
				if (!data->match_found) {
					synapse_result_set_add (data->results, (SynapseMatch*) data->match_obj, (gint) (SYNAPSE_MATCH_SCORE_POOR + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR));
				}
				_g_object_unref0 (data->match_obj);
				_g_object_unref0 (data->f);
				_g_free0 (data->icon);
				_g_free0 (data->thumbnail_path);
			}
			_g_object_unref0 (data->subject);
		}
		_g_object_unref0 (data->_event_it);
	}
	{
		data->_tmp58_ = NULL;
		data->_tmp58_ = synapse_result_set_get_entries (data->results);
		data->_tmp59_ = data->_tmp58_;
		data->_tmp60_ = NULL;
		data->_tmp60_ = gee_iterable_iterator ((GeeIterable*) data->_tmp59_);
		data->_tmp61_ = data->_tmp60_;
		_g_object_unref0 (data->_tmp59_);
		data->_entry_it = data->_tmp61_;
		while (TRUE) {
			data->_tmp62_ = gee_iterator_next (data->_entry_it);
			if (!data->_tmp62_) {
				break;
			}
			data->_tmp63_ = NULL;
			data->_tmp63_ = gee_iterator_get (data->_entry_it);
			data->entry = (GeeMapEntry*) data->_tmp63_;
			data->_tmp64_ = NULL;
			data->_tmp64_ = gee_map_entry_get_key (data->entry);
			data->_tmp65_ = (SynapseMatch*) data->_tmp64_;
			data->_tmp66_ = _g_object_ref0 (SYNAPSE_ZEITGEIST_PLUGIN_IS_MATCH_OBJECT (data->_tmp65_) ? ((SynapseZeitgeistPluginMatchObject*) data->_tmp65_) : NULL);
			data->mo = data->_tmp66_;
			data->_tmp69_ = NULL;
			data->_tmp69_ = synapse_uri_match_get_uri ((SynapseUriMatch*) data->mo);
			if (data->_tmp69_ != NULL) {
				data->_tmp70_ = NULL;
				data->_tmp70_ = synapse_uri_match_get_uri ((SynapseUriMatch*) data->mo);
				data->_tmp71_ = g_str_has_prefix (data->_tmp70_, "http");
				data->_tmp68_ = data->_tmp71_;
			} else {
				data->_tmp68_ = FALSE;
			}
			if (data->_tmp68_) {
				data->_tmp67_ = data->minimum != data->maximum;
			} else {
				data->_tmp67_ = FALSE;
			}
			if (data->_tmp67_) {
				data->_tmp72_ = NULL;
				data->_tmp72_ = synapse_uri_match_get_uri ((SynapseUriMatch*) data->mo);
				data->_tmp73_ = strlen (data->_tmp72_);
				data->len = (glong) data->_tmp73_;
				data->mult = (data->len - data->minimum) / ((gfloat) (data->maximum - data->minimum));
				data->_tmp74_ = NULL;
				data->_tmp74_ = gee_map_entry_get_value (data->entry);
				data->adjusted_relevancy = GPOINTER_TO_INT (data->_tmp74_) - ((gint) (data->mult * SYNAPSE_MATCH_SCORE_INCREMENT_MINOR));
				data->_tmp75_ = NULL;
				data->_tmp75_ = synapse_uri_match_get_uri ((SynapseUriMatch*) data->mo);
				data->_tmp76_ = NULL;
				data->_tmp76_ = strstr (data->_tmp75_, "?");
				if (data->_tmp76_ != NULL) {
					data->adjusted_relevancy = data->adjusted_relevancy - ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
				}
				synapse_result_set_add (data->real_results, (SynapseMatch*) data->mo, data->adjusted_relevancy);
			} else {
				data->_tmp77_ = NULL;
				data->_tmp77_ = gee_map_entry_get_value (data->entry);
				synapse_result_set_add (data->real_results, (SynapseMatch*) data->mo, GPOINTER_TO_INT (data->_tmp77_));
			}
			_g_object_unref0 (data->mo);
			_g_object_unref0 (data->entry);
		}
		_g_object_unref0 (data->_entry_it);
	}
	_g_object_unref0 (data->results);
	_g_object_unref0 (data->matchers);
	_g_object_unref0 (data->uris);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_zeitgeist_plugin_process_recent_results_data_free (gpointer _data) {
	SynapseZeitgeistPluginProcessRecentResultsData* data;
	data = _data;
	_g_object_unref0 (data->events);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->results);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseZeitgeistPluginProcessRecentResultsData, data);
}


static void synapse_zeitgeist_plugin_process_recent_results (SynapseZeitgeistPlugin* self, ZeitgeistResultSet* events, GCancellable* cancellable, SynapseResultSet* results, gboolean local_only, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
	_data_ = g_slice_new0 (SynapseZeitgeistPluginProcessRecentResultsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_plugin_process_recent_results);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_plugin_process_recent_results_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->events = _g_object_ref0 (events);
	_data_->cancellable = _g_object_ref0 (cancellable);
	_data_->results = _g_object_ref0 (results);
	_data_->local_only = local_only;
	synapse_zeitgeist_plugin_process_recent_results_co (_data_);
}


static void synapse_zeitgeist_plugin_process_recent_results_finish (SynapseZeitgeistPlugin* self, GAsyncResult* _res_) {
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_zeitgeist_plugin_process_recent_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistPluginProcessRecentResultsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_zeitgeist_plugin_process_recent_results_co (data);
}


static gboolean synapse_zeitgeist_plugin_process_recent_results_co (SynapseZeitgeistPluginProcessRecentResultsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	data->uris = (GeeSet*) data->_tmp0_;
	data->_tmp1_ = zeitgeist_result_set_size (data->events);
	data->events_size = data->_tmp1_;
	data->event_index = (guint) 0;
	{
		data->_tmp2_ = NULL;
		data->_tmp2_ = _vala_zeitgeist_result_set_iterator (data->events);
		data->_event_it = data->_tmp2_;
		while (TRUE) {
			data->_tmp3_ = NULL;
			data->_tmp3_ = _vala_zeitgeist_result_set_next_value (data->_event_it);
			data->event = data->_tmp3_;
			if (!(data->event != NULL)) {
				break;
			}
			data->event_index++;
			data->_tmp4_ = zeitgeist_event_num_subjects (data->event);
			if (data->_tmp4_ <= 0) {
				continue;
			}
			data->_tmp5_ = NULL;
			data->_tmp5_ = zeitgeist_event_get_subject (data->event, 0);
			data->_tmp6_ = _g_object_ref0 (data->_tmp5_);
			data->subject = data->_tmp6_;
			data->_tmp7_ = NULL;
			data->_tmp7_ = zeitgeist_subject_get_uri (data->subject);
			data->uri = data->_tmp7_;
			data->_tmp8_ = gee_collection_contains ((GeeCollection*) data->uris, data->uri);
			if (!data->_tmp8_) {
				data->_tmp9_ = g_str_has_prefix (data->uri, "application://");
				data->is_application = data->_tmp9_;
				data->relevancy_penalty = (gint) SYNAPSE_MATCH_SCORE_URI_PENALTY;
				data->thumbnail_path = NULL;
				data->icon = NULL;
				gee_collection_add ((GeeCollection*) data->uris, data->uri);
				data->_tmp10_ = NULL;
				data->_tmp10_ = g_file_new_for_uri (data->uri);
				data->f = data->_tmp10_;
				data->_tmp11_ = NULL;
				data->_tmp11_ = g_file_get_uri_scheme (data->f);
				data->_tmp12_ = data->_tmp11_;
				data->_tmp13_ = g_strcmp0 (data->_tmp12_, "data") == 0;
				_g_free0 (data->_tmp12_);
				if (data->_tmp13_) {
					_g_object_unref0 (data->f);
					_g_free0 (data->icon);
					_g_free0 (data->thumbnail_path);
					_g_object_unref0 (data->subject);
					continue;
				}
				data->_tmp14_ = g_file_is_native (data->f);
				if (data->_tmp14_) {
					data->_state_ = 1;
					g_file_query_info_async (data->f, data->self->priv->interesting_attributes, 0, 0, data->cancellable, synapse_zeitgeist_plugin_process_recent_results_ready, data);
					return FALSE;
					_state_1:
					data->_tmp15_ = NULL;
					data->_tmp15_ = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
					data->fi = data->_tmp15_;
					if (data->_inner_error_ != NULL) {
						goto __catch51_g_error;
					}
					data->_tmp16_ = NULL;
					data->_tmp16_ = g_file_info_get_icon (data->fi);
					data->_tmp17_ = NULL;
					data->_tmp17_ = g_icon_to_string (data->_tmp16_);
					_g_free0 (data->icon);
					data->icon = data->_tmp17_;
					data->_tmp18_ = g_file_info_has_attribute (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
					if (data->_tmp18_) {
						data->_tmp19_ = NULL;
						data->_tmp19_ = g_file_info_get_attribute_byte_string (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
						data->_tmp20_ = g_strdup (data->_tmp19_);
						_g_free0 (data->thumbnail_path);
						data->thumbnail_path = data->_tmp20_;
					}
					data->_tmp21_ = g_file_info_get_is_hidden (data->fi);
					if (data->_tmp21_) {
						data->relevancy_penalty = data->relevancy_penalty + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM);
					}
					_g_object_unref0 (data->fi);
					goto __finally51;
					__catch51_g_error:
					{
						data->err = data->_inner_error_;
						data->_inner_error_ = NULL;
						data->_tmp22_ = g_cancellable_is_cancelled (data->cancellable);
						if (data->_tmp22_) {
							_g_error_free0 (data->err);
							_g_object_unref0 (data->f);
							_g_free0 (data->icon);
							_g_free0 (data->thumbnail_path);
							_g_object_unref0 (data->subject);
							_g_object_unref0 (data->_event_it);
							_g_object_unref0 (data->uris);
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						} else {
							_g_error_free0 (data->err);
							_g_object_unref0 (data->f);
							_g_free0 (data->icon);
							_g_free0 (data->thumbnail_path);
							_g_object_unref0 (data->subject);
							continue;
						}
						_g_error_free0 (data->err);
					}
					__finally51:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->f);
						_g_free0 (data->icon);
						_g_free0 (data->thumbnail_path);
						_g_object_unref0 (data->subject);
						_g_object_unref0 (data->_event_it);
						_g_object_unref0 (data->uris);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				} else {
					if (data->local_only) {
						data->_tmp23_ = !data->is_application;
					} else {
						data->_tmp23_ = FALSE;
					}
					if (data->_tmp23_) {
						_g_object_unref0 (data->f);
						_g_free0 (data->icon);
						_g_free0 (data->thumbnail_path);
						_g_object_unref0 (data->subject);
						continue;
					} else {
						if (data->is_application) {
							data->_tmp24_ = NULL;
							data->_tmp24_ = synapse_desktop_file_service_get_default ();
							data->dfs = data->_tmp24_;
							data->_tmp25_ = NULL;
							data->_tmp25_ = string_substring (data->uri, (glong) 14, (glong) (-1));
							data->_tmp26_ = data->_tmp25_;
							data->_tmp27_ = NULL;
							data->_tmp27_ = synapse_desktop_file_service_get_desktop_file_for_id (data->dfs, data->_tmp26_);
							data->_tmp28_ = data->_tmp27_;
							data->_tmp29_ = data->_tmp28_ == NULL;
							_g_object_unref0 (data->_tmp28_);
							_g_free0 (data->_tmp26_);
							if (data->_tmp29_) {
								_g_object_unref0 (data->dfs);
								_g_object_unref0 (data->f);
								_g_free0 (data->icon);
								_g_free0 (data->thumbnail_path);
								_g_object_unref0 (data->subject);
								continue;
							}
							_g_object_unref0 (data->dfs);
						} else {
							data->relevancy_penalty = data->relevancy_penalty + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
							data->_tmp30_ = NULL;
							data->_tmp30_ = zeitgeist_subject_get_mimetype (data->subject);
							data->mimetype = data->_tmp30_;
							if (data->mimetype != NULL) {
								data->_tmp31_ = g_strcmp0 (data->mimetype, "") != 0;
							} else {
								data->_tmp31_ = FALSE;
							}
							if (data->_tmp31_) {
								data->_tmp32_ = NULL;
								data->_tmp32_ = g_content_type_get_icon (data->mimetype);
								data->_tmp33_ = data->_tmp32_;
								data->_tmp34_ = NULL;
								data->_tmp34_ = g_icon_to_string (data->_tmp33_);
								_g_free0 (data->icon);
								data->icon = data->_tmp34_;
								_g_object_unref0 (data->_tmp33_);
							}
						}
					}
				}
				data->_tmp35_ = NULL;
				data->_tmp35_ = synapse_zeitgeist_plugin_match_object_new (data->event, data->thumbnail_path, data->icon, data->is_application);
				data->match_obj = data->_tmp35_;
				synapse_zeitgeist_plugin_match_object_init_extended_info_from_event (data->match_obj, data->event);
				data->relevancy = (gint) (((data->events_size - data->event_index) / ((gfloat) data->events_size)) * SYNAPSE_MATCH_SCORE_HIGHEST);
				synapse_result_set_add (data->results, (SynapseMatch*) data->match_obj, data->relevancy);
				_g_object_unref0 (data->match_obj);
				_g_object_unref0 (data->f);
				_g_free0 (data->icon);
				_g_free0 (data->thumbnail_path);
			}
			_g_object_unref0 (data->subject);
		}
		_g_object_unref0 (data->_event_it);
	}
	_g_object_unref0 (data->uris);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GPtrArray* synapse_zeitgeist_plugin_create_templates (SynapseZeitgeistPlugin* self, SynapseQueryFlags flags) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* templates;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* manifestation;
	ZeitgeistEvent* event = NULL;
	ZeitgeistSubject* subject = NULL;
	SynapseQueryFlags flags_intersect;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	templates = _tmp0_;
	if ((flags & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) {
		_tmp1_ = "";
	} else {
		_tmp1_ = "!" ZEITGEIST_NFO_REMOTE_DATA_OBJECT;
	}
	_tmp2_ = g_strdup (_tmp1_);
	manifestation = _tmp2_;
	flags_intersect = flags & SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT;
	if (flags_intersect == SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT) {
		ZeitgeistSubject* _tmp3_ = NULL;
		ZeitgeistEvent* _tmp4_ = NULL;
		ZeitgeistSubject* _tmp5_ = NULL;
		ZeitgeistSubject* _tmp6_ = NULL;
		ZeitgeistEvent* _tmp7_;
		_tmp3_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp3_);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		_tmp4_ = zeitgeist_event_new ();
		_g_object_unref0 (event);
		event = g_object_ref_sink (_tmp4_);
		zeitgeist_event_add_subject (event, subject);
		_tmp5_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp5_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_FOLDER);
		zeitgeist_event_add_subject (event, subject);
		_tmp6_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp6_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_SOFTWARE);
		zeitgeist_event_add_subject (event, subject);
		_tmp7_ = _g_object_ref0 (event);
		g_ptr_array_add (templates, _tmp7_);
		result = templates;
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
		_g_free0 (manifestation);
		return result;
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS) {
		ZeitgeistSubject* _tmp8_ = NULL;
		ZeitgeistEvent* _tmp9_ = NULL;
		ZeitgeistEvent* _tmp10_;
		_tmp8_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp8_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_SOFTWARE);
		_tmp9_ = zeitgeist_event_new ();
		_g_object_unref0 (event);
		event = g_object_ref_sink (_tmp9_);
		zeitgeist_event_add_subject (event, subject);
		_tmp10_ = _g_object_ref0 (event);
		g_ptr_array_add (templates, _tmp10_);
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_AUDIO) == SYNAPSE_QUERY_FLAGS_AUDIO) {
		ZeitgeistSubject* _tmp11_ = NULL;
		ZeitgeistEvent* _tmp12_ = NULL;
		ZeitgeistEvent* _tmp13_;
		_tmp11_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp11_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_AUDIO);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		_tmp12_ = zeitgeist_event_new ();
		_g_object_unref0 (event);
		event = g_object_ref_sink (_tmp12_);
		zeitgeist_event_add_subject (event, subject);
		_tmp13_ = _g_object_ref0 (event);
		g_ptr_array_add (templates, _tmp13_);
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_VIDEO) == SYNAPSE_QUERY_FLAGS_VIDEO) {
		ZeitgeistSubject* _tmp14_ = NULL;
		ZeitgeistEvent* _tmp15_ = NULL;
		ZeitgeistEvent* _tmp16_;
		_tmp14_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp14_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_VIDEO);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		_tmp15_ = zeitgeist_event_new ();
		_g_object_unref0 (event);
		event = g_object_ref_sink (_tmp15_);
		zeitgeist_event_add_subject (event, subject);
		_tmp16_ = _g_object_ref0 (event);
		g_ptr_array_add (templates, _tmp16_);
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_IMAGES) == SYNAPSE_QUERY_FLAGS_IMAGES) {
		ZeitgeistSubject* _tmp17_ = NULL;
		ZeitgeistEvent* _tmp18_ = NULL;
		ZeitgeistEvent* _tmp19_;
		_tmp17_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp17_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_IMAGE);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		_tmp18_ = zeitgeist_event_new ();
		_g_object_unref0 (event);
		event = g_object_ref_sink (_tmp18_);
		zeitgeist_event_add_subject (event, subject);
		_tmp19_ = _g_object_ref0 (event);
		g_ptr_array_add (templates, _tmp19_);
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_DOCUMENTS) == SYNAPSE_QUERY_FLAGS_DOCUMENTS) {
		ZeitgeistSubject* _tmp20_ = NULL;
		ZeitgeistEvent* _tmp21_ = NULL;
		ZeitgeistEvent* _tmp22_;
		_tmp20_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp20_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_DOCUMENT);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		_tmp21_ = zeitgeist_event_new ();
		_g_object_unref0 (event);
		event = g_object_ref_sink (_tmp21_);
		zeitgeist_event_add_subject (event, subject);
		_tmp22_ = _g_object_ref0 (event);
		g_ptr_array_add (templates, _tmp22_);
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET) {
		ZeitgeistSubject* _tmp23_ = NULL;
		ZeitgeistEvent* _tmp24_ = NULL;
		ZeitgeistEvent* _tmp25_;
		_tmp23_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp23_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_WEBSITE);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		_tmp24_ = zeitgeist_event_new ();
		_g_object_unref0 (event);
		event = g_object_ref_sink (_tmp24_);
		zeitgeist_event_add_subject (event, subject);
		_tmp25_ = _g_object_ref0 (event);
		g_ptr_array_add (templates, _tmp25_);
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) == SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) {
		ZeitgeistEvent* _tmp26_ = NULL;
		ZeitgeistSubject* _tmp27_ = NULL;
		ZeitgeistSubject* _tmp28_ = NULL;
		ZeitgeistSubject* _tmp29_ = NULL;
		ZeitgeistSubject* _tmp30_ = NULL;
		ZeitgeistSubject* _tmp31_ = NULL;
		ZeitgeistSubject* _tmp32_ = NULL;
		ZeitgeistEvent* _tmp34_;
		_tmp26_ = zeitgeist_event_new ();
		_g_object_unref0 (event);
		event = g_object_ref_sink (_tmp26_);
		_tmp27_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp27_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_SOFTWARE);
		zeitgeist_event_add_subject (event, subject);
		_tmp28_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp28_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_AUDIO);
		zeitgeist_event_add_subject (event, subject);
		_tmp29_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp29_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_VIDEO);
		zeitgeist_event_add_subject (event, subject);
		_tmp30_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp30_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_IMAGE);
		zeitgeist_event_add_subject (event, subject);
		_tmp31_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp31_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_DOCUMENT);
		zeitgeist_event_add_subject (event, subject);
		_tmp32_ = zeitgeist_subject_new ();
		_g_object_unref0 (subject);
		subject = g_object_ref_sink (_tmp32_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_WEBSITE);
		zeitgeist_event_add_subject (event, subject);
		if (!((flags & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE)) {
			ZeitgeistSubject* _tmp33_ = NULL;
			_tmp33_ = zeitgeist_subject_new ();
			_g_object_unref0 (subject);
			subject = g_object_ref_sink (_tmp33_);
			zeitgeist_subject_set_manifestation (subject, manifestation);
			zeitgeist_event_add_subject (event, subject);
		}
		_tmp34_ = _g_object_ref0 (event);
		g_ptr_array_add (templates, _tmp34_);
	}
	result = templates;
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
	_g_free0 (manifestation);
	return result;
}


static gboolean synapse_zeitgeist_plugin_real_handles_empty_query (SynapseItemProvider* base) {
	SynapseZeitgeistPlugin * self;
	gboolean result = FALSE;
	self = (SynapseZeitgeistPlugin*) base;
	result = TRUE;
	return result;
}


static void synapse_zeitgeist_plugin_real_search_data_free (gpointer _data) {
	SynapseZeitgeistPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseZeitgeistPluginSearchData, data);
}


static void synapse_zeitgeist_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistPlugin * self;
	SynapseZeitgeistPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseZeitgeistPlugin*) base;
	_data_ = g_slice_new0 (SynapseZeitgeistPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_plugin_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_query_copy (q, &_tmp0_);
	_data_->q = _tmp0_;
	synapse_zeitgeist_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_zeitgeist_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseZeitgeistPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static void synapse_zeitgeist_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistPluginSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_zeitgeist_plugin_real_search_co (data);
}


static gboolean synapse_zeitgeist_plugin_real_search_co (SynapseZeitgeistPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = string_strip (data->q.query_string);
	data->search_query = data->_tmp0_;
	data->empty_query = g_strcmp0 (data->search_query, "") == 0;
	if (!data->empty_query) {
		data->q.query_type = data->q.query_type & (~SYNAPSE_QUERY_FLAGS_APPLICATIONS);
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_timer_new ();
	data->timer = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_ptr_array_new ();
	data->templates = data->_tmp2_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = synapse_zeitgeist_plugin_create_templates (data->self, data->q.query_type);
	data->event_templates = data->_tmp3_;
	data->_tmp4_ = g_ptr_array_get_length (data->event_templates);
	if (data->_tmp4_ == 0) {
		data->result = NULL;
		_g_ptr_array_unref0 (data->event_templates);
		_g_ptr_array_free0 (data->templates);
		_g_timer_destroy0 (data->timer);
		_g_free0 (data->search_query);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	{
		data->i = 0;
		{
			data->_tmp5_ = TRUE;
			while (TRUE) {
				if (!data->_tmp5_) {
					data->i++;
				}
				data->_tmp5_ = FALSE;
				data->_tmp6_ = g_ptr_array_get_length (data->event_templates);
				if (!(data->i < data->_tmp6_)) {
					break;
				}
				data->_tmp7_ = NULL;
				data->_tmp7_ = g_ptr_array_index (data->event_templates, (guint) data->i);
				g_ptr_array_add (data->templates, (ZeitgeistEvent*) data->_tmp7_);
			}
		}
	}
	data->_tmp8_ = NULL;
	data->_tmp8_ = synapse_result_set_new ();
	data->_result_ = data->_tmp8_;
	data->only_local = !((data->q.query_type & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE);
	if (data->empty_query) {
		data->_tmp9_ = zeitgeist_timestamp_for_now ();
		data->start_ts = data->_tmp9_ - (ZEITGEIST_TIMESTAMP_WEEK * 4);
		data->_tmp10_ = NULL;
		data->_tmp10_ = zeitgeist_time_range_new (data->start_ts, G_MAXINT64);
		data->_tmp11_ = g_object_ref_sink (data->_tmp10_);
		data->_tmp12_ = data->templates;
		data->templates = NULL;
		data->_state_ = 1;
		zeitgeist_log_find_events (data->self->priv->zg_log, data->_tmp11_, data->_tmp12_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) data->q.max_results, ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, data->q.cancellable, synapse_zeitgeist_plugin_search_ready, data);
		return FALSE;
		_state_1:
		data->_tmp13_ = NULL;
		data->_tmp13_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_);
		data->_tmp14_ = data->_tmp13_;
		_g_object_unref0 (data->_tmp11_);
		data->_tmp15_ = data->_tmp14_;
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->rs);
			goto __catch52_g_error;
		}
		_g_object_unref0 (data->rs);
		data->rs = data->_tmp15_;
		data->_tmp16_ = synapse_query_is_cancelled (&data->q);
		if (!data->_tmp16_) {
			data->_state_ = 2;
			synapse_zeitgeist_plugin_process_recent_results (data->self, data->rs, data->q.cancellable, data->_result_, data->only_local, synapse_zeitgeist_plugin_search_ready, data);
			return FALSE;
			_state_2:
			synapse_zeitgeist_plugin_process_recent_results_finish (data->self, data->_res_);
		}
	} else {
		data->_tmp18_ = NULL;
		data->_tmp18_ = data->_tmp17_ = g_regex_split_simple ("\\s+|\\.+(?!\\d)", data->search_query, 0, 0);
		data->words = data->_tmp18_;
		data->words_length1 = _vala_array_length (data->_tmp17_);
		data->_words_size_ = _vala_array_length (data->_tmp17_);
		data->_tmp19_ = NULL;
		data->_tmp19_ = g_strjoinv ("* ", data->words);
		data->_tmp20_ = data->_tmp19_;
		data->_tmp21_ = NULL;
		data->_tmp21_ = g_strdup_printf ("(%s*)", data->_tmp20_);
		_g_free0 (data->search_query);
		data->search_query = data->_tmp21_;
		_g_free0 (data->_tmp20_);
		data->_tmp22_ = NULL;
		data->_tmp22_ = zeitgeist_time_range_new (G_MININT64, G_MAXINT64);
		data->_tmp23_ = g_object_ref_sink (data->_tmp22_);
		data->_tmp24_ = data->templates;
		data->templates = NULL;
		data->_state_ = 3;
		zeitgeist_index_search (data->self->priv->zg_index, data->search_query, data->_tmp23_, data->_tmp24_, (guint32) 0, (guint32) data->q.max_results, ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, data->q.cancellable, synapse_zeitgeist_plugin_search_ready, data);
		return FALSE;
		_state_3:
		data->_tmp25_ = NULL;
		data->_tmp25_ = zeitgeist_index_search_finish (data->self->priv->zg_index, data->_res_, &data->_inner_error_);
		data->_tmp26_ = data->_tmp25_;
		_g_object_unref0 (data->_tmp23_);
		data->_tmp27_ = data->_tmp26_;
		if (data->_inner_error_ != NULL) {
			data->words = (_vala_array_free (data->words, data->words_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data->rs);
			goto __catch52_g_error;
		}
		_g_object_unref0 (data->rs);
		data->rs = data->_tmp27_;
		data->_tmp28_ = synapse_query_is_cancelled (&data->q);
		if (!data->_tmp28_) {
			data->_state_ = 4;
			synapse_zeitgeist_plugin_process_results (data->self, data->q.query_string, data->rs, data->q.cancellable, data->_result_, data->only_local, synapse_zeitgeist_plugin_search_ready, data);
			return FALSE;
			_state_4:
			synapse_zeitgeist_plugin_process_results_finish (data->self, data->_res_);
		}
		data->words = (_vala_array_free (data->words, data->words_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (data->rs);
	goto __finally52;
	__catch52_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp29_ = synapse_query_is_cancelled (&data->q);
		if (!data->_tmp29_) {
			synapse_utils_logger_warning ((GObject*) data->self, "Zeitgeist search failed: %s", data->err->message, NULL);
		}
		_g_error_free0 (data->err);
	}
	__finally52:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->_result_);
			_g_ptr_array_unref0 (data->event_templates);
			_g_ptr_array_free0 (data->templates);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->search_query);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->_result_);
			_g_ptr_array_unref0 (data->event_templates);
			_g_ptr_array_free0 (data->templates);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->search_query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->_result_);
			_g_ptr_array_unref0 (data->event_templates);
			_g_ptr_array_free0 (data->templates);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->search_query);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->_result_);
			_g_ptr_array_unref0 (data->event_templates);
			_g_ptr_array_free0 (data->templates);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->search_query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp30_ = g_timer_elapsed (data->timer, NULL);
	synapse_utils_logger_debug ((GObject*) data->self, "zeitgeist-plugin.vala:659: search took %d ms", (gint) (data->_tmp30_ * 1000), NULL);
	data->result = data->_result_;
	_g_ptr_array_unref0 (data->event_templates);
	_g_ptr_array_free0 (data->templates);
	_g_timer_destroy0 (data->timer);
	_g_free0 (data->search_query);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->_result_);
	_g_ptr_array_unref0 (data->event_templates);
	_g_ptr_array_free0 (data->templates);
	_g_timer_destroy0 (data->timer);
	_g_free0 (data->search_query);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_construct (GType object_type) {
	SynapseZeitgeistPlugin * self = NULL;
	self = (SynapseZeitgeistPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_new (void) {
	return synapse_zeitgeist_plugin_construct (SYNAPSE_TYPE_ZEITGEIST_PLUGIN);
}


static gboolean synapse_zeitgeist_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseZeitgeistPlugin* self;
	self = (SynapseZeitgeistPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_zeitgeist_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseZeitgeistPlugin* self;
	self = (SynapseZeitgeistPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_zeitgeist_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistPlugin * self;
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_ZEITGEIST_PLUGIN (obj);
	return obj;
}


static SynapseZeitgeistPluginMatchObject* synapse_zeitgeist_plugin_match_object_construct (GType object_type, ZeitgeistEvent* event, const gchar* thumbnail_path, const gchar* icon, gboolean is_application) {
	SynapseZeitgeistPluginMatchObject * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = g_strdup (icon);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp2_;
	}
	_tmp3_ = g_strdup (thumbnail_path);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp5_;
	}
	self = (SynapseZeitgeistPluginMatchObject*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp1_, "thumbnail-path", _tmp4_, NULL);
	if (!is_application) {
		synapse_zeitgeist_plugin_match_object_init_from_event (self, event);
	} else {
		synapse_zeitgeist_plugin_match_object_init_from_app_event (self, event);
	}
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	return self;
}


static SynapseZeitgeistPluginMatchObject* synapse_zeitgeist_plugin_match_object_new (ZeitgeistEvent* event, const gchar* thumbnail_path, const gchar* icon, gboolean is_application) {
	return synapse_zeitgeist_plugin_match_object_construct (SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, event, thumbnail_path, icon, is_application);
}


static void synapse_zeitgeist_plugin_match_object_init_from_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event) {
	ZeitgeistSubject* _tmp0_ = NULL;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* subject;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* f;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* text;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* interpretation;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = zeitgeist_event_get_subject (event, 0);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	subject = _tmp1_;
	_tmp2_ = zeitgeist_subject_get_uri (subject);
	synapse_uri_match_set_uri ((SynapseUriMatch*) self, _tmp2_);
	_tmp3_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
	_tmp4_ = g_file_new_for_uri (_tmp3_);
	f = _tmp4_;
	_tmp5_ = g_file_get_parse_name (f);
	_tmp6_ = _tmp5_;
	synapse_match_set_description ((SynapseMatch*) self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = zeitgeist_subject_get_text (subject);
	text = _tmp7_;
	if (text == NULL) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = g_strcmp0 (text, "") == 0;
	}
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = synapse_match_get_description ((SynapseMatch*) self);
		synapse_match_set_title ((SynapseMatch*) self, _tmp9_);
	} else {
		synapse_match_set_title ((SynapseMatch*) self, text);
	}
	_tmp10_ = zeitgeist_subject_get_mimetype (subject);
	synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, _tmp10_);
	_tmp11_ = zeitgeist_subject_get_interpretation (subject);
	interpretation = _tmp11_;
	_tmp12_ = zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_AUDIO);
	if (_tmp12_) {
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_AUDIO);
	} else {
		gboolean _tmp13_;
		_tmp13_ = zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_VIDEO);
		if (_tmp13_) {
			synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_VIDEO);
		} else {
			gboolean _tmp14_;
			_tmp14_ = zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_IMAGE);
			if (_tmp14_) {
				synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_IMAGES);
			} else {
				gboolean _tmp15_;
				_tmp15_ = zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_DOCUMENT);
				if (_tmp15_) {
					synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_DOCUMENTS);
				} else {
					gboolean _tmp16_;
					_tmp16_ = zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_WEBSITE);
					if (_tmp16_) {
						synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_INTERNET);
					} else {
						synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_UNCATEGORIZED);
					}
				}
			}
		}
	}
	_g_object_unref0 (f);
	_g_object_unref0 (subject);
}


static void synapse_zeitgeist_plugin_match_object_init_from_app_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event) {
	ZeitgeistSubject* _tmp0_ = NULL;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* subject;
	const gchar* _tmp2_ = NULL;
	SynapseDesktopFileService* _tmp3_ = NULL;
	SynapseDesktopFileService* dfs;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	SynapseDesktopFileInfo* _tmp7_ = NULL;
	SynapseDesktopFileInfo* _tmp8_;
	SynapseDesktopFileInfo* dfi;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_;
	const gchar* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_UNCATEGORIZED);
	synapse_match_set_match_type ((SynapseMatch*) self, SYNAPSE_MATCH_TYPE_APPLICATION);
	_tmp0_ = zeitgeist_event_get_subject (event, 0);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	subject = _tmp1_;
	_tmp2_ = zeitgeist_subject_get_uri (subject);
	synapse_uri_match_set_uri ((SynapseUriMatch*) self, _tmp2_);
	_tmp3_ = synapse_desktop_file_service_get_default ();
	dfs = _tmp3_;
	_tmp4_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
	_tmp5_ = string_substring (_tmp4_, (glong) 14, (glong) (-1));
	_tmp6_ = _tmp5_;
	_tmp7_ = synapse_desktop_file_service_get_desktop_file_for_id (dfs, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	dfi = _tmp8_;
	_tmp9_ = synapse_desktop_file_info_get_name (dfi);
	synapse_match_set_title ((SynapseMatch*) self, _tmp9_);
	_tmp10_ = synapse_desktop_file_info_get_icon_name (dfi);
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp10_);
	_tmp11_ = synapse_desktop_file_info_get_comment (dfi);
	synapse_match_set_description ((SynapseMatch*) self, _tmp11_);
	_tmp12_ = synapse_desktop_file_info_get_needs_terminal (dfi);
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp12_);
	_tmp13_ = synapse_desktop_file_info_get_filename (dfi);
	synapse_application_match_set_filename ((SynapseApplicationMatch*) self, _tmp13_);
	_g_object_unref0 (dfi);
	_g_object_unref0 (dfs);
	_g_object_unref0 (subject);
}


static void synapse_zeitgeist_plugin_match_object_init_extended_info_from_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event) {
	gint64 _tmp0_;
	gint64 now;
	gint64 _tmp1_;
	gint64 delta;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = zeitgeist_timestamp_for_now ();
	now = _tmp0_;
	_tmp1_ = zeitgeist_event_get_timestamp (event);
	delta = now - _tmp1_;
	if (delta < (ZEITGEIST_TIMESTAMP_MINUTE * 2)) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _ ("few moments ago");
		synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp2_);
	} else {
		if (delta < ZEITGEIST_TIMESTAMP_HOUR) {
			gint mins;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			mins = (gint) (delta / ZEITGEIST_TIMESTAMP_MINUTE);
			_tmp3_ = ngettext ("%d minute ago", "%d minutes ago", (gulong) mins);
			_tmp4_ = g_strdup_printf (_tmp3_, mins);
			_tmp5_ = _tmp4_;
			synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp5_);
			_g_free0 (_tmp5_);
		} else {
			if (delta < (ZEITGEIST_TIMESTAMP_DAY * 2)) {
				gint hours;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				hours = (gint) (delta / ZEITGEIST_TIMESTAMP_HOUR);
				_tmp6_ = ngettext ("%d hour ago", "%d hours ago", (gulong) hours);
				_tmp7_ = g_strdup_printf (_tmp6_, hours);
				_tmp8_ = _tmp7_;
				synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp8_);
				_g_free0 (_tmp8_);
			} else {
				if (delta < (ZEITGEIST_TIMESTAMP_WEEK * 2)) {
					gint days;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					days = (gint) (delta / ZEITGEIST_TIMESTAMP_DAY);
					_tmp9_ = ngettext ("%d day ago", "%d days ago", (gulong) days);
					_tmp10_ = g_strdup_printf (_tmp9_, days);
					_tmp11_ = _tmp10_;
					synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp11_);
					_g_free0 (_tmp11_);
				} else {
					if (delta < ZEITGEIST_TIMESTAMP_YEAR) {
						gint weeks;
						const gchar* _tmp12_ = NULL;
						gchar* _tmp13_ = NULL;
						gchar* _tmp14_;
						weeks = (gint) (delta / ZEITGEIST_TIMESTAMP_WEEK);
						_tmp12_ = ngettext ("%d week ago", "%d weeks ago", (gulong) weeks);
						_tmp13_ = g_strdup_printf (_tmp12_, weeks);
						_tmp14_ = _tmp13_;
						synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp14_);
						_g_free0 (_tmp14_);
					} else {
						synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, "long time ago");
					}
				}
			}
		}
	}
}


static const gchar* synapse_zeitgeist_plugin_match_object_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseZeitgeistPluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_zeitgeist_plugin_match_object_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseZeitgeistPluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp0_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_zeitgeist_plugin_match_object_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseZeitgeistPluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp0_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_zeitgeist_plugin_match_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_zeitgeist_plugin_match_object_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseZeitgeistPluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp0_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_zeitgeist_plugin_match_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static GAppInfo* synapse_zeitgeist_plugin_match_object_real_get_app_info (SynapseApplicationMatch* base) {
	GAppInfo* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_app_info;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_app_info (SynapseApplicationMatch* base, GAppInfo* value) {
	SynapseZeitgeistPluginMatchObject* self;
	GAppInfo* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_app_info);
	self->priv->_app_info = _tmp0_;
	g_object_notify ((GObject *) self, "app-info");
}


static gboolean synapse_zeitgeist_plugin_match_object_real_get_needs_terminal (SynapseApplicationMatch* base) {
	gboolean result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_needs_terminal;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_needs_terminal (SynapseApplicationMatch* base, gboolean value) {
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_needs_terminal = value;
	g_object_notify ((GObject *) self, "needs-terminal");
}


static const gchar* synapse_zeitgeist_plugin_match_object_real_get_filename (SynapseApplicationMatch* base) {
	const gchar* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_filename;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_filename (SynapseApplicationMatch* base, const gchar* value) {
	SynapseZeitgeistPluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
	g_object_notify ((GObject *) self, "filename");
}


static const gchar* synapse_zeitgeist_plugin_match_object_real_get_uri (SynapseUriMatch* base) {
	const gchar* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_uri;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_uri (SynapseUriMatch* base, const gchar* value) {
	SynapseZeitgeistPluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp0_;
	g_object_notify ((GObject *) self, "uri");
}


static SynapseQueryFlags synapse_zeitgeist_plugin_match_object_real_get_file_type (SynapseUriMatch* base) {
	SynapseQueryFlags result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_file_type;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_file_type (SynapseUriMatch* base, SynapseQueryFlags value) {
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_file_type = value;
	g_object_notify ((GObject *) self, "file-type");
}


static const gchar* synapse_zeitgeist_plugin_match_object_real_get_mime_type (SynapseUriMatch* base) {
	const gchar* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_mime_type;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_mime_type (SynapseUriMatch* base, const gchar* value) {
	SynapseZeitgeistPluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp0_;
	g_object_notify ((GObject *) self, "mime-type");
}


static const gchar* synapse_zeitgeist_plugin_match_object_real_get_extended_info (SynapseExtendedInfo* base) {
	const gchar* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_extended_info;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_extended_info (SynapseExtendedInfo* base, const gchar* value) {
	SynapseZeitgeistPluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_extended_info);
	self->priv->_extended_info = _tmp0_;
	g_object_notify ((GObject *) self, "extended-info");
}


static void synapse_zeitgeist_plugin_match_object_class_init (SynapseZeitgeistPluginMatchObjectClass * klass) {
	synapse_zeitgeist_plugin_match_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseZeitgeistPluginMatchObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_plugin_match_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_plugin_match_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_match_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_APP_INFO, "app-info");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_NEEDS_TERMINAL, "needs-terminal");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILENAME, "filename");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MIME_TYPE, "mime-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_EXTENDED_INFO, "extended-info");
}


static void synapse_zeitgeist_plugin_match_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_zeitgeist_plugin_match_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_zeitgeist_plugin_match_object_real_get_title;
	iface->set_title = synapse_zeitgeist_plugin_match_object_real_set_title;
	iface->get_description = synapse_zeitgeist_plugin_match_object_real_get_description;
	iface->set_description = synapse_zeitgeist_plugin_match_object_real_set_description;
	iface->get_icon_name = synapse_zeitgeist_plugin_match_object_real_get_icon_name;
	iface->set_icon_name = synapse_zeitgeist_plugin_match_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_zeitgeist_plugin_match_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_zeitgeist_plugin_match_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_zeitgeist_plugin_match_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_zeitgeist_plugin_match_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_zeitgeist_plugin_match_object_real_get_match_type;
	iface->set_match_type = synapse_zeitgeist_plugin_match_object_real_set_match_type;
}


static void synapse_zeitgeist_plugin_match_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface) {
	synapse_zeitgeist_plugin_match_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_zeitgeist_plugin_match_object_real_get_uri;
	iface->set_uri = synapse_zeitgeist_plugin_match_object_real_set_uri;
	iface->get_file_type = synapse_zeitgeist_plugin_match_object_real_get_file_type;
	iface->set_file_type = synapse_zeitgeist_plugin_match_object_real_set_file_type;
	iface->get_mime_type = synapse_zeitgeist_plugin_match_object_real_get_mime_type;
	iface->set_mime_type = synapse_zeitgeist_plugin_match_object_real_set_mime_type;
}


static void synapse_zeitgeist_plugin_match_object_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface) {
	synapse_zeitgeist_plugin_match_object_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_app_info = synapse_zeitgeist_plugin_match_object_real_get_app_info;
	iface->set_app_info = synapse_zeitgeist_plugin_match_object_real_set_app_info;
	iface->get_needs_terminal = synapse_zeitgeist_plugin_match_object_real_get_needs_terminal;
	iface->set_needs_terminal = synapse_zeitgeist_plugin_match_object_real_set_needs_terminal;
	iface->get_filename = synapse_zeitgeist_plugin_match_object_real_get_filename;
	iface->set_filename = synapse_zeitgeist_plugin_match_object_real_set_filename;
}


static void synapse_zeitgeist_plugin_match_object_synapse_extended_info_interface_init (SynapseExtendedInfoIface * iface) {
	synapse_zeitgeist_plugin_match_object_synapse_extended_info_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_extended_info = synapse_zeitgeist_plugin_match_object_real_get_extended_info;
	iface->set_extended_info = synapse_zeitgeist_plugin_match_object_real_set_extended_info;
}


static void synapse_zeitgeist_plugin_match_object_instance_init (SynapseZeitgeistPluginMatchObject * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
	self->priv->_extended_info = NULL;
}


static void synapse_zeitgeist_plugin_match_object_finalize (GObject* obj) {
	SynapseZeitgeistPluginMatchObject * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_extended_info);
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_match_object_parent_class)->finalize (obj);
}


static GType synapse_zeitgeist_plugin_match_object_get_type (void) {
	static volatile gsize synapse_zeitgeist_plugin_match_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_match_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginMatchObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_match_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPluginMatchObject), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_match_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_match_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_match_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_match_object_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_extended_info_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_match_object_synapse_extended_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_zeitgeist_plugin_match_object_type_id;
		synapse_zeitgeist_plugin_match_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistPluginMatchObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_zeitgeist_plugin_match_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_zeitgeist_plugin_match_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		g_type_add_interface_static (synapse_zeitgeist_plugin_match_object_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
		g_type_add_interface_static (synapse_zeitgeist_plugin_match_object_type_id, SYNAPSE_TYPE_EXTENDED_INFO, &synapse_extended_info_info);
		g_once_init_leave (&synapse_zeitgeist_plugin_match_object_type_id__volatile, synapse_zeitgeist_plugin_match_object_type_id);
	}
	return synapse_zeitgeist_plugin_match_object_type_id__volatile;
}


static void _vala_synapse_zeitgeist_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseZeitgeistPluginMatchObject * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_APP_INFO:
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_NEEDS_TERMINAL:
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILENAME:
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_URI:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_EXTENDED_INFO:
		g_value_set_string (value, synapse_extended_info_get_extended_info ((SynapseExtendedInfo*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_zeitgeist_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseZeitgeistPluginMatchObject * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_APP_INFO:
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_NEEDS_TERMINAL:
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILENAME:
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_URI:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_EXTENDED_INFO:
		synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_zeitgeist_plugin_class_init (SynapseZeitgeistPluginClass * klass) {
	synapse_zeitgeist_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseZeitgeistPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_ENABLED, "enabled");
	synapse_zeitgeist_plugin_register_plugin ();
}


static void synapse_zeitgeist_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_zeitgeist_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_zeitgeist_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_zeitgeist_plugin_real_deactivate;
	iface->get_enabled = synapse_zeitgeist_plugin_real_get_enabled;
	iface->set_enabled = synapse_zeitgeist_plugin_real_set_enabled;
}


static void synapse_zeitgeist_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_zeitgeist_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_empty_query = (gboolean (*)(SynapseItemProvider*)) synapse_zeitgeist_plugin_real_handles_empty_query;
	iface->search = (SynapseResultSet* (*)(SynapseItemProvider* ,SynapseQuery* ,GError**)) synapse_zeitgeist_plugin_real_search;
	iface->search_finish = synapse_zeitgeist_plugin_real_search_finish;
}


static void synapse_zeitgeist_plugin_instance_init (SynapseZeitgeistPlugin * self) {
	gchar* _tmp0_ = NULL;
	self->priv = SYNAPSE_ZEITGEIST_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	_tmp0_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, NULL, NULL);
	self->priv->interesting_attributes = _tmp0_;
}


static void synapse_zeitgeist_plugin_finalize (GObject* obj) {
	SynapseZeitgeistPlugin * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN (obj);
	_g_object_unref0 (self->priv->zg_index);
	_g_object_unref0 (self->priv->zg_log);
	_g_free0 (self->priv->interesting_attributes);
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_parent_class)->finalize (obj);
}


GType synapse_zeitgeist_plugin_get_type (void) {
	static volatile gsize synapse_zeitgeist_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPlugin), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_zeitgeist_plugin_type_id;
		synapse_zeitgeist_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_zeitgeist_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_zeitgeist_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_zeitgeist_plugin_type_id__volatile, synapse_zeitgeist_plugin_type_id);
	}
	return synapse_zeitgeist_plugin_type_id__volatile;
}


static void _vala_synapse_zeitgeist_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseZeitgeistPlugin * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_ZEITGEIST_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_zeitgeist_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseZeitgeistPlugin * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_ZEITGEIST_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



