/* selection-plugin.c generated by valac 0.11.7.1-263a8, the Vala compiler
 * generated from selection-plugin.vala, do not modify */

/*
 * Copyright (C) 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define SYNAPSE_TYPE_SELECTION_PLUGIN (synapse_selection_plugin_get_type ())
#define SYNAPSE_SELECTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPlugin))
#define SYNAPSE_SELECTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPluginClass))
#define SYNAPSE_IS_SELECTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SELECTION_PLUGIN))
#define SYNAPSE_IS_SELECTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_SELECTION_PLUGIN))
#define SYNAPSE_SELECTION_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPluginClass))

typedef struct _SynapseSelectionPlugin SynapseSelectionPlugin;
typedef struct _SynapseSelectionPluginClass SynapseSelectionPluginClass;
typedef struct _SynapseSelectionPluginPrivate SynapseSelectionPluginPrivate;

#define SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM (synapse_selection_plugin_selected_text_item_get_type ())
#define SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM, SynapseSelectionPluginSelectedTextItem))
#define SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM, SynapseSelectionPluginSelectedTextItemClass))
#define SYNAPSE_SELECTION_PLUGIN_IS_SELECTED_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM))
#define SYNAPSE_SELECTION_PLUGIN_IS_SELECTED_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM))
#define SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM, SynapseSelectionPluginSelectedTextItemClass))

typedef struct _SynapseSelectionPluginSelectedTextItem SynapseSelectionPluginSelectedTextItem;
typedef struct _SynapseSelectionPluginSelectedTextItemClass SynapseSelectionPluginSelectedTextItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseSelectionPluginSearchData SynapseSelectionPluginSearchData;
typedef struct _SynapseSelectionPluginSelectedTextItemPrivate SynapseSelectionPluginSelectedTextItemPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseSelectionPlugin {
	GObject parent_instance;
	SynapseSelectionPluginPrivate * priv;
};

struct _SynapseSelectionPluginClass {
	GObjectClass parent_class;
};

struct _SynapseSelectionPluginPrivate {
	gboolean _enabled;
	GtkClipboard* clipboard;
	SynapseSelectionPluginSelectedTextItem* item;
	gboolean cb_changed;
};

struct _Block7Data {
	int _ref_count_;
	SynapseSelectionPlugin * self;
	gchar* cb_text;
	gpointer _async_data_;
};

typedef void (*SynapseSelectionPluginClipboardTextReceivedFunc) (GtkClipboard* cb, const gchar* text, void* user_data);
struct _SynapseSelectionPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseSelectionPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	Block7Data* _data7_;
	GeeList* _tmp0_;
	GeeList* matchers;
	gint relevancy;
	GeeList* _tmp1_;
	GeeList* _matcher_list;
	gint _tmp2_;
	gint _matcher_size;
	gint _matcher_index;
	gpointer _tmp3_;
	GeeMapEntry* matcher;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gconstpointer _tmp7_;
	SynapseSelectionPluginClipboardTextReceivedFunc f;
	void* f_target;
	GDestroyNotify f_target_destroy_notify;
	gchar* _tmp8_;
	gchar* _tmp9_;
	SynapseResultSet* _tmp10_;
	SynapseResultSet* results;
	GError * _inner_error_;
};

struct _SynapseSelectionPluginSelectedTextItem {
	GObject parent_instance;
	SynapseSelectionPluginSelectedTextItemPrivate * priv;
};

struct _SynapseSelectionPluginSelectedTextItemClass {
	GObjectClass parent_class;
};

struct _SynapseSelectionPluginSelectedTextItemPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	SynapseTextOrigin _text_origin;
	gchar* content;
};


static gpointer synapse_selection_plugin_parent_class = NULL;
static gpointer synapse_selection_plugin_selected_text_item_parent_class = NULL;
static SynapseMatchIface* synapse_selection_plugin_selected_text_item_synapse_match_parent_iface = NULL;
static SynapseTextMatchIface* synapse_selection_plugin_selected_text_item_synapse_text_match_parent_iface = NULL;
static SynapseActivatableIface* synapse_selection_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_selection_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_selection_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_selection_plugin_selected_text_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_SELECTION_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPluginPrivate))
enum  {
	SYNAPSE_SELECTION_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_SELECTION_PLUGIN_ENABLED
};
static void synapse_selection_plugin_real_activate (SynapseActivatable* base);
static SynapseSelectionPluginSelectedTextItem* synapse_selection_plugin_selected_text_item_new (void);
static SynapseSelectionPluginSelectedTextItem* synapse_selection_plugin_selected_text_item_construct (GType object_type);
static void synapse_selection_plugin_cb_owner_change (SynapseSelectionPlugin* self);
static void _synapse_selection_plugin_cb_owner_change_gtk_clipboard_owner_change (GtkClipboard* _sender, GdkEvent* p0, gpointer self);
static void synapse_selection_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_selection_plugin_register_plugin (void);
static void _synapse_selection_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_selection_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* query);
static void synapse_selection_plugin_real_search_data_free (gpointer _data);
static void synapse_selection_plugin_real_search (SynapseItemProvider* base, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean synapse_selection_plugin_real_search_co (SynapseSelectionPluginSearchData* data);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void _lambda13_ (GtkClipboard* cb, const gchar* text, Block7Data* _data7_);
static void __lambda13__synapse_selection_plugin_clipboard_text_received_func (GtkClipboard* cb, const gchar* text, gpointer self);
static gboolean _synapse_selection_plugin_real_search_co_gsource_func (gpointer self);
static void synapse_selection_plugin_selected_text_item_update_content (SynapseSelectionPluginSelectedTextItem* self, gchar* content);
SynapseSelectionPlugin* synapse_selection_plugin_new (void);
SynapseSelectionPlugin* synapse_selection_plugin_construct (GType object_type);
#define SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM, SynapseSelectionPluginSelectedTextItemPrivate))
enum  {
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_DUMMY_PROPERTY,
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_TITLE,
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_DESCRIPTION,
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_ICON_NAME,
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_HAS_THUMBNAIL,
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_THUMBNAIL_PATH,
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_MATCH_TYPE,
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_TEXT_ORIGIN
};
static gchar* synapse_selection_plugin_selected_text_item_real_get_text (SynapseTextMatch* base);
static void synapse_selection_plugin_selected_text_item_finalize (GObject* obj);
static void _vala_synapse_selection_plugin_selected_text_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_selection_plugin_selected_text_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_selection_plugin_finalize (GObject* obj);
static void _vala_synapse_selection_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_selection_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _synapse_selection_plugin_cb_owner_change_gtk_clipboard_owner_change (GtkClipboard* _sender, GdkEvent* p0, gpointer self) {
	synapse_selection_plugin_cb_owner_change (self);
}


static void synapse_selection_plugin_real_activate (SynapseActivatable* base) {
	SynapseSelectionPlugin * self;
	SynapseSelectionPluginSelectedTextItem* _tmp0_ = NULL;
	GtkClipboard* _tmp1_ = NULL;
	GtkClipboard* _tmp2_;
	self = (SynapseSelectionPlugin*) base;
	_tmp0_ = synapse_selection_plugin_selected_text_item_new ();
	_g_object_unref0 (self->priv->item);
	self->priv->item = _tmp0_;
	_tmp1_ = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->clipboard = _tmp2_;
	g_signal_connect_object (self->priv->clipboard, "owner-change", (GCallback) _synapse_selection_plugin_cb_owner_change_gtk_clipboard_owner_change, self, 0);
}


static void synapse_selection_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseSelectionPlugin * self;
	guint _tmp0_;
	self = (SynapseSelectionPlugin*) base;
	g_signal_parse_name ("owner-change", GTK_TYPE_CLIPBOARD, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->clipboard, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _synapse_selection_plugin_cb_owner_change_gtk_clipboard_owner_change, self);
}


static void synapse_selection_plugin_cb_owner_change (SynapseSelectionPlugin* self) {
	g_return_if_fail (self != NULL);
	self->priv->cb_changed = TRUE;
}


static void _synapse_selection_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_selection_plugin_register_plugin ();
}


static void synapse_selection_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Selection");
	_tmp3_ = _ ("Provides actions for currently selected text.");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_SELECTION_PLUGIN, _tmp2_, _tmp3_, "edit-select-all", _synapse_selection_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}


static gboolean synapse_selection_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* query) {
	SynapseSelectionPlugin * self;
	gboolean result = FALSE;
	self = (SynapseSelectionPlugin*) base;
	result = ((*query).query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
	return result;
}


static void synapse_selection_plugin_real_search_data_free (gpointer _data) {
	SynapseSelectionPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->query);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseSelectionPluginSearchData, data);
}


static void synapse_selection_plugin_real_search (SynapseItemProvider* base, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseSelectionPlugin * self;
	SynapseSelectionPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseSelectionPlugin*) base;
	_data_ = g_slice_new0 (SynapseSelectionPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_selection_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_selection_plugin_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_query_copy (query, &_tmp0_);
	_data_->query = _tmp0_;
	synapse_selection_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_selection_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseSelectionPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_free0 (_data7_->cb_text);
		g_slice_free (Block7Data, _data7_);
	}
}


static void _lambda13_ (GtkClipboard* cb, const gchar* text, Block7Data* _data7_) {
	SynapseSelectionPlugin * self;
	gchar* _tmp0_;
	self = _data7_->self;
	g_return_if_fail (cb != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data7_->cb_text);
	_data7_->cb_text = _tmp0_;
	synapse_selection_plugin_real_search_co (_data7_->_async_data_);
}


static void __lambda13__synapse_selection_plugin_clipboard_text_received_func (GtkClipboard* cb, const gchar* text, gpointer self) {
	_lambda13_ (cb, text, self);
}


static gboolean _synapse_selection_plugin_real_search_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_selection_plugin_real_search_co (self);
	return result;
}


static gboolean synapse_selection_plugin_real_search_co (SynapseSelectionPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data7_ = g_slice_new0 (Block7Data);
	data->_data7_->_ref_count_ = 1;
	data->_data7_->self = g_object_ref (data->self);
	data->_data7_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = synapse_query_get_matchers_for_query (data->query.query_string, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, G_REGEX_CASELESS);
	data->matchers = data->_tmp0_;
	data->relevancy = 0;
	{
		data->_tmp1_ = _g_object_ref0 (data->matchers);
		data->_matcher_list = data->_tmp1_;
		data->_tmp2_ = gee_collection_get_size ((GeeCollection*) data->_matcher_list);
		data->_matcher_size = data->_tmp2_;
		data->_matcher_index = -1;
		while (TRUE) {
			data->_matcher_index = data->_matcher_index + 1;
			if (!(data->_matcher_index < data->_matcher_size)) {
				break;
			}
			data->_tmp3_ = NULL;
			data->_tmp3_ = gee_list_get (data->_matcher_list, data->_matcher_index);
			data->matcher = (GeeMapEntry*) data->_tmp3_;
			data->_tmp4_ = NULL;
			data->_tmp4_ = gee_map_entry_get_key (data->matcher);
			data->_tmp5_ = NULL;
			data->_tmp5_ = synapse_match_get_title ((SynapseMatch*) data->self->priv->item);
			data->_tmp6_ = g_regex_match ((GRegex*) data->_tmp4_, data->_tmp5_, 0, NULL);
			if (data->_tmp6_) {
				data->_tmp7_ = NULL;
				data->_tmp7_ = gee_map_entry_get_value (data->matcher);
				data->relevancy = GPOINTER_TO_INT (data->_tmp7_);
				_g_object_unref0 (data->matcher);
				break;
			}
			_g_object_unref0 (data->matcher);
		}
		_g_object_unref0 (data->_matcher_list);
	}
	if (data->relevancy == 0) {
		data->result = NULL;
		_g_object_unref0 (data->matchers);
		block7_data_unref (data->_data7_);
		data->_data7_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_data7_->cb_text = NULL;
	if (data->self->priv->cb_changed) {
		data->f_target = NULL;
		data->f_target_destroy_notify = NULL;
		data->f = __lambda13__synapse_selection_plugin_clipboard_text_received_func;
		data->f_target = block7_data_ref (data->_data7_);
		data->f_target_destroy_notify = block7_data_unref;
		gtk_clipboard_request_text (data->self->priv->clipboard, (GtkClipboardTextReceivedFunc) data->f, data->f_target);
		(data->f_target_destroy_notify == NULL) ? NULL : (data->f_target_destroy_notify (data->f_target), NULL);
		data->f = NULL;
		data->f_target = NULL;
		data->f_target_destroy_notify = NULL;
	} else {
		data->_tmp8_ = g_strdup ("");
		_g_free0 (data->_data7_->cb_text);
		data->_data7_->cb_text = data->_tmp8_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_selection_plugin_real_search_co_gsource_func, data, NULL);
	}
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	synapse_query_check_cancellable (&data->query, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->matchers);
			block7_data_unref (data->_data7_);
			data->_data7_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->matchers);
			block7_data_unref (data->_data7_);
			data->_data7_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_data7_->cb_text != NULL) {
		if (data->self->priv->cb_changed) {
			data->_tmp9_ = data->_data7_->cb_text;
			data->_data7_->cb_text = NULL;
			synapse_selection_plugin_selected_text_item_update_content (data->self->priv->item, data->_tmp9_);
			data->self->priv->cb_changed = FALSE;
		}
		data->_tmp10_ = NULL;
		data->_tmp10_ = synapse_result_set_new ();
		data->results = data->_tmp10_;
		synapse_result_set_add (data->results, (SynapseMatch*) data->self->priv->item, data->relevancy);
		synapse_query_check_cancellable (&data->query, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->results);
				_g_object_unref0 (data->matchers);
				block7_data_unref (data->_data7_);
				data->_data7_ = NULL;
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (data->results);
				_g_object_unref0 (data->matchers);
				block7_data_unref (data->_data7_);
				data->_data7_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->results;
		_g_object_unref0 (data->matchers);
		block7_data_unref (data->_data7_);
		data->_data7_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	synapse_query_check_cancellable (&data->query, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->matchers);
			block7_data_unref (data->_data7_);
			data->_data7_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->matchers);
			block7_data_unref (data->_data7_);
			data->_data7_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = NULL;
	_g_object_unref0 (data->matchers);
	block7_data_unref (data->_data7_);
	data->_data7_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->matchers);
	block7_data_unref (data->_data7_);
	data->_data7_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


SynapseSelectionPlugin* synapse_selection_plugin_construct (GType object_type) {
	SynapseSelectionPlugin * self = NULL;
	self = (SynapseSelectionPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseSelectionPlugin* synapse_selection_plugin_new (void) {
	return synapse_selection_plugin_construct (SYNAPSE_TYPE_SELECTION_PLUGIN);
}


static gboolean synapse_selection_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseSelectionPlugin* self;
	self = (SynapseSelectionPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_selection_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseSelectionPlugin* self;
	self = (SynapseSelectionPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static SynapseSelectionPluginSelectedTextItem* synapse_selection_plugin_selected_text_item_construct (GType object_type) {
	SynapseSelectionPluginSelectedTextItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = _ ("Selected text");
	self = (SynapseSelectionPluginSelectedTextItem*) g_object_new (object_type, "title", _tmp0_, "description", "", "icon-name", "edit-select-all", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_TEXT, "text-origin", SYNAPSE_TEXT_ORIGIN_CLIPBOARD, NULL);
	return self;
}


static SynapseSelectionPluginSelectedTextItem* synapse_selection_plugin_selected_text_item_new (void) {
	return synapse_selection_plugin_selected_text_item_construct (SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM);
}


static gchar* synapse_selection_plugin_selected_text_item_real_get_text (SynapseTextMatch* base) {
	SynapseSelectionPluginSelectedTextItem * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	_tmp0_ = g_strdup (self->priv->content);
	result = _tmp0_;
	return result;
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch41_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch41_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally41;
	__catch41_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally41:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void synapse_selection_plugin_selected_text_item_update_content (SynapseSelectionPluginSelectedTextItem* self, gchar* content) {
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* chugged;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* shortened;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = g_strdup (content);
	_g_free0 (self->priv->content);
	self->priv->content = _tmp0_;
	_tmp1_ = string_chug (content);
	chugged = _tmp1_;
	_tmp2_ = strlen (chugged);
	_tmp3_ = MIN ((gint) _tmp2_, 100);
	_tmp4_ = string_substring (chugged, (glong) 0, (glong) _tmp3_);
	shortened = _tmp4_;
	_tmp5_ = string_replace (shortened, "\n", " ");
	_tmp6_ = _tmp5_;
	synapse_match_set_description ((SynapseMatch*) self, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (shortened);
	_g_free0 (chugged);
	_g_free0 (content);
}


static const gchar* synapse_selection_plugin_selected_text_item_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_selection_plugin_selected_text_item_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseSelectionPluginSelectedTextItem* self;
	gchar* _tmp0_;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_selection_plugin_selected_text_item_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_selection_plugin_selected_text_item_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseSelectionPluginSelectedTextItem* self;
	gchar* _tmp0_;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp0_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_selection_plugin_selected_text_item_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_selection_plugin_selected_text_item_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseSelectionPluginSelectedTextItem* self;
	gchar* _tmp0_;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp0_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_selection_plugin_selected_text_item_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_selection_plugin_selected_text_item_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_selection_plugin_selected_text_item_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_selection_plugin_selected_text_item_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseSelectionPluginSelectedTextItem* self;
	gchar* _tmp0_;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp0_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_selection_plugin_selected_text_item_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_selection_plugin_selected_text_item_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static SynapseTextOrigin synapse_selection_plugin_selected_text_item_real_get_text_origin (SynapseTextMatch* base) {
	SynapseTextOrigin result;
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	result = self->priv->_text_origin;
	return result;
}


static void synapse_selection_plugin_selected_text_item_real_set_text_origin (SynapseTextMatch* base, SynapseTextOrigin value) {
	SynapseSelectionPluginSelectedTextItem* self;
	self = (SynapseSelectionPluginSelectedTextItem*) base;
	self->priv->_text_origin = value;
	g_object_notify ((GObject *) self, "text-origin");
}


static void synapse_selection_plugin_selected_text_item_class_init (SynapseSelectionPluginSelectedTextItemClass * klass) {
	synapse_selection_plugin_selected_text_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseSelectionPluginSelectedTextItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_selection_plugin_selected_text_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_selection_plugin_selected_text_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_selection_plugin_selected_text_item_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_TEXT_ORIGIN, "text-origin");
}


static void synapse_selection_plugin_selected_text_item_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_selection_plugin_selected_text_item_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_selection_plugin_selected_text_item_real_get_title;
	iface->set_title = synapse_selection_plugin_selected_text_item_real_set_title;
	iface->get_description = synapse_selection_plugin_selected_text_item_real_get_description;
	iface->set_description = synapse_selection_plugin_selected_text_item_real_set_description;
	iface->get_icon_name = synapse_selection_plugin_selected_text_item_real_get_icon_name;
	iface->set_icon_name = synapse_selection_plugin_selected_text_item_real_set_icon_name;
	iface->get_has_thumbnail = synapse_selection_plugin_selected_text_item_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_selection_plugin_selected_text_item_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_selection_plugin_selected_text_item_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_selection_plugin_selected_text_item_real_set_thumbnail_path;
	iface->get_match_type = synapse_selection_plugin_selected_text_item_real_get_match_type;
	iface->set_match_type = synapse_selection_plugin_selected_text_item_real_set_match_type;
}


static void synapse_selection_plugin_selected_text_item_synapse_text_match_interface_init (SynapseTextMatchIface * iface) {
	synapse_selection_plugin_selected_text_item_synapse_text_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_text = (gchar* (*)(SynapseTextMatch*)) synapse_selection_plugin_selected_text_item_real_get_text;
	iface->get_text_origin = synapse_selection_plugin_selected_text_item_real_get_text_origin;
	iface->set_text_origin = synapse_selection_plugin_selected_text_item_real_set_text_origin;
}


static void synapse_selection_plugin_selected_text_item_instance_init (SynapseSelectionPluginSelectedTextItem * self) {
	self->priv = SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_GET_PRIVATE (self);
	self->priv->content = NULL;
}


static void synapse_selection_plugin_selected_text_item_finalize (GObject* obj) {
	SynapseSelectionPluginSelectedTextItem * self;
	self = SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->content);
	G_OBJECT_CLASS (synapse_selection_plugin_selected_text_item_parent_class)->finalize (obj);
}


static GType synapse_selection_plugin_selected_text_item_get_type (void) {
	static volatile gsize synapse_selection_plugin_selected_text_item_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_selection_plugin_selected_text_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseSelectionPluginSelectedTextItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_selection_plugin_selected_text_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseSelectionPluginSelectedTextItem), 0, (GInstanceInitFunc) synapse_selection_plugin_selected_text_item_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_selection_plugin_selected_text_item_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_text_match_info = { (GInterfaceInitFunc) synapse_selection_plugin_selected_text_item_synapse_text_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_selection_plugin_selected_text_item_type_id;
		synapse_selection_plugin_selected_text_item_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseSelectionPluginSelectedTextItem", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_selection_plugin_selected_text_item_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_selection_plugin_selected_text_item_type_id, SYNAPSE_TYPE_TEXT_MATCH, &synapse_text_match_info);
		g_once_init_leave (&synapse_selection_plugin_selected_text_item_type_id__volatile, synapse_selection_plugin_selected_text_item_type_id);
	}
	return synapse_selection_plugin_selected_text_item_type_id__volatile;
}


static void _vala_synapse_selection_plugin_selected_text_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseSelectionPluginSelectedTextItem * self;
	self = SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM (object);
	switch (property_id) {
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_TEXT_ORIGIN:
		g_value_set_enum (value, synapse_text_match_get_text_origin ((SynapseTextMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_selection_plugin_selected_text_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseSelectionPluginSelectedTextItem * self;
	self = SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM (object);
	switch (property_id) {
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_TEXT_ORIGIN:
		synapse_text_match_set_text_origin ((SynapseTextMatch*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_selection_plugin_class_init (SynapseSelectionPluginClass * klass) {
	synapse_selection_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseSelectionPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_selection_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_selection_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_selection_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_ENABLED, "enabled");
	synapse_selection_plugin_register_plugin ();
}


static void synapse_selection_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_selection_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_selection_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_selection_plugin_real_deactivate;
	iface->get_enabled = synapse_selection_plugin_real_get_enabled;
	iface->set_enabled = synapse_selection_plugin_real_set_enabled;
}


static void synapse_selection_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_selection_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*)(SynapseItemProvider* ,SynapseQuery*)) synapse_selection_plugin_real_handles_query;
	iface->search = (SynapseResultSet* (*)(SynapseItemProvider* ,SynapseQuery* ,GError**)) synapse_selection_plugin_real_search;
	iface->search_finish = synapse_selection_plugin_real_search_finish;
}


static void synapse_selection_plugin_instance_init (SynapseSelectionPlugin * self) {
	self->priv = SYNAPSE_SELECTION_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->cb_changed = TRUE;
}


static void synapse_selection_plugin_finalize (GObject* obj) {
	SynapseSelectionPlugin * self;
	self = SYNAPSE_SELECTION_PLUGIN (obj);
	_g_object_unref0 (self->priv->clipboard);
	_g_object_unref0 (self->priv->item);
	G_OBJECT_CLASS (synapse_selection_plugin_parent_class)->finalize (obj);
}


GType synapse_selection_plugin_get_type (void) {
	static volatile gsize synapse_selection_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_selection_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseSelectionPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_selection_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseSelectionPlugin), 0, (GInstanceInitFunc) synapse_selection_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_selection_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_selection_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_selection_plugin_type_id;
		synapse_selection_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseSelectionPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_selection_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_selection_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_selection_plugin_type_id__volatile, synapse_selection_plugin_type_id);
	}
	return synapse_selection_plugin_type_id__volatile;
}


static void _vala_synapse_selection_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseSelectionPlugin * self;
	self = SYNAPSE_SELECTION_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_SELECTION_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_selection_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseSelectionPlugin * self;
	self = SYNAPSE_SELECTION_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_SELECTION_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



