/* locate-plugin.c generated by valac 0.11.7.1-263a8, the Vala compiler
 * generated from locate-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gunixinputstream.h>


#define SYNAPSE_TYPE_LOCATE_PLUGIN (synapse_locate_plugin_get_type ())
#define SYNAPSE_LOCATE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin))
#define SYNAPSE_LOCATE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginClass))
#define SYNAPSE_IS_LOCATE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN))
#define SYNAPSE_IS_LOCATE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_LOCATE_PLUGIN))
#define SYNAPSE_LOCATE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginClass))

typedef struct _SynapseLocatePlugin SynapseLocatePlugin;
typedef struct _SynapseLocatePluginClass SynapseLocatePluginClass;
typedef struct _SynapseLocatePluginPrivate SynapseLocatePluginPrivate;

#define SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM (synapse_locate_plugin_locate_item_get_type ())
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem))
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItemClass))
#define SYNAPSE_LOCATE_PLUGIN_IS_LOCATE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM))
#define SYNAPSE_LOCATE_PLUGIN_IS_LOCATE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM))
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItemClass))

typedef struct _SynapseLocatePluginLocateItem SynapseLocatePluginLocateItem;
typedef struct _SynapseLocatePluginLocateItemClass SynapseLocatePluginLocateItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT (synapse_locate_plugin_match_object_get_type ())
#define SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT, SynapseLocatePluginMatchObject))
#define SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT, SynapseLocatePluginMatchObjectClass))
#define SYNAPSE_LOCATE_PLUGIN_IS_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_LOCATE_PLUGIN_IS_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT, SynapseLocatePluginMatchObjectClass))

typedef struct _SynapseLocatePluginMatchObject SynapseLocatePluginMatchObject;
typedef struct _SynapseLocatePluginMatchObjectClass SynapseLocatePluginMatchObjectClass;
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
typedef struct _SynapseLocatePluginLocateData SynapseLocatePluginLocateData;
typedef struct _SynapseLocatePluginMatchObjectPrivate SynapseLocatePluginMatchObjectPrivate;
typedef struct _SynapseLocatePluginLocateItemPrivate SynapseLocatePluginLocateItemPrivate;
typedef struct _SynapseLocatePluginLocateItemSearchData SynapseLocatePluginLocateItemSearchData;

struct _SynapseLocatePlugin {
	GObject parent_instance;
	SynapseLocatePluginPrivate * priv;
};

struct _SynapseLocatePluginClass {
	GObjectClass parent_class;
};

struct _SynapseLocatePluginPrivate {
	gboolean _enabled;
	SynapseLocatePluginLocateItem* action;
};

struct _SynapseLocatePluginLocateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseLocatePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQueryFlags our_results;
	SynapseQueryFlags common_flags;
	gchar* _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* regex;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	GeeHashSet* _tmp13_;
	GeeSet* uris;
	GPid pid;
	gint read_fd;
	GPid _tmp14_;
	gint _tmp15_;
	GUnixInputStream* _tmp16_;
	GUnixInputStream* read_stream;
	GDataInputStream* _tmp17_;
	GDataInputStream* locate_output;
	gchar* line;
	GRegex* _tmp18_;
	GRegex* filter_re;
	gboolean _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	GFile* _tmp23_;
	GFile* file;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError * err;
	gboolean _tmp26_;
	SynapseResultSet* _tmp27_;
	SynapseResultSet* _result_;
	GeeIterator* _tmp28_;
	GeeIterator* _s_it;
	gboolean _tmp29_;
	gpointer _tmp30_;
	gchar* s;
	SynapseUtilsFileInfo* _tmp31_;
	SynapseUtilsFileInfo* fi;
	gboolean _tmp32_;
	gint relevancy;
	gboolean _tmp33_;
	GError * _inner_error_;
};

struct _SynapseLocatePluginMatchObject {
	GObject parent_instance;
	SynapseLocatePluginMatchObjectPrivate * priv;
};

struct _SynapseLocatePluginMatchObjectClass {
	GObjectClass parent_class;
};

struct _SynapseLocatePluginMatchObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gchar* _uri;
	SynapseQueryFlags _file_type;
	gchar* _mime_type;
};

struct _SynapseLocatePluginLocateItem {
	GObject parent_instance;
	SynapseLocatePluginLocateItemPrivate * priv;
};

struct _SynapseLocatePluginLocateItemClass {
	GObjectClass parent_class;
};

struct _SynapseLocatePluginLocateItemPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
	SynapseLocatePlugin* plugin;
};

struct _SynapseLocatePluginLocateItemSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseLocatePluginLocateItem* self;
	gchar* query;
	SynapseQueryFlags flags;
	SynapseResultSet* dest_result_set;
	GCancellable* cancellable;
	GeeList* result;
	SynapseQuery q;
	GCancellable* _tmp0_;
	SynapseResultSet* _tmp1_;
	SynapseResultSet* results;
	GeeList* _tmp2_;
	GError * _inner_error_;
};


static gpointer synapse_locate_plugin_parent_class = NULL;
static gpointer synapse_locate_plugin_match_object_parent_class = NULL;
static SynapseMatchIface* synapse_locate_plugin_match_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface* synapse_locate_plugin_match_object_synapse_uri_match_parent_iface = NULL;
static gpointer synapse_locate_plugin_locate_item_parent_class = NULL;
static SynapseSearchProviderIface* synapse_locate_plugin_locate_item_synapse_search_provider_parent_iface = NULL;
static SynapseMatchIface* synapse_locate_plugin_locate_item_synapse_match_parent_iface = NULL;
static SynapseSearchMatchIface* synapse_locate_plugin_locate_item_synapse_search_match_parent_iface = NULL;
static SynapseActivatableIface* synapse_locate_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface* synapse_locate_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_locate_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_locate_plugin_locate_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_LOCATE_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginPrivate))
enum  {
	SYNAPSE_LOCATE_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_ENABLED
};
static void synapse_locate_plugin_real_activate (SynapseActivatable* base);
static void synapse_locate_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_locate_plugin_register_plugin (void);
static void _synapse_locate_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_locate_plugin_real_handles_unknown (SynapseActionProvider* base);
static void synapse_locate_plugin_locate_data_free (gpointer _data);
void synapse_locate_plugin_locate (SynapseLocatePlugin* self, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
SynapseResultSet* synapse_locate_plugin_locate_finish (SynapseLocatePlugin* self, GAsyncResult* _res_, GError** error);
static gboolean synapse_locate_plugin_locate_co (SynapseLocatePluginLocateData* data);
static void synapse_locate_plugin_locate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GType synapse_locate_plugin_match_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseResultSet* synapse_locate_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* q, SynapseMatch* match);
static gint synapse_locate_plugin_locate_item_get_default_relevancy (SynapseLocatePluginLocateItem* self);
SynapseLocatePlugin* synapse_locate_plugin_new (void);
SynapseLocatePlugin* synapse_locate_plugin_construct (GType object_type);
static GObject * synapse_locate_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static SynapseLocatePluginLocateItem* synapse_locate_plugin_locate_item_new (SynapseLocatePlugin* plugin);
static SynapseLocatePluginLocateItem* synapse_locate_plugin_locate_item_construct (GType object_type, SynapseLocatePlugin* plugin);
#define SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT, SynapseLocatePluginMatchObjectPrivate))
enum  {
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_TITLE,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_DESCRIPTION,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_ICON_NAME,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_MATCH_TYPE,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_URI,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_FILE_TYPE,
	SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_MIME_TYPE
};
static SynapseLocatePluginMatchObject* synapse_locate_plugin_match_object_new (const gchar* thumbnail_path, const gchar* icon);
static SynapseLocatePluginMatchObject* synapse_locate_plugin_match_object_construct (GType object_type, const gchar* thumbnail_path, const gchar* icon);
static void synapse_locate_plugin_match_object_finalize (GObject* obj);
static void _vala_synapse_locate_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_locate_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItemPrivate))
enum  {
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DUMMY_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_TITLE,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DESCRIPTION,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_ICON_NAME,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_HAS_THUMBNAIL,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_THUMBNAIL_PATH,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_MATCH_TYPE,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY
};
static void synapse_locate_plugin_locate_item_real_search_data_free (gpointer _data);
static void synapse_locate_plugin_locate_item_real_search (SynapseSearchProvider* base, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean synapse_locate_plugin_locate_item_real_search_co (SynapseLocatePluginLocateItemSearchData* data);
static void synapse_locate_plugin_locate_item_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_locate_plugin_locate_item_set_default_relevancy (SynapseLocatePluginLocateItem* self, gint value);
static void synapse_locate_plugin_locate_item_finalize (GObject* obj);
static void _vala_synapse_locate_plugin_locate_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_locate_plugin_locate_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_locate_plugin_finalize (GObject* obj);
static void _vala_synapse_locate_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_locate_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void synapse_locate_plugin_real_activate (SynapseActivatable* base) {
	SynapseLocatePlugin * self;
	self = (SynapseLocatePlugin*) base;
}


static void synapse_locate_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseLocatePlugin * self;
	self = (SynapseLocatePlugin*) base;
}


static void _synapse_locate_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_locate_plugin_register_plugin ();
}


static void synapse_locate_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Locate");
	_tmp3_ = _ ("Runs locate command to find files on the filesystem.");
	_tmp4_ = g_find_program_in_path ("locate");
	_tmp5_ = _tmp4_;
	_tmp6_ = _ ("Unable to find \"locate\" binary");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_LOCATE_PLUGIN, _tmp2_, _tmp3_, "search", _synapse_locate_plugin_register_plugin_synapse_plugin_register_func, _tmp5_ != NULL, _tmp6_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
}


static gboolean synapse_locate_plugin_real_handles_unknown (SynapseActionProvider* base) {
	SynapseLocatePlugin * self;
	gboolean result = FALSE;
	self = (SynapseLocatePlugin*) base;
	result = TRUE;
	return result;
}


static void synapse_locate_plugin_locate_data_free (gpointer _data) {
	SynapseLocatePluginLocateData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseLocatePluginLocateData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void synapse_locate_plugin_locate (SynapseLocatePlugin* self, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseLocatePluginLocateData* _data_;
	SynapseQuery _tmp0_ = {0};
	_data_ = g_slice_new0 (SynapseLocatePluginLocateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_locate_plugin_locate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_locate_plugin_locate_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_query_copy (q, &_tmp0_);
	_data_->q = _tmp0_;
	synapse_locate_plugin_locate_co (_data_);
}


SynapseResultSet* synapse_locate_plugin_locate_finish (SynapseLocatePlugin* self, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseLocatePluginLocateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch26_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch26_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally26;
	__catch26_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void synapse_locate_plugin_locate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseLocatePluginLocateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_locate_plugin_locate_co (data);
}


static gboolean synapse_locate_plugin_locate_co (SynapseLocatePluginLocateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
	data->common_flags = data->q.query_type & data->our_results;
	data->_tmp0_ = NULL;
	data->_tmp0_ = string_strip (data->q.query_string);
	_g_free0 (data->q.query_string);
	data->q.query_string = data->_tmp0_;
	if (data->common_flags == 0) {
		data->_tmp1_ = TRUE;
	} else {
		data->_tmp2_ = strlen (data->q.query_string);
		data->_tmp1_ = data->_tmp2_ <= 1;
	}
	if (data->_tmp1_) {
		data->result = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->q.max_results = (guint) 256;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_regex_escape_string (data->q.query_string, -1);
	data->regex = data->_tmp3_;
	data->_tmp4_ = g_strdup ("locate");
	data->_tmp5_ = g_strdup ("-i");
	data->_tmp6_ = g_strdup ("-l");
	data->_tmp7_ = NULL;
	data->_tmp7_ = g_strdup_printf ("%u", data->q.max_results);
	data->_tmp8_ = NULL;
	data->_tmp8_ = string_replace (data->regex, " ", "*");
	data->_tmp9_ = data->_tmp8_;
	data->_tmp10_ = NULL;
	data->_tmp10_ = g_strdup_printf ("*%s*", data->_tmp9_);
	data->_tmp11_ = NULL;
	data->_tmp11_ = g_new0 (gchar*, 5 + 1);
	data->_tmp11_[0] = data->_tmp4_;
	data->_tmp11_[1] = data->_tmp5_;
	data->_tmp11_[2] = data->_tmp6_;
	data->_tmp11_[3] = data->_tmp7_;
	data->_tmp11_[4] = data->_tmp10_;
	data->_tmp12_ = data->_tmp11_;
	_g_free0 (data->_tmp9_);
	data->argv = data->_tmp12_;
	data->argv_length1 = 5;
	data->_argv_size_ = 5;
	data->_tmp13_ = NULL;
	data->_tmp13_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	data->uris = (GeeSet*) data->_tmp13_;
	g_spawn_async_with_pipes (NULL, data->argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &data->_tmp14_, NULL, &data->_tmp15_, NULL, &data->_inner_error_);
	data->pid = data->_tmp14_;
	data->read_fd = data->_tmp15_;
	if (data->_inner_error_ != NULL) {
		goto __catch27_g_error;
	}
	data->_tmp16_ = NULL;
	data->_tmp16_ = (GUnixInputStream*) g_unix_input_stream_new (data->read_fd, TRUE);
	data->read_stream = data->_tmp16_;
	data->_tmp17_ = NULL;
	data->_tmp17_ = g_data_input_stream_new ((GInputStream*) data->read_stream);
	data->locate_output = data->_tmp17_;
	data->line = NULL;
	data->_tmp18_ = NULL;
	data->_tmp18_ = g_regex_new ("/\\.", 0, 0, &data->_inner_error_);
	data->filter_re = data->_tmp18_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->line);
		_g_object_unref0 (data->locate_output);
		_g_object_unref0 (data->read_stream);
		goto __catch27_g_error;
	}
	{
		data->_tmp19_ = TRUE;
		while (TRUE) {
			if (!data->_tmp19_) {
				if (!(data->line != NULL)) {
					break;
				}
			}
			data->_tmp19_ = FALSE;
			data->_state_ = 1;
			g_data_input_stream_read_line_async (data->locate_output, G_PRIORITY_DEFAULT_IDLE, data->q.cancellable, synapse_locate_plugin_locate_ready, data);
			return FALSE;
			_state_1:
			data->_tmp20_ = NULL;
			data->_tmp20_ = g_data_input_stream_read_line_finish (data->locate_output, data->_res_, NULL, &data->_inner_error_);
			data->_tmp21_ = data->_tmp20_;
			if (data->_inner_error_ != NULL) {
				_g_regex_unref0 (data->filter_re);
				_g_free0 (data->line);
				_g_object_unref0 (data->locate_output);
				_g_object_unref0 (data->read_stream);
				goto __catch27_g_error;
			}
			_g_free0 (data->line);
			data->line = data->_tmp21_;
			if (data->line != NULL) {
				data->_tmp22_ = g_regex_match (data->filter_re, data->line, 0, NULL);
				if (data->_tmp22_) {
					continue;
				}
				data->_tmp23_ = NULL;
				data->_tmp23_ = g_file_new_for_path (data->line);
				data->file = data->_tmp23_;
				data->_tmp24_ = NULL;
				data->_tmp24_ = g_file_get_uri (data->file);
				data->_tmp25_ = data->_tmp24_;
				gee_collection_add ((GeeCollection*) data->uris, data->_tmp25_);
				_g_free0 (data->_tmp25_);
				_g_object_unref0 (data->file);
			}
		}
	}
	_g_regex_unref0 (data->filter_re);
	_g_free0 (data->line);
	_g_object_unref0 (data->locate_output);
	_g_object_unref0 (data->read_stream);
	goto __finally27;
	__catch27_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp26_ = synapse_query_is_cancelled (&data->q);
		if (!data->_tmp26_) {
			g_warning ("locate-plugin.vala:179: %s", data->err->message);
		}
		_g_error_free0 (data->err);
	}
	__finally27:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->uris);
			data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->regex);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->uris);
			data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->regex);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->uris);
			data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->regex);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->uris);
			data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->regex);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp27_ = NULL;
	data->_tmp27_ = synapse_result_set_new ();
	data->_result_ = data->_tmp27_;
	{
		data->_tmp28_ = NULL;
		data->_tmp28_ = gee_iterable_iterator ((GeeIterable*) data->uris);
		data->_s_it = data->_tmp28_;
		while (TRUE) {
			data->_tmp29_ = gee_iterator_next (data->_s_it);
			if (!data->_tmp29_) {
				break;
			}
			data->_tmp30_ = NULL;
			data->_tmp30_ = gee_iterator_get (data->_s_it);
			data->s = (gchar*) data->_tmp30_;
			data->_tmp31_ = NULL;
			data->_tmp31_ = synapse_utils_file_info_new (data->s, SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT);
			data->fi = data->_tmp31_;
			data->_state_ = 2;
			synapse_utils_file_info_initialize (data->fi, synapse_locate_plugin_locate_ready, data);
			return FALSE;
			_state_2:
			synapse_utils_file_info_initialize_finish (data->fi, data->_res_);
			if (data->fi->match_obj != NULL) {
				data->_tmp32_ = (data->q.query_type & data->fi->file_type) == data->fi->file_type;
			} else {
				data->_tmp32_ = FALSE;
			}
			if (data->_tmp32_) {
				data->relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
				data->_tmp33_ = g_str_has_prefix (data->fi->uri, "file:///home/");
				if (data->_tmp33_) {
					data->relevancy = data->relevancy + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR);
				}
				synapse_result_set_add (data->_result_, (SynapseMatch*) data->fi->match_obj, data->relevancy);
			}
			synapse_query_check_cancellable (&data->q, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_synapse_utils_file_info_unref0 (data->fi);
					_g_free0 (data->s);
					_g_object_unref0 (data->_s_it);
					_g_object_unref0 (data->_result_);
					_g_object_unref0 (data->uris);
					data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (data->regex);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				} else {
					_synapse_utils_file_info_unref0 (data->fi);
					_g_free0 (data->s);
					_g_object_unref0 (data->_s_it);
					_g_object_unref0 (data->_result_);
					_g_object_unref0 (data->uris);
					data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (data->regex);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			_synapse_utils_file_info_unref0 (data->fi);
			_g_free0 (data->s);
		}
		_g_object_unref0 (data->_s_it);
	}
	data->result = data->_result_;
	_g_object_unref0 (data->uris);
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data->regex);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->_result_);
	_g_object_unref0 (data->uris);
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data->regex);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static SynapseResultSet* synapse_locate_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* q, SynapseMatch* match) {
	SynapseLocatePlugin * self;
	SynapseResultSet* result = NULL;
	SynapseQueryFlags our_results;
	SynapseQueryFlags common_flags;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp2_ = NULL;
	gboolean query_empty;
	SynapseResultSet* _tmp3_ = NULL;
	SynapseResultSet* results;
	self = (SynapseLocatePlugin*) base;
	g_return_val_if_fail (match != NULL, NULL);
	our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
	common_flags = (*q).query_type & our_results;
	if (common_flags == 0) {
		_tmp0_ = TRUE;
	} else {
		SynapseMatchType _tmp1_;
		_tmp1_ = synapse_match_get_match_type (match);
		_tmp0_ = _tmp1_ != SYNAPSE_MATCH_TYPE_UNKNOWN;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = string_strip ((*q).query_string);
	_g_free0 ((*q).query_string);
	(*q).query_string = _tmp2_;
	query_empty = g_strcmp0 ((*q).query_string, "") == 0;
	_tmp3_ = synapse_result_set_new ();
	results = _tmp3_;
	if (query_empty) {
		gint _tmp4_;
		_tmp4_ = synapse_locate_plugin_locate_item_get_default_relevancy (self->priv->action);
		synapse_result_set_add (results, (SynapseMatch*) self->priv->action, _tmp4_);
	} else {
		GeeList* _tmp5_ = NULL;
		GeeList* matchers;
		_tmp5_ = synapse_query_get_matchers_for_query ((*q).query_string, 0, G_REGEX_CASELESS);
		matchers = _tmp5_;
		{
			GeeList* _tmp6_;
			GeeList* _matcher_list;
			gint _tmp7_;
			gint _matcher_size;
			gint _matcher_index;
			_tmp6_ = _g_object_ref0 (matchers);
			_matcher_list = _tmp6_;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _matcher_list);
			_matcher_size = _tmp7_;
			_matcher_index = -1;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				GeeMapEntry* matcher;
				gconstpointer _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp11_;
				_matcher_index = _matcher_index + 1;
				if (!(_matcher_index < _matcher_size)) {
					break;
				}
				_tmp8_ = gee_list_get (_matcher_list, _matcher_index);
				matcher = (GeeMapEntry*) _tmp8_;
				_tmp9_ = gee_map_entry_get_key (matcher);
				_tmp10_ = synapse_match_get_title ((SynapseMatch*) self->priv->action);
				_tmp11_ = g_regex_match ((GRegex*) _tmp9_, _tmp10_, 0, NULL);
				if (_tmp11_) {
					gconstpointer _tmp12_ = NULL;
					_tmp12_ = gee_map_entry_get_value (matcher);
					synapse_result_set_add (results, (SynapseMatch*) self->priv->action, GPOINTER_TO_INT (_tmp12_));
					_g_object_unref0 (matcher);
					break;
				}
				_g_object_unref0 (matcher);
			}
			_g_object_unref0 (_matcher_list);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


SynapseLocatePlugin* synapse_locate_plugin_construct (GType object_type) {
	SynapseLocatePlugin * self = NULL;
	self = (SynapseLocatePlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseLocatePlugin* synapse_locate_plugin_new (void) {
	return synapse_locate_plugin_construct (SYNAPSE_TYPE_LOCATE_PLUGIN);
}


static gboolean synapse_locate_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseLocatePlugin* self;
	self = (SynapseLocatePlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_locate_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseLocatePlugin* self;
	self = (SynapseLocatePlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_locate_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseLocatePlugin * self;
	SynapseLocatePluginLocateItem* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_locate_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_LOCATE_PLUGIN (obj);
	_tmp0_ = synapse_locate_plugin_locate_item_new (self);
	_g_object_unref0 (self->priv->action);
	self->priv->action = _tmp0_;
	return obj;
}


static SynapseLocatePluginMatchObject* synapse_locate_plugin_match_object_construct (GType object_type, const gchar* thumbnail_path, const gchar* icon) {
	SynapseLocatePluginMatchObject * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = g_strdup (icon);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp2_;
	}
	_tmp3_ = g_strdup (thumbnail_path);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp5_;
	}
	self = (SynapseLocatePluginMatchObject*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp1_, "thumbnail-path", _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	return self;
}


static SynapseLocatePluginMatchObject* synapse_locate_plugin_match_object_new (const gchar* thumbnail_path, const gchar* icon) {
	return synapse_locate_plugin_match_object_construct (SYNAPSE_LOCATE_PLUGIN_TYPE_MATCH_OBJECT, thumbnail_path, icon);
}


static const gchar* synapse_locate_plugin_match_object_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseLocatePluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_locate_plugin_match_object_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseLocatePluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp0_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_locate_plugin_match_object_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseLocatePluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp0_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_locate_plugin_match_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_locate_plugin_match_object_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseLocatePluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp0_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_locate_plugin_match_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static const gchar* synapse_locate_plugin_match_object_real_get_uri (SynapseUriMatch* base) {
	const gchar* result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_uri;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_uri (SynapseUriMatch* base, const gchar* value) {
	SynapseLocatePluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp0_;
	g_object_notify ((GObject *) self, "uri");
}


static SynapseQueryFlags synapse_locate_plugin_match_object_real_get_file_type (SynapseUriMatch* base) {
	SynapseQueryFlags result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_file_type;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_file_type (SynapseUriMatch* base, SynapseQueryFlags value) {
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	self->priv->_file_type = value;
	g_object_notify ((GObject *) self, "file-type");
}


static const gchar* synapse_locate_plugin_match_object_real_get_mime_type (SynapseUriMatch* base) {
	const gchar* result;
	SynapseLocatePluginMatchObject* self;
	self = (SynapseLocatePluginMatchObject*) base;
	result = self->priv->_mime_type;
	return result;
}


static void synapse_locate_plugin_match_object_real_set_mime_type (SynapseUriMatch* base, const gchar* value) {
	SynapseLocatePluginMatchObject* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginMatchObject*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp0_;
	g_object_notify ((GObject *) self, "mime-type");
}


static void synapse_locate_plugin_match_object_class_init (SynapseLocatePluginMatchObjectClass * klass) {
	synapse_locate_plugin_match_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseLocatePluginMatchObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_locate_plugin_match_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_locate_plugin_match_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_locate_plugin_match_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_MIME_TYPE, "mime-type");
}


static void synapse_locate_plugin_match_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_locate_plugin_match_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_locate_plugin_match_object_real_get_title;
	iface->set_title = synapse_locate_plugin_match_object_real_set_title;
	iface->get_description = synapse_locate_plugin_match_object_real_get_description;
	iface->set_description = synapse_locate_plugin_match_object_real_set_description;
	iface->get_icon_name = synapse_locate_plugin_match_object_real_get_icon_name;
	iface->set_icon_name = synapse_locate_plugin_match_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_locate_plugin_match_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_locate_plugin_match_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_locate_plugin_match_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_locate_plugin_match_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_locate_plugin_match_object_real_get_match_type;
	iface->set_match_type = synapse_locate_plugin_match_object_real_set_match_type;
}


static void synapse_locate_plugin_match_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface) {
	synapse_locate_plugin_match_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_locate_plugin_match_object_real_get_uri;
	iface->set_uri = synapse_locate_plugin_match_object_real_set_uri;
	iface->get_file_type = synapse_locate_plugin_match_object_real_get_file_type;
	iface->set_file_type = synapse_locate_plugin_match_object_real_set_file_type;
	iface->get_mime_type = synapse_locate_plugin_match_object_real_get_mime_type;
	iface->set_mime_type = synapse_locate_plugin_match_object_real_set_mime_type;
}


static void synapse_locate_plugin_match_object_instance_init (SynapseLocatePluginMatchObject * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
}


static void synapse_locate_plugin_match_object_finalize (GObject* obj) {
	SynapseLocatePluginMatchObject * self;
	self = SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	G_OBJECT_CLASS (synapse_locate_plugin_match_object_parent_class)->finalize (obj);
}


static GType synapse_locate_plugin_match_object_get_type (void) {
	static volatile gsize synapse_locate_plugin_match_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_locate_plugin_match_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLocatePluginMatchObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_locate_plugin_match_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLocatePluginMatchObject), 0, (GInstanceInitFunc) synapse_locate_plugin_match_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_locate_plugin_match_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_locate_plugin_match_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_locate_plugin_match_object_type_id;
		synapse_locate_plugin_match_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLocatePluginMatchObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_locate_plugin_match_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_locate_plugin_match_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		g_once_init_leave (&synapse_locate_plugin_match_object_type_id__volatile, synapse_locate_plugin_match_object_type_id);
	}
	return synapse_locate_plugin_match_object_type_id__volatile;
}


static void _vala_synapse_locate_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseLocatePluginMatchObject * self;
	self = SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_URI:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_locate_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseLocatePluginMatchObject * self;
	self = SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_URI:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_locate_plugin_locate_item_real_search_data_free (gpointer _data) {
	SynapseLocatePluginLocateItemSearchData* data;
	data = _data;
	_g_free0 (data->query);
	_g_object_unref0 (data->dest_result_set);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseLocatePluginLocateItemSearchData, data);
}


static void synapse_locate_plugin_locate_item_real_search (SynapseSearchProvider* base, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseLocatePluginLocateItem * self;
	SynapseLocatePluginLocateItemSearchData* _data_;
	self = (SynapseLocatePluginLocateItem*) base;
	_data_ = g_slice_new0 (SynapseLocatePluginLocateItemSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_locate_plugin_locate_item_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_locate_plugin_locate_item_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->query = g_strdup (query);
	_data_->flags = flags;
	_data_->dest_result_set = _g_object_ref0 (dest_result_set);
	_data_->cancellable = _g_object_ref0 (cancellable);
	synapse_locate_plugin_locate_item_real_search_co (_data_);
}


static GeeList* synapse_locate_plugin_locate_item_real_search_finish (SynapseSearchProvider* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	SynapseLocatePluginLocateItemSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_locate_plugin_locate_item_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseLocatePluginLocateItemSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_locate_plugin_locate_item_real_search_co (data);
}


static gboolean synapse_locate_plugin_locate_item_real_search_co (SynapseLocatePluginLocateItemSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	synapse_query_init (&data->q, (guint) 0, data->query, data->flags, (guint) 96);
	data->_tmp0_ = _g_object_ref0 (data->cancellable);
	_g_object_unref0 (data->q.cancellable);
	data->q.cancellable = data->_tmp0_;
	data->_state_ = 1;
	synapse_locate_plugin_locate (data->self->priv->plugin, &data->q, synapse_locate_plugin_locate_item_search_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = synapse_locate_plugin_locate_finish (data->self->priv->plugin, data->_res_, &data->_inner_error_);
	data->results = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			synapse_query_destroy (&data->q);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			synapse_query_destroy (&data->q);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	synapse_result_set_add_all (data->dest_result_set, data->results);
	data->_tmp2_ = NULL;
	data->_tmp2_ = synapse_result_set_get_sorted_list (data->dest_result_set);
	data->result = data->_tmp2_;
	_g_object_unref0 (data->results);
	synapse_query_destroy (&data->q);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->results);
	synapse_query_destroy (&data->q);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static SynapseLocatePluginLocateItem* synapse_locate_plugin_locate_item_construct (GType object_type, SynapseLocatePlugin* plugin) {
	SynapseLocatePluginLocateItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (plugin != NULL, NULL);
	_tmp0_ = _ ("Locate");
	_tmp1_ = _ ("Locate files with this name on the filesystem");
	self = (SynapseLocatePluginLocateItem*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_SEARCH, "has-thumbnail", FALSE, "icon-name", "search", "title", _tmp0_, "description", _tmp1_, NULL);
	self->priv->plugin = plugin;
	return self;
}


static SynapseLocatePluginLocateItem* synapse_locate_plugin_locate_item_new (SynapseLocatePlugin* plugin) {
	return synapse_locate_plugin_locate_item_construct (SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, plugin);
}


static const gchar* synapse_locate_plugin_locate_item_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseLocatePluginLocateItem* self;
	self = (SynapseLocatePluginLocateItem*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_locate_plugin_locate_item_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseLocatePluginLocateItem* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginLocateItem*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_locate_plugin_locate_item_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseLocatePluginLocateItem* self;
	self = (SynapseLocatePluginLocateItem*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_locate_plugin_locate_item_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseLocatePluginLocateItem* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginLocateItem*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp0_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_locate_plugin_locate_item_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseLocatePluginLocateItem* self;
	self = (SynapseLocatePluginLocateItem*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_locate_plugin_locate_item_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseLocatePluginLocateItem* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginLocateItem*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp0_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_locate_plugin_locate_item_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseLocatePluginLocateItem* self;
	self = (SynapseLocatePluginLocateItem*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_locate_plugin_locate_item_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseLocatePluginLocateItem* self;
	self = (SynapseLocatePluginLocateItem*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_locate_plugin_locate_item_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseLocatePluginLocateItem* self;
	self = (SynapseLocatePluginLocateItem*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_locate_plugin_locate_item_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseLocatePluginLocateItem* self;
	gchar* _tmp0_;
	self = (SynapseLocatePluginLocateItem*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp0_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_locate_plugin_locate_item_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseLocatePluginLocateItem* self;
	self = (SynapseLocatePluginLocateItem*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_locate_plugin_locate_item_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseLocatePluginLocateItem* self;
	self = (SynapseLocatePluginLocateItem*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static gint synapse_locate_plugin_locate_item_get_default_relevancy (SynapseLocatePluginLocateItem* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}


static void synapse_locate_plugin_locate_item_set_default_relevancy (SynapseLocatePluginLocateItem* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_default_relevancy = value;
	g_object_notify ((GObject *) self, "default-relevancy");
}


static void synapse_locate_plugin_locate_item_class_init (SynapseLocatePluginLocateItemClass * klass) {
	synapse_locate_plugin_locate_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseLocatePluginLocateItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_locate_plugin_locate_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_locate_plugin_locate_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_locate_plugin_locate_item_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_MATCH_TYPE, "match-type");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY, g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_locate_plugin_locate_item_synapse_search_provider_interface_init (SynapseSearchProviderIface * iface) {
	synapse_locate_plugin_locate_item_synapse_search_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (GeeList* (*)(SynapseSearchProvider* ,const gchar* ,SynapseQueryFlags ,SynapseResultSet* ,GCancellable* ,GError**)) synapse_locate_plugin_locate_item_real_search;
	iface->search_finish = synapse_locate_plugin_locate_item_real_search_finish;
}


static void synapse_locate_plugin_locate_item_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_locate_plugin_locate_item_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_locate_plugin_locate_item_real_get_title;
	iface->set_title = synapse_locate_plugin_locate_item_real_set_title;
	iface->get_description = synapse_locate_plugin_locate_item_real_get_description;
	iface->set_description = synapse_locate_plugin_locate_item_real_set_description;
	iface->get_icon_name = synapse_locate_plugin_locate_item_real_get_icon_name;
	iface->set_icon_name = synapse_locate_plugin_locate_item_real_set_icon_name;
	iface->get_has_thumbnail = synapse_locate_plugin_locate_item_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_locate_plugin_locate_item_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_locate_plugin_locate_item_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_locate_plugin_locate_item_real_set_thumbnail_path;
	iface->get_match_type = synapse_locate_plugin_locate_item_real_get_match_type;
	iface->set_match_type = synapse_locate_plugin_locate_item_real_set_match_type;
}


static void synapse_locate_plugin_locate_item_synapse_search_match_interface_init (SynapseSearchMatchIface * iface) {
	synapse_locate_plugin_locate_item_synapse_search_match_parent_iface = g_type_interface_peek_parent (iface);
}


static void synapse_locate_plugin_locate_item_instance_init (SynapseLocatePluginLocateItem * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
	self->priv->_default_relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
}


static void synapse_locate_plugin_locate_item_finalize (GObject* obj) {
	SynapseLocatePluginLocateItem * self;
	self = SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_locate_plugin_locate_item_parent_class)->finalize (obj);
}


static GType synapse_locate_plugin_locate_item_get_type (void) {
	static volatile gsize synapse_locate_plugin_locate_item_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_locate_plugin_locate_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLocatePluginLocateItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_locate_plugin_locate_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLocatePluginLocateItem), 0, (GInstanceInitFunc) synapse_locate_plugin_locate_item_instance_init, NULL };
		static const GInterfaceInfo synapse_search_provider_info = { (GInterfaceInitFunc) synapse_locate_plugin_locate_item_synapse_search_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_locate_plugin_locate_item_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_search_match_info = { (GInterfaceInitFunc) synapse_locate_plugin_locate_item_synapse_search_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_locate_plugin_locate_item_type_id;
		synapse_locate_plugin_locate_item_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLocatePluginLocateItem", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_locate_plugin_locate_item_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER, &synapse_search_provider_info);
		g_type_add_interface_static (synapse_locate_plugin_locate_item_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_locate_plugin_locate_item_type_id, SYNAPSE_TYPE_SEARCH_MATCH, &synapse_search_match_info);
		g_once_init_leave (&synapse_locate_plugin_locate_item_type_id__volatile, synapse_locate_plugin_locate_item_type_id);
	}
	return synapse_locate_plugin_locate_item_type_id__volatile;
}


static void _vala_synapse_locate_plugin_locate_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseLocatePluginLocateItem * self;
	self = SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM (object);
	switch (property_id) {
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY:
		g_value_set_int (value, synapse_locate_plugin_locate_item_get_default_relevancy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_locate_plugin_locate_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseLocatePluginLocateItem * self;
	self = SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM (object);
	switch (property_id) {
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY:
		synapse_locate_plugin_locate_item_set_default_relevancy (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_locate_plugin_class_init (SynapseLocatePluginClass * klass) {
	synapse_locate_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseLocatePluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_locate_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_locate_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_locate_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_locate_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_ENABLED, "enabled");
	synapse_locate_plugin_register_plugin ();
}


static void synapse_locate_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_locate_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(SynapseActivatable*)) synapse_locate_plugin_real_activate;
	iface->deactivate = (void (*)(SynapseActivatable*)) synapse_locate_plugin_real_deactivate;
	iface->get_enabled = synapse_locate_plugin_real_get_enabled;
	iface->set_enabled = synapse_locate_plugin_real_set_enabled;
}


static void synapse_locate_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface) {
	synapse_locate_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_unknown = (gboolean (*)(SynapseActionProvider*)) synapse_locate_plugin_real_handles_unknown;
	iface->find_for_match = (SynapseResultSet* (*)(SynapseActionProvider* ,SynapseQuery* ,SynapseMatch*)) synapse_locate_plugin_real_find_for_match;
}


static void synapse_locate_plugin_instance_init (SynapseLocatePlugin * self) {
	self->priv = SYNAPSE_LOCATE_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_locate_plugin_finalize (GObject* obj) {
	SynapseLocatePlugin * self;
	self = SYNAPSE_LOCATE_PLUGIN (obj);
	_g_object_unref0 (self->priv->action);
	G_OBJECT_CLASS (synapse_locate_plugin_parent_class)->finalize (obj);
}


GType synapse_locate_plugin_get_type (void) {
	static volatile gsize synapse_locate_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_locate_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLocatePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_locate_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLocatePlugin), 0, (GInstanceInitFunc) synapse_locate_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_locate_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_locate_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_locate_plugin_type_id;
		synapse_locate_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLocatePlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_locate_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_locate_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		g_once_init_leave (&synapse_locate_plugin_type_id__volatile, synapse_locate_plugin_type_id);
	}
	return synapse_locate_plugin_type_id__volatile;
}


static void _vala_synapse_locate_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseLocatePlugin * self;
	self = SYNAPSE_LOCATE_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_LOCATE_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_locate_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseLocatePlugin * self;
	self = SYNAPSE_LOCATE_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_LOCATE_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



