/* match.c generated by valac 0.11.7.1-263a8, the Vala compiler
 * generated from match.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;

#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_EXTENDED_INFO (synapse_extended_info_get_type ())
#define SYNAPSE_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfo))
#define SYNAPSE_IS_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_EXTENDED_INFO))
#define SYNAPSE_EXTENDED_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfoIface))

typedef struct _SynapseExtendedInfo SynapseExtendedInfo;
typedef struct _SynapseExtendedInfoIface SynapseExtendedInfoIface;

#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchIface))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchIface SynapseTextMatchIface;

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_SEARCH_MATCH (synapse_search_match_get_type ())
#define SYNAPSE_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch))
#define SYNAPSE_IS_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_SEARCH_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchIface))

typedef struct _SynapseSearchMatch SynapseSearchMatch;
typedef struct _SynapseSearchMatchIface SynapseSearchMatchIface;

#define SYNAPSE_TYPE_DEFAULT_MATCH (synapse_default_match_get_type ())
#define SYNAPSE_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch))
#define SYNAPSE_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))
#define SYNAPSE_IS_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_IS_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_DEFAULT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))

typedef struct _SynapseDefaultMatch SynapseDefaultMatch;
typedef struct _SynapseDefaultMatchClass SynapseDefaultMatchClass;
typedef struct _SynapseDefaultMatchPrivate SynapseDefaultMatchPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH
} SynapseMatchType;

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 1,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 3,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 5,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 6,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 7,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 15,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFF | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseExtendedInfoIface {
	GTypeInterface parent_iface;
	const gchar* (*get_extended_info) (SynapseExtendedInfo* self);
	void (*set_extended_info) (SynapseExtendedInfo* self, const gchar* value);
};

typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;

struct _SynapseTextMatchIface {
	GTypeInterface parent_iface;
	gchar* (*get_text) (SynapseTextMatch* self);
	SynapseTextOrigin (*get_text_origin) (SynapseTextMatch* self);
	void (*set_text_origin) (SynapseTextMatch* self, SynapseTextOrigin value);
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseSearchMatchIface {
	GTypeInterface parent_iface;
};

struct _SynapseDefaultMatch {
	GObject parent_instance;
	SynapseDefaultMatchPrivate * priv;
};

struct _SynapseDefaultMatchClass {
	GObjectClass parent_class;
};

struct _SynapseDefaultMatchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
};


static gpointer synapse_default_match_parent_class = NULL;
static SynapseMatchIface* synapse_default_match_synapse_match_parent_iface = NULL;

GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_match_score_get_type (void) G_GNUC_CONST;
void synapse_match_execute (SynapseMatch* self, SynapseMatch* match);
static void synapse_match_real_execute (SynapseMatch* self, SynapseMatch* match);
void synapse_utils_logger_error (GObject* obj, const gchar* format, ...);
const gchar* synapse_match_get_title (SynapseMatch* self);
void synapse_match_set_title (SynapseMatch* self, const gchar* value);
const gchar* synapse_match_get_description (SynapseMatch* self);
void synapse_match_set_description (SynapseMatch* self, const gchar* value);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
void synapse_match_set_icon_name (SynapseMatch* self, const gchar* value);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
void synapse_match_set_has_thumbnail (SynapseMatch* self, gboolean value);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
void synapse_match_set_thumbnail_path (SynapseMatch* self, const gchar* value);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
void synapse_match_set_match_type (SynapseMatch* self, SynapseMatchType value);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
void synapse_application_match_set_app_info (SynapseApplicationMatch* self, GAppInfo* value);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self, gboolean value);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
void synapse_application_match_set_filename (SynapseApplicationMatch* self, const gchar* value);
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
void synapse_uri_match_set_uri (SynapseUriMatch* self, const gchar* value);
SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self);
void synapse_uri_match_set_file_type (SynapseUriMatch* self, SynapseQueryFlags value);
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self, const gchar* value);
GType synapse_extended_info_get_type (void) G_GNUC_CONST;
const gchar* synapse_extended_info_get_extended_info (SynapseExtendedInfo* self);
void synapse_extended_info_set_extended_info (SynapseExtendedInfo* self, const gchar* value);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
GType synapse_text_match_get_type (void) G_GNUC_CONST;
gchar* synapse_text_match_get_text (SynapseTextMatch* self);
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
void synapse_text_match_set_text_origin (SynapseTextMatch* self, SynapseTextOrigin value);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
GType synapse_search_match_get_type (void) G_GNUC_CONST;
GType synapse_default_match_get_type (void) G_GNUC_CONST;
#define SYNAPSE_DEFAULT_MATCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchPrivate))
enum  {
	SYNAPSE_DEFAULT_MATCH_DUMMY_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_TITLE,
	SYNAPSE_DEFAULT_MATCH_DESCRIPTION,
	SYNAPSE_DEFAULT_MATCH_ICON_NAME,
	SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL,
	SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH,
	SYNAPSE_DEFAULT_MATCH_MATCH_TYPE
};
SynapseDefaultMatch* synapse_default_match_new (const gchar* query_string);
SynapseDefaultMatch* synapse_default_match_construct (GType object_type, const gchar* query_string);
static void synapse_default_match_finalize (GObject* obj);
static void _vala_synapse_default_match_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_default_match_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType synapse_match_type_get_type (void) {
	static volatile gsize synapse_match_type_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SYNAPSE_MATCH_TYPE_UNKNOWN, "SYNAPSE_MATCH_TYPE_UNKNOWN", "unknown"}, {SYNAPSE_MATCH_TYPE_TEXT, "SYNAPSE_MATCH_TYPE_TEXT", "text"}, {SYNAPSE_MATCH_TYPE_APPLICATION, "SYNAPSE_MATCH_TYPE_APPLICATION", "application"}, {SYNAPSE_MATCH_TYPE_GENERIC_URI, "SYNAPSE_MATCH_TYPE_GENERIC_URI", "generic-uri"}, {SYNAPSE_MATCH_TYPE_ACTION, "SYNAPSE_MATCH_TYPE_ACTION", "action"}, {SYNAPSE_MATCH_TYPE_SEARCH, "SYNAPSE_MATCH_TYPE_SEARCH", "search"}, {0, NULL, NULL}};
		GType synapse_match_type_type_id;
		synapse_match_type_type_id = g_enum_register_static ("SynapseMatchType", values);
		g_once_init_leave (&synapse_match_type_type_id__volatile, synapse_match_type_type_id);
	}
	return synapse_match_type_type_id__volatile;
}


GType synapse_match_score_get_type (void) {
	static volatile gsize synapse_match_score_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_score_type_id__volatile)) {
		static const GEnumValue values[] = {{SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, "SYNAPSE_MATCH_SCORE_INCREMENT_MINOR", "increment-minor"}, {SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, "SYNAPSE_MATCH_SCORE_INCREMENT_SMALL", "increment-small"}, {SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM, "SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM", "increment-medium"}, {SYNAPSE_MATCH_SCORE_INCREMENT_LARGE, "SYNAPSE_MATCH_SCORE_INCREMENT_LARGE", "increment-large"}, {SYNAPSE_MATCH_SCORE_URI_PENALTY, "SYNAPSE_MATCH_SCORE_URI_PENALTY", "uri-penalty"}, {SYNAPSE_MATCH_SCORE_POOR, "SYNAPSE_MATCH_SCORE_POOR", "poor"}, {SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, "SYNAPSE_MATCH_SCORE_BELOW_AVERAGE", "below-average"}, {SYNAPSE_MATCH_SCORE_AVERAGE, "SYNAPSE_MATCH_SCORE_AVERAGE", "average"}, {SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE, "SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE", "above-average"}, {SYNAPSE_MATCH_SCORE_GOOD, "SYNAPSE_MATCH_SCORE_GOOD", "good"}, {SYNAPSE_MATCH_SCORE_VERY_GOOD, "SYNAPSE_MATCH_SCORE_VERY_GOOD", "very-good"}, {SYNAPSE_MATCH_SCORE_EXCELLENT, "SYNAPSE_MATCH_SCORE_EXCELLENT", "excellent"}, {SYNAPSE_MATCH_SCORE_HIGHEST, "SYNAPSE_MATCH_SCORE_HIGHEST", "highest"}, {0, NULL, NULL}};
		GType synapse_match_score_type_id;
		synapse_match_score_type_id = g_enum_register_static ("SynapseMatchScore", values);
		g_once_init_leave (&synapse_match_score_type_id__volatile, synapse_match_score_type_id);
	}
	return synapse_match_score_type_id__volatile;
}


static void synapse_match_real_execute (SynapseMatch* self, SynapseMatch* match) {
	synapse_utils_logger_error ((GObject*) self, "execute () is not implemented", NULL);
}


void synapse_match_execute (SynapseMatch* self, SynapseMatch* match) {
	SYNAPSE_MATCH_GET_INTERFACE (self)->execute (self, match);
}


const gchar* synapse_match_get_title (SynapseMatch* self) {
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_title (self);
}


void synapse_match_set_title (SynapseMatch* self, const gchar* value) {
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_title (self, value);
}


const gchar* synapse_match_get_description (SynapseMatch* self) {
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_description (self);
}


void synapse_match_set_description (SynapseMatch* self, const gchar* value) {
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_description (self, value);
}


const gchar* synapse_match_get_icon_name (SynapseMatch* self) {
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_icon_name (self);
}


void synapse_match_set_icon_name (SynapseMatch* self, const gchar* value) {
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_icon_name (self, value);
}


gboolean synapse_match_get_has_thumbnail (SynapseMatch* self) {
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_has_thumbnail (self);
}


void synapse_match_set_has_thumbnail (SynapseMatch* self, gboolean value) {
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_has_thumbnail (self, value);
}


const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self) {
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_thumbnail_path (self);
}


void synapse_match_set_thumbnail_path (SynapseMatch* self, const gchar* value) {
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_thumbnail_path (self, value);
}


SynapseMatchType synapse_match_get_match_type (SynapseMatch* self) {
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_match_type (self);
}


void synapse_match_set_match_type (SynapseMatch* self, SynapseMatchType value) {
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_match_type (self, value);
}


static void synapse_match_base_init (SynapseMatchIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
		g_object_interface_install_property (iface, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
		g_object_interface_install_property (iface, g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
		g_object_interface_install_property (iface, g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
		g_object_interface_install_property (iface, g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
		g_signal_new ("executed", SYNAPSE_TYPE_MATCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		iface->execute = synapse_match_real_execute;
	}
}


GType synapse_match_get_type (void) {
	static volatile gsize synapse_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseMatchIface), (GBaseInitFunc) synapse_match_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_match_type_id;
		synapse_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_match_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&synapse_match_type_id__volatile, synapse_match_type_id);
	}
	return synapse_match_type_id__volatile;
}


GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self) {
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_app_info (self);
}


void synapse_application_match_set_app_info (SynapseApplicationMatch* self, GAppInfo* value) {
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_app_info (self, value);
}


gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self) {
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_needs_terminal (self);
}


void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self, gboolean value) {
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_needs_terminal (self, value);
}


const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self) {
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_filename (self);
}


void synapse_application_match_set_filename (SynapseApplicationMatch* self, const gchar* value) {
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_filename (self, value);
}


static void synapse_application_match_base_init (SynapseApplicationMatchIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_APP_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	}
}


GType synapse_application_match_get_type (void) {
	static volatile gsize synapse_application_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_application_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseApplicationMatchIface), (GBaseInitFunc) synapse_application_match_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_application_match_type_id;
		synapse_application_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseApplicationMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_application_match_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_application_match_type_id__volatile, synapse_application_match_type_id);
	}
	return synapse_application_match_type_id__volatile;
}


const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self) {
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_uri (self);
}


void synapse_uri_match_set_uri (SynapseUriMatch* self, const gchar* value) {
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_uri (self, value);
}


SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self) {
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_file_type (self);
}


void synapse_uri_match_set_file_type (SynapseUriMatch* self, SynapseQueryFlags value) {
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_file_type (self, value);
}


const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self) {
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_mime_type (self);
}


void synapse_uri_match_set_mime_type (SynapseUriMatch* self, const gchar* value) {
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_mime_type (self, value);
}


static void synapse_uri_match_base_init (SynapseUriMatchIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_flags ("file-type", "file-type", "file-type", SYNAPSE_TYPE_QUERY_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType synapse_uri_match_get_type (void) {
	static volatile gsize synapse_uri_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_uri_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUriMatchIface), (GBaseInitFunc) synapse_uri_match_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_uri_match_type_id;
		synapse_uri_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseUriMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_uri_match_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_uri_match_type_id__volatile, synapse_uri_match_type_id);
	}
	return synapse_uri_match_type_id__volatile;
}


const gchar* synapse_extended_info_get_extended_info (SynapseExtendedInfo* self) {
	return SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self)->get_extended_info (self);
}


void synapse_extended_info_set_extended_info (SynapseExtendedInfo* self, const gchar* value) {
	SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self)->set_extended_info (self, value);
}


static void synapse_extended_info_base_init (SynapseExtendedInfoIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("extended-info", "extended-info", "extended-info", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType synapse_extended_info_get_type (void) {
	static volatile gsize synapse_extended_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_extended_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseExtendedInfoIface), (GBaseInitFunc) synapse_extended_info_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_extended_info_type_id;
		synapse_extended_info_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseExtendedInfo", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_extended_info_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_extended_info_type_id__volatile, synapse_extended_info_type_id);
	}
	return synapse_extended_info_type_id__volatile;
}


GType synapse_text_origin_get_type (void) {
	static volatile gsize synapse_text_origin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_text_origin_type_id__volatile)) {
		static const GEnumValue values[] = {{SYNAPSE_TEXT_ORIGIN_UNKNOWN, "SYNAPSE_TEXT_ORIGIN_UNKNOWN", "unknown"}, {SYNAPSE_TEXT_ORIGIN_CLIPBOARD, "SYNAPSE_TEXT_ORIGIN_CLIPBOARD", "clipboard"}, {0, NULL, NULL}};
		GType synapse_text_origin_type_id;
		synapse_text_origin_type_id = g_enum_register_static ("SynapseTextOrigin", values);
		g_once_init_leave (&synapse_text_origin_type_id__volatile, synapse_text_origin_type_id);
	}
	return synapse_text_origin_type_id__volatile;
}


gchar* synapse_text_match_get_text (SynapseTextMatch* self) {
	return SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->get_text (self);
}


SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self) {
	return SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->get_text_origin (self);
}


void synapse_text_match_set_text_origin (SynapseTextMatch* self, SynapseTextOrigin value) {
	SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->set_text_origin (self, value);
}


static void synapse_text_match_base_init (SynapseTextMatchIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_enum ("text-origin", "text-origin", "text-origin", SYNAPSE_TYPE_TEXT_ORIGIN, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType synapse_text_match_get_type (void) {
	static volatile gsize synapse_text_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_text_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseTextMatchIface), (GBaseInitFunc) synapse_text_match_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_text_match_type_id;
		synapse_text_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseTextMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_text_match_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_text_match_type_id__volatile, synapse_text_match_type_id);
	}
	return synapse_text_match_type_id__volatile;
}


static void synapse_search_match_base_init (SynapseSearchMatchIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType synapse_search_match_get_type (void) {
	static volatile gsize synapse_search_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_search_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseSearchMatchIface), (GBaseInitFunc) synapse_search_match_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_search_match_type_id;
		synapse_search_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseSearchMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_search_match_type_id, SYNAPSE_TYPE_MATCH);
		g_type_interface_add_prerequisite (synapse_search_match_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER);
		g_once_init_leave (&synapse_search_match_type_id__volatile, synapse_search_match_type_id);
	}
	return synapse_search_match_type_id__volatile;
}


SynapseDefaultMatch* synapse_default_match_construct (GType object_type, const gchar* query_string) {
	SynapseDefaultMatch * self = NULL;
	g_return_val_if_fail (query_string != NULL, NULL);
	self = (SynapseDefaultMatch*) g_object_new (object_type, "title", query_string, "description", "", "has-thumbnail", FALSE, "icon-name", "unknown", "match-type", SYNAPSE_MATCH_TYPE_UNKNOWN, NULL);
	return self;
}


SynapseDefaultMatch* synapse_default_match_new (const gchar* query_string) {
	return synapse_default_match_construct (SYNAPSE_TYPE_DEFAULT_MATCH, query_string);
}


static const gchar* synapse_default_match_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_default_match_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseDefaultMatch* self;
	gchar* _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_default_match_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_default_match_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseDefaultMatch* self;
	gchar* _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp0_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_default_match_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_default_match_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseDefaultMatch* self;
	gchar* _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp0_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_default_match_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_default_match_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_default_match_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_default_match_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseDefaultMatch* self;
	gchar* _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp0_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_default_match_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_default_match_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static void synapse_default_match_class_init (SynapseDefaultMatchClass * klass) {
	synapse_default_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDefaultMatchPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_default_match_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_default_match_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_default_match_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_MATCH_TYPE, "match-type");
}


static void synapse_default_match_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_default_match_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_default_match_real_get_title;
	iface->set_title = synapse_default_match_real_set_title;
	iface->get_description = synapse_default_match_real_get_description;
	iface->set_description = synapse_default_match_real_set_description;
	iface->get_icon_name = synapse_default_match_real_get_icon_name;
	iface->set_icon_name = synapse_default_match_real_set_icon_name;
	iface->get_has_thumbnail = synapse_default_match_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_default_match_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_default_match_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_default_match_real_set_thumbnail_path;
	iface->get_match_type = synapse_default_match_real_get_match_type;
	iface->set_match_type = synapse_default_match_real_set_match_type;
}


static void synapse_default_match_instance_init (SynapseDefaultMatch * self) {
	self->priv = SYNAPSE_DEFAULT_MATCH_GET_PRIVATE (self);
}


static void synapse_default_match_finalize (GObject* obj) {
	SynapseDefaultMatch * self;
	self = SYNAPSE_DEFAULT_MATCH (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_default_match_parent_class)->finalize (obj);
}


GType synapse_default_match_get_type (void) {
	static volatile gsize synapse_default_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_default_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDefaultMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_default_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDefaultMatch), 0, (GInstanceInitFunc) synapse_default_match_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_default_match_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_default_match_type_id;
		synapse_default_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDefaultMatch", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_default_match_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_once_init_leave (&synapse_default_match_type_id__volatile, synapse_default_match_type_id);
	}
	return synapse_default_match_type_id__volatile;
}


static void _vala_synapse_default_match_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDefaultMatch * self;
	self = SYNAPSE_DEFAULT_MATCH (object);
	switch (property_id) {
		case SYNAPSE_DEFAULT_MATCH_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_default_match_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDefaultMatch * self;
	self = SYNAPSE_DEFAULT_MATCH (object);
	switch (property_id) {
		case SYNAPSE_DEFAULT_MATCH_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



