/* zeitgeist-plugin.c generated by valac 0.10.4, the Vala compiler
 * generated from zeitgeist-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <zeitgeist.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define SYNAPSE_TYPE_ZEITGEIST_PLUGIN (synapse_zeitgeist_plugin_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin))
#define SYNAPSE_ZEITGEIST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPluginClass))
#define SYNAPSE_IS_ZEITGEIST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN))
#define SYNAPSE_IS_ZEITGEIST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEITGEIST_PLUGIN))
#define SYNAPSE_ZEITGEIST_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPluginClass))

typedef struct _SynapseZeitgeistPlugin SynapseZeitgeistPlugin;
typedef struct _SynapseZeitgeistPluginClass SynapseZeitgeistPluginClass;
typedef struct _SynapseZeitgeistPluginPrivate SynapseZeitgeistPluginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT (synapse_zeitgeist_plugin_match_object_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, SynapseZeitgeistPluginMatchObject))
#define SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, SynapseZeitgeistPluginMatchObjectClass))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, SynapseZeitgeistPluginMatchObjectClass))

typedef struct _SynapseZeitgeistPluginMatchObject SynapseZeitgeistPluginMatchObject;
typedef struct _SynapseZeitgeistPluginMatchObjectClass SynapseZeitgeistPluginMatchObjectClass;
typedef struct _SynapseZeitgeistPluginProcessResultsData SynapseZeitgeistPluginProcessResultsData;
typedef struct _SynapseZeitgeistPluginProcessRecentResultsData SynapseZeitgeistPluginProcessRecentResultsData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _SynapseZeitgeistPluginSearchData SynapseZeitgeistPluginSearchData;
typedef struct _SynapseZeitgeistPluginMatchObjectPrivate SynapseZeitgeistPluginMatchObjectPrivate;

struct _SynapseZeitgeistPlugin {
	GObject parent_instance;
	SynapseZeitgeistPluginPrivate * priv;
};

struct _SynapseZeitgeistPluginClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistPluginPrivate {
	gboolean _enabled;
	ZeitgeistIndex* zg_index;
	ZeitgeistLog* zg_log;
	char* interesting_attributes;
};

struct _SynapseZeitgeistPluginProcessResultsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistPlugin* self;
	char* query;
	ZeitgeistResultSet* events;
	GCancellable* cancellable;
	SynapseResultSet* real_results;
	gboolean local_only;
	GeeSet* uris;
	GeeList* matchers;
	SynapseResultSet* results;
	glong minimum;
	glong maximum;
	ZeitgeistResultSet* _event_it;
	ZeitgeistEvent* event;
	ZeitgeistSubject* subject;
	const char* uri;
	gboolean _tmp0_;
	gint relevancy_penalty;
	char* thumbnail_path;
	char* icon;
	GFile* f;
	char* _tmp1_;
	gboolean _tmp2_;
	GFileInfo* fi;
	char* _tmp3_;
	char* _tmp4_;
	GError * err;
	char* note_filename;
	char* _tmp5_;
	char* _tmp6_;
	char* note_path;
	GFile* note_f;
	gboolean exists;
	GIcon* _tmp7_;
	char* _tmp8_;
	const char* mimetype;
	gboolean _tmp9_;
	GIcon* _tmp10_;
	char* _tmp11_;
	SynapseZeitgeistPluginMatchObject* match_obj;
	gboolean match_found;
	GeeIterator* _matcher_it;
	GeeMapEntry* matcher;
	gint relevancy;
	GeeIterator* _entry_it;
	GeeSet* _tmp12_;
	GeeIterator* _tmp13_;
	GeeMapEntry* entry;
	SynapseZeitgeistPluginMatchObject* mo;
	SynapseMatch* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	glong len;
	float mult;
	gint adjusted_relevancy;
	GError * _inner_error_;
};

struct _SynapseZeitgeistPluginProcessRecentResultsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistPlugin* self;
	ZeitgeistResultSet* events;
	GCancellable* cancellable;
	SynapseResultSet* results;
	gboolean local_only;
	GeeSet* uris;
	guint events_size;
	guint event_index;
	ZeitgeistResultSet* _event_it;
	ZeitgeistEvent* event;
	ZeitgeistSubject* subject;
	const char* uri;
	gboolean is_application;
	gint relevancy_penalty;
	char* thumbnail_path;
	char* icon;
	GFile* f;
	char* _tmp0_;
	gboolean _tmp1_;
	GFileInfo* fi;
	char* _tmp2_;
	char* _tmp3_;
	GError * err;
	gboolean _tmp4_;
	SynapseDesktopFileService* dfs;
	char* _tmp5_;
	SynapseDesktopFileInfo* _tmp6_;
	gboolean _tmp7_;
	const char* mimetype;
	gboolean _tmp8_;
	GIcon* _tmp9_;
	char* _tmp10_;
	SynapseZeitgeistPluginMatchObject* match_obj;
	gint relevancy;
	GError * _inner_error_;
};

struct _SynapseZeitgeistPluginSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	char* search_query;
	gboolean empty_query;
	GTimer* timer;
	GPtrArray* templates;
	GPtrArray* event_templates;
	gint i;
	gboolean _tmp0_;
	SynapseResultSet* _result_;
	ZeitgeistResultSet* rs;
	gboolean only_local;
	gint64 start_ts;
	ZeitgeistResultSet* _tmp4_;
	ZeitgeistTimeRange* _tmp1_;
	GPtrArray* _tmp2_;
	ZeitgeistResultSet* _tmp3_;
	ZeitgeistResultSet* _tmp5_;
	char** words;
	char** _tmp6_;
	gint words_length1;
	gint _words_size_;
	char** _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	ZeitgeistResultSet* _tmp13_;
	ZeitgeistTimeRange* _tmp10_;
	GPtrArray* _tmp11_;
	ZeitgeistResultSet* _tmp12_;
	ZeitgeistResultSet* _tmp14_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseZeitgeistPluginMatchObject {
	GObject parent_instance;
	SynapseZeitgeistPluginMatchObjectPrivate * priv;
};

struct _SynapseZeitgeistPluginMatchObjectClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistPluginMatchObjectPrivate {
	char* _title;
	char* _description;
	char* _icon_name;
	gboolean _has_thumbnail;
	char* _thumbnail_path;
	SynapseMatchType _match_type;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	char* _filename;
	char* _uri;
	SynapseQueryFlags _file_type;
	char* _mime_type;
	char* _extended_info;
};


static gpointer synapse_zeitgeist_plugin_match_object_parent_class = NULL;
static SynapseMatchIface* synapse_zeitgeist_plugin_match_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface* synapse_zeitgeist_plugin_match_object_synapse_uri_match_parent_iface = NULL;
static SynapseApplicationMatchIface* synapse_zeitgeist_plugin_match_object_synapse_application_match_parent_iface = NULL;
static SynapseExtendedInfoIface* synapse_zeitgeist_plugin_match_object_synapse_extended_info_parent_iface = NULL;
static gpointer synapse_zeitgeist_plugin_parent_class = NULL;
static SynapseActivatableIface* synapse_zeitgeist_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_zeitgeist_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_zeitgeist_plugin_get_type (void) G_GNUC_CONST;
#define SYNAPSE_ZEITGEIST_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPluginPrivate))
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_ENABLED
};
#define SYNAPSE_ZEITGEIST_PLUGIN_UNIQUE_NAME "org.gnome.zeitgeist.Engine"
static void synapse_zeitgeist_plugin_real_activate (SynapseActivatable* base);
static void synapse_zeitgeist_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_zeitgeist_plugin_register_plugin (void);
static void _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func (void);
static gint synapse_zeitgeist_plugin_compute_relevancy (SynapseZeitgeistPlugin* self, const char* uri, gint base_relevancy);
static void synapse_zeitgeist_plugin_update_min_max (const char* uri, glong* minimum, glong* maximum);
static void synapse_zeitgeist_plugin_process_results_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_process_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_zeitgeist_plugin_process_results (SynapseZeitgeistPlugin* self, const char* query, ZeitgeistResultSet* events, GCancellable* cancellable, SynapseResultSet* real_results, gboolean local_only, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_plugin_process_results_finish (SynapseZeitgeistPlugin* self, GAsyncResult* _res_);
static gboolean synapse_zeitgeist_plugin_process_results_co (SynapseZeitgeistPluginProcessResultsData* data);
static SynapseZeitgeistPluginMatchObject* synapse_zeitgeist_plugin_match_object_new (ZeitgeistEvent* event, const char* thumbnail_path, const char* icon, gboolean is_application);
static SynapseZeitgeistPluginMatchObject* synapse_zeitgeist_plugin_match_object_construct (GType object_type, ZeitgeistEvent* event, const char* thumbnail_path, const char* icon, gboolean is_application);
static GType synapse_zeitgeist_plugin_match_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void synapse_zeitgeist_plugin_process_recent_results_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_process_recent_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_zeitgeist_plugin_process_recent_results (SynapseZeitgeistPlugin* self, ZeitgeistResultSet* events, GCancellable* cancellable, SynapseResultSet* results, gboolean local_only, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_plugin_process_recent_results_finish (SynapseZeitgeistPlugin* self, GAsyncResult* _res_);
static gboolean synapse_zeitgeist_plugin_process_recent_results_co (SynapseZeitgeistPluginProcessRecentResultsData* data);
static void synapse_zeitgeist_plugin_match_object_init_extended_info_from_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event);
static GPtrArray* synapse_zeitgeist_plugin_create_templates (SynapseZeitgeistPlugin* self, SynapseQueryFlags flags);
static gboolean synapse_zeitgeist_plugin_real_handles_empty_query (SynapseItemProvider* base);
static void synapse_zeitgeist_plugin_real_search_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_zeitgeist_plugin_real_search_co (SynapseZeitgeistPluginSearchData* data);
SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_new (void);
SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_construct (GType object_type);
static GObject * synapse_zeitgeist_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, SynapseZeitgeistPluginMatchObjectPrivate))
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_TITLE,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DESCRIPTION,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_ICON_NAME,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MATCH_TYPE,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_APP_INFO,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_NEEDS_TERMINAL,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILENAME,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_URI,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILE_TYPE,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MIME_TYPE,
	SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_EXTENDED_INFO
};
static void synapse_zeitgeist_plugin_match_object_init_from_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event);
static void synapse_zeitgeist_plugin_match_object_init_from_app_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event);
static void synapse_zeitgeist_plugin_match_object_finalize (GObject* obj);
static void synapse_zeitgeist_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_zeitgeist_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_zeitgeist_plugin_finalize (GObject* obj);
static void synapse_zeitgeist_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_zeitgeist_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void synapse_zeitgeist_plugin_real_activate (SynapseActivatable* base) {
	SynapseZeitgeistPlugin * self;
	ZeitgeistLog* _tmp0_;
	ZeitgeistIndex* _tmp1_;
	self = (SynapseZeitgeistPlugin*) base;
	self->priv->zg_log = (_tmp0_ = zeitgeist_log_new (), _g_object_unref0 (self->priv->zg_log), _tmp0_);
	self->priv->zg_index = (_tmp1_ = zeitgeist_index_new (), _g_object_unref0 (self->priv->zg_index), _tmp1_);
}


static void synapse_zeitgeist_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseZeitgeistPlugin * self;
	self = (SynapseZeitgeistPlugin*) base;
}


static void _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_zeitgeist_plugin_register_plugin ();
}


static void synapse_zeitgeist_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDBusService* _tmp1_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp0_ = synapse_data_sink_plugin_registry_get_default (), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, "Zeitgeist", _ ("Search various items logged by Zeitgeist."), "zeitgeist", _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func, synapse_dbus_service_name_is_activatable (_tmp1_ = synapse_dbus_service_get_default (), SYNAPSE_ZEITGEIST_PLUGIN_UNIQUE_NAME), _ ("Zeitgeist is not installed"));
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (_tmp0_);
}


static gint synapse_zeitgeist_plugin_compute_relevancy (SynapseZeitgeistPlugin* self, const char* uri, gint base_relevancy) {
	gint result = 0;
	SynapseRelevancyService* rs;
	float pop;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	rs = synapse_relevancy_service_get_default ();
	pop = synapse_relevancy_service_get_uri_popularity (rs, uri);
	result = synapse_relevancy_service_compute_relevancy (base_relevancy, pop);
	_g_object_unref0 (rs);
	return result;
}


static void synapse_zeitgeist_plugin_update_min_max (const char* uri, glong* minimum, glong* maximum) {
	glong len;
	g_return_if_fail (uri != NULL);
	len = (glong) strlen (uri);
	if (len > (*maximum)) {
		*maximum = len;
	}
	if (len < (*minimum)) {
		*minimum = len;
	}
}


static void synapse_zeitgeist_plugin_process_results_data_free (gpointer _data) {
	SynapseZeitgeistPluginProcessResultsData* data;
	data = _data;
	_g_free0 (data->query);
	_g_object_unref0 (data->events);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->real_results);
	g_object_unref (data->self);
	g_slice_free (SynapseZeitgeistPluginProcessResultsData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_zeitgeist_plugin_process_results (SynapseZeitgeistPlugin* self, const char* query, ZeitgeistResultSet* events, GCancellable* cancellable, SynapseResultSet* real_results, gboolean local_only, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistPluginProcessResultsData* _data_;
	_data_ = g_slice_new0 (SynapseZeitgeistPluginProcessResultsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_plugin_process_results);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_plugin_process_results_data_free);
	_data_->self = g_object_ref (self);
	_data_->query = g_strdup (query);
	_data_->events = _g_object_ref0 (events);
	_data_->cancellable = _g_object_ref0 (cancellable);
	_data_->real_results = _g_object_ref0 (real_results);
	_data_->local_only = local_only;
	synapse_zeitgeist_plugin_process_results_co (_data_);
}


static void synapse_zeitgeist_plugin_process_results_finish (SynapseZeitgeistPlugin* self, GAsyncResult* _res_) {
	SynapseZeitgeistPluginProcessResultsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_zeitgeist_plugin_process_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistPluginProcessResultsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_zeitgeist_plugin_process_results_co (data);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gboolean synapse_zeitgeist_plugin_process_results_co (SynapseZeitgeistPluginProcessResultsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 52:
		goto _state_52;
		case 53:
		goto _state_53;
	}
	_state_0:
	data->uris = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	data->matchers = synapse_query_get_matchers_for_query (data->query, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
	data->results = synapse_result_set_new ();
	data->minimum = G_MAXLONG;
	data->maximum = (glong) 0;
	{
		data->_event_it = _vala_zeitgeist_result_set_iterator (data->events);
		while (TRUE) {
			if (!((data->event = _vala_zeitgeist_result_set_next_value (data->_event_it)) != NULL)) {
				break;
			}
			if (zeitgeist_event_num_subjects (data->event) <= 0) {
				continue;
			}
			data->subject = _g_object_ref0 (zeitgeist_event_get_subject (data->event, 0));
			data->uri = zeitgeist_subject_get_uri (data->subject);
			if (data->uri == NULL) {
				data->_tmp0_ = TRUE;
			} else {
				data->_tmp0_ = _vala_strcmp0 (data->uri, "") == 0;
			}
			if (data->_tmp0_) {
				_g_object_unref0 (data->subject);
				continue;
			}
			if (!gee_collection_contains ((GeeCollection*) data->uris, data->uri)) {
				data->relevancy_penalty = (gint) SYNAPSE_MATCH_SCORE_URI_PENALTY;
				data->thumbnail_path = NULL;
				data->icon = NULL;
				gee_collection_add ((GeeCollection*) data->uris, data->uri);
				data->f = g_file_new_for_uri (data->uri);
				if ((data->_tmp2_ = _vala_strcmp0 (data->_tmp1_ = g_file_get_uri_scheme (data->f), "data") == 0, _g_free0 (data->_tmp1_), data->_tmp2_)) {
					_g_object_unref0 (data->f);
					_g_free0 (data->icon);
					_g_free0 (data->thumbnail_path);
					_g_object_unref0 (data->subject);
					continue;
				}
				if (g_file_is_native (data->f)) {
					{
						data->_state_ = 52;
						g_file_query_info_async (data->f, data->self->priv->interesting_attributes, 0, 0, data->cancellable, synapse_zeitgeist_plugin_process_results_ready, data);
						return FALSE;
						_state_52:
						data->fi = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							goto __catch50_g_error;
						}
						data->icon = (data->_tmp3_ = g_icon_to_string (g_file_info_get_icon (data->fi)), _g_free0 (data->icon), data->_tmp3_);
						if (g_file_info_has_attribute (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH)) {
							data->thumbnail_path = (data->_tmp4_ = g_strdup (g_file_info_get_attribute_byte_string (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH)), _g_free0 (data->thumbnail_path), data->_tmp4_);
						}
						if (g_file_info_get_is_hidden (data->fi)) {
							data->relevancy_penalty = data->relevancy_penalty + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM);
						}
						_g_object_unref0 (data->fi);
					}
					goto __finally50;
					__catch50_g_error:
					{
						data->err = data->_inner_error_;
						data->_inner_error_ = NULL;
						{
							if (g_cancellable_is_cancelled (data->cancellable)) {
								_g_error_free0 (data->err);
								_g_object_unref0 (data->f);
								_g_free0 (data->icon);
								_g_free0 (data->thumbnail_path);
								_g_object_unref0 (data->subject);
								_g_object_unref0 (data->_event_it);
								_g_object_unref0 (data->results);
								_g_object_unref0 (data->matchers);
								_g_object_unref0 (data->uris);
								{
									if (data->_state_ == 0) {
										g_simple_async_result_complete_in_idle (data->_async_result);
									} else {
										g_simple_async_result_complete (data->_async_result);
									}
									g_object_unref (data->_async_result);
									return FALSE;
								}
							} else {
								_g_error_free0 (data->err);
								_g_object_unref0 (data->f);
								_g_free0 (data->icon);
								_g_free0 (data->thumbnail_path);
								_g_object_unref0 (data->subject);
								continue;
							}
							_g_error_free0 (data->err);
						}
					}
					__finally50:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->f);
						_g_free0 (data->icon);
						_g_free0 (data->thumbnail_path);
						_g_object_unref0 (data->subject);
						_g_object_unref0 (data->_event_it);
						_g_object_unref0 (data->results);
						_g_object_unref0 (data->matchers);
						_g_object_unref0 (data->uris);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				} else {
					if (g_str_has_prefix (data->uri, "note://tomboy/")) {
						data->note_filename = (data->_tmp6_ = g_strconcat (data->_tmp5_ = string_substring (data->uri, (glong) 14, -1), ".note", NULL), _g_free0 (data->_tmp5_), data->_tmp6_);
						data->note_path = g_build_filename (g_get_user_data_dir (), "tomboy", data->note_filename, NULL);
						data->note_f = g_file_new_for_path (data->note_path);
						data->_state_ = 53;
						synapse_utils_query_exists_async (data->note_f, synapse_zeitgeist_plugin_process_results_ready, data);
						return FALSE;
						_state_53:
						data->exists = synapse_utils_query_exists_finish (data->_res_);
						if (g_cancellable_is_cancelled (data->cancellable)) {
							_g_object_unref0 (data->note_f);
							_g_free0 (data->note_path);
							_g_free0 (data->note_filename);
							_g_object_unref0 (data->f);
							_g_free0 (data->icon);
							_g_free0 (data->thumbnail_path);
							_g_object_unref0 (data->subject);
							_g_object_unref0 (data->_event_it);
							_g_object_unref0 (data->results);
							_g_object_unref0 (data->matchers);
							_g_object_unref0 (data->uris);
							{
								if (data->_state_ == 0) {
									g_simple_async_result_complete_in_idle (data->_async_result);
								} else {
									g_simple_async_result_complete (data->_async_result);
								}
								g_object_unref (data->_async_result);
								return FALSE;
							}
						} else {
							if (!data->exists) {
								_g_object_unref0 (data->note_f);
								_g_free0 (data->note_path);
								_g_free0 (data->note_filename);
								_g_object_unref0 (data->f);
								_g_free0 (data->icon);
								_g_free0 (data->thumbnail_path);
								_g_object_unref0 (data->subject);
								continue;
							}
						}
						data->icon = (data->_tmp8_ = g_icon_to_string (data->_tmp7_ = g_content_type_get_icon ("application/x-note")), _g_free0 (data->icon), data->_tmp8_);
						_g_object_unref0 (data->_tmp7_);
						_g_object_unref0 (data->note_f);
						_g_free0 (data->note_path);
						_g_free0 (data->note_filename);
					} else {
						if (data->local_only) {
							_g_object_unref0 (data->f);
							_g_free0 (data->icon);
							_g_free0 (data->thumbnail_path);
							_g_object_unref0 (data->subject);
							continue;
						} else {
							data->relevancy_penalty = data->relevancy_penalty + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
							data->mimetype = zeitgeist_subject_get_mimetype (data->subject);
							if (data->mimetype != NULL) {
								data->_tmp9_ = _vala_strcmp0 (data->mimetype, "") != 0;
							} else {
								data->_tmp9_ = FALSE;
							}
							if (data->_tmp9_) {
								data->icon = (data->_tmp11_ = g_icon_to_string (data->_tmp10_ = g_content_type_get_icon (data->mimetype)), _g_free0 (data->icon), data->_tmp11_);
								_g_object_unref0 (data->_tmp10_);
							}
							if (g_str_has_prefix (data->uri, "http")) {
								synapse_zeitgeist_plugin_update_min_max (data->uri, &data->minimum, &data->maximum);
							}
						}
					}
				}
				data->match_obj = synapse_zeitgeist_plugin_match_object_new (data->event, data->thumbnail_path, data->icon, FALSE);
				data->match_found = FALSE;
				{
					data->_matcher_it = gee_iterable_iterator ((GeeIterable*) data->matchers);
					while (TRUE) {
						if (!gee_iterator_next (data->_matcher_it)) {
							break;
						}
						data->matcher = (GeeMapEntry*) gee_iterator_get (data->_matcher_it);
						if (g_regex_match ((GRegex*) gee_map_entry_get_key (data->matcher), synapse_match_get_title ((SynapseMatch*) data->match_obj), 0, NULL)) {
							data->relevancy = synapse_zeitgeist_plugin_compute_relevancy (data->self, data->uri, GPOINTER_TO_INT (gee_map_entry_get_value (data->matcher)) - data->relevancy_penalty);
							synapse_result_set_add (data->results, (SynapseMatch*) data->match_obj, data->relevancy);
							data->match_found = TRUE;
							_g_object_unref0 (data->matcher);
							break;
						}
						_g_object_unref0 (data->matcher);
					}
					_g_object_unref0 (data->_matcher_it);
				}
				if (!data->match_found) {
					synapse_result_set_add (data->results, (SynapseMatch*) data->match_obj, (gint) (SYNAPSE_MATCH_SCORE_POOR + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR));
				}
				_g_object_unref0 (data->match_obj);
				_g_object_unref0 (data->f);
				_g_free0 (data->icon);
				_g_free0 (data->thumbnail_path);
			}
			_g_object_unref0 (data->subject);
		}
		_g_object_unref0 (data->_event_it);
	}
	{
		data->_entry_it = (data->_tmp13_ = gee_iterable_iterator ((GeeIterable*) (data->_tmp12_ = synapse_result_set_get_entries (data->results))), _g_object_unref0 (data->_tmp12_), data->_tmp13_);
		while (TRUE) {
			if (!gee_iterator_next (data->_entry_it)) {
				break;
			}
			data->entry = (GeeMapEntry*) gee_iterator_get (data->_entry_it);
			data->mo = _g_object_ref0 ((data->_tmp14_ = (SynapseMatch*) gee_map_entry_get_key (data->entry), SYNAPSE_ZEITGEIST_PLUGIN_IS_MATCH_OBJECT (data->_tmp14_) ? ((SynapseZeitgeistPluginMatchObject*) data->_tmp14_) : NULL));
			if (synapse_uri_match_get_uri ((SynapseUriMatch*) data->mo) != NULL) {
				data->_tmp16_ = g_str_has_prefix (synapse_uri_match_get_uri ((SynapseUriMatch*) data->mo), "http");
			} else {
				data->_tmp16_ = FALSE;
			}
			if (data->_tmp16_) {
				data->_tmp15_ = data->minimum != data->maximum;
			} else {
				data->_tmp15_ = FALSE;
			}
			if (data->_tmp15_) {
				data->len = (glong) strlen (synapse_uri_match_get_uri ((SynapseUriMatch*) data->mo));
				data->mult = (data->len - data->minimum) / ((float) (data->maximum - data->minimum));
				data->adjusted_relevancy = GPOINTER_TO_INT (gee_map_entry_get_value (data->entry)) - ((gint) (data->mult * SYNAPSE_MATCH_SCORE_INCREMENT_MINOR));
				synapse_result_set_add (data->real_results, (SynapseMatch*) data->mo, data->adjusted_relevancy);
			} else {
				synapse_result_set_add (data->real_results, (SynapseMatch*) data->mo, GPOINTER_TO_INT (gee_map_entry_get_value (data->entry)));
			}
			_g_object_unref0 (data->mo);
			_g_object_unref0 (data->entry);
		}
		_g_object_unref0 (data->_entry_it);
	}
	_g_object_unref0 (data->results);
	_g_object_unref0 (data->matchers);
	_g_object_unref0 (data->uris);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_zeitgeist_plugin_process_recent_results_data_free (gpointer _data) {
	SynapseZeitgeistPluginProcessRecentResultsData* data;
	data = _data;
	_g_object_unref0 (data->events);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->results);
	g_object_unref (data->self);
	g_slice_free (SynapseZeitgeistPluginProcessRecentResultsData, data);
}


static void synapse_zeitgeist_plugin_process_recent_results (SynapseZeitgeistPlugin* self, ZeitgeistResultSet* events, GCancellable* cancellable, SynapseResultSet* results, gboolean local_only, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
	_data_ = g_slice_new0 (SynapseZeitgeistPluginProcessRecentResultsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_plugin_process_recent_results);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_plugin_process_recent_results_data_free);
	_data_->self = g_object_ref (self);
	_data_->events = _g_object_ref0 (events);
	_data_->cancellable = _g_object_ref0 (cancellable);
	_data_->results = _g_object_ref0 (results);
	_data_->local_only = local_only;
	synapse_zeitgeist_plugin_process_recent_results_co (_data_);
}


static void synapse_zeitgeist_plugin_process_recent_results_finish (SynapseZeitgeistPlugin* self, GAsyncResult* _res_) {
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_zeitgeist_plugin_process_recent_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistPluginProcessRecentResultsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_zeitgeist_plugin_process_recent_results_co (data);
}


static gboolean synapse_zeitgeist_plugin_process_recent_results_co (SynapseZeitgeistPluginProcessRecentResultsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 54:
		goto _state_54;
	}
	_state_0:
	data->uris = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	data->events_size = zeitgeist_result_set_size (data->events);
	data->event_index = (guint) 0;
	{
		data->_event_it = _vala_zeitgeist_result_set_iterator (data->events);
		while (TRUE) {
			if (!((data->event = _vala_zeitgeist_result_set_next_value (data->_event_it)) != NULL)) {
				break;
			}
			data->event_index++;
			if (zeitgeist_event_num_subjects (data->event) <= 0) {
				continue;
			}
			data->subject = _g_object_ref0 (zeitgeist_event_get_subject (data->event, 0));
			data->uri = zeitgeist_subject_get_uri (data->subject);
			if (!gee_collection_contains ((GeeCollection*) data->uris, data->uri)) {
				data->is_application = g_str_has_prefix (data->uri, "application://");
				data->relevancy_penalty = (gint) SYNAPSE_MATCH_SCORE_URI_PENALTY;
				data->thumbnail_path = NULL;
				data->icon = NULL;
				gee_collection_add ((GeeCollection*) data->uris, data->uri);
				data->f = g_file_new_for_uri (data->uri);
				if ((data->_tmp1_ = _vala_strcmp0 (data->_tmp0_ = g_file_get_uri_scheme (data->f), "data") == 0, _g_free0 (data->_tmp0_), data->_tmp1_)) {
					_g_object_unref0 (data->f);
					_g_free0 (data->icon);
					_g_free0 (data->thumbnail_path);
					_g_object_unref0 (data->subject);
					continue;
				}
				if (g_file_is_native (data->f)) {
					{
						data->_state_ = 54;
						g_file_query_info_async (data->f, data->self->priv->interesting_attributes, 0, 0, data->cancellable, synapse_zeitgeist_plugin_process_recent_results_ready, data);
						return FALSE;
						_state_54:
						data->fi = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							goto __catch51_g_error;
						}
						data->icon = (data->_tmp2_ = g_icon_to_string (g_file_info_get_icon (data->fi)), _g_free0 (data->icon), data->_tmp2_);
						if (g_file_info_has_attribute (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH)) {
							data->thumbnail_path = (data->_tmp3_ = g_strdup (g_file_info_get_attribute_byte_string (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH)), _g_free0 (data->thumbnail_path), data->_tmp3_);
						}
						if (g_file_info_get_is_hidden (data->fi)) {
							data->relevancy_penalty = data->relevancy_penalty + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM);
						}
						_g_object_unref0 (data->fi);
					}
					goto __finally51;
					__catch51_g_error:
					{
						data->err = data->_inner_error_;
						data->_inner_error_ = NULL;
						{
							if (g_cancellable_is_cancelled (data->cancellable)) {
								_g_error_free0 (data->err);
								_g_object_unref0 (data->f);
								_g_free0 (data->icon);
								_g_free0 (data->thumbnail_path);
								_g_object_unref0 (data->subject);
								_g_object_unref0 (data->_event_it);
								_g_object_unref0 (data->uris);
								{
									if (data->_state_ == 0) {
										g_simple_async_result_complete_in_idle (data->_async_result);
									} else {
										g_simple_async_result_complete (data->_async_result);
									}
									g_object_unref (data->_async_result);
									return FALSE;
								}
							} else {
								_g_error_free0 (data->err);
								_g_object_unref0 (data->f);
								_g_free0 (data->icon);
								_g_free0 (data->thumbnail_path);
								_g_object_unref0 (data->subject);
								continue;
							}
							_g_error_free0 (data->err);
						}
					}
					__finally51:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->f);
						_g_free0 (data->icon);
						_g_free0 (data->thumbnail_path);
						_g_object_unref0 (data->subject);
						_g_object_unref0 (data->_event_it);
						_g_object_unref0 (data->uris);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				} else {
					if (data->local_only) {
						data->_tmp4_ = !data->is_application;
					} else {
						data->_tmp4_ = FALSE;
					}
					if (data->_tmp4_) {
						_g_object_unref0 (data->f);
						_g_free0 (data->icon);
						_g_free0 (data->thumbnail_path);
						_g_object_unref0 (data->subject);
						continue;
					} else {
						if (data->is_application) {
							data->dfs = synapse_desktop_file_service_get_default ();
							if ((data->_tmp7_ = (data->_tmp6_ = synapse_desktop_file_service_get_desktop_file_for_id (data->dfs, data->_tmp5_ = string_substring (data->uri, (glong) 14, -1))) == NULL, _g_object_unref0 (data->_tmp6_), _g_free0 (data->_tmp5_), data->_tmp7_)) {
								_g_object_unref0 (data->dfs);
								_g_object_unref0 (data->f);
								_g_free0 (data->icon);
								_g_free0 (data->thumbnail_path);
								_g_object_unref0 (data->subject);
								continue;
							}
							_g_object_unref0 (data->dfs);
						} else {
							data->relevancy_penalty = data->relevancy_penalty + ((gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
							data->mimetype = zeitgeist_subject_get_mimetype (data->subject);
							if (data->mimetype != NULL) {
								data->_tmp8_ = _vala_strcmp0 (data->mimetype, "") != 0;
							} else {
								data->_tmp8_ = FALSE;
							}
							if (data->_tmp8_) {
								data->icon = (data->_tmp10_ = g_icon_to_string (data->_tmp9_ = g_content_type_get_icon (data->mimetype)), _g_free0 (data->icon), data->_tmp10_);
								_g_object_unref0 (data->_tmp9_);
							}
						}
					}
				}
				data->match_obj = synapse_zeitgeist_plugin_match_object_new (data->event, data->thumbnail_path, data->icon, data->is_application);
				synapse_zeitgeist_plugin_match_object_init_extended_info_from_event (data->match_obj, data->event);
				data->relevancy = (gint) (((data->events_size - data->event_index) / ((float) data->events_size)) * SYNAPSE_MATCH_SCORE_HIGHEST);
				synapse_result_set_add (data->results, (SynapseMatch*) data->match_obj, data->relevancy);
				_g_object_unref0 (data->match_obj);
				_g_object_unref0 (data->f);
				_g_free0 (data->icon);
				_g_free0 (data->thumbnail_path);
			}
			_g_object_unref0 (data->subject);
		}
		_g_object_unref0 (data->_event_it);
	}
	_g_object_unref0 (data->uris);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GPtrArray* synapse_zeitgeist_plugin_create_templates (SynapseZeitgeistPlugin* self, SynapseQueryFlags flags) {
	GPtrArray* result = NULL;
	GPtrArray* templates;
	const char* _tmp0_;
	char* manifestation;
	ZeitgeistEvent* event;
	ZeitgeistSubject* subject;
	SynapseQueryFlags flags_intersect;
	g_return_val_if_fail (self != NULL, NULL);
	templates = g_ptr_array_new_with_free_func (g_object_unref);
	_tmp0_ = NULL;
	if ((flags & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) {
		_tmp0_ = "";
	} else {
		_tmp0_ = "!" ZEITGEIST_NFO_REMOTE_DATA_OBJECT;
	}
	manifestation = g_strdup (_tmp0_);
	event = NULL;
	subject = NULL;
	flags_intersect = flags & SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT;
	if (flags_intersect == SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT) {
		ZeitgeistSubject* _tmp1_;
		ZeitgeistEvent* _tmp2_;
		ZeitgeistSubject* _tmp3_;
		ZeitgeistSubject* _tmp4_;
		subject = (_tmp1_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp1_);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		event = (_tmp2_ = g_object_ref_sink (zeitgeist_event_new ()), _g_object_unref0 (event), _tmp2_);
		zeitgeist_event_add_subject (event, subject);
		subject = (_tmp3_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp3_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_FOLDER);
		zeitgeist_event_add_subject (event, subject);
		subject = (_tmp4_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp4_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_SOFTWARE);
		zeitgeist_event_add_subject (event, subject);
		g_ptr_array_add (templates, _g_object_ref0 (event));
		result = templates;
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
		_g_free0 (manifestation);
		return result;
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS) {
		ZeitgeistSubject* _tmp5_;
		ZeitgeistEvent* _tmp6_;
		subject = (_tmp5_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp5_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_SOFTWARE);
		event = (_tmp6_ = g_object_ref_sink (zeitgeist_event_new ()), _g_object_unref0 (event), _tmp6_);
		zeitgeist_event_add_subject (event, subject);
		g_ptr_array_add (templates, _g_object_ref0 (event));
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_AUDIO) == SYNAPSE_QUERY_FLAGS_AUDIO) {
		ZeitgeistSubject* _tmp7_;
		ZeitgeistEvent* _tmp8_;
		subject = (_tmp7_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp7_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_AUDIO);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		event = (_tmp8_ = g_object_ref_sink (zeitgeist_event_new ()), _g_object_unref0 (event), _tmp8_);
		zeitgeist_event_add_subject (event, subject);
		g_ptr_array_add (templates, _g_object_ref0 (event));
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_VIDEO) == SYNAPSE_QUERY_FLAGS_VIDEO) {
		ZeitgeistSubject* _tmp9_;
		ZeitgeistEvent* _tmp10_;
		subject = (_tmp9_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp9_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_VIDEO);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		event = (_tmp10_ = g_object_ref_sink (zeitgeist_event_new ()), _g_object_unref0 (event), _tmp10_);
		zeitgeist_event_add_subject (event, subject);
		g_ptr_array_add (templates, _g_object_ref0 (event));
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_IMAGES) == SYNAPSE_QUERY_FLAGS_IMAGES) {
		ZeitgeistSubject* _tmp11_;
		ZeitgeistEvent* _tmp12_;
		subject = (_tmp11_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp11_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_IMAGE);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		event = (_tmp12_ = g_object_ref_sink (zeitgeist_event_new ()), _g_object_unref0 (event), _tmp12_);
		zeitgeist_event_add_subject (event, subject);
		g_ptr_array_add (templates, _g_object_ref0 (event));
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_DOCUMENTS) == SYNAPSE_QUERY_FLAGS_DOCUMENTS) {
		ZeitgeistSubject* _tmp13_;
		ZeitgeistEvent* _tmp14_;
		subject = (_tmp13_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp13_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_DOCUMENT);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		event = (_tmp14_ = g_object_ref_sink (zeitgeist_event_new ()), _g_object_unref0 (event), _tmp14_);
		zeitgeist_event_add_subject (event, subject);
		g_ptr_array_add (templates, _g_object_ref0 (event));
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET) {
		ZeitgeistSubject* _tmp15_;
		ZeitgeistEvent* _tmp16_;
		subject = (_tmp15_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp15_);
		zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_WEBSITE);
		zeitgeist_subject_set_manifestation (subject, manifestation);
		event = (_tmp16_ = g_object_ref_sink (zeitgeist_event_new ()), _g_object_unref0 (event), _tmp16_);
		zeitgeist_event_add_subject (event, subject);
		g_ptr_array_add (templates, _g_object_ref0 (event));
	}
	if ((flags & SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) == SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) {
		ZeitgeistEvent* _tmp17_;
		ZeitgeistSubject* _tmp18_;
		ZeitgeistSubject* _tmp19_;
		ZeitgeistSubject* _tmp20_;
		ZeitgeistSubject* _tmp21_;
		ZeitgeistSubject* _tmp22_;
		ZeitgeistSubject* _tmp23_;
		event = (_tmp17_ = g_object_ref_sink (zeitgeist_event_new ()), _g_object_unref0 (event), _tmp17_);
		subject = (_tmp18_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp18_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_SOFTWARE);
		zeitgeist_event_add_subject (event, subject);
		subject = (_tmp19_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp19_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_AUDIO);
		zeitgeist_event_add_subject (event, subject);
		subject = (_tmp20_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp20_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_VIDEO);
		zeitgeist_event_add_subject (event, subject);
		subject = (_tmp21_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp21_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_IMAGE);
		zeitgeist_event_add_subject (event, subject);
		subject = (_tmp22_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp22_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_DOCUMENT);
		zeitgeist_event_add_subject (event, subject);
		subject = (_tmp23_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp23_);
		zeitgeist_subject_set_interpretation (subject, "!" ZEITGEIST_NFO_WEBSITE);
		zeitgeist_event_add_subject (event, subject);
		if (!((flags & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE)) {
			ZeitgeistSubject* _tmp24_;
			subject = (_tmp24_ = g_object_ref_sink (zeitgeist_subject_new ()), _g_object_unref0 (subject), _tmp24_);
			zeitgeist_subject_set_manifestation (subject, manifestation);
			zeitgeist_event_add_subject (event, subject);
		}
		g_ptr_array_add (templates, _g_object_ref0 (event));
	}
	result = templates;
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
	_g_free0 (manifestation);
	return result;
}


static gboolean synapse_zeitgeist_plugin_real_handles_empty_query (SynapseItemProvider* base) {
	SynapseZeitgeistPlugin * self;
	gboolean result = FALSE;
	self = (SynapseZeitgeistPlugin*) base;
	result = TRUE;
	return result;
}


static void synapse_zeitgeist_plugin_real_search_data_free (gpointer _data) {
	SynapseZeitgeistPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (SynapseZeitgeistPluginSearchData, data);
}


static void synapse_zeitgeist_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistPlugin * self;
	SynapseZeitgeistPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseZeitgeistPlugin*) base;
	_data_ = g_slice_new0 (SynapseZeitgeistPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_plugin_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	synapse_zeitgeist_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_zeitgeist_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseZeitgeistPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_zeitgeist_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistPluginSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_zeitgeist_plugin_real_search_co (data);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static gboolean synapse_zeitgeist_plugin_real_search_co (SynapseZeitgeistPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 55:
		goto _state_55;
		case 56:
		goto _state_56;
		case 57:
		goto _state_57;
		case 58:
		goto _state_58;
	}
	_state_0:
	data->search_query = string_strip (data->q.query_string);
	data->empty_query = _vala_strcmp0 (data->search_query, "") == 0;
	if (!data->empty_query) {
		data->q.query_type = data->q.query_type & (~SYNAPSE_QUERY_FLAGS_APPLICATIONS);
	}
	data->timer = g_timer_new ();
	data->templates = g_ptr_array_new ();
	data->event_templates = synapse_zeitgeist_plugin_create_templates (data->self, data->q.query_type);
	if (g_ptr_array_get_length (data->event_templates) == 0) {
		data->result = NULL;
		_g_ptr_array_unref0 (data->event_templates);
		_g_ptr_array_free0 (data->templates);
		_g_timer_destroy0 (data->timer);
		_g_free0 (data->search_query);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		data->i = 0;
		{
			data->_tmp0_ = TRUE;
			while (TRUE) {
				if (!data->_tmp0_) {
					data->i++;
				}
				data->_tmp0_ = FALSE;
				if (!(data->i < g_ptr_array_get_length (data->event_templates))) {
					break;
				}
				g_ptr_array_add (data->templates, (ZeitgeistEvent*) g_ptr_array_index (data->event_templates, (guint) data->i));
			}
		}
	}
	data->_result_ = synapse_result_set_new ();
	{
		data->only_local = !((data->q.query_type & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE);
		if (data->empty_query) {
			data->start_ts = zeitgeist_timestamp_for_now () - (ZEITGEIST_TIMESTAMP_WEEK * 4);
			data->_state_ = 55;
			zeitgeist_log_find_events (data->self->priv->zg_log, data->_tmp1_ = g_object_ref_sink (zeitgeist_time_range_new (data->start_ts, G_MAXINT64)), (data->_tmp2_ = data->templates, data->templates = NULL, data->_tmp2_), ZEITGEIST_STORAGE_STATE_ANY, (guint32) data->q.max_results, ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, data->q.cancellable, synapse_zeitgeist_plugin_search_ready, data);
			return FALSE;
			_state_55:
			data->_tmp4_ = (data->_tmp3_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp1_), data->_tmp3_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->rs);
				goto __catch52_g_error;
			}
			data->rs = (data->_tmp5_ = data->_tmp4_, _g_object_unref0 (data->rs), data->_tmp5_);
			if (!synapse_query_is_cancelled (&data->q)) {
				data->_state_ = 56;
				synapse_zeitgeist_plugin_process_recent_results (data->self, data->rs, data->q.cancellable, data->_result_, data->only_local, synapse_zeitgeist_plugin_search_ready, data);
				return FALSE;
				_state_56:
				synapse_zeitgeist_plugin_process_recent_results_finish (data->self, data->_res_);
			}
		} else {
			data->words = (data->_tmp7_ = data->_tmp6_ = g_regex_split_simple ("\\s+", data->search_query, 0, 0), data->words_length1 = _vala_array_length (data->_tmp6_), data->_words_size_ = data->words_length1, data->_tmp7_);
			data->search_query = (data->_tmp9_ = g_strdup_printf ("(%s*)", data->_tmp8_ = g_strjoinv ("* ", data->words)), _g_free0 (data->search_query), data->_tmp9_);
			_g_free0 (data->_tmp8_);
			data->_state_ = 57;
			zeitgeist_index_search (data->self->priv->zg_index, data->search_query, data->_tmp10_ = g_object_ref_sink (zeitgeist_time_range_new (G_MININT64, G_MAXINT64)), (data->_tmp11_ = data->templates, data->templates = NULL, data->_tmp11_), (guint32) 0, (guint32) data->q.max_results, ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, data->q.cancellable, synapse_zeitgeist_plugin_search_ready, data);
			return FALSE;
			_state_57:
			data->_tmp13_ = (data->_tmp12_ = zeitgeist_index_search_finish (data->self->priv->zg_index, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp10_), data->_tmp12_);
			if (data->_inner_error_ != NULL) {
				data->words = (_vala_array_free (data->words, data->words_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (data->rs);
				goto __catch52_g_error;
			}
			data->rs = (data->_tmp14_ = data->_tmp13_, _g_object_unref0 (data->rs), data->_tmp14_);
			if (!synapse_query_is_cancelled (&data->q)) {
				data->_state_ = 58;
				synapse_zeitgeist_plugin_process_results (data->self, data->q.query_string, data->rs, data->q.cancellable, data->_result_, data->only_local, synapse_zeitgeist_plugin_search_ready, data);
				return FALSE;
				_state_58:
				synapse_zeitgeist_plugin_process_results_finish (data->self, data->_res_);
			}
			data->words = (_vala_array_free (data->words, data->words_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_object_unref0 (data->rs);
	}
	goto __finally52;
	__catch52_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			if (!synapse_query_is_cancelled (&data->q)) {
				synapse_utils_logger_warning ((GObject*) data->self, "Zeitgeist search failed: %s", data->err->message, NULL);
			}
			_g_error_free0 (data->err);
		}
	}
	__finally52:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->_result_);
			_g_ptr_array_unref0 (data->event_templates);
			_g_ptr_array_free0 (data->templates);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->search_query);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_object_unref0 (data->_result_);
			_g_ptr_array_unref0 (data->event_templates);
			_g_ptr_array_free0 (data->templates);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->search_query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->_result_);
			_g_ptr_array_unref0 (data->event_templates);
			_g_ptr_array_free0 (data->templates);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->search_query);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_object_unref0 (data->_result_);
			_g_ptr_array_unref0 (data->event_templates);
			_g_ptr_array_free0 (data->templates);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->search_query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	synapse_utils_logger_debug ((GObject*) data->self, "zeitgeist-plugin.vala:651: search took %d ms", (gint) (g_timer_elapsed (data->timer, NULL) * 1000), NULL);
	data->result = data->_result_;
	_g_ptr_array_unref0 (data->event_templates);
	_g_ptr_array_free0 (data->templates);
	_g_timer_destroy0 (data->timer);
	_g_free0 (data->search_query);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->_result_);
	_g_ptr_array_unref0 (data->event_templates);
	_g_ptr_array_free0 (data->templates);
	_g_timer_destroy0 (data->timer);
	_g_free0 (data->search_query);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_construct (GType object_type) {
	SynapseZeitgeistPlugin * self = NULL;
	self = (SynapseZeitgeistPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_new (void) {
	return synapse_zeitgeist_plugin_construct (SYNAPSE_TYPE_ZEITGEIST_PLUGIN);
}


static gboolean synapse_zeitgeist_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseZeitgeistPlugin* self;
	self = (SynapseZeitgeistPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_zeitgeist_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseZeitgeistPlugin* self;
	self = (SynapseZeitgeistPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_zeitgeist_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistPlugin * self;
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_ZEITGEIST_PLUGIN (obj);
	{
	}
	return obj;
}


static SynapseZeitgeistPluginMatchObject* synapse_zeitgeist_plugin_match_object_construct (GType object_type, ZeitgeistEvent* event, const char* thumbnail_path, const char* icon, gboolean is_application) {
	SynapseZeitgeistPluginMatchObject * self = NULL;
	char* _tmp0_;
	char* _tmp2_;
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = g_strdup (icon);
	if (_tmp0_ == NULL) {
		char* _tmp1_;
		_tmp0_ = (_tmp1_ = g_strdup (""), _g_free0 (_tmp0_), _tmp1_);
	}
	_tmp2_ = g_strdup (thumbnail_path);
	if (_tmp2_ == NULL) {
		char* _tmp3_;
		_tmp2_ = (_tmp3_ = g_strdup (""), _g_free0 (_tmp2_), _tmp3_);
	}
	self = (SynapseZeitgeistPluginMatchObject*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp0_, "thumbnail-path", _tmp2_, NULL);
	if (!is_application) {
		synapse_zeitgeist_plugin_match_object_init_from_event (self, event);
	} else {
		synapse_zeitgeist_plugin_match_object_init_from_app_event (self, event);
	}
	_g_free0 (_tmp2_);
	_g_free0 (_tmp0_);
	return self;
}


static SynapseZeitgeistPluginMatchObject* synapse_zeitgeist_plugin_match_object_new (ZeitgeistEvent* event, const char* thumbnail_path, const char* icon, gboolean is_application) {
	return synapse_zeitgeist_plugin_match_object_construct (SYNAPSE_ZEITGEIST_PLUGIN_TYPE_MATCH_OBJECT, event, thumbnail_path, icon, is_application);
}


static void synapse_zeitgeist_plugin_match_object_init_from_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event) {
	ZeitgeistSubject* subject;
	GFile* f;
	char* _tmp0_;
	const char* text;
	gboolean _tmp1_ = FALSE;
	const char* interpretation;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	subject = _g_object_ref0 (zeitgeist_event_get_subject (event, 0));
	synapse_uri_match_set_uri ((SynapseUriMatch*) self, zeitgeist_subject_get_uri (subject));
	f = g_file_new_for_uri (synapse_uri_match_get_uri ((SynapseUriMatch*) self));
	synapse_match_set_description ((SynapseMatch*) self, _tmp0_ = g_file_get_parse_name (f));
	_g_free0 (_tmp0_);
	text = zeitgeist_subject_get_text (subject);
	if (text == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _vala_strcmp0 (text, "") == 0;
	}
	if (_tmp1_) {
		synapse_match_set_title ((SynapseMatch*) self, synapse_match_get_description ((SynapseMatch*) self));
	} else {
		synapse_match_set_title ((SynapseMatch*) self, text);
	}
	synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, zeitgeist_subject_get_mimetype (subject));
	interpretation = zeitgeist_subject_get_interpretation (subject);
	if (zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_AUDIO)) {
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_AUDIO);
	} else {
		if (zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_VIDEO)) {
			synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_VIDEO);
		} else {
			if (zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_IMAGE)) {
				synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_IMAGES);
			} else {
				if (zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_DOCUMENT)) {
					synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_DOCUMENTS);
				} else {
					if (zeitgeist_symbol_is_a (interpretation, ZEITGEIST_NFO_WEBSITE)) {
						synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_INTERNET);
					} else {
						synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_UNCATEGORIZED);
					}
				}
			}
		}
	}
	_g_object_unref0 (f);
	_g_object_unref0 (subject);
}


static void synapse_zeitgeist_plugin_match_object_init_from_app_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event) {
	ZeitgeistSubject* subject;
	SynapseDesktopFileService* dfs;
	char* _tmp0_;
	SynapseDesktopFileInfo* _tmp1_;
	SynapseDesktopFileInfo* dfi;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_UNCATEGORIZED);
	synapse_match_set_match_type ((SynapseMatch*) self, SYNAPSE_MATCH_TYPE_APPLICATION);
	subject = _g_object_ref0 (zeitgeist_event_get_subject (event, 0));
	synapse_uri_match_set_uri ((SynapseUriMatch*) self, zeitgeist_subject_get_uri (subject));
	dfs = synapse_desktop_file_service_get_default ();
	dfi = (_tmp1_ = synapse_desktop_file_service_get_desktop_file_for_id (dfs, _tmp0_ = string_substring (synapse_uri_match_get_uri ((SynapseUriMatch*) self), (glong) 14, -1)), _g_free0 (_tmp0_), _tmp1_);
	synapse_match_set_title ((SynapseMatch*) self, synapse_desktop_file_info_get_name (dfi));
	synapse_match_set_icon_name ((SynapseMatch*) self, synapse_desktop_file_info_get_icon_name (dfi));
	synapse_match_set_description ((SynapseMatch*) self, synapse_desktop_file_info_get_comment (dfi));
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, synapse_desktop_file_info_get_needs_terminal (dfi));
	synapse_application_match_set_filename ((SynapseApplicationMatch*) self, synapse_desktop_file_info_get_filename (dfi));
	_g_object_unref0 (dfi);
	_g_object_unref0 (dfs);
	_g_object_unref0 (subject);
}


static void synapse_zeitgeist_plugin_match_object_init_extended_info_from_event (SynapseZeitgeistPluginMatchObject* self, ZeitgeistEvent* event) {
	gint64 now;
	gint64 delta;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	now = zeitgeist_timestamp_for_now ();
	delta = now - zeitgeist_event_get_timestamp (event);
	if (delta < (ZEITGEIST_TIMESTAMP_MINUTE * 2)) {
		synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _ ("few moments ago"));
	} else {
		if (delta < ZEITGEIST_TIMESTAMP_HOUR) {
			gint mins;
			char* _tmp0_;
			mins = (gint) (delta / ZEITGEIST_TIMESTAMP_MINUTE);
			synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp0_ = g_strdup_printf (ngettext ("%d minute ago", "%d minutes ago", (gulong) mins), mins));
			_g_free0 (_tmp0_);
		} else {
			if (delta < (ZEITGEIST_TIMESTAMP_DAY * 2)) {
				gint hours;
				char* _tmp1_;
				hours = (gint) (delta / ZEITGEIST_TIMESTAMP_HOUR);
				synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp1_ = g_strdup_printf (ngettext ("%d hour ago", "%d hours ago", (gulong) hours), hours));
				_g_free0 (_tmp1_);
			} else {
				if (delta < (ZEITGEIST_TIMESTAMP_WEEK * 2)) {
					gint days;
					char* _tmp2_;
					days = (gint) (delta / ZEITGEIST_TIMESTAMP_DAY);
					synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp2_ = g_strdup_printf (ngettext ("%d day ago", "%d days ago", (gulong) days), days));
					_g_free0 (_tmp2_);
				} else {
					if (delta < ZEITGEIST_TIMESTAMP_YEAR) {
						gint weeks;
						char* _tmp3_;
						weeks = (gint) (delta / ZEITGEIST_TIMESTAMP_WEEK);
						synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, _tmp3_ = g_strdup_printf (ngettext ("%d week ago", "%d weeks ago", (gulong) weeks), weeks));
						_g_free0 (_tmp3_);
					} else {
						synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, "long time ago");
					}
				}
			}
		}
	}
}


static const char* synapse_zeitgeist_plugin_match_object_real_get_title (SynapseMatch* base) {
	const char* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_title (SynapseMatch* base, const char* value) {
	SynapseZeitgeistPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_title = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_title), _tmp0_);
	g_object_notify ((GObject *) self, "title");
}


static const char* synapse_zeitgeist_plugin_match_object_real_get_description (SynapseMatch* base) {
	const char* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_description (SynapseMatch* base, const char* value) {
	SynapseZeitgeistPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


static const char* synapse_zeitgeist_plugin_match_object_real_get_icon_name (SynapseMatch* base) {
	const char* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_icon_name (SynapseMatch* base, const char* value) {
	SynapseZeitgeistPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_zeitgeist_plugin_match_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const char* synapse_zeitgeist_plugin_match_object_real_get_thumbnail_path (SynapseMatch* base) {
	const char* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_thumbnail_path (SynapseMatch* base, const char* value) {
	SynapseZeitgeistPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_thumbnail_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_thumbnail_path), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_zeitgeist_plugin_match_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static GAppInfo* synapse_zeitgeist_plugin_match_object_real_get_app_info (SynapseApplicationMatch* base) {
	GAppInfo* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_app_info;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_app_info (SynapseApplicationMatch* base, GAppInfo* value) {
	SynapseZeitgeistPluginMatchObject* self;
	GAppInfo* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_app_info = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_app_info), _tmp0_);
	g_object_notify ((GObject *) self, "app-info");
}


static gboolean synapse_zeitgeist_plugin_match_object_real_get_needs_terminal (SynapseApplicationMatch* base) {
	gboolean result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_needs_terminal;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_needs_terminal (SynapseApplicationMatch* base, gboolean value) {
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_needs_terminal = value;
	g_object_notify ((GObject *) self, "needs-terminal");
}


static const char* synapse_zeitgeist_plugin_match_object_real_get_filename (SynapseApplicationMatch* base) {
	const char* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_filename;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_filename (SynapseApplicationMatch* base, const char* value) {
	SynapseZeitgeistPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_filename), _tmp0_);
	g_object_notify ((GObject *) self, "filename");
}


static const char* synapse_zeitgeist_plugin_match_object_real_get_uri (SynapseUriMatch* base) {
	const char* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_uri;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_uri (SynapseUriMatch* base, const char* value) {
	SynapseZeitgeistPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_uri = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_uri), _tmp0_);
	g_object_notify ((GObject *) self, "uri");
}


static SynapseQueryFlags synapse_zeitgeist_plugin_match_object_real_get_file_type (SynapseUriMatch* base) {
	SynapseQueryFlags result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_file_type;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_file_type (SynapseUriMatch* base, SynapseQueryFlags value) {
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_file_type = value;
	g_object_notify ((GObject *) self, "file-type");
}


static const char* synapse_zeitgeist_plugin_match_object_real_get_mime_type (SynapseUriMatch* base) {
	const char* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_mime_type;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_mime_type (SynapseUriMatch* base, const char* value) {
	SynapseZeitgeistPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_mime_type = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_mime_type), _tmp0_);
	g_object_notify ((GObject *) self, "mime-type");
}


static const char* synapse_zeitgeist_plugin_match_object_real_get_extended_info (SynapseExtendedInfo* base) {
	const char* result;
	SynapseZeitgeistPluginMatchObject* self;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	result = self->priv->_extended_info;
	return result;
}


static void synapse_zeitgeist_plugin_match_object_real_set_extended_info (SynapseExtendedInfo* base, const char* value) {
	SynapseZeitgeistPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseZeitgeistPluginMatchObject*) base;
	self->priv->_extended_info = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_extended_info), _tmp0_);
	g_object_notify ((GObject *) self, "extended-info");
}


static void synapse_zeitgeist_plugin_match_object_class_init (SynapseZeitgeistPluginMatchObjectClass * klass) {
	synapse_zeitgeist_plugin_match_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseZeitgeistPluginMatchObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_zeitgeist_plugin_match_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_zeitgeist_plugin_match_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_match_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_APP_INFO, "app-info");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_NEEDS_TERMINAL, "needs-terminal");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILENAME, "filename");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MIME_TYPE, "mime-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_EXTENDED_INFO, "extended-info");
}


static void synapse_zeitgeist_plugin_match_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_zeitgeist_plugin_match_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_zeitgeist_plugin_match_object_real_get_title;
	iface->set_title = synapse_zeitgeist_plugin_match_object_real_set_title;
	iface->get_description = synapse_zeitgeist_plugin_match_object_real_get_description;
	iface->set_description = synapse_zeitgeist_plugin_match_object_real_set_description;
	iface->get_icon_name = synapse_zeitgeist_plugin_match_object_real_get_icon_name;
	iface->set_icon_name = synapse_zeitgeist_plugin_match_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_zeitgeist_plugin_match_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_zeitgeist_plugin_match_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_zeitgeist_plugin_match_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_zeitgeist_plugin_match_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_zeitgeist_plugin_match_object_real_get_match_type;
	iface->set_match_type = synapse_zeitgeist_plugin_match_object_real_set_match_type;
}


static void synapse_zeitgeist_plugin_match_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface) {
	synapse_zeitgeist_plugin_match_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_zeitgeist_plugin_match_object_real_get_uri;
	iface->set_uri = synapse_zeitgeist_plugin_match_object_real_set_uri;
	iface->get_file_type = synapse_zeitgeist_plugin_match_object_real_get_file_type;
	iface->set_file_type = synapse_zeitgeist_plugin_match_object_real_set_file_type;
	iface->get_mime_type = synapse_zeitgeist_plugin_match_object_real_get_mime_type;
	iface->set_mime_type = synapse_zeitgeist_plugin_match_object_real_set_mime_type;
}


static void synapse_zeitgeist_plugin_match_object_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface) {
	synapse_zeitgeist_plugin_match_object_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_app_info = synapse_zeitgeist_plugin_match_object_real_get_app_info;
	iface->set_app_info = synapse_zeitgeist_plugin_match_object_real_set_app_info;
	iface->get_needs_terminal = synapse_zeitgeist_plugin_match_object_real_get_needs_terminal;
	iface->set_needs_terminal = synapse_zeitgeist_plugin_match_object_real_set_needs_terminal;
	iface->get_filename = synapse_zeitgeist_plugin_match_object_real_get_filename;
	iface->set_filename = synapse_zeitgeist_plugin_match_object_real_set_filename;
}


static void synapse_zeitgeist_plugin_match_object_synapse_extended_info_interface_init (SynapseExtendedInfoIface * iface) {
	synapse_zeitgeist_plugin_match_object_synapse_extended_info_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_extended_info = synapse_zeitgeist_plugin_match_object_real_get_extended_info;
	iface->set_extended_info = synapse_zeitgeist_plugin_match_object_real_set_extended_info;
}


static void synapse_zeitgeist_plugin_match_object_instance_init (SynapseZeitgeistPluginMatchObject * self) {
	self->priv = SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_GET_PRIVATE (self);
	self->priv->_description = g_strdup ("");
	self->priv->_icon_name = g_strdup ("");
	self->priv->_has_thumbnail = FALSE;
	self->priv->_extended_info = NULL;
}


static void synapse_zeitgeist_plugin_match_object_finalize (GObject* obj) {
	SynapseZeitgeistPluginMatchObject * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_extended_info);
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_match_object_parent_class)->finalize (obj);
}


static GType synapse_zeitgeist_plugin_match_object_get_type (void) {
	static volatile gsize synapse_zeitgeist_plugin_match_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_match_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginMatchObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_match_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPluginMatchObject), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_match_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_match_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_match_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_match_object_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_extended_info_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_match_object_synapse_extended_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_zeitgeist_plugin_match_object_type_id;
		synapse_zeitgeist_plugin_match_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistPluginMatchObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_zeitgeist_plugin_match_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_zeitgeist_plugin_match_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		g_type_add_interface_static (synapse_zeitgeist_plugin_match_object_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
		g_type_add_interface_static (synapse_zeitgeist_plugin_match_object_type_id, SYNAPSE_TYPE_EXTENDED_INFO, &synapse_extended_info_info);
		g_once_init_leave (&synapse_zeitgeist_plugin_match_object_type_id__volatile, synapse_zeitgeist_plugin_match_object_type_id);
	}
	return synapse_zeitgeist_plugin_match_object_type_id__volatile;
}


static void synapse_zeitgeist_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseZeitgeistPluginMatchObject * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_APP_INFO:
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_NEEDS_TERMINAL:
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILENAME:
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_URI:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_EXTENDED_INFO:
		g_value_set_string (value, synapse_extended_info_get_extended_info ((SynapseExtendedInfo*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_zeitgeist_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseZeitgeistPluginMatchObject * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_APP_INFO:
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_NEEDS_TERMINAL:
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILENAME:
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_URI:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_ZEITGEIST_PLUGIN_MATCH_OBJECT_EXTENDED_INFO:
		synapse_extended_info_set_extended_info ((SynapseExtendedInfo*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_zeitgeist_plugin_class_init (SynapseZeitgeistPluginClass * klass) {
	synapse_zeitgeist_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseZeitgeistPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_zeitgeist_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_zeitgeist_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_ENABLED, "enabled");
	{
		synapse_zeitgeist_plugin_register_plugin ();
	}
}


static void synapse_zeitgeist_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_zeitgeist_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = synapse_zeitgeist_plugin_real_activate;
	iface->deactivate = synapse_zeitgeist_plugin_real_deactivate;
	iface->get_enabled = synapse_zeitgeist_plugin_real_get_enabled;
	iface->set_enabled = synapse_zeitgeist_plugin_real_set_enabled;
}


static void synapse_zeitgeist_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_zeitgeist_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_empty_query = synapse_zeitgeist_plugin_real_handles_empty_query;
	iface->search = synapse_zeitgeist_plugin_real_search;
	iface->search_finish = synapse_zeitgeist_plugin_real_search_finish;
}


static void synapse_zeitgeist_plugin_instance_init (SynapseZeitgeistPlugin * self) {
	self->priv = SYNAPSE_ZEITGEIST_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->interesting_attributes = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, NULL, NULL);
}


static void synapse_zeitgeist_plugin_finalize (GObject* obj) {
	SynapseZeitgeistPlugin * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN (obj);
	_g_object_unref0 (self->priv->zg_index);
	_g_object_unref0 (self->priv->zg_log);
	_g_free0 (self->priv->interesting_attributes);
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_parent_class)->finalize (obj);
}


GType synapse_zeitgeist_plugin_get_type (void) {
	static volatile gsize synapse_zeitgeist_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPlugin), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_zeitgeist_plugin_type_id;
		synapse_zeitgeist_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_zeitgeist_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_zeitgeist_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_zeitgeist_plugin_type_id__volatile, synapse_zeitgeist_plugin_type_id);
	}
	return synapse_zeitgeist_plugin_type_id__volatile;
}


static void synapse_zeitgeist_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseZeitgeistPlugin * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_ZEITGEIST_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_zeitgeist_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseZeitgeistPlugin * self;
	self = SYNAPSE_ZEITGEIST_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_ZEITGEIST_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




