/* opensearch.c generated by valac 0.10.4, the Vala compiler
 * generated from opensearch.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <synapse-core.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN (synapse_open_search_plugin_get_type ())
#define SYNAPSE_OPEN_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, SynapseOpenSearchPlugin))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, SynapseOpenSearchPluginClass))
#define SYNAPSE_IS_OPEN_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN))
#define SYNAPSE_IS_OPEN_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, SynapseOpenSearchPluginClass))

typedef struct _SynapseOpenSearchPlugin SynapseOpenSearchPlugin;
typedef struct _SynapseOpenSearchPluginClass SynapseOpenSearchPluginClass;
typedef struct _SynapseOpenSearchPluginPrivate SynapseOpenSearchPluginPrivate;

#define SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION (synapse_open_search_plugin_search_action_get_type ())
#define SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchAction))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchActionClass))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_SEARCH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_SEARCH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchActionClass))

typedef struct _SynapseOpenSearchPluginSearchAction SynapseOpenSearchPluginSearchAction;
typedef struct _SynapseOpenSearchPluginSearchActionClass SynapseOpenSearchPluginSearchActionClass;

#define SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG (synapse_open_search_plugin_config_get_type ())
#define SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfig))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfigClass))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfigClass))

typedef struct _SynapseOpenSearchPluginConfig SynapseOpenSearchPluginConfig;
typedef struct _SynapseOpenSearchPluginConfigClass SynapseOpenSearchPluginConfigClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER (synapse_open_search_plugin_open_search_parser_get_type ())
#define SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParser))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParserClass))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_OPEN_SEARCH_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_OPEN_SEARCH_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParserClass))

typedef struct _SynapseOpenSearchPluginOpenSearchParser SynapseOpenSearchPluginOpenSearchParser;
typedef struct _SynapseOpenSearchPluginOpenSearchParserClass SynapseOpenSearchPluginOpenSearchParserClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseOpenSearchPluginLoadXmlsData SynapseOpenSearchPluginLoadXmlsData;
typedef struct _SynapseOpenSearchPluginOpenSearchParserPrivate SynapseOpenSearchPluginOpenSearchParserPrivate;
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
typedef struct _SynapseOpenSearchPluginSearchActionPrivate SynapseOpenSearchPluginSearchActionPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseOpenSearchPluginConfigPrivate SynapseOpenSearchPluginConfigPrivate;

struct _SynapseOpenSearchPlugin {
	GObject parent_instance;
	SynapseOpenSearchPluginPrivate * priv;
};

struct _SynapseOpenSearchPluginClass {
	GObjectClass parent_class;
};

struct _SynapseOpenSearchPluginPrivate {
	gboolean _enabled;
	GeeList* actions;
	SynapseOpenSearchPluginConfig* config;
};

struct _SynapseOpenSearchPluginLoadXmlsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseOpenSearchPlugin* self;
	SynapseOpenSearchPluginOpenSearchParser* parser;
	GeeList* internals;
	GeeIterator* _s_it;
	const char* s;
	SynapseOpenSearchPluginOpenSearchParser* _tmp0_;
	SynapseOpenSearchPluginSearchAction* _tmp1_;
	GError * no_way;
	char** xmls;
	gint _tmp2_;
	char** _tmp3_;
	gint xmls_length1;
	gint _xmls_size_;
	char** _tmp4_;
	char* xml_path;
	char* _tmp5_;
	char* _tmp6_;
	GFile* f;
	char* contents;
	gsize len;
	char* _tmp7_;
	char* _tmp8_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp9_;
	SynapseOpenSearchPluginSearchAction* _tmp10_;
	GError * err;
	char** xml_collection;
	int xml_collection_length1;
	int xml_it;
	const char* xml;
	GError * _inner_error_;
};

struct _SynapseOpenSearchPluginOpenSearchParser {
	GObject parent_instance;
	SynapseOpenSearchPluginOpenSearchParserPrivate * priv;
};

struct _SynapseOpenSearchPluginOpenSearchParserClass {
	GObjectClass parent_class;
};

struct _SynapseOpenSearchPluginOpenSearchParserPrivate {
	GMarkupParseContext* context;
	gboolean is_opensearch;
	gboolean in_name_elem;
	gboolean in_description_elem;
	gboolean has_name;
	gboolean has_desc;
	gboolean has_url;
	char* _short_name;
	char* _description;
	char* _query_url;
	char* _suggestion_url;
};

struct _SynapseOpenSearchPluginSearchAction {
	GObject parent_instance;
	SynapseOpenSearchPluginSearchActionPrivate * priv;
};

struct _SynapseOpenSearchPluginSearchActionClass {
	GObjectClass parent_class;
};

struct _SynapseOpenSearchPluginSearchActionPrivate {
	char* _title;
	char* _description;
	char* _icon_name;
	gboolean _has_thumbnail;
	char* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
	char* _query_template;
};

struct _SynapseOpenSearchPluginConfig {
	SynapseConfigObject parent_instance;
	SynapseOpenSearchPluginConfigPrivate * priv;
};

struct _SynapseOpenSearchPluginConfigClass {
	SynapseConfigObjectClass parent_class;
};

struct _SynapseOpenSearchPluginConfigPrivate {
	gboolean _use_internal;
	char** _search_engines;
	gint _search_engines_length1;
	gint __search_engines_size_;
};


static gpointer synapse_open_search_plugin_open_search_parser_parent_class = NULL;
static gpointer synapse_open_search_plugin_search_action_parent_class = NULL;
static SynapseMatchIface* synapse_open_search_plugin_search_action_synapse_match_parent_iface = NULL;
static gpointer synapse_open_search_plugin_config_parent_class = NULL;
static gpointer synapse_open_search_plugin_parent_class = NULL;
static SynapseActivatableIface* synapse_open_search_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface* synapse_open_search_plugin_synapse_action_provider_parent_iface = NULL;

#define SYNAPSE_GOOGLE_SEARCH_XML "\n" \
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
"<OpenSearchDescription xmlns=\"http://a9.com/-/spec/opensearch/1.1/\">" \
"\n" \
"  <ShortName>Google</ShortName>\n" \
"  <Description>Search the web using google.com</Description>\n" \
"  <Url type=\"text/html\" method=\"get\" template=\"http://www.google." \
"com/search?q={searchTerms}&amp;hl={language}\"/>\n" \
"  <Url type=\"application/x-suggestions+json\" template=\"http://sugge" \
"stqueries.google.com/complete/search?output=firefox&amp;client=firefox" \
"&amp;hl=en&amp;q={searchTerms}\"/>\n" \
"\n" \
"  <Developer>Synapse dev team</Developer>\n" \
"  <InputEncoding>UTF-8</InputEncoding>\n" \
"</OpenSearchDescription>\n"
#define SYNAPSE_GOOGLE_MAPS_XML "\n" \
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
"<OpenSearchDescription xmlns=\"http://a9.com/-/spec/opensearch/1.1/\">" \
"\n" \
"  <ShortName>Google Maps</ShortName>\n" \
"  <Description>Search using Google Maps</Description>\n" \
"  <Url type=\"text/html\" method=\"get\" template=\"http://maps.google" \
".com/maps?q={searchTerms}&amp;hl={language}\"/>\n" \
"\n" \
"  <Developer>Synapse dev team</Developer>\n" \
"  <InputEncoding>UTF-8</InputEncoding>\n" \
"</OpenSearchDescription>\n"
GType synapse_open_search_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_open_search_plugin_search_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType synapse_open_search_plugin_config_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_OPEN_SEARCH_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, SynapseOpenSearchPluginPrivate))
enum  {
	SYNAPSE_OPEN_SEARCH_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED
};
static void synapse_open_search_plugin_real_activate (SynapseActivatable* base);
static void synapse_open_search_plugin_load_xmls (SynapseOpenSearchPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_open_search_plugin_load_xmls_finish (SynapseOpenSearchPlugin* self, GAsyncResult* _res_);
static void synapse_open_search_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_open_search_plugin_register_plugin (void);
static void _synapse_open_search_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_open_search_plugin_load_xmls_data_free (gpointer _data);
static void synapse_open_search_plugin_load_xmls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_open_search_plugin_load_xmls_co (SynapseOpenSearchPluginLoadXmlsData* data);
static GType synapse_open_search_plugin_open_search_parser_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean synapse_open_search_plugin_config_get_use_internal (SynapseOpenSearchPluginConfig* self);
static SynapseOpenSearchPluginOpenSearchParser* synapse_open_search_plugin_open_search_parser_new (void);
static SynapseOpenSearchPluginOpenSearchParser* synapse_open_search_plugin_open_search_parser_construct (GType object_type);
static gboolean synapse_open_search_plugin_open_search_parser_parse (SynapseOpenSearchPluginOpenSearchParser* self, const char* content, GError** error);
static gboolean synapse_open_search_plugin_open_search_parser_has_valid_result (SynapseOpenSearchPluginOpenSearchParser* self);
static const char* synapse_open_search_plugin_open_search_parser_get_short_name (SynapseOpenSearchPluginOpenSearchParser* self);
static const char* synapse_open_search_plugin_open_search_parser_get_description (SynapseOpenSearchPluginOpenSearchParser* self);
static const char* synapse_open_search_plugin_open_search_parser_get_query_url (SynapseOpenSearchPluginOpenSearchParser* self);
static SynapseOpenSearchPluginSearchAction* synapse_open_search_plugin_search_action_new (const char* name, const char* description, const char* url);
static SynapseOpenSearchPluginSearchAction* synapse_open_search_plugin_search_action_construct (GType object_type, const char* name, const char* description, const char* url);
static char** synapse_open_search_plugin_config_get_search_engines (SynapseOpenSearchPluginConfig* self, int* result_length1);
static char** _vala_array_dup1 (char** self, int length);
static gboolean synapse_open_search_plugin_real_handles_unknown (SynapseActionProvider* base);
static SynapseResultSet* synapse_open_search_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* query, SynapseMatch* match);
static gint synapse_open_search_plugin_search_action_get_default_relevancy (SynapseOpenSearchPluginSearchAction* self);
SynapseOpenSearchPlugin* synapse_open_search_plugin_new (void);
SynapseOpenSearchPlugin* synapse_open_search_plugin_construct (GType object_type);
static GObject * synapse_open_search_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParserPrivate))
enum  {
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DUMMY_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL
};
static void synapse_open_search_plugin_open_search_parser_start (SynapseOpenSearchPluginOpenSearchParser* self, GMarkupParseContext* ctx, const char* name, char** attr_names, int attr_names_length1, char** attr_vals, int attr_vals_length1, GError** error);
static void _synapse_open_search_plugin_open_search_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const char* element_name, char** attribute_names, char** attribute_values, gpointer self, GError** error);
static void synapse_open_search_plugin_open_search_parser_end (SynapseOpenSearchPluginOpenSearchParser* self, GMarkupParseContext* ctx, const char* name, GError** error);
static void _synapse_open_search_plugin_open_search_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const char* element_name, gpointer self, GError** error);
static void synapse_open_search_plugin_open_search_parser_text (SynapseOpenSearchPluginOpenSearchParser* self, GMarkupParseContext* ctx, const char* text, gsize text_len, GError** error);
static void _synapse_open_search_plugin_open_search_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const char* text, gsize text_len, gpointer self, GError** error);
static void synapse_open_search_plugin_open_search_parser_process_url (SynapseOpenSearchPluginOpenSearchParser* self, char** attrs, int attrs_length1, char** vals, int vals_length1);
static void synapse_open_search_plugin_open_search_parser_set_query_url (SynapseOpenSearchPluginOpenSearchParser* self, const char* value);
static void synapse_open_search_plugin_open_search_parser_set_suggestion_url (SynapseOpenSearchPluginOpenSearchParser* self, const char* value);
static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle);
static void synapse_open_search_plugin_open_search_parser_set_short_name (SynapseOpenSearchPluginOpenSearchParser* self, const char* value);
static void synapse_open_search_plugin_open_search_parser_set_description (SynapseOpenSearchPluginOpenSearchParser* self, const char* value);
static const char* synapse_open_search_plugin_open_search_parser_get_suggestion_url (SynapseOpenSearchPluginOpenSearchParser* self);
static GObject * synapse_open_search_plugin_open_search_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void synapse_open_search_plugin_open_search_parser_finalize (GObject* obj);
static void synapse_open_search_plugin_open_search_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_open_search_plugin_open_search_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchActionPrivate))
enum  {
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DUMMY_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_TITLE,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DESCRIPTION,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_ICON_NAME,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_HAS_THUMBNAIL,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_THUMBNAIL_PATH,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_MATCH_TYPE,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE
};
static void synapse_open_search_plugin_search_action_real_execute (SynapseMatch* base, SynapseMatch* match);
static char* synapse_open_search_plugin_search_action_get_query_url (SynapseOpenSearchPluginSearchAction* self, const char* query);
static const char* synapse_open_search_plugin_search_action_get_query_template (SynapseOpenSearchPluginSearchAction* self);
static char* synapse_open_search_plugin_search_action_get_lang (SynapseOpenSearchPluginSearchAction* self);
static void synapse_open_search_plugin_search_action_set_default_relevancy (SynapseOpenSearchPluginSearchAction* self, gint value);
static void synapse_open_search_plugin_search_action_set_query_template (SynapseOpenSearchPluginSearchAction* self, const char* value);
static void synapse_open_search_plugin_search_action_finalize (GObject* obj);
static void synapse_open_search_plugin_search_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_open_search_plugin_search_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfigPrivate))
enum  {
	SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_DUMMY_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL,
	SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES
};
static SynapseOpenSearchPluginConfig* synapse_open_search_plugin_config_new (void);
static SynapseOpenSearchPluginConfig* synapse_open_search_plugin_config_construct (GType object_type);
static void synapse_open_search_plugin_config_set_use_internal (SynapseOpenSearchPluginConfig* self, gboolean value);
static void synapse_open_search_plugin_config_set_search_engines (SynapseOpenSearchPluginConfig* self, char** value, int value_length1);
static char** _vala_array_dup2 (char** self, int length);
static void synapse_open_search_plugin_config_finalize (GObject* obj);
static void synapse_open_search_plugin_config_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_open_search_plugin_config_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_open_search_plugin_finalize (GObject* obj);
static void synapse_open_search_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_open_search_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GMarkupParser SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_parser = {_synapse_open_search_plugin_open_search_parser_start_gmarkup_parser_start_element_func, _synapse_open_search_plugin_open_search_parser_end_gmarkup_parser_end_element_func, _synapse_open_search_plugin_open_search_parser_text_gmarkup_parser_text_func, NULL, NULL};


static void synapse_open_search_plugin_real_activate (SynapseActivatable* base) {
	SynapseOpenSearchPlugin * self;
	GeeList* _tmp0_;
	self = (SynapseOpenSearchPlugin*) base;
	self->priv->actions = (_tmp0_ = (GeeList*) gee_array_list_new (SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->actions), _tmp0_);
	synapse_open_search_plugin_load_xmls (self, NULL, NULL);
}


static void synapse_open_search_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseOpenSearchPlugin * self;
	self = (SynapseOpenSearchPlugin*) base;
}


static void _synapse_open_search_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_open_search_plugin_register_plugin ();
}


static void synapse_open_search_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp0_ = synapse_data_sink_plugin_registry_get_default (), SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, "OpenSearch", _ ("Search the web."), "applications-internet", _synapse_open_search_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp0_);
}


static void synapse_open_search_plugin_load_xmls_data_free (gpointer _data) {
	SynapseOpenSearchPluginLoadXmlsData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseOpenSearchPluginLoadXmlsData, data);
}


static void synapse_open_search_plugin_load_xmls (SynapseOpenSearchPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseOpenSearchPluginLoadXmlsData* _data_;
	_data_ = g_slice_new0 (SynapseOpenSearchPluginLoadXmlsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_open_search_plugin_load_xmls);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_open_search_plugin_load_xmls_data_free);
	_data_->self = g_object_ref (self);
	synapse_open_search_plugin_load_xmls_co (_data_);
}


static void synapse_open_search_plugin_load_xmls_finish (SynapseOpenSearchPlugin* self, GAsyncResult* _res_) {
	SynapseOpenSearchPluginLoadXmlsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_open_search_plugin_load_xmls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseOpenSearchPluginLoadXmlsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_open_search_plugin_load_xmls_co (data);
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gboolean synapse_open_search_plugin_load_xmls_co (SynapseOpenSearchPluginLoadXmlsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 35:
		goto _state_35;
	}
	_state_0:
	if (synapse_open_search_plugin_config_get_use_internal (data->self->priv->config)) {
		data->internals = (GeeList*) gee_array_list_new (G_TYPE_STRING, NULL, NULL, NULL, NULL, NULL);
		gee_collection_add ((GeeCollection*) data->internals, SYNAPSE_GOOGLE_SEARCH_XML);
		gee_collection_add ((GeeCollection*) data->internals, SYNAPSE_GOOGLE_MAPS_XML);
		{
			data->_s_it = gee_iterable_iterator ((GeeIterable*) data->internals);
			while (TRUE) {
				if (!gee_iterator_next (data->_s_it)) {
					break;
				}
				data->s = (const char*) gee_iterator_get (data->_s_it);
				data->parser = (data->_tmp0_ = synapse_open_search_plugin_open_search_parser_new (), _g_object_unref0 (data->parser), data->_tmp0_);
				{
					synapse_open_search_plugin_open_search_parser_parse (data->parser, data->s, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						goto __catch28_g_error;
					}
					if (synapse_open_search_plugin_open_search_parser_has_valid_result (data->parser)) {
						gee_collection_add ((GeeCollection*) data->self->priv->actions, data->_tmp1_ = synapse_open_search_plugin_search_action_new (_ (synapse_open_search_plugin_open_search_parser_get_short_name (data->parser)), _ (synapse_open_search_plugin_open_search_parser_get_description (data->parser)), synapse_open_search_plugin_open_search_parser_get_query_url (data->parser)));
						_g_object_unref0 (data->_tmp1_);
					}
				}
				goto __finally28;
				__catch28_g_error:
				{
					data->no_way = data->_inner_error_;
					data->_inner_error_ = NULL;
					{
						_g_error_free0 (data->no_way);
					}
				}
				__finally28:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->_s_it);
					_g_object_unref0 (data->internals);
					_g_object_unref0 (data->parser);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (data->_s_it);
		}
		_g_object_unref0 (data->internals);
	}
	data->xmls = (data->_tmp4_ = (data->_tmp3_ = synapse_open_search_plugin_config_get_search_engines (data->self->priv->config, &data->_tmp2_), (data->_tmp3_ == NULL) ? ((gpointer) data->_tmp3_) : _vala_array_dup1 (data->_tmp3_, data->_tmp2_)), data->xmls_length1 = data->_tmp2_, data->_xmls_size_ = data->xmls_length1, data->_tmp4_);
	{
		data->xml_collection = data->xmls;
		data->xml_collection_length1 = data->xmls_length1;
		for (data->xml_it = 0; data->xml_it < data->xmls_length1; data->xml_it = data->xml_it + 1) {
			data->xml = data->xml_collection[data->xml_it];
			{
				data->xml_path = g_strdup (data->xml);
				if (g_str_has_prefix (data->xml_path, "~")) {
					data->xml_path = (data->_tmp6_ = g_strconcat (g_get_home_dir (), data->_tmp5_ = string_substring (data->xml_path, (glong) 1, -1), NULL), _g_free0 (data->xml_path), data->_tmp6_);
					_g_free0 (data->_tmp5_);
				}
				data->f = g_file_new_for_path (data->xml_path);
				{
					data->_tmp7_ = NULL;
					data->_state_ = 35;
					g_file_load_contents_async (data->f, NULL, synapse_open_search_plugin_load_xmls_ready, data);
					return FALSE;
					_state_35:
					g_file_load_contents_finish (data->f, data->_res_, &data->_tmp7_, &data->len, NULL, &data->_inner_error_);
					data->contents = (data->_tmp8_ = data->_tmp7_, _g_free0 (data->contents), data->_tmp8_);
					if (data->_inner_error_ != NULL) {
						_g_free0 (data->contents);
						goto __catch29_g_error;
					}
					data->parser = (data->_tmp9_ = synapse_open_search_plugin_open_search_parser_new (), _g_object_unref0 (data->parser), data->_tmp9_);
					synapse_open_search_plugin_open_search_parser_parse (data->parser, data->contents, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						_g_free0 (data->contents);
						goto __catch29_g_error;
					}
					if (synapse_open_search_plugin_open_search_parser_has_valid_result (data->parser)) {
						gee_collection_add ((GeeCollection*) data->self->priv->actions, data->_tmp10_ = synapse_open_search_plugin_search_action_new (synapse_open_search_plugin_open_search_parser_get_short_name (data->parser), synapse_open_search_plugin_open_search_parser_get_description (data->parser), synapse_open_search_plugin_open_search_parser_get_query_url (data->parser)));
						_g_object_unref0 (data->_tmp10_);
					} else {
						g_warning ("opensearch.vala:328: Unable to parse search plugin [%s]", data->xml);
					}
					_g_free0 (data->contents);
				}
				goto __finally29;
				__catch29_g_error:
				{
					data->err = data->_inner_error_;
					data->_inner_error_ = NULL;
					{
						g_warning ("opensearch.vala:332: Unable to load search plugin [%s]: %s", data->xml, data->err->message);
						_g_error_free0 (data->err);
					}
				}
				__finally29:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->f);
					_g_free0 (data->xml_path);
					data->xmls = (_vala_array_free (data->xmls, data->xmls_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (data->parser);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (data->f);
				_g_free0 (data->xml_path);
			}
		}
	}
	data->xmls = (_vala_array_free (data->xmls, data->xmls_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->parser);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gboolean synapse_open_search_plugin_real_handles_unknown (SynapseActionProvider* base) {
	SynapseOpenSearchPlugin * self;
	gboolean result = FALSE;
	self = (SynapseOpenSearchPlugin*) base;
	result = TRUE;
	return result;
}


static SynapseResultSet* synapse_open_search_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* query, SynapseMatch* match) {
	SynapseOpenSearchPlugin * self;
	SynapseResultSet* result = NULL;
	gboolean _tmp0_ = FALSE;
	SynapseQueryFlags my_flags;
	gboolean query_empty;
	SynapseResultSet* results;
	self = (SynapseOpenSearchPlugin*) base;
	g_return_val_if_fail (match != NULL, NULL);
	if (synapse_match_get_match_type (match) != SYNAPSE_MATCH_TYPE_UNKNOWN) {
		_tmp0_ = synapse_match_get_match_type (match) != SYNAPSE_MATCH_TYPE_TEXT;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	my_flags = SYNAPSE_QUERY_FLAGS_ACTIONS | SYNAPSE_QUERY_FLAGS_INTERNET;
	if (((*query).query_type & my_flags) == 0) {
		result = NULL;
		return result;
	}
	query_empty = _vala_strcmp0 ((*query).query_string, "") == 0;
	results = synapse_result_set_new ();
	if (query_empty) {
		{
			GeeIterator* _action_it;
			_action_it = gee_iterable_iterator ((GeeIterable*) self->priv->actions);
			while (TRUE) {
				SynapseOpenSearchPluginSearchAction* action;
				if (!gee_iterator_next (_action_it)) {
					break;
				}
				action = (SynapseOpenSearchPluginSearchAction*) gee_iterator_get (_action_it);
				synapse_result_set_add (results, (SynapseMatch*) action, synapse_open_search_plugin_search_action_get_default_relevancy (action));
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_it);
		}
	} else {
		GeeList* matchers;
		matchers = synapse_query_get_matchers_for_query ((*query).query_string, 0, G_REGEX_CASELESS);
		{
			GeeIterator* _item_it;
			_item_it = gee_iterable_iterator ((GeeIterable*) self->priv->actions);
			while (TRUE) {
				SynapseOpenSearchPluginSearchAction* item;
				if (!gee_iterator_next (_item_it)) {
					break;
				}
				item = (SynapseOpenSearchPluginSearchAction*) gee_iterator_get (_item_it);
				{
					GeeIterator* _matcher_it;
					_matcher_it = gee_iterable_iterator ((GeeIterable*) matchers);
					while (TRUE) {
						GeeMapEntry* matcher;
						if (!gee_iterator_next (_matcher_it)) {
							break;
						}
						matcher = (GeeMapEntry*) gee_iterator_get (_matcher_it);
						if (g_regex_match ((GRegex*) gee_map_entry_get_key (matcher), synapse_match_get_title ((SynapseMatch*) item), 0, NULL)) {
							synapse_result_set_add (results, (SynapseMatch*) item, GPOINTER_TO_INT (gee_map_entry_get_value (matcher)));
							_g_object_unref0 (matcher);
							break;
						}
						_g_object_unref0 (matcher);
					}
					_g_object_unref0 (_matcher_it);
				}
				_g_object_unref0 (item);
			}
			_g_object_unref0 (_item_it);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


SynapseOpenSearchPlugin* synapse_open_search_plugin_construct (GType object_type) {
	SynapseOpenSearchPlugin * self = NULL;
	self = (SynapseOpenSearchPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseOpenSearchPlugin* synapse_open_search_plugin_new (void) {
	return synapse_open_search_plugin_construct (SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN);
}


static gboolean synapse_open_search_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseOpenSearchPlugin* self;
	self = (SynapseOpenSearchPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_open_search_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseOpenSearchPlugin* self;
	self = (SynapseOpenSearchPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_open_search_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseOpenSearchPlugin * self;
	parent_class = G_OBJECT_CLASS (synapse_open_search_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_OPEN_SEARCH_PLUGIN (obj);
	{
		SynapseConfigService* cs;
		SynapseOpenSearchPluginConfig* _tmp0_;
		cs = synapse_config_service_get_default ();
		self->priv->config = (_tmp0_ = SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG (synapse_config_service_get_config (cs, "plugins", "opensearch", SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG)), _g_object_unref0 (self->priv->config), _tmp0_);
		_g_object_unref0 (cs);
	}
	return obj;
}


static void _synapse_open_search_plugin_open_search_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const char* element_name, char** attribute_names, char** attribute_values, gpointer self, GError** error) {
	synapse_open_search_plugin_open_search_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _synapse_open_search_plugin_open_search_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const char* element_name, gpointer self, GError** error) {
	synapse_open_search_plugin_open_search_parser_end (self, context, element_name, error);
}


static void _synapse_open_search_plugin_open_search_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const char* text, gsize text_len, gpointer self, GError** error) {
	synapse_open_search_plugin_open_search_parser_text (self, context, text, text_len, error);
}


static gboolean synapse_open_search_plugin_open_search_parser_parse (SynapseOpenSearchPluginOpenSearchParser* self, const char* content, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (content != NULL, FALSE);
	_tmp0_ = g_markup_parse_context_parse (self->priv->context, content, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_MARKUP_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


static gboolean synapse_open_search_plugin_open_search_parser_has_valid_result (SynapseOpenSearchPluginOpenSearchParser* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->is_opensearch) {
		_tmp2_ = self->priv->has_name;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->has_desc;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->has_url;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void synapse_open_search_plugin_open_search_parser_process_url (SynapseOpenSearchPluginOpenSearchParser* self, char** attrs, int attrs_length1, char** vals, int vals_length1) {
	guint len;
	gboolean main_type;
	gboolean suggestion_type;
	g_return_if_fail (self != NULL);
	len = g_strv_length (attrs);
	main_type = FALSE;
	suggestion_type = FALSE;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				const char* _tmp1_;
				GQuark _tmp2_;
				static GQuark _tmp2__label0 = 0;
				static GQuark _tmp2__label1 = 0;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < len)) {
					break;
				}
				_tmp1_ = attrs[i];
				_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
				if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("type"))))
				switch (0) {
					default:
					{
						if (_vala_strcmp0 (vals[i], "text/html") == 0) {
							main_type = TRUE;
						} else {
							if (_vala_strcmp0 (vals[i], "application/x-suggestions+json") == 0) {
								suggestion_type = TRUE;
							}
						}
						break;
					}
				} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("template"))))
				switch (0) {
					default:
					{
						if (main_type) {
							synapse_open_search_plugin_open_search_parser_set_query_url (self, vals[i]);
							self->priv->has_url = TRUE;
						} else {
							if (suggestion_type) {
								synapse_open_search_plugin_open_search_parser_set_suggestion_url (self, vals[i]);
							}
						}
						break;
					}
				} else
				switch (0) {
					default:
					{
						break;
					}
				}
			}
		}
	}
}


static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_vala_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void synapse_open_search_plugin_open_search_parser_start (SynapseOpenSearchPluginOpenSearchParser* self, GMarkupParseContext* ctx, const char* name, char** attr_names, int attr_names_length1, char** attr_vals, int attr_vals_length1, GError** error) {
	const char* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	static GQuark _tmp1__label5 = 0;
	static GQuark _tmp1__label6 = 0;
	static GQuark _tmp1__label7 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("SearchPlugin"))))
	switch (0) {
		default:
		{
			if (_vala_string_array_contains (attr_names, attr_names_length1, "xmlns:os")) {
				self->priv->is_opensearch = TRUE;
			}
			break;
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("OpenSearchDescription"))))
	switch (0) {
		default:
		{
			self->priv->is_opensearch = TRUE;
			break;
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("os:ShortName")))) || (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("ShortName")))))
	switch (0) {
		default:
		{
			self->priv->has_name = TRUE;
			self->priv->in_name_elem = TRUE;
			break;
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("os:Description")))) || (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("Description")))))
	switch (0) {
		default:
		{
			self->priv->has_desc = TRUE;
			self->priv->in_description_elem = TRUE;
			break;
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label6) ? _tmp1__label6 : (_tmp1__label6 = g_quark_from_static_string ("os:Url")))) || (_tmp1_ == ((0 != _tmp1__label7) ? _tmp1__label7 : (_tmp1__label7 = g_quark_from_static_string ("Url")))))
	switch (0) {
		default:
		{
			synapse_open_search_plugin_open_search_parser_process_url (self, attr_names, attr_names_length1, attr_vals, attr_vals_length1);
			break;
		}
	} else
	switch (0) {
		default:
		{
			break;
		}
	}
}


static void synapse_open_search_plugin_open_search_parser_end (SynapseOpenSearchPluginOpenSearchParser* self, GMarkupParseContext* ctx, const char* name, GError** error) {
	const char* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("os:ShortName")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("ShortName")))))
	switch (0) {
		default:
		{
			self->priv->in_name_elem = FALSE;
			break;
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("os:Description")))) || (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("Description")))))
	switch (0) {
		default:
		{
			self->priv->in_description_elem = FALSE;
			break;
		}
	} else
	switch (0) {
		default:
		{
			break;
		}
	}
}


static void synapse_open_search_plugin_open_search_parser_text (SynapseOpenSearchPluginOpenSearchParser* self, GMarkupParseContext* ctx, const char* text, gsize text_len, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->in_name_elem) {
		synapse_open_search_plugin_open_search_parser_set_short_name (self, text);
	} else {
		if (self->priv->in_description_elem) {
			synapse_open_search_plugin_open_search_parser_set_description (self, text);
		}
	}
}


static SynapseOpenSearchPluginOpenSearchParser* synapse_open_search_plugin_open_search_parser_construct (GType object_type) {
	SynapseOpenSearchPluginOpenSearchParser * self = NULL;
	self = (SynapseOpenSearchPluginOpenSearchParser*) g_object_new (object_type, NULL);
	return self;
}


static SynapseOpenSearchPluginOpenSearchParser* synapse_open_search_plugin_open_search_parser_new (void) {
	return synapse_open_search_plugin_open_search_parser_construct (SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER);
}


static const char* synapse_open_search_plugin_open_search_parser_get_short_name (SynapseOpenSearchPluginOpenSearchParser* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_short_name;
	return result;
}


static void synapse_open_search_plugin_open_search_parser_set_short_name (SynapseOpenSearchPluginOpenSearchParser* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_short_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_short_name), _tmp0_);
	g_object_notify ((GObject *) self, "short-name");
}


static const char* synapse_open_search_plugin_open_search_parser_get_description (SynapseOpenSearchPluginOpenSearchParser* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_description;
	return result;
}


static void synapse_open_search_plugin_open_search_parser_set_description (SynapseOpenSearchPluginOpenSearchParser* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


static const char* synapse_open_search_plugin_open_search_parser_get_query_url (SynapseOpenSearchPluginOpenSearchParser* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_query_url;
	return result;
}


static void synapse_open_search_plugin_open_search_parser_set_query_url (SynapseOpenSearchPluginOpenSearchParser* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_query_url = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_query_url), _tmp0_);
	g_object_notify ((GObject *) self, "query-url");
}


static const char* synapse_open_search_plugin_open_search_parser_get_suggestion_url (SynapseOpenSearchPluginOpenSearchParser* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_suggestion_url;
	return result;
}


static void synapse_open_search_plugin_open_search_parser_set_suggestion_url (SynapseOpenSearchPluginOpenSearchParser* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_suggestion_url = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_suggestion_url), _tmp0_);
	g_object_notify ((GObject *) self, "suggestion-url");
}


static GObject * synapse_open_search_plugin_open_search_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseOpenSearchPluginOpenSearchParser * self;
	parent_class = G_OBJECT_CLASS (synapse_open_search_plugin_open_search_parser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER (obj);
	{
		GMarkupParseContext* _tmp0_;
		self->priv->context = (_tmp0_ = g_markup_parse_context_new (&SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_parser, 0, self, NULL), _g_markup_parse_context_free0 (self->priv->context), _tmp0_);
	}
	return obj;
}


static void synapse_open_search_plugin_open_search_parser_class_init (SynapseOpenSearchPluginOpenSearchParserClass * klass) {
	synapse_open_search_plugin_open_search_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseOpenSearchPluginOpenSearchParserPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_open_search_plugin_open_search_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_open_search_plugin_open_search_parser_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_open_search_plugin_open_search_parser_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_open_search_plugin_open_search_parser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME, g_param_spec_string ("short-name", "short-name", "short-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL, g_param_spec_string ("query-url", "query-url", "query-url", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL, g_param_spec_string ("suggestion-url", "suggestion-url", "suggestion-url", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_open_search_plugin_open_search_parser_instance_init (SynapseOpenSearchPluginOpenSearchParser * self) {
	self->priv = SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_GET_PRIVATE (self);
	self->priv->is_opensearch = FALSE;
	self->priv->in_name_elem = FALSE;
	self->priv->in_description_elem = FALSE;
	self->priv->has_name = FALSE;
	self->priv->has_desc = FALSE;
	self->priv->has_url = FALSE;
}


static void synapse_open_search_plugin_open_search_parser_finalize (GObject* obj) {
	SynapseOpenSearchPluginOpenSearchParser * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER (obj);
	_g_markup_parse_context_free0 (self->priv->context);
	_g_free0 (self->priv->_short_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_query_url);
	_g_free0 (self->priv->_suggestion_url);
	G_OBJECT_CLASS (synapse_open_search_plugin_open_search_parser_parent_class)->finalize (obj);
}


static GType synapse_open_search_plugin_open_search_parser_get_type (void) {
	static volatile gsize synapse_open_search_plugin_open_search_parser_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_open_search_plugin_open_search_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseOpenSearchPluginOpenSearchParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_open_search_plugin_open_search_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseOpenSearchPluginOpenSearchParser), 0, (GInstanceInitFunc) synapse_open_search_plugin_open_search_parser_instance_init, NULL };
		GType synapse_open_search_plugin_open_search_parser_type_id;
		synapse_open_search_plugin_open_search_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseOpenSearchPluginOpenSearchParser", &g_define_type_info, 0);
		g_once_init_leave (&synapse_open_search_plugin_open_search_parser_type_id__volatile, synapse_open_search_plugin_open_search_parser_type_id);
	}
	return synapse_open_search_plugin_open_search_parser_type_id__volatile;
}


static void synapse_open_search_plugin_open_search_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseOpenSearchPluginOpenSearchParser * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER (object);
	switch (property_id) {
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME:
		g_value_set_string (value, synapse_open_search_plugin_open_search_parser_get_short_name (self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION:
		g_value_set_string (value, synapse_open_search_plugin_open_search_parser_get_description (self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL:
		g_value_set_string (value, synapse_open_search_plugin_open_search_parser_get_query_url (self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL:
		g_value_set_string (value, synapse_open_search_plugin_open_search_parser_get_suggestion_url (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_open_search_plugin_open_search_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseOpenSearchPluginOpenSearchParser * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER (object);
	switch (property_id) {
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME:
		synapse_open_search_plugin_open_search_parser_set_short_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION:
		synapse_open_search_plugin_open_search_parser_set_description (self, g_value_get_string (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL:
		synapse_open_search_plugin_open_search_parser_set_query_url (self, g_value_get_string (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL:
		synapse_open_search_plugin_open_search_parser_set_suggestion_url (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_open_search_plugin_search_action_real_execute (SynapseMatch* base, SynapseMatch* match) {
	SynapseOpenSearchPluginSearchAction * self;
	GError * _inner_error_ = NULL;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	{
		char* _tmp0_;
		char* what;
		char* _tmp4_;
		GdkAppLaunchContext* _tmp5_;
		_tmp0_ = NULL;
		if (SYNAPSE_IS_TEXT_MATCH (match)) {
			SynapseMatch* _tmp1_;
			char* _tmp2_;
			_tmp0_ = (_tmp2_ = synapse_text_match_get_text ((_tmp1_ = match, SYNAPSE_IS_TEXT_MATCH (_tmp1_) ? ((SynapseTextMatch*) _tmp1_) : NULL)), _g_free0 (_tmp0_), _tmp2_);
		} else {
			char* _tmp3_;
			_tmp0_ = (_tmp3_ = g_strdup (synapse_match_get_title (match)), _g_free0 (_tmp0_), _tmp3_);
		}
		what = g_strdup (_tmp0_);
		g_app_info_launch_default_for_uri (_tmp4_ = synapse_open_search_plugin_search_action_get_query_url (self, what), (GAppLaunchContext*) (_tmp5_ = gdk_app_launch_context_new ()), &_inner_error_);
		_g_object_unref0 (_tmp5_);
		_g_free0 (_tmp4_);
		if (_inner_error_ != NULL) {
			_g_free0 (what);
			_g_free0 (_tmp0_);
			goto __catch30_g_error;
		}
		_g_free0 (what);
		_g_free0 (_tmp0_);
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("opensearch.vala:190: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally30:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally31;
	__catch31_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static char* synapse_open_search_plugin_search_action_get_query_url (SynapseOpenSearchPluginSearchAction* self, const char* query) {
	char* result = NULL;
	char* _result_;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_result_ = NULL;
	_result_ = (_tmp1_ = string_replace (self->priv->_query_template, "{searchTerms}", _tmp0_ = g_uri_escape_string (query, "", FALSE)), _g_free0 (_result_), _tmp1_);
	_g_free0 (_tmp0_);
	_result_ = (_tmp3_ = string_replace (_result_, "{language}", _tmp2_ = synapse_open_search_plugin_search_action_get_lang (self)), _g_free0 (_result_), _tmp3_);
	_g_free0 (_tmp2_);
	result = _result_;
	return result;
}


static char* synapse_open_search_plugin_search_action_get_lang (SynapseOpenSearchPluginSearchAction* self) {
	char* result = NULL;
	char* _result_;
	char* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	{
		char** _tmp0_;
		char** lang_collection;
		int lang_collection_length1;
		int lang_it;
		lang_collection = _tmp0_ = g_get_language_names ();
		lang_collection_length1 = _vala_array_length (_tmp0_);
		for (lang_it = 0; lang_it < _vala_array_length (_tmp0_); lang_it = lang_it + 1) {
			const char* lang;
			lang = lang_collection[lang_it];
			{
				if (string_get_length (lang) == 2) {
					char* _tmp1_;
					_result_ = (_tmp1_ = g_strdup (lang), _g_free0 (_result_), _tmp1_);
					break;
				}
			}
		}
	}
	_tmp2_ = g_strdup (_result_);
	if (_tmp2_ == NULL) {
		char* _tmp3_;
		_tmp2_ = (_tmp3_ = g_strdup ("en"), _g_free0 (_tmp2_), _tmp3_);
	}
	result = _tmp2_;
	_g_free0 (_result_);
	return result;
}


static SynapseOpenSearchPluginSearchAction* synapse_open_search_plugin_search_action_construct (GType object_type, const char* name, const char* description, const char* url) {
	SynapseOpenSearchPluginSearchAction * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	self = (SynapseOpenSearchPluginSearchAction*) g_object_new (object_type, "title", name, "description", description, "query-template", url, "has-thumbnail", FALSE, "icon-name", "applications-internet", NULL);
	return self;
}


static SynapseOpenSearchPluginSearchAction* synapse_open_search_plugin_search_action_new (const char* name, const char* description, const char* url) {
	return synapse_open_search_plugin_search_action_construct (SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, name, description, url);
}


static const char* synapse_open_search_plugin_search_action_real_get_title (SynapseMatch* base) {
	const char* result;
	SynapseOpenSearchPluginSearchAction* self;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_open_search_plugin_search_action_real_set_title (SynapseMatch* base, const char* value) {
	SynapseOpenSearchPluginSearchAction* self;
	char* _tmp0_;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	self->priv->_title = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_title), _tmp0_);
	g_object_notify ((GObject *) self, "title");
}


static const char* synapse_open_search_plugin_search_action_real_get_description (SynapseMatch* base) {
	const char* result;
	SynapseOpenSearchPluginSearchAction* self;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_open_search_plugin_search_action_real_set_description (SynapseMatch* base, const char* value) {
	SynapseOpenSearchPluginSearchAction* self;
	char* _tmp0_;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


static const char* synapse_open_search_plugin_search_action_real_get_icon_name (SynapseMatch* base) {
	const char* result;
	SynapseOpenSearchPluginSearchAction* self;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_open_search_plugin_search_action_real_set_icon_name (SynapseMatch* base, const char* value) {
	SynapseOpenSearchPluginSearchAction* self;
	char* _tmp0_;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_open_search_plugin_search_action_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseOpenSearchPluginSearchAction* self;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_open_search_plugin_search_action_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseOpenSearchPluginSearchAction* self;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const char* synapse_open_search_plugin_search_action_real_get_thumbnail_path (SynapseMatch* base) {
	const char* result;
	SynapseOpenSearchPluginSearchAction* self;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_open_search_plugin_search_action_real_set_thumbnail_path (SynapseMatch* base, const char* value) {
	SynapseOpenSearchPluginSearchAction* self;
	char* _tmp0_;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	self->priv->_thumbnail_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_thumbnail_path), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_open_search_plugin_search_action_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseOpenSearchPluginSearchAction* self;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_open_search_plugin_search_action_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseOpenSearchPluginSearchAction* self;
	self = (SynapseOpenSearchPluginSearchAction*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static gint synapse_open_search_plugin_search_action_get_default_relevancy (SynapseOpenSearchPluginSearchAction* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}


static void synapse_open_search_plugin_search_action_set_default_relevancy (SynapseOpenSearchPluginSearchAction* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_default_relevancy = value;
	g_object_notify ((GObject *) self, "default-relevancy");
}


static const char* synapse_open_search_plugin_search_action_get_query_template (SynapseOpenSearchPluginSearchAction* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_query_template;
	return result;
}


static void synapse_open_search_plugin_search_action_set_query_template (SynapseOpenSearchPluginSearchAction* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_query_template = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_query_template), _tmp0_);
	g_object_notify ((GObject *) self, "query-template");
}


static void synapse_open_search_plugin_search_action_class_init (SynapseOpenSearchPluginSearchActionClass * klass) {
	synapse_open_search_plugin_search_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseOpenSearchPluginSearchActionPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_open_search_plugin_search_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_open_search_plugin_search_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_open_search_plugin_search_action_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_MATCH_TYPE, "match-type");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY, g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE, g_param_spec_string ("query-template", "query-template", "query-template", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void synapse_open_search_plugin_search_action_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_open_search_plugin_search_action_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->execute = synapse_open_search_plugin_search_action_real_execute;
	iface->get_title = synapse_open_search_plugin_search_action_real_get_title;
	iface->set_title = synapse_open_search_plugin_search_action_real_set_title;
	iface->get_description = synapse_open_search_plugin_search_action_real_get_description;
	iface->set_description = synapse_open_search_plugin_search_action_real_set_description;
	iface->get_icon_name = synapse_open_search_plugin_search_action_real_get_icon_name;
	iface->set_icon_name = synapse_open_search_plugin_search_action_real_set_icon_name;
	iface->get_has_thumbnail = synapse_open_search_plugin_search_action_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_open_search_plugin_search_action_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_open_search_plugin_search_action_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_open_search_plugin_search_action_real_set_thumbnail_path;
	iface->get_match_type = synapse_open_search_plugin_search_action_real_get_match_type;
	iface->set_match_type = synapse_open_search_plugin_search_action_real_set_match_type;
}


static void synapse_open_search_plugin_search_action_instance_init (SynapseOpenSearchPluginSearchAction * self) {
	self->priv = SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_GET_PRIVATE (self);
	self->priv->_default_relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR;
}


static void synapse_open_search_plugin_search_action_finalize (GObject* obj) {
	SynapseOpenSearchPluginSearchAction * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_query_template);
	G_OBJECT_CLASS (synapse_open_search_plugin_search_action_parent_class)->finalize (obj);
}


static GType synapse_open_search_plugin_search_action_get_type (void) {
	static volatile gsize synapse_open_search_plugin_search_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_open_search_plugin_search_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseOpenSearchPluginSearchActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_open_search_plugin_search_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseOpenSearchPluginSearchAction), 0, (GInstanceInitFunc) synapse_open_search_plugin_search_action_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_open_search_plugin_search_action_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_open_search_plugin_search_action_type_id;
		synapse_open_search_plugin_search_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseOpenSearchPluginSearchAction", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_open_search_plugin_search_action_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_once_init_leave (&synapse_open_search_plugin_search_action_type_id__volatile, synapse_open_search_plugin_search_action_type_id);
	}
	return synapse_open_search_plugin_search_action_type_id__volatile;
}


static void synapse_open_search_plugin_search_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseOpenSearchPluginSearchAction * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION (object);
	switch (property_id) {
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY:
		g_value_set_int (value, synapse_open_search_plugin_search_action_get_default_relevancy (self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE:
		g_value_set_string (value, synapse_open_search_plugin_search_action_get_query_template (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_open_search_plugin_search_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseOpenSearchPluginSearchAction * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION (object);
	switch (property_id) {
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY:
		synapse_open_search_plugin_search_action_set_default_relevancy (self, g_value_get_int (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE:
		synapse_open_search_plugin_search_action_set_query_template (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static SynapseOpenSearchPluginConfig* synapse_open_search_plugin_config_construct (GType object_type) {
	SynapseOpenSearchPluginConfig * self = NULL;
	self = (SynapseOpenSearchPluginConfig*) synapse_config_object_construct (object_type);
	return self;
}


static SynapseOpenSearchPluginConfig* synapse_open_search_plugin_config_new (void) {
	return synapse_open_search_plugin_config_construct (SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG);
}


static gboolean synapse_open_search_plugin_config_get_use_internal (SynapseOpenSearchPluginConfig* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_internal;
	return result;
}


static void synapse_open_search_plugin_config_set_use_internal (SynapseOpenSearchPluginConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_use_internal = value;
	g_object_notify ((GObject *) self, "use-internal");
}


static char** synapse_open_search_plugin_config_get_search_engines (SynapseOpenSearchPluginConfig* self, int* result_length1) {
	char** result;
	char** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp0_ = self->priv->_search_engines, *result_length1 = self->priv->_search_engines_length1, _tmp0_);
	return result;
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void synapse_open_search_plugin_config_set_search_engines (SynapseOpenSearchPluginConfig* self, char** value, int value_length1) {
	char** _tmp0_;
	char** _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_search_engines = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup2 (_tmp0_, value_length1)), self->priv->_search_engines = (_vala_array_free (self->priv->_search_engines, self->priv->_search_engines_length1, (GDestroyNotify) g_free), NULL), self->priv->_search_engines_length1 = value_length1, self->priv->__search_engines_size_ = self->priv->_search_engines_length1, _tmp1_);
	g_object_notify ((GObject *) self, "search-engines");
}


static void synapse_open_search_plugin_config_class_init (SynapseOpenSearchPluginConfigClass * klass) {
	synapse_open_search_plugin_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseOpenSearchPluginConfigPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_open_search_plugin_config_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_open_search_plugin_config_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_open_search_plugin_config_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL, g_param_spec_boolean ("use-internal", "use-internal", "use-internal", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES, g_param_spec_boxed ("search-engines", "search-engines", "search-engines", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_open_search_plugin_config_instance_init (SynapseOpenSearchPluginConfig * self) {
	self->priv = SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_GET_PRIVATE (self);
	self->priv->_use_internal = TRUE;
}


static void synapse_open_search_plugin_config_finalize (GObject* obj) {
	SynapseOpenSearchPluginConfig * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG (obj);
	self->priv->_search_engines = (_vala_array_free (self->priv->_search_engines, self->priv->_search_engines_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (synapse_open_search_plugin_config_parent_class)->finalize (obj);
}


static GType synapse_open_search_plugin_config_get_type (void) {
	static volatile gsize synapse_open_search_plugin_config_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_open_search_plugin_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseOpenSearchPluginConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_open_search_plugin_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseOpenSearchPluginConfig), 0, (GInstanceInitFunc) synapse_open_search_plugin_config_instance_init, NULL };
		GType synapse_open_search_plugin_config_type_id;
		synapse_open_search_plugin_config_type_id = g_type_register_static (SYNAPSE_TYPE_CONFIG_OBJECT, "SynapseOpenSearchPluginConfig", &g_define_type_info, 0);
		g_once_init_leave (&synapse_open_search_plugin_config_type_id__volatile, synapse_open_search_plugin_config_type_id);
	}
	return synapse_open_search_plugin_config_type_id__volatile;
}


static void synapse_open_search_plugin_config_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseOpenSearchPluginConfig * self;
	int length;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG (object);
	switch (property_id) {
		case SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL:
		g_value_set_boolean (value, synapse_open_search_plugin_config_get_use_internal (self));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES:
		g_value_set_boxed (value, synapse_open_search_plugin_config_get_search_engines (self, &length));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_open_search_plugin_config_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseOpenSearchPluginConfig * self;
	gpointer boxed;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG (object);
	switch (property_id) {
		case SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL:
		synapse_open_search_plugin_config_set_use_internal (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES:
		boxed = g_value_get_boxed (value);
		synapse_open_search_plugin_config_set_search_engines (self, boxed, g_strv_length (boxed));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_open_search_plugin_class_init (SynapseOpenSearchPluginClass * klass) {
	synapse_open_search_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseOpenSearchPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_open_search_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_open_search_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_open_search_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_open_search_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED, "enabled");
	{
		const char* dummy;
		synapse_open_search_plugin_register_plugin ();
		dummy = NULL;
		dummy = N_ ("Google");
		dummy = N_ ("Search the web using google.com");
		dummy = N_ ("Google Maps");
		dummy = N_ ("Search using Google Maps");
	}
}


static void synapse_open_search_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_open_search_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = synapse_open_search_plugin_real_activate;
	iface->deactivate = synapse_open_search_plugin_real_deactivate;
	iface->get_enabled = synapse_open_search_plugin_real_get_enabled;
	iface->set_enabled = synapse_open_search_plugin_real_set_enabled;
}


static void synapse_open_search_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface) {
	synapse_open_search_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_unknown = synapse_open_search_plugin_real_handles_unknown;
	iface->find_for_match = synapse_open_search_plugin_real_find_for_match;
}


static void synapse_open_search_plugin_instance_init (SynapseOpenSearchPlugin * self) {
	self->priv = SYNAPSE_OPEN_SEARCH_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_open_search_plugin_finalize (GObject* obj) {
	SynapseOpenSearchPlugin * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN (obj);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->config);
	G_OBJECT_CLASS (synapse_open_search_plugin_parent_class)->finalize (obj);
}


GType synapse_open_search_plugin_get_type (void) {
	static volatile gsize synapse_open_search_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_open_search_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseOpenSearchPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_open_search_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseOpenSearchPlugin), 0, (GInstanceInitFunc) synapse_open_search_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_open_search_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_open_search_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_open_search_plugin_type_id;
		synapse_open_search_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseOpenSearchPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_open_search_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_open_search_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		g_once_init_leave (&synapse_open_search_plugin_type_id__volatile, synapse_open_search_plugin_type_id);
	}
	return synapse_open_search_plugin_type_id__volatile;
}


static void synapse_open_search_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseOpenSearchPlugin * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_open_search_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseOpenSearchPlugin * self;
	self = SYNAPSE_OPEN_SEARCH_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




