/* launchpad-plugin.c generated by valac 0.10.4, the Vala compiler
 * generated from launchpad-plugin.vala, do not modify */

/*
 * Copyright (C) 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define SYNAPSE_TYPE_LAUNCHPAD_PLUGIN (synapse_launchpad_plugin_get_type ())
#define SYNAPSE_LAUNCHPAD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, SynapseLaunchpadPlugin))
#define SYNAPSE_LAUNCHPAD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, SynapseLaunchpadPluginClass))
#define SYNAPSE_IS_LAUNCHPAD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN))
#define SYNAPSE_IS_LAUNCHPAD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN))
#define SYNAPSE_LAUNCHPAD_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, SynapseLaunchpadPluginClass))

typedef struct _SynapseLaunchpadPlugin SynapseLaunchpadPlugin;
typedef struct _SynapseLaunchpadPluginClass SynapseLaunchpadPluginClass;
typedef struct _SynapseLaunchpadPluginPrivate SynapseLaunchpadPluginPrivate;

#define SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT (synapse_launchpad_plugin_launchpad_auth_object_get_type ())
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT, SynapseLaunchpadPluginLaunchpadAuthObject))
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT, SynapseLaunchpadPluginLaunchpadAuthObjectClass))
#define SYNAPSE_LAUNCHPAD_PLUGIN_IS_LAUNCHPAD_AUTH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT))
#define SYNAPSE_LAUNCHPAD_PLUGIN_IS_LAUNCHPAD_AUTH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT))
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT, SynapseLaunchpadPluginLaunchpadAuthObjectClass))

typedef struct _SynapseLaunchpadPluginLaunchpadAuthObject SynapseLaunchpadPluginLaunchpadAuthObject;
typedef struct _SynapseLaunchpadPluginLaunchpadAuthObjectClass SynapseLaunchpadPluginLaunchpadAuthObjectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT (synapse_launchpad_plugin_launchpad_object_get_type ())
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, SynapseLaunchpadPluginLaunchpadObject))
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, SynapseLaunchpadPluginLaunchpadObjectClass))
#define SYNAPSE_LAUNCHPAD_PLUGIN_IS_LAUNCHPAD_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT))
#define SYNAPSE_LAUNCHPAD_PLUGIN_IS_LAUNCHPAD_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT))
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, SynapseLaunchpadPluginLaunchpadObjectClass))

typedef struct _SynapseLaunchpadPluginLaunchpadObject SynapseLaunchpadPluginLaunchpadObject;
typedef struct _SynapseLaunchpadPluginLaunchpadObjectClass SynapseLaunchpadPluginLaunchpadObjectClass;
typedef struct _SynapseLaunchpadPluginSearchData SynapseLaunchpadPluginSearchData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseLaunchpadPluginLaunchpadAuthObjectPrivate SynapseLaunchpadPluginLaunchpadAuthObjectPrivate;
typedef struct _SynapseLaunchpadPluginLaunchpadObjectPrivate SynapseLaunchpadPluginLaunchpadObjectPrivate;

struct _SynapseLaunchpadPlugin {
	GObject parent_instance;
	SynapseLaunchpadPluginPrivate * priv;
};

struct _SynapseLaunchpadPluginClass {
	GObjectClass parent_class;
};

struct _SynapseLaunchpadPluginPrivate {
	gboolean _enabled;
	SynapseLaunchpadPluginLaunchpadAuthObject* auth_object;
	GRegex* bug_regex;
	GRegex* branch_regex;
};

struct _SynapseLaunchpadPluginSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseLaunchpadPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	char* uri;
	char* title;
	char* description;
	SynapseResultSet* _result_;
	char* stripped;
	GMatchInfo* mi;
	char* branch;
	char** groups;
	char** _tmp3_;
	gint groups_length1;
	gint _groups_size_;
	char** _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	gboolean _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	SynapseLaunchpadPluginLaunchpadObject* _tmp15_;
	char* bug_num;
	char* _tmp19_;
	char* _tmp20_;
	char* _tmp21_;
	SynapseLaunchpadPluginLaunchpadObject* _tmp22_;
	GMatchInfo* _tmp16_;
	gboolean _tmp17_;
	GMatchInfo* _tmp18_;
	GMatchInfo* _tmp0_;
	gboolean _tmp1_;
	GMatchInfo* _tmp2_;
	GError * _inner_error_;
};

struct _SynapseLaunchpadPluginLaunchpadAuthObject {
	GObject parent_instance;
	SynapseLaunchpadPluginLaunchpadAuthObjectPrivate * priv;
};

struct _SynapseLaunchpadPluginLaunchpadAuthObjectClass {
	GObjectClass parent_class;
};

struct _SynapseLaunchpadPluginLaunchpadObject {
	GObject parent_instance;
	SynapseLaunchpadPluginLaunchpadObjectPrivate * priv;
};

struct _SynapseLaunchpadPluginLaunchpadObjectClass {
	GObjectClass parent_class;
};

struct _SynapseLaunchpadPluginLaunchpadObjectPrivate {
	char* _title;
	char* _description;
	char* _icon_name;
	gboolean _has_thumbnail;
	char* _thumbnail_path;
	SynapseMatchType _match_type;
	char* _uri;
	SynapseQueryFlags _file_type;
	char* _mime_type;
};


static gpointer synapse_launchpad_plugin_launchpad_auth_object_parent_class = NULL;
static gpointer synapse_launchpad_plugin_launchpad_object_parent_class = NULL;
static SynapseMatchIface* synapse_launchpad_plugin_launchpad_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface* synapse_launchpad_plugin_launchpad_object_synapse_uri_match_parent_iface = NULL;
static gpointer synapse_launchpad_plugin_parent_class = NULL;
static SynapseActivatableIface* synapse_launchpad_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_launchpad_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_launchpad_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_launchpad_plugin_launchpad_auth_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_LAUNCHPAD_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, SynapseLaunchpadPluginPrivate))
enum  {
	SYNAPSE_LAUNCHPAD_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_LAUNCHPAD_PLUGIN_ENABLED
};
static void synapse_launchpad_plugin_real_activate (SynapseActivatable* base);
static void synapse_launchpad_plugin_real_deactivate (SynapseActivatable* base);
GtkWidget* synapse_launchpad_plugin_create_config_widget (SynapseLaunchpadPlugin* self);
static void synapse_launchpad_plugin_register_plugin (void);
static void _synapse_launchpad_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_launchpad_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* q);
static void synapse_launchpad_plugin_real_search_data_free (gpointer _data);
static void synapse_launchpad_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_launchpad_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_launchpad_plugin_real_search_co (SynapseLaunchpadPluginSearchData* data);
static SynapseLaunchpadPluginLaunchpadObject* synapse_launchpad_plugin_launchpad_object_new (const char* title, const char* desc, const char* uri);
static SynapseLaunchpadPluginLaunchpadObject* synapse_launchpad_plugin_launchpad_object_construct (GType object_type, const char* title, const char* desc, const char* uri);
static GType synapse_launchpad_plugin_launchpad_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
SynapseResultSet* synapse_launchpad_plugin_find_for_match (SynapseLaunchpadPlugin* self, SynapseQuery* query, SynapseMatch* match);
SynapseLaunchpadPlugin* synapse_launchpad_plugin_new (void);
SynapseLaunchpadPlugin* synapse_launchpad_plugin_construct (GType object_type);
static GObject * synapse_launchpad_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT_DUMMY_PROPERTY
};
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_AUTH_OBJECT_CONSUMER_KEY "Synapse.LaunchpadPlugin"
static SynapseLaunchpadPluginLaunchpadAuthObject* synapse_launchpad_plugin_launchpad_auth_object_new (void);
static SynapseLaunchpadPluginLaunchpadAuthObject* synapse_launchpad_plugin_launchpad_auth_object_construct (GType object_type);
#define SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, SynapseLaunchpadPluginLaunchpadObjectPrivate))
enum  {
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_TITLE,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DESCRIPTION,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_ICON_NAME,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MATCH_TYPE,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_URI,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_FILE_TYPE,
	SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MIME_TYPE
};
static void synapse_launchpad_plugin_launchpad_object_finalize (GObject* obj);
static void synapse_launchpad_plugin_launchpad_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_launchpad_plugin_launchpad_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_launchpad_plugin_finalize (GObject* obj);
static void synapse_launchpad_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_launchpad_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void synapse_launchpad_plugin_real_activate (SynapseActivatable* base) {
	SynapseLaunchpadPlugin * self;
	self = (SynapseLaunchpadPlugin*) base;
}


static void synapse_launchpad_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseLaunchpadPlugin * self;
	SynapseLaunchpadPluginLaunchpadAuthObject* _tmp0_;
	self = (SynapseLaunchpadPlugin*) base;
	self->priv->auth_object = (_tmp0_ = NULL, _g_object_unref0 (self->priv->auth_object), _tmp0_);
}


GtkWidget* synapse_launchpad_plugin_create_config_widget (SynapseLaunchpadPlugin* self) {
	GtkWidget* result = NULL;
	GtkVBox* box;
	GtkButton* authorize_button;
	GtkSpinner* spinner;
	GtkLabel* label;
	GtkButton* proceed_button;
	g_return_val_if_fail (self != NULL, NULL);
	box = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_widget_show ((GtkWidget*) box);
	authorize_button = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Authorize with Launchpad")));
	gtk_widget_show ((GtkWidget*) authorize_button);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) authorize_button, TRUE, FALSE, 0);
	spinner = g_object_ref_sink ((GtkSpinner*) gtk_spinner_new ());
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) spinner, TRUE, TRUE, 0);
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Please press the Finish button once you login to Launchpad with your w" \
"eb browser")));
	gtk_label_set_width_chars (label, 40);
	gtk_label_set_line_wrap (label, TRUE);
	proceed_button = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Finish authorization")));
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, 0);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) proceed_button, TRUE, FALSE, 0);
	result = (GtkWidget*) box;
	_g_object_unref0 (proceed_button);
	_g_object_unref0 (label);
	_g_object_unref0 (spinner);
	_g_object_unref0 (authorize_button);
	return result;
}


static void _synapse_launchpad_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_launchpad_plugin_register_plugin ();
}


static void synapse_launchpad_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp0_ = synapse_data_sink_plugin_registry_get_default (), SYNAPSE_TYPE_LAUNCHPAD_PLUGIN, "Launchpad", _ ("Find bugs and branches on Launchpad."), "applications-internet", _synapse_launchpad_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp0_);
}


static gboolean synapse_launchpad_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* q) {
	SynapseLaunchpadPlugin * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (SynapseLaunchpadPlugin*) base;
	if (((*q).query_type & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = ((*q).query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
	}
	result = _tmp0_;
	return result;
}


static void synapse_launchpad_plugin_real_search_data_free (gpointer _data) {
	SynapseLaunchpadPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (SynapseLaunchpadPluginSearchData, data);
}


static void synapse_launchpad_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseLaunchpadPlugin * self;
	SynapseLaunchpadPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseLaunchpadPlugin*) base;
	_data_ = g_slice_new0 (SynapseLaunchpadPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_launchpad_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_launchpad_plugin_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	synapse_launchpad_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_launchpad_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseLaunchpadPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_launchpad_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseLaunchpadPluginSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_launchpad_plugin_real_search_co (data);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean synapse_launchpad_plugin_real_search_co (SynapseLaunchpadPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->uri = NULL;
	data->title = NULL;
	data->description = NULL;
	data->_result_ = synapse_result_set_new ();
	data->stripped = string_strip (data->q.query_string);
	if (_vala_strcmp0 (data->stripped, "") == 0) {
		data->result = NULL;
		_g_free0 (data->stripped);
		_g_object_unref0 (data->_result_);
		_g_free0 (data->description);
		_g_free0 (data->title);
		_g_free0 (data->uri);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_tmp0_ = NULL;
	if ((data->_tmp1_ = g_regex_match (data->self->priv->branch_regex, data->stripped, 0, &data->_tmp0_), data->mi = (data->_tmp2_ = data->_tmp0_, _g_match_info_free0 (data->mi), data->_tmp2_), data->_tmp1_)) {
		data->branch = g_match_info_fetch (data->mi, 1);
		data->groups = (data->_tmp4_ = data->_tmp3_ = g_strsplit (data->branch, "/", 0), data->groups_length1 = _vala_array_length (data->_tmp3_), data->_groups_size_ = data->groups_length1, data->_tmp4_);
		if (data->groups_length1 == 1) {
			data->uri = (data->_tmp5_ = g_strconcat ("https://code.launchpad.net/", data->branch, NULL), _g_free0 (data->uri), data->_tmp5_);
			data->title = (data->_tmp6_ = g_strdup_printf (_ ("Launchpad: Bazaar branches for %s"), data->branch), _g_free0 (data->title), data->_tmp6_);
			data->description = (data->_tmp7_ = g_strdup (data->uri), _g_free0 (data->description), data->_tmp7_);
		} else {
			if (data->groups_length1 == 2) {
				data->_tmp8_ = !g_str_has_prefix (data->branch, "~");
			} else {
				data->_tmp8_ = FALSE;
			}
			if (data->_tmp8_) {
				data->uri = (data->_tmp9_ = g_strconcat ("https://code.launchpad.net/", data->branch, NULL), _g_free0 (data->uri), data->_tmp9_);
				data->title = (data->_tmp10_ = g_strdup_printf (_ ("Launchpad: Series %s for Project %s"), data->groups[1], data->groups[0]), _g_free0 (data->title), data->_tmp10_);
				data->description = (data->_tmp11_ = g_strdup (data->uri), _g_free0 (data->description), data->_tmp11_);
			} else {
				if (g_str_has_prefix (data->branch, "~")) {
					data->uri = (data->_tmp12_ = g_strconcat ("https://code.launchpad.net/", data->branch, NULL), _g_free0 (data->uri), data->_tmp12_);
					data->title = (data->_tmp13_ = g_strdup_printf (_ ("Launchpad: Bazaar branch %s"), data->branch), _g_free0 (data->title), data->_tmp13_);
					data->description = (data->_tmp14_ = g_strdup (data->uri), _g_free0 (data->description), data->_tmp14_);
				}
			}
		}
		if (data->uri != NULL) {
			synapse_result_set_add (data->_result_, (SynapseMatch*) (data->_tmp15_ = synapse_launchpad_plugin_launchpad_object_new (data->title, data->description, data->uri)), (gint) SYNAPSE_MATCH_SCORE_EXCELLENT);
			_g_object_unref0 (data->_tmp15_);
		}
		data->groups = (_vala_array_free (data->groups, data->groups_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->branch);
	} else {
		data->_tmp16_ = NULL;
		if ((data->_tmp17_ = g_regex_match (data->self->priv->bug_regex, data->stripped, 0, &data->_tmp16_), data->mi = (data->_tmp18_ = data->_tmp16_, _g_match_info_free0 (data->mi), data->_tmp18_), data->_tmp17_)) {
			data->bug_num = g_match_info_fetch (data->mi, 1);
			data->uri = (data->_tmp19_ = g_strconcat ("https://bugs.launchpad.net/bugs/", data->bug_num, NULL), _g_free0 (data->uri), data->_tmp19_);
			data->title = (data->_tmp20_ = g_strdup_printf (_ ("Launchpad: Bug #%s"), data->bug_num), _g_free0 (data->title), data->_tmp20_);
			data->description = (data->_tmp21_ = g_strdup (data->uri), _g_free0 (data->description), data->_tmp21_);
			synapse_result_set_add (data->_result_, (SynapseMatch*) (data->_tmp22_ = synapse_launchpad_plugin_launchpad_object_new (data->title, data->description, data->uri)), (gint) SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE);
			_g_object_unref0 (data->_tmp22_);
			_g_free0 (data->bug_num);
		}
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_match_info_free0 (data->mi);
			_g_free0 (data->stripped);
			_g_object_unref0 (data->_result_);
			_g_free0 (data->description);
			_g_free0 (data->title);
			_g_free0 (data->uri);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_match_info_free0 (data->mi);
			_g_free0 (data->stripped);
			_g_object_unref0 (data->_result_);
			_g_free0 (data->description);
			_g_free0 (data->title);
			_g_free0 (data->uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_result_;
	_g_match_info_free0 (data->mi);
	_g_free0 (data->stripped);
	_g_free0 (data->description);
	_g_free0 (data->title);
	_g_free0 (data->uri);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_match_info_free0 (data->mi);
	_g_free0 (data->stripped);
	_g_object_unref0 (data->_result_);
	_g_free0 (data->description);
	_g_free0 (data->title);
	_g_free0 (data->uri);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


SynapseResultSet* synapse_launchpad_plugin_find_for_match (SynapseLaunchpadPlugin* self, SynapseQuery* query, SynapseMatch* match) {
	SynapseResultSet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (match != NULL, NULL);
	result = NULL;
	return result;
}


SynapseLaunchpadPlugin* synapse_launchpad_plugin_construct (GType object_type) {
	SynapseLaunchpadPlugin * self = NULL;
	self = (SynapseLaunchpadPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseLaunchpadPlugin* synapse_launchpad_plugin_new (void) {
	return synapse_launchpad_plugin_construct (SYNAPSE_TYPE_LAUNCHPAD_PLUGIN);
}


static gboolean synapse_launchpad_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseLaunchpadPlugin* self;
	self = (SynapseLaunchpadPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_launchpad_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseLaunchpadPlugin* self;
	self = (SynapseLaunchpadPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_launchpad_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseLaunchpadPlugin * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (synapse_launchpad_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_LAUNCHPAD_PLUGIN (obj);
	_inner_error_ = NULL;
	{
		{
			GRegex* _tmp1_;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			GRegex* _tmp4_;
			_tmp1_ = g_regex_new ("(?:bug|lp|#):?\\s*#?\\s*(\\d+)$", G_REGEX_OPTIMIZE | G_REGEX_CASELESS, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch25_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			self->priv->bug_regex = (_tmp2_ = _tmp1_, _g_regex_unref0 (self->priv->bug_regex), _tmp2_);
			_tmp3_ = g_regex_new ("lp:(~?[a-z]+[+-/_a-z0-9]*)", G_REGEX_OPTIMIZE, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch25_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			self->priv->branch_regex = (_tmp4_ = _tmp3_, _g_regex_unref0 (self->priv->branch_regex), _tmp4_);
		}
		goto __finally25;
		__catch25_g_regex_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				synapse_utils_logger_warning ((GObject*) self, "Unable to construct regex: %s", err->message, NULL);
				_g_error_free0 (err);
			}
		}
		__finally25:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static SynapseLaunchpadPluginLaunchpadAuthObject* synapse_launchpad_plugin_launchpad_auth_object_construct (GType object_type) {
	SynapseLaunchpadPluginLaunchpadAuthObject * self = NULL;
	self = (SynapseLaunchpadPluginLaunchpadAuthObject*) g_object_new (object_type, NULL);
	return self;
}


static SynapseLaunchpadPluginLaunchpadAuthObject* synapse_launchpad_plugin_launchpad_auth_object_new (void) {
	return synapse_launchpad_plugin_launchpad_auth_object_construct (SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_AUTH_OBJECT);
}


static void synapse_launchpad_plugin_launchpad_auth_object_class_init (SynapseLaunchpadPluginLaunchpadAuthObjectClass * klass) {
	synapse_launchpad_plugin_launchpad_auth_object_parent_class = g_type_class_peek_parent (klass);
}


static void synapse_launchpad_plugin_launchpad_auth_object_instance_init (SynapseLaunchpadPluginLaunchpadAuthObject * self) {
}


static GType synapse_launchpad_plugin_launchpad_auth_object_get_type (void) {
	static volatile gsize synapse_launchpad_plugin_launchpad_auth_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_launchpad_plugin_launchpad_auth_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLaunchpadPluginLaunchpadAuthObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_launchpad_plugin_launchpad_auth_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLaunchpadPluginLaunchpadAuthObject), 0, (GInstanceInitFunc) synapse_launchpad_plugin_launchpad_auth_object_instance_init, NULL };
		GType synapse_launchpad_plugin_launchpad_auth_object_type_id;
		synapse_launchpad_plugin_launchpad_auth_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLaunchpadPluginLaunchpadAuthObject", &g_define_type_info, 0);
		g_once_init_leave (&synapse_launchpad_plugin_launchpad_auth_object_type_id__volatile, synapse_launchpad_plugin_launchpad_auth_object_type_id);
	}
	return synapse_launchpad_plugin_launchpad_auth_object_type_id__volatile;
}


static SynapseLaunchpadPluginLaunchpadObject* synapse_launchpad_plugin_launchpad_object_construct (GType object_type, const char* title, const char* desc, const char* uri) {
	SynapseLaunchpadPluginLaunchpadObject * self = NULL;
	GIcon* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (SynapseLaunchpadPluginLaunchpadObject*) g_object_new (object_type, "title", title, "description", desc, "icon-name", _tmp1_ = g_icon_to_string (_tmp0_ = g_content_type_get_icon ("text/html")), "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, "uri", uri, "mime-type", "text/html", "file-type", SYNAPSE_QUERY_FLAGS_INTERNET, NULL);
	_g_free0 (_tmp1_);
	_g_object_unref0 (_tmp0_);
	return self;
}


static SynapseLaunchpadPluginLaunchpadObject* synapse_launchpad_plugin_launchpad_object_new (const char* title, const char* desc, const char* uri) {
	return synapse_launchpad_plugin_launchpad_object_construct (SYNAPSE_LAUNCHPAD_PLUGIN_TYPE_LAUNCHPAD_OBJECT, title, desc, uri);
}


static const char* synapse_launchpad_plugin_launchpad_object_real_get_title (SynapseMatch* base) {
	const char* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_title (SynapseMatch* base, const char* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	char* _tmp0_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_title = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_title), _tmp0_);
	g_object_notify ((GObject *) self, "title");
}


static const char* synapse_launchpad_plugin_launchpad_object_real_get_description (SynapseMatch* base) {
	const char* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_description (SynapseMatch* base, const char* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	char* _tmp0_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


static const char* synapse_launchpad_plugin_launchpad_object_real_get_icon_name (SynapseMatch* base) {
	const char* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_icon_name (SynapseMatch* base, const char* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	char* _tmp0_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_launchpad_plugin_launchpad_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const char* synapse_launchpad_plugin_launchpad_object_real_get_thumbnail_path (SynapseMatch* base) {
	const char* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_thumbnail_path (SynapseMatch* base, const char* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	char* _tmp0_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_thumbnail_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_thumbnail_path), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_launchpad_plugin_launchpad_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static const char* synapse_launchpad_plugin_launchpad_object_real_get_uri (SynapseUriMatch* base) {
	const char* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_uri;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_uri (SynapseUriMatch* base, const char* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	char* _tmp0_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_uri = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_uri), _tmp0_);
	g_object_notify ((GObject *) self, "uri");
}


static SynapseQueryFlags synapse_launchpad_plugin_launchpad_object_real_get_file_type (SynapseUriMatch* base) {
	SynapseQueryFlags result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_file_type;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_file_type (SynapseUriMatch* base, SynapseQueryFlags value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_file_type = value;
	g_object_notify ((GObject *) self, "file-type");
}


static const char* synapse_launchpad_plugin_launchpad_object_real_get_mime_type (SynapseUriMatch* base) {
	const char* result;
	SynapseLaunchpadPluginLaunchpadObject* self;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	result = self->priv->_mime_type;
	return result;
}


static void synapse_launchpad_plugin_launchpad_object_real_set_mime_type (SynapseUriMatch* base, const char* value) {
	SynapseLaunchpadPluginLaunchpadObject* self;
	char* _tmp0_;
	self = (SynapseLaunchpadPluginLaunchpadObject*) base;
	self->priv->_mime_type = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_mime_type), _tmp0_);
	g_object_notify ((GObject *) self, "mime-type");
}


static void synapse_launchpad_plugin_launchpad_object_class_init (SynapseLaunchpadPluginLaunchpadObjectClass * klass) {
	synapse_launchpad_plugin_launchpad_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseLaunchpadPluginLaunchpadObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_launchpad_plugin_launchpad_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_launchpad_plugin_launchpad_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_launchpad_plugin_launchpad_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MIME_TYPE, "mime-type");
}


static void synapse_launchpad_plugin_launchpad_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_launchpad_plugin_launchpad_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_launchpad_plugin_launchpad_object_real_get_title;
	iface->set_title = synapse_launchpad_plugin_launchpad_object_real_set_title;
	iface->get_description = synapse_launchpad_plugin_launchpad_object_real_get_description;
	iface->set_description = synapse_launchpad_plugin_launchpad_object_real_set_description;
	iface->get_icon_name = synapse_launchpad_plugin_launchpad_object_real_get_icon_name;
	iface->set_icon_name = synapse_launchpad_plugin_launchpad_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_launchpad_plugin_launchpad_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_launchpad_plugin_launchpad_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_launchpad_plugin_launchpad_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_launchpad_plugin_launchpad_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_launchpad_plugin_launchpad_object_real_get_match_type;
	iface->set_match_type = synapse_launchpad_plugin_launchpad_object_real_set_match_type;
}


static void synapse_launchpad_plugin_launchpad_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface) {
	synapse_launchpad_plugin_launchpad_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_launchpad_plugin_launchpad_object_real_get_uri;
	iface->set_uri = synapse_launchpad_plugin_launchpad_object_real_set_uri;
	iface->get_file_type = synapse_launchpad_plugin_launchpad_object_real_get_file_type;
	iface->set_file_type = synapse_launchpad_plugin_launchpad_object_real_set_file_type;
	iface->get_mime_type = synapse_launchpad_plugin_launchpad_object_real_get_mime_type;
	iface->set_mime_type = synapse_launchpad_plugin_launchpad_object_real_set_mime_type;
}


static void synapse_launchpad_plugin_launchpad_object_instance_init (SynapseLaunchpadPluginLaunchpadObject * self) {
	self->priv = SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_GET_PRIVATE (self);
	self->priv->_description = g_strdup ("");
	self->priv->_icon_name = g_strdup ("");
	self->priv->_has_thumbnail = FALSE;
}


static void synapse_launchpad_plugin_launchpad_object_finalize (GObject* obj) {
	SynapseLaunchpadPluginLaunchpadObject * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	G_OBJECT_CLASS (synapse_launchpad_plugin_launchpad_object_parent_class)->finalize (obj);
}


static GType synapse_launchpad_plugin_launchpad_object_get_type (void) {
	static volatile gsize synapse_launchpad_plugin_launchpad_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_launchpad_plugin_launchpad_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLaunchpadPluginLaunchpadObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_launchpad_plugin_launchpad_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLaunchpadPluginLaunchpadObject), 0, (GInstanceInitFunc) synapse_launchpad_plugin_launchpad_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_launchpad_plugin_launchpad_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_launchpad_plugin_launchpad_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_launchpad_plugin_launchpad_object_type_id;
		synapse_launchpad_plugin_launchpad_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLaunchpadPluginLaunchpadObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_launchpad_plugin_launchpad_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_launchpad_plugin_launchpad_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		g_once_init_leave (&synapse_launchpad_plugin_launchpad_object_type_id__volatile, synapse_launchpad_plugin_launchpad_object_type_id);
	}
	return synapse_launchpad_plugin_launchpad_object_type_id__volatile;
}


static void synapse_launchpad_plugin_launchpad_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseLaunchpadPluginLaunchpadObject * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_URI:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_FILE_TYPE:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MIME_TYPE:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_launchpad_plugin_launchpad_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseLaunchpadPluginLaunchpadObject * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_URI:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_FILE_TYPE:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_LAUNCHPAD_PLUGIN_LAUNCHPAD_OBJECT_MIME_TYPE:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_launchpad_plugin_class_init (SynapseLaunchpadPluginClass * klass) {
	synapse_launchpad_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseLaunchpadPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_launchpad_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_launchpad_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_launchpad_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_launchpad_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_LAUNCHPAD_PLUGIN_ENABLED, "enabled");
	{
		synapse_launchpad_plugin_register_plugin ();
	}
}


static void synapse_launchpad_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_launchpad_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = synapse_launchpad_plugin_real_activate;
	iface->deactivate = synapse_launchpad_plugin_real_deactivate;
	iface->get_enabled = synapse_launchpad_plugin_real_get_enabled;
	iface->set_enabled = synapse_launchpad_plugin_real_set_enabled;
}


static void synapse_launchpad_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_launchpad_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = synapse_launchpad_plugin_real_handles_query;
	iface->search = synapse_launchpad_plugin_real_search;
	iface->search_finish = synapse_launchpad_plugin_real_search_finish;
}


static void synapse_launchpad_plugin_instance_init (SynapseLaunchpadPlugin * self) {
	self->priv = SYNAPSE_LAUNCHPAD_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_launchpad_plugin_finalize (GObject* obj) {
	SynapseLaunchpadPlugin * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN (obj);
	_g_object_unref0 (self->priv->auth_object);
	_g_regex_unref0 (self->priv->bug_regex);
	_g_regex_unref0 (self->priv->branch_regex);
	G_OBJECT_CLASS (synapse_launchpad_plugin_parent_class)->finalize (obj);
}


GType synapse_launchpad_plugin_get_type (void) {
	static volatile gsize synapse_launchpad_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_launchpad_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseLaunchpadPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_launchpad_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLaunchpadPlugin), 0, (GInstanceInitFunc) synapse_launchpad_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_launchpad_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_launchpad_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_launchpad_plugin_type_id;
		synapse_launchpad_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLaunchpadPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_launchpad_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_launchpad_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_launchpad_plugin_type_id__volatile, synapse_launchpad_plugin_type_id);
	}
	return synapse_launchpad_plugin_type_id__volatile;
}


static void synapse_launchpad_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseLaunchpadPlugin * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_LAUNCHPAD_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_launchpad_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseLaunchpadPlugin * self;
	self = SYNAPSE_LAUNCHPAD_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_LAUNCHPAD_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




