/* imgur-plugin.c generated by valac 0.10.4, the Vala compiler
 * generated from imgur-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rest/rest-proxy.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <json-glib/json-glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libnotify/notify.h>


#define SYNAPSE_TYPE_IMG_UR_PLUGIN (synapse_img_ur_plugin_get_type ())
#define SYNAPSE_IMG_UR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_IMG_UR_PLUGIN, SynapseImgUrPlugin))
#define SYNAPSE_IMG_UR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_IMG_UR_PLUGIN, SynapseImgUrPluginClass))
#define SYNAPSE_IS_IMG_UR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_IMG_UR_PLUGIN))
#define SYNAPSE_IS_IMG_UR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_IMG_UR_PLUGIN))
#define SYNAPSE_IMG_UR_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_IMG_UR_PLUGIN, SynapseImgUrPluginClass))

typedef struct _SynapseImgUrPlugin SynapseImgUrPlugin;
typedef struct _SynapseImgUrPluginClass SynapseImgUrPluginClass;
typedef struct _SynapseImgUrPluginPrivate SynapseImgUrPluginPrivate;

#define SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION (synapse_img_ur_plugin_img_ur_action_get_type ())
#define SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION, SynapseImgUrPluginImgUrAction))
#define SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION, SynapseImgUrPluginImgUrActionClass))
#define SYNAPSE_IMG_UR_PLUGIN_IS_IMG_UR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION))
#define SYNAPSE_IMG_UR_PLUGIN_IS_IMG_UR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION))
#define SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION, SynapseImgUrPluginImgUrActionClass))

typedef struct _SynapseImgUrPluginImgUrAction SynapseImgUrPluginImgUrAction;
typedef struct _SynapseImgUrPluginImgUrActionClass SynapseImgUrPluginImgUrActionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseImgUrPluginImgUrActionPrivate SynapseImgUrPluginImgUrActionPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _SynapseImgUrPluginImgUrActionUploadFileData SynapseImgUrPluginImgUrActionUploadFileData;

typedef enum  {
	SYNAPSE_UPLOAD_ERROR_LIMIT_REACHED,
	SYNAPSE_UPLOAD_ERROR_UNKNOWN_ERROR
} SynapseUploadError;
#define SYNAPSE_UPLOAD_ERROR synapse_upload_error_quark ()
struct _SynapseImgUrPlugin {
	GObject parent_instance;
	SynapseImgUrPluginPrivate * priv;
};

struct _SynapseImgUrPluginClass {
	GObjectClass parent_class;
};

struct _SynapseImgUrPluginPrivate {
	gboolean _enabled;
	SynapseImgUrPluginImgUrAction* action;
};

struct _SynapseImgUrPluginImgUrAction {
	SynapseBaseAction parent_instance;
	SynapseImgUrPluginImgUrActionPrivate * priv;
};

struct _SynapseImgUrPluginImgUrActionClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseImgUrPluginImgUrActionPrivate {
	RestProxy* proxy;
};

struct _Block8Data {
	int _ref_count_;
	SynapseImgUrPluginImgUrAction * self;
	GError* err;
	gpointer _async_data_;
};

struct _SynapseImgUrPluginImgUrActionUploadFileData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseImgUrPluginImgUrAction* self;
	char* uri;
	char* result;
	GFile* f;
	GFileInputStream* input;
	gint chunk_size;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	guint8* _tmp0_;
	gchar* encode_buffer;
	gint encode_buffer_length1;
	gint _encode_buffer_size_;
	gchar* _tmp1_;
	gsize read_bytes;
	gint state;
	gint save;
	GString* encoded;
	gssize _tmp2_;
	gsize enc_len;
	gssize _tmp3_;
	gsize enc_close;
	RestProxyCall* call;
	const char* limit_remaining;
	const char* reset_time;
	gboolean _tmp4_;
	gint remaining;
	glong reset;
	gboolean _tmp5_;
	GTimeVal cur_time;
	glong delta;
	char* _tmp6_;
	char* _tmp7_;
	GError* _tmp8_;
	JsonParser* parser;
	JsonObject* node_obj;
	Block8Data* _data8_;
	GError * _inner_error_;
};


static gpointer synapse_img_ur_plugin_img_ur_action_parent_class = NULL;
static gpointer synapse_img_ur_plugin_parent_class = NULL;
static SynapseActivatableIface* synapse_img_ur_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface* synapse_img_ur_plugin_synapse_action_provider_parent_iface = NULL;

GQuark synapse_upload_error_quark (void);
GType synapse_img_ur_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_img_ur_plugin_img_ur_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_IMG_UR_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_IMG_UR_PLUGIN, SynapseImgUrPluginPrivate))
enum  {
	SYNAPSE_IMG_UR_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_IMG_UR_PLUGIN_ENABLED
};
static void synapse_img_ur_plugin_real_activate (SynapseActivatable* base);
static SynapseImgUrPluginImgUrAction* synapse_img_ur_plugin_img_ur_action_new (void);
static SynapseImgUrPluginImgUrAction* synapse_img_ur_plugin_img_ur_action_construct (GType object_type);
static void synapse_img_ur_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_img_ur_plugin_register_plugin (void);
static void _synapse_img_ur_plugin_register_plugin_synapse_plugin_register_func (void);
static SynapseResultSet* synapse_img_ur_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* q, SynapseMatch* match);
SynapseImgUrPlugin* synapse_img_ur_plugin_new (void);
SynapseImgUrPlugin* synapse_img_ur_plugin_construct (GType object_type);
static GObject * synapse_img_ur_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION, SynapseImgUrPluginImgUrActionPrivate))
enum  {
	SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_DUMMY_PROPERTY
};
static void synapse_img_ur_plugin_img_ur_action_upload_file_data_free (gpointer _data);
static void synapse_img_ur_plugin_img_ur_action_upload_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_img_ur_plugin_img_ur_action_upload_file (SynapseImgUrPluginImgUrAction* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static char* synapse_img_ur_plugin_img_ur_action_upload_file_finish (SynapseImgUrPluginImgUrAction* self, GAsyncResult* _res_, GError** error);
static gboolean synapse_img_ur_plugin_img_ur_action_upload_file_co (SynapseImgUrPluginImgUrActionUploadFileData* data);
static void _lambda14_ (RestProxyCall* call_obj, GError* _error_, GObject* obj, Block8Data* _data8_);
static void __lambda14__rest_proxy_call_async_callback (RestProxyCall* call, GError* _error_, GObject* weak_object, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void synapse_img_ur_plugin_img_ur_action_process_result (SynapseImgUrPluginImgUrAction* self, const char* url);
static void synapse_img_ur_plugin_img_ur_action_real_do_execute (SynapseBaseAction* base, SynapseMatch* match);
static void _lambda15_ (GObject* obj, GAsyncResult* res, SynapseImgUrPluginImgUrAction* self);
static void __lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean synapse_img_ur_plugin_img_ur_action_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match);
static GObject * synapse_img_ur_plugin_img_ur_action_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void synapse_img_ur_plugin_img_ur_action_finalize (GObject* obj);
static void synapse_img_ur_plugin_finalize (GObject* obj);
static void synapse_img_ur_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_img_ur_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark synapse_upload_error_quark (void) {
	return g_quark_from_static_string ("synapse_upload_error-quark");
}


static void synapse_img_ur_plugin_real_activate (SynapseActivatable* base) {
	SynapseImgUrPlugin * self;
	SynapseImgUrPluginImgUrAction* _tmp0_;
	self = (SynapseImgUrPlugin*) base;
	self->priv->action = (_tmp0_ = synapse_img_ur_plugin_img_ur_action_new (), _g_object_unref0 (self->priv->action), _tmp0_);
}


static void synapse_img_ur_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseImgUrPlugin * self;
	SynapseImgUrPluginImgUrAction* _tmp0_;
	self = (SynapseImgUrPlugin*) base;
	self->priv->action = (_tmp0_ = NULL, _g_object_unref0 (self->priv->action), _tmp0_);
}


static void _synapse_img_ur_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_img_ur_plugin_register_plugin ();
}


static void synapse_img_ur_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp0_ = synapse_data_sink_plugin_registry_get_default (), SYNAPSE_TYPE_IMG_UR_PLUGIN, _ ("Imgur"), _ ("Share images using imgur."), "document-send", _synapse_img_ur_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp0_);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static SynapseResultSet* synapse_img_ur_plugin_real_find_for_match (SynapseActionProvider* base, SynapseQuery* q, SynapseMatch* match) {
	SynapseImgUrPlugin * self;
	SynapseResultSet* result = NULL;
	char* _tmp0_;
	gboolean query_empty;
	SynapseResultSet* results;
	self = (SynapseImgUrPlugin*) base;
	g_return_val_if_fail (match != NULL, NULL);
	if (!synapse_base_action_valid_for_match ((SynapseBaseAction*) self->priv->action, match)) {
		result = NULL;
		return result;
	}
	(*q).query_string = (_tmp0_ = string_strip ((*q).query_string), _g_free0 ((*q).query_string), _tmp0_);
	query_empty = _vala_strcmp0 ((*q).query_string, "") == 0;
	results = synapse_result_set_new ();
	if (query_empty) {
		synapse_result_set_add (results, (SynapseMatch*) self->priv->action, synapse_base_action_get_default_relevancy ((SynapseBaseAction*) self->priv->action));
	} else {
		GeeList* matchers;
		matchers = synapse_query_get_matchers_for_query ((*q).query_string, 0, G_REGEX_CASELESS);
		{
			GeeIterator* _matcher_it;
			_matcher_it = gee_iterable_iterator ((GeeIterable*) matchers);
			while (TRUE) {
				GeeMapEntry* matcher;
				if (!gee_iterator_next (_matcher_it)) {
					break;
				}
				matcher = (GeeMapEntry*) gee_iterator_get (_matcher_it);
				if (g_regex_match ((GRegex*) gee_map_entry_get_key (matcher), synapse_match_get_title ((SynapseMatch*) self->priv->action), 0, NULL)) {
					synapse_result_set_add (results, (SynapseMatch*) self->priv->action, GPOINTER_TO_INT (gee_map_entry_get_value (matcher)));
					_g_object_unref0 (matcher);
					break;
				}
				_g_object_unref0 (matcher);
			}
			_g_object_unref0 (_matcher_it);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


SynapseImgUrPlugin* synapse_img_ur_plugin_construct (GType object_type) {
	SynapseImgUrPlugin * self = NULL;
	self = (SynapseImgUrPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseImgUrPlugin* synapse_img_ur_plugin_new (void) {
	return synapse_img_ur_plugin_construct (SYNAPSE_TYPE_IMG_UR_PLUGIN);
}


static gboolean synapse_img_ur_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseImgUrPlugin* self;
	self = (SynapseImgUrPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_img_ur_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseImgUrPlugin* self;
	self = (SynapseImgUrPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_img_ur_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseImgUrPlugin * self;
	parent_class = G_OBJECT_CLASS (synapse_img_ur_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_IMG_UR_PLUGIN (obj);
	{
	}
	return obj;
}


static SynapseImgUrPluginImgUrAction* synapse_img_ur_plugin_img_ur_action_construct (GType object_type) {
	SynapseImgUrPluginImgUrAction * self = NULL;
	self = (SynapseImgUrPluginImgUrAction*) g_object_new (object_type, "title", _ ("Upload to imgur"), "description", _ ("Upload selection to imgur image sharer"), "match-type", SYNAPSE_MATCH_TYPE_ACTION, "icon-name", "document-send", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, NULL);
	return self;
}


static SynapseImgUrPluginImgUrAction* synapse_img_ur_plugin_img_ur_action_new (void) {
	return synapse_img_ur_plugin_img_ur_action_construct (SYNAPSE_IMG_UR_PLUGIN_TYPE_IMG_UR_ACTION);
}


static void synapse_img_ur_plugin_img_ur_action_upload_file_data_free (gpointer _data) {
	SynapseImgUrPluginImgUrActionUploadFileData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_free0 (data->result);
	g_object_unref (data->self);
	g_slice_free (SynapseImgUrPluginImgUrActionUploadFileData, data);
}


static void synapse_img_ur_plugin_img_ur_action_upload_file (SynapseImgUrPluginImgUrAction* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseImgUrPluginImgUrActionUploadFileData* _data_;
	_data_ = g_slice_new0 (SynapseImgUrPluginImgUrActionUploadFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_img_ur_plugin_img_ur_action_upload_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_img_ur_plugin_img_ur_action_upload_file_data_free);
	_data_->self = g_object_ref (self);
	_data_->uri = g_strdup (uri);
	synapse_img_ur_plugin_img_ur_action_upload_file_co (_data_);
}


static char* synapse_img_ur_plugin_img_ur_action_upload_file_finish (SynapseImgUrPluginImgUrAction* self, GAsyncResult* _res_, GError** error) {
	char* result;
	SynapseImgUrPluginImgUrActionUploadFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_img_ur_plugin_img_ur_action_upload_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseImgUrPluginImgUrActionUploadFileData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_img_ur_plugin_img_ur_action_upload_file_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _lambda14_ (RestProxyCall* call_obj, GError* _error_, GObject* obj, Block8Data* _data8_) {
	SynapseImgUrPluginImgUrAction * self;
	GError* _tmp0_;
	self = _data8_->self;
	g_return_if_fail (call_obj != NULL);
	_data8_->err = (_tmp0_ = _g_error_copy0 (_error_), _g_error_free0 (_data8_->err), _tmp0_);
	synapse_img_ur_plugin_img_ur_action_upload_file_co (_data8_->_async_data_);
}


static void __lambda14__rest_proxy_call_async_callback (RestProxyCall* call, GError* _error_, GObject* weak_object, gpointer self) {
	_lambda14_ (call, _error_, weak_object, self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_g_error_free0 (_data8_->err);
		g_slice_free (Block8Data, _data8_);
	}
}


static gboolean synapse_img_ur_plugin_img_ur_action_upload_file_co (SynapseImgUrPluginImgUrActionUploadFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 59:
		goto _state_59;
		case 60:
		goto _state_60;
		case 61:
		goto _state_61;
		case 62:
		goto _state_62;
	}
	_state_0:
	data->_data8_ = g_slice_new0 (Block8Data);
	data->_data8_->_ref_count_ = 1;
	data->_data8_->self = g_object_ref (data->self);
	data->_data8_->_async_data_ = data;
	data->f = g_file_new_for_uri (data->uri);
	data->_state_ = 59;
	g_file_read_async (data->f, G_PRIORITY_DEFAULT, NULL, synapse_img_ur_plugin_img_ur_action_upload_file_ready, data);
	return FALSE;
	_state_59:
	data->input = g_file_read_finish (data->f, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->f);
		block8_data_unref (data->_data8_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->chunk_size = 128 * 1024;
	data->buffer = (data->_tmp0_ = g_new0 (guint8, data->chunk_size), data->buffer_length1 = data->chunk_size, data->_buffer_size_ = data->buffer_length1, data->_tmp0_);
	data->encode_buffer = (data->_tmp1_ = g_new0 (gchar, (((data->chunk_size / 3) + 1) * 4) + 4), data->encode_buffer_length1 = (((data->chunk_size / 3) + 1) * 4) + 4, data->_encode_buffer_size_ = data->encode_buffer_length1, data->_tmp1_);
	data->state = 0;
	data->save = 0;
	data->encoded = g_string_new ("");
	data->_state_ = 60;
	g_input_stream_read_async ((GInputStream*) data->input, data->buffer, (gsize) data->buffer_length1, G_PRIORITY_DEFAULT, NULL, synapse_img_ur_plugin_img_ur_action_upload_file_ready, data);
	return FALSE;
	_state_60:
	data->_tmp2_ = g_input_stream_read_finish ((GInputStream*) data->input, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_string_free0 (data->encoded);
		data->encode_buffer = (g_free (data->encode_buffer), NULL);
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->input);
		_g_object_unref0 (data->f);
		block8_data_unref (data->_data8_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->read_bytes = (gsize) data->_tmp2_;
	while (TRUE) {
		if (!(data->read_bytes != 0)) {
			break;
		}
		data->buffer_length1 = (gint) data->read_bytes;
		data->enc_len = g_base64_encode_step ((guchar*) data->buffer, data->buffer_length1, FALSE, data->encode_buffer, &data->state, &data->save);
		g_string_append_len (data->encoded, (const char*) data->encode_buffer, (gssize) data->enc_len);
		data->_state_ = 61;
		g_input_stream_read_async ((GInputStream*) data->input, data->buffer, (gsize) data->buffer_length1, G_PRIORITY_DEFAULT, NULL, synapse_img_ur_plugin_img_ur_action_upload_file_ready, data);
		return FALSE;
		_state_61:
		data->_tmp3_ = g_input_stream_read_finish ((GInputStream*) data->input, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_string_free0 (data->encoded);
			data->encode_buffer = (g_free (data->encode_buffer), NULL);
			data->buffer = (g_free (data->buffer), NULL);
			_g_object_unref0 (data->input);
			_g_object_unref0 (data->f);
			block8_data_unref (data->_data8_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->read_bytes = (gsize) data->_tmp3_;
	}
	data->enc_close = g_base64_encode_close (FALSE, data->encode_buffer, &data->state, &data->save);
	g_string_append_len (data->encoded, (const char*) data->encode_buffer, (gssize) data->enc_close);
	data->call = rest_proxy_new_call (data->self->priv->proxy);
	rest_proxy_call_set_method (data->call, "POST");
	rest_proxy_call_set_function (data->call, "upload.json");
	rest_proxy_call_add_param (data->call, "key", "ae208d46a27310d4758e462a05c7f12e");
	rest_proxy_call_add_param (data->call, "image", data->encoded->str);
	data->_data8_->err = NULL;
	rest_proxy_call_async (data->call, __lambda14__rest_proxy_call_async_callback, (GObject*) data->self, data->_data8_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->call);
		_g_string_free0 (data->encoded);
		data->encode_buffer = (g_free (data->encode_buffer), NULL);
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->input);
		_g_object_unref0 (data->f);
		block8_data_unref (data->_data8_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 62;
	return FALSE;
	_state_62:
	;
	if (data->_data8_->err != NULL) {
		data->_inner_error_ = _g_error_copy0 (data->_data8_->err);
		{
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->call);
			_g_string_free0 (data->encoded);
			data->encode_buffer = (g_free (data->encode_buffer), NULL);
			data->buffer = (g_free (data->buffer), NULL);
			_g_object_unref0 (data->input);
			_g_object_unref0 (data->f);
			block8_data_unref (data->_data8_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	data->limit_remaining = rest_proxy_call_lookup_response_header (data->call, "X-RateLimit-Remaining");
	data->reset_time = rest_proxy_call_lookup_response_header (data->call, "X-RateLimit-Reset");
	if (rest_proxy_call_get_status_code (data->call) != 200) {
		if (data->limit_remaining != NULL) {
			data->_tmp4_ = data->reset_time != NULL;
		} else {
			data->_tmp4_ = FALSE;
		}
		if (data->_tmp4_) {
			data->remaining = atoi (data->limit_remaining);
			data->reset = strtol (data->reset_time, NULL, 0);
			if (data->remaining < 10) {
				data->_tmp5_ = data->reset > 0;
			} else {
				data->_tmp5_ = FALSE;
			}
			if (data->_tmp5_) {
				g_get_current_time (&data->cur_time);
				data->delta = (data->reset - data->cur_time.tv_sec) / 60;
				data->delta = MAX ((glong) 1, data->delta);
				data->_inner_error_ = (data->_tmp8_ = g_error_new_literal (SYNAPSE_UPLOAD_ERROR, SYNAPSE_UPLOAD_ERROR_LIMIT_REACHED, data->_tmp7_ = g_strconcat ("Upload limit reached, reset in ", data->_tmp6_ = g_strdup_printf ("%li", data->delta), " minutes", NULL)), _g_free0 (data->_tmp7_), _g_free0 (data->_tmp6_), data->_tmp8_);
				{
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->call);
					_g_string_free0 (data->encoded);
					data->encode_buffer = (g_free (data->encode_buffer), NULL);
					data->buffer = (g_free (data->buffer), NULL);
					_g_object_unref0 (data->input);
					_g_object_unref0 (data->f);
					block8_data_unref (data->_data8_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			} else {
				data->_inner_error_ = g_error_new_literal (SYNAPSE_UPLOAD_ERROR, SYNAPSE_UPLOAD_ERROR_UNKNOWN_ERROR, rest_proxy_call_get_status_message (data->call));
				{
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->call);
					_g_string_free0 (data->encoded);
					data->encode_buffer = (g_free (data->encode_buffer), NULL);
					data->buffer = (g_free (data->buffer), NULL);
					_g_object_unref0 (data->input);
					_g_object_unref0 (data->f);
					block8_data_unref (data->_data8_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
		} else {
			data->_inner_error_ = g_error_new_literal (SYNAPSE_UPLOAD_ERROR, SYNAPSE_UPLOAD_ERROR_UNKNOWN_ERROR, rest_proxy_call_get_status_message (data->call));
			{
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->call);
				_g_string_free0 (data->encoded);
				data->encode_buffer = (g_free (data->encode_buffer), NULL);
				data->buffer = (g_free (data->buffer), NULL);
				_g_object_unref0 (data->input);
				_g_object_unref0 (data->f);
				block8_data_unref (data->_data8_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
	}
	data->parser = json_parser_new ();
	json_parser_load_from_data (data->parser, rest_proxy_call_get_payload (data->call), (gssize) rest_proxy_call_get_payload_length (data->call), &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->parser);
		_g_object_unref0 (data->call);
		_g_string_free0 (data->encoded);
		data->encode_buffer = (g_free (data->encode_buffer), NULL);
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->input);
		_g_object_unref0 (data->f);
		block8_data_unref (data->_data8_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->node_obj = json_node_get_object (json_parser_get_root (data->parser));
	if (data->node_obj != NULL) {
		data->node_obj = json_object_get_object_member (data->node_obj, "upload");
		if (data->node_obj != NULL) {
			data->node_obj = json_object_get_object_member (data->node_obj, "links");
			if (data->node_obj != NULL) {
				data->result = g_strdup (json_object_get_string_member (data->node_obj, "imgur_page"));
				_g_object_unref0 (data->parser);
				_g_object_unref0 (data->call);
				_g_string_free0 (data->encoded);
				data->encode_buffer = (g_free (data->encode_buffer), NULL);
				data->buffer = (g_free (data->buffer), NULL);
				_g_object_unref0 (data->input);
				_g_object_unref0 (data->f);
				block8_data_unref (data->_data8_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
	}
	data->_inner_error_ = g_error_new_literal (SYNAPSE_UPLOAD_ERROR, SYNAPSE_UPLOAD_ERROR_UNKNOWN_ERROR, "Unable to parse result");
	{
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->parser);
		_g_object_unref0 (data->call);
		_g_string_free0 (data->encoded);
		data->encode_buffer = (g_free (data->encode_buffer), NULL);
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->input);
		_g_object_unref0 (data->f);
		block8_data_unref (data->_data8_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (data->parser);
	_g_object_unref0 (data->call);
	_g_string_free0 (data->encoded);
	data->encode_buffer = (g_free (data->encode_buffer), NULL);
	data->buffer = (g_free (data->buffer), NULL);
	_g_object_unref0 (data->input);
	_g_object_unref0 (data->f);
	block8_data_unref (data->_data8_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_img_ur_plugin_img_ur_action_process_result (SynapseImgUrPluginImgUrAction* self, const char* url) {
	char* msg;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	msg = NULL;
	if (url != NULL) {
		GtkClipboard* cb;
		char* _tmp0_;
		cb = _g_object_ref0 (gtk_clipboard_get (GDK_NONE));
		gtk_clipboard_set_text (cb, url, -1);
		msg = (_tmp0_ = g_strdup (_ ("The selection was successfully uploaded and its URL was copied to clip" \
"board.")), _g_free0 (msg), _tmp0_);
		_g_object_unref0 (cb);
	} else {
		char* _tmp1_;
		msg = (_tmp1_ = g_strdup (_ ("An error occurred during upload, please check the log for more informa" \
"tion.")), _g_free0 (msg), _tmp1_);
	}
	{
		GObject* _tmp2_;
		GObject* _tmp3_;
		NotifyNotification* notification;
		notification = (_tmp3_ = (_tmp2_ = g_object_new (NOTIFY_TYPE_NOTIFICATION, "summary", _ ("Synapse - Imgur"), "body", msg, "icon-name", "synapse", NULL, NULL), G_IS_INITIALLY_UNOWNED (_tmp2_) ? g_object_ref_sink (_tmp2_) : _tmp2_), NOTIFY_IS_NOTIFICATION (_tmp3_) ? ((NotifyNotification*) _tmp3_) : NULL);
		notify_notification_set_timeout (notification, 10);
		notify_notification_show (notification, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (notification);
			goto __catch53_g_error;
		}
		_g_object_unref0 (notification);
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
			_g_error_free0 (err);
		}
	}
	__finally53:
	if (_inner_error_ != NULL) {
		_g_free0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (msg);
}


static void _lambda15_ (GObject* obj, GAsyncResult* res, SynapseImgUrPluginImgUrAction* self) {
	char* url;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	url = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = synapse_img_ur_plugin_img_ur_action_upload_file_finish (self, res, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch54_g_error;
		}
		url = (_tmp1_ = _tmp0_, _g_free0 (url), _tmp1_);
		synapse_utils_logger_log ((GObject*) self, "%s", url, NULL);
	}
	goto __finally54;
	__catch54_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
			_g_error_free0 (err);
		}
	}
	__finally54:
	if (_inner_error_ != NULL) {
		_g_free0 (url);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	synapse_img_ur_plugin_img_ur_action_process_result (self, url);
	_g_free0 (url);
}


static void __lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda15_ (source_object, res, self);
	g_object_unref (self);
}


static void synapse_img_ur_plugin_img_ur_action_real_do_execute (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseImgUrPluginImgUrAction * self;
	gboolean _tmp0_ = FALSE;
	self = (SynapseImgUrPluginImgUrAction*) base;
	if (synapse_match_get_match_type (match) == SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		_tmp0_ = SYNAPSE_IS_URI_MATCH (match);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SynapseMatch* _tmp1_;
		SynapseUriMatch* uri_match;
		uri_match = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_URI_MATCH (_tmp1_) ? ((SynapseUriMatch*) _tmp1_) : NULL));
		synapse_img_ur_plugin_img_ur_action_upload_file (self, synapse_uri_match_get_uri (uri_match), __lambda15__gasync_ready_callback, g_object_ref (self));
		_g_object_unref0 (uri_match);
	}
}


static gboolean synapse_img_ur_plugin_img_ur_action_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseImgUrPluginImgUrAction * self;
	gboolean result = FALSE;
	self = (SynapseImgUrPluginImgUrAction*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	switch (synapse_match_get_match_type (match)) {
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
		{
			SynapseMatch* _tmp0_;
			SynapseUriMatch* um;
			GFile* f;
			char* _tmp1_;
			gboolean _tmp2_;
			um = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL));
			f = g_file_new_for_uri (synapse_uri_match_get_uri (um));
			if ((_tmp2_ = (_tmp1_ = g_file_get_path (f)) == NULL, _g_free0 (_tmp1_), _tmp2_)) {
				result = FALSE;
				_g_object_unref0 (f);
				_g_object_unref0 (um);
				return result;
			}
			result = g_content_type_is_a (synapse_uri_match_get_mime_type (um), "image/*");
			_g_object_unref0 (f);
			_g_object_unref0 (um);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static GObject * synapse_img_ur_plugin_img_ur_action_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseImgUrPluginImgUrAction * self;
	parent_class = G_OBJECT_CLASS (synapse_img_ur_plugin_img_ur_action_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION (obj);
	{
		RestProxy* _tmp0_;
		self->priv->proxy = (_tmp0_ = rest_proxy_new ("http://api.imgur.com/2/", FALSE), _g_object_unref0 (self->priv->proxy), _tmp0_);
	}
	return obj;
}


static void synapse_img_ur_plugin_img_ur_action_class_init (SynapseImgUrPluginImgUrActionClass * klass) {
	synapse_img_ur_plugin_img_ur_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseImgUrPluginImgUrActionPrivate));
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_img_ur_plugin_img_ur_action_real_do_execute;
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_img_ur_plugin_img_ur_action_real_valid_for_match;
	G_OBJECT_CLASS (klass)->constructor = synapse_img_ur_plugin_img_ur_action_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_img_ur_plugin_img_ur_action_finalize;
}


static void synapse_img_ur_plugin_img_ur_action_instance_init (SynapseImgUrPluginImgUrAction * self) {
	self->priv = SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION_GET_PRIVATE (self);
}


static void synapse_img_ur_plugin_img_ur_action_finalize (GObject* obj) {
	SynapseImgUrPluginImgUrAction * self;
	self = SYNAPSE_IMG_UR_PLUGIN_IMG_UR_ACTION (obj);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (synapse_img_ur_plugin_img_ur_action_parent_class)->finalize (obj);
}


static GType synapse_img_ur_plugin_img_ur_action_get_type (void) {
	static volatile gsize synapse_img_ur_plugin_img_ur_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_img_ur_plugin_img_ur_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseImgUrPluginImgUrActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_img_ur_plugin_img_ur_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseImgUrPluginImgUrAction), 0, (GInstanceInitFunc) synapse_img_ur_plugin_img_ur_action_instance_init, NULL };
		GType synapse_img_ur_plugin_img_ur_action_type_id;
		synapse_img_ur_plugin_img_ur_action_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseImgUrPluginImgUrAction", &g_define_type_info, 0);
		g_once_init_leave (&synapse_img_ur_plugin_img_ur_action_type_id__volatile, synapse_img_ur_plugin_img_ur_action_type_id);
	}
	return synapse_img_ur_plugin_img_ur_action_type_id__volatile;
}


static void synapse_img_ur_plugin_class_init (SynapseImgUrPluginClass * klass) {
	synapse_img_ur_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseImgUrPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_img_ur_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_img_ur_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_img_ur_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_img_ur_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_IMG_UR_PLUGIN_ENABLED, "enabled");
	{
		synapse_img_ur_plugin_register_plugin ();
	}
}


static void synapse_img_ur_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_img_ur_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = synapse_img_ur_plugin_real_activate;
	iface->deactivate = synapse_img_ur_plugin_real_deactivate;
	iface->get_enabled = synapse_img_ur_plugin_real_get_enabled;
	iface->set_enabled = synapse_img_ur_plugin_real_set_enabled;
}


static void synapse_img_ur_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface) {
	synapse_img_ur_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_for_match = synapse_img_ur_plugin_real_find_for_match;
}


static void synapse_img_ur_plugin_instance_init (SynapseImgUrPlugin * self) {
	self->priv = SYNAPSE_IMG_UR_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_img_ur_plugin_finalize (GObject* obj) {
	SynapseImgUrPlugin * self;
	self = SYNAPSE_IMG_UR_PLUGIN (obj);
	_g_object_unref0 (self->priv->action);
	G_OBJECT_CLASS (synapse_img_ur_plugin_parent_class)->finalize (obj);
}


GType synapse_img_ur_plugin_get_type (void) {
	static volatile gsize synapse_img_ur_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_img_ur_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseImgUrPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_img_ur_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseImgUrPlugin), 0, (GInstanceInitFunc) synapse_img_ur_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_img_ur_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_img_ur_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_img_ur_plugin_type_id;
		synapse_img_ur_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseImgUrPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_img_ur_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_img_ur_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		g_once_init_leave (&synapse_img_ur_plugin_type_id__volatile, synapse_img_ur_plugin_type_id);
	}
	return synapse_img_ur_plugin_type_id__volatile;
}


static void synapse_img_ur_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseImgUrPlugin * self;
	self = SYNAPSE_IMG_UR_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_IMG_UR_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_img_ur_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseImgUrPlugin * self;
	self = SYNAPSE_IMG_UR_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_IMG_UR_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




