/* hybrid-search-plugin.c generated by valac 0.10.4, the Vala compiler
 * generated from hybrid-search-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */
/* 
 * This plugin keeps a cache of file names for directories that are commonly
 * used. 
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN (synapse_hybrid_search_plugin_get_type ())
#define SYNAPSE_HYBRID_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPlugin))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPluginClass))
#define SYNAPSE_IS_HYBRID_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN))
#define SYNAPSE_IS_HYBRID_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPluginClass))

typedef struct _SynapseHybridSearchPlugin SynapseHybridSearchPlugin;
typedef struct _SynapseHybridSearchPluginClass SynapseHybridSearchPluginClass;
typedef struct _SynapseHybridSearchPluginPrivate SynapseHybridSearchPluginPrivate;

#define SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO (synapse_hybrid_search_plugin_directory_info_get_type ())
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfo))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfoClass))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfoClass))

typedef struct _SynapseHybridSearchPluginDirectoryInfo SynapseHybridSearchPluginDirectoryInfo;
typedef struct _SynapseHybridSearchPluginDirectoryInfoClass SynapseHybridSearchPluginDirectoryInfoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bookmark_file_free0(var) ((var == NULL) ? NULL : (var = (g_bookmark_file_free (var), NULL)))
typedef struct _SynapseHybridSearchPluginDirectoryInfoPrivate SynapseHybridSearchPluginDirectoryInfoPrivate;
typedef struct _SynapseHybridSearchPluginAnalyzeRecentDocumentsData SynapseHybridSearchPluginAnalyzeRecentDocumentsData;
typedef struct _SynapseHybridSearchPluginProcessUrisData SynapseHybridSearchPluginProcessUrisData;

#define SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT (synapse_hybrid_search_plugin_match_object_get_type ())
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, SynapseHybridSearchPluginMatchObject))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, SynapseHybridSearchPluginMatchObjectClass))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, SynapseHybridSearchPluginMatchObjectClass))

typedef struct _SynapseHybridSearchPluginMatchObject SynapseHybridSearchPluginMatchObject;
typedef struct _SynapseHybridSearchPluginMatchObjectClass SynapseHybridSearchPluginMatchObjectClass;
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
#define _synapse_hybrid_search_plugin_directory_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_hybrid_search_plugin_directory_info_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _SynapseHybridSearchPluginUpdateDirectoryContentsData SynapseHybridSearchPluginUpdateDirectoryContentsData;
typedef struct _SynapseHybridSearchPluginProcessDirectoriesData SynapseHybridSearchPluginProcessDirectoriesData;
typedef struct _SynapseHybridSearchPluginGetExtraResultsData SynapseHybridSearchPluginGetExtraResultsData;
typedef struct _Block3Data Block3Data;
typedef struct _SynapseHybridSearchPluginWaitForProcessingFinishedData SynapseHybridSearchPluginWaitForProcessingFinishedData;
typedef struct _Block4Data Block4Data;
typedef struct _SynapseHybridSearchPluginSearchData SynapseHybridSearchPluginSearchData;
typedef struct _SynapseHybridSearchPluginMatchObjectPrivate SynapseHybridSearchPluginMatchObjectPrivate;
typedef struct _SynapseHybridSearchPluginParamSpecDirectoryInfo SynapseHybridSearchPluginParamSpecDirectoryInfo;

struct _SynapseHybridSearchPlugin {
	GObject parent_instance;
	SynapseHybridSearchPluginPrivate * priv;
};

struct _SynapseHybridSearchPluginClass {
	GObjectClass parent_class;
};

struct _SynapseHybridSearchPluginPrivate {
	SynapseDataSink* _data_sink;
	gboolean _enabled;
	gboolean initialization_done;
	GeeMap* directory_hits;
	gint hit_level;
	gint current_level_uris;
	GeeMap* directory_contents;
	char* current_query;
	gboolean _processing_query;
};

struct _SynapseHybridSearchPluginDirectoryInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseHybridSearchPluginDirectoryInfoPrivate * priv;
	char* path;
	GTimeVal last_update;
	GeeMap* files;
};

struct _SynapseHybridSearchPluginDirectoryInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseHybridSearchPluginDirectoryInfo *self);
};

struct _SynapseHybridSearchPluginAnalyzeRecentDocumentsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	GFile* recent;
	char* _tmp0_;
	GFile* _tmp1_;
	char* contents;
	gsize len;
	gboolean load_ok;
	gboolean _tmp5_;
	char* _tmp2_;
	gboolean _tmp3_;
	char* _tmp4_;
	GError * load_error;
	char* _tmp6_;
	GFile* _tmp7_;
	gboolean _tmp11_;
	char* _tmp8_;
	gboolean _tmp9_;
	char* _tmp10_;
	GBookmarkFile* bf;
	char** uris;
	gint _tmp12_;
	gint uris_length1;
	gint _uris_size_;
	char** _tmp13_;
	GeeMap* dir_hits;
	GFile* f;
	GFile* parent;
	char* parent_path;
	char** uri_collection;
	int uri_collection_length1;
	int uri_it;
	const char* uri;
	GeeList* sorted_dirs;
	GeeSet* _tmp14_;
	GeeList* directories;
	gint i;
	gboolean _tmp15_;
	gboolean _tmp16_;
	char* dir_path;
	GeeMapEntry* _tmp17_;
	char* _tmp18_;
	GFile* dir_f;
	gboolean exists;
	gint z;
	GeeIterator* _x_it;
	GeeSet* _tmp19_;
	GeeIterator* _tmp20_;
	GeeMapEntry* x;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginProcessUrisData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	GeeCollection* uris;
	GeeSet* dirs;
	GeeIterator* _uri_it;
	char* uri;
	GFile* f;
	GFileInfo* fi;
	char* parent_path;
	GFile* _tmp0_;
	char* _tmp1_;
	GError * err;
	gint _tmp2_;
	gint q_len;
	GeeIterator* _dir_it;
	char* dir;
	gint hit_count;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginUpdateDirectoryContentsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	GFile* directory;
	SynapseHybridSearchPluginDirectoryInfo* di;
	char* _tmp0_;
	GFileEnumerator* enumerator;
	GList* files;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginProcessDirectoriesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	GeeCollection* directories;
	GeeIterator* _dir_path_it;
	char* dir_path;
	GFile* directory;
	SynapseHybridSearchPluginDirectoryInfo* di;
	GTimeVal cur_time;
	SynapseHybridSearchPluginDirectoryInfo* _tmp0_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp1_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginGetExtraResultsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	SynapseQuery q;
	SynapseResultSet* original_rs;
	GeeCollection* dirs;
	SynapseResultSet* result;
	guint num_results;
	gboolean enough_results;
	SynapseResultSet* results;
	GRegexCompileFlags flags;
	GeeList* matchers;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* directories;
	GeeIterator* _directory_it;
	char* directory;
	SynapseHybridSearchPluginDirectoryInfo* di;
	GFile* dir;
	GFileInfo* dir_info;
	GTimeVal t;
	GError * err;
	SynapseRelevancyService* rel_srv;
	GeeIterator* _entry_it;
	GeeSet* _tmp2_;
	GeeIterator* _tmp3_;
	GeeMapEntry* entry;
	GeeIterator* _matcher_it;
	GeeMapEntry* matcher;
	SynapseUtilsFileInfo* fi;
	gboolean _tmp4_;
	gboolean done_io;
	gboolean _tmp5_;
	gboolean exists;
	gboolean _tmp6_;
	gint base_relevancy;
	float pop;
	gint _tmp7_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	SynapseHybridSearchPlugin * self;
	gpointer _async_data_;
};

struct _SynapseHybridSearchPluginWaitForProcessingFinishedData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	gulong sig_id;
	Block3Data* _data3_;
};

struct _Block4Data {
	int _ref_count_;
	SynapseHybridSearchPlugin * self;
	guint query_id;
	SynapseResultSet* original_rs;
	GeeSet* uris;
	gulong sig_id;
	gpointer _async_data_;
};

struct _SynapseHybridSearchPluginSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseHybridSearchPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	gboolean _tmp0_;
	char* _tmp1_;
	gint last_level_uris;
	gulong canc_sig_id;
	GObject* _tmp2_;
	gboolean _tmp3_;
	GeeList* directories;
	SynapseResultSet* _result_;
	Block4Data* _data4_;
	GError * _inner_error_;
};

struct _SynapseHybridSearchPluginMatchObject {
	GObject parent_instance;
	SynapseHybridSearchPluginMatchObjectPrivate * priv;
};

struct _SynapseHybridSearchPluginMatchObjectClass {
	GObjectClass parent_class;
};

struct _SynapseHybridSearchPluginMatchObjectPrivate {
	char* _title;
	char* _description;
	char* _icon_name;
	gboolean _has_thumbnail;
	char* _thumbnail_path;
	SynapseMatchType _match_type;
	char* _uri;
	SynapseQueryFlags _file_type;
	char* _mime_type;
};

struct _SynapseHybridSearchPluginParamSpecDirectoryInfo {
	GParamSpec parent_instance;
};


static gpointer synapse_hybrid_search_plugin_match_object_parent_class = NULL;
static SynapseMatchIface* synapse_hybrid_search_plugin_match_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface* synapse_hybrid_search_plugin_match_object_synapse_uri_match_parent_iface = NULL;
static gpointer synapse_hybrid_search_plugin_directory_info_parent_class = NULL;
static gpointer synapse_hybrid_search_plugin_parent_class = NULL;
static SynapseActivatableIface* synapse_hybrid_search_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_hybrid_search_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_hybrid_search_plugin_get_type (void) G_GNUC_CONST;
static gpointer synapse_hybrid_search_plugin_directory_info_ref (gpointer instance);
static void synapse_hybrid_search_plugin_directory_info_unref (gpointer instance);
static GParamSpec* synapse_hybrid_search_plugin_param_spec_directory_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void synapse_hybrid_search_plugin_value_set_directory_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void synapse_hybrid_search_plugin_value_take_directory_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer synapse_hybrid_search_plugin_value_get_directory_info (const GValue* value) G_GNUC_UNUSED;
static GType synapse_hybrid_search_plugin_directory_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPluginPrivate))
enum  {
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY
};
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME ".recently-used.xbel"
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MAX_RECENT_DIRS 10
static void synapse_hybrid_search_plugin_real_activate (SynapseActivatable* base);
static void synapse_hybrid_search_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_hybrid_search_plugin_register_plugin (void);
static void _synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_hybrid_search_plugin_real_constructed (GObject* base);
SynapseDataSink* synapse_hybrid_search_plugin_get_data_sink (SynapseHybridSearchPlugin* self);
static void synapse_hybrid_search_plugin_zg_plugin_search_done (SynapseHybridSearchPlugin* self, SynapseResultSet* rs, guint query_id);
static void _synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_data_sink_search_done (SynapseDataSink* _sender, SynapseResultSet* rs, guint query_id, gpointer self);
static void synapse_hybrid_search_plugin_analyze_recent_documents_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_analyze_recent_documents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_analyze_recent_documents (SynapseHybridSearchPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_analyze_recent_documents_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_);
static gboolean synapse_hybrid_search_plugin_analyze_recent_documents_co (SynapseHybridSearchPluginAnalyzeRecentDocumentsData* data);
static gint _lambda5_ (void* a, void* b, SynapseHybridSearchPlugin* self);
static gint __lambda5__gcompare_data_func (void* a, void* b, gpointer self);
static void synapse_hybrid_search_plugin_process_directories (SynapseHybridSearchPlugin* self, GeeCollection* directories, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_process_directories_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_);
static void synapse_hybrid_search_plugin_process_uris_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_process_uris_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_process_uris (SynapseHybridSearchPlugin* self, GeeCollection* uris, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_process_uris_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_);
static gboolean synapse_hybrid_search_plugin_process_uris_co (SynapseHybridSearchPluginProcessUrisData* data);
static GeeList* synapse_hybrid_search_plugin_get_most_likely_dirs (SynapseHybridSearchPlugin* self);
static gint _lambda6_ (void* a, void* b, SynapseHybridSearchPlugin* self);
static gint __lambda6__gcompare_data_func (void* a, void* b, gpointer self);
static void synapse_hybrid_search_plugin_process_directory_contents (SynapseHybridSearchPlugin* self, SynapseHybridSearchPluginDirectoryInfo* di, GFile* directory, GList* files);
static GType synapse_hybrid_search_plugin_match_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void synapse_hybrid_search_plugin_update_directory_contents_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_update_directory_contents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_update_directory_contents (SynapseHybridSearchPlugin* self, GFile* directory, SynapseHybridSearchPluginDirectoryInfo* di, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_update_directory_contents_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_, GError** error);
static gboolean synapse_hybrid_search_plugin_update_directory_contents_co (SynapseHybridSearchPluginUpdateDirectoryContentsData* data);
static void _g_list_free_g_object_unref (GList* self);
static void synapse_hybrid_search_plugin_process_directories_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_process_directories_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_hybrid_search_plugin_process_directories_co (SynapseHybridSearchPluginProcessDirectoriesData* data);
static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_new (const char* path);
static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_construct (GType object_type, const char* path);
static void synapse_hybrid_search_plugin_get_extra_results_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_get_extra_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_get_extra_results (SynapseHybridSearchPlugin* self, SynapseQuery* q, SynapseResultSet* original_rs, GeeCollection* dirs, GAsyncReadyCallback _callback_, gpointer _user_data_);
static SynapseResultSet* synapse_hybrid_search_plugin_get_extra_results_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_, GError** error);
static gboolean synapse_hybrid_search_plugin_get_extra_results_co (SynapseHybridSearchPluginGetExtraResultsData* data);
static gboolean synapse_hybrid_search_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* query);
static void synapse_hybrid_search_plugin_wait_for_processing_finished_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_wait_for_processing_finished_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_wait_for_processing_finished (SynapseHybridSearchPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_wait_for_processing_finished_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_);
static gboolean synapse_hybrid_search_plugin_wait_for_processing_finished_co (SynapseHybridSearchPluginWaitForProcessingFinishedData* data);
gboolean synapse_hybrid_search_plugin_get_processing_query (SynapseHybridSearchPlugin* self);
static void _lambda7_ (Block3Data* _data3_);
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void synapse_hybrid_search_plugin_real_search_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_hybrid_search_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_hybrid_search_plugin_real_search_co (SynapseHybridSearchPluginSearchData* data);
static void _lambda8_ (SynapseResultSet* rs, guint q_id, Block4Data* _data4_);
static void __lambda8__synapse_hybrid_search_plugin_zeitgeist_search_complete (SynapseHybridSearchPlugin* _sender, SynapseResultSet* rs, guint query_id, gpointer self);
static void _lambda9_ (Block4Data* _data4_);
static gboolean _synapse_hybrid_search_plugin_real_search_co_gsource_func (gpointer self);
static void __lambda9__gcallback (GCancellable* instance, gpointer self);
static void synapse_hybrid_search_plugin_set_processing_query (SynapseHybridSearchPlugin* self, gboolean value);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_new (void);
SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_construct (GType object_type);
static void synapse_hybrid_search_plugin_set_data_sink (SynapseHybridSearchPlugin* self, SynapseDataSink* value);
static GObject * synapse_hybrid_search_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, SynapseHybridSearchPluginMatchObjectPrivate))
enum  {
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_TITLE,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DESCRIPTION,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_ICON_NAME,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MATCH_TYPE,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_URI,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_FILE_TYPE,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MIME_TYPE
};
static SynapseHybridSearchPluginMatchObject* synapse_hybrid_search_plugin_match_object_new (const char* thumbnail_path, const char* icon);
static SynapseHybridSearchPluginMatchObject* synapse_hybrid_search_plugin_match_object_construct (GType object_type, const char* thumbnail_path, const char* icon);
static void synapse_hybrid_search_plugin_match_object_finalize (GObject* obj);
static void synapse_hybrid_search_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_hybrid_search_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_DUMMY_PROPERTY
};
static void synapse_hybrid_search_plugin_directory_info_finalize (SynapseHybridSearchPluginDirectoryInfo* obj);
static void synapse_hybrid_search_plugin_finalize (GObject* obj);
static void synapse_hybrid_search_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_hybrid_search_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void synapse_hybrid_search_plugin_real_activate (SynapseActivatable* base) {
	SynapseHybridSearchPlugin * self;
	self = (SynapseHybridSearchPlugin*) base;
}


static void synapse_hybrid_search_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseHybridSearchPlugin * self;
	self = (SynapseHybridSearchPlugin*) base;
}


static void _synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_hybrid_search_plugin_register_plugin ();
}


static void synapse_hybrid_search_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp0_ = synapse_data_sink_plugin_registry_get_default (), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, "Hybrid Search", _ ("Improve results returned by the Zeitgeist plugin by looking " "for similar files on the filesystem."), "search", _synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp0_);
}


static void _synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_data_sink_search_done (SynapseDataSink* _sender, SynapseResultSet* rs, guint query_id, gpointer self) {
	synapse_hybrid_search_plugin_zg_plugin_search_done (self, rs, query_id);
}


static void synapse_hybrid_search_plugin_real_constructed (GObject* base) {
	SynapseHybridSearchPlugin * self;
	self = (SynapseHybridSearchPlugin*) base;
	g_signal_connect_object (self->priv->_data_sink, "search-done::SynapseZeitgeistPlugin", (GCallback) _synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_data_sink_search_done, self, 0);
}


static void synapse_hybrid_search_plugin_analyze_recent_documents_data_free (gpointer _data) {
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseHybridSearchPluginAnalyzeRecentDocumentsData, data);
}


static void synapse_hybrid_search_plugin_analyze_recent_documents (SynapseHybridSearchPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginAnalyzeRecentDocumentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_analyze_recent_documents);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_analyze_recent_documents_data_free);
	_data_->self = g_object_ref (self);
	synapse_hybrid_search_plugin_analyze_recent_documents_co (_data_);
}


static void synapse_hybrid_search_plugin_analyze_recent_documents_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_) {
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_analyze_recent_documents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_analyze_recent_documents_co (data);
}


static gint _lambda5_ (void* a, void* b, SynapseHybridSearchPlugin* self) {
	gint result = 0;
	GeeMapEntry* e1;
	GeeMapEntry* e2;
	e1 = GEE_MAP_ENTRY (a);
	e2 = GEE_MAP_ENTRY (b);
	result = GPOINTER_TO_INT (gee_map_entry_get_value (e2)) - GPOINTER_TO_INT (gee_map_entry_get_value (e1));
	return result;
}


static gint __lambda5__gcompare_data_func (void* a, void* b, gpointer self) {
	gint result;
	result = _lambda5_ (a, b, self);
	return result;
}


static gboolean synapse_hybrid_search_plugin_analyze_recent_documents_co (SynapseHybridSearchPluginAnalyzeRecentDocumentsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 13:
		goto _state_13;
		case 14:
		goto _state_14;
		case 15:
		goto _state_15;
		case 16:
		goto _state_16;
	}
	_state_0:
	data->recent = (data->_tmp1_ = g_file_new_for_path (data->_tmp0_ = g_build_filename (g_get_home_dir (), SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME, NULL, NULL)), _g_free0 (data->_tmp0_), data->_tmp1_);
	{
		{
			data->_tmp2_ = NULL;
			data->_state_ = 13;
			g_file_load_contents_async (data->recent, NULL, synapse_hybrid_search_plugin_analyze_recent_documents_ready, data);
			return FALSE;
			_state_13:
			data->_tmp5_ = (data->_tmp3_ = g_file_load_contents_finish (data->recent, data->_res_, &data->_tmp2_, &data->len, NULL, &data->_inner_error_), data->contents = (data->_tmp4_ = data->_tmp2_, _g_free0 (data->contents), data->_tmp4_), data->_tmp3_);
			if (data->_inner_error_ != NULL) {
				goto __catch20_g_error;
			}
			data->load_ok = data->_tmp5_;
		}
		goto __finally20;
		__catch20_g_error:
		{
			data->load_error = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->load_ok = FALSE;
				_g_error_free0 (data->load_error);
			}
		}
		__finally20:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->contents);
			goto __catch19_g_error;
		}
		if (!data->load_ok) {
			data->recent = (data->_tmp7_ = g_file_new_for_path (data->_tmp6_ = g_build_filename (g_get_user_data_dir (), SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME, NULL, NULL)), _g_object_unref0 (data->recent), data->_tmp7_);
			_g_free0 (data->_tmp6_);
			data->_tmp8_ = NULL;
			data->_state_ = 14;
			g_file_load_contents_async (data->recent, NULL, synapse_hybrid_search_plugin_analyze_recent_documents_ready, data);
			return FALSE;
			_state_14:
			data->_tmp11_ = (data->_tmp9_ = g_file_load_contents_finish (data->recent, data->_res_, &data->_tmp8_, &data->len, NULL, &data->_inner_error_), data->contents = (data->_tmp10_ = data->_tmp8_, _g_free0 (data->contents), data->_tmp10_), data->_tmp9_);
			if (data->_inner_error_ != NULL) {
				_g_free0 (data->contents);
				goto __catch19_g_error;
			}
			data->load_ok = data->_tmp11_;
		}
		if (data->load_ok) {
			data->bf = g_bookmark_file_new ();
			g_bookmark_file_load_from_data (data->bf, data->contents, data->len, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_bookmark_file_free0 (data->bf);
				_g_free0 (data->contents);
				goto __catch19_g_error;
			}
			data->uris = (data->_tmp13_ = g_bookmark_file_get_uris (data->bf, &data->_tmp12_), data->uris_length1 = data->_tmp12_, data->_uris_size_ = data->uris_length1, data->_tmp13_);
			data->dir_hits = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			{
				data->uri_collection = data->uris;
				data->uri_collection_length1 = data->uris_length1;
				for (data->uri_it = 0; data->uri_it < data->uris_length1; data->uri_it = data->uri_it + 1) {
					data->uri = data->uri_collection[data->uri_it];
					{
						data->f = g_file_new_for_uri (data->uri);
						data->parent = g_file_get_parent (data->f);
						if (data->parent == NULL) {
							_g_object_unref0 (data->parent);
							_g_object_unref0 (data->f);
							continue;
						}
						data->parent_path = g_file_get_path (data->parent);
						if (data->parent_path == NULL) {
							_g_free0 (data->parent_path);
							_g_object_unref0 (data->parent);
							_g_object_unref0 (data->f);
							continue;
						}
						gee_map_set (data->dir_hits, data->parent_path, GINT_TO_POINTER (GPOINTER_TO_INT (gee_map_get (data->dir_hits, data->parent_path)) + 1));
						_g_free0 (data->parent_path);
						_g_object_unref0 (data->parent);
						_g_object_unref0 (data->f);
					}
				}
			}
			data->sorted_dirs = (GeeList*) gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
			gee_collection_add_all ((GeeCollection*) data->sorted_dirs, (GeeCollection*) (data->_tmp14_ = gee_map_get_entries (data->dir_hits)));
			_g_object_unref0 (data->_tmp14_);
			gee_list_sort (data->sorted_dirs, __lambda5__gcompare_data_func, g_object_ref (data->self), g_object_unref);
			data->directories = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
			{
				data->i = 0;
				{
					data->_tmp15_ = TRUE;
					while (TRUE) {
						if (!data->_tmp15_) {
							data->i++;
						}
						data->_tmp15_ = FALSE;
						if (data->i < gee_collection_get_size ((GeeCollection*) data->sorted_dirs)) {
							data->_tmp16_ = gee_collection_get_size ((GeeCollection*) data->directories) < SYNAPSE_HYBRID_SEARCH_PLUGIN_MAX_RECENT_DIRS;
						} else {
							data->_tmp16_ = FALSE;
						}
						if (!data->_tmp16_) {
							break;
						}
						data->dir_path = (data->_tmp18_ = g_strdup ((const char*) gee_map_entry_get_key (data->_tmp17_ = (GeeMapEntry*) gee_list_get (data->sorted_dirs, data->i))), _g_object_unref0 (data->_tmp17_), data->_tmp18_);
						if (g_str_has_prefix (data->dir_path, "/tmp")) {
							_g_free0 (data->dir_path);
							continue;
						}
						data->dir_f = g_file_new_for_path (data->dir_path);
						if (g_file_is_native (data->dir_f)) {
							data->_state_ = 15;
							synapse_utils_query_exists_async (data->dir_f, synapse_hybrid_search_plugin_analyze_recent_documents_ready, data);
							return FALSE;
							_state_15:
							data->exists = synapse_utils_query_exists_finish (data->_res_);
							if (data->exists) {
								gee_collection_add ((GeeCollection*) data->directories, data->dir_path);
							}
						}
						_g_object_unref0 (data->dir_f);
						_g_free0 (data->dir_path);
					}
				}
			}
			data->_state_ = 16;
			synapse_hybrid_search_plugin_process_directories (data->self, (GeeCollection*) data->directories, synapse_hybrid_search_plugin_analyze_recent_documents_ready, data);
			return FALSE;
			_state_16:
			synapse_hybrid_search_plugin_process_directories_finish (data->self, data->_res_);
			data->z = 0;
			{
				data->_x_it = (data->_tmp20_ = gee_iterable_iterator ((GeeIterable*) (data->_tmp19_ = gee_map_get_entries (data->self->priv->directory_contents))), _g_object_unref0 (data->_tmp19_), data->_tmp20_);
				while (TRUE) {
					if (!gee_iterator_next (data->_x_it)) {
						break;
					}
					data->x = (GeeMapEntry*) gee_iterator_get (data->_x_it);
					data->z = data->z + gee_map_get_size (((SynapseHybridSearchPluginDirectoryInfo*) gee_map_entry_get_value (data->x))->files);
					_g_object_unref0 (data->x);
				}
				_g_object_unref0 (data->_x_it);
			}
			synapse_utils_logger_log ((GObject*) data->self, "keeps in cache now %d file names", data->z, NULL);
			_g_object_unref0 (data->directories);
			_g_object_unref0 (data->sorted_dirs);
			_g_object_unref0 (data->dir_hits);
			data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
			_g_bookmark_file_free0 (data->bf);
		}
		_g_free0 (data->contents);
	}
	goto __finally19;
	__catch19_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			synapse_utils_logger_warning ((GObject*) data->self, "Unable to parse ~/%s", SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME, NULL);
			_g_error_free0 (data->err);
		}
	}
	__finally19:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->recent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->self->priv->initialization_done = TRUE;
	_g_object_unref0 (data->recent);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_hybrid_search_plugin_zg_plugin_search_done (SynapseHybridSearchPlugin* self, SynapseResultSet* rs, guint query_id) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "zeitgeist-search-complete", rs, query_id);
}


static void synapse_hybrid_search_plugin_process_uris_data_free (gpointer _data) {
	SynapseHybridSearchPluginProcessUrisData* data;
	data = _data;
	_g_object_unref0 (data->uris);
	g_object_unref (data->self);
	g_slice_free (SynapseHybridSearchPluginProcessUrisData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_hybrid_search_plugin_process_uris (SynapseHybridSearchPlugin* self, GeeCollection* uris, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginProcessUrisData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginProcessUrisData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_process_uris);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_process_uris_data_free);
	_data_->self = g_object_ref (self);
	_data_->uris = _g_object_ref0 (uris);
	synapse_hybrid_search_plugin_process_uris_co (_data_);
}


static void synapse_hybrid_search_plugin_process_uris_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_) {
	SynapseHybridSearchPluginProcessUrisData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_process_uris_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginProcessUrisData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_process_uris_co (data);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static gboolean synapse_hybrid_search_plugin_process_uris_co (SynapseHybridSearchPluginProcessUrisData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 17:
		goto _state_17;
	}
	_state_0:
	data->dirs = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	{
		data->_uri_it = gee_iterable_iterator ((GeeIterable*) data->uris);
		while (TRUE) {
			if (!gee_iterator_next (data->_uri_it)) {
				break;
			}
			data->uri = (char*) gee_iterator_get (data->_uri_it);
			data->f = g_file_new_for_uri (data->uri);
			{
				if (g_file_is_native (data->f)) {
					data->_state_ = 17;
					g_file_query_info_async (data->f, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_hybrid_search_plugin_process_uris_ready, data);
					return FALSE;
					_state_17:
					data->fi = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						goto __catch21_g_error;
					}
					if (g_file_info_get_file_type (data->fi) == G_FILE_TYPE_REGULAR) {
						data->parent_path = (data->_tmp1_ = g_file_get_path (data->_tmp0_ = g_file_get_parent (data->f)), _g_object_unref0 (data->_tmp0_), data->_tmp1_);
						if (data->parent_path != NULL) {
							gee_collection_add ((GeeCollection*) data->dirs, data->parent_path);
						}
						_g_free0 (data->parent_path);
					}
					_g_object_unref0 (data->fi);
				}
			}
			goto __finally21;
			__catch21_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					_g_error_free0 (data->err);
					_g_object_unref0 (data->f);
					_g_free0 (data->uri);
					continue;
				}
			}
			__finally21:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->f);
				_g_free0 (data->uri);
				_g_object_unref0 (data->_uri_it);
				_g_object_unref0 (data->dirs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			_g_object_unref0 (data->f);
			_g_free0 (data->uri);
		}
		_g_object_unref0 (data->_uri_it);
	}
	if (data->self->priv->current_query == NULL) {
		data->_tmp2_ = 1;
	} else {
		data->_tmp2_ = (gint) string_get_length (data->self->priv->current_query);
	}
	data->q_len = data->_tmp2_;
	{
		data->_dir_it = gee_iterable_iterator ((GeeIterable*) data->dirs);
		while (TRUE) {
			if (!gee_iterator_next (data->_dir_it)) {
				break;
			}
			data->dir = (char*) gee_iterator_get (data->_dir_it);
			if (gee_map_contains (data->self->priv->directory_hits, data->dir)) {
				data->hit_count = GPOINTER_TO_INT (gee_map_get (data->self->priv->directory_hits, data->dir));
				gee_map_set (data->self->priv->directory_hits, data->dir, GINT_TO_POINTER (data->hit_count + data->q_len));
			} else {
				gee_map_set (data->self->priv->directory_hits, data->dir, GINT_TO_POINTER (data->q_len));
			}
			_g_free0 (data->dir);
		}
		_g_object_unref0 (data->_dir_it);
	}
	_g_object_unref0 (data->dirs);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gint _lambda6_ (void* a, void* b, SynapseHybridSearchPlugin* self) {
	gint result = 0;
	GeeMapEntry* e1;
	GeeMapEntry* e2;
	e1 = GEE_MAP_ENTRY (a);
	e2 = GEE_MAP_ENTRY (b);
	result = GPOINTER_TO_INT (gee_map_entry_get_value (e2)) - GPOINTER_TO_INT (gee_map_entry_get_value (e1));
	return result;
}


static gint __lambda6__gcompare_data_func (void* a, void* b, gpointer self) {
	gint result;
	result = _lambda6_ (a, b, self);
	return result;
}


static GeeList* synapse_hybrid_search_plugin_get_most_likely_dirs (SynapseHybridSearchPlugin* self) {
	GeeList* result = NULL;
	gint MAX_ITEMS;
	GeeArrayList* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	MAX_ITEMS = 2;
	_result_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	if (gee_map_get_size (self->priv->directory_hits) <= MAX_ITEMS) {
		{
			GeeSet* _tmp0_;
			GeeIterator* _tmp1_;
			GeeIterator* _dir_it;
			_dir_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys (self->priv->directory_hits))), _g_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				char* dir;
				if (!gee_iterator_next (_dir_it)) {
					break;
				}
				dir = (char*) gee_iterator_get (_dir_it);
				gee_abstract_collection_add ((GeeAbstractCollection*) _result_, dir);
				_g_free0 (dir);
			}
			_g_object_unref0 (_dir_it);
		}
	} else {
		GeeArrayList* sort_array;
		gint min_hit;
		gint count;
		sort_array = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		min_hit = G_MAXINT;
		{
			GeeSet* _tmp2_;
			GeeIterator* _tmp3_;
			GeeIterator* _entry_it;
			_entry_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_entries (self->priv->directory_hits))), _g_object_unref0 (_tmp2_), _tmp3_);
			while (TRUE) {
				GeeMapEntry* entry;
				if (!gee_iterator_next (_entry_it)) {
					break;
				}
				entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
				if (GPOINTER_TO_INT (gee_map_entry_get_value (entry)) < min_hit) {
					min_hit = GPOINTER_TO_INT (gee_map_entry_get_value (entry));
				}
				_g_object_unref0 (entry);
			}
			_g_object_unref0 (_entry_it);
		}
		{
			GeeSet* _tmp4_;
			GeeIterator* _tmp5_;
			GeeIterator* _entry_it;
			_entry_it = (_tmp5_ = gee_iterable_iterator ((GeeIterable*) (_tmp4_ = gee_map_get_entries (self->priv->directory_hits))), _g_object_unref0 (_tmp4_), _tmp5_);
			while (TRUE) {
				GeeMapEntry* entry;
				if (!gee_iterator_next (_entry_it)) {
					break;
				}
				entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
				if (GPOINTER_TO_INT (gee_map_entry_get_value (entry)) > min_hit) {
					gee_abstract_collection_add ((GeeAbstractCollection*) sort_array, entry);
				}
				_g_object_unref0 (entry);
			}
			_g_object_unref0 (_entry_it);
		}
		gee_list_sort ((GeeList*) sort_array, __lambda6__gcompare_data_func, g_object_ref (self), g_object_unref);
		count = 0;
		{
			GeeIterator* _entry_it;
			_entry_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) sort_array);
			while (TRUE) {
				GeeMapEntry* entry;
				if (!gee_iterator_next (_entry_it)) {
					break;
				}
				entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
				gee_abstract_collection_add ((GeeAbstractCollection*) _result_, (const char*) gee_map_entry_get_key (entry));
				if ((count++) >= (MAX_ITEMS - 1)) {
					_g_object_unref0 (entry);
					break;
				}
				_g_object_unref0 (entry);
			}
			_g_object_unref0 (_entry_it);
		}
		_g_object_unref0 (sort_array);
	}
	result = (GeeList*) _result_;
	return result;
}


static void synapse_hybrid_search_plugin_process_directory_contents (SynapseHybridSearchPlugin* self, SynapseHybridSearchPluginDirectoryInfo* di, GFile* directory, GList* files) {
	GTimeVal _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (di != NULL);
	g_return_if_fail (directory != NULL);
	di->last_update = (g_get_current_time (&_tmp0_), _tmp0_);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFileInfo* f;
			f = _g_object_ref0 ((GFileInfo*) f_it->data);
			{
				const char* name;
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				GFile* child;
				char* _tmp4_;
				SynapseUtilsFileInfo* _tmp5_;
				SynapseUtilsFileInfo* file_info;
				name = g_file_info_get_name (f);
				if (g_str_has_suffix (name, ".o")) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = g_str_has_suffix (name, ".lo");
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = g_str_has_suffix (name, ".mo");
				}
				if (_tmp2_) {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = g_str_has_suffix (name, ".gmo");
				}
				if (_tmp1_) {
					_g_object_unref0 (f);
					continue;
				}
				child = g_file_get_child (directory, name);
				file_info = (_tmp5_ = synapse_utils_file_info_new (_tmp4_ = g_file_get_uri (child), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT), _g_free0 (_tmp4_), _tmp5_);
				gee_map_set (di->files, file_info->uri, file_info);
				_synapse_utils_file_info_unref0 (file_info);
				_g_object_unref0 (child);
				_g_object_unref0 (f);
			}
		}
	}
}


static void synapse_hybrid_search_plugin_update_directory_contents_data_free (gpointer _data) {
	SynapseHybridSearchPluginUpdateDirectoryContentsData* data;
	data = _data;
	_g_object_unref0 (data->directory);
	_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
	g_object_unref (data->self);
	g_slice_free (SynapseHybridSearchPluginUpdateDirectoryContentsData, data);
}


static gpointer _synapse_hybrid_search_plugin_directory_info_ref0 (gpointer self) {
	return self ? synapse_hybrid_search_plugin_directory_info_ref (self) : NULL;
}


static void synapse_hybrid_search_plugin_update_directory_contents (SynapseHybridSearchPlugin* self, GFile* directory, SynapseHybridSearchPluginDirectoryInfo* di, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginUpdateDirectoryContentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_update_directory_contents);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_update_directory_contents_data_free);
	_data_->self = g_object_ref (self);
	_data_->directory = _g_object_ref0 (directory);
	_data_->di = _synapse_hybrid_search_plugin_directory_info_ref0 (di);
	synapse_hybrid_search_plugin_update_directory_contents_co (_data_);
}


static void synapse_hybrid_search_plugin_update_directory_contents_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_, GError** error) {
	SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_update_directory_contents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginUpdateDirectoryContentsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_update_directory_contents_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean synapse_hybrid_search_plugin_update_directory_contents_co (SynapseHybridSearchPluginUpdateDirectoryContentsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 18:
		goto _state_18;
		case 19:
		goto _state_19;
	}
	_state_0:
	synapse_utils_logger_debug ((GObject*) data->self, "hybrid-search-plugin.vala:334: Scanning %s", data->_tmp0_ = g_file_get_path (data->directory), NULL);
	_g_free0 (data->_tmp0_);
	data->_state_ = 18;
	g_file_enumerate_children_async (data->directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, 0, NULL, synapse_hybrid_search_plugin_update_directory_contents_ready, data);
	return FALSE;
	_state_18:
	data->enumerator = g_file_enumerate_children_finish (data->directory, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 19;
	g_file_enumerator_next_files_async (data->enumerator, 1024, 0, NULL, synapse_hybrid_search_plugin_update_directory_contents_ready, data);
	return FALSE;
	_state_19:
	data->files = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->enumerator);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	gee_map_clear (data->di->files);
	synapse_hybrid_search_plugin_process_directory_contents (data->self, data->di, data->directory, data->files);
	__g_list_free_g_object_unref0 (data->files);
	_g_object_unref0 (data->enumerator);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_hybrid_search_plugin_process_directories_data_free (gpointer _data) {
	SynapseHybridSearchPluginProcessDirectoriesData* data;
	data = _data;
	_g_object_unref0 (data->directories);
	g_object_unref (data->self);
	g_slice_free (SynapseHybridSearchPluginProcessDirectoriesData, data);
}


static void synapse_hybrid_search_plugin_process_directories (SynapseHybridSearchPlugin* self, GeeCollection* directories, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginProcessDirectoriesData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginProcessDirectoriesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_process_directories);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_process_directories_data_free);
	_data_->self = g_object_ref (self);
	_data_->directories = _g_object_ref0 (directories);
	synapse_hybrid_search_plugin_process_directories_co (_data_);
}


static void synapse_hybrid_search_plugin_process_directories_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_) {
	SynapseHybridSearchPluginProcessDirectoriesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_process_directories_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginProcessDirectoriesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_process_directories_co (data);
}


static gboolean synapse_hybrid_search_plugin_process_directories_co (SynapseHybridSearchPluginProcessDirectoriesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 20:
		goto _state_20;
	}
	_state_0:
	{
		data->_dir_path_it = gee_iterable_iterator ((GeeIterable*) data->directories);
		while (TRUE) {
			if (!gee_iterator_next (data->_dir_path_it)) {
				break;
			}
			data->dir_path = (char*) gee_iterator_get (data->_dir_path_it);
			data->directory = g_file_new_for_path (data->dir_path);
			{
				if (gee_map_contains (data->self->priv->directory_contents, data->dir_path)) {
					g_get_current_time (&data->cur_time);
					data->di = (data->_tmp0_ = (SynapseHybridSearchPluginDirectoryInfo*) gee_map_get (data->self->priv->directory_contents, data->dir_path), _synapse_hybrid_search_plugin_directory_info_unref0 (data->di), data->_tmp0_);
					if ((data->cur_time.tv_sec - data->di->last_update.tv_sec) <= (5 * 60)) {
						_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
						_g_object_unref0 (data->directory);
						_g_free0 (data->dir_path);
						continue;
					}
				} else {
					data->di = (data->_tmp1_ = synapse_hybrid_search_plugin_directory_info_new (data->dir_path), _synapse_hybrid_search_plugin_directory_info_unref0 (data->di), data->_tmp1_);
					gee_map_set (data->self->priv->directory_contents, data->dir_path, data->di);
				}
				data->_state_ = 20;
				synapse_hybrid_search_plugin_update_directory_contents (data->self, data->directory, data->di, synapse_hybrid_search_plugin_process_directories_ready, data);
				return FALSE;
				_state_20:
				synapse_hybrid_search_plugin_update_directory_contents_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					goto __catch22_g_error;
				}
				_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
			}
			goto __finally22;
			__catch22_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					_g_error_free0 (data->err);
				}
			}
			__finally22:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->directory);
				_g_free0 (data->dir_path);
				_g_object_unref0 (data->_dir_path_it);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			_g_object_unref0 (data->directory);
			_g_free0 (data->dir_path);
		}
		_g_object_unref0 (data->_dir_path_it);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_hybrid_search_plugin_get_extra_results_data_free (gpointer _data) {
	SynapseHybridSearchPluginGetExtraResultsData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->original_rs);
	_g_object_unref0 (data->dirs);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (SynapseHybridSearchPluginGetExtraResultsData, data);
}


static void synapse_hybrid_search_plugin_get_extra_results (SynapseHybridSearchPlugin* self, SynapseQuery* q, SynapseResultSet* original_rs, GeeCollection* dirs, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginGetExtraResultsData* _data_;
	SynapseQuery _tmp0_ = {0};
	_data_ = g_slice_new0 (SynapseHybridSearchPluginGetExtraResultsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_get_extra_results);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_get_extra_results_data_free);
	_data_->self = g_object_ref (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	_data_->original_rs = _g_object_ref0 (original_rs);
	_data_->dirs = _g_object_ref0 (dirs);
	synapse_hybrid_search_plugin_get_extra_results_co (_data_);
}


static SynapseResultSet* synapse_hybrid_search_plugin_get_extra_results_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseHybridSearchPluginGetExtraResultsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_hybrid_search_plugin_get_extra_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginGetExtraResultsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_get_extra_results_co (data);
}


static gpointer _synapse_utils_file_info_ref0 (gpointer self) {
	return self ? synapse_utils_file_info_ref (self) : NULL;
}


static gboolean synapse_hybrid_search_plugin_get_extra_results_co (SynapseHybridSearchPluginGetExtraResultsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 21:
		goto _state_21;
		case 22:
		goto _state_22;
		case 23:
		goto _state_23;
		case 24:
		goto _state_24;
	}
	_state_0:
	data->num_results = (guint) 0;
	data->enough_results = FALSE;
	data->results = synapse_result_set_new ();
	data->flags = G_REGEX_OPTIMIZE | G_REGEX_CASELESS;
	data->matchers = synapse_query_get_matchers_for_query (data->q.query_string, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, data->flags);
	data->_tmp0_ = _g_object_ref0 (data->dirs);
	if (data->_tmp0_ == NULL) {
		data->_tmp0_ = (data->_tmp1_ = (GeeCollection*) gee_map_get_keys (data->self->priv->directory_contents), _g_object_unref0 (data->_tmp0_), data->_tmp1_);
	}
	data->directories = _g_object_ref0 (data->_tmp0_);
	{
		data->_directory_it = gee_iterable_iterator ((GeeIterable*) data->directories);
		while (TRUE) {
			if (!gee_iterator_next (data->_directory_it)) {
				break;
			}
			data->directory = (char*) gee_iterator_get (data->_directory_it);
			data->di = (SynapseHybridSearchPluginDirectoryInfo*) gee_map_get (data->self->priv->directory_contents, data->directory);
			data->dir = g_file_new_for_path (data->directory);
			{
				data->_state_ = 21;
				g_file_query_info_async (data->dir, "time::*", 0, 0, NULL, synapse_hybrid_search_plugin_get_extra_results_ready, data);
				return FALSE;
				_state_21:
				data->dir_info = g_file_query_info_finish (data->dir, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch23_g_error;
				}
				g_get_current_time (&data->t);
				g_file_info_get_modification_time (data->dir_info, &data->t);
				if (data->t.tv_sec > data->di->last_update.tv_sec) {
					data->_state_ = 22;
					synapse_hybrid_search_plugin_update_directory_contents (data->self, data->dir, data->di, synapse_hybrid_search_plugin_get_extra_results_ready, data);
					return FALSE;
					_state_22:
					synapse_hybrid_search_plugin_update_directory_contents_finish (data->self, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->dir_info);
						goto __catch23_g_error;
					}
				}
				_g_object_unref0 (data->dir_info);
			}
			goto __finally23;
			__catch23_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					synapse_utils_logger_warning ((GObject*) data->self, "%s", data->err->message, NULL);
					_g_error_free0 (data->err);
				}
			}
			__finally23:
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->dir);
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_free0 (data->directory);
					_g_object_unref0 (data->_directory_it);
					_g_object_unref0 (data->directories);
					_g_object_unref0 (data->_tmp0_);
					_g_object_unref0 (data->matchers);
					_g_object_unref0 (data->results);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				} else {
					_g_object_unref0 (data->dir);
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_free0 (data->directory);
					_g_object_unref0 (data->_directory_it);
					_g_object_unref0 (data->directories);
					_g_object_unref0 (data->_tmp0_);
					_g_object_unref0 (data->matchers);
					_g_object_unref0 (data->results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			data->rel_srv = synapse_relevancy_service_get_default ();
			{
				data->_entry_it = (data->_tmp3_ = gee_iterable_iterator ((GeeIterable*) (data->_tmp2_ = gee_map_get_entries (data->di->files))), _g_object_unref0 (data->_tmp2_), data->_tmp3_);
				while (TRUE) {
					if (!gee_iterator_next (data->_entry_it)) {
						break;
					}
					data->entry = (GeeMapEntry*) gee_iterator_get (data->_entry_it);
					{
						data->_matcher_it = gee_iterable_iterator ((GeeIterable*) data->matchers);
						while (TRUE) {
							if (!gee_iterator_next (data->_matcher_it)) {
								break;
							}
							data->matcher = (GeeMapEntry*) gee_iterator_get (data->_matcher_it);
							data->fi = _synapse_utils_file_info_ref0 ((SynapseUtilsFileInfo*) gee_map_entry_get_value (data->entry));
							if (g_regex_match ((GRegex*) gee_map_entry_get_key (data->matcher), data->fi->parse_name, 0, NULL)) {
								if (data->original_rs == NULL) {
									data->_tmp4_ = TRUE;
								} else {
									data->_tmp4_ = !synapse_result_set_contains_uri (data->original_rs, data->fi->uri);
								}
								if (data->_tmp4_) {
									data->done_io = FALSE;
									if (!synapse_utils_file_info_is_initialized (data->fi)) {
										data->_state_ = 23;
										synapse_utils_file_info_initialize (data->fi, synapse_hybrid_search_plugin_get_extra_results_ready, data);
										return FALSE;
										_state_23:
										synapse_utils_file_info_initialize_finish (data->fi, data->_res_);
										data->done_io = TRUE;
									} else {
										if (data->fi->match_obj != NULL) {
											data->_tmp5_ = (data->q.query_type & data->fi->file_type) == data->fi->file_type;
										} else {
											data->_tmp5_ = FALSE;
										}
										if (data->_tmp5_) {
											data->_state_ = 24;
											synapse_utils_file_info_exists (data->fi, synapse_hybrid_search_plugin_get_extra_results_ready, data);
											return FALSE;
											_state_24:
											data->exists = synapse_utils_file_info_exists_finish (data->fi, data->_res_);
											if (!data->exists) {
												_synapse_utils_file_info_unref0 (data->fi);
												_g_object_unref0 (data->matcher);
												break;
											}
											data->done_io = TRUE;
										}
									}
									if (data->fi->match_obj != NULL) {
										data->_tmp6_ = (data->q.query_type & data->fi->file_type) == data->fi->file_type;
									} else {
										data->_tmp6_ = FALSE;
									}
									if (data->_tmp6_) {
										data->base_relevancy = GPOINTER_TO_INT (gee_map_entry_get_value (data->matcher)) - SYNAPSE_MATCH_SCORE_URI_PENALTY;
										data->pop = synapse_relevancy_service_get_uri_popularity (data->rel_srv, data->fi->uri);
										synapse_result_set_add (data->results, (SynapseMatch*) data->fi->match_obj, synapse_relevancy_service_compute_relevancy (data->base_relevancy, data->pop));
										data->num_results++;
									}
									if (data->done_io) {
										synapse_query_check_cancellable (&data->q, &data->_inner_error_);
										if (data->_inner_error_ != NULL) {
											if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
												g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
												g_error_free (data->_inner_error_);
												_synapse_utils_file_info_unref0 (data->fi);
												_g_object_unref0 (data->matcher);
												_g_object_unref0 (data->_matcher_it);
												_g_object_unref0 (data->entry);
												_g_object_unref0 (data->_entry_it);
												_g_object_unref0 (data->rel_srv);
												_g_object_unref0 (data->dir);
												_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
												_g_free0 (data->directory);
												_g_object_unref0 (data->_directory_it);
												_g_object_unref0 (data->directories);
												_g_object_unref0 (data->_tmp0_);
												_g_object_unref0 (data->matchers);
												_g_object_unref0 (data->results);
												{
													if (data->_state_ == 0) {
														g_simple_async_result_complete_in_idle (data->_async_result);
													} else {
														g_simple_async_result_complete (data->_async_result);
													}
													g_object_unref (data->_async_result);
													return FALSE;
												}
											} else {
												_synapse_utils_file_info_unref0 (data->fi);
												_g_object_unref0 (data->matcher);
												_g_object_unref0 (data->_matcher_it);
												_g_object_unref0 (data->entry);
												_g_object_unref0 (data->_entry_it);
												_g_object_unref0 (data->rel_srv);
												_g_object_unref0 (data->dir);
												_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
												_g_free0 (data->directory);
												_g_object_unref0 (data->_directory_it);
												_g_object_unref0 (data->directories);
												_g_object_unref0 (data->_tmp0_);
												_g_object_unref0 (data->matchers);
												_g_object_unref0 (data->results);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
												g_clear_error (&data->_inner_error_);
												return FALSE;
											}
										}
									}
								}
								_synapse_utils_file_info_unref0 (data->fi);
								_g_object_unref0 (data->matcher);
								break;
							}
							_synapse_utils_file_info_unref0 (data->fi);
							_g_object_unref0 (data->matcher);
						}
						_g_object_unref0 (data->_matcher_it);
					}
					if (data->num_results >= data->q.max_results) {
						data->enough_results = TRUE;
						_g_object_unref0 (data->entry);
						break;
					}
					_g_object_unref0 (data->entry);
				}
				_g_object_unref0 (data->_entry_it);
			}
			synapse_query_check_cancellable (&data->q, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->rel_srv);
					_g_object_unref0 (data->dir);
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_free0 (data->directory);
					_g_object_unref0 (data->_directory_it);
					_g_object_unref0 (data->directories);
					_g_object_unref0 (data->_tmp0_);
					_g_object_unref0 (data->matchers);
					_g_object_unref0 (data->results);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				} else {
					_g_object_unref0 (data->rel_srv);
					_g_object_unref0 (data->dir);
					_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
					_g_free0 (data->directory);
					_g_object_unref0 (data->_directory_it);
					_g_object_unref0 (data->directories);
					_g_object_unref0 (data->_tmp0_);
					_g_object_unref0 (data->matchers);
					_g_object_unref0 (data->results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			if (data->enough_results) {
				_g_object_unref0 (data->rel_srv);
				_g_object_unref0 (data->dir);
				_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
				_g_free0 (data->directory);
				break;
			}
			_g_object_unref0 (data->rel_srv);
			_g_object_unref0 (data->dir);
			_synapse_hybrid_search_plugin_directory_info_unref0 (data->di);
			_g_free0 (data->directory);
		}
		_g_object_unref0 (data->_directory_it);
	}
	if (gee_collection_get_size (data->directories) == 0) {
		synapse_query_check_cancellable (&data->q, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->directories);
				_g_object_unref0 (data->_tmp0_);
				_g_object_unref0 (data->matchers);
				_g_object_unref0 (data->results);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				_g_object_unref0 (data->directories);
				_g_object_unref0 (data->_tmp0_);
				_g_object_unref0 (data->matchers);
				_g_object_unref0 (data->results);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	if (data->original_rs == NULL) {
		data->_tmp7_ = 0;
	} else {
		data->_tmp7_ = synapse_result_set_get_size (data->original_rs);
	}
	synapse_utils_logger_debug ((GObject*) data->self, "hybrid-search-plugin.vala:468: found %d extra uris (ZG returned %d)", synapse_result_set_get_size (data->results), data->_tmp7_, NULL);
	data->result = data->results;
	_g_object_unref0 (data->directories);
	_g_object_unref0 (data->_tmp0_);
	_g_object_unref0 (data->matchers);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->directories);
	_g_object_unref0 (data->_tmp0_);
	_g_object_unref0 (data->matchers);
	_g_object_unref0 (data->results);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gboolean synapse_hybrid_search_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* query) {
	SynapseHybridSearchPlugin * self;
	gboolean result = FALSE;
	SynapseQueryFlags our_results;
	SynapseQueryFlags common_flags;
	self = (SynapseHybridSearchPlugin*) base;
	our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
	common_flags = (*query).query_type & our_results;
	result = common_flags != 0;
	return result;
}


static void synapse_hybrid_search_plugin_wait_for_processing_finished_data_free (gpointer _data) {
	SynapseHybridSearchPluginWaitForProcessingFinishedData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseHybridSearchPluginWaitForProcessingFinishedData, data);
}


static void synapse_hybrid_search_plugin_wait_for_processing_finished (SynapseHybridSearchPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPluginWaitForProcessingFinishedData* _data_;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginWaitForProcessingFinishedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_wait_for_processing_finished);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_wait_for_processing_finished_data_free);
	_data_->self = g_object_ref (self);
	synapse_hybrid_search_plugin_wait_for_processing_finished_co (_data_);
}


static void synapse_hybrid_search_plugin_wait_for_processing_finished_finish (SynapseHybridSearchPlugin* self, GAsyncResult* _res_) {
	SynapseHybridSearchPluginWaitForProcessingFinishedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_hybrid_search_plugin_wait_for_processing_finished_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginWaitForProcessingFinishedData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_wait_for_processing_finished_co (data);
}


static void _lambda7_ (Block3Data* _data3_) {
	SynapseHybridSearchPlugin * self;
	self = _data3_->self;
	if (self->priv->_processing_query) {
		return;
	}
	synapse_hybrid_search_plugin_wait_for_processing_finished_co (_data3_->_async_data_);
}


static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda7_ (self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean synapse_hybrid_search_plugin_wait_for_processing_finished_co (SynapseHybridSearchPluginWaitForProcessingFinishedData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 25:
		goto _state_25;
	}
	_state_0:
	data->_data3_ = g_slice_new0 (Block3Data);
	data->_data3_->_ref_count_ = 1;
	data->_data3_->self = g_object_ref (data->self);
	data->_data3_->_async_data_ = data;
	while (TRUE) {
		if (!data->self->priv->_processing_query) {
			break;
		}
		data->sig_id = g_signal_connect_data ((GObject*) data->self, "notify::processing-query", (GCallback) __lambda7__g_object_notify, block3_data_ref (data->_data3_), (GClosureNotify) block3_data_unref, 0);
		data->_state_ = 25;
		return FALSE;
		_state_25:
		;
		g_signal_handler_disconnect (data->self, data->sig_id);
	}
	block3_data_unref (data->_data3_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_hybrid_search_plugin_real_search_data_free (gpointer _data) {
	SynapseHybridSearchPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (SynapseHybridSearchPluginSearchData, data);
}


static void synapse_hybrid_search_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseHybridSearchPlugin * self;
	SynapseHybridSearchPluginSearchData* _data_;
	SynapseQuery _tmp1_ = {0};
	self = (SynapseHybridSearchPlugin*) base;
	_data_ = g_slice_new0 (SynapseHybridSearchPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_hybrid_search_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_hybrid_search_plugin_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->q = (synapse_query_copy (q, &_tmp1_), _tmp1_);
	synapse_hybrid_search_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_hybrid_search_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseHybridSearchPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_hybrid_search_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseHybridSearchPluginSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_hybrid_search_plugin_real_search_co (data);
}


static void _lambda8_ (SynapseResultSet* rs, guint q_id, Block4Data* _data4_) {
	SynapseHybridSearchPlugin * self;
	SynapseResultSet* _tmp1_;
	self = _data4_->self;
	if (q_id != _data4_->query_id) {
		return;
	}
	{
		GeeIterator* _match_it;
		_match_it = gee_iterable_iterator ((GeeIterable*) rs);
		while (TRUE) {
			GeeMapEntry* match;
			SynapseMatch* _tmp0_;
			SynapseUriMatch* uri_match;
			if (!gee_iterator_next (_match_it)) {
				break;
			}
			match = (GeeMapEntry*) gee_iterator_get (_match_it);
			uri_match = (_tmp0_ = (SynapseMatch*) gee_map_entry_get_key (match), SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL);
			if (uri_match == NULL) {
				_g_object_unref0 (match);
				continue;
			}
			gee_collection_add ((GeeCollection*) _data4_->uris, synapse_uri_match_get_uri (uri_match));
			_g_object_unref0 (match);
		}
		_g_object_unref0 (_match_it);
	}
	_data4_->original_rs = (_tmp1_ = _g_object_ref0 (rs), _g_object_unref0 (_data4_->original_rs), _tmp1_);
	synapse_hybrid_search_plugin_real_search_co (_data4_->_async_data_);
}


static void __lambda8__synapse_hybrid_search_plugin_zeitgeist_search_complete (SynapseHybridSearchPlugin* _sender, SynapseResultSet* rs, guint query_id, gpointer self) {
	_lambda8_ (rs, query_id, self);
}


static gboolean _synapse_hybrid_search_plugin_real_search_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_hybrid_search_plugin_real_search_co (self);
	return result;
}


static void _lambda9_ (Block4Data* _data4_) {
	SynapseHybridSearchPlugin * self;
	self = _data4_->self;
	g_signal_handler_block (self, _data4_->sig_id);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_hybrid_search_plugin_real_search_co_gsource_func, _data4_->_async_data_, NULL);
}


static void __lambda9__gcallback (GCancellable* instance, gpointer self) {
	_lambda9_ (self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->uris);
		_g_object_unref0 (_data4_->original_rs);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean synapse_hybrid_search_plugin_real_search_co (SynapseHybridSearchPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 26:
		goto _state_26;
		case 27:
		goto _state_27;
		case 28:
		goto _state_28;
		case 29:
		goto _state_29;
		case 30:
		goto _state_30;
		case 31:
		goto _state_31;
	}
	_state_0:
	data->_data4_ = g_slice_new0 (Block4Data);
	data->_data4_->_ref_count_ = 1;
	data->_data4_->self = g_object_ref (data->self);
	data->_data4_->_async_data_ = data;
	if (string_get_length (data->q.query_string) <= 1) {
		data->result = NULL;
		block4_data_unref (data->_data4_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->self->priv->current_query != NULL) {
		data->_tmp0_ = !g_str_has_prefix (data->q.query_string, data->self->priv->current_query);
	} else {
		data->_tmp0_ = FALSE;
	}
	if (data->_tmp0_) {
		data->self->priv->hit_level = 0;
		data->self->priv->current_level_uris = 0;
		gee_map_clear (data->self->priv->directory_hits);
	}
	data->_data4_->query_id = data->q.query_id;
	data->self->priv->current_query = (data->_tmp1_ = g_strdup (data->q.query_string), _g_free0 (data->self->priv->current_query), data->_tmp1_);
	data->last_level_uris = data->self->priv->current_level_uris;
	data->_data4_->original_rs = NULL;
	data->_data4_->uris = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	data->_data4_->sig_id = g_signal_connect_data (data->self, "zeitgeist-search-complete", (GCallback) __lambda8__synapse_hybrid_search_plugin_zeitgeist_search_complete, block4_data_ref (data->_data4_), (GClosureNotify) block4_data_unref, 0);
	data->canc_sig_id = g_cancellable_connect (data->q.cancellable, __lambda9__gcallback, block4_data_ref (data->_data4_), block4_data_unref);
	if (synapse_activatable_get_enabled ((SynapseActivatable*) (data->_tmp2_ = synapse_data_sink_get_plugin (data->self->priv->_data_sink, "SynapseZeitgeistPlugin"), SYNAPSE_IS_ITEM_PROVIDER (data->_tmp2_) ? ((SynapseItemProvider*) data->_tmp2_) : NULL))) {
		data->_state_ = 26;
		return FALSE;
		_state_26:
		;
	}
	g_signal_handler_disconnect (data->self, data->_data4_->sig_id);
	g_cancellable_disconnect (data->q.cancellable, data->canc_sig_id);
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block4_data_unref (data->_data4_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			block4_data_unref (data->_data4_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	while (TRUE) {
		if (!(!data->self->priv->initialization_done)) {
			break;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _synapse_hybrid_search_plugin_real_search_co_gsource_func, data, NULL);
		data->_state_ = 27;
		return FALSE;
		_state_27:
		;
		synapse_query_check_cancellable (&data->q, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				block4_data_unref (data->_data4_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				block4_data_unref (data->_data4_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	while (TRUE) {
		if (!data->self->priv->_processing_query) {
			break;
		}
		data->_state_ = 28;
		synapse_hybrid_search_plugin_wait_for_processing_finished (data->self, synapse_hybrid_search_plugin_search_ready, data);
		return FALSE;
		_state_28:
		synapse_hybrid_search_plugin_wait_for_processing_finished_finish (data->self, data->_res_);
		synapse_query_check_cancellable (&data->q, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				block4_data_unref (data->_data4_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				block4_data_unref (data->_data4_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	synapse_hybrid_search_plugin_set_processing_query (data->self, TRUE);
	{
		data->self->priv->current_level_uris = gee_collection_get_size ((GeeCollection*) data->_data4_->uris);
		if (data->self->priv->current_level_uris > 0) {
			data->_state_ = 29;
			synapse_hybrid_search_plugin_process_uris (data->self, (GeeCollection*) data->_data4_->uris, synapse_hybrid_search_plugin_search_ready, data);
			return FALSE;
			_state_29:
			synapse_hybrid_search_plugin_process_uris_finish (data->self, data->_res_);
			synapse_query_check_cancellable (&data->q, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __finally24;
			}
		}
		data->self->priv->hit_level++;
		if (data->self->priv->hit_level > 1) {
			data->_tmp3_ = string_get_length (data->q.query_string) >= 3;
		} else {
			data->_tmp3_ = FALSE;
		}
		if (data->_tmp3_) {
			if ((data->self->priv->current_level_uris * 3) > (2 * data->last_level_uris)) {
				data->directories = synapse_hybrid_search_plugin_get_most_likely_dirs (data->self);
				data->_state_ = 30;
				synapse_hybrid_search_plugin_process_directories (data->self, (GeeCollection*) data->directories, synapse_hybrid_search_plugin_search_ready, data);
				return FALSE;
				_state_30:
				synapse_hybrid_search_plugin_process_directories_finish (data->self, data->_res_);
				synapse_query_check_cancellable (&data->q, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->directories);
					goto __finally24;
				}
				_g_object_unref0 (data->directories);
			}
		}
		data->_state_ = 31;
		synapse_hybrid_search_plugin_get_extra_results (data->self, &data->q, data->_data4_->original_rs, NULL, synapse_hybrid_search_plugin_search_ready, data);
		return FALSE;
		_state_31:
		data->_result_ = synapse_hybrid_search_plugin_get_extra_results_finish (data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __finally24;
		}
		data->result = data->_result_;
		{
			synapse_hybrid_search_plugin_set_processing_query (data->self, FALSE);
		}
		block4_data_unref (data->_data4_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->_result_);
	}
	__finally24:
	{
		synapse_hybrid_search_plugin_set_processing_query (data->self, FALSE);
	}
	{
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block4_data_unref (data->_data4_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			block4_data_unref (data->_data4_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	block4_data_unref (data->_data4_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_construct (GType object_type) {
	SynapseHybridSearchPlugin * self = NULL;
	self = (SynapseHybridSearchPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_new (void) {
	return synapse_hybrid_search_plugin_construct (SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN);
}


SynapseDataSink* synapse_hybrid_search_plugin_get_data_sink (SynapseHybridSearchPlugin* self) {
	SynapseDataSink* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_data_sink;
	return result;
}


static void synapse_hybrid_search_plugin_set_data_sink (SynapseHybridSearchPlugin* self, SynapseDataSink* value) {
	g_return_if_fail (self != NULL);
	self->priv->_data_sink = value;
	g_object_notify ((GObject *) self, "data-sink");
}


static gboolean synapse_hybrid_search_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseHybridSearchPlugin* self;
	self = (SynapseHybridSearchPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_hybrid_search_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseHybridSearchPlugin* self;
	self = (SynapseHybridSearchPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


gboolean synapse_hybrid_search_plugin_get_processing_query (SynapseHybridSearchPlugin* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_processing_query;
	return result;
}


static void synapse_hybrid_search_plugin_set_processing_query (SynapseHybridSearchPlugin* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_processing_query = value;
	g_object_notify ((GObject *) self, "processing-query");
}


static GObject * synapse_hybrid_search_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseHybridSearchPlugin * self;
	parent_class = G_OBJECT_CLASS (synapse_hybrid_search_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN (obj);
	{
		GeeMap* _tmp2_;
		GeeMap* _tmp3_;
		self->priv->directory_hits = (_tmp2_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->directory_hits), _tmp2_);
		self->priv->directory_contents = (_tmp3_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SYNAPSE_UTILS_TYPE_FILE_INFO, (GBoxedCopyFunc) synapse_utils_file_info_ref, synapse_utils_file_info_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->directory_contents), _tmp3_);
		synapse_hybrid_search_plugin_analyze_recent_documents (self, NULL, NULL);
	}
	return obj;
}


static SynapseHybridSearchPluginMatchObject* synapse_hybrid_search_plugin_match_object_construct (GType object_type, const char* thumbnail_path, const char* icon) {
	SynapseHybridSearchPluginMatchObject * self = NULL;
	char* _tmp0_;
	char* _tmp2_;
	_tmp0_ = g_strdup (icon);
	if (_tmp0_ == NULL) {
		char* _tmp1_;
		_tmp0_ = (_tmp1_ = g_strdup (""), _g_free0 (_tmp0_), _tmp1_);
	}
	_tmp2_ = g_strdup (thumbnail_path);
	if (_tmp2_ == NULL) {
		char* _tmp3_;
		_tmp2_ = (_tmp3_ = g_strdup (""), _g_free0 (_tmp2_), _tmp3_);
	}
	self = (SynapseHybridSearchPluginMatchObject*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp0_, "thumbnail-path", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp0_);
	return self;
}


static SynapseHybridSearchPluginMatchObject* synapse_hybrid_search_plugin_match_object_new (const char* thumbnail_path, const char* icon) {
	return synapse_hybrid_search_plugin_match_object_construct (SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_MATCH_OBJECT, thumbnail_path, icon);
}


static const char* synapse_hybrid_search_plugin_match_object_real_get_title (SynapseMatch* base) {
	const char* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_title (SynapseMatch* base, const char* value) {
	SynapseHybridSearchPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_title = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_title), _tmp0_);
	g_object_notify ((GObject *) self, "title");
}


static const char* synapse_hybrid_search_plugin_match_object_real_get_description (SynapseMatch* base) {
	const char* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_description (SynapseMatch* base, const char* value) {
	SynapseHybridSearchPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


static const char* synapse_hybrid_search_plugin_match_object_real_get_icon_name (SynapseMatch* base) {
	const char* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_icon_name (SynapseMatch* base, const char* value) {
	SynapseHybridSearchPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_hybrid_search_plugin_match_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const char* synapse_hybrid_search_plugin_match_object_real_get_thumbnail_path (SynapseMatch* base) {
	const char* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_thumbnail_path (SynapseMatch* base, const char* value) {
	SynapseHybridSearchPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_thumbnail_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_thumbnail_path), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_hybrid_search_plugin_match_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static const char* synapse_hybrid_search_plugin_match_object_real_get_uri (SynapseUriMatch* base) {
	const char* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_uri;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_uri (SynapseUriMatch* base, const char* value) {
	SynapseHybridSearchPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_uri = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_uri), _tmp0_);
	g_object_notify ((GObject *) self, "uri");
}


static SynapseQueryFlags synapse_hybrid_search_plugin_match_object_real_get_file_type (SynapseUriMatch* base) {
	SynapseQueryFlags result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_file_type;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_file_type (SynapseUriMatch* base, SynapseQueryFlags value) {
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_file_type = value;
	g_object_notify ((GObject *) self, "file-type");
}


static const char* synapse_hybrid_search_plugin_match_object_real_get_mime_type (SynapseUriMatch* base) {
	const char* result;
	SynapseHybridSearchPluginMatchObject* self;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	result = self->priv->_mime_type;
	return result;
}


static void synapse_hybrid_search_plugin_match_object_real_set_mime_type (SynapseUriMatch* base, const char* value) {
	SynapseHybridSearchPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseHybridSearchPluginMatchObject*) base;
	self->priv->_mime_type = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_mime_type), _tmp0_);
	g_object_notify ((GObject *) self, "mime-type");
}


static void synapse_hybrid_search_plugin_match_object_class_init (SynapseHybridSearchPluginMatchObjectClass * klass) {
	synapse_hybrid_search_plugin_match_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseHybridSearchPluginMatchObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_hybrid_search_plugin_match_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_hybrid_search_plugin_match_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_hybrid_search_plugin_match_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MIME_TYPE, "mime-type");
}


static void synapse_hybrid_search_plugin_match_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_hybrid_search_plugin_match_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_hybrid_search_plugin_match_object_real_get_title;
	iface->set_title = synapse_hybrid_search_plugin_match_object_real_set_title;
	iface->get_description = synapse_hybrid_search_plugin_match_object_real_get_description;
	iface->set_description = synapse_hybrid_search_plugin_match_object_real_set_description;
	iface->get_icon_name = synapse_hybrid_search_plugin_match_object_real_get_icon_name;
	iface->set_icon_name = synapse_hybrid_search_plugin_match_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_hybrid_search_plugin_match_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_hybrid_search_plugin_match_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_hybrid_search_plugin_match_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_hybrid_search_plugin_match_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_hybrid_search_plugin_match_object_real_get_match_type;
	iface->set_match_type = synapse_hybrid_search_plugin_match_object_real_set_match_type;
}


static void synapse_hybrid_search_plugin_match_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface) {
	synapse_hybrid_search_plugin_match_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_hybrid_search_plugin_match_object_real_get_uri;
	iface->set_uri = synapse_hybrid_search_plugin_match_object_real_set_uri;
	iface->get_file_type = synapse_hybrid_search_plugin_match_object_real_get_file_type;
	iface->set_file_type = synapse_hybrid_search_plugin_match_object_real_set_file_type;
	iface->get_mime_type = synapse_hybrid_search_plugin_match_object_real_get_mime_type;
	iface->set_mime_type = synapse_hybrid_search_plugin_match_object_real_set_mime_type;
}


static void synapse_hybrid_search_plugin_match_object_instance_init (SynapseHybridSearchPluginMatchObject * self) {
	self->priv = SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_GET_PRIVATE (self);
	self->priv->_description = g_strdup ("");
	self->priv->_icon_name = g_strdup ("");
	self->priv->_has_thumbnail = FALSE;
}


static void synapse_hybrid_search_plugin_match_object_finalize (GObject* obj) {
	SynapseHybridSearchPluginMatchObject * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	G_OBJECT_CLASS (synapse_hybrid_search_plugin_match_object_parent_class)->finalize (obj);
}


static GType synapse_hybrid_search_plugin_match_object_get_type (void) {
	static volatile gsize synapse_hybrid_search_plugin_match_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_hybrid_search_plugin_match_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseHybridSearchPluginMatchObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_hybrid_search_plugin_match_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseHybridSearchPluginMatchObject), 0, (GInstanceInitFunc) synapse_hybrid_search_plugin_match_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_match_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_match_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_hybrid_search_plugin_match_object_type_id;
		synapse_hybrid_search_plugin_match_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseHybridSearchPluginMatchObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_hybrid_search_plugin_match_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_hybrid_search_plugin_match_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		g_once_init_leave (&synapse_hybrid_search_plugin_match_object_type_id__volatile, synapse_hybrid_search_plugin_match_object_type_id);
	}
	return synapse_hybrid_search_plugin_match_object_type_id__volatile;
}


static void synapse_hybrid_search_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseHybridSearchPluginMatchObject * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_URI:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_hybrid_search_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseHybridSearchPluginMatchObject * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_URI:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_construct (GType object_type, const char* path) {
	SynapseHybridSearchPluginDirectoryInfo* self = (SynapseHybridSearchPluginDirectoryInfo*) g_type_create_instance (object_type);
	GeeMap* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (path != NULL, NULL);
	self->files = (_tmp0_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, NULL, NULL, SYNAPSE_UTILS_TYPE_FILE_INFO, (GBoxedCopyFunc) synapse_utils_file_info_ref, synapse_utils_file_info_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->files), _tmp0_);
	self->path = (_tmp1_ = g_strdup (path), _g_free0 (self->path), _tmp1_);
	return self;
}


static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_new (const char* path) {
	return synapse_hybrid_search_plugin_directory_info_construct (SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, path);
}


static void synapse_hybrid_search_plugin_value_directory_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void synapse_hybrid_search_plugin_value_directory_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		synapse_hybrid_search_plugin_directory_info_unref (value->data[0].v_pointer);
	}
}


static void synapse_hybrid_search_plugin_value_directory_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_hybrid_search_plugin_directory_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer synapse_hybrid_search_plugin_value_directory_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* synapse_hybrid_search_plugin_value_directory_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SynapseHybridSearchPluginDirectoryInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_hybrid_search_plugin_directory_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* synapse_hybrid_search_plugin_value_directory_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SynapseHybridSearchPluginDirectoryInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_hybrid_search_plugin_directory_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* synapse_hybrid_search_plugin_param_spec_directory_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SynapseHybridSearchPluginParamSpecDirectoryInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer synapse_hybrid_search_plugin_value_get_directory_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
	return value->data[0].v_pointer;
}


static void synapse_hybrid_search_plugin_value_set_directory_info (GValue* value, gpointer v_object) {
	SynapseHybridSearchPluginDirectoryInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_hybrid_search_plugin_directory_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_hybrid_search_plugin_directory_info_unref (old);
	}
}


static void synapse_hybrid_search_plugin_value_take_directory_info (GValue* value, gpointer v_object) {
	SynapseHybridSearchPluginDirectoryInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_hybrid_search_plugin_directory_info_unref (old);
	}
}


static void synapse_hybrid_search_plugin_directory_info_class_init (SynapseHybridSearchPluginDirectoryInfoClass * klass) {
	synapse_hybrid_search_plugin_directory_info_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_CLASS (klass)->finalize = synapse_hybrid_search_plugin_directory_info_finalize;
}


static void synapse_hybrid_search_plugin_directory_info_instance_init (SynapseHybridSearchPluginDirectoryInfo * self) {
	self->ref_count = 1;
}


static void synapse_hybrid_search_plugin_directory_info_finalize (SynapseHybridSearchPluginDirectoryInfo* obj) {
	SynapseHybridSearchPluginDirectoryInfo * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO (obj);
	_g_free0 (self->path);
	_g_object_unref0 (self->files);
}


static GType synapse_hybrid_search_plugin_directory_info_get_type (void) {
	static volatile gsize synapse_hybrid_search_plugin_directory_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_hybrid_search_plugin_directory_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_hybrid_search_plugin_value_directory_info_init, synapse_hybrid_search_plugin_value_directory_info_free_value, synapse_hybrid_search_plugin_value_directory_info_copy_value, synapse_hybrid_search_plugin_value_directory_info_peek_pointer, "p", synapse_hybrid_search_plugin_value_directory_info_collect_value, "p", synapse_hybrid_search_plugin_value_directory_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseHybridSearchPluginDirectoryInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_hybrid_search_plugin_directory_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseHybridSearchPluginDirectoryInfo), 0, (GInstanceInitFunc) synapse_hybrid_search_plugin_directory_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_hybrid_search_plugin_directory_info_type_id;
		synapse_hybrid_search_plugin_directory_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseHybridSearchPluginDirectoryInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&synapse_hybrid_search_plugin_directory_info_type_id__volatile, synapse_hybrid_search_plugin_directory_info_type_id);
	}
	return synapse_hybrid_search_plugin_directory_info_type_id__volatile;
}


static gpointer synapse_hybrid_search_plugin_directory_info_ref (gpointer instance) {
	SynapseHybridSearchPluginDirectoryInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void synapse_hybrid_search_plugin_directory_info_unref (gpointer instance) {
	SynapseHybridSearchPluginDirectoryInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void synapse_hybrid_search_plugin_class_init (SynapseHybridSearchPluginClass * klass) {
	synapse_hybrid_search_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseHybridSearchPluginPrivate));
	G_OBJECT_CLASS (klass)->constructed = synapse_hybrid_search_plugin_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = synapse_hybrid_search_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_hybrid_search_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_hybrid_search_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_hybrid_search_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK, g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED, "enabled");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY, g_param_spec_boolean ("processing-query", "processing-query", "processing-query", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("zeitgeist_search_complete", SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
	{
		synapse_hybrid_search_plugin_register_plugin ();
	}
}


static void synapse_hybrid_search_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_hybrid_search_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = synapse_hybrid_search_plugin_real_activate;
	iface->deactivate = synapse_hybrid_search_plugin_real_deactivate;
	iface->get_enabled = synapse_hybrid_search_plugin_real_get_enabled;
	iface->set_enabled = synapse_hybrid_search_plugin_real_set_enabled;
}


static void synapse_hybrid_search_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_hybrid_search_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = synapse_hybrid_search_plugin_real_handles_query;
	iface->search = synapse_hybrid_search_plugin_real_search;
	iface->search_finish = synapse_hybrid_search_plugin_real_search_finish;
}


static void synapse_hybrid_search_plugin_instance_init (SynapseHybridSearchPlugin * self) {
	self->priv = SYNAPSE_HYBRID_SEARCH_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->initialization_done = FALSE;
	self->priv->hit_level = 0;
	self->priv->current_level_uris = 0;
	self->priv->current_query = NULL;
	self->priv->_processing_query = FALSE;
}


static void synapse_hybrid_search_plugin_finalize (GObject* obj) {
	SynapseHybridSearchPlugin * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN (obj);
	_g_object_unref0 (self->priv->directory_hits);
	_g_object_unref0 (self->priv->directory_contents);
	_g_free0 (self->priv->current_query);
	G_OBJECT_CLASS (synapse_hybrid_search_plugin_parent_class)->finalize (obj);
}


GType synapse_hybrid_search_plugin_get_type (void) {
	static volatile gsize synapse_hybrid_search_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_hybrid_search_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseHybridSearchPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_hybrid_search_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseHybridSearchPlugin), 0, (GInstanceInitFunc) synapse_hybrid_search_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_hybrid_search_plugin_type_id;
		synapse_hybrid_search_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseHybridSearchPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_hybrid_search_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_hybrid_search_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_hybrid_search_plugin_type_id__volatile, synapse_hybrid_search_plugin_type_id);
	}
	return synapse_hybrid_search_plugin_type_id__volatile;
}


static void synapse_hybrid_search_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseHybridSearchPlugin * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK:
		g_value_set_object (value, synapse_hybrid_search_plugin_get_data_sink (self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY:
		g_value_set_boolean (value, synapse_hybrid_search_plugin_get_processing_query (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_hybrid_search_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseHybridSearchPlugin * self;
	self = SYNAPSE_HYBRID_SEARCH_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK:
		synapse_hybrid_search_plugin_set_data_sink (self, g_value_get_object (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY:
		synapse_hybrid_search_plugin_set_processing_query (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



