/* directory-plugin.c generated by valac 0.10.4, the Vala compiler
 * generated from directory-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */
/* 
 * This plugin keeps a cache of file names for directories that are commonly
 * used. 
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define SYNAPSE_TYPE_DIRECTORY_PLUGIN (synapse_directory_plugin_get_type ())
#define SYNAPSE_DIRECTORY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DIRECTORY_PLUGIN, SynapseDirectoryPlugin))
#define SYNAPSE_DIRECTORY_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DIRECTORY_PLUGIN, SynapseDirectoryPluginClass))
#define SYNAPSE_IS_DIRECTORY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DIRECTORY_PLUGIN))
#define SYNAPSE_IS_DIRECTORY_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DIRECTORY_PLUGIN))
#define SYNAPSE_DIRECTORY_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DIRECTORY_PLUGIN, SynapseDirectoryPluginClass))

typedef struct _SynapseDirectoryPlugin SynapseDirectoryPlugin;
typedef struct _SynapseDirectoryPluginClass SynapseDirectoryPluginClass;
typedef struct _SynapseDirectoryPluginPrivate SynapseDirectoryPluginPrivate;

#define SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO (synapse_directory_plugin_directory_info_get_type ())
#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, SynapseDirectoryPluginDirectoryInfo))
#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, SynapseDirectoryPluginDirectoryInfoClass))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, SynapseDirectoryPluginDirectoryInfoClass))

typedef struct _SynapseDirectoryPluginDirectoryInfo SynapseDirectoryPluginDirectoryInfo;
typedef struct _SynapseDirectoryPluginDirectoryInfoClass SynapseDirectoryPluginDirectoryInfoClass;

#define SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG (synapse_directory_plugin_config_get_type ())
#define SYNAPSE_DIRECTORY_PLUGIN_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfig))
#define SYNAPSE_DIRECTORY_PLUGIN_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfigClass))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG))
#define SYNAPSE_DIRECTORY_PLUGIN_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfigClass))

typedef struct _SynapseDirectoryPluginConfig SynapseDirectoryPluginConfig;
typedef struct _SynapseDirectoryPluginConfigClass SynapseDirectoryPluginConfigClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseDirectoryPluginDirectoryInfoPrivate SynapseDirectoryPluginDirectoryInfoPrivate;

#define SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT (synapse_directory_plugin_match_object_get_type ())
#define SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, SynapseDirectoryPluginMatchObject))
#define SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, SynapseDirectoryPluginMatchObjectClass))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, SynapseDirectoryPluginMatchObjectClass))

typedef struct _SynapseDirectoryPluginMatchObject SynapseDirectoryPluginMatchObject;
typedef struct _SynapseDirectoryPluginMatchObjectClass SynapseDirectoryPluginMatchObjectClass;
#define _synapse_directory_plugin_directory_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_directory_plugin_directory_info_unref (var), NULL)))
typedef struct _SynapseDirectoryPluginIndexXdgDirectoriesData SynapseDirectoryPluginIndexXdgDirectoriesData;
typedef struct _SynapseDirectoryPluginProcessDirectoriesData SynapseDirectoryPluginProcessDirectoriesData;
typedef struct _Block2Data Block2Data;
typedef struct _SynapseDirectoryPluginSearchData SynapseDirectoryPluginSearchData;
typedef struct _SynapseDirectoryPluginMatchObjectPrivate SynapseDirectoryPluginMatchObjectPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDirectoryPluginDirectoryInfoInitializeData SynapseDirectoryPluginDirectoryInfoInitializeData;
typedef struct _SynapseDirectoryPluginParamSpecDirectoryInfo SynapseDirectoryPluginParamSpecDirectoryInfo;
typedef struct _SynapseDirectoryPluginConfigPrivate SynapseDirectoryPluginConfigPrivate;

struct _SynapseDirectoryPlugin {
	GObject parent_instance;
	SynapseDirectoryPluginPrivate * priv;
};

struct _SynapseDirectoryPluginClass {
	GObjectClass parent_class;
};

struct _SynapseDirectoryPluginPrivate {
	SynapseDataSink* _data_sink;
	gboolean _enabled;
	GeeMap* directory_info_map;
	SynapseDirectoryPluginConfig* config;
	gboolean xdg_indexed;
	char* home_dir_uri;
};

struct _SynapseDirectoryPluginDirectoryInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseDirectoryPluginDirectoryInfoPrivate * priv;
	SynapseDirectoryPluginMatchObject* match_obj;
	char* name;
	char* name_folded;
};

struct _SynapseDirectoryPluginDirectoryInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseDirectoryPluginDirectoryInfo *self);
};

struct _SynapseDirectoryPluginIndexXdgDirectoriesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDirectoryPlugin* self;
	GUserDirectory dir;
	gboolean _tmp0_;
	char* path;
	GFile* f;
	char* uri;
	SynapseDirectoryPluginDirectoryInfo* info;
};

struct _SynapseDirectoryPluginProcessDirectoriesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDirectoryPlugin* self;
	GeeCollection* dirs;
	char* home_dir;
	GFile* home;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	GeeIterator* _dir_it;
	char* dir;
	gboolean _tmp3_;
	char** directories;
	gint _tmp4_;
	gint directories_length1;
	gint _directories_size_;
	char** _tmp5_;
	SynapseDirectoryPluginDirectoryInfo* info;
	char** dir_uri_collection;
	int dir_uri_collection_length1;
	int dir_uri_it;
	const char* dir_uri;
};

struct _Block2Data {
	int _ref_count_;
	SynapseDirectoryPlugin * self;
	GeeCollection* directories;
	guint query_id;
	gulong sig_id;
	gpointer _async_data_;
};

struct _SynapseDirectoryPluginSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDirectoryPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	gulong canc_sig_id;
	GObject* _tmp0_;
	SynapseResultSet* rs;
	GeeIterator* _entry_it;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_;
	SynapseDirectoryPluginDirectoryInfo* entry;
	SynapseMatchScore _tmp3_;
	gint relevancy;
	Block2Data* _data2_;
	GError * _inner_error_;
};

struct _SynapseDirectoryPluginMatchObject {
	GObject parent_instance;
	SynapseDirectoryPluginMatchObjectPrivate * priv;
};

struct _SynapseDirectoryPluginMatchObjectClass {
	GObjectClass parent_class;
};

struct _SynapseDirectoryPluginMatchObjectPrivate {
	char* _title;
	char* _description;
	char* _icon_name;
	gboolean _has_thumbnail;
	char* _thumbnail_path;
	SynapseMatchType _match_type;
	char* _uri;
	SynapseQueryFlags _file_type;
	char* _mime_type;
};

struct _SynapseDirectoryPluginDirectoryInfoPrivate {
	gboolean initialized;
};

struct _SynapseDirectoryPluginDirectoryInfoInitializeData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDirectoryPluginDirectoryInfo* self;
	GFile* f;
	GFileInfo* fi;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	GFile* icon_f;
	char* _tmp3_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseDirectoryPluginParamSpecDirectoryInfo {
	GParamSpec parent_instance;
};

struct _SynapseDirectoryPluginConfig {
	SynapseConfigObject parent_instance;
	SynapseDirectoryPluginConfigPrivate * priv;
};

struct _SynapseDirectoryPluginConfigClass {
	SynapseConfigObjectClass parent_class;
};

struct _SynapseDirectoryPluginConfigPrivate {
	gboolean _home_dir_children_only;
};


static gpointer synapse_directory_plugin_match_object_parent_class = NULL;
static SynapseMatchIface* synapse_directory_plugin_match_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface* synapse_directory_plugin_match_object_synapse_uri_match_parent_iface = NULL;
static gpointer synapse_directory_plugin_directory_info_parent_class = NULL;
static gpointer synapse_directory_plugin_config_parent_class = NULL;
static gpointer synapse_directory_plugin_parent_class = NULL;
static SynapseActivatableIface* synapse_directory_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_directory_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_directory_plugin_get_type (void) G_GNUC_CONST;
static gpointer synapse_directory_plugin_directory_info_ref (gpointer instance);
static void synapse_directory_plugin_directory_info_unref (gpointer instance);
static GParamSpec* synapse_directory_plugin_param_spec_directory_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void synapse_directory_plugin_value_set_directory_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void synapse_directory_plugin_value_take_directory_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer synapse_directory_plugin_value_get_directory_info (const GValue* value) G_GNUC_UNUSED;
static GType synapse_directory_plugin_directory_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType synapse_directory_plugin_config_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_DIRECTORY_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DIRECTORY_PLUGIN, SynapseDirectoryPluginPrivate))
enum  {
	SYNAPSE_DIRECTORY_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK,
	SYNAPSE_DIRECTORY_PLUGIN_ENABLED
};
static void synapse_directory_plugin_real_activate (SynapseActivatable* base);
static void synapse_directory_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_directory_plugin_register_plugin (void);
static void _synapse_directory_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_directory_plugin_real_constructed (GObject* base);
SynapseDataSink* synapse_directory_plugin_get_data_sink (SynapseDirectoryPlugin* self);
static void synapse_directory_plugin_zg_plugin_search_done (SynapseDirectoryPlugin* self, SynapseResultSet* rs, guint query_id);
static void _synapse_directory_plugin_zg_plugin_search_done_synapse_data_sink_search_done (SynapseDataSink* _sender, SynapseResultSet* rs, guint query_id, gpointer self);
static void synapse_directory_plugin_index_xdg_directories_data_free (gpointer _data);
static void synapse_directory_plugin_index_xdg_directories_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_directory_plugin_index_xdg_directories (SynapseDirectoryPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_directory_plugin_index_xdg_directories_finish (SynapseDirectoryPlugin* self, GAsyncResult* _res_);
static gboolean synapse_directory_plugin_index_xdg_directories_co (SynapseDirectoryPluginIndexXdgDirectoriesData* data);
static SynapseDirectoryPluginDirectoryInfo* synapse_directory_plugin_directory_info_new (const char* uri);
static SynapseDirectoryPluginDirectoryInfo* synapse_directory_plugin_directory_info_construct (GType object_type, const char* uri);
static void synapse_directory_plugin_directory_info_initialize (SynapseDirectoryPluginDirectoryInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_directory_plugin_directory_info_initialize_finish (SynapseDirectoryPluginDirectoryInfo* self, GAsyncResult* _res_);
static GType synapse_directory_plugin_match_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeCollection* synapse_directory_plugin_extract_directories (SynapseDirectoryPlugin* self, SynapseResultSet* rs);
static char** synapse_directory_plugin_get_dir_parents (SynapseDirectoryPlugin* self, const char* dir_uri, gboolean include_self, int* result_length1);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static gboolean synapse_directory_plugin_config_get_home_dir_children_only (SynapseDirectoryPluginConfig* self);
static void _vala_array_add2 (char*** array, int* length, int* size, char* value);
static void synapse_directory_plugin_process_directories_data_free (gpointer _data);
static void synapse_directory_plugin_process_directories_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_directory_plugin_process_directories (SynapseDirectoryPlugin* self, GeeCollection* dirs, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_directory_plugin_process_directories_finish (SynapseDirectoryPlugin* self, GAsyncResult* _res_);
static gboolean synapse_directory_plugin_process_directories_co (SynapseDirectoryPluginProcessDirectoriesData* data);
static void synapse_directory_plugin_real_search_data_free (gpointer _data);
static void synapse_directory_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_directory_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_directory_plugin_real_search_co (SynapseDirectoryPluginSearchData* data);
static void _lambda3_ (SynapseResultSet* rs, guint q_id, Block2Data* _data2_);
static void __lambda3__synapse_directory_plugin_zeitgeist_search_complete (SynapseDirectoryPlugin* _sender, SynapseResultSet* rs, guint query_id, gpointer self);
static void _lambda4_ (Block2Data* _data2_);
static gboolean _synapse_directory_plugin_real_search_co_gsource_func (gpointer self);
static void __lambda4__gcallback (GCancellable* instance, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
SynapseDirectoryPlugin* synapse_directory_plugin_new (void);
SynapseDirectoryPlugin* synapse_directory_plugin_construct (GType object_type);
static void synapse_directory_plugin_set_data_sink (SynapseDirectoryPlugin* self, SynapseDataSink* value);
static GObject * synapse_directory_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, SynapseDirectoryPluginMatchObjectPrivate))
enum  {
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_TITLE,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_DESCRIPTION,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_ICON_NAME,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_MATCH_TYPE,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_URI,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_FILE_TYPE,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_MIME_TYPE
};
static SynapseDirectoryPluginMatchObject* synapse_directory_plugin_match_object_new (const char* uri);
static SynapseDirectoryPluginMatchObject* synapse_directory_plugin_match_object_construct (GType object_type, const char* uri);
static void synapse_directory_plugin_match_object_finalize (GObject* obj);
static void synapse_directory_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_directory_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, SynapseDirectoryPluginDirectoryInfoPrivate))
enum  {
	SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_DUMMY_PROPERTY
};
#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_ATTRIBUTE_CUSTOM_ICON "metadata::custom-icon"
static void synapse_directory_plugin_directory_info_initialize_data_free (gpointer _data);
static void synapse_directory_plugin_directory_info_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_directory_plugin_directory_info_initialize_co (SynapseDirectoryPluginDirectoryInfoInitializeData* data);
static void synapse_directory_plugin_directory_info_finalize (SynapseDirectoryPluginDirectoryInfo* obj);
#define SYNAPSE_DIRECTORY_PLUGIN_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfigPrivate))
enum  {
	SYNAPSE_DIRECTORY_PLUGIN_CONFIG_DUMMY_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY
};
static SynapseDirectoryPluginConfig* synapse_directory_plugin_config_new (void);
static SynapseDirectoryPluginConfig* synapse_directory_plugin_config_construct (GType object_type);
static void synapse_directory_plugin_config_set_home_dir_children_only (SynapseDirectoryPluginConfig* self, gboolean value);
static void synapse_directory_plugin_config_finalize (GObject* obj);
static void synapse_directory_plugin_config_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_directory_plugin_config_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_directory_plugin_finalize (GObject* obj);
static void synapse_directory_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_directory_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void synapse_directory_plugin_real_activate (SynapseActivatable* base) {
	SynapseDirectoryPlugin * self;
	self = (SynapseDirectoryPlugin*) base;
}


static void synapse_directory_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseDirectoryPlugin * self;
	self = (SynapseDirectoryPlugin*) base;
}


static void _synapse_directory_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_directory_plugin_register_plugin ();
}


static void synapse_directory_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp0_ = synapse_data_sink_plugin_registry_get_default (), SYNAPSE_TYPE_DIRECTORY_PLUGIN, "Directory Search", _ ("Open commonly used directories."), "folder", _synapse_directory_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp0_);
}


static void _synapse_directory_plugin_zg_plugin_search_done_synapse_data_sink_search_done (SynapseDataSink* _sender, SynapseResultSet* rs, guint query_id, gpointer self) {
	synapse_directory_plugin_zg_plugin_search_done (self, rs, query_id);
}


static void synapse_directory_plugin_real_constructed (GObject* base) {
	SynapseDirectoryPlugin * self;
	self = (SynapseDirectoryPlugin*) base;
	g_signal_connect_object (self->priv->_data_sink, "search-done::SynapseZeitgeistPlugin", (GCallback) _synapse_directory_plugin_zg_plugin_search_done_synapse_data_sink_search_done, self, 0);
}


static void synapse_directory_plugin_index_xdg_directories_data_free (gpointer _data) {
	SynapseDirectoryPluginIndexXdgDirectoriesData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseDirectoryPluginIndexXdgDirectoriesData, data);
}


static void synapse_directory_plugin_index_xdg_directories (SynapseDirectoryPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDirectoryPluginIndexXdgDirectoriesData* _data_;
	_data_ = g_slice_new0 (SynapseDirectoryPluginIndexXdgDirectoriesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_directory_plugin_index_xdg_directories);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_directory_plugin_index_xdg_directories_data_free);
	_data_->self = g_object_ref (self);
	synapse_directory_plugin_index_xdg_directories_co (_data_);
}


static void synapse_directory_plugin_index_xdg_directories_finish (SynapseDirectoryPlugin* self, GAsyncResult* _res_) {
	SynapseDirectoryPluginIndexXdgDirectoriesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_directory_plugin_index_xdg_directories_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDirectoryPluginIndexXdgDirectoriesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_directory_plugin_index_xdg_directories_co (data);
}


static gboolean synapse_directory_plugin_index_xdg_directories_co (SynapseDirectoryPluginIndexXdgDirectoriesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 7:
		goto _state_7;
	}
	_state_0:
	if (data->self->priv->xdg_indexed) {
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		data->dir = G_USER_DIRECTORY_DESKTOP;
		{
			data->_tmp0_ = TRUE;
			while (TRUE) {
				if (!data->_tmp0_) {
					data->dir = data->dir + 1;
				}
				data->_tmp0_ = FALSE;
				if (!(data->dir <= G_USER_DIRECTORY_VIDEOS)) {
					break;
				}
				data->path = g_strdup (g_get_user_special_dir (data->dir));
				if (data->path == NULL) {
					_g_free0 (data->path);
					continue;
				}
				data->f = g_file_new_for_path (data->path);
				data->uri = g_file_get_uri (data->f);
				if (gee_map_contains (data->self->priv->directory_info_map, data->uri)) {
					_g_free0 (data->uri);
					_g_object_unref0 (data->f);
					_g_free0 (data->path);
					continue;
				}
				data->info = synapse_directory_plugin_directory_info_new (data->uri);
				data->_state_ = 7;
				synapse_directory_plugin_directory_info_initialize (data->info, synapse_directory_plugin_index_xdg_directories_ready, data);
				return FALSE;
				_state_7:
				synapse_directory_plugin_directory_info_initialize_finish (data->info, data->_res_);
				gee_map_set (data->self->priv->directory_info_map, synapse_uri_match_get_uri ((SynapseUriMatch*) data->info->match_obj), data->info);
				_synapse_directory_plugin_directory_info_unref0 (data->info);
				_g_free0 (data->uri);
				_g_object_unref0 (data->f);
				_g_free0 (data->path);
			}
		}
	}
	data->self->priv->xdg_indexed = TRUE;
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_directory_plugin_zg_plugin_search_done (SynapseDirectoryPlugin* self, SynapseResultSet* rs, guint query_id) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "zeitgeist-search-complete", rs, query_id);
}


static GeeCollection* synapse_directory_plugin_extract_directories (SynapseDirectoryPlugin* self, SynapseResultSet* rs) {
	GeeCollection* result = NULL;
	GeeSet* directories;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (rs != NULL, NULL);
	directories = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	{
		GeeIterator* _match_it;
		_match_it = gee_iterable_iterator ((GeeIterable*) rs);
		while (TRUE) {
			GeeMapEntry* match;
			SynapseMatch* _tmp0_;
			SynapseUriMatch* uri_match;
			GFile* f;
			gboolean _tmp1_ = FALSE;
			GFile* parent;
			char* parent_uri;
			if (!gee_iterator_next (_match_it)) {
				break;
			}
			match = (GeeMapEntry*) gee_iterator_get (_match_it);
			uri_match = (_tmp0_ = (SynapseMatch*) gee_map_entry_get_key (match), SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL);
			if (uri_match == NULL) {
				_g_object_unref0 (match);
				continue;
			}
			f = g_file_new_for_uri (synapse_uri_match_get_uri (uri_match));
			if (!g_file_is_native (f)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = !g_file_has_parent (f, NULL);
			}
			if (_tmp1_) {
				_g_object_unref0 (f);
				_g_object_unref0 (match);
				continue;
			}
			parent = g_file_get_parent (f);
			parent_uri = g_file_get_uri (parent);
			if (gee_collection_contains ((GeeCollection*) directories, parent_uri)) {
				_g_free0 (parent_uri);
				_g_object_unref0 (parent);
				_g_object_unref0 (f);
				_g_object_unref0 (match);
				continue;
			}
			gee_collection_add ((GeeCollection*) directories, parent_uri);
			_g_free0 (parent_uri);
			_g_object_unref0 (parent);
			_g_object_unref0 (f);
			_g_object_unref0 (match);
		}
		_g_object_unref0 (_match_it);
	}
	result = (GeeCollection*) directories;
	return result;
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static char** synapse_directory_plugin_get_dir_parents (SynapseDirectoryPlugin* self, const char* dir_uri, gboolean include_self, int* result_length1) {
	char** result = NULL;
	gint dirs_length1;
	gint _dirs_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** dirs;
	GFile* f;
	char** _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dir_uri != NULL, NULL);
	dirs = (_tmp1_ = (_tmp0_ = g_new0 (char*, 0 + 1), _tmp0_), dirs_length1 = 0, _dirs_size_ = dirs_length1, _tmp1_);
	f = g_file_new_for_uri (dir_uri);
	if (include_self) {
		_vala_array_add1 (&dirs, &dirs_length1, &_dirs_size_, g_file_get_uri (f));
	}
	while (TRUE) {
		GFile* _tmp2_;
		char* parent_uri;
		gboolean _tmp3_ = FALSE;
		if (!g_file_has_parent (f, NULL)) {
			break;
		}
		f = (_tmp2_ = g_file_get_parent (f), _g_object_unref0 (f), _tmp2_);
		parent_uri = g_file_get_uri (f);
		if (synapse_directory_plugin_config_get_home_dir_children_only (self->priv->config)) {
			_tmp3_ = !g_str_has_prefix (parent_uri, self->priv->home_dir_uri);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_g_free0 (parent_uri);
			break;
		}
		_vala_array_add2 (&dirs, &dirs_length1, &_dirs_size_, g_strdup (parent_uri));
		_g_free0 (parent_uri);
	}
	result = (_tmp4_ = dirs, *result_length1 = dirs_length1, _tmp4_);
	_g_object_unref0 (f);
	return result;
	_g_object_unref0 (f);
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
}


static void synapse_directory_plugin_process_directories_data_free (gpointer _data) {
	SynapseDirectoryPluginProcessDirectoriesData* data;
	data = _data;
	_g_object_unref0 (data->dirs);
	g_object_unref (data->self);
	g_slice_free (SynapseDirectoryPluginProcessDirectoriesData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_directory_plugin_process_directories (SynapseDirectoryPlugin* self, GeeCollection* dirs, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDirectoryPluginProcessDirectoriesData* _data_;
	_data_ = g_slice_new0 (SynapseDirectoryPluginProcessDirectoriesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_directory_plugin_process_directories);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_directory_plugin_process_directories_data_free);
	_data_->self = g_object_ref (self);
	_data_->dirs = _g_object_ref0 (dirs);
	synapse_directory_plugin_process_directories_co (_data_);
}


static void synapse_directory_plugin_process_directories_finish (SynapseDirectoryPlugin* self, GAsyncResult* _res_) {
	SynapseDirectoryPluginProcessDirectoriesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_directory_plugin_process_directories_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDirectoryPluginProcessDirectoriesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_directory_plugin_process_directories_co (data);
}


static gboolean synapse_directory_plugin_process_directories_co (SynapseDirectoryPluginProcessDirectoriesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 8:
		goto _state_8;
	}
	_state_0:
	if (data->self->priv->home_dir_uri == NULL) {
		data->home_dir = g_strdup (g_get_home_dir ());
		if (data->home_dir != NULL) {
			data->home = g_file_new_for_path (data->home_dir);
			data->self->priv->home_dir_uri = (data->_tmp1_ = g_strconcat (data->_tmp0_ = g_file_get_uri (data->home), "/", NULL), _g_free0 (data->self->priv->home_dir_uri), data->_tmp1_);
			_g_free0 (data->_tmp0_);
			_g_object_unref0 (data->home);
		} else {
			g_warning ("directory-plugin.vala:234: Home directory is not set!");
			data->self->priv->home_dir_uri = (data->_tmp2_ = g_strdup ("file:///home/"), _g_free0 (data->self->priv->home_dir_uri), data->_tmp2_);
		}
		_g_free0 (data->home_dir);
	}
	if (data->dirs == NULL) {
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		data->_dir_it = gee_iterable_iterator ((GeeIterable*) data->dirs);
		while (TRUE) {
			if (!gee_iterator_next (data->_dir_it)) {
				break;
			}
			data->dir = (char*) gee_iterator_get (data->_dir_it);
			if (gee_map_contains (data->self->priv->directory_info_map, data->dir)) {
				_g_free0 (data->dir);
				continue;
			}
			if (synapse_directory_plugin_config_get_home_dir_children_only (data->self->priv->config)) {
				data->_tmp3_ = !g_str_has_prefix (data->dir, data->self->priv->home_dir_uri);
			} else {
				data->_tmp3_ = FALSE;
			}
			if (data->_tmp3_) {
				_g_free0 (data->dir);
				continue;
			}
			data->directories = (data->_tmp5_ = synapse_directory_plugin_get_dir_parents (data->self, data->dir, TRUE, &data->_tmp4_), data->directories_length1 = data->_tmp4_, data->_directories_size_ = data->directories_length1, data->_tmp5_);
			{
				data->dir_uri_collection = data->directories;
				data->dir_uri_collection_length1 = data->directories_length1;
				for (data->dir_uri_it = 0; data->dir_uri_it < data->directories_length1; data->dir_uri_it = data->dir_uri_it + 1) {
					data->dir_uri = data->dir_uri_collection[data->dir_uri_it];
					{
						if (gee_map_contains (data->self->priv->directory_info_map, data->dir_uri)) {
							continue;
						}
						data->info = synapse_directory_plugin_directory_info_new (data->dir_uri);
						data->_state_ = 8;
						synapse_directory_plugin_directory_info_initialize (data->info, synapse_directory_plugin_process_directories_ready, data);
						return FALSE;
						_state_8:
						synapse_directory_plugin_directory_info_initialize_finish (data->info, data->_res_);
						gee_map_set (data->self->priv->directory_info_map, synapse_uri_match_get_uri ((SynapseUriMatch*) data->info->match_obj), data->info);
						_synapse_directory_plugin_directory_info_unref0 (data->info);
					}
				}
			}
			data->directories = (_vala_array_free (data->directories, data->directories_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->dir);
		}
		_g_object_unref0 (data->_dir_it);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_directory_plugin_real_search_data_free (gpointer _data) {
	SynapseDirectoryPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (SynapseDirectoryPluginSearchData, data);
}


static void synapse_directory_plugin_real_search (SynapseItemProvider* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDirectoryPlugin * self;
	SynapseDirectoryPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseDirectoryPlugin*) base;
	_data_ = g_slice_new0 (SynapseDirectoryPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_directory_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_directory_plugin_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	synapse_directory_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_directory_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseDirectoryPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_directory_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDirectoryPluginSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_directory_plugin_real_search_co (data);
}


static void _lambda3_ (SynapseResultSet* rs, guint q_id, Block2Data* _data2_) {
	SynapseDirectoryPlugin * self;
	GeeCollection* _tmp0_;
	self = _data2_->self;
	if (q_id != _data2_->query_id) {
		return;
	}
	_data2_->directories = (_tmp0_ = synapse_directory_plugin_extract_directories (self, rs), _g_object_unref0 (_data2_->directories), _tmp0_);
	synapse_directory_plugin_real_search_co (_data2_->_async_data_);
}


static void __lambda3__synapse_directory_plugin_zeitgeist_search_complete (SynapseDirectoryPlugin* _sender, SynapseResultSet* rs, guint query_id, gpointer self) {
	_lambda3_ (rs, query_id, self);
}


static gboolean _synapse_directory_plugin_real_search_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_directory_plugin_real_search_co (self);
	return result;
}


static void _lambda4_ (Block2Data* _data2_) {
	SynapseDirectoryPlugin * self;
	self = _data2_->self;
	g_signal_handler_block (self, _data2_->sig_id);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_directory_plugin_real_search_co_gsource_func, _data2_->_async_data_, NULL);
}


static void __lambda4__gcallback (GCancellable* instance, gpointer self) {
	_lambda4_ (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->directories);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean synapse_directory_plugin_real_search_co (SynapseDirectoryPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
	}
	_state_0:
	data->_data2_ = g_slice_new0 (Block2Data);
	data->_data2_->_ref_count_ = 1;
	data->_data2_->self = g_object_ref (data->self);
	data->_data2_->_async_data_ = data;
	if (!((data->q.query_type & SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) == SYNAPSE_QUERY_FLAGS_UNCATEGORIZED)) {
		data->result = NULL;
		block2_data_unref (data->_data2_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_data2_->directories = NULL;
	data->_data2_->query_id = data->q.query_id;
	data->_data2_->sig_id = g_signal_connect_data (data->self, "zeitgeist-search-complete", (GCallback) __lambda3__synapse_directory_plugin_zeitgeist_search_complete, block2_data_ref (data->_data2_), (GClosureNotify) block2_data_unref, 0);
	data->canc_sig_id = g_cancellable_connect (data->q.cancellable, __lambda4__gcallback, block2_data_ref (data->_data2_), block2_data_unref);
	if (synapse_activatable_get_enabled ((SynapseActivatable*) (data->_tmp0_ = synapse_data_sink_get_plugin (data->self->priv->_data_sink, "SynapseZeitgeistPlugin"), SYNAPSE_IS_ITEM_PROVIDER (data->_tmp0_) ? ((SynapseItemProvider*) data->_tmp0_) : NULL))) {
		data->_state_ = 9;
		return FALSE;
		_state_9:
		;
	}
	g_signal_handler_disconnect (data->self, data->_data2_->sig_id);
	g_cancellable_disconnect (data->q.cancellable, data->canc_sig_id);
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block2_data_unref (data->_data2_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			block2_data_unref (data->_data2_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (!data->self->priv->xdg_indexed) {
		data->_state_ = 10;
		synapse_directory_plugin_index_xdg_directories (data->self, synapse_directory_plugin_search_ready, data);
		return FALSE;
		_state_10:
		synapse_directory_plugin_index_xdg_directories_finish (data->self, data->_res_);
	}
	data->_state_ = 11;
	synapse_directory_plugin_process_directories (data->self, data->_data2_->directories, synapse_directory_plugin_search_ready, data);
	return FALSE;
	_state_11:
	synapse_directory_plugin_process_directories_finish (data->self, data->_res_);
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block2_data_unref (data->_data2_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			block2_data_unref (data->_data2_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->rs = synapse_result_set_new ();
	{
		data->_entry_it = (data->_tmp2_ = gee_iterable_iterator ((GeeIterable*) (data->_tmp1_ = gee_map_get_values (data->self->priv->directory_info_map))), _g_object_unref0 (data->_tmp1_), data->_tmp2_);
		while (TRUE) {
			if (!gee_iterator_next (data->_entry_it)) {
				break;
			}
			data->entry = (SynapseDirectoryPluginDirectoryInfo*) gee_iterator_get (data->_entry_it);
			if (g_str_has_prefix (data->entry->name_folded, data->q.query_string_folded)) {
				if (g_str_has_prefix (synapse_uri_match_get_uri ((SynapseUriMatch*) data->entry->match_obj), data->self->priv->home_dir_uri)) {
					data->_tmp3_ = SYNAPSE_MATCH_SCORE_VERY_GOOD - SYNAPSE_MATCH_SCORE_URI_PENALTY;
				} else {
					data->_tmp3_ = SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE - SYNAPSE_MATCH_SCORE_URI_PENALTY;
				}
				data->relevancy = (gint) data->_tmp3_;
				synapse_result_set_add (data->rs, (SynapseMatch*) data->entry->match_obj, data->relevancy);
			}
			_synapse_directory_plugin_directory_info_unref0 (data->entry);
		}
		_g_object_unref0 (data->_entry_it);
	}
	data->result = data->rs;
	block2_data_unref (data->_data2_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->rs);
	block2_data_unref (data->_data2_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


SynapseDirectoryPlugin* synapse_directory_plugin_construct (GType object_type) {
	SynapseDirectoryPlugin * self = NULL;
	self = (SynapseDirectoryPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseDirectoryPlugin* synapse_directory_plugin_new (void) {
	return synapse_directory_plugin_construct (SYNAPSE_TYPE_DIRECTORY_PLUGIN);
}


SynapseDataSink* synapse_directory_plugin_get_data_sink (SynapseDirectoryPlugin* self) {
	SynapseDataSink* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_data_sink;
	return result;
}


static void synapse_directory_plugin_set_data_sink (SynapseDirectoryPlugin* self, SynapseDataSink* value) {
	g_return_if_fail (self != NULL);
	self->priv->_data_sink = value;
	g_object_notify ((GObject *) self, "data-sink");
}


static gboolean synapse_directory_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseDirectoryPlugin* self;
	self = (SynapseDirectoryPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_directory_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseDirectoryPlugin* self;
	self = (SynapseDirectoryPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_directory_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDirectoryPlugin * self;
	parent_class = G_OBJECT_CLASS (synapse_directory_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_DIRECTORY_PLUGIN (obj);
	{
		GeeMap* _tmp1_;
		SynapseConfigService* cs;
		SynapseDirectoryPluginConfig* _tmp2_;
		self->priv->directory_info_map = (_tmp1_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, NULL, NULL, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, (GBoxedCopyFunc) synapse_directory_plugin_directory_info_ref, synapse_directory_plugin_directory_info_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->directory_info_map), _tmp1_);
		cs = synapse_config_service_get_default ();
		self->priv->config = (_tmp2_ = SYNAPSE_DIRECTORY_PLUGIN_CONFIG (synapse_config_service_get_config (cs, "plugins", "directory-plugin", SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG)), _g_object_unref0 (self->priv->config), _tmp2_);
		_g_object_unref0 (cs);
	}
	return obj;
}


static SynapseDirectoryPluginMatchObject* synapse_directory_plugin_match_object_construct (GType object_type, const char* uri) {
	SynapseDirectoryPluginMatchObject * self = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (SynapseDirectoryPluginMatchObject*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, "has-thumbnail", FALSE, "uri", uri, "file-type", SYNAPSE_QUERY_FLAGS_UNCATEGORIZED, "mime-type", "inode/directory", NULL);
	return self;
}


static SynapseDirectoryPluginMatchObject* synapse_directory_plugin_match_object_new (const char* uri) {
	return synapse_directory_plugin_match_object_construct (SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, uri);
}


static const char* synapse_directory_plugin_match_object_real_get_title (SynapseMatch* base) {
	const char* result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_title (SynapseMatch* base, const char* value) {
	SynapseDirectoryPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_title = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_title), _tmp0_);
	g_object_notify ((GObject *) self, "title");
}


static const char* synapse_directory_plugin_match_object_real_get_description (SynapseMatch* base) {
	const char* result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_description (SynapseMatch* base, const char* value) {
	SynapseDirectoryPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


static const char* synapse_directory_plugin_match_object_real_get_icon_name (SynapseMatch* base) {
	const char* result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_icon_name (SynapseMatch* base, const char* value) {
	SynapseDirectoryPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_directory_plugin_match_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const char* synapse_directory_plugin_match_object_real_get_thumbnail_path (SynapseMatch* base) {
	const char* result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_thumbnail_path (SynapseMatch* base, const char* value) {
	SynapseDirectoryPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_thumbnail_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_thumbnail_path), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_directory_plugin_match_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static const char* synapse_directory_plugin_match_object_real_get_uri (SynapseUriMatch* base) {
	const char* result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_uri;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_uri (SynapseUriMatch* base, const char* value) {
	SynapseDirectoryPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_uri = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_uri), _tmp0_);
	g_object_notify ((GObject *) self, "uri");
}


static SynapseQueryFlags synapse_directory_plugin_match_object_real_get_file_type (SynapseUriMatch* base) {
	SynapseQueryFlags result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_file_type;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_file_type (SynapseUriMatch* base, SynapseQueryFlags value) {
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_file_type = value;
	g_object_notify ((GObject *) self, "file-type");
}


static const char* synapse_directory_plugin_match_object_real_get_mime_type (SynapseUriMatch* base) {
	const char* result;
	SynapseDirectoryPluginMatchObject* self;
	self = (SynapseDirectoryPluginMatchObject*) base;
	result = self->priv->_mime_type;
	return result;
}


static void synapse_directory_plugin_match_object_real_set_mime_type (SynapseUriMatch* base, const char* value) {
	SynapseDirectoryPluginMatchObject* self;
	char* _tmp0_;
	self = (SynapseDirectoryPluginMatchObject*) base;
	self->priv->_mime_type = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_mime_type), _tmp0_);
	g_object_notify ((GObject *) self, "mime-type");
}


static void synapse_directory_plugin_match_object_class_init (SynapseDirectoryPluginMatchObjectClass * klass) {
	synapse_directory_plugin_match_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDirectoryPluginMatchObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_directory_plugin_match_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_directory_plugin_match_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_directory_plugin_match_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_MIME_TYPE, "mime-type");
}


static void synapse_directory_plugin_match_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_directory_plugin_match_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_directory_plugin_match_object_real_get_title;
	iface->set_title = synapse_directory_plugin_match_object_real_set_title;
	iface->get_description = synapse_directory_plugin_match_object_real_get_description;
	iface->set_description = synapse_directory_plugin_match_object_real_set_description;
	iface->get_icon_name = synapse_directory_plugin_match_object_real_get_icon_name;
	iface->set_icon_name = synapse_directory_plugin_match_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_directory_plugin_match_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_directory_plugin_match_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_directory_plugin_match_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_directory_plugin_match_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_directory_plugin_match_object_real_get_match_type;
	iface->set_match_type = synapse_directory_plugin_match_object_real_set_match_type;
}


static void synapse_directory_plugin_match_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface) {
	synapse_directory_plugin_match_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_directory_plugin_match_object_real_get_uri;
	iface->set_uri = synapse_directory_plugin_match_object_real_set_uri;
	iface->get_file_type = synapse_directory_plugin_match_object_real_get_file_type;
	iface->set_file_type = synapse_directory_plugin_match_object_real_set_file_type;
	iface->get_mime_type = synapse_directory_plugin_match_object_real_get_mime_type;
	iface->set_mime_type = synapse_directory_plugin_match_object_real_set_mime_type;
}


static void synapse_directory_plugin_match_object_instance_init (SynapseDirectoryPluginMatchObject * self) {
	self->priv = SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_GET_PRIVATE (self);
	self->priv->_description = g_strdup ("");
	self->priv->_icon_name = g_strdup ("");
	self->priv->_has_thumbnail = FALSE;
}


static void synapse_directory_plugin_match_object_finalize (GObject* obj) {
	SynapseDirectoryPluginMatchObject * self;
	self = SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	G_OBJECT_CLASS (synapse_directory_plugin_match_object_parent_class)->finalize (obj);
}


static GType synapse_directory_plugin_match_object_get_type (void) {
	static volatile gsize synapse_directory_plugin_match_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_directory_plugin_match_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDirectoryPluginMatchObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_directory_plugin_match_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDirectoryPluginMatchObject), 0, (GInstanceInitFunc) synapse_directory_plugin_match_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_directory_plugin_match_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_directory_plugin_match_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_directory_plugin_match_object_type_id;
		synapse_directory_plugin_match_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDirectoryPluginMatchObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_directory_plugin_match_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_directory_plugin_match_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		g_once_init_leave (&synapse_directory_plugin_match_object_type_id__volatile, synapse_directory_plugin_match_object_type_id);
	}
	return synapse_directory_plugin_match_object_type_id__volatile;
}


static void synapse_directory_plugin_match_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDirectoryPluginMatchObject * self;
	self = SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_URI:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_directory_plugin_match_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDirectoryPluginMatchObject * self;
	self = SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_URI:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_FILE_TYPE:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_MIME_TYPE:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static SynapseDirectoryPluginDirectoryInfo* synapse_directory_plugin_directory_info_construct (GType object_type, const char* uri) {
	SynapseDirectoryPluginDirectoryInfo* self = (SynapseDirectoryPluginDirectoryInfo*) g_type_create_instance (object_type);
	SynapseDirectoryPluginMatchObject* _tmp0_;
	GFile* f;
	char* _tmp1_;
	g_return_val_if_fail (uri != NULL, NULL);
	self->match_obj = (_tmp0_ = synapse_directory_plugin_match_object_new (uri), _g_object_unref0 (self->match_obj), _tmp0_);
	f = g_file_new_for_uri (uri);
	synapse_match_set_description ((SynapseMatch*) self->match_obj, _tmp1_ = g_file_get_path (f));
	_g_free0 (_tmp1_);
	_g_object_unref0 (f);
	return self;
}


static SynapseDirectoryPluginDirectoryInfo* synapse_directory_plugin_directory_info_new (const char* uri) {
	return synapse_directory_plugin_directory_info_construct (SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, uri);
}


static void synapse_directory_plugin_directory_info_initialize_data_free (gpointer _data) {
	SynapseDirectoryPluginDirectoryInfoInitializeData* data;
	data = _data;
	synapse_directory_plugin_directory_info_unref (data->self);
	g_slice_free (SynapseDirectoryPluginDirectoryInfoInitializeData, data);
}


static void synapse_directory_plugin_directory_info_initialize (SynapseDirectoryPluginDirectoryInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDirectoryPluginDirectoryInfoInitializeData* _data_;
	_data_ = g_slice_new0 (SynapseDirectoryPluginDirectoryInfoInitializeData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, synapse_directory_plugin_directory_info_initialize);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_directory_plugin_directory_info_initialize_data_free);
	_data_->self = synapse_directory_plugin_directory_info_ref (self);
	synapse_directory_plugin_directory_info_initialize_co (_data_);
}


static void synapse_directory_plugin_directory_info_initialize_finish (SynapseDirectoryPluginDirectoryInfo* self, GAsyncResult* _res_) {
	SynapseDirectoryPluginDirectoryInfoInitializeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_directory_plugin_directory_info_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDirectoryPluginDirectoryInfoInitializeData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_directory_plugin_directory_info_initialize_co (data);
}


static gboolean synapse_directory_plugin_directory_info_initialize_co (SynapseDirectoryPluginDirectoryInfoInitializeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 12:
		goto _state_12;
	}
	_state_0:
	data->f = g_file_new_for_uri (synapse_uri_match_get_uri ((SynapseUriMatch*) data->self->match_obj));
	{
		data->_state_ = 12;
		g_file_query_info_async (data->f, G_FILE_ATTRIBUTE_STANDARD_ICON "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_ATTRIBUTE_CUSTOM_ICON, 0, G_PRIORITY_DEFAULT, NULL, synapse_directory_plugin_directory_info_initialize_ready, data);
		return FALSE;
		_state_12:
		data->fi = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		data->self->name = (data->_tmp0_ = g_strdup (g_file_info_get_display_name (data->fi)), _g_free0 (data->self->name), data->_tmp0_);
		data->self->name_folded = (data->_tmp1_ = g_utf8_casefold (data->self->name, -1), _g_free0 (data->self->name_folded), data->_tmp1_);
		synapse_match_set_title ((SynapseMatch*) data->self->match_obj, data->self->name);
		synapse_match_set_icon_name ((SynapseMatch*) data->self->match_obj, data->_tmp2_ = g_icon_to_string (g_file_info_get_icon (data->fi)));
		_g_free0 (data->_tmp2_);
		if (g_file_info_has_attribute (data->fi, SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_ATTRIBUTE_CUSTOM_ICON)) {
			data->icon_f = g_file_new_for_uri (g_file_info_get_attribute_string (data->fi, SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_ATTRIBUTE_CUSTOM_ICON));
			synapse_match_set_icon_name ((SynapseMatch*) data->self->match_obj, data->_tmp3_ = g_file_get_path (data->icon_f));
			_g_free0 (data->_tmp3_);
			_g_object_unref0 (data->icon_f);
		}
		_g_object_unref0 (data->fi);
	}
	goto __finally15;
	__catch15_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("directory-plugin.vala:108: %s", data->err->message);
			_g_error_free0 (data->err);
		}
	}
	__finally15:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->self->priv->initialized = TRUE;
	_g_object_unref0 (data->f);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_directory_plugin_value_directory_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void synapse_directory_plugin_value_directory_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		synapse_directory_plugin_directory_info_unref (value->data[0].v_pointer);
	}
}


static void synapse_directory_plugin_value_directory_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_directory_plugin_directory_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer synapse_directory_plugin_value_directory_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* synapse_directory_plugin_value_directory_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SynapseDirectoryPluginDirectoryInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_directory_plugin_directory_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* synapse_directory_plugin_value_directory_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SynapseDirectoryPluginDirectoryInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_directory_plugin_directory_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* synapse_directory_plugin_param_spec_directory_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SynapseDirectoryPluginParamSpecDirectoryInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer synapse_directory_plugin_value_get_directory_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
	return value->data[0].v_pointer;
}


static void synapse_directory_plugin_value_set_directory_info (GValue* value, gpointer v_object) {
	SynapseDirectoryPluginDirectoryInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_directory_plugin_directory_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_directory_plugin_directory_info_unref (old);
	}
}


static void synapse_directory_plugin_value_take_directory_info (GValue* value, gpointer v_object) {
	SynapseDirectoryPluginDirectoryInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_directory_plugin_directory_info_unref (old);
	}
}


static void synapse_directory_plugin_directory_info_class_init (SynapseDirectoryPluginDirectoryInfoClass * klass) {
	synapse_directory_plugin_directory_info_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_CLASS (klass)->finalize = synapse_directory_plugin_directory_info_finalize;
	g_type_class_add_private (klass, sizeof (SynapseDirectoryPluginDirectoryInfoPrivate));
}


static void synapse_directory_plugin_directory_info_instance_init (SynapseDirectoryPluginDirectoryInfo * self) {
	self->priv = SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_GET_PRIVATE (self);
	self->priv->initialized = FALSE;
	self->ref_count = 1;
}


static void synapse_directory_plugin_directory_info_finalize (SynapseDirectoryPluginDirectoryInfo* obj) {
	SynapseDirectoryPluginDirectoryInfo * self;
	self = SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO (obj);
	_g_object_unref0 (self->match_obj);
	_g_free0 (self->name);
	_g_free0 (self->name_folded);
}


static GType synapse_directory_plugin_directory_info_get_type (void) {
	static volatile gsize synapse_directory_plugin_directory_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_directory_plugin_directory_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_directory_plugin_value_directory_info_init, synapse_directory_plugin_value_directory_info_free_value, synapse_directory_plugin_value_directory_info_copy_value, synapse_directory_plugin_value_directory_info_peek_pointer, "p", synapse_directory_plugin_value_directory_info_collect_value, "p", synapse_directory_plugin_value_directory_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDirectoryPluginDirectoryInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_directory_plugin_directory_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDirectoryPluginDirectoryInfo), 0, (GInstanceInitFunc) synapse_directory_plugin_directory_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_directory_plugin_directory_info_type_id;
		synapse_directory_plugin_directory_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseDirectoryPluginDirectoryInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&synapse_directory_plugin_directory_info_type_id__volatile, synapse_directory_plugin_directory_info_type_id);
	}
	return synapse_directory_plugin_directory_info_type_id__volatile;
}


static gpointer synapse_directory_plugin_directory_info_ref (gpointer instance) {
	SynapseDirectoryPluginDirectoryInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void synapse_directory_plugin_directory_info_unref (gpointer instance) {
	SynapseDirectoryPluginDirectoryInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static SynapseDirectoryPluginConfig* synapse_directory_plugin_config_construct (GType object_type) {
	SynapseDirectoryPluginConfig * self = NULL;
	self = (SynapseDirectoryPluginConfig*) synapse_config_object_construct (object_type);
	return self;
}


static SynapseDirectoryPluginConfig* synapse_directory_plugin_config_new (void) {
	return synapse_directory_plugin_config_construct (SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG);
}


static gboolean synapse_directory_plugin_config_get_home_dir_children_only (SynapseDirectoryPluginConfig* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_home_dir_children_only;
	return result;
}


static void synapse_directory_plugin_config_set_home_dir_children_only (SynapseDirectoryPluginConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_home_dir_children_only = value;
	g_object_notify ((GObject *) self, "home-dir-children-only");
}


static void synapse_directory_plugin_config_class_init (SynapseDirectoryPluginConfigClass * klass) {
	synapse_directory_plugin_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDirectoryPluginConfigPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_directory_plugin_config_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_directory_plugin_config_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_directory_plugin_config_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY, g_param_spec_boolean ("home-dir-children-only", "home-dir-children-only", "home-dir-children-only", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_directory_plugin_config_instance_init (SynapseDirectoryPluginConfig * self) {
	self->priv = SYNAPSE_DIRECTORY_PLUGIN_CONFIG_GET_PRIVATE (self);
	self->priv->_home_dir_children_only = TRUE;
}


static void synapse_directory_plugin_config_finalize (GObject* obj) {
	SynapseDirectoryPluginConfig * self;
	self = SYNAPSE_DIRECTORY_PLUGIN_CONFIG (obj);
	G_OBJECT_CLASS (synapse_directory_plugin_config_parent_class)->finalize (obj);
}


static GType synapse_directory_plugin_config_get_type (void) {
	static volatile gsize synapse_directory_plugin_config_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_directory_plugin_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDirectoryPluginConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_directory_plugin_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDirectoryPluginConfig), 0, (GInstanceInitFunc) synapse_directory_plugin_config_instance_init, NULL };
		GType synapse_directory_plugin_config_type_id;
		synapse_directory_plugin_config_type_id = g_type_register_static (SYNAPSE_TYPE_CONFIG_OBJECT, "SynapseDirectoryPluginConfig", &g_define_type_info, 0);
		g_once_init_leave (&synapse_directory_plugin_config_type_id__volatile, synapse_directory_plugin_config_type_id);
	}
	return synapse_directory_plugin_config_type_id__volatile;
}


static void synapse_directory_plugin_config_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDirectoryPluginConfig * self;
	self = SYNAPSE_DIRECTORY_PLUGIN_CONFIG (object);
	switch (property_id) {
		case SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY:
		g_value_set_boolean (value, synapse_directory_plugin_config_get_home_dir_children_only (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_directory_plugin_config_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDirectoryPluginConfig * self;
	self = SYNAPSE_DIRECTORY_PLUGIN_CONFIG (object);
	switch (property_id) {
		case SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY:
		synapse_directory_plugin_config_set_home_dir_children_only (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_directory_plugin_class_init (SynapseDirectoryPluginClass * klass) {
	synapse_directory_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDirectoryPluginPrivate));
	G_OBJECT_CLASS (klass)->constructed = synapse_directory_plugin_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = synapse_directory_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_directory_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_directory_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_directory_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK, g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_ENABLED, "enabled");
	g_signal_new ("zeitgeist_search_complete", SYNAPSE_TYPE_DIRECTORY_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
	{
		synapse_directory_plugin_register_plugin ();
	}
}


static void synapse_directory_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_directory_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = synapse_directory_plugin_real_activate;
	iface->deactivate = synapse_directory_plugin_real_deactivate;
	iface->get_enabled = synapse_directory_plugin_real_get_enabled;
	iface->set_enabled = synapse_directory_plugin_real_set_enabled;
}


static void synapse_directory_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_directory_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = synapse_directory_plugin_real_search;
	iface->search_finish = synapse_directory_plugin_real_search_finish;
}


static void synapse_directory_plugin_instance_init (SynapseDirectoryPlugin * self) {
	self->priv = SYNAPSE_DIRECTORY_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->xdg_indexed = FALSE;
	self->priv->home_dir_uri = NULL;
}


static void synapse_directory_plugin_finalize (GObject* obj) {
	SynapseDirectoryPlugin * self;
	self = SYNAPSE_DIRECTORY_PLUGIN (obj);
	_g_object_unref0 (self->priv->directory_info_map);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->home_dir_uri);
	G_OBJECT_CLASS (synapse_directory_plugin_parent_class)->finalize (obj);
}


GType synapse_directory_plugin_get_type (void) {
	static volatile gsize synapse_directory_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_directory_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDirectoryPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_directory_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDirectoryPlugin), 0, (GInstanceInitFunc) synapse_directory_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_directory_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_directory_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_directory_plugin_type_id;
		synapse_directory_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDirectoryPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_directory_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_directory_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_directory_plugin_type_id__volatile, synapse_directory_plugin_type_id);
	}
	return synapse_directory_plugin_type_id__volatile;
}


static void synapse_directory_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDirectoryPlugin * self;
	self = SYNAPSE_DIRECTORY_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK:
		g_value_set_object (value, synapse_directory_plugin_get_data_sink (self));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_directory_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDirectoryPlugin * self;
	self = SYNAPSE_DIRECTORY_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK:
		synapse_directory_plugin_set_data_sink (self, g_value_get_object (value));
		break;
		case SYNAPSE_DIRECTORY_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



