/* calculator-plugin.c generated by valac 0.10.4, the Vala compiler
 * generated from calculator-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Magnus Kulke <mkulke@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <float.h>
#include <math.h>


#define SYNAPSE_TYPE_CALCULATOR_PLUGIN (synapse_calculator_plugin_get_type ())
#define SYNAPSE_CALCULATOR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin))
#define SYNAPSE_CALCULATOR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPluginClass))
#define SYNAPSE_IS_CALCULATOR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN))
#define SYNAPSE_IS_CALCULATOR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CALCULATOR_PLUGIN))
#define SYNAPSE_CALCULATOR_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPluginClass))

typedef struct _SynapseCalculatorPlugin SynapseCalculatorPlugin;
typedef struct _SynapseCalculatorPluginClass SynapseCalculatorPluginClass;
typedef struct _SynapseCalculatorPluginPrivate SynapseCalculatorPluginPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT (synapse_calculator_plugin_result_get_type ())
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult))
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultClass))
#define SYNAPSE_CALCULATOR_PLUGIN_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CALCULATOR_PLUGIN_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultClass))

typedef struct _SynapseCalculatorPluginResult SynapseCalculatorPluginResult;
typedef struct _SynapseCalculatorPluginResultClass SynapseCalculatorPluginResultClass;
typedef struct _SynapseCalculatorPluginSearchData SynapseCalculatorPluginSearchData;
typedef struct _SynapseCalculatorPluginResultPrivate SynapseCalculatorPluginResultPrivate;

struct _SynapseCalculatorPlugin {
	GObject parent_instance;
	SynapseCalculatorPluginPrivate * priv;
};

struct _SynapseCalculatorPluginClass {
	GObjectClass parent_class;
};

struct _SynapseCalculatorPluginPrivate {
	gboolean _enabled;
	GRegex* regex;
};

struct _SynapseCalculatorPluginSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseCalculatorPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	char* input;
	gboolean matched;
	gboolean _tmp0_;
	char* _tmp1_;
	GPid pid;
	gint read_fd;
	gint write_fd;
	char** argv;
	char** _tmp2_;
	gint argv_length1;
	gint _argv_size_;
	char** _tmp3_;
	char* solution;
	GUnixInputStream* read_stream;
	GDataInputStream* bc_output;
	GUnixOutputStream* write_stream;
	GDataOutputStream* bc_input;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	double d;
	SynapseCalculatorPluginResult* _result_;
	SynapseResultSet* results;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseCalculatorPluginResult {
	GObject parent_instance;
	SynapseCalculatorPluginResultPrivate * priv;
};

struct _SynapseCalculatorPluginResultClass {
	GObjectClass parent_class;
};

struct _SynapseCalculatorPluginResultPrivate {
	char* _title;
	char* _description;
	char* _icon_name;
	gboolean _has_thumbnail;
	char* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
};


static gpointer synapse_calculator_plugin_result_parent_class = NULL;
static SynapseMatchIface* synapse_calculator_plugin_result_synapse_match_parent_iface = NULL;
static gpointer synapse_calculator_plugin_parent_class = NULL;
static SynapseActivatableIface* synapse_calculator_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface* synapse_calculator_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_calculator_plugin_get_type (void) G_GNUC_CONST;
#define SYNAPSE_CALCULATOR_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPluginPrivate))
enum  {
	SYNAPSE_CALCULATOR_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_ENABLED
};
static void synapse_calculator_plugin_real_activate (SynapseActivatable* base);
static void synapse_calculator_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_calculator_plugin_register_plugin (void);
static void _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_calculator_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* query);
static void synapse_calculator_plugin_real_search_data_free (gpointer _data);
static void synapse_calculator_plugin_real_search (SynapseItemProvider* base, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_calculator_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_calculator_plugin_real_search_co (SynapseCalculatorPluginSearchData* data);
static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_new (double _result_, const char* match_string);
static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_construct (GType object_type, double _result_, const char* match_string);
static GType synapse_calculator_plugin_result_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
SynapseCalculatorPlugin* synapse_calculator_plugin_new (void);
SynapseCalculatorPlugin* synapse_calculator_plugin_construct (GType object_type);
static GObject * synapse_calculator_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultPrivate))
enum  {
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_DUMMY_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY
};
static gint synapse_calculator_plugin_result_get_default_relevancy (SynapseCalculatorPluginResult* self);
static void synapse_calculator_plugin_result_set_default_relevancy (SynapseCalculatorPluginResult* self, gint value);
static void synapse_calculator_plugin_result_finalize (GObject* obj);
static void synapse_calculator_plugin_result_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_calculator_plugin_result_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_calculator_plugin_finalize (GObject* obj);
static void synapse_calculator_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_calculator_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static void synapse_calculator_plugin_real_activate (SynapseActivatable* base) {
	SynapseCalculatorPlugin * self;
	self = (SynapseCalculatorPlugin*) base;
}


static void synapse_calculator_plugin_real_deactivate (SynapseActivatable* base) {
	SynapseCalculatorPlugin * self;
	self = (SynapseCalculatorPlugin*) base;
}


static void _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func (void) {
	synapse_calculator_plugin_register_plugin ();
}


static void synapse_calculator_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_;
	char* _tmp1_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp0_ = synapse_data_sink_plugin_registry_get_default (), SYNAPSE_TYPE_CALCULATOR_PLUGIN, _ ("Calculator"), _ ("Calculate basic expressions."), "accessories-calculator", _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func, (_tmp1_ = g_find_program_in_path ("bc")) != NULL, _ ("bc is not installed"));
	_g_free0 (_tmp1_);
	_g_object_unref0 (_tmp0_);
}


static gboolean synapse_calculator_plugin_real_handles_query (SynapseItemProvider* base, SynapseQuery* query) {
	SynapseCalculatorPlugin * self;
	gboolean result = FALSE;
	self = (SynapseCalculatorPlugin*) base;
	result = ((*query).query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
	return result;
}


static void synapse_calculator_plugin_real_search_data_free (gpointer _data) {
	SynapseCalculatorPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->query);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (SynapseCalculatorPluginSearchData, data);
}


static void synapse_calculator_plugin_real_search (SynapseItemProvider* base, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseCalculatorPlugin * self;
	SynapseCalculatorPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseCalculatorPlugin*) base;
	_data_ = g_slice_new0 (SynapseCalculatorPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_calculator_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_calculator_plugin_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->query = (synapse_query_copy (query, &_tmp0_), _tmp0_);
	synapse_calculator_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_calculator_plugin_real_search_finish (SynapseItemProvider* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseCalculatorPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_calculator_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseCalculatorPluginSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_calculator_plugin_real_search_co (data);
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_slice (const char* self, glong start, glong end) {
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp0_ = start <= string_length;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	if (end >= 0) {
		_tmp1_ = end <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	start_string = g_utf8_offset_to_pointer (self, start);
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
	return result;
}


static gboolean synapse_calculator_plugin_real_search_co (SynapseCalculatorPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
	}
	_state_0:
	data->input = string_replace (data->query.query_string, " ", "");
	data->matched = g_regex_match (data->self->priv->regex, data->input, 0, NULL);
	if (!data->matched) {
		data->_tmp0_ = string_get_length (data->input) > 1;
	} else {
		data->_tmp0_ = FALSE;
	}
	if (data->_tmp0_) {
		data->input = (data->_tmp1_ = string_slice (data->input, (glong) 0, string_get_length (data->input) - 1), _g_free0 (data->input), data->_tmp1_);
		data->matched = g_regex_match (data->self->priv->regex, data->input, 0, NULL);
	}
	if (data->matched) {
		data->_tmp2_ = NULL;
		data->argv = (data->_tmp3_ = (data->_tmp2_ = g_new0 (char*, 2 + 1), data->_tmp2_[0] = g_strdup ("bc"), data->_tmp2_[1] = g_strdup ("-l"), data->_tmp2_), data->argv_length1 = 2, data->_argv_size_ = data->argv_length1, data->_tmp3_);
		data->solution = NULL;
		{
			g_spawn_async_with_pipes (NULL, data->argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &data->pid, &data->write_fd, &data->read_fd, NULL, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
			data->read_stream = (GUnixInputStream*) g_unix_input_stream_new (data->read_fd, TRUE);
			data->bc_output = g_data_input_stream_new ((GInputStream*) data->read_stream);
			data->write_stream = (GUnixOutputStream*) g_unix_output_stream_new (data->write_fd, TRUE);
			data->bc_input = g_data_output_stream_new ((GOutputStream*) data->write_stream);
			g_data_output_stream_put_string (data->bc_input, data->_tmp4_ = g_strconcat (data->input, "\n", NULL), data->query.cancellable, &data->_inner_error_);
			_g_free0 (data->_tmp4_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->bc_input);
				_g_object_unref0 (data->write_stream);
				_g_object_unref0 (data->bc_output);
				_g_object_unref0 (data->read_stream);
				goto __catch7_g_error;
			}
			data->_state_ = 1;
			g_output_stream_close_async ((GOutputStream*) data->bc_input, G_PRIORITY_DEFAULT, data->query.cancellable, synapse_calculator_plugin_search_ready, data);
			return FALSE;
			_state_1:
			g_output_stream_close_finish ((GOutputStream*) data->bc_input, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->bc_input);
				_g_object_unref0 (data->write_stream);
				_g_object_unref0 (data->bc_output);
				_g_object_unref0 (data->read_stream);
				goto __catch7_g_error;
			}
			data->_state_ = 2;
			g_data_input_stream_read_line_async (data->bc_output, G_PRIORITY_DEFAULT_IDLE, data->query.cancellable, synapse_calculator_plugin_search_ready, data);
			return FALSE;
			_state_2:
			data->_tmp5_ = g_data_input_stream_read_line_finish (data->bc_output, data->_res_, NULL, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->bc_input);
				_g_object_unref0 (data->write_stream);
				_g_object_unref0 (data->bc_output);
				_g_object_unref0 (data->read_stream);
				goto __catch7_g_error;
			}
			data->solution = (data->_tmp6_ = data->_tmp5_, _g_free0 (data->solution), data->_tmp6_);
			if (data->solution != NULL) {
				data->d = g_ascii_strtod (data->solution, NULL);
				data->_result_ = synapse_calculator_plugin_result_new (data->d, data->query.query_string);
				data->results = synapse_result_set_new ();
				synapse_result_set_add (data->results, (SynapseMatch*) data->_result_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
				synapse_query_check_cancellable (&data->query, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->results);
					_g_object_unref0 (data->_result_);
					_g_object_unref0 (data->bc_input);
					_g_object_unref0 (data->write_stream);
					_g_object_unref0 (data->bc_output);
					_g_object_unref0 (data->read_stream);
					goto __catch7_g_error;
				}
				data->result = data->results;
				_g_object_unref0 (data->_result_);
				_g_object_unref0 (data->bc_input);
				_g_object_unref0 (data->write_stream);
				_g_object_unref0 (data->bc_output);
				_g_object_unref0 (data->read_stream);
				_g_free0 (data->solution);
				data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->input);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_object_unref0 (data->results);
				_g_object_unref0 (data->_result_);
			}
			_g_object_unref0 (data->bc_input);
			_g_object_unref0 (data->write_stream);
			_g_object_unref0 (data->bc_output);
			_g_object_unref0 (data->read_stream);
		}
		goto __finally7;
		__catch7_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				if (!synapse_query_is_cancelled (&data->query)) {
					g_warning ("calculator-plugin.vala:139: %s", data->err->message);
				}
				_g_error_free0 (data->err);
			}
		}
		__finally7:
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->solution);
				data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->input);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				_g_free0 (data->solution);
				data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->input);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		_g_free0 (data->solution);
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	}
	synapse_query_check_cancellable (&data->query, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->input);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_free0 (data->input);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = NULL;
	_g_free0 (data->input);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_free0 (data->input);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


SynapseCalculatorPlugin* synapse_calculator_plugin_construct (GType object_type) {
	SynapseCalculatorPlugin * self = NULL;
	self = (SynapseCalculatorPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseCalculatorPlugin* synapse_calculator_plugin_new (void) {
	return synapse_calculator_plugin_construct (SYNAPSE_TYPE_CALCULATOR_PLUGIN);
}


static gboolean synapse_calculator_plugin_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseCalculatorPlugin* self;
	self = (SynapseCalculatorPlugin*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_calculator_plugin_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseCalculatorPlugin* self;
	self = (SynapseCalculatorPlugin*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_calculator_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCalculatorPlugin * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (synapse_calculator_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_CALCULATOR_PLUGIN (obj);
	_inner_error_ = NULL;
	{
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("^\\(*(-?\\d+(\\.\\d+)?)([*/+-^]\\(*(-?\\d+(\\.\\d+)?)\\)*)+$", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		self->priv->regex = (_tmp2_ = _tmp1_, _g_regex_unref0 (self->priv->regex), _tmp2_);
	}
	return obj;
}


static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_construct (GType object_type, double _result_, const char* match_string) {
	SynapseCalculatorPluginResult * self = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (match_string != NULL, NULL);
	self = (SynapseCalculatorPluginResult*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_TEXT, "title", _tmp0_ = g_strdup_printf ("%g", _result_), "description", _tmp1_ = g_strdup_printf ("%s = %g", match_string, _result_), "has-thumbnail", FALSE, "icon-name", "accessories-calculator", NULL);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	return self;
}


static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_new (double _result_, const char* match_string) {
	return synapse_calculator_plugin_result_construct (SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, _result_, match_string);
}


static const char* synapse_calculator_plugin_result_real_get_title (SynapseMatch* base) {
	const char* result;
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_calculator_plugin_result_real_set_title (SynapseMatch* base, const char* value) {
	SynapseCalculatorPluginResult* self;
	char* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	self->priv->_title = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_title), _tmp0_);
	g_object_notify ((GObject *) self, "title");
}


static const char* synapse_calculator_plugin_result_real_get_description (SynapseMatch* base) {
	const char* result;
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_calculator_plugin_result_real_set_description (SynapseMatch* base, const char* value) {
	SynapseCalculatorPluginResult* self;
	char* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


static const char* synapse_calculator_plugin_result_real_get_icon_name (SynapseMatch* base) {
	const char* result;
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_calculator_plugin_result_real_set_icon_name (SynapseMatch* base, const char* value) {
	SynapseCalculatorPluginResult* self;
	char* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_calculator_plugin_result_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_calculator_plugin_result_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const char* synapse_calculator_plugin_result_real_get_thumbnail_path (SynapseMatch* base) {
	const char* result;
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_calculator_plugin_result_real_set_thumbnail_path (SynapseMatch* base, const char* value) {
	SynapseCalculatorPluginResult* self;
	char* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	self->priv->_thumbnail_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_thumbnail_path), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_calculator_plugin_result_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_calculator_plugin_result_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static gint synapse_calculator_plugin_result_get_default_relevancy (SynapseCalculatorPluginResult* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}


static void synapse_calculator_plugin_result_set_default_relevancy (SynapseCalculatorPluginResult* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_default_relevancy = value;
	g_object_notify ((GObject *) self, "default-relevancy");
}


static void synapse_calculator_plugin_result_class_init (SynapseCalculatorPluginResultClass * klass) {
	synapse_calculator_plugin_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseCalculatorPluginResultPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_calculator_plugin_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_calculator_plugin_result_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_result_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE, "match-type");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY, g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_calculator_plugin_result_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_calculator_plugin_result_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_calculator_plugin_result_real_get_title;
	iface->set_title = synapse_calculator_plugin_result_real_set_title;
	iface->get_description = synapse_calculator_plugin_result_real_get_description;
	iface->set_description = synapse_calculator_plugin_result_real_set_description;
	iface->get_icon_name = synapse_calculator_plugin_result_real_get_icon_name;
	iface->set_icon_name = synapse_calculator_plugin_result_real_set_icon_name;
	iface->get_has_thumbnail = synapse_calculator_plugin_result_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_calculator_plugin_result_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_calculator_plugin_result_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_calculator_plugin_result_real_set_thumbnail_path;
	iface->get_match_type = synapse_calculator_plugin_result_real_get_match_type;
	iface->set_match_type = synapse_calculator_plugin_result_real_set_match_type;
}


static void synapse_calculator_plugin_result_instance_init (SynapseCalculatorPluginResult * self) {
	self->priv = SYNAPSE_CALCULATOR_PLUGIN_RESULT_GET_PRIVATE (self);
	self->priv->_default_relevancy = 0;
}


static void synapse_calculator_plugin_result_finalize (GObject* obj) {
	SynapseCalculatorPluginResult * self;
	self = SYNAPSE_CALCULATOR_PLUGIN_RESULT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_calculator_plugin_result_parent_class)->finalize (obj);
}


static GType synapse_calculator_plugin_result_get_type (void) {
	static volatile gsize synapse_calculator_plugin_result_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_calculator_plugin_result_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPluginResult), 0, (GInstanceInitFunc) synapse_calculator_plugin_result_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_calculator_plugin_result_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_calculator_plugin_result_type_id;
		synapse_calculator_plugin_result_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCalculatorPluginResult", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_calculator_plugin_result_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_once_init_leave (&synapse_calculator_plugin_result_type_id__volatile, synapse_calculator_plugin_result_type_id);
	}
	return synapse_calculator_plugin_result_type_id__volatile;
}


static void synapse_calculator_plugin_result_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseCalculatorPluginResult * self;
	self = SYNAPSE_CALCULATOR_PLUGIN_RESULT (object);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY:
		g_value_set_int (value, synapse_calculator_plugin_result_get_default_relevancy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_calculator_plugin_result_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseCalculatorPluginResult * self;
	self = SYNAPSE_CALCULATOR_PLUGIN_RESULT (object);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY:
		synapse_calculator_plugin_result_set_default_relevancy (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_calculator_plugin_class_init (SynapseCalculatorPluginClass * klass) {
	synapse_calculator_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseCalculatorPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_calculator_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_calculator_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_calculator_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_ENABLED, "enabled");
	{
		synapse_calculator_plugin_register_plugin ();
	}
}


static void synapse_calculator_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_calculator_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = synapse_calculator_plugin_real_activate;
	iface->deactivate = synapse_calculator_plugin_real_deactivate;
	iface->get_enabled = synapse_calculator_plugin_real_get_enabled;
	iface->set_enabled = synapse_calculator_plugin_real_set_enabled;
}


static void synapse_calculator_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface) {
	synapse_calculator_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = synapse_calculator_plugin_real_handles_query;
	iface->search = synapse_calculator_plugin_real_search;
	iface->search_finish = synapse_calculator_plugin_real_search_finish;
}


static void synapse_calculator_plugin_instance_init (SynapseCalculatorPlugin * self) {
	self->priv = SYNAPSE_CALCULATOR_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_calculator_plugin_finalize (GObject* obj) {
	SynapseCalculatorPlugin * self;
	self = SYNAPSE_CALCULATOR_PLUGIN (obj);
	_g_regex_unref0 (self->priv->regex);
	G_OBJECT_CLASS (synapse_calculator_plugin_parent_class)->finalize (obj);
}


GType synapse_calculator_plugin_get_type (void) {
	static volatile gsize synapse_calculator_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_calculator_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPlugin), 0, (GInstanceInitFunc) synapse_calculator_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_calculator_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_calculator_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_calculator_plugin_type_id;
		synapse_calculator_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCalculatorPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_calculator_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_calculator_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_once_init_leave (&synapse_calculator_plugin_type_id__volatile, synapse_calculator_plugin_type_id);
	}
	return synapse_calculator_plugin_type_id__volatile;
}


static void synapse_calculator_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseCalculatorPlugin * self;
	self = SYNAPSE_CALCULATOR_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_calculator_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseCalculatorPlugin * self;
	self = SYNAPSE_CALCULATOR_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




