/* utils.c generated by valac 0.10.4, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdarg.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseUtilsQueryExistsAsyncData SynapseUtilsQueryExistsAsyncData;

#define SYNAPSE_UTILS_TYPE_LOGGER (synapse_utils_logger_get_type ())
#define SYNAPSE_UTILS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLogger))
#define SYNAPSE_UTILS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))
#define SYNAPSE_UTILS_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))

typedef struct _SynapseUtilsLogger SynapseUtilsLogger;
typedef struct _SynapseUtilsLoggerClass SynapseUtilsLoggerClass;
typedef struct _SynapseUtilsLoggerPrivate SynapseUtilsLoggerPrivate;
typedef struct _SynapseUtilsParamSpecLogger SynapseUtilsParamSpecLogger;

#define SYNAPSE_UTILS_TYPE_FILE_INFO (synapse_utils_file_info_get_type ())
#define SYNAPSE_UTILS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo))
#define SYNAPSE_UTILS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))
#define SYNAPSE_UTILS_IS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_IS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))

typedef struct _SynapseUtilsFileInfo SynapseUtilsFileInfo;
typedef struct _SynapseUtilsFileInfoClass SynapseUtilsFileInfoClass;
typedef struct _SynapseUtilsFileInfoPrivate SynapseUtilsFileInfoPrivate;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
typedef struct _SynapseUtilsFileInfoInitializeData SynapseUtilsFileInfoInitializeData;
typedef struct _SynapseUtilsFileInfoExistsData SynapseUtilsFileInfoExistsData;
typedef struct _SynapseUtilsParamSpecFileInfo SynapseUtilsParamSpecFileInfo;

struct _SynapseUtilsQueryExistsAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* f;
	gboolean result;
	gboolean exists;
	GFileInfo* _tmp0_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseUtilsLogger {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsLoggerPrivate * priv;
};

struct _SynapseUtilsLoggerClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsLogger *self);
};

struct _SynapseUtilsParamSpecLogger {
	GParamSpec parent_instance;
};

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 1,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 3,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 5,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 6,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 7,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 15,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFF | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH
} SynapseMatchType;

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	const char* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const char* value);
	const char* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const char* value);
	const char* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const char* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const char* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const char* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const char* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const char* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const char* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const char* value);
};

struct _SynapseUtilsFileInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsFileInfoPrivate * priv;
	char* uri;
	char* parse_name;
	SynapseQueryFlags file_type;
	SynapseUriMatch* match_obj;
};

struct _SynapseUtilsFileInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsFileInfo *self);
};

struct _SynapseUtilsFileInfoPrivate {
	gboolean initialized;
	GType match_obj_type;
};

struct _SynapseUtilsFileInfoInitializeData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseUtilsFileInfo* self;
	GFile* f;
	GFileInfo* fi;
	gboolean _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	GObject* _tmp4_;
	SynapseUriMatch* _tmp5_;
	const char* mime_type;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseUtilsFileInfoExistsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseUtilsFileInfo* self;
	gboolean result;
	GFile* f;
	gboolean _result_;
};

struct _SynapseUtilsParamSpecFileInfo {
	GParamSpec parent_instance;
};


static gboolean synapse_utils_logger_initialized;
static gboolean synapse_utils_logger_initialized = FALSE;
static gboolean synapse_utils_logger_show_debug;
static gboolean synapse_utils_logger_show_debug = FALSE;
static gpointer synapse_utils_logger_parent_class = NULL;
static char* synapse_utils_file_info_interesting_attributes;
static char* synapse_utils_file_info_interesting_attributes = NULL;
static gpointer synapse_utils_file_info_parent_class = NULL;

char* synapse_utils_remove_accents (const char* input);
char* synapse_utils_remove_last_unichar (const char* input, glong offset);
static void synapse_utils_query_exists_async_data_free (gpointer _data);
static void synapse_utils_query_exists_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void synapse_utils_query_exists_async (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static gboolean synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* data);
char* synapse_utils_extract_type_name (GType obj_type);
gpointer synapse_utils_logger_ref (gpointer instance);
void synapse_utils_logger_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_logger (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void synapse_utils_value_set_logger (GValue* value, gpointer v_object);
void synapse_utils_value_take_logger (GValue* value, gpointer v_object);
gpointer synapse_utils_value_get_logger (const GValue* value);
GType synapse_utils_logger_get_type (void) G_GNUC_CONST;
enum  {
	SYNAPSE_UTILS_LOGGER_DUMMY_PROPERTY
};
#define SYNAPSE_UTILS_LOGGER_RED "\x1b[31m"
#define SYNAPSE_UTILS_LOGGER_GREEN "\x1b[32m"
#define SYNAPSE_UTILS_LOGGER_YELLOW "\x1b[33m"
#define SYNAPSE_UTILS_LOGGER_BLUE "\x1b[34m"
#define SYNAPSE_UTILS_LOGGER_MAGENTA "\x1b[35m"
#define SYNAPSE_UTILS_LOGGER_CYAN "\x1b[36m"
#define SYNAPSE_UTILS_LOGGER_RESET "\x1b[0m"
static void synapse_utils_logger_log_internal (GObject* obj, GLogLevelFlags level, const char* format, va_list args);
void synapse_utils_logger_handler (const char* domain, GLogLevelFlags level, const char* msg);
static void _synapse_utils_logger_handler_glog_func (const char* log_domain, GLogLevelFlags log_levels, const char* message, gpointer self);
void synapse_utils_logger_log (GObject* obj, const char* format, ...);
void synapse_utils_logger_debug (GObject* obj, const char* format, ...);
void synapse_utils_logger_warning (GObject* obj, const char* format, ...);
void synapse_utils_logger_error (GObject* obj, const char* format, ...);
SynapseUtilsLogger* synapse_utils_logger_new (void);
SynapseUtilsLogger* synapse_utils_logger_construct (GType object_type);
static void synapse_utils_logger_finalize (SynapseUtilsLogger* obj);
gpointer synapse_utils_file_info_ref (gpointer instance);
void synapse_utils_file_info_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_file_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void synapse_utils_value_set_file_info (GValue* value, gpointer v_object);
void synapse_utils_value_take_file_info (GValue* value, gpointer v_object);
gpointer synapse_utils_value_get_file_info (const GValue* value);
GType synapse_utils_file_info_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
#define SYNAPSE_UTILS_FILE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoPrivate))
enum  {
	SYNAPSE_UTILS_FILE_INFO_DUMMY_PROPERTY
};
SynapseUtilsFileInfo* synapse_utils_file_info_new (const char* uri, GType obj_type);
SynapseUtilsFileInfo* synapse_utils_file_info_construct (GType object_type, const char* uri, GType obj_type);
gboolean synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self);
static void synapse_utils_file_info_initialize_data_free (gpointer _data);
static void synapse_utils_file_info_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_);
static gboolean synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* data);
void synapse_uri_match_set_file_type (SynapseUriMatch* self, SynapseQueryFlags value);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self, const char* value);
static void synapse_utils_file_info_exists_data_free (gpointer _data);
static void synapse_utils_file_info_exists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void synapse_utils_file_info_exists (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_);
static gboolean synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* data);
static void synapse_utils_file_info_finalize (SynapseUtilsFileInfo* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


char* synapse_utils_remove_accents (const char* input) {
	char* result = NULL;
	char* _result_;
	const char* charset;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_result_ = NULL;
	charset = NULL;
	g_get_charset (&charset);
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = g_convert (input, (gssize) string_get_length (input), "US-ASCII//TRANSLIT", charset, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch23_g_convert_error;
			}
			_g_free0 (_result_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_result_ = (_tmp1_ = _tmp0_, _g_free0 (_result_), _tmp1_);
		if (_vala_strcmp0 (input, _result_) == 0) {
			result = NULL;
			_g_free0 (_result_);
			return result;
		}
	}
	goto __finally23;
	__catch23_g_convert_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
			_result_ = (_tmp2_ = NULL, _g_free0 (_result_), _tmp2_);
			_g_error_free0 (err);
		}
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_free0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _result_;
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


char* synapse_utils_remove_last_unichar (const char* input, glong offset) {
	char* result = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	result = string_substring (input, offset, string_get_length (input) - 1);
	return result;
}


static void synapse_utils_query_exists_async_data_free (gpointer _data) {
	SynapseUtilsQueryExistsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->f);
	g_slice_free (SynapseUtilsQueryExistsAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void synapse_utils_query_exists_async (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = g_slice_new0 (SynapseUtilsQueryExistsAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, synapse_utils_query_exists_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_utils_query_exists_async_data_free);
	_data_->f = _g_object_ref0 (f);
	synapse_utils_query_exists_async_co (_data_);
}


gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_) {
	gboolean result;
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void synapse_utils_query_exists_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseUtilsQueryExistsAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_utils_query_exists_async_co (data);
}


static gboolean synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 20:
		goto _state_20;
	}
	_state_0:
	{
		data->_state_ = 20;
		g_file_query_info_async (data->f, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_utils_query_exists_async_ready, data);
		return FALSE;
		_state_20:
		data->_tmp0_ = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
		_g_object_unref0 (data->_tmp0_);
		if (data->_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		data->exists = TRUE;
	}
	goto __finally24;
	__catch24_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			data->exists = FALSE;
			_g_error_free0 (data->err);
		}
	}
	__finally24:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->result = data->exists;
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


char* synapse_utils_extract_type_name (GType obj_type) {
	char* result = NULL;
	char* obj_class;
	obj_class = g_strdup (g_type_name (obj_type));
	if (g_str_has_prefix (obj_class, "Synapse")) {
		result = string_substring (obj_class, (glong) 7, -1);
		_g_free0 (obj_class);
		return result;
	}
	result = obj_class;
	return result;
}


static void _synapse_utils_logger_handler_glog_func (const char* log_domain, GLogLevelFlags log_levels, const char* message, gpointer self) {
	synapse_utils_logger_handler (log_domain, log_levels, message);
}


static void synapse_utils_logger_log_internal (GObject* obj, GLogLevelFlags level, const char* format, va_list args) {
	GType _tmp0_ = 0UL;
	GType obj_type;
	char* obj_class;
	char* pretty_obj;
	char* _tmp1_;
	g_return_if_fail (format != NULL);
	if (!synapse_utils_logger_initialized) {
		GLogLevelFlags levels;
		levels = (((G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_INFO) | G_LOG_LEVEL_WARNING) | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR;
		g_log_set_handler ("Synapse", levels, _synapse_utils_logger_handler_glog_func, NULL);
		synapse_utils_logger_show_debug = g_getenv ("SYNAPSE_DEBUG") != NULL;
		synapse_utils_logger_initialized = TRUE;
	}
	if (obj != NULL) {
		_tmp0_ = G_TYPE_FROM_INSTANCE (obj);
	} else {
		_tmp0_ = SYNAPSE_UTILS_TYPE_LOGGER;
	}
	obj_type = _tmp0_;
	obj_class = synapse_utils_extract_type_name (obj_type);
	pretty_obj = g_strdup_printf ("%s[%s]%s ", SYNAPSE_UTILS_LOGGER_MAGENTA, obj_class, SYNAPSE_UTILS_LOGGER_RESET);
	g_logv ("Synapse", level, _tmp1_ = g_strconcat (pretty_obj, format, NULL), args);
	_g_free0 (_tmp1_);
	_g_free0 (pretty_obj);
	_g_free0 (obj_class);
}


void synapse_utils_logger_log (GObject* obj, const char* format, ...) {
	va_list args;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_INFO, format, args);
	va_end (args);
}


void synapse_utils_logger_debug (GObject* obj, const char* format, ...) {
	va_list args;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_DEBUG, format, args);
	va_end (args);
}


void synapse_utils_logger_warning (GObject* obj, const char* format, ...) {
	va_list args;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_WARNING, format, args);
	va_end (args);
}


void synapse_utils_logger_error (GObject* obj, const char* format, ...) {
	va_list args;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_ERROR, format, args);
	va_end (args);
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void synapse_utils_logger_handler (const char* domain, GLogLevelFlags level, const char* msg) {
	char* header;
	GTimeVal _tmp0_ = {0};
	GTimeVal _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* cur_time;
	g_return_if_fail (msg != NULL);
	header = NULL;
	cur_time = (_tmp3_ = string_substring (_tmp2_ = g_time_val_to_iso8601 ((_tmp1_ = (g_get_current_time (&_tmp0_), _tmp0_), &_tmp1_)), (glong) 11, (glong) 15), _g_free0 (_tmp2_), _tmp3_);
	if (level == G_LOG_LEVEL_DEBUG) {
		char* _tmp4_;
		if (!synapse_utils_logger_show_debug) {
			_g_free0 (cur_time);
			_g_free0 (header);
			return;
		}
		header = (_tmp4_ = g_strconcat (string_to_string (SYNAPSE_UTILS_LOGGER_GREEN), "[", string_to_string (cur_time), " Debug]", string_to_string (SYNAPSE_UTILS_LOGGER_RESET), NULL), _g_free0 (header), _tmp4_);
	} else {
		if (level == G_LOG_LEVEL_INFO) {
			char* _tmp5_;
			header = (_tmp5_ = g_strconcat (string_to_string (SYNAPSE_UTILS_LOGGER_BLUE), "[", string_to_string (cur_time), " Info]", string_to_string (SYNAPSE_UTILS_LOGGER_RESET), NULL), _g_free0 (header), _tmp5_);
		} else {
			if (level == G_LOG_LEVEL_WARNING) {
				char* _tmp6_;
				header = (_tmp6_ = g_strconcat (string_to_string (SYNAPSE_UTILS_LOGGER_RED), "[", string_to_string (cur_time), " Warning]", string_to_string (SYNAPSE_UTILS_LOGGER_RESET), NULL), _g_free0 (header), _tmp6_);
			} else {
				gboolean _tmp7_ = FALSE;
				if (level == G_LOG_LEVEL_CRITICAL) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = level == G_LOG_LEVEL_ERROR;
				}
				if (_tmp7_) {
					char* _tmp8_;
					header = (_tmp8_ = g_strconcat (string_to_string (SYNAPSE_UTILS_LOGGER_RED), "[", string_to_string (cur_time), " Critical]", string_to_string (SYNAPSE_UTILS_LOGGER_RESET), NULL), _g_free0 (header), _tmp8_);
				} else {
					char* _tmp9_;
					header = (_tmp9_ = g_strconcat (string_to_string (SYNAPSE_UTILS_LOGGER_YELLOW), "[", string_to_string (cur_time), "]", string_to_string (SYNAPSE_UTILS_LOGGER_RESET), NULL), _g_free0 (header), _tmp9_);
				}
			}
		}
	}
	fprintf (stdout, "%s %s\n", header, msg);
	_g_free0 (cur_time);
	_g_free0 (header);
}


SynapseUtilsLogger* synapse_utils_logger_construct (GType object_type) {
	SynapseUtilsLogger* self = (SynapseUtilsLogger*) g_type_create_instance (object_type);
	return self;
}


SynapseUtilsLogger* synapse_utils_logger_new (void) {
	return synapse_utils_logger_construct (SYNAPSE_UTILS_TYPE_LOGGER);
}


static void synapse_utils_value_logger_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void synapse_utils_value_logger_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		synapse_utils_logger_unref (value->data[0].v_pointer);
	}
}


static void synapse_utils_value_logger_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_utils_logger_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer synapse_utils_value_logger_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* synapse_utils_value_logger_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SynapseUtilsLogger* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_utils_logger_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* synapse_utils_value_logger_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SynapseUtilsLogger** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_utils_logger_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* synapse_utils_param_spec_logger (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SynapseUtilsParamSpecLogger* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer synapse_utils_value_get_logger (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
	return value->data[0].v_pointer;
}


void synapse_utils_value_set_logger (GValue* value, gpointer v_object) {
	SynapseUtilsLogger* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_utils_logger_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_logger_unref (old);
	}
}


void synapse_utils_value_take_logger (GValue* value, gpointer v_object) {
	SynapseUtilsLogger* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_logger_unref (old);
	}
}


static void synapse_utils_logger_class_init (SynapseUtilsLoggerClass * klass) {
	synapse_utils_logger_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_UTILS_LOGGER_CLASS (klass)->finalize = synapse_utils_logger_finalize;
}


static void synapse_utils_logger_instance_init (SynapseUtilsLogger * self) {
	self->ref_count = 1;
}


static void synapse_utils_logger_finalize (SynapseUtilsLogger* obj) {
	SynapseUtilsLogger * self;
	self = SYNAPSE_UTILS_LOGGER (obj);
}


GType synapse_utils_logger_get_type (void) {
	static volatile gsize synapse_utils_logger_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_logger_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_logger_init, synapse_utils_value_logger_free_value, synapse_utils_value_logger_copy_value, synapse_utils_value_logger_peek_pointer, "p", synapse_utils_value_logger_collect_value, "p", synapse_utils_value_logger_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsLogger), 0, (GInstanceInitFunc) synapse_utils_logger_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_utils_logger_type_id;
		synapse_utils_logger_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsLogger", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&synapse_utils_logger_type_id__volatile, synapse_utils_logger_type_id);
	}
	return synapse_utils_logger_type_id__volatile;
}


gpointer synapse_utils_logger_ref (gpointer instance) {
	SynapseUtilsLogger* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void synapse_utils_logger_unref (gpointer instance) {
	SynapseUtilsLogger* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_UTILS_LOGGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


SynapseUtilsFileInfo* synapse_utils_file_info_construct (GType object_type, const char* uri, GType obj_type) {
	SynapseUtilsFileInfo* self = (SynapseUtilsFileInfo*) g_type_create_instance (object_type);
	char* _tmp0_;
	SynapseUriMatch* _tmp1_;
	GFile* f;
	char* _tmp2_;
	g_return_val_if_fail (uri != NULL, NULL);
	g_assert (g_type_is_a (obj_type, SYNAPSE_TYPE_URI_MATCH));
	self->uri = (_tmp0_ = g_strdup (uri), _g_free0 (self->uri), _tmp0_);
	self->match_obj = (_tmp1_ = NULL, _g_object_unref0 (self->match_obj), _tmp1_);
	self->priv->match_obj_type = obj_type;
	self->priv->initialized = FALSE;
	self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
	f = g_file_new_for_uri (uri);
	self->parse_name = (_tmp2_ = g_file_get_parse_name (f), _g_free0 (self->parse_name), _tmp2_);
	_g_object_unref0 (f);
	return self;
}


SynapseUtilsFileInfo* synapse_utils_file_info_new (const char* uri, GType obj_type) {
	return synapse_utils_file_info_construct (SYNAPSE_UTILS_TYPE_FILE_INFO, uri, obj_type);
}


gboolean synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->initialized;
	return result;
}


static void synapse_utils_file_info_initialize_data_free (gpointer _data) {
	SynapseUtilsFileInfoInitializeData* data;
	data = _data;
	synapse_utils_file_info_unref (data->self);
	g_slice_free (SynapseUtilsFileInfoInitializeData, data);
}


void synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = g_slice_new0 (SynapseUtilsFileInfoInitializeData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, synapse_utils_file_info_initialize);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_utils_file_info_initialize_data_free);
	_data_->self = synapse_utils_file_info_ref (self);
	synapse_utils_file_info_initialize_co (_data_);
}


void synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_) {
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_utils_file_info_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseUtilsFileInfoInitializeData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_utils_file_info_initialize_co (data);
}


static gboolean synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 21:
		goto _state_21;
	}
	_state_0:
	data->self->priv->initialized = TRUE;
	data->f = g_file_new_for_uri (data->self->uri);
	{
		data->_state_ = 21;
		g_file_query_info_async (data->f, synapse_utils_file_info_interesting_attributes, 0, 0, NULL, synapse_utils_file_info_initialize_ready, data);
		return FALSE;
		_state_21:
		data->fi = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
		if (g_file_info_get_file_type (data->fi) == G_FILE_TYPE_REGULAR) {
			data->_tmp1_ = !g_file_info_get_is_hidden (data->fi);
		} else {
			data->_tmp1_ = FALSE;
		}
		if (data->_tmp1_) {
			data->_tmp0_ = !g_file_info_get_is_backup (data->fi);
		} else {
			data->_tmp0_ = FALSE;
		}
		if (data->_tmp0_) {
			data->self->match_obj = (data->_tmp5_ = SYNAPSE_URI_MATCH ((data->_tmp4_ = g_object_new (data->self->priv->match_obj_type, "thumbnail-path", g_file_info_get_attribute_byte_string (data->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH), "icon-name", data->_tmp2_ = g_icon_to_string (g_file_info_get_icon (data->fi)), "uri", data->self->uri, "title", g_file_info_get_display_name (data->fi), "description", data->_tmp3_ = g_file_get_parse_name (data->f), "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, NULL, NULL), G_IS_INITIALLY_UNOWNED (data->_tmp4_) ? g_object_ref_sink (data->_tmp4_) : data->_tmp4_)), _g_object_unref0 (data->self->match_obj), data->_tmp5_);
			_g_free0 (data->_tmp3_);
			_g_free0 (data->_tmp2_);
			data->mime_type = g_file_info_get_attribute_string (data->fi, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
			if (g_content_type_is_unknown (data->mime_type)) {
				data->self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
			} else {
				if (g_content_type_is_a (data->mime_type, "audio/*")) {
					data->self->file_type = SYNAPSE_QUERY_FLAGS_AUDIO;
				} else {
					if (g_content_type_is_a (data->mime_type, "video/*")) {
						data->self->file_type = SYNAPSE_QUERY_FLAGS_VIDEO;
					} else {
						if (g_content_type_is_a (data->mime_type, "image/*")) {
							data->self->file_type = SYNAPSE_QUERY_FLAGS_IMAGES;
						} else {
							if (g_content_type_is_a (data->mime_type, "text/*")) {
								data->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
							} else {
								if (g_content_type_is_a (data->mime_type, "application/*")) {
									data->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
								}
							}
						}
					}
				}
			}
			synapse_uri_match_set_file_type (data->self->match_obj, data->self->file_type);
			synapse_uri_match_set_mime_type (data->self->match_obj, data->mime_type);
		}
		_g_object_unref0 (data->fi);
	}
	goto __finally25;
	__catch25_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("utils.vala:277: %s", data->err->message);
			_g_error_free0 (data->err);
		}
	}
	__finally25:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->f);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_utils_file_info_exists_data_free (gpointer _data) {
	SynapseUtilsFileInfoExistsData* data;
	data = _data;
	synapse_utils_file_info_unref (data->self);
	g_slice_free (SynapseUtilsFileInfoExistsData, data);
}


void synapse_utils_file_info_exists (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = g_slice_new0 (SynapseUtilsFileInfoExistsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, synapse_utils_file_info_exists);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_utils_file_info_exists_data_free);
	_data_->self = synapse_utils_file_info_ref (self);
	synapse_utils_file_info_exists_co (_data_);
}


gboolean synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_) {
	gboolean result;
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void synapse_utils_file_info_exists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseUtilsFileInfoExistsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_utils_file_info_exists_co (data);
}


static gboolean synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 22:
		goto _state_22;
	}
	_state_0:
	data->f = g_file_new_for_uri (data->self->uri);
	data->_state_ = 22;
	synapse_utils_query_exists_async (data->f, synapse_utils_file_info_exists_ready, data);
	return FALSE;
	_state_22:
	data->_result_ = synapse_utils_query_exists_finish (data->_res_);
	data->result = data->_result_;
	_g_object_unref0 (data->f);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->f);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_utils_value_file_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void synapse_utils_value_file_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		synapse_utils_file_info_unref (value->data[0].v_pointer);
	}
}


static void synapse_utils_value_file_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_utils_file_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer synapse_utils_value_file_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* synapse_utils_value_file_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SynapseUtilsFileInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_utils_file_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* synapse_utils_value_file_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SynapseUtilsFileInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_utils_file_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* synapse_utils_param_spec_file_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SynapseUtilsParamSpecFileInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer synapse_utils_value_get_file_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
	return value->data[0].v_pointer;
}


void synapse_utils_value_set_file_info (GValue* value, gpointer v_object) {
	SynapseUtilsFileInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_utils_file_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_file_info_unref (old);
	}
}


void synapse_utils_value_take_file_info (GValue* value, gpointer v_object) {
	SynapseUtilsFileInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_file_info_unref (old);
	}
}


static void synapse_utils_file_info_class_init (SynapseUtilsFileInfoClass * klass) {
	synapse_utils_file_info_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_UTILS_FILE_INFO_CLASS (klass)->finalize = synapse_utils_file_info_finalize;
	g_type_class_add_private (klass, sizeof (SynapseUtilsFileInfoPrivate));
	{
		char* _tmp0_;
		synapse_utils_file_info_interesting_attributes = (_tmp0_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, NULL, NULL), _g_free0 (synapse_utils_file_info_interesting_attributes), _tmp0_);
	}
}


static void synapse_utils_file_info_instance_init (SynapseUtilsFileInfo * self) {
	self->priv = SYNAPSE_UTILS_FILE_INFO_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void synapse_utils_file_info_finalize (SynapseUtilsFileInfo* obj) {
	SynapseUtilsFileInfo * self;
	self = SYNAPSE_UTILS_FILE_INFO (obj);
	_g_free0 (self->uri);
	_g_free0 (self->parse_name);
	_g_object_unref0 (self->match_obj);
}


GType synapse_utils_file_info_get_type (void) {
	static volatile gsize synapse_utils_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_file_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_file_info_init, synapse_utils_value_file_info_free_value, synapse_utils_value_file_info_copy_value, synapse_utils_value_file_info_peek_pointer, "p", synapse_utils_value_file_info_collect_value, "p", synapse_utils_value_file_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsFileInfo), 0, (GInstanceInitFunc) synapse_utils_file_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_utils_file_info_type_id;
		synapse_utils_file_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsFileInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&synapse_utils_file_info_type_id__volatile, synapse_utils_file_info_type_id);
	}
	return synapse_utils_file_info_type_id__volatile;
}


gpointer synapse_utils_file_info_ref (gpointer instance) {
	SynapseUtilsFileInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void synapse_utils_file_info_unref (gpointer instance) {
	SynapseUtilsFileInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_UTILS_FILE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




