/* relevancy-backend-zg.c generated by valac 0.10.4, the Vala compiler
 * generated from relevancy-backend-zg.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <zeitgeist.h>
#include <gee.h>
#include <gio/gdesktopappinfo.h>


#define SYNAPSE_TYPE_RELEVANCY_BACKEND (synapse_relevancy_backend_get_type ())
#define SYNAPSE_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackend))
#define SYNAPSE_IS_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND))
#define SYNAPSE_RELEVANCY_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackendIface))

typedef struct _SynapseRelevancyBackend SynapseRelevancyBackend;
typedef struct _SynapseRelevancyBackendIface SynapseRelevancyBackendIface;

#define SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND (synapse_zeitgeist_relevancy_backend_get_type ())
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackend))
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendClass))
#define SYNAPSE_IS_ZEITGEIST_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND))
#define SYNAPSE_IS_ZEITGEIST_RELEVANCY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND))
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendClass))

typedef struct _SynapseZeitgeistRelevancyBackend SynapseZeitgeistRelevancyBackend;
typedef struct _SynapseZeitgeistRelevancyBackendClass SynapseZeitgeistRelevancyBackendClass;
typedef struct _SynapseZeitgeistRelevancyBackendPrivate SynapseZeitgeistRelevancyBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
typedef struct _SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData;
typedef struct _SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SynapseRelevancyBackendIface {
	GTypeInterface parent_iface;
	float (*get_application_popularity) (SynapseRelevancyBackend* self, const char* desktop_id);
	float (*get_uri_popularity) (SynapseRelevancyBackend* self, const char* uri);
	void (*application_launched) (SynapseRelevancyBackend* self, GAppInfo* app_info);
};

struct _SynapseZeitgeistRelevancyBackend {
	GObject parent_instance;
	SynapseZeitgeistRelevancyBackendPrivate * priv;
};

struct _SynapseZeitgeistRelevancyBackendClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistRelevancyBackendPrivate {
	ZeitgeistLog* zg_log;
	GeeMap* application_popularity;
	GeeMap* uri_popularity;
};

struct _SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	gint64 end;
	gint64 start;
	ZeitgeistTimeRange* tr;
	ZeitgeistEvent* event;
	ZeitgeistSubject* subject;
	GPtrArray* ptr_arr;
	ZeitgeistResultSet* rs;
	ZeitgeistResultSet* _tmp1_;
	GPtrArray* _tmp0_;
	ZeitgeistResultSet* _tmp2_;
	guint size;
	guint index;
	ZeitgeistResultSet* _e_it;
	ZeitgeistEvent* e;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistSubject* s;
	float power;
	float relevancy;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	gint64 end;
	gint64 start;
	ZeitgeistTimeRange* tr;
	ZeitgeistEvent* event;
	ZeitgeistSubject* subject;
	GPtrArray* ptr_arr;
	ZeitgeistResultSet* rs;
	GeeMap* popularity_map;
	guint size;
	guint index;
	float power;
	float relevancy;
	ZeitgeistResultSet* _tmp1_;
	GPtrArray* _tmp0_;
	ZeitgeistResultSet* _tmp2_;
	ZeitgeistResultSet* _e1_it;
	ZeitgeistEvent* e1;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistSubject* s1;
	GPtrArray* _tmp4_;
	ZeitgeistResultSet* _tmp6_;
	GPtrArray* _tmp5_;
	ZeitgeistResultSet* _tmp7_;
	ZeitgeistResultSet* _e2_it;
	ZeitgeistEvent* e2;
	ZeitgeistEvent* _tmp8_;
	ZeitgeistSubject* s2;
	GError * err;
	GeeMap* _tmp9_;
	GError * _inner_error_;
};


static gpointer synapse_zeitgeist_relevancy_backend_parent_class = NULL;
static SynapseRelevancyBackendIface* synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_parent_iface = NULL;

GType synapse_relevancy_backend_get_type (void) G_GNUC_CONST;
GType synapse_zeitgeist_relevancy_backend_get_type (void) G_GNUC_CONST;
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendPrivate))
enum  {
	SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_DUMMY_PROPERTY
};
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER 65535.0f
static gboolean synapse_zeitgeist_relevancy_backend_refresh_popularity (SynapseZeitgeistRelevancyBackend* self);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies (SynapseZeitgeistRelevancyBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_finish (SynapseZeitgeistRelevancyBackend* self, GAsyncResult* _res_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies (SynapseZeitgeistRelevancyBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_finish (SynapseZeitgeistRelevancyBackend* self, GAsyncResult* _res_);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free (gpointer _data);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* data);
static gboolean _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free (gpointer _data);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* data);
static gboolean _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func (gpointer self);
static float synapse_zeitgeist_relevancy_backend_real_get_application_popularity (SynapseRelevancyBackend* base, const char* desktop_id);
static float synapse_zeitgeist_relevancy_backend_real_get_uri_popularity (SynapseRelevancyBackend* base, const char* uri);
static void synapse_zeitgeist_relevancy_backend_reload_relevancies (SynapseZeitgeistRelevancyBackend* self);
static gboolean _lambda2_ (SynapseZeitgeistRelevancyBackend* self);
static gboolean __lambda2__gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_real_application_launched (SynapseRelevancyBackend* base, GAppInfo* app_info);
void synapse_utils_logger_debug (GObject* obj, const char* format, ...);
static void synapse_zeitgeist_relevancy_backend_push_app_launch (SynapseZeitgeistRelevancyBackend* self, const char* app_uri, const char* display_name);
SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_new (void);
SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_construct (GType object_type);
static gboolean _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func (gpointer self);
static GObject * synapse_zeitgeist_relevancy_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void synapse_zeitgeist_relevancy_backend_finalize (GObject* obj);



static gboolean synapse_zeitgeist_relevancy_backend_refresh_popularity (SynapseZeitgeistRelevancyBackend* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	synapse_zeitgeist_relevancy_backend_load_application_relevancies (self, NULL, NULL);
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies (self, NULL, NULL);
	result = TRUE;
	return result;
}


static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free (gpointer _data) {
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData, data);
}


static void synapse_zeitgeist_relevancy_backend_load_application_relevancies (SynapseZeitgeistRelevancyBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_relevancy_backend_load_application_relevancies);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free);
	_data_->self = g_object_ref (self);
	synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (_data_);
}


static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_finish (SynapseZeitgeistRelevancyBackend* self, GAsyncResult* _res_) {
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (data);
}


static gboolean _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 23:
		goto _state_23;
		case 24:
		goto _state_24;
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_LOW, _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func, data, NULL);
	data->_state_ = 23;
	return FALSE;
	_state_23:
	;
	data->end = zeitgeist_timestamp_for_now ();
	data->start = data->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
	data->tr = g_object_ref_sink (zeitgeist_time_range_new (data->start, data->end));
	data->event = g_object_ref_sink (zeitgeist_event_new ());
	zeitgeist_event_set_interpretation (data->event, "!" ZEITGEIST_ZG_LEAVE_EVENT);
	data->subject = g_object_ref_sink (zeitgeist_subject_new ());
	zeitgeist_subject_set_interpretation (data->subject, ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_subject_set_uri (data->subject, "application://*");
	zeitgeist_event_add_subject (data->event, data->subject);
	data->ptr_arr = g_ptr_array_new ();
	g_ptr_array_add (data->ptr_arr, data->event);
	{
		data->_state_ = 24;
		zeitgeist_log_find_events (data->self->priv->zg_log, data->tr, (data->_tmp0_ = data->ptr_arr, data->ptr_arr = NULL, data->_tmp0_), ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready, data);
		return FALSE;
		_state_24:
		data->_tmp1_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		data->rs = (data->_tmp2_ = data->_tmp1_, _g_object_unref0 (data->rs), data->_tmp2_);
		gee_map_clear (data->self->priv->application_popularity);
		data->size = zeitgeist_result_set_size (data->rs);
		data->index = (guint) 0;
		{
			data->_e_it = _vala_zeitgeist_result_set_iterator (data->rs);
			while (TRUE) {
				if (!((data->e = (data->_tmp3_ = _g_object_ref0 (_vala_zeitgeist_result_set_next_value (data->_e_it)), _g_object_unref0 (data->e), data->_tmp3_)) != NULL)) {
					break;
				}
				if (zeitgeist_event_num_subjects (data->e) <= 0) {
					continue;
				}
				data->s = _g_object_ref0 (zeitgeist_event_get_subject (data->e, 0));
				data->power = (data->index / (data->size * 2)) + 0.5f;
				data->relevancy = 1.0f / powf ((float) (data->index + 1), data->power);
				gee_map_set (data->self->priv->application_popularity, zeitgeist_subject_get_uri (data->s), GINT_TO_POINTER ((gint) (data->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
				data->index++;
				_g_object_unref0 (data->s);
			}
			_g_object_unref0 (data->e);
			_g_object_unref0 (data->_e_it);
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("relevancy-backend-zg.vala:98: %s", data->err->message);
			_g_error_free0 (data->err);
			_g_object_unref0 (data->rs);
			_g_ptr_array_free0 (data->ptr_arr);
			_g_object_unref0 (data->subject);
			_g_object_unref0 (data->event);
			_g_object_unref0 (data->tr);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->err);
		}
	}
	__finally26:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->rs);
		_g_ptr_array_free0 (data->ptr_arr);
		_g_object_unref0 (data->subject);
		_g_object_unref0 (data->event);
		_g_object_unref0 (data->tr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->rs);
	_g_ptr_array_free0 (data->ptr_arr);
	_g_object_unref0 (data->subject);
	_g_object_unref0 (data->event);
	_g_object_unref0 (data->tr);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free (gpointer _data) {
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData, data);
}


static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies (SynapseZeitgeistRelevancyBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_zeitgeist_relevancy_backend_load_uri_relevancies);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free);
	_data_->self = g_object_ref (self);
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (_data_);
}


static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_finish (SynapseZeitgeistRelevancyBackend* self, GAsyncResult* _res_) {
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (data);
}


static gboolean _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (self);
	return result;
}


static gboolean synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 25:
		goto _state_25;
		case 26:
		goto _state_26;
		case 27:
		goto _state_27;
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_LOW, _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func, data, NULL);
	data->_state_ = 25;
	return FALSE;
	_state_25:
	;
	data->end = zeitgeist_timestamp_for_now ();
	data->start = data->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
	data->tr = g_object_ref_sink (zeitgeist_time_range_new (data->start, data->end));
	data->event = g_object_ref_sink (zeitgeist_event_new ());
	zeitgeist_event_set_interpretation (data->event, "!" ZEITGEIST_ZG_LEAVE_EVENT);
	data->subject = g_object_ref_sink (zeitgeist_subject_new ());
	zeitgeist_subject_set_interpretation (data->subject, "!" ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_subject_set_uri (data->subject, "file://*");
	zeitgeist_event_add_subject (data->event, data->subject);
	data->ptr_arr = g_ptr_array_new ();
	g_ptr_array_add (data->ptr_arr, data->event);
	data->popularity_map = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	{
		data->_state_ = 26;
		zeitgeist_log_find_events (data->self->priv->zg_log, data->tr, (data->_tmp0_ = data->ptr_arr, data->ptr_arr = NULL, data->_tmp0_), ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready, data);
		return FALSE;
		_state_26:
		data->_tmp1_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
		data->rs = (data->_tmp2_ = data->_tmp1_, _g_object_unref0 (data->rs), data->_tmp2_);
		data->size = zeitgeist_result_set_size (data->rs);
		data->index = (guint) 0;
		{
			data->_e1_it = _vala_zeitgeist_result_set_iterator (data->rs);
			while (TRUE) {
				if (!((data->e1 = (data->_tmp3_ = _g_object_ref0 (_vala_zeitgeist_result_set_next_value (data->_e1_it)), _g_object_unref0 (data->e1), data->_tmp3_)) != NULL)) {
					break;
				}
				if (zeitgeist_event_num_subjects (data->e1) <= 0) {
					continue;
				}
				data->s1 = _g_object_ref0 (zeitgeist_event_get_subject (data->e1, 0));
				data->power = (data->index / (data->size * 2)) + 0.5f;
				data->relevancy = 1.0f / powf ((float) (data->index + 1), data->power);
				gee_map_set (data->popularity_map, zeitgeist_subject_get_uri (data->s1), GINT_TO_POINTER ((gint) (data->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
				data->index++;
				_g_object_unref0 (data->s1);
			}
			_g_object_unref0 (data->e1);
			_g_object_unref0 (data->_e1_it);
		}
		zeitgeist_subject_set_interpretation (data->subject, ZEITGEIST_NFO_WEBSITE);
		zeitgeist_subject_set_uri (data->subject, "");
		data->ptr_arr = (data->_tmp4_ = g_ptr_array_new (), _g_ptr_array_free0 (data->ptr_arr), data->_tmp4_);
		g_ptr_array_add (data->ptr_arr, data->event);
		data->_state_ = 27;
		zeitgeist_log_find_events (data->self->priv->zg_log, data->tr, (data->_tmp5_ = data->ptr_arr, data->ptr_arr = NULL, data->_tmp5_), ZEITGEIST_STORAGE_STATE_ANY, (guint32) 128, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready, data);
		return FALSE;
		_state_27:
		data->_tmp6_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
		data->rs = (data->_tmp7_ = data->_tmp6_, _g_object_unref0 (data->rs), data->_tmp7_);
		data->size = zeitgeist_result_set_size (data->rs);
		data->index = (guint) 0;
		{
			data->_e2_it = _vala_zeitgeist_result_set_iterator (data->rs);
			while (TRUE) {
				if (!((data->e2 = (data->_tmp8_ = _g_object_ref0 (_vala_zeitgeist_result_set_next_value (data->_e2_it)), _g_object_unref0 (data->e2), data->_tmp8_)) != NULL)) {
					break;
				}
				if (zeitgeist_event_num_subjects (data->e2) <= 0) {
					continue;
				}
				data->s2 = _g_object_ref0 (zeitgeist_event_get_subject (data->e2, 0));
				data->power = (data->index / (data->size * 2)) + 0.5f;
				data->relevancy = 1.0f / powf ((float) (data->index + 1), data->power);
				gee_map_set (data->popularity_map, zeitgeist_subject_get_uri (data->s2), GINT_TO_POINTER ((gint) (data->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
				data->index++;
				_g_object_unref0 (data->s2);
			}
			_g_object_unref0 (data->e2);
			_g_object_unref0 (data->_e2_it);
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("relevancy-backend-zg.vala:184: %s", data->err->message);
			_g_error_free0 (data->err);
		}
	}
	__finally27:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->popularity_map);
		_g_object_unref0 (data->rs);
		_g_ptr_array_free0 (data->ptr_arr);
		_g_object_unref0 (data->subject);
		_g_object_unref0 (data->event);
		_g_object_unref0 (data->tr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->self->priv->uri_popularity = (data->_tmp9_ = _g_object_ref0 (data->popularity_map), _g_object_unref0 (data->self->priv->uri_popularity), data->_tmp9_);
	_g_object_unref0 (data->popularity_map);
	_g_object_unref0 (data->rs);
	_g_ptr_array_free0 (data->ptr_arr);
	_g_object_unref0 (data->subject);
	_g_object_unref0 (data->event);
	_g_object_unref0 (data->tr);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static float synapse_zeitgeist_relevancy_backend_real_get_application_popularity (SynapseRelevancyBackend* base, const char* desktop_id) {
	SynapseZeitgeistRelevancyBackend * self;
	float result = 0.0F;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_val_if_fail (desktop_id != NULL, 0.0F);
	if (gee_map_contains (self->priv->application_popularity, desktop_id)) {
		result = GPOINTER_TO_INT (gee_map_get (self->priv->application_popularity, desktop_id)) / SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER;
		return result;
	}
	result = 0.0f;
	return result;
}


static float synapse_zeitgeist_relevancy_backend_real_get_uri_popularity (SynapseRelevancyBackend* base, const char* uri) {
	SynapseZeitgeistRelevancyBackend * self;
	float result = 0.0F;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_val_if_fail (uri != NULL, 0.0F);
	if (gee_map_contains (self->priv->uri_popularity, uri)) {
		result = GPOINTER_TO_INT (gee_map_get (self->priv->uri_popularity, uri)) / SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER;
		return result;
	}
	result = 0.0f;
	return result;
}


static gboolean _lambda2_ (SynapseZeitgeistRelevancyBackend* self) {
	gboolean result = FALSE;
	synapse_zeitgeist_relevancy_backend_load_application_relevancies (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static void synapse_zeitgeist_relevancy_backend_reload_relevancies (SynapseZeitgeistRelevancyBackend* self) {
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_LOW, __lambda2__gsource_func, g_object_ref (self), g_object_unref);
}


static void synapse_zeitgeist_relevancy_backend_real_application_launched (SynapseRelevancyBackend* base, GAppInfo* app_info) {
	SynapseZeitgeistRelevancyBackend * self;
	GType zg_gio_module;
	char* app_uri;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_if_fail (app_info != NULL);
	zg_gio_module = g_type_from_name ("GAppLaunchHandlerZeitgeist");
	if (zg_gio_module != 0) {
		synapse_utils_logger_debug ((GObject*) self, "relevancy-backend-zg.vala:228: libzg-gio-module detected, not pushing", NULL);
		synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
		return;
	}
	app_uri = NULL;
	if (g_app_info_get_id (app_info) != NULL) {
		char* _tmp0_;
		app_uri = (_tmp0_ = g_strconcat ("application://", g_app_info_get_id (app_info), NULL), _g_free0 (app_uri), _tmp0_);
	} else {
		if (G_IS_DESKTOP_APP_INFO (app_info)) {
			GAppInfo* _tmp1_;
			char* filename;
			char* _tmp2_;
			char* _tmp3_;
			filename = g_strdup (g_desktop_app_info_get_filename ((_tmp1_ = app_info, G_IS_DESKTOP_APP_INFO (_tmp1_) ? ((GDesktopAppInfo*) _tmp1_) : NULL)));
			if (filename == NULL) {
				_g_free0 (filename);
				_g_free0 (app_uri);
				return;
			}
			app_uri = (_tmp3_ = g_strconcat ("application://", _tmp2_ = g_path_get_basename (filename), NULL), _g_free0 (app_uri), _tmp3_);
			_g_free0 (_tmp2_);
			_g_free0 (filename);
		}
	}
	synapse_utils_logger_debug ((GObject*) self, "relevancy-backend-zg.vala:245: launched \"%s\", pushing to ZG", app_uri, NULL);
	synapse_zeitgeist_relevancy_backend_push_app_launch (self, app_uri, g_app_info_get_display_name (app_info));
	synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
	_g_free0 (app_uri);
}


static void synapse_zeitgeist_relevancy_backend_push_app_launch (SynapseZeitgeistRelevancyBackend* self, const char* app_uri, const char* display_name) {
	ZeitgeistEvent* event;
	ZeitgeistSubject* subject;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_uri != NULL);
	event = g_object_ref_sink (zeitgeist_event_new ());
	subject = g_object_ref_sink (zeitgeist_subject_new ());
	zeitgeist_event_set_actor (event, "application://synapse.desktop");
	zeitgeist_event_set_interpretation (event, ZEITGEIST_ZG_ACCESS_EVENT);
	zeitgeist_event_set_manifestation (event, ZEITGEIST_ZG_USER_ACTIVITY);
	zeitgeist_event_add_subject (event, subject);
	zeitgeist_subject_set_uri (subject, app_uri);
	zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_subject_set_manifestation (subject, ZEITGEIST_NFO_SOFTWARE_ITEM);
	zeitgeist_subject_set_mimetype (subject, "application/x-desktop");
	zeitgeist_subject_set_text (subject, display_name);
	zeitgeist_log_insert_events_no_reply (self->priv->zg_log, event, NULL, NULL);
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
}


SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_construct (GType object_type) {
	SynapseZeitgeistRelevancyBackend * self = NULL;
	self = (SynapseZeitgeistRelevancyBackend*) g_object_new (object_type, NULL);
	return self;
}


SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_new (void) {
	return synapse_zeitgeist_relevancy_backend_construct (SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND);
}


static gboolean _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_refresh_popularity (self);
	return result;
}


static GObject * synapse_zeitgeist_relevancy_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistRelevancyBackend * self;
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_relevancy_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND (obj);
	{
		ZeitgeistLog* _tmp0_;
		GeeMap* _tmp1_;
		GeeMap* _tmp2_;
		self->priv->zg_log = (_tmp0_ = zeitgeist_log_new (), _g_object_unref0 (self->priv->zg_log), _tmp0_);
		self->priv->application_popularity = (_tmp1_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->application_popularity), _tmp1_);
		self->priv->uri_popularity = (_tmp2_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->uri_popularity), _tmp2_);
		synapse_zeitgeist_relevancy_backend_refresh_popularity (self);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (60 * 30), _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func, g_object_ref (self), g_object_unref);
	}
	return obj;
}


static void synapse_zeitgeist_relevancy_backend_class_init (SynapseZeitgeistRelevancyBackendClass * klass) {
	synapse_zeitgeist_relevancy_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseZeitgeistRelevancyBackendPrivate));
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_relevancy_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_relevancy_backend_finalize;
}


static void synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_interface_init (SynapseRelevancyBackendIface * iface) {
	synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_application_popularity = synapse_zeitgeist_relevancy_backend_real_get_application_popularity;
	iface->get_uri_popularity = synapse_zeitgeist_relevancy_backend_real_get_uri_popularity;
	iface->application_launched = synapse_zeitgeist_relevancy_backend_real_application_launched;
}


static void synapse_zeitgeist_relevancy_backend_instance_init (SynapseZeitgeistRelevancyBackend * self) {
	self->priv = SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_GET_PRIVATE (self);
}


static void synapse_zeitgeist_relevancy_backend_finalize (GObject* obj) {
	SynapseZeitgeistRelevancyBackend * self;
	self = SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND (obj);
	_g_object_unref0 (self->priv->zg_log);
	_g_object_unref0 (self->priv->application_popularity);
	_g_object_unref0 (self->priv->uri_popularity);
	G_OBJECT_CLASS (synapse_zeitgeist_relevancy_backend_parent_class)->finalize (obj);
}


GType synapse_zeitgeist_relevancy_backend_get_type (void) {
	static volatile gsize synapse_zeitgeist_relevancy_backend_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_relevancy_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistRelevancyBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_relevancy_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistRelevancyBackend), 0, (GInstanceInitFunc) synapse_zeitgeist_relevancy_backend_instance_init, NULL };
		static const GInterfaceInfo synapse_relevancy_backend_info = { (GInterfaceInitFunc) synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_zeitgeist_relevancy_backend_type_id;
		synapse_zeitgeist_relevancy_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistRelevancyBackend", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_zeitgeist_relevancy_backend_type_id, SYNAPSE_TYPE_RELEVANCY_BACKEND, &synapse_relevancy_backend_info);
		g_once_init_leave (&synapse_zeitgeist_relevancy_backend_type_id__volatile, synapse_zeitgeist_relevancy_backend_type_id);
	}
	return synapse_zeitgeist_relevancy_backend_type_id__volatile;
}




