/* desktop-file-service.c generated by valac 0.10.4, the Vala compiler
 * generated from desktop-file-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>


#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;
typedef struct _SynapseDesktopFileInfoPrivate SynapseDesktopFileInfoPrivate;

#define SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE (synapse_desktop_file_info_environment_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;
typedef struct _SynapseDesktopFileServicePrivate SynapseDesktopFileServicePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceInitializeData SynapseDesktopFileServiceInitializeData;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceProcessDirectoryData SynapseDesktopFileServiceProcessDirectoryData;
typedef struct _SynapseDesktopFileServiceLoadAllDesktopFilesData SynapseDesktopFileServiceLoadAllDesktopFilesData;
typedef struct _SynapseDesktopFileServiceReloadDesktopFilesData SynapseDesktopFileServiceReloadDesktopFilesData;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadDesktopFileData SynapseDesktopFileServiceLoadDesktopFileData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData SynapseDesktopFileServiceLoadMimeParentsFromFileData;

typedef enum  {
	SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY
} SynapseDesktopFileError;
#define SYNAPSE_DESKTOP_FILE_ERROR synapse_desktop_file_error_quark ()
struct _SynapseDesktopFileInfo {
	GObject parent_instance;
	SynapseDesktopFileInfoPrivate * priv;
	char** mime_types;
	gint mime_types_length1;
};

struct _SynapseDesktopFileInfoClass {
	GObjectClass parent_class;
};

typedef enum  {
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME = 1 << 0,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE = 1 << 1,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE = 1 << 2,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX = 1 << 3,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE = 1 << 4,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD = 1 << 5,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL = 0x3F
} SynapseDesktopFileInfoEnvironmentType;

struct _SynapseDesktopFileInfoPrivate {
	char* _name;
	char* _comment;
	char* _icon_name;
	gboolean _needs_terminal;
	char* _filename;
	char* _exec;
	gboolean _is_hidden;
	gboolean _is_valid;
	char* name_folded;
	SynapseDesktopFileInfoEnvironmentType _show_in;
};

struct _SynapseDesktopFileService {
	GObject parent_instance;
	SynapseDesktopFileServicePrivate * priv;
};

struct _SynapseDesktopFileServiceClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileServicePrivate {
	gboolean _initialized;
	GeeList* directory_monitors;
	GeeList* all_desktop_files;
	GeeList* non_hidden_desktop_files;
	GeeMap* mimetype_map;
	GeeMap* exec_map;
	GeeMap* desktop_id_map;
	GeeMultiMap* mimetype_parent_map;
	SynapseDesktopFileInfoEnvironmentType session_type;
	char* session_type_str;
	guint timer_id;
};

struct _SynapseDesktopFileServiceInitializeData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
};

struct _SynapseDesktopFileServiceProcessDirectoryData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
	GFile* directory;
	GeeSet* monitored_dirs;
	char* path;
	gboolean _tmp0_;
	gboolean exists;
	GFileEnumerator* enumerator;
	GList* files;
	const char* name;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GList* f_collection;
	GList* f_it;
	GFileInfo* f;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceLoadAllDesktopFilesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
	char** data_dirs;
	char** _tmp0_;
	char** _tmp1_;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	char** _tmp2_;
	GeeSet* desktop_file_dirs;
	char* dir_path;
	GFile* directory;
	char* _tmp3_;
	char** data_dir_collection;
	int data_dir_collection_length1;
	int data_dir_it;
	const char* data_dir;
	GeeList* _tmp4_;
	GeeIterator* _d_it;
	GFile* d;
	GFileMonitor* monitor;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceReloadDesktopFilesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
};

struct _SynapseDesktopFileServiceLoadDesktopFileData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
	GFile* file;
	gsize len;
	char* contents;
	gboolean success;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	GKeyFile* keyfile;
	SynapseDesktopFileInfo* dfi;
	char* _tmp3_;
	SynapseDesktopFileInfo* _tmp4_;
	gboolean _tmp5_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
	char* fi;
	GFile* file;
	gboolean exists;
	GFileInputStream* fis;
	GDataInputStream* dis;
	char* line;
	char** mimes;
	gint mimes_length1;
	gint _mimes_size_;
	char** _tmp0_;
	gint len;
	char* _tmp1_;
	char* _tmp2_;
	char** _tmp3_;
	char** _tmp4_;
	GError * err;
	GError * _inner_error_;
};


static gpointer synapse_desktop_file_info_parent_class = NULL;
static SynapseDesktopFileService* synapse_desktop_file_service_instance;
static SynapseDesktopFileService* synapse_desktop_file_service_instance = NULL;
static gpointer synapse_desktop_file_service_parent_class = NULL;

GQuark synapse_desktop_file_error_quark (void);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
GType synapse_desktop_file_info_environment_type_get_type (void) G_GNUC_CONST;
#define SYNAPSE_DESKTOP_FILE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoPrivate))
enum  {
	SYNAPSE_DESKTOP_FILE_INFO_DUMMY_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NAME,
	SYNAPSE_DESKTOP_FILE_INFO_COMMENT,
	SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME,
	SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL,
	SYNAPSE_DESKTOP_FILE_INFO_FILENAME,
	SYNAPSE_DESKTOP_FILE_INFO_EXEC,
	SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN,
	SYNAPSE_DESKTOP_FILE_INFO_IS_VALID,
	SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN
};
#define SYNAPSE_DESKTOP_FILE_INFO_GROUP "Desktop Entry"
const char* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self);
const char* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const char* path, GKeyFile* keyfile);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type, const char* path, GKeyFile* keyfile);
static void synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self, GKeyFile* keyfile);
static SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self, char** environments, int environments_length1);
static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle);
void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self, const char* value);
void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self, const char* value);
static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self, gboolean value);
void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self, const char* value);
void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self, const char* value);
const char* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self, gboolean value);
void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self, SynapseDesktopFileInfoEnvironmentType value);
static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self, gboolean value);
SynapseDesktopFileInfo* synapse_desktop_file_info_new (void);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type);
const char* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self);
const char* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self, const char* value);
const char* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_info_finalize (GObject* obj);
static void synapse_desktop_file_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_desktop_file_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServicePrivate))
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_DUMMY_PROPERTY,
	SYNAPSE_DESKTOP_FILE_SERVICE_INITIALIZED
};
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
static SynapseDesktopFileService* synapse_desktop_file_service_new (void);
static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type);
static void synapse_desktop_file_service_initialize_data_free (gpointer _data);
static void synapse_desktop_file_service_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* data);
static void synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static void synapse_desktop_file_service_set_initialized (SynapseDesktopFileService* self, gboolean value);
static void synapse_desktop_file_service_process_directory_data_free (gpointer _data);
static void synapse_desktop_file_service_process_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self, GFile* directory, GeeSet* monitored_dirs, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* data);
void synapse_utils_query_exists_async (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static void synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static void _g_list_free_g_object_unref (GList* self);
static void synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* data);
static char** _vala_array_dup2 (char** self, int length);
static void _vala_array_add5 (char*** array, int* length, int* size, char* value);
static void synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self, const char* fi, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static void synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self);
static void _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static gboolean _lambda4_ (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static gboolean __lambda4__gsource_func (gpointer self);
static void synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* data);
static void synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data);
static void synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* data);
static void synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data);
static void synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* data);
static void synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self, const char* mime, GeeSet* ret);
GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self, const char* mime_type);
GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self, const char* exec);
SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self, const char* desktop_id);
gboolean synapse_desktop_file_service_get_initialized (SynapseDesktopFileService* self);
static GObject * synapse_desktop_file_service_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void synapse_desktop_file_service_finalize (GObject* obj);
static void synapse_desktop_file_service_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void synapse_desktop_file_service_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark synapse_desktop_file_error_quark (void) {
	return g_quark_from_static_string ("synapse_desktop_file_error-quark");
}


GType synapse_desktop_file_info_environment_type_get_type (void) {
	static volatile gsize synapse_desktop_file_info_environment_type_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_environment_type_type_id__volatile)) {
		static const GFlagsValue values[] = {{SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME", "gnome"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE", "kde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE", "lxde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX", "rox"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE", "xfce"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD", "old"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL", "all"}, {0, NULL, NULL}};
		GType synapse_desktop_file_info_environment_type_type_id;
		synapse_desktop_file_info_environment_type_type_id = g_flags_register_static ("SynapseDesktopFileInfoEnvironmentType", values);
		g_once_init_leave (&synapse_desktop_file_info_environment_type_type_id__volatile, synapse_desktop_file_info_environment_type_type_id);
	}
	return synapse_desktop_file_info_environment_type_type_id__volatile;
}


const char* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->name_folded == NULL) {
		char* _tmp0_;
		self->priv->name_folded = (_tmp0_ = g_utf8_casefold (self->priv->_name, -1), _g_free0 (self->priv->name_folded), _tmp0_);
	}
	result = self->priv->name_folded;
	return result;
}


SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type, const char* path, GKeyFile* keyfile) {
	SynapseDesktopFileInfo * self = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (keyfile != NULL, NULL);
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, "filename", path, NULL);
	synapse_desktop_file_info_init_from_keyfile (self, keyfile);
	return self;
}


SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const char* path, GKeyFile* keyfile) {
	return synapse_desktop_file_info_construct_for_keyfile (SYNAPSE_TYPE_DESKTOP_FILE_INFO, path, keyfile);
}


static SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self, char** environments, int environments_length1) {
	SynapseDesktopFileInfoEnvironmentType result = 0;
	SynapseDesktopFileInfoEnvironmentType _result_;
	g_return_val_if_fail (self != NULL, 0);
	_result_ = 0;
	{
		char** env_collection;
		int env_collection_length1;
		int env_it;
		env_collection = environments;
		env_collection_length1 = environments_length1;
		for (env_it = 0; env_it < environments_length1; env_it = env_it + 1) {
			const char* env;
			env = env_collection[env_it];
			{
				char* env_up;
				const char* _tmp0_;
				GQuark _tmp1_;
				static GQuark _tmp1__label0 = 0;
				static GQuark _tmp1__label1 = 0;
				static GQuark _tmp1__label2 = 0;
				static GQuark _tmp1__label3 = 0;
				static GQuark _tmp1__label4 = 0;
				static GQuark _tmp1__label5 = 0;
				env_up = g_utf8_strup (env, -1);
				_tmp0_ = env_up;
				_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
				if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("GNOME"))))
				switch (0) {
					default:
					{
						_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
						break;
					}
				} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("KDE"))))
				switch (0) {
					default:
					{
						_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
						break;
					}
				} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("LXDE"))))
				switch (0) {
					default:
					{
						_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
						break;
					}
				} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("XFCE"))))
				switch (0) {
					default:
					{
						_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
						break;
					}
				} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("ROX"))))
				switch (0) {
					default:
					{
						_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
						break;
					}
				} else if (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("OLD"))))
				switch (0) {
					default:
					{
						_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD;
						break;
					}
				} else
				switch (0) {
					default:
					{
						g_warning ("desktop-file-service.vala:91: %s is not understood", env);
						break;
					}
				}
				_g_free0 (env_up);
			}
		}
	}
	result = _result_;
	return result;
}


static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_vala_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self, GKeyFile* keyfile) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keyfile != NULL);
	{
		char* _tmp0_;
		char* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		char* _tmp6_;
		char* _tmp7_;
		char* _tmp8_;
		char* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_;
		gboolean _tmp16_;
		gboolean _tmp19_;
		gboolean _tmp26_;
		gboolean _tmp31_;
		gboolean _tmp33_;
		_tmp0_ = g_key_file_get_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Type", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if ((_tmp2_ = _vala_strcmp0 (_tmp1_ = _tmp0_, "Application") != 0, _g_free0 (_tmp1_), _tmp2_)) {
			_inner_error_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Not Application-type desktop entry");
			{
				goto __catch9_g_error;
			}
		}
		_tmp3_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Categories", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (_tmp3_) {
			gint categories_length1;
			gint _categories_size_;
			char** _tmp5_;
			gsize _tmp4_;
			char** categories;
			categories = (_tmp5_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Categories", &_tmp4_, &_inner_error_), categories_length1 = _tmp4_, _categories_size_ = categories_length1, _tmp5_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			if (_vala_string_array_contains (categories, categories_length1, "Screensaver")) {
				_inner_error_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Screensaver desktop entry");
				{
					categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
					goto __catch9_g_error;
				}
			}
			categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp6_ = g_key_file_get_locale_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Name", NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		synapse_desktop_file_info_set_name (self, _tmp7_ = _tmp6_);
		_g_free0 (_tmp7_);
		_tmp8_ = g_key_file_get_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Exec", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		synapse_desktop_file_info_set_exec (self, _tmp9_ = _tmp8_);
		_g_free0 (_tmp9_);
		_tmp11_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Hidden", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (_tmp11_) {
			gboolean _tmp12_;
			_tmp12_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Hidden", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			_tmp10_ = _tmp12_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
		}
		_tmp14_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NoDisplay", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (_tmp14_) {
			gboolean _tmp15_;
			_tmp15_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NoDisplay", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			_tmp13_ = _tmp15_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
		}
		_tmp16_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Comment", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (_tmp16_) {
			char* _tmp17_;
			char* _tmp18_;
			_tmp17_ = g_key_file_get_locale_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Comment", NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			synapse_desktop_file_info_set_comment (self, _tmp18_ = _tmp17_);
			_g_free0 (_tmp18_);
		}
		_tmp19_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Icon", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (_tmp19_) {
			char* _tmp20_;
			char* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp20_ = g_key_file_get_locale_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Icon", NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			synapse_desktop_file_info_set_icon_name (self, _tmp21_ = _tmp20_);
			_g_free0 (_tmp21_);
			if (!g_path_is_absolute (self->priv->_icon_name)) {
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				if (g_str_has_suffix (self->priv->_icon_name, ".png")) {
					_tmp24_ = TRUE;
				} else {
					_tmp24_ = g_str_has_suffix (self->priv->_icon_name, ".svg");
				}
				if (_tmp24_) {
					_tmp23_ = TRUE;
				} else {
					_tmp23_ = g_str_has_suffix (self->priv->_icon_name, ".xpm");
				}
				_tmp22_ = _tmp23_;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				char* _tmp25_;
				synapse_desktop_file_info_set_icon_name (self, _tmp25_ = g_strndup (self->priv->_icon_name, strlen (self->priv->_icon_name) - 4));
				_g_free0 (_tmp25_);
			}
		}
		_tmp26_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "MimeType", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (_tmp26_) {
			gint _tmp28__length1;
			gint __tmp28__size_;
			char** _tmp29_;
			gsize _tmp27_;
			char** _tmp28_;
			char** _tmp30_;
			_tmp28_ = (_tmp29_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "MimeType", &_tmp27_, &_inner_error_), _tmp28__length1 = _tmp27_, __tmp28__size_ = _tmp28__length1, _tmp29_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			self->mime_types = (_tmp30_ = _tmp28_, self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL), self->mime_types_length1 = _tmp28__length1, _tmp30_);
		}
		_tmp31_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Terminal", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (_tmp31_) {
			gboolean _tmp32_;
			_tmp32_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Terminal", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			synapse_desktop_file_info_set_needs_terminal (self, _tmp32_);
		}
		_tmp33_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "OnlyShowIn", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (_tmp33_) {
			gint _tmp35__length1;
			gint __tmp35__size_;
			char** _tmp36_;
			gsize _tmp34_;
			char** _tmp35_;
			char** _tmp37_;
			gint _tmp37__length1;
			_tmp35_ = (_tmp36_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "OnlyShowIn", &_tmp34_, &_inner_error_), _tmp35__length1 = _tmp34_, __tmp35__size_ = _tmp35__length1, _tmp36_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			synapse_desktop_file_info_set_show_in (self, synapse_desktop_file_info_parse_environments (self, (_tmp37_ = _tmp35_, _tmp37__length1 = _tmp35__length1, _tmp37_), _tmp35__length1));
			_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
		} else {
			gboolean _tmp38_;
			_tmp38_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NotShowIn", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			if (_tmp38_) {
				gint _tmp40__length1;
				gint __tmp40__size_;
				char** _tmp41_;
				gsize _tmp39_;
				char** _tmp40_;
				char** _tmp42_;
				gint _tmp42__length1;
				SynapseDesktopFileInfoEnvironmentType _tmp43_;
				SynapseDesktopFileInfoEnvironmentType not_show;
				_tmp40_ = (_tmp41_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NotShowIn", &_tmp39_, &_inner_error_), _tmp40__length1 = _tmp39_, __tmp40__size_ = _tmp40__length1, _tmp41_);
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
				not_show = (_tmp43_ = synapse_desktop_file_info_parse_environments (self, (_tmp42_ = _tmp40_, _tmp42__length1 = _tmp40__length1, _tmp42_), _tmp40__length1), _tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL), _tmp43_);
				synapse_desktop_file_info_set_show_in (self, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL ^ not_show);
			}
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			synapse_desktop_file_info_set_is_valid (self, FALSE);
			_g_error_free0 (err);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type) {
	SynapseDesktopFileInfo * self = NULL;
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, NULL);
	return self;
}


SynapseDesktopFileInfo* synapse_desktop_file_info_new (void) {
	return synapse_desktop_file_info_construct (SYNAPSE_TYPE_DESKTOP_FILE_INFO);
}


const char* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


const char* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_comment;
	return result;
}


void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_comment = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_comment), _tmp0_);
	g_object_notify ((GObject *) self, "comment");
}


const char* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon_name;
	return result;
}


void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_needs_terminal;
	return result;
}


void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_needs_terminal = value;
	g_object_notify ((GObject *) self, "needs-terminal");
}


const char* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
	return result;
}


void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_filename), _tmp0_);
	g_object_notify ((GObject *) self, "filename");
}


const char* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_exec;
	return result;
}


void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_exec = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_exec), _tmp0_);
	g_object_notify ((GObject *) self, "exec");
}


gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_hidden;
	return result;
}


static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_hidden = value;
	g_object_notify ((GObject *) self, "is-hidden");
}


gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_valid;
	return result;
}


static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_valid = value;
	g_object_notify ((GObject *) self, "is-valid");
}


SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self) {
	SynapseDesktopFileInfoEnvironmentType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_show_in;
	return result;
}


void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self, SynapseDesktopFileInfoEnvironmentType value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_in = value;
	g_object_notify ((GObject *) self, "show-in");
}


static void synapse_desktop_file_info_class_init (SynapseDesktopFileInfoClass * klass) {
	synapse_desktop_file_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDesktopFileInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_desktop_file_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_desktop_file_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_COMMENT, g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL, g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_EXEC, g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN, g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_VALID, g_param_spec_boolean ("is-valid", "is-valid", "is-valid", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN, g_param_spec_flags ("show-in", "show-in", "show-in", SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_desktop_file_info_instance_init (SynapseDesktopFileInfo * self) {
	self->priv = SYNAPSE_DESKTOP_FILE_INFO_GET_PRIVATE (self);
	self->priv->_comment = g_strdup ("");
	self->priv->_icon_name = g_strdup ("");
	self->priv->_needs_terminal = FALSE;
	self->priv->_is_hidden = FALSE;
	self->priv->_is_valid = TRUE;
	self->mime_types = NULL;
	self->priv->name_folded = NULL;
	self->priv->_show_in = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL;
}


static void synapse_desktop_file_info_finalize (GObject* obj) {
	SynapseDesktopFileInfo * self;
	self = SYNAPSE_DESKTOP_FILE_INFO (obj);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_comment);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_exec);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->name_folded);
	G_OBJECT_CLASS (synapse_desktop_file_info_parent_class)->finalize (obj);
}


GType synapse_desktop_file_info_get_type (void) {
	static volatile gsize synapse_desktop_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileInfo), 0, (GInstanceInitFunc) synapse_desktop_file_info_instance_init, NULL };
		GType synapse_desktop_file_info_type_id;
		synapse_desktop_file_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileInfo", &g_define_type_info, 0);
		g_once_init_leave (&synapse_desktop_file_info_type_id__volatile, synapse_desktop_file_info_type_id);
	}
	return synapse_desktop_file_info_type_id__volatile;
}


static void synapse_desktop_file_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDesktopFileInfo * self;
	self = SYNAPSE_DESKTOP_FILE_INFO (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_INFO_NAME:
		g_value_set_string (value, synapse_desktop_file_info_get_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT:
		g_value_set_string (value, synapse_desktop_file_info_get_comment (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME:
		g_value_set_string (value, synapse_desktop_file_info_get_icon_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL:
		g_value_set_boolean (value, synapse_desktop_file_info_get_needs_terminal (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME:
		g_value_set_string (value, synapse_desktop_file_info_get_filename (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC:
		g_value_set_string (value, synapse_desktop_file_info_get_exec (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN:
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_hidden (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID:
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_valid (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN:
		g_value_set_flags (value, synapse_desktop_file_info_get_show_in (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_desktop_file_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDesktopFileInfo * self;
	self = SYNAPSE_DESKTOP_FILE_INFO (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_INFO_NAME:
		synapse_desktop_file_info_set_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT:
		synapse_desktop_file_info_set_comment (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME:
		synapse_desktop_file_info_set_icon_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL:
		synapse_desktop_file_info_set_needs_terminal (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME:
		synapse_desktop_file_info_set_filename (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC:
		synapse_desktop_file_info_set_exec (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN:
		synapse_desktop_file_info_set_is_hidden (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID:
		synapse_desktop_file_info_set_is_valid (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN:
		synapse_desktop_file_info_set_show_in (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SynapseDesktopFileService* synapse_desktop_file_service_get_default (void) {
	SynapseDesktopFileService* result = NULL;
	SynapseDesktopFileService* _tmp0_;
	_tmp0_ = _g_object_ref0 (synapse_desktop_file_service_instance);
	if (_tmp0_ == NULL) {
		SynapseDesktopFileService* _tmp1_;
		_tmp0_ = (_tmp1_ = synapse_desktop_file_service_new (), _g_object_unref0 (_tmp0_), _tmp1_);
	}
	result = _tmp0_;
	return result;
}


static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type) {
	SynapseDesktopFileService * self = NULL;
	self = (SynapseDesktopFileService*) g_object_new (object_type, NULL);
	return self;
}


static SynapseDesktopFileService* synapse_desktop_file_service_new (void) {
	return synapse_desktop_file_service_construct (SYNAPSE_TYPE_DESKTOP_FILE_SERVICE);
}


static void synapse_desktop_file_service_initialize_data_free (gpointer _data) {
	SynapseDesktopFileServiceInitializeData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseDesktopFileServiceInitializeData, data);
}


static void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceInitializeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_initialize);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_initialize_data_free);
	_data_->self = g_object_ref (self);
	synapse_desktop_file_service_initialize_co (_data_);
}


static void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceInitializeData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_desktop_file_service_initialize_co (data);
}


static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 7:
		goto _state_7;
	}
	_state_0:
	synapse_desktop_file_service_get_environment_type (data->self);
	g_desktop_app_info_set_desktop_env (data->self->priv->session_type_str);
	data->_state_ = 7;
	synapse_desktop_file_service_load_all_desktop_files (data->self, synapse_desktop_file_service_initialize_ready, data);
	return FALSE;
	_state_7:
	synapse_desktop_file_service_load_all_desktop_files_finish (data->self, data->_res_);
	synapse_desktop_file_service_set_initialized (data->self, TRUE);
	g_signal_emit_by_name (data->self, "initialization-done");
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self) {
	const char* session_var;
	char* session;
	g_return_if_fail (self != NULL);
	session_var = g_getenv ("DESKTOP_SESSION");
	if (session_var == NULL) {
		return;
	}
	session = g_utf8_strdown (session_var, -1);
	if (g_str_has_prefix (session, "kde")) {
		char* _tmp0_;
		self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
		self->priv->session_type_str = (_tmp0_ = g_strdup ("KDE"), _g_free0 (self->priv->session_type_str), _tmp0_);
	} else {
		if (g_str_has_prefix (session, "gnome")) {
			char* _tmp1_;
			self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
			self->priv->session_type_str = (_tmp1_ = g_strdup ("GNOME"), _g_free0 (self->priv->session_type_str), _tmp1_);
		} else {
			if (g_str_has_prefix (session, "lx")) {
				char* _tmp2_;
				self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
				self->priv->session_type_str = (_tmp2_ = g_strdup ("XFCE"), _g_free0 (self->priv->session_type_str), _tmp2_);
			} else {
				if (g_str_has_prefix (session, "xfce")) {
					char* _tmp3_;
					self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
					self->priv->session_type_str = (_tmp3_ = g_strdup ("XFCE"), _g_free0 (self->priv->session_type_str), _tmp3_);
				} else {
					if (g_str_has_prefix (session, "rox")) {
						char* _tmp4_;
						self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
						self->priv->session_type_str = (_tmp4_ = g_strdup ("ROX"), _g_free0 (self->priv->session_type_str), _tmp4_);
					} else {
						g_warning ("desktop-file-service.vala:262: Desktop session type is not recognized," \
" assuming GNOME.");
					}
				}
			}
		}
	}
	_g_free0 (session);
}


static void synapse_desktop_file_service_process_directory_data_free (gpointer _data) {
	SynapseDesktopFileServiceProcessDirectoryData* data;
	data = _data;
	_g_object_unref0 (data->directory);
	_g_object_unref0 (data->monitored_dirs);
	g_object_unref (data->self);
	g_slice_free (SynapseDesktopFileServiceProcessDirectoryData, data);
}


static void synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self, GFile* directory, GeeSet* monitored_dirs, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceProcessDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_process_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_process_directory_data_free);
	_data_->self = g_object_ref (self);
	_data_->directory = _g_object_ref0 (directory);
	_data_->monitored_dirs = _g_object_ref0 (monitored_dirs);
	synapse_desktop_file_service_process_directory_co (_data_);
}


static void synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_process_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceProcessDirectoryData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_desktop_file_service_process_directory_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
	}
	_state_0:
	{
		data->path = g_file_get_path (data->directory);
		if (data->path != NULL) {
			data->_tmp0_ = g_str_has_suffix (data->path, "menu-xdg");
		} else {
			data->_tmp0_ = FALSE;
		}
		if (data->_tmp0_) {
			_g_free0 (data->path);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->_state_ = 8;
		synapse_utils_query_exists_async (data->directory, synapse_desktop_file_service_process_directory_ready, data);
		return FALSE;
		_state_8:
		data->exists = synapse_utils_query_exists_finish (data->_res_);
		if (!data->exists) {
			_g_free0 (data->path);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		gee_collection_add ((GeeCollection*) data->monitored_dirs, data->directory);
		data->_state_ = 9;
		g_file_enumerate_children_async (data->directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_desktop_file_service_process_directory_ready, data);
		return FALSE;
		_state_9:
		data->enumerator = g_file_enumerate_children_finish (data->directory, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->path);
			goto __catch10_g_error;
		}
		data->_state_ = 10;
		g_file_enumerator_next_files_async (data->enumerator, 1024, 0, NULL, synapse_desktop_file_service_process_directory_ready, data);
		return FALSE;
		_state_10:
		data->files = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->enumerator);
			_g_free0 (data->path);
			goto __catch10_g_error;
		}
		{
			data->f_collection = data->files;
			for (data->f_it = data->f_collection; data->f_it != NULL; data->f_it = data->f_it->next) {
				data->f = _g_object_ref0 ((GFileInfo*) data->f_it->data);
				{
					data->name = g_file_info_get_name (data->f);
					if (g_file_info_get_file_type (data->f) == G_FILE_TYPE_DIRECTORY) {
						data->_state_ = 11;
						synapse_desktop_file_service_process_directory (data->self, data->_tmp1_ = g_file_get_child (data->directory, data->name), data->monitored_dirs, synapse_desktop_file_service_process_directory_ready, data);
						return FALSE;
						_state_11:
						synapse_desktop_file_service_process_directory_finish (data->self, data->_res_);
						_g_object_unref0 (data->_tmp1_);
					} else {
						if (g_str_has_suffix (data->name, "synapse.desktop")) {
							_g_object_unref0 (data->f);
							continue;
						}
						if (g_str_has_suffix (data->name, ".desktop")) {
							data->_state_ = 12;
							synapse_desktop_file_service_load_desktop_file (data->self, data->_tmp2_ = g_file_get_child (data->directory, data->name), synapse_desktop_file_service_process_directory_ready, data);
							return FALSE;
							_state_12:
							synapse_desktop_file_service_load_desktop_file_finish (data->self, data->_res_);
							_g_object_unref0 (data->_tmp2_);
						}
					}
					_g_object_unref0 (data->f);
				}
			}
		}
		__g_list_free_g_object_unref0 (data->files);
		_g_object_unref0 (data->enumerator);
		_g_free0 (data->path);
	}
	goto __finally10;
	__catch10_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("desktop-file-service.vala:301: %s", data->err->message);
			_g_error_free0 (data->err);
		}
	}
	__finally10:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data) {
	SynapseDesktopFileServiceLoadAllDesktopFilesData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseDesktopFileServiceLoadAllDesktopFilesData, data);
}


static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadAllDesktopFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_load_all_desktop_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_load_all_desktop_files_data_free);
	_data_->self = g_object_ref (self);
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
}


static void synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadAllDesktopFilesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_desktop_file_service_load_all_desktop_files_co (data);
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _vala_array_add5 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	synapse_desktop_file_service_desktop_file_directory_changed (self);
}


static gboolean synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 13:
		goto _state_13;
		case 14:
		goto _state_14;
	}
	_state_0:
	data->data_dirs = (data->_tmp2_ = (data->_tmp1_ = data->_tmp0_ = g_get_system_data_dirs (), (data->_tmp1_ == NULL) ? ((gpointer) data->_tmp1_) : _vala_array_dup2 (data->_tmp1_, _vala_array_length (data->_tmp0_))), data->data_dirs_length1 = _vala_array_length (data->_tmp0_), data->_data_dirs_size_ = data->data_dirs_length1, data->_tmp2_);
	_vala_array_add5 (&data->data_dirs, &data->data_dirs_length1, &data->_data_dirs_size_, g_strdup (g_get_user_data_dir ()));
	data->desktop_file_dirs = (GeeSet*) gee_hash_set_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	gee_multi_map_clear (data->self->priv->mimetype_parent_map);
	{
		data->data_dir_collection = data->data_dirs;
		data->data_dir_collection_length1 = data->data_dirs_length1;
		for (data->data_dir_it = 0; data->data_dir_it < data->data_dirs_length1; data->data_dir_it = data->data_dir_it + 1) {
			data->data_dir = data->data_dir_collection[data->data_dir_it];
			{
				data->dir_path = g_build_filename (data->data_dir, "applications", NULL, NULL);
				data->directory = g_file_new_for_path (data->dir_path);
				data->_state_ = 13;
				synapse_desktop_file_service_process_directory (data->self, data->directory, data->desktop_file_dirs, synapse_desktop_file_service_load_all_desktop_files_ready, data);
				return FALSE;
				_state_13:
				synapse_desktop_file_service_process_directory_finish (data->self, data->_res_);
				data->dir_path = (data->_tmp3_ = g_build_filename (data->data_dir, "mime", "subclasses", NULL), _g_free0 (data->dir_path), data->_tmp3_);
				data->_state_ = 14;
				synapse_desktop_file_service_load_mime_parents_from_file (data->self, data->dir_path, synapse_desktop_file_service_load_all_desktop_files_ready, data);
				return FALSE;
				_state_14:
				synapse_desktop_file_service_load_mime_parents_from_file_finish (data->self, data->_res_);
				_g_object_unref0 (data->directory);
				_g_free0 (data->dir_path);
			}
		}
	}
	synapse_desktop_file_service_create_indices (data->self);
	data->self->priv->directory_monitors = (data->_tmp4_ = (GeeList*) gee_array_list_new (G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (data->self->priv->directory_monitors), data->_tmp4_);
	{
		data->_d_it = gee_iterable_iterator ((GeeIterable*) data->desktop_file_dirs);
		while (TRUE) {
			if (!gee_iterator_next (data->_d_it)) {
				break;
			}
			data->d = (GFile*) gee_iterator_get (data->_d_it);
			data->monitor = g_file_monitor_directory (data->d, 0, NULL, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->d);
				_g_object_unref0 (data->_d_it);
				_g_object_unref0 (data->desktop_file_dirs);
				data->data_dirs = (_vala_array_free (data->data_dirs, data->data_dirs_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			g_signal_connect_object (data->monitor, "changed", (GCallback) _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed, data->self, 0);
			gee_collection_add ((GeeCollection*) data->self->priv->directory_monitors, data->monitor);
			_g_object_unref0 (data->monitor);
			_g_object_unref0 (data->d);
		}
		_g_object_unref0 (data->_d_it);
	}
	_g_object_unref0 (data->desktop_file_dirs);
	data->data_dirs = (_vala_array_free (data->data_dirs, data->data_dirs_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gboolean _lambda4_ (SynapseDesktopFileService* self) {
	gboolean result = FALSE;
	self->priv->timer_id = (guint) 0;
	synapse_desktop_file_service_reload_desktop_files (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda4_ (self);
	return result;
}


static void synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "reload-started");
	if (self->priv->timer_id != 0) {
		g_source_remove (self->priv->timer_id);
	}
	self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, __lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


static void synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data) {
	SynapseDesktopFileServiceReloadDesktopFilesData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (SynapseDesktopFileServiceReloadDesktopFilesData, data);
}


static void synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceReloadDesktopFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_reload_desktop_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_reload_desktop_files_data_free);
	_data_->self = g_object_ref (self);
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
}


static void synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceReloadDesktopFilesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_desktop_file_service_reload_desktop_files_co (data);
}


static gboolean synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 15:
		goto _state_15;
	}
	_state_0:
	g_debug ("desktop-file-service.vala:357: Reloading desktop files...");
	gee_collection_clear ((GeeCollection*) data->self->priv->all_desktop_files);
	gee_collection_clear ((GeeCollection*) data->self->priv->non_hidden_desktop_files);
	data->_state_ = 15;
	synapse_desktop_file_service_load_all_desktop_files (data->self, synapse_desktop_file_service_reload_desktop_files_ready, data);
	return FALSE;
	_state_15:
	synapse_desktop_file_service_load_all_desktop_files_finish (data->self, data->_res_);
	g_signal_emit_by_name (data->self, "reload-done");
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data) {
	SynapseDesktopFileServiceLoadDesktopFileData* data;
	data = _data;
	_g_object_unref0 (data->file);
	g_object_unref (data->self);
	g_slice_free (SynapseDesktopFileServiceLoadDesktopFileData, data);
}


static void synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadDesktopFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_load_desktop_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_load_desktop_file_data_free);
	_data_->self = g_object_ref (self);
	_data_->file = _g_object_ref0 (file);
	synapse_desktop_file_service_load_desktop_file_co (_data_);
}


static void synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadDesktopFileData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_desktop_file_service_load_desktop_file_co (data);
}


static gboolean synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 16:
		goto _state_16;
	}
	_state_0:
	{
		data->_tmp0_ = NULL;
		data->_state_ = 16;
		g_file_load_contents_async (data->file, NULL, synapse_desktop_file_service_load_desktop_file_ready, data);
		return FALSE;
		_state_16:
		data->success = (data->_tmp1_ = g_file_load_contents_finish (data->file, data->_res_, &data->_tmp0_, &data->len, NULL, &data->_inner_error_), data->contents = (data->_tmp2_ = data->_tmp0_, _g_free0 (data->contents), data->_tmp2_), data->_tmp1_);
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->contents);
			goto __catch11_g_error;
		}
		if (data->success) {
			data->keyfile = g_key_file_new ();
			g_key_file_load_from_data (data->keyfile, data->contents, data->len, 0, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_key_file_free0 (data->keyfile);
				_g_free0 (data->contents);
				goto __catch11_g_error;
			}
			data->dfi = (data->_tmp4_ = synapse_desktop_file_info_new_for_keyfile (data->_tmp3_ = g_file_get_path (data->file), data->keyfile), _g_free0 (data->_tmp3_), data->_tmp4_);
			if (synapse_desktop_file_info_get_is_valid (data->dfi)) {
				gee_collection_add ((GeeCollection*) data->self->priv->all_desktop_files, data->dfi);
				if (!synapse_desktop_file_info_get_is_hidden (data->dfi)) {
					data->_tmp5_ = (synapse_desktop_file_info_get_show_in (data->dfi) & data->self->priv->session_type) == data->self->priv->session_type;
				} else {
					data->_tmp5_ = FALSE;
				}
				if (data->_tmp5_) {
					gee_collection_add ((GeeCollection*) data->self->priv->non_hidden_desktop_files, data->dfi);
				}
			}
			_g_object_unref0 (data->dfi);
			_g_key_file_free0 (data->keyfile);
		}
		_g_free0 (data->contents);
	}
	goto __finally11;
	__catch11_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("desktop-file-service.vala:390: %s", data->err->message);
			_g_error_free0 (data->err);
		}
	}
	__finally11:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self) {
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GRegex* exec_re;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->mimetype_map = (_tmp0_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, NULL, NULL, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->mimetype_map), _tmp0_);
	self->priv->exec_map = (_tmp1_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->exec_map), _tmp1_);
	self->priv->desktop_id_map = (_tmp2_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->desktop_id_map), _tmp2_);
	exec_re = NULL;
	{
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		_tmp3_ = g_regex_new ("%[fFuU]", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		exec_re = (_tmp4_ = _tmp3_, _g_regex_unref0 (exec_re), _tmp4_);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("desktop-file-service.vala:413: %s", err->message);
			_g_error_free0 (err);
			_g_regex_unref0 (exec_re);
			return;
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (exec_re);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GeeIterator* _dfi_it;
		_dfi_it = gee_iterable_iterator ((GeeIterable*) self->priv->all_desktop_files);
		while (TRUE) {
			SynapseDesktopFileInfo* dfi;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* exec;
			GeeList* exec_list;
			char* _tmp9_;
			gboolean _tmp10_ = FALSE;
			if (!gee_iterator_next (_dfi_it)) {
				break;
			}
			dfi = (SynapseDesktopFileInfo*) gee_iterator_get (_dfi_it);
			_tmp5_ = g_regex_replace_literal (exec_re, synapse_desktop_file_info_get_exec (dfi), (gssize) (-1), 0, "", 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dfi);
				_g_object_unref0 (_dfi_it);
				_g_regex_unref0 (exec_re);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			exec = (_tmp7_ = string_strip (_tmp6_ = _tmp5_), _g_free0 (_tmp6_), _tmp7_);
			exec_list = (GeeList*) gee_map_get (self->priv->exec_map, exec);
			if (exec_list == NULL) {
				GeeList* _tmp8_;
				exec_list = (_tmp8_ = (GeeList*) gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (exec_list), _tmp8_);
				gee_map_set (self->priv->exec_map, exec, exec_list);
			}
			gee_collection_add ((GeeCollection*) exec_list, dfi);
			gee_map_set (self->priv->desktop_id_map, _tmp9_ = g_path_get_basename (synapse_desktop_file_info_get_filename (dfi)), dfi);
			_g_free0 (_tmp9_);
			if (synapse_desktop_file_info_get_is_hidden (dfi)) {
				_tmp10_ = TRUE;
			} else {
				_tmp10_ = dfi->mime_types == NULL;
			}
			if (_tmp10_) {
				_g_object_unref0 (exec_list);
				_g_free0 (exec);
				_g_object_unref0 (dfi);
				continue;
			}
			{
				char** mime_type_collection;
				int mime_type_collection_length1;
				int mime_type_it;
				mime_type_collection = dfi->mime_types;
				mime_type_collection_length1 = dfi->mime_types_length1;
				for (mime_type_it = 0; mime_type_it < dfi->mime_types_length1; mime_type_it = mime_type_it + 1) {
					const char* mime_type;
					mime_type = mime_type_collection[mime_type_it];
					{
						GeeList* list;
						list = (GeeList*) gee_map_get (self->priv->mimetype_map, mime_type);
						if (list == NULL) {
							GeeList* _tmp11_;
							list = (_tmp11_ = (GeeList*) gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (list), _tmp11_);
							gee_map_set (self->priv->mimetype_map, mime_type, list);
						}
						gee_collection_add ((GeeCollection*) list, dfi);
						_g_object_unref0 (list);
					}
				}
			}
			_g_object_unref0 (exec_list);
			_g_free0 (exec);
			_g_object_unref0 (dfi);
		}
		_g_object_unref0 (_dfi_it);
	}
	_g_regex_unref0 (exec_re);
}


static void synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data) {
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* data;
	data = _data;
	_g_free0 (data->fi);
	g_object_unref (data->self);
	g_slice_free (SynapseDesktopFileServiceLoadMimeParentsFromFileData, data);
}


static void synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self, const char* fi, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadMimeParentsFromFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_load_mime_parents_from_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_load_mime_parents_from_file_data_free);
	_data_->self = g_object_ref (self);
	_data_->fi = g_strdup (fi);
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
}


static void synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* data;
	data = _user_data_;
	data->_res_ = _res_;
	synapse_desktop_file_service_load_mime_parents_from_file_co (data);
}


static gboolean synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 17:
		goto _state_17;
		case 18:
		goto _state_18;
		case 19:
		goto _state_19;
	}
	_state_0:
	data->file = g_file_new_for_path (data->fi);
	data->_state_ = 17;
	synapse_utils_query_exists_async (data->file, synapse_desktop_file_service_load_mime_parents_from_file_ready, data);
	return FALSE;
	_state_17:
	data->exists = synapse_utils_query_exists_finish (data->_res_);
	if (!data->exists) {
		_g_object_unref0 (data->file);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		data->_state_ = 18;
		g_file_read_async (data->file, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, data);
		return FALSE;
		_state_18:
		data->fis = g_file_read_finish (data->file, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		data->dis = g_data_input_stream_new ((GInputStream*) data->fis);
		data->line = NULL;
		data->mimes = (data->_tmp0_ = NULL, data->mimes_length1 = 0, data->_mimes_size_ = data->mimes_length1, data->_tmp0_);
		data->len = 0;
		while (TRUE) {
			data->_state_ = 19;
			g_data_input_stream_read_line_async (data->dis, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, data);
			return FALSE;
			_state_19:
			data->_tmp1_ = g_data_input_stream_read_line_finish (data->dis, data->_res_, NULL, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				data->mimes = (_vala_array_free (data->mimes, data->mimes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->line);
				_g_object_unref0 (data->dis);
				_g_object_unref0 (data->fis);
				goto __catch13_g_error;
			}
			data->line = (data->_tmp2_ = data->_tmp1_, _g_free0 (data->line), data->_tmp2_);
			if (data->line == NULL) {
				break;
			}
			if (g_str_has_prefix (data->line, "#")) {
				continue;
			}
			data->mimes = (data->_tmp4_ = data->_tmp3_ = g_strsplit (data->line, " ", 0), data->mimes = (_vala_array_free (data->mimes, data->mimes_length1, (GDestroyNotify) g_free), NULL), data->mimes_length1 = _vala_array_length (data->_tmp3_), data->_mimes_size_ = data->mimes_length1, data->_tmp4_);
			data->len = (gint) g_strv_length (data->mimes);
			if (data->len != 2) {
				continue;
			}
			if (_vala_strcmp0 (data->mimes[0], data->mimes[1]) == 0) {
				continue;
			}
			gee_multi_map_set (data->self->priv->mimetype_parent_map, data->mimes[0], data->mimes[1]);
		}
		data->mimes = (_vala_array_free (data->mimes, data->mimes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->line);
		_g_object_unref0 (data->dis);
		_g_object_unref0 (data->fis);
	}
	goto __finally13;
	__catch13_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			_g_error_free0 (data->err);
		}
	}
	__finally13:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->file);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self, const char* mime, GeeSet* ret) {
	GeeList* dfis;
	GeeCollection* parents;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime != NULL);
	g_return_if_fail (ret != NULL);
	dfis = (GeeList*) gee_map_get (self->priv->mimetype_map, mime);
	if (dfis != NULL) {
		gee_collection_add_all ((GeeCollection*) ret, (GeeCollection*) dfis);
	}
	parents = gee_multi_map_get (self->priv->mimetype_parent_map, mime);
	if (parents == NULL) {
		_g_object_unref0 (parents);
		_g_object_unref0 (dfis);
		return;
	}
	{
		GeeIterator* _parent_it;
		_parent_it = gee_iterable_iterator ((GeeIterable*) parents);
		while (TRUE) {
			char* parent;
			if (!gee_iterator_next (_parent_it)) {
				break;
			}
			parent = (char*) gee_iterator_get (_parent_it);
			synapse_desktop_file_service_add_dfi_for_mime (self, parent, ret);
			_g_free0 (parent);
		}
		_g_object_unref0 (_parent_it);
	}
	_g_object_unref0 (parents);
	_g_object_unref0 (dfis);
}


GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self) {
	GeeList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = gee_list_get_read_only_view (self->priv->non_hidden_desktop_files);
	return result;
}


GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self) {
	GeeList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = gee_list_get_read_only_view (self->priv->all_desktop_files);
	return result;
}


GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self, const char* mime_type) {
	GeeList* result = NULL;
	GeeHashSet* dfi_set;
	GeeArrayList* ret;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	dfi_set = gee_hash_set_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	synapse_desktop_file_service_add_dfi_for_mime (self, mime_type, (GeeSet*) dfi_set);
	ret = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	gee_abstract_collection_add_all ((GeeAbstractCollection*) ret, (GeeCollection*) dfi_set);
	result = (GeeList*) ret;
	_g_object_unref0 (dfi_set);
	return result;
}


GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self, const char* exec) {
	GeeList* result = NULL;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exec != NULL, NULL);
	_tmp0_ = (GeeList*) gee_map_get (self->priv->exec_map, exec);
	if (_tmp0_ == NULL) {
		GeeList* _tmp1_;
		_tmp0_ = (_tmp1_ = (GeeList*) gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (_tmp0_), _tmp1_);
	}
	result = _tmp0_;
	return result;
}


SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self, const char* desktop_id) {
	SynapseDesktopFileInfo* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (desktop_id != NULL, NULL);
	result = (SynapseDesktopFileInfo*) gee_map_get (self->priv->desktop_id_map, desktop_id);
	return result;
}


gboolean synapse_desktop_file_service_get_initialized (SynapseDesktopFileService* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_initialized;
	return result;
}


static void synapse_desktop_file_service_set_initialized (SynapseDesktopFileService* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_initialized = value;
	g_object_notify ((GObject *) self, "initialized");
}


static GObject * synapse_desktop_file_service_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFileService * self;
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_DESKTOP_FILE_SERVICE (obj);
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		GeeMultiMap* _tmp3_;
		synapse_desktop_file_service_instance = self;
		self->priv->directory_monitors = (_tmp0_ = (GeeList*) gee_array_list_new (G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->directory_monitors), _tmp0_);
		self->priv->all_desktop_files = (_tmp1_ = (GeeList*) gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->all_desktop_files), _tmp1_);
		self->priv->non_hidden_desktop_files = (_tmp2_ = (GeeList*) gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->non_hidden_desktop_files), _tmp2_);
		self->priv->mimetype_parent_map = (_tmp3_ = (GeeMultiMap*) gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->mimetype_parent_map), _tmp3_);
		synapse_desktop_file_service_initialize (self, NULL, NULL);
	}
	return obj;
}


static void synapse_desktop_file_service_class_init (SynapseDesktopFileServiceClass * klass) {
	synapse_desktop_file_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDesktopFileServicePrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_desktop_file_service_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_desktop_file_service_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_service_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_SERVICE_INITIALIZED, g_param_spec_boolean ("initialized", "initialized", "initialized", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("initialization_done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("reload_started", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("reload_done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void synapse_desktop_file_service_instance_init (SynapseDesktopFileService * self) {
	self->priv = SYNAPSE_DESKTOP_FILE_SERVICE_GET_PRIVATE (self);
	self->priv->_initialized = FALSE;
	self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
	self->priv->session_type_str = g_strdup ("GNOME");
	self->priv->timer_id = (guint) 0;
}


static void synapse_desktop_file_service_finalize (GObject* obj) {
	SynapseDesktopFileService * self;
	self = SYNAPSE_DESKTOP_FILE_SERVICE (obj);
	{
		synapse_desktop_file_service_instance = NULL;
	}
	_g_object_unref0 (self->priv->directory_monitors);
	_g_object_unref0 (self->priv->all_desktop_files);
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
	_g_object_unref0 (self->priv->mimetype_map);
	_g_object_unref0 (self->priv->exec_map);
	_g_object_unref0 (self->priv->desktop_id_map);
	_g_object_unref0 (self->priv->mimetype_parent_map);
	_g_free0 (self->priv->session_type_str);
	G_OBJECT_CLASS (synapse_desktop_file_service_parent_class)->finalize (obj);
}


GType synapse_desktop_file_service_get_type (void) {
	static volatile gsize synapse_desktop_file_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileService), 0, (GInstanceInitFunc) synapse_desktop_file_service_instance_init, NULL };
		GType synapse_desktop_file_service_type_id;
		synapse_desktop_file_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileService", &g_define_type_info, 0);
		g_once_init_leave (&synapse_desktop_file_service_type_id__volatile, synapse_desktop_file_service_type_id);
	}
	return synapse_desktop_file_service_type_id__volatile;
}


static void synapse_desktop_file_service_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDesktopFileService * self;
	self = SYNAPSE_DESKTOP_FILE_SERVICE (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_SERVICE_INITIALIZED:
		g_value_set_boolean (value, synapse_desktop_file_service_get_initialized (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_desktop_file_service_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDesktopFileService * self;
	self = SYNAPSE_DESKTOP_FILE_SERVICE (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_SERVICE_INITIALIZED:
		synapse_desktop_file_service_set_initialized (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




