/* common-actions.c generated by valac 0.10.4, the Vala compiler
 * generated from common-actions.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>


#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_BASE_ACTION (synapse_base_action_get_type ())
#define SYNAPSE_BASE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction))
#define SYNAPSE_BASE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseActionClass))
#define SYNAPSE_IS_BASE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_BASE_ACTION))
#define SYNAPSE_IS_BASE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_BASE_ACTION))
#define SYNAPSE_BASE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseActionClass))

typedef struct _SynapseBaseAction SynapseBaseAction;
typedef struct _SynapseBaseActionClass SynapseBaseActionClass;
typedef struct _SynapseBaseActionPrivate SynapseBaseActionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_ACTION_PROVIDER (synapse_action_provider_get_type ())
#define SYNAPSE_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider))
#define SYNAPSE_IS_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER))
#define SYNAPSE_ACTION_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProviderIface))

typedef struct _SynapseActionProvider SynapseActionProvider;
typedef struct _SynapseActionProviderIface SynapseActionProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_COMMON_ACTIONS (synapse_common_actions_get_type ())
#define SYNAPSE_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions))
#define SYNAPSE_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))
#define SYNAPSE_IS_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_IS_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_COMMON_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))

typedef struct _SynapseCommonActions SynapseCommonActions;
typedef struct _SynapseCommonActionsClass SynapseCommonActionsClass;
typedef struct _SynapseCommonActionsPrivate SynapseCommonActionsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER (synapse_common_actions_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunner))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))

typedef struct _SynapseCommonActionsRunner SynapseCommonActionsRunner;
typedef struct _SynapseCommonActionsRunnerClass SynapseCommonActionsRunnerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER (synapse_common_actions_terminal_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunner))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))

typedef struct _SynapseCommonActionsTerminalRunner SynapseCommonActionsTerminalRunner;
typedef struct _SynapseCommonActionsTerminalRunnerClass SynapseCommonActionsTerminalRunnerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPENER (synapse_common_actions_opener_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener))
#define SYNAPSE_COMMON_ACTIONS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_OPENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))

typedef struct _SynapseCommonActionsOpener SynapseCommonActionsOpener;
typedef struct _SynapseCommonActionsOpenerClass SynapseCommonActionsOpenerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER (synapse_common_actions_open_folder_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolder))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))

typedef struct _SynapseCommonActionsOpenFolder SynapseCommonActionsOpenFolder;
typedef struct _SynapseCommonActionsOpenFolderClass SynapseCommonActionsOpenFolderClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY (synapse_common_actions_clipboard_copy_get_type ())
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopy))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))

typedef struct _SynapseCommonActionsClipboardCopy SynapseCommonActionsClipboardCopy;
typedef struct _SynapseCommonActionsClipboardCopyClass SynapseCommonActionsClipboardCopyClass;
typedef struct _SynapseCommonActionsRunnerPrivate SynapseCommonActionsRunnerPrivate;

#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;
typedef struct _SynapseCommonActionsTerminalRunnerPrivate SynapseCommonActionsTerminalRunnerPrivate;
typedef struct _SynapseCommonActionsOpenerPrivate SynapseCommonActionsOpenerPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
typedef struct _SynapseCommonActionsOpenFolderPrivate SynapseCommonActionsOpenFolderPrivate;
typedef struct _SynapseCommonActionsClipboardCopyPrivate SynapseCommonActionsClipboardCopyPrivate;

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchIface))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchIface SynapseTextMatchIface;

#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH
} SynapseMatchType;

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	const char* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const char* value);
	const char* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const char* value);
	const char* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const char* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const char* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const char* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseBaseAction {
	GObject parent_instance;
	SynapseBaseActionPrivate * priv;
};

struct _SynapseBaseActionClass {
	GObjectClass parent_class;
	gboolean (*valid_for_match) (SynapseBaseAction* self, SynapseMatch* match);
	gint (*get_relevancy_for_match) (SynapseBaseAction* self, SynapseMatch* match);
	void (*do_execute) (SynapseBaseAction* self, SynapseMatch* match);
};

struct _SynapseBaseActionPrivate {
	char* _title;
	char* _description;
	char* _icon_name;
	gboolean _has_thumbnail;
	char* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
	gboolean _notify_match;
};

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 1,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 3,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 5,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 6,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 7,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 15,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFF | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

struct _SynapseQuery {
	char* query_string;
	char* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

struct _SynapseActionProviderIface {
	GTypeInterface parent_iface;
	SynapseResultSet* (*find_for_match) (SynapseActionProvider* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*handles_unknown) (SynapseActionProvider* self);
};

struct _SynapseCommonActions {
	GObject parent_instance;
	SynapseCommonActionsPrivate * priv;
};

struct _SynapseCommonActionsClass {
	GObjectClass parent_class;
};

struct _SynapseCommonActionsPrivate {
	gboolean _enabled;
	GeeList* actions;
};

typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

struct _SynapseCommonActionsRunner {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsRunnerPrivate * priv;
};

struct _SynapseCommonActionsRunnerClass {
	SynapseBaseActionClass parent_class;
};

typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const char* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const char* value);
};

struct _SynapseCommonActionsTerminalRunner {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsTerminalRunnerPrivate * priv;
};

struct _SynapseCommonActionsTerminalRunnerClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsOpener {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsOpenerPrivate * priv;
};

struct _SynapseCommonActionsOpenerClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsOpenerPrivate {
	GRegex* web_uri;
	GRegex* file_path;
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const char* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const char* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const char* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const char* value);
};

struct _SynapseCommonActionsOpenFolder {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsOpenFolderPrivate * priv;
};

struct _SynapseCommonActionsOpenFolderClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsClipboardCopy {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsClipboardCopyPrivate * priv;
};

struct _SynapseCommonActionsClipboardCopyClass {
	SynapseBaseActionClass parent_class;
};

typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;

struct _SynapseTextMatchIface {
	GTypeInterface parent_iface;
	char* (*get_text) (SynapseTextMatch* self);
	SynapseTextOrigin (*get_text_origin) (SynapseTextMatch* self);
	void (*set_text_origin) (SynapseTextMatch* self, SynapseTextOrigin value);
};


static gpointer synapse_base_action_parent_class = NULL;
static SynapseMatchIface* synapse_base_action_synapse_match_parent_iface = NULL;
static gpointer synapse_common_actions_runner_parent_class = NULL;
static gpointer synapse_common_actions_terminal_runner_parent_class = NULL;
static gpointer synapse_common_actions_opener_parent_class = NULL;
static gpointer synapse_common_actions_open_folder_parent_class = NULL;
static gpointer synapse_common_actions_clipboard_copy_parent_class = NULL;
static gpointer synapse_common_actions_parent_class = NULL;
static SynapseActivatableIface* synapse_common_actions_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface* synapse_common_actions_synapse_action_provider_parent_iface = NULL;

GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_base_action_get_type (void) G_GNUC_CONST;
#define SYNAPSE_BASE_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseActionPrivate))
enum  {
	SYNAPSE_BASE_ACTION_DUMMY_PROPERTY,
	SYNAPSE_BASE_ACTION_TITLE,
	SYNAPSE_BASE_ACTION_DESCRIPTION,
	SYNAPSE_BASE_ACTION_ICON_NAME,
	SYNAPSE_BASE_ACTION_HAS_THUMBNAIL,
	SYNAPSE_BASE_ACTION_THUMBNAIL_PATH,
	SYNAPSE_BASE_ACTION_MATCH_TYPE,
	SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY,
	SYNAPSE_BASE_ACTION_NOTIFY_MATCH
};
gboolean synapse_base_action_valid_for_match (SynapseBaseAction* self, SynapseMatch* match);
static gboolean synapse_base_action_real_valid_for_match (SynapseBaseAction* self, SynapseMatch* match);
gint synapse_base_action_get_relevancy_for_match (SynapseBaseAction* self, SynapseMatch* match);
static gint synapse_base_action_real_get_relevancy_for_match (SynapseBaseAction* self, SynapseMatch* match);
gint synapse_base_action_get_default_relevancy (SynapseBaseAction* self);
void synapse_base_action_do_execute (SynapseBaseAction* self, SynapseMatch* match);
static void synapse_base_action_real_do_execute (SynapseBaseAction* self, SynapseMatch* match);
static void synapse_base_action_real_execute (SynapseMatch* base, SynapseMatch* match);
gboolean synapse_base_action_get_notify_match (SynapseBaseAction* self);
SynapseBaseAction* synapse_base_action_construct (GType object_type);
void synapse_base_action_set_default_relevancy (SynapseBaseAction* self, gint value);
void synapse_base_action_set_notify_match (SynapseBaseAction* self, gboolean value);
static void synapse_base_action_finalize (GObject* obj);
const char* synapse_match_get_title (SynapseMatch* self);
const char* synapse_match_get_description (SynapseMatch* self);
const char* synapse_match_get_icon_name (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const char* synapse_match_get_thumbnail_path (SynapseMatch* self);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
static void synapse_base_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void synapse_match_set_title (SynapseMatch* self, const char* value);
void synapse_match_set_description (SynapseMatch* self, const char* value);
void synapse_match_set_icon_name (SynapseMatch* self, const char* value);
void synapse_match_set_has_thumbnail (SynapseMatch* self, gboolean value);
void synapse_match_set_thumbnail_path (SynapseMatch* self, const char* value);
void synapse_match_set_match_type (SynapseMatch* self, SynapseMatchType value);
static void synapse_base_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self, SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GType synapse_action_provider_get_type (void) G_GNUC_CONST;
GType synapse_common_actions_get_type (void) G_GNUC_CONST;
#define SYNAPSE_COMMON_ACTIONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsPrivate))
enum  {
	SYNAPSE_COMMON_ACTIONS_DUMMY_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_ENABLED
};
static void synapse_common_actions_real_activate (SynapseActivatable* base);
static void synapse_common_actions_real_deactivate (SynapseActivatable* base);
static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionProvider* base, SynapseQuery* query, SynapseMatch* match);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
void synapse_result_set_add (SynapseResultSet* self, SynapseMatch* match, gint relevancy);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GeeList* synapse_query_get_matchers_for_query (const char* query, SynapseMatcherFlags match_flags, GRegexCompileFlags flags);
void synapse_common_actions_open_uri (const char* uri);
static void _g_list_free_g_object_unref (GList* self);
void synapse_utils_logger_warning (GObject* obj, const char* format, ...);
SynapseCommonActions* synapse_common_actions_new (void);
SynapseCommonActions* synapse_common_actions_construct (GType object_type);
static SynapseCommonActionsRunner* synapse_common_actions_runner_new (void);
static SynapseCommonActionsRunner* synapse_common_actions_runner_construct (GType object_type);
static GType synapse_common_actions_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_new (void);
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_construct (GType object_type);
static GType synapse_common_actions_terminal_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsOpener* synapse_common_actions_opener_new (void);
static SynapseCommonActionsOpener* synapse_common_actions_opener_construct (GType object_type);
static GType synapse_common_actions_opener_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_new (void);
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_construct (GType object_type);
static GType synapse_common_actions_open_folder_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_new (void);
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_construct (GType object_type);
static GType synapse_common_actions_clipboard_copy_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GObject * synapse_common_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SYNAPSE_COMMON_ACTIONS_RUNNER_DUMMY_PROPERTY
};
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void synapse_common_actions_runner_real_do_execute (SynapseBaseAction* base, SynapseMatch* match);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
const char* synapse_application_match_get_filename (SynapseApplicationMatch* self);
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
void synapse_relevancy_service_application_launched (SynapseRelevancyService* self, GAppInfo* app_info);
void synapse_match_execute (SynapseMatch* self, SynapseMatch* match);
static gboolean synapse_common_actions_runner_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
enum  {
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_DUMMY_PROPERTY
};
static void synapse_common_actions_terminal_runner_real_do_execute (SynapseBaseAction* base, SynapseMatch* match);
static gboolean synapse_common_actions_terminal_runner_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match);
#define SYNAPSE_COMMON_ACTIONS_OPENER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerPrivate))
enum  {
	SYNAPSE_COMMON_ACTIONS_OPENER_DUMMY_PROPERTY
};
static void synapse_common_actions_opener_real_do_execute (SynapseBaseAction* base, SynapseMatch* match);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const char* synapse_uri_match_get_uri (SynapseUriMatch* self);
static gboolean synapse_common_actions_opener_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match);
static GObject * synapse_common_actions_opener_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void synapse_common_actions_opener_finalize (GObject* obj);
enum  {
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_DUMMY_PROPERTY
};
static void synapse_common_actions_open_folder_real_do_execute (SynapseBaseAction* base, SynapseMatch* match);
static gboolean synapse_common_actions_open_folder_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match);
enum  {
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_DUMMY_PROPERTY
};
static void synapse_common_actions_clipboard_copy_real_do_execute (SynapseBaseAction* base, SynapseMatch* match);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
GType synapse_text_match_get_type (void) G_GNUC_CONST;
char* synapse_text_match_get_text (SynapseTextMatch* self);
static gboolean synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match);
static gint synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseBaseAction* base, SynapseMatch* match);
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
static void synapse_common_actions_finalize (GObject* obj);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
static void synapse_common_actions_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void synapse_activatable_set_enabled (SynapseActivatable* self, gboolean value);
static void synapse_common_actions_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gboolean synapse_base_action_real_valid_for_match (SynapseBaseAction* self, SynapseMatch* match) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `synapse_base_action_valid_for_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean synapse_base_action_valid_for_match (SynapseBaseAction* self, SynapseMatch* match) {
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->valid_for_match (self, match);
}


static gint synapse_base_action_real_get_relevancy_for_match (SynapseBaseAction* self, SynapseMatch* match) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (match != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}


gint synapse_base_action_get_relevancy_for_match (SynapseBaseAction* self, SynapseMatch* match) {
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->get_relevancy_for_match (self, match);
}


static void synapse_base_action_real_do_execute (SynapseBaseAction* self, SynapseMatch* match) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `synapse_base_action_do_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void synapse_base_action_do_execute (SynapseBaseAction* self, SynapseMatch* match) {
	SYNAPSE_BASE_ACTION_GET_CLASS (self)->do_execute (self, match);
}


static void synapse_base_action_real_execute (SynapseMatch* base, SynapseMatch* match) {
	SynapseBaseAction * self;
	self = (SynapseBaseAction*) base;
	synapse_base_action_do_execute (self, match);
	if (self->priv->_notify_match) {
		g_signal_emit_by_name (match, "executed");
	}
}


SynapseBaseAction* synapse_base_action_construct (GType object_type) {
	SynapseBaseAction * self = NULL;
	self = (SynapseBaseAction*) g_object_new (object_type, NULL);
	return self;
}


static const char* synapse_base_action_real_get_title (SynapseMatch* base) {
	const char* result;
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_base_action_real_set_title (SynapseMatch* base, const char* value) {
	SynapseBaseAction* self;
	char* _tmp0_;
	self = (SynapseBaseAction*) base;
	self->priv->_title = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_title), _tmp0_);
	g_object_notify ((GObject *) self, "title");
}


static const char* synapse_base_action_real_get_description (SynapseMatch* base) {
	const char* result;
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_base_action_real_set_description (SynapseMatch* base, const char* value) {
	SynapseBaseAction* self;
	char* _tmp0_;
	self = (SynapseBaseAction*) base;
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


static const char* synapse_base_action_real_get_icon_name (SynapseMatch* base) {
	const char* result;
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_base_action_real_set_icon_name (SynapseMatch* base, const char* value) {
	SynapseBaseAction* self;
	char* _tmp0_;
	self = (SynapseBaseAction*) base;
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_base_action_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_base_action_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const char* synapse_base_action_real_get_thumbnail_path (SynapseMatch* base) {
	const char* result;
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_base_action_real_set_thumbnail_path (SynapseMatch* base, const char* value) {
	SynapseBaseAction* self;
	char* _tmp0_;
	self = (SynapseBaseAction*) base;
	self->priv->_thumbnail_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_thumbnail_path), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_base_action_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_base_action_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


gint synapse_base_action_get_default_relevancy (SynapseBaseAction* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}


void synapse_base_action_set_default_relevancy (SynapseBaseAction* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_default_relevancy = value;
	g_object_notify ((GObject *) self, "default-relevancy");
}


gboolean synapse_base_action_get_notify_match (SynapseBaseAction* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_notify_match;
	return result;
}


void synapse_base_action_set_notify_match (SynapseBaseAction* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_notify_match = value;
	g_object_notify ((GObject *) self, "notify-match");
}


static void synapse_base_action_class_init (SynapseBaseActionClass * klass) {
	synapse_base_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseBaseActionPrivate));
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_base_action_real_valid_for_match;
	SYNAPSE_BASE_ACTION_CLASS (klass)->get_relevancy_for_match = synapse_base_action_real_get_relevancy_for_match;
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_base_action_real_do_execute;
	G_OBJECT_CLASS (klass)->get_property = synapse_base_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_base_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_base_action_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_MATCH_TYPE, "match-type");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY, g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_NOTIFY_MATCH, g_param_spec_boolean ("notify-match", "notify-match", "notify-match", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_base_action_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_base_action_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->execute = synapse_base_action_real_execute;
	iface->get_title = synapse_base_action_real_get_title;
	iface->set_title = synapse_base_action_real_set_title;
	iface->get_description = synapse_base_action_real_get_description;
	iface->set_description = synapse_base_action_real_set_description;
	iface->get_icon_name = synapse_base_action_real_get_icon_name;
	iface->set_icon_name = synapse_base_action_real_set_icon_name;
	iface->get_has_thumbnail = synapse_base_action_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_base_action_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_base_action_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_base_action_real_set_thumbnail_path;
	iface->get_match_type = synapse_base_action_real_get_match_type;
	iface->set_match_type = synapse_base_action_real_set_match_type;
}


static void synapse_base_action_instance_init (SynapseBaseAction * self) {
	self->priv = SYNAPSE_BASE_ACTION_GET_PRIVATE (self);
	self->priv->_notify_match = TRUE;
}


static void synapse_base_action_finalize (GObject* obj) {
	SynapseBaseAction * self;
	self = SYNAPSE_BASE_ACTION (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_base_action_parent_class)->finalize (obj);
}


GType synapse_base_action_get_type (void) {
	static volatile gsize synapse_base_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_base_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseBaseActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_base_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseBaseAction), 0, (GInstanceInitFunc) synapse_base_action_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_base_action_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_base_action_type_id;
		synapse_base_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseBaseAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (synapse_base_action_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_once_init_leave (&synapse_base_action_type_id__volatile, synapse_base_action_type_id);
	}
	return synapse_base_action_type_id__volatile;
}


static void synapse_base_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseBaseAction * self;
	self = SYNAPSE_BASE_ACTION (object);
	switch (property_id) {
		case SYNAPSE_BASE_ACTION_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY:
		g_value_set_int (value, synapse_base_action_get_default_relevancy (self));
		break;
		case SYNAPSE_BASE_ACTION_NOTIFY_MATCH:
		g_value_set_boolean (value, synapse_base_action_get_notify_match (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_base_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseBaseAction * self;
	self = SYNAPSE_BASE_ACTION (object);
	switch (property_id) {
		case SYNAPSE_BASE_ACTION_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_BASE_ACTION_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_BASE_ACTION_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_BASE_ACTION_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_BASE_ACTION_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_BASE_ACTION_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY:
		synapse_base_action_set_default_relevancy (self, g_value_get_int (value));
		break;
		case SYNAPSE_BASE_ACTION_NOTIFY_MATCH:
		synapse_base_action_set_notify_match (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_common_actions_real_activate (SynapseActivatable* base) {
	SynapseCommonActions * self;
	self = (SynapseCommonActions*) base;
}


static void synapse_common_actions_real_deactivate (SynapseActivatable* base) {
	SynapseCommonActions * self;
	self = (SynapseCommonActions*) base;
}


static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionProvider* base, SynapseQuery* query, SynapseMatch* match) {
	SynapseCommonActions * self;
	SynapseResultSet* result = NULL;
	gboolean query_empty;
	SynapseResultSet* results;
	self = (SynapseCommonActions*) base;
	g_return_val_if_fail (match != NULL, NULL);
	query_empty = _vala_strcmp0 ((*query).query_string, "") == 0;
	results = synapse_result_set_new ();
	if (query_empty) {
		{
			GeeIterator* _action_it;
			_action_it = gee_iterable_iterator ((GeeIterable*) self->priv->actions);
			while (TRUE) {
				SynapseBaseAction* action;
				if (!gee_iterator_next (_action_it)) {
					break;
				}
				action = (SynapseBaseAction*) gee_iterator_get (_action_it);
				if (synapse_base_action_valid_for_match (action, match)) {
					synapse_result_set_add (results, (SynapseMatch*) action, synapse_base_action_get_relevancy_for_match (action, match));
				}
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_it);
		}
	} else {
		GeeList* matchers;
		matchers = synapse_query_get_matchers_for_query ((*query).query_string, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
		{
			GeeIterator* _action_it;
			_action_it = gee_iterable_iterator ((GeeIterable*) self->priv->actions);
			while (TRUE) {
				SynapseBaseAction* action;
				if (!gee_iterator_next (_action_it)) {
					break;
				}
				action = (SynapseBaseAction*) gee_iterator_get (_action_it);
				if (!synapse_base_action_valid_for_match (action, match)) {
					_g_object_unref0 (action);
					continue;
				}
				{
					GeeIterator* _matcher_it;
					_matcher_it = gee_iterable_iterator ((GeeIterable*) matchers);
					while (TRUE) {
						GeeMapEntry* matcher;
						if (!gee_iterator_next (_matcher_it)) {
							break;
						}
						matcher = (GeeMapEntry*) gee_iterator_get (_matcher_it);
						if (g_regex_match ((GRegex*) gee_map_entry_get_key (matcher), synapse_match_get_title ((SynapseMatch*) action), 0, NULL)) {
							synapse_result_set_add (results, (SynapseMatch*) action, GPOINTER_TO_INT (gee_map_entry_get_value (matcher)));
							_g_object_unref0 (matcher);
							break;
						}
						_g_object_unref0 (matcher);
					}
					_g_object_unref0 (_matcher_it);
				}
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_it);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


void synapse_common_actions_open_uri (const char* uri) {
	GFile* f;
	GError * _inner_error_ = NULL;
	g_return_if_fail (uri != NULL);
	f = g_file_new_for_uri (uri);
	{
		GAppInfo* app_info;
		GList* files;
		GdkAppLaunchContext* _tmp0_;
		app_info = g_file_query_default_handler (f, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		files = NULL;
		files = g_list_prepend (files, _g_object_ref0 (f));
		g_app_info_launch (app_info, files, (GAppLaunchContext*) (_tmp0_ = gdk_app_launch_context_new ()), &_inner_error_);
		_g_object_unref0 (_tmp0_);
		if (_inner_error_ != NULL) {
			__g_list_free_g_object_unref0 (files);
			_g_object_unref0 (app_info);
			goto __catch0_g_error;
		}
		__g_list_free_g_object_unref0 (files);
		_g_object_unref0 (app_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			synapse_utils_logger_warning (NULL, "%s", err->message, NULL);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (f);
}


SynapseCommonActions* synapse_common_actions_construct (GType object_type) {
	SynapseCommonActions * self = NULL;
	self = (SynapseCommonActions*) g_object_new (object_type, NULL);
	return self;
}


SynapseCommonActions* synapse_common_actions_new (void) {
	return synapse_common_actions_construct (SYNAPSE_TYPE_COMMON_ACTIONS);
}


static gboolean synapse_common_actions_real_get_enabled (SynapseActivatable* base) {
	gboolean result;
	SynapseCommonActions* self;
	self = (SynapseCommonActions*) base;
	result = self->priv->_enabled;
	return result;
}


static void synapse_common_actions_real_set_enabled (SynapseActivatable* base, gboolean value) {
	SynapseCommonActions* self;
	self = (SynapseCommonActions*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static GObject * synapse_common_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActions * self;
	parent_class = G_OBJECT_CLASS (synapse_common_actions_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_COMMON_ACTIONS (obj);
	{
		GeeList* _tmp0_;
		SynapseCommonActionsRunner* _tmp1_;
		SynapseCommonActionsTerminalRunner* _tmp2_;
		SynapseCommonActionsOpener* _tmp3_;
		SynapseCommonActionsOpenFolder* _tmp4_;
		SynapseCommonActionsClipboardCopy* _tmp5_;
		self->priv->actions = (_tmp0_ = (GeeList*) gee_array_list_new (SYNAPSE_TYPE_BASE_ACTION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->actions), _tmp0_);
		gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseBaseAction*) (_tmp1_ = synapse_common_actions_runner_new ()));
		_g_object_unref0 (_tmp1_);
		gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseBaseAction*) (_tmp2_ = synapse_common_actions_terminal_runner_new ()));
		_g_object_unref0 (_tmp2_);
		gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseBaseAction*) (_tmp3_ = synapse_common_actions_opener_new ()));
		_g_object_unref0 (_tmp3_);
		gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseBaseAction*) (_tmp4_ = synapse_common_actions_open_folder_new ()));
		_g_object_unref0 (_tmp4_);
		gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseBaseAction*) (_tmp5_ = synapse_common_actions_clipboard_copy_new ()));
		_g_object_unref0 (_tmp5_);
	}
	return obj;
}


static SynapseCommonActionsRunner* synapse_common_actions_runner_construct (GType object_type) {
	SynapseCommonActionsRunner * self = NULL;
	self = (SynapseCommonActionsRunner*) g_object_new (object_type, "title", _ ("Run"), "description", _ ("Run an application, action or script"), "icon-name", "system-run", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_EXCELLENT, NULL);
	return self;
}


static SynapseCommonActionsRunner* synapse_common_actions_runner_new (void) {
	return synapse_common_actions_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER);
}


static void synapse_common_actions_runner_real_do_execute (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsRunner * self;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsRunner*) base;
	if (synapse_match_get_match_type (match) == SYNAPSE_MATCH_TYPE_APPLICATION) {
		SynapseMatch* _tmp0_;
		SynapseApplicationMatch* app_match;
		GAppInfo* _tmp1_;
		GAppInfo* app;
		app_match = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_APPLICATION_MATCH (_tmp0_) ? ((SynapseApplicationMatch*) _tmp0_) : NULL));
		g_return_if_fail (app_match != NULL);
		_tmp1_ = _g_object_ref0 (synapse_application_match_get_app_info (app_match));
		if (_tmp1_ == NULL) {
			GAppInfo* _tmp2_;
			_tmp1_ = (_tmp2_ = (GAppInfo*) g_desktop_app_info_new_from_filename (synapse_application_match_get_filename (app_match)), _g_object_unref0 (_tmp1_), _tmp2_);
		}
		app = _g_object_ref0 (_tmp1_);
		{
			GdkAppLaunchContext* _tmp3_;
			SynapseRelevancyService* _tmp4_;
			g_app_info_launch (app, NULL, (GAppLaunchContext*) (_tmp3_ = gdk_app_launch_context_new ()), &_inner_error_);
			_g_object_unref0 (_tmp3_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			synapse_relevancy_service_application_launched (_tmp4_ = synapse_relevancy_service_get_default (), app);
			_g_object_unref0 (_tmp4_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
				_g_error_free0 (err);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (app);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (app_match);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (app);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (app_match);
	} else {
		synapse_match_execute (match, NULL);
	}
}


static gboolean synapse_common_actions_runner_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsRunner * self;
	gboolean result = FALSE;
	self = (SynapseCommonActionsRunner*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	switch (synapse_match_get_match_type (match)) {
		case SYNAPSE_MATCH_TYPE_SEARCH:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_ACTION:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_APPLICATION:
		{
			SynapseMatch* _tmp0_;
			SynapseApplicationMatch* am;
			gboolean _tmp1_ = FALSE;
			am = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_APPLICATION_MATCH (_tmp0_) ? ((SynapseApplicationMatch*) _tmp0_) : NULL));
			if (am == NULL) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = !synapse_application_match_get_needs_terminal (am);
			}
			result = _tmp1_;
			_g_object_unref0 (am);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void synapse_common_actions_runner_class_init (SynapseCommonActionsRunnerClass * klass) {
	synapse_common_actions_runner_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_common_actions_runner_real_do_execute;
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_runner_real_valid_for_match;
}


static void synapse_common_actions_runner_instance_init (SynapseCommonActionsRunner * self) {
}


static GType synapse_common_actions_runner_get_type (void) {
	static volatile gsize synapse_common_actions_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsRunner), 0, (GInstanceInitFunc) synapse_common_actions_runner_instance_init, NULL };
		GType synapse_common_actions_runner_type_id;
		synapse_common_actions_runner_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsRunner", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_runner_type_id__volatile, synapse_common_actions_runner_type_id);
	}
	return synapse_common_actions_runner_type_id__volatile;
}


static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_construct (GType object_type) {
	SynapseCommonActionsTerminalRunner * self = NULL;
	self = (SynapseCommonActionsTerminalRunner*) g_object_new (object_type, "title", _ ("Run in Terminal"), "description", _ ("Run application or command in terminal"), "icon-name", "terminal", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, NULL);
	return self;
}


static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_new (void) {
	return synapse_common_actions_terminal_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER);
}


static void synapse_common_actions_terminal_runner_real_do_execute (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsTerminalRunner * self;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsTerminalRunner*) base;
	if (synapse_match_get_match_type (match) == SYNAPSE_MATCH_TYPE_APPLICATION) {
		SynapseMatch* _tmp0_;
		SynapseApplicationMatch* app_match;
		GAppInfo* _tmp1_;
		GAppInfo* original;
		GAppInfo* app;
		app_match = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_APPLICATION_MATCH (_tmp0_) ? ((SynapseApplicationMatch*) _tmp0_) : NULL));
		g_return_if_fail (app_match != NULL);
		_tmp1_ = _g_object_ref0 (synapse_application_match_get_app_info (app_match));
		if (_tmp1_ == NULL) {
			GAppInfo* _tmp2_;
			_tmp1_ = (_tmp2_ = (GAppInfo*) g_desktop_app_info_new_from_filename (synapse_application_match_get_filename (app_match)), _g_object_unref0 (_tmp1_), _tmp2_);
		}
		original = _g_object_ref0 (_tmp1_);
		app = _g_object_ref0 (g_app_info_create_from_commandline (g_app_info_get_commandline (original), g_app_info_get_name (original), G_APP_INFO_CREATE_NEEDS_TERMINAL, &_inner_error_));
		if (_inner_error_ != NULL) {
			_g_object_unref0 (original);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (app_match);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			GdkAppLaunchContext* _tmp3_;
			g_app_info_launch (app, NULL, (GAppLaunchContext*) (_tmp3_ = gdk_app_launch_context_new ()), &_inner_error_);
			_g_object_unref0 (_tmp3_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
				_g_error_free0 (err);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (app);
			_g_object_unref0 (original);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (app_match);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (app);
		_g_object_unref0 (original);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (app_match);
	}
}


static gboolean synapse_common_actions_terminal_runner_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsTerminalRunner * self;
	gboolean result = FALSE;
	self = (SynapseCommonActionsTerminalRunner*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	switch (synapse_match_get_match_type (match)) {
		case SYNAPSE_MATCH_TYPE_APPLICATION:
		{
			SynapseMatch* _tmp0_;
			SynapseApplicationMatch* am;
			am = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_APPLICATION_MATCH (_tmp0_) ? ((SynapseApplicationMatch*) _tmp0_) : NULL));
			result = am != NULL;
			_g_object_unref0 (am);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void synapse_common_actions_terminal_runner_class_init (SynapseCommonActionsTerminalRunnerClass * klass) {
	synapse_common_actions_terminal_runner_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_common_actions_terminal_runner_real_do_execute;
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_terminal_runner_real_valid_for_match;
}


static void synapse_common_actions_terminal_runner_instance_init (SynapseCommonActionsTerminalRunner * self) {
}


static GType synapse_common_actions_terminal_runner_get_type (void) {
	static volatile gsize synapse_common_actions_terminal_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_terminal_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsTerminalRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_terminal_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsTerminalRunner), 0, (GInstanceInitFunc) synapse_common_actions_terminal_runner_instance_init, NULL };
		GType synapse_common_actions_terminal_runner_type_id;
		synapse_common_actions_terminal_runner_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsTerminalRunner", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_terminal_runner_type_id__volatile, synapse_common_actions_terminal_runner_type_id);
	}
	return synapse_common_actions_terminal_runner_type_id__volatile;
}


static SynapseCommonActionsOpener* synapse_common_actions_opener_construct (GType object_type) {
	SynapseCommonActionsOpener * self = NULL;
	self = (SynapseCommonActionsOpener*) g_object_new (object_type, "title", _ ("Open"), "description", _ ("Open using default application"), "icon-name", "fileopen", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_GOOD, NULL);
	return self;
}


static SynapseCommonActionsOpener* synapse_common_actions_opener_new (void) {
	return synapse_common_actions_opener_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPENER);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void synapse_common_actions_opener_real_do_execute (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsOpener * self;
	SynapseMatch* _tmp0_;
	SynapseUriMatch* uri_match;
	self = (SynapseCommonActionsOpener*) base;
	uri_match = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL));
	if (uri_match != NULL) {
		synapse_common_actions_open_uri (synapse_uri_match_get_uri (uri_match));
	} else {
		if (g_regex_match (self->priv->file_path, synapse_match_get_title (match), 0, NULL)) {
			GFile* f;
			char* _tmp5_;
			f = NULL;
			if (g_str_has_prefix (synapse_match_get_title (match), "~")) {
				char* _tmp1_;
				char* _tmp2_;
				GFile* _tmp3_;
				f = (_tmp3_ = g_file_new_for_path (_tmp2_ = g_build_filename (g_get_home_dir (), _tmp1_ = string_substring (synapse_match_get_title (match), (glong) 1, -1), NULL, NULL)), _g_object_unref0 (f), _tmp3_);
				_g_free0 (_tmp2_);
				_g_free0 (_tmp1_);
			} else {
				GFile* _tmp4_;
				f = (_tmp4_ = g_file_new_for_path (synapse_match_get_title (match)), _g_object_unref0 (f), _tmp4_);
			}
			synapse_common_actions_open_uri (_tmp5_ = g_file_get_uri (f));
			_g_free0 (_tmp5_);
			_g_object_unref0 (f);
		} else {
			synapse_common_actions_open_uri (synapse_match_get_title (match));
		}
	}
	_g_object_unref0 (uri_match);
}


static gboolean synapse_common_actions_opener_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsOpener * self;
	gboolean result = FALSE;
	self = (SynapseCommonActionsOpener*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	switch (synapse_match_get_match_type (match)) {
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_UNKNOWN:
		{
			gboolean _tmp0_ = FALSE;
			if (g_regex_match (self->priv->web_uri, synapse_match_get_title (match), 0, NULL)) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = g_regex_match (self->priv->file_path, synapse_match_get_title (match), 0, NULL);
			}
			result = _tmp0_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static GObject * synapse_common_actions_opener_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActionsOpener * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (synapse_common_actions_opener_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_COMMON_ACTIONS_OPENER (obj);
	_inner_error_ = NULL;
	{
		{
			GRegex* _tmp0_;
			GRegex* _tmp1_;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp0_ = g_regex_new ("^(ftp|http(s)?)://[^.]+\\.[^.]+", G_REGEX_OPTIMIZE, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			self->priv->web_uri = (_tmp1_ = _tmp0_, _g_regex_unref0 (self->priv->web_uri), _tmp1_);
			_tmp2_ = g_regex_new ("^(/|~/)[^/]+", G_REGEX_OPTIMIZE, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			self->priv->file_path = (_tmp3_ = _tmp2_, _g_regex_unref0 (self->priv->file_path), _tmp3_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
				_g_error_free0 (err);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void synapse_common_actions_opener_class_init (SynapseCommonActionsOpenerClass * klass) {
	synapse_common_actions_opener_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseCommonActionsOpenerPrivate));
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_common_actions_opener_real_do_execute;
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_opener_real_valid_for_match;
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_opener_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_opener_finalize;
}


static void synapse_common_actions_opener_instance_init (SynapseCommonActionsOpener * self) {
	self->priv = SYNAPSE_COMMON_ACTIONS_OPENER_GET_PRIVATE (self);
}


static void synapse_common_actions_opener_finalize (GObject* obj) {
	SynapseCommonActionsOpener * self;
	self = SYNAPSE_COMMON_ACTIONS_OPENER (obj);
	_g_regex_unref0 (self->priv->web_uri);
	_g_regex_unref0 (self->priv->file_path);
	G_OBJECT_CLASS (synapse_common_actions_opener_parent_class)->finalize (obj);
}


static GType synapse_common_actions_opener_get_type (void) {
	static volatile gsize synapse_common_actions_opener_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_opener_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_opener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpener), 0, (GInstanceInitFunc) synapse_common_actions_opener_instance_init, NULL };
		GType synapse_common_actions_opener_type_id;
		synapse_common_actions_opener_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsOpener", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_opener_type_id__volatile, synapse_common_actions_opener_type_id);
	}
	return synapse_common_actions_opener_type_id__volatile;
}


static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_construct (GType object_type) {
	SynapseCommonActionsOpenFolder * self = NULL;
	self = (SynapseCommonActionsOpenFolder*) g_object_new (object_type, "title", _ ("Open folder"), "description", _ ("Open folder containing this file"), "icon-name", "folder-open", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
	return self;
}


static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_new (void) {
	return synapse_common_actions_open_folder_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER);
}


static void synapse_common_actions_open_folder_real_do_execute (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsOpenFolder * self;
	SynapseMatch* _tmp0_;
	SynapseUriMatch* uri_match;
	GFile* f;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsOpenFolder*) base;
	uri_match = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL));
	g_return_if_fail (uri_match != NULL);
	f = g_file_new_for_uri (synapse_uri_match_get_uri (uri_match));
	f = (_tmp1_ = g_file_get_parent (f), _g_object_unref0 (f), _tmp1_);
	{
		GAppInfo* app_info;
		GList* files;
		GdkAppLaunchContext* _tmp2_;
		app_info = g_file_query_default_handler (f, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		files = NULL;
		files = g_list_prepend (files, _g_object_ref0 (f));
		g_app_info_launch (app_info, files, (GAppLaunchContext*) (_tmp2_ = gdk_app_launch_context_new ()), &_inner_error_);
		_g_object_unref0 (_tmp2_);
		if (_inner_error_ != NULL) {
			__g_list_free_g_object_unref0 (files);
			_g_object_unref0 (app_info);
			goto __catch4_g_error;
		}
		__g_list_free_g_object_unref0 (files);
		_g_object_unref0 (app_info);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			synapse_utils_logger_warning ((GObject*) self, "%s", err->message, NULL);
			_g_error_free0 (err);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		_g_object_unref0 (uri_match);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
}


static gboolean synapse_common_actions_open_folder_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsOpenFolder * self;
	gboolean result = FALSE;
	SynapseMatch* _tmp0_;
	SynapseUriMatch* uri_match;
	GFile* f;
	GFile* parent;
	gboolean _tmp1_ = FALSE;
	self = (SynapseCommonActionsOpenFolder*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	if (synapse_match_get_match_type (match) != SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		result = FALSE;
		return result;
	}
	uri_match = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL));
	f = g_file_new_for_uri (synapse_uri_match_get_uri (uri_match));
	parent = g_file_get_parent (f);
	if (parent != NULL) {
		_tmp1_ = g_file_is_native (f);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (parent);
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
	return result;
}


static void synapse_common_actions_open_folder_class_init (SynapseCommonActionsOpenFolderClass * klass) {
	synapse_common_actions_open_folder_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_common_actions_open_folder_real_do_execute;
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_open_folder_real_valid_for_match;
}


static void synapse_common_actions_open_folder_instance_init (SynapseCommonActionsOpenFolder * self) {
}


static GType synapse_common_actions_open_folder_get_type (void) {
	static volatile gsize synapse_common_actions_open_folder_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_open_folder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_open_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpenFolder), 0, (GInstanceInitFunc) synapse_common_actions_open_folder_instance_init, NULL };
		GType synapse_common_actions_open_folder_type_id;
		synapse_common_actions_open_folder_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsOpenFolder", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_open_folder_type_id__volatile, synapse_common_actions_open_folder_type_id);
	}
	return synapse_common_actions_open_folder_type_id__volatile;
}


static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_construct (GType object_type) {
	SynapseCommonActionsClipboardCopy * self = NULL;
	self = (SynapseCommonActionsClipboardCopy*) g_object_new (object_type, "title", _ ("Copy to Clipboard"), "description", _ ("Copy selection to clipboard"), "icon-name", "gtk-copy", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
	return self;
}


static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_new (void) {
	return synapse_common_actions_clipboard_copy_construct (SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY);
}


static void synapse_common_actions_clipboard_copy_real_do_execute (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsClipboardCopy * self;
	GtkClipboard* cb;
	self = (SynapseCommonActionsClipboardCopy*) base;
	cb = _g_object_ref0 (gtk_clipboard_get (GDK_NONE));
	if (synapse_match_get_match_type (match) == SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		SynapseMatch* _tmp0_;
		SynapseUriMatch* uri_match;
		uri_match = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL));
		g_return_if_fail (uri_match != NULL);
		gtk_clipboard_set_text (cb, synapse_uri_match_get_uri (uri_match), -1);
		_g_object_unref0 (uri_match);
	} else {
		if (synapse_match_get_match_type (match) == SYNAPSE_MATCH_TYPE_TEXT) {
			SynapseMatch* _tmp1_;
			SynapseTextMatch* text_match;
			char* _tmp2_;
			char* content;
			text_match = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_TEXT_MATCH (_tmp1_) ? ((SynapseTextMatch*) _tmp1_) : NULL));
			_tmp2_ = NULL;
			if (text_match != NULL) {
				char* _tmp3_;
				_tmp2_ = (_tmp3_ = synapse_text_match_get_text (text_match), _g_free0 (_tmp2_), _tmp3_);
			} else {
				char* _tmp4_;
				_tmp2_ = (_tmp4_ = g_strdup (synapse_match_get_title (match)), _g_free0 (_tmp2_), _tmp4_);
			}
			content = g_strdup (_tmp2_);
			gtk_clipboard_set_text (cb, content, -1);
			_g_free0 (content);
			_g_free0 (_tmp2_);
			_g_object_unref0 (text_match);
		}
	}
	_g_object_unref0 (cb);
}


static gboolean synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsClipboardCopy * self;
	gboolean result = FALSE;
	self = (SynapseCommonActionsClipboardCopy*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	switch (synapse_match_get_match_type (match)) {
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_TEXT:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gint synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseBaseAction* base, SynapseMatch* match) {
	SynapseCommonActionsClipboardCopy * self;
	gint result = 0;
	SynapseMatch* _tmp0_;
	SynapseTextMatch* text_match;
	gboolean _tmp1_ = FALSE;
	self = (SynapseCommonActionsClipboardCopy*) base;
	g_return_val_if_fail (match != NULL, 0);
	text_match = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_TEXT_MATCH (_tmp0_) ? ((SynapseTextMatch*) _tmp0_) : NULL));
	if (text_match != NULL) {
		_tmp1_ = synapse_text_match_get_text_origin (text_match) == SYNAPSE_TEXT_ORIGIN_CLIPBOARD;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = 0;
		_g_object_unref0 (text_match);
		return result;
	}
	result = synapse_base_action_get_default_relevancy ((SynapseBaseAction*) self);
	_g_object_unref0 (text_match);
	return result;
}


static void synapse_common_actions_clipboard_copy_class_init (SynapseCommonActionsClipboardCopyClass * klass) {
	synapse_common_actions_clipboard_copy_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_BASE_ACTION_CLASS (klass)->do_execute = synapse_common_actions_clipboard_copy_real_do_execute;
	SYNAPSE_BASE_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_clipboard_copy_real_valid_for_match;
	SYNAPSE_BASE_ACTION_CLASS (klass)->get_relevancy_for_match = synapse_common_actions_clipboard_copy_real_get_relevancy_for_match;
}


static void synapse_common_actions_clipboard_copy_instance_init (SynapseCommonActionsClipboardCopy * self) {
}


static GType synapse_common_actions_clipboard_copy_get_type (void) {
	static volatile gsize synapse_common_actions_clipboard_copy_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_clipboard_copy_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClipboardCopyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_clipboard_copy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsClipboardCopy), 0, (GInstanceInitFunc) synapse_common_actions_clipboard_copy_instance_init, NULL };
		GType synapse_common_actions_clipboard_copy_type_id;
		synapse_common_actions_clipboard_copy_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsClipboardCopy", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_clipboard_copy_type_id__volatile, synapse_common_actions_clipboard_copy_type_id);
	}
	return synapse_common_actions_clipboard_copy_type_id__volatile;
}


static void synapse_common_actions_class_init (SynapseCommonActionsClass * klass) {
	synapse_common_actions_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseCommonActionsPrivate));
	G_OBJECT_CLASS (klass)->get_property = synapse_common_actions_get_property;
	G_OBJECT_CLASS (klass)->set_property = synapse_common_actions_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ENABLED, "enabled");
}


static void synapse_common_actions_synapse_activatable_interface_init (SynapseActivatableIface * iface) {
	synapse_common_actions_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = synapse_common_actions_real_activate;
	iface->deactivate = synapse_common_actions_real_deactivate;
	iface->get_enabled = synapse_common_actions_real_get_enabled;
	iface->set_enabled = synapse_common_actions_real_set_enabled;
}


static void synapse_common_actions_synapse_action_provider_interface_init (SynapseActionProviderIface * iface) {
	synapse_common_actions_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_for_match = synapse_common_actions_real_find_for_match;
}


static void synapse_common_actions_instance_init (SynapseCommonActions * self) {
	self->priv = SYNAPSE_COMMON_ACTIONS_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_common_actions_finalize (GObject* obj) {
	SynapseCommonActions * self;
	self = SYNAPSE_COMMON_ACTIONS (obj);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (synapse_common_actions_parent_class)->finalize (obj);
}


GType synapse_common_actions_get_type (void) {
	static volatile gsize synapse_common_actions_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActions), 0, (GInstanceInitFunc) synapse_common_actions_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_common_actions_type_id;
		synapse_common_actions_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommonActions", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		g_once_init_leave (&synapse_common_actions_type_id__volatile, synapse_common_actions_type_id);
	}
	return synapse_common_actions_type_id__volatile;
}


static void synapse_common_actions_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseCommonActions * self;
	self = SYNAPSE_COMMON_ACTIONS (object);
	switch (property_id) {
		case SYNAPSE_COMMON_ACTIONS_ENABLED:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_common_actions_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseCommonActions * self;
	self = SYNAPSE_COMMON_ACTIONS (object);
	switch (property_id) {
		case SYNAPSE_COMMON_ACTIONS_ENABLED:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




