/* command-plugin.c generated by valac UNKNOWN, the Vala compiler
 * generated from command-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define SYNAPSE_TYPE_COMMAND_PLUGIN (synapse_command_plugin_get_type ())
#define SYNAPSE_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin))
#define SYNAPSE_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))
#define SYNAPSE_IS_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_IS_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_COMMAND_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))

typedef struct _SynapseCommandPlugin SynapseCommandPlugin;
typedef struct _SynapseCommandPluginClass SynapseCommandPluginClass;
typedef struct _SynapseCommandPluginPrivate SynapseCommandPluginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT (synapse_command_plugin_command_object_get_type ())
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))

typedef struct _SynapseCommandPluginCommandObject SynapseCommandPluginCommandObject;
typedef struct _SynapseCommandPluginCommandObjectClass SynapseCommandPluginCommandObjectClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseCommandPluginSearchData SynapseCommandPluginSearchData;
typedef struct _SynapseCommandPluginCommandObjectPrivate SynapseCommandPluginCommandObjectPrivate;

struct _SynapseCommandPlugin {
	SynapseDataPlugin parent_instance;
	SynapseCommandPluginPrivate * priv;
};

struct _SynapseCommandPluginClass {
	SynapseDataPluginClass parent_class;
};

struct _SynapseCommandPluginPrivate {
	GeeSet* past_commands;
	GRegex* split_regex;
};

struct _SynapseCommandPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseCommandPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseResultSet* _tmp0_;
	SynapseResultSet* _result_;
	gchar* _tmp1_;
	gchar* stripped;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _command_it;
	gboolean _tmp8_;
	gpointer _tmp9_;
	gchar* command;
	gboolean _tmp10_;
	SynapseCommandPluginCommandObject* _tmp11_;
	SynapseCommandPluginCommandObject* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp15_;
	gchar** args;
	gchar* _tmp16_;
	gchar* valid_cmd;
	SynapseCommandPluginCommandObject* _tmp17_;
	SynapseCommandPluginCommandObject* co;
	SynapseCommandPluginCommandObject* _tmp18_;
	SynapseCommandPluginCommandObject* _tmp19_;
	GError * _inner_error_;
};

struct _SynapseCommandPluginCommandObject {
	GObject parent_instance;
	SynapseCommandPluginCommandObjectPrivate * priv;
};

struct _SynapseCommandPluginCommandObjectClass {
	GObjectClass parent_class;
};

struct _SynapseCommandPluginCommandObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _command;
};


static gpointer synapse_command_plugin_parent_class = NULL;
static gpointer synapse_command_plugin_command_object_parent_class = NULL;
static SynapseMatchIface* synapse_command_plugin_command_object_synapse_match_parent_iface = NULL;
static SynapseApplicationMatchIface* synapse_command_plugin_command_object_synapse_application_match_parent_iface = NULL;

GType synapse_command_plugin_get_type (void) G_GNUC_CONST;
#define SYNAPSE_COMMAND_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginPrivate))
enum  {
	SYNAPSE_COMMAND_PLUGIN_DUMMY_PROPERTY
};
static void synapse_command_plugin_register_plugin (void);
static void _synapse_command_plugin_register_plugin_synapse_data_sink_plugin_registry_plugin_register_func (void);
static GType synapse_command_plugin_command_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommandPluginCommandObject* synapse_command_plugin_create_co (SynapseCommandPlugin* self, const gchar* exec);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_new (const gchar* cmd);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_construct (GType object_type, const gchar* cmd);
static void synapse_command_plugin_command_executed (SynapseCommandPlugin* self, SynapseMatch* match);
static const gchar* synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self);
static void synapse_command_plugin_real_search_data_free (gpointer _data);
static void synapse_command_plugin_real_search (SynapseDataPlugin* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_command_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* data);
static gboolean _synapse_command_plugin_real_search_co_gsource_func (gpointer self);
static void _synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender, gpointer self);
SynapseCommandPlugin* synapse_command_plugin_new (void);
SynapseCommandPlugin* synapse_command_plugin_construct (GType object_type);
static GObject * synapse_command_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectPrivate))
enum  {
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DUMMY_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND
};
static void synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self, const gchar* value);
static void synapse_command_plugin_command_object_finalize (GObject* obj);
static void _vala_synapse_command_plugin_command_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_command_plugin_command_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void synapse_command_plugin_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _synapse_command_plugin_register_plugin_synapse_data_sink_plugin_registry_plugin_register_func (void) {
	synapse_command_plugin_register_plugin ();
}


static void synapse_command_plugin_register_plugin (void) {
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("Find and execute arbitrary commands.");
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_COMMAND_PLUGIN, "Command Search", _tmp2_, "system-run", _synapse_command_plugin_register_plugin_synapse_data_sink_plugin_registry_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static SynapseCommandPluginCommandObject* synapse_command_plugin_create_co (SynapseCommandPlugin* self, const gchar* exec) {
	SynapseCommandPluginCommandObject* result = NULL;
	SynapseDesktopFileService* _tmp0_ = NULL;
	SynapseDesktopFileService* dfs;
	GeeList* _tmp1_ = NULL;
	GeeList* df_list;
	SynapseDesktopFileInfo* dfi;
	SynapseCommandPluginCommandObject* _tmp8_ = NULL;
	SynapseCommandPluginCommandObject* co;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exec != NULL, NULL);
	_tmp0_ = synapse_desktop_file_service_get_default ();
	dfs = _tmp0_;
	_tmp1_ = synapse_desktop_file_service_get_desktop_files_for_exec (dfs, exec);
	df_list = _tmp1_;
	dfi = NULL;
	{
		GeeList* _tmp2_;
		GeeList* _df_list;
		gint _tmp3_;
		gint _df_size;
		gint _df_index;
		_tmp2_ = _g_object_ref0 (df_list);
		_df_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _df_list);
		_df_size = _tmp3_;
		_df_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			SynapseDesktopFileInfo* df;
			gboolean _tmp5_;
			SynapseDesktopFileInfo* _tmp6_;
			SynapseDesktopFileInfo* _tmp7_;
			_df_index = _df_index + 1;
			if (!(_df_index < _df_size)) {
				break;
			}
			_tmp4_ = gee_list_get (_df_list, _df_index);
			df = (SynapseDesktopFileInfo*) _tmp4_;
			_tmp5_ = synapse_desktop_file_info_get_is_hidden (df);
			if (!_tmp5_) {
				result = NULL;
				_g_object_unref0 (df);
				_g_object_unref0 (_df_list);
				_g_object_unref0 (dfi);
				_g_object_unref0 (df_list);
				_g_object_unref0 (dfs);
				return result;
			}
			_tmp6_ = _g_object_ref0 (df);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (dfi);
			dfi = _tmp7_;
			_g_object_unref0 (df);
		}
		_g_object_unref0 (_df_list);
	}
	_tmp8_ = synapse_command_plugin_command_object_new (exec);
	co = _tmp8_;
	if (dfi != NULL) {
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
		_tmp9_ = synapse_desktop_file_info_get_name (dfi);
		synapse_match_set_title ((SynapseMatch*) co, _tmp9_);
		_tmp10_ = synapse_desktop_file_info_get_comment (dfi);
		if (g_strcmp0 (_tmp10_, "") != 0) {
			const gchar* _tmp11_ = NULL;
			_tmp11_ = synapse_desktop_file_info_get_comment (dfi);
			synapse_match_set_description ((SynapseMatch*) co, _tmp11_);
		}
		_tmp13_ = synapse_desktop_file_info_get_icon_name (dfi);
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = synapse_desktop_file_info_get_icon_name (dfi);
			_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = synapse_desktop_file_info_get_icon_name (dfi);
			synapse_match_set_icon_name ((SynapseMatch*) co, _tmp15_);
		}
	}
	result = co;
	_g_object_unref0 (dfi);
	_g_object_unref0 (df_list);
	_g_object_unref0 (dfs);
	return result;
}


static void synapse_command_plugin_command_executed (SynapseCommandPlugin* self, SynapseMatch* match) {
	SynapseMatch* _tmp0_;
	SynapseCommandPluginCommandObject* _tmp1_;
	SynapseCommandPluginCommandObject* co;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (match != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT (_tmp0_) ? ((SynapseCommandPluginCommandObject*) _tmp0_) : NULL));
	co = _tmp1_;
	if (co == NULL) {
		_g_object_unref0 (co);
		return;
	}
	_tmp2_ = synapse_command_plugin_command_object_get_command (co);
	gee_collection_add ((GeeCollection*) self->priv->past_commands, _tmp2_);
	_g_object_unref0 (co);
}


static void synapse_command_plugin_real_search_data_free (gpointer _data) {
	SynapseCommandPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->q);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseCommandPluginSearchData, data);
}


static void synapse_command_plugin_real_search (SynapseDataPlugin* base, SynapseQuery* q, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseCommandPlugin * self;
	SynapseCommandPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseCommandPlugin*) base;
	_data_ = g_slice_new0 (SynapseCommandPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_command_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_command_plugin_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->q = (synapse_query_copy (q, &_tmp0_), _tmp0_);
	synapse_command_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_command_plugin_real_search_finish (SynapseDataPlugin* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseCommandPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_command_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseCommandPluginSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_command_plugin_real_search_co (data);
}


static gboolean _synapse_command_plugin_real_search_co_gsource_func (gpointer self) {
	gboolean result;
	result = synapse_command_plugin_real_search_co (self);
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch6_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch6_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender, gpointer self) {
	synapse_command_plugin_command_executed (self, _sender);
}


static gboolean synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!((data->q.query_type & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
		data->result = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_command_plugin_real_search_co_gsource_func, data, NULL);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	data->_tmp0_ = NULL;
	data->_tmp0_ = synapse_result_set_new ();
	data->_result_ = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = string_strip (data->q.query_string);
	data->stripped = data->_tmp1_;
	if (g_strcmp0 (data->stripped, "") == 0) {
		data->result = NULL;
		_g_free0 (data->stripped);
		_g_object_unref0 (data->_result_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp2_ = g_str_has_prefix (data->stripped, "~/");
	if (data->_tmp2_) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_get_home_dir ();
		data->_tmp4_ = NULL;
		data->_tmp4_ = string_replace (data->stripped, "~", data->_tmp3_);
		data->_tmp5_ = data->_tmp4_;
		_g_free0 (data->stripped);
		data->stripped = data->_tmp5_;
	}
	data->_tmp6_ = gee_collection_contains ((GeeCollection*) data->self->priv->past_commands, data->stripped);
	if (!data->_tmp6_) {
		{
			data->_tmp7_ = NULL;
			data->_tmp7_ = gee_iterable_iterator ((GeeIterable*) data->self->priv->past_commands);
			data->_command_it = data->_tmp7_;
			while (TRUE) {
				data->_tmp8_ = gee_iterator_next (data->_command_it);
				if (!data->_tmp8_) {
					break;
				}
				data->_tmp9_ = NULL;
				data->_tmp9_ = gee_iterator_get (data->_command_it);
				data->command = (gchar*) data->_tmp9_;
				data->_tmp10_ = g_str_has_prefix (data->command, data->stripped);
				if (data->_tmp10_) {
					data->_tmp11_ = NULL;
					data->_tmp11_ = synapse_command_plugin_create_co (data->self, data->command);
					data->_tmp12_ = data->_tmp11_;
					synapse_result_set_add (data->_result_, (SynapseMatch*) data->_tmp12_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
					_g_object_unref0 (data->_tmp12_);
				}
				_g_free0 (data->command);
			}
			_g_object_unref0 (data->_command_it);
		}
		data->_tmp14_ = NULL;
		data->_tmp14_ = data->_tmp13_ = g_regex_split (data->self->priv->split_regex, data->stripped, 0);
		data->_tmp15_ = data->_tmp14_;
		data->args_length1 = _vala_array_length (data->_tmp13_);
		data->_args_size_ = data->args_length1;
		data->args = data->_tmp15_;
		data->_tmp16_ = NULL;
		data->_tmp16_ = g_find_program_in_path (data->args[0]);
		data->valid_cmd = data->_tmp16_;
		if (data->valid_cmd != NULL) {
			if (g_strcmp0 (data->args[0], "rm") == 0) {
				data->result = NULL;
				_g_free0 (data->valid_cmd);
				data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->stripped);
				_g_object_unref0 (data->_result_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			data->_tmp17_ = NULL;
			data->_tmp17_ = synapse_command_plugin_create_co (data->self, data->stripped);
			data->co = data->_tmp17_;
			if (data->co == NULL) {
				data->result = NULL;
				_g_object_unref0 (data->co);
				_g_free0 (data->valid_cmd);
				data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->stripped);
				_g_object_unref0 (data->_result_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			synapse_result_set_add (data->_result_, (SynapseMatch*) data->co, (gint) SYNAPSE_MATCH_SCORE_POOR);
			g_signal_connect_object ((SynapseMatch*) data->co, "executed", (GCallback) _synapse_command_plugin_command_executed_synapse_match_executed, data->self, 0);
			_g_object_unref0 (data->co);
		}
		_g_free0 (data->valid_cmd);
		data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
	} else {
		data->_tmp18_ = NULL;
		data->_tmp18_ = synapse_command_plugin_create_co (data->self, data->stripped);
		data->_tmp19_ = data->_tmp18_;
		synapse_result_set_add (data->_result_, (SynapseMatch*) data->_tmp19_, (gint) SYNAPSE_MATCH_SCORE_VERY_GOOD);
		_g_object_unref0 (data->_tmp19_);
	}
	synapse_query_check_cancellable (&data->q, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->stripped);
			_g_object_unref0 (data->_result_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->stripped);
			_g_object_unref0 (data->_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_result_;
	_g_free0 (data->stripped);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_free0 (data->stripped);
	_g_object_unref0 (data->_result_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


SynapseCommandPlugin* synapse_command_plugin_construct (GType object_type) {
	SynapseCommandPlugin * self = NULL;
	self = (SynapseCommandPlugin*) synapse_data_plugin_construct (object_type);
	return self;
}


SynapseCommandPlugin* synapse_command_plugin_new (void) {
	return synapse_command_plugin_construct (SYNAPSE_TYPE_COMMAND_PLUGIN);
}


static GObject * synapse_command_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommandPlugin * self;
	GeeHashSet* _tmp0_ = NULL;
	GeeSet* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* _tmp4_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_command_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_COMMAND_PLUGIN (obj);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_tmp1_ = (GeeSet*) _tmp0_;
	_g_object_unref0 (self->priv->past_commands);
	self->priv->past_commands = _tmp1_;
	_tmp2_ = g_regex_new ("\\s+", G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch7_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp4_ = _tmp3_;
	_g_regex_unref0 (self->priv->split_regex);
	self->priv->split_regex = _tmp4_;
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("command-plugin.vala:89: %s", err->message);
		_g_error_free0 (err);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_construct (GType object_type, const gchar* cmd) {
	SynapseCommandPluginCommandObject * self = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GAppInfo* _tmp2_ = NULL;
	GAppInfo* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = _ ("Run command");
	_tmp1_ = g_str_has_prefix (cmd, "sudo ");
	self = (SynapseCommandPluginCommandObject*) g_object_new (object_type, "title", cmd, "description", _tmp0_, "command", cmd, "icon-name", "application-x-executable", "match-type", SYNAPSE_MATCH_TYPE_APPLICATION, "needs-terminal", _tmp1_, NULL);
	_tmp2_ = g_app_info_create_from_commandline (cmd, NULL, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, _tmp3_);
	goto __finally8;
	__catch8_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("command-plugin.vala:55: %s", err->message);
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_new (const gchar* cmd) {
	return synapse_command_plugin_command_object_construct (SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, cmd);
}


static const gchar* synapse_command_plugin_command_object_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_command_plugin_command_object_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseCommandPluginCommandObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_command_plugin_command_object_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_command_plugin_command_object_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseCommandPluginCommandObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_command_plugin_command_object_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_command_plugin_command_object_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseCommandPluginCommandObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_command_plugin_command_object_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_command_plugin_command_object_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_command_plugin_command_object_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_command_plugin_command_object_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseCommandPluginCommandObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp1_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_command_plugin_command_object_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_command_plugin_command_object_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static GAppInfo* synapse_command_plugin_command_object_real_get_app_info (SynapseApplicationMatch* base) {
	GAppInfo* result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_app_info;
	return result;
}


static void synapse_command_plugin_command_object_real_set_app_info (SynapseApplicationMatch* base, GAppInfo* value) {
	SynapseCommandPluginCommandObject* self;
	GAppInfo* _tmp0_;
	GAppInfo* _tmp1_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_app_info);
	self->priv->_app_info = _tmp1_;
	g_object_notify ((GObject *) self, "app-info");
}


static gboolean synapse_command_plugin_command_object_real_get_needs_terminal (SynapseApplicationMatch* base) {
	gboolean result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_needs_terminal;
	return result;
}


static void synapse_command_plugin_command_object_real_set_needs_terminal (SynapseApplicationMatch* base, gboolean value) {
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	self->priv->_needs_terminal = value;
	g_object_notify ((GObject *) self, "needs-terminal");
}


static const gchar* synapse_command_plugin_command_object_real_get_filename (SynapseApplicationMatch* base) {
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_filename;
	return result;
}


static void synapse_command_plugin_command_object_real_set_filename (SynapseApplicationMatch* base, const gchar* value) {
	SynapseCommandPluginCommandObject* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	g_object_notify ((GObject *) self, "filename");
}


static const gchar* synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_command;
	return result;
}


static void synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_command);
	self->priv->_command = _tmp1_;
	g_object_notify ((GObject *) self, "command");
}


static void synapse_command_plugin_command_object_class_init (SynapseCommandPluginCommandObjectClass * klass) {
	synapse_command_plugin_command_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseCommandPluginCommandObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_command_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_command_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_command_object_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE, "match-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO, "app-info");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL, "needs-terminal");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME, "filename");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND, g_param_spec_string ("command", "command", "command", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void synapse_command_plugin_command_object_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_command_plugin_command_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_command_plugin_command_object_real_get_title;
	iface->set_title = synapse_command_plugin_command_object_real_set_title;
	iface->get_description = synapse_command_plugin_command_object_real_get_description;
	iface->set_description = synapse_command_plugin_command_object_real_set_description;
	iface->get_icon_name = synapse_command_plugin_command_object_real_get_icon_name;
	iface->set_icon_name = synapse_command_plugin_command_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_command_plugin_command_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_command_plugin_command_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_command_plugin_command_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_command_plugin_command_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_command_plugin_command_object_real_get_match_type;
	iface->set_match_type = synapse_command_plugin_command_object_real_set_match_type;
}


static void synapse_command_plugin_command_object_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface) {
	synapse_command_plugin_command_object_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_app_info = synapse_command_plugin_command_object_real_get_app_info;
	iface->set_app_info = synapse_command_plugin_command_object_real_set_app_info;
	iface->get_needs_terminal = synapse_command_plugin_command_object_real_get_needs_terminal;
	iface->set_needs_terminal = synapse_command_plugin_command_object_real_set_needs_terminal;
	iface->get_filename = synapse_command_plugin_command_object_real_get_filename;
	iface->set_filename = synapse_command_plugin_command_object_real_set_filename;
}


static void synapse_command_plugin_command_object_instance_init (SynapseCommandPluginCommandObject * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
	self->priv->_app_info = NULL;
	self->priv->_needs_terminal = FALSE;
	self->priv->_filename = NULL;
}


static void synapse_command_plugin_command_object_finalize (GObject* obj) {
	SynapseCommandPluginCommandObject * self;
	self = SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_command);
	G_OBJECT_CLASS (synapse_command_plugin_command_object_parent_class)->finalize (obj);
}


static GType synapse_command_plugin_command_object_get_type (void) {
	static volatile gsize synapse_command_plugin_command_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_command_plugin_command_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginCommandObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_command_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPluginCommandObject), 0, (GInstanceInitFunc) synapse_command_plugin_command_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_command_plugin_command_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_command_plugin_command_object_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_command_plugin_command_object_type_id;
		synapse_command_plugin_command_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommandPluginCommandObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_command_plugin_command_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_command_plugin_command_object_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
		g_once_init_leave (&synapse_command_plugin_command_object_type_id__volatile, synapse_command_plugin_command_object_type_id);
	}
	return synapse_command_plugin_command_object_type_id__volatile;
}


static void _vala_synapse_command_plugin_command_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseCommandPluginCommandObject * self;
	self = SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO:
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL:
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME:
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND:
		g_value_set_string (value, synapse_command_plugin_command_object_get_command (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_command_plugin_command_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseCommandPluginCommandObject * self;
	self = SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT (object);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO:
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL:
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME:
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND:
		synapse_command_plugin_command_object_set_command (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void synapse_command_plugin_class_init (SynapseCommandPluginClass * klass) {
	synapse_command_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseCommandPluginPrivate));
	SYNAPSE_DATA_PLUGIN_CLASS (klass)->search = synapse_command_plugin_real_search;
	SYNAPSE_DATA_PLUGIN_CLASS (klass)->search_finish = synapse_command_plugin_real_search_finish;
	G_OBJECT_CLASS (klass)->constructor = synapse_command_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_finalize;
	synapse_command_plugin_register_plugin ();
}


static void synapse_command_plugin_instance_init (SynapseCommandPlugin * self) {
	self->priv = SYNAPSE_COMMAND_PLUGIN_GET_PRIVATE (self);
}


static void synapse_command_plugin_finalize (GObject* obj) {
	SynapseCommandPlugin * self;
	self = SYNAPSE_COMMAND_PLUGIN (obj);
	_g_object_unref0 (self->priv->past_commands);
	_g_regex_unref0 (self->priv->split_regex);
	G_OBJECT_CLASS (synapse_command_plugin_parent_class)->finalize (obj);
}


GType synapse_command_plugin_get_type (void) {
	static volatile gsize synapse_command_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_command_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPlugin), 0, (GInstanceInitFunc) synapse_command_plugin_instance_init, NULL };
		GType synapse_command_plugin_type_id;
		synapse_command_plugin_type_id = g_type_register_static (SYNAPSE_TYPE_DATA_PLUGIN, "SynapseCommandPlugin", &g_define_type_info, 0);
		g_once_init_leave (&synapse_command_plugin_type_id__volatile, synapse_command_plugin_type_id);
	}
	return synapse_command_plugin_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



