/* synapse-core.h generated by valac UNKNOWN, the Vala compiler, do not modify */


#ifndef __SYNAPSE_CORE_H__
#define __SYNAPSE_CORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <float.h>
#include <math.h>

G_BEGIN_DECLS


#define SYNAPSE_TYPE_DATA_PLUGIN (synapse_data_plugin_get_type ())
#define SYNAPSE_DATA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPlugin))
#define SYNAPSE_DATA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPluginClass))
#define SYNAPSE_IS_DATA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DATA_PLUGIN))
#define SYNAPSE_IS_DATA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DATA_PLUGIN))
#define SYNAPSE_DATA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPluginClass))

typedef struct _SynapseDataPlugin SynapseDataPlugin;
typedef struct _SynapseDataPluginClass SynapseDataPluginClass;
typedef struct _SynapseDataPluginPrivate SynapseDataPluginPrivate;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_ACTION_PLUGIN (synapse_action_plugin_get_type ())
#define SYNAPSE_ACTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPlugin))
#define SYNAPSE_ACTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPluginClass))
#define SYNAPSE_IS_ACTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PLUGIN))
#define SYNAPSE_IS_ACTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ACTION_PLUGIN))
#define SYNAPSE_ACTION_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPluginClass))

typedef struct _SynapseActionPlugin SynapseActionPlugin;
typedef struct _SynapseActionPluginClass SynapseActionPluginClass;
typedef struct _SynapseActionPluginPrivate SynapseActionPluginPrivate;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_COMMON_ACTIONS (synapse_common_actions_get_type ())
#define SYNAPSE_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions))
#define SYNAPSE_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))
#define SYNAPSE_IS_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_IS_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_COMMON_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))

typedef struct _SynapseCommonActions SynapseCommonActions;
typedef struct _SynapseCommonActionsClass SynapseCommonActionsClass;
typedef struct _SynapseCommonActionsPrivate SynapseCommonActionsPrivate;

#define SYNAPSE_TYPE_CONFIG_OBJECT (synapse_config_object_get_type ())
#define SYNAPSE_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObject))
#define SYNAPSE_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))
#define SYNAPSE_IS_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_IS_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_CONFIG_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))

typedef struct _SynapseConfigObject SynapseConfigObject;
typedef struct _SynapseConfigObjectClass SynapseConfigObjectClass;
typedef struct _SynapseConfigObjectPrivate SynapseConfigObjectPrivate;

#define SYNAPSE_TYPE_CONFIG_SERVICE (synapse_config_service_get_type ())
#define SYNAPSE_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService))
#define SYNAPSE_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))
#define SYNAPSE_IS_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_IS_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_CONFIG_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))

typedef struct _SynapseConfigService SynapseConfigService;
typedef struct _SynapseConfigServiceClass SynapseConfigServiceClass;
typedef struct _SynapseConfigServicePrivate SynapseConfigServicePrivate;

#define SYNAPSE_TYPE_SEARCH_ENGINE (synapse_search_engine_get_type ())
#define SYNAPSE_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_ENGINE, SynapseSearchEngine))
#define SYNAPSE_IS_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_ENGINE))
#define SYNAPSE_SEARCH_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_ENGINE, SynapseSearchEngineIface))

typedef struct _SynapseSearchEngine SynapseSearchEngine;
typedef struct _SynapseSearchEngineIface SynapseSearchEngineIface;

#define SYNAPSE_TYPE_DATA_SINK (synapse_data_sink_get_type ())
#define SYNAPSE_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSink))
#define SYNAPSE_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))
#define SYNAPSE_IS_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_IS_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_DATA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))

typedef struct _SynapseDataSink SynapseDataSink;
typedef struct _SynapseDataSinkClass SynapseDataSinkClass;
typedef struct _SynapseDataSinkPrivate SynapseDataSinkPrivate;

#define SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY (synapse_data_sink_plugin_registry_get_type ())
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))

typedef struct _SynapseDataSinkPluginRegistry SynapseDataSinkPluginRegistry;
typedef struct _SynapseDataSinkPluginRegistryClass SynapseDataSinkPluginRegistryClass;
typedef struct _SynapseDataSinkPluginRegistryPrivate SynapseDataSinkPluginRegistryPrivate;

#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO (synapse_data_sink_plugin_registry_plugin_info_get_type ())
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_PLUGIN_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, SynapseDataSinkPluginRegistryPluginInfo))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_PLUGIN_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, SynapseDataSinkPluginRegistryPluginInfoClass))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_IS_PLUGIN_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_IS_PLUGIN_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_PLUGIN_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, SynapseDataSinkPluginRegistryPluginInfoClass))

typedef struct _SynapseDataSinkPluginRegistryPluginInfo SynapseDataSinkPluginRegistryPluginInfo;
typedef struct _SynapseDataSinkPluginRegistryPluginInfoClass SynapseDataSinkPluginRegistryPluginInfoClass;
typedef struct _SynapseDataSinkPluginRegistryPluginInfoPrivate SynapseDataSinkPluginRegistryPluginInfoPrivate;

#define SYNAPSE_TYPE_FREE_DESKTOP_DBUS (synapse_free_desktop_dbus_get_type ())
#define SYNAPSE_FREE_DESKTOP_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS, SynapseFreeDesktopDBus))
#define SYNAPSE_IS_FREE_DESKTOP_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS))
#define SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS, SynapseFreeDesktopDBusIface))

typedef struct _SynapseFreeDesktopDBus SynapseFreeDesktopDBus;
typedef struct _SynapseFreeDesktopDBusIface SynapseFreeDesktopDBusIface;

#define SYNAPSE_TYPE_DBUS_NAME_CACHE (synapse_dbus_name_cache_get_type ())
#define SYNAPSE_DBUS_NAME_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DBUS_NAME_CACHE, SynapseDBusNameCache))
#define SYNAPSE_DBUS_NAME_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DBUS_NAME_CACHE, SynapseDBusNameCacheClass))
#define SYNAPSE_IS_DBUS_NAME_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DBUS_NAME_CACHE))
#define SYNAPSE_IS_DBUS_NAME_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DBUS_NAME_CACHE))
#define SYNAPSE_DBUS_NAME_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DBUS_NAME_CACHE, SynapseDBusNameCacheClass))

typedef struct _SynapseDBusNameCache SynapseDBusNameCache;
typedef struct _SynapseDBusNameCacheClass SynapseDBusNameCacheClass;
typedef struct _SynapseDBusNameCachePrivate SynapseDBusNameCachePrivate;

#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;
typedef struct _SynapseDesktopFileInfoPrivate SynapseDesktopFileInfoPrivate;

#define SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE (synapse_desktop_file_info_environment_type_get_type ())

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;
typedef struct _SynapseDesktopFileServicePrivate SynapseDesktopFileServicePrivate;

#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;

#define SYNAPSE_TYPE_EXTENDED_INFO (synapse_extended_info_get_type ())
#define SYNAPSE_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfo))
#define SYNAPSE_IS_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_EXTENDED_INFO))
#define SYNAPSE_EXTENDED_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfoIface))

typedef struct _SynapseExtendedInfo SynapseExtendedInfo;
typedef struct _SynapseExtendedInfoIface SynapseExtendedInfoIface;

#define SYNAPSE_TYPE_SEARCH_MATCH (synapse_search_match_get_type ())
#define SYNAPSE_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch))
#define SYNAPSE_IS_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_SEARCH_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchIface))

typedef struct _SynapseSearchMatch SynapseSearchMatch;
typedef struct _SynapseSearchMatchIface SynapseSearchMatchIface;

#define SYNAPSE_TYPE_DEFAULT_MATCH (synapse_default_match_get_type ())
#define SYNAPSE_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch))
#define SYNAPSE_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))
#define SYNAPSE_IS_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_IS_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_DEFAULT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))

typedef struct _SynapseDefaultMatch SynapseDefaultMatch;
typedef struct _SynapseDefaultMatchClass SynapseDefaultMatchClass;
typedef struct _SynapseDefaultMatchPrivate SynapseDefaultMatchPrivate;

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())

#define SYNAPSE_TYPE_RELEVANCY_BACKEND (synapse_relevancy_backend_get_type ())
#define SYNAPSE_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackend))
#define SYNAPSE_IS_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND))
#define SYNAPSE_RELEVANCY_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackendIface))

typedef struct _SynapseRelevancyBackend SynapseRelevancyBackend;
typedef struct _SynapseRelevancyBackendIface SynapseRelevancyBackendIface;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;
typedef struct _SynapseRelevancyServicePrivate SynapseRelevancyServicePrivate;
typedef struct _SynapseResultSetPrivate SynapseResultSetPrivate;

#define SYNAPSE_UTILS_TYPE_FILE_INFO (synapse_utils_file_info_get_type ())
#define SYNAPSE_UTILS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo))
#define SYNAPSE_UTILS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))
#define SYNAPSE_UTILS_IS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_IS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))

typedef struct _SynapseUtilsFileInfo SynapseUtilsFileInfo;
typedef struct _SynapseUtilsFileInfoClass SynapseUtilsFileInfoClass;
typedef struct _SynapseUtilsFileInfoPrivate SynapseUtilsFileInfoPrivate;

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 1,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 3,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 5,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 6,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 7,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 15,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFF | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseDataPlugin {
	GObject parent_instance;
	SynapseDataPluginPrivate * priv;
};

struct _SynapseDataPluginClass {
	GObjectClass parent_class;
	void (*search) (SynapseDataPlugin* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseDataPlugin* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_empty_query) (SynapseDataPlugin* self);
};

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH
} SynapseMatchType;

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseActionPlugin {
	SynapseDataPlugin parent_instance;
	SynapseActionPluginPrivate * priv;
};

struct _SynapseActionPluginClass {
	SynapseDataPluginClass parent_class;
	gboolean (*handles_unknown) (SynapseActionPlugin* self);
	SynapseResultSet* (*find_for_match) (SynapseActionPlugin* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*provides_data) (SynapseActionPlugin* self);
};

struct _SynapseCommonActions {
	SynapseActionPlugin parent_instance;
	SynapseCommonActionsPrivate * priv;
};

struct _SynapseCommonActionsClass {
	SynapseActionPluginClass parent_class;
};

struct _SynapseConfigObject {
	GObject parent_instance;
	SynapseConfigObjectPrivate * priv;
};

struct _SynapseConfigObjectClass {
	GObjectClass parent_class;
};

struct _SynapseConfigService {
	GObject parent_instance;
	SynapseConfigServicePrivate * priv;
};

struct _SynapseConfigServiceClass {
	GObjectClass parent_class;
};

struct _SynapseSearchEngineIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchEngine* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchEngine* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseDataSink {
	GObject parent_instance;
	SynapseDataSinkPrivate * priv;
};

struct _SynapseDataSinkClass {
	GObjectClass parent_class;
};

struct _SynapseDataSinkPluginRegistry {
	GObject parent_instance;
	SynapseDataSinkPluginRegistryPrivate * priv;
};

struct _SynapseDataSinkPluginRegistryClass {
	GObjectClass parent_class;
};

typedef void (*SynapseDataSinkPluginRegistryPluginRegisterFunc) ();
struct _SynapseDataSinkPluginRegistryPluginInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseDataSinkPluginRegistryPluginInfoPrivate * priv;
	GType plugin_type;
	gchar* title;
	gchar* description;
	gchar* icon_name;
	SynapseDataSinkPluginRegistryPluginRegisterFunc register_func;
	gboolean runnable;
	gchar* runnable_error;
};

struct _SynapseDataSinkPluginRegistryPluginInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseDataSinkPluginRegistryPluginInfo *self);
};

struct _SynapseFreeDesktopDBusIface {
	GTypeInterface parent_iface;
	void (*list_queued_owners) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_queued_owners_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_names) (SynapseFreeDesktopDBus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_activatable_names) (SynapseFreeDesktopDBus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_activatable_names_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*name_has_owner) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*name_has_owner_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
	void (*start_service_by_name) (SynapseFreeDesktopDBus* self, const gchar* name, guint32 flags, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint32 (*start_service_by_name_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
	void (*get_name_owner) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_name_owner_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseDBusNameCache {
	GObject parent_instance;
	SynapseDBusNameCachePrivate * priv;
};

struct _SynapseDBusNameCacheClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileInfo {
	GObject parent_instance;
	SynapseDesktopFileInfoPrivate * priv;
	gchar** mime_types;
	gint mime_types_length1;
};

struct _SynapseDesktopFileInfoClass {
	GObjectClass parent_class;
};

typedef enum  {
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME = 1 << 0,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE = 1 << 1,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE = 1 << 2,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX = 1 << 3,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE = 1 << 4,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD = 1 << 5,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL = 0x3F
} SynapseDesktopFileInfoEnvironmentType;

struct _SynapseDesktopFileService {
	GObject parent_instance;
	SynapseDesktopFileServicePrivate * priv;
};

struct _SynapseDesktopFileServiceClass {
	GObjectClass parent_class;
};

typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 200,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 500,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 1000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 2000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 1500,
	SYNAPSE_MATCH_SCORE_POOR = 5000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 6000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 7000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 7500,
	SYNAPSE_MATCH_SCORE_GOOD = 8000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 8500,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 9000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 10000
} SynapseMatchScore;

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseExtendedInfoIface {
	GTypeInterface parent_iface;
	const gchar* (*get_extended_info) (SynapseExtendedInfo* self);
	void (*set_extended_info) (SynapseExtendedInfo* self, const gchar* value);
};

struct _SynapseSearchMatchIface {
	GTypeInterface parent_iface;
};

struct _SynapseDefaultMatch {
	GObject parent_instance;
	SynapseDefaultMatchPrivate * priv;
};

struct _SynapseDefaultMatchClass {
	GObjectClass parent_class;
};

typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

struct _SynapseRelevancyBackendIface {
	GTypeInterface parent_iface;
	gfloat (*get_application_popularity) (SynapseRelevancyBackend* self, const gchar* desktop_id);
	gfloat (*get_uri_popularity) (SynapseRelevancyBackend* self, const gchar* uri);
	void (*application_launched) (SynapseRelevancyBackend* self, GAppInfo* app_info);
};

struct _SynapseRelevancyService {
	GObject parent_instance;
	SynapseRelevancyServicePrivate * priv;
};

struct _SynapseRelevancyServiceClass {
	GObjectClass parent_class;
};

struct _SynapseResultSet {
	GObject parent_instance;
	SynapseResultSetPrivate * priv;
	GeeMap* matches;
	GeeSet* uris;
};

struct _SynapseResultSetClass {
	GObjectClass parent_class;
};

struct _SynapseUtilsFileInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsFileInfoPrivate * priv;
	gchar* uri;
	gchar* parse_name;
	SynapseQueryFlags file_type;
	SynapseUriMatch* match_obj;
};

struct _SynapseUtilsFileInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsFileInfo *self);
};


GType synapse_data_plugin_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self, SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_action_plugin_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_common_actions_get_type (void) G_GNUC_CONST;
SynapseCommonActions* synapse_common_actions_new (void);
SynapseCommonActions* synapse_common_actions_construct (GType object_type);
GType synapse_config_object_get_type (void) G_GNUC_CONST;
SynapseConfigObject* synapse_config_object_construct (GType object_type);
GType synapse_config_service_get_type (void) G_GNUC_CONST;
SynapseConfigService* synapse_config_service_get_default (void);
SynapseConfigObject* synapse_config_service_get_config (SynapseConfigService* self, const gchar* group, const gchar* key, GType config_type);
SynapseConfigObject* synapse_config_service_bind_config (SynapseConfigService* self, const gchar* group, const gchar* key, GType config_type);
void synapse_config_service_set_config (SynapseConfigService* self, const gchar* group, const gchar* key, SynapseConfigObject* cfg_obj);
void synapse_config_service_save (SynapseConfigService* self);
GType synapse_search_engine_get_type (void) G_GNUC_CONST;
void synapse_search_engine_search (SynapseSearchEngine* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* synapse_search_engine_search_finish (SynapseSearchEngine* self, GAsyncResult* _res_, GError** error);
GType synapse_data_sink_get_type (void) G_GNUC_CONST;
SynapseDataSink* synapse_data_sink_new (void);
SynapseDataSink* synapse_data_sink_construct (GType object_type);
void synapse_data_sink_register_plugin (SynapseDataSink* self, SynapseDataPlugin* plugin);
void synapse_data_sink_register_static_plugin (SynapseDataSink* self, GType plugin_type);
SynapseDataPlugin* synapse_data_sink_get_plugin (SynapseDataSink* self, const gchar* name);
gboolean synapse_data_sink_is_plugin_enabled (SynapseDataSink* self, GType plugin_type);
void synapse_data_sink_set_plugin_enabled (SynapseDataSink* self, GType plugin_type, gboolean enabled);
GeeList* synapse_data_sink_find_actions_for_unknown_match (SynapseDataSink* self, SynapseMatch* match, SynapseQueryFlags flags);
GeeList* synapse_data_sink_find_actions_for_match (SynapseDataSink* self, SynapseMatch* match, const gchar* query, SynapseQueryFlags flags);
GType synapse_data_sink_plugin_registry_get_type (void) G_GNUC_CONST;
extern SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_instance;
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_get_default (void);
void synapse_data_sink_plugin_registry_register_plugin (SynapseDataSinkPluginRegistry* self, GType plugin_type, const gchar* title, const gchar* description, const gchar* icon_name, SynapseDataSinkPluginRegistryPluginRegisterFunc reg_func, gboolean runnable, const gchar* runnable_error);
gpointer synapse_data_sink_plugin_registry_plugin_info_ref (gpointer instance);
void synapse_data_sink_plugin_registry_plugin_info_unref (gpointer instance);
GParamSpec* synapse_data_sink_plugin_registry_param_spec_plugin_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void synapse_data_sink_plugin_registry_value_set_plugin_info (GValue* value, gpointer v_object);
void synapse_data_sink_plugin_registry_value_take_plugin_info (GValue* value, gpointer v_object);
gpointer synapse_data_sink_plugin_registry_value_get_plugin_info (const GValue* value);
GType synapse_data_sink_plugin_registry_plugin_info_get_type (void) G_GNUC_CONST;
GeeList* synapse_data_sink_plugin_registry_get_plugins (SynapseDataSinkPluginRegistry* self);
SynapseDataSinkPluginRegistryPluginInfo* synapse_data_sink_plugin_registry_get_plugin_info_for_type (SynapseDataSinkPluginRegistry* self, GType plugin_type);
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_new (void);
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_construct (GType object_type);
SynapseDataSinkPluginRegistryPluginInfo* synapse_data_sink_plugin_registry_plugin_info_new (GType type, const gchar* title, const gchar* desc, const gchar* icon_name, SynapseDataSinkPluginRegistryPluginRegisterFunc reg_func, gboolean runnable, const gchar* runnable_error);
SynapseDataSinkPluginRegistryPluginInfo* synapse_data_sink_plugin_registry_plugin_info_construct (GType object_type, GType type, const gchar* title, const gchar* desc, const gchar* icon_name, SynapseDataSinkPluginRegistryPluginRegisterFunc reg_func, gboolean runnable, const gchar* runnable_error);
SynapseFreeDesktopDBus* synapse_free_desktop_dbus_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType synapse_free_desktop_dbus_get_type (void) G_GNUC_CONST;
void synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_queued_owners_finish (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
void synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_names_finish (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
void synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_activatable_names_finish (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
void synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_free_desktop_dbus_name_has_owner_finish (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
void synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self, const gchar* name, guint32 flags, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint32 synapse_free_desktop_dbus_start_service_by_name_finish (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
void synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* synapse_free_desktop_dbus_get_name_owner_finish (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
#define SYNAPSE_FREE_DESKTOP_DBUS_UNIQUE_NAME "org.freedesktop.DBus"
#define SYNAPSE_FREE_DESKTOP_DBUS_OBJECT_PATH "/org/freedesktop/DBus"
#define SYNAPSE_FREE_DESKTOP_DBUS_INTERFACE_NAME "org.freedesktop.DBus"
GType synapse_dbus_name_cache_get_type (void) G_GNUC_CONST;
SynapseDBusNameCache* synapse_dbus_name_cache_get_default (void);
gboolean synapse_dbus_name_cache_name_has_owner (SynapseDBusNameCache* self, const gchar* name);
gboolean synapse_dbus_name_cache_name_is_activatable (SynapseDBusNameCache* self, const gchar* name);
gboolean synapse_dbus_name_cache_service_is_available (SynapseDBusNameCache* self, const gchar* name);
gboolean synapse_dbus_name_cache_get_initialized (SynapseDBusNameCache* self);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
GType synapse_desktop_file_info_environment_type_get_type (void) G_GNUC_CONST;
const gchar* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const gchar* path, GKeyFile* keyfile);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type, const gchar* path, GKeyFile* keyfile);
SynapseDesktopFileInfo* synapse_desktop_file_info_new (void);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type);
const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self, const gchar* value);
const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self, const gchar* value);
const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self, const gchar* value);
gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self, gboolean value);
const gchar* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self, const gchar* value);
const gchar* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self, const gchar* value);
gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self, SynapseDesktopFileInfoEnvironmentType value);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self, const gchar* mime_type);
GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self, const gchar* exec);
SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self, const gchar* desktop_id);
gboolean synapse_desktop_file_service_get_initialized (SynapseDesktopFileService* self);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
void synapse_match_execute (SynapseMatch* self, SynapseMatch* match);
const gchar* synapse_match_get_title (SynapseMatch* self);
void synapse_match_set_title (SynapseMatch* self, const gchar* value);
const gchar* synapse_match_get_description (SynapseMatch* self);
void synapse_match_set_description (SynapseMatch* self, const gchar* value);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
void synapse_match_set_icon_name (SynapseMatch* self, const gchar* value);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
void synapse_match_set_has_thumbnail (SynapseMatch* self, gboolean value);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
void synapse_match_set_thumbnail_path (SynapseMatch* self, const gchar* value);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
void synapse_match_set_match_type (SynapseMatch* self, SynapseMatchType value);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
void synapse_application_match_set_app_info (SynapseApplicationMatch* self, GAppInfo* value);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self, gboolean value);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
void synapse_application_match_set_filename (SynapseApplicationMatch* self, const gchar* value);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
void synapse_uri_match_set_uri (SynapseUriMatch* self, const gchar* value);
SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self);
void synapse_uri_match_set_file_type (SynapseUriMatch* self, SynapseQueryFlags value);
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self, const gchar* value);
GType synapse_extended_info_get_type (void) G_GNUC_CONST;
const gchar* synapse_extended_info_get_extended_info (SynapseExtendedInfo* self);
void synapse_extended_info_set_extended_info (SynapseExtendedInfo* self, const gchar* value);
GType synapse_search_match_get_type (void) G_GNUC_CONST;
GType synapse_default_match_get_type (void) G_GNUC_CONST;
SynapseDefaultMatch* synapse_default_match_new (const gchar* query_string);
SynapseDefaultMatch* synapse_default_match_construct (GType object_type, const gchar* query_string);
void synapse_data_plugin_search (SynapseDataPlugin* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
SynapseResultSet* synapse_data_plugin_search_finish (SynapseDataPlugin* self, GAsyncResult* _res_, GError** error);
gboolean synapse_data_plugin_handles_empty_query (SynapseDataPlugin* self);
SynapseDataPlugin* synapse_data_plugin_construct (GType object_type);
SynapseDataSink* synapse_data_plugin_get_data_sink (SynapseDataPlugin* self);
gboolean synapse_data_plugin_get_enabled (SynapseDataPlugin* self);
void synapse_data_plugin_set_enabled (SynapseDataPlugin* self, gboolean value);
gboolean synapse_action_plugin_handles_unknown (SynapseActionPlugin* self);
SynapseResultSet* synapse_action_plugin_find_for_match (SynapseActionPlugin* self, SynapseQuery* query, SynapseMatch* match);
gboolean synapse_action_plugin_provides_data (SynapseActionPlugin* self);
SynapseActionPlugin* synapse_action_plugin_construct (GType object_type);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
void synapse_query_init (SynapseQuery *self, guint query_id, const gchar* query, SynapseQueryFlags flags, guint num_results);
gboolean synapse_query_is_cancelled (SynapseQuery *self);
void synapse_query_check_cancellable (SynapseQuery *self, GError** error);
GeeList* synapse_query_get_matchers_for_query (const gchar* query, SynapseMatcherFlags match_flags, GRegexCompileFlags flags);
GType synapse_relevancy_backend_get_type (void) G_GNUC_CONST;
gfloat synapse_relevancy_backend_get_application_popularity (SynapseRelevancyBackend* self, const gchar* desktop_id);
gfloat synapse_relevancy_backend_get_uri_popularity (SynapseRelevancyBackend* self, const gchar* uri);
void synapse_relevancy_backend_application_launched (SynapseRelevancyBackend* self, GAppInfo* app_info);
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
gfloat synapse_relevancy_service_get_application_popularity (SynapseRelevancyService* self, const gchar* desktop_id);
gfloat synapse_relevancy_service_get_uri_popularity (SynapseRelevancyService* self, const gchar* uri);
void synapse_relevancy_service_application_launched (SynapseRelevancyService* self, GAppInfo* app_info);
gint synapse_relevancy_service_compute_relevancy (gint base_relevancy, gfloat modifier);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
void synapse_result_set_add (SynapseResultSet* self, SynapseMatch* match, gint relevancy);
void synapse_result_set_add_all (SynapseResultSet* self, SynapseResultSet* rs);
gboolean synapse_result_set_contains_uri (SynapseResultSet* self, const gchar* uri);
GeeList* synapse_result_set_get_sorted_list (SynapseResultSet* self);
gint synapse_result_set_get_size (SynapseResultSet* self);
GeeSet* synapse_result_set_get_keys (SynapseResultSet* self);
GeeSet* synapse_result_set_get_entries (SynapseResultSet* self);
gchar* synapse_utils_remove_accents (const gchar* input);
void synapse_utils_query_exists_async (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
gpointer synapse_utils_file_info_ref (gpointer instance);
void synapse_utils_file_info_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_file_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void synapse_utils_value_set_file_info (GValue* value, gpointer v_object);
void synapse_utils_value_take_file_info (GValue* value, gpointer v_object);
gpointer synapse_utils_value_get_file_info (const GValue* value);
GType synapse_utils_file_info_get_type (void) G_GNUC_CONST;
SynapseUtilsFileInfo* synapse_utils_file_info_new (const gchar* uri, GType obj_type);
SynapseUtilsFileInfo* synapse_utils_file_info_construct (GType object_type, const gchar* uri, GType obj_type);
gboolean synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self);
void synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_);
void synapse_utils_file_info_exists (SynapseUtilsFileInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self, GAsyncResult* _res_);


G_END_DECLS

#endif
