/* query.c generated by valac UNKNOWN, the Vala compiler
 * generated from query.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 1,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 3,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 5,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 6,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 7,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 15,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFF | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 200,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 500,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 1000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 2000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 1500,
	SYNAPSE_MATCH_SCORE_POOR = 5000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 6000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 7000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 7500,
	SYNAPSE_MATCH_SCORE_GOOD = 8000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 8500,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 9000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 10000
} SynapseMatchScore;



GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self, SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
void synapse_query_init (SynapseQuery *self, guint query_id, const gchar* query, SynapseQueryFlags flags, guint num_results);
gboolean synapse_query_is_cancelled (SynapseQuery *self);
GQuark synapse_search_error_quark (void);
void synapse_query_check_cancellable (SynapseQuery *self, GError** error);
GeeList* synapse_query_get_matchers_for_query (const gchar* query, SynapseMatcherFlags match_flags, GRegexCompileFlags flags);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static gint _lambda7_ (gconstpointer a, gconstpointer b);
static gint __lambda7__gcompare_func (gconstpointer a, gconstpointer b);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType synapse_query_flags_get_type (void) {
	static volatile gsize synapse_query_flags_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_query_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE, "SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE", "include-remote"}, {SYNAPSE_QUERY_FLAGS_APPLICATIONS, "SYNAPSE_QUERY_FLAGS_APPLICATIONS", "applications"}, {SYNAPSE_QUERY_FLAGS_ACTIONS, "SYNAPSE_QUERY_FLAGS_ACTIONS", "actions"}, {SYNAPSE_QUERY_FLAGS_AUDIO, "SYNAPSE_QUERY_FLAGS_AUDIO", "audio"}, {SYNAPSE_QUERY_FLAGS_VIDEO, "SYNAPSE_QUERY_FLAGS_VIDEO", "video"}, {SYNAPSE_QUERY_FLAGS_DOCUMENTS, "SYNAPSE_QUERY_FLAGS_DOCUMENTS", "documents"}, {SYNAPSE_QUERY_FLAGS_IMAGES, "SYNAPSE_QUERY_FLAGS_IMAGES", "images"}, {SYNAPSE_QUERY_FLAGS_INTERNET, "SYNAPSE_QUERY_FLAGS_INTERNET", "internet"}, {SYNAPSE_QUERY_FLAGS_UNCATEGORIZED, "SYNAPSE_QUERY_FLAGS_UNCATEGORIZED", "uncategorized"}, {SYNAPSE_QUERY_FLAGS_ALL, "SYNAPSE_QUERY_FLAGS_ALL", "all"}, {SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT, "SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT", "local-content"}, {0, NULL, NULL}};
		GType synapse_query_flags_type_id;
		synapse_query_flags_type_id = g_flags_register_static ("SynapseQueryFlags", values);
		g_once_init_leave (&synapse_query_flags_type_id__volatile, synapse_query_flags_type_id);
	}
	return synapse_query_flags_type_id__volatile;
}


GType synapse_matcher_flags_get_type (void) {
	static volatile gsize synapse_matcher_flags_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_matcher_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{SYNAPSE_MATCHER_FLAGS_NO_REVERSED, "SYNAPSE_MATCHER_FLAGS_NO_REVERSED", "no-reversed"}, {SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING, "SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING", "no-substring"}, {SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, "SYNAPSE_MATCHER_FLAGS_NO_PARTIAL", "no-partial"}, {SYNAPSE_MATCHER_FLAGS_NO_FUZZY, "SYNAPSE_MATCHER_FLAGS_NO_FUZZY", "no-fuzzy"}, {0, NULL, NULL}};
		GType synapse_matcher_flags_type_id;
		synapse_matcher_flags_type_id = g_flags_register_static ("SynapseMatcherFlags", values);
		g_once_init_leave (&synapse_matcher_flags_type_id__volatile, synapse_matcher_flags_type_id);
	}
	return synapse_matcher_flags_type_id__volatile;
}


void synapse_query_init (SynapseQuery *self, guint query_id, const gchar* query, SynapseQueryFlags flags, guint num_results) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (query != NULL);
	memset (self, 0, sizeof (SynapseQuery));
	(*self).query_id = query_id;
	_tmp0_ = g_strdup (query);
	_tmp1_ = _tmp0_;
	_g_free0 ((*self).query_string);
	(*self).query_string = _tmp1_;
	_tmp2_ = g_utf8_casefold (query, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_g_free0 ((*self).query_string_folded);
	(*self).query_string_folded = _tmp3_;
	(*self).query_type = flags;
	(*self).max_results = num_results;
}


gboolean synapse_query_is_cancelled (SynapseQuery *self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	_tmp0_ = g_cancellable_is_cancelled ((*self).cancellable);
	result = _tmp0_;
	return result;
}


void synapse_query_check_cancellable (SynapseQuery *self, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_cancellable_is_cancelled ((*self).cancellable);
	if (_tmp0_) {
		GError* _tmp1_ = NULL;
		_tmp1_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint _lambda7_ (gconstpointer a, gconstpointer b) {
	gint result = 0;
	GeeMapEntry* e1;
	GeeMapEntry* e2;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	e1 = GEE_MAP_ENTRY (a);
	e2 = GEE_MAP_ENTRY (b);
	_tmp0_ = gee_map_entry_get_value (e2);
	_tmp1_ = gee_map_entry_get_value (e1);
	result = GPOINTER_TO_INT (_tmp0_) - GPOINTER_TO_INT (_tmp1_);
	return result;
}


static gint __lambda7__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = _lambda7_ (a, b);
	return result;
}


GeeList* synapse_query_get_matchers_for_query (const gchar* query, SynapseMatcherFlags match_flags, GRegexCompileFlags flags) {
	GeeList* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* results;
	GRegex* re;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GRegex* _tmp5_ = NULL;
	GRegex* _tmp6_;
	GRegex* _tmp7_;
	GRegex* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	GRegex* _tmp13_ = NULL;
	GRegex* _tmp14_;
	GRegex* _tmp15_;
	GRegex* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	GRegex* _tmp21_ = NULL;
	GRegex* _tmp22_;
	GRegex* _tmp23_;
	GRegex* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_;
	gint individual_words_length1;
	gint _individual_words_size_;
	gchar** _tmp30_;
	gchar** individual_words;
	gchar** _tmp67_;
	gchar** _tmp68_ = NULL;
	gint individual_chars_length1;
	gint _individual_chars_size_;
	gchar** _tmp69_;
	gchar** individual_chars;
	gchar** _tmp70_ = NULL;
	gint escaped_chars_length1;
	gint _escaped_chars_size_;
	gchar** _tmp71_;
	gchar** escaped_chars;
	gboolean _tmp73_ = FALSE;
	gboolean _tmp74_ = FALSE;
	GeeArrayList* _tmp89_ = NULL;
	GeeArrayList* sorted_results;
	GeeSet* _tmp90_ = NULL;
	GeeSet* entries;
	GeeSet* _tmp91_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_REGEX, (GBoxedCopyFunc) g_regex_ref, g_regex_unref, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	results = _tmp0_;
	re = NULL;
	_tmp1_ = g_regex_escape_string (query, -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("^(%s)$", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_regex_new (_tmp4_, flags, 0, &_inner_error_);
	_tmp7_ = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _g_free0 (_tmp2_), _tmp6_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch13_g_regex_error;
		}
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = _tmp7_;
	_g_regex_unref0 (re);
	re = _tmp8_;
	gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) SYNAPSE_MATCH_SCORE_HIGHEST));
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = g_regex_escape_string (query, -1);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("^(%s)", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_regex_new (_tmp12_, flags, 0, &_inner_error_);
	_tmp15_ = (_tmp14_ = _tmp13_, _g_free0 (_tmp12_), _g_free0 (_tmp10_), _tmp14_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch14_g_regex_error;
		}
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp16_ = _tmp15_;
	_g_regex_unref0 (re);
	re = _tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) SYNAPSE_MATCH_SCORE_EXCELLENT));
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp17_ = g_regex_escape_string (query, -1);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("\\b(%s)", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_regex_new (_tmp20_, flags, 0, &_inner_error_);
	_tmp23_ = (_tmp22_ = _tmp21_, _g_free0 (_tmp20_), _g_free0 (_tmp18_), _tmp22_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch15_g_regex_error;
		}
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp24_ = _tmp23_;
	_g_regex_unref0 (re);
	re = _tmp24_;
	gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) SYNAPSE_MATCH_SCORE_VERY_GOOD));
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp25_ = string_strip (query);
	_tmp26_ = _tmp25_;
	_tmp28_ = _tmp27_ = g_regex_split_simple ("\\s+", _tmp26_, 0, 0);
	_tmp30_ = (_tmp29_ = _tmp28_, _g_free0 (_tmp26_), _tmp29_);
	individual_words_length1 = _vala_array_length (_tmp27_);
	_individual_words_size_ = individual_words_length1;
	individual_words = _tmp30_;
	if (individual_words_length1 >= 2) {
		gchar** _tmp31_ = NULL;
		gint escaped_words_length1;
		gint _escaped_words_size_;
		gchar** _tmp32_;
		gchar** escaped_words;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* pattern;
		GRegex* _tmp38_ = NULL;
		GRegex* _tmp39_;
		GRegex* _tmp40_;
		_tmp31_ = g_new0 (gchar*, 0 + 1);
		_tmp32_ = _tmp31_;
		escaped_words_length1 = 0;
		_escaped_words_size_ = escaped_words_length1;
		escaped_words = _tmp32_;
		{
			gchar** word_collection;
			int word_collection_length1;
			int word_it;
			word_collection = individual_words;
			word_collection_length1 = individual_words_length1;
			for (word_it = 0; word_it < individual_words_length1; word_it = word_it + 1) {
				const gchar* word;
				word = word_collection[word_it];
				{
					gchar* _tmp33_ = NULL;
					_tmp33_ = g_regex_escape_string (word, -1);
					_vala_array_add6 (&escaped_words, &escaped_words_length1, &_escaped_words_size_, _tmp33_);
				}
			}
		}
		_tmp34_ = g_strjoinv (").+\\b(", escaped_words);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("\\b(%s)", _tmp35_);
		pattern = (_tmp37_ = _tmp36_, _g_free0 (_tmp35_), _tmp37_);
		_tmp38_ = g_regex_new (pattern, flags, 0, &_inner_error_);
		_tmp39_ = _tmp38_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch16_g_regex_error;
			}
			_g_free0 (pattern);
			escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp40_ = _tmp39_;
		_g_regex_unref0 (re);
		re = _tmp40_;
		gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) SYNAPSE_MATCH_SCORE_GOOD));
		goto __finally16;
		__catch16_g_regex_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally16:
		if (_inner_error_ != NULL) {
			_g_free0 (pattern);
			escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_REVERSED) == SYNAPSE_MATCHER_FLAGS_NO_REVERSED)) {
			if (escaped_words_length1 == 2) {
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_;
				gchar* reversed;
				GRegex* _tmp45_ = NULL;
				GRegex* _tmp46_;
				GRegex* _tmp47_;
				_tmp41_ = g_strjoin (").+\\b(", escaped_words[1], escaped_words[0], NULL, NULL);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("\\b(%s)", _tmp42_);
				reversed = (_tmp44_ = _tmp43_, _g_free0 (_tmp42_), _tmp44_);
				_tmp45_ = g_regex_new (reversed, flags, 0, &_inner_error_);
				_tmp46_ = _tmp45_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch17_g_regex_error;
					}
					_g_free0 (reversed);
					_g_free0 (pattern);
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
					_g_regex_unref0 (re);
					_g_object_unref0 (results);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp47_ = _tmp46_;
				_g_regex_unref0 (re);
				re = _tmp47_;
				gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) (SYNAPSE_MATCH_SCORE_GOOD - SYNAPSE_MATCH_SCORE_INCREMENT_MINOR)));
				goto __finally17;
				__catch17_g_regex_error:
				{
					GError * err;
					err = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (err);
				}
				__finally17:
				if (_inner_error_ != NULL) {
					_g_free0 (reversed);
					_g_free0 (pattern);
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
					_g_regex_unref0 (re);
					_g_object_unref0 (results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (reversed);
			} else {
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_;
				gchar* orred;
				gchar* _tmp52_;
				gchar* any_order;
				GRegex* _tmp56_ = NULL;
				GRegex* _tmp57_;
				GRegex* _tmp58_;
				_tmp48_ = g_strjoinv (")|(?:", escaped_words);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strdup_printf ("\\b((?:%s))", _tmp49_);
				orred = (_tmp51_ = _tmp50_, _g_free0 (_tmp49_), _tmp51_);
				_tmp52_ = g_strdup ("");
				any_order = _tmp52_;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp53_;
						_tmp53_ = TRUE;
						while (TRUE) {
							gboolean is_last;
							gchar* _tmp54_;
							if (!_tmp53_) {
								i++;
							}
							_tmp53_ = FALSE;
							if (!(i < escaped_words_length1)) {
								break;
							}
							is_last = i == (escaped_words_length1 - 1);
							_tmp54_ = g_strconcat (any_order, orred, NULL);
							_g_free0 (any_order);
							any_order = _tmp54_;
							if (!is_last) {
								gchar* _tmp55_;
								_tmp55_ = g_strconcat (any_order, ".+", NULL);
								_g_free0 (any_order);
								any_order = _tmp55_;
							}
						}
					}
				}
				_tmp56_ = g_regex_new (any_order, flags, 0, &_inner_error_);
				_tmp57_ = _tmp56_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch18_g_regex_error;
					}
					_g_free0 (any_order);
					_g_free0 (orred);
					_g_free0 (pattern);
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
					_g_regex_unref0 (re);
					_g_object_unref0 (results);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp58_ = _tmp57_;
				_g_regex_unref0 (re);
				re = _tmp58_;
				gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) (SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR)));
				goto __finally18;
				__catch18_g_regex_error:
				{
					GError * err;
					err = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (err);
				}
				__finally18:
				if (_inner_error_ != NULL) {
					_g_free0 (any_order);
					_g_free0 (orred);
					_g_free0 (pattern);
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
					_g_regex_unref0 (re);
					_g_object_unref0 (results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (any_order);
				_g_free0 (orred);
			}
		}
		_g_free0 (pattern);
		escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING) == SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING)) {
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_;
		GRegex* _tmp63_ = NULL;
		GRegex* _tmp64_;
		GRegex* _tmp65_;
		GRegex* _tmp66_;
		_tmp59_ = g_regex_escape_string (query, -1);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strdup_printf ("(%s)", _tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_regex_new (_tmp62_, flags, 0, &_inner_error_);
		_tmp65_ = (_tmp64_ = _tmp63_, _g_free0 (_tmp62_), _g_free0 (_tmp60_), _tmp64_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp66_ = _tmp65_;
		_g_regex_unref0 (re);
		re = _tmp66_;
		gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) SYNAPSE_MATCH_SCORE_AVERAGE));
		goto __finally19;
		__catch19_g_regex_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally19:
		if (_inner_error_ != NULL) {
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp68_ = _tmp67_ = g_regex_split_simple ("\\s*", query, 0, 0);
	_tmp69_ = _tmp68_;
	individual_chars_length1 = _vala_array_length (_tmp67_);
	_individual_chars_size_ = individual_chars_length1;
	individual_chars = _tmp69_;
	_tmp70_ = g_new0 (gchar*, 0 + 1);
	_tmp71_ = _tmp70_;
	escaped_chars_length1 = 0;
	_escaped_chars_size_ = escaped_chars_length1;
	escaped_chars = _tmp71_;
	{
		gchar** word_collection;
		int word_collection_length1;
		int word_it;
		word_collection = individual_chars;
		word_collection_length1 = individual_chars_length1;
		for (word_it = 0; word_it < individual_chars_length1; word_it = word_it + 1) {
			const gchar* word;
			word = word_collection[word_it];
			{
				gchar* _tmp72_ = NULL;
				_tmp72_ = g_regex_escape_string (word, -1);
				_vala_array_add7 (&escaped_chars, &escaped_chars_length1, &_escaped_chars_size_, _tmp72_);
			}
		}
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) == SYNAPSE_MATCHER_FLAGS_NO_PARTIAL)) {
		_tmp74_ = individual_words_length1 == 1;
	} else {
		_tmp74_ = FALSE;
	}
	if (_tmp74_) {
		_tmp73_ = individual_chars_length1 <= 5;
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_;
		gchar* pattern;
		GRegex* _tmp79_ = NULL;
		GRegex* _tmp80_;
		GRegex* _tmp81_;
		_tmp75_ = g_strjoinv (").+\\b(", escaped_chars);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strdup_printf ("\\b(%s)", _tmp76_);
		pattern = (_tmp78_ = _tmp77_, _g_free0 (_tmp76_), _tmp78_);
		_tmp79_ = g_regex_new (pattern, flags, 0, &_inner_error_);
		_tmp80_ = _tmp79_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch20_g_regex_error;
			}
			_g_free0 (pattern);
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp81_ = _tmp80_;
		_g_regex_unref0 (re);
		re = _tmp81_;
		gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE));
		goto __finally20;
		__catch20_g_regex_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally20:
		if (_inner_error_ != NULL) {
			_g_free0 (pattern);
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (pattern);
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_FUZZY) == SYNAPSE_MATCHER_FLAGS_NO_FUZZY)) {
		gchar* _tmp82_ = NULL;
		gchar* _tmp83_;
		gchar* _tmp84_ = NULL;
		gchar* _tmp85_;
		gchar* pattern;
		GRegex* _tmp86_ = NULL;
		GRegex* _tmp87_;
		GRegex* _tmp88_;
		_tmp82_ = g_strjoinv (").*(", escaped_chars);
		_tmp83_ = _tmp82_;
		_tmp84_ = g_strdup_printf ("\\b(%s)", _tmp83_);
		pattern = (_tmp85_ = _tmp84_, _g_free0 (_tmp83_), _tmp85_);
		_tmp86_ = g_regex_new (pattern, flags, 0, &_inner_error_);
		_tmp87_ = _tmp86_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch21_g_regex_error;
			}
			_g_free0 (pattern);
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp88_ = _tmp87_;
		_g_regex_unref0 (re);
		re = _tmp88_;
		gee_abstract_map_set ((GeeAbstractMap*) results, re, GINT_TO_POINTER ((gint) SYNAPSE_MATCH_SCORE_POOR));
		goto __finally21;
		__catch21_g_regex_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally21:
		if (_inner_error_ != NULL) {
			_g_free0 (pattern);
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (pattern);
	}
	_tmp89_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	sorted_results = _tmp89_;
	_tmp90_ = gee_map_get_entries ((GeeMap*) results);
	entries = _tmp90_;
	_tmp91_ = _g_object_ref0 (entries);
	g_object_set_data_full ((GObject*) sorted_results, "entries-ref", _tmp91_, g_object_unref);
	gee_abstract_collection_add_all ((GeeAbstractCollection*) sorted_results, (GeeCollection*) entries);
	gee_list_sort ((GeeList*) sorted_results, __lambda7__gcompare_func);
	result = (GeeList*) sorted_results;
	_g_object_unref0 (entries);
	escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
	individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
	individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
	_g_regex_unref0 (re);
	_g_object_unref0 (results);
	return result;
}


void synapse_query_copy (const SynapseQuery* self, SynapseQuery* dest) {
	dest->query_string = g_strdup (self->query_string);
	dest->query_string_folded = g_strdup (self->query_string_folded);
	dest->cancellable = _g_object_ref0 (self->cancellable);
	dest->query_type = self->query_type;
	dest->max_results = self->max_results;
	dest->query_id = self->query_id;
}


void synapse_query_destroy (SynapseQuery* self) {
	_g_free0 (self->query_string);
	_g_free0 (self->query_string_folded);
	_g_object_unref0 (self->cancellable);
}


SynapseQuery* synapse_query_dup (const SynapseQuery* self) {
	SynapseQuery* dup;
	dup = g_new0 (SynapseQuery, 1);
	synapse_query_copy (self, dup);
	return dup;
}


void synapse_query_free (SynapseQuery* self) {
	synapse_query_destroy (self);
	g_free (self);
}


GType synapse_query_get_type (void) {
	static volatile gsize synapse_query_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_query_type_id__volatile)) {
		GType synapse_query_type_id;
		synapse_query_type_id = g_boxed_type_register_static ("SynapseQuery", (GBoxedCopyFunc) synapse_query_dup, (GBoxedFreeFunc) synapse_query_free);
		g_once_init_leave (&synapse_query_type_id__volatile, synapse_query_type_id);
	}
	return synapse_query_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



