/* plugin.c generated by valac UNKNOWN, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define SYNAPSE_TYPE_DATA_PLUGIN (synapse_data_plugin_get_type ())
#define SYNAPSE_DATA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPlugin))
#define SYNAPSE_DATA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPluginClass))
#define SYNAPSE_IS_DATA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DATA_PLUGIN))
#define SYNAPSE_IS_DATA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DATA_PLUGIN))
#define SYNAPSE_DATA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPluginClass))

typedef struct _SynapseDataPlugin SynapseDataPlugin;
typedef struct _SynapseDataPluginClass SynapseDataPluginClass;
typedef struct _SynapseDataPluginPrivate SynapseDataPluginPrivate;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_DATA_SINK (synapse_data_sink_get_type ())
#define SYNAPSE_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSink))
#define SYNAPSE_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))
#define SYNAPSE_IS_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_IS_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_DATA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))

typedef struct _SynapseDataSink SynapseDataSink;
typedef struct _SynapseDataSinkClass SynapseDataSinkClass;

#define SYNAPSE_TYPE_ACTION_PLUGIN (synapse_action_plugin_get_type ())
#define SYNAPSE_ACTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPlugin))
#define SYNAPSE_ACTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPluginClass))
#define SYNAPSE_IS_ACTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PLUGIN))
#define SYNAPSE_IS_ACTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ACTION_PLUGIN))
#define SYNAPSE_ACTION_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPluginClass))

typedef struct _SynapseActionPlugin SynapseActionPlugin;
typedef struct _SynapseActionPluginClass SynapseActionPluginClass;
typedef struct _SynapseActionPluginPrivate SynapseActionPluginPrivate;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseActionPluginSearchData SynapseActionPluginSearchData;

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 1,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 3,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 5,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 6,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 7,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 15,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFF | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseDataPlugin {
	GObject parent_instance;
	SynapseDataPluginPrivate * priv;
};

struct _SynapseDataPluginClass {
	GObjectClass parent_class;
	void (*search) (SynapseDataPlugin* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseDataPlugin* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_empty_query) (SynapseDataPlugin* self);
};

struct _SynapseDataPluginPrivate {
	SynapseDataSink* _data_sink;
	gboolean _enabled;
};

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH
} SynapseMatchType;

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseActionPlugin {
	SynapseDataPlugin parent_instance;
	SynapseActionPluginPrivate * priv;
};

struct _SynapseActionPluginClass {
	SynapseDataPluginClass parent_class;
	gboolean (*handles_unknown) (SynapseActionPlugin* self);
	SynapseResultSet* (*find_for_match) (SynapseActionPlugin* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*provides_data) (SynapseActionPlugin* self);
};

struct _SynapseActionPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseActionPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
};


static gpointer synapse_data_plugin_parent_class = NULL;
static gpointer synapse_action_plugin_parent_class = NULL;

GType synapse_data_plugin_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self, SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_data_sink_get_type (void) G_GNUC_CONST;
#define SYNAPSE_DATA_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPluginPrivate))
enum  {
	SYNAPSE_DATA_PLUGIN_DUMMY_PROPERTY,
	SYNAPSE_DATA_PLUGIN_DATA_SINK,
	SYNAPSE_DATA_PLUGIN_ENABLED
};
void synapse_data_plugin_search (SynapseDataPlugin* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
SynapseResultSet* synapse_data_plugin_search_finish (SynapseDataPlugin* self, GAsyncResult* _res_, GError** error);
gboolean synapse_data_plugin_handles_empty_query (SynapseDataPlugin* self);
static gboolean synapse_data_plugin_real_handles_empty_query (SynapseDataPlugin* self);
SynapseDataPlugin* synapse_data_plugin_construct (GType object_type);
SynapseDataSink* synapse_data_plugin_get_data_sink (SynapseDataPlugin* self);
static void synapse_data_plugin_set_data_sink (SynapseDataPlugin* self, SynapseDataSink* value);
gboolean synapse_data_plugin_get_enabled (SynapseDataPlugin* self);
void synapse_data_plugin_set_enabled (SynapseDataPlugin* self, gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void synapse_data_plugin_finalize (GObject* obj);
static void _vala_synapse_data_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_data_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType synapse_action_plugin_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
enum  {
	SYNAPSE_ACTION_PLUGIN_DUMMY_PROPERTY
};
gboolean synapse_action_plugin_handles_unknown (SynapseActionPlugin* self);
static gboolean synapse_action_plugin_real_handles_unknown (SynapseActionPlugin* self);
SynapseResultSet* synapse_action_plugin_find_for_match (SynapseActionPlugin* self, SynapseQuery* query, SynapseMatch* match);
static SynapseResultSet* synapse_action_plugin_real_find_for_match (SynapseActionPlugin* self, SynapseQuery* query, SynapseMatch* match);
gboolean synapse_action_plugin_provides_data (SynapseActionPlugin* self);
static gboolean synapse_action_plugin_real_provides_data (SynapseActionPlugin* self);
static void synapse_action_plugin_real_search_data_free (gpointer _data);
static void synapse_action_plugin_real_search (SynapseDataPlugin* base, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_action_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_action_plugin_real_search_co (SynapseActionPluginSearchData* data);
SynapseActionPlugin* synapse_action_plugin_construct (GType object_type);


void synapse_data_plugin_search (SynapseDataPlugin* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SYNAPSE_DATA_PLUGIN_GET_CLASS (self)->search (self, query, _callback_, _user_data_);
}


SynapseResultSet* synapse_data_plugin_search_finish (SynapseDataPlugin* self, GAsyncResult* _res_, GError** error) {
	return SYNAPSE_DATA_PLUGIN_GET_CLASS (self)->search_finish (self, _res_, error);
}


static gboolean synapse_data_plugin_real_handles_empty_query (SynapseDataPlugin* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean synapse_data_plugin_handles_empty_query (SynapseDataPlugin* self) {
	return SYNAPSE_DATA_PLUGIN_GET_CLASS (self)->handles_empty_query (self);
}


SynapseDataPlugin* synapse_data_plugin_construct (GType object_type) {
	SynapseDataPlugin * self = NULL;
	self = (SynapseDataPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseDataSink* synapse_data_plugin_get_data_sink (SynapseDataPlugin* self) {
	SynapseDataSink* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_data_sink;
	return result;
}


static void synapse_data_plugin_set_data_sink (SynapseDataPlugin* self, SynapseDataSink* value) {
	g_return_if_fail (self != NULL);
	self->priv->_data_sink = value;
	g_object_notify ((GObject *) self, "data-sink");
}


gboolean synapse_data_plugin_get_enabled (SynapseDataPlugin* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enabled;
	return result;
}


void synapse_data_plugin_set_enabled (SynapseDataPlugin* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void synapse_data_plugin_class_init (SynapseDataPluginClass * klass) {
	synapse_data_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDataPluginPrivate));
	SYNAPSE_DATA_PLUGIN_CLASS (klass)->handles_empty_query = synapse_data_plugin_real_handles_empty_query;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_data_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_data_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_data_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_PLUGIN_DATA_SINK, g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_PLUGIN_ENABLED, g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("search_done", SYNAPSE_TYPE_DATA_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
}


static void synapse_data_plugin_instance_init (SynapseDataPlugin * self) {
	self->priv = SYNAPSE_DATA_PLUGIN_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
}


static void synapse_data_plugin_finalize (GObject* obj) {
	SynapseDataPlugin * self;
	self = SYNAPSE_DATA_PLUGIN (obj);
	G_OBJECT_CLASS (synapse_data_plugin_parent_class)->finalize (obj);
}


GType synapse_data_plugin_get_type (void) {
	static volatile gsize synapse_data_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_data_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDataPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataPlugin), 0, (GInstanceInitFunc) synapse_data_plugin_instance_init, NULL };
		GType synapse_data_plugin_type_id;
		synapse_data_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDataPlugin", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&synapse_data_plugin_type_id__volatile, synapse_data_plugin_type_id);
	}
	return synapse_data_plugin_type_id__volatile;
}


static void _vala_synapse_data_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDataPlugin * self;
	self = SYNAPSE_DATA_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_DATA_PLUGIN_DATA_SINK:
		g_value_set_object (value, synapse_data_plugin_get_data_sink (self));
		break;
		case SYNAPSE_DATA_PLUGIN_ENABLED:
		g_value_set_boolean (value, synapse_data_plugin_get_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_data_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDataPlugin * self;
	self = SYNAPSE_DATA_PLUGIN (object);
	switch (property_id) {
		case SYNAPSE_DATA_PLUGIN_DATA_SINK:
		synapse_data_plugin_set_data_sink (self, g_value_get_object (value));
		break;
		case SYNAPSE_DATA_PLUGIN_ENABLED:
		synapse_data_plugin_set_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gboolean synapse_action_plugin_real_handles_unknown (SynapseActionPlugin* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean synapse_action_plugin_handles_unknown (SynapseActionPlugin* self) {
	return SYNAPSE_ACTION_PLUGIN_GET_CLASS (self)->handles_unknown (self);
}


static SynapseResultSet* synapse_action_plugin_real_find_for_match (SynapseActionPlugin* self, SynapseQuery* query, SynapseMatch* match) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `synapse_action_plugin_find_for_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


SynapseResultSet* synapse_action_plugin_find_for_match (SynapseActionPlugin* self, SynapseQuery* query, SynapseMatch* match) {
	return SYNAPSE_ACTION_PLUGIN_GET_CLASS (self)->find_for_match (self, query, match);
}


static gboolean synapse_action_plugin_real_provides_data (SynapseActionPlugin* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean synapse_action_plugin_provides_data (SynapseActionPlugin* self) {
	return SYNAPSE_ACTION_PLUGIN_GET_CLASS (self)->provides_data (self);
}


static void synapse_action_plugin_real_search_data_free (gpointer _data) {
	SynapseActionPluginSearchData* data;
	data = _data;
	synapse_query_destroy (&data->query);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseActionPluginSearchData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void synapse_action_plugin_real_search (SynapseDataPlugin* base, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseActionPlugin * self;
	SynapseActionPluginSearchData* _data_;
	SynapseQuery _tmp0_ = {0};
	self = (SynapseActionPlugin*) base;
	_data_ = g_slice_new0 (SynapseActionPluginSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_action_plugin_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_action_plugin_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->query = (synapse_query_copy (query, &_tmp0_), _tmp0_);
	synapse_action_plugin_real_search_co (_data_);
}


static SynapseResultSet* synapse_action_plugin_real_search_finish (SynapseDataPlugin* base, GAsyncResult* _res_, GError** error) {
	SynapseResultSet* result;
	SynapseActionPluginSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void synapse_action_plugin_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseActionPluginSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_action_plugin_real_search_co (data);
}


static gboolean synapse_action_plugin_real_search_co (SynapseActionPluginSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_assert_not_reached ();
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


SynapseActionPlugin* synapse_action_plugin_construct (GType object_type) {
	SynapseActionPlugin * self = NULL;
	self = (SynapseActionPlugin*) synapse_data_plugin_construct (object_type);
	return self;
}


static void synapse_action_plugin_class_init (SynapseActionPluginClass * klass) {
	synapse_action_plugin_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_ACTION_PLUGIN_CLASS (klass)->handles_unknown = synapse_action_plugin_real_handles_unknown;
	SYNAPSE_ACTION_PLUGIN_CLASS (klass)->find_for_match = synapse_action_plugin_real_find_for_match;
	SYNAPSE_ACTION_PLUGIN_CLASS (klass)->provides_data = synapse_action_plugin_real_provides_data;
	SYNAPSE_DATA_PLUGIN_CLASS (klass)->search = synapse_action_plugin_real_search;
	SYNAPSE_DATA_PLUGIN_CLASS (klass)->search_finish = synapse_action_plugin_real_search_finish;
}


static void synapse_action_plugin_instance_init (SynapseActionPlugin * self) {
}


GType synapse_action_plugin_get_type (void) {
	static volatile gsize synapse_action_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_action_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseActionPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_action_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseActionPlugin), 0, (GInstanceInitFunc) synapse_action_plugin_instance_init, NULL };
		GType synapse_action_plugin_type_id;
		synapse_action_plugin_type_id = g_type_register_static (SYNAPSE_TYPE_DATA_PLUGIN, "SynapseActionPlugin", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&synapse_action_plugin_type_id__volatile, synapse_action_plugin_type_id);
	}
	return synapse_action_plugin_type_id__volatile;
}



