/* desktop-file-service.c generated by valac UNKNOWN, the Vala compiler
 * generated from desktop-file-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>


#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;
typedef struct _SynapseDesktopFileInfoPrivate SynapseDesktopFileInfoPrivate;

#define SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE (synapse_desktop_file_info_environment_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;
typedef struct _SynapseDesktopFileServicePrivate SynapseDesktopFileServicePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceInitializeData SynapseDesktopFileServiceInitializeData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _SynapseDesktopFileServiceProcessDirectoryData SynapseDesktopFileServiceProcessDirectoryData;
typedef struct _SynapseDesktopFileServiceLoadAllDesktopFilesData SynapseDesktopFileServiceLoadAllDesktopFilesData;
typedef struct _SynapseDesktopFileServiceReloadDesktopFilesData SynapseDesktopFileServiceReloadDesktopFilesData;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadDesktopFileData SynapseDesktopFileServiceLoadDesktopFileData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData SynapseDesktopFileServiceLoadMimeParentsFromFileData;

typedef enum  {
	SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY
} SynapseDesktopFileError;
#define SYNAPSE_DESKTOP_FILE_ERROR synapse_desktop_file_error_quark ()
struct _SynapseDesktopFileInfo {
	GObject parent_instance;
	SynapseDesktopFileInfoPrivate * priv;
	gchar** mime_types;
	gint mime_types_length1;
};

struct _SynapseDesktopFileInfoClass {
	GObjectClass parent_class;
};

typedef enum  {
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME = 1 << 0,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE = 1 << 1,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE = 1 << 2,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX = 1 << 3,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE = 1 << 4,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD = 1 << 5,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL = 0x3F
} SynapseDesktopFileInfoEnvironmentType;

struct _SynapseDesktopFileInfoPrivate {
	gchar* _name;
	gchar* _comment;
	gchar* _icon_name;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _exec;
	gboolean _is_hidden;
	gboolean _is_valid;
	gchar* name_folded;
	SynapseDesktopFileInfoEnvironmentType _show_in;
};

struct _SynapseDesktopFileService {
	GObject parent_instance;
	SynapseDesktopFileServicePrivate * priv;
};

struct _SynapseDesktopFileServiceClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileServicePrivate {
	gboolean _initialized;
	GeeList* directory_monitors;
	GeeList* all_desktop_files;
	GeeList* non_hidden_desktop_files;
	GeeMap* mimetype_map;
	GeeMap* exec_map;
	GeeMap* desktop_id_map;
	GeeMultiMap* mimetype_parent_map;
	SynapseDesktopFileInfoEnvironmentType session_type;
	gchar* session_type_str;
	guint timer_id;
};

struct _SynapseDesktopFileServiceInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
};

struct _SynapseDesktopFileServiceProcessDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
	GFile* directory;
	GeeSet* monitored_dirs;
	gchar* _tmp0_;
	gchar* path;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean exists;
	GFileEnumerator* _tmp4_;
	GFileEnumerator* enumerator;
	GList* _tmp5_;
	GList* files;
	GList* f_collection;
	GList* f_it;
	GFileInfo* _tmp6_;
	GFileInfo* f;
	const gchar* _tmp7_;
	const gchar* name;
	GFileType _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	gchar** _tmp4_;
	gchar** data_dirs;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeSet* desktop_file_dirs;
	gchar** data_dir_collection;
	int data_dir_collection_length1;
	int data_dir_it;
	const gchar* data_dir;
	gchar* _tmp8_;
	gchar* dir_path;
	GFile* _tmp9_;
	GFile* directory;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeList* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _d_it;
	gboolean _tmp15_;
	gpointer _tmp16_;
	GFile* d;
	GFileMonitor* _tmp17_;
	GFileMonitor* monitor;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceReloadDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
};

struct _SynapseDesktopFileServiceLoadDesktopFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
	GFile* file;
	gsize len;
	gchar* contents;
	gchar* _tmp0_;
	gsize _tmp1_;
	gboolean _tmp2_;
	gboolean success;
	GKeyFile* _tmp3_;
	GKeyFile* keyfile;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SynapseDesktopFileInfo* _tmp6_;
	SynapseDesktopFileInfo* _tmp7_;
	SynapseDesktopFileInfo* dfi;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	SynapseDesktopFileInfoEnvironmentType _tmp11_;
	GError * err;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SynapseDesktopFileService* self;
	gchar* fi;
	GFile* _tmp0_;
	GFile* file;
	gboolean _tmp1_;
	gboolean exists;
	GFileInputStream* _tmp2_;
	GFileInputStream* fis;
	GDataInputStream* _tmp3_;
	GDataInputStream* dis;
	gchar* line;
	gint mimes_length1;
	gint _mimes_size_;
	gchar** _tmp4_;
	gchar** mimes;
	gint len;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	guint _tmp12_;
	GError * err;
	GError * _inner_error_;
};


static gpointer synapse_desktop_file_info_parent_class = NULL;
static gpointer synapse_desktop_file_service_parent_class = NULL;
static SynapseDesktopFileService* synapse_desktop_file_service_instance;
static SynapseDesktopFileService* synapse_desktop_file_service_instance = NULL;

GQuark synapse_desktop_file_error_quark (void);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
GType synapse_desktop_file_info_environment_type_get_type (void) G_GNUC_CONST;
#define SYNAPSE_DESKTOP_FILE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoPrivate))
enum  {
	SYNAPSE_DESKTOP_FILE_INFO_DUMMY_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NAME,
	SYNAPSE_DESKTOP_FILE_INFO_COMMENT,
	SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME,
	SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL,
	SYNAPSE_DESKTOP_FILE_INFO_FILENAME,
	SYNAPSE_DESKTOP_FILE_INFO_EXEC,
	SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN,
	SYNAPSE_DESKTOP_FILE_INFO_IS_VALID,
	SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN
};
#define SYNAPSE_DESKTOP_FILE_INFO_GROUP "Desktop Entry"
const gchar* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const gchar* path, GKeyFile* keyfile);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type, const gchar* path, GKeyFile* keyfile);
static void synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self, GKeyFile* keyfile);
static SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self, gchar** environments, int environments_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self, const gchar* value);
void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self, const gchar* value);
static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self, gboolean value);
void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self, const gchar* value);
void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self, const gchar* value);
const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self, gboolean value);
void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self, SynapseDesktopFileInfoEnvironmentType value);
static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self, gboolean value);
SynapseDesktopFileInfo* synapse_desktop_file_info_new (void);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type);
const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self, const gchar* value);
const gchar* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_info_finalize (GObject* obj);
static void _vala_synapse_desktop_file_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_desktop_file_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServicePrivate))
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_DUMMY_PROPERTY,
	SYNAPSE_DESKTOP_FILE_SERVICE_INITIALIZED
};
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
static SynapseDesktopFileService* synapse_desktop_file_service_new (void);
static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type);
static void synapse_desktop_file_service_initialize_data_free (gpointer _data);
static void synapse_desktop_file_service_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* data);
static void synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static void synapse_desktop_file_service_set_initialized (SynapseDesktopFileService* self, gboolean value);
static void synapse_desktop_file_service_process_directory_data_free (gpointer _data);
static void synapse_desktop_file_service_process_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self, GFile* directory, GeeSet* monitored_dirs, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* data);
void synapse_utils_query_exists_async (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static void synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* data);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self, const gchar* fi, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static void synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self);
static void _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static gboolean _lambda1_ (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self, GAsyncResult* _res_);
static gboolean __lambda1__gsource_func (gpointer self);
static void synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* data);
static void synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data);
static void synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* data);
static void synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data);
static void synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* data);
static void synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self, const gchar* mime, GeeSet* ret);
GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self, const gchar* mime_type);
GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self, const gchar* exec);
SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self, const gchar* desktop_id);
gboolean synapse_desktop_file_service_get_initialized (SynapseDesktopFileService* self);
static GObject * synapse_desktop_file_service_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void synapse_desktop_file_service_finalize (GObject* obj);
static void _vala_synapse_desktop_file_service_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_synapse_desktop_file_service_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark synapse_desktop_file_error_quark (void) {
	return g_quark_from_static_string ("synapse_desktop_file_error-quark");
}


GType synapse_desktop_file_info_environment_type_get_type (void) {
	static volatile gsize synapse_desktop_file_info_environment_type_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_environment_type_type_id__volatile)) {
		static const GFlagsValue values[] = {{SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME", "gnome"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE", "kde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE", "lxde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX", "rox"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE", "xfce"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD", "old"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL", "all"}, {0, NULL, NULL}};
		GType synapse_desktop_file_info_environment_type_type_id;
		synapse_desktop_file_info_environment_type_type_id = g_flags_register_static ("SynapseDesktopFileInfoEnvironmentType", values);
		g_once_init_leave (&synapse_desktop_file_info_environment_type_type_id__volatile, synapse_desktop_file_info_environment_type_type_id);
	}
	return synapse_desktop_file_info_environment_type_type_id__volatile;
}


const gchar* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->name_folded == NULL) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = g_utf8_casefold (self->priv->_name, (gssize) (-1));
		_tmp1_ = _tmp0_;
		_g_free0 (self->priv->name_folded);
		self->priv->name_folded = _tmp1_;
	}
	result = self->priv->name_folded;
	return result;
}


SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type, const gchar* path, GKeyFile* keyfile) {
	SynapseDesktopFileInfo * self = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (keyfile != NULL, NULL);
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, "filename", path, NULL);
	synapse_desktop_file_info_init_from_keyfile (self, keyfile);
	return self;
}


SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const gchar* path, GKeyFile* keyfile) {
	return synapse_desktop_file_info_construct_for_keyfile (SYNAPSE_TYPE_DESKTOP_FILE_INFO, path, keyfile);
}


static SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self, gchar** environments, int environments_length1) {
	SynapseDesktopFileInfoEnvironmentType result = 0;
	SynapseDesktopFileInfoEnvironmentType _result_;
	g_return_val_if_fail (self != NULL, 0);
	_result_ = 0;
	{
		gchar** env_collection;
		int env_collection_length1;
		int env_it;
		env_collection = environments;
		env_collection_length1 = environments_length1;
		for (env_it = 0; env_it < environments_length1; env_it = env_it + 1) {
			const gchar* env;
			env = env_collection[env_it];
			{
				gchar* _tmp0_ = NULL;
				gchar* env_up;
				const gchar* _tmp1_;
				GQuark _tmp2_;
				static GQuark _tmp2__label0 = 0;
				static GQuark _tmp2__label1 = 0;
				static GQuark _tmp2__label2 = 0;
				static GQuark _tmp2__label3 = 0;
				static GQuark _tmp2__label4 = 0;
				static GQuark _tmp2__label5 = 0;
				_tmp0_ = g_utf8_strup (env, (gssize) (-1));
				env_up = _tmp0_;
				_tmp1_ = env_up;
				_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
				if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("GNOME")))) {
					switch (0) {
						default:
						{
							_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
							break;
						}
					}
				} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("KDE")))) {
					switch (0) {
						default:
						{
							_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
							break;
						}
					}
				} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("LXDE")))) {
					switch (0) {
						default:
						{
							_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
							break;
						}
					}
				} else if (_tmp2_ == ((0 != _tmp2__label3) ? _tmp2__label3 : (_tmp2__label3 = g_quark_from_static_string ("XFCE")))) {
					switch (0) {
						default:
						{
							_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
							break;
						}
					}
				} else if (_tmp2_ == ((0 != _tmp2__label4) ? _tmp2__label4 : (_tmp2__label4 = g_quark_from_static_string ("ROX")))) {
					switch (0) {
						default:
						{
							_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
							break;
						}
					}
				} else if (_tmp2_ == ((0 != _tmp2__label5) ? _tmp2__label5 : (_tmp2__label5 = g_quark_from_static_string ("OLD")))) {
					switch (0) {
						default:
						{
							_result_ = _result_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							g_warning ("desktop-file-service.vala:91: %s is not understood", env);
							break;
						}
					}
				}
				_g_free0 (env_up);
			}
		}
	}
	result = _result_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self, GKeyFile* keyfile) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp58_;
	gboolean _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keyfile != NULL);
	_tmp0_ = g_key_file_get_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Type", &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	_tmp2_ = _tmp1_;
	if ((_tmp3_ = g_strcmp0 (_tmp2_, "Application") != 0, _g_free0 (_tmp2_), _tmp3_)) {
		GError* _tmp4_ = NULL;
		_tmp4_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Not Application-type desktop entry");
		_inner_error_ = _tmp4_;
		goto __catch8_g_error;
	}
	_tmp5_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Categories", &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	if (_tmp6_) {
		gsize _tmp7_;
		gchar** _tmp8_ = NULL;
		gint categories_length1;
		gint _categories_size_;
		gchar** _tmp9_;
		gchar** categories;
		_tmp8_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Categories", &_tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		categories_length1 = _tmp7_;
		_categories_size_ = categories_length1;
		categories = _tmp9_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		if (_vala_string_array_contains (categories, categories_length1, "Screensaver")) {
			GError* _tmp10_ = NULL;
			_tmp10_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Screensaver desktop entry");
			_inner_error_ = _tmp10_;
			categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
			goto __catch8_g_error;
		}
		categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = g_key_file_get_locale_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Name", NULL, &_inner_error_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	_tmp13_ = _tmp12_;
	synapse_desktop_file_info_set_name (self, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = g_key_file_get_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Exec", &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	_tmp16_ = _tmp15_;
	synapse_desktop_file_info_set_exec (self, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp18_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Hidden", &_inner_error_);
	_tmp19_ = _tmp18_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	if (_tmp19_) {
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp20_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Hidden", &_inner_error_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		synapse_desktop_file_info_set_is_hidden (self, TRUE);
	}
	_tmp23_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NoDisplay", &_inner_error_);
	_tmp24_ = _tmp23_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	if (_tmp24_) {
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp25_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NoDisplay", &_inner_error_);
		_tmp26_ = _tmp25_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp22_ = _tmp26_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		synapse_desktop_file_info_set_is_hidden (self, TRUE);
	}
	_tmp27_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Comment", &_inner_error_);
	_tmp28_ = _tmp27_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	if (_tmp28_) {
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp29_ = g_key_file_get_locale_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Comment", NULL, &_inner_error_);
		_tmp30_ = _tmp29_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp31_ = _tmp30_;
		synapse_desktop_file_info_set_comment (self, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Icon", &_inner_error_);
	_tmp33_ = _tmp32_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	if (_tmp33_) {
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_;
		_tmp34_ = g_key_file_get_locale_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Icon", NULL, &_inner_error_);
		_tmp35_ = _tmp34_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp36_ = _tmp35_;
		synapse_desktop_file_info_set_icon_name (self, _tmp36_);
		_g_free0 (_tmp36_);
		_tmp38_ = g_path_is_absolute (self->priv->_icon_name);
		if (!_tmp38_) {
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_ = FALSE;
			gboolean _tmp41_;
			_tmp41_ = g_str_has_suffix (self->priv->_icon_name, ".png");
			if (_tmp41_) {
				_tmp40_ = TRUE;
			} else {
				gboolean _tmp42_;
				_tmp42_ = g_str_has_suffix (self->priv->_icon_name, ".svg");
				_tmp40_ = _tmp42_;
			}
			if (_tmp40_) {
				_tmp39_ = TRUE;
			} else {
				gboolean _tmp43_;
				_tmp43_ = g_str_has_suffix (self->priv->_icon_name, ".xpm");
				_tmp39_ = _tmp43_;
			}
			_tmp37_ = _tmp39_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gsize _tmp44_;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_;
			_tmp44_ = strlen (self->priv->_icon_name);
			_tmp45_ = g_strndup (self->priv->_icon_name, _tmp44_ - 4);
			_tmp46_ = _tmp45_;
			synapse_desktop_file_info_set_icon_name (self, _tmp46_);
			_g_free0 (_tmp46_);
		}
	}
	_tmp47_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "MimeType", &_inner_error_);
	_tmp48_ = _tmp47_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	if (_tmp48_) {
		gsize _tmp49_;
		gchar** _tmp50_ = NULL;
		gint _tmp51__length1;
		gint __tmp51__size_;
		gchar** _tmp52_;
		gchar** _tmp51_;
		gchar** _tmp53_;
		_tmp50_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "MimeType", &_tmp49_, &_inner_error_);
		_tmp52_ = _tmp50_;
		_tmp51__length1 = _tmp49_;
		__tmp51__size_ = _tmp51__length1;
		_tmp51_ = _tmp52_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp53_ = _tmp51_;
		self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
		self->mime_types_length1 = _tmp51__length1;
		self->mime_types = _tmp53_;
	}
	_tmp54_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Terminal", &_inner_error_);
	_tmp55_ = _tmp54_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	if (_tmp55_) {
		gboolean _tmp56_;
		gboolean _tmp57_;
		_tmp56_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Terminal", &_inner_error_);
		_tmp57_ = _tmp56_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		synapse_desktop_file_info_set_needs_terminal (self, _tmp57_);
	}
	_tmp58_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "OnlyShowIn", &_inner_error_);
	_tmp59_ = _tmp58_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	if (_tmp59_) {
		gsize _tmp60_;
		gchar** _tmp61_ = NULL;
		gint _tmp62__length1;
		gint __tmp62__size_;
		gchar** _tmp63_;
		gchar** _tmp62_;
		gchar** _tmp64_;
		gint _tmp64__length1;
		SynapseDesktopFileInfoEnvironmentType _tmp65_;
		_tmp61_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "OnlyShowIn", &_tmp60_, &_inner_error_);
		_tmp63_ = _tmp61_;
		_tmp62__length1 = _tmp60_;
		__tmp62__size_ = _tmp62__length1;
		_tmp62_ = _tmp63_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp64_ = _tmp62_;
		_tmp64__length1 = _tmp62__length1;
		_tmp65_ = synapse_desktop_file_info_parse_environments (self, _tmp64_, _tmp62__length1);
		synapse_desktop_file_info_set_show_in (self, _tmp65_);
		_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
	} else {
		gboolean _tmp66_;
		gboolean _tmp67_;
		_tmp66_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NotShowIn", &_inner_error_);
		_tmp67_ = _tmp66_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		if (_tmp67_) {
			gsize _tmp68_;
			gchar** _tmp69_ = NULL;
			gint _tmp70__length1;
			gint __tmp70__size_;
			gchar** _tmp71_;
			gchar** _tmp70_;
			gchar** _tmp72_;
			gint _tmp72__length1;
			SynapseDesktopFileInfoEnvironmentType _tmp73_;
			SynapseDesktopFileInfoEnvironmentType _tmp74_;
			SynapseDesktopFileInfoEnvironmentType not_show;
			_tmp69_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NotShowIn", &_tmp68_, &_inner_error_);
			_tmp71_ = _tmp69_;
			_tmp70__length1 = _tmp68_;
			__tmp70__size_ = _tmp70__length1;
			_tmp70_ = _tmp71_;
			if (_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
			_tmp72_ = _tmp70_;
			_tmp72__length1 = _tmp70__length1;
			_tmp73_ = synapse_desktop_file_info_parse_environments (self, _tmp72_, _tmp70__length1);
			not_show = (_tmp74_ = _tmp73_, _tmp72_ = (_vala_array_free (_tmp72_, _tmp72__length1, (GDestroyNotify) g_free), NULL), _tmp74_);
			synapse_desktop_file_info_set_show_in (self, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL ^ not_show);
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		synapse_desktop_file_info_set_is_valid (self, FALSE);
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type) {
	SynapseDesktopFileInfo * self = NULL;
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, NULL);
	return self;
}


SynapseDesktopFileInfo* synapse_desktop_file_info_new (void) {
	return synapse_desktop_file_info_construct (SYNAPSE_TYPE_DESKTOP_FILE_INFO);
}


const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_comment;
	return result;
}


void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_comment);
	self->priv->_comment = _tmp1_;
	g_object_notify ((GObject *) self, "comment");
}


const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon_name;
	return result;
}


void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_needs_terminal;
	return result;
}


void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_needs_terminal = value;
	g_object_notify ((GObject *) self, "needs-terminal");
}


const gchar* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
	return result;
}


void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	g_object_notify ((GObject *) self, "filename");
}


const gchar* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_exec;
	return result;
}


void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_exec);
	self->priv->_exec = _tmp1_;
	g_object_notify ((GObject *) self, "exec");
}


gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_hidden;
	return result;
}


static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_hidden = value;
	g_object_notify ((GObject *) self, "is-hidden");
}


gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_valid;
	return result;
}


static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_valid = value;
	g_object_notify ((GObject *) self, "is-valid");
}


SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self) {
	SynapseDesktopFileInfoEnvironmentType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_show_in;
	return result;
}


void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self, SynapseDesktopFileInfoEnvironmentType value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_in = value;
	g_object_notify ((GObject *) self, "show-in");
}


static void synapse_desktop_file_info_class_init (SynapseDesktopFileInfoClass * klass) {
	synapse_desktop_file_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDesktopFileInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_COMMENT, g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL, g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_EXEC, g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN, g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_VALID, g_param_spec_boolean ("is-valid", "is-valid", "is-valid", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN, g_param_spec_flags ("show-in", "show-in", "show-in", SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_desktop_file_info_instance_init (SynapseDesktopFileInfo * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SYNAPSE_DESKTOP_FILE_INFO_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_comment = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_needs_terminal = FALSE;
	self->priv->_is_hidden = FALSE;
	self->priv->_is_valid = TRUE;
	self->mime_types = NULL;
	self->priv->name_folded = NULL;
	self->priv->_show_in = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL;
}


static void synapse_desktop_file_info_finalize (GObject* obj) {
	SynapseDesktopFileInfo * self;
	self = SYNAPSE_DESKTOP_FILE_INFO (obj);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_comment);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_exec);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->name_folded);
	G_OBJECT_CLASS (synapse_desktop_file_info_parent_class)->finalize (obj);
}


GType synapse_desktop_file_info_get_type (void) {
	static volatile gsize synapse_desktop_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileInfo), 0, (GInstanceInitFunc) synapse_desktop_file_info_instance_init, NULL };
		GType synapse_desktop_file_info_type_id;
		synapse_desktop_file_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileInfo", &g_define_type_info, 0);
		g_once_init_leave (&synapse_desktop_file_info_type_id__volatile, synapse_desktop_file_info_type_id);
	}
	return synapse_desktop_file_info_type_id__volatile;
}


static void _vala_synapse_desktop_file_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDesktopFileInfo * self;
	self = SYNAPSE_DESKTOP_FILE_INFO (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_INFO_NAME:
		g_value_set_string (value, synapse_desktop_file_info_get_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT:
		g_value_set_string (value, synapse_desktop_file_info_get_comment (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME:
		g_value_set_string (value, synapse_desktop_file_info_get_icon_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL:
		g_value_set_boolean (value, synapse_desktop_file_info_get_needs_terminal (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME:
		g_value_set_string (value, synapse_desktop_file_info_get_filename (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC:
		g_value_set_string (value, synapse_desktop_file_info_get_exec (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN:
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_hidden (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID:
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_valid (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN:
		g_value_set_flags (value, synapse_desktop_file_info_get_show_in (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_desktop_file_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDesktopFileInfo * self;
	self = SYNAPSE_DESKTOP_FILE_INFO (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_INFO_NAME:
		synapse_desktop_file_info_set_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT:
		synapse_desktop_file_info_set_comment (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME:
		synapse_desktop_file_info_set_icon_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL:
		synapse_desktop_file_info_set_needs_terminal (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME:
		synapse_desktop_file_info_set_filename (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC:
		synapse_desktop_file_info_set_exec (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN:
		synapse_desktop_file_info_set_is_hidden (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID:
		synapse_desktop_file_info_set_is_valid (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN:
		synapse_desktop_file_info_set_show_in (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SynapseDesktopFileService* synapse_desktop_file_service_get_default (void) {
	SynapseDesktopFileService* result = NULL;
	SynapseDesktopFileService* _tmp0_;
	SynapseDesktopFileService* _tmp1_;
	_tmp0_ = _g_object_ref0 (synapse_desktop_file_service_instance);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		SynapseDesktopFileService* _tmp2_ = NULL;
		SynapseDesktopFileService* _tmp3_;
		_tmp2_ = synapse_desktop_file_service_new ();
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp3_;
	}
	result = _tmp1_;
	return result;
}


static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type) {
	SynapseDesktopFileService * self = NULL;
	self = (SynapseDesktopFileService*) g_object_new (object_type, NULL);
	return self;
}


static SynapseDesktopFileService* synapse_desktop_file_service_new (void) {
	return synapse_desktop_file_service_construct (SYNAPSE_TYPE_DESKTOP_FILE_SERVICE);
}


static void synapse_desktop_file_service_initialize_data_free (gpointer _data) {
	SynapseDesktopFileServiceInitializeData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SynapseDesktopFileServiceInitializeData, data);
}


static void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceInitializeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_initialize);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_initialize_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_desktop_file_service_initialize_co (_data_);
}


static void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceInitializeData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_desktop_file_service_initialize_co (data);
}


static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	synapse_desktop_file_service_get_environment_type (data->self);
	g_desktop_app_info_set_desktop_env (data->self->priv->session_type_str);
	data->_state_ = 1;
	synapse_desktop_file_service_load_all_desktop_files (data->self, synapse_desktop_file_service_initialize_ready, data);
	return FALSE;
	_state_1:
	synapse_desktop_file_service_load_all_desktop_files_finish (data->self, data->_res_);
	synapse_desktop_file_service_set_initialized (data->self, TRUE);
	g_signal_emit_by_name (data->self, "initialization-done");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* session_var;
	gchar* _tmp1_ = NULL;
	gchar* session;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_getenv ("DESKTOP_SESSION");
	session_var = _tmp0_;
	if (session_var == NULL) {
		return;
	}
	_tmp1_ = g_utf8_strdown (session_var, (gssize) (-1));
	session = _tmp1_;
	_tmp2_ = g_str_has_prefix (session, "kde");
	if (_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
		_tmp3_ = g_strdup ("KDE");
		_tmp4_ = _tmp3_;
		_g_free0 (self->priv->session_type_str);
		self->priv->session_type_str = _tmp4_;
	} else {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_prefix (session, "gnome");
		if (_tmp5_) {
			gchar* _tmp6_;
			gchar* _tmp7_;
			self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
			_tmp6_ = g_strdup ("GNOME");
			_tmp7_ = _tmp6_;
			_g_free0 (self->priv->session_type_str);
			self->priv->session_type_str = _tmp7_;
		} else {
			gboolean _tmp8_;
			_tmp8_ = g_str_has_prefix (session, "lx");
			if (_tmp8_) {
				gchar* _tmp9_;
				gchar* _tmp10_;
				self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
				_tmp9_ = g_strdup ("XFCE");
				_tmp10_ = _tmp9_;
				_g_free0 (self->priv->session_type_str);
				self->priv->session_type_str = _tmp10_;
			} else {
				gboolean _tmp11_;
				_tmp11_ = g_str_has_prefix (session, "xfce");
				if (_tmp11_) {
					gchar* _tmp12_;
					gchar* _tmp13_;
					self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
					_tmp12_ = g_strdup ("XFCE");
					_tmp13_ = _tmp12_;
					_g_free0 (self->priv->session_type_str);
					self->priv->session_type_str = _tmp13_;
				} else {
					gboolean _tmp14_;
					_tmp14_ = g_str_has_prefix (session, "rox");
					if (_tmp14_) {
						gchar* _tmp15_;
						gchar* _tmp16_;
						self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
						_tmp15_ = g_strdup ("ROX");
						_tmp16_ = _tmp15_;
						_g_free0 (self->priv->session_type_str);
						self->priv->session_type_str = _tmp16_;
					} else {
						g_warning ("desktop-file-service.vala:262: Desktop session type is not recognized," \
" assuming GNOME.");
					}
				}
			}
		}
	}
	_g_free0 (session);
}


static void synapse_desktop_file_service_process_directory_data_free (gpointer _data) {
	SynapseDesktopFileServiceProcessDirectoryData* data;
	data = _data;
	_g_object_unref0 (data->directory);
	_g_object_unref0 (data->monitored_dirs);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseDesktopFileServiceProcessDirectoryData, data);
}


static void synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self, GFile* directory, GeeSet* monitored_dirs, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceProcessDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_process_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_process_directory_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->directory = _g_object_ref0 (directory);
	_data_->monitored_dirs = _g_object_ref0 (monitored_dirs);
	synapse_desktop_file_service_process_directory_co (_data_);
}


static void synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_process_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceProcessDirectoryData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_desktop_file_service_process_directory_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_get_path (data->directory);
	data->path = data->_tmp0_;
	if (data->path != NULL) {
		data->_tmp2_ = g_str_has_suffix (data->path, "menu-xdg");
		data->_tmp1_ = data->_tmp2_;
	} else {
		data->_tmp1_ = FALSE;
	}
	if (data->_tmp1_) {
		_g_free0 (data->path);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	synapse_utils_query_exists_async (data->directory, synapse_desktop_file_service_process_directory_ready, data);
	return FALSE;
	_state_1:
	data->_tmp3_ = synapse_utils_query_exists_finish (data->_res_);
	data->exists = data->_tmp3_;
	if (!data->exists) {
		_g_free0 (data->path);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	gee_collection_add ((GeeCollection*) data->monitored_dirs, data->directory);
	data->_state_ = 2;
	g_file_enumerate_children_async (data->directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_desktop_file_service_process_directory_ready, data);
	return FALSE;
	_state_2:
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_file_enumerate_children_finish (data->directory, data->_res_, &data->_inner_error_);
	data->enumerator = data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->path);
		goto __catch9_g_error;
	}
	data->_state_ = 3;
	g_file_enumerator_next_files_async (data->enumerator, 1024, 0, NULL, synapse_desktop_file_service_process_directory_ready, data);
	return FALSE;
	_state_3:
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
	data->files = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->enumerator);
		_g_free0 (data->path);
		goto __catch9_g_error;
	}
	{
		data->f_collection = data->files;
		for (data->f_it = data->f_collection; data->f_it != NULL; data->f_it = data->f_it->next) {
			data->_tmp6_ = _g_object_ref0 ((GFileInfo*) data->f_it->data);
			data->f = data->_tmp6_;
			{
				data->_tmp7_ = NULL;
				data->_tmp7_ = g_file_info_get_name (data->f);
				data->name = data->_tmp7_;
				data->_tmp8_ = g_file_info_get_file_type (data->f);
				if (data->_tmp8_ == G_FILE_TYPE_DIRECTORY) {
					data->_tmp9_ = NULL;
					data->_tmp9_ = g_file_get_child (data->directory, data->name);
					data->_tmp10_ = data->_tmp9_;
					data->_state_ = 4;
					synapse_desktop_file_service_process_directory (data->self, data->_tmp10_, data->monitored_dirs, synapse_desktop_file_service_process_directory_ready, data);
					return FALSE;
					_state_4:
					synapse_desktop_file_service_process_directory_finish (data->self, data->_res_);
					_g_object_unref0 (data->_tmp10_);
				} else {
					data->_tmp11_ = g_str_has_suffix (data->name, "synapse.desktop");
					if (data->_tmp11_) {
						_g_object_unref0 (data->f);
						continue;
					}
					data->_tmp12_ = g_str_has_suffix (data->name, ".desktop");
					if (data->_tmp12_) {
						data->_tmp13_ = NULL;
						data->_tmp13_ = g_file_get_child (data->directory, data->name);
						data->_tmp14_ = data->_tmp13_;
						data->_state_ = 5;
						synapse_desktop_file_service_load_desktop_file (data->self, data->_tmp14_, synapse_desktop_file_service_process_directory_ready, data);
						return FALSE;
						_state_5:
						synapse_desktop_file_service_load_desktop_file_finish (data->self, data->_res_);
						_g_object_unref0 (data->_tmp14_);
					}
				}
				_g_object_unref0 (data->f);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (data->files);
	_g_object_unref0 (data->enumerator);
	_g_free0 (data->path);
	goto __finally9;
	__catch9_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("desktop-file-service.vala:301: %s", data->err->message);
		_g_error_free0 (data->err);
	}
	__finally9:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data) {
	SynapseDesktopFileServiceLoadAllDesktopFilesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SynapseDesktopFileServiceLoadAllDesktopFilesData, data);
}


static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadAllDesktopFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_load_all_desktop_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_load_all_desktop_files_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
}


static void synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadAllDesktopFilesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_desktop_file_service_load_all_desktop_files_co (data);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	synapse_desktop_file_service_desktop_file_directory_changed (self);
}


static gboolean synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp1_ = NULL;
	data->_tmp1_ = data->_tmp0_ = g_get_system_data_dirs ();
	data->_tmp2_ = (data->_tmp3_ = data->_tmp1_, (data->_tmp3_ == NULL) ? ((gpointer) data->_tmp3_) : _vala_array_dup2 (data->_tmp3_, _vala_array_length (data->_tmp0_)));
	data->_tmp4_ = data->_tmp2_;
	data->data_dirs_length1 = _vala_array_length (data->_tmp0_);
	data->_data_dirs_size_ = data->data_dirs_length1;
	data->data_dirs = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_get_user_data_dir ();
	data->_tmp6_ = g_strdup (data->_tmp5_);
	_vala_array_add5 (&data->data_dirs, &data->data_dirs_length1, &data->_data_dirs_size_, data->_tmp6_);
	data->_tmp7_ = NULL;
	data->_tmp7_ = gee_hash_set_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->desktop_file_dirs = (GeeSet*) data->_tmp7_;
	gee_multi_map_clear (data->self->priv->mimetype_parent_map);
	{
		data->data_dir_collection = data->data_dirs;
		data->data_dir_collection_length1 = data->data_dirs_length1;
		for (data->data_dir_it = 0; data->data_dir_it < data->data_dirs_length1; data->data_dir_it = data->data_dir_it + 1) {
			data->data_dir = data->data_dir_collection[data->data_dir_it];
			{
				data->_tmp8_ = NULL;
				data->_tmp8_ = g_build_filename (data->data_dir, "applications", NULL, NULL);
				data->dir_path = data->_tmp8_;
				data->_tmp9_ = NULL;
				data->_tmp9_ = g_file_new_for_path (data->dir_path);
				data->directory = data->_tmp9_;
				data->_state_ = 1;
				synapse_desktop_file_service_process_directory (data->self, data->directory, data->desktop_file_dirs, synapse_desktop_file_service_load_all_desktop_files_ready, data);
				return FALSE;
				_state_1:
				synapse_desktop_file_service_process_directory_finish (data->self, data->_res_);
				data->_tmp10_ = NULL;
				data->_tmp10_ = g_build_filename (data->data_dir, "mime", "subclasses", NULL);
				data->_tmp11_ = data->_tmp10_;
				_g_free0 (data->dir_path);
				data->dir_path = data->_tmp11_;
				data->_state_ = 2;
				synapse_desktop_file_service_load_mime_parents_from_file (data->self, data->dir_path, synapse_desktop_file_service_load_all_desktop_files_ready, data);
				return FALSE;
				_state_2:
				synapse_desktop_file_service_load_mime_parents_from_file_finish (data->self, data->_res_);
				_g_object_unref0 (data->directory);
				_g_free0 (data->dir_path);
			}
		}
	}
	synapse_desktop_file_service_create_indices (data->self);
	data->_tmp12_ = NULL;
	data->_tmp12_ = gee_array_list_new (G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	data->_tmp13_ = (GeeList*) data->_tmp12_;
	_g_object_unref0 (data->self->priv->directory_monitors);
	data->self->priv->directory_monitors = data->_tmp13_;
	{
		data->_tmp14_ = NULL;
		data->_tmp14_ = gee_iterable_iterator ((GeeIterable*) data->desktop_file_dirs);
		data->_d_it = data->_tmp14_;
		while (TRUE) {
			data->_tmp15_ = gee_iterator_next (data->_d_it);
			if (!data->_tmp15_) {
				break;
			}
			data->_tmp16_ = NULL;
			data->_tmp16_ = gee_iterator_get (data->_d_it);
			data->d = (GFile*) data->_tmp16_;
			data->_tmp17_ = NULL;
			data->_tmp17_ = g_file_monitor_directory (data->d, 0, NULL, &data->_inner_error_);
			data->monitor = data->_tmp17_;
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->d);
				_g_object_unref0 (data->_d_it);
				_g_object_unref0 (data->desktop_file_dirs);
				data->data_dirs = (_vala_array_free (data->data_dirs, data->data_dirs_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			g_signal_connect_object (data->monitor, "changed", (GCallback) _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed, data->self, 0);
			gee_collection_add ((GeeCollection*) data->self->priv->directory_monitors, data->monitor);
			_g_object_unref0 (data->monitor);
			_g_object_unref0 (data->d);
		}
		_g_object_unref0 (data->_d_it);
	}
	_g_object_unref0 (data->desktop_file_dirs);
	data->data_dirs = (_vala_array_free (data->data_dirs, data->data_dirs_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean _lambda1_ (SynapseDesktopFileService* self) {
	gboolean result = FALSE;
	self->priv->timer_id = (guint) 0;
	synapse_desktop_file_service_reload_desktop_files (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static void synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "reload-started");
	if (self->priv->timer_id != 0) {
		g_source_remove (self->priv->timer_id);
	}
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->timer_id = _tmp0_;
}


static void synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data) {
	SynapseDesktopFileServiceReloadDesktopFilesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SynapseDesktopFileServiceReloadDesktopFilesData, data);
}


static void synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceReloadDesktopFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_reload_desktop_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_reload_desktop_files_data_free);
	_data_->self = _g_object_ref0 (self);
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
}


static void synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceReloadDesktopFilesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_desktop_file_service_reload_desktop_files_co (data);
}


static gboolean synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("desktop-file-service.vala:357: Reloading desktop files...");
	gee_collection_clear ((GeeCollection*) data->self->priv->all_desktop_files);
	gee_collection_clear ((GeeCollection*) data->self->priv->non_hidden_desktop_files);
	data->_state_ = 1;
	synapse_desktop_file_service_load_all_desktop_files (data->self, synapse_desktop_file_service_reload_desktop_files_ready, data);
	return FALSE;
	_state_1:
	synapse_desktop_file_service_load_all_desktop_files_finish (data->self, data->_res_);
	g_signal_emit_by_name (data->self, "reload-done");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data) {
	SynapseDesktopFileServiceLoadDesktopFileData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseDesktopFileServiceLoadDesktopFileData, data);
}


static void synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadDesktopFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_load_desktop_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_load_desktop_file_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	synapse_desktop_file_service_load_desktop_file_co (_data_);
}


static void synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadDesktopFileData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_desktop_file_service_load_desktop_file_co (data);
}


static gboolean synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_state_ = 1;
	g_file_load_contents_async (data->file, NULL, synapse_desktop_file_service_load_desktop_file_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = g_file_load_contents_finish (data->file, data->_res_, &data->_tmp0_, &data->_tmp1_, NULL, &data->_inner_error_);
	_g_free0 (data->contents);
	data->contents = data->_tmp0_;
	data->len = data->_tmp1_;
	data->success = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->contents);
		goto __catch10_g_error;
	}
	if (data->success) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_key_file_new ();
		data->keyfile = data->_tmp3_;
		g_key_file_load_from_data (data->keyfile, data->contents, data->len, 0, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			_g_key_file_free0 (data->keyfile);
			_g_free0 (data->contents);
			goto __catch10_g_error;
		}
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_file_get_path (data->file);
		data->_tmp5_ = data->_tmp4_;
		data->_tmp6_ = NULL;
		data->_tmp6_ = synapse_desktop_file_info_new_for_keyfile (data->_tmp5_, data->keyfile);
		data->dfi = (data->_tmp7_ = data->_tmp6_, _g_free0 (data->_tmp5_), data->_tmp7_);
		data->_tmp8_ = synapse_desktop_file_info_get_is_valid (data->dfi);
		if (data->_tmp8_) {
			gee_collection_add ((GeeCollection*) data->self->priv->all_desktop_files, data->dfi);
			data->_tmp10_ = synapse_desktop_file_info_get_is_hidden (data->dfi);
			if (!data->_tmp10_) {
				data->_tmp11_ = synapse_desktop_file_info_get_show_in (data->dfi);
				data->_tmp9_ = (data->_tmp11_ & data->self->priv->session_type) == data->self->priv->session_type;
			} else {
				data->_tmp9_ = FALSE;
			}
			if (data->_tmp9_) {
				gee_collection_add ((GeeCollection*) data->self->priv->non_hidden_desktop_files, data->dfi);
			}
		}
		_g_object_unref0 (data->dfi);
		_g_key_file_free0 (data->keyfile);
	}
	_g_free0 (data->contents);
	goto __finally10;
	__catch10_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("desktop-file-service.vala:390: %s", data->err->message);
		_g_error_free0 (data->err);
	}
	__finally10:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeMap* _tmp1_;
	GeeHashMap* _tmp2_ = NULL;
	GeeMap* _tmp3_;
	GeeHashMap* _tmp4_ = NULL;
	GeeMap* _tmp5_;
	GRegex* exec_re;
	GRegex* _tmp6_ = NULL;
	GRegex* _tmp7_;
	GRegex* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, NULL, NULL, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp1_ = (GeeMap*) _tmp0_;
	_g_object_unref0 (self->priv->mimetype_map);
	self->priv->mimetype_map = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp3_ = (GeeMap*) _tmp2_;
	_g_object_unref0 (self->priv->exec_map);
	self->priv->exec_map = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp5_ = (GeeMap*) _tmp4_;
	_g_object_unref0 (self->priv->desktop_id_map);
	self->priv->desktop_id_map = _tmp5_;
	exec_re = NULL;
	_tmp6_ = g_regex_new ("%[fFuU]", 0, 0, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch11_g_error;
	}
	_tmp8_ = _tmp7_;
	_g_regex_unref0 (exec_re);
	exec_re = _tmp8_;
	goto __finally11;
	__catch11_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("desktop-file-service.vala:413: %s", err->message);
		_g_error_free0 (err);
		_g_regex_unref0 (exec_re);
		return;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (exec_re);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GeeList* _tmp9_;
		GeeList* _dfi_list;
		gint _tmp10_;
		gint _dfi_size;
		gint _dfi_index;
		_tmp9_ = _g_object_ref0 (self->priv->all_desktop_files);
		_dfi_list = _tmp9_;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _dfi_list);
		_dfi_size = _tmp10_;
		_dfi_index = -1;
		while (TRUE) {
			gpointer _tmp11_ = NULL;
			SynapseDesktopFileInfo* dfi;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* exec;
			gpointer _tmp18_ = NULL;
			GeeList* exec_list;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_;
			_dfi_index = _dfi_index + 1;
			if (!(_dfi_index < _dfi_size)) {
				break;
			}
			_tmp11_ = gee_list_get (_dfi_list, _dfi_index);
			dfi = (SynapseDesktopFileInfo*) _tmp11_;
			_tmp12_ = synapse_desktop_file_info_get_exec (dfi);
			_tmp13_ = g_regex_replace_literal (exec_re, _tmp12_, (gssize) (-1), 0, "", 0, &_inner_error_);
			_tmp14_ = _tmp13_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dfi);
				_g_object_unref0 (_dfi_list);
				_g_regex_unref0 (exec_re);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp15_ = _tmp14_;
			_tmp16_ = string_strip (_tmp15_);
			exec = (_tmp17_ = _tmp16_, _g_free0 (_tmp15_), _tmp17_);
			_tmp18_ = gee_map_get (self->priv->exec_map, exec);
			exec_list = (GeeList*) _tmp18_;
			if (exec_list == NULL) {
				GeeArrayList* _tmp19_ = NULL;
				GeeList* _tmp20_;
				_tmp19_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
				_tmp20_ = (GeeList*) _tmp19_;
				_g_object_unref0 (exec_list);
				exec_list = _tmp20_;
				gee_map_set (self->priv->exec_map, exec, exec_list);
			}
			gee_collection_add ((GeeCollection*) exec_list, dfi);
			_tmp21_ = synapse_desktop_file_info_get_filename (dfi);
			_tmp22_ = g_path_get_basename (_tmp21_);
			_tmp23_ = _tmp22_;
			gee_map_set (self->priv->desktop_id_map, _tmp23_, dfi);
			_g_free0 (_tmp23_);
			_tmp25_ = synapse_desktop_file_info_get_is_hidden (dfi);
			if (_tmp25_) {
				_tmp24_ = TRUE;
			} else {
				_tmp24_ = dfi->mime_types == NULL;
			}
			if (_tmp24_) {
				_g_object_unref0 (exec_list);
				_g_free0 (exec);
				_g_object_unref0 (dfi);
				continue;
			}
			{
				gchar** mime_type_collection;
				int mime_type_collection_length1;
				int mime_type_it;
				mime_type_collection = dfi->mime_types;
				mime_type_collection_length1 = dfi->mime_types_length1;
				for (mime_type_it = 0; mime_type_it < dfi->mime_types_length1; mime_type_it = mime_type_it + 1) {
					const gchar* mime_type;
					mime_type = mime_type_collection[mime_type_it];
					{
						gpointer _tmp26_ = NULL;
						GeeList* list;
						_tmp26_ = gee_map_get (self->priv->mimetype_map, mime_type);
						list = (GeeList*) _tmp26_;
						if (list == NULL) {
							GeeArrayList* _tmp27_ = NULL;
							GeeList* _tmp28_;
							_tmp27_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
							_tmp28_ = (GeeList*) _tmp27_;
							_g_object_unref0 (list);
							list = _tmp28_;
							gee_map_set (self->priv->mimetype_map, mime_type, list);
						}
						gee_collection_add ((GeeCollection*) list, dfi);
						_g_object_unref0 (list);
					}
				}
			}
			_g_object_unref0 (exec_list);
			_g_free0 (exec);
			_g_object_unref0 (dfi);
		}
		_g_object_unref0 (_dfi_list);
	}
	_g_regex_unref0 (exec_re);
}


static void synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data) {
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* data;
	data = _data;
	_g_free0 (data->fi);
	_g_object_unref0 (data->self);
	g_slice_free (SynapseDesktopFileServiceLoadMimeParentsFromFileData, data);
}


static void synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self, const gchar* fi, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadMimeParentsFromFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, synapse_desktop_file_service_load_mime_parents_from_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, synapse_desktop_file_service_load_mime_parents_from_file_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->fi = g_strdup (fi);
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
}


static void synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self, GAsyncResult* _res_) {
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	synapse_desktop_file_service_load_mime_parents_from_file_co (data);
}


static gboolean synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_new_for_path (data->fi);
	data->file = data->_tmp0_;
	data->_state_ = 1;
	synapse_utils_query_exists_async (data->file, synapse_desktop_file_service_load_mime_parents_from_file_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = synapse_utils_query_exists_finish (data->_res_);
	data->exists = data->_tmp1_;
	if (!data->exists) {
		_g_object_unref0 (data->file);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 2;
	g_file_read_async (data->file, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, data);
	return FALSE;
	_state_2:
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_file_read_finish (data->file, data->_res_, &data->_inner_error_);
	data->fis = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_data_input_stream_new ((GInputStream*) data->fis);
	data->dis = data->_tmp3_;
	data->line = NULL;
	data->_tmp4_ = NULL;
	data->mimes_length1 = 0;
	data->_mimes_size_ = data->mimes_length1;
	data->mimes = data->_tmp4_;
	data->len = 0;
	while (TRUE) {
		data->_state_ = 3;
		g_data_input_stream_read_line_async (data->dis, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, data);
		return FALSE;
		_state_3:
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_data_input_stream_read_line_finish (data->dis, data->_res_, NULL, &data->_inner_error_);
		data->_tmp6_ = data->_tmp5_;
		if (data->_inner_error_ != NULL) {
			data->mimes = (_vala_array_free (data->mimes, data->mimes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->line);
			_g_object_unref0 (data->dis);
			_g_object_unref0 (data->fis);
			goto __catch12_g_error;
		}
		data->_tmp7_ = data->_tmp6_;
		_g_free0 (data->line);
		data->line = data->_tmp7_;
		if (data->line == NULL) {
			break;
		}
		data->_tmp8_ = g_str_has_prefix (data->line, "#");
		if (data->_tmp8_) {
			continue;
		}
		data->_tmp10_ = NULL;
		data->_tmp10_ = data->_tmp9_ = g_strsplit (data->line, " ", 0);
		data->_tmp11_ = data->_tmp10_;
		data->mimes = (_vala_array_free (data->mimes, data->mimes_length1, (GDestroyNotify) g_free), NULL);
		data->mimes_length1 = _vala_array_length (data->_tmp9_);
		data->_mimes_size_ = data->mimes_length1;
		data->mimes = data->_tmp11_;
		data->_tmp12_ = g_strv_length (data->mimes);
		data->len = (gint) data->_tmp12_;
		if (data->len != 2) {
			continue;
		}
		if (g_strcmp0 (data->mimes[0], data->mimes[1]) == 0) {
			continue;
		}
		gee_multi_map_set (data->self->priv->mimetype_parent_map, data->mimes[0], data->mimes[1]);
	}
	data->mimes = (_vala_array_free (data->mimes, data->mimes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data->line);
	_g_object_unref0 (data->dis);
	_g_object_unref0 (data->fis);
	goto __finally12;
	__catch12_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		_g_error_free0 (data->err);
	}
	__finally12:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->file);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self, const gchar* mime, GeeSet* ret) {
	gpointer _tmp0_ = NULL;
	GeeList* dfis;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* parents;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime != NULL);
	g_return_if_fail (ret != NULL);
	_tmp0_ = gee_map_get (self->priv->mimetype_map, mime);
	dfis = (GeeList*) _tmp0_;
	if (dfis != NULL) {
		gee_collection_add_all ((GeeCollection*) ret, (GeeCollection*) dfis);
	}
	_tmp1_ = gee_multi_map_get (self->priv->mimetype_parent_map, mime);
	parents = _tmp1_;
	if (parents == NULL) {
		_g_object_unref0 (parents);
		_g_object_unref0 (dfis);
		return;
	}
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _parent_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) parents);
		_parent_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gchar* parent;
			_tmp3_ = gee_iterator_next (_parent_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_parent_it);
			parent = (gchar*) _tmp4_;
			synapse_desktop_file_service_add_dfi_for_mime (self, parent, ret);
			_g_free0 (parent);
		}
		_g_object_unref0 (_parent_it);
	}
	_g_object_unref0 (parents);
	_g_object_unref0 (dfis);
}


GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self) {
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_list_get_read_only_view (self->priv->non_hidden_desktop_files);
	result = _tmp0_;
	return result;
}


GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self) {
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_list_get_read_only_view (self->priv->all_desktop_files);
	result = _tmp0_;
	return result;
}


GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self, const gchar* mime_type) {
	GeeList* result = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* dfi_set;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* ret;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	_tmp0_ = gee_hash_set_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	dfi_set = _tmp0_;
	synapse_desktop_file_service_add_dfi_for_mime (self, mime_type, (GeeSet*) dfi_set);
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	ret = _tmp1_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) ret, (GeeCollection*) dfi_set);
	result = (GeeList*) ret;
	_g_object_unref0 (dfi_set);
	return result;
}


GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self, const gchar* exec) {
	GeeList* result = NULL;
	gpointer _tmp0_ = NULL;
	GeeList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exec != NULL, NULL);
	_tmp0_ = gee_map_get (self->priv->exec_map, exec);
	_tmp1_ = (GeeList*) _tmp0_;
	if (_tmp1_ == NULL) {
		GeeArrayList* _tmp2_ = NULL;
		GeeList* _tmp3_;
		_tmp2_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_tmp3_ = (GeeList*) _tmp2_;
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp3_;
	}
	result = _tmp1_;
	return result;
}


SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self, const gchar* desktop_id) {
	SynapseDesktopFileInfo* result = NULL;
	gpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = gee_map_get (self->priv->desktop_id_map, desktop_id);
	result = (SynapseDesktopFileInfo*) _tmp0_;
	return result;
}


gboolean synapse_desktop_file_service_get_initialized (SynapseDesktopFileService* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_initialized;
	return result;
}


static void synapse_desktop_file_service_set_initialized (SynapseDesktopFileService* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_initialized = value;
	g_object_notify ((GObject *) self, "initialized");
}


static GObject * synapse_desktop_file_service_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFileService * self;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* _tmp1_;
	GeeArrayList* _tmp2_ = NULL;
	GeeList* _tmp3_;
	GeeArrayList* _tmp4_ = NULL;
	GeeList* _tmp5_;
	GeeHashMultiMap* _tmp6_ = NULL;
	GeeMultiMap* _tmp7_;
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_DESKTOP_FILE_SERVICE (obj);
	synapse_desktop_file_service_instance = self;
	_tmp0_ = gee_array_list_new (G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp1_ = (GeeList*) _tmp0_;
	_g_object_unref0 (self->priv->directory_monitors);
	self->priv->directory_monitors = _tmp1_;
	_tmp2_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp3_ = (GeeList*) _tmp2_;
	_g_object_unref0 (self->priv->all_desktop_files);
	self->priv->all_desktop_files = _tmp3_;
	_tmp4_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp5_ = (GeeList*) _tmp4_;
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
	self->priv->non_hidden_desktop_files = _tmp5_;
	_tmp6_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	_tmp7_ = (GeeMultiMap*) _tmp6_;
	_g_object_unref0 (self->priv->mimetype_parent_map);
	self->priv->mimetype_parent_map = _tmp7_;
	synapse_desktop_file_service_initialize (self, NULL, NULL);
	return obj;
}


static void synapse_desktop_file_service_class_init (SynapseDesktopFileServiceClass * klass) {
	synapse_desktop_file_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseDesktopFileServicePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_service_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_service_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_service_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_SERVICE_INITIALIZED, g_param_spec_boolean ("initialized", "initialized", "initialized", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("initialization_done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("reload_started", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("reload_done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void synapse_desktop_file_service_instance_init (SynapseDesktopFileService * self) {
	gchar* _tmp0_;
	self->priv = SYNAPSE_DESKTOP_FILE_SERVICE_GET_PRIVATE (self);
	self->priv->_initialized = FALSE;
	self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
	_tmp0_ = g_strdup ("GNOME");
	self->priv->session_type_str = _tmp0_;
	self->priv->timer_id = (guint) 0;
}


static void synapse_desktop_file_service_finalize (GObject* obj) {
	SynapseDesktopFileService * self;
	self = SYNAPSE_DESKTOP_FILE_SERVICE (obj);
	synapse_desktop_file_service_instance = NULL;
	_g_object_unref0 (self->priv->directory_monitors);
	_g_object_unref0 (self->priv->all_desktop_files);
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
	_g_object_unref0 (self->priv->mimetype_map);
	_g_object_unref0 (self->priv->exec_map);
	_g_object_unref0 (self->priv->desktop_id_map);
	_g_object_unref0 (self->priv->mimetype_parent_map);
	_g_free0 (self->priv->session_type_str);
	G_OBJECT_CLASS (synapse_desktop_file_service_parent_class)->finalize (obj);
}


GType synapse_desktop_file_service_get_type (void) {
	static volatile gsize synapse_desktop_file_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileService), 0, (GInstanceInitFunc) synapse_desktop_file_service_instance_init, NULL };
		GType synapse_desktop_file_service_type_id;
		synapse_desktop_file_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileService", &g_define_type_info, 0);
		g_once_init_leave (&synapse_desktop_file_service_type_id__volatile, synapse_desktop_file_service_type_id);
	}
	return synapse_desktop_file_service_type_id__volatile;
}


static void _vala_synapse_desktop_file_service_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseDesktopFileService * self;
	self = SYNAPSE_DESKTOP_FILE_SERVICE (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_SERVICE_INITIALIZED:
		g_value_set_boolean (value, synapse_desktop_file_service_get_initialized (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_desktop_file_service_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseDesktopFileService * self;
	self = SYNAPSE_DESKTOP_FILE_SERVICE (object);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_SERVICE_INITIALIZED:
		synapse_desktop_file_service_set_initialized (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



