/* common-actions.c generated by valac UNKNOWN, the Vala compiler
 * generated from common-actions.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>


#define SYNAPSE_TYPE_DATA_PLUGIN (synapse_data_plugin_get_type ())
#define SYNAPSE_DATA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPlugin))
#define SYNAPSE_DATA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPluginClass))
#define SYNAPSE_IS_DATA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DATA_PLUGIN))
#define SYNAPSE_IS_DATA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DATA_PLUGIN))
#define SYNAPSE_DATA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DATA_PLUGIN, SynapseDataPluginClass))

typedef struct _SynapseDataPlugin SynapseDataPlugin;
typedef struct _SynapseDataPluginClass SynapseDataPluginClass;
typedef struct _SynapseDataPluginPrivate SynapseDataPluginPrivate;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_ACTION_PLUGIN (synapse_action_plugin_get_type ())
#define SYNAPSE_ACTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPlugin))
#define SYNAPSE_ACTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPluginClass))
#define SYNAPSE_IS_ACTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PLUGIN))
#define SYNAPSE_IS_ACTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ACTION_PLUGIN))
#define SYNAPSE_ACTION_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ACTION_PLUGIN, SynapseActionPluginClass))

typedef struct _SynapseActionPlugin SynapseActionPlugin;
typedef struct _SynapseActionPluginClass SynapseActionPluginClass;
typedef struct _SynapseActionPluginPrivate SynapseActionPluginPrivate;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_COMMON_ACTIONS (synapse_common_actions_get_type ())
#define SYNAPSE_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions))
#define SYNAPSE_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))
#define SYNAPSE_IS_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_IS_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_COMMON_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))

typedef struct _SynapseCommonActions SynapseCommonActions;
typedef struct _SynapseCommonActionsClass SynapseCommonActionsClass;
typedef struct _SynapseCommonActionsPrivate SynapseCommonActionsPrivate;

#define SYNAPSE_COMMON_ACTIONS_TYPE_ACTION (synapse_common_actions_action_get_type ())
#define SYNAPSE_COMMON_ACTIONS_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, SynapseCommonActionsAction))
#define SYNAPSE_COMMON_ACTIONS_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, SynapseCommonActionsActionClass))
#define SYNAPSE_COMMON_ACTIONS_IS_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_ACTION))
#define SYNAPSE_COMMON_ACTIONS_IS_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_ACTION))
#define SYNAPSE_COMMON_ACTIONS_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, SynapseCommonActionsActionClass))

typedef struct _SynapseCommonActionsAction SynapseCommonActionsAction;
typedef struct _SynapseCommonActionsActionClass SynapseCommonActionsActionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())

#define SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER (synapse_common_actions_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunner))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))

typedef struct _SynapseCommonActionsRunner SynapseCommonActionsRunner;
typedef struct _SynapseCommonActionsRunnerClass SynapseCommonActionsRunnerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER (synapse_common_actions_terminal_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunner))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))

typedef struct _SynapseCommonActionsTerminalRunner SynapseCommonActionsTerminalRunner;
typedef struct _SynapseCommonActionsTerminalRunnerClass SynapseCommonActionsTerminalRunnerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPENER (synapse_common_actions_opener_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener))
#define SYNAPSE_COMMON_ACTIONS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_OPENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))

typedef struct _SynapseCommonActionsOpener SynapseCommonActionsOpener;
typedef struct _SynapseCommonActionsOpenerClass SynapseCommonActionsOpenerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER (synapse_common_actions_open_folder_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolder))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))

typedef struct _SynapseCommonActionsOpenFolder SynapseCommonActionsOpenFolder;
typedef struct _SynapseCommonActionsOpenFolderClass SynapseCommonActionsOpenFolderClass;
typedef struct _SynapseCommonActionsActionPrivate SynapseCommonActionsActionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseCommonActionsRunnerPrivate SynapseCommonActionsRunnerPrivate;

#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseCommonActionsTerminalRunnerPrivate SynapseCommonActionsTerminalRunnerPrivate;
typedef struct _SynapseCommonActionsOpenerPrivate SynapseCommonActionsOpenerPrivate;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _SynapseCommonActionsOpenFolderPrivate SynapseCommonActionsOpenFolderPrivate;

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 1,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 3,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 5,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 6,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 7,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 15,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFF | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseDataPlugin {
	GObject parent_instance;
	SynapseDataPluginPrivate * priv;
};

struct _SynapseDataPluginClass {
	GObjectClass parent_class;
	void (*search) (SynapseDataPlugin* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseDataPlugin* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_empty_query) (SynapseDataPlugin* self);
};

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH
} SynapseMatchType;

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseActionPlugin {
	SynapseDataPlugin parent_instance;
	SynapseActionPluginPrivate * priv;
};

struct _SynapseActionPluginClass {
	SynapseDataPluginClass parent_class;
	gboolean (*handles_unknown) (SynapseActionPlugin* self);
	SynapseResultSet* (*find_for_match) (SynapseActionPlugin* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*provides_data) (SynapseActionPlugin* self);
};

struct _SynapseCommonActions {
	SynapseActionPlugin parent_instance;
	SynapseCommonActionsPrivate * priv;
};

struct _SynapseCommonActionsClass {
	SynapseActionPluginClass parent_class;
};

struct _SynapseCommonActionsPrivate {
	GeeList* actions;
};

typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

struct _SynapseCommonActionsAction {
	GObject parent_instance;
	SynapseCommonActionsActionPrivate * priv;
};

struct _SynapseCommonActionsActionClass {
	GObjectClass parent_class;
	gboolean (*valid_for_match) (SynapseCommonActionsAction* self, SynapseMatch* match);
	void (*execute_internal) (SynapseCommonActionsAction* self, SynapseMatch* match);
};

struct _SynapseCommonActionsActionPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
	gboolean _notify_match;
};

struct _SynapseCommonActionsRunner {
	SynapseCommonActionsAction parent_instance;
	SynapseCommonActionsRunnerPrivate * priv;
};

struct _SynapseCommonActionsRunnerClass {
	SynapseCommonActionsActionClass parent_class;
};

typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 200,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 500,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 1000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 2000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 1500,
	SYNAPSE_MATCH_SCORE_POOR = 5000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 6000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 7000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 7500,
	SYNAPSE_MATCH_SCORE_GOOD = 8000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 8500,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 9000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 10000
} SynapseMatchScore;

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

struct _SynapseCommonActionsTerminalRunner {
	SynapseCommonActionsAction parent_instance;
	SynapseCommonActionsTerminalRunnerPrivate * priv;
};

struct _SynapseCommonActionsTerminalRunnerClass {
	SynapseCommonActionsActionClass parent_class;
};

struct _SynapseCommonActionsOpener {
	SynapseCommonActionsAction parent_instance;
	SynapseCommonActionsOpenerPrivate * priv;
};

struct _SynapseCommonActionsOpenerClass {
	SynapseCommonActionsActionClass parent_class;
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseCommonActionsOpenFolder {
	SynapseCommonActionsAction parent_instance;
	SynapseCommonActionsOpenFolderPrivate * priv;
};

struct _SynapseCommonActionsOpenFolderClass {
	SynapseCommonActionsActionClass parent_class;
};


static gpointer synapse_common_actions_parent_class = NULL;
static gpointer synapse_common_actions_action_parent_class = NULL;
static SynapseMatchIface* synapse_common_actions_action_synapse_match_parent_iface = NULL;
static gpointer synapse_common_actions_runner_parent_class = NULL;
static gpointer synapse_common_actions_terminal_runner_parent_class = NULL;
static gpointer synapse_common_actions_opener_parent_class = NULL;
static gpointer synapse_common_actions_open_folder_parent_class = NULL;

GType synapse_data_plugin_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self, SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_action_plugin_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_common_actions_get_type (void) G_GNUC_CONST;
static GType synapse_common_actions_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_COMMON_ACTIONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsPrivate))
enum  {
	SYNAPSE_COMMON_ACTIONS_DUMMY_PROPERTY
};
static gboolean synapse_common_actions_real_handles_unknown (SynapseActionPlugin* base);
static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionPlugin* base, SynapseQuery* query, SynapseMatch* match);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
static gboolean synapse_common_actions_action_valid_for_match (SynapseCommonActionsAction* self, SynapseMatch* match);
void synapse_result_set_add (SynapseResultSet* self, SynapseMatch* match, gint relevancy);
static gint synapse_common_actions_action_get_default_relevancy (SynapseCommonActionsAction* self);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GeeList* synapse_query_get_matchers_for_query (const gchar* query, SynapseMatcherFlags match_flags, GRegexCompileFlags flags);
const gchar* synapse_match_get_title (SynapseMatch* self);
SynapseCommonActions* synapse_common_actions_new (void);
SynapseCommonActions* synapse_common_actions_construct (GType object_type);
SynapseActionPlugin* synapse_action_plugin_construct (GType object_type);
static GObject * synapse_common_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static SynapseCommonActionsRunner* synapse_common_actions_runner_new (void);
static SynapseCommonActionsRunner* synapse_common_actions_runner_construct (GType object_type);
static GType synapse_common_actions_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_new (void);
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_construct (GType object_type);
static GType synapse_common_actions_terminal_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsOpener* synapse_common_actions_opener_new (void);
static SynapseCommonActionsOpener* synapse_common_actions_opener_construct (GType object_type);
static GType synapse_common_actions_opener_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_new (void);
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_construct (GType object_type);
static GType synapse_common_actions_open_folder_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SYNAPSE_COMMON_ACTIONS_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, SynapseCommonActionsActionPrivate))
enum  {
	SYNAPSE_COMMON_ACTIONS_ACTION_DUMMY_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_ACTION_TITLE,
	SYNAPSE_COMMON_ACTIONS_ACTION_DESCRIPTION,
	SYNAPSE_COMMON_ACTIONS_ACTION_ICON_NAME,
	SYNAPSE_COMMON_ACTIONS_ACTION_HAS_THUMBNAIL,
	SYNAPSE_COMMON_ACTIONS_ACTION_THUMBNAIL_PATH,
	SYNAPSE_COMMON_ACTIONS_ACTION_MATCH_TYPE,
	SYNAPSE_COMMON_ACTIONS_ACTION_DEFAULT_RELEVANCY,
	SYNAPSE_COMMON_ACTIONS_ACTION_NOTIFY_MATCH
};
static gboolean synapse_common_actions_action_real_valid_for_match (SynapseCommonActionsAction* self, SynapseMatch* match);
static void synapse_common_actions_action_execute_internal (SynapseCommonActionsAction* self, SynapseMatch* match);
static void synapse_common_actions_action_real_execute_internal (SynapseCommonActionsAction* self, SynapseMatch* match);
static void synapse_common_actions_action_real_execute (SynapseMatch* base, SynapseMatch* match);
static gboolean synapse_common_actions_action_get_notify_match (SynapseCommonActionsAction* self);
static SynapseCommonActionsAction* synapse_common_actions_action_construct (GType object_type);
static void synapse_common_actions_action_set_default_relevancy (SynapseCommonActionsAction* self, gint value);
static void synapse_common_actions_action_set_notify_match (SynapseCommonActionsAction* self, gboolean value);
static void synapse_common_actions_action_finalize (GObject* obj);
const gchar* synapse_match_get_description (SynapseMatch* self);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
static void _vala_synapse_common_actions_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void synapse_match_set_title (SynapseMatch* self, const gchar* value);
void synapse_match_set_description (SynapseMatch* self, const gchar* value);
void synapse_match_set_icon_name (SynapseMatch* self, const gchar* value);
void synapse_match_set_has_thumbnail (SynapseMatch* self, gboolean value);
void synapse_match_set_thumbnail_path (SynapseMatch* self, const gchar* value);
void synapse_match_set_match_type (SynapseMatch* self, SynapseMatchType value);
static void _vala_synapse_common_actions_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SYNAPSE_COMMON_ACTIONS_RUNNER_DUMMY_PROPERTY
};
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void synapse_common_actions_runner_real_execute_internal (SynapseCommonActionsAction* base, SynapseMatch* match);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
void synapse_relevancy_service_application_launched (SynapseRelevancyService* self, GAppInfo* app_info);
void synapse_match_execute (SynapseMatch* self, SynapseMatch* match);
static gboolean synapse_common_actions_runner_real_valid_for_match (SynapseCommonActionsAction* base, SynapseMatch* match);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
enum  {
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_DUMMY_PROPERTY
};
static void synapse_common_actions_terminal_runner_real_execute_internal (SynapseCommonActionsAction* base, SynapseMatch* match);
static gboolean synapse_common_actions_terminal_runner_real_valid_for_match (SynapseCommonActionsAction* base, SynapseMatch* match);
enum  {
	SYNAPSE_COMMON_ACTIONS_OPENER_DUMMY_PROPERTY
};
static void synapse_common_actions_opener_real_execute_internal (SynapseCommonActionsAction* base, SynapseMatch* match);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean synapse_common_actions_opener_real_valid_for_match (SynapseCommonActionsAction* base, SynapseMatch* match);
enum  {
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_DUMMY_PROPERTY
};
static void synapse_common_actions_open_folder_real_execute_internal (SynapseCommonActionsAction* base, SynapseMatch* match);
static gboolean synapse_common_actions_open_folder_real_valid_for_match (SynapseCommonActionsAction* base, SynapseMatch* match);
static void synapse_common_actions_finalize (GObject* obj);


static gboolean synapse_common_actions_real_handles_unknown (SynapseActionPlugin* base) {
	SynapseCommonActions * self;
	gboolean result = FALSE;
	self = (SynapseCommonActions*) base;
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionPlugin* base, SynapseQuery* query, SynapseMatch* match) {
	SynapseCommonActions * self;
	SynapseResultSet* result = NULL;
	gboolean query_empty;
	SynapseResultSet* _tmp0_ = NULL;
	SynapseResultSet* results;
	self = (SynapseCommonActions*) base;
	g_return_val_if_fail (match != NULL, NULL);
	query_empty = g_strcmp0 ((*query).query_string, "") == 0;
	_tmp0_ = synapse_result_set_new ();
	results = _tmp0_;
	if (query_empty) {
		{
			GeeList* _tmp1_;
			GeeList* _action_list;
			gint _tmp2_;
			gint _action_size;
			gint _action_index;
			_tmp1_ = _g_object_ref0 (self->priv->actions);
			_action_list = _tmp1_;
			_tmp2_ = gee_collection_get_size ((GeeCollection*) _action_list);
			_action_size = _tmp2_;
			_action_index = -1;
			while (TRUE) {
				gpointer _tmp3_ = NULL;
				SynapseCommonActionsAction* action;
				gboolean _tmp4_;
				_action_index = _action_index + 1;
				if (!(_action_index < _action_size)) {
					break;
				}
				_tmp3_ = gee_list_get (_action_list, _action_index);
				action = (SynapseCommonActionsAction*) _tmp3_;
				_tmp4_ = synapse_common_actions_action_valid_for_match (action, match);
				if (_tmp4_) {
					gint _tmp5_;
					_tmp5_ = synapse_common_actions_action_get_default_relevancy (action);
					synapse_result_set_add (results, (SynapseMatch*) action, _tmp5_);
				}
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_list);
		}
	} else {
		GeeList* _tmp6_ = NULL;
		GeeList* matchers;
		_tmp6_ = synapse_query_get_matchers_for_query ((*query).query_string, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
		matchers = _tmp6_;
		{
			GeeList* _tmp7_;
			GeeList* _action_list;
			gint _tmp8_;
			gint _action_size;
			gint _action_index;
			_tmp7_ = _g_object_ref0 (self->priv->actions);
			_action_list = _tmp7_;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) _action_list);
			_action_size = _tmp8_;
			_action_index = -1;
			while (TRUE) {
				gpointer _tmp9_ = NULL;
				SynapseCommonActionsAction* action;
				gboolean _tmp10_;
				_action_index = _action_index + 1;
				if (!(_action_index < _action_size)) {
					break;
				}
				_tmp9_ = gee_list_get (_action_list, _action_index);
				action = (SynapseCommonActionsAction*) _tmp9_;
				_tmp10_ = synapse_common_actions_action_valid_for_match (action, match);
				if (!_tmp10_) {
					_g_object_unref0 (action);
					continue;
				}
				{
					GeeList* _tmp11_;
					GeeList* _matcher_list;
					gint _tmp12_;
					gint _matcher_size;
					gint _matcher_index;
					_tmp11_ = _g_object_ref0 (matchers);
					_matcher_list = _tmp11_;
					_tmp12_ = gee_collection_get_size ((GeeCollection*) _matcher_list);
					_matcher_size = _tmp12_;
					_matcher_index = -1;
					while (TRUE) {
						gpointer _tmp13_ = NULL;
						GeeMapEntry* matcher;
						gconstpointer _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						gboolean _tmp16_;
						_matcher_index = _matcher_index + 1;
						if (!(_matcher_index < _matcher_size)) {
							break;
						}
						_tmp13_ = gee_list_get (_matcher_list, _matcher_index);
						matcher = (GeeMapEntry*) _tmp13_;
						_tmp14_ = gee_map_entry_get_key (matcher);
						_tmp15_ = synapse_match_get_title ((SynapseMatch*) action);
						_tmp16_ = g_regex_match ((GRegex*) _tmp14_, _tmp15_, 0, NULL);
						if (_tmp16_) {
							gconstpointer _tmp17_ = NULL;
							_tmp17_ = gee_map_entry_get_value (matcher);
							synapse_result_set_add (results, (SynapseMatch*) action, GPOINTER_TO_INT (_tmp17_));
							_g_object_unref0 (matcher);
							break;
						}
						_g_object_unref0 (matcher);
					}
					_g_object_unref0 (_matcher_list);
				}
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_list);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


SynapseCommonActions* synapse_common_actions_construct (GType object_type) {
	SynapseCommonActions * self = NULL;
	self = (SynapseCommonActions*) synapse_action_plugin_construct (object_type);
	return self;
}


SynapseCommonActions* synapse_common_actions_new (void) {
	return synapse_common_actions_construct (SYNAPSE_TYPE_COMMON_ACTIONS);
}


static GObject * synapse_common_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActions * self;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* _tmp1_;
	SynapseCommonActionsRunner* _tmp2_ = NULL;
	SynapseCommonActionsRunner* _tmp3_;
	SynapseCommonActionsTerminalRunner* _tmp4_ = NULL;
	SynapseCommonActionsTerminalRunner* _tmp5_;
	SynapseCommonActionsOpener* _tmp6_ = NULL;
	SynapseCommonActionsOpener* _tmp7_;
	SynapseCommonActionsOpenFolder* _tmp8_ = NULL;
	SynapseCommonActionsOpenFolder* _tmp9_;
	parent_class = G_OBJECT_CLASS (synapse_common_actions_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SYNAPSE_COMMON_ACTIONS (obj);
	_tmp0_ = gee_array_list_new (SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp1_ = (GeeList*) _tmp0_;
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp1_;
	_tmp2_ = synapse_common_actions_runner_new ();
	_tmp3_ = _tmp2_;
	gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseCommonActionsAction*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = synapse_common_actions_terminal_runner_new ();
	_tmp5_ = _tmp4_;
	gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseCommonActionsAction*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = synapse_common_actions_opener_new ();
	_tmp7_ = _tmp6_;
	gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseCommonActionsAction*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = synapse_common_actions_open_folder_new ();
	_tmp9_ = _tmp8_;
	gee_collection_add ((GeeCollection*) self->priv->actions, (SynapseCommonActionsAction*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	return obj;
}


static gboolean synapse_common_actions_action_real_valid_for_match (SynapseCommonActionsAction* self, SynapseMatch* match) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `synapse_common_actions_action_valid_for_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean synapse_common_actions_action_valid_for_match (SynapseCommonActionsAction* self, SynapseMatch* match) {
	return SYNAPSE_COMMON_ACTIONS_ACTION_GET_CLASS (self)->valid_for_match (self, match);
}


static void synapse_common_actions_action_real_execute_internal (SynapseCommonActionsAction* self, SynapseMatch* match) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `synapse_common_actions_action_execute_internal'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void synapse_common_actions_action_execute_internal (SynapseCommonActionsAction* self, SynapseMatch* match) {
	SYNAPSE_COMMON_ACTIONS_ACTION_GET_CLASS (self)->execute_internal (self, match);
}


static void synapse_common_actions_action_real_execute (SynapseMatch* base, SynapseMatch* match) {
	SynapseCommonActionsAction * self;
	self = (SynapseCommonActionsAction*) base;
	synapse_common_actions_action_execute_internal (self, match);
	if (self->priv->_notify_match) {
		g_signal_emit_by_name (match, "executed");
	}
}


static SynapseCommonActionsAction* synapse_common_actions_action_construct (GType object_type) {
	SynapseCommonActionsAction * self = NULL;
	self = (SynapseCommonActionsAction*) g_object_new (object_type, NULL);
	return self;
}


static const gchar* synapse_common_actions_action_real_get_title (SynapseMatch* base) {
	const gchar* result;
	SynapseCommonActionsAction* self;
	self = (SynapseCommonActionsAction*) base;
	result = self->priv->_title;
	return result;
}


static void synapse_common_actions_action_real_set_title (SynapseMatch* base, const gchar* value) {
	SynapseCommonActionsAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommonActionsAction*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


static const gchar* synapse_common_actions_action_real_get_description (SynapseMatch* base) {
	const gchar* result;
	SynapseCommonActionsAction* self;
	self = (SynapseCommonActionsAction*) base;
	result = self->priv->_description;
	return result;
}


static void synapse_common_actions_action_real_set_description (SynapseMatch* base, const gchar* value) {
	SynapseCommonActionsAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommonActionsAction*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static const gchar* synapse_common_actions_action_real_get_icon_name (SynapseMatch* base) {
	const gchar* result;
	SynapseCommonActionsAction* self;
	self = (SynapseCommonActionsAction*) base;
	result = self->priv->_icon_name;
	return result;
}


static void synapse_common_actions_action_real_set_icon_name (SynapseMatch* base, const gchar* value) {
	SynapseCommonActionsAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommonActionsAction*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


static gboolean synapse_common_actions_action_real_get_has_thumbnail (SynapseMatch* base) {
	gboolean result;
	SynapseCommonActionsAction* self;
	self = (SynapseCommonActionsAction*) base;
	result = self->priv->_has_thumbnail;
	return result;
}


static void synapse_common_actions_action_real_set_has_thumbnail (SynapseMatch* base, gboolean value) {
	SynapseCommonActionsAction* self;
	self = (SynapseCommonActionsAction*) base;
	self->priv->_has_thumbnail = value;
	g_object_notify ((GObject *) self, "has-thumbnail");
}


static const gchar* synapse_common_actions_action_real_get_thumbnail_path (SynapseMatch* base) {
	const gchar* result;
	SynapseCommonActionsAction* self;
	self = (SynapseCommonActionsAction*) base;
	result = self->priv->_thumbnail_path;
	return result;
}


static void synapse_common_actions_action_real_set_thumbnail_path (SynapseMatch* base, const gchar* value) {
	SynapseCommonActionsAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SynapseCommonActionsAction*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp1_;
	g_object_notify ((GObject *) self, "thumbnail-path");
}


static SynapseMatchType synapse_common_actions_action_real_get_match_type (SynapseMatch* base) {
	SynapseMatchType result;
	SynapseCommonActionsAction* self;
	self = (SynapseCommonActionsAction*) base;
	result = self->priv->_match_type;
	return result;
}


static void synapse_common_actions_action_real_set_match_type (SynapseMatch* base, SynapseMatchType value) {
	SynapseCommonActionsAction* self;
	self = (SynapseCommonActionsAction*) base;
	self->priv->_match_type = value;
	g_object_notify ((GObject *) self, "match-type");
}


static gint synapse_common_actions_action_get_default_relevancy (SynapseCommonActionsAction* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}


static void synapse_common_actions_action_set_default_relevancy (SynapseCommonActionsAction* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_default_relevancy = value;
	g_object_notify ((GObject *) self, "default-relevancy");
}


static gboolean synapse_common_actions_action_get_notify_match (SynapseCommonActionsAction* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_notify_match;
	return result;
}


static void synapse_common_actions_action_set_notify_match (SynapseCommonActionsAction* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_notify_match = value;
	g_object_notify ((GObject *) self, "notify-match");
}


static void synapse_common_actions_action_class_init (SynapseCommonActionsActionClass * klass) {
	synapse_common_actions_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseCommonActionsActionPrivate));
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_action_real_valid_for_match;
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->execute_internal = synapse_common_actions_action_real_execute_internal;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_common_actions_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_common_actions_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_action_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ACTION_TITLE, "title");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ACTION_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ACTION_ICON_NAME, "icon-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ACTION_HAS_THUMBNAIL, "has-thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ACTION_THUMBNAIL_PATH, "thumbnail-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ACTION_MATCH_TYPE, "match-type");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ACTION_DEFAULT_RELEVANCY, g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ACTION_NOTIFY_MATCH, g_param_spec_boolean ("notify-match", "notify-match", "notify-match", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void synapse_common_actions_action_synapse_match_interface_init (SynapseMatchIface * iface) {
	synapse_common_actions_action_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->execute = (void (*)(SynapseMatch* ,SynapseMatch*)) synapse_common_actions_action_real_execute;
	iface->get_title = synapse_common_actions_action_real_get_title;
	iface->set_title = synapse_common_actions_action_real_set_title;
	iface->get_description = synapse_common_actions_action_real_get_description;
	iface->set_description = synapse_common_actions_action_real_set_description;
	iface->get_icon_name = synapse_common_actions_action_real_get_icon_name;
	iface->set_icon_name = synapse_common_actions_action_real_set_icon_name;
	iface->get_has_thumbnail = synapse_common_actions_action_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_common_actions_action_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_common_actions_action_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_common_actions_action_real_set_thumbnail_path;
	iface->get_match_type = synapse_common_actions_action_real_get_match_type;
	iface->set_match_type = synapse_common_actions_action_real_set_match_type;
}


static void synapse_common_actions_action_instance_init (SynapseCommonActionsAction * self) {
	self->priv = SYNAPSE_COMMON_ACTIONS_ACTION_GET_PRIVATE (self);
	self->priv->_notify_match = TRUE;
}


static void synapse_common_actions_action_finalize (GObject* obj) {
	SynapseCommonActionsAction * self;
	self = SYNAPSE_COMMON_ACTIONS_ACTION (obj);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_common_actions_action_parent_class)->finalize (obj);
}


static GType synapse_common_actions_action_get_type (void) {
	static volatile gsize synapse_common_actions_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsAction), 0, (GInstanceInitFunc) synapse_common_actions_action_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_common_actions_action_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_common_actions_action_type_id;
		synapse_common_actions_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommonActionsAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (synapse_common_actions_action_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_once_init_leave (&synapse_common_actions_action_type_id__volatile, synapse_common_actions_action_type_id);
	}
	return synapse_common_actions_action_type_id__volatile;
}


static void _vala_synapse_common_actions_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SynapseCommonActionsAction * self;
	self = SYNAPSE_COMMON_ACTIONS_ACTION (object);
	switch (property_id) {
		case SYNAPSE_COMMON_ACTIONS_ACTION_TITLE:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_DESCRIPTION:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_ICON_NAME:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_HAS_THUMBNAIL:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_THUMBNAIL_PATH:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_MATCH_TYPE:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_DEFAULT_RELEVANCY:
		g_value_set_int (value, synapse_common_actions_action_get_default_relevancy (self));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_NOTIFY_MATCH:
		g_value_set_boolean (value, synapse_common_actions_action_get_notify_match (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_synapse_common_actions_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SynapseCommonActionsAction * self;
	self = SYNAPSE_COMMON_ACTIONS_ACTION (object);
	switch (property_id) {
		case SYNAPSE_COMMON_ACTIONS_ACTION_TITLE:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_DESCRIPTION:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_ICON_NAME:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_HAS_THUMBNAIL:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_THUMBNAIL_PATH:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_MATCH_TYPE:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_DEFAULT_RELEVANCY:
		synapse_common_actions_action_set_default_relevancy (self, g_value_get_int (value));
		break;
		case SYNAPSE_COMMON_ACTIONS_ACTION_NOTIFY_MATCH:
		synapse_common_actions_action_set_notify_match (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static SynapseCommonActionsRunner* synapse_common_actions_runner_construct (GType object_type) {
	SynapseCommonActionsRunner * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Run");
	_tmp1_ = _ ("Run an application, action or script");
	self = (SynapseCommonActionsRunner*) g_object_new (object_type, "title", _tmp0_, "description", _tmp1_, "icon-name", "system-run", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_EXCELLENT, NULL);
	return self;
}


static SynapseCommonActionsRunner* synapse_common_actions_runner_new (void) {
	return synapse_common_actions_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER);
}


static void synapse_common_actions_runner_real_execute_internal (SynapseCommonActionsAction* base, SynapseMatch* match) {
	SynapseCommonActionsRunner * self;
	SynapseMatchType _tmp0_;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsRunner*) base;
	_tmp0_ = synapse_match_get_match_type (match);
	if (_tmp0_ == SYNAPSE_MATCH_TYPE_APPLICATION) {
		SynapseMatch* _tmp1_;
		SynapseApplicationMatch* _tmp2_;
		SynapseApplicationMatch* app_match;
		GAppInfo* _tmp3_ = NULL;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		GAppInfo* _tmp9_;
		GAppInfo* app;
		GdkAppLaunchContext* _tmp10_ = NULL;
		GdkAppLaunchContext* _tmp11_;
		SynapseRelevancyService* _tmp12_ = NULL;
		SynapseRelevancyService* _tmp13_;
		_tmp2_ = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_APPLICATION_MATCH (_tmp1_) ? ((SynapseApplicationMatch*) _tmp1_) : NULL));
		app_match = _tmp2_;
		g_return_if_fail (app_match != NULL);
		_tmp3_ = synapse_application_match_get_app_info (app_match);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == NULL) {
			const gchar* _tmp6_ = NULL;
			GDesktopAppInfo* _tmp7_ = NULL;
			GAppInfo* _tmp8_;
			_tmp6_ = synapse_application_match_get_filename (app_match);
			_tmp7_ = g_desktop_app_info_new_from_filename (_tmp6_);
			_tmp8_ = (GAppInfo*) _tmp7_;
			_g_object_unref0 (_tmp5_);
			_tmp5_ = _tmp8_;
		}
		_tmp9_ = _g_object_ref0 (_tmp5_);
		app = _tmp9_;
		_tmp10_ = gdk_app_launch_context_new ();
		_tmp11_ = _tmp10_;
		g_app_info_launch (app, NULL, (GAppLaunchContext*) _tmp11_, &_inner_error_);
		_g_object_unref0 (_tmp11_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp12_ = synapse_relevancy_service_get_default ();
		_tmp13_ = _tmp12_;
		synapse_relevancy_service_application_launched (_tmp13_, app);
		_g_object_unref0 (_tmp13_);
		goto __finally0;
		__catch0_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("common-actions.vala:77: %s", err->message);
			_g_error_free0 (err);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (app);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (app_match);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (app);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (app_match);
	} else {
		synapse_match_execute (match, NULL);
	}
}


static gboolean synapse_common_actions_runner_real_valid_for_match (SynapseCommonActionsAction* base, SynapseMatch* match) {
	SynapseCommonActionsRunner * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	self = (SynapseCommonActionsRunner*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	switch (_tmp0_) {
		case SYNAPSE_MATCH_TYPE_SEARCH:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_ACTION:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_APPLICATION:
		{
			SynapseMatch* _tmp1_;
			SynapseApplicationMatch* _tmp2_;
			SynapseApplicationMatch* am;
			gboolean _tmp3_ = FALSE;
			_tmp2_ = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_APPLICATION_MATCH (_tmp1_) ? ((SynapseApplicationMatch*) _tmp1_) : NULL));
			am = _tmp2_;
			if (am == NULL) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp4_;
				_tmp4_ = synapse_application_match_get_needs_terminal (am);
				_tmp3_ = !_tmp4_;
			}
			result = _tmp3_;
			_g_object_unref0 (am);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void synapse_common_actions_runner_class_init (SynapseCommonActionsRunnerClass * klass) {
	synapse_common_actions_runner_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->execute_internal = synapse_common_actions_runner_real_execute_internal;
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_runner_real_valid_for_match;
}


static void synapse_common_actions_runner_instance_init (SynapseCommonActionsRunner * self) {
}


static GType synapse_common_actions_runner_get_type (void) {
	static volatile gsize synapse_common_actions_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsRunner), 0, (GInstanceInitFunc) synapse_common_actions_runner_instance_init, NULL };
		GType synapse_common_actions_runner_type_id;
		synapse_common_actions_runner_type_id = g_type_register_static (SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, "SynapseCommonActionsRunner", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_runner_type_id__volatile, synapse_common_actions_runner_type_id);
	}
	return synapse_common_actions_runner_type_id__volatile;
}


static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_construct (GType object_type) {
	SynapseCommonActionsTerminalRunner * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Run in Terminal");
	_tmp1_ = _ ("Run application or command in terminal");
	self = (SynapseCommonActionsTerminalRunner*) g_object_new (object_type, "title", _tmp0_, "description", _tmp1_, "icon-name", "terminal", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, NULL);
	return self;
}


static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_new (void) {
	return synapse_common_actions_terminal_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER);
}


static void synapse_common_actions_terminal_runner_real_execute_internal (SynapseCommonActionsAction* base, SynapseMatch* match) {
	SynapseCommonActionsTerminalRunner * self;
	SynapseMatchType _tmp0_;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsTerminalRunner*) base;
	_tmp0_ = synapse_match_get_match_type (match);
	if (_tmp0_ == SYNAPSE_MATCH_TYPE_APPLICATION) {
		SynapseMatch* _tmp1_;
		SynapseApplicationMatch* _tmp2_;
		SynapseApplicationMatch* app_match;
		GAppInfo* _tmp3_ = NULL;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		GAppInfo* _tmp9_;
		GAppInfo* original;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GAppInfo* _tmp12_ = NULL;
		GAppInfo* _tmp13_;
		GAppInfo* app;
		GdkAppLaunchContext* _tmp14_ = NULL;
		GdkAppLaunchContext* _tmp15_;
		_tmp2_ = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_APPLICATION_MATCH (_tmp1_) ? ((SynapseApplicationMatch*) _tmp1_) : NULL));
		app_match = _tmp2_;
		g_return_if_fail (app_match != NULL);
		_tmp3_ = synapse_application_match_get_app_info (app_match);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == NULL) {
			const gchar* _tmp6_ = NULL;
			GDesktopAppInfo* _tmp7_ = NULL;
			GAppInfo* _tmp8_;
			_tmp6_ = synapse_application_match_get_filename (app_match);
			_tmp7_ = g_desktop_app_info_new_from_filename (_tmp6_);
			_tmp8_ = (GAppInfo*) _tmp7_;
			_g_object_unref0 (_tmp5_);
			_tmp5_ = _tmp8_;
		}
		_tmp9_ = _g_object_ref0 (_tmp5_);
		original = _tmp9_;
		_tmp10_ = g_app_info_get_commandline (original);
		_tmp11_ = g_app_info_get_name (original);
		_tmp12_ = g_app_info_create_from_commandline (_tmp10_, _tmp11_, G_APP_INFO_CREATE_NEEDS_TERMINAL, &_inner_error_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		app = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (original);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (app_match);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = gdk_app_launch_context_new ();
		_tmp15_ = _tmp14_;
		g_app_info_launch (app, NULL, (GAppLaunchContext*) _tmp15_, &_inner_error_);
		_g_object_unref0 (_tmp15_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("common-actions.vala:133: %s", err->message);
			_g_error_free0 (err);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (app);
			_g_object_unref0 (original);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (app_match);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (app);
		_g_object_unref0 (original);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (app_match);
	}
}


static gboolean synapse_common_actions_terminal_runner_real_valid_for_match (SynapseCommonActionsAction* base, SynapseMatch* match) {
	SynapseCommonActionsTerminalRunner * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	self = (SynapseCommonActionsTerminalRunner*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	switch (_tmp0_) {
		case SYNAPSE_MATCH_TYPE_APPLICATION:
		{
			SynapseMatch* _tmp1_;
			SynapseApplicationMatch* _tmp2_;
			SynapseApplicationMatch* am;
			_tmp2_ = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_APPLICATION_MATCH (_tmp1_) ? ((SynapseApplicationMatch*) _tmp1_) : NULL));
			am = _tmp2_;
			result = am != NULL;
			_g_object_unref0 (am);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void synapse_common_actions_terminal_runner_class_init (SynapseCommonActionsTerminalRunnerClass * klass) {
	synapse_common_actions_terminal_runner_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->execute_internal = synapse_common_actions_terminal_runner_real_execute_internal;
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_terminal_runner_real_valid_for_match;
}


static void synapse_common_actions_terminal_runner_instance_init (SynapseCommonActionsTerminalRunner * self) {
}


static GType synapse_common_actions_terminal_runner_get_type (void) {
	static volatile gsize synapse_common_actions_terminal_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_terminal_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsTerminalRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_terminal_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsTerminalRunner), 0, (GInstanceInitFunc) synapse_common_actions_terminal_runner_instance_init, NULL };
		GType synapse_common_actions_terminal_runner_type_id;
		synapse_common_actions_terminal_runner_type_id = g_type_register_static (SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, "SynapseCommonActionsTerminalRunner", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_terminal_runner_type_id__volatile, synapse_common_actions_terminal_runner_type_id);
	}
	return synapse_common_actions_terminal_runner_type_id__volatile;
}


static SynapseCommonActionsOpener* synapse_common_actions_opener_construct (GType object_type) {
	SynapseCommonActionsOpener * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Open");
	_tmp1_ = _ ("Open using default application");
	self = (SynapseCommonActionsOpener*) g_object_new (object_type, "title", _tmp0_, "description", _tmp1_, "icon-name", "fileopen", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_GOOD, NULL);
	return self;
}


static SynapseCommonActionsOpener* synapse_common_actions_opener_new (void) {
	return synapse_common_actions_opener_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPENER);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void synapse_common_actions_opener_real_execute_internal (SynapseCommonActionsAction* base, SynapseMatch* match) {
	SynapseCommonActionsOpener * self;
	SynapseMatch* _tmp0_;
	SynapseUriMatch* _tmp1_;
	SynapseUriMatch* uri_match;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* f;
	GAppInfo* _tmp4_ = NULL;
	GAppInfo* app_info;
	GList* files;
	GFile* _tmp5_;
	GdkAppLaunchContext* _tmp6_ = NULL;
	GdkAppLaunchContext* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsOpener*) base;
	_tmp1_ = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL));
	uri_match = _tmp1_;
	g_return_if_fail (uri_match != NULL);
	_tmp2_ = synapse_uri_match_get_uri (uri_match);
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	f = _tmp3_;
	_tmp4_ = g_file_query_default_handler (f, NULL, &_inner_error_);
	app_info = _tmp4_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	files = NULL;
	_tmp5_ = _g_object_ref0 (f);
	files = g_list_prepend (files, _tmp5_);
	_tmp6_ = gdk_app_launch_context_new ();
	_tmp7_ = _tmp6_;
	g_app_info_launch (app_info, files, (GAppLaunchContext*) _tmp7_, &_inner_error_);
	_g_object_unref0 (_tmp7_);
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (files);
		_g_object_unref0 (app_info);
		goto __catch2_g_error;
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (app_info);
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("common-actions.vala:176: %s", err->message);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		_g_object_unref0 (uri_match);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
}


static gboolean synapse_common_actions_opener_real_valid_for_match (SynapseCommonActionsAction* base, SynapseMatch* match) {
	SynapseCommonActionsOpener * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	self = (SynapseCommonActionsOpener*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	switch (_tmp0_) {
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void synapse_common_actions_opener_class_init (SynapseCommonActionsOpenerClass * klass) {
	synapse_common_actions_opener_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->execute_internal = synapse_common_actions_opener_real_execute_internal;
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_opener_real_valid_for_match;
}


static void synapse_common_actions_opener_instance_init (SynapseCommonActionsOpener * self) {
}


static GType synapse_common_actions_opener_get_type (void) {
	static volatile gsize synapse_common_actions_opener_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_opener_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_opener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpener), 0, (GInstanceInitFunc) synapse_common_actions_opener_instance_init, NULL };
		GType synapse_common_actions_opener_type_id;
		synapse_common_actions_opener_type_id = g_type_register_static (SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, "SynapseCommonActionsOpener", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_opener_type_id__volatile, synapse_common_actions_opener_type_id);
	}
	return synapse_common_actions_opener_type_id__volatile;
}


static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_construct (GType object_type) {
	SynapseCommonActionsOpenFolder * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Open folder");
	_tmp1_ = _ ("Open folder containing this file");
	self = (SynapseCommonActionsOpenFolder*) g_object_new (object_type, "title", _tmp0_, "description", _tmp1_, "icon-name", "folder-open", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
	return self;
}


static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_new (void) {
	return synapse_common_actions_open_folder_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER);
}


static void synapse_common_actions_open_folder_real_execute_internal (SynapseCommonActionsAction* base, SynapseMatch* match) {
	SynapseCommonActionsOpenFolder * self;
	SynapseMatch* _tmp0_;
	SynapseUriMatch* _tmp1_;
	SynapseUriMatch* uri_match;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* f;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	GAppInfo* _tmp6_ = NULL;
	GAppInfo* app_info;
	GList* files;
	GFile* _tmp7_;
	GdkAppLaunchContext* _tmp8_ = NULL;
	GdkAppLaunchContext* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsOpenFolder*) base;
	_tmp1_ = _g_object_ref0 ((_tmp0_ = match, SYNAPSE_IS_URI_MATCH (_tmp0_) ? ((SynapseUriMatch*) _tmp0_) : NULL));
	uri_match = _tmp1_;
	g_return_if_fail (uri_match != NULL);
	_tmp2_ = synapse_uri_match_get_uri (uri_match);
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	f = _tmp3_;
	_tmp4_ = g_file_get_parent (f);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (f);
	f = _tmp5_;
	_tmp6_ = g_file_query_default_handler (f, NULL, &_inner_error_);
	app_info = _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	files = NULL;
	_tmp7_ = _g_object_ref0 (f);
	files = g_list_prepend (files, _tmp7_);
	_tmp8_ = gdk_app_launch_context_new ();
	_tmp9_ = _tmp8_;
	g_app_info_launch (app_info, files, (GAppLaunchContext*) _tmp9_, &_inner_error_);
	_g_object_unref0 (_tmp9_);
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (files);
		_g_object_unref0 (app_info);
		goto __catch3_g_error;
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (app_info);
	goto __finally3;
	__catch3_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("common-actions.vala:218: %s", err->message);
		_g_error_free0 (err);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		_g_object_unref0 (uri_match);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
}


static gboolean synapse_common_actions_open_folder_real_valid_for_match (SynapseCommonActionsAction* base, SynapseMatch* match) {
	SynapseCommonActionsOpenFolder * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	SynapseMatch* _tmp1_;
	SynapseUriMatch* _tmp2_;
	SynapseUriMatch* uri_match;
	const gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* f;
	GFile* _tmp5_ = NULL;
	GFile* parent;
	gboolean _tmp6_ = FALSE;
	self = (SynapseCommonActionsOpenFolder*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	if (_tmp0_ != SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		result = FALSE;
		return result;
	}
	_tmp2_ = _g_object_ref0 ((_tmp1_ = match, SYNAPSE_IS_URI_MATCH (_tmp1_) ? ((SynapseUriMatch*) _tmp1_) : NULL));
	uri_match = _tmp2_;
	_tmp3_ = synapse_uri_match_get_uri (uri_match);
	_tmp4_ = g_file_new_for_uri (_tmp3_);
	f = _tmp4_;
	_tmp5_ = g_file_get_parent (f);
	parent = _tmp5_;
	if (parent != NULL) {
		gboolean _tmp7_;
		_tmp7_ = g_file_is_native (f);
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	_g_object_unref0 (parent);
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
	return result;
}


static void synapse_common_actions_open_folder_class_init (SynapseCommonActionsOpenFolderClass * klass) {
	synapse_common_actions_open_folder_parent_class = g_type_class_peek_parent (klass);
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->execute_internal = synapse_common_actions_open_folder_real_execute_internal;
	SYNAPSE_COMMON_ACTIONS_ACTION_CLASS (klass)->valid_for_match = synapse_common_actions_open_folder_real_valid_for_match;
}


static void synapse_common_actions_open_folder_instance_init (SynapseCommonActionsOpenFolder * self) {
}


static GType synapse_common_actions_open_folder_get_type (void) {
	static volatile gsize synapse_common_actions_open_folder_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_open_folder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_open_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpenFolder), 0, (GInstanceInitFunc) synapse_common_actions_open_folder_instance_init, NULL };
		GType synapse_common_actions_open_folder_type_id;
		synapse_common_actions_open_folder_type_id = g_type_register_static (SYNAPSE_COMMON_ACTIONS_TYPE_ACTION, "SynapseCommonActionsOpenFolder", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_open_folder_type_id__volatile, synapse_common_actions_open_folder_type_id);
	}
	return synapse_common_actions_open_folder_type_id__volatile;
}


static void synapse_common_actions_class_init (SynapseCommonActionsClass * klass) {
	synapse_common_actions_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynapseCommonActionsPrivate));
	SYNAPSE_ACTION_PLUGIN_CLASS (klass)->handles_unknown = synapse_common_actions_real_handles_unknown;
	SYNAPSE_ACTION_PLUGIN_CLASS (klass)->find_for_match = synapse_common_actions_real_find_for_match;
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_finalize;
}


static void synapse_common_actions_instance_init (SynapseCommonActions * self) {
	self->priv = SYNAPSE_COMMON_ACTIONS_GET_PRIVATE (self);
}


static void synapse_common_actions_finalize (GObject* obj) {
	SynapseCommonActions * self;
	self = SYNAPSE_COMMON_ACTIONS (obj);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (synapse_common_actions_parent_class)->finalize (obj);
}


GType synapse_common_actions_get_type (void) {
	static volatile gsize synapse_common_actions_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActions), 0, (GInstanceInitFunc) synapse_common_actions_instance_init, NULL };
		GType synapse_common_actions_type_id;
		synapse_common_actions_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION_PLUGIN, "SynapseCommonActions", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_type_id__volatile, synapse_common_actions_type_id);
	}
	return synapse_common_actions_type_id__volatile;
}



