CHANGELOG for 5.3.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 5.3 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v5.3.0...v5.3.1

* 5.3.12 (2021-11-24)

 * security #cve-2021-41268 [SecurityBundle] Default signature_properties to the previous behavior (wouterj)
 * security #cve-2021-41267 [HttpKernel] Fix missing extra trusted header in sub-request (jderusse)
 * security #cve-2021-41270 [Serializer] Use single quote to escape formulas (jderusse)
 * bug #44232 [Cache] fix connecting to local Redis sockets (nicolas-grekas)
 * bug #44204 [HttpClient] fix closing curl multi handle when destructing client (nicolas-grekas)
 * bug #44208 [Process] exclude argv/argc from possible default env vars (nicolas-grekas)

* 5.3.11 (2021-11-22)

 * bug #44188 [VarExporter] fix exporting declared but unset properties when __sleep() is implemented (nicolas-grekas)
 * bug #44176 [Console] Default ansi option to null (jderusse)
 * bug #44119 [HttpClient][Mime] Add correct IDN flags for IDNA2008 compliance (j-bernard)
 * bug #44131 [Yaml] properly parse quoted strings tagged with !!str (xabbuh)
 * bug #42323 [TwigBridge] do not merge label classes into expanded choice labels (xabbuh)
 * bug #44110 [FrameworkBundle] Fix default PHP attributes support in validation and serializer configuration when doctrine/annotations is not installed with PHP 8 (fancyweb)
 * bug #44121 [Serializer] fix support for lazy properties (nicolas-grekas)
 * bug #44108 [FrameworkBundle][Messenger] remove `FlattenExceptionNormalizer` definition if serializer not available (kbond)
 * bug #44111 [Serializer] fix support for unset properties on PHP < 7.4 (nicolas-grekas)
 * bug #44070 [Process] intersect with getenv() to populate default envs (nicolas-grekas)
 * bug #43990 [Translation] [Loco] Generate id parameter instead of letting Loco do it (welcoMattic)
 * bug #44043 [Cache] fix dbindex Redis (a1812)
 * bug #44050 [Notifier] Fix package names (fabpot)
 * bug #44042 Fix DateIntervalToStringTransformer::transform() doc (BenMorel)
 * bug #44034 [Yaml] don't try to replace references in quoted strings (xabbuh)
 * bug #44028 [ErrorHandler] Fix FlattenException::setPrevious argument typing (welcoMattic)
 * bug #44012 [DependencyInjection] fix inlining when non-shared services are involved (nicolas-grekas)
 * bug #44002 [Cache] Fix Memory leak (a1812)
 * bug #43981 [FrameworkBundle] fix registering late resettable services (nicolas-grekas)
 * bug #43988 [DoctrineBridge] add support for the JSON type (dunglas)
 * bug #43987 [PhpUnitBridge] Fix Uncaught ValueError (dunglas)
 * bug #43961 [HttpClient] Curl http client has to reinit curl multi handle on reset (rmikalkenas)
 * bug #43948 [Asset][Security] Fixed leftover deprecations PHP 8.1 (michaljusiega)
 * bug #43945 [Runtime] fix defining APP_DEBUG when Dotenv is not enabled (nicolas-grekas)
 * bug #43922 [DependencyInjection] only allow `ReflectionNamedType` for `ServiceSubscriberTrait` (kbond)
 * bug #43814 [Intl] Update the ICU data to 70.1 - 5.3 (jderusse)
 * bug #43915 [Messenger] Fix tests (jderusse)
 * bug #43901 [SecurityBundle] Default access_decision_manager.strategy option with merge (biozshock)
 * bug #43909 [VarExporter] escape unicode chars involved in directionality (nicolas-grekas)
 * bug #43900 [Security] Fix TypeError message in ChainUserProvider (derrabus)
 * bug #43884 [Console] Runtime conflict for psr/log >= 3.0 instead of composer conflict (fancyweb)
 * bug #43867 [VarDumper] Make dumping DateInterval instances timezone-independent (derrabus)
 * bug #43096 [Messenger] Use `TransportMessageIdStamp` in `InMemoryTransport` allows retrying (alexndlm)
 * bug #42168 [RateLimiter] Fix wait duration for fixed window policy (jlekowski)
 * bug #43501 [HttpKernel] fix ErrorException in CacheWarmerAggregate (Ahummeling)
 * bug #42361 [Translation] correctly handle intl domains with TargetOperation (acran)
 * bug #43833 [Runtime] Consider also $_ENV when resolving APP_RUNTIME and APP_RUNTIME_OPTIONS (Peter Simoncic)
 * bug #43834 [Inflector] Fix inflector for "zombies" (acodispo)
 * bug #43267 [Config] Fix signature generation with nested attributes on PHP 8.1 (agustingomes)

* 5.3.10 (2021-10-29)

 * bug #43798 [Dotenv] Duplicate $_SERVER values in $_ENV if they don't exist (fancyweb)
 * bug #43799 [PhpUnitBridge] fix symlink to bridge in docker by making its path relative (nicolas-grekas)
 * bug #43801 [TwigBundle] fix auto-enabling assets/expression/routing/yaml/workflow extensions (nicolas-grekas)
 * bug #43790 [String] Fix inflector for "zombies" (acodispo)
 * bug #43781 [Messenger] Fix `TraceableMessageBus` implementation so it can compute caller even when used within a callback (Ocramius)
 * bug #43589 [Lock] Fix incorrect return type in PostgreSqlStore (GromNaN)
 * bug #43627 [Framework][Secrets] Fix service definition when local vault is disabled (GromNaN)
 * bug #43579 [DependencyInjection] Fix autowiring tagged arguments from attributes (Okhoshi)
 * bug #43655 [VarDumper] Fix dumping twig templates found in exceptions (event15)
 * bug #43484 [Messenger] Fix Redis Transport when username is empty (villfa)
 * bug #43659 Fix logging of impersonator introduced in 5.3 (johanwilfer)
 * bug #43630 [Messenger] Fix unwrapping the Postgres connection in DBAL 3 (derrabus)
 * bug #43568 [Messenger] fix: TypeError in PhpSerializer::encode() (dsech)
 * bug #43591 [Config] Fix files sorting in GlobResource (lyrixx)
 * bug #43569 [HttpClient] fix collecting debug info on destruction of CurlResponse (nicolas-grekas)
 * bug #43545 [DependencyInjection] fix "url" env var processor (nicolas-grekas)
 * bug #43537 [HttpClient] fix RetryableHttpClient when a response is canceled (nicolas-grekas)
 * bug #43533 [Uid] fix 4 missing bits of entropy in UUIDv4 (nicolas-grekas)
 * bug #43376 [Runtime] Fix class validation of composer "extra.runtime.class" (piku235)
 * bug #43413 [VarDumper] Fix error with uninitialized XMLReader (villfa)
 * bug #43439 [Notifier] [RocketChat] Fix undefined index for message id (OskarStark)
 * bug #43408 [Notifier] Fix 'Undefined array key' error in FirebaseTransport (villfa)
 * bug #43388 [Validator] Fixes URL validation for single-char subdomains (DfKimera)
 * bug #41534 [Form] Fix ChoiceType to effectively set and use translator (marek-binkowski-sim)
 * bug #43364 [Translation] Use symfony default locale when pulling translations from providers (Yoann MOROCUTTI)
 * bug #43333 [HttpClient] fix missing kernel.reset tag on TraceableHttpClient services (nicolas-grekas)
 * bug #43302 [Cache] Commit items implicitly only when deferred keys are requested (Sergey Belyshkin)
 * bug #43330 [Cache][Lock] fix SQLSRV throws for method_exists() (GDmac)
 * bug #43270 [VarDumper] Fix handling of "new" in initializers on PHP 8.1 (nicolas-grekas)
 * bug #43312 [Translation] [Bridge] [Lokalise] do not export empty strings (taranovegor)
 * bug #43277 [DependencyInjection] fix support for "new" in initializers on PHP 8.1 (nicolas-grekas)
 * bug #43243 [HttpClient] accept headers when CURLE_RECV_ERROR is received before the content (nicolas-grekas)
 * bug #43208 [Serializer] Attributes that extend serializer`s annotations are not ignored by the serialization process (Alexander Onatskiy)
 * bug #43241 [PhpUnitBridge] Do not override correct triggering file for return type deprecations (wouterj)
 * bug #43204 [Serializer] Fix denormalizing XML array with empty body (5.x) (alexandre-daubois)
 * bug #43205 [Serializer] Fix denormalizing XML array with empty body (4.4) (alexandre-daubois)
 * bug #43235 [Security] Remove annoying deprecation in `UsageTrackingTokenStorage` (chalasr)

* 5.3.9 (2021-09-28)

 * Fix subtree split issue

* 5.3.8 (2021-09-28)

 * bug #43206 [Workflow] Add missing audit-trail settings in framework workflow con… (Stephan Wentz)
 * bug #42354 [Ldap][Security] Make LdapAuthenticator an EntryPoint (dcp-dev, chalasr)
 * bug #43146 [SecurityBundle] Fixed LogicException message of FirewallAwareTrait (fkropfhamer)
 * bug #43158 [Cache] Fix invalidating tags on Redis <5 (wouterj)
 * bug #43179 [Ldap] Fix `resource` type checks & docblocks on PHP 8.1 (chalasr)
 * bug #43174 [Messenger] relax parameter type (xabbuh)
 * bug #43137 [FrameworkBundle] Avoid secrets:decrypt-to-local command to fail (noniagriconomie)
 * bug #43171 [VarDumper] fix dumping typed references from properties (nicolas-grekas)
 * bug #43124 [Messenger] [Redis] Allow authentication with user and password (GaryPEGEOT)
 * bug #39350 [FrameworkBundle] Remove translation data_collector BEFORE adding it to profiler (l-vo)
 * bug #43115 [DependencyInjection] Fix iterator in ServiceConfigurator (jderusse)
 * bug #43073 [Notifier] Update FirebaseTransport.php (dima-gr)
 * bug #43031 [Form] Do not trim unassigned unicode characters (simonberger)
 * bug #43058 [WebProfilerBundle] Fix displaying certain configs (HypeMC)
 * bug #43022 [PhpUnitBridge] Track unsilenced deprecations only for userland (nicolas-grekas)
 * bug #42979 [FrameworkBundle] fix session-related BC layer triggering deprecation (nicolas-grekas)
 * bug #42672 [PropertyAccess] Fix Regression in PropertyAccessor::isWritable()  (haase-fabian)
 * bug #42976 [Mime] Allow array as input for RawMessage (derrabus)
 * bug #42932 [Messenger] Support rediss in transport bridge (RuslanZavacky)
 * bug #42771 [FrameworkBundle] Match 5.3 and 5.1 mailer configuration (wizardz)
 * bug #42098 [PropertyInfo] Support for intersection types (derrabus)
 * bug #42904 [Cache] Make sure PdoAdapter::prune() always returns a bool (derrabus)
 * bug #42896 [HttpClient] Fix handling timeouts when responses are destructed (nicolas-grekas)
 * bug #42862 [Framework] Clean "about" command help after Environment section was removed (GromNaN)
 * bug #42835 [Cache] Fix implicit float to int cast (derrabus)
 * bug #42831 [Mime] Update mime types (fabpot)
 * bug #42830 [HttpKernel] Fix empty timeline in profiler (nicodmf)
 * bug #42815 [DependencyInjection] Fix circular reference in autowired decorators (shyim)
 * bug #42819 Fix tests failing with DBAL 3 (derrabus)

* 5.3.7 (2021-08-30)

 * bug #42769 [HttpClient] Don't pass float to `usleep()` (derrabus)
 * bug #42753 Cast ini_get to an integer to match expected type (natewiebe13)
 * bug #42345 [Messenger] Remove indices in messenger table on MySQL to prevent deadlocks while removing messages when running multiple consumers (jeroennoten)
 * bug #41378 [Messenger] Fix `ErrorDetailsStamp` denormalization (wucdbm)
 * bug #42160 [Translation] Extract translatable content on twig set (natewiebe13)
 * bug #42053 [Notifier] [Smsapi] fixed checking whether message is sent (damlox)
 * bug #40744 allow null for framework.translator.default_path (SimonHeimberg)
 * bug #39856 [DomCrawler] improve failure messages of the CrawlerSelectorTextContains constraint (xabbuh)
 * bug #40545 [HttpFoundation] Fix isNotModified determination logic (ol0lll)
 * bug #42368 [FrameworkBundle] Fall back to default configuration in debug:config and consistently resolve parameter values (herndlm)
 * bug #41684 Fix Url Validator false positives (sidz)
 * bug #42576 [Translation] Reverse fallback locales (ro0NL)
 * bug #42721 Escape all special characters for parse_mode MARKDOWN_V2 (thomas2411)
 * bug #42707 [Messenger] [AMQP]  Do not leak any credentials when connection fails (ruudk)
 * bug #42690 [Notifier] Firebase error handling (mishaklomp)
 * bug #42628 [PropertyInfo] Support for the `never` return type (derrabus)
 * bug #42685 Fix ProgressBar to correctly clear multi-line formats (rtek)
 * bug #42649 [Translation] Fix message key handling for the Localise provider (xepozz)
 * bug #42659 Ignoring X-Transport header while signing email with DKIM (metaer)
 * bug #42585 [ExpressionLanguage] [Lexer] Remove PHP 8.0 polyfill (nigelmann)
 * bug #42621 [Security] Don't produce TypeErrors for non-string CSRF tokens (derrabus)
 * bug #42596 [Security] Fix wrong cache directive when using the new PUBLIC_ACCESS attribute (wouterj)
 * bug #42445 [Cache] fix wiring async cache recomputing in debug mode (nicolas-grekas)
 * bug #42365 [Cache] Do not add namespace argument to `NullAdapter` in `CachePoolPass` (olsavmic)
 * bug #42331 [HttpKernel] always close open stopwatch section after handling `kernel.request` events (xabbuh)
 * bug #42381 [Console] Don't pass null to preg_replace() (derrabus)
 * bug #42347 Fix ServiceLocator indexing when service is decorated (shyim)
 * bug #42380 [HttpFoundation] Don't pass null to strpos() (derrabus)
 * bug #42377 [HttpKernel] Remove preloading legacy event dispatcher (OskarStark)
 * bug #42260 Fix return types for PHP 8.1 (derrabus)
 * bug #42360 [DoctrineBridge] Typehint against doctrine/persistence interfaces (malarzm)
 * bug #42341 [Validator] Update MIR card scheme (ossinkine)
 * bug #42321 [PasswordHasher] Fix usage of PasswordHasherAdapter in PasswordHasherFactory (peter17)

* 5.3.6 (2021-07-29)

 * bug #42307 [Mailer] Fixed decode exception when sendgrid response is 202 (rubanooo)
 * bug #42296 [Dotenv][Yaml] Remove PHP 8.0 polyfill (derrabus)
 * bug #42274 [VarDumper] `HtmlDumper::setDumpHeader()` accepts `null` (rrpadilla)
 * bug #42289 [HttpFoundation] Fixed type mismatch (Toflar)
 * bug #42259 [Security] fix Check if it has session before getSession() (mousezheng)

* 5.3.5 (2021-07-27)

 * bug #42270 [WebProfilerBundle] [WebProfiler] "empty" filter bugfix. Filter with name "empty" is not … (luzrain)

* 5.3.4 (2021-07-26)

 * bug #41504 [Translation] Fix default value for locales in translation push|pull commands (welcoMattic)
 * bug #42243 [Translation] [Lokalise] Fix `base_uri` (welcoMattic, Nyholm)
 * bug #42212 [Lock] Handle lock with long key (jderusse)
 * bug #42223 [Debug][ErrorHandler] Do not use the php80 polyfill (nicolas-grekas)
 * bug #42207 [Console] fix table setHeaderTitle without headers (a1812)
 * bug #42130 [Translation] fix fallback to Locale::getDefault() (nicolas-grekas)
 * bug #42184 [Mailer] Make sure Http TransportException is not leaking (Nyholm)
 * bug #42091 [Console] Run commands when implements SignalableCommandInterface without pcntl and they have'nt signals (PaolaRuby)
 * bug #42150 [Form] Fix 'invalid_message' use in multiple ChoiceType (alexandre-daubois)
 * bug #42183 [Notifier] Allow passing a previous throwable to exceptions (derrabus)
 * bug #42185 [Notifier]  Make sure Http TransportException is not leaking (Nyholm)
 * bug #42182 [Notifier] Make sure Http TransportException is not leaking (Nyholm)
 * bug #42173 [Messenger] [Redis] Fix auth option wrongly considered invalid (chalasr)
 * bug #42174 Indicate compatibility with psr/log 2 and 3 (derrabus)
 * bug #41897 [Security] fix #41891 Save hashed tokenValue in RememberMe cookie (qurben)
 * bug #42156 Fix missing assignment (Seldaek)
 * bug #42112 [HttpFoundation] fix FileBag under PHP 8.1 (alexpott)
 * bug #42131 [PhpUnitBridge] Fix composer resolution on Windows (Rainrider)
 * bug #42097 [DependencyInjection] Support for intersection types (derrabus)
 * bug #42114 [HttpFoundation] Fix return types of SessionHandler::gc() (derrabus)
 * bug #42099 [VarDumper] Support for intersection types (derrabus)
 * bug #42011 [Cache] Support decorated Dbal drivers in PdoAdapter (Jeroeny)
 * bug #42068 Add a Special Case for Translating Choices in en_US_POSIX (chrisguitarguy)
 * bug #42074 Fix ctype_digit deprecation (alexpott)
 * bug #42084 [WebProfilerBundle] Fix the values of some CSS properties (javiereguiluz)
 * bug #42079 [FrameworkBundle] Fixed file operations in Sodium vault seal (javiereguiluz)
 * bug #42078 [DoctrineBridge] [Doctrine Bridge] Fix an exception message (javiereguiluz)
 * bug #42067 [Messenger] [Redis] Make `auth` option works (welcoMattic)
 * bug #42054 [DoctrineBridge] fix setting default mapping type to attribute/annotation on php 8/7 respectively (nicolas-grekas)
 * bug #42059 [Messenger] Fixed BC layer for RedeliveryStamp (Nyholm)
 * bug #42060 [Messenger] AmqpTransport implements QueueReceiverInterface (xabbuh)
 * bug #42049 [TwigBridge] do not render the same label id attribute twice (xabbuh)
 * bug #42019 [DependencyInjection] Fix TaggedLocator attribute without indexAttribute argument (Lucas Bäuerle)
 * bug #42032 [HttpKernel] recover from failed deserializations (xabbuh)
 * bug #42035 [Messenger] Fix use_notify default value for PostgreSqlConnection (tgalopin)
 * bug #42009 [Console] Fix save correct name in setDefaultCommand() for PHP8 (a1812)
 * bug #41990 [Lock] fix derivating semaphore from key (nicolas-grekas)
 * bug #41986 [Notifier] Fix TransportTestCase (OskarStark)
 * bug #40529 [Translation] Missing translations from traits (insekticid)
 * bug #41384 Fix SkippedTestSuite (jderusse)
 * bug #41966 [Console] Revert "bug #41952  fix handling positional arguments" (chalasr, nicolas-grekas)
 * bug #41905 [EventDispatcher] Correct the called event listener method case (JJsty1e)
 * bug #41961 [Serializer] Need to clear cache when updating Annotation Groups on Entities (monteiro)
 * bug #41952 [Console] fix handling positional arguments (nicolas-grekas)
 * bug #41917 Rethrow exception in `DoctrineTokenProvider` (jderusse)
 * bug #41887 [PhpUnitBridge] Fix deprecation handler with PHPUnit 10 (YaFou)

* 5.3.3 (2021-06-30)

 * bug #41910 [Security] Handle concurency in Csrf DoctrineTokenProvider (jderusse)
 * bug #41881 Fix SessionTokenStorage reuse with Request (jderusse)
 * bug #41893 [Filesystem] Workaround cannot dumpFile into "protected" folders on Windows (arnegroskurth)
 * bug #41896 [Messenger] fix FlattenExceptionNormalizer (nicolas-grekas)
 * bug #41242 [SecurityBundle] Change information label from red to yellow (94noni)
 * bug #41665 [HttpKernel] Keep max lifetime also when part of the responses don't set it (mpdude)
 * bug #41760 [ErrorHandler] fix handling buffered SilencedErrorContext (nicolas-grekas)
 * bug #41807 [HttpClient] fix Psr18Client when allow_url_fopen=0 (nicolas-grekas)
 * bug #41735 [Runtime] Fix project dir variable when vendor not in project root (Ash014)
 * bug #40857 [DependencyInjection] Add support of PHP enumerations (alexandre-daubois)
 * bug #41767 [Config] fix tracking default values that reference the parent class (nicolas-grekas)
 * bug #41768 [DependencyInjection] Fix binding "iterable $foo" when using the PHP-DSL (nicolas-grekas)
 * bug #41777 [DependencyInjection] accept service locator definitions with no class (nicolas-grekas)
 * bug #41801 [Uid] Fix fromString() with low base58 values (fancyweb)
 * bug #41793 [Cache] handle prefixed redis connections when clearing pools (nicolas-grekas)
 * bug #41804 [Cache] fix eventual consistency when using RedisTagAwareAdapter with a cluster (nicolas-grekas)
 * bug #41773 [Cache] Disable locking on Windows by default (nicolas-grekas)
 * bug #41655 [Mailer] fix encoding of addresses using SmtpTransport (dmaicher)
 * bug #41663 [HttpKernel] [HttpCache] Keep s-maxage=0 from ESI sub-responses (mpdude)
 * bug #41739 Avoid broken action URL in text notification mail (mbrodala)
 * bug #41737 [Security] Fix special char used to create cache key (jderusse)
 * bug #41701 [VarDumper] Fix tests for PHP 8.1 (alexandre-daubois)
 * bug #41795 [FrameworkBundle] Replace var_export with VarExporter to use array short syntax in secrets list files (alexandre-daubois)
 * bug #41779 [DependencyInjection] throw proper exception when decorating a synthetic service (nicolas-grekas)
 * bug #41787 [Security] Implement fluent interface on RememberMeBadge::disable() (derrabus)
 * bug #41776 [ErrorHandler] [DebugClassLoader] Do not check Phake mocks classes (adoy)
 * bug #41780 [PhpUnitBridge] fix handling the COMPOSER_BINARY env var when using simple-phpunit (Taluu)
 * bug #41755 [PasswordHasher] UserPasswordHasher only calls getSalt when method exists (dbrumann)
 * bug #41670 [HttpFoundation] allow savePath of NativeFileSessionHandler to be null (simon.chrzanowski)
 * bug #41751 [Messenger] prevent reflection usages when classes do not exist (xabbuh)
 * bug #41747 [Security] Fixed 'security.command.debug_firewall' not found (Nyholm)
 * bug #41741 [Security] Fix invalid RememberMe value after update (jderusse)
 * bug #41744 [Security] Fix invalid cookie when migrating to new Security (jderusse)
 * bug #41740 [Security] make the getter usable if no user identifier is set (xabbuh)

* 5.3.2 (2021-06-17)

 * security #cve-2021-32693 [SecurityHttp] Fix "Authentication granted with multiple firewalls" (wouterj)
 * bug #41693 [Uid] fix performance and prevent collisions with the real clock_seq (nicolas-grekas)
 * bug #41700 [Security] Fix deprecation notice on TokenInterface::getUser() stringable return (tscni)
 * bug #41703 [Security] Restore extension point in MessageDigestPasswordEncoder (derrabus)
 * bug #41716 [Messenger] Fix RequestContext not updated (jderusse)
 * bug #41616 [Messenger] Remove TLS related options when not using TLS (odolbeau)
 * bug #41719 [FrameworkBundle] fix Could not find service "test.service_container" (smilesrg)
 * bug #41686 [Console] Fix using #[AsCommand] without DI (nicolas-grekas)
 * bug #41673 [DependencyInjection] fix parsing classes for attributes (nicolas-grekas)
 * bug #41675 [Runtime] fix overriding --env|-e with single-command apps (nicolas-grekas)
 * bug #41674 [HttpClient] fix compat with cURL <= 7.37 (nicolas-grekas)
 * bug #41680 [Console] fix managing signals when commands are lazy loaded (nicolas-grekas)
 * bug #41678 [PasswordHasher] Fix missing PasswordHasherAwareInterface allowed type (chalasr)
 * bug #41656 [HttpClient] throw exception when AsyncDecoratorTrait gets an already consumed response (nicolas-grekas)
 * bug #41600 [Notifier] Escape `.` char for Telegram transport (Clément)
 * bug #41644 [Config] fix tracking attributes in ReflectionClassResource (nicolas-grekas)
 * bug #41621 [Process] Fix incorrect parameter type (bch36)
 * bug #41624 [HttpClient] Revert bindto workaround for unaffected PHP versions (derrabus)
 * bug #41597 [DependencyInjection] fix `when@{env}` inside imported files (nusje2000)
 * bug #41553 [Messenger] fix BC for FrameworkBundle 4.4 with a non-existence alias being used (monteiro)
 * bug #41582 Fix not null get collection key types (dragosprotung)
 * bug #41572 [PasswordHasher] Prevent PHP fatal error when using auto algorithm (matason)
 * bug #41549 [Security] Fix opcache preload with alias classes (jderusse)
 * bug #41491 [Serializer] Do not allow to denormalize string with spaces only to valid a DateTime object (sidz)
 * bug #41535 [Console] Fix negated options not accessible (jderusse)
 * bug #41472 [Validator] remove service if its class doesn't exist (xabbuh)
 * bug #41218 [DependencyInjection] Update loader’s directory when calling ContainerConfigurator::withPath (MatTheCat)
 * bug #41505 [FrameworkBundle] fix KernelBrowser::loginUser with a stateless firewall (dunglas)
 * bug #41509 [SecurityBundle] Link UserProviderListener to correct firewall dispatcher (Matth--)
 * bug #41386 [Console] Escape synopsis output (jschaedl)
 * bug #41523 [Notifier] [Bridge] Remove hidden dependency on HttpFoundation for SmsBiurasTransport (fre5h)
 * bug #41512 Relax requirement on symfony/runtime (lyrixx)

* 5.3.1 (2021-06-02)

 * bug #41463 [Serializer][Validator] Fix not null return from "getCollectionValueTypes" (jderusse)
 * bug #41493 [Security] Readd deprecated methods to the interfaces (wouterj)
 * bug #41495 [HttpFoundation] Add ReturnTypeWillChange to SessionHandlers (nikic)
 * bug #41485 [HttpKernel] fix ArgumentMetadataFactory messes up controller arguments with attributes (sgehrig)
 * bug #41461 Fix Symfony 5.3 end of maintenance date (jmsche)

* 5.3.0 (2021-05-31)

 * bug #41458 [FrameworkBundle] fix ConfigBuilderCacheWarmer (nicolas-grekas)
 * bug #41456 [FrameworkBundle] fix creating ContainerBuilder at warmup/CLI time (nicolas-grekas)
 * bug #41452 [FrameworkBundle] Remove redundant cache service (derrabus)
 * bug #41451 [Translation] Remove PoEditor Provider (welcoMattic)
 * bug #41000 [Form] Use !isset for checks cause this doesn't falsely include 0 (Kai Dederichs)
 * bug #41407 [DependencyInjection] keep container.service_subscriber tag on the decorated definition (xabbuh)
 * bug #40866 [Filesystem] fix readlink() for Windows (a1812)
 * bug #41402 [HttpKernel] Throw when HttpKernel is created and the env is empty (nicolas-grekas)
 * bug #41376 [SecurityBundle] Don't register deprecated listeners with authenticator manager enabled (chalasr)
 * bug #41394 [Form] fix support for years outside of the 32b range on x86 arch (nicolas-grekas)
 * bug #41380 Make Mailgun Header compatible with other Bridges (jderusse)
 * bug #39847 [Messenger] Fix merging PrototypedArrayNode associative values (svityashchuk)
 * bug #41367 [Ldap] Avoid calling the deprecated getUsername() (derrabus)
 * bug #41346 [WebProfilerBundle] Wrapping exception js in Sfjs check and also loading base_js Sfjs if needed (weaverryan)
 * bug #41344 [VarDumper] Don't pass null to parse_url() (derrabus)

* 5.3.0-RC1 (2021-05-19)

 * security #cve-2021-21424 [Security\Core] Fix user enumeration via response body on invalid credentials (chalasr)
 * bug #41275 Fixes Undefined method call (faizanakram99)
 * feature #41175 [Security] [RememberMe] Add support for parallel requests doing remember-me re-authentication (Seldaek)
 * bug #41269 [SecurityBundle] Remove invalid unused service (chalasr)
 * feature #41247 [Security] Deprecate the old authentication mechanisms (chalasr)
 * bug #41139 [Security] [DataCollector] Remove allows anonymous information in datacollector (ismail1432)
 * bug #41254 [Security\Http] Fix handling `secure: auto` using the new RememberMeAuthenticator (chalasr)
 * bug #41230 [FrameworkBundle][Validator] Fix deprecations from Doctrine Annotations+Cache (derrabus)
 * bug #41206 [Mailer] Fix SES API call with UTF-8 Addresses (jderusse)
 * bug #41240 Fixed deprecation warnings about passing null as parameter (derrabus)
 * bug #41241 [Finder] Fix gitignore regex build with "**" (mvorisek)
 * bug #41224 [HttpClient] fix adding query string to relative URLs with scoped clients (nicolas-grekas)
 * bug #41233 [DependencyInjection][ProxyManagerBridge] Don't call class_exists() on null (derrabus)
 * bug #41214 [Console] fix registering command aliases when using the new "cmd|alias" syntax for names (nicolas-grekas)
 * bug #41211 [Notifier] Add missing charset to content-type for Slack notifier (norkunas)
 * bug #41210 [Console] Fix Windows code page support (orkan)

* 5.3.0-BETA4 (2021-05-12)

 * security #cve-2021-21424 [Security][Guard] Prevent user enumeration (chalasr)
 * feature #41178 [FrameworkBundle] Introduce `AbstractController::renderForm()` instead of `handleForm()` (lyrixx)
 * feature #41182 [DependencyInjection] allow PHP-DSL files to be env-conditional (nicolas-grekas)
 * bug #41177 [DependencyInjection] fix empty instanceof-conditionals created by AttributeAutoconfigurationPass (nicolas-grekas)
 * bug #41176 [DependencyInjection] fix dumping service-closure-arguments (nicolas-grekas)
 * bug #41174 [Console] Fix Windows code page support (orkan)
 * bug #41173 [Security] Make Login Rate Limiter also case insensitive for non-ascii user identifiers (Seldaek)
 * bug #41170 [DependencyInjection] Don't try to load YamlFileLoader if it's not actually needed (nicolas-grekas)
 * bug #41168 WDT: Only load "Sfjs" if it is not present already (weaverryan)
 * feature #36864 [Messenger] Ability to distinguish retry and delay actions (theravel)
 * bug #41164 [FrameworkBundle] fix debug:event-dispatcher and debug:firewall (nicolas-grekas)
 * feature #41161 [HttpClient] Add `DecoratorTrait` to ease writing simple decorators (nicolas-grekas)
 * bug #41147 [Inflector][String] wrong plural form of words ending by "pectus" (makraz)
 * bug #41160 [HttpClient] Don't prepare the request in ScopingHttpClient (nicolas-grekas)
 * bug #41156 [Security] Make Login Rate Limiter case insensitive (jderusse)
 * bug #41155 [Translation] Improved Translation Providers (welcoMattic)
 * feature #40927 [Translation] Added Lokalise Provider (welcoMattic)
 * feature #40926 [Translation] Added PoEditor Provider (welcoMattic)
 * bug #41137 [Security] Reset limiters on successful login (MatTheCat)
 * bug #41148 [Runtime] fix defining $_SERVER[APP_ENV] (nicolas-grekas)
 * bug #40758 [Security] NullToken signature (jderusse)
 * bug #40763 Fix/Rewrite .gitignore regex builder (mvorisek)

* 5.3.0-BETA3 (2021-05-09)

 * feature #40947 [Translation] Added Crowdin Translation Provider (andrii-bodnar)
 * bug #41132 [Runtime] don't display the shebang on the CLI (nicolas-grekas)
 * bug #41113 [Console] Fix Windows code page support (orkan)
 * bug #40902 [Security] Allow ips parameter in access_control to accept comma-separated string (edefimov)
 * bug #40980 [TwigBridge] Fix HTML for translatable custom-file label in Bootstrap 4 theme (acran)
 * bug #40955 [Notifier] [Bridge] Fix missed messageId for SendMessage object in slack notifier (WaylandAce)
 * bug #40943 [PropertyInfo] PhpDocExtractor: Handle "true" and "false" property types (Maciej Zgadzaj)
 * bug #40759 [Form] Add missing TranslatableMessage support to choice_label option of ChoiceType (alexandre-daubois)
 * bug #40917 [Config][DependencyInjection] Uniformize trailing slash handling (dunglas)
 * bug #40699 [PropertyInfo] Make ReflectionExtractor correctly extract nullability (shiftby)
 * bug #40874 [PropertyInfo] fix attribute namespace with recursive traits (soullivaneuh)
 * bug #40957 [PhpUnitBridge] Fix tests with ``@doesNotPerformAssertions`` annotations (alexpott)
 * bug #41099 [Cache] Check if phpredis version is compatible with stream parameter (nicolassing)
 * bug #40982 [Notifier] Fix return SentMessage then Messenger not used (WaylandAce)
 * bug #40972 Avoid regenerating the remember me token if it is still fresh (Seldaek)
 * bug #41072 [VarExporter] Add support of PHP enumerations (alexandre-daubois)
 * feature #40992 [Notifier] Add SlackOptions::threadTs() to send message as reply (WaylandAce)
 * bug #41104 Fix return type in isAllowedProperty method on ReflectionExtractor class (Tomanhez)
 * bug #41078 [Notifier] Make FailoverTransport always pick the first transport (jschaedl)
 * feature #39157 [TwigBridge] Add form templates for Bootstrap 5 (ker0x)
 * bug #41022 [PasswordHasher] Improved BC layer (derrabus)
 * bug #41105 [Inflector][String] Fixed singularize `edges` > `edge` (ruudk)
 * bug #41075 [ErrorHandler] Skip "same vendor" ``@method`` deprecations for `Symfony\*` classes unless symfony/symfony is being tested (nicolas-grekas)
 * bug #41096 Make Serializable implementation internal and final (derrabus)
 * bug #40994 [Config] More accurate message on invalid config builder (a-menshchikov)
 * bug #40767 [Routing] Fix localized paths (l-vo)

* 5.3.0-BETA2 (2021-05-01)

 * feature #41002 [FrameworkBundle][HttpKernel] Move IDE file link formats from FrameworkExtension to FileLinkFormatter (MatTheCat)
 * bug #41014 [Routing] allow extending Route attribute (robmro27)
 * feature #39913 [OptionsResolver] Add prototype definition support for nested options (yceruto)
 * bug #41008 [Security] Do not try to rehash null-passwords (tjveldhuizen)
 * bug #41013 [Console] Remove spaces between arguments GithubActionReporter (franmomu)
 * bug #40920 [PasswordHasher] accept hashing passwords with nul bytes or longer than 72 bytes when using bcrypt (nicolas-grekas)
 * bug #40993 [Security] [Security/Core] fix checking for bcrypt (nicolas-grekas)
 * bug #40986 [Console] Negatable option are null by default (jderusse)
 * bug #40923 [Yaml] expose references detected in inline notation structures (xabbuh)
 * bug #40951 [FrameworkBundle] Make debug:event-dispatcher search case insensitive (javiereguiluz)
 * bug #40966 [Messenger] fix manual amqp setup when autosetup disabled (Tobion)
 * bug #40956 [Config] [ConfigBuilder] Set FQCN as properties type instead of class name (MatTheCat)
 * bug #40964 [HttpFoundation] Fixes for PHP 8.1 deprecations (jrmajor)
 * bug #40950 [Config] Remove double semicolons from autogenerated config classes (HypeMC)
 * bug #40903 [Config] Builder: Remove typehints and allow for EnvConfigurator (Nyholm)
 * bug #40919 [Mailer] use correct spelling when accessing the SMTP php.ini value (xabbuh)
 * bug #40514 [Yaml] Allow tabs as separators between tokens (bertramakers)
 * bug #40882 [Cache] phpredis: Added full TLS support for RedisCluster (jackthomasatl)
 * feature #38475 [Translation] Adding Translation Providers (welcoMattic)
 * bug #40877 [Config] Make sure one can build cache on Windows and then run in (Docker) Linux (Nyholm)
 * bug #40878 [Config] Use plural name on array values (Nyholm)
 * bug #40872 [DependencyInjection] [AliasDeprecatedPublicServicesPass] Noop when the service is private (fancyweb)
 * feature #40800 [DependencyInjection] Add `#[Target]` to tell how a dependency is used and hint named autowiring aliases (nicolas-grekas)
 * bug #40859 [Config] Support extensions without configuration in ConfigBuilder warmup (wouterj)
 * bug #40852 [Notifier] Add missing entries in scheme to package map (jschaedl)

* 5.3.0-BETA1 (2021-04-18)

 * feature #40838 [SecurityBundle] Deprecate public services to private (fancyweb)
 * feature #40782 [DependencyInjection] Add `#[When(env: 'foo')]` to skip autoregistering a class when the env doesn't match (nicolas-grekas)
 * feature #40840 [Security] Add passport to AuthenticationTokenCreatedEvent (scheb)
 * feature #40799 [FrameworkBundle] Add AbstractController::handleForm() helper (dunglas)
 * feature #40646 [Notifier] Add MessageBird notifier bridge (StaffNowa)
 * feature #40804 [Config][FrameworkBundle] Add CacheWarmer for ConfigBuilder (Nyholm)
 * feature #40814 Remove the experimental flag from the authenticator system 🚀 (chalasr)
 * feature #40690 [Form] Add support for sorting fields (yceruto)
 * feature #40691 [Notifier] Add SmsBiuras notifier bridge (StaffNowa)
 * feature #40406 [DependencyInjection] Autowire arguments using attributes (derrabus, nicolas-grekas)
 * feature #40155 [Messenger] Support Redis Cluster (nesk)
 * feature #40600 [Config][DependencyInjection] Add configuration builder for writing PHP config (Nyholm)
 * feature #40171 [Workflow] Add Mermaid.js dumper (eFrane)
 * feature #40761 [MonologBridge] Reset loggers on workers (l-vo)
 * feature #40785 [Security] Deprecate using UsageTrackingTokenStorage outside the request-response cycle (wouterj)
 * feature #40718 [Messenger] Add X-Ray trace header support to the SQS transport (WaylandAce)
 * feature #40682 [DependencyInjection] Add env() and EnvConfigurator in the PHP-DSL (fancyweb)
 * feature #40145 [Security] Rework the remember me system (wouterj)
 * feature #40695 [Console] Deprecate Helper::strlen() for width() and length() (Nyholm)
 * feature #40486 [Security] Add concept of required passport badges (wouterj)
 * feature #39007 [Notifier] Add notifier for Microsoft Teams (idetox)
 * feature #40710 [Serializer] Construct annotations using named arguments (derrabus)
 * feature #40647 [Notifier] [FakeChat] Added the bridge (OskarStark)
 * feature #40607 [Notifier] Add LightSms notifier bridge (Vasilij Dusko, StaffNowa)
 * feature #40576 [Mime] Remove @internal from Headers methods (VincentLanglet)
 * feature #40575 [FrameworkBundle][HttpKernel][TwigBridge] Add an helper to generate fragments URL (dunglas)
 * feature #38468 Messenger multiple failed transports (monteiro)
 * feature #39949 [Notifier] [FakeSms] Add the bridge (JamesHemery)
 * feature #40403 [Security] Rename UserInterface::getUsername() to getUserIdentifier() (wouterj)
 * feature #40602 [Cache] Support a custom serializer in the ApcuAdapter class (ste93cry)
 * feature #40449 [TwigBridge] add tailwindcss form layout (kbond)
 * feature #40567 [Security] Move the badges resolution check to `AuthenticatorManager` (chalasr)
 * feature #40300 [HttpFoundation] Add support for mysql unix_socket and charset in PdoSessionHandler::buildDsnFromUrl (bcremer, Nyholm)
 * feature #40153 [Security] LoginLink with specific locale (roromix)
 * feature #40489 [Serializer] Add a Custom End Of Line in CSV File (xfifix)
 * feature #40554 [Contracts] Add `TranslatorInterface::getLocale()` (nicolas-grekas)
 * feature #40556 Add `#[As-prefix]` to service attributes (nicolas-grekas)
 * feature #40555 [HttpKernel] Add `#[AsController]` attribute for declaring standalone controllers on PHP 8 (nicolas-grekas)
 * feature #40550 [Notifier] Move abstract test cases to  namespace (OskarStark)
 * feature #40530 [Uid] Handle predefined namespaces keywords "dns", "url", "oid" and "x500" (fancyweb)
 * feature #40536 [HttpFoundation][HttpKernel] Rename master request to main request (derrabus)
 * feature #40513 [Runtime] make GenericRuntime ... generic (nicolas-grekas)
 * feature #40430 [Form] Add "form_attr" FormType option (cristoforocervino)
 * feature #38488 [Validator] Add normalizer option to Unique constraint (henry2778)
 * feature #40487 [Security] Remove deprecated support for passing a UserInterface implementation to Passport (wouterj)
 * feature #40443 [Security] Rename User to InMemoryUser (chalasr)
 * feature #40468 Deprecate configuring tag names and service ids in compiler passes (nicolas-grekas)
 * feature #40248 [DependencyInjection] Add `#[TaggedItem]` attribute for defining the index and priority of classes found in tagged iterators/locators (nicolas-grekas)
 * feature #40240 [Validator] Add Validation::createIsValidCallable() that returns a boolean instead of exception (wouterj)
 * feature #40366 [FrameworkBundle] Add KernelTestCase::getContainer() (Nyholm)
 * feature #40441 [WebProfilerBundle] Disable CSP if dumper was used (monojp)
 * feature #40448 [twig-bridge] Allow NotificationEmail to be marked as public (maxailloud)
 * feature #38465 [Runtime] a new component to decouple applications from global state (nicolas-grekas)
 * feature #40432 [HttpKernel] Deprecate returning a `ContainerBuilder` from `KernelInterface::registerContainerConfiguration()` (nicolas-grekas)
 * feature #40337 [DependencyInjection] Add support an integer return for default_index_method (maranqz)
 * feature #39693 [PropertyAccess] use bitwise flags to configure when the property accessor should throw (xabbuh)
 * feature #40267 [Security] Decouple passwords from UserInterface (chalasr)
 * feature #40377 [Notifier] [OvhCloud] Add "sender" (notFloran)
 * feature #40384 [DependencyInjection] Implement psr/container 1.1 (derrabus)
 * feature #40229 [FrameworkBundle][Translation] Extract translation IDs from all of src (natewiebe13)
 * feature #40338 [FrameworkBundle] Add support for doctrine/annotations:1.13 || 2.0 (Nyholm)
 * feature #40323 [TwigBridge][TwigBundle] Twig serialize filter (jrushlow)
 * feature #40339 [RateLimiter][Security] Add a `login_throttling.interval` (in `security.firewalls`) option to change the default throttling interval. (damienfa, wouterj)
 * feature #40307 [HttpKernel] Handle multi-attribute controller arguments (chalasr)
 * feature #40284 [RateLimiter][Security] Allow to use no lock in the rate limiter/login throttling (wouterj)
 * feature #39607 [Messenger] Add `rediss://` DSN scheme support for TLS to Redis transport (njutn95)
 * feature #40306 [HttpClient] Add `HttpClientInterface::withOptions()` (nicolas-grekas)
 * feature #39883 [Uid] Add Generate and Inspect commands (fancyweb)
 * feature #40140 [DependencyInjection] Add ContainerBuilder::willBeAvailable() to help with conditional configuration (nicolas-grekas)
 * feature #40266 [Routing] Construct Route annotations using named arguments (derrabus)
 * feature #40288 Deprecate passing null as $message or $code to exceptions (derrabus)
 * feature #40298 [Form] Remove hard dependency on symfony/intl (Nyholm)
 * feature #40214 [FrameworkBundle] allow container/routing configurators to vary by env (nicolas-grekas)
 * feature #40257 [Intl] Add `Currencies::getCashFractionDigits()` and `Currencies::getCashRoundingIncrement()` (nicolas-grekas)
 * feature #39326 [Security] Added debug:firewall command (TimoBakx)
 * feature #40234 [Console] Add `ConsoleCommand` attribute for declaring commands on PHP 8 (nicolas-grekas)
 * feature #39897 [DependencyInjection] Autoconfigurable attributes (derrabus)
 * feature #39804 [DependencyInjection] Add `#[Autoconfigure]` to help define autoconfiguration rules (nicolas-grekas)
 * feature #40174 [Mailer] AWS SES transport Source ARN header support (chekalsky)
 * feature #38473 [Framework] Add tag assets.package to register asset packages (GromNaN)
 * feature #39399 [Serializer] Allow to provide (de)normalization context in mapping (ogizanagi)
 * feature #40202 [Workflow] Deprecate InvalidTokenConfigurationException (chalasr)
 * feature #40176 [PasswordHasher] Use bcrypt as default hash algorithm for "native" and "auto" (chalasr)
 * feature #40048 [FrameworkBundle] Deprecate session.storage service (jderusse)
 * feature #40169 [DependencyInjection] Negated (not:) env var processor (bpolaszek)
 * feature #39802 [Security] Extract password hashing from security-core - with proper wording (chalasr)
 * feature #40143 [Filesystem] improve messages on failure (nicolas-grekas)
 * feature #40144 [Filesystem] Remove dirs atomically if possible (nicolas-grekas)
 * feature #39507 [Uid] Add UidFactory to create Ulid and Uuid from timestamps and randomness/nodes (fancyweb)
 * feature #39688 [FrameworkBundle][Messenger] Added RouterContextMiddleware (jderusse)
 * feature #40102 [Notifier] [Firebase] Add data field to options (Raresmldvn)
 * feature #39978 [DoctrineBridge] Make subscriber and listeners prioritizable (jderusse)
 * feature #39732 [Routing] don't decode nor double-encode already encoded slashes when generating URLs (nicolas-grekas)
 * feature #39893 [HttpKernel] Show full URI when route not found (ruudk)
 * feature #40059 [PhpUnitBridge] Add SYMFONY_PHPUNIT_REQUIRE env variable (acasademont)
 * feature #39948 [Notifier] [SpotHit] Add the bridge (JamesHemery)
 * feature #38973 [Messenger] Allow to limit consumer to specific queues (dbu)
 * feature #40029 [DoctineBridge] Remove UuidV*Generator classes (nicolas-grekas)
 * feature #39976 [Console] Add bright colors to console. (CupOfTea696)
 * feature #40028 [Semaphore] remove "experimental" status (jderusse)
 * feature #38616 [FrameworkBundle][HttpFoundation][Security] Deprecate service "session" (jderusse)
 * feature #40010 [Uid] remove "experimental" status (nicolas-grekas)
 * feature #40012 [Uid] Add RFC4122 UUID namespaces as constants (nicolas-grekas)
 * feature #40008 [Uid] Replace getTime() with getDateTime() (fancyweb)
 * feature #39910 [FrameworkBundle] Command cache:pool:clear warns and fails when one of the pools fails to clear (jderusse)
 * feature #39699 [String] Made AsciiSlugger fallback to parent locale's symbolsMap (jontjs)
 * feature #39971 [Cache] Change PDO cache table collate from utf8_bin to utf8mb4_bin (pdragun)
 * feature #38922 [Notifier] Add notifier for Clickatell (Kevin Auivinet, Kevin Auvinet, ke20)
 * feature #39587 [Notifier] [Mobyt] Change ctor signature and validate message types (OskarStark)
 * feature #39919 [Security] Randomize CSRF token to harden BREACH attacks (jderusse)
 * feature #39850 [Uid] Add fromBase58(), fromBase32(), fromRfc4122() and fromBinary() methods (fancyweb)
 * feature #39904 [Console] add option `--short` to the `list` command (nicolas-grekas)
 * feature #39851 [Console] enable describing commands in ways that make the `list` command lazy (nicolas-grekas)
 * feature #39838 [Notifier] Add Gitter Bridge (christingruber)
 * feature #39342 [Notifier] Add mercure bridge (mtarld)
 * feature #39863 [Form][Uid] Add UlidType and UuidType form types (Gemorroj)
 * feature #39806 [DependencyInjection] Add a remove() method to the PHP configurator (dunglas)
 * feature #39843 [FrameworkBundle] Add renderForm() helper setting the appropriate HTTP status code (dunglas)
 * feature #39852 [Security] RoleHierarchy returns an unique array of roles (lyrixx)
 * feature #39855 [HttpFoundation] deprecate the NamespacedAttributeBag class (xabbuh)
 * feature #39579 [Notifier] [GoogleChat] [BC BREAK] Rename threadKey parameter to thread_key + set parameter via ctor (OskarStark)
 * feature #39617 [Notifier] Add AllMySms Bridge (qdequippe)
 * feature #39702 [Notifier] Add Octopush notifier transport (aurelienheyliot)
 * feature #39568 [Notifier] Add GatewayApi bridge (Piergiuseppe Longo)
 * feature #39585 [Notifier] Change Dsn api (OskarStark)
 * feature #39675 [Serializer] [UidNormalizer] Add normalization formats (fancyweb)
 * feature #39457 [Notifier] [DX] Dsn::getRequiredOption() (OskarStark)
 * feature #39098 [PhpUnitBridge] Add log file option for deprecations (michaelKaefer)
 * feature #39642 [Console] Support binary / negatable options (greg-1-anderson, jderusse)
 * feature #39051 [WebProfilerBundle] Possibility to dynamically set mode (brusch)
 * feature #39701 [Lock] Create flock directory (jderusse)
 * feature #39696 [DoctrineBridge] Deprecate internal test helpers in Test namespace (wouterj)
 * feature #39684 [DomCrawler] deprecate parents() in favor of ancestors() (xabbuh)
 * feature #39666 [FrameworkBundle][HttpFoundation] add assertResponseFormatSame() (dunglas)
 * feature #39660 [Messenger] Deprecate option prefetch_count (jderusse)
 * feature #39577 [Serializer] Migrate ArrayDenormalizer to DenormalizerAwareInterface (derrabus)
 * feature #39020 [PropertyInfo] Support multiple types for collection keys & values (Korbeil)
 * feature #39557 [Notifier] [BC BREAK] Final classes (OskarStark)
 * feature #39592 [Notifier] [BC BREAK] Change constructor signature for Mattermost and Esendex transport (OskarStark)
 * feature #39643 [PhpUnitBridge] Remove obsolete polyfills (derrabus)
 * feature #39606 [Notifier] [Slack] Validate token syntax (OskarStark)
 * feature #39549 [Notifier] [BC BREAK] Fix return type (OskarStark)
 * feature #39096 [Notifier] add iqsms bridge (alexandrbarabolia)
 * feature #39493 [Notifier] Introduce LengthException (OskarStark)
 * feature #39484 [FrameworkBundle] Allow env variables in `json_manifest_path` (jderusse)
 * feature #39480 [FrameworkBundle] Add "mailer" monolog channel to mailer transports (chalasr)
 * feature #39419 [PhpUnitBridge] bump "php" to 7.1+ and "phpunit" to 7.5+ (nicolas-grekas)
 * feature #39410 [Notifier] Add HeaderBlock for slack notifier (norkunas)
 * feature #39365 [Notifier] [DX] UnsupportedMessageTypeException for notifier transports (OskarStark)
 * feature #38469 [Form] Add "choice_translation_parameters" option (VincentLanglet)
 * feature #39352 [TwigBridge] export concatenated translations (Stephen)
 * feature #39378 [Messenger] Use "warning" instead of "error" log level for RecoverableException (lyrixx)
 * feature #38622 [BrowserKit] Allowing body content from GET with a content-type (thiagomp)
 * feature #39363 [Cache] Support Redis Sentinel mode when using phpredis/phpredis extension (renan)
 * feature #39340 [Security] Assert voter returns valid decision (jderusse)
 * feature #39327 [FrameworkBundle] Add validator.expression_language service (fbourigault)
 * feature #39276 [FrameworkBundle] Added option to specify the event dispatcher in debug:event-dispatcher (TimoBakx)
 * feature #39042 [Console] Extracting ProgressBar's format's magic strings into const (CesarScur)
 * feature #39323 Search for pattern on debug:event-dispatcher (Nyholm)
 * feature #39317 [Form] Changed DataMapperInterface $forms parameter type to \Traversable (vudaltsov)
 * feature #39258 [Notifier] Add ContextBlock for slack notifier (norkunas)
 * feature #39300 [Notifier] Check for maximum number of buttons in slack action block (malteschlueter)
 * feature #39097 [DomCrawler] Cache discovered namespaces (simonberger, fabpot)
 * feature #39037 [Ldap] Ldap Entry case-sensitive attribute key option (karlshea)
 * feature #39146 [Console] Added Invalid constant into Command Class (TheGarious)
 * feature #39075 [Messenger]  Allow InMemoryTransport to serialize message (tyx)
 * feature #38982 [Console][Yaml] Linter: add Github annotations format for errors (ogizanagi)
 * feature #38846 [Messenger] Make all the dependencies of AmazonSqsTransport injectable (jacekwilczynski)
 * feature #38596 [BrowserKit] Add jsonRequest function to the browser-kit client (alexander-schranz)
 * feature #38998 [Messenger][SQS] Make sure one can enable debug logs (Nyholm)
 * feature #38974 [Intl] deprecate polyfills in favor of symfony/polyfill-intl-icu (nicolas-grekas)

