CHANGELOG for 4.3.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 4.3 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v4.3.0...v4.3.1

* 4.3.3 (2019-07-28)

 * bug #32726 [Messenger] Fix redis last error not cleared between calls (chalasr)
 * bug #32760 [HttpKernel] clarify error handler restoring process (xabbuh)
 * bug #32730 [Inflector] Fix pluralizing words ending with "son" (norkunas)
 * bug #32715 [DI] fix perf issue with lazy autowire error messages (nicolas-grekas)
 * bug #32503 Fix multiSelect ChoiceQuestion when answers have spaces (IceMaD)
 * bug #32688 [Yaml] fix inline handling when dumping tagged values (xabbuh)
 * bug #32710 [Security/Core] align defaults for sodium with PHP 7.4 (nicolas-grekas)
 * bug #32644 [WebProfileBundle] Avoid getting right to left style (Arman-Hosseini)
 * bug #32689 [HttpClient] rewind stream when using Psr18Client (nicolas-grekas)
 * bug #32700 [Messenger] Flatten collection of stamps collected by the traceable middleware (ogizanagi)
 * bug #32699 [HttpClient] fix canceling responses in a streaming loop (nicolas-grekas)
 * bug #32679 [Intl] relax some date parser patterns (xabbuh)
 * bug #31303 [VarDumper] Use \ReflectionReference for determining if a key is a reference (php >= 7.4) (dorumd, nicolas-grekas)
 * bug #32485 [Validator] Added support for validation of giga values (kernig)
 * bug #32567 [Messenger] pass transport name to factory (Tobion)
 * bug #32568 [Messenger] Fix UnrecoverableExceptionInterface handling (LanaiGrunt)
 * bug #32604 Properly handle optional tag attributes for !tagged_iterator (apfelbox)
 * bug #32571 [HttpClient] fix debug output added to stderr at shutdown (nicolas-grekas)
 * bug #32443 [PHPUnitBridge] Mute deprecations triggered from phpunit (greg0ire)
 * bug #32572 Bump minimum version of symfony/phpunit-bridge (fancyweb)
 * bug #32438 [Serializer] XmlEncoder: don't cast padded strings (ogizanagi)
 * bug #32579 [Config] Do not use absolute path when computing the vendor freshness (lyrixx)
 * bug #32563 Container*::getServiceIds() should return strings (mathroc)
 * bug #32553 [Mailer] Allow register mailer configuration in xml format (Koc)
 * bug #32442 Adding missing event_dispatcher wiring for messenger.middleware.send_message (weaverryan)
 * bug #32466 [Config] Fix for signatures of typed properties (tvandervorm)
 * bug #32501 [FrameworkBundle] Fix descriptor of routes described as callable array (ribeiropaulor)
 * bug #32500 [Debug][DebugClassLoader] Include found files instead of requiring them (fancyweb)
 * bug #32464 [WebProfilerBundle] Fix Twig 1.x compatibility (yceruto)
 * bug #31620 [FrameworkBundle] Inform the user when save_path will be ignored (gnat42)
 * bug #32096 Don't assume port 0 for X-Forwarded-Port (alexbowers, xabbuh)
 * bug #31820 [SecurityBundle] Fix profiler dump for non-invokable security listeners (chalasr)
 * bug #32392 [Messenger] Doctrine Transport: Support setting auto_setup from DSN (bendavies)
 * bug #31267 [Translator] Load plurals from mo files properly (Stadly)
 * bug #31266 [Translator] Load plurals from po files properly (Stadly)
 * bug #32383 [Serializer] AbstractObjectNormalizer ignores the property types of discriminated classes (sandergo90)
 * bug #32413 [Messenger] fix publishing headers set on AmqpStamp (Tobion)
 * bug #32421 [EventDispatcher] Add tag kernel.rest on 'debug.event_dispatcher' service (lyrixx)
 * bug #32398 [Messenger] Removes deprecated call to ReflectionType::__toString() on MessengerPass (brunowowk)
 * bug #32379 [SecurityBundle] conditionally register services (xabbuh)
 * bug #32380 [Messenger] fix broken key normalization (Tobion)
 * bug #32363 [FrameworkBundle] reset cache pools between requests (nicolas-grekas)
 * bug #32365 [DI] fix processing of regular parameter bags by MergeExtensionConfigurationPass (nicolas-grekas)
 * bug #32187 [PHPUnit] Fixed composer error on Windows (misterx)
 * bug #32299 [Lock] Stores must implement `putOffExpiration` (jderusse)
 * bug #32302 [Mime] Remove @internal annotations for the serialize methods (francoispluchino)
 * bug #32334 [Messenger] Fix authentication for redis transport (alexander-schranz)
 * bug #32309 Fixing validation for messenger transports retry_strategy service key (weaverryan)
 * bug #32331 [Workflow] only decorate when an event dispatcher was passed (xabbuh)
 * bug #32236 [Cache] work aroung PHP memory leak (nicolas-grekas)
 * bug #32206 Catch JsonException and rethrow in JsonEncode (phil-davis)
 * bug #32211 [Mailer] Fix error message when connecting to a stream raises an error before connect() (fabpot)
 * bug #32210 [Mailer] Fix timeout type hint (fabpot)
 * bug #32199 [EventDispatcher] improve error messages in the event dispatcher (xabbuh)
 * bug #32200 [Security/Core] work around sodium_compat issue (nicolas-grekas)

* 4.3.2 (2019-06-26)

 * bug #31954 [PhpunitBridge] Read environment variable from superglobals (greg0ire)
 * bug #32131 [Mailgun Mailer] fixed issue when using html body (alOneh)
 * bug #31730 [PhpUnitBridge] More accurate grouping (greg0ire)
 * bug #31966 [Messenger] Doctrine Connection find and findAll now correctly decode headers (TimoBakx)
 * bug #31972 Add missing rendering of form help block. (alexsegura)
 * bug #32141 [HttpClient] fix dealing with 1xx informational responses (nicolas-grekas)
 * bug #32138 [Filesystem] fix mirroring directory into parent directory (xabbuh)
 * bug #32137 [HttpFoundation] fix accessing session bags (xabbuh)
 * bug #32147 [HttpClient] fix timing measurements with NativeHttpClient (nicolas-grekas)
 * bug #32165 revert #30525 due to performance penalty (bendavies)
 * bug #32164 [EventDispatcher] collect called listeners information only once (xabbuh)
 * bug #32173 [FrameworkBundle] Fix calling Client::getProfile() before sending a request (dunglas)
 * bug #32163 [DoctrineBridge] Fix type error (norkunas)
 * bug #32154 [Messenger] fix retrying handlers using DoctrineTransactionMiddleware (Tobion)
 * bug #32169 [Security/Core] require libsodium >= 1.0.14 (nicolas-grekas)
 * bug #32170 [Security/Core] Don't use ParagonIE_Sodium_Compat (nicolas-grekas)
 * bug #32156 [Workflow] re-add workflow.definition tag to workflow services (nikossvnk)
 * bug #32053 [Messenger] No need for retry to require SentStamp (Tobion)
 * bug #32083 [HttpClient] fixing passing debug info to progress callback (nicolas-grekas)
 * bug #32129 [DebugBundle] fix register ReflectionCaster::unsetClosureFileInfo caster in var cloner service (alekitto)
 * bug #32027 [Messenger] Remove DispatchAfterCurrentBusStamp when message is put on internal queue (Nyholm)
 * bug #32125 [Form] accept floats for input="string" in NumberType (xabbuh)
 * bug #32094 [Validator] Use LogicException for missing Property Access Component in comparison constraints (Lctrs)
 * bug #32136 [FrameworkBundle] sync `require-dev` and `conflict` constraints (xabbuh)
 * bug #32123 [Form] fix translation domain (xabbuh)
 * bug #32115 [SecurityBundle] don't validate IP addresses from env var placeholders (xabbuh)
 * bug #32116 [FrameworkBundle] tag the FileType service as a form type (xabbuh)
 * bug #32109 [Messenger] fix delay exchange recreation after disconnect (Tobion)
 * bug #32090 [Debug] workaround BC break in PHP 7.3 (nicolas-grekas)
 * bug #32076 [Lock] Fix PDO prune not called (jderusse)
 * bug #32071 Fix expired lock not cleaned (jderusse)
 * bug #32052 [Messenger] fix AMQP delay queue to be per exchange (Tobion)
 * bug #32065 [HttpClient] throw DecodingExceptionInterface when toArray() fails because of content-type error (nicolas-grekas)
 * bug #32057 [HttpFoundation] Fix SA/phpdoc JsonResponse (ro0NL)
 * bug #32040 [DI] Show the right class autowired when providing a non-existing class (Simperfit)
 * bug #32035 [Messenger] fix delay delivery for non-fanout exchanges (Tobion)
 * bug #32025 SimpleCacheAdapter fails to cache any item if a namespace is used (moufmouf)
 * bug #32022 [HttpClient] Don't use CurlHttpClient on Windows when curl.cainfo is not set (nicolas-grekas)
 * bug #32037 [Form] validate composite constraints in all groups (xabbuh)
 * bug #32007 [Serializer] Handle true and false appropriately in CSV encoder (battye)
 * bug #32036 [Messenger] improve logs (Tobion)
 * bug #31998 Parameterize Mailgun's region (jderusse)
 * bug #32000 [Routing] fix absolute url generation when scheme is not known (Tobion)
 * bug #32012 Add statement to fileLink to ignore href code when no fileLink. (bmxmale)
 * bug #32024 [VarDumper] fix dumping objects that implement __debugInfo() (nicolas-grekas)
 * bug #32014 Do not log or call the proxy function when the locale is the same (gmponos)
 * bug #32011 [HttpClient] fix closing debug stream prematurely (nicolas-grekas)
 * bug #32017 [Contracts] add missing required dependencies (mbessolov)
 * bug #31992 Fix sender/recipients in SMTP Envelope (fabpot)
 * bug #31999 [PhpunitBridge] Restore php 5.5 compat (greg0ire)
 * bug #31991 [EventDispatcher] collect called listeners information only once (xabbuh)
 * bug #31988 [TwigBridge] add back possibility to use form themes without translations (xabbuh)
 * bug #31982 [HttpClient] fix Psr18Client handling of non-200 response codes (nicolas-grekas)
 * bug #31953 [DoctrineBridge] fix handling nested embeddables (xabbuh)
 * bug #31962 Fix reporting unsilenced deprecations from insulated tests (nicolas-grekas)
 * bug #31936 PropertyInfoLoader should not try to add validation to non-existent property (weaverryan)
 * bug #31923 [Serializer] Fix DataUriNormalizer deprecation (MIME type guesser is optional) (ogizanagi)
 * bug #31928 [FrameworkBundle] avoid service id conflicts with Swiftmailer (xabbuh)
 * bug #31925 [Form] fix usage of legacy TranslatorInterface (nicolas-grekas)
 * bug #31908 [Validator] fix deprecation layer of ValidatorBuilder (nicolas-grekas)

* 4.3.1 (2019-06-06)

 * bug #31894 Fix wrong requirements for ocramius/proxy-manager in root composer.json (henrikvolmer)
 * bug #31865 [Form] Fix wrong DateTime on outdated ICU library (aweelex)
 * bug #31893 [HttpKernel] fix link to source generation (nicolas-grekas)
 * bug #31880 [FrameworkBundle] fix BC-breaking property in WebTestAssertionsTrait (nicolas-grekas)
 * bug #31881 [FramworkBundle][HttpKernel] fix KernelBrowser BC layer (nicolas-grekas)
 * bug #31879 [Cache] Pass  arg to get callback everywhere (fancyweb)
 * bug #31874 [Doctrine Bridge] Check field type before adding Length constraint (belinde)
 * bug #31872 [Messenger] Add missing runtime check for ext redis version (chalasr)
 * bug #31864 [Cache] Fixed undefined variable in ArrayTrait (eXtreme)
 * bug #31863 [HttpFoundation] Fixed case-sensitive handling of cache-control header in RedirectResponse constructor (Ivo)
 * bug #31850 [HttpClient] add $response->cancel() (nicolas-grekas)
 * bug #31871 [HttpClient] revert bad logic around JSON_THROW_ON_ERROR (nicolas-grekas)
 * bug #31869 Fix json-encoding when JSON_THROW_ON_ERROR is used (nicolas-grekas)
 * bug #31868 [HttpKernel] Fix handling non-catchable fatal errors (nicolas-grekas)
 * bug #31834 [HttpClient] Don't throw InvalidArgumentException on bad Location header (nicolas-grekas)
 * bug #31846 [Mailer] Set default crypto method (bpolaszek)
 * bug #31849 [Console] Add check for Konsole/Yakuake to disable hyperlinks (belinde)
 * bug #31854 Rename the Symfony Mailer service implementation to avoid conflict with SwitMailer (tgalopin)
 * bug #31856 [VarDumper] fix dumping the cloner itself (nicolas-grekas)
 * bug #31861 [HttpClient] work around PHP 7.3 bug related to json_encode() (nicolas-grekas)
 * bug #31860 [HttpFoundation] work around PHP 7.3 bug related to json_encode() (nicolas-grekas)
 * bug #31852 [Form] add missing symfony/service-contracts dependency (nicolas-grekas)
 * bug #31836 [DoctrineBridge] do not process private properties from parent class (xabbuh)
 * bug #31790 [Messenger] set amqp content_type based on serialization format (Tobion)
 * bug #31832 [HttpClient] fix unregistering the debug buffer when using curl (nicolas-grekas)
 * bug #31407 [Security] added support for updated "distinguished name" format in x509 authentication (Robert Kopera)
 * bug #31774 [Mailer] Fix the possibility to set a From header from MessageListener (fabpot)
 * bug #31811 [DoctrineBridge] don't add embedded properties to wrapping class metadata (xabbuh)
 * bug #31786 [Translation] Fixed case sensitivity of lint:xliff command (javiereguiluz)
 * bug #31815 [Translator] Collect locale details earlier in the process (pierredup)
 * bug #31761 [TwigBridge] suggest Translation Component when TranslationExtension is used (nicolas-grekas)
 * bug #31748 [Messenger] Inject RoutableMessageBus instead of bus locator (chalasr)
 * bug #31763 [Security\Core] Make SodiumPasswordEncoder validate BCrypt-ed passwords (nicolas-grekas)
 * bug #31744 [Validator] Fix TimezoneValidator default option (ro0NL)
 * bug #31749 [DoctrineBridge][Validator] do not enable validator auto mapping by default (xabbuh)
 * bug #31757 [DomCrawler] Fix type error with null Form::$currentUri (chalasr)
 * bug #31721 [PHPUnitBridge] Use a more appropriate group when deprecating mode (greg0ire)

* 4.3.0 (2019-05-30)

 * bug #31654 [HttpFoundation] Do not set X-Accel-Redirect for paths outside of X-Accel-Mapping (vilius-g)

* 4.3.0-RC1 (2019-05-28)

 * bug #31650 Create an abstract HTTP transport and extend it in all HTTP transports (bocharsky-bw)
 * feature #31641 [HttpClient] make $response->getInfo('debug') return extended logs about the HTTP transaction (nicolas-grekas)
 * feature #31571 [Contracts] split in one package per sub-contracts (nicolas-grekas)
 * bug #31625 [Messenger] Disable the SchemaAssetsFilter when setup the transport (vincenttouzet)
 * bug #31621 [Messenger] Fix missing auto_setup for RedisTransport (chalasr)
 * bug #31584 [Workflow] Do not trigger extra guards (lyrixx)
 * bug #31632 [Messenger] Use "real" memory usage to honor --memory-limit (chalasr)
 * bug #31610 [HttpClient] fix handling exceptions thrown before first mock chunk (nicolas-grekas)
 * bug #31615 Allow WrappedListener to describe uncallable listeners (derrabus)
 * bug #31599 [Translation] Fixed issue with new vs old TranslatorInterface in TranslationDataCollector (althaus)
 * bug #31565 [Mime][HttpFoundation] Added mime type audio/x-hx-aac-adts (ifaridjalilov)
 * bug #31591 [FrameworkBundle] fix named autowiring aliases for TagAwareCacheInterface (nicolas-grekas)
 * bug #31590 [Cache] improve logged messages (nicolas-grekas)
 * bug #31586 [HttpClient] display proper error message on TransportException when curl is used (nicolas-grekas)
 * bug #31349 [WebProfilerBundle] Use absolute URL for profiler links (Alumbrados)
 * bug #31541 [DI] fix using bindings with locators of service subscribers (nicolas-grekas)
 * bug #31568 [Process] Fix infinite waiting for stopped process (mshavliuk)

* 4.3.0-BETA2 (2019-05-22)

 * bug #31569 [HttpClient] Only use CURLMOPT_MAX_HOST_CONNECTIONS & CURL_VERSION_HTTP2 if defined (GawainLynch)
 * bug #31566 [Security] fixed a fatal error when upgrading from 4.2 (fabpot)
 * bug #31219 [HttpClient] Allow arrays as query parameters (sleepyboy)
 * bug #31482 [Messenger][DoctrineBridge] Throws UnrecoverableMessageHandlingException when passed invalid entity manager name (Koc)
 * feature #31471 [Messenger] Add "non sendable" stamps (weaverryan)
 * bug #31545 [Messenger] Fix redis Connection::get() should be non blocking by default (chalasr)
 * bug #31537 [Workflow] use method marking store (noniagriconomie)
 * bug #31551 [ProxyManager] isProxyCandidate() does not take into account interfaces (andrerom)
 * bug #31542 [HttpClient] add missing argument check (nicolas-grekas)
 * bug #31544 [Messenger] Fix undefined index on read timeout (chalasr)
 * bug #31335 [Doctrine] Respect parent class contract in ContainerAwareEventManager (Koc)
 * bug #31421 [Routing][AnnotationClassLoader] fix utf-8 encoding in default route name (przemyslaw-bogusz)
 * bug #31493 [EventDispatcher] Removed "callable" type hint from WrappedListener constructor (wskorodecki)
 * bug #31502 [WebProfilerBundle][Form] The form data collector return serialized data (Simperfit)
 * bug #31510 Use the current working dir as default first arg in 'link' binary (lyrixx)
 * bug #31524 [HttpFoundation] prevent deprecation when filesize matches error code (xabbuh)
 * bug #31535 [Debug] Wrap call to require_once in a try/catch (lyrixx)
 * feature #31030 [Serializer] Deprecate calling createChildContext without the format parameter (dbu)
 * bug #31459 Fix the interface incompatibility of EventDispatchers (keulinho)
 * bug #31463 [DI] default to service id - *not* FQCN - when building tagged locators (nicolas-grekas)
 * feature #31294 [Form] Add intl/choice_translation_locale option to TimezoneType (ro0NL)
 * feature #31452 [FrameworkBundle] Add cache configuration for PropertyInfo (alanpoulain)
 * feature #31486 [Doctrine][PropertyInfo] Detect if the ID is writeable (dunglas)
 * bug #31481 [Validator] Autovalidation: skip readonly props (dunglas)
 * bug #31480 Update dependencies in the main component (DavidPrevot)
 * bug #31477 [PropertyAccess] Add missing property to PropertyAccessor (vudaltsov)
 * bug #31479 [Cache] fix saving unrelated keys in recursive callback calls (nicolas-grekas)
 * bug #30930 [FrameworkBundle] Fixed issue when a parameter contains a '' (lyrixx)
 * bug #31438 [Serializer] Fix denormalization of object with variadic constructor typed argument  (ajgarlag)
 * bug #31445 [Messenger] Making cache rebuild correctly when message subscribers change (weaverryan)
 * bug #31442 [Validator] Fix finding translator parent definition in compiler pass (deguif)
 * bug #31475 [HttpFoundation] Allow set 'None' on samesite cookie flag (markitosgv)
 * feature #31454 [Messenger] remove send_and_handle which can be achieved with SyncTransport (Tobion)
 * bug #31425 [Messenger] On failure retry, make message appear received from original sender (weaverryan)
 * bug #31472 [Messenger] Fix routable message bus default bus (weaverryan)
 * bug #31465 [Serializer] Fix BC break: DEPTH_KEY_PATTERN must be public (dunglas)
 * bug #31458 [TwigBundle] Fix Mailer integration in Twig (fabpot)
 * bug #31456 Remove deprecated usage of some Twig features (fabpot)
 * bug #31207 [Routing] Fixed unexpected 404 NoConfigurationException (yceruto)
 * bug #31261 [Console] Commands with an alias should not be recognized as ambiguous when using register (Simperfit)
 * bug #31371 [DI] Removes number of elements information in debug mode (jschaedl)
 * bug #31418 [FrameworkBundle] clarify the possible class/interface of the cache (xabbuh)

* 4.3.0-BETA1 (2019-05-09)

 * feature #31249 [Translator] Set sources when extracting strings from php files (Stadly)
 * feature #31365 [Intl] Made countries ISO 3166 compliant + exclude Zzzz script code (ro0NL)
 * feature #31060 [Validator] Make API endpoint for NotCompromisedPasswordValidator configurable (xelan)
 * feature #31353 [FrameworkBundle] Show injected services for iterator and array arguments (jschaedl)
 * feature #31350 [Intl] Rename Regions to Countries (ro0NL)
 * feature #31364 [Bridge/PhpUnit] Extract all the code but shebang from bin/simple-phpunit (JustBlackBird)
 * feature #30985 [Form] Keep preferred choices order in ChoiceType (vudaltsov)
 * feature #31288 [Messenger] RoutableMessageBus route to default bus (dirk39)
 * feature #31292 [Validator] Allow intl timezones (ro0NL)
 * feature #30970 [Messenger] Adding failure transport support (weaverryan)
 * feature #31318 [Intl] Compile localized timezone offset name (ro0NL)
 * feature #31248 [Translator] Add sources when dumping qt files (Stadly)
 * feature #31280 [WebServerBundle] Change the default pidfile location to cache directory (jschaedl)
 * feature #31293 [Form] Remove default option grouping in TimezoneType (ro0NL)
 * feature #31262 [Intl] Update timezones to ICU 64.2 + compile zone to country mapping (ro0NL)
 * feature #31295 [Intl] Add timezone offset utilities (ro0NL)
 * feature #30958 [Messenger] Allows to register handlers on a specific transport (sroze)
 * feature #31061 [BridgeDoctrineMessenger] Doctrine ping connection middleware (insidestyles)
 * feature #31282 [Messenger] Add WorkerStoppedEvent (chalasr)
 * feature #31138 [Security] Dispatch an event when "logout user on change" steps in (Simperfit)
 * feature #31242 Update LoggingTranslator to log the change of a locale (gmponos)
 * feature #30917 [Messenger] Add a redis stream transport (soyuka, alexander-schranz)
 * feature #31195 [Form] Add intltimezone input to TimezoneType (ro0NL)
 * feature #31134 [Routing] do not encode comma in query and fragment (Tobion)
 * feature #31220 [TwigBridge] bootstrap4 file_widget: allow setting label attributes declared in label_attr (AngelFQC)
 * feature #31204 [Messenger] ease testing and allow forking the middleware stack (nicolas-grekas)
 * feature #30370 [Cache] Add optimized FileSystem & Redis TagAware Adapters (andrerom)
 * feature #28831 [Intl] Add Timezones (ro0NL)
 * feature #31170 [Security] deprecate BCryptPasswordEncoder in favor of NativePasswordEncoder (nicolas-grekas)
 * feature #31140 [Security] Add NativePasswordEncoder (nicolas-grekas)
 * feature #31130 [VarDumper] add caster for WeakReference instances of PHP 7.4 (nicolas-grekas)
 * feature #31082 [Form] Show all option normalizers on debug:form command (yceruto)
 * feature #30957 [Messenger] Remove base64_encode & use addslashes (weaverryan)
 * feature #30717 [Serializer] Use name converter when normalizing constraint violation list (norkunas)
 * feature #28846 [Intl] Simplify API (ro0NL)
 * feature #31093 [PhpUnitBridge] ClockMock does not mock gmdate() (Simperfit)
 * feature #29211 [PhpUnitBridge] Url encoded deprecations helper config (greg0ire)
 * feature #31062 [Dotenv] Deprecate useage of "putenv" (Nyholm)
 * feature #31021 [Cache] Added command for list all available cache pools (Nyholm)
 * feature #31027 [Config] Deprecate TreeBuilder::root (gharlan)
 * feature #31019 [Security] Replace Argon2*PasswordEncoder by SodiumPasswordEncoder (chalasr)
 * feature #30997 [Console] Add callback support to Console\Question autocompleter (Mikkel Paulson)
 * feature #30959 [FrameworkBundle] [TwigBundle] Move the hinclude key away from templating (Simperfit)
 * feature #30968 [Security] Add Argon2idPasswordEncoder (chalasr)
 * feature #30963 [Serializer] Experimental for ObjectListExtractor (joelwurtz)
 * feature #30933 [Routing][ObjectRouteLoader] Allow invokable route loader services (fancyweb)
 * feature #30897 [DIC] Add a `require` env var processor (mpdude)
 * feature #30964 [HttpKernel] Add a "short" trace header format, make header configurable (mpdude)
 * feature #29935 [DI] Fix bad error message for unused bind under _defaults (przemyslaw-bogusz)
 * feature #30962 [DoctrineBridge] Deprecated implicit optimization in DoctrineChoiceLoader (HeahDude)
 * feature #30862 [Routing] UrlHelper to get absolute URL for a path (vudaltsov)
 * feature #30607 [Serializer] Add Support of recursive denormalization on object_to_populate (jewome62)
 * feature #30429 [Form]  group_by as callback returns array (antonch1989)
 * feature #30887 [FrameworkBundle] fix search in debug autowiring (sez-open)
 * feature #30935 Use env variable to create anytype of lock store (jderusse)
 * feature #30932 [Validator] Add an option to disable NotCompromisedPasswordValidator (lyrixx)
 * feature #30909 [Translator] Add comments when dumping po files (deguif)
 * feature #30913 [Messenger] Uses an `AmqpStamp` to provide flags and attributes (sroze)
 * feature #30900 [Validator] add new `Timezone` validation constraint (phansys)
 * feature #30915 [Serializer] Add datetimezone normalizer (jewome62)
 * feature #28937 Improve Translator caching  (rpkamp)
 * feature #30904 [Serializer] provide new ObjectPropertyListExtractorInterface (dmaicher)
 * feature #30902 [Workflow] The TransitionEvent is able to modify the context (lyrixx)
 * feature #30908 [Workflow] Added workflow_transition_blockers twig function (lyrixx)
 * feature #30893 Add "input" option to NumberType (fancyweb, Bernhard Schussek)
 * feature #30898 [Validator] Wire NotCompromisedPassword in FrameworkBundle and handle non UTF-8 password (tgalopin)
 * feature #30890 [Workflow] Changed initial_places to initial_marking, added property (HeahDude, lyrixx)
 * feature #30906 [symfony/HttpKernel] Throws an error when the generated class name is invalid. (drupol)
 * feature #30892 [DomCrawler] Improve Crawler HTML5 parser need detection (tgalopin)
 * feature #30901 Renamed NotPwned to NotCompromisedPassword (javiereguiluz)
 * feature #30020 [Messenger] Ensure message is handled only once per handler (keulinho, sroze)
 * feature #30545 #30536 PropertyAccessor->getValue disable exception (dimabory)
 * feature #30008 [messenger] Adds a stamp to provide a routing key on message publishing (G15N, sroze)
 * feature #29097 [Messenger] Add a "in-memory://" transport (GaryPEGEOT, sroze)
 * feature #30537 [HttpClient] logger integration (antonch1989, nicolas-grekas)
 * feature #30853 [Twig] Remove TemplatedEmail::template() (fabpot)
 * feature #30757 [Messenger] Adding MessageCountAwareInterface to get transport message count (weaverryan)
 * feature #28929 [HttpKernel][Framework] Locale aware services (neghmurken)
 * feature #29306 [DomCrawler] Optionally use html5-php to parse HTML (tgalopin)
 * feature #30255 [DependencyInjection] Invokable Factory Services (zanbaldwin)
 * feature #30843 [HttpClient] Add ScopingHttpClient::forBaseUri() + tweak MockHttpClient (nicolas-grekas)
 * feature #30844 [Cache] add logs on early-recomputation and locking (nicolas-grekas)
 * feature #30520 [RouterDebugCommand] add link to Controllers (nicoweb)
 * feature #30212 [DI] Add support for "wither" methods - for greater immutable services (nicolas-grekas)
 * feature #30674 [FrameworkBundle] change the way http clients are configured by leveraging ScopingHttpClient (nicolas-grekas)
 * feature #29312 [EventDispatcher] Split events across requests (ro0NL)
 * feature #30827 [TwigBridge] Add template file link to debug:twig command (yceruto)
 * feature #30826 [Form] Add file links for described classes in debug:form command (yceruto)
 * feature #30813 New PHPUnit assertions for the WebTestCase (Pierstoval, fabpot)
 * feature #27738 [Validator] Add a HaveIBeenPwned password validator (dunglas)
 * feature #30690 Changing messenger bus id from 'message_bus' to 'messenger.default_bus' (THERAGE Kévin)
 * feature #30810 [Inflector] remove "internal" marker from the component (nicolas-grekas)
 * feature #26890 [Inflector] Support pluralization in the inflector (mbabker)
 * feature #28637 [Validator] add number constraints (jschaedl)
 * feature #30754 [Messenger] New messenger:stop-workers Command (weaverryan)
 * feature #30707 [Messenger][DX] Allow stamps to be passed directly to MessageBusInterface::dispatch() (weaverryan)
 * feature #29007 [Messenger] Add a Doctrine transport (vincenttouzet)
 * feature #30628 Making the serializer configurable by transport (weaverryan)
 * feature #30569 [FrameworkBundle][HttpKernel] Provide intuitive error message when a controller fails because it's not registered as a service (moynzzz)
 * feature #26484 [Validator] String normalization options for string-based validators (renan-taranto)
 * feature #30320 [Form][TwigBridge] Add row_attr to form theme (alexander-schranz)
 * feature #30371 [OptionsResolver] Add a new method addNormalizer and normalization hierarchy (yceruto)
 * feature #27735 [Validator][DoctrineBridge][FWBundle] Automatic data validation (dunglas)
 * feature #30758 [PropertyAccess] Allow Can Accessor in Property Access (ragboyjr)
 * feature #30116 [Filesystem] Fix mirroring a directory into itself or in his child with realpath checks (Fleuv, XuruDragon)
 * feature #28879 [Debug] Mimic __toString php behavior in FlattenException (Deltachaos)
 * feature #29495 [Ldap] Implement pagination (kevans91)
 * feature #29448 [Ldap] Entry move support  (kevans91)
 * feature #30741 Add the Mailer component (fabpot)
 * feature #30780 Fix some exception previous type hints (fabpot)
 * feature #30729 [HttpKernel] change $previous argument for HttpException to \Throwable (sGy1980de)
 * feature #30744 [Finder] Throw a dedicated exception for non-existing directory (xelan)
 * feature #30759 [Messenger] Adding the "sync" transport to call handlers synchronously (weaverryan)
 * feature #30772 [Contracts][EventDispatcher] move the Event class to symfony/contracts (nicolas-grekas)
 * feature #30708 [Messenger] ReceiverInterface::handle() to get() & Worker with prioritized transports (weaverryan)
 * feature #27648 [Lock] Added MongoDBStore (Joe Bennett)
 * feature #30752 [HttpClient] use "nyholm/psr7" by default in Psr18Client (nicolas-grekas)
 * feature #30671 Add optional parameter `prefetching` for AMQP connection (fbouchery)
 * feature #25707 [DI] ServiceProviderInterface, implementation for ServiceLocator (kejwmen)
 * feature #30606 [Validator] allow brackets in the optional query string (Emmanuel BORGES)
 * feature #29476 [Messenger] Add a command to setup transports (vincenttouzet)
 * feature #30719 [Mime] Add BodyRendererInterface (fabpot)
 * feature #30664 [Finder] Get filename without extension (antonch1989)
 * feature #30645 Alias for each assets package (gpenverne)
 * feature #30706 [PropertyInfo] Add possibility to extract private and protected properties in reflection extractor (joelwurtz)
 * feature #27808 [DI] Deprecate non-string default envs (ro0NL)
 * feature #30691 [Contracts][EventDispatcher] add EventDispatcherInterface to symfony/contracts and use it where possible (nicolas-grekas)
 * feature #20978 [Form] TransformationFailedException: Support specifying message to display (ogizanagi)
 * feature #30676 Avoid dispatching SendMessageToTransportsEvent on redeliver (weaverryan)
 * feature #26555 [Validator] Add constraint on unique elements collection(Assert\Unique) (zenmate, nicolas-grekas)
 * feature #27684 [FrameworkBundle] Debug container environment variables (ro0NL)
 * feature #30666 [Form][Console] Use dumper (ro0NL)
 * feature #30559 [HttpClient] Parse common API error formats for better exception messages (dunglas)
 * feature #28898 [Console] Add dumper (ro0NL)
 * feature #30629 [HttpClient] added CachingHttpClient (fabpot)
 * feature #30602 [BrowserKit] Add support for HttpClient (fabpot, THERAGE Kévin)
 * feature #30651 Allow user to set the project dir (tdutrion)
 * feature #30654 [HttpClient] Add a ScopingHttpClient (XuruDragon)
 * feature #30388 [Security] undeprecate the RoleHierarchyInterface (xabbuh)
 * feature #30652 Fixing a bug where messenger:consume could send message to wrong bus (weaverryan)
 * feature #30650 Dispatching two events when a message is sent & handled (weaverryan)
 * feature #30557 [Messenger] Worker events + global retry functionality (weaverryan)
 * feature #30468 [Workflow] Added support for many inital places (lyrixx)
 * feature #30448  [Finder] Ignore paths from .gitignore #26714 (amaabdou)
 * feature #30625 [HttpKernel] add RealHttpKernel: handle requests with HttpClientInterface (fabpot)
 * feature #30508 [Routing] Exposed "utf8" option, defaults "locale" and "format" in configuration (Jules Pietri)
 * feature #28920 [EventDispatcher] swap arguments of dispatch() to allow registering events by FQCN (nicolas-grekas)
 * feature #30605 [Cache] added DSN support for rediss in AbstractAdapter and RedisTrait (alex-vasilchenko-md)
 * feature #30604 [HttpClient] add MockHttpClient (nicolas-grekas)
 * feature #21035 [FrameworkBundle] Deprecate the Templating component integration (dunglas, fabpot)
 * feature #30567 [HttpClient] exceptions carry response (antonch1989)
 * feature #28849 [Messenger] Support for handling messages after current bus is finished (Nyholm)
 * feature #29538 [Workflow] Add colors to workflow dumps (alexislefebvre)
 * feature #28975 [DI] Add an url EnvProcessor (jderusse)
 * feature #30419 [FrameworkBundle] Add integration of http-client component (Ioni14, nicoweb)
 * feature #30583 [Messenger] Display a nice error when connection fail (lyrixx)
 * feature #30450 [Profiler] Render the performance graph with SVG (Tom32i)
 * feature #29130 [Serializer] Normalize constraint violation parameters (ogizanagi)
 * feature #28330 [MonologBridge] Add monolog processors adding route and command info (trakos)
 * feature #30339 [Monolog] Disable DebugLogger in CLI (lyrixx)
 * feature #30584 [Intl] Add compile binary (ro0NL)
 * feature #30579 Using AMQP auto-setup in all cases, not just in debug (weaverryan)
 * feature #30348 [DependencyInjection] Add ability to define an index for service in an injected service locator argument (XuruDragon, nicolas-grekas)
 * feature #30469 Create a hyperlink to interfaces/classes that can be autowired (SerkanYildiz)
 * feature #30334 [DI] add ReverseContainer: a locator that turns services back to their ids (nicolas-grekas)
 * feature #30539 [Messenger] deprecate LoggingMiddleware in favor of providing a logger to SendMessageMiddleware (nicolas-grekas)
 * feature #30556 [HttpClient] Allow to pass user/pw as an array (dunglas)
 * feature #30547 [HttpClient] Add new bearer option (dunglas)
 * feature #29303 [Messenger] add welcome notice when running the command (nicolas-grekas)
 * feature #30541 [BrowserKit] Rename Client to Browser (fabpot)
 * feature #30504 [DI] replace "nullable" env processor by improving the "default" one (nicolas-grekas)
 * feature #30499 [HttpClient] add ResponseInterface::toArray() (nicolas-grekas)
 * feature #30472 [Translation] Add XLIFF 1 source to metadata to differentiate from attr (ostrolucky)
 * feature #30484 [Mime] added Headers::toArray() (fabpot)
 * feature #30482 [Mime] Fix support for date form parts (fabpot)
 * feature #30385 [SecurityBundle] Validate the IPs configured in access_control (javiereguiluz)
 * feature #30413 [HttpClient][Contracts] introduce component and related contracts (nicolas-grekas)
 * feature #30377 [Validator] add MIR card scheme (antonch1989)
 * feature #29146 [Workflow] Added a context to `Workflow::apply()` (lyrixx)
 * feature #30433 [Form] Allow to disable and customize PercentType symbol (Ken Stanley, OskarStark)
 * feature #30408 [HttpKernel] Better exception page when the invokable controller returns nothing  (dimabory)
 * feature #30325 [HttpKernel] Prevent search engines from indexing dev applications (GaryPEGEOT)
 * feature #30390 [FrameworkBundle] Fix UrlGenerator::generate to return an empty string instead of null (Emmanuel BORGES)
 * feature #30375 [Messenger] Added transport agnostic exception (nikossvnk, lolmx)
 * feature #29254 [FrameworkBundle] Added the condition routing option to the debug router command (soufianZantar)
 * feature #30286 Drop more usages of Serializable (nicolas-grekas)
 * feature #30379 [FrameworkBundle][Routing] allow boolean container parameters for routes (dmaicher)
 * feature #29661 [Filesystem] Support resources and deprecate using arrays in dumpFile() and appendToFile() (thewilkybarkid)
 * feature #30358 [Form] be able to specify the input format for times (xabbuh)
 * feature #30416 Mime messages (fabpot)
 * feature #22048 [Security] deprecate the Role and SwitchUserRole classes (xabbuh)
 * feature #30345 [Monolog] Added a way to configure the ConsoleFormatter from the ConsoleHandler (lyrixx)
 * feature #30357 [TwigBridge] rename parent_form() to form_parent() (xabbuh)
 * feature #30257 [DependencyInjection] Allow to choose an index for tagged collection (deguif, XuruDragon)
 * feature #30311 [VarDumper] Implement DsCaster (enumag)
 * feature #27570 [PropertyInfo] Added support for extract type from default value (tsantos84)
 * feature #28919 [DX][WebProfilerBundle] Add Pretty Print functionality for Request Content (SamFleming)
 * feature #28723 [Form] deprecate custom formats with HTML5 widgets (xabbuh)
 * feature #29865 [Console] Added suggestions for missing packages (przemyslaw-bogusz)
 * feature #30301 [VarDumper] add link to source next to class names (nicolas-grekas)
 * feature #30225 publish message with custom queue options : flags | attributes (fedor.f, insidestyles)
 * feature #30249 [Routing] deprecate some router options (Tobion)
 * feature #30267 [Form] add option to render NumberType as type="number" (xabbuh)
 * feature #28969 [Form] deprecate using invalid names for buttons (xabbuh)
 * feature #29887 [Form] Add input_format option to DateType and DateTimeType (fancyweb)
 * feature #30051 Drop \Serializable implementations (renanbr)
 * feature #30236 Add element to ghost in Exception (przemyslaw-bogusz)
 * feature #30120 [FrameworkBundle][Translation] Added support for PHP files with trans() in translation commands (yceruto)
 * feature #28812 [Form] add a convenience method to get the parent form in Twig templates (xabbuh)
 * feature #29121 [FrameworkBundle][Translation] Add support for Translator paths, Twig paths and Translator aware services paths in commands (yceruto)
 * feature #28477 [Validator] Add new json Validator (zairigimad)
 * feature #30126 [Form] forward valid numeric values to transform() (xabbuh)
 * feature #28635 [Form] Add label_translation_parameters, help_translation_parameters and attr_translation_parameters options to base form type (webnet-fr)
 * feature #29767 Nullable environment variable processor (bpolaszek)
 * feature #30111 [SecurityBundle] Deprecate the normalization of the cookie names (javiereguiluz)
 * feature #30027 [FrameworkBundle] Add sid_length and sid_bits_per_character session ini options in session configuration (XuruDragon)
 * feature #30075 [DependencyInjection] Added information about deprecated aliases in debug:autowiring (XuruDragon)
 * feature #30024 [Debug] Display more details in the simple error page of Debug (javiereguiluz)
 * feature #30052 [Security] Replace serialization API (renanbr)
 * feature #27898 [Yaml] Fixed invalid Parser behavior (guiguiboy)
 * feature #29753 [Console] Add an iterate method to the ProgressBar class (jvasseur)
 * feature #29999 [PropertyAccess] speed up accessing object properties (xabbuh)
 * feature #29641 [Validator] NotBlank: add a new option to allow null values (dunglas)
 * feature #28721 [Form] deprecate some options for single_text widgets (xabbuh)
 * feature #29936 [Mime] Add a set of default content-types for some extensions (fabpot)
 * feature #28865 [Routing] allow using compiled matchers and generators without dumping PHP code (nicolas-grekas)
 * feature #29236 [Cache] deprecate all PSR-16 adapters, provide Psr16Cache instead (nicolas-grekas)
 * feature #29958 introducing native php serialize() support for Messenger transport (weaverryan, xabbuh)
 * feature #29861 [Form][TwigBridge] Add help_html (mpiot)
 * feature #29968 [DI] Added support for deprecating aliases (j92, Renan)
 * feature #29850 [FrameworkBundle] xliff-version option to translation update command (andrewwro)
 * feature #29896 [Mime] Add the component (fabpot)
 * feature #29862 Add block prefix to csrf token field (alexander-schranz)
 * feature #29881 [BrowserKit] Various changes to the Response class (fabpot)
 * feature #29813 [FrameworkBundle] Remove ControllerTrait::isFormValid() (lyrixx)
 * feature #29148 Load original file metadata when loading Xliff 1.2 files (eternoendless)
 * feature #29840 [FrameworkBundle] pass project dir into the assets install command (xabbuh)
 * feature #29821 [VarDumper] add caster for OpenSSL X.509 resources (nicolas-grekas)
 * feature #29781 [DI] Add trim env processor (ogizanagi)
 * feature #28902 [Debug] Detect virtual methods using @method (ro0NL)
 * feature #29780 [Profiler] Still show locale and fallback locale even if no trans used (ogizanagi)
 * feature #29680 [Form] Add new block_prefix option for an easy form theming (yceruto)
 * feature #29528 [DebugBundle] Added 'theme' option to change the color of dump() when rendered inside templates (dem3trio)
 * feature #24576 [FrameworkBundle] Added `ControllerTrait::isFormValid` (lyrixx)
 * feature #29483 [HttpKernel] Set the default locale early (thewilkybarkid)
 * feature #29186 [HttpKernel] Increase priority of AddRequestFormatsListener (thewilkybarkid)
 * feature #29658 [Validator] Choices constraint improvement   (nikophil)
 * feature #29283 [Serializer] CsvEncoder no header option (encode / decode) (redecs)
 * feature #29718 [PHPUnit bridge] Bump php version of PHPUnit-bridge (gmponos)
 * feature #29599 [Routing] Allow force-generation of trailing parameters using eg "/exports/news.{!_format}" (zavulon)
 * feature #29613 [VarDumper] Use hyperlinks in CliDescriptor (ogizanagi)
 * feature #28581 [DomCrawler] return empty string on `Crawler::text()` and `Crawler::html()` instead of an exception (respinoza)
 * feature #29286 [WebProfilerBundle] Enable translation filters (ro0NL)
 * feature #29517 [Hackday][Messenger] Add an alias for transport.symfony_serializer so SerializerInterface can be autowired (karser)
 * feature #29108 [DI] compute autowiring error messages lazily (nicolas-grekas)
 * feature #29235 [VarDumper] add support for links in CliDumper (nicolas-grekas)
 * feature #29541 [FrameworkBundle] Stop calling Kernel::boot() twice in cli (chalasr)
 * feature #28931 [PhpUnitBridge] Added ClassExistsMock (ro0NL)
 * feature #29504 [Validator] Add support for UATP card validation (raulfraile)
 * feature #29168 [Console] Add hyperlinks support (ostrolucky)
 * feature #29439 [PhpUnitBridge] install PHPUnit 7 on PHP 7.1 and fix requir. for PHPUnit 6 (gregurco)
 * feature #29452 [Form] Shortcut debug:form for partial type name (ro0NL)
 * feature #28954 [Debug] Mark ErrorHandler and ExceptionHandler classes as final (fancyweb)
 * feature #28479 [Validator] Checking a BIC along with an IBAN (sylfabre)
 * feature #28858 [DI] Deprecated using env vars with cannotBeEmpty() (ro0NL)
 * feature #28976 [DI] Add a "default" EnvProcessor (jderusse)
 * feature #29127 [DomCrawler] Added return of element name in `extract()` method (andrey-helldar)
 * feature #29145 [Workflow] Trigger `entered` event for subject entering in the Workflow for the first time (lyrixx)

