CHANGELOG for 3.4.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 3.4 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v3.4.0...v3.4.1

* 3.4.3 (2018-01-05)

 * bug #25685 Use triggering file to determine weak vendors if when the test is run in a separate process (alexpott)
 * bug #25671 Remove randomness from dumped containers (nicolas-grekas)
 * bug #25532 [HttpKernel] Disable CSP header on exception pages (ostrolucky)
 * bug #25678 [WebProfilerBundle] set the var in the right scope (Jochen Mandl)
 * bug #25491 [Routing] Use the default host even if context is empty (sroze)
 * bug #25672 [WebServerBundle] use interface_exists instead of class_exists (kbond)
 * bug #25662 Dumper shouldn't use html format for phpdbg / cli-server (jhoff)
 * bug #25529 [Validator] Fix access to root object when using composite constraint (ostrolucky)
 * bug #25404 [Form] Remove group options without data on debug:form command (yceruto)
 * bug #25430 Fixes for Oracle in PdoSessionHandler (elislenio)
 * bug #25117 [FrameworkBundle] Make cache:clear "atomic" and consistent with cache:warmup (hkdobrev)
 * bug #25583 [HttpKernel] Call Response->setPrivate() instead of sending raw header() when session is started (Toflar)
 * bug #25601 [TwigBundle/Brige] catch missing requirements to throw meaningful exceptions (nicolas-grekas)
 * bug #25547 [DX][DependencyInjection] Suggest to write an implementation if the interface cannot be autowired (sroze)
 * bug #25599 Add application/ld+json format associated to json (vincentchalamon)
 * bug #25623 [HttpFoundation] Fix false-positive ConflictingHeadersException (nicolas-grekas)
 * bug #25624 [WebServerBundle] Fix escaping of php binary with arguments (nicolas-grekas)
 * bug #25604 Add check for SecurityBundle in createAccessDeniedException (FGM)
 * bug #25591 [HttpKernel] fix cleaning legacy containers (nicolas-grekas)
 * bug #25526 [WebProfilerBundle] Fix panel break when stopwatch component is not installed. (umulmrum, javiereguiluz)
 * bug #25606 Updating message to inform the user how to install the component (weaverryan)
 * bug #25571 [SecurityBundle] allow auto_wire for SessionAuthenticationStrategy class (xavren)
 * bug #25567 [Process] Fix setting empty env vars (nicolas-grekas)
 * bug #25407 [Console] Commands with an alias should not be recognized as ambiguous (Simperfit)
 * bug #25523 [WebServerBundle] fix a bug where require would not require the good file because of env (Simperfit)
 * bug #25559 [Process] Dont use getenv(), it returns arrays and can introduce subtle breaks accros PHP versions (nicolas-grekas)
 * bug #25552 [WebProfilerBundle] Let fetch() cast URL to string (ro0NL)
 * bug #25521 [Console] fix a bug when you are passing a default value and passing -n would output the index (Simperfit)

* 3.4.2 (2017-12-15)

 * bug #25489 [FrameworkBundle] remove esi/ssi renderers if inactive (dmaicher)
 * bug #25502 Fixing wrong class_exists on interface (weaverryan)
 * bug #25427 Preserve percent-encoding in URLs when performing redirects in the UrlMatcher (mpdude)
 * bug #25480 [FrameworkBundle] add missing validation options to XSD file (xabbuh)
 * bug #25487 [Console] Fix a bug when passing a letter that could be an alias (Simperfit)
 * bug #25425 When available use AnnotationRegistry::registerUniqueLoader (jrjohnson)
 * bug #25474 [DI] Optimize Container::get() for perf (nicolas-grekas)
 * bug #24594 [Translation] Fix InvalidArgumentException when using untranslated plural forms from .po files (BjornTwachtmann)
 * bug #25233 [TwigBridge][Form] Fix hidden currency element with Bootstrap 3 theme (julienfalque)
 * bug #25413 [HttpKernel] detect deprecations thrown by container initialization during tests (nicolas-grekas)
 * bug #25408 [Debug] Fix catching fatal errors in case of nested error handlers (nicolas-grekas)
 * bug #25330 [HttpFoundation] Support 0 bit netmask in IPv6 (`::/0`) (stephank)
 * bug #25378 [VarDumper] Fixed file links leave blank pages when ide is configured (antalaron)
 * bug #25410 [HttpKernel] Fix logging of post-terminate errors/exceptions (nicolas-grekas)
 * bug #25417 [Process] Dont rely on putenv(), it fails on ZTS PHP (nicolas-grekas)
 * bug #25333 [DI] Impossible to set an environment variable and then an array as container parameter (Phantas0s)
 * bug #25447 [Process] remove false-positive BC breaking exception on Windows (nicolas-grekas)
 * bug #25381 [DI] Add context to service-not-found exceptions thrown by service locators (nicolas-grekas)
 * bug #25438 [Yaml] empty lines don't count for indent detection (xabbuh)
 * bug #25412 Extend Argon2i support check to account for sodium_compat (mbabker)
 * bug #25389 [Yaml] fix some edge cases with indented blocks (xabbuh)
 * bug #25396 [Form] Fix debug:form command definition (yceruto)
 * bug #25398 [HttpFoundation] don't prefix cookies with "Set-Cookie:" (pableu)
 * bug #25354 [DI] Fix non-string class handling in PhpDumper (nicolas-grekas, sroze)
 * bug #25340 [Serializer] Unset attributes when creating child context (dunglas)
 * bug #25325 [Yaml] do not evaluate PHP constant names (xabbuh)
 * bug #25380 [FrameworkBundle][Cache] register system cache clearer only if it's used (xabbuh)
 * bug #25323 [ExpressionLanguage] throw an SyntaxError instead of an undefined index notice (Simperfit)
 * bug #25363 [HttpKernel] Disable inlining on PHP 5 (nicolas-grekas)
 * bug #25364 [DependencyInjection] Prevent a loop in aliases within the `findDefinition` method (sroze)
 * bug #25337 Remove Exclusive Lock That Breaks NFS Caching (brianfreytag)

* 3.4.1 (2017-12-04)

 * bug #25304 [Bridge/PhpUnit] Prefer $_SERVER['argv'] over $argv (ricknox)
 * bug #25272 [SecurityBundle] fix setLogoutOnUserChange calls for context listeners (dmaicher)
 * bug #25282 [DI] Register singly-implemented interfaces when doing PSR-4 discovery (nicolas-grekas)
 * bug #25274 [Security] Adding a GuardAuthenticatorHandler alias (weaverryan)
 * bug #25308 [FrameworkBundle] Fix a bug where a color tag will be shown when passing an antislash (Simperfit)
 * bug #25278 Fix for missing whitespace control modifier in form layout (kubawerlos)
 * bug #25306 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25305 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25236 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25312 [DI] Fix deep-inlining of non-shared refs (nicolas-grekas)
 * bug #25309 [Yaml] parse newlines in quoted multiline strings (xabbuh)
 * bug #25313 [DI] Fix missing unset leading to false-positive circular ref (nicolas-grekas)
 * bug #25285 [DI] Throw an exception if Expression Language is not installed (sroze)
 * bug #25241 [Yaml] do not eagerly filter comment lines (xabbuh)
 * bug #25297 [Validator] Fixed the @Valid(groups={"group"}) against null exception case (vudaltsov)
 * bug #25255 [Console][DI] Fail gracefully (nicolas-grekas)
 * bug #25264 [DI] Trigger deprecation when setting a to-be-private synthetic service (nicolas-grekas)
 * bug #25258 [link] Prevent warnings when running link with 2.7 (dunglas)
 * bug #25244 [DI] Add missing deprecation when fetching private services from ContainerBuilder (nicolas-grekas)
 * bug #24750 [Validator] ExpressionValidator should use OBJECT_TO_STRING  (Simperfit)
 * bug #25247 [DI] Fix false-positive circular exception (nicolas-grekas)
 * bug #25226 [HttpKernel] Fix issue when resetting DumpDataCollector (Pierstoval)
 * bug #25230 Use a more specific file for detecting the bridge (greg0ire)
 * bug #25232 [WebProfilerBundle] [TwigBundle] Fix Profiler breaking XHTML pages (tistre)

* 3.4.0 (2017-11-30)

 * bug #25220 [HttpFoundation] Add Session::isEmpty(), fix MockFileSessionStorage to behave like the native one (nicolas-grekas)
 * bug #25209 [VarDumper] Dont use empty(), it chokes on eg GMP objects (nicolas-grekas)
 * bug #25200 [HttpKernel] Arrays with scalar values passed to ESI fragment renderer throw deprecation notice (Simperfit)
 * bug #25201 [HttpKernel] Add a better error messages when passing a private or non-tagged controller (Simperfit)
 * bug #25217 [Dotenv] Changed preg_match flags from null to 0 (deekthesqueak)
 * bug #25180 [DI] Fix circular reference when using setters (nicolas-grekas)
 * bug #25204 [DI] Clear service reference graph (nicolas-grekas)
 * bug #25203 [DI] Fix infinite loop in InlineServiceDefinitionsPass (nicolas-grekas)
 * bug #25185 [Serializer] Do not cache attributes if `attributes` in context (sroze)
 * bug #25190 [HttpKernel] Keep legacy container files for concurrent requests (nicolas-grekas)
 * bug #25182 [HttpFoundation] AutExpireFlashBag should not clear new flashes (Simperfit, sroze)
 * bug #25174 [Translation] modify definitions only if the do exist (xabbuh)
 * bug #25179 [FrameworkBundle][Serializer] Remove YamlEncoder definition if Yaml component isn't installed (ogizanagi)
 * bug #25160 [DI] Prevent a ReflectionException during cache:clear when the parent class doesn't exist (dunglas)
 * bug #25163 [DI] Fix tracking of env vars in exceptions (nicolas-grekas)
 * bug #25162 [HttpKernel] Read $_ENV when checking SHELL_VERBOSITY (nicolas-grekas)
 * bug #25158 [DI] Remove unreachable code (GawainLynch)
 * bug #25152 [Form] Don't rely on `Symfony\Component\HttpFoundation\File\File` if http-foundation isn't in FileType (issei-m)
 * bug #24987 [Console] Fix global console flag when used in chain (Simperfit)
 * bug #25137 Adding checks for the expression language (weaverryan)
 * bug #25151 [FrameworkBundle] Automatically enable the CSRF protection if CSRF manager exists (sroze)
 * bug #25043 [Yaml] added ability for substitute aliases when mapping is on single line (Michał Strzelecki, xabbuh)

* 3.4.0-RC2 (2017-11-24)

 * bug #25146 [DI] Dont resolve envs in service ids (nicolas-grekas)
 * bug #25113 [Routing] Fix "config-file-relative" annotation loader resources (nicolas-grekas, sroze)
 * bug #25065 [FrameworkBundle] Update translation commands to work with default paths (yceruto)
 * bug #25109 Make debug:container search command case-insensitive (jzawadzki)
 * bug #25121 [FrameworkBundle] Fix AssetsInstallCommand (nicolas-grekas)
 * bug #25102 [Form] Fixed ContextErrorException in FileType (chihiro-adachi)
 * bug #25130 [DI] Fix handling of inlined definitions by ContainerBuilder (nicolas-grekas)
 * bug #25119 [DI] Fix infinite loop when analyzing references (nicolas-grekas)
 * bug #25094 [FrameworkBundle][DX] Display a nice error message if an enabled component is missing (derrabus)
 * bug #25100 [SecurityBundle] providerIds is undefined error when firewall provider is not specified (karser)
 * bug #25100 [SecurityBundle] providerIds is undefined error when firewall provider is not specified (karser)
 * bug #25100 [SecurityBundle] providerIds is undefined error when firewall provider is not specified (karser)
 * bug #25097 [Bridge\PhpUnit] Turn "preserveGlobalState" to false by default, revert "Blacklist" removal (nicolas-grekas)

* 3.4.0-RC1 (2017-11-21)

 * bug #25077 [Bridge/Twig] Let getFlashes starts the session (MatTheCat)
 * bug #25082 [HttpKernel] Disable container inlining when legacy inlining has been used (nicolas-grekas)
 * bug #25072 [Bridge/PhpUnit] Remove trailing "\n" from ClockMock::microtime(false) (joky)
 * bug #25069 [Debug] Fix undefined variable $lightTrace (nicolas-grekas)
 * bug #25053 [Serializer] Fixing PropertyNormalizer supports parent properties (Christopher Hertel)
 * bug #25055 [DI] Analyze setter-circular deps more precisely (nicolas-grekas)
 * feature #25056 [Bridge/PhpUnit] Sync the bridge version installed in vendor/ and in phpunit clone (nicolas-grekas)
 * bug #25045 [SecurityBundle] Don't trigger auto-picking notice if provider is set per listener (chalasr)
 * bug #25033 [FrameworkBundle] Dont create empty bundles directory by default (ro0NL)
 * bug #25037 [DI] Skip hot_path tag for deprecated services as their class might also be (nicolas-grekas)
 * bug #25038 [Cache] Memcached options should ignore "lazy" (nicolas-grekas)
 * bug #25014 Move deprecation under use statements (greg0ire)
 * bug #25030 [Console] Fix ability to disable lazy commands (chalasr)
 * bug #25032 [Bridge\PhpUnit] Disable broken auto-require mechanism of phpunit (nicolas-grekas)
 * bug #25027 [FrameworkBundle] Hide server:log command based on deps (sroze)
 * bug #24991 [DependencyInjection] Single typed argument can be applied on multiple parameters (nicolas-grekas, sroze)
 * bug #24983 [Validator] enter the context in which to validate (xabbuh)
 * bug #24956 Fix ambiguous pattern (weltling)
 * bug #24732 [DependencyInjection] Prevent service:method factory notation in PHP config (vudaltsov)
 * bug #24979 [HttpKernel] remove services resetter even when it's an alias (xabbuh)
 * bug #24972 [HttpKernel] Fix service arg resolver for controllers as array callables (sroze, nicolas-grekas)
 * bug #24971 [FrameworkBundle] Empty event dispatcher earlier in CacheClearCommand (nicolas-grekas)
 * security #24995 Validate redirect targets using the session cookie domain (nicolas-grekas)
 * security #24994 Prevent bundle readers from breaking out of paths (xabbuh)
 * security #24993 Ensure that submitted data are uploaded files (xabbuh)
 * security #24992 Namespace generated CSRF tokens depending of the current scheme (dunglas)
 * bug #24954 [DI] Fix dumping with custom base class (nicolas-grekas)
 * bug #24952 [HttpFoundation] Fix session-related BC break (nicolas-grekas, sroze)
 * bug #24943 [FrameworkBundle] Wire the translation.reader service instead of deprecated translation.loader in commands (ogizanagi)

* 3.4.0-BETA4 (2017-11-12)

 * bug #24874 [TwigBridge] Fixed the .form-check-input class in the bs4 templates (vudaltsov)
 * bug #24929 [Console] Fix traversable autocomplete values (ro0NL)
 * feature #24860 [FrameworkBundle] Add default translations path option and convention (yceruto)
 * bug #24921 [Debug] Remove false-positive deprecation from DebugClassLoader (nicolas-grekas)
 * bug #24856 [FrameworkBundle] Add default mapping path for validator component in bundle-less app (yceruto)
 * bug #24833 [FrameworkBundle] Add default mapping path for serializer component in bundle-less app (yceruto)
 * bug #24908 [WebServerBundle] Prevent console.terminate from being fired when server:start finishes (kbond)
 * bug #24888 [FrameworkBundle] Specifically inject the debug dispatcher in the collector (ogizanagi)
 * bug #24909 [Intl] Update ICU data to 60.1 (jakzal)
 * bug #24870 [YAML] Allow to parse custom tags when linting yaml files (pierredup)
 * bug #24910 [HttpKernel][Debug] Remove noise from stack frames of deprecations (nicolas-grekas)
 * bug #24906 [Bridge/ProxyManager] Remove direct reference to value holder property (nicolas-grekas)
 * feature #24887 [Cache][Lock] Add RedisProxy for lazy Redis connections (nicolas-grekas)
 * bug #24633 [Config] Fix cannotBeEmpty() (ro0NL)
 * bug #24900 [Validator] Fix Costa Rica IBAN format (Bozhidar Hristov)
 * bug #24904 [Validator] Add Belarus IBAN format (Bozhidar Hristov)
 * bug #24837 [TwigBridge] [Bootstrap 4] Fix validation error design for expanded choiceType (ostrolucky)
 * bug #24878 [HttpFoundation] Prevent PHP from sending Last-Modified on session start (nicolas-grekas)
 * bug #24881 [WebserverBundle] fixed the bug that caused that the webserver would … (Serkan Yildiz)
 * bug #24850 [DI] Fix cannot bind env var (ogizanagi)
 * bug #24851 [TwigBridge] Fix BC break due required twig environment (ro0NL)

* 3.4.0-BETA3 (2017-11-05)

 * bug #24531 [HttpFoundation] Fix forward-compat of NativeSessionStorage with PHP 7.2 (sroze)
 * bug #24828 [DI] Fix the "almost-circular refs" fix (nicolas-grekas)
 * bug #24665 Fix dump panel hidden when closing a dump (julienfalque)
 * bug #24802 [TwigBridge] [Bootstrap 4] Fix hidden errors (ostrolucky)
 * bug #24816 [Serializer] Fix extra attributes when no group specified (ogizanagi)
 * bug #24822 [DI] Fix "almost-circular" dependencies handling (nicolas-grekas)
 * bug #24821 symfony/form auto-enables symfony/validator, even when not present (weaverryan)
 * bug #24824 [FrameworkBundle][Config] fix: do not add resource checkers for no-debug (dmaicher)
 * bug #24814 [Intl] Make intl-data tests pass and save language aliases again (jakzal)
 * bug #24810 [Serializer] readd default argument value (xabbuh)
 * bug #24809 [Config] Fix dump of config references for deprecated nodes (chalasr)
 * bug #24796 [PhpUnitBridge] Fixed fatal error in CoverageListener when something goes wrong in Test::setUpBeforeClass (lyrixx)
 * bug #24774 [HttpKernel] Let the storage manage the session starts (sroze)
 * bug #24735 [VarDumper] fix trailling comma when dumping an exception (Simperfit)
 * bug #24770 [Validator] Fix TraceableValidator is reset on data collector instantiation (ogizanagi)
 * bug #24764 [HttpFoundation] add Early Hints to Reponse to fix test (Simperfit)
 * bug #24759 Removes \n or space when $context/$extra are empty (kirkmadera)
 * bug #24758 Throwing exception if redis and predis unavailable (aequasi)

* 3.4.0-BETA2 (2017-10-30)

 * bug #24728 [Bridge\Twig] fix bootstrap checkbox_row to render properly & remove spaceless (arkste)
 * bug #24709 [HttpKernel] Move services reset to Kernel::handle()+boot() (nicolas-grekas)
 * bug #24703 [TwigBridge] Bootstrap 4 form theme fixes (vudaltsov)
 * bug #24744 debug:container --types: Fix bug with non-existent classes (weaverryan)
 * bug #24747 [VarDumper] HtmlDumper: fix collapsing nodes with depth < maxDepth (ogizanagi)
 * bug #24743 [FrameworkBundle] Do not activate the cache if Doctrine's cache is not present (sroze)
 * bug #24605 [FrameworkBundle] Do not load property_access.xml if the component isn't installed (ogizanagi)
 * bug #24710 [TwigBridge] Fix template paths in profiler (ro0NL)
 * bug #24706 [DependencyInjection] Add the possibility to disable assets via xml (renatomefi)
 * bug #24696 Ensure DeprecationErrorHandler::collectDeprecations() is triggered (alexpott)
 * bug #24711 [TwigBridge] Re-add Bootstrap 3 Checkbox Layout (arkste)
 * bug #24713 [FrameworkBundle] fix CachePoolPrunerPass to use correct command service id (kbond)
 * bug #24686 Fix $_ENV/$_SERVER precedence in test framework (fabpot)
 * bug #24691 [HttpFoundation] Fix caching of session-enabled pages (nicolas-grekas)
 * bug #24606 [HttpFoundation] Fix FileBag issue with associative arrays (enumag)
 * bug #24673 [DI] Throw when a service name or an alias contains dynamic values (prevent an infinite loop) (dunglas)
 * bug #24684 [Security] remove invalid deprecation notice on AbstractGuardAuthenticator::supports() (kbond)
 * bug #24681 Fix isolated error handling (alexpott)
 * bug #24575 Ensure that PHPUnit's error handler is still working in isolated tests (alexpott)
 * bug #24597 [PhpUnitBridge] fix deprecation triggering test detection (xabbuh)
 * feature #24671 [DI] Handle container.autowiring.strict_mode to opt-out from legacy autowiring (nicolas-grekas)
 * bug #24660 Escape trailing \ in QuestionHelper autocompletion (kamazee)
 * bug #24624 [Security] Fix missing BC layer for AbstractGuardAuthenticator::getCredentials() (chalasr)
 * bug #24598 Prefer line formatter on missing cli dumper (greg0ire)
 * bug #24635 [DI] Register default env var provided types (ro0NL)
 * bug #24620 [FrameworkBundle][Workflow] Fix deprectation when checking workflow.registry service in dump command (Jean-Beru)
 * bug #24644 [Security] Fixed auth provider authenticate() cannot return void (glye)
 * bug #24642 [Routing] Fix resource miss (dunglas)
 * bug #24608 Adding the Form default theme files to be warmed up in Twig's cache (weaverryan)
 * bug #24626 streamed response should return $this (DQNEO)
 * bug #24630 [WebServerBundle] Prevent commands from being registered by convention (chalasr)
 * bug #24589 Username and password in basic auth are allowed to contain '.' (Richard Quadling)
 * bug #24566 Fixed unsetting from loosely equal keys OrderedHashMap (maryo)
 * bug #24570 [Debug] Fix same vendor detection in class loader (Jean-Beru)
 * bug #24573  Fixed pathinfo calculation for requests starting with a question mark. (syzygymsu)
 * bug #24565 [Serializer] YamlEncoder: throw if the Yaml component isn't installed (dunglas)
 * bug #24563 [Serializer] ObjectNormalizer: throw if PropertyAccess isn't installed (dunglas)
 * bug #24571 [PropertyInfo] Add support for the iterable type (dunglas)
 * bug #24579 pdo session fix (mxp100)
 * bug #24536 [Security] Reject remember-me token if UserCheckerInterface::checkPostAuth() fails (kbond)

* 3.4.0-BETA1 (2017-10-18)

 * feature #24583 Adding a new debug:autowiring command (weaverryan)
 * feature #24523 [HttpFoundation] Make sessions secure and lazy (nicolas-grekas)
 * feature #22610 [Form] [TwigBridge] Added option to disable usage of default themes when rendering a form (emodric)
 * feature #23112 [OptionsResolver] Support array of types in allowed type (pierredup)
 * feature #24321 added ability to handle parent classes for PropertyNormalizer (ivoba)
 * feature #24505 [HttpKernel] implement reset() in DumpDataCollector (xabbuh)
 * feature #24425 [Console][HttpKernel] Handle new SHELL_VERBOSITY env var, also configures the default logger (nicolas-grekas)
 * feature #24387 [FORM] Prevent forms from extending itself as a parent (pierredup)
 * feature #24484 [DI] Throw accurate failures when accessing removed services (nicolas-grekas)
 * feature #24208 [Form] Display option definition from a given form type (yceruto, ogizanagi)
 * feature #23499 [Workflow] add guard is_valid() method support (alain-flaus, lyrixx)
 * feature #24388 [Security] Look at headers for switch_user username (chalasr)
 * feature #23708 Added deprecation to cwd not existing Fixes #18249 (alexbowers)
 * feature #24443 [Session] deprecate MemcacheSessionHandler (Tobion)
 * feature #24409 [Bridge\Doctrine][FrameworkBundle] Deprecate some remaining uses of ContainerAwareTrait (nicolas-grekas)
 * feature #24438 [Session][VarDumper] Deprecate accepting legacy mongo extension (Tobion)
 * feature #24389 [DoctrineBridge] Deprecate dbal session handler (Tobion)
 * feature #16835 [Security] Add Guard authenticator <supports> method (Amo, chalasr)
 * feature #24289 [FrameworkBundle][HttpKernel] Reset profiler (derrabus)
 * feature #24144 [FrameworkBundle] Expose dotenv in bin/console about (ro0NL)
 * feature #24403 [FrameworkBundle][Routing] Show welcome message if no routes are configured (yceruto)
 * feature #22679 [Form] Add tel and color types (apetitpa)
 * feature #23845 [Validator] Add unique entity violation cause (Ilya Vertakov)
 * feature #22132 [Lock] Automaticaly release lock when user forget it (jderusse)
 * feature #21751 Bootstrap4 support for Twig form theme (hiddewie, javiereguiluz)
 * feature #24383 [FrameworkBundle] Don't clear app pools on cache:clear (nicolas-grekas)
 * feature #24148 [Form] Hide label button when its setted to false (TeLiXj)
 * feature #24378 [SecurityBundle] Deprecate auto picking the first provider (ogizanagi)
 * feature #24260 [Security] Add impersonation support for stateless authentication (chalasr)
 * feature #24300 [HttpKernel][FrameworkBundle] Add a minimalist default PSR-3 logger (dunglas)
 * feature #21604 [Security] Argon2i Password Encoder (zanbaldwin)
 * feature #24372 [DowCrawler] Default to UTF-8 when possible (nicolas-grekas)
 * feature #24264 [TwigBundle] Improve the overriding of bundle templates (yceruto)
 * feature #24197 [Translation] 	Moved PhpExtractor and PhpStringTokenParser to Translation component (Nyholm)
 * feature #24362 [HttpKernel] Deprecate some compiler passes in favor of tagged iterator args (nicolas-grekas)
 * feature #21027 [Asset] Provide default context (ro0NL)
 * feature #22200 [DI] Reference tagged services in config (ro0NL)
 * feature #24337 Adding a shortcuts for the main security functionality (weaverryan, javiereguiluz)
 * feature #24358 [TwigBundle] register an identity translator as fallback (xabbuh)
 * feature #24357 [Yaml] include file and line no in deprecation message (xabbuh)
 * feature #24330 [FrameworkBundle] register class metadata factory alias (xabbuh)
 * feature #24349 [SecurityBundle] Add missing AclSchemaListener deprecation (ogizanagi)
 * feature #24202 [Filesystem] deprecate relative paths in makePathRelative() (xabbuh)
 * feature #21716 [Serializer] Add Support for `object_to_populate` in CustomNormalizer (chrisguitarguy)
 * feature #21960 Remove Validator\TypeTestCase and add validator logic to base TypeTestCase (pierredup)
 * feature #22113 [Lock] Include lock component in framework bundle (jderusse)
 * feature #24236 [WebProfilerBundle] Render file links for twig templates (ro0NL)
 * feature #21239 [Serializer] throw more specific exceptions (xabbuh)
 * feature #24256 CsvEncoder handling variable structures and custom header order (Oliver Hoff)
 * feature #23471 [Finder] Add a method to check if any results were found (duncan3dc)
 * feature #23149 [PhpUnitBridge] Added a CoverageListener to enhance the code coverage report (lyrixx)
 * feature #24318 [SecurityBundle] Deprecate ACL related code (chalasr)
 * feature #24335 [Security][SecurityBundle] Deprecate the HTTP digest auth (ogizanagi)
 * feature #21951 [Security][Firewall] Passing the newly generated security token to the event during user switching (klandaika)
 * feature #23485 [Config] extracted the xml parsing from XmlUtils::loadFile into XmlUtils::parse (Basster)
 * feature #22890 [HttpKernel] Add ability to configure catching exceptions for Client (kbond)
 * feature #24239 [HttpFoundation] Deprecate compatibility with PHP <5.4 sessions (afurculita)
 * feature #23882 [Security] Deprecated not being logged out after user change (iltar)
 * feature #24200 Added an alias for FlashBagInterface in config (tifabien)
 * feature #24295 [DI][DX] Throw exception on some ContainerBuilder methods used from extensions (ogizanagi)
 * feature #24253 [Yaml] support parsing files (xabbuh)
 * feature #24290 Adding Definition::addError() and a compiler pass to throw errors as exceptions (weaverryan)
 * feature #24301 [DI] Add AutowireRequiredMethodsPass to fix bindings for `@required` methods (nicolas-grekas)
 * feature #24226 [Cache] Add ResettableInterface to allow resetting any pool's local state (nicolas-grekas)
 * feature #24303 [FrameworkBundle] allow forms without translations and validator (xabbuh)
 * feature #24291 [SecurityBundle] Reset the authentication token between requests (derrabus)
 * feature #24280 [VarDumper] Make `dump()` a little bit more easier to use (freekmurze)
 * feature #24277 [Serializer] Getter for extra attributes in ExtraAttributesException (mdeboer)
 * feature #24257 [HttpKernel][DI] Enable Kernel to implement CompilerPassInterface (nicolas-grekas)
 * feature #23834 [DI] Add "PHP fluent format" for configuring the container (nicolas-grekas)
 * feature #24180 [Routing] Add PHP fluent DSL for configuring routes (nicolas-grekas)
 * feature #24232 [Bridge\Doctrine] Add "DoctrineType::reset()" method (nicolas-grekas)
 * feature #24238 [DI] Turn services and aliases private by default, with BC layer (nicolas-grekas)
 * feature #23648 [Form] Add input  + regions options to TimezoneType (ro0NL)
 * feature #24185 [Form] Display general forms information on debug:form (yceruto)
 * feature #23747 [Serializer][FrameworkBundle] Add a DateInterval normalizer (Lctrs)
 * feature #24193 [FrameworkBundle] Reset stopwatch between requests (derrabus)
 * feature #24160 [HttpKernel] Deprecate bundle inheritance (fabpot)
 * feature #24155 [FrameworkBundle][HttpKernel] Add DI tag for resettable services (derrabus)
 * feature #23625 Feature #23583  Add current and fallback locales in WDT / Profiler (nemoneph)
 * feature #24179 [TwigBundle] Add default templates directory and option to configure it (yceruto)
 * feature #24104 Make as many services private as possible (nicolas-grekas)
 * feature #18314 [Translation] added support for adding custom message formatter (aitboudad)
 * feature #24158 deprecated profiler.matcher configuration (fabpot)
 * feature #24131 [Console] Do not display short exception trace for common console exceptions (yceruto)
 * feature #24080 Deprecated the web_profiler.position option (javiereguiluz)
 * feature #24114 [SecurityBundle] Throw a meaningful exception when an undefined user provider is used inside a firewall (chalasr)
 * feature #24122 [DI] rename ResolveDefinitionTemplatesPass to ResolveChildDefinitionsPass (nicolas-grekas)
 * feature #23901 [DI] Allow processing env vars (nicolas-grekas)
 * feature #24093 [FrameworkBundle] be able to enable workflow support explicitly (xabbuh)
 * feature #24064 [TwigBridge] Show Twig's loader paths on debug:twig command (yceruto)
 * feature #23978 [Cache] Use options from Memcached DSN (Bukashk0zzz)
 * feature #24075 Implemented PruneableInterface on TagAwareAdapter (Toflar)
 * feature #21414 [Console] Display file and line on Exception (arno14)
 * feature #24068 [HttpKernel] Deprecate EnvParametersResource (ro0NL)
 * feature #22542 [Lock] Check TTL expiration in lock acquisition (jderusse)
 * feature #24031 [Routing] Add the possibility to define a prefix for all routes of a controller (fabpot)
 * feature #23967 [VarDumper] add force-collapse/expand + use it for traces (nicolas-grekas)
 * feature #24033 [DI] Add ContainerInterface::IGNORE_ON_UNINITIALIZED_REFERENCE (nicolas-grekas)
 * feature #24026 [Security] add impersonator_user to "User was reloaded" log message (gharlan)
 * feature #23603 [Cache] Add (pdo|chain) cache (adapter|simple) prune method (robfrawley)
 * feature #23694 [Form] Add debug:form command (yceruto)
 * feature #24028 [Yaml] mark some classes as final (xabbuh)
 * feature #22543 [Lock] Expose an expiringDate and isExpired method in Lock (jderusse)
 * feature #23667 [Translation] Create an TranslationReaderInterface and move TranslationLoader to TranslationComponent (Nyholm)
 * feature #24024 [config] Add ability to deprecate a node (sanpii)
 * feature #23668 [VarDumper] Add period caster (maidmaid)
 * feature #23991 [DI] Improve psr4-based service discovery (alternative implementation) (kbond)
 * feature #23947 [Translation] Adding the ability do load <notes> in xliff2.0 (Nyholm)
 * feature #23887 [Console] Allow commands to provide a default name for compile time registration (chalasr, nicolas-grekas)
 * feature #23874 [DI] Case sensitive parameter names (ro0NL)
 * feature #23936 Remove some sf2 references (fabpot)
 * feature #23680 [Webprofiler] Added blocks that allows extension of the profiler page. (Nyholm)
 * feature #23665 Create an interface for TranslationWriter (Nyholm)
 * feature #23890 [Translation] Adding the ability do dump <notes> in xliff2.0 (Nyholm)
 * feature #23862 [SecurityBundle] resolve class name parameter inside AddSecurityVotersPass (pjarmalavicius)
 * feature #23915 [DI] Allow get available services from service locator (Koc)
 * feature #23792 [HttpKernel][FrameworkBundle] Add RebootableInterface, fix and un-deprecate cache:clear with warmup (nicolas-grekas)
 * feature #23227 Add support for "controller" keyword for configuring routes controllers (voronkovich)
 * feature #23869 [Console] Made console command shortcuts case insensitive (thanosp)
 * feature #23855 [DI] Allow dumping inline services in Yaml (nicolas-grekas)
 * feature #23836 [FrameworkBundle] Catch Fatal errors in commands registration (chalasr)
 * feature #23805 [HttpKernel] Deprecated commands auto-registration (GuilhemN)
 * feature #23816 [Debug] Detect internal and deprecated methods (GuilhemN)
 * feature #23812 [FrameworkBundle] Allow micro kernel to subscribe events easily (ogizanagi)
 * feature #22187 [DependencyInjection] Support local binding (GuilhemN)
 * feature #23741 [DI] Generate one file per service factory (nicolas-grekas)
 * feature #23807 [Debug] Trigger a deprecation when using an internal class/trait/interface (GuilhemN)
 * feature #22587 [Workflow] Add transition completed event (izzyp)
 * feature #23624 [FrameworkBundle] Commands as a service (ro0NL)
 * feature #21111 [Validator] add groups support to the Valid constraint (xabbuh)
 * feature #20361 [Config] Enable cannotBeEmpty along with requiresAtLeastOneElement (ro0NL)
 * feature #23712 [DependencyInjection] Deprecate autowiring service auto-registration (GuilhemN)
 * feature #23719 Autoconfigure instances of ArgumentValueResolverInterface (BPScott)
 * feature #23706 [Webprofiler] Improve sql explain table display (mimol91)
 * feature #23724 [Lock] Deprecate Filesystem/LockHandler (jderusse)
 * feature #23593 [Workflow] Adding workflow name to the announce event (Nyholm)
 * feature #20496 [Form] Allow pass filter callback to delete_empty option. (Koc)
 * feature #23451 [Cache] Add (filesystem|phpfiles) cache (adapter|simple) prune method and prune command (robfrawley)
 * feature #23519 [TwigBundle] Commands as a service (ro0NL)
 * feature #23591 [VarDumper] Add time zone caster (maidmaid)
 * feature #23510 [Console] Add a factory command loader for standalone application with lazy-loading needs (ogizanagi)
 * feature #23357 [VarDumper] Add interval caster (maidmaid)
 * feature #23550 [DebugBundle] Added min_depth to Configuration (james-johnston-thumbtack)
 * feature #23570 [FrameworkBundle] Make RouterCacheWarmer implement ServiceSubscriberInterface (nicolas-grekas)
 * feature #23437 [TwigBridge] deprecate TwigRenderer (Tobion)
 * feature #23515 [VarDumper] Added setMinDepth to VarCloner (james-johnston-thumbtack)
 * feature #23404 [Serializer] AbstractObjectNormalizer: Allow to disable type enforcement (ogizanagi)
 * feature #21086 [MonologBridge] Add TokenProcessor (maidmaid)
 * feature #22576 [Validator] Allow to use a property path to get value to compare in comparison constraints (ogizanagi)
 * feature #22689 [DoctrineBridge] Add support for doctrin/dbal v2.6 types (jvasseur)
 * feature #22734 [Console] Add support for command lazy-loading (chalasr)
 * feature #19034 [Security] make it possible to configure a custom access decision manager service (xabbuh)
 * feature #23037 [TwigBundle] Added a RuntimeExtensionInterface to take advantage of autoconfigure (lyrixx)
 * feature #22176 [DI] Allow imports in string format for YAML (ro0NL)
 * feature #23295 [Security] Lazy load user providers (chalasr)
 * feature #23440 [Routing] Add matched and default parameters to redirect responses (artursvonda, Tobion)
 * feature #22832 [Debug] Deprecate support for stacked errors (mbabker)
 * feature #21469 [HttpFoundation] Find the original request protocol version (thewilkybarkid)
 * feature #23431 [Validator] Add min/max amount of pixels to Image constraint (akeeman)
 * feature #23223 Add support for microseconds in Stopwatch (javiereguiluz)
 * feature #22341 [BrowserKit] Emulate back/forward browser navigation (e-moe)
 * feature #22619 [FrameworkBundle][Translation] Move translation compiler pass (lepiaf)
 * feature #22620 [FrameworkBundle][HttpKernel] Move httpkernel pass (lepiaf)
 * feature #23337 [Component][Serializer][Normalizer] : Deal it with Has Method for the Normalizer/Denormalizer (jordscream)
 * feature #22588 [VarDumper] Add filter in VarDumperTestTrait (maidmaid)
 * feature #23288 [Yaml] deprecate the !str tag (xabbuh)
 * feature #23039 [Validator] Support for parsing PHP constants in yaml loader (mimol91)
 * feature #22431 [VarDumper] Add date caster (maidmaid)
 * feature #23285 [Stopwatch] Add a reset method (jmgq)
 * feature #23320 [WebServer] Allow * to bind all interfaces (as INADDR_ANY) (jpauli, fabpot)
 * feature #23272 [FrameworkBundle] disable unusable fragment renderers (xabbuh)
 * feature #23332 [Yaml] fix the displayed line number (fabpot, xabbuh)
 * feature #23026 [SecurityBundle] Add user impersonation info and exit action to the profiler (yceruto)
 * feature #22932 [HttpFoundation] Adds support for the immutable directive in the cache-control header (twoleds)
 * feature #22554 [Profiler][Validator] Add a validator panel in profiler (ogizanagi)
 * feature #22124 Shift responsibility for keeping Date header to ResponseHeaderBag (mpdude)
 * feature #23122 Xml encoder optional type cast (ragboyjr)
 * feature #23207 [FrameworkBundle] Allow .yaml file extension everywhere (ogizanagi)
 * feature #23076 [Validator] Adds support to check specific DNS record type for URL (iisisrael)
 * feature #22629 [Security] Trigger a deprecation when a voter is missing the VoterInterface (iltar)
 * feature #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * feature #22909 [Yaml] Deprecate using the non-specific tag (GuilhemN)
 * feature #23042 Consistent error handling in remember me services (lstrojny)
 * feature #22444 [Serializer] DateTimeNormalizer: allow to provide timezone (ogizanagi)
 * feature #23143 [DI] Reference instead of inline for array-params (nicolas-grekas)
 * feature #23154 [WebProfilerBundle] Sticky ajax window (ro0NL)
 * feature #23161 [FrameworkBundle] Deprecate useless --no-prefix option (chalasr)
 * feature #23105 [SecurityBundle][Profiler] Give info about called security listeners in profiler (chalasr)
 * feature #23148 [FrameworkBundle] drop hard dependency on the Stopwatch component (xabbuh)
 * feature #23131 [FrameworkBundle] Remove dependency on Doctrine cache (fabpot)
 * feature #23114 [SecurityBundle] Lazy load security listeners (chalasr)
 * feature #23111 [Process] Deprecate ProcessBuilder (nicolas-grekas)
 * feature #22675 [FrameworkBundle] KernelTestCase: deprecate not using KERNEL_CLASS (ogizanagi)
 * feature #22917 [VarDumper] Cycle prev/next searching in HTML dumps (ro0NL)
 * feature #23044 Automatically enable the routing annotation loader (GuilhemN)
 * feature #22696 [PropertyInfo] Made ReflectionExtractor's prefix lists instance variables (neemzy)
 * feature #23035  Deprecate passing a concrete service in optional cache warmers (romainneutron)
 * feature #23036  Implement ServiceSubscriberInterface in optional cache warmers (romainneutron)
 * feature #23022 [Di] Remove closure-proxy arguments (nicolas-grekas)
 * feature #22903 [DI] Deprecate XML services without ID (ro0NL)
 * feature #22597 [Lock] Re-add the Lock component in 3.4 (jderusse)
 * feature #22803 [DI] Deprecate Container::initialized() for privates (ro0NL)
 * feature #22828 [Finder] Deprecate FilterIterator (ogizanagi)
 * feature #22826 [Validator] improve strict option value deprecation (xabbuh)

