<?php
// Make sure we use installed autoload.php files
set_include_path('/usr/share/php' . PATH_SEPARATOR . get_include_path());
// ----
// Make sure we use the autoload.php files generated by phpab
// What needs to be autoloaded for test can be found in  the main
// composer.json under 'autoload:'
require_once "Symfony/Bridge/Doctrine/autoload.php";
require_once "Symfony/Bridge/Monolog/autoload.php";
require_once "Symfony/Bridge/ProxyManager/autoload.php";
require_once "Symfony/Bridge/Twig/autoload.php";
foreach (glob("Symfony/{Bundle,Component}/*/autoload.php", GLOB_BRACE) as $autoload_file) {
    require_once "$autoload_file";
}
// ----
// Make sure the Symfony Class Loader is in place, since some tests need it
require_once 'Symfony/Component/ClassLoader/ClassLoader.php';
use Symfony\Component\ClassLoader\ClassLoader;
$loader = new ClassLoader();
$loader->setUseIncludePath(true);
$loader->addPrefix('Symfony', '/usr/share/php');
$loader->addPrefix('Symfony', './');
$loader->register();
// ----
// Make sure Doctrine's AnnotationRegistry is in place, since tests need it
use Doctrine\Common\Annotations\AnnotationRegistry;
AnnotationRegistry::registerLoader(array($loader, 'loadClass'));
// ----
