
from dolfin import *

parameters["form_compiler"]["name"]= "sfc"

class Source(Expression): 
    def eval(self, values, x): 
        values[0] = -1.0+((0.5)*x[0]+(0.5)*x[1])**6

class Solution(Expression): 
    def eval(self, values, x): 
        values[0] = (0.5*(x[0] + x[1]))**2     

class DirichletBoundary(SubDomain): 
    def inside(self, x, on_boundary): 
        return bool(on_boundary)

# Geometry
N = 80  
P = 4 
mesh = UnitSquare(N, N)

# Function spaces
X = FunctionSpace(mesh, 'CG', 1)

# Unknown function
U = Function(X)

# Basis functions 
v = TestFunction(X)
u = TrialFunction(X)

# Source term 
source = Source(element=X.ufl_element())

# Forms
L = inner(grad(U),grad(U))*dx + U**P*dx + source*U*dx 
F = derivative(L, U, v)

# Analytical solution 
solution = Solution(element=X.ufl_element())
sol = project(solution, X)

# Solve nonlinear variational problem
dirichlet_boundary = DirichletBoundary()
bc = DirichletBC(X, solution, dirichlet_boundary)

solve(F==0, U, bc)

# Write solution to file
file = File("u.pvd") 
file << U 

file = File("u0.pvd") 
file << sol 

# Plot and wait
plot(sol)
plot(U)
interactive()
