#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

void example_of_use(FE& fe) { 
    ex Ni; 
    ex gradNi; 
    ex dofi; 
    for (int i=0; i< fe.nbf() ; i++) { 
        Ni = fe.N(i); 
        gradNi = grad(Ni); 
        dofi = fe.dof(i); 
        cout <<"The basis function, N("<<i<<")="<<Ni<<endl; 
        cout <<"The gradient of N("<<i<<")="<<gradNi<<endl; 
        cout <<"The corresponding dof, L("<<i<<")="<<dofi<<endl; 
    }
}



int main(){ 
   
    initSyFi(2); 

    int order = 1; 
    Triangle triangle(lst(0,0), lst(1,0), lst(0,1));   
    Lagrange fe; 
    fe.set_order(order); 
    fe.set_polygon(triangle); 
    fe.compute_basis_functions(); 

    example_of_use(fe); 

    // regression test

    archive ar; 
    for (int i=0; i< fe.nbf(); i++) {
	    ar.archive_ex(fe.N(i) , istr("N",i).c_str()); 
	    ar.archive_ex(fe.dof(i) , istr("D",i).c_str()); 
    }

    ofstream vfile("fe_ex1.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("fe_ex1.gar.v", "fe_ex1.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 
}


