// Copyright (C) 2009-2009 Martin Sandve Alnæs
// Licensed under the GNU LGPL Version 3.0.
//
// First added:  2009-01-01
// Last changed: 2009-04-01
//
// This demo program computes a projection of a tensor finite element space.

#include <dolfin.h>
#include "generated_code/ProjectionTensor.h"

using namespace dolfin;
using namespace ProjectionTensor;

class Weight: public Expression 
{
public:
  void eval(Array<double>& values, const Array<double>& x) const
  {
    values[0] = 1.0;
  }
};

class Source: public Expression 
{
public:
  Source (): Expression(2,2) {}
  void eval(Array<double>& values, const Array<double>& x) const
  {
    double dx = x[0] - 0.5;
    double dy = x[1] - 0.5;
  //values[0] = cos(2*DOLFIN_PI*dx*dx);
  //values[1] = cos(2*DOLFIN_PI*dx*dy);
  //values[2] = cos(2*DOLFIN_PI*dy*dx);
  //values[3] = cos(2*DOLFIN_PI*dy*dy);
    values[0] = x[0] + x[1];
    values[1] = x[0] + x[1];
    values[2] = x[0] + x[1];
    values[3] = x[0] + x[1];
  }
};

int main(int argc, char ** argv)
{
  UnitSquare mesh(10, 10);

  BilinearForm::TrialSpace V(mesh);
  CoefficientSpace_c C(mesh);
  CoefficientSpace_f F(mesh);

  Weight c;
  Source f;
  Function u(V);

  BilinearForm a(V, V);
  LinearForm L(V);

  a.c = c;
  L.f = f;

  VariationalProblem problem(a, L);
  problem.solve(u);


 
  // Interpolate f onto the discrete space V
  Source f2;
  Function fi(V);
  fi = f2; 
  
  File u_file("u.pvd");
  u_file << u;
  File f_file("f.pvd");
  f_file << fi;
  
  //plot(u);
  
  return 0;
}

