// Copyright (C) 2009-2009 Martin Sandve Alnæs
// Licensed under the GNU LGPL Version 3.0.
//
// First added:  2009-01-01
// Last changed: 2009-04-01
//
// This demo program computes a projection of a function
// between two scalar finite element spaces.

#include <dolfin.h>
#include "generated_code/Projection.h"

using namespace dolfin;
using namespace Projection;

class Weight: public Expression 
{
public:
  void eval(Array<double>& values, const Array<double>& x) const
  {
    values[0] = 1.0;
  }
};

class Source: public Expression 
{
public:
  void eval(Array<double>& values, const Array<double>& x) const
  {
    double dx = x[0] - 0.5;
    double dy = x[1] - 0.5;
    //values[0] = 500.0*exp(-(dx*dx + dy*dy)/0.02);
    values[0] = x[0] + x[1];
  }
};

int main(int argc, char ** argv)
{
  // Geometry
  UnitSquare mesh(10, 10);

  // Function spaces
  BilinearForm::TrialSpace V(mesh);
  CoefficientSpace_c C(mesh);
  CoefficientSpace_f F(mesh);

  // Functions
  Weight c;
  Source f;
  Function u(V);

  // Forms
  BilinearForm a(V, V);
  LinearForm L(V);

  // Form coefficients
  a.c = c;
  L.f = f;


  VariationalProblem problem(a, L);
  problem.solve(u);

  // Interpolate f onto the discrete space V
  Source f2;
  Function fi(V);
  fi = f2; 

  // Write u and f to file
  File u_file("u.pvd");
  u_file << u;
  File f_file("f.pvd");
  f_file << fi;
  
  //plot(u);
  
  return 0;
}

