/* Swfdec
 * Copyright (C) 2007 Pekka Lampila <pekka.lampila@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "swfdec_as_internal.h"
#include "swfdec_debug.h"

SWFDEC_AS_NATIVE (13, 0, swfdec_system_ime_getEnabled)
void
swfdec_system_ime_getEnabled (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("System.IME.getEnabled (static)");
}

SWFDEC_AS_NATIVE (13, 1, swfdec_system_ime_setEnabled)
void
swfdec_system_ime_setEnabled (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("System.IME.setEnabled (static)");
}

SWFDEC_AS_NATIVE (13, 2, swfdec_system_ime_getCovnersionMode)
void
swfdec_system_ime_getCovnersionMode (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("System.IME.getCovnersionMode (static)");
}

SWFDEC_AS_NATIVE (13, 3, swfdec_system_ime_setConversionMode)
void
swfdec_system_ime_setConversionMode (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("System.IME.setConversionMode (static)");
}

SWFDEC_AS_NATIVE (13, 4, swfdec_system_ime_setCompositionString)
void
swfdec_system_ime_setCompositionString (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("System.IME.setCompositionString (static)");
}

SWFDEC_AS_NATIVE (13, 5, swfdec_system_ime_doConversion)
void
swfdec_system_ime_doConversion (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("System.IME.doConversion (static)");
}
