/* Swfdec
 * Copyright (C) 2007 Pekka Lampila <pekka.lampila@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "swfdec_as_internal.h"
#include "swfdec_debug.h"

SWFDEC_AS_NATIVE (1108, 1, swfdec_gradient_filter_get_distance)
void
swfdec_gradient_filter_get_distance (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter/GradientGlowFilter.distance (get)");
}

SWFDEC_AS_NATIVE (1108, 2, swfdec_gradient_filter_set_distance)
void
swfdec_gradient_filter_set_distance (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter/GradientGlowFilter.distance (set)");
}

SWFDEC_AS_NATIVE (1108, 3, swfdec_gradient_filter_get_angle)
void
swfdec_gradient_filter_get_angle (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.angle (get)");
}

SWFDEC_AS_NATIVE (1108, 4, swfdec_gradient_filter_set_angle)
void
swfdec_gradient_filter_set_angle (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.angle (set)");
}

SWFDEC_AS_NATIVE (1108, 5, swfdec_gradient_filter_get_colors)
void
swfdec_gradient_filter_get_colors (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.colors (get)");
}

SWFDEC_AS_NATIVE (1108, 6, swfdec_gradient_filter_set_colors)
void
swfdec_gradient_filter_set_colors (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.colors (set)");
}

SWFDEC_AS_NATIVE (1108, 7, swfdec_gradient_filter_get_alphas)
void
swfdec_gradient_filter_get_alphas (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.alphas (get)");
}

SWFDEC_AS_NATIVE (1108, 8, swfdec_gradient_filter_set_alphas)
void
swfdec_gradient_filter_set_alphas (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.alphas (set)");
}

SWFDEC_AS_NATIVE (1108, 9, swfdec_gradient_filter_get_ratios)
void
swfdec_gradient_filter_get_ratios (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.ratios (get)");
}

SWFDEC_AS_NATIVE (1108, 10, swfdec_gradient_filter_set_ratios)
void
swfdec_gradient_filter_set_ratios (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.ratios (set)");
}

SWFDEC_AS_NATIVE (1108, 11, swfdec_gradient_filter_get_blurX)
void
swfdec_gradient_filter_get_blurX (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.blurX (get)");
}

SWFDEC_AS_NATIVE (1108, 12, swfdec_gradient_filter_set_blurX)
void
swfdec_gradient_filter_set_blurX (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.blurX (set)");
}

SWFDEC_AS_NATIVE (1108, 13, swfdec_gradient_filter_get_blurY)
void
swfdec_gradient_filter_get_blurY (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.blurY (get)");
}

SWFDEC_AS_NATIVE (1108, 14, swfdec_gradient_filter_set_blurY)
void
swfdec_gradient_filter_set_blurY (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.blurY (set)");
}

SWFDEC_AS_NATIVE (1108, 15, swfdec_gradient_filter_get_quality)
void
swfdec_gradient_filter_get_quality (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.quality (get)");
}

SWFDEC_AS_NATIVE (1108, 16, swfdec_gradient_filter_set_quality)
void
swfdec_gradient_filter_set_quality (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.quality (set)");
}

SWFDEC_AS_NATIVE (1108, 17, swfdec_gradient_filter_get_strength)
void
swfdec_gradient_filter_get_strength (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.strength (get)");
}

SWFDEC_AS_NATIVE (1108, 18, swfdec_gradient_filter_set_strength)
void
swfdec_gradient_filter_set_strength (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.strength (set)");
}

SWFDEC_AS_NATIVE (1108, 19, swfdec_gradient_filter_get_knockout)
void
swfdec_gradient_filter_get_knockout (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.knockout (get)");
}

SWFDEC_AS_NATIVE (1108, 20, swfdec_gradient_filter_set_knockout)
void
swfdec_gradient_filter_set_knockout (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.knockout (set)");
}

SWFDEC_AS_NATIVE (1108, 21, swfdec_gradient_filter_get_type)
void
swfdec_gradient_filter_get_type (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.type (get)");
}

SWFDEC_AS_NATIVE (1108, 22, swfdec_gradient_filter_set_type)
void
swfdec_gradient_filter_set_type (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter/GradientGlowFilter.type (set)");
}

// constructors

SWFDEC_AS_NATIVE (1108, 0, swfdec_gradient_glow_filter_construct)
void
swfdec_gradient_glow_filter_construct (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientGlowFilter");
}

SWFDEC_AS_NATIVE (1108, 1000, swfdec_gradient_bevel_filter_construct)
void
swfdec_gradient_bevel_filter_construct (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("GradientBevelFilter");
}
