/* Swfdec
 * Copyright (C) 2007 Pekka Lampila <pekka.lampila@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "swfdec_as_internal.h"
#include "swfdec_debug.h"

SWFDEC_AS_NATIVE (1107, 1, swfdec_bevel_filter_get_distance)
void
swfdec_bevel_filter_get_distance (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.distance (get)");
}

SWFDEC_AS_NATIVE (1107, 2, swfdec_bevel_filter_set_distance)
void
swfdec_bevel_filter_set_distance (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.distance (set)");
}

SWFDEC_AS_NATIVE (1107, 3, swfdec_bevel_filter_get_angle)
void
swfdec_bevel_filter_get_angle (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.angle (get)");
}

SWFDEC_AS_NATIVE (1107, 4, swfdec_bevel_filter_set_angle)
void
swfdec_bevel_filter_set_angle (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.angle (set)");
}

SWFDEC_AS_NATIVE (1107, 5, swfdec_bevel_filter_get_highlightColor)
void
swfdec_bevel_filter_get_highlightColor (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.highlightColor (get)");
}

SWFDEC_AS_NATIVE (1107, 6, swfdec_bevel_filter_set_highlightColor)
void
swfdec_bevel_filter_set_highlightColor (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.highlightColor (set)");
}

SWFDEC_AS_NATIVE (1107, 7, swfdec_bevel_filter_get_highlightAlpha)
void
swfdec_bevel_filter_get_highlightAlpha (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.highlightAlpha (get)");
}

SWFDEC_AS_NATIVE (1107, 8, swfdec_bevel_filter_set_highlightAlpha)
void
swfdec_bevel_filter_set_highlightAlpha (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.highlightAlpha (set)");
}

SWFDEC_AS_NATIVE (1107, 9, swfdec_bevel_filter_get_shadowColor)
void
swfdec_bevel_filter_get_shadowColor (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.shadowColor (get)");
}

SWFDEC_AS_NATIVE (1107, 10, swfdec_bevel_filter_set_shadowColor)
void
swfdec_bevel_filter_set_shadowColor (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.shadowColor (set)");
}

SWFDEC_AS_NATIVE (1107, 11, swfdec_bevel_filter_get_shadowAlpha)
void
swfdec_bevel_filter_get_shadowAlpha (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.shadowAlpha (get)");
}

SWFDEC_AS_NATIVE (1107, 12, swfdec_bevel_filter_set_shadowAlpha)
void
swfdec_bevel_filter_set_shadowAlpha (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.shadowAlpha (set)");
}

SWFDEC_AS_NATIVE (1107, 13, swfdec_bevel_filter_get_quality)
void
swfdec_bevel_filter_get_quality (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.quality (get)");
}

SWFDEC_AS_NATIVE (1107, 14, swfdec_bevel_filter_set_quality)
void
swfdec_bevel_filter_set_quality (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.quality (set)");
}

SWFDEC_AS_NATIVE (1107, 15, swfdec_bevel_filter_get_strength)
void
swfdec_bevel_filter_get_strength (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.strength (get)");
}

SWFDEC_AS_NATIVE (1107, 16, swfdec_bevel_filter_set_strength)
void
swfdec_bevel_filter_set_strength (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.strength (set)");
}

SWFDEC_AS_NATIVE (1107, 17, swfdec_bevel_filter_get_knockout)
void
swfdec_bevel_filter_get_knockout (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.knockout (get)");
}

SWFDEC_AS_NATIVE (1107, 18, swfdec_bevel_filter_set_knockout)
void
swfdec_bevel_filter_set_knockout (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.knockout (set)");
}

SWFDEC_AS_NATIVE (1107, 19, swfdec_bevel_filter_get_blurX)
void
swfdec_bevel_filter_get_blurX (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.blurX (get)");
}

SWFDEC_AS_NATIVE (1107, 20, swfdec_bevel_filter_set_blurX)
void
swfdec_bevel_filter_set_blurX (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.blurX (set)");
}

SWFDEC_AS_NATIVE (1107, 21, swfdec_bevel_filter_get_blurY)
void
swfdec_bevel_filter_get_blurY (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.blurY (get)");
}

SWFDEC_AS_NATIVE (1107, 22, swfdec_bevel_filter_set_blurY)
void
swfdec_bevel_filter_set_blurY (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.blurY (set)");
}

SWFDEC_AS_NATIVE (1107, 23, swfdec_bevel_filter_get_type)
void
swfdec_bevel_filter_get_type (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.type (get)");
}

SWFDEC_AS_NATIVE (1107, 24, swfdec_bevel_filter_set_type)
void
swfdec_bevel_filter_set_type (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter.type (set)");
}

// constructor
SWFDEC_AS_NATIVE (1107, 0, swfdec_bevel_filter_construct)
void
swfdec_bevel_filter_construct (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("BevelFilter");
}
